#! /usr/bin/env python

import ConfigParser
import shutil
import datetime
import io
import os
import subprocess
import argparse
from termcolor import colored, cprint

def create_patch(dir, prefix):
    global gitlog
    cmd='git log -1 --pretty="%h %ad %f" --date=format:%y%m%d'
    fname = prefix+'-'+os.popen(cmd).readlines()[0].replace(' ', '-').strip()[0:40]

    cmd = "git log -2 --pretty=format:%h"
    hash = os.popen(cmd).readlines()
    ori_git = hash[1].strip('\n')
    mod_git = hash[0].strip('\n')

    # create tree
    ori_dir = "ori_%s" % (ori_git)
    mod_dir = "mod_%s" % (mod_git)

    for file in gitlog[1:]:
        file = file.strip()
        ori_file = "%s/%s/%s" % (dir, ori_dir, file)
        mod_file = "%s/%s/%s" % (dir, mod_dir, file)
        if not os.path.exists(os.path.dirname(mod_file)):
            os.makedirs(os.path.dirname(mod_file))
            os.makedirs(os.path.dirname(ori_file))

        cmd = "git show %s:%s" % (ori_git, file)
        rin, rout= os.popen4(cmd)
        o=rout.read()
        if not o[0:5]=="fatal":
            f = open(ori_file, 'w')
            f.write(o)
            f.close()

        rin.close()
        rout.close()

        if os.path.exists(file):
            if os.path.islink(file):
                os.symlink(os.readlink(file), mod_file)
            else:
               shutil.copyfile(file, mod_file)

    #git log --grep=9310 --summary 9df9591665d6..HEAD
    log_fname = "ChangeLog_%s_%s" % (ori_git, mod_git)
    exec_sys_cmd("git log -1 > %s/%s" % (dir, log_fname))

    owd = os.getcwd()
    os.chdir(dir)
    exec_sys_cmd("tar -jcf %s.tar.bz2 %s %s %s" % (fname, ori_dir, mod_dir, log_fname))
    os.chdir(owd)

class Build_Info(object):
    def __init__(self, plr, ub, ub_type, tk):
        self.plr = plr
        self.ub = ub
        self.ub_type = ub_type
        self.tk = tk
        self.log = ''
        self.err = 0
        self.elog = ''

class Color_Info(object):
    def __init__(self, word, color, attr):
        self.word = word
        self.color = color
        self.attr = attr

def env_var_get(name):
    try:
        return os.environ[name]
    except:
        pass

def env_var_set(name, value):
    os.environ[name] = value

def cfg_opt_try_and_set(cfg, sec, opt, name):
    try:
        cfg.get(sec, opt)
    except ConfigParser.NoOptionError:
        cfg.set(sec, opt, name)

def cfg_opt_copy(cfg, section1, section2):
    for options in cfg.options(section1):
        if options in ('active', 'plr', 'uboot'):
            continue
        cfg_opt_try_and_set(cfg, section2, options, cfg.get(section1, options))

def cfg_opt_fill_default(cfg, section):
    cfg_opt_try_and_set(cfg, section, 'plr', section)
    cfg_opt_try_and_set(cfg, section, 'uboot', section)
    cfg_opt_try_and_set(cfg, section, 'active', 'yes')
    cfg_opt_try_and_set(cfg, section, 'uboot_type', 'legacy')

def gen_dummy_char(num, c):
    str = ""
    for i in range(0, num):
        str = str + c
    return str

def gen_dummy_space(num):
    return gen_dummy_char(num, ' ')

def build_list_append(blist, otto_plr_cfg, ub_ven_cfg, ub_type, tk_path):
    for b in blist:
        if otto_plr_cfg==b.plr and b.tk==tk_path:
            return
    blist.append(Build_Info(otto_plr_cfg, ub_ven_cfg, ub_type, tk_path))

def prj_name_list_unique_append(list, element):
    #process prefix
    e = element.split('_')[0].lower().replace('rtl', '')
    if e not in list:
        list.append(e)

def prj_name_list_check(list, element):
    if element not in list:
        return False
    else:
        return True

def exec_sys_cmd(cmd):
    print cmd
    os.system(cmd)

def exec_build_cmd(b, cmd):
    global trial_build
    note = subprocess.check_output('pwd').strip('\n') + '$'
    for n in cmd:
        note += ' ' + n
    b.log += colored(note, 'magenta')+'\n'
    print colored(note, 'magenta')
    try:
        if trial_build is False:
            b.log += subprocess.check_output(cmd, stderr=subprocess.STDOUT)
    except subprocess.CalledProcessError as e:
        b.log += e.output
        b.err = 1
        for l in io.BytesIO(e.output).readlines()[-11:-1]:
            b.elog += l.strip('\n')
    return b

def word_color(clist, log):
    _log = str(log)
    for c in clist:
        if None != c.attr:
            _log = _log.replace(c.word, colored(c.word, c.color, attrs=[c.attr]))
        else:
            _log = _log.replace(c.word, colored(c.word, c.color))
    return _log

def color_list_append(list, word, color, attr):
    for c in list:
        if word==c.word:
            return
    list.append(Color_Info(word, color, attr))

def color_list_init(list):
    #define color word
    color_list_append(list, 'error:',     'red',      'reverse')
    color_list_append(list, 'error:',     'yellow',   'reverse')
    color_list_append(list, 'Error',      'red',      'reverse')
    color_list_append(list, 'warning:',   'yellow',   'reverse')
    color_list_append(list, 'Warning',    'yellow',   'reverse')
    color_list_append(list, '[MAKE]',     'magenta',  None)
    color_list_append(list, '[CC]',       'magenta',  None)
    color_list_append(list, '[OBJCPY]',   'magenta',  None)
    color_list_append(list, '[OBJDUMP]',  'magenta',  None)
    color_list_append(list, '[LD]',       'magenta',  None)
    color_list_append(list, '[PACK]',     'magenta',  None)
    color_list_append(list, '[STRIP]',    'magenta',  None)
    color_list_append(list, '[OTTO]',     'magenta',  None)
    color_list_append(list, 'FAIL',       'red',      None)
    color_list_append(list, 'PASS',       'green',    None)

def code_base_sync():
    global branch
    #repo download $GERRIT_PROJECT $GERRIT_CHANGE_NUMBER/$GERRIT_PATCHSET_NUMBER
    prj = env_var_get("GERRIT_PROJECT")
    change_num = env_var_get("GERRIT_CHANGE_NUMBER")
    patchset_num = env_var_get("GERRIT_PATCHSET_NUMBER")
    commit_branch = env_var_get("GERRIT_BRANCH")
    print "Gerrit Info: PRJ(\"%s\") CHN(\"%s\") PSN(\"%s\") BRH(\"%s\")" % (prj, change_num, patchset_num, commit_branch)

    if None != prj:
        # check branch
        if commit_branch is not None and branch != commit_branch:
            exec_sys_cmd('repo init -m %s.xml ' % (commit_branch if commit_branch != 'master' else 'default'))
            exec_sys_cmd('repo sync -d -c -q')
        # repo download
        exec_sys_cmd('repo download %s %s/%s' % (prj, change_num, patchset_num))
    branch = commit_branch

def main(args):
    _args = args.parse_args()
    global gitlog
    global trial_build
    global branch

    branch = os.popen("repo info | grep \"Current\"").readlines()[0].split(':')[1].strip()
    trial_build = _args.trial_build

    code_base_sync()

    otto_plr_list = map(str.strip, os.popen('ls project').readlines())
    ub_ven_list = map(str.strip, os.popen('ls uboot/vendors').readlines())
    ub_todaro_list = map(str.strip, os.popen('ls uboot_todaro/board/realtek').readlines())
    build_list = []
    md_list = []
    color_list = []

    # load config
    with open("./util/buildtest/config.ini") as f:
        sample_config = f.read()

    config = ConfigParser.RawConfigParser(allow_no_value=True)
    config.readfp(io.BytesIO(sample_config))
    cfg_sections = config.sections()

    build_err = 0
    max_plr_len=0
    max_ubt_len=0

    # init list
    color_list_init(color_list)

    # parsing config.init
    for section in cfg_sections:
        # check config_copy
        try:
            seed=config.get(section, 'config_copy')
        except ConfigParser.NoOptionError:
            pass
        else:
            cfg_opt_copy(config, seed, section)
            config.remove_option(section, 'config_copy')
        cfg_opt_fill_default(config, section)
        plr_len = len(config.get(section, 'plr'))
        ubt_len = len(config.get(section, 'uboot'))
        max_plr_len = plr_len if  plr_len > max_plr_len else max_plr_len
        max_ubt_len = ubt_len if  ubt_len > max_ubt_len else max_ubt_len

    # process git log
    gitlog=os.popen('git log --name-only --oneline -1').readlines()
    for line in gitlog[1:]:
        # get file list
        flist = line.strip('\n')
        # dismember the path, check further more
        dism = flist.split('/')

        if len(dism)>2:
            if dism[0] == 'src':
                if dism[1] == 'soc':
                    prj_name_list_unique_append(md_list, 'all')
                elif dism[1] == 'platform':
                    prj_name_list_unique_append(md_list, dism[2])
                elif dism[1] == 'template':
                    prj_name_list_unique_append(md_list, dism[2])
            elif dism[0] == 'project':
                prj_name_list_unique_append(md_list, dism[1])
            elif dism[0] == 'ext':
                prj_name_list_unique_append(md_list, dism[1])
            elif dism[0] == 'uboot':
                if dism[1] == 'vendors':
                    prj_name_list_unique_append(md_list, dism[2])
                elif dism[1] == 'arch' and dism[2] == 'otto' and dism[3] == 'cpu':
                    prj_name_list_unique_append(md_list, dism[5])
                elif dism[1] == 'board' and dism[2] == 'Realtek':
                    prj_name_list_unique_append(md_list, dism[3])
                else:
                    prj_name_list_unique_append(md_list, 'all')
            elif (dism[0] == 'util') and (dism[1] == 'vcs_kit'):
                prj_name_list_unique_append(md_list, 'ignore')

    if not md_list:
        prj_name_list_unique_append(md_list, 'all')

    for section in cfg_sections:
        if("yes"==config.get(section, 'active')):
            otto_plr_cfg = config.get(section, 'plr')
            ub_ven_cfg = config.get(section, 'uboot')
            if True == prj_name_list_check(otto_plr_list, otto_plr_cfg) and True == prj_name_list_check(ub_ven_list, ub_ven_cfg):
                ub_type = "T" if config.get(section, 'uboot_type')=="todaro" else "U"
                tk_path_ary = config.get(section, 'tk_path').translate(None, '\n[]" ').split(',')

                for tk_path in tk_path_ary:
                    if 'all' not in md_list and otto_plr_cfg.split('_')[0].lower() not in md_list:
                        pass
                    else:
                        build_list_append(build_list, otto_plr_cfg, ub_ven_cfg, ub_type, tk_path)
                    color_list_append(color_list, tk_path+'gcc',    'magenta',  None)
                    color_list_append(color_list, tk_path+'ld',     'magenta',  None)
                    color_list_append(color_list, tk_path+'objdump','magenta',  None)
                    color_list_append(color_list, tk_path+'objcopy','magenta',  None)

                    score_board = "[ Score Board ]\n"

    if _args.branch is not None and branch not in _args.branch:
        _args.img_snapshot = False
        _args.patch_gen = None

    # create output dir
    out_dir = ""
    if _args.img_snapshot is True or _args.patch_gen is not None:
        out_dir = "%s_%s" % ("build", datetime.datetime.now().strftime('%y%m%d%H%M'))
        if _args.dir is not None:
            out_dir = _args.dir.rstrip('/') + '/' + out_dir
        if os.path.exists(out_dir):
            shutil.rmtree(out_dir)
        os.makedirs(out_dir)

    for build in build_list:
        build.err=0
        # check toolkit
        if(True==os.path.isfile(build.tk+'gcc')):
            env_var_set('CROSS_COMPILE', build.tk)

            if(0==build.err):
                build = exec_build_cmd(build, ['make', 'distclean'])

            os.chdir('uboot')
            if(0==build.err):
                build = exec_build_cmd(build, ['make', 'distclean'])

            os.chdir('..')
            if(0==build.err):
                build = exec_build_cmd(build, ['make', 'preconfig_'+build.plr])

            os.chdir('uboot')
            if(0 == build.err):
                build = exec_build_cmd(build, ['make', 'preconfig_'+build.ub])

            if(0 == build.err):
                build = exec_build_cmd(build, ['make', 'all'])
            os.chdir('..')
            if(0 == build.err):
                build = exec_build_cmd(build, ['make', 'all'])
            if 0 == build.err and _args.img_snapshot :
                _dir = out_dir+'/snapshot/'+build.plr+'-'+build.tk.split('/')[3][0:10]
                os.makedirs(_dir)
                exec_sys_cmd("cp release/*.img "+_dir)
        else:
            build.err=1
            build.log = build.elog = 'missing toolkit\n'

        # process log
        build.log = word_color(color_list, build.log)
        score_board += build.plr+gen_dummy_space(max_plr_len-len(build.plr))+' : '
        score_board += "PASS" if(0 == build.err) else "FAIL"
        score_board += " (" + build.tk + ")\n"
        score_board += build.elog

        build_err = build_err or build.err

    # show detail log
    for build in build_list:
        info = '%s (%s)' % (build.plr, build.tk)
        cprint(gen_dummy_char(len(info), '='), 'blue')
        cprint(info, 'blue')
        cprint(gen_dummy_char(len(info), '='), 'blue')
        print build.log

    print word_color(color_list, score_board)

    #gen patch
    if build_err!=1 and _args.patch_gen is not None:
        #prefix = _args.patch_gen[1] if(len(_args.patch_gen)>1) else None
        create_patch(out_dir+'/patch', _args.patch_gen)
    exit(int(build_err))

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    # need action append for more branch?
    parser.add_argument('-b', '--branch', metavar='BRANCH', nargs='*',\
                        help='enable patch gen or image snapshot for specific BRANCH')
    parser.add_argument('-d', '--dir', help='directory of image snapshot or patch file')
    parser.add_argument('-i', '--img_snapshot', action='store_true',\
                        help='enable image snapshot')
    parser.add_argument('-p', '--patch_gen', metavar='PREFIX', const='git', nargs='?', \
                        help='generate patch file with PREFIX ')
    parser.add_argument('-t', '--trial_build', action='store_true',\
                        help='trial build')

    main(parser)
