/* vi: set sw=4 ts=4: */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
//#include "pppd.h"
#include <limits.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include "eloop.h"

//paul test
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/ethernet.h>
#include <net/if.h>
#include <netinet/in.h>
#include <fcntl.h>
//paul --
#ifdef MUSL_LIBC
#include <time.h>
#endif

typedef unsigned char	bool;

enum opt_type
{
	o_special_noarg = 0,
	o_special = 1,
	o_bool,
	o_int,
	o_uint32,
	o_string,
	o_wild
};

typedef struct
{
	char *			name;		/* name of the option */
	enum opt_type	type;
	void *			addr;
	char *			description;
	unsigned int	flags;
	void *			addr2;
	int				upper_limit;
	int				lower_limit;
	const char *	source;
	short int		priority;
	short int		winner;
} option_t;

#define MAX_ENDP_LEN	20
struct epdisc
{
	unsigned char	class;
	unsigned char	length;
	unsigned char	value[MAX_ENDP_LEN];
};

struct channel
{
	option_t *options;
	void (*process_extra_options)(void);
	void (*check_options)(void);
	int  (*connect)(void);
	void (*disconnect)(void);
	int  (*establish_ppp)(int);
	void (*disestablish_ppp)(int);
	void (*send_config)(int, u_int32_t, int, int);
	void (*recv_config)(int, u_int32_t, int, int);
	void (*cleanup)(void);
	void (*close)(void);
	void (*sigterm)(int);
};

#define MAXNAMELEN      256
#define OPT_INITONLY	0x04000000 
#define OPT_DEVEQUIV	0x08000000
#define OPT_DEVNAM		(OPT_INITONLY | OPT_DEVEQUIV)
#define OPT_PRIVFIX		0x02000000
#define OPT_NOARG		0x00000200
#define OPT_A2STRVAL	0x20000000
#define OPT_STATIC		0x00002000

//#include "fsm.h"
//#include "lcp.h"
//#include "ipcp.h"
//#include "ccp.h"

#include <linux/types.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/ethernet.h>
#include <net/if.h>
#include <netinet/in.h>
//#include <ppp_defs.h>
//#include "if_ppp.h"
#include "if_pppox.h"

#include <syslog.h>
#include <asyslog.h>
#include <elbox_config.h>
#include <dtrace.h>

#include "pppoe.h"

#include "kpppoe.h"

//paul+++++
#include <sys/stat.h>
#include <fcntl.h>
int recv_PADT;
int unuse_sid = 0; //add for receive un-using session, v2
//paul-----

char	gm_linkname[NAME_MAX];
//extern char linkname[];

//extern char kpppoe_dev[];
//extern char kpppoe_ac_name[];
//extern char kpppoe_srv_name[];
//extern int kpppoe_hostuniq;

unsigned int gm_sts_mtu;
char	gm_ifname[32];

extern void kpppoe_discovery(PPPoEConnection * conn);
void kpppoe_sendPADT(PPPoEConnection * conn, const char * msg);

//struct channel kpppoe_channel;
//static PPPoEConnection poeconn;
static int PPPoEDevnameHook(char *cmd, char **argv, int doit);
static PPPoEConnection *conn = NULL;

/*paul, add for write session ID and destination MAC address if connection successfully., v2*/
static void WriteDataToFlash(PPPoEConnection * conn);
static void ClearDataToFlash(void);
int PPPoE_Discon_Flag;
/*paul, add end -----*/
/*paul add to send PADT, v2*/
static void check_auth(void *, void *);
static void check_sendPADT(void *, void *);
static int PPPoeStatus(void);
/*paul add end -----, v2*/

/*
 * this variable is not refered in pppd
 */
int	ppp_session_number;

/* Ethernet I/F name (example : nas10_0) */
char	devnam[NAME_MAX];

/* Ethernet I/F name (example : nas10_0) */
char	gm_ppp_devnam[NAME_MAX];

/*
 * MUST return these parameters to pppd
 */
char	gm_remote_number[NAME_MAX];

/*paul add system call, v2*/
static void gpio_system(char *cmd)
{
	FILE *gpio;

	if((gpio = popen(cmd,"r"))==NULL)
		printf("popen() error!\n");
	pclose(gpio);
}
/*paul add end---, v2*/

/*paul, write NAK Flag when change flag status, v2*/
static void write_NAK_flag(int value)
{
	FILE * pFile;
	pFile = fopen ("/etc/ppp/AuthNak_flag.txt","w");
	if ( pFile != NULL )
	{
		fprintf(pFile, "%d\n",value);
		(void)fclose(pFile);
	}
	else
		printf("+++++pFile == NULL\n");
}
/*paul add for PADT receiving PADT flag*/
static void write_PADT_fg(int value)
{
	FILE * pFile;
	pFile = fopen ("/etc/ppp/receive_PADT.txt","w");
	if ( pFile != NULL )
	{
		fprintf(pFile, "%d\n",value);
		(void)fclose(pFile);
	}
	else
		printf("+++++pFile == NULL\n");
}
/*paul add end -----, v2*/

//paul add for pppd v2
static long int check_systime()
{
	time_t t = time(NULL);
	struct tm tm = *localtime(&t);
	long int time_sec;

	time_sec = (tm.tm_sec + (60*tm.tm_min) + (60*60*tm.tm_hour));// second:Minute:Hour(Transfer to seconds)
	return time_sec;
}
//paul add end-----

/*Create a presend PADT packet*/
void PREsendPADT(PPPoEConnection *conn)
{
    PPPoEPacket packet;
	UINT16_t plen = 0;

	memcpy(packet.ethHdr.h_dest, discn.remote, ETH_ALEN);
	memcpy(packet.ethHdr.h_source, conn->myEth, ETH_ALEN);

	packet.ethHdr.h_proto = htons(Eth_PPPOE_Discovery);
	packet.ver = 1;
	packet.type = 1;
	packet.code = CODE_PADT;
	packet.session = discn.sessionID;

	packet.length = htons(plen);

	sendPacket(conn, conn->discoverySocket, &packet, (int) (plen + HDR_SIZE));

	/*paul, clear PPPoE information after send pre-PADT*/
	PPPoE_Discon_Flag = 0;
	ClearDataToFlash();
	/*paul add end-----*/
}
//paul----

/*paul, check PPPoE connection status, v2*/
static int PPPoeStatus()
{
	FILE *readStatus;
	char string[15];

	readStatus = fopen("/var/run/ppp-WAN-1.status","r");
	if (readStatus != NULL)
	{
		fgets(string,15,readStatus);
		fclose(readStatus);
		if (strncmp(string, "connected", 9) == 0)
			return 1;
		else //without "connected" status
			return 0;
	}
	else
		return 0;
}
/*paul add end-----, v2*/

/*paul add, eloop: discovery_read for PADT*/
static void discovery_read(int sock, void * eloop_ctx, void * sock_ctx)
{
	static PPPoEPacket packet;
	PPPoEConnection * conn = (PPPoEConnection *)sock_ctx;
	int len;
	UINT16_t temp;
		
	if (receivePacket(sock, &packet, &len) < 0) return;
	
	/* Check length */
	if (ntohs(packet.length) + HDR_SIZE > len)
	{
		d_error("[%d]: Bogus PPPoE length field (%u)\n", getpid(), (unsigned int)ntohs(packet.length));
		return;
	}
	
	/* Not PADT, ignore it */
	if (packet.code != CODE_PADT) return;
	
	/* Active on connected ststus */
	if (!PPPoeStatus()) return;
	
	/* It's a PADT, all right. Is it for us ? */
	if (memcmp(packet.ethHdr.h_dest, conn->myEth, ETH_ALEN)) return;
	if (memcmp(packet.ethHdr.h_source, conn->peerEth, ETH_ALEN)) return;

	/* check session ID*/
	if (packet.session != conn->session)
	{
		unuse_sid = 1;
		temp = conn->session;
		conn->session = packet.session;
		kpppoe_sendPADT(conn, "Received PADT with un-using session ID from peer");
		conn->session = temp;
		return;
	}

	d_info("pppoe: Session %d terminated -- received PADT from peer!\n", (int)ntohs(packet.session));
	recv_PADT = 1;
	discn.PPPoE_Discon_Flag = 0; //prevent to clear previou session again.
	kpppoe_sendPADT(conn, "Received PADT from peer");
	write_PADT_fg(1);
	eloop_terminate();
	return;
}
/*paul add end-----, v2*/

/*paul add for check auth status, v2*/
void check_auth_timer()
{
	TIMEOUT(check_auth, NULL, check_auth_interval);
}

static void check_auth(void * eloop_ctx, void * timeout_ctx)
{
	FILE * rFile;
	FILE * wFile;
	int status;
	
	if (PPPoeStatus())
		{
			UNTIMEOUT(check_auth, NULL);
			rFile = fopen ("/etc/ppp/Auth_failed.txt","r");
			if (rFile != NULL)
				remove("/etc/ppp/Auth_failed.txt");
			//wFile = fopen ("/etc/ppp/Auth_failed.txt","w");
			//fprintf(wFile, "0\n");
			//(void)fclose(wFile);
		}
	if (!PPPoeStatus())
	{
		rFile = fopen ("/etc/ppp/Auth_failed.txt","r");
		if ( rFile == NULL ) check_auth_timer();
		else
		{
			fscanf(rFile, "%d",&status);
			(void)fclose(rFile);
			if (status == 1)
			{
				UNTIMEOUT(check_auth, NULL);
				eloop_terminate();
				PPPOEDisconnectDevice();
				wFile = fopen ("/etc/ppp/Auth_failed.txt","w");
				fprintf(wFile, "0\n");
				(void)fclose(wFile);
			}
			else
				check_auth_timer();
		}
	}
}
/*paul add end -----, v2*/

/*paul add for PADT sending when reboot/LCP Echo Request failed, v2*/
void check_needPADT_timer()
{
	TIMEOUT(check_sendPADT, NULL, check_sendPADT_interval);
}

static void check_sendPADT(void * eloop_ctx, void * timeout_ctx)
{
	FILE * rFile;
	int status;
	
	rFile = fopen ("/etc/ppp/NeedSendPADT.txt","r");
	if ( rFile == NULL )
		check_needPADT_timer();
	else
	{
		fscanf(rFile, "%d",&status);
		(void)fclose(rFile);
		if(status == 1)
		{
			eloop_terminate();
			PPPOEDisconnectDevice();
			remove("/etc/ppp/NeedSendPADT.txt");

		}
		else
			check_needPADT_timer();
	}
}
/*paul add end -----, v2*/

//static int PPPOEConnectDevice(void)
int PPPOEConnectDevice(void)
{
	struct sockaddr_pppox sp;
	int e; //paul
	d_dbg("[%d]: PPPOEConnectDevice() >>>\n", getpid());
/*
	conn->acName = kpppoe_ac_name[0] ? kpppoe_ac_name : NULL;
	conn->serviceName = kpppoe_srv_name[0] ? kpppoe_srv_name : NULL;
	conn->ifName = kpppoe_dev;
	conn->discoverySocket = -1;
	conn->sessionSocket = -1;
	conn->useHostUniq = kpppoe_hostuniq;
	
	strlcpy(ppp_devnam, kpppoe_dev, 32);
*/
	strncpy(gm_ppp_devnam, devnam, sizeof(gm_ppp_devnam));
	kpppoe_discovery(conn);
	if (conn->discoveryState != STATE_SESSION)
	{
		d_error("[%d]: Unable to complete PPPoE Discovery!\n", getpid());
		return -1;
	}

	/*paul add a stage for receive PADT from peer*/
	eloop_init(conn); //paul add
	e = eloop_register_read_sock(conn->discoverySocket, discovery_read, NULL, conn);
	/*paul add end-----*/

	/* Set PPPoE session-number for further consumption */
	ppp_session_number = ntohs(conn->session);

	/* Make the session socket */
	conn->sessionSocket = socket(AF_PPPOX, SOCK_STREAM, PX_PROTO_OE);
	if (conn->sessionSocket < 0)
	{	
		d_error("[%d]: Failed to create PPPoE socket\n", getpid());
		return -1;
	}
	sp.sa_family = AF_PPPOX;
	sp.sa_protocol = PX_PROTO_OE;
	sp.sa_addr.pppoe.sid = conn->session;
	memcpy(sp.sa_addr.pppoe.dev, conn->ifName, IFNAMSIZ);
	memcpy(sp.sa_addr.pppoe.remote, conn->peerEth, ETH_ALEN);

	/* Set remote_number for ServPoET */
	sprintf(gm_remote_number, "%02X:%02X:%02X:%02X:%02X:%02X",
			(unsigned) conn->peerEth[0],
			(unsigned) conn->peerEth[1],
			(unsigned) conn->peerEth[2],
			(unsigned) conn->peerEth[3],
			(unsigned) conn->peerEth[4],
			(unsigned) conn->peerEth[5]);

	/*paul, when got session ID from PPPoE server, write session ID and server MAC firstly., v2*/
	PPPoE_Discon_Flag = 0;
	WriteDataToFlash(conn);
	/*paul add end-----, v2*/

	if (connect(conn->sessionSocket, (struct sockaddr *)&sp,
				sizeof(struct sockaddr_pppox)) < 0)
	{
		d_error("[%d]: Failed to connect PPPoE socket: %d\n", getpid(), errno);
		return -1;
	}
	
	/*paul add for check auth status timer and reboot /keepalive failed behaviors*/
	check_auth_timer();
	check_needPADT_timer();
	/*paul add end -----, v2*/

	return conn->sessionSocket;
}

//static void PPPOEDisconnectDevice(void)
void PPPOEDisconnectDevice(void)
{
	struct sockaddr_pppox sp;
	kpppoe_sendPADT(conn, "User Request");
	
	sp.sa_family = AF_PPPOX;
	sp.sa_protocol = PX_PROTO_OE;
	sp.sa_addr.pppoe.sid = 0;
	memcpy(sp.sa_addr.pppoe.dev, conn->ifName, IFNAMSIZ);
	memcpy(sp.sa_addr.pppoe.remote, conn->peerEth, ETH_ALEN);
	if (connect(conn->sessionSocket, (struct sockaddr *)&sp, sizeof(struct sockaddr_pppox)) < 0)
	{
		d_error("[%d]: Failed to discconect PPPoE socket: %d\n", getpid(), errno);
	}
	close(conn->sessionSocket);
}

//extern unsigned int sts_mtu;

//static void PPPOESendConfig(int mtu, u_int32_t asyncmap, int pcomp, int accomp)
void PPPOESendConfig(int mtu)
{
	int sock;
	struct ifreq ifr;

	if (mtu > MAX_PPPOE_MTU)
	{
		d_warn("[%d]: Couldn't increase MTU to %d\n", getpid(), mtu);
		mtu = MAX_PPPOE_MTU;
	}
	sock = socket(AF_INET, SOCK_DGRAM, 0);
	if (sock < 0)
	{
		d_error("[%d]: Couldn't create IP socket\n", getpid());
		return;
	}
	strlcpy(ifr.ifr_name, gm_ifname, sizeof(ifr.ifr_name));
	ifr.ifr_mtu = mtu;
	if (ioctl(sock, SIOCSIFMTU, &ifr) < 0)
	{
		d_error("[%d]: Couldn't set interface MTU to %d\n", getpid(), mtu);
	}
	(void) close(sock);

	gm_sts_mtu = mtu;
}

//static void PPPOERecvConfig(int mru, u_int32_t asyncmap, int pcomp, int accomp)
void PPPOERecvConfig(int mru)
{
	if (mru > MAX_PPPOE_MTU)
		d_warn("[%d]: Couldn't increase MRU to %d\n", getpid(), mru);
}

int PPPOEInitDevice(void)
{
/*
	the_channel = &kpppoe_channel;
	modem = 0;

	lcp_allowoptions[0].neg_accompression = 0;
	lcp_wantoptions[0].neg_accompression = 0;

	lcp_allowoptions[0].neg_asyncmap = 0;
	lcp_wantoptions[0].neg_asyncmap = 0;

	lcp_allowoptions[0].neg_pcompression = 0;
	lcp_wantoptions[0].neg_pcompression = 0;

	ccp_allowoptions[0].deflate = 0;
	ccp_wantoptions[0].deflate = 0;

	ipcp_allowoptions[0].neg_vj = 0;
	ipcp_wantoptions[0].neg_vj = 0;

	ccp_allowoptions[0].bsd_compress = 0;
	ccp_wantoptions[0].bsd_compress = 0;
*/
//	conn = &poeconn;
	conn = malloc(sizeof(PPPoEConnection));
	if (!conn) {
		d_error("PPPoE session data\n");
	}
	memset(conn, 0, sizeof(PPPoEConnection));
/*
	conn->acName = kpppoe_ac_name[0] ? kpppoe_ac_name : NULL;
	conn->serviceName = kpppoe_srv_name[0] ? kpppoe_srv_name : NULL;
	conn->ifName = kpppoe_dev;
*/
	conn->acName = NULL;
	conn->serviceName = NULL;
	conn->ifName = devnam;
	conn->discoverySocket = -1;
	conn->sessionSocket = -1;
	conn->useHostUniq = 0;
	return 1;
}

void kpppoe_sendPADT(PPPoEConnection * conn, const char * msg)
{
	PPPoEPacket packet;
	unsigned char *cursor = packet.payload;
	UINT16_t plen = 0;

	/* Do nothing if no session established yet */
	if (!conn->session) return;

	/* Do nothing if no discovery socket */
	if (conn->discoverySocket < 0) return;

	memcpy(packet.ethHdr.h_dest, conn->peerEth, ETH_ALEN);
	memcpy(packet.ethHdr.h_source, conn->myEth, ETH_ALEN);

	packet.ethHdr.h_proto = htons(Eth_PPPOE_Discovery);
	packet.ver = 1;
	packet.type = 1;
	packet.code = CODE_PADT;
	packet.session = conn->session;

	/* Restart Session to zero so there is no possibility of
	 * recursuve calls to this function by any signal handler */
	conn->session = 0;

	/* If we're using Host-Uniq, copy it over. */
	if (conn->useHostUniq)
	{
		PPPoETag hostUniq;
		pid_t pid = getpid();
		hostUniq.type = htons(TAG_HOST_UNIQ);
		hostUniq.length = htons(sizeof(pid));
		memcpy(hostUniq.payload, &pid, sizeof(pid));
		memcpy(cursor, &hostUniq, sizeof(pid) + TAG_HDR_SIZE);
		cursor += sizeof(pid) + TAG_HDR_SIZE;
		plen += sizeof(pid) + TAG_HDR_SIZE;
	}

	/* Copy error message */
	if (msg)
	{
		PPPoETag err;
		size_t elen = strlen(msg);
		err.type = htons(TAG_GENERIC_ERROR);
		err.length = htons(elen);
		strcpy((char *)err.payload, msg);
		memcpy(cursor, &err, elen + TAG_HDR_SIZE);
		cursor += elen + TAG_HDR_SIZE;
		plen += elen + TAG_HDR_SIZE;
	}

	/* Copy cookie and relay-ID if needed */
	if (conn->cookie.type)
	{
		CHECK_ROOM(cursor, packet.payload,
					ntohs(conn->cookie.length) + TAG_HDR_SIZE);
		memcpy(cursor, &conn->cookie, ntohs(conn->cookie.length) + TAG_HDR_SIZE);
		cursor += ntohs(conn->cookie.length) + TAG_HDR_SIZE;
		plen += ntohs(conn->cookie.length) + TAG_HDR_SIZE;
	}

	if (conn->relayId.type)
	{
		CHECK_ROOM(cursor, packet.payload,
					ntohs(conn->relayId.length) + TAG_HDR_SIZE);
		memcpy(cursor, &conn->relayId, ntohs(conn->relayId.length) + TAG_HDR_SIZE);
		cursor += ntohs(conn->relayId.length) + TAG_HDR_SIZE;
		plen += ntohs(conn->relayId.length) + TAG_HDR_SIZE;
	}

#ifndef LOGNUM
#ifdef ELBOX_PROGS_GPL_SYSLOGD_AP	
	syslog(ALOG_NOTICE|LOG_NOTICE, "[Notice]PPPoE: Sending PADT for %s. (Session ID: %x)", gm_linkname, (int)ntohs(packet.session));
#else
	syslog(ALOG_NOTICE|LOG_NOTICE, "PPPoE: Sending PADT for %s. (Session ID: %x)", gm_linkname, (int)ntohs(packet.session));
#endif	
#else
	syslog(ALOG_NOTICE|LOG_NOTICE, "NTC:032[%s][%x]", gm_linkname, (int)ntohs(packet.session));
#endif
	packet.length = htons(plen);

  if (!unuse_sid) //paul add for receive using SID packets only, v2
  {
	/*paul, clear PPPoE information when send PADT, v2*/
	PPPoE_Discon_Flag = 0;
	ClearDataToFlash();
	/*paul add end-----, v2*/

	/*Paul add for any condition. The interval 20 seconds from send PADT to next PADI., v2*/
	write_NAK_flag(1);

	if (recv_PADT == 1) //delayed 20 second and then to reply PADT to peer when got PADT, v2
		{
			//Trigger LED by gpio command(re-auth)
			gpio_system("usockc /var/gpio_ctrl ACTIVE_GET_PPP_RESPOND_LED_OFF=pppd.alpha.v2");
			gpio_system("usockc /var/gpio_ctrl ACTIVE_RECONFIRMS_PPP_AUTH_LED_OFF=pppd.alpha.v2");
			gpio_system("usockc /var/gpio_ctrl ACTIVE_PPP_CONNECTED_LED_OFF=pppd.alpha.v2");
			sleep(20);
		}

	sendPacket(conn, conn->discoverySocket, &packet, (int)(plen + HDR_SIZE));
	recv_PADT = 0;

	/*paul add for record send PADT time and avoid to purge after re-init pppd */
	long int send_PADT_time = check_systime();
	FILE * pFile;
	pFile = fopen ("/etc/ppp/sendPADTtime.txt","w");
	fprintf(pFile, "%ld\n",send_PADT_time);
	fclose(pFile);
	/*paul add end-----*/
  }
  else
  	{
		sendPacket(conn, conn->discoverySocket, &packet, (int)(plen + HDR_SIZE));
		unuse_sid = 0;
	}
}

int kpppoe_parsePacket(PPPoEPacket * packet, ParseFunc * func, void * extra)
{
	UINT16_t len = ntohs(packet->length);
	unsigned char * curTag;
	UINT16_t tagType, tagLen;

	if (packet->ver != 1)
	{
		d_error("[%d]: Invalid PPPoE version (%d)\n", getpid(), (int)packet->ver);
		return -1;
	}
	if (packet->type != 1)
	{
		d_error("[%d]: Invalid PPPoE type (%d)\n", getpid(), (int)packet->type);
		return -1;
	}

	/* Do some sanity checks on packet */
	if (len > ETH_DATA_LEN - 6) /* 6-byte overhead for PPPoE header */
	{
		d_error("[%d]: Invalid PPPoE packet length (%u)\n", getpid(), len);
		return -1;
	}

	/* Step through the tags */
	curTag = packet->payload;
	while (curTag - packet->payload < len)
	{
		/* Alignment is not guaranteed, so do this by hand ... */
		tagType = (((UINT16_t)curTag[0]) << 8) + (UINT16_t)curTag[1];
		tagLen  = (((UINT16_t)curTag[2]) << 8) + (UINT16_t)curTag[3];
		if (tagType == TAG_END_OF_LIST) return 0;
		if ((curTag - packet->payload) + tagLen + TAG_HDR_SIZE > len)
		{
			d_error("[%d]: Invalid PPPoE tag length (%u)\n", getpid(), tagLen);
			return -1;
		}
		func(tagType, tagLen, curTag+TAG_HDR_SIZE, extra);
		curTag = curTag + TAG_HDR_SIZE + tagLen;
	}
	return 0;
}

/*paul, save Server MAC, Session Number and PPPoE_Discon_Flag status in the ROM, v2*/
/*change PPPoE informations*/
static void WriteDataToFlash(PPPoEConnection * conn)
{
	static char *o_nvramf = ELBOX_PROGS_GPL_PPPD_MISC_MTDBLOCK;
	FILE * nvram;

	if (!conn->session)
		printf("+++++d->sessionID == NULL\n");
	
	nvram = fopen(o_nvramf,"w");

	if (!nvram)
		printf("+++++WriteDataToFlash, open file failed\n");
	else
		{
			if (fseek(nvram,0,SEEK_SET)!=0)
				printf("+++++WriteDataToFlash, fseek error !!\n");
			/*write any information into ROM*/
			fprintf(nvram,"%d %x %02x:%02x:%02x:%02x:%02x:%02x\n",
			PPPoE_Discon_Flag,conn->session,
			conn->peerEth[0],
			conn->peerEth[1],
			conn->peerEth[2],
			conn->peerEth[3],
			conn->peerEth[4],
			conn->peerEth[5]);
		}
	fclose(nvram);
}

/*clean PPPoE informations and set the PPoE_Discon_Flag=0, v2*/
static void ClearDataToFlash()
{
	static char *o_nvramf = ELBOX_PROGS_GPL_PPPD_MISC_MTDBLOCK;
	FILE * nvram;
	char buffer[0];
	int i;
	
	nvram = fopen(o_nvramf,"w");

	if (!nvram)
		printf("+++++ClearDataToFlash, open file failed\n");
	else
		{
			if (fseek(nvram,0,SEEK_SET)!=0)
				printf("+++++ClearDataToFlash, fseek error !!\n");

				buffer[0]='\0'; //initial buffer
			for (i=0; i<DISCON_BUFSIZE; i++){
				fprintf(nvram,"%c\n",buffer[i]);
			}
			if (fseek(nvram,0,SEEK_SET)!=0)
				printf("+++++ClearDataToFlash, fseek error !!\n");
			fprintf(nvram,"%d",PPPoE_Discon_Flag); //filled the Flag = 0.
		}
	fclose(nvram);
}
/*paul add end-----, v2*/

/*
struct channel kpppoe_channel =
{
	options: NULL,
	process_extra_options: NULL,
	check_options: NULL,
	connect: &PPPOEConnectDevice,
	disconnect: &PPPOEDisconnectDevice,
	establish_ppp: &generic_establish_ppp,
	disestablish_ppp: &generic_disestablish_ppp,
	send_config: &PPPOESendConfig,
	recv_config: &PPPOERecvConfig,
	close: NULL,
	cleanup: NULL
};
*/
/**********************************************************************
 * %FUNCTION: PPPoEDevnameHook
 * %ARGUMENTS:
 * cmd -- the command (actually, the device name
 * argv -- argument vector
 * doit -- if non-zero, set device name.  Otherwise, just check if possible
 * %RETURNS:
 * 1 if we will handle this device; 0 otherwise.
 * %DESCRIPTION:
 * Checks if name is a valid interface name; if so, returns 1.  Also
 * sets up devnam (string representation of device).
 ***********************************************************************/
static int
PPPoEPrepareDevice( char*  arg_devname )
{
    int r = 1;
    int fd;
    struct ifreq ifr;

    /* Open a socket */
    if ((fd = socket(PF_PACKET, SOCK_RAW, 0)) < 0) {
	r = 0;
    }

    /* Try getting interface index */
    if (r) {
	strncpy(ifr.ifr_name, arg_devname, sizeof(ifr.ifr_name));
	if (ioctl(fd, SIOCGIFINDEX, &ifr) < 0) {
	    r = 0;
	} else {
	    if (ioctl(fd, SIOCGIFHWADDR, &ifr) < 0) {
		r = 0;
	    } else {
		if (ifr.ifr_hwaddr.sa_family != ARPHRD_ETHER) {
			d_error("Interface %s not Ethernet", arg_devname);
			r = 0;
		}
	    }
	}
    }

    /* Close socket */
    close(fd);
    if ( r ) {
	strncpy(devnam, arg_devname, sizeof(devnam));
	PPPOEInitDevice();

	return 1;
    }

    return r;
}

/**********************************************************************
 * %FUNCTION: plugin_init
 * %ARGUMENTS:
 * None
 * %RETURNS:
 * Nothing
 * %DESCRIPTION:
 * Initializes hooks for pppd plugin
 ***********************************************************************/
PPPoEConnection*  kpppoe_init( char*  arg_devname )
{
	int	res;
	res = PPPoEPrepareDevice( arg_devname );

	return (res == 1) ? conn : NULL;
}
