#ifndef __MTK_EFUSE_H__
#define __MTK_EFUSE_H__

#include <stdbool.h>
#include <lib/mmio.h>

/*********************************************************************************
 *
 *  Returned status of eFuse SMC
 *
 ********************************************************************************/
#define MTK_EFUSE_SUCCESS					0x00000000
#define MTK_EFUSE_ERROR_INVALIDE_PARAMTER			0x00000001
#define MTK_EFUSE_ERROR_INVALIDE_EFUSE_FIELD			0x00000002
#define MTK_EFUSE_ERROR_EFUSE_FIELD_DISABLED			0x00000003
#define MTK_EFUSE_ERROR_EFUSE_LEN_EXCEED_BUFFER_LEN		0x00000004
#define MTK_EFUSE_ERROR_READ_EFUSE_FIELD_FAIL			0x00000005
#define MTK_EFUSE_ERROR_WRITE_EFUSE_FIELD_FAIL			0x00000006

/* use to offset efuse r/w api error code */
#define MTK_EFUSE_ERROR_CODE_OFFSET				0x0000000A

/*********************************************************************************
 *
 *  eFuse info
 *
 ********************************************************************************/
enum MTK_EFUSE_FIELD {
	MTK_EFUSE_FIELD_F0 = 0,
	MTK_EFUSE_FIELD_F1,
	MTK_EFUSE_FIELD_F2,
	MTK_EFUSE_FIELD_F3,
	MTK_EFUSE_FIELD_F4,
	MTK_EFUSE_FIELD_F5,
	MTK_EFUSE_FIELD_F6,
	MTK_EFUSE_FIELD_F7,
	MTK_EFUSE_FIELD_F8,
	MTK_EFUSE_FIELD_F9,
	MTK_EFUSE_FIELD_F10,
	MTK_EFUSE_FIELD_F11,
	MTK_EFUSE_FIELD_F12,
	MTK_EFUSE_FIELD_F13,
	MTK_EFUSE_FIELD_F14,
	MTK_EFUSE_FIELD_F15,
	MTK_EFUSE_FIELD_F16,
	MTK_EFUSE_FIELD_F17,
	MTK_EFUSE_FIELD_F18,
	MTK_EFUSE_FIELD_F19,
	MTK_EFUSE_FIELD_F20,
	MTK_EFUSE_FIELD_F21,
	MTK_EFUSE_FIELD_F22,
	MTK_EFUSE_FIELD_F23,
	MTK_EFUSE_FIELD_F24,
	__MTK_EFUSE_FIELD_MAX,
};
#define MTK_EFUSE_FIELD_MAX (__MTK_EFUSE_FIELD_MAX)

struct mtk_efuse_field_t {
	uint32_t index;
	uint32_t len;
	bool enable;
};

enum MTK_EFUSE_PUBK_HASH_INDEX {
	MTK_EFUSE_PUBK_HASH_INDEX0 = 0,
	MTK_EFUSE_PUBK_HASH_INDEX1,
	MTK_EFUSE_PUBK_HASH_INDEX2,
	MTK_EFUSE_PUBK_HASH_INDEX3,
	MTK_EFUSE_PUBK_HASH_INDEX4,
	MTK_EFUSE_PUBK_HASH_INDEX5,
	MTK_EFUSE_PUBK_HASH_INDEX6,
	MTK_EFUSE_PUBK_HASH_INDEX7,
	__MTK_EFUSE_PUBK_HASH_INDEX_MAX,
};
#define MTK_EFUSE_PUBK_HASH_INDEX_MAX (__MTK_EFUSE_PUBK_HASH_INDEX_MAX)

#define MTK_EFUSE_PUBK_HASH_LEN			4
#define MTK_EFUSE_SMC_DATA_LEN_MAX		2 * MTK_EFUSE_PUBK_HASH_LEN
#define MTK_EFUSE_SMC_DATA_OFFSET_MAX \
		MTK_EFUSE_PUBK_HASH_INDEX6 * MTK_EFUSE_PUBK_HASH_LEN
#define MTK_EFUSE_MAX_HUID_LEN			U(16)

uint32_t mtk_efuse_get_len(uint32_t efuse_field,
			   uint32_t *efuse_len_ptr);

uint32_t mtk_efuse_send_data(uint8_t *buffer,
			     uint8_t *data,
			     uint32_t offset,
			     uint32_t len);

uint32_t mtk_efuse_get_data(uint8_t *data,
			    uint8_t *buffer,
			    uint32_t offset,
			    uint32_t len);

uint32_t mtk_efuse_read(uint32_t efuse_field,
			uint8_t *efuse_buffer,
			uint32_t efuse_buffer_len);

uint32_t mtk_efuse_write(uint32_t efuse_field,
			 uint8_t *efuse_buffer,
			 uint32_t efuse_buffer_len);

uint32_t mtk_efuse_disable(uint32_t efuse_field);

#endif /* __MTK_EFUSE_H__ */
