#include <stdio.h>
#include <string.h>
//#include "typedefs.h"
#include "dramc_dv_init.h"
//#define mcSHOW_DBG_MSG(x) {printf x;}
#define MAX2(X,Y) ((X>Y)?X:Y)
#define MIN2(X,Y) ((X<Y)?X:Y)
extern U32 A_div_B_RU (U32 A, U32 B);
extern U8 get_dq_ca_p2s_latency(U8 p2s_ratio, U8 frate, U8 fake_mode);
typedef struct TX_path_config 
{
  U8  cs2WL_start         ; //unit ca_ui
  U8  byte_num	          ;
  U8  rank_num	          ;
  U8  CKR                 ;
  U8  DBI_WR              ;
  U8  DRAMOBF_EN          ;
  U8  DRAMOBF_PIPE_NO     ;
  U8  dly_1T_by_FDIV2     ;
  U32 data_ratio          ;
  U32 WL[2]	          ;
  U32 TDQSS[2][2]         ;   //unit: ps
  U32 TDQS2DQ[2][2]       ;
  U32 TDQS2DQ_skew[2][2]  ;
  U8  ca_p2s_ratio        ;
  U8  ca_default_dly      ;
  U8  ca_default_pi       ;
  U8  ca_ser_latency      ;
  U8  dqs_ser_laterncy    ;
  U8  dqs_default_dly     ;
  U8  dqs_oe_default_dly  ;
  U8  dq_ser_laterncy     ;
  U8  dq_p2s_ratio        ;
  U8  ui2pi_ratio         ;
  U32 MCK_unit            ;
  U32 dq_ui_unit          ;
  U32 ca_unit             ;
  U32 ca_MCKIO_unit       ;
  U8  ca_frate            ;
  U8  TX_ECC              ;
  U8  TWPRE               ; //unit: dq ui
  U32 OE_pre_margin       ;
  U32 OE_pst_margin       ;
  U8  OE_downgrade        ;
  U8  aphy_slice_dly      ;
  U8  aphy_dtc_dly        ;
  U8  aphy_tx_dly         ;
  U8  DDRPHY_CLK_EN_COMB_TX_OPT ;
  U8  NEW_RANK_MODE       ;
  U8  close_loop_mode     ;
  U8  semi_open_loop_mode ;  
  U8  TXP_WORKAROUND_OPT  ;
  U8  XRTW2W_PI_mute_time ;
  U8  fake_mode           ;
  U8  dphy_tx_dly         ;
  U8  impact_latency_for_dramobf;
  U32 TX_DQ_Dline         ;
} TX_path_config_T;
typedef struct TX_path_attribution 
{
  U32 TX_DQ_MCK_OE[2][2]                  ;
  U32 TX_DQ_UI_OE[2][2]                   ;
  U32 TX_DQ_MCK[2][2]	                  ;
  U32 TX_DQ_UI[2][2]                      ;
  U32 TX_DQ_PI[2][2]                      ;
  U32 TX_DQ_UI_ORIG[2][2]                 ;
  U32 TX_DQ_PI_ORIG[2][2]                 ;
  U32 TX_DQ_UIPI_all[2][2]                ;
  U32 TX_DQ_dlyline[2][2]                 ;
  U32 TX_DQS_MCK[2][2]	                  ;
  U32 TX_DQS_MCK_OE[2][2]                 ;
  U32 TX_DQS_UI[2][2]                     ;
  U32 TX_DQS_UI_OE[2][2]                  ;
  U32 TX_DQS_PI[2][2]                     ;
  U8  DDRPHY_CLK_EN_COMB_TX_OPT           ;
  U8  DDRPHY_CLK_EN_COMB_TX_PICG_CNT      ;
  U8  DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0    ;
  U8  DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1    ;
  U8  DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P0 ;
  U8  DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P1 ;
  U8  DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P0 ;
  U8  DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P1 ;
  U8  DPHY_TX_DCM_EXTCNT                  ;
  U8  TX_PI_UPD_MODE                      ;
  U8  TX_PI_UPDCTL_B0                     ;
  U8  TX_PI_UPDCTL_B1                     ;
  U8  TX_RANKINCTL_ROOT                   ;
  U8  TX_RANKINCTL                        ;
  U8  TX_RANKINCTL_TXDLY                  ;
  U8  DDRPHY_CLK_DYN_GATING_SEL           ;
  U8  DDRPHY_CLK_EN_OPT                   ;
  U8  ARPI_CMD                            ;
  U8  TDMY                                ;
  U8  TXOEN_AUTOSET_DQ_OFFSET             ;
  U8  TXOEN_AUTOSET_DQS_OFFSET            ;
  U8  TXOEN_AUTOSET_EN	                  ;
  U8  TXPICG_AUTOSET_OPT	          ;  
  U8  TXPICG_AUTOSET_EN	                  ;
  U8  TXPICG_DQ_MCK_OFFSET_LAG            ;
  U8  TXPICG_DQS_MCK_OFFSET_LAG           ;
  U8  TXPICG_DQ_UI_OFFSET_LEAD            ;
  U8  TXPICG_DQ_UI_OFFSET_LAG             ;
  U8  TXPICG_DQS_UI_OFFSET_LEAD           ;
  U8  TXPICG_DQS_UI_OFFSET_LAG            ;
} TX_path_attribution_T;

void print_TX_path_config(TX_path_config_T *tr)
{
  mcSHOW_DBG_MSG ("=====================================\n"                          );
  mcSHOW_DBG_MSG ("print TX_path_config\n"                                           );
  mcSHOW_DBG_MSG ("=====================================\n"                          );
  mcSHOW_DBG_MSG ("data_ratio                is %d\n", tr->data_ratio                );
  mcSHOW_DBG_MSG ("dq_p2s_ratio              is %d\n", tr->dq_p2s_ratio              );
  mcSHOW_DBG_MSG ("cs2WL_start               is %d\n", tr->cs2WL_start               );
  mcSHOW_DBG_MSG ("byte_num                  is %d\n", tr->byte_num                  );
  mcSHOW_DBG_MSG ("rank_num                  is %d\n", tr->rank_num                  );
  mcSHOW_DBG_MSG ("CKR                       is %d\n", tr->CKR                       );
  mcSHOW_DBG_MSG ("DBI_WR                    is %d\n", tr->DBI_WR                    );
  mcSHOW_DBG_MSG ("DRAMOBF_EN                is %d\n", tr->DRAMOBF_EN                );
  mcSHOW_DBG_MSG ("DRAMOBF_PIPE_NO           is %d\n", tr->DRAMOBF_PIPE_NO           );
  mcSHOW_DBG_MSG ("dly_1T_by_FDIV2           is %d\n", tr->dly_1T_by_FDIV2           );
  mcSHOW_DBG_MSG ("WL[0]                     is %d\n", tr->WL[0]                     );
  mcSHOW_DBG_MSG ("WL[1]                     is %d\n", tr->WL[1]                     );
  mcSHOW_DBG_MSG ("TDQSS[0][0]               is %d\n", tr->TDQSS[0][0]               );
  mcSHOW_DBG_MSG ("TDQSS[0][1]               is %d\n", tr->TDQSS[0][1]               );
  mcSHOW_DBG_MSG ("TDQSS[1][0]               is %d\n", tr->TDQSS[1][0]               );
  mcSHOW_DBG_MSG ("TDQSS[1][1]               is %d\n", tr->TDQSS[1][1]               );
  mcSHOW_DBG_MSG ("TDQS2DQ[0][0]             is %d\n", tr->TDQS2DQ[0][0]             );
  mcSHOW_DBG_MSG ("TDQS2DQ[0][1]             is %d\n", tr->TDQS2DQ[0][1]             );
  mcSHOW_DBG_MSG ("TDQS2DQ[1][0]             is %d\n", tr->TDQS2DQ[1][0]             );
  mcSHOW_DBG_MSG ("TDQS2DQ[1][1]             is %d\n", tr->TDQS2DQ[1][1]             );
  mcSHOW_DBG_MSG ("TDQS2DQ_skew[0][0]        is %d\n", tr->TDQS2DQ_skew[0][0]        );
  mcSHOW_DBG_MSG ("TDQS2DQ_skew[0][1]        is %d\n", tr->TDQS2DQ_skew[0][1]        );
  mcSHOW_DBG_MSG ("TDQS2DQ_skew[1][0]        is %d\n", tr->TDQS2DQ_skew[1][0]        );
  mcSHOW_DBG_MSG ("TDQS2DQ_skew[1][1]        is %d\n", tr->TDQS2DQ_skew[1][1]        );
  mcSHOW_DBG_MSG ("ca_p2s_ratio              is %d\n", tr->ca_p2s_ratio              );
  mcSHOW_DBG_MSG ("ca_default_dly            is %d\n", tr->ca_default_dly            );
  mcSHOW_DBG_MSG ("ca_default_pi             is %d\n", tr->ca_default_pi             );
  mcSHOW_DBG_MSG ("ca_ser_latency            is %d\n", tr->ca_ser_latency            );
  mcSHOW_DBG_MSG ("dqs_ser_laterncy          is %d\n", tr->dqs_ser_laterncy          );
  mcSHOW_DBG_MSG ("dqs_default_dly           is %d\n", tr->dqs_default_dly           );
  mcSHOW_DBG_MSG ("dqs_oe_default_dly        is %d\n", tr->dqs_oe_default_dly        );
  mcSHOW_DBG_MSG ("dq_ser_laterncy           is %d\n", tr->dq_ser_laterncy           );
  mcSHOW_DBG_MSG ("MCK_unit                  is %d\n", tr->MCK_unit                  );
  mcSHOW_DBG_MSG ("dq_ui_unit                is %d\n", tr->dq_ui_unit                );
  mcSHOW_DBG_MSG ("ca_unit                   is %d\n", tr->ca_unit                   );
  mcSHOW_DBG_MSG ("ca_MCKIO_unit             is %d\n", tr->ca_MCKIO_unit             );
  mcSHOW_DBG_MSG ("ca_frate                  is %d\n", tr->ca_frate                  );
  mcSHOW_DBG_MSG ("TX_ECC                    is %d\n", tr->TX_ECC                    );
  mcSHOW_DBG_MSG ("TWPRE                     is %d\n", tr->TWPRE                     );
  mcSHOW_DBG_MSG ("OE_pre_margin             is %d\n", tr->OE_pre_margin             );
  mcSHOW_DBG_MSG ("OE_pst_margin             is %d\n", tr->OE_pst_margin             );
  mcSHOW_DBG_MSG ("OE_downgrade              is %d\n", tr->OE_downgrade              );
  mcSHOW_DBG_MSG ("aphy_slice_dly            is %d\n", tr->aphy_slice_dly            );
  mcSHOW_DBG_MSG ("aphy_dtc_dly              is %d\n", tr->aphy_dtc_dly              );
  mcSHOW_DBG_MSG ("aphy_tx_dly               is %d\n", tr->aphy_tx_dly               );
  mcSHOW_DBG_MSG ("DDRPHY_CLK_EN_COMB_TX_OPT is %d\n", tr->DDRPHY_CLK_EN_COMB_TX_OPT );
  mcSHOW_DBG_MSG ("NEW_RANK_MODE             is %d\n", tr->NEW_RANK_MODE             );
  mcSHOW_DBG_MSG ("close_loop_mode           is %d\n", tr->close_loop_mode           );
  mcSHOW_DBG_MSG ("semi_open_loop_mode       is %d\n", tr->semi_open_loop_mode       );  
  mcSHOW_DBG_MSG ("TXP_WORKAROUND_OPT        is %d\n", tr->TXP_WORKAROUND_OPT        );
  mcSHOW_DBG_MSG ("ui2pi_ratio               is %d\n", tr->ui2pi_ratio               );
  mcSHOW_DBG_MSG ("XRTW2W_PI_mute_time       is %d\n", tr->XRTW2W_PI_mute_time       );
  mcSHOW_DBG_MSG ("fake_mode                 is %d\n", tr->fake_mode                 );
  mcSHOW_DBG_MSG ("dphy_tx_dly               is %d\n", tr->dphy_tx_dly               );
  mcSHOW_DBG_MSG ("impact_lat_dramobf        is %d\n", tr->impact_latency_for_dramobf);
  mcSHOW_DBG_MSG ("TX_DQ_Dline               is %d\n", tr->TX_DQ_Dline               );
  mcSHOW_DBG_MSG ("===========================================\n"                    );
}
void print_TX_path_attribution(TX_path_attribution_T *tr)
{
  mcSHOW_DBG_MSG ("===========================================\n"                 );
  mcSHOW_DBG_MSG ("print TX_path_attribution\n"                                   );
  mcSHOW_DBG_MSG ("===========================================\n"                 );
  mcSHOW_DBG_MSG ("TX_DQ_MCK_OE[0][0]                  is %d\n", tr->TX_DQ_MCK_OE[0][0]                  );
  mcSHOW_DBG_MSG ("TX_DQ_MCK_OE[0][1]                  is %d\n", tr->TX_DQ_MCK_OE[0][1]                  );
  mcSHOW_DBG_MSG ("TX_DQ_MCK_OE[1][0]                  is %d\n", tr->TX_DQ_MCK_OE[1][0]                  );
  mcSHOW_DBG_MSG ("TX_DQ_MCK_OE[1][1]                  is %d\n", tr->TX_DQ_MCK_OE[1][1]                  );
  mcSHOW_DBG_MSG ("TX_DQ_UI_OE[0][0]                   is %d\n", tr->TX_DQ_UI_OE[0][0]                   );
  mcSHOW_DBG_MSG ("TX_DQ_UI_OE[0][1]                   is %d\n", tr->TX_DQ_UI_OE[0][1]                   );
  mcSHOW_DBG_MSG ("TX_DQ_UI_OE[1][0]                   is %d\n", tr->TX_DQ_UI_OE[1][0]                   );
  mcSHOW_DBG_MSG ("TX_DQ_UI_OE[1][1]                   is %d\n", tr->TX_DQ_UI_OE[1][1]                   );
  mcSHOW_DBG_MSG ("TX_DQ_MCK[0][0]                     is %d\n", tr->TX_DQ_MCK[0][0]                     );
  mcSHOW_DBG_MSG ("TX_DQ_MCK[0][1]                     is %d\n", tr->TX_DQ_MCK[0][1]                     );
  mcSHOW_DBG_MSG ("TX_DQ_MCK[1][0]                     is %d\n", tr->TX_DQ_MCK[1][0]                     );
  mcSHOW_DBG_MSG ("TX_DQ_MCK[1][1]                     is %d\n", tr->TX_DQ_MCK[1][1]                     );
  mcSHOW_DBG_MSG ("TX_DQ_UI[0][0]                      is %d\n", tr->TX_DQ_UI[0][0]                      );
  mcSHOW_DBG_MSG ("TX_DQ_UI[0][1]                      is %d\n", tr->TX_DQ_UI[0][1]                      );
  mcSHOW_DBG_MSG ("TX_DQ_UI[1][0]                      is %d\n", tr->TX_DQ_UI[1][0]                      );
  mcSHOW_DBG_MSG ("TX_DQ_UI[1][1]                      is %d\n", tr->TX_DQ_UI[1][1]                      );
  mcSHOW_DBG_MSG ("TX_DQ_PI[0][0]                      is %d\n", tr->TX_DQ_PI[0][0]                      );
  mcSHOW_DBG_MSG ("TX_DQ_PI[0][1]                      is %d\n", tr->TX_DQ_PI[0][1]                      );
  mcSHOW_DBG_MSG ("TX_DQ_PI[1][0]                      is %d\n", tr->TX_DQ_PI[1][0]                      );
  mcSHOW_DBG_MSG ("TX_DQ_PI[1][1]                      is %d\n", tr->TX_DQ_PI[1][1]                      );
  mcSHOW_DBG_MSG ("TX_DQ_UIPI_all[0][0]                is %d\n", tr->TX_DQ_UIPI_all[0][0]                );
  mcSHOW_DBG_MSG ("TX_DQ_UIPI_all[0][1]                is %d\n", tr->TX_DQ_UIPI_all[0][1]                );
  mcSHOW_DBG_MSG ("TX_DQ_UIPI_all[1][0]                is %d\n", tr->TX_DQ_UIPI_all[1][0]                );
  mcSHOW_DBG_MSG ("TX_DQ_UIPI_all[1][1]                is %d\n", tr->TX_DQ_UIPI_all[1][1]                );
  mcSHOW_DBG_MSG ("TX_DQ_dlyline[0][0]                 is %d\n", tr->TX_DQ_dlyline[0][0]                 );
  mcSHOW_DBG_MSG ("TX_DQ_dlyline[0][1]                 is %d\n", tr->TX_DQ_dlyline[0][1]                 );
  mcSHOW_DBG_MSG ("TX_DQ_dlyline[1][0]                 is %d\n", tr->TX_DQ_dlyline[1][0]                 );
  mcSHOW_DBG_MSG ("TX_DQ_dlyline[1][1]                 is %d\n", tr->TX_DQ_dlyline[1][1]                 );
  mcSHOW_DBG_MSG ("TX_DQS_MCK_OE[0][0]                 is %d\n", tr->TX_DQS_MCK_OE[0][0]                 );
  mcSHOW_DBG_MSG ("TX_DQS_MCK_OE[0][1]                 is %d\n", tr->TX_DQS_MCK_OE[0][1]                 );
  mcSHOW_DBG_MSG ("TX_DQS_MCK_OE[1][0]                 is %d\n", tr->TX_DQS_MCK_OE[1][0]                 );
  mcSHOW_DBG_MSG ("TX_DQS_MCK_OE[1][1]                 is %d\n", tr->TX_DQS_MCK_OE[1][1]                 );
  mcSHOW_DBG_MSG ("TX_DQS_UI_OE[0][0]                  is %d\n", tr->TX_DQS_UI_OE[0][0]                  );
  mcSHOW_DBG_MSG ("TX_DQS_UI_OE[0][1]                  is %d\n", tr->TX_DQS_UI_OE[0][1]                  );
  mcSHOW_DBG_MSG ("TX_DQS_UI_OE[1][0]                  is %d\n", tr->TX_DQS_UI_OE[1][0]                  );
  mcSHOW_DBG_MSG ("TX_DQS_UI_OE[1][1]                  is %d\n", tr->TX_DQS_UI_OE[1][1]                  );
  mcSHOW_DBG_MSG ("TX_DQS_MCK[0][0]                    is %d\n", tr->TX_DQS_MCK[0][0]                    );
  mcSHOW_DBG_MSG ("TX_DQS_MCK[0][1]                    is %d\n", tr->TX_DQS_MCK[0][1]                    );
  mcSHOW_DBG_MSG ("TX_DQS_MCK[1][0]                    is %d\n", tr->TX_DQS_MCK[1][0]                    );
  mcSHOW_DBG_MSG ("TX_DQS_MCK[1][1]                    is %d\n", tr->TX_DQS_MCK[1][1]                    );
  mcSHOW_DBG_MSG ("TX_DQS_UI[0][0]                     is %d\n", tr->TX_DQS_UI[0][0]                     );
  mcSHOW_DBG_MSG ("TX_DQS_UI[0][1]                     is %d\n", tr->TX_DQS_UI[0][1]                     );
  mcSHOW_DBG_MSG ("TX_DQS_UI[1][0]                     is %d\n", tr->TX_DQS_UI[1][0]                     );
  mcSHOW_DBG_MSG ("TX_DQS_UI[1][1]                     is %d\n", tr->TX_DQS_UI[1][1]                     );
  mcSHOW_DBG_MSG ("DDRPHY_CLK_EN_COMB_TX_OPT           is %d\n", tr->DDRPHY_CLK_EN_COMB_TX_OPT           );
  mcSHOW_DBG_MSG ("TX_DQS_PI[0][0]                     is %d\n", tr->TX_DQS_PI[0][0]                     );
  mcSHOW_DBG_MSG ("TX_DQS_PI[0][1]                     is %d\n", tr->TX_DQS_PI[0][1]                     );
  mcSHOW_DBG_MSG ("TX_DQS_PI[1][0]                     is %d\n", tr->TX_DQS_PI[1][0]                     );
  mcSHOW_DBG_MSG ("TX_DQS_PI[1][1]                     is %d\n", tr->TX_DQS_PI[1][1]                     );
  mcSHOW_DBG_MSG ("DDRPHY_CLK_EN_COMB_TX_PICG_CNT      is %d\n", tr->DDRPHY_CLK_EN_COMB_TX_PICG_CNT      );
  mcSHOW_DBG_MSG ("DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0    is %d\n", tr->DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0    );
  mcSHOW_DBG_MSG ("DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1    is %d\n", tr->DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1    );
  mcSHOW_DBG_MSG ("DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P0 is %d\n", tr->DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P0 );
  mcSHOW_DBG_MSG ("DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P1 is %d\n", tr->DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P1 );
  mcSHOW_DBG_MSG ("DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P0 is %d\n", tr->DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P0 );
  mcSHOW_DBG_MSG ("DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P1 is %d\n", tr->DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P1 );
  mcSHOW_DBG_MSG ("DPHY_TX_DCM_EXTCNT                  is %d\n", tr->DPHY_TX_DCM_EXTCNT                  );
  mcSHOW_DBG_MSG ("TX_PI_UPD_MODE                      is %d\n", tr->TX_PI_UPD_MODE                      );
  mcSHOW_DBG_MSG ("TX_PI_UPDCTL_B0                     is %d\n", tr->TX_PI_UPDCTL_B0                     );
  mcSHOW_DBG_MSG ("TX_PI_UPDCTL_B1                     is %d\n", tr->TX_PI_UPDCTL_B1                     );
  mcSHOW_DBG_MSG ("TX_RANKINCTL_ROOT                   is %d\n", tr->TX_RANKINCTL_ROOT                   );
  mcSHOW_DBG_MSG ("TX_RANKINCTL                        is %d\n", tr->TX_RANKINCTL                        );
  mcSHOW_DBG_MSG ("TX_RANKINCTL_TXDLY                  is %d\n", tr->TX_RANKINCTL_TXDLY                  );
  mcSHOW_DBG_MSG ("DDRPHY_CLK_DYN_GATING_SEL           is %d\n", tr->DDRPHY_CLK_DYN_GATING_SEL           );
  mcSHOW_DBG_MSG ("DDRPHY_CLK_EN_OPT                   is %d\n", tr->DDRPHY_CLK_EN_OPT                   );
  mcSHOW_DBG_MSG ("ARPI_CMD                            is %d\n", tr->ARPI_CMD                            );
  mcSHOW_DBG_MSG ("TDMY                                is %d\n", tr->TDMY                                );
  mcSHOW_DBG_MSG ("TXOEN_AUTOSET_DQ_OFFSET             is %d\n", tr->TXOEN_AUTOSET_DQ_OFFSET             );
  mcSHOW_DBG_MSG ("TXOEN_AUTOSET_DQS_OFFSET            is %d\n", tr->TXOEN_AUTOSET_DQS_OFFSET            );
  mcSHOW_DBG_MSG ("TXOEN_AUTOSET_EN	                is %d\n", tr->TXOEN_AUTOSET_EN	                  );
  mcSHOW_DBG_MSG ("TXPICG_AUTOSET_OPT	                is %d\n", tr->TXPICG_AUTOSET_OPT                  );  
  mcSHOW_DBG_MSG ("TXPICG_AUTOSET_EN	                is %d\n", tr->TXPICG_AUTOSET_EN	                  );
  mcSHOW_DBG_MSG ("TXPICG_DQ_MCK_OFFSET_LAG            is %d\n", tr->TXPICG_DQ_MCK_OFFSET_LAG            );
  mcSHOW_DBG_MSG ("TXPICG_DQS_MCK_OFFSET_LAG           is %d\n", tr->TXPICG_DQS_MCK_OFFSET_LAG           );
  mcSHOW_DBG_MSG ("TXPICG_DQ_UI_OFFSET_LEAD            is %d\n", tr->TXPICG_DQ_UI_OFFSET_LEAD            );
  mcSHOW_DBG_MSG ("TXPICG_DQ_UI_OFFSET_LAG             is %d\n", tr->TXPICG_DQ_UI_OFFSET_LAG             );
  mcSHOW_DBG_MSG ("TXPICG_DQS_UI_OFFSET_LEAD           is %d\n", tr->TXPICG_DQS_UI_OFFSET_LEAD           );
  mcSHOW_DBG_MSG ("TXPICG_DQS_UI_OFFSET_LAG            is %d\n", tr->TXPICG_DQS_UI_OFFSET_LAG            );
  mcSHOW_DBG_MSG ("===========================================\n"                 );
}

//extern U32 Get_WL_by_MR_LP4(U8 Version, U8 MR_WL_field_value);
extern U32 Get_WL_LP5_DVFSC_DIS( U8 MR_RL_field_value,U8 BYTE_MODE_EN,U8 CKR);
extern U32 Get_WL_LP5_DVFSC_EN( U8 MR_RL_field_value, U8 BYTE_MODE_EN,U8 CKR);
extern U32 Get_WL_by_MR_PC3(U8 BYTE_MODE_EN,U8 DBI_EN, U8 MR_CWL,U8 AL);
extern U32 Get_WL_by_MR_PC4(U8 BYTE_MODE_EN, U8 MR_CWL,U8 AL);

void get_TX_path_config(TX_path_config_T *TX_C,U8 ch_id, U32 group_id)
{
  U8 BYTE_swap;
  U8 rank_id ;
  U8 byte_id ;
  U32 TDQS2DQ_min;

  if (ch_id == 0) {
    BYTE_swap = DUT_p.PINMUX_BYTE_SWAP_CHA;
  } else {
    BYTE_swap = DUT_p.PINMUX_BYTE_SWAP_CHB;
  }

  mcSHOW_DBG_MSG3("BYTE_swap:%d \n", BYTE_swap);
#if SUPPORT_TYPE_LPDDR4
  LP4_DRAM_CONFIG_T LP4_TX_temp;
  if (LPDDR4_EN_S) {
    LP4_DRAM_config(DFS(group_id)->data_rate, &LP4_TX_temp,DUT_p.FORCE_DBI_OFF);
  }
#endif
#if SUPPORT_TYPE_LPDDR5
  LP5_DRAM_CONFIG_T LP5_TX_temp;
  if (LPDDR5_EN_S) {
    LP5_DRAM_config(DFS(group_id), &LP5_TX_temp, group_id);
  }
#endif
  PC3_DRAM_CONFIG_T PC3_TX_temp;
  if (PCDDR3_EN_S) {
    PC3_DRAM_config(DFS(group_id)->data_rate, &PC3_TX_temp);
  }
  PC4_DRAM_CONFIG_T PC4_TX_temp;
  if (PCDDR4_EN_S) {
    PC4_DRAM_config(DFS(group_id)->data_rate, &PC4_TX_temp);
  }

  TX_C->NEW_RANK_MODE       = DUT_p.NEW_RANK_MODE ; 
  TX_C->TXP_WORKAROUND_OPT  = 0 ; //TODO  depend on top_cfg
  TX_C->data_ratio          = DFS(group_id)->data_rate;  
  TX_C->ca_frate            = A_D->CA_FULL_RATE;
#if SA_CONFIG_EN
    TX_C->close_loop_mode = !(u1IsPhaseMode(DUT_p.ctx));
    TX_C->semi_open_loop_mode = !!(u1IsPhaseMode(DUT_p.ctx));
#else
  TX_C->close_loop_mode     = (TX_C->data_ratio >=2133) ;
  TX_C->semi_open_loop_mode = ((TX_C->data_ratio< 2133)&&(DUT_shu_p[group_id].APHY_CLOCK_MODE!=3));
#endif
#if SUPPORT_TYPE_LPDDR4
  if (LPDDR4_EN_S == 1)
  { 
    TX_C->WL[0]        = Get_WL_by_MR_LP4(0, LP4_TX_temp.MR_WL);  
    TX_C->WL[1]        = Get_WL_by_MR_LP4(0, LP4_TX_temp.MR_WL);
    TX_C->TDQS2DQ[0][0]= BYTE_swap ? DUT_p.TDQS2DQ_R0_B1 : DUT_p.TDQS2DQ_R0_B0 ; //ps
    TX_C->TDQS2DQ[0][1]= BYTE_swap ? DUT_p.TDQS2DQ_R0_B0 : DUT_p.TDQS2DQ_R0_B1 ; //ps
    TX_C->TDQS2DQ[1][0]= BYTE_swap ? DUT_p.TDQS2DQ_R1_B1 : DUT_p.TDQS2DQ_R1_B0 ; //ps
    TX_C->TDQS2DQ[1][1]= BYTE_swap ? DUT_p.TDQS2DQ_R1_B0 : DUT_p.TDQS2DQ_R1_B1 ; //ps
  } else
#endif
#if SUPPORT_TYPE_LPDDR5
  if (LPDDR5_EN_S == 1)
  {
    if (LP5_TX_temp.DVFSC)
    {
      TX_C->WL[0]    = Get_WL_LP5_DVFSC_EN(LP5_TX_temp.MR_WL, LP5_TX_temp.BYTE_MODE[0], A_D->CKR);
      TX_C->WL[1]    = Get_WL_LP5_DVFSC_EN(LP5_TX_temp.MR_WL, LP5_TX_temp.BYTE_MODE[1], A_D->CKR);
    } else 
    {
      TX_C->WL[0]    = Get_WL_LP5_DVFSC_DIS(LP5_TX_temp.MR_WL, LP5_TX_temp.BYTE_MODE[0], A_D->CKR);
      TX_C->WL[1]    = Get_WL_LP5_DVFSC_DIS(LP5_TX_temp.MR_WL, LP5_TX_temp.BYTE_MODE[1], A_D->CKR);
    }
    if (LP5_TX_temp.WCK_FM)
    {
      TX_C->TDQS2DQ[0][0]= BYTE_swap ? DUT_p.TWCK2DQI_HF_R0_B1 : DUT_p.TWCK2DQI_HF_R0_B0 ; //ps
      TX_C->TDQS2DQ[0][1]= BYTE_swap ? DUT_p.TWCK2DQI_HF_R0_B0 : DUT_p.TWCK2DQI_HF_R0_B1 ; //ps
      TX_C->TDQS2DQ[1][0]= BYTE_swap ? DUT_p.TWCK2DQI_HF_R1_B1 : DUT_p.TWCK2DQI_HF_R1_B0 ; //ps
      TX_C->TDQS2DQ[1][1]= BYTE_swap ? DUT_p.TWCK2DQI_HF_R1_B0 : DUT_p.TWCK2DQI_HF_R1_B1 ; //ps
    } else 
    {
      TX_C->TDQS2DQ[0][0]= BYTE_swap ? DUT_p.TWCK2DQI_LF_R0_B1 : DUT_p.TWCK2DQI_LF_R0_B0 ; //ps
      TX_C->TDQS2DQ[0][1]= BYTE_swap ? DUT_p.TWCK2DQI_LF_R0_B0 : DUT_p.TWCK2DQI_LF_R0_B1 ; //ps
      TX_C->TDQS2DQ[1][0]= BYTE_swap ? DUT_p.TWCK2DQI_LF_R1_B1 : DUT_p.TWCK2DQI_LF_R1_B0 ; //ps
      TX_C->TDQS2DQ[1][1]= BYTE_swap ? DUT_p.TWCK2DQI_LF_R1_B0 : DUT_p.TWCK2DQI_LF_R1_B1 ; //ps
    }
  } else
#endif
#if SUPPORT_TYPE_PCDDR3
  if (PCDDR3_EN_S == 1) {
      TX_C->WL[0]        = Get_WL_by_MR_PC3(0,0, PC3_TX_temp.CWL,PC3_TX_temp.AL);
      TX_C->WL[1]        = Get_WL_by_MR_PC3(0,0, PC3_TX_temp.CWL,PC3_TX_temp.AL);
      TX_C->TDQS2DQ[0][0]= DUT_p.TDQS2DQ_R0_B0 ; //ps
      TX_C->TDQS2DQ[0][1]= DUT_p.TDQS2DQ_R0_B1 ; //ps
      TX_C->TDQS2DQ[1][0]= DUT_p.TDQS2DQ_R1_B0 ; //ps
      TX_C->TDQS2DQ[1][1]= DUT_p.TDQS2DQ_R1_B1 ; //ps
  } else 
#endif
#if SUPPORT_TYPE_PCDDR4
  if (PCDDR4_EN_S == 1) {
      TX_C->WL[0]        = Get_WL_by_MR_PC4(0, PC4_TX_temp.CWL,PC4_TX_temp.AL);
      TX_C->WL[1]        = Get_WL_by_MR_PC4(0, PC4_TX_temp.CWL,PC4_TX_temp.AL);
      TX_C->TDQS2DQ[0][0]= DUT_p.TDQS2DQ_R0_B0 ; //ps
      TX_C->TDQS2DQ[0][1]= DUT_p.TDQS2DQ_R0_B1 ; //ps
      TX_C->TDQS2DQ[1][0]= DUT_p.TDQS2DQ_R1_B0 ; //ps
      TX_C->TDQS2DQ[1][1]= DUT_p.TDQS2DQ_R1_B1 ; //ps
  }
  else 
#endif
  {
    mcSHOW_DBG_MSG("Error: wrong memory type, LP4 LP5 DDR3 DDR4 are support lists.--TX caculation\n");  
  }

  //*****************************calculate the DQSTDQ mini and skew****************************//
  if(LPDDR5_EN_S && (TX_C->semi_open_loop_mode==1)){
    TDQS2DQ_min =  TX_C->TDQS2DQ[0][0];
    for(rank_id = 0; rank_id < 2; rank_id ++)
    {
      for(byte_id = 0; byte_id < 2; byte_id ++)
      {
        if(TDQS2DQ_min > TX_C->TDQS2DQ[rank_id][byte_id])
           TDQS2DQ_min = TX_C->TDQS2DQ[rank_id][byte_id];
      }
    }
    for(rank_id = 0; rank_id < 2; rank_id ++)
    {
      for(byte_id = 0; byte_id < 2; byte_id ++)
      {
           TX_C->TDQS2DQ_skew[rank_id][byte_id]  = TX_C->TDQS2DQ[rank_id][byte_id] - TDQS2DQ_min;
      }
    }
  }
  //*******************************************************************************************//

  TX_C->dq_p2s_ratio	   = A_D->DQ_P2S_RATIO   ;   
  TX_C->ui2pi_ratio	   = 32   ;   
  TX_C->CKR           	   = A_D->CKR   ;  
  TX_C->byte_num      	   = 2   ;
  TX_C->rank_num      	   = 2   ;
  TX_C->dq_ui_unit    	   = 1000000 / TX_C->data_ratio ;
  TX_C->ca_p2s_ratio	   = TX_C->dq_p2s_ratio / TX_C->CKR;
  TX_C->MCK_unit  	   = TX_C->dq_ui_unit * TX_C->dq_p2s_ratio;
  TX_C->ca_unit   	   = TX_C->dq_ui_unit * TX_C->CKR;
  TX_C->ca_MCKIO_unit      = TX_C->dq_ui_unit * TX_C->CKR / (1 + A_D->CA_FULL_RATE );
  TX_C->dqs_oe_default_dly = 2   ; //TODO
  TX_C->TWPRE              = 4   ; //unit: dq_ui
  TX_C->OE_pre_margin      = 400 ; //ps  ASVA_6_1
  TX_C->OE_pst_margin      = 500 ; //ps
  TX_C->OE_downgrade       = 1   ; //TODO 
  TX_C->aphy_slice_dly     = 11  ; //ps
  TX_C->aphy_dtc_dly       = 100 ; //ps
  TX_C->aphy_tx_dly        = 16  ;
  TX_C->TX_DQ_Dline        = DFS(group_id)->TX_DQ_Dline  ;
  if (TX_C->dq_p2s_ratio == 4)
  {
    //TX_C->dly_1T_by_FDIV2 = 1;
    TX_C->dly_1T_by_FDIV2 = ((DUT_p.DEF_DDR34_1C32B_EN_TBA == 1) && (DUT_p.DEF_DDR3_X32_EN || DUT_p.DEF_DDR4_X32_EN)) ? 0 : 1; //dly_1T_by_FDIV2 = RG_FDIV2 & (~RG_DQBUS_X32) , RG_DQBUS_X32=1 when DUT_p.DEF_DDR34_1C32B_EN_TBA =1
  }
  else 
  {
    TX_C->dly_1T_by_FDIV2 = 0; //dly_1T_by_FDIV2 = RG_FDIV2 & (~RG_DQBUS_X32) , RG_DQBUS_X32 always is 0
  }
  TX_C->dqs_default_dly    = (TX_C->dly_1T_by_FDIV2 == 1) ? 1 : 5; //TODO
#if SUPPORT_TYPE_LPDDR4
  if (LPDDR4_EN_S) //LP4
  {
    TX_C->ca_default_pi     = 0  ;
    TX_C->DBI_WR            = LP4_TX_temp.DBI_WR;

    if (DUT_p.DRAMOBF_EN) {
	TX_C->DRAMOBF_EN        = 1  ;
	     switch(TX_C->data_ratio)
	     {
//               case 8533: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
//               case 7500: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
//               case 6400: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
//               case 5500: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
//               case 4800: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
               case 4266: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
//               case 4100: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
               case 3733: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
               case 3200: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
               case 2667: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
               case 2400: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
               case 2133: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
               case 1866: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
               case 1600: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
               case 1200: {TX_C->DRAMOBF_PIPE_NO   = 3  ;break;}
               case 800 : {TX_C->DRAMOBF_PIPE_NO   = 3  ;break;}
               case 400 : {TX_C->DRAMOBF_PIPE_NO   = 3  ;break;}
	       default  : mcSHOW_DBG_MSG("[TX_path_auto_gen] DRAMOBF_PIPE_NO Unexpected DFS(group_id)->data_rate=%d input \n",TX_C->data_ratio);
	     }//switch
    }
    else 
    {
      TX_C->DRAMOBF_EN        = 0  ;
      TX_C->DRAMOBF_PIPE_NO   = 0  ;
    }

    TX_C->ca_default_dly    = 1  ;
    TX_C->cs2WL_start       = 7  ;
    TX_C->TDQSS[0][0]	    = 2 * TX_C->dq_ui_unit ; 
    TX_C->TDQSS[0][1]  	    = 2 * TX_C->dq_ui_unit ; 
    TX_C->TDQSS[1][0]  	    = 2 * TX_C->dq_ui_unit ; 
    TX_C->TDQSS[1][1]  	    = 2 * TX_C->dq_ui_unit ; 
    TX_C->TX_ECC            = 0  ;
    if (DUT_p.DEF_DIGPHY)
      TX_C->dphy_tx_dly = 1;
    else
      TX_C->dphy_tx_dly = 0;
  }   
  else 
#endif
#if SUPPORT_TYPE_LPDDR5
if (LPDDR5_EN_S)
  {
    TX_C->ca_default_pi     = A_D->CA_FULL_RATE ? 32 : 16 ;
    TX_C->DBI_WR            = LP5_TX_temp.DBI_WR;

    if (DUT_p.DRAMOBF_EN) {
	TX_C->DRAMOBF_EN        = 1  ;
	     switch(TX_C->data_ratio)
	     {
               case 8533: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;} //!TBD
               case 7500: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
               case 6400: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
               case 5500: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
               case 4800: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
               case 4266: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;} //ECC need off
               case 4100: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
               case 3733: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
               case 3200: {TX_C->DRAMOBF_PIPE_NO   = 5  ;break;}
               case 2667: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
               case 2400: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
               case 2133: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
               case 1866: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
               case 1600: {TX_C->DRAMOBF_PIPE_NO   = 4  ;break;}
               case 1200: {TX_C->DRAMOBF_PIPE_NO   = 3  ;break;}
               case 800 : {TX_C->DRAMOBF_PIPE_NO   = 3  ;break;}
               case 400 : {TX_C->DRAMOBF_PIPE_NO   = 2  ;break;}
	       default  : mcSHOW_DBG_MSG("[TX_path_auto_gen] DRAMOBF_PIPE_NO Unexpected DFS(group_id)->data_rate=%d input \n",TX_C->data_ratio);
	     }//switch
    }
    else 
    {
      TX_C->DRAMOBF_EN        = 0  ;
      TX_C->DRAMOBF_PIPE_NO   = 0  ;
    }

    TX_C->ca_default_dly    = 1 ;  //TODO
    TX_C->cs2WL_start       = 1 ;
    TX_C->TDQSS[0][0]	    = 0 * TX_C->dq_ui_unit; 
    TX_C->TDQSS[0][1]  	    = 0 * TX_C->dq_ui_unit; 
    TX_C->TDQSS[1][0]  	    = 0 * TX_C->dq_ui_unit; 
    TX_C->TDQSS[1][1]  	    = 0 * TX_C->dq_ui_unit; 
    TX_C->TX_ECC            = LP5_TX_temp.WECC  ;
    //if (TX_C->dq_p2s_ratio == 4)
    //  TX_C->dly_1T_by_FDIV2 = 1;
    //else 
    //  TX_C->dly_1T_by_FDIV2 = 0;
    if (DUT_p.DEF_DIGPHY)
      TX_C->dphy_tx_dly = 0;
    else
      TX_C->dphy_tx_dly = 0;
  } 
  else 
#endif
#if SUPPORT_TYPE_PCDDR3
    if (PCDDR3_EN_S){
    TX_C->TDQS2DQ[0][0]   = 0 ; 
    TX_C->TDQS2DQ[0][1]   = 0 ; 
    TX_C->TDQS2DQ[1][0]   = 0 ; 
    TX_C->TDQS2DQ[1][1]   = 0 ;
    TX_C->ca_default_pi     = 0 ; //2T cmd and shift 1/2 UI for TIS and TIH, IPM_V23 change item by berson
    TX_C->DBI_WR            = 0  ;

    if (DUT_p.DRAMOBF_EN) {
      TX_C->DRAMOBF_EN        = 1  ;
      TX_C->DRAMOBF_PIPE_NO   = 2  ; //for CHACHA2
    } else {
      TX_C->DRAMOBF_EN        = 0  ;
      TX_C->DRAMOBF_PIPE_NO   = 0  ;
    }
    
    TX_C->ca_default_dly    = 1  ;
    TX_C->cs2WL_start       = 1  ;
    TX_C->TDQSS[0][0]	    = (2 * TX_C->dq_ui_unit) / 10  ;//SPEC -0.27 ~ 0.27 here fix 0.2
    TX_C->TDQSS[0][1]  	    = (4 * TX_C->dq_ui_unit) / 10  ;//SPEC -0.27 ~ 0.27 here fix 0.2
    TX_C->TDQSS[1][0]  	    = (4 * TX_C->dq_ui_unit) / 10  ;//SPEC -0.27 ~ 0.27 here fix 0.2
    TX_C->TDQSS[1][1]  	    = (2 * TX_C->dq_ui_unit) / 10  ;//SPEC -0.27 ~ 0.27 here fix 0.2
    TX_C->TX_ECC            = 0  ;
    //if (TX_C->dq_p2s_ratio == 4)  //TODO
    //  TX_C->dly_1T_by_FDIV2 = 1;
    //else 
    //  TX_C->dly_1T_by_FDIV2 = 0;
    if (DUT_p.DEF_DIGPHY)
      TX_C->dphy_tx_dly = 0;
    else
      TX_C->dphy_tx_dly = 0;
  }
  else 
#endif
#if SUPPORT_TYPE_PCDDR4
    if (PCDDR4_EN_S){
      TX_C->TDQS2DQ[0][0]   = 0 ; 
    TX_C->TDQS2DQ[0][1]   = 0 ; 
    TX_C->TDQS2DQ[1][0]   = 0 ; 
    TX_C->TDQS2DQ[1][1]   = 0 ;
    TX_C->ca_default_pi     = 0  ;
    TX_C->DBI_WR            = 0  ;//TODO

    if (DUT_p.DRAMOBF_EN) {
      TX_C->DRAMOBF_EN        = 1  ;
      TX_C->DRAMOBF_PIPE_NO   = 2  ; //for CHACHA2
    } else {
      TX_C->DRAMOBF_EN        = 0  ;
      TX_C->DRAMOBF_PIPE_NO   = 0  ;
    }
    TX_C->ca_default_dly    = 1  ;
    TX_C->cs2WL_start       = 1  ;
    TX_C->TDQSS[0][0]	    = (2 * TX_C->dq_ui_unit) / 10  ;//SPEC -0.27 ~ 0.27 here fix 0.2
    TX_C->TDQSS[0][1]  	    = (4 * TX_C->dq_ui_unit) / 10  ;//SPEC -0.27 ~ 0.27 here fix 0.2
    TX_C->TDQSS[1][0]  	    = (4 * TX_C->dq_ui_unit) / 10  ;//SPEC -0.27 ~ 0.27 here fix 0.2
    TX_C->TDQSS[1][1]  	    = (2 * TX_C->dq_ui_unit) / 10  ;//SPEC -0.27 ~ 0.27 here fix 0.2
    TX_C->TX_ECC            = 0  ;
    //if (TX_C->dq_p2s_ratio == 4)  //TODO
    //  TX_C->dly_1T_by_FDIV2 = 1;
    //else 
    //  TX_C->dly_1T_by_FDIV2 = 0;
    if (DUT_p.DEF_DIGPHY)
      TX_C->dphy_tx_dly = 0;
    else
      TX_C->dphy_tx_dly = 0;
  } 
  else 
#endif
  {
    mcSHOW_DBG_MSG("Error: wrong memory type, LP4 LP5 DDR3 DDR4 are support lists.\n");  
  }
  
  TX_C->fake_mode = (DUT_shu_p[group_id].FAKE_1TO16_MODE == 1);
  TX_C->dq_ser_laterncy  = get_dq_ca_p2s_latency(TX_C->dq_p2s_ratio, 0, DUT_shu_p[group_id].FAKE_1TO16_MODE);
  TX_C->dqs_ser_laterncy = get_dq_ca_p2s_latency(TX_C->dq_p2s_ratio, 0, DUT_shu_p[group_id].FAKE_1TO16_MODE);
  TX_C->ca_ser_latency   = get_dq_ca_p2s_latency(TX_C->ca_p2s_ratio, A_D->CA_FULL_RATE, DUT_shu_p[group_id].FAKE_1TO16_MODE);
  TX_C->DDRPHY_CLK_EN_COMB_TX_OPT = 1 ; //TODO it should depend on top_cfg.PICG_MODE

  TX_C->XRTW2W_PI_mute_time = (TX_C->dq_p2s_ratio == 16) ? 5 : ((TX_C->dq_p2s_ratio == 8) ? 7 : 11); //AC timing spec RU.
  TX_C->impact_latency_for_dramobf = DFS(group_id)->TX_IMPAT_LAT_DRAMOBF;
} //get_TX_path_config

void calculate_TX_path_rg_val(TX_path_config_T *TX_C, TX_path_attribution_T *TX_R, U8 group_id, U8 ch_id)
{
  U32 TX_dq_latency_ps[2][2]           ;
  U32 TX_dq_latency_for_PI[2][2]       ;
  U32 TX_dq_latency_for_dly_line[2][2] ;
  U8  least_tracking_margin = 0            ; //ps
  U8  tx_dly_line_unit      = 8        ; //ps
//  U8  TX_DQ_UI_OE_pre                  ;
//  U8  TX_DQS_UI_OE_pre                 ;
  U8  TX_DQ_PI_min                     ;
  U8  TX_DQ_PI_max                     ;
  U32 TX_DQ_PI_mini   =   65535        ;
  U32 TX_DQ_UI_mini   =   65535        ;
//  U32 TDQS2DQ_skew_min=   65535        ;
  U8  rank_id                          ;
  U8  byte_id                          ;
//  U8  aphy_def_dly                     ;
//  U8  TX_DQ_MCK_RK0_min                ;
//  U8  TX_DQ_MCK_RK1_min                ;
//  U8  TX_DQ_UI_RK0_min                 ;
//  U8  TX_DQ_UI_RK1_min                 ;
  U8  TX_DQ_OE_MCK_RK0_min             ;
  U8  TX_DQ_OE_MCK_RK1_min             ;
  U8  TX_DQ_OE_UI_RK0_min              ;
  U8  TX_DQ_OE_UI_RK1_min              ;
  U8  TX_DQ_OE_MCK_MAX                 ;
//  U8  TX_PI_UPDCTL                     ;
  U8  ASVA_PICG_SPEC = 1               ;  //unit: M_CK
//  U8  ASVA_PICHG_FROMTXD = 1           ;
//  U8  ASVA_DLINECHANG_FROMTXD=2        ;
  U8  dqs_oe_def_ui_dly_p0             ;
  U8  dqs_oe_def_ui_dly_p1             ;

  if (LPDDR5_EN_S)
    least_tracking_margin = 0  ;  //for LP5 tx_tracking can update UI, no need to consider tracking margin
  else if (LPDDR4_EN_S)
    least_tracking_margin = 120;
  else if (PCDDR3_EN_S)
    least_tracking_margin = 0;
  else if (PCDDR4_EN_S)
    least_tracking_margin = 0;
  else {
    mcSHOW_DBG_MSG("Error: don't support this memory type\n");
  }
    

//  aphy_def_dly = TX_C->aphy_slice_dly + TX_C->aphy_dtc_dly + TX_C->aphy_tx_dly ;
  TX_DQ_PI_min = A_div_B_RU(least_tracking_margin * TX_C->ui2pi_ratio, TX_C->dq_ui_unit);
  TX_DQ_PI_max = 64 - TX_DQ_PI_min; // TODO 64? don't related with frequence?
//  TX_DQ_UI_OE_pre = A_div_B_RU(TX_C->OE_pre_margin, TX_C->dq_ui_unit);
//  TX_DQS_UI_OE_pre = A_div_B_RU(TX_C->OE_pre_margin, TX_C->dq_ui_unit) - 1 ; //ASVA_6_1
  //if (TX_C->OE_downgrade == 1)
  //{
  //  if (~(TX_DQ_UI_OE_pre == 0) & ((TX_DQ_UI_OE_pre &1 )== 0))
  //    TX_DQ_UI_OE_pre = TX_DQ_UI_OE_pre + 1;
  //  //if (~(TX_DQS_UI_OE_pre == 0) & ((TX_DQS_UI_OE_pre &1 ) == 0))
  //  //  TX_DQS_UI_OE_pre = TX_DQS_UI_OE_pre + 1;
  //}
  //mcSHOW_DBG_MSG("TX_DQ_UI_OE_pre  is %d\n", TX_DQ_UI_OE_pre);
  //mcSHOW_DBG_MSG("TX_DQS_UI_OE_pre is %d\n", TX_DQS_UI_OE_pre);
  for(rank_id = 0; rank_id < 2; rank_id ++)
  {
    for(byte_id = 0; byte_id < 2; byte_id ++)
    {
      TX_dq_latency_ps[rank_id][byte_id] = TX_C->WL[rank_id] * 2 * TX_C->CKR * TX_C->dq_ui_unit + TX_C->TDQSS[rank_id][byte_id]/* * TX_C->dq_ui_unit*/ + (TX_C->TDQS2DQ[rank_id][byte_id] - TX_C->dq_ui_unit / 2) + TX_C->cs2WL_start * TX_C->CKR * TX_C->dq_ui_unit - (1 + TX_C->DBI_WR + TX_C->dly_1T_by_FDIV2 +1) * TX_C->MCK_unit - (TX_C->DRAMOBF_EN * (TX_C->DRAMOBF_PIPE_NO-1 - TX_C->impact_latency_for_dramobf)) * TX_C->MCK_unit + TX_C->ca_default_dly * TX_C->ca_unit + TX_C->ca_ser_latency * TX_C->ca_MCKIO_unit - TX_C->dq_ser_laterncy * TX_C->dq_ui_unit + TX_C->dphy_tx_dly * TX_C->dq_ui_unit; //TDQS2DQ boundary is DQ/DQS central align position, TX_dq_latency_ps boundary is DQ start, so minus 1/2 UI
      
      if((ch_id == 1) && ((PCDDR4_EN_S) && (DUT_p.DEF_DDR4_LP4_EN_TBA == 1)))
      {
           TX_dq_latency_ps[rank_id][byte_id] = TX_dq_latency_ps[rank_id][byte_id] + 4*TX_C->dq_ui_unit ;
      }
      if(DUT_p.DEF_DDR34_1C32B_EN_TBA && DUT_p.DEF_DDR3_X32_EN)
      {
           //TX_dq_latency_ps[rank_id][byte_id] = TX_dq_latency_ps[rank_id][byte_id] - TX_C->dq_ui_unit ;
      } 

      if(DUT_p.DEF_DDR34_1C32B_EN_TBA && DUT_p.DEF_DDR4_X32_EN)
      {
           TX_dq_latency_ps[rank_id][byte_id] = TX_dq_latency_ps[rank_id][byte_id] /*- TX_C->dq_ui_unit*/ ;
      }
      
      mcSHOW_DBG_MSG("june_debug: TX_dq_latency_ps bef is %0d\n", TX_dq_latency_ps[rank_id][byte_id]);
      if((DUT_p.TX_DQ_Dline_EN == 1) && (rank_id == 0)){
        switch (byte_id) {
          case 0: {TX_dq_latency_ps[rank_id][byte_id] = TX_dq_latency_ps[rank_id][byte_id] - (TX_C->TX_DQ_Dline>>2 )*tx_dly_line_unit; break;}
          case 1: {TX_dq_latency_ps[rank_id][byte_id] = TX_dq_latency_ps[rank_id][byte_id] - (TX_C->TX_DQ_Dline>>2 )*tx_dly_line_unit; break;}
        }
      }
      if((DUT_p.TX_DQ_Dline_EN == 1) && (rank_id == 1)){
        switch (byte_id) {
          case 0: {TX_dq_latency_ps[rank_id][byte_id] = TX_dq_latency_ps[rank_id][byte_id] - (TX_C->TX_DQ_Dline>>2 )*tx_dly_line_unit; break;}
          case 1: {TX_dq_latency_ps[rank_id][byte_id] = TX_dq_latency_ps[rank_id][byte_id] - (TX_C->TX_DQ_Dline>>2 )*tx_dly_line_unit; break;}
        }
      }
      mcSHOW_DBG_MSG("june_debug: TX_dq_latency_ps aft is %0d\n", TX_dq_latency_ps[rank_id][byte_id]);
      //if((DUT_p.DEF_DDR34_1C32B_EN_TBA && PCDDR3_EN_S) && (DUT_p.DEF_DDR3_X32_EN)){
      //TX_R->TX_DQ_UI[rank_id][byte_id] = (TX_dq_latency_ps[rank_id][byte_id]/* - least_tracking_margin*/ - TX_C->dq_ui_unit) / TX_C->dq_ui_unit;
      //} 
      //else {
      TX_R->TX_DQ_UI[rank_id][byte_id] = (TX_dq_latency_ps[rank_id][byte_id]/* - least_tracking_margin*/) / TX_C->dq_ui_unit;
      //}

    //  if(PCDDR4_EN_S && (DUT_p.DEF_DDR4_LP4_EN_TBA == 1)){
    //    TX_R->TX_DQ_UI[rank_id][byte_id] = (ch_id == 1) ? TX_R->TX_DQ_UI[rank_id][byte_id]+4 : TX_R->TX_DQ_UI[rank_id][byte_id]; //for ca 1to2
    //  }
      mcSHOW_DBG_MSG("data_ratio %d, TX_dq_latency_ps is %d, TX_dq_latency_MCK is %d \n", TX_C->data_ratio, TX_dq_latency_ps[rank_id][byte_id], TX_dq_latency_ps[rank_id][byte_id]/TX_C->MCK_unit);
      TX_dq_latency_for_PI[rank_id][byte_id] = TX_dq_latency_ps[rank_id][byte_id] - TX_R->TX_DQ_UI[rank_id][byte_id] * TX_C->dq_ui_unit ;
      TX_dq_latency_for_dly_line[rank_id][byte_id] = 0;
      //calculate dq PI for must reserve PI tracking margin
      if (TX_C->close_loop_mode == 1)
      {
	if (TX_dq_latency_for_PI[rank_id][byte_id] < least_tracking_margin)  
      	{
      	  TX_dq_latency_for_PI[rank_id][byte_id] = TX_dq_latency_for_PI[rank_id][byte_id] + TX_C->dq_ui_unit;
      	  TX_R->TX_DQ_UI[rank_id][byte_id] = TX_R->TX_DQ_UI[rank_id][byte_id] - 1; 
      	}
      	if (TX_dq_latency_for_PI[rank_id][byte_id] > (2 * TX_C->dq_ui_unit - least_tracking_margin) )
      	{
      	  TX_dq_latency_for_dly_line[rank_id][byte_id] = TX_dq_latency_for_PI[rank_id][byte_id] - (2 * TX_C->dq_ui_unit - least_tracking_margin);
      	  TX_dq_latency_for_PI[rank_id][byte_id] = (2 * TX_C->dq_ui_unit - least_tracking_margin) ;
      	}
      }
      TX_R->TX_DQ_PI[rank_id][byte_id] =(TX_dq_latency_for_PI[rank_id][byte_id] * TX_C->ui2pi_ratio) / TX_C->dq_ui_unit;
      TX_R->TX_DQ_dlyline[rank_id][byte_id] = TX_dq_latency_for_dly_line[rank_id][byte_id] / tx_dly_line_unit ; //TODO can't cover TX dlyline
      if(DUT_p.TX_DQ_Dline_EN == 1){
        TX_R->TX_DQ_dlyline[0][0] = TX_C->TX_DQ_Dline ;
        TX_R->TX_DQ_dlyline[0][1] = TX_C->TX_DQ_Dline ;
        TX_R->TX_DQ_dlyline[1][0] = TX_C->TX_DQ_Dline ;
        TX_R->TX_DQ_dlyline[1][1] = TX_C->TX_DQ_Dline ;
      }
      if (TX_C->close_loop_mode == 0) //open mode and semi open mode, PI can only set 0, 8, 16, 24
      {
	if      (TX_R->TX_DQ_PI[rank_id][byte_id] < 4  ) TX_R->TX_DQ_PI[rank_id][byte_id] = 0  ;
	else if (TX_R->TX_DQ_PI[rank_id][byte_id] < 12 ) TX_R->TX_DQ_PI[rank_id][byte_id] = 8  ;
	else if (TX_R->TX_DQ_PI[rank_id][byte_id] < 20 ) TX_R->TX_DQ_PI[rank_id][byte_id] = 16 ;
	else if (TX_R->TX_DQ_PI[rank_id][byte_id] < 30 ) TX_R->TX_DQ_PI[rank_id][byte_id] = 24 ;
	else    {TX_R->TX_DQ_PI[rank_id][byte_id] = 0;  TX_R->TX_DQ_UI[rank_id][byte_id] = TX_R->TX_DQ_UI[rank_id][byte_id] +1;}
      }
      if ((TX_R->TX_DQ_PI[rank_id][byte_id] < TX_DQ_PI_min) | (TX_R->TX_DQ_PI[rank_id][byte_id] > TX_DQ_PI_max))
      {
	mcSHOW_DBG_MSG("Warning: calculate wrong TX_DQ_PI, PI is %0d, PI_min is %0d, PI_max is %0d\n", TX_R->TX_DQ_PI[rank_id][byte_id], TX_DQ_PI_min, TX_DQ_PI_max);
      }
      //TX_R->TX_DQ_UI_OE[rank_id][byte_id] = TX_R->TX_DQ_UI[rank_id][byte_id] - TX_DQ_UI_OE_pre + TX_C->DBI_WR * TX_C->dq_p2s_ratio  ; 
      TX_R->TX_DQ_UI_OE[rank_id][byte_id] = TX_dq_latency_ps[rank_id][byte_id] / TX_C->dq_ui_unit - A_div_B_RU(TX_C->OE_pre_margin, TX_C->dq_ui_unit) + TX_C->DBI_WR * TX_C->dq_p2s_ratio + (TX_C->DRAMOBF_EN * (TX_C->DRAMOBF_PIPE_NO-1)) * TX_C->dq_p2s_ratio- 1 ; // -1 for DQ/DQM SKEW, see more in ASVA_6_1
      //compensate TX_DQ_UI - (DRAMOBF_PIPE_NO-1)

      if(PCDDR4_EN_S && (DUT_p.DEF_DDR4_LP4_EN_TBA == 1)){
       TX_R->TX_DQ_UI_OE[rank_id][byte_id] = (ch_id == 1) ? TX_R->TX_DQ_UI_OE[rank_id][byte_id]+4 : TX_R->TX_DQ_UI_OE[rank_id][byte_id];
      }

      TX_R->TX_DQS_UI[rank_id][byte_id] = TX_C->WL[rank_id] * 2 * TX_C->CKR - TX_C->dq_p2s_ratio + TX_C->TDQSS[rank_id][byte_id] / TX_C->dq_ui_unit + TX_C->ca_default_dly /*+ TX_C->ca_default_pi / TX_C->ui2pi_ratio */ + TX_C->cs2WL_start * TX_C->CKR - TX_C->dqs_default_dly - TX_C->dly_1T_by_FDIV2 * TX_C->dq_p2s_ratio - TX_C->TWPRE + (TX_C->DRAMOBF_EN * TX_C->impact_latency_for_dramobf * TX_C->dq_p2s_ratio) ; //+1 for TX CA central align --LP5 CA width only 1UI so for central align should shift 1/2 MCKIO
      if(PCDDR4_EN_S && (DUT_p.DEF_DDR4_LP4_EN_TBA == 1)){
        TX_R->TX_DQS_UI[rank_id][byte_id] = (ch_id == 1) ? TX_R->TX_DQS_UI[rank_id][byte_id]+4 : TX_R->TX_DQS_UI[rank_id][byte_id];
      }

      if ((LPDDR4_EN_S) && (DUT_p.BYPASS_TX_PIPE_MODE == 2/*NEW modoe*/)) {
        TX_R->TX_DQS_UI[rank_id][byte_id] = TX_R->TX_DQS_UI[rank_id][byte_id] - TX_C->dq_p2s_ratio;
        mcSHOW_ERR_MSG("[calculate_TX_path_rg_val] DEBUG_INFO::TX_DQS_UI decreased for LP4 BYPASS_TX_PIPE_MODE == 2 (NEW mode). \n");
      }

      //TX_R->TX_DQS_UI_OE[rank_id][byte_id] = TX_R->TX_DQS_UI[rank_id][byte_id] - TX_DQS_UI_OE_pre ;
      if (PCDDR3_EN_S || PCDDR4_EN_S)
      {
        TX_R->TX_DQS_PI[rank_id][byte_id] = TX_C->TDQSS[rank_id][byte_id] * 32 / TX_C->dq_ui_unit;
      }
      else 
      {
        switch (DUT_shu_p[group_id].WCK_PI_RANK_DIFF) {
          case 0: TX_R->TX_DQS_PI[rank_id][byte_id] = 0;                       break;
          case 1: TX_R->TX_DQS_PI[rank_id][byte_id] = (rank_id == 0) ? 1 : 0;  break;
          case 2: TX_R->TX_DQS_PI[rank_id][byte_id] = (rank_id == 1) ? 1 : 0;  break;
          case 3: TX_R->TX_DQS_PI[rank_id][byte_id] = (rank_id + 1);           break;
        }
      }
      TX_R->TX_DQS_UI_OE[rank_id][byte_id] = TX_R->TX_DQS_UI[rank_id][byte_id] - A_div_B_RU(TX_C->OE_pre_margin, TX_C->dq_ui_unit) ;

      if ((TX_R->TX_DQ_UI_OE[rank_id][byte_id] &1) == 1 )
	TX_R->TX_DQ_UI_OE[rank_id][byte_id] = TX_R->TX_DQ_UI_OE[rank_id][byte_id] - 1 ; // for downgrade,
      else
	TX_R->TX_DQ_UI_OE[rank_id][byte_id] = TX_R->TX_DQ_UI_OE[rank_id][byte_id] - 2 ; // for downgrade, and add margin
      if ((TX_R->TX_DQS_UI_OE[rank_id][byte_id] &1) == 1 )
	TX_R->TX_DQS_UI_OE[rank_id][byte_id] = TX_R->TX_DQS_UI_OE[rank_id][byte_id] - 1 ; // for downgrade,
      else
	TX_R->TX_DQS_UI_OE[rank_id][byte_id] = TX_R->TX_DQS_UI_OE[rank_id][byte_id] - 2 ; // for downgrade, and add margin
      
#if SA_CONFIG_EN /* cc mp */
    TX_R->TX_DQ_UI_OE[rank_id][byte_id] = (TX_R->TX_DQ_UI[rank_id][byte_id] > 6) ? (TX_R->TX_DQ_UI[rank_id][byte_id] - 6) : 0;
    TX_R->TX_DQS_UI_OE[rank_id][byte_id] = (TX_R->TX_DQS_UI[rank_id][byte_id] > 6) ? (TX_R->TX_DQS_UI[rank_id][byte_id] - 6) :  0;
#endif
      TX_R->TX_DQ_MCK[rank_id][byte_id]     = TX_R->TX_DQ_UI[rank_id][byte_id]	   / TX_C->dq_p2s_ratio;
      TX_R->TX_DQ_UI_ORIG[rank_id][byte_id] = TX_R->TX_DQ_UI[rank_id][byte_id];
      TX_R->TX_DQ_PI_ORIG[rank_id][byte_id] = TX_R->TX_DQ_PI[rank_id][byte_id];
      TX_R->TX_DQ_UIPI_all[rank_id][byte_id] = TX_R->TX_DQ_PI[rank_id][byte_id] + TX_R->TX_DQ_UI[rank_id][byte_id] * 32 * (LPDDR5_EN_S ? 1 :0);
      TX_R->TX_DQ_UI[rank_id][byte_id]      = TX_R->TX_DQ_UI[rank_id][byte_id]     - TX_R->TX_DQ_MCK[rank_id][byte_id]     * TX_C->dq_p2s_ratio ;
      TX_R->TX_DQS_MCK[rank_id][byte_id]    = TX_R->TX_DQS_UI[rank_id][byte_id]    / TX_C->dq_p2s_ratio;
      TX_R->TX_DQS_UI[rank_id][byte_id]     = TX_R->TX_DQS_UI[rank_id][byte_id]    - TX_R->TX_DQS_MCK[rank_id][byte_id]    * TX_C->dq_p2s_ratio;
      TX_R->TX_DQ_MCK_OE[rank_id][byte_id]  = TX_R->TX_DQ_UI_OE[rank_id][byte_id]  / TX_C->dq_p2s_ratio;
      TX_R->TX_DQ_UI_OE[rank_id][byte_id]   = TX_R->TX_DQ_UI_OE[rank_id][byte_id]  - TX_R->TX_DQ_MCK_OE[rank_id][byte_id]  * TX_C->dq_p2s_ratio;
      TX_R->TX_DQS_MCK_OE[rank_id][byte_id] = TX_R->TX_DQS_UI_OE[rank_id][byte_id] / TX_C->dq_p2s_ratio;
      TX_R->TX_DQS_UI_OE[rank_id][byte_id]  = TX_R->TX_DQS_UI_OE[rank_id][byte_id] - TX_R->TX_DQS_MCK_OE[rank_id][byte_id] * TX_C->dq_p2s_ratio;
      //TODO temp for LP5_TX_ECC
      if (LPDDR5_EN_S ) //sync from freq_related_vseq.sv
      {
	if	(TX_C->TX_ECC & (TX_C->dq_p2s_ratio == 8))  TX_R->TX_DQS_MCK[rank_id][byte_id]    = TX_R->TX_DQ_MCK[rank_id][byte_id] - 2;
	else if (TX_C->TX_ECC & (TX_C->dq_p2s_ratio == 16)) TX_R->TX_DQS_MCK[rank_id][byte_id]    = TX_R->TX_DQ_MCK[rank_id][byte_id] - 1;
	else                                                TX_R->TX_DQS_MCK[rank_id][byte_id]    = TX_R->TX_DQ_MCK[rank_id][byte_id];

	TX_R->TX_DQS_UI[rank_id][byte_id]     = TX_R->TX_DQ_UI[rank_id][byte_id];
	TX_R->TX_DQS_MCK_OE[rank_id][byte_id] = TX_R->TX_DQ_MCK_OE[rank_id][byte_id];
      	TX_R->TX_DQS_UI_OE[rank_id][byte_id]  = TX_R->TX_DQ_UI_OE[rank_id][byte_id] ;
      }

      // For DQS dline 
      if((DUT_p.TX_DQ_Dline_EN == 1) && (LPDDR4_EN_S)){
        mcSHOW_DBG_MSG("Warning: calculate TX_DQS_UI, TX_DQS_UI is %0d, rank_id=%0d, byte_id==%0d\n", TX_R->TX_DQS_UI[rank_id][byte_id], rank_id, byte_id);
        mcSHOW_DBG_MSG("Warning: calculate TX_DQS_UI_OE, TX_DQS_UI_OE is %0d, rank_id=%0d, byte_id==%0d\n", TX_R->TX_DQS_UI_OE[rank_id][byte_id], rank_id, byte_id);
        if(TX_R->TX_DQS_UI[rank_id][byte_id] == 0){
           TX_R->TX_DQS_MCK[rank_id][byte_id] = TX_R->TX_DQ_MCK[rank_id][byte_id] - 1;
           TX_R->TX_DQS_UI[rank_id][byte_id]  = TX_R->TX_DQS_UI[rank_id][byte_id] + TX_C->dq_p2s_ratio;
        }
        if(TX_R->TX_DQS_UI_OE[rank_id][byte_id] == 0){
           TX_R->TX_DQS_MCK_OE[rank_id][byte_id] = TX_R->TX_DQ_MCK_OE[rank_id][byte_id] - 1;
           TX_R->TX_DQS_UI_OE[rank_id][byte_id]  = TX_R->TX_DQS_UI_OE[rank_id][byte_id] + TX_C->dq_p2s_ratio;
        }
        TX_R->TX_DQS_UI[rank_id][byte_id]     = TX_R->TX_DQS_UI[rank_id][byte_id]    - 1; //reserve 1 UI for tx dline
        //TX_R->TX_DQS_UI_OE[rank_id][byte_id]  = TX_R->TX_DQS_UI_OE[rank_id][byte_id] - 1; //reserve 1 UI for tx dline
        mcSHOW_DBG_MSG("Warning: calculate_0 TX_DQS_PI, TX_DQS_PI is %0d, rank_id=%0d, byte_id==%0d \n", TX_R->TX_DQS_PI[rank_id][byte_id], rank_id, byte_id);
        TX_R->TX_DQS_PI[rank_id][byte_id]    = ((TX_C->dq_ui_unit - (TX_C->TX_DQ_Dline>>2 )*tx_dly_line_unit)*TX_C->ui2pi_ratio) / TX_C->dq_ui_unit;
        mcSHOW_DBG_MSG("Warning: calculate_1 TX_DQS_PI, TX_DQS_PI is %0d, rank_id=%0d, byte_id==%0d \n", TX_R->TX_DQS_PI[rank_id][byte_id], rank_id, byte_id);
        if(rank_id == 1) {
         TX_R->TX_DQS_PI[rank_id][byte_id]   =  TX_R->TX_DQS_PI[rank_id][byte_id] + 1;
        }
        mcSHOW_DBG_MSG("Warning: calculate_1 TX_DQS_PI, TX_DQS_PI is %0d, rank_id=%0d, byte_id==%0d \n", TX_R->TX_DQS_PI[rank_id][byte_id], rank_id, byte_id);

        if (TX_C->close_loop_mode == 0) //open mode and semi open mode, PI can only set 0, 8, 16, 24
        {
        if      (TX_R->TX_DQS_PI[rank_id][byte_id] < 4  ) TX_R->TX_DQS_PI[rank_id][byte_id] = 0  ;
        else if (TX_R->TX_DQS_PI[rank_id][byte_id] < 12 ) TX_R->TX_DQS_PI[rank_id][byte_id] = 8  ;
        else if (TX_R->TX_DQS_PI[rank_id][byte_id] < 20 ) TX_R->TX_DQS_PI[rank_id][byte_id] = 16 ;
        else if (TX_R->TX_DQS_PI[rank_id][byte_id] < 28 ) TX_R->TX_DQS_PI[rank_id][byte_id] = 24 ;
        else    {TX_R->TX_DQS_PI[rank_id][byte_id] = 0;   TX_R->TX_DQS_UI[rank_id][byte_id] = TX_R->TX_DQS_UI[rank_id][byte_id] +1;}
        }
        
        //TX_R->TX_DQS_PI_OE[rank_id][byte_id]  = (TX_C->dq_ui_unit - (TX_C->TX_DQ_Dline>>2 )*tx_dly_line_unit)/(dq_ui_unit/32); //reserve 1 UI for tx dline
        mcSHOW_DBG_MSG("Warning: calculate TX_DQS_UI, TX_DQS_UI is %0d, rank_id=%0d, byte_id==%0d\n", TX_R->TX_DQS_UI[rank_id][byte_id], rank_id, byte_id);
        mcSHOW_DBG_MSG("Warning: calculate TX_DQS_UI_OE, TX_DQS_UI_OE is %0d, rank_id=%0d, byte_id==%0d\n", TX_R->TX_DQS_UI_OE[rank_id][byte_id], rank_id, byte_id);

        //TX_R->TX_DQS_Dline[rank_id][byte_id]     = TX_R->TX_DQ_UI[rank_id][byte_id]-1;
      }
      //if(LPDDR5_EN_S){
      //    TX_R->TX_DQS_PI[rank_id][byte_id] = 0;
      //}
    } //for byte_id=0 byte_id<2
  } //for rank_id=0; rank_id<2

  // update PI setting for SEMI_OPEN mode not support Rank diff@ Lepin.
  for(rank_id = 0; rank_id < 2; rank_id ++){
    for(byte_id = 0; byte_id < 2; byte_id ++){
      //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_UI_mini is %0d\n", TX_DQ_UI_mini);
      if(TX_DQ_UI_mini > TX_R->TX_DQ_UI[rank_id][byte_id]){
        TX_DQ_UI_mini  = TX_R->TX_DQ_UI[rank_id][byte_id];
      }
      //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_UI_mini is %0d\n", TX_DQ_UI_mini);
      //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_PI_mini,  is %0h\n", TX_DQ_PI_mini);
      if( TX_C->TDQS2DQ_skew[rank_id][byte_id] == 0){
//        TDQS2DQ_skew_min = TX_C->TDQS2DQ_skew[rank_id][byte_id];
        TX_DQ_PI_mini  = TX_R->TX_DQ_PI[rank_id][byte_id];
      }
      //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_PI_mini,  is %0d\n", TX_DQ_PI_mini);
    }
  }
  if(TX_C->semi_open_loop_mode == 1 && LPDDR5_EN_S/*&& TX_C->data_ratio == 1866*/ )
  {
    for(rank_id = 0; rank_id < 2; rank_id ++){
     for(byte_id = 0; byte_id < 2; byte_id ++){
      if((TX_R->TX_DQ_PI[rank_id][byte_id] > TX_DQ_PI_mini) && (TX_R->TX_DQ_UI[rank_id][byte_id] <= TX_DQ_UI_mini) ){
	TX_R->TX_DQ_UIPI_all[rank_id][byte_id] = TX_R->TX_DQ_UIPI_all[rank_id][byte_id] - TX_R->TX_DQ_PI[rank_id][byte_id] + TX_DQ_PI_mini;
        TX_R->TX_DQ_PI[rank_id][byte_id] = TX_DQ_PI_mini ;
        TX_R->TX_DQ_dlyline[rank_id][byte_id] = TX_R->TX_DQ_dlyline[rank_id][byte_id] + (TX_C->TDQS2DQ_skew[rank_id][byte_id] / tx_dly_line_unit)*4;
	if(TX_R->TX_DQ_dlyline[rank_id][byte_id] > 255){ TX_R->TX_DQ_dlyline[rank_id][byte_id] =255; }
      }
      else if((TX_R->TX_DQ_PI[rank_id][byte_id] > TX_DQ_PI_mini) && (TX_R->TX_DQ_UI[rank_id][byte_id] > TX_DQ_UI_mini)){
	TX_R->TX_DQ_UIPI_all[rank_id][byte_id] = TX_R->TX_DQ_UIPI_all[rank_id][byte_id] - TX_R->TX_DQ_PI[rank_id][byte_id] + TX_DQ_PI_mini;
        TX_R->TX_DQ_PI[rank_id][byte_id] = TX_DQ_PI_mini ;
	TX_R->TX_DQ_dlyline[rank_id][byte_id] = TX_R->TX_DQ_dlyline[rank_id][byte_id] + ((TX_R->TX_DQ_PI[rank_id][byte_id]- TX_DQ_PI_mini)*(TX_C->dq_ui_unit/TX_C->ui2pi_ratio)/ tx_dly_line_unit)*4;
	if(TX_R->TX_DQ_dlyline[rank_id][byte_id] > 255){ TX_R->TX_DQ_dlyline[rank_id][byte_id]=255; }
      }
      else if((TX_R->TX_DQ_PI[rank_id][byte_id] < TX_DQ_PI_mini) && (TX_DQ_PI_mini < 65535) ){
        if(TX_R->TX_DQ_UI[rank_id][byte_id] > 0){
          TX_R->TX_DQ_UI[rank_id][byte_id]  = TX_R->TX_DQ_UI[rank_id][byte_id] -1;
	  TX_R->TX_DQS_UI[rank_id][byte_id] = TX_R->TX_DQS_UI[rank_id][byte_id] -1;
	  TX_R->TX_DQ_UIPI_all[rank_id][byte_id] = TX_R->TX_DQ_UIPI_all[rank_id][byte_id] - 1*32; 
	  TX_R->TX_DQ_UIPI_all[rank_id][byte_id] = TX_R->TX_DQ_UIPI_all[rank_id][byte_id] + ((TX_DQ_PI_mini - TX_R->TX_DQ_PI[rank_id][byte_id])); 
        }
        TX_R->TX_DQ_PI[rank_id][byte_id] = TX_DQ_PI_mini ;
        TX_R->TX_DQ_dlyline[rank_id][byte_id] = TX_R->TX_DQ_dlyline[rank_id][byte_id] + (TX_C->TDQS2DQ_skew[rank_id][byte_id] / tx_dly_line_unit)*4;
        if(TX_R->TX_DQ_dlyline[rank_id][byte_id] > 255){ TX_R->TX_DQ_dlyline[rank_id][byte_id] =255; }
      }
     }
    }
    //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_PI_mini,  is %0h\n", TX_DQ_PI_mini);
    //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_UI is %0d\n", TX_R->TX_DQ_UI[rank_id][byte_id]);
    //mcSHOW_DBG_MSG("Warning: june_debug TDQS2DQ_skew_mini,  is %0h\n", TDQS2DQ_skew_min);
  }

  for(rank_id = 0; rank_id < 2; rank_id ++){
    for(byte_id = 0; byte_id < 2; byte_id ++){
      //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_UI_mini is %0d\n", TX_DQ_UI_mini);
      if(TX_DQ_UI_mini > TX_R->TX_DQ_UI[rank_id][byte_id]){
        TX_DQ_UI_mini  = TX_R->TX_DQ_UI[rank_id][byte_id];
      }
      //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_UI_mini is %0d\n", TX_DQ_UI_mini);

      //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_PI_mini,  is %0h\n", TX_DQ_PI_mini);
      if( TX_C->TDQS2DQ_skew[rank_id][byte_id] == 0){
//        TDQS2DQ_skew_min = TX_C->TDQS2DQ_skew[rank_id][byte_id];
        TX_DQ_PI_mini  = TX_R->TX_DQ_PI[rank_id][byte_id];
      }
      //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_PI_mini,  is %0d\n", TX_DQ_PI_mini);
    }
  }
  if(TX_C->semi_open_loop_mode == 1 && LPDDR5_EN_S/*&& TX_C->data_ratio == 1866*/ )
  {
    for(rank_id = 0; rank_id < 2; rank_id ++){
     for(byte_id = 0; byte_id < 2; byte_id ++){
      if((TX_R->TX_DQ_PI[rank_id][byte_id] > TX_DQ_PI_mini) && (TX_R->TX_DQ_UI[rank_id][byte_id] <= TX_DQ_UI_mini) ){
	TX_R->TX_DQ_UIPI_all[rank_id][byte_id] = TX_R->TX_DQ_UIPI_all[rank_id][byte_id] - TX_R->TX_DQ_PI[rank_id][byte_id] + TX_DQ_PI_mini;
        TX_R->TX_DQ_PI[rank_id][byte_id] = TX_DQ_PI_mini ;
        TX_R->TX_DQ_dlyline[rank_id][byte_id] = TX_R->TX_DQ_dlyline[rank_id][byte_id] + (TX_C->TDQS2DQ_skew[rank_id][byte_id] / tx_dly_line_unit)*4;
	if(TX_R->TX_DQ_dlyline[rank_id][byte_id] > 255){ TX_R->TX_DQ_dlyline[rank_id][byte_id] =255; }
      }
      else if((TX_R->TX_DQ_PI[rank_id][byte_id] > TX_DQ_PI_mini) && (TX_R->TX_DQ_UI[rank_id][byte_id] > TX_DQ_UI_mini)){
	TX_R->TX_DQ_UIPI_all[rank_id][byte_id] = TX_R->TX_DQ_UIPI_all[rank_id][byte_id] - TX_R->TX_DQ_PI[rank_id][byte_id] + TX_DQ_PI_mini;
        TX_R->TX_DQ_PI[rank_id][byte_id] = TX_DQ_PI_mini ;
	TX_R->TX_DQ_dlyline[rank_id][byte_id] = TX_R->TX_DQ_dlyline[rank_id][byte_id] + ((TX_R->TX_DQ_PI[rank_id][byte_id]- TX_DQ_PI_mini)*(TX_C->dq_ui_unit/TX_C->ui2pi_ratio)/ tx_dly_line_unit)*4;
	if(TX_R->TX_DQ_dlyline[rank_id][byte_id] > 255){ TX_R->TX_DQ_dlyline[rank_id][byte_id]=255; }
      }
      else if((TX_R->TX_DQ_PI[rank_id][byte_id] < TX_DQ_PI_mini) && (TX_DQ_PI_mini < 65535) ){
        if(TX_R->TX_DQ_UI[rank_id][byte_id] > 0){
          TX_R->TX_DQ_UI[rank_id][byte_id] = TX_R->TX_DQ_UI[rank_id][byte_id] -1;
	  TX_R->TX_DQ_UIPI_all[rank_id][byte_id] = TX_R->TX_DQ_UIPI_all[rank_id][byte_id] - 1*32; 
	  TX_R->TX_DQ_UIPI_all[rank_id][byte_id] = TX_R->TX_DQ_UIPI_all[rank_id][byte_id] + ((TX_DQ_PI_mini - TX_R->TX_DQ_PI[rank_id][byte_id])); 
        }
        TX_R->TX_DQ_PI[rank_id][byte_id] = TX_DQ_PI_mini ;
        TX_R->TX_DQ_dlyline[rank_id][byte_id] = TX_R->TX_DQ_dlyline[rank_id][byte_id] + (TX_C->TDQS2DQ_skew[rank_id][byte_id] / tx_dly_line_unit)*4;
        if(TX_R->TX_DQ_dlyline[rank_id][byte_id] > 255){ TX_R->TX_DQ_dlyline[rank_id][byte_id] =255; }
      }
     }
    }
    //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_PI_mini,  is %0h\n", TX_DQ_PI_mini);
    //mcSHOW_DBG_MSG("Warning: june_debug TX_DQ_UI is %0d\n", TX_R->TX_DQ_UI[rank_id][byte_id]);
    //mcSHOW_DBG_MSG("Warning: june_debug TDQS2DQ_skew_mini,  is %0h\n", TDQS2DQ_skew_min);
  }

  // dqs oe and dq PICG related RG setting
//  TX_DQ_MCK_RK0_min    = MIN2(TX_R->TX_DQ_MCK[0][0], TX_R->TX_DQ_MCK[0][1]);
//  TX_DQ_MCK_RK1_min    = MIN2(TX_R->TX_DQ_MCK[1][0], TX_R->TX_DQ_MCK[1][1]);
//  TX_DQ_UI_RK0_min     = MIN2(TX_R->TX_DQ_UI[0][0],  TX_R->TX_DQ_UI[0][1] );
//  TX_DQ_UI_RK1_min     = MIN2(TX_R->TX_DQ_UI[1][0],  TX_R->TX_DQ_UI[1][1] );
  TX_DQ_OE_MCK_RK0_min = MIN2(TX_R->TX_DQ_MCK_OE[0][0], TX_R->TX_DQ_MCK_OE[0][1]);
  TX_DQ_OE_MCK_RK1_min = MIN2(TX_R->TX_DQ_MCK_OE[1][0], TX_R->TX_DQ_MCK_OE[1][1]);
  TX_DQ_OE_UI_RK0_min  = MIN2(TX_R->TX_DQ_UI_OE[0][0],  TX_R->TX_DQ_UI_OE[0][1] );
  TX_DQ_OE_UI_RK1_min  = MIN2(TX_R->TX_DQ_UI_OE[1][0],  TX_R->TX_DQ_UI_OE[1][1] );

  TX_R->DDRPHY_CLK_EN_COMB_TX_OPT = TX_C->DDRPHY_CLK_EN_COMB_TX_OPT;
  if (TX_R->DDRPHY_CLK_EN_COMB_TX_OPT == 0)
  {
    TX_R->DDRPHY_CLK_EN_COMB_TX_PICG_CNT      = 0 ;
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0    = 0 ;
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1    = 0 ;
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P0 = 0 ;
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P1 = 0 ;
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P0 = 0 ;
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P1 = 0 ;
    TX_R->DPHY_TX_DCM_EXTCNT                  = 0 ;
  }
  else
  {
    TX_R->DDRPHY_CLK_EN_COMB_TX_PICG_CNT      = 2 + (TX_C->fake_mode == 1) + ((A_D->DQ_P2S_RATIO==4) && (PCDDR3_EN_S || PCDDR4_EN_S));
    //when fake mode, TXD will be extend 1T but not use in APHY //for DDR3/4 ASVA_4_3, PST 5T when dq_p2s_ratio is 4 , fake mode should be 0 when DDR3/4
    TX_R->DPHY_TX_DCM_EXTCNT                  = 0 ;
    //dqs OE /dq CG related rg
    dqs_oe_def_ui_dly_p0 = (TX_C->dq_p2s_ratio ==16) ? 8 : (TX_C->dq_p2s_ratio ==8) ? 6 : 2; //get for DUT 
    dqs_oe_def_ui_dly_p1 = (TX_C->dq_p2s_ratio ==16) ? 8 : (TX_C->dq_p2s_ratio ==8) ? 2 : 0;
    if ((TX_R->TX_DQS_MCK_OE[0][0] < (ASVA_PICG_SPEC - TX_C->dq_p2s_ratio ==4)) & (TX_R->TX_DQS_UI_OE[0][0] < ( TX_C->dq_p2s_ratio ==8 - dqs_oe_def_ui_dly_p0) ))  
    {
	mcSHOW_DBG_MSG("ERROR: TX_DQS_MCK_OE and TX_DQS_UI_OE don't suit this algorithm"); //make sure the rg val >=0
    }
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0 = TX_R->TX_DQS_MCK_OE[0][0] + 1 + (TX_C->dq_p2s_ratio==4) + ((TX_R->TX_DQS_UI_OE[0][0] >= (U32)(TX_C->dq_p2s_ratio - dqs_oe_def_ui_dly_p0)) ? 1 : 0) - ASVA_PICG_SPEC; //see more in PICG_introduction.pptx by York or TX_path_item.vsdx by jianbo
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1 = TX_R->TX_DQS_MCK_OE[0][0] + 1 + (TX_C->dq_p2s_ratio==4) + ((TX_R->TX_DQS_UI_OE[0][0] >= (U32)(TX_C->dq_p2s_ratio - dqs_oe_def_ui_dly_p1)) ? 1 : 0) - (ASVA_PICG_SPEC - 1); //see more in PICG_introduction.pptx by York or TX_path_item.vsdx by jianbo
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P0 = TX_DQ_OE_MCK_RK0_min + 1 + 1 - ASVA_PICG_SPEC + (TX_C->dq_p2s_ratio==4) ; //+1 for dpy_tx_dcm_b* start early 1T than dq_oe TXD
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P1 = TX_DQ_OE_MCK_RK0_min + 1 + 1 - ASVA_PICG_SPEC + (TX_C->dq_p2s_ratio==4) + ((TX_DQ_OE_UI_RK0_min >= (TX_C->dq_p2s_ratio /2)) ? 1 : 0) ;  //see mode in TX_path_item.vsdx by jianbo
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P0 = TX_DQ_OE_MCK_RK1_min + 1 + 1 - ASVA_PICG_SPEC + (TX_C->dq_p2s_ratio==4) ; // DQ OE PICG before 2T                 
    TX_R->DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P1 = TX_DQ_OE_MCK_RK1_min + 1 + 1 - ASVA_PICG_SPEC + (TX_C->dq_p2s_ratio==4) + ((TX_DQ_OE_UI_RK1_min >= (TX_C->dq_p2s_ratio /2)) ? 1 : 0) ;  //see mode in TX_path_item.vsdx by jianbo

    if (TX_C->dq_p2s_ratio ==4)
    {
      TX_R->DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1 = 0 ;
      TX_R->DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P1 = 0;
      TX_R->DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P1 = 0;
    }

  } //TX_R->DDRPHY_CLK_EN_COMB_TX_OPT 

  //rank_sel relate rg setting
  TX_DQ_OE_MCK_MAX = MAX2(MAX2(MAX2(TX_R->TX_DQ_MCK_OE[0][0],TX_R->TX_DQ_MCK_OE[0][1]), TX_R->TX_DQ_MCK_OE[1][0]), TX_R->TX_DQ_MCK_OE[1][1]);
  if (TX_C->NEW_RANK_MODE == 1)
  {
    TX_R->TX_PI_UPD_MODE = 0;
    if (MIN2(TX_R->TX_DQ_MCK_OE[0][0],TX_R->TX_DQ_MCK_OE[1][0]) > 0)
      TX_R->TX_PI_UPDCTL_B0 = MIN2(TX_R->TX_DQ_MCK_OE[0][0],TX_R->TX_DQ_MCK_OE[1][0]) - ((TX_C->dq_p2s_ratio==8)?1:0);
    else 
      TX_R->TX_PI_UPDCTL_B0 = 0 ;
    if (MIN2(TX_R->TX_DQ_MCK_OE[0][1],TX_R->TX_DQ_MCK_OE[1][1]) > 0)
      TX_R->TX_PI_UPDCTL_B1 = MIN2(TX_R->TX_DQ_MCK_OE[0][1],TX_R->TX_DQ_MCK_OE[1][1]) - ((TX_C->dq_p2s_ratio==8)?1:0);
    else
      TX_R->TX_PI_UPDCTL_B1 = 0 ;
    //if (TX_C->dq_p2s_ratio == 8) //see more in TX_path_item.vsdx by jianbo 
    //{
    //  TX_R->TX_PI_UPDCTL_B0 = MIN2(TX_R->TX_DQ_MCK_OE[0][0],TX_R->TX_DQ_MCK_OE[1][0]);
    //  TX_R->TX_PI_UPDCTL_B1 = MIN2(TX_R->TX_DQ_MCK_OE[0][1],TX_R->TX_DQ_MCK_OE[1][1]);
    //} else if (TX_C->dq_p2s_ratio == 4)
    //{
    //  TX_R->TX_PI_UPDCTL_B0 = MIN2(TX_R->TX_DQ_MCK_OE[0][0],TX_R->TX_DQ_MCK_OE[1][0]) - 1;
    //  TX_R->TX_PI_UPDCTL_B1 = MIN2(TX_R->TX_DQ_MCK_OE[0][1],TX_R->TX_DQ_MCK_OE[1][1]) - 1;
    //} else 
    //{
    //  //TODO
    //  mcSHOW_DBG_MSG("Warning: do not support dq_p2s_ratio is %0d\n", TX_C->dq_p2s_ratio);
    //}
    if (TX_C->DRAMOBF_EN) {
      //TX_R->TX_RANKINCTL_ROOT = TX_C->impact_latency_for_dramobf;
      //TX_R->TX_RANKINCTL_ROOT = TX_C->DRAMOBF_PIPE_NO-1 ; //[1015-112426]
      TX_R->TX_RANKINCTL_ROOT = 0 ;
    } else {
      TX_R->TX_RANKINCTL_ROOT = 0 ;
    }

    //TX_R->TX_RANKINCTL  = ((MAX2(TX_R->TX_PI_UPDCTL_B0, TX_R->TX_PI_UPDCTL_B1)) == 0) ? 0 : ((MAX2(TX_R->TX_PI_UPDCTL_B0, TX_R->TX_PI_UPDCTL_B1)) -1);
    if (TX_C->dq_p2s_ratio == 16) {
      if (TX_DQ_OE_MCK_MAX >= 1) 
        TX_R->TX_RANKINCTL = TX_DQ_OE_MCK_MAX - 1 ;
      else  //prevent underflow
        TX_R->TX_RANKINCTL = 0 ; 
    } else {
      if (TX_DQ_OE_MCK_MAX >= 2) 
        TX_R->TX_RANKINCTL = TX_DQ_OE_MCK_MAX - 2 ;
      else  //prevent underflow
        TX_R->TX_RANKINCTL = 0 ; 
    }
    if ((TX_C->data_ratio ==1866) && LPDDR5_EN_S)
    {
        TX_R->TX_RANKINCTL       = 1;//TODO,for LePin LP5-1866,TX DQ PI cross rank 
    }
    TX_R->TX_RANKINCTL_TXDLY = TX_R->TX_RANKINCTL;
    //TX_R->TX_RANKINCTL = (TX_PI_UPDCTL < ASVA_PICHG_FROMTXD) ? ASVA_PICHG_FROMTXD : (TX_PI_UPDCTL - ASVA_PICHG_FROMTXD);
    //TX_R->TX_RANKINCTL_TXDLY = (TX_PI_UPDCTL < ASVA_DLINECHANG_FROMTXD) ? ASVA_DLINECHANG_FROMTXD : (TX_PI_UPDCTL - ASVA_DLINECHANG_FROMTXD);
  }
  else //NEW_RANK_MODE == 0
  {
    TX_R->TX_PI_UPD_MODE = 1;
    TX_R->TX_PI_UPDCTL_B0 = 0;
    TX_R->TX_PI_UPDCTL_B1 = 0;
    TX_R->TX_RANKINCTL_ROOT  = 0 ;
    if (TX_C->data_ratio >=3733)
      TX_R->TX_RANKINCTL_ROOT  = 1 ;
    if (TX_C->dq_p2s_ratio == 4)
    {
      TX_R->TX_RANKINCTL       = 1;
      TX_R->TX_RANKINCTL_TXDLY = 2;
    } else if (TX_C->dq_p2s_ratio == 8)
    {
      if (TX_C->data_ratio <= 1600 )
      {
        TX_R->TX_RANKINCTL       = 0;
        TX_R->TX_RANKINCTL_TXDLY = 1;
      } else if (TX_C->data_ratio <= 3733)
      {
        TX_R->TX_RANKINCTL       = 1;
        TX_R->TX_RANKINCTL_TXDLY = 2;
      } else if (TX_C->data_ratio <= 4266)
      {
        TX_R->TX_RANKINCTL       = 2;
        TX_R->TX_RANKINCTL_TXDLY = 3;
      } else 
      { mcSHOW_DBG_MSG("Warning: do not support data_ratio is %0d", TX_C->data_ratio); }
    }
  }
  //rank_sel related rg setting done
  if (TX_C->dq_p2s_ratio == 4)
    TX_R->DDRPHY_CLK_DYN_GATING_SEL = TX_C->TXP_WORKAROUND_OPT ? 7 : 6;
  else
    TX_R->DDRPHY_CLK_DYN_GATING_SEL = 5;
  TX_R->DDRPHY_CLK_EN_OPT = 1;
  TX_R->ARPI_CMD = TX_C->ca_default_pi;//tIH
  if (TX_C->close_loop_mode == 0) {
    if ((TX_C->semi_open_loop_mode == 1) && (LPDDR4_EN_S==1)) {
      TX_R->ARPI_CMD = 0;
    } else {
      TX_R->ARPI_CMD = TX_C->ca_frate ? 24 : 16; //TODO template, LP5 800 set 24, LP4 400 and 800 set 16
    }
  }
  if ((TX_C->data_ratio == 400 ) && (LPDDR4_EN_S))
  {
    TX_R->ARPI_CMD = 0;
  }
  if ((TX_C->data_ratio == 2133 ) && (LPDDR5_EN_S))
  {
    TX_R->ARPI_CMD = 24; //IPM2.4 LP5-2133 is close mode,but its CA is semi mode.
  }  
  TX_R->TDMY =MAX2(( TX_DQ_OE_MCK_MAX + 7), TX_C->XRTW2W_PI_mute_time);
  
  if (LPDDR5_EN_S) //sync from test_sa.c
    {
      TX_R->TXOEN_AUTOSET_DQ_OFFSET  = 5;
      TX_R->TXOEN_AUTOSET_DQS_OFFSET = (TX_C->data_ratio <= 4266) ? 1 : ((TX_C->data_ratio == 8533) ? 3 : 2);
    }
  else if (DUT_p.DEF_DDR34_1C32B_EN_TBA || DUT_p.DEF_DDR34_1C16B_EN) 
    {
      TX_R->TXOEN_AUTOSET_DQ_OFFSET  = 6;
      TX_R->TXOEN_AUTOSET_DQS_OFFSET = 6;
    }
  else 
    {
      TX_R->TXOEN_AUTOSET_DQ_OFFSET  = 3;
      TX_R->TXOEN_AUTOSET_DQS_OFFSET = (TX_C->dq_p2s_ratio == 4) ? 4 : 3;
    }
#if SA_CONFIG_EN
#if TX_OE_AUTO_SET_EN
    TX_R->TXOEN_AUTOSET_EN = 1;
#else
    TX_R->TXOEN_AUTOSET_EN = 0;
#endif
#if TX_PICG_AUTO_SET_MODE
    TX_R->TXPICG_AUTOSET_EN = 1;
    TX_R->TXPICG_AUTOSET_OPT = 0;
#else
    TX_R->TXPICG_AUTOSET_EN = 0;
    TX_R->TXPICG_AUTOSET_OPT = 1;
#endif
#else //!SA_CONFIG_EN
    TX_R->TXOEN_AUTOSET_EN = 1;
    TX_R->TXPICG_AUTOSET_EN = 1;
      TX_R->TXPICG_AUTOSET_OPT = 0;
#endif

  TX_R->TXPICG_DQ_MCK_OFFSET_LAG = (TX_C->dq_p2s_ratio == 4) ? 1 : 0;
  TX_R->TXPICG_DQ_UI_OFFSET_LEAD  = 0;
  TX_R->TXPICG_DQ_UI_OFFSET_LAG   = 1;
  TX_R->TXPICG_DQS_MCK_OFFSET_LAG  = (LPDDR5_EN_S) ? 0 : ((TX_C->dq_p2s_ratio == 8) ? 0 : 1);
  TX_R->TXPICG_DQS_UI_OFFSET_LEAD  = (LPDDR5_EN_S) ? 0 : ((TX_C->dq_p2s_ratio == 8) ? 1 : 0);
  TX_R->TXPICG_DQS_UI_OFFSET_LAG   = (LPDDR5_EN_S) ? 0 : ((TX_C->dq_p2s_ratio == 4) ? 1 : 0);

} //calculate_TX_path_rg_val


//=================================
void TX_PATH_config(DRAMC_CTX_T *p, TX_path_attribution_T *tr,U32 ch_id, U32 group_id)
{
  U8  rank_id; 
  U8  WCK_APHY_OE_EN              = (LPDDR5_EN_S && (DUT_shu_p[group_id].LP5_CAS_MODE == 1) && (DUT_shu_p[group_id].WCK_PI_RANK_DIFF != 0)) ? 1 : 0;
  U8  WCK_APHY_OE_CHANGE_PI_SPEC  = (LPDDR5_EN_S && (DUT_shu_p[group_id].LP5_CAS_MODE == 1) && (DUT_shu_p[group_id].WCK_PI_RANK_DIFF != 0)) ? 1 : 0;
  vSetPHY2ChannelMapping(p, ch_id);
  p->ShuRGAccessIdx = (group_id == 0) ? DRAM_DFS_REG_SHU0 : DRAM_DFS_REG_SHU1;

    //oe auto set 
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_TX_SET1), P_Fld(tr->TXOEN_AUTOSET_EN	            , SHU_TX_SET1_TXOEN_AUTOSET_EN          ) 
                                                            | P_Fld(tr->TXPICG_AUTOSET_OPT	        , SHU_TX_SET1_TXPICG_AUTOSET_OPT        ) 
                                                            | P_Fld(tr->TXPICG_AUTOSET_EN	        , SHU_TX_SET1_TXPICG_AUTOSET_EN         ) 
                                                            | P_Fld(tr->TXPICG_DQ_MCK_OFFSET_LAG     , SHU_TX_SET1_TXPICG_DQ_MCK_OFFSET_LAG  ) 
                                                            | P_Fld(tr->TXPICG_DQS_MCK_OFFSET_LAG    , SHU_TX_SET1_TXPICG_DQS_MCK_OFFSET_LAG ) 
                                                            | P_Fld(tr->TXPICG_DQ_UI_OFFSET_LEAD     , SHU_TX_SET1_TXPICG_DQ_UI_OFFSET_LEAD  ) 
                                                            | P_Fld(tr->TXPICG_DQ_UI_OFFSET_LAG      , SHU_TX_SET1_TXPICG_DQ_UI_OFFSET_LAG   ) 
                                                            | P_Fld(tr->TXPICG_DQS_UI_OFFSET_LEAD    , SHU_TX_SET1_TXPICG_DQS_UI_OFFSET_LEAD ) 
                                                            | P_Fld(tr->TXPICG_DQS_UI_OFFSET_LAG     , SHU_TX_SET1_TXPICG_DQS_UI_OFFSET_LAG  ));


    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_TX_SET2), P_Fld(tr->TXOEN_AUTOSET_DQ_OFFSET      , SHU_TX_SET2_TXOEN_AUTOSET_DQ_B0_OFFSET  ) 
                                                            | P_Fld(tr->TXOEN_AUTOSET_DQ_OFFSET      , SHU_TX_SET2_TXOEN_AUTOSET_DQ_B1_OFFSET  )
                                                            | P_Fld(tr->TXOEN_AUTOSET_DQ_OFFSET      , SHU_TX_SET2_TXOEN_AUTOSET_DQ_B2_OFFSET  )
                                                            | P_Fld(tr->TXOEN_AUTOSET_DQ_OFFSET      , SHU_TX_SET2_TXOEN_AUTOSET_DQ_B3_OFFSET  )
                                                            | P_Fld(tr->TXOEN_AUTOSET_DQS_OFFSET     , SHU_TX_SET2_TXOEN_AUTOSET_DQS_B0_OFFSET  )
                                                            | P_Fld(tr->TXOEN_AUTOSET_DQS_OFFSET     , SHU_TX_SET2_TXOEN_AUTOSET_DQS_B1_OFFSET  )
                                                            | P_Fld(tr->TXOEN_AUTOSET_DQS_OFFSET     , SHU_TX_SET2_TXOEN_AUTOSET_DQS_B2_OFFSET  )
                                                            | P_Fld(tr->TXOEN_AUTOSET_DQS_OFFSET     , SHU_TX_SET2_TXOEN_AUTOSET_DQS_B3_OFFSET  ));

    //set dqs oe PICG releate rg
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_APHY_TX_PICG_CTRL),  P_Fld(tr->DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0,	  SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0  )
                                                                        |P_Fld(tr->DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1,  	SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1)
                                                                        |P_Fld(tr->DPHY_TX_DCM_EXTCNT              ,  	SHU_APHY_TX_PICG_CTRL_DPHY_TX_DCM_EXTCNT              )
                                                                        |P_Fld(tr->DDRPHY_CLK_EN_COMB_TX_OPT       ,  	SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_OPT       )
                                                                        |P_Fld(tr->DDRPHY_CLK_EN_COMB_TX_PICG_CNT  ,  	SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_PICG_CNT  )  );
    //set rank_sel related rg
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_NEW_XRW2W_CTRL),  P_Fld(tr->TX_PI_UPD_MODE,          SHU_NEW_XRW2W_CTRL_TXPI_UPD_MODE   )  
                                                                     |P_Fld(tr->TX_PI_UPDCTL_B0,  	  SHU_NEW_XRW2W_CTRL_TX_PI_UPDCTL_B0   )  
                                                                     |P_Fld(tr->TX_PI_UPDCTL_B1,  	  SHU_NEW_XRW2W_CTRL_TX_PI_UPDCTL_B1   )  );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_TX_RANKCTL),      P_Fld(tr->TX_RANKINCTL_ROOT,	  SHU_TX_RANKCTL_TXRANKINCTL_ROOT      )  
                                                                     |P_Fld(tr->TX_RANKINCTL,    	  SHU_TX_RANKCTL_TXRANKINCTL           )  
                                                                     |P_Fld(tr->TX_RANKINCTL_TXDLY,  	  SHU_TX_RANKCTL_TXRANKINCTL_TXDLY )
                                                                     |P_Fld(WCK_APHY_OE_EN             ,SHU_TX_RANKCTL_WCK_APHY_OE_EN               )
                                                                     |P_Fld(WCK_APHY_OE_CHANGE_PI_SPEC ,SHU_TX_RANKCTL_WCK_APHY_OE_CHANGE_PI_SPEC   ));
    //
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_DCM_CTRL0),       P_Fld(tr->DDRPHY_CLK_DYN_GATING_SEL,  SHU_DCM_CTRL0_DDRPHY_CLK_DYN_GATING_SEL  )  \
                                                                     |P_Fld(tr->DDRPHY_CLK_EN_OPT,  	     SHU_DCM_CTRL0_DDRPHY_CLK_EN_OPT          )  );

    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM7),       P_Fld(tr->TDMY,  SHU_ACTIM7_TDMY  )  );

  for (rank_id = 0; rank_id <=1; rank_id++)
  {
    vSetRank(p, rank_id);
    //set TX DQ/DQ_OE/DQS MCK/UI delay
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ0),   P_Fld(tr->TX_DQ_MCK[rank_id][0],     SHURK_SELPH_DQ0_TXDLY_DQ0)      \
                                                                   |P_Fld(tr->TX_DQ_MCK[rank_id][1],     SHURK_SELPH_DQ0_TXDLY_DQ1)      \
                                                                   |P_Fld(tr->TX_DQ_MCK[rank_id][0],     SHURK_SELPH_DQ0_TXDLY_DQ2)      \
                                                                   |P_Fld(tr->TX_DQ_MCK[rank_id][1],     SHURK_SELPH_DQ0_TXDLY_DQ3)      \
                                                                   |P_Fld(tr->TX_DQ_MCK_OE[rank_id][0],  SHURK_SELPH_DQ0_TXDLY_OEN_DQ0)  \
                                                                   |P_Fld(tr->TX_DQ_MCK_OE[rank_id][1],  SHURK_SELPH_DQ0_TXDLY_OEN_DQ1)  \
                                                                   |P_Fld(tr->TX_DQ_MCK_OE[rank_id][0],  SHURK_SELPH_DQ0_TXDLY_OEN_DQ2)  \
                                                                   |P_Fld(tr->TX_DQ_MCK_OE[rank_id][1],  SHURK_SELPH_DQ0_TXDLY_OEN_DQ3)  );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ1),   P_Fld(tr->TX_DQ_MCK[rank_id][0],     SHURK_SELPH_DQ1_TXDLY_DQM0)     \
                                                                   |P_Fld(tr->TX_DQ_MCK[rank_id][1],     SHURK_SELPH_DQ1_TXDLY_DQM1)     \
                                                                   |P_Fld(tr->TX_DQ_MCK[rank_id][0],     SHURK_SELPH_DQ1_TXDLY_DQM2)     \
                                                                   |P_Fld(tr->TX_DQ_MCK[rank_id][1],     SHURK_SELPH_DQ1_TXDLY_DQM3)     \
                                                                   |P_Fld(tr->TX_DQ_MCK_OE[rank_id][0],  SHURK_SELPH_DQ1_TXDLY_OEN_DQM0) \
                                                                   |P_Fld(tr->TX_DQ_MCK_OE[rank_id][1],  SHURK_SELPH_DQ1_TXDLY_OEN_DQM1) \
                                                                   |P_Fld(tr->TX_DQ_MCK_OE[rank_id][0],  SHURK_SELPH_DQ1_TXDLY_OEN_DQM2) \
                                                                   |P_Fld(tr->TX_DQ_MCK_OE[rank_id][1],  SHURK_SELPH_DQ1_TXDLY_OEN_DQM3) );

      vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ2), P_Fld(tr->TX_DQ_UI[rank_id][0],      SHURK_SELPH_DQ2_DLY_DQ0)        \
                                                                   |P_Fld(tr->TX_DQ_UI[rank_id][1],      SHURK_SELPH_DQ2_DLY_DQ1)        \
                                                                   |P_Fld(tr->TX_DQ_UI[rank_id][0],      SHURK_SELPH_DQ2_DLY_DQ2)        \
                                                                   |P_Fld(tr->TX_DQ_UI[rank_id][1],      SHURK_SELPH_DQ2_DLY_DQ3)        \
                                                                   |P_Fld(tr->TX_DQ_UI_OE[rank_id][0],   SHURK_SELPH_DQ2_DLY_OEN_DQ0)    \
                                                                   |P_Fld(tr->TX_DQ_UI_OE[rank_id][1],   SHURK_SELPH_DQ2_DLY_OEN_DQ1)    \
                                                                   |P_Fld(tr->TX_DQ_UI_OE[rank_id][0],   SHURK_SELPH_DQ2_DLY_OEN_DQ2)    \
                                                                   |P_Fld(tr->TX_DQ_UI_OE[rank_id][1],   SHURK_SELPH_DQ2_DLY_OEN_DQ3)    );
      vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQ3), P_Fld(tr->TX_DQ_UI[rank_id][0],      SHURK_SELPH_DQ3_DLY_DQM0)       \
                                                                   |P_Fld(tr->TX_DQ_UI[rank_id][1],      SHURK_SELPH_DQ3_DLY_DQM1)       \
                                                                   |P_Fld(tr->TX_DQ_UI[rank_id][0],      SHURK_SELPH_DQ3_DLY_DQM2)       \
                                                                   |P_Fld(tr->TX_DQ_UI[rank_id][1],      SHURK_SELPH_DQ3_DLY_DQM3)       \
                                                                   |P_Fld(tr->TX_DQ_UI_OE[rank_id][0],   SHURK_SELPH_DQ3_DLY_OEN_DQM0)    \
                                                                   |P_Fld(tr->TX_DQ_UI_OE[rank_id][1],   SHURK_SELPH_DQ3_DLY_OEN_DQM1)    \
                                                                   |P_Fld(tr->TX_DQ_UI_OE[rank_id][0],   SHURK_SELPH_DQ3_DLY_OEN_DQM2)    \
                                                                   |P_Fld(tr->TX_DQ_UI_OE[rank_id][1],   SHURK_SELPH_DQ3_DLY_OEN_DQM3)    );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQS0),  P_Fld(tr->TX_DQS_MCK[rank_id][0],    SHURK_SELPH_DQS0_TXDLY_DQS0)      \
                                                                   |P_Fld(tr->TX_DQS_MCK[rank_id][1],    SHURK_SELPH_DQS0_TXDLY_DQS1)      \
                                                                   |P_Fld(tr->TX_DQS_MCK[rank_id][0],    SHURK_SELPH_DQS0_TXDLY_DQS2)      \
                                                                   |P_Fld(tr->TX_DQS_MCK[rank_id][1],    SHURK_SELPH_DQS0_TXDLY_DQS3)      \
                                                                   |P_Fld(tr->TX_DQS_MCK_OE[rank_id][0], SHURK_SELPH_DQS0_TXDLY_OEN_DQS0)  \
                                                                   |P_Fld(tr->TX_DQS_MCK_OE[rank_id][1], SHURK_SELPH_DQS0_TXDLY_OEN_DQS1)  \
                                                                   |P_Fld(tr->TX_DQS_MCK_OE[rank_id][0], SHURK_SELPH_DQS0_TXDLY_OEN_DQS2)  \
                                                                   |P_Fld(tr->TX_DQS_MCK_OE[rank_id][1], SHURK_SELPH_DQS0_TXDLY_OEN_DQS3)  );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_SELPH_DQS1),  P_Fld(tr->TX_DQS_UI[rank_id][0],     SHURK_SELPH_DQS1_DLY_DQS0)      \
                                                                   |P_Fld(tr->TX_DQS_UI[rank_id][1],     SHURK_SELPH_DQS1_DLY_DQS1)      \
                                                                   |P_Fld(tr->TX_DQS_UI[rank_id][0],     SHURK_SELPH_DQS1_DLY_DQS2)      \
                                                                   |P_Fld(tr->TX_DQS_UI[rank_id][1],     SHURK_SELPH_DQS1_DLY_DQS3)      \
                                                                   |P_Fld(tr->TX_DQS_UI_OE[rank_id][0],  SHURK_SELPH_DQS1_DLY_OEN_DQS0)  \
                                                                   |P_Fld(tr->TX_DQS_UI_OE[rank_id][1],  SHURK_SELPH_DQS1_DLY_OEN_DQS1)  \
                                                                   |P_Fld(tr->TX_DQS_UI_OE[rank_id][0],  SHURK_SELPH_DQS1_DLY_OEN_DQS2)  \
                                                                   |P_Fld(tr->TX_DQS_UI_OE[rank_id][1],  SHURK_SELPH_DQS1_DLY_OEN_DQS3)  );
    //set TX DQ PI delay
    if(DUT_p.DEF_DDR34_1C32B_EN_TBA && (DUT_p.DEF_DDR3_X32_EN || DUT_p.DEF_DDR4_X32_EN)){
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQ),    P_Fld (tr->TX_DQ_PI[rank_id][0]/* 16*/,     SHU_RK_B0_DQ_SW_ARPI_DQ_B0)    \
                                                                   |P_Fld(tr->TX_DQ_PI[rank_id][0]/* 16*/,     SHU_RK_B0_DQ_SW_ARPI_DQM_B0)   );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQ),    P_Fld (tr->TX_DQ_PI[rank_id][1]/* 16*/,     SHU_RK_B1_DQ_SW_ARPI_DQ_B1)    \
                                                                   |P_Fld(tr->TX_DQ_PI[rank_id][1]/* 16*/,     SHU_RK_B1_DQ_SW_ARPI_DQM_B1)   ); //B2, B3 for DDR3/4 x32 ?
    }
    else{
      U32 TX_DQ_PI_tmp = (DUT_p.DEF_DDR34_1C16B_EN&&(!ch_id))? (tr->TX_DQ_PI[rank_id][1]):(tr->TX_DQ_PI[rank_id][0]);
      vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQ),P_Fld(TX_DQ_PI_tmp,SHU_RK_B0_DQ_SW_ARPI_DQ_B0)\
                                                                |P_Fld(TX_DQ_PI_tmp,SHU_RK_B0_DQ_SW_ARPI_DQM_B0)    );
      vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQ),    P_Fld (tr->TX_DQ_PI[rank_id][1] ,     SHU_RK_B1_DQ_SW_ARPI_DQ_B1)   \
                                                                    |P_Fld (tr->TX_DQ_PI[rank_id][1] ,     SHU_RK_B1_DQ_SW_ARPI_DQM_B1)  ); //B2, B3 for DDR3/4 x32 ?
    }

    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_DQS2DQ_CAL1), P_Fld(tr->TX_DQ_UIPI_all[rank_id][0],     SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ0)    \
                                                                   |P_Fld(tr->TX_DQ_UIPI_all[rank_id][1],     SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ1)   );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_DQS2DQ_CAL4), P_Fld(tr->TX_DQ_UIPI_all[rank_id][0],     SHURK_DQS2DQ_CAL4_BOOT_ORIG_UI_RK0_DQM0)    \
                                                                   |P_Fld(tr->TX_DQ_UIPI_all[rank_id][1],     SHURK_DQS2DQ_CAL4_BOOT_ORIG_UI_RK0_DQM1)   );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_DQS2DQ_CAL2), P_Fld(tr->TX_DQ_UIPI_all[rank_id][0],     SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ0)    \
                                                                   |P_Fld(tr->TX_DQ_UIPI_all[rank_id][1],     SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ1)   );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_DQS2DQ_CAL5), P_Fld(tr->TX_DQ_UIPI_all[rank_id][0],     SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM0)   \
                                                                   |P_Fld(tr->TX_DQ_UIPI_all[rank_id][1],     SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM1)  );
    if(DUT_p.DEF_DDR34_1C32B_EN_TBA && (DUT_p.DEF_DDR3_X32_EN || DUT_p.DEF_DDR4_X32_EN)){
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_PI),          P_Fld(tr->TX_DQ_PI[rank_id][0]/* 16*/,     SHURK_PI_RK0_ARPI_DQ_B0)       \
                                                                   |P_Fld(tr->TX_DQ_PI[rank_id][1]/* 16*/,     SHURK_PI_RK0_ARPI_DQ_B1)       \
                                                                   |P_Fld(tr->TX_DQ_PI[rank_id][0]/* 16*/,     SHURK_PI_RK0_ARPI_DQM_B0)    \
                                                                   |P_Fld(tr->TX_DQ_PI[rank_id][1]/* 16*/,     SHURK_PI_RK0_ARPI_DQM_B1)    );
    }
    else{
       vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_PI),   P_Fld((DUT_p.DEF_DDR34_1C16B_EN&&(!ch_id))? tr->TX_DQ_PI[rank_id][1]:tr->TX_DQ_PI[rank_id][0],SHURK_PI_RK0_ARPI_DQ_B0)\
                                                               |P_Fld(tr->TX_DQ_PI[rank_id][1],     SHURK_PI_RK0_ARPI_DQ_B1)     \
                                                               |P_Fld((DUT_p.DEF_DDR34_1C16B_EN&&(!ch_id))?tr->TX_DQ_PI[rank_id][1]:tr->TX_DQ_PI[rank_id][0],SHURK_PI_RK0_ARPI_DQM_B0)\
                                                               |P_Fld(tr->TX_DQ_PI[rank_id][1],     SHURK_PI_RK0_ARPI_DQM_B1)    );
    	
    }
    //set TX dly line
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_TXDLY0),  P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY0_TX_ARDQ0_DLY_B0 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY0_TX_ARDQ1_DLY_B0 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY0_TX_ARDQ2_DLY_B0 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY0_TX_ARDQ3_DLY_B0 )  );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_TXDLY1),  P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY1_TX_ARDQ4_DLY_B0 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY1_TX_ARDQ5_DLY_B0 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY1_TX_ARDQ6_DLY_B0 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY1_TX_ARDQ7_DLY_B0 )  );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_TXDLY3),  P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY3_TX_ARDQM0_DLY_B0) ); 
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_TXDLY0),  P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY0_TX_ARDQ0_DLY_B1 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY0_TX_ARDQ1_DLY_B1 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY0_TX_ARDQ2_DLY_B1 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY0_TX_ARDQ3_DLY_B1 )  );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_TXDLY1),  P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY1_TX_ARDQ4_DLY_B1 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY1_TX_ARDQ5_DLY_B1 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY1_TX_ARDQ6_DLY_B1 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY1_TX_ARDQ7_DLY_B1 )  );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_TXDLY3),  P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY3_TX_ARDQM0_DLY_B1) ); 
    //set TX DQS dly line
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_TXDLY2),  P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY2_TX_ARDQS0_DLYB_B0  )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY2_TX_ARDQS0B_DLYB_B0 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY2_TX_ARDQS0_DLY_B0   )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][0],  SHU_RK_B0_TXDLY2_TX_ARDQS0B_DLY_B0  )  );
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_TXDLY2),  P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY2_TX_ARDQS0_DLYB_B1  )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY2_TX_ARDQS0B_DLYB_B1 )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY2_TX_ARDQS0_DLY_B1   )  \
                                                                    |P_Fld(tr->TX_DQ_dlyline[rank_id][1],  SHU_RK_B1_TXDLY2_TX_ARDQS0B_DLY_B1  )  );

    //set TX DQ PICG relate rg
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHURK_APHY_TX_PICG_CTRL), P_Fld((rank_id ? tr->DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P0 :tr->DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P0),SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0)       \
                                                                         |P_Fld((rank_id ? tr->DDRPHY_CLK_EN_COMB_TX_DQ_RK1_SEL_P1 :tr->DDRPHY_CLK_EN_COMB_TX_DQ_RK0_SEL_P1),SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1)   )    ;

    if(DUT_p.DEF_DDR34_1C32B_EN_TBA && (DUT_p.DEF_DDR3_X32_EN || DUT_p.DEF_DDR4_X32_EN))
    {
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQ),  P_Fld(tr->TX_DQS_PI[rank_id][0]/*0*/,  SHU_RK_B0_DQ_ARPI_PBYTE_B0) ); 
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQ),  P_Fld(tr->TX_DQS_PI[rank_id][1]/*0*/,  SHU_RK_B1_DQ_ARPI_PBYTE_B1) ); 
    } 
    else 
    {
      U32 TX_DQS_PI_tmp_b0 = DUT_p.DEF_DDR34_1C32B_EN_TBA?(tr->TX_DQS_PI[rank_id][0]):((DUT_p.DEF_DDR34_1C16B_EN&&(!ch_id))? (tr->TX_DQS_PI[rank_id][1]):(tr->TX_DQS_PI[rank_id][0]));
      U32 TX_DQS_PI_tmp_b1 = DUT_p.DEF_DDR34_1C32B_EN_TBA?(tr->TX_DQS_PI[rank_id][1]):((DUT_p.DEF_DDR34_1C16B_EN&&(!ch_id))? (tr->TX_DQS_PI[rank_id][1]):(tr->TX_DQS_PI[rank_id][0]));
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQ),  P_Fld(TX_DQS_PI_tmp_b0/*tr->TX_DQS_PI[rank_id][0]*/,  SHU_RK_B0_DQ_ARPI_PBYTE_B0) ); 
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQ),  P_Fld(TX_DQS_PI_tmp_b1/*tr->TX_DQS_PI[rank_id][1]*/,  SHU_RK_B1_DQ_ARPI_PBYTE_B1) ); 
    }

#if DDR_CS_DELAY_1T
      //set CLK CA PI
    vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_CA_CMD),    P_Fld(PCDDR4_EN_S ? ((ch_id == 1) ? 0x28 : 0) : ((ch_id == 1) ? 63 : 0),              SHU_RK_CA_CMD_RG_ARPI_CLK  )
                                                                    |P_Fld(PCDDR4_EN_S ? 0x28 : 63,  SHU_RK_CA_CMD_RG_ARPI_CMD )
                                                                    |P_Fld(PCDDR4_EN_S ? ((ch_id == 1) ? 0x30 : 0x28) : 63,              SHU_RK_CA_CMD_RG_ARPI_CS  )  );
#else
		vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_CA_CMD),    P_Fld(0,              SHU_RK_CA_CMD_RG_ARPI_CLK  )
                                                                    |P_Fld(tr->ARPI_CMD,  SHU_RK_CA_CMD_RG_ARPI_CMD )
                                                                    |P_Fld(0,              SHU_RK_CA_CMD_RG_ARPI_CS  )  );
#endif
    if(PCDDR3_EN_S && DUT_p.DEF_DDR34_1C32B_EN_TBA == 0) //B2 AS CA
    {
         vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B2_DQ),  P_Fld(tr->ARPI_CMD ,  SHU_RK_B2_DQ_ARPI_PBYTE_B2   )  
                                                                     |P_Fld(tr->ARPI_CMD,  SHU_RK_B2_DQ_SW_ARPI_DQ_B2   )  
                                                                     |P_Fld(tr->ARPI_CMD,  SHU_RK_B2_DQ_SW_ARPI_DQM_B2  )  );
    }
  }

   //set WODT
    if(PCDDR3_EN_S)
    {

      vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_WODT),        P_Fld(1,     SHU_WODT_WOEN)    \
                                                                   |P_Fld(15,     SHU_WODT_TWODT)    ); //ddr3-2133
    }

    if(PCDDR4_EN_S){

      vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_WODT),        P_Fld(1,     SHU_WODT_WOEN)    \
                                                                   |P_Fld(3,     SHU_WODT_TWODT)    ); //ddr4-3200
    }
}
//============================

void TX_PATH_auto_gen_and_set(DRAMC_CTX_T *p, U32 ch_id, U32 group_id)
{

  TX_path_config_T          TX_C   ;
  TX_path_attribution_T     TX_R   ;
  get_TX_path_config        (&TX_C, ch_id,group_id);
  print_TX_path_config      (&TX_C);
  calculate_TX_path_rg_val  (&TX_C, &TX_R, group_id, ch_id);
  print_TX_path_attribution (&TX_R);

  TX_PATH_config(p,&TX_R,ch_id,group_id);

      //set 4-3 picg related setting, should be move to DCM function by yanghao
    if (DUT_shu_p[group_id].FAKE_1TO16_MODE ==1)
    {
      vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_DCM_CTRL0),  P_Fld(5,    SHU_DCM_CTRL0_APHYPI_CKCGH_CNT)); //CG change to high 1T later when FAKE_MODE 
      mcSHOW_DBG_MSG ("set APHY_PI_CKCGH_CNT is 5 when fake_mode, cur data_rate is %d\n", TX_C.data_ratio            );
    }
    else
    {
      vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_DCM_CTRL0),  P_Fld(4,    SHU_DCM_CTRL0_APHYPI_CKCGH_CNT)); //CG change to high 1T later when FAKE_MODE 
      mcSHOW_DBG_MSG ("set APHY_PI_CKCGH_CNT is 4 when not fake_mode, cur data_rate is %d\n", TX_C.data_ratio            );
    }
      vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_WODT),  P_Fld(TX_C.DRAMOBF_PIPE_NO,    SHU_WODT_DRAMOBF_PIPE_NO)); // 
      mcSHOW_DBG_MSG ("set DRAMOBF_PIPE_NO is %d\n", TX_C.DRAMOBF_PIPE_NO           );
}
