/*----------------------------------------------------------------------------*
 * Copyright Statement:                                                       *
 *                                                                            *
 *   This software/firmware and related documentation ("MediaTek Software")   *
 * are protected under international and related jurisdictions'copyright laws *
 * as unpublished works. The information contained herein is confidential and *
 * proprietary to MediaTek Inc. Without the prior written permission of       *
 * MediaTek Inc., any reproduction, modification, use or disclosure of        *
 * MediaTek Software, and information contained herein, in whole or in part,  *
 * shall be strictly prohibited.                                              *
 * MediaTek Inc. Copyright (C) 2010. All rights reserved.                     *
 *                                                                            *
 *   BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND     *
 * AGREES TO THE FOLLOWING:                                                   *
 *                                                                            *
 *   1)Any and all intellectual property rights (including without            *
 * limitation, patent, copyright, and trade secrets) in and to this           *
 * Software/firmware and related documentation ("MediaTek Software") shall    *
 * remain the exclusive property of MediaTek Inc. Any and all intellectual    *
 * property rights (including without limitation, patent, copyright, and      *
 * trade secrets) in and to any modifications and derivatives to MediaTek     *
 * Software, whoever made, shall also remain the exclusive property of        *
 * MediaTek Inc.  Nothing herein shall be construed as any transfer of any    *
 * title to any intellectual property right in MediaTek Software to Receiver. *
 *                                                                            *
 *   2)This MediaTek Software Receiver received from MediaTek Inc. and/or its *
 * representatives is provided to Receiver on an "AS IS" basis only.          *
 * MediaTek Inc. expressly disclaims all warranties, expressed or implied,    *
 * including but not limited to any implied warranties of merchantability,    *
 * non-infringement and fitness for a particular purpose and any warranties   *
 * arising out of course of performance, course of dealing or usage of trade. *
 * MediaTek Inc. does not provide any warranty whatsoever with respect to the *
 * software of any third party which may be used by, incorporated in, or      *
 * supplied with the MediaTek Software, and Receiver agrees to look only to   *
 * such third parties for any warranty claim relating thereto.  Receiver      *
 * expressly acknowledges that it is Receiver's sole responsibility to obtain *
 * from any third party all proper licenses contained in or delivered with    *
 * MediaTek Software.  MediaTek is not responsible for any MediaTek Software  *
 * releases made to Receiver's specifications or to conform to a particular   *
 * standard or open forum.                                                    *
 *                                                                            *
 *   3)Receiver further acknowledge that Receiver may, either presently       *
 * and/or in the future, instruct MediaTek Inc. to assist it in the           *
 * development and the implementation, in accordance with Receiver's designs, *
 * of certain softwares relating to Receiver's product(s) (the "Services").   *
 * Except as may be otherwise agreed to in writing, no warranties of any      *
 * kind, whether express or implied, are given by MediaTek Inc. with respect  *
 * to the Services provided, and the Services are provided on an "AS IS"      *
 * basis. Receiver further acknowledges that the Services may contain errors  *
 * that testing is important and it is solely responsible for fully testing   *
 * the Services and/or derivatives thereof before they are used, sublicensed  *
 * or distributed. Should there be any third party action brought against     *
 * MediaTek Inc. arising out of or relating to the Services, Receiver agree   *
 * to fully indemnify and hold MediaTek Inc. harmless.  If the parties        *
 * mutually agree to enter into or continue a business relationship or other  *
 * arrangement, the terms and conditions set forth herein shall remain        *
 * effective and, unless explicitly stated otherwise, shall prevail in the    *
 * event of a conflict in the terms in any agreements entered into between    *
 * the parties.                                                               *
 *                                                                            *
 *   4)Receiver's sole and exclusive remedy and MediaTek Inc.'s entire and    *
 * cumulative liability with respect to MediaTek Software released hereunder  *
 * will be, at MediaTek Inc.'s sole discretion, to replace or revise the      *
 * MediaTek Software at issue.                                                *
 *                                                                            *
 *   5)The transaction contemplated hereunder shall be construed in           *
 * accordance with the laws of Singapore, excluding its conflict of laws      *
 * principles.  Any disputes, controversies or claims arising thereof and     *
 * related thereto shall be settled via arbitration in Singapore, under the   *
 * then current rules of the International Chamber of Commerce (ICC).  The    *
 * arbitration shall be conducted in English. The awards of the arbitration   *
 * shall be final and binding upon both parties and shall be entered and      *
 * enforceable in any court of competent jurisdiction.                        *
 *---------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// Include files
//-----------------------------------------------------------------------------
#if FOR_DV_SIMULATION_USED
#include "./sv_to_c_lib/sv_to_c_api.h"
#endif
#include "dramc_common.h"
#include "x_hal_io.h"
#include "dramc_pi_api.h"
#include "dramc_actiming.h"
#if CFG_PCDDR_ENABLE
#include "dramc_pi_api_pcddr.h"
#endif
#include "dramc_dv_init.h"

//-----------------------------------------------------------------------------
// Global variables
//-----------------------------------------------------------------------------

//-------------------------------------------------------------------------
/** u1GetACTimingIdx()
 *  Retrieve internal ACTimingTbl's index according to dram type, freqGroup, Read DBI status
 *  @param p                Pointer of context created by DramcCtxCreate.
 *  @retval u1TimingIdx     Return ACTimingTbl entry's index
 */
//-------------------------------------------------------------------------
static U8 u1GetACTimingIdx(DRAMC_CTX_T *p)
{
    U8 u1TimingIdx = 0xff, u1TmpIdx;
    U8 u1TmpDramType = p->dram_type;

    mcSHOW_DBG_MSG2("DramType: %d, freqGroup: %d, DivMode:%d, cbt_mode:%d\n", u1TmpDramType, p->freqGroup, vGet_Div_Mode(p), vGet_Dram_CBT_Mode(p));
    // LP4/LP4P/LP4X use same table
    if(u1TmpDramType== TYPE_LPDDR4X || u1TmpDramType == TYPE_LPDDR4P)
        u1TmpDramType = TYPE_LPDDR4;

#if SUPPORT_TYPE_LPDDR5
    if(is_lp5_family(p))
    {
        //mcSHOW_DBG_MSG("DBI_R: %d, ECC_R: %d, ECC_W: %d\n", p->DBI_R_onoff[p->dram_fsp], p->ECC_R_onoff, p->ECC_W_onoff);

        for(u1TmpIdx = 0; u1TmpIdx < AC_TIMING_NUMBER_LP5_SA; u1TmpIdx++)
        {
            if((ACTimingTbl_LP5_SA[u1TmpIdx].dramType == u1TmpDramType) &&
                /* p->frequency may not be in ACTimingTable, use p->freqGroup */
                (ACTimingTbl_LP5_SA[u1TmpIdx].freq == p->freqGroup) &&
                (ACTimingTbl_LP5_SA[u1TmpIdx].CKRMode == p->CKR) &&
                (ACTimingTbl_LP5_SA[u1TmpIdx].readDBI == p->DBI_R_onoff[p->dram_fsp]) &&
                (ACTimingTbl_LP5_SA[u1TmpIdx].DivMode == vGet_Div_Mode(p)) && // Darren for LP4 1:4 and 1:8 mode
                (ACTimingTbl_LP5_SA[u1TmpIdx].cbtMode == vGet_Dram_CBT_Mode(p)) && //LP4 byte/mixed mode dram both use byte mode ACTiming
                (ACTimingTbl_LP5_SA[u1TmpIdx].readECCLink == p->ECC_R_onoff) &&
                (ACTimingTbl_LP5_SA[u1TmpIdx].writeECCLink== p->ECC_W_onoff)
               )
            {
                u1TimingIdx = u1TmpIdx;
                mcSHOW_DBG_MSG("match AC timing %d\n", u1TimingIdx);
                //mcFPRINTF(fp_A60501, "match AC timing %d\n", u1TimingIdx);
                break;
            }
        }
    }
    else
#endif
#if SUPPORT_TYPE_LPDDR4
    if (is_lp4_family(p))
    {
        for(u1TmpIdx = 0; u1TmpIdx < AC_TIMING_NUMBER_LP4; u1TmpIdx++)
        {
            if((ACTimingTbl_LP4_SA[u1TmpIdx].dramType == u1TmpDramType) &&
                /* p->frequency may not be in ACTimingTable, use p->freqGroup */
                (ACTimingTbl_LP4_SA[u1TmpIdx].freq == p->freqGroup) &&
                (ACTimingTbl_LP4_SA[u1TmpIdx].readDBI == p->DBI_R_onoff[p->dram_fsp]) &&
                (ACTimingTbl_LP4_SA[u1TmpIdx].DivMode == vGet_Div_Mode(p)) && // Darren for LP4 1:4 and 1:8 mode
                (ACTimingTbl_LP4_SA[u1TmpIdx].cbtMode == vGet_Dram_CBT_Mode(p)) //LP4 byte/mixed mode dram both use byte mode ACTiming
               )
            {
                u1TimingIdx = u1TmpIdx;
                 mcSHOW_DBG_MSG("match AC timing %d\n", u1TimingIdx);
                //mcFPRINTF(fp_A60501, "match AC timing %d\n", u1TimingIdx);
                break;
            }
        }
    }
    else
#endif
#if SUPPORT_TYPE_PCDDR3
    if (is_ddr3_family(p))
    {
        for(u1TmpIdx = 0; u1TmpIdx < ARRAY_SIZE(ACTimingTbl_DDR3); u1TmpIdx++)
        {
            if((ACTimingTbl_DDR3[u1TmpIdx].dramType == TYPE_DDR3) &&
                (ACTimingTbl_DDR3[u1TmpIdx].freq    == p->freqGroup) &&
                (ACTimingTbl_DDR3[u1TmpIdx].DivMode == vGet_Div_Mode(p)) && // Darren for LP4 1:4 and 1:8 mode
                (ACTimingTbl_DDR3[u1TmpIdx].cbtMode == CBT_NORMAL_MODE)
               )
            {
                u1TimingIdx = u1TmpIdx;
                 mcSHOW_DBG_MSG("match AC timing %d\n", u1TimingIdx);
                //mcFPRINTF(fp_A60501, "match AC timing %d\n", u1TimingIdx);
                break;
            }
        }
    } else
#endif
#if SUPPORT_TYPE_PCDDR4
    if (is_ddr4_family(p))
    {
        for(u1TmpIdx = 0; u1TmpIdx < ARRAY_SIZE(ACTimingTbl_DDR4); u1TmpIdx++)
        {
            if((ACTimingTbl_DDR4[u1TmpIdx].dramType == TYPE_DDR4) &&
                (ACTimingTbl_DDR4[u1TmpIdx].freq    == p->freqGroup) &&
                (ACTimingTbl_DDR4[u1TmpIdx].DivMode == vGet_Div_Mode(p)) && // Darren for LP4 1:4 and 1:8 mode
                (ACTimingTbl_DDR4[u1TmpIdx].cbtMode == CBT_NORMAL_MODE)
               )
            {
                u1TimingIdx = u1TmpIdx;
                mcSHOW_DBG_MSG("match AC timing %d\n", u1TimingIdx);
                //mcFPRINTF((fp_A60501, "match AC timing %d\n", u1TimingIdx));
                break;
            }
        }
        

    }
#endif
    {
        /* For build error */
    }

    return u1TimingIdx;
}

//-------------------------------------------------------------------------
/** UpdateACTimingReg_ddr3()
 *  ACTiming related register field update
 *  @param p                Pointer of context created by DramcCtxCreate.
 *  @param  ACTbl           Pointer to correct ACTiming table struct
 *  @retval status          (DRAM_STATUS_T): DRAM_OK or DRAM_FAIL
 */
#if SUPPORT_TYPE_PCDDR3
#if !SA_CONFIG_EN
U8 u1GetACTimingIdx_ddr3(DRAMC_CTX_T *p, int dramc_dram_ratio, int frequency)
{
    U8 u1TimingIdx = 0xff, u1TmpIdx;
    U8 u1LP5DivMode = 0xff;
    mcSHOW_DBG_MSG("dramc_dram_ratio: %d\n", dramc_dram_ratio);

    if(dramc_dram_ratio == 8)
        u1LP5DivMode = DIV16_MODE;
    if(dramc_dram_ratio == 4)
        u1LP5DivMode = DIV8_MODE;
    if(dramc_dram_ratio == 2)
        u1LP5DivMode = DIV4_MODE;

    mcSHOW_DBG_MSG("LP5_DivMode: %d\n", u1LP5DivMode);
    mcSHOW_DBG_MSG("freq_index: %d\n", frequency >> 1);
    for(u1TmpIdx = 0; u1TmpIdx < AC_TIMING_NUMBER_DDR3; u1TmpIdx++)
    {
        if((ACTimingTbl_DDR3[u1TmpIdx].dramType == TYPE_DDR3) &&
            /* p->frequency may not be in ACTimingTable, use p->freqGroup */
            (ACTimingTbl_DDR3[u1TmpIdx].freq    == frequency/2) &&
            (ACTimingTbl_DDR3[u1TmpIdx].DivMode == u1LP5DivMode) && // Darren for LP4 1:4 and 1:8 mode
            (ACTimingTbl_DDR3[u1TmpIdx].cbtMode == CBT_NORMAL_MODE)
           )
        {
            u1TimingIdx = u1TmpIdx;
            mcSHOW_DBG_MSG("match AC timing %d\n", u1TimingIdx);
//            mcFPRINTF((fp_A60501, "match AC timing %d\n", u1TimingIdx));
            break;
        }
    }

    return u1TimingIdx;
}
#endif

static void DDR3_ac_timing_setting(DRAMC_CTX_T *p, const ACTime_T_DDR3 *ACTbl_ddr3)
{

	ACTime_T_DDR3 ACTime_DDR3_Final;

	ACTime_DDR3_Final = *ACTbl_ddr3;

//	U32  tR2MRR;
	U32  tMANTMRR;

	U32 DDR3_ODT_ON = 1; //TODO by frequency setting
	U8 cas_mode = 0;
	U16 XRTW2W, XRTW2R, XRTR2W, XRTR2R, tCKESRX, ACDERATEEN, tR2W, tR2W_05T;	
	u8 backup_ShuRGAccessIdx = p->ShuRGAccessIdx;
	mcSHOW_DBG_MSG("[%s]start\n", __FUNCTION__);

	tCKESRX = 0;//tCKESRX = DDR3_AC_timing_item.tCKESRX
	ACDERATEEN = 0;//ACDERATEEN = DDR3_AC_timing_item.ACDERATEEN

	if ((p->frequency << 1) >= 2133)
		cas_mode = 0;


	if (cas_mode != 1) { //(TbaEnvDVFSCfg[group_id].CAS_MODE != 1)
		XRTW2W  = ACTime_DDR3_Final.xrtw2w_old_mode;//DDR3_AC_timing_item.XRTW2W          = ACTime_DDR3_Final.xrtw2w_old_mode;

		if (DDR3_ODT_ON ) {
			XRTW2R = ACTime_DDR3_Final.xrtw2r_odt_on;//DDR3_AC_timing_item.XRTW2R     = ACTime_DDR3_Final.xrtw2r_odt_on;
		}

		if (DDR3_ODT_ON ) {
			XRTW2R = ACTime_DDR3_Final.xrtw2r_odt_on;//DDR3_AC_timing_item.XRTW2R     = ACTime_DDR3_Final.xrtw2r_odt_on;
		}

		if (DDR3_ODT_ON) {
			XRTR2W = ACTime_DDR3_Final.xrtr2w_odt_on;//DDR3_AC_timing_item.XRTR2W      = ACTime_DDR3_Final.xrtr2w_odt_on;
		} else {
			XRTR2W = ACTime_DDR3_Final.xrtr2w_odt_off;//DDR3_AC_timing_item.XRTR2W     = ACTime_DDR3_Final.xrtr2w_odt_off;
		}

		XRTR2R = ACTime_DDR3_Final.xrtr2r_old_mode;//DDR3_AC_timing_item.XRTR2R        = ACTime_DDR3_Final.xrtr2r_old_mode;
	} else { //CAS_mode = 1, low_freq mode
		if (DDR3_ODT_ON) {
			XRTW2R = ACTime_DDR3_Final.xrtw2r_odt_on_wck;//DDR3_AC_timing_item.XRTW2R      = ACTime_DDR3_Final.xrtw2r_odt_on_wck;
			XRTR2W = ACTime_DDR3_Final.xrtr2w_odt_on_wck;//DDR3_AC_timing_item.XRTR2W      = ACTime_DDR3_Final.xrtr2w_odt_on_wck;
		} else {
			XRTW2R = ACTime_DDR3_Final.xrtw2r_odt_off_wck;//DDR3_AC_timing_item.XRTW2R     = ACTime_DDR3_Final.xrtw2r_odt_off_wck;
			XRTR2W = ACTime_DDR3_Final.xrtr2w_odt_off_wck;//DDR3_AC_timing_item.XRTR2W     = ACTime_DDR3_Final.xrtr2w_odt_off_wck;
		}

		XRTW2W = ACTime_DDR3_Final.xrtw2w_old_mode;//DDR3_AC_timing_item.XRTW2W        = ACTime_DDR3_Final.xrtw2w_old_mode;
		XRTR2R = ACTime_DDR3_Final.xrtr2r_old_mode;//DDR3_AC_timing_item.XRTR2R        = ACTime_DDR3_Final.xrtr2r_old_mode;
	}

	if (DDR3_ODT_ON) {
		tR2W = ACTime_DDR3_Final.tr2w_odt_on;
		tR2W_05T = ACTime_DDR3_Final.tr2w_odt_on_05T;
	} else {
		tR2W = ACTime_DDR3_Final.tr2w_odt_off;
		tR2W_05T = ACTime_DDR3_Final.tr2w_odt_off_05T;
	}

	if (vGet_Div_Mode(p)== DIV4_MODE) { //(TbaEnvDVFSCfg[group_id].dramc_dram_ratio == 4){
		tMANTMRR = 4;
		//tR2MRR   = 4;
	} else {
		tMANTMRR = 8;
		//tR2MRR   = 8;
	}

//	//vSetPHY2ChannelMapping(p, ch_id);
//
//	//[SV] bit need_fifo;
//	//[SV] need_fifo = (group_id == 0) ? 1'b0 : 1'b1;
	p->ShuRGAccessIdx = DRAM_DFS_REG_SHU0;//(group_id == 0) ? DRAM_DFS_REG_SHU0 : DRAM_DFS_REG_SHU1;

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_CKECTRL), P_Fld(ACTime_DDR3_Final.tpde_05T, SHU_CKECTRL_TPDE_05T) \
		| P_Fld(ACTime_DDR3_Final.tpdx_05T, SHU_CKECTRL_TPDX_05T) \
		| P_Fld(ACTime_DDR3_Final.tpde, SHU_CKECTRL_TPDE) \
		| P_Fld(ACTime_DDR3_Final.tpdx, SHU_CKECTRL_TPDX) \
		| P_Fld(ACTime_DDR3_Final.ckeprd, SHU_CKECTRL_TCKEPRD) \
		| P_Fld(tCKESRX, SHU_CKECTRL_TCKESRX));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM0), P_Fld(ACTime_DDR3_Final.twtr, SHU_ACTIM0_TWTR) \
		| P_Fld(ACTime_DDR3_Final.twr,  SHU_ACTIM0_TWR ) \
		| P_Fld(ACTime_DDR3_Final.trrd, SHU_ACTIM0_TRRD) \
		| P_Fld(ACTime_DDR3_Final.trcd, SHU_ACTIM0_TRCD) \
		| P_Fld(ACTime_DDR3_Final.ckelckcnt, SHU_ACTIM0_CKELCKCNT));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM1), P_Fld(ACTime_DDR3_Final.trc,  SHU_ACTIM1_TRC ) \
		| P_Fld(ACTime_DDR3_Final.tras, SHU_ACTIM1_TRAS) \
		| P_Fld(ACTime_DDR3_Final.trp,  SHU_ACTIM1_TRP ) \
		| P_Fld(ACTime_DDR3_Final.tmrwckel,  SHU_ACTIM1_TMRWCKEL ) \
		| P_Fld(ACTime_DDR3_Final.trpab, SHU_ACTIM1_TRPAB));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM2), P_Fld(ACTime_DDR3_Final.tfaw, SHU_ACTIM2_TFAW ) \
		| P_Fld(tR2W, SHU_ACTIM2_TR2W ) \
		| P_Fld(ACTime_DDR3_Final.trtp, SHU_ACTIM2_TRTP ) \
		| P_Fld(ACTime_DDR3_Final.tmrri, SHU_ACTIM2_TMRRI) \
		| P_Fld(ACTime_DDR3_Final.txp,  SHU_ACTIM2_TXP));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM3), P_Fld(ACTime_DDR3_Final.trfcpb, SHU_ACTIM3_TRFCPB ) \
		| P_Fld(ACTime_DDR3_Final.tr2mrr, SHU_ACTIM3_TR2MRR ) \
		| P_Fld(ACTime_DDR3_Final.trfc, SHU_ACTIM3_TRFC ) \
		| P_Fld(tMANTMRR, SHU_ACTIM3_MANTMRR ) \
		/* | P_Fld(tr2mrr  , SHU_ACTIM3_TR2MRR   ) \*/
		| P_Fld(ACTime_DDR3_Final.twtr_l, SHU_ACTIM3_TWTR_L));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM4), P_Fld(ACTime_DDR3_Final.txrefcnt, SHU_ACTIM4_TXREFCNT ) \
		| P_Fld(ACTime_DDR3_Final.tmrr2mrw, SHU_ACTIM4_TMRR2MRW ) \
		| P_Fld(ACTime_DDR3_Final.tmrr2w, SHU_ACTIM4_TMRR2W ) \
		| P_Fld(ACTime_DDR3_Final.tzqcs, SHU_ACTIM4_TZQCS));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM5), P_Fld(ACTime_DDR3_Final.trtpd, SHU_ACTIM5_TR2PD ) \
		| P_Fld(ACTime_DDR3_Final.twtpd, SHU_ACTIM5_TWTPD ) \
		| P_Fld(ACTime_DDR3_Final.tpbr2pbr, SHU_ACTIM5_TPBR2PBR ) \
		/*| P_Fld(ACTime_DDR3_Final.bgtccd  , SHU_ACTIM5_BGTCCD   ) \*/
		| P_Fld(ACTime_DDR3_Final.tpbr2act, SHU_ACTIM5_TPBR2ACT));


	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM6), P_Fld(ACTime_DDR3_Final.zqlat2, SHU_ACTIM6_TZQLAT2 ) \
		| P_Fld(ACTime_DDR3_Final.tmrd, SHU_ACTIM6_TMRD ) \
		| P_Fld(ACTime_DDR3_Final.tmrw, SHU_ACTIM6_TMRW ) \
		| P_Fld(ACTime_DDR3_Final.tw2mrw, SHU_ACTIM6_TW2MRW ) \
		| P_Fld(ACTime_DDR3_Final.tr2mrw, SHU_ACTIM6_TR2MRW ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM7), P_Fld(ACTime_DDR3_Final.tcsh_cscal, SHU_ACTIM7_TCSH_CSCAL ) \
		| P_Fld(ACTime_DDR3_Final.tcacsh, SHU_ACTIM7_TCACSH ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM7), P_Fld(ACTime_DDR3_Final.nwr_05T, SHU_ACTIM7_NWR_05T ) \
		| P_Fld(ACTime_DDR3_Final.nrbtp_05T, SHU_ACTIM7_NRBTP_05T ) );

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM8), P_Fld(ACTime_DDR3_Final.nwr, SHU_ACTIM8_NWR ) \
		| P_Fld(ACTime_DDR3_Final.nrbtp, SHU_ACTIM8_NRBTP ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_LP5_CMD), P_Fld(ACTime_DDR3_Final.tcsh, SHU_LP5_CMD_TCSH ));


	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM_XRT), P_Fld(XRTW2W, SHU_ACTIM_XRT_XRTW2W ) \
		| P_Fld(XRTW2R, SHU_ACTIM_XRT_XRTW2R ) \
		| P_Fld(XRTR2W, SHU_ACTIM_XRT_XRTR2W ) \
		| P_Fld(XRTR2R, SHU_ACTIM_XRT_XRTR2R));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_WCKCTRL), P_Fld(ACTime_DDR3_Final.wckrdoff, SHU_WCKCTRL_WCKRDOFF     ) \
		| P_Fld(ACTime_DDR3_Final.wckrdoff_05T, SHU_WCKCTRL_WCKRDOFF_05T ) \
		| P_Fld(ACTime_DDR3_Final.wckwroff, SHU_WCKCTRL_WCKWROFF ) \
		| P_Fld(ACTime_DDR3_Final.wckwroff_05T, SHU_WCKCTRL_WCKWROFF_05T));


	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_AC_DERATING0), P_Fld(ACTime_DDR3_Final.trcd_derate,
			SHU_AC_DERATING0_TRCD_DERATE ) \
		| P_Fld(ACTime_DDR3_Final.trrd_derate, SHU_AC_DERATING0_TRRD_DERATE ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_AC_DERATING1), P_Fld(ACTime_DDR3_Final.trpab_derate,
			SHU_AC_DERATING1_TRPAB_DERATE) \
		| P_Fld(ACTime_DDR3_Final.trp_derate, SHU_AC_DERATING1_TRP_DERATE ) \
		| P_Fld(ACTime_DDR3_Final.tras_derate, SHU_AC_DERATING1_TRAS_DERATE) \
		| P_Fld(ACTime_DDR3_Final.trc_derate, SHU_AC_DERATING1_TRC_DERATE ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_AC_DERATING_05T), P_Fld(ACTime_DDR3_Final.trpab_derate_05T,
			SHU_AC_DERATING_05T_TRPAB_05T_DERATE) \
		| P_Fld(ACTime_DDR3_Final.trp_derate_05T, SHU_AC_DERATING_05T_TRP_05T_DERATE ) \
		| P_Fld(ACTime_DDR3_Final.tras_derate_05T, SHU_AC_DERATING_05T_TRAS_05T_DERATE) \
		| P_Fld(ACTime_DDR3_Final.trrd_derate_05T, SHU_AC_DERATING_05T_TRRD_05T_DERATE) \
		| P_Fld(ACTime_DDR3_Final.trcd_derate_05T, SHU_AC_DERATING_05T_TRCD_05T_DERATE) \
		| P_Fld(ACTime_DDR3_Final.trc_derate_05T, SHU_AC_DERATING_05T_TRC_05T_DERATE ));


	//ac_timing_05T
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_AC_TIME_05T), P_Fld(ACTime_DDR3_Final.trc_05T,
			SHU_AC_TIME_05T_TRC_05T ) \
		| P_Fld(ACTime_DDR3_Final.trfcpb_05T, SHU_AC_TIME_05T_TRFCPB_05T ) \
		| P_Fld(ACTime_DDR3_Final.trfc_05T, SHU_AC_TIME_05T_TRFC_05T ) \
		| P_Fld(ACTime_DDR3_Final.tpbr2pbr_05T, SHU_AC_TIME_05T_TPBR2PBR_05T ) \
		| P_Fld(ACTime_DDR3_Final.txp_05T, SHU_AC_TIME_05T_TXP_05T ) \
		| P_Fld(ACTime_DDR3_Final.trtp_05T, SHU_AC_TIME_05T_TRTP_05T ) \
		| P_Fld(ACTime_DDR3_Final.trcd_05T, SHU_AC_TIME_05T_TRCD_05T ) \
		| P_Fld(ACTime_DDR3_Final.trp_05T, SHU_AC_TIME_05T_TRP_05T ) \
		| P_Fld(ACTime_DDR3_Final.trpab_05T, SHU_AC_TIME_05T_TRPAB_05T ) \
		| P_Fld(ACTime_DDR3_Final.tras_05T, SHU_AC_TIME_05T_TRAS_05T ) \
		| P_Fld(ACTime_DDR3_Final.twr_05T, SHU_AC_TIME_05T_TWR_M05T  ) \
		| P_Fld(ACTime_DDR3_Final.trrd_05T, SHU_AC_TIME_05T_TRRD_05T ) \
		| P_Fld(ACTime_DDR3_Final.tfaw_05T, SHU_AC_TIME_05T_TFAW_05T ) \
		/*| P_Fld(ACTime_DDR3_Final.tCKEPRD_05T, SHU_AC_TIME_05T_TCKEPRD_05T ) \*/
		| P_Fld(ACTime_DDR3_Final.trtpd_05T, SHU_AC_TIME_05T_TR2PD_05T ) \
		| P_Fld(ACTime_DDR3_Final.twtpd_05T, SHU_AC_TIME_05T_TWTPD_M05T ) \
		| P_Fld(ACTime_DDR3_Final.tmrri_05T, SHU_AC_TIME_05T_TMRRI_05T ) \
		| P_Fld(ACTime_DDR3_Final.tmrwckel_05T, SHU_AC_TIME_05T_TMRWCKEL_05T ) \
		| P_Fld(ACTime_DDR3_Final.twtr_l_05T, SHU_AC_TIME_05T_BGTWTR_M05T ) \
		| P_Fld(tR2W_05T, SHU_AC_TIME_05T_TR2W_05T ) \
		| P_Fld(ACTime_DDR3_Final.twtr_05T, SHU_AC_TIME_05T_TWTR_M05T ) \
		| P_Fld(ACTime_DDR3_Final.tmrd_05T, SHU_AC_TIME_05T_TMRD_05T ) \
		| P_Fld(ACTime_DDR3_Final.tmrw_05T, SHU_AC_TIME_05T_TMRW_05T ) \
		| P_Fld(ACTime_DDR3_Final.tmrr2mrw_05T, SHU_AC_TIME_05T_TMRR2MRW_05T ) \
		| P_Fld(ACTime_DDR3_Final.tw2mrw_05T, SHU_AC_TIME_05T_TW2MRW_05T ) \
		| P_Fld(ACTime_DDR3_Final.tr2mrw_05T, SHU_AC_TIME_05T_TR2MRW_05T ) \
		| P_Fld(ACTime_DDR3_Final.tpbr2act_05T, SHU_AC_TIME_05T_TPBR2ACT_05T ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM8), P_Fld(ACTime_DDR3_Final.trfmpb, SHU_ACTIM8_TRFMPB ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM7), P_Fld(ACTime_DDR3_Final.twtrap, SHU_ACTIM7_TWTRAP ) \
		| P_Fld(ACTime_DDR3_Final.twtrap_05T, SHU_ACTIM7_TWTRAP_05T ) \
		| P_Fld(ACTime_DDR3_Final.twtrap_l, SHU_ACTIM7_TWTRAP_L   ) \
		| P_Fld(ACTime_DDR3_Final.twtrap_l_05T, SHU_ACTIM7_TWTRAP_L_05T ));
	//                                                          | P_Fld(ACTime_DDR3_Final.tmdy        , SHU_ACTIM7_TDMY ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_HMR4_DVFS_CTRL0), P_Fld(0x64, SHU_HMR4_DVFS_CTRL0_FSPCHG_PRDCNT ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_SREF_CTRL), P_Fld(0x3, SHU_SREF_CTRL_SREF_CK_DLY ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_SREF_CTRL), P_Fld(0x3, SHU_SREF_CTRL_CKEHCMD ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_CKECTRL), P_Fld(0x3, SHU_CKECTRL_TCKESRX ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_MISC), P_Fld(0x7, SHU_MISC_DCMDLYREF ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_AC_DERATING0), P_Fld(ACDERATEEN, SHU_AC_DERATING0_ACDERATEEN ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_HWSET_VRCG  ), P_Fld(ACTime_DDR3_Final.vrcgdis_prdcnt, SHU_HWSET_VRCG_VRCGDIS_PRDCNT));

	// mcSHOW_DBG_MSG("========>SHUFFLE GROUP:%2d, ShuRGAccessIdx:%2d, DDR3_AC_TIMING setting Exit:\n", group_id, p->ShuRGAccessIdx);

	p->ShuRGAccessIdx = backup_ShuRGAccessIdx;
//mcSHOW_DBG_MSG("[test_sa.c]========>lp5_ac_timing_auto_setting Exit\n");
}

#endif

//-------------------------------------------------------------------------
/** UpdateACTimingReg_ddr4()
 *  ACTiming related register field update
 *  @param p                Pointer of context created by DramcCtxCreate.
 *  @param  ACTbl           Pointer to correct ACTiming table struct
 *  @retval status          (DRAM_STATUS_T): DRAM_OK or DRAM_FAIL
 */
#if SUPPORT_TYPE_PCDDR4
#if !SA_CONFIG_EN
U8 u1GetACTimingIdx_ddr4(DRAMC_CTX_T *p, int dramc_dram_ratio, int frequency)
{
    U8 u1TimingIdx = 0xff, u1TmpIdx;
    U8 u1LP5DivMode = 0xff;
    mcSHOW_DBG_MSG("dramc_dram_ratio: %d\n", dramc_dram_ratio);

    if(dramc_dram_ratio == 8)
        u1LP5DivMode = DIV16_MODE;
    if(dramc_dram_ratio == 4)
        u1LP5DivMode = DIV8_MODE;
    if(dramc_dram_ratio == 2)
        u1LP5DivMode = DIV4_MODE;

    if(frequency == 4100)
       frequency = 4266;

    mcSHOW_DBG_MSG("DDR4_DivMode: %d\n", u1LP5DivMode);
    mcSHOW_DBG_MSG("freq_index: %d\n", frequency >> 1);
    for(u1TmpIdx = 0; u1TmpIdx < AC_TIMING_NUMBER_DDR4; u1TmpIdx++)
    {
        if((ACTimingTbl_DDR4[u1TmpIdx].dramType == TYPE_DDR4) &&
            /* p->frequency may not be in ACTimingTable, use p->freqGroup */
            (ACTimingTbl_DDR4[u1TmpIdx].freq    == frequency/2) &&
            (ACTimingTbl_DDR4[u1TmpIdx].DivMode      == u1LP5DivMode) &&// Darren for LP4 1:4 and 1:8 mode
            (ACTimingTbl_DDR4[u1TmpIdx].cbtMode == CBT_NORMAL_MODE)
           )
        {
            u1TimingIdx = u1TmpIdx;
            mcSHOW_DBG_MSG("match AC timing %d\n", u1TimingIdx);
            //mcFPRINTF((fp_A60501, "match AC timing %d\n", u1TimingIdx));
            break;
        }
    }

    return u1TimingIdx;
}
#endif

static void DDR4_ac_timing_setting(DRAMC_CTX_T *p, const ACTime_T_DDR4 *ACTbl_ddr4)
{
	ACTime_T_DDR4 ACTime_DDR4_Final;

	ACTime_DDR4_Final = *ACTbl_ddr4;
	U8 LP5_DQ_ODT = p->odt_onoff;
	U8 BGPIPEEN = DUT_p.BGPIPE_EN;
//	U32  tR2MRR;
	U32  tMANTMRR;
	U16 XRTW2W, XRTW2R, XRTR2W, XRTR2R, tCKESRX, ACDERATEEN, tR2W, tR2W_05T, tRAS, tRC, tXP, tRTP, tWR, tpbR2pbR, tpbR2act,
		tFAW, tRC_DERATE;
	U8 cas_mod = 0;
	U32 DDR4_ODT_ON = 1; //TODO by frequency setting
	u8 backup_ShuRGAccessIdx = p->ShuRGAccessIdx;
	mcSHOW_DBG_MSG("[%s]start\n", __FUNCTION__);
	ACDERATEEN = 0;

	tCKESRX = 0;

	if (LP5_DQ_ODT) { // 2, 1
		tR2W = ACTime_DDR4_Final.tr2w_odt_on;
		tR2W_05T = ACTime_DDR4_Final.tr2w_odt_on_05T;
	} else {
		tR2W = ACTime_DDR4_Final.tr2w_odt_off;
		tR2W_05T = ACTime_DDR4_Final.tr2w_odt_off_05T;
	}

	tRAS = (ACTime_DDR4_Final.tras > 0) ? (ACTime_DDR4_Final.tras - BGPIPEEN) : ACTime_DDR4_Final.tras;
	tRC = (ACTime_DDR4_Final.trc > 0) ? (ACTime_DDR4_Final.trc - BGPIPEEN) : ACTime_DDR4_Final.trc;
	tXP = (ACTime_DDR4_Final.txp > 0) ? (ACTime_DDR4_Final.txp - BGPIPEEN) : ACTime_DDR4_Final.txp;
	tRTP = (ACTime_DDR4_Final.trtp > 0) ? (ACTime_DDR4_Final.trtp - BGPIPEEN) : ACTime_DDR4_Final.trtp;
	tWR = (ACTime_DDR4_Final.twr > 0) ? (ACTime_DDR4_Final.twr - BGPIPEEN) : ACTime_DDR4_Final.twr;
	tpbR2pbR = (ACTime_DDR4_Final.tpbr2pbr > 0) ? (ACTime_DDR4_Final.tpbr2pbr - BGPIPEEN) : ACTime_DDR4_Final.tpbr2pbr;
	tpbR2act = (ACTime_DDR4_Final.tpbr2act > 0) ? (ACTime_DDR4_Final.tpbr2act - BGPIPEEN) : ACTime_DDR4_Final.tpbr2act;
	tFAW = (ACTime_DDR4_Final.tfaw > 0) ? (ACTime_DDR4_Final.tfaw - BGPIPEEN) : ACTime_DDR4_Final.tfaw;
	tRC_DERATE = (ACTime_DDR4_Final.trc_derate > 0) ? (ACTime_DDR4_Final.trc_derate - BGPIPEEN) : ACTime_DDR4_Final.trc_derate;

	if (cas_mod != 1) {
		XRTW2W = ACTime_DDR4_Final.xrtw2w_old_mode;

		if (DDR4_ODT_ON)
			XRTW2R = ACTime_DDR4_Final.xrtw2r_odt_on;
		else
			XRTW2R = ACTime_DDR4_Final.xrtw2r_odt_off;


		if (DDR4_ODT_ON)
			XRTR2W = ACTime_DDR4_Final.xrtr2w_odt_on;
		else
			XRTR2W = ACTime_DDR4_Final.xrtr2w_odt_off;

		XRTR2R = ACTime_DDR4_Final.xrtr2r_old_mode;

	} else { //CAS_mode = 1, low_freq mode
		if (DDR4_ODT_ON) {
			XRTW2R = ACTime_DDR4_Final.xrtw2r_odt_on_wck;
			XRTR2W = ACTime_DDR4_Final.xrtr2w_odt_on_wck;
		} else {
			XRTW2R = ACTime_DDR4_Final.xrtw2r_odt_off_wck;
			XRTR2W = ACTime_DDR4_Final.xrtr2w_odt_off_wck;
		}

		XRTW2W = ACTime_DDR4_Final.xrtw2w_old_mode;
		XRTR2R = ACTime_DDR4_Final.xrtr2r_old_mode;
	}

	if (vGet_Div_Mode(p)== DIV4_MODE) {
		tMANTMRR = 4;
		//tR2MRR   = 4;

	} else {
		tMANTMRR = 8;
		//tR2MRR   = 8;
	}

//	//vSetPHY2ChannelMapping(p, ch_id);
//
//	//[SV] bit need_fifo;
//	//[SV] need_fifo = (group_id == 0) ? 1'b0 : 1'b1;
	p->ShuRGAccessIdx = DRAM_DFS_REG_SHU0;//(group_id == 0) ? DRAM_DFS_REG_SHU0 : DRAM_DFS_REG_SHU1;

	//[SV] `LOG_PRINT("[FREQ_RELATED]",$psprintf("========>SHUFFLE GROUP:%2d, need_fifo:%2d, IMP golden setting Enter:",group_id, need_fifo),UVM_LOW);
//  mcSHOW_DBG_MSG("========>SHUFFLE GROUP:%2d, ShuRGAccessIdx:%2d, DDR4_AC_TIMING setting Enter:\n", group_id, p->ShuRGAccessIdx);

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_CKECTRL), P_Fld(ACTime_DDR4_Final.tpde_05T, SHU_CKECTRL_TPDE_05T) \
		| P_Fld(ACTime_DDR4_Final.tpdx_05T, SHU_CKECTRL_TPDX_05T) \
		| P_Fld(ACTime_DDR4_Final.tpde, SHU_CKECTRL_TPDE) \
		| P_Fld(ACTime_DDR4_Final.tpdx, SHU_CKECTRL_TPDX) \
		| P_Fld(ACTime_DDR4_Final.ckeprd, SHU_CKECTRL_TCKEPRD) \
		| P_Fld(tCKESRX, SHU_CKECTRL_TCKESRX));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM0), P_Fld(ACTime_DDR4_Final.twtr, SHU_ACTIM0_TWTR) \
		| P_Fld(tWR,  SHU_ACTIM0_TWR ) \
		| P_Fld(ACTime_DDR4_Final.trrd, SHU_ACTIM0_TRRD) \
		| P_Fld(ACTime_DDR4_Final.trcd, SHU_ACTIM0_TRCD) \
		| P_Fld(ACTime_DDR4_Final.ckelckcnt, SHU_ACTIM0_CKELCKCNT));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM1), P_Fld(tRC,  SHU_ACTIM1_TRC ) \
		| P_Fld(tRAS, SHU_ACTIM1_TRAS) \
		| P_Fld(ACTime_DDR4_Final.trp,  SHU_ACTIM1_TRP ) \
		| P_Fld(ACTime_DDR4_Final.tmrwckel,  SHU_ACTIM1_TMRWCKEL ) \
		| P_Fld(ACTime_DDR4_Final.trpab, SHU_ACTIM1_TRPAB));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM2), P_Fld(tFAW, SHU_ACTIM2_TFAW ) \
		| P_Fld(tR2W, SHU_ACTIM2_TR2W ) \
		| P_Fld(tRTP, SHU_ACTIM2_TRTP ) \
		| P_Fld(ACTime_DDR4_Final.tmrri, SHU_ACTIM2_TMRRI) \
		| P_Fld(tXP,  SHU_ACTIM2_TXP));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM3), P_Fld(ACTime_DDR4_Final.trfcpb, SHU_ACTIM3_TRFCPB ) \
		| P_Fld(ACTime_DDR4_Final.tr2mrr, SHU_ACTIM3_TR2MRR ) \
		| P_Fld(ACTime_DDR4_Final.trfc, SHU_ACTIM3_TRFC   ) \
		| P_Fld(tMANTMRR, SHU_ACTIM3_MANTMRR   ) \
		/* | P_Fld(tr2mrr  , SHU_ACTIM3_TR2MRR     ) \*/
		| P_Fld(ACTime_DDR4_Final.twtr_l, SHU_ACTIM3_TWTR_L));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM4), P_Fld(ACTime_DDR4_Final.txrefcnt, SHU_ACTIM4_TXREFCNT ) \
		| P_Fld(ACTime_DDR4_Final.tmrr2mrw, SHU_ACTIM4_TMRR2MRW ) \
		| P_Fld(ACTime_DDR4_Final.tmrr2w, SHU_ACTIM4_TMRR2W ) \
		| P_Fld(ACTime_DDR4_Final.tzqcs, SHU_ACTIM4_TZQCS));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM5), P_Fld(ACTime_DDR4_Final.trtpd, SHU_ACTIM5_TR2PD ) \
		| P_Fld(ACTime_DDR4_Final.twtpd, SHU_ACTIM5_TWTPD ) \
		| P_Fld(tpbR2pbR, SHU_ACTIM5_TPBR2PBR ) \
		/*| P_Fld(ACTime_DDR4_Final.bgtccd  , SHU_ACTIM5_BGTCCD   ) \*/
		| P_Fld(tpbR2act, SHU_ACTIM5_TPBR2ACT));


	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM6), P_Fld(ACTime_DDR4_Final.zqlat2, SHU_ACTIM6_TZQLAT2 ) \
		| P_Fld(ACTime_DDR4_Final.tmrd, SHU_ACTIM6_TMRD    ) \
		| P_Fld(ACTime_DDR4_Final.tmrw, SHU_ACTIM6_TMRW    ) \
		| P_Fld(ACTime_DDR4_Final.tw2mrw, SHU_ACTIM6_TW2MRW  ) \
		| P_Fld(ACTime_DDR4_Final.tr2mrw, SHU_ACTIM6_TR2MRW  ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM7), P_Fld(ACTime_DDR4_Final.tcsh_cscal, SHU_ACTIM7_TCSH_CSCAL ) \
		| P_Fld(ACTime_DDR4_Final.tcacsh, SHU_ACTIM7_TCACSH ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM7), P_Fld(ACTime_DDR4_Final.nwr_05T, SHU_ACTIM7_NWR_05T ) \
		| P_Fld(ACTime_DDR4_Final.nrbtp_05T, SHU_ACTIM7_NRBTP_05T ) );

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM8), P_Fld(ACTime_DDR4_Final.nwr, SHU_ACTIM8_NWR ) \
		| P_Fld(ACTime_DDR4_Final.nrbtp, SHU_ACTIM8_NRBTP ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM9), P_Fld(ACTime_DDR4_Final.trrd_l, SHU_ACTIM9_TRRD_L ) \
		|  P_Fld(ACTime_DDR4_Final.trrd_l_05T, SHU_ACTIM9_TRRD_L_05T ) \
		|  P_Fld(ACTime_DDR4_Final.tccd_l, SHU_ACTIM9_TCCD_L     ) \
		|  P_Fld(ACTime_DDR4_Final.tccd_l_05T, SHU_ACTIM9_TCCD_L_05T ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_LP5_CMD), P_Fld(ACTime_DDR4_Final.tcsh, SHU_LP5_CMD_TCSH ));


	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM_XRT), P_Fld(XRTW2W, SHU_ACTIM_XRT_XRTW2W ) \
		| P_Fld(XRTW2R, SHU_ACTIM_XRT_XRTW2R ) \
		| P_Fld(XRTR2W, SHU_ACTIM_XRT_XRTR2W ) \
		| P_Fld(XRTR2R, SHU_ACTIM_XRT_XRTR2R));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_WCKCTRL), P_Fld(ACTime_DDR4_Final.wckrdoff, SHU_WCKCTRL_WCKRDOFF ) \
		| P_Fld(ACTime_DDR4_Final.wckrdoff_05T, SHU_WCKCTRL_WCKRDOFF_05T ) \
		| P_Fld(ACTime_DDR4_Final.wckwroff, SHU_WCKCTRL_WCKWROFF ) \
		| P_Fld(ACTime_DDR4_Final.wckwroff_05T, SHU_WCKCTRL_WCKWROFF_05T));


	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_AC_DERATING0), P_Fld(ACTime_DDR4_Final.trcd_derate,
			SHU_AC_DERATING0_TRCD_DERATE ) \
		| P_Fld(ACTime_DDR4_Final.trrd_derate, SHU_AC_DERATING0_TRRD_DERATE ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_AC_DERATING1), P_Fld(ACTime_DDR4_Final.trpab_derate,
			SHU_AC_DERATING1_TRPAB_DERATE) \
		| P_Fld(ACTime_DDR4_Final.trp_derate, SHU_AC_DERATING1_TRP_DERATE ) \
		| P_Fld(ACTime_DDR4_Final.tras_derate, SHU_AC_DERATING1_TRAS_DERATE) \
		| P_Fld(tRC_DERATE, SHU_AC_DERATING1_TRC_DERATE ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_AC_DERATING_05T), P_Fld(ACTime_DDR4_Final.trpab_derate_05T,
			SHU_AC_DERATING_05T_TRPAB_05T_DERATE) \
		| P_Fld(ACTime_DDR4_Final.trp_derate_05T, SHU_AC_DERATING_05T_TRP_05T_DERATE ) \
		| P_Fld(ACTime_DDR4_Final.tras_derate_05T, SHU_AC_DERATING_05T_TRAS_05T_DERATE) \
		| P_Fld(ACTime_DDR4_Final.trrd_derate_05T, SHU_AC_DERATING_05T_TRRD_05T_DERATE) \
		| P_Fld(ACTime_DDR4_Final.trcd_derate_05T, SHU_AC_DERATING_05T_TRCD_05T_DERATE) \
		| P_Fld(ACTime_DDR4_Final.trc_derate_05T, SHU_AC_DERATING_05T_TRC_05T_DERATE ));


	//ac_timing_05T
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_AC_TIME_05T), P_Fld(ACTime_DDR4_Final.trc_05T,
			SHU_AC_TIME_05T_TRC_05T ) \
		| P_Fld(ACTime_DDR4_Final.trfcpb_05T, SHU_AC_TIME_05T_TRFCPB_05T ) \
		| P_Fld(ACTime_DDR4_Final.trfc_05T, SHU_AC_TIME_05T_TRFC_05T ) \
		| P_Fld(ACTime_DDR4_Final.tpbr2pbr_05T, SHU_AC_TIME_05T_TPBR2PBR_05T ) \
		| P_Fld(ACTime_DDR4_Final.txp_05T, SHU_AC_TIME_05T_TXP_05T ) \
		| P_Fld(ACTime_DDR4_Final.trtp_05T, SHU_AC_TIME_05T_TRTP_05T ) \
		| P_Fld(ACTime_DDR4_Final.trcd_05T, SHU_AC_TIME_05T_TRCD_05T ) \
		| P_Fld(ACTime_DDR4_Final.trp_05T, SHU_AC_TIME_05T_TRP_05T  ) \
		| P_Fld(ACTime_DDR4_Final.trpab_05T, SHU_AC_TIME_05T_TRPAB_05T ) \
		| P_Fld(ACTime_DDR4_Final.tras_05T, SHU_AC_TIME_05T_TRAS_05T ) \
		| P_Fld(ACTime_DDR4_Final.twr_05T, SHU_AC_TIME_05T_TWR_M05T  ) \
		| P_Fld(ACTime_DDR4_Final.trrd_05T, SHU_AC_TIME_05T_TRRD_05T ) \
		| P_Fld(ACTime_DDR4_Final.tfaw_05T, SHU_AC_TIME_05T_TFAW_05T ) \
		/*| P_Fld(ACTime_DDR4_Final.tCKEPRD_05T, SHU_AC_TIME_05T_TCKEPRD_05T ) \*/
		| P_Fld(ACTime_DDR4_Final.trtpd_05T, SHU_AC_TIME_05T_TR2PD_05T ) \
		| P_Fld(ACTime_DDR4_Final.twtpd_05T, SHU_AC_TIME_05T_TWTPD_M05T ) \
		| P_Fld(ACTime_DDR4_Final.tmrri_05T, SHU_AC_TIME_05T_TMRRI_05T ) \
		| P_Fld(ACTime_DDR4_Final.tmrwckel_05T, SHU_AC_TIME_05T_TMRWCKEL_05T ) \
		| P_Fld(ACTime_DDR4_Final.twtr_l_05T, SHU_AC_TIME_05T_BGTWTR_M05T ) \
		| P_Fld(tR2W_05T, SHU_AC_TIME_05T_TR2W_05T ) \
		| P_Fld(ACTime_DDR4_Final.twtr_05T, SHU_AC_TIME_05T_TWTR_M05T ) \
		| P_Fld(ACTime_DDR4_Final.tmrd_05T, SHU_AC_TIME_05T_TMRD_05T ) \
		| P_Fld(ACTime_DDR4_Final.tmrw_05T, SHU_AC_TIME_05T_TMRW_05T ) \
		| P_Fld(ACTime_DDR4_Final.tmrr2mrw_05T, SHU_AC_TIME_05T_TMRR2MRW_05T ) \
		| P_Fld(ACTime_DDR4_Final.tw2mrw_05T, SHU_AC_TIME_05T_TW2MRW_05T ) \
		| P_Fld(ACTime_DDR4_Final.tr2mrw_05T, SHU_AC_TIME_05T_TR2MRW_05T ) \
		| P_Fld(ACTime_DDR4_Final.tpbr2act_05T, SHU_AC_TIME_05T_TPBR2ACT_05T ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM8), P_Fld(ACTime_DDR4_Final.trfmpb, SHU_ACTIM8_TRFMPB ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_ACTIM7), P_Fld(ACTime_DDR4_Final.twtrap, SHU_ACTIM7_TWTRAP ) \
		| P_Fld(ACTime_DDR4_Final.twtrap_05T, SHU_ACTIM7_TWTRAP_05T ) \
		| P_Fld(ACTime_DDR4_Final.twtrap_l, SHU_ACTIM7_TWTRAP_L ) \
		| P_Fld(ACTime_DDR4_Final.twtrap_l_05T, SHU_ACTIM7_TWTRAP_L_05T ));
	//                                                          | P_Fld(ACTime_DDR4_Final.tmdy        , SHU_ACTIM7_TDMY ));

	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_HMR4_DVFS_CTRL0), P_Fld(0x64, SHU_HMR4_DVFS_CTRL0_FSPCHG_PRDCNT ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_SREF_CTRL), P_Fld(0x3, SHU_SREF_CTRL_SREF_CK_DLY ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_SREF_CTRL), P_Fld(0x3, SHU_SREF_CTRL_CKEHCMD ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_CKECTRL), P_Fld(0x3, SHU_CKECTRL_TCKESRX ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_MISC), P_Fld(0x7, SHU_MISC_DCMDLYREF ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_AC_DERATING0), P_Fld(ACDERATEEN, SHU_AC_DERATING0_ACDERATEEN  ));
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DRAMC_REG_SHU_HWSET_VRCG  ), P_Fld(ACTime_DDR4_Final.vrcgdis_prdcnt, SHU_HWSET_VRCG_VRCGDIS_PRDCNT));

	p->ShuRGAccessIdx = backup_ShuRGAccessIdx;
//mcSHOW_DBG_MSG("[test_sa.c]========>lp5_ac_timing_auto_setting Exit\n");
}

#endif


void DdrUpdateACTiming(DRAMC_CTX_T *p)
{
	U8 timing_idx = 0;

	timing_idx = u1GetACTimingIdx(p);

	if(timing_idx == 255){
		mcSHOW_DBG_MSG("[%s]AC_Timing mismatch. timing_idx = %0d, frequency = %0d\n",__FUNCTION__,timing_idx,p->freqGroup);
		ASSERT(0);
	}
	
#if SUPPORT_TYPE_PCDDR3
	if(is_ddr3_family(p))
		DDR3_ac_timing_setting(p,&ACTimingTbl_DDR3[timing_idx]);
	else
#endif
#if SUPPORT_TYPE_PCDDR4
	if(is_ddr4_family(p))
		DDR4_ac_timing_setting(p,&ACTimingTbl_DDR4[timing_idx]);
	else
#endif
	{
		/* For build error */
	}
}

