#include "drm_define.h"
#include "emi.h"
#include "dramc_common.h"
#include "dramc_int_global.h"
#include "x_hal_io.h"
#include "dramc_dv_init.h"
#include "dramc_top.h"
#include "spm_register.h"

#define EXIT_DRM_WITH_SAME_FREQ 1 //1:DRM out with the same freq
#ifdef DDR_RESERVE_MODE
//#define DDRPHY_AO_RANK_OFFSET 0x100
#define mcSHOW_DRM_MSG mcSHOW_DBG_MSG
#define CHAN_MODE 3 //1_chan: 1 2_chan: 3 //NEED_DE_NOTICE

#if CPU_RW_TEST_AFTER_K
extern void vDramCPUReadWriteTestAfterCalibration(DRAMC_CTX_T *p);
#endif

void DRM_DDR34_SWZQ(DRAMC_CTX_T *p,U8 rank)
{
    U8 temp_ZQC_RESPONSE = 0 ;
//    U8 i;
    U8 DIV2, DIV4, DIV8;


    mcSHOW_DBG_MSG("[DDR34_ZQ] RK:%d  Enter >>>>>>>>\n",rank);
    DIV2 = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHU_COMMON0), SHU_COMMON0_FDIV2) ;
    DIV4 = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHU_COMMON0), SHU_COMMON0_FREQDIV4) ;
    DIV8 = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SHU_COMMON0), SHU_COMMON0_FREQDIV8) ;
    //***************************SW_ZQ by rtswcmd******************************//
    vIO32WriteFldAlign_All(DRAMC_REG_SWCMD_EN, 0xC                , SWCMD_EN_RTSWCMD_SEL);                  //DRAMC_AO_BASE_ADDRESS + 0x0124[31:26]
    vIO32WriteFldAlign_All(DRAMC_REG_SWCMD_CTRL2, rank     & 0x1  , SWCMD_CTRL2_RTSWCMD_RK );               //DRAMC_AO_BASE_ADDRESS + 0x0130[11:10]
    if(DIV2)      vIO32WriteFldAlign_All(DRAMC_REG_RTSWCMD_CNT, 0x48            , RTSWCMD_CNT_RTSWCMD_CNT );
    else if(DIV4) vIO32WriteFldAlign_All(DRAMC_REG_RTSWCMD_CNT, 0x28            , RTSWCMD_CNT_RTSWCMD_CNT ); 
    else if(DIV8) vIO32WriteFldAlign_All(DRAMC_REG_RTSWCMD_CNT, 0x18            , RTSWCMD_CNT_RTSWCMD_CNT ); 
    vIO32WriteFldAlign_All(DRAMC_REG_SWCMD_EN, 1                  , SWCMD_EN_RTSWCMDEN); 

//V25//    for(i=CHANNEL_NUM;i>0;--i)
//V25//     for(i=1;i>0;--i)
//V25//     {
//V25//         vSetPHY2ChannelMapping(p, i-1);
        do
        {
            temp_ZQC_RESPONSE = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SPCMDRESP3), SPCMDRESP3_RTSWCMD_RESPONSE) ;
            //temp_ZQC_RESPONSE = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SPCMDRESP), SPCMDRESP_MRW_RESPONSE) ;
        } while ( temp_ZQC_RESPONSE != 1 );
//V25//     }

    vIO32WriteFldAlign_All(DRAMC_REG_SWCMD_EN, 0, SWCMD_EN_RTSWCMDEN);
    mcSHOW_DBG_MSG("[DDR34_ZQ] RK:%d  Exit <<<<<<<<\n",rank);
}

//static U32 u4DramType = 0;
static U32 u4ReserveRegBackupAddress[] =
{
#if DDR_TEMP_SENSOR_ENABLE
    (DRAMC_REG_HMR4),//MR4
#endif
    (DRAMC_REG_DRAMC_PD_CTRL),//PHY clk
    (DDRPHY_REG_B0_DQ5),//Verf en
    (DDRPHY_REG_B1_DQ5),//cc: Will be mappint to BRB0 by Hal. Skipped if to CHB
    (DDRPHY_REG_B0_RXDVS0),//RX tracking

//V25//    (DDRPHY_REG_B1_RXDVS0),
//V25//    (DDRPHY_REG_B1_RXDVS0 + SHIFT_TO_CHB_ADDR),//0x02E4

    (DDRPHY_REG_RK_B0_RXDVS2),

//V25//    (DDRPHY_REG_RK_B1_RXDVS2),
//V25//    (DDRPHY_REG_RK_B1_RXDVS2 + SHIFT_TO_CHB_ADDR),//0x01E8

    (DDRPHY_AO_RANK_OFFSET + DDRPHY_REG_RK_B0_RXDVS2),

    (DRAMC_REG_DUMMY_RD),//Dummy read

//    (DDRPHY_REG_MISC_CTRL1),//TX tracking reload from AO
//    (DDRPHY_REG_MISC_CTRL1 + SHIFT_TO_CHB_ADDR),//TX tracking reload from AO
//#if (CHANNEL_NUM > 2)
//    (DDRPHY_REG_MISC_CTRL1 + SHIFT_TO_CHC_ADDR),//TX tracking reload from AO
//    (DDRPHY_REG_MISC_CTRL1 + SHIFT_TO_CHD_ADDR),//TX tracking reload from AO
//#endif
};

#if (fcFOR_CHIP_ID != fcGriffin)
static U32 u4ReserveRegBackupAddress_X32[] =
{
    (DRAMC_REG_HMR4),//MR4
//V25//    (DRAMC_REG_HMR4 + SHIFT_TO_CHB_ADDR),//0x0220
#if (CHANNEL_NUM > 2)
    (DRAMC_REG_HMR4 + SHIFT_TO_CHC_ADDR),//0x0220
    (DRAMC_REG_HMR4 + SHIFT_TO_CHD_ADDR),//0x0220
#endif

    (DRAMC_REG_DRAMC_PD_CTRL),//PHY clk
//V25//    (DRAMC_REG_DRAMC_PD_CTRL + SHIFT_TO_CHB_ADDR),//0x01FC
#if (CHANNEL_NUM > 2)
    (DRAMC_REG_DRAMC_PD_CTRL + SHIFT_TO_CHC_ADDR),//0x01FC
    (DRAMC_REG_DRAMC_PD_CTRL + SHIFT_TO_CHD_ADDR),//0x01FC
#endif

    (DDRPHY_REG_B0_DQ5),//Verf en
    (DDRPHY_REG_B0_DQ5 + SHIFT_TO_CHB_ADDR),//0x0188
#if (CHANNEL_NUM > 2)
    (DDRPHY_REG_B0_DQ5 + SHIFT_TO_CHC_ADDR),//0x0188
    (DDRPHY_REG_B0_DQ5 + SHIFT_TO_CHD_ADDR),//0x0188
#endif

    (DDRPHY_REG_B1_DQ5),
    (DDRPHY_REG_B1_DQ5 + SHIFT_TO_CHB_ADDR),//0x0308
#if (CHANNEL_NUM > 2)
    (DDRPHY_REG_B1_DQ5 + SHIFT_TO_CHC_ADDR),//0x0308
    (DDRPHY_REG_B1_DQ5 + SHIFT_TO_CHD_ADDR),//0x0308
#endif

    (DDRPHY_REG_B0_RXDVS0),//RX tracking
    (DDRPHY_REG_B0_RXDVS0 + SHIFT_TO_CHB_ADDR),//0x0164
#if (CHANNEL_NUM > 2)
    (DDRPHY_REG_B0_RXDVS0 + SHIFT_TO_CHC_ADDR),//0x0164
    (DDRPHY_REG_B0_RXDVS0 + SHIFT_TO_CHD_ADDR),//0x0164
#endif

    (DDRPHY_REG_B1_RXDVS0),
    (DDRPHY_REG_B1_RXDVS0 + SHIFT_TO_CHB_ADDR),//0x02E4
#if (CHANNEL_NUM > 2)
    (DDRPHY_REG_B1_RXDVS0 + SHIFT_TO_CHC_ADDR),//0x02E4
    (DDRPHY_REG_B1_RXDVS0 + SHIFT_TO_CHD_ADDR),//0x02E4
#endif

    (DDRPHY_REG_RK_B0_RXDVS2),
    (DDRPHY_REG_RK_B0_RXDVS2 + SHIFT_TO_CHB_ADDR),//0x0068
#if (CHANNEL_NUM > 2)
    (DDRPHY_REG_RK_B0_RXDVS2 + SHIFT_TO_CHC_ADDR),//0x0068
    (DDRPHY_REG_RK_B0_RXDVS2 + SHIFT_TO_CHD_ADDR),//0x0068
#endif

    (DDRPHY_REG_RK_B1_RXDVS2),
    (DDRPHY_REG_RK_B1_RXDVS2 + SHIFT_TO_CHB_ADDR),//0x01E8
#if (CHANNEL_NUM > 2)
    (DDRPHY_REG_RK_B1_RXDVS2 + SHIFT_TO_CHC_ADDR),//0x01E8
    (DDRPHY_REG_RK_B1_RXDVS2 + SHIFT_TO_CHD_ADDR),//0x01E8
#endif

    (DDRPHY_AO_RANK_OFFSET + DDRPHY_REG_RK_B0_RXDVS2),
    (DDRPHY_AO_RANK_OFFSET + DDRPHY_REG_RK_B0_RXDVS2 + SHIFT_TO_CHB_ADDR),  //0x00E8
#if (CHANNEL_NUM > 2)
    (DDRPHY_AO_RANK_OFFSET + DDRPHY_REG_RK_B0_RXDVS2 + SHIFT_TO_CHC_ADDR),  //0x00E8
    (DDRPHY_AO_RANK_OFFSET + DDRPHY_REG_RK_B0_RXDVS2 + SHIFT_TO_CHD_ADDR),  //0x00E8
#endif

    (DDRPHY_AO_RANK_OFFSET + DDRPHY_REG_RK_B1_RXDVS2),
    (DDRPHY_AO_RANK_OFFSET + DDRPHY_REG_RK_B1_RXDVS2 + SHIFT_TO_CHB_ADDR),  //0x0268
#if (CHANNEL_NUM > 2)
    (DDRPHY_AO_RANK_OFFSET + DDRPHY_REG_RK_B1_RXDVS2 + SHIFT_TO_CHC_ADDR),  //0x0268
    (DDRPHY_AO_RANK_OFFSET + DDRPHY_REG_RK_B1_RXDVS2 + SHIFT_TO_CHD_ADDR),  //0x0268
#endif

    (DRAMC_REG_DUMMY_RD),//Dummy read
//V25//    (DRAMC_REG_DUMMY_RD + SHIFT_TO_CHB_ADDR),//0x0110
#if (CHANNEL_NUM > 2)
    (DRAMC_REG_DUMMY_RD + SHIFT_TO_CHC_ADDR),//0x0110
    (DRAMC_REG_DUMMY_RD + SHIFT_TO_CHD_ADDR),//0x0110
#endif

    (DDRPHY_REG_MISC_CTRL1),//TX tracking reload from AO
    (DDRPHY_REG_MISC_CTRL1 + SHIFT_TO_CHB_ADDR),//TX tracking reload from AO
#if (CHANNEL_NUM > 2)
    (DDRPHY_REG_MISC_CTRL1 + SHIFT_TO_CHC_ADDR),//TX tracking reload from AO
    (DDRPHY_REG_MISC_CTRL1 + SHIFT_TO_CHD_ADDR),//TX tracking reload from AO
#endif

    (DDRPHY_MD32_REG_LPIF_FSM_CFG_1),
#if (CHANNEL_NUM > 2)
    (DDRPHY_MD32_REG_LPIF_FSM_CFG_1 + SHIFT_TO_CHB_ADDR),
#endif
};
#endif

void MD32_init(void)
{
    DRAMC_CTX_T *p;
    p = psCurrDramCtx;

    mcSHOW_DRM_MSG("[mem.c]CFC setting for MD32 NAO start\n");
////  *((UINT32P)(MD32DR_CH0_BASE + 0x47034)) |= ( 0x1);//legacy
//  *((UINT32P)(MD32DR_CH0_BASE + 0x47020)) |= ( 0x10000000);
//  *((UINT32P)(MD32DR_CH0_BASE + 0x47004)) &= (~0xF003);
//  *((UINT32P)(MD32DR_CH0_BASE + 0x47008)) &= (~0xC0000);
//  *((UINT32P)(MD32DR_CH0_BASE + 0x4700C)) &= (~0x70);
//  *((UINT32P)(MD32DR_CH0_BASE + 0x4703C)) &= (~0xC03000);
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_0, 0x0,LPIF_LOW_POWER_CFG_0_MEM_CK_OFF);          //0x47004[15:14]
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_2, 0x0, LPIF_LOW_POWER_CFG_2_DPY_MODE_SW);
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_0, 0x0, LPIF_LOW_POWER_CFG_0_EMI_CLK_OFF_REQ);
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_0, 0x0, LPIF_LOW_POWER_CFG_0_DMSUS_OFF);
    mcDELAY_XUS(1);

    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_FSM_CFG_1, 0, LPIF_FSM_CFG_1_LPIF_LEGACY_CONTROL);              //0x47034[0], NEED_DE_NOTICE
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_FSM_CTRL_0, 0x1,LPIF_FSM_CTRL_0_LP_INTF_OUT_ENABLE);            //0x47020[28]

    mcSHOW_DRM_MSG("[mem.c]CFC setting for MD32 NAO end\n");
}

void LP_Mode_DRM_Setting(void)
{
    DRAMC_CTX_T * p;
//    U32 temp;
    p = psCurrDramCtx;
    U32 backup_broadcast = GetDramcBroadcast();
    DramcBroadcastOnOff(DRAMC_BROADCAST_ON);

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL7, 1, MISC_CG_CTRL7_MEM_DCM_FORCE_ON_EXT);
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL2, 0, MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG);
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL2, 1, MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG);
    vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CLK_CTRL,
                     P_Fld(0x1, MISC_CLK_CTRL_DVFS_CLK_MEM_SEL) | // by "sel_source"
                     P_Fld(0x0, MISC_CLK_CTRL_DVFS_MEM_CK_MUX_SEL_MODE) | // HW mode by shuffle
                     P_Fld(0x1, MISC_CLK_CTRL_DVFS_MEM_CK_MUX_SEL)); // 4-to-1 mux from PLLCK if DVFS_MEM_CK_MUX_SEL_MODE = 2

    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

#if (FOR_DV_SIMULATION_USED == 1)
    ANA_top_config_T *a_cfg = A_T;
    vSetPHY2ChannelMapping(p, CHANNEL_A);
    if(a_cfg->ASYNC_MODE == 0)//8139, Panther
    {
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CKMUX_SEL  )  , P_Fld(   1             , MISC_CKMUX_SEL_FMEM_CK_MUX ));
    #if (CHANNEL_NUM > 1)
	vSetPHY2ChannelMapping(p, CHANNEL_B);
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CKMUX_SEL  )  , P_Fld(   3             , MISC_CKMUX_SEL_FMEM_CK_MUX ));
    #endif
        //only set at dsim, TBA can't & need not. 
        //#define INFRACFG_AO_MEM_BASE (0x10002000)
        //#define TOP_CK_ANCHOR_CFG	((UINT32P)(INFRACFG_AO_MEM_BASE+0x038))
        //Please confirm addr
        //*TOP_CK_ANCHOR_CFG   |= ((0x1 << 28) | (0x1 << 30));
    }
    else if(a_cfg->ASYNC_MODE == 2)
    {
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CKMUX_SEL  )  , P_Fld(   0             , MISC_CKMUX_SEL_FMEM_CK_MUX ));
    #if (CHANNEL_NUM > 1)
	vSetPHY2ChannelMapping(p, CHANNEL_B);
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CKMUX_SEL  )  , P_Fld(   2             , MISC_CKMUX_SEL_FMEM_CK_MUX ));
    #endif
    }
    else//LePin, Figeac, Montrose
    {
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CKMUX_SEL  )  , P_Fld(   0             , MISC_CKMUX_SEL_FMEM_CK_MUX ));
    #if (CHANNEL_NUM > 1)
	vSetPHY2ChannelMapping(p, CHANNEL_B);
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CKMUX_SEL  )  , P_Fld(   0             , MISC_CKMUX_SEL_FMEM_CK_MUX ));
    #endif
    }
    vSetPHY2ChannelMapping(p, CHANNEL_A);
#else//TBD: need SA change
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CKMUX_SEL  )  , P_Fld(   1             , MISC_CKMUX_SEL_FMEM_CK_MUX ));
	vSetPHY2ChannelMapping(p, CHANNEL_B);
	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CKMUX_SEL  )  , P_Fld(   3             , MISC_CKMUX_SEL_FMEM_CK_MUX ));
	vSetPHY2ChannelMapping(p, CHANNEL_A);
#endif
    DramcBroadcastOnOff(DRAMC_BROADCAST_ON);
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL0, 1, MISC_CG_CTRL0_RESERVED_MISC_CG_CTRL0_BIT3_1);
    mcDELAY_XUS(1);
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL0, 0, MISC_CG_CTRL0_RESERVED_MISC_CG_CTRL0_BIT3_1);

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL0, 1, MISC_CG_CTRL0_CLK_MEM_SEL);
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL0, 1, MISC_CG_CTRL0_W_CHG_MEM);
    mcDELAY_XUS(1);
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL0, 0, MISC_CG_CTRL0_W_CHG_MEM);

        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL0,  1, MISC_CG_CTRL0_RG_FREERUN_MCK_CG );

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL10, 1, MISC_CG_CTRL10_CLK_MEM_SEL_MCK8X);
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL10, 1, MISC_CG_CTRL10_W_CHG_MEM_MCK8X);
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL10, 0, MISC_CG_CTRL10_W_CHG_MEM_MCK8X);
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL0, 1, MISC_CG_CTRL0_RESERVED_MISC_CG_CTRL0_BIT7);
    DramcBroadcastOnOff(backup_broadcast);
}

void ASVA5_8_New_Mode_1(void)
{
//    U32 u4WbrBackup = 0;
//    U32 u4value = 0;
    DRAMC_CTX_T * p;
    p = psCurrDramCtx;
//    BOOL bSupport2Rank = (u4IO32ReadFldAlign(DRAMC_REG_SA_RESERVE, SA_RESERVE_SINGLE_RANK) == 0) ? TRUE : FALSE;
	Init_Dram_Ctx_By_Type(psCurrDramCtx, is_use_ddr4 ? TYPE_DDR4 : TYPE_DDR3);
    MD32_init();

    vSetChannelNumber(p);
    vSetRankNumber(p);

    mcSHOW_DRM_MSG("ASVA5_8_New_Mode_1\n");

#if DDR_IMPEDANCE_TRACKING_ENABLE
    mcSHOW_DRM_MSG("Disable IMP tracking\n");
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_IMPCAL, 0, MISC_IMPCAL_IMPCAL_HW);
#endif

  if (is_lp5_family(p) ||  u1IsLP4Family(p->dram_type))
  {
#if DDR_ENABLE_TX_TRACKING
    mcSHOW_DRM_MSG("Disable DQSOSC\n");
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DRAMC_REG_RK_DQSOSC), 0, RK_DQSOSC_DQSOSCR_RK0EN);
    if ((bSupport2Rank == TRUE))
    {
        vSetRank(p, RANK_1);
        vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DRAMC_REG_RK_DQSOSC), 0, RK_DQSOSC_DQSOSCR_RK0EN);
    }
    vSetRank(p, RANK_0);
#endif
  }
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_LP_CTRL,1,MISC_LP_CTRL_RG_ARDMSUS_10);
    vIO32WriteFldAlign_All(DDRPHY_REG_B0_LP_CTRL0 ,1,  B0_LP_CTRL0_RG_ARDMSUS_10_B0);
    vIO32WriteFldAlign_All(DDRPHY_REG_B1_LP_CTRL0 ,1,  B1_LP_CTRL0_RG_ARDMSUS_10_B1);
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_LP_CTRL0 ,1,  CA_LP_CTRL0_RG_ARDMSUS_10_CA);

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_LP_CTRL,0,MISC_LP_CTRL_RG_ARDMSUS_10_LP_SEL);
    vIO32WriteFldAlign_All(DDRPHY_REG_B0_LP_CTRL0 ,0,  B0_LP_CTRL0_RG_ARDMSUS_10_B0_LP_SEL);
    vIO32WriteFldAlign_All(DDRPHY_REG_B1_LP_CTRL0 ,0,  B1_LP_CTRL0_RG_ARDMSUS_10_B1_LP_SEL);
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_LP_CTRL0 ,0,  CA_LP_CTRL0_RG_ARDMSUS_10_CA_LP_SEL);

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE,0,MISC_DDR_RESERVE_WDT_LITE_EN);
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE,1,MISC_DDR_RESERVE_WDT_SM_CLR);
}

void ASVA5_8_CSCA_Pull_Down_EN(void)
{
//    U32 u4WbrBackup = 0;
//    U32 u4value = 0;
    DRAMC_CTX_T * p;
    p = psCurrDramCtx;

    mcSHOW_DRM_MSG("ASVA5_8_CSCA_Pull_Down_EN\n");
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD7, 1, CA_CMD7_RG_TX_ARCS0_PULL_DN); //DDRPHY_AO_BASE_ADDRESS + 0x0490[4]
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD7, 1, CA_CMD7_RG_TX_ARCS1_PULL_DN); //DDRPHY_AO_BASE_ADDRESS + 0x0490[8]
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD7, 1, CA_CMD7_RG_TX_ARCMD_PULL_DN); //DDRPHY_AO_BASE_ADDRESS + 0x0490[6]
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_LP_CTRL0, 0, CA_LP_CTRL0_RG_TX_ARCS_PULL_DN_LP_SEL);//DDRPHY_AO_BASE_ADDRESS + 0x0460[3]
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_LP_CTRL0, 0, CA_LP_CTRL0_RG_TX_ARCA_PULL_DN_LP_SEL);//DDRPHY_AO_BASE_ADDRESS + 0x0460[1]
}

void ASVA5_8_CSCA_Pull_Down_DIS(void)
{
//    U32 u4WbrBackup = 0;
//    U32 u4value = 0;
    DRAMC_CTX_T * p;
    p = psCurrDramCtx;

    mcSHOW_DRM_MSG("ASVA5_8_CSCA_Pull_Down_DIS\n");
//    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD7, 1, CA_CMD7_RG_TX_ARCS0_PULL_DN);
//    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD7, 1, CA_CMD7_RG_TX_ARCS1_PULL_DN);
//    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD7, 1, CA_CMD7_RG_TX_ARCMD_PULL_DN);
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_LP_CTRL0, 1, CA_LP_CTRL0_RG_TX_ARCS_PULL_DN_LP_SEL);//DDRPHY_AO_BASE_ADDRESS + 0x0460[3]
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_LP_CTRL0, 1, CA_LP_CTRL0_RG_TX_ARCA_PULL_DN_LP_SEL);//DDRPHY_AO_BASE_ADDRESS + 0x0460[1]
}

void ASVA5_8_New_Mode_2(void)
{
//    U32 u4WbrBackup = 0;
//    U32 u4value = 0;
    DRAMC_CTX_T * p;
    p = psCurrDramCtx;

    mcSHOW_DRM_MSG("ASVA5_8_New_Mode_2\n");

    ASVA5_8_CSCA_Pull_Down_EN();

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_LP_CTRL,1,MISC_LP_CTRL_RG_ARDMSUS_10_LP_SEL);
    vIO32WriteFldAlign_All(DDRPHY_REG_B0_LP_CTRL0 ,1,  B0_LP_CTRL0_RG_ARDMSUS_10_B0_LP_SEL);
    vIO32WriteFldAlign_All(DDRPHY_REG_B1_LP_CTRL0 ,1,  B1_LP_CTRL0_RG_ARDMSUS_10_B1_LP_SEL);
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_LP_CTRL0 ,1,  CA_LP_CTRL0_RG_ARDMSUS_10_CA_LP_SEL);

    ASVA5_8_CSCA_Pull_Down_DIS();
}

void ASVA5_8_New_Mode_3(void)
{
//    U32 u4WbrBackup = 0;
//    U32 u4value = 0;
    DRAMC_CTX_T * p;
    p = psCurrDramCtx;

    mcSHOW_DRM_MSG("ASVA5_8_New_Mode_3\n");

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE,0,MISC_DDR_RESERVE_WDT_SM_CLR);
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE,1,MISC_DDR_RESERVE_WDT_LITE_EN);
}

void ASVA5_8_IPMV2(void)
{
  DRAMC_CTX_T * p;
//  U32 temp;
  p = psCurrDramCtx;

    if(u4IO32ReadFldAlign(DDRPHY_REG_MISC_DDR_RESERVE, MISC_DDR_RESERVE_WDT_LITE_EN)==0)
    {
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE , 0,     MISC_DDR_RESERVE_WDT_SM_CLR);
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE3, 0x1FF, MISC_DDR_RESERVE3_DRM_SM_PASS_CTRL);    
        mcDELAY_XUS(1);
        vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE , 1,     MISC_DDR_RESERVE_WDT_LITE_EN);
    }

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE3, 0x1FF, MISC_DDR_RESERVE3_DRM_SM_PASS_CTRL);  
  
    mcSHOW_DRM_MSG("[mem.c]DRM_ASVA5_8_IPMV2 start\n");
    
    while ( u4IO32ReadFldAlign(DDRPHY_REG_MISC_DDR_RESERVE_STATE ,                    MISC_DDR_RESERVE_STATE_WDT_SM) !=9);//0x1520[3:0]
#if (CHANNEL_NUM > 1)
    while ( u4IO32ReadFldAlign(DDRPHY_REG_MISC_DDR_RESERVE_STATE + SHIFT_TO_CHB_ADDR, MISC_DDR_RESERVE_STATE_WDT_SM) !=9);
#endif
#if (CHANNEL_NUM > 2)
    while ( u4IO32ReadFldAlign(DDRPHY_REG_MISC_DDR_RESERVE_STATE + SHIFT_TO_CHC_ADDR, MISC_DDR_RESERVE_STATE_WDT_SM) !=9);
    while ( u4IO32ReadFldAlign(DDRPHY_REG_MISC_DDR_RESERVE_STATE + SHIFT_TO_CHD_ADDR, MISC_DDR_RESERVE_STATE_WDT_SM) !=9);
#endif
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE3, 0x8004, MISC_DDR_RESERVE3_DRM_SM_PASS_CTRL);

    ASVA5_8_CSCA_Pull_Down_EN();

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE2, 0x400, MISC_DDR_RESERVE2_DRM_SM_HOLD_CTRL);//0x6f4[31:16]

    ASVA5_8_CSCA_Pull_Down_DIS();
    mcSHOW_DRM_MSG("[mem.c]DRM_ASVA5_8_IPMV2 end\n");
}

void wait_SREFx(void)
{
    DRAMC_CTX_T * p;
//    U32 temp;
    p = psCurrDramCtx;
    mcSHOW_DRM_MSG("[mem.c]wait_SREFx start\n");
    
    while ( u4IO32ReadFldAlign(DRAMC_REG_MISC_STATUSA ,                    MISC_STATUSA_SREF_STATE) !=0);//DRAMC_NAO_BASE_ADDRESS + 0x0080[16]
#if (CHANNEL_NUM > 1)
    while ( u4IO32ReadFldAlign(DRAMC_REG_MISC_STATUSA + SHIFT_TO_CHB_ADDR, MISC_STATUSA_SREF_STATE) !=0);
#endif
#if (CHANNEL_NUM > 2)
    while ( u4IO32ReadFldAlign(DRAMC_REG_MISC_STATUSA + SHIFT_TO_CHC_ADDR, MISC_STATUSA_SREF_STATE) !=0);
    while ( u4IO32ReadFldAlign(DRAMC_REG_MISC_STATUSA + SHIFT_TO_CHD_ADDR, MISC_STATUSA_SREF_STATE) !=0);
#endif

    mcSHOW_DRM_MSG("[mem.c]wait_SREFx end\n");
}


#if LOG_ONLY_VALUE
void dump_SR(DRAMC_CTX_T * p, U32 u4DramType)
{
    DRAM_CHANNEL_T bkChannel = vGetPHY2ChannelMapping(p);
    U8 u1channel = CHANNEL_A;
    U32 u4value = 0;

    for(u1channel = CHANNEL_A; u1channel < p->support_channel_num; u1channel++)
    {
        vSetPHY2ChannelMapping(p, u1channel);
        u4value = u4IO32ReadFldAlign(DRAMC_REG_MISC_STATUSA, MISC_STATUSA_SREF_STATE);
        mcSHOW_ERR_MSG("###CH%d SREF_STATE [0x%X]\n", u1channel, u4value);
    }
    vSetPHY2ChannelMapping(p, bkChannel);
    return;
}
#endif

void dump_last_dramc(DRAMC_CTX_T * p)
{
    DRAM_CHANNEL_T bkChannel = vGetPHY2ChannelMapping(p);
    U8 u1channel = CHANNEL_A;
    U32 u4value = 0;

    mcSHOW_DRM_MSG("@@@ p->support_channel_num=%d \n",p->support_channel_num);
    for(u1channel = CHANNEL_A; u1channel < p->support_channel_num; u1channel++)
    {
        vSetPHY2ChannelMapping(p, u1channel);
        u4value = u4IO32Read4B(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL));
        mcSHOW_ERR_MSG("@ DDR reserve CH%d last_dramc[0x%x]\n", u1channel, u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_DRAMC_GATING_ERROR_FROM_AO);
        mcSHOW_ERR_MSG("@ GATING_ERROR[%d]\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RD_TEST_DM_CMP_CPT2_RK0_FROM_AO);
        mcSHOW_ERR_MSG("@ RD_TEST_DM_CMP_CPT2_RK0[%d]\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RD_TEST_DM_CMP_CPT2_RK1_FROM_AO);
        mcSHOW_ERR_MSG("@ RD_TEST_DM_CMP_CPT2_RK1[%d]\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RD_TEST_DM_CMP_ERR2_RK0_FROM_AO);
        mcSHOW_ERR_MSG("@ RD_TEST_DM_CMP_ERR2_RK0[%d] <-Ignore (w/o test)\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RD_TEST_DM_CMP_ERR2_RK1_FROM_AO);
        mcSHOW_ERR_MSG("@ RD_TEST_DM_CMP_ERR2_RK1[%d] <-Ignore (w/o test)\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RD_TEST_DLE_CNT_OK2_RK0_FROM_AO);
        mcSHOW_ERR_MSG("@ RD_TEST_DLE_CNT_OK2_RK0[%d]\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RD_TEST_DLE_CNT_OK2_RK1_FROM_AO);
        mcSHOW_ERR_MSG("@ RD_TEST_DLE_CNT_OK2_RK1[%d]\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DM_CMP_CPT2_RK0_FROM_AO);
        mcSHOW_ERR_MSG("@ RDWR_TEST_DM_CMP_CPT2_RK0[%d]\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DM_CMP_CPT2_RK1_FROM_AO);
        mcSHOW_ERR_MSG("@ RDWR_TEST_DM_CMP_CPT2_RK1[%d]\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DM_CMP_ERR2_RK0_FROM_AO);
        mcSHOW_ERR_MSG("@ RDWR_TEST_DM_CMP_ERR2_RK0[%d]\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DM_CMP_ERR2_RK1_FROM_AO);
        mcSHOW_ERR_MSG("@ RDWR_TEST_DM_CMP_ERR2_RK1[%d]\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DLE_CNT_OK2_RK0_FROM_AO);
        mcSHOW_ERR_MSG("@ RDWR_TEST_DLE_CNT_OK2_RK0[%d]\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_WDT_DBG_SIGNAL), WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DLE_CNT_OK2_RK1_FROM_AO);
        mcSHOW_ERR_MSG("@ RDWR_TEST_DLE_CNT_OK2_RK1[%d]\n", u4value);

        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_MISC_STATUSA), MISC_STATUSA_SREF_STATE);
        mcSHOW_ERR_MSG("@ Check DRAMC enter Self-Refresh-> MISC_STATUSA_SREF_STATE=[0x%x]\n", u4value);
    }
    vSetPHY2ChannelMapping(p, bkChannel);
    return;
}

void dump_gating_error_rg(DRAMC_CTX_T * p)
{
    DRAM_CHANNEL_T bkChannel = vGetPHY2ChannelMapping(p);
    U8 u1channel = CHANNEL_A;
    U32 u4value = 0;

    for(u1channel = CHANNEL_A; u1channel < p->support_channel_num; u1channel++)
    {
        vSetPHY2ChannelMapping(p, u1channel);
        u4value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_MISC_STATUSA), MISC_STATUSA_SREF_STATE);
        mcSHOW_ERR_MSG("###DDR reserve CH%d Self Refresh State [0x%x]\n", u1channel, u4value);
        u4value = u4IO32Read4B(DRAMC_REG_ADDR(DDRPHY_REG_MISC_STBERR_ALL));
        mcSHOW_ERR_MSG("###DDR reserve CH%d DDRPHY_REG_MISC_STBERR_ALL [0x%x]\n", u1channel, u4value);
        u4value = u4IO32Read4B(DRAMC_REG_ADDR(DDRPHY_REG_MISC_RD_DET_ERR_FLAG_B0));
        mcSHOW_ERR_MSG("###DDR reserve CH%d DDRPHY_REG_MISC_RD_DET_ERR_FLAG_B0 [0x%x]\n", u1channel, u4value);
#if (fcFOR_CHIP_ID == fcGriffin)
		channel_backup_and_set(p, CHANNEL_B);
		u4value = u4IO32Read4B(DRAMC_REG_ADDR(DDRPHY_REG_MISC_RD_DET_ERR_FLAG_B0));
		mcSHOW_ERR_MSG("###DDR reserve CH%d DDRPHY_REG_MISC_RD_DET_ERR_FLAG_B1 [0x%x]\n", u1channel, u4value);
		u4value = u4IO32Read4B(DRAMC_REG_ADDR(DDRPHY_REG_CAL_DQSG_CNT_B0));
		mcSHOW_ERR_MSG("###DDR reserve CH%d DDRPHY_REG_CAL_DQSG_CNT_B1 [0x%x]\n", u1channel, u4value);
		channel_restore(p);
#endif
        u4value = u4IO32Read4B(DRAMC_REG_ADDR(DDRPHY_REG_CAL_DQSG_CNT_B0));
        mcSHOW_ERR_MSG("###DDR reserve CH%d DDRPHY_REG_CAL_DQSG_CNT_B0 [0x%x]\n", u1channel, u4value);
        u4value = u4IO32Read4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_DLY));
        mcSHOW_ERR_MSG("###DDR reserve CH%d DDRPHY_REG_SHU_RK_B0_DQSIEN_DLY RK0[0x%x]\n", u1channel, u4value);
        u4value = u4IO32Read4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_DLY + DDRPHY_AO_RANK_OFFSET));
        mcSHOW_ERR_MSG("###DDR reserve CH%d DDRPHY_REG_SHU_RK_B0_DQSIEN_DLY RK1[0x%x]\n", u1channel, u4value);
		u4value = u4IO32Read4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_DLY));
        mcSHOW_ERR_MSG("###DDR reserve CH%d DDRPHY_REG_SHU_RK_B1_DQSIEN_DLY RK0[0x%x]\n", u1channel, u4value);
        u4value = u4IO32Read4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_DLY + DDRPHY_AO_RANK_OFFSET));
        mcSHOW_ERR_MSG("###DDR reserve CH%d DDRPHY_REG_SHU_RK_B1_DQSIEN_DLY RK1[0x%x]\n", u1channel, u4value);
    }
    vSetPHY2ChannelMapping(p, bkChannel);
    return;
}

void Dramc_DDR_Reserved_Mode_setting(void)
{
//    U32 u4WbrBackup = 0;
//    U32 u4value = 0;
    U32 backup_broadcast = GetDramcBroadcast();
    DRAMC_CTX_T * p;
    p = psCurrDramCtx;
    U32 u4SramShuLevel = 0;
    U32 u4ConfShuLevel = 0;
//    U32 MIDPI_set = 0;
//    U32 MIDPI_CA = 0;
//    U32 MIDPI_B0 = 0;
    U8  DVFS_CLK_MEM_SEL = 0;
//V25//    U32 MIDPI_B1 = 0;
//V25//    U32 MIDPI_B2 = 0;
//    unsigned int temp;

	Init_Dram_Ctx_By_Type(psCurrDramCtx, is_use_ddr4 ? TYPE_DDR4 : TYPE_DDR3);
    MD32_init();
#if (FOR_DV_SIMULATION_USED == 0)
#if EXIT_DRM_WITH_SAME_FREQ
    mcSHOW_DRM_MSG("@@@ Out DRM with the same freq\n");
    vSetDFSTable(p, get_FreqTbl_by_shuffleIndex(p, SRAM_SHU0)); /* Cheetah only SH0 */
    DDRPhyFreqSel(p, p->pDFSTable->freq_sel);
#else
    p->frequency = u2DFSGetHighestFreq(p);
    vSetDFSTable(p, get_FreqTbl_by_shuffleIndex(p, SRAM_SHU0));
#endif
    mcSHOW_DRM_MSG("@@@ Out DRM with DDR[%d]\n", p->frequency << 1);
    //vSetChannelNumber(p);
    vSetRankNumber(p);
#else
    if(p->support_channel_num !=2)
    {
        mcSHOW_DRM_MSG("Set DRAMC Dual Channel\n");//FOR_DV_SIMULATION_USE, never delet
        p->support_channel_num = 2;//FOR_DV_SIMULATION_USE, never delet
    }
#endif

    Set_DRAM_Pinmux_Sel(p);
    DramcDUTTopSet(p, NULL);
    DramcDUTShuSet(p, NULL, DRAM_DFS_REG_SHU0);
    //DramcHWFuncSet(p, NULL);
    dump_last_dramc(p);

    u4ConfShuLevel = u4IO32ReadFldAlign(DDRPHY_MD32_REG_LPIF_STATUS_10, LPIF_STATUS_10_DRAMC_DR_SHU_LEVEL);
    u4ConfShuLevel = u4ConfShuLevel & 0x3;

    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

    mcSHOW_DRM_MSG("@@@ %d, %d\n", u4SramShuLevel, u4ConfShuLevel);
    vIO32WriteFldAlign_All(DRAMC_REG_SWCMD_EN, 0x0, SWCMD_EN_RTSWCMDEN);//DRAMC_AO_BASE_ADDRESS + 0x0124[25], walk around for PC4 RTSWCMD trigger before reset

    mcSHOW_DRM_MSG("@@@ DOE15. WDT_SM=[%x]\n", u4IO32ReadFldAlign(DDRPHY_REG_MISC_DDR_RESERVE_STATE, MISC_DDR_RESERVE_STATE_WDT_SM) );

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE2, 0x600, MISC_DDR_RESERVE2_DRM_SM_HOLD_CTRL);//0x6f4[31:16]
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE3, 0xFF, MISC_DDR_RESERVE3_DRM_SM_PASS_CTRL);
    mcDELAY_XUS(1);
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE3, 0x8004,  MISC_DDR_RESERVE3_DRM_SM_PASS_CTRL);//CFC IPM V2.4 0x6f8[15: 0]

    vIO32WriteFldMulti_All(DRAMC_REG_TEST2_A3, P_Fld(  0                ,TEST2_A3_TEST2W             ) \
                                               | P_Fld(  0          ,TEST2_A3_TEST2R               ));
    mcSHOW_DRM_MSG("To 26MHz\n");

    DVFS_CLK_MEM_SEL = u4IO32ReadFldAlign(DDRPHY_REG_MISC_CLK_CTRL, MISC_CLK_CTRL_DVFS_CLK_MEM_SEL);//Use the second MRW{MR13 VRCG=0} of DFS as reference to meet SPEC tFC
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CLK_CTRL, 0x0, MISC_CLK_CTRL_DVFS_CLK_MEM_SEL);
    vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL0, P_Fld(  0                , MISC_CG_CTRL0_CLK_MEM_SEL            ) \
                                                   | P_Fld(  1                , MISC_CG_CTRL0_W_CHG_MEM              ));
    mcSHOW_DRM_MSG("DELAY 1 us\n");
    mcDELAY_XUS(1);

    mcSHOW_DRM_MSG("disable memory clock change\n");
    vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL0, P_Fld(0, MISC_CG_CTRL0_W_CHG_MEM));

    mcSHOW_DRM_MSG("Start Dramc_DDR_Reserved_Mode_setting \n");

    mcSHOW_DRM_MSG("Enable BLCOK_ALE + DIS FAKEUP2\n");
    vIO32WriteFldAlign_All(DRAMC_REG_DRAMCTRL, 1,  DRAMCTRL_ALEBLOCK);
    vIO32WriteFldAlign_All(DRAMC_REG_SHU_DCM_CTRL0, 0,  SHU_DCM_CTRL0_FASTWAKE2);

    mcSHOW_DRM_MSG("Backup regs\n");
#if (fcFOR_CHIP_ID != fcGriffin)
  if( (DUT_p.DEF_DDR3_X32_EN==1) | (DUT_p.DEF_DDR4_X32_EN==1) )
  {
    DramcBackupRegisters(p, u4ReserveRegBackupAddress_X32, sizeof(u4ReserveRegBackupAddress_X32)/sizeof(U32), TO_ONE_CHANNEL);
  }
  else
#endif
  {
    DramcBackupRegisters(p, u4ReserveRegBackupAddress, sizeof(u4ReserveRegBackupAddress)/sizeof(U32), TO_ONE_CHANNEL);
  }

#if DDR_HW_GATING
    mcSHOW_DRM_MSG("Disable HW Gating tracking for gating tracking fifo mode, 0x0514, 0x04E8, 0x0D14\n");
    DramcHWGatingOnOff(p, 0);
#endif

    mcSHOW_DRM_MSG("Disable Dummy Read\n");
    vIO32WriteFldMulti_All(DRAMC_REG_DUMMY_RD, P_Fld(0x0, DUMMY_RD_DQSG_DMYWR_EN)
            | P_Fld(0x0, DUMMY_RD_DQSG_DMYRD_EN)
            | P_Fld(0x0, DUMMY_RD_SREF_DMYRD_EN)
            | P_Fld(0x0, DUMMY_RD_DUMMY_RD_EN)
            | P_Fld(0x0, DUMMY_RD_DMY_RD_DBG)
            | P_Fld(0x0, DUMMY_RD_DMY_WR_DBG));

    mcSHOW_DRM_MSG("Disable DDRPHY dynamic clock gating\n");
    vIO32WriteFldAlign_All(DRAMC_REG_DRAMC_PD_CTRL, 0, DRAMC_PD_CTRL_PHYCLKDYNGEN);//disable DDRPHY dynamic clock gating

#if DDR_ZQCS_ENABLE
    mcSHOW_DRM_MSG("Disable HW ZQ\n");
    vIO32WriteFldAlign_All(DRAMC_REG_ZQ_SET1, 0, ZQ_SET1_ZQCALDISB);
    vIO32WriteFldAlign_All(DRAMC_REG_ZQ_SET1, 0, ZQ_SET1_ZQCSDISB);
#endif

#if DDR_IMPEDANCE_TRACKING_ENABLE
    mcSHOW_DRM_MSG("Disable IMP tracking\n");
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_IMPCAL, 0, MISC_IMPCAL_IMPCAL_HW);
#endif

    //DLL Off
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B0_DLL1), 0, SHU_B0_DLL1_RG_ARDLL_PHDET_EN_B0);
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B1_DLL1), 0, SHU_B1_DLL1_RG_ARDLL_PHDET_EN_B1);
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B2_DLL1), 0, SHU_B2_DLL1_RG_ARDLL_PHDET_EN_B2);
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_CA_DLL1), 0, SHU_CA_DLL1_RG_ARDLL_PHDET_EN_CA);

    //CG
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B0_DLL_ARPI2), P_Fld(0x1, SHU_B0_DLL_ARPI2_RG_ARPI_CG_MCK_B0)
                | P_Fld(0x1, SHU_B0_DLL_ARPI2_RG_ARPI_CG_MCK_FB2DLL_B0)
                | P_Fld(0x1, SHU_B0_DLL_ARPI2_RG_ARPI_CG_MCTL_B0)
                | P_Fld(0x1, SHU_B0_DLL_ARPI2_RG_ARPI_CG_FB_B0)
                | P_Fld(0x1, SHU_B0_DLL_ARPI2_RG_ARPI_CG_DQS_B0)
                | P_Fld(0x1, SHU_B0_DLL_ARPI2_RG_ARPI_CG_DQM_B0)
                | P_Fld(0x1, SHU_B0_DLL_ARPI2_RG_ARPI_CG_DQ_B0)
                | P_Fld(0x1, SHU_B0_DLL_ARPI2_RG_ARPI_CG_DQSIEN_B0)
                | P_Fld(0x1, SHU_B0_DLL_ARPI2_RG_ARPI_MPDIV_CG_B0));
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B1_DLL_ARPI2), P_Fld(0x1, SHU_B1_DLL_ARPI2_RG_ARPI_CG_MCK_B1)
                | P_Fld(0x1, SHU_B1_DLL_ARPI2_RG_ARPI_CG_MCK_FB2DLL_B1)
                | P_Fld(0x1, SHU_B1_DLL_ARPI2_RG_ARPI_CG_MCTL_B1)
                | P_Fld(0x1, SHU_B1_DLL_ARPI2_RG_ARPI_CG_FB_B1)
                | P_Fld(0x1, SHU_B1_DLL_ARPI2_RG_ARPI_CG_DQS_B1)
                | P_Fld(0x1, SHU_B1_DLL_ARPI2_RG_ARPI_CG_DQM_B1)
                | P_Fld(0x1, SHU_B1_DLL_ARPI2_RG_ARPI_CG_DQ_B1)
                | P_Fld(0x1, SHU_B1_DLL_ARPI2_RG_ARPI_CG_DQSIEN_B1)
                | P_Fld(0x1, SHU_B1_DLL_ARPI2_RG_ARPI_MPDIV_CG_B1));
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B2_DLL_ARPI2), P_Fld(0x1, SHU_B2_DLL_ARPI2_RG_ARPI_CG_MCK_B2)
                | P_Fld(0x1, SHU_B2_DLL_ARPI2_RG_ARPI_CG_MCK_FB2DLL_B2)
                | P_Fld(0x1, SHU_B2_DLL_ARPI2_RG_ARPI_CG_MCTL_B2)
                | P_Fld(0x1, SHU_B2_DLL_ARPI2_RG_ARPI_CG_FB_B2)
                | P_Fld(0x1, SHU_B2_DLL_ARPI2_RG_ARPI_CG_DQS_B2)
                | P_Fld(0x1, SHU_B2_DLL_ARPI2_RG_ARPI_CG_DQM_B2)
                | P_Fld(0x1, SHU_B2_DLL_ARPI2_RG_ARPI_CG_DQ_B2)
                | P_Fld(0x1, SHU_B2_DLL_ARPI2_RG_ARPI_CG_DQSIEN_B2)
                | P_Fld(0x1, SHU_B2_DLL_ARPI2_RG_ARPI_MPDIV_CG_B2));
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_CA_DLL_ARPI2), P_Fld(0x1, SHU_CA_DLL_ARPI2_RG_ARPI_CG_MCK_CA)
                | P_Fld(0x1, SHU_CA_DLL_ARPI2_RG_ARPI_CG_MCK_FB2DLL_CA)
                | P_Fld(0x1, SHU_CA_DLL_ARPI2_RG_ARPI_CG_MCTL_CA)
                | P_Fld(0x1, SHU_CA_DLL_ARPI2_RG_ARPI_CG_FB_CA)
                | P_Fld(0x1, SHU_CA_DLL_ARPI2_RG_ARPI_CG_CS)
                | P_Fld(0x1, SHU_CA_DLL_ARPI2_RG_ARPI_CG_CLK)
                | P_Fld(0x1, SHU_CA_DLL_ARPI2_RG_ARPI_CG_CMD)
                | P_Fld(0x1, SHU_CA_DLL_ARPI2_RG_ARPI_CG_CLKIEN)
                | P_Fld(0x1, SHU_CA_DLL_ARPI2_RG_ARPI_MPDIV_CG_CA));

    //step4:MIDPI_EN disable
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_CA_CMD1)        , P_Fld(0, SHU_CA_CMD1_RG_ARPI_MIDPI_EN_CA        ) \
                                                                     | P_Fld(0, SHU_CA_CMD1_RG_ARPI_MIDPI_CKDIV4_EN_CA ));
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_CA_CMD1)        , P_Fld(0, SHU_CA_CMD1_RG_ARPI_MIDPI_CKDIV4_PREDIV_EN_CA));

    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B0_MIDPI_CTRL)  , P_Fld(0, SHU_B0_MIDPI_CTRL_MIDPI_ENABLE_B0      ) \
                                                                     | P_Fld(0, SHU_B0_MIDPI_CTRL_MIDPI_DIV4_ENABLE_B0 ));
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B1_MIDPI_CTRL)  , P_Fld(0, SHU_B1_MIDPI_CTRL_MIDPI_ENABLE_B1      ) \
                                                                     | P_Fld(0, SHU_B1_MIDPI_CTRL_MIDPI_DIV4_ENABLE_B1 ));
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_B2_MIDPI_CTRL)  , P_Fld(0, SHU_B2_MIDPI_CTRL_MIDPI_ENABLE_B2      ) \
                                                                     | P_Fld(0, SHU_B2_MIDPI_CTRL_MIDPI_DIV4_ENABLE_B2 ));
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_CA_MIDPI_CTRL)  , P_Fld(0, SHU_CA_MIDPI_CTRL_MIDPI_ENABLE_CA      ) \
                                                                     | P_Fld(0, SHU_CA_MIDPI_CTRL_MIDPI_DIV4_ENABLE_CA ));

    //step5:PI_RESETB
    mcSHOW_DRM_MSG("RG_*RESETB = 1\n");
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_CA_DLL_ARPI0)       , P_Fld(  0         , CA_DLL_ARPI0_RG_ARPI_RESETB_CA           ));
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_B0_DLL_ARPI0)       , P_Fld(  0         , B0_DLL_ARPI0_RG_ARPI_RESETB_B0           ));
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_B1_DLL_ARPI0)       , P_Fld(  0         , B1_DLL_ARPI0_RG_ARPI_RESETB_B1           ));
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_B2_DLL_ARPI0)       , P_Fld(  0         , B2_DLL_ARPI0_RG_ARPI_RESETB_B2           ));

    //PLLCK
    vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DDRPHY_REG_SHU_PLL2), 0, SHU_PLL2_RG_RPHYPLL_ADA_MCK8X_EN_SHU);  //refer to MISC_DVFSCTRL2
    vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DDRPHY_REG_PHYPLL2), P_Fld(0, PHYPLL2_RG_RPHYPLL_AD_MCK8X_EN)
                                                        | P_Fld(0, PHYPLL2_RG_RPHYPLL_ADA_MCK8X_EN));

    mcSHOW_DRM_MSG("RG_*VREF_EN=0\n");
    vIO32WriteFldAlign_All(DDRPHY_REG_B0_DQ5, 0x0, B0_DQ5_RG_RX_ARDQ_VREF_EN_B0);
    vIO32WriteFldAlign_All(DDRPHY_REG_B1_DQ5, 0x0, B1_DQ5_RG_RX_ARDQ_VREF_EN_B1);
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD5, 0x0, CA_CMD5_RG_RX_ARCMD_VREF_EN);

    mcSHOW_DRM_MSG("RG_*BIAS_EN = 0\n");
    vIO32WriteFldAlign_All(DDRPHY_REG_B0_DQ6, 0x0, B0_DQ6_RG_RX_ARDQ_BIAS_EN_B0);
    vIO32WriteFldAlign_All(DDRPHY_REG_B1_DQ6, 0x0, B1_DQ6_RG_RX_ARDQ_BIAS_EN_B1);
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD6, 0x0, CA_CMD6_RG_RX_ARCMD_BIAS_EN);

    //PLL
    vIO32WriteFldAlign_All(DDRPHY_REG_PHYPLL0, 0, PHYPLL0_RG_RPHYPLL_EN);

    vIO32WriteFldAlign_All(DDRPHY_REG_PHYPLL2, 0, PHYPLL2_RG_RPHYPLL_RESETB);
    mcSHOW_DBG_MSG("[ANA_ClockOff_Sequence] flow end \n");

    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_FSM_CTRL_0, 0x0, LPIF_FSM_CTRL_0_DPM_DRAMC_WO_CONF_RSTB);
    mcSHOW_DBG_MSG("[ANA_ClockOff_Sequence] flow end \n");
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_FSM_CTRL_0, 0x1, LPIF_FSM_CTRL_0_DPM_DRAMC_WO_CONF_RSTB);

    vIO32WriteFldAlign_All(DRAMC_REG_RX_SET0, 1, RX_SET0_RDATRST);
    vIO32WriteFldAlign_All(DRAMC_REG_RX_SET0, 0, RX_SET0_RDATRST);

    vIO32WriteFldAlign_All(DDRPHY_REG_B0_DQ3 , 0x0, B0_DQ3_RG_ARDQ_RESETB_B0);
    vIO32WriteFldAlign_All(DDRPHY_REG_B1_DQ3 , 0x0, B1_DQ3_RG_ARDQ_RESETB_B1);
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD3, 0x0, CA_CMD3_RG_ARCMD_RESETB);

    vIO32WriteFldAlign_All(DDRPHY_REG_B0_DQ3, 0x1, B0_DQ3_RG_ARDQ_RESETB_B0);
    vIO32WriteFldAlign_All(DDRPHY_REG_B1_DQ3, 0x1, B1_DQ3_RG_ARDQ_RESETB_B1);
    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD3, 0x1, CA_CMD3_RG_ARCMD_RESETB);

    MPLLInit();

    DramcBroadcastOnOff(DRAMC_BROADCAST_ON);
	ANA_init_DRM(p);
    vIO32WriteFldMulti(DDRPHY_REG_MISC_CTRL3, P_Fld(0, MISC_CTRL3_ARPI_MPDIV_CG_DQ_OPT) \
                                            | P_Fld(0, MISC_CTRL3_ARPI_MPDIV_CG_CA_OPT));
    vIO32WriteFldAlign(DDRPHY_REG_SHU_PHYPLL0, 0x0, SHU_PHYPLL0_RG_RPHYPLL_RESERVED);
    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

//    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_0, 0x0, LPIF_LOW_POWER_CFG_0_DMSUS_OFF);

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CLK_CTRL, DVFS_CLK_MEM_SEL , MISC_CLK_CTRL_DVFS_CLK_MEM_SEL);
    vIO32WriteFldMulti_All(DRAMC_REG_DQSOSCR, P_Fld(0x1, DQSOSCR_TXUPDMODE));
    mcDELAY_XUS(1);
    vIO32WriteFldMulti_All(DRAMC_REG_DQSOSCR, P_Fld(0x0, DQSOSCR_TXUPDMODE));

    mcSHOW_DRM_MSG("RG_*BIAS_EN = 1\n");
    vIO32WriteFldAlign_All(DDRPHY_REG_B0_DQ6, 0x1, B0_DQ6_RG_RX_ARDQ_BIAS_EN_B0);
    vIO32WriteFldAlign_All(DDRPHY_REG_B1_DQ6, 0x1, B1_DQ6_RG_RX_ARDQ_BIAS_EN_B1);
//tg    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD6, 0x1, CA_CMD6_RG_RX_ARCMD_BIAS_EN);

    mcSHOW_DRM_MSG("DELAY 1 us\n");
    mcDELAY_XUS(1);
    mcSHOW_DRM_MSG("RG_*VREF_EN=1\n");
    vIO32WriteFldAlign_All(DDRPHY_REG_B0_DQ5,  0x1, B0_DQ5_RG_RX_ARDQ_VREF_EN_B0);
    vIO32WriteFldAlign_All(DDRPHY_REG_B1_DQ5,  0x1, B1_DQ5_RG_RX_ARDQ_VREF_EN_B1);
//tg    vIO32WriteFldAlign_All(DDRPHY_REG_CA_CMD5, 0x1, CA_CMD5_RG_RX_ARCMD_VREF_EN);

#if ENABLE_TX_REBASE_ODT_WA
    TxReadBaseODTWA(p, SRAM_SHU0);//for low power enter DRM fail
#endif

//    ASVA5_8_CSCA_Pull_Down_EN();
    DramcBroadcastOnOff(backup_broadcast);
    //DDRPhyFreqMeter();
    mcSHOW_DRM_MSG("End of Dramc_DDR_Reserved_Mode_setting \n");
}

void Dramc_DDR_Reserved_Mode_BeforeSR(void)
{
    DRAMC_CTX_T * p = psCurrDramCtx; //done in ddr reserve mode setting
    U32 tmp;
#if DDR_HW_GATING
    U8 u1ShuLevel;
    U8 u1OPEN;
    U8 u1SOPEN;
#endif

    mcSHOW_DRM_MSG("Start Dramc_DDR_Reserved_Mode_BeforeSR, dram type = %x \n", p->dram_type);

    tmp =  u4IO32Read4B(DDRPHY_REG_MISC_CG_CTRL11);
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_4, 0x3, LPIF_LOW_POWER_CFG_4_DPY_SUB_DCM_FREERUN);
    vIO32Write4B_All(DDRPHY_REG_MISC_CG_CTRL11, tmp| 0xFFFFF);

    mcSHOW_DRM_MSG("DELAY 1 us\n");
    mcDELAY_XUS(1);

    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_4,   0, LPIF_LOW_POWER_CFG_4_DPY_SUB_DCM_FREERUN);
    vIO32Write4B_All(DDRPHY_REG_MISC_CG_CTRL11, tmp);

    mcSHOW_DRM_MSG("Restore regs\n");

#if (fcFOR_CHIP_ID != fcGriffin)
    if( (DUT_p.DEF_DDR3_X32_EN==1) | (DUT_p.DEF_DDR4_X32_EN==1) )
    {
        DramcRestoreRegisters(p, u4ReserveRegBackupAddress_X32, sizeof(u4ReserveRegBackupAddress_X32)/sizeof(U32), TO_ONE_CHANNEL);
    }
    else
#endif
    {
        DramcRestoreRegisters(p, u4ReserveRegBackupAddress, sizeof(u4ReserveRegBackupAddress)/sizeof(U32), TO_ONE_CHANNEL);
    }

#if DDR_HW_GATING
    if(is_ddr4_family(p))
    {
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL0,
                P_Fld(0x1, MISC_CG_CTRL0_RG_CG_RX_CMD_OFF_DISABLE)   |
                P_Fld(0x1, MISC_CG_CTRL0_RG_CG_RX_COMB0_OFF_DISABLE) |
                P_Fld(0x1, MISC_CG_CTRL0_RG_CG_RX_COMB1_OFF_DISABLE));

        vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_4, 0x0,LPIF_LOW_POWER_CFG_4_DPY_ALL_TRACKING_OFF);//0x4703C[13:12]*/
#if EXIT_DRM_WITH_SAME_FREQ
        u1ShuLevel = u4IO32ReadFldAlign(DDRPHY_REG_DVFS_STATUS, DVFS_STATUS_OTHER_SHU_GP);
        u1OPEN     = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_CA_CMD6 + (SHU_GRP_DDRPHY_OFFSET * 0)), SHU_CA_CMD6_RG_ARPI_OPEN_EN_CA );
        u1SOPEN    = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_CA_CMD6 + (SHU_GRP_DDRPHY_OFFSET * 0)), SHU_CA_CMD6_RG_ARPI_SOPEN_EN_CA);
        mcSHOW_DRM_MSG("Open/Sopen Mode=(%0d,%d), shuffle group=%0d\n",u1OPEN,u1SOPEN, u1ShuLevel);
        if (u1OPEN || u1SOPEN)
        {
            mcSHOW_DRM_MSG("Disable HW Gating tracking for gating tracking fifo mode");
            DramcHWGatingOnOff(p,0);
            //Enable_Gating_Tracking(p,u1ShuLevel);
			vIO32WriteFldMulti_All(DDRPHY_REG_MISC_SHU_STBCAL + (SHU_GRP_DDRPHY_OFFSET * 0),
                P_Fld(0x0, MISC_SHU_STBCAL_STBCALEN) |
                P_Fld(0x0, MISC_SHU_STBCAL_STB_SELPHCALEN));
        }
        else
        {
            mcSHOW_DRM_MSG("Enable HW Gating tracking for gating tracking fifo mode");
            //DramcHWGatingOnOff(p,1);
            DDR_Enable_Gating_Tracking(p);
			vIO32WriteFldMulti_All(DDRPHY_REG_MISC_SHU_STBCAL + (SHU_GRP_DDRPHY_OFFSET * 0),
                P_Fld(0x1, MISC_SHU_STBCAL_STBCALEN) |
                P_Fld(0x1, MISC_SHU_STBCAL_STB_SELPHCALEN));

            u1OPEN     = u4IO32ReadFldAlign(DDRPHY_REG_MISC_SHU_STBCAL, MISC_SHU_STBCAL_STBCALEN );

        }
#endif
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL0,
                P_Fld(0x0, MISC_CG_CTRL0_RG_CG_RX_CMD_OFF_DISABLE)   |
                P_Fld(0x0, MISC_CG_CTRL0_RG_CG_RX_COMB0_OFF_DISABLE) |
                P_Fld(0x0, MISC_CG_CTRL0_RG_CG_RX_COMB1_OFF_DISABLE));
        mcSHOW_DRM_MSG("DELAY 1 us\n");
        mcDELAY_XUS(1);
        vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL0,
                    P_Fld(0x0, MISC_CG_CTRL0_RG_CG_RX_COMB1_OFF_DISABLE) |
                    P_Fld(0x0, MISC_CG_CTRL0_RG_CG_RX_COMB0_OFF_DISABLE) );
    }
#endif
    mcSHOW_DRM_MSG("End Dramc_DDR_Reserved_Mode_BeforeSR, dram type = %x \n", p->dram_type);
}

#define USE_TA2_IN_DDR_RESERVE_MODE  1//Just for debug
#define USE_TA2_TO_DECIDE_DRM_RESULT 1
extern u32 g_ddr_reserve_success; //In platform.c

#if USE_TA2_IN_DDR_RESERVE_MODE
static U32 TA2_Test_After_DRM(DRAMC_CTX_T * p)//Not change test range of DRM
{
    DRAM_CHANNEL_T channel_bak = p->channel;
    DRAM_RANK_T rank_bak = p->rank;
    U32 bit_error = 0;

    TA2_Test_Run_Time_HW_Write(p, ENABLE);
    bit_error = TA2_Test_Run_Time_HW_Status(p);

    if(bit_error)
		dump_gating_error_rg(p);

    p->channel = channel_bak;
    p->rank = rank_bak;

    return bit_error;
}
#endif

void Dramc_DDR_Reserved_Mode_AfterSR(void)
{
//    U32 u4value = 0;
//    U32 u4WbrBackup = 0;
    DRAMC_CTX_T * p = psCurrDramCtx; //done in ddr reserve mode setting
//    U32 u4LP3_MR2RLWL = 0;
//    U32 u4LP4_MR13FSP = 0;
//    U32 u4LP4_MR2RLWL = 0;
    U32 backup_broadcast = GetDramcBroadcast();
//    U8 u1channel = CHANNEL_A;
//    DRAM_CHANNEL_T eOriChannel = vGetPHY2ChannelMapping(p);
	BOOL bSupport2Rank = u4IO32ReadFldAlign(DRAMC_REG_SA_RESERVE, SA_RESERVE_SINGLE_RANK) == 0 ? TRUE : FALSE;
//    U8 u1set_mrsrk = (bSupport2Rank == TRUE) ? 0x3 : 0x0;
#if LOG_ONLY_VALUE
    U8 u1ShuLevel;
#endif

    mcSHOW_DRM_MSG("Start Dramc_DDR_Reserved_Mode_AfterSR, dram type = %x\n", p->dram_type);

    DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

#if (DDR_RESERVE_NEW_MODE==1)
    //ASVA5_8_IPMV2();
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE2, 0x0, MISC_DDR_RESERVE2_DRM_SM_HOLD_CTRL); //0x6f4[31:16] = 0x200
    wait_SREFx();
#endif

    //if((p->dram_type == TYPE_DDR4) || (p->dram_type == TYPE_DDR3))
    {
        mcSHOW_DRM_MSG("PCDDR3/4 new SPEC: insert ZQ between SREF and read\n");
        DRM_DDR34_SWZQ(p,0);
        if (bSupport2Rank == TRUE)
            DRM_DDR34_SWZQ(p,1);
    }

    //TODO  vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL0, 0x0, MISC_CG_CTRL0_RG_CG_PHY_OFF_DIABLE);

    mcSHOW_DRM_MSG("Disable BLCOK_ALE + EN FAKEUP2 + hold\n");
    vIO32WriteFldAlign_All(DRAMC_REG_DRAMCTRL, 0,  DRAMCTRL_ALEBLOCK);
    vIO32WriteFldAlign_All(DRAMC_REG_SHU_DCM_CTRL0, 1,  SHU_DCM_CTRL0_FASTWAKE2);
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE2, 0x600,  MISC_DDR_RESERVE2_DRM_SM_HOLD_CTRL);

    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_4, 0, LPIF_LOW_POWER_CFG_4_DPY_BLOCK_CTO_ALE);
//    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_1, 0, LPIF_LOW_POWER_CFG_1_TX_TRACKING_DIS);
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_2, 0, LPIF_LOW_POWER_CFG_2_EMI_SLEEP_PROT_EN);

#if DDR_ZQCS_ENABLE
    vIO32WriteFldAlign_All(DRAMC_REG_ZQ_SET1, 1, ZQ_SET1_ZQCSDISB);
#endif

	mcDELAY_XUS(5);

	{
#if USE_TA2_IN_DDR_RESERVE_MODE
        DDRPhyFreqMeter(p);
		mcSHOW_DBG_MSG("***CPU r/w test after exit DRM***\n");
		vDramCPUReadWriteTestAfterCalibration(p);

		mcSHOW_DBG_MSG("\n***TA2 test after exit DRM***\n");
		int i = 0;
		U32 bit_error = 0;

		for(i = 0; i < 10; i++)
		{
			bit_error |= TA2_Test_After_DRM(p);
		}

		g_ddr_reserve_success = (bit_error == 0) ? (1) : (0); //Overwrite DRM result to avoid run re-K even access memory OK after DRM		
#endif
	}
#if (FOR_DV_SIMULATION_USED == 1)
    mcSHOW_DRM_MSG("Set DRM MP for next sim =%x \n", p->dram_type);//IPM V2.4
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_SSPM_CFGREG_DBG_LATCH_SW, 1,  SSPM_CFGREG_DBG_LATCH_SW_R_DRM_LATCH_EN);//DDRPHY_MD32_BASE_ADDRESS + 0x401A8[1]
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_SSPM_CFGREG_DBG_LATCH_SW, 1,  SSPM_CFGREG_DBG_LATCH_SW_R_SYS_WDT_EVENT_LATCH_EN);//DDRPHY_MD32_BASE_ADDRESS + 0x401A8[2]
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE2, 0x600,  MISC_DDR_RESERVE2_DRM_SM_HOLD_CTRL);  //IPM V2.4 DDRPHY MP
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DDR_RESERVE3, 0x4,    MISC_DDR_RESERVE3_DRM_SM_PASS_CTRL);  //IPM V2.4 DDRPHY MP

//  vIO32WriteFldAlign_All(DDRPHY_MD32_REG_SSPM_INTC_IRQ_POL1, 0x2, SSPM_INTC_IRQ_POL1_IRQ_POL1);                                 //DDRPHY_MD32_BASE_ADDRESS + 0x42044
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_SSPM_INTC_IRQ_EN1 , 0x2, SSPM_INTC_IRQ_EN1_IRQ_EN1);                                   //DDRPHY_MD32_BASE_ADDRESS + 0x42024
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_SSPM_INTC_IRQ_WAKE_TO_DCM_EN1, 0x2, SSPM_INTC_IRQ_WAKE_TO_DCM_EN1_IRQ_WAKE_TO_DCM_EN1);//DDRPHY_MD32_BASE_ADDRESS + 0x42034
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_SSPM_INTC_IRQ_GRP5_1, 0x2, SSPM_INTC_IRQ_GRP5_1_IRQ_GRP5_1);                           //DDRPHY_MD32_BASE_ADDRESS + 0x420A4
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_PST_TRIGGER1 , 0, PST_TRIGGER1_R_DDR_PST_PATH_SEL);                                    //DDRPHY_MD32_BASE_ADDRESS + 0x472F4[0]=1: RG mode   0:PST/PSTA
#endif
    DramcBroadcastOnOff(backup_broadcast);
}

//----------------------------------------
// Auto Gen Code -- START
//----------------------------------------
void patch_to_before_k(DRAMC_CTX_T *p)
{
#if (fcFOR_CHIP_ID == fcGriffin)
        /* do nothing */
#endif
}
//----------------------------------------
// Auto Gen Code -- END
//----------------------------------------


void Patch_ReK(DRAMC_CTX_T *p)
{
#if DDR_HW_GATING
    mcSHOW_DRM_MSG("Disable HW Gating tracking for gating tracking fifo mode, 0x0514, 0x04E8, 0x0D14\n");
    DramcHWGatingOnOff(p, 0);
#endif    

#if DDR_IMPEDANCE_TRACKING_ENABLE
    mcSHOW_DRM_MSG("Disable IMP tracking\n");
    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_IMPCAL, 0, MISC_IMPCAL_IMPCAL_HW);
    vIO32WriteFldAlign_All(DRAMC_REG_RK_DQSOSC, 0, RK_DQSOSC_DQSOSCR_RK0EN);
#endif

#if DDR_ZQCS_ENABLE
    mcSHOW_DRM_MSG("Disable HW ZQ\n");
    vIO32WriteFldAlign_All(DRAMC_REG_ZQ_SET1, 0, ZQ_SET1_ZQCSDISB);
#endif

    mcSHOW_DRM_MSG("Disable Dummy Read\n");
    vIO32WriteFldMulti_All(DRAMC_REG_DUMMY_RD, P_Fld(0x0, DUMMY_RD_DQSG_DMYWR_EN)
            | P_Fld(0x0, DUMMY_RD_DQSG_DMYRD_EN)
            | P_Fld(0x0, DUMMY_RD_SREF_DMYRD_EN)
            | P_Fld(0x0, DUMMY_RD_DUMMY_RD_EN)
            | P_Fld(0x0, DUMMY_RD_DMY_RD_DBG)
            | P_Fld(0x0, DUMMY_RD_DMY_WR_DBG));

    EnableDramcPhyDCM(p, DCM_OFF); //Let CLK always free-run

    //WA for re-K
    vIO32WriteFldAlign_All(DDRPHY_REG_PHYPLL0, 0x1, PHYPLL0_RG_RPHYPLL_EN);//conf PLL_EN set to 1
    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_0, 0, LPIF_LOW_POWER_CFG_0_PHYPLL_MODE_SW);//PLL control back to RG

    vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CLK_CTRL, 0, MISC_CLK_CTRL_DVFS_CLK_MEM_SEL);//[1]: 0:SW 1:HW => Set 0 for Init DRAM to switch to 26MHz

//    vIO32WriteFldAlign_All(DRAMC_REG_DVFS_CTRL0, 1, DVFS_CTRL0_R_DMDVFSMRW_EN);//must be, could not switch to ddr1600
//    vIO32WriteFldAlign_All(DRAMC_REG_DVFS_CTRL0, 0, DVFS_CTRL0_DVFS_NOQUEFLUSH_EN);//must be, could not switch to ddr1600
//    vIO32WriteFldAlign_All(DRAMC_REG_DQSOSCR, 1, DQSOSCR_ARUIDQ_SW);//must be, TA2 fail

    patch_to_before_k(p);
}


void Before_Init_DRAM_While_Reserve_Mode_fail(DRAM_DRAM_TYPE_T dram_type)
{
    DRAMC_CTX_T * p = psCurrDramCtx;
	p->dram_type = dram_type;
    mcSHOW_DBG_MSG("\n\tPCDDR%d Reserve mode fail\tBefore_Init_DRAM_While_Reserve_Mode_fail\n", (U8)dram_type);
//    while(1);
    Patch_ReK(p);

	reset_dramc_ddrphy(p);
}

#if __ETT__
//int MustStop = 0;
void ETT_DRM(DRAMC_CTX_T *p) 
{
    U32 u4SramShuLevel;
    U32 u4ConfShuLevel;

    //After system reset shu level value will latch to RG:DDRPHY_MD32_REG_LPIF_DBG_LATCH8
    u4ConfShuLevel = u4IO32ReadFldAlign(DDRPHY_MD32_REG_LPIF_STATUS_10, LPIF_STATUS_10_DRAMC_DR_SHU_LEVEL);
    u4ConfShuLevel = u4ConfShuLevel & 0x3;
    u4SramShuLevel = u4IO32ReadFldAlign(DDRPHY_MD32_REG_LPIF_STATUS_10, LPIF_STATUS_10_DRAMC_DR_SHU_SRAM_LEVEL);
    u4SramShuLevel = u4SramShuLevel & 0xf;
    vSetDFSTable(p, get_FreqTbl_by_shuffleIndex(p, u4SramShuLevel));
    DDRPhyFreqSel(p, p->pDFSTable->freq_sel);
    mcSHOW_DRM_MSG("@@@ In DRM with DDR[%d] conf_shuffle_level[%d] sram_shuffle_level[%d]\n", p->frequency << 1, u4ConfShuLevel, u4SramShuLevel);

    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_0, CHAN_MODE, LPIF_LOW_POWER_CFG_0_EMI_CLK_OFF_REQ);//DRAM into SR
    if(u4IO32ReadFldAlign(DRAMC_REG_MISC_STATUSA, MISC_STATUSA_SREF_STATE))
    {
        mcSHOW_DBG_MSG("CHA in self refresh\n");
    }
    else
    {
        mcSHOW_DBG_MSG("CHA not in self refresh\n");
    }

    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_0, CHAN_MODE,LPIF_LOW_POWER_CFG_0_DMSUS_OFF);//DMSUS set 1

    Dramc_DDR_Reserved_Mode_setting();

    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_0, 0 ,LPIF_LOW_POWER_CFG_0_DMSUS_OFF);//DMSUS set 0

    vIO32WriteFldAlign_All(DDRPHY_MD32_REG_LPIF_LOW_POWER_CFG_0, 0 ,LPIF_LOW_POWER_CFG_0_EMI_CLK_OFF_REQ);//DRAM exit SR
    if(u4IO32ReadFldAlign(DRAMC_REG_MISC_STATUSA, MISC_STATUSA_SREF_STATE))
    {
        mcSHOW_DBG_MSG("CHA in self refresh\n");
    }
    else
    {
        mcSHOW_DBG_MSG("CHA not in self refresh\n");
    }

    Dramc_DDR_Reserved_Mode_AfterSR();

//    Patch_ReK(p);
//    MustStop = 1;
//    Init_DRAM(TYPE_LPDDR4X, CBT_R0_R1_BYTE, NULL, NORMAL_USED);//CBT_R0_R1_BYTE since DRAM is H9HQ16AFAMMDAR
}
#endif
#endif
