/*----------------------------------------------------------------------------*
 * Copyright Statement:                                                       *
 *                                                                            *
 *   This software/firmware and related documentation ("MediaTek Software")   *
 * are protected under international and related jurisdictions'copyright laws *
 * as unpublished works. The information contained herein is confidential and *
 * proprietary to MediaTek Inc. Without the prior written permission of       *
 * MediaTek Inc., any reproduction, modification, use or disclosure of        *
 * MediaTek Software, and information contained herein, in whole or in part,  *
 * shall be strictly prohibited.                                              *
 * MediaTek Inc. Copyright (C) 2010. All rights reserved.                     *
 *                                                                            *
 *   BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND     *
 * AGREES TO THE FOLLOWING:                                                   *
 *                                                                            *
 *   1)Any and all intellectual property rights (including without            *
 * limitation, patent, copyright, and trade secrets) in and to this           *
 * Software/firmware and related documentation ("MediaTek Software") shall    *
 * remain the exclusive property of MediaTek Inc. Any and all intellectual    *
 * property rights (including without limitation, patent, copyright, and      *
 * trade secrets) in and to any modifications and derivatives to MediaTek     *
 * Software, whoever made, shall also remain the exclusive property of        *
 * MediaTek Inc.  Nothing herein shall be construed as any transfer of any    *
 * title to any intellectual property right in MediaTek Software to Receiver. *
 *                                                                            *
 *   2)This MediaTek Software Receiver received from MediaTek Inc. and/or its *
 * representatives is provided to Receiver on an "AS IS" basis only.          *
 * MediaTek Inc. expressly disclaims all warranties, expressed or implied,    *
 * including but not limited to any implied warranties of merchantability,    *
 * non-infringement and fitness for a particular purpose and any warranties   *
 * arising out of course of performance, course of dealing or usage of trade. *
 * MediaTek Inc. does not provide any warranty whatsoever with respect to the *
 * software of any third party which may be used by, incorporated in, or      *
 * supplied with the MediaTek Software, and Receiver agrees to look only to   *
 * such third parties for any warranty claim relating thereto.  Receiver      *
 * expressly acknowledges that it is Receiver's sole responsibility to obtain *
 * from any third party all proper licenses contained in or delivered with    *
 * MediaTek Software.  MediaTek is not responsible for any MediaTek Software  *
 * releases made to Receiver's specifications or to conform to a particular   *
 * standard or open forum.                                                    *
 *                                                                            *
 *   3)Receiver further acknowledge that Receiver may, either presently       *
 * and/or in the future, instruct MediaTek Inc. to assist it in the           *
 * development and the implementation, in accordance with Receiver's designs, *
 * of certain softwares relating to Receiver's product(s) (the "Services").   *
 * Except as may be otherwise agreed to in writing, no warranties of any      *
 * kind, whether express or implied, are given by MediaTek Inc. with respect  *
 * to the Services provided, and the Services are provided on an "AS IS"      *
 * basis. Receiver further acknowledges that the Services may contain errors  *
 * that testing is important and it is solely responsible for fully testing   *
 * the Services and/or derivatives thereof before they are used, sublicensed  *
 * or distributed. Should there be any third party action brought against     *
 * MediaTek Inc. arising out of or relating to the Services, Receiver agree   *
 * to fully indemnify and hold MediaTek Inc. harmless.  If the parties        *
 * mutually agree to enter into or continue a business relationship or other  *
 * arrangement, the terms and conditions set forth herein shall remain        *
 * effective and, unless explicitly stated otherwise, shall prevail in the    *
 * event of a conflict in the terms in any agreements entered into between    *
 * the parties.                                                               *
 *                                                                            *
 *   4)Receiver's sole and exclusive remedy and MediaTek Inc.'s entire and    *
 * cumulative liability with respect to MediaTek Software released hereunder  *
 * will be, at MediaTek Inc.'s sole discretion, to replace or revise the      *
 * MediaTek Software at issue.                                                *
 *                                                                            *
 *   5)The transaction contemplated hereunder shall be construed in           *
 * accordance with the laws of Singapore, excluding its conflict of laws      *
 * principles.  Any disputes, controversies or claims arising thereof and     *
 * related thereto shall be settled via arbitration in Singapore, under the   *
 * then current rules of the International Chamber of Commerce (ICC).  The    *
 * arbitration shall be conducted in English. The awards of the arbitration   *
 * shall be final and binding upon both parties and shall be entered and      *
 * enforceable in any court of competent jurisdiction.                        *
 *---------------------------------------------------------------------------*/


//=============================================================================
//  Include Files
//=============================================================================
#include "emi_hw.h"
#include "emi.h"
#include "dramc_top.h"
#include "dramc_common.h"
//#include "reg_base.h"

#if __ETT__
#define emi_log	printf
#elif __FLASH_TOOL_DA__
#define emi_log	LOGD
#else
#define emi_log	printf
#endif

/* cheetah has no low power scenario request */
//#define FMEM_CLK_TBA_ENABLE

#define EMI_DRS_DIS
//#define SHORT_DIS

static inline U32 mt_emi_sync_read(U64 addr)
{
	dsb();
	return *((volatile U32 *)addr);
}

#define mt_emi_sync_write(addr, value)				\
	do {							\
		*((volatile U32 *)(addr)) = value;	\
		dsb();						\
	} while (0)

#define mt_emi_sync_write_or(addr, or_value)			\
	do {							\
		mt_emi_sync_write(addr,				\
			mt_emi_sync_read(addr) | or_value);	\
	} while (0)

int get_row_width_by_emi(unsigned int rank)
{
	unsigned int emi_cona;
	unsigned int shift_row, shift_ext;
	int row_width;

	if (rank == 0) {
		shift_row = 12;
		shift_ext = 22;
	} else if (rank == 1) {
		shift_row = 14;
		shift_ext = 23;
	} else
		return -1;

	emi_cona = mt_emi_sync_read(EMI_CONA);
	row_width =
		((emi_cona >> shift_row) & 0x3) |
		((emi_cona >> shift_ext) & 0x4);

	return (row_width + 13);
}


static void emi_init2(void)
{
    UINT32  rd_tmp;

    // CHN_EMI enable after DRAMC setting done
#ifdef REAL_CHIP_EMI_GOLDEN_SETTING
     // CHN_EMI enable after DRAMC setting done
    rd_tmp = *((UINT32P)(EMI_CHN0_APB_BASE + 0x000010));
    *((UINT32P)(EMI_CHN0_APB_BASE + 0x000010))  = rd_tmp | 0x1;		// CHN_EMI_CONC :	[31: 1] --> EMI APB Configuration & Address Mapping tool

    // CEN_EMI enable after CHN_EMI setting done
    rd_tmp = *((UINT32P)(EMI_APB_BASE+0x00000060));
    *((UINT32P)(EMI_APB_BASE+0x00000060))      =    rd_tmp | 0x400;		// EMI_CONM :		[10]	--> EMI enable,
    									// 			[ 9: 8]	--> Normail age speed,
    									//			[ 7: 0]	--> Page hit high priority enable
    									//			[0]     --> MUST be 1
#else
    *((UINT32P)(EMI_CHN0_APB_BASE+0x000010))    = 0x1;
    //rd_tmp = *((UINT32P)(CHN0_EMI_APB_BASE+0x000010));
    *((UINT32P)(EMI_CHN0_APB_BASE+0x000010))    |= 0x20;		// CHN_EMI_CONC :	[31: 1] --> EMI APB Configuration & Address Mapping tool, for fast clk
    									//			[0]     --> MUST be 1
    // CEN_EMI enable after CHN_EMI setting done
    *((UINT32P)(EMI_APB_BASE+0x00000060))       |= 0x00000400;			// EMI_CONM :		EMI enable, Normail age speed, Page hit high priority enable
#endif
}

static void emi_init(void)
{
    //C:-------------------BEGIN))=EMI Setting--------------------
    //))=Row = 15-bit
#ifdef MM_COSIM_PERFORMANCE // BEGIN MM_COSIM_PERFORMANCE
#ifndef ONE_CH
      #ifdef RANK_512MB  // => 2channel , dual rank , total=2G
        *((UINT32P)(EMI_APB_BASE+0x00000000))=0xa053a154; //10:Row=15bits, 11:Row=16bits
      #else  //RANK_1G  => 2channel , dual rank , total=4G
        *((UINT32P)(EMI_APB_BASE+0x00000000))=0xf053f154; //2CH
      #endif
#else
      #ifdef RANK_512MB
        *((UINT32P)(EMI_APB_BASE+0x00000000))=0xa053a054; //1CH
      #else
        *((UINT32P)(EMI_APB_BASE+0x00000000))=0xf053f054; //1CH
      #endif
#endif
#endif // END MM_COSIM_PERFORMANCE
    //))=Row = 14-bit;
    //*((UINT32P)(EMI_APB_BASE+0x00000000))=0x50505154;
    *((UINT32P)(EMI_APB_BASE+0x00000008))=0x17283544;
    *((UINT32P)(EMI_APB_BASE+0x00000010))=0x0a1a0b1a;
    *((UINT32P)(EMI_APB_BASE+0x00000018))=0x3657587a;
    //*((UINT32P)(EMI_APB_BASE+0x00000020))=0x0000c142;//pcddr4_esl, 0xffff0848;
    //20201105 Disable cmd age count down by 26m clk
    *((UINT32P)(EMI_APB_BASE+0x00000020))=0x0000c143;//pcddr4_esl, 0xffff0848;

    *((UINT32P)(EMI_APB_BASE+0x00000028))=0x00000000;
    *((UINT32P)(EMI_APB_BASE+0x00000030))=0x2b2b2a38;
#ifdef MM_COSIM_PERFORMANCE // BEGIN MM_COSIM_PERFORMANCE
    *((UINT32P)(EMI_APB_BASE+0x00000038))=0x00002800;
#ifdef BANK_INTERLEAVE_ON
    *((UINT32P)(EMI_APB_BASE+0x00000038))=0x00002804; // enable bank interleaving
#endif
#endif // END MM_COSIM_PERFORMANCE
    *((UINT32P)(EMI_APB_BASE+0x00000038))=0x00001f83;//pcddr4_esl
    //*((UINT32P)(EMI_APB_BASE+0x00000038))=0x00073338;//pcddr4_esl,[3]:reg_bg1_pos, [5]:reg_chn0_16bank_mode, [8]:reg_chn1_16bank_mode


    *((UINT32P)(EMI_APB_BASE+0x00000040))=0x00008802;//pcddr4_esl, 0x00008003
    *((UINT32P)(EMI_APB_BASE+0x00000048))=0x00000000;//pcddr4_esl

    //*((UINT32P)(EMI_APB_BASE+0x00000060))=0x00781100;//pcddr4_esl, 0x000011ff; // reserved buffer to normal read/write no limit
    *((UINT32P)(EMI_APB_BASE+0x00000060))=0x00121100;//reserve rd buffer=2+ wr buffer =1 for M0, ultra and under BW limiter request ; pcddr4_esl, 0x000011ff; // reserved buffer to normal read/write no limit

#ifdef ICFP
    *((UINT32P)(EMI_APB_BASE+0x00000060))=0x009d11ff; // reserved buffer to normal read/write = 4/4
#endif
#ifdef VPWFD
    *((UINT32P)(EMI_APB_BASE+0x00000060))=0x009d11ff; // reserved buffer to normal read/write = 4/4
#endif
#ifdef VR4K
    *((UINT32P)(EMI_APB_BASE+0x00000060))=0x009d11ff; // reserved buffer to normal read/write = 4/4
#endif
    *((UINT32P)(EMI_APB_BASE+0x00000078))=0x11000c10;//pcddr4_esl, no_MD ,0x11128c17; //reserve buffer to ap_w[30:28]=1, ap_r[26:24]=1, moden u_w[22:20]=0, moden u_r[28:16]=0
    *((UINT32P)(EMI_APB_BASE+0x00000710))=0x11000c10;//pcddr4_esl, no_MD ,0x11128c17; //reserve buffer to ap_w[30:28], ap_r[26:24], u_w[22:20], u_r[28:16]
    *((UINT32P)(EMI_APB_BASE+0x0000007c))=0x00000000;//pcddr4_esl, no_MD, 0x00001123; //reserve buffer to hi_w[15:12], hi_r[10:8], md_w[6:4], md_r[2:0]
    *((UINT32P)(EMI_APB_BASE+0x00000718))=0x00000000;//pcddr4_esl, no_MD, 0x00001123; //reserve buffer to hi_w[15:12], hi_r[10:8], md_w[6:4], md_r[2:0]

    *((UINT32P)(EMI_APB_BASE+0x000000d0))=0xa8a8a8a8;
    *((UINT32P)(EMI_APB_BASE+0x000000d4))=0x25252525;
    *((UINT32P)(EMI_APB_BASE+0x000000d8))=0xa8a8a8a8;
    *((UINT32P)(EMI_APB_BASE+0x000000dc))=0x25252525;
    //*((UINT32P)(EMI_APB_BASE+0x000000e8))=0x00062037;//pcddr4_esl
#ifdef SHORT_DIS
    *((UINT32P)(EMI_APB_BASE+0x000000e8))=0x00062037; // initial starvation counter div2, [4]=1
#else
    *((UINT32P)(EMI_APB_BASE+0x000000e8))=0x00060037; // initial starvation counter div2, [4]=1
#endif
    *((UINT32P)(EMI_APB_BASE+0x000000f0))=0x384a0024;//pcddr4_esl, no_MD, 0x38420000;
    *((UINT32P)(EMI_APB_BASE+0x000000f8))=0xa0000000;//pcddr4_esl
    /////  EMI  bandwidth limit  ////////// default UI
#ifdef SCN_ICFP
    *((UINT32P)(EMI_APB_BASE+0x00000100))=0x20107244;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000108))=0x10107044;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000110))=0x343450df;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000118))=0x0000ffff;//0x0000f0d0;//pcddr4_esl, no_MD
    *((UINT32P)(EMI_APB_BASE+0x00000120))=0x10106048;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000128))=0x343450df;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000130))=0x83837044;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000138))=0x83837044;//pcddr4_esl
#else
    //average prioty latency allocate
    //*((UINT32P)(EMI_APB_BASE+0x00000100))=0x00007244;//no r/w latency 0x20107250;//pcddr4_esl
    //*((UINT32P)(EMI_APB_BASE+0x00000108))=0x10107050;//pcddr4_esl??
    //*((UINT32P)(EMI_APB_BASE+0x00000110))=0x000050df;//0x343450df;//pcddr4_esl
    //*((UINT32P)(EMI_APB_BASE+0x00000118))=0x0000ffff;//0x0000f0d0;//pcddr4_esl, no_MD
    //*((UINT32P)(EMI_APB_BASE+0x00000120))=0x10106050;//pcddr4_esl
    //*((UINT32P)(EMI_APB_BASE+0x00000124))=0x00000034;//pcddr4_esl, no_MD
    //*((UINT32P)(EMI_APB_BASE+0x00000128))=0x343450df;//pcddr4_esl
    //*((UINT32P)(EMI_APB_BASE+0x00000130))=0x83837048;//pcddr4_esl
    //*((UINT32P)(EMI_APB_BASE+0x00000138))=0x83837048;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000100))=0xFFFF7250;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000108))=0xFFFF7050;//pcddr4_esl, ??
    *((UINT32P)(EMI_APB_BASE+0x00000110))=0xFFFF50df;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000118))=0xFFFFffff;//0x0000f0d0;//pcddr4_esl, no_MD
    *((UINT32P)(EMI_APB_BASE+0x00000120))=0xFFFF6050;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000124))=0xFFFF0034;//pcddr4_esl, no_MD
    *((UINT32P)(EMI_APB_BASE+0x00000128))=0xFFFF50df;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000130))=0xFFFF7048;//pcddr4_esl
    *((UINT32P)(EMI_APB_BASE+0x00000138))=0xFFFF7048;//pcddr4_esl
#endif
    //#endif
    // scenario setting from Alaska begin
#ifdef VPWFD
    *((UINT32P)(EMI_APB_BASE+0x00000100))=0x8fb07241;
    *((UINT32P)(EMI_APB_BASE+0x00000108))=0x8fb07041;
    *((UINT32P)(EMI_APB_BASE+0x00000110))=0xa0a050d8;
    *((UINT32P)(EMI_APB_BASE+0x00000118))=0x000070c3;
    *((UINT32P)(EMI_APB_BASE+0x00000120))=0x40406048;
    *((UINT32P)(EMI_APB_BASE+0x00000128))=0xa0a050d7;
    *((UINT32P)(EMI_APB_BASE+0x00000130))=0xb0b07042;
    *((UINT32P)(EMI_APB_BASE+0x00000138))=0xb0b07042;
#endif
#ifdef VR4K
    *((UINT32P)(EMI_APB_BASE+0x00000100))=0xc0c07241;
    *((UINT32P)(EMI_APB_BASE+0x00000108))=0xc0c07041;
    *((UINT32P)(EMI_APB_BASE+0x00000110))=0xa0a050da;
    *((UINT32P)(EMI_APB_BASE+0x00000118))=0x000070c4;
    *((UINT32P)(EMI_APB_BASE+0x00000120))=0x40406049;
    *((UINT32P)(EMI_APB_BASE+0x00000128))=0xa0a050d3;
    *((UINT32P)(EMI_APB_BASE+0x00000130))=0xc0c07042;
    *((UINT32P)(EMI_APB_BASE+0x00000138))=0xc0c07042;
#endif
    //scenario setting from Alaska end
#ifdef ICFP
    *((UINT32P)(EMI_APB_BASE+0x00000100))=0xafb07245;
    *((UINT32P)(EMI_APB_BASE+0x00000108))=0xafb07045;
    *((UINT32P)(EMI_APB_BASE+0x00000110))=0xa0a050cb;
    *((UINT32P)(EMI_APB_BASE+0x00000118))=0x000070cc;
    *((UINT32P)(EMI_APB_BASE+0x00000120))=0x40406046;
    *((UINT32P)(EMI_APB_BASE+0x00000128))=0xa0a050d6;
    *((UINT32P)(EMI_APB_BASE+0x00000130))=0xb0b07041;
    *((UINT32P)(EMI_APB_BASE+0x00000138))=0xb0b07042;
#endif
    ////////////////////////////////////////////////////

    *((UINT32P)(EMI_APB_BASE+0x00000140))=0x00007108;
    *((UINT32P)(EMI_APB_BASE+0x00000144))=0x00007108;
    *((UINT32P)(EMI_APB_BASE+0x00000150))=0x090a0000;//pcddr4_esl, 0xff01ff00;
    *((UINT32P)(EMI_APB_BASE+0x00000158))=0xff01ff00;
    *((UINT32P)(EMI_APB_BASE+0x00000400))=0x00ff0001; //[27:20] enable monitor
    *((UINT32P)(EMI_APB_BASE+0x0000071c))=0x10000008;//pcddr4_esl, 0x00004688;
    *((UINT32P)(EMI_APB_BASE+0x00000800))=0xffffffff;//pcddr4_esl
    // EMI SRT throttling setting
    *((UINT32P)(EMI_APB_BASE+0x00000820))=0x24240000;//pcddr4_esl, 0x24240101; //wostd throttle
    *((UINT32P)(EMI_APB_BASE+0x00000824))=0x00002424;//pcddr4_esl, 0x01012424; //wostd throttle
    *((UINT32P)(EMI_APB_BASE+0x00000828))=0x50500000;//pcddr4_esl, 0x50500101; //rostd throttle
    *((UINT32P)(EMI_APB_BASE+0x0000082c))=0x00005050;//pcddr4_esl, 0x01015050; //rostd throttle
    *((UINT32P)(EMI_APB_BASE+0x00000830))=0x0fc39a20;//pcddr4_esl, 0x0fc39a70;
    *((UINT32P)(EMI_APB_BASE+0x00000834))=0x05050003;
    *((UINT32P)(EMI_APB_BASE+0x00000838))=0x254dffff;
    *((UINT32P)(EMI_APB_BASE+0x0000083c))=0x3c785a3c;
    *((UINT32P)(EMI_APB_BASE+0x00000840))=0x00002ee0;//pcddr4_esl, 0x00000000;
    *((UINT32P)(EMI_APB_BASE+0x00000844))=0x00004650;//pcddr4_esl, 0x00000000;
    *((UINT32P)(EMI_APB_BASE+0x00000848))=0x00005dc0;//pcddr4_esl, 0x00000000;
    *((UINT32P)(EMI_APB_BASE+0x0000084c))=0x00002ee0;//pcddr4_esl, 0x00000000;
    *((UINT32P)(EMI_APB_BASE+0x00000850))=0x00000000;
    *((UINT32P)(EMI_APB_BASE+0x00000854))=0x00000000;
    *((UINT32P)(EMI_APB_BASE+0x00000858))=0x02533c0c;//pcddr4_esl, 0x02533c0f;
    *((UINT32P)(EMI_APB_BASE+0x0000085c))=0x00002785;

    *((UINT32P)(EMI_APB_BASE+0x00000858))=0x02533c0c;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000858))=0x02533c0c;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000874))=0x00004650;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000878))=0x005a0000;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x0000087c))=0x0250250f;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000890))=0xffff3c59;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000894))=0xffff00ff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x000008a0))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x000008a4))=0x0000ffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x000008c0))=0x00005dc0;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x000008c4))=0x00780000;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x000008c8))=0x00006d60;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x000008cc))=0x008c0000;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x000008d0))=0x00007d00;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x000008d4))=0x00a00000;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x000008e0))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x000008e4))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x000008e8))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000920))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000924))=0x0000ffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000930))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000934))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000938))=0xffffffff;//pcddr4_esl,

    *((UINT32P)(EMI_APB_BASE+0x000009f0))=0x32644b32;//pcddr4_esl, MD_LAT_BUDGET
    *((UINT32P)(EMI_APB_BASE+0x000009f4))=0x8574644b;//pcddr4_esl, MD_LAT_BUDGET
    *((UINT32P)(EMI_APB_BASE+0x000009f8))=0x00001770;//pcddr4_esl, MD_WR_LAT_MARGIN
    *((UINT32P)(EMI_APB_BASE+0x000009fc))=0x00002328;//pcddr4_esl, MD_WR_LAT_MARGIN
    *((UINT32P)(EMI_APB_BASE+0x00000b00))=0x00002ee0;//pcddr4_esl, MD_WR_LAT_MARGIN
    *((UINT32P)(EMI_APB_BASE+0x00000b04))=0x00001770;//pcddr4_esl, MD_WR_LAT_MARGIN
    *((UINT32P)(EMI_APB_BASE+0x00000b08))=0x00002328;//pcddr4_esl, MD_WR_LAT_MARGIN
    *((UINT32P)(EMI_APB_BASE+0x00000b0c))=0x00002ee0;//pcddr4_esl, MD_WR_LAT_MARGIN
    *((UINT32P)(EMI_APB_BASE+0x00000b10))=0x000036b0;//pcddr4_esl, MD_WR_LAT_MARGIN
    *((UINT32P)(EMI_APB_BASE+0x00000b14))=0x00003e80;//pcddr4_esl, MD_WR_LAT_MARGIN
    *((UINT32P)(EMI_APB_BASE+0x00000b28))=0x1e3c2d1e;//pcddr4_esl, MD_WR_LAT_BUDGET
    *((UINT32P)(EMI_APB_BASE+0x00000b2c))=0x4b463c2d;//pcddr4_esl, MD_WR_LAT_BUDGET
    *((UINT32P)(EMI_APB_BASE+0x00000b60))=0x14281e14;//pcddr4_esl, MD_WR_LAT_BUDGET
    *((UINT32P)(EMI_APB_BASE+0x00000b64))=0x352e281e;//pcddr4_esl, MD_WR_LAT_BUDGET

    *((UINT32P)(EMI_APB_BASE+0x00000b98))=0x64c89664;//pcddr4_esl, AP_LAT_BUDGET
    *((UINT32P)(EMI_APB_BASE+0x00000b9c))=0xffe9c896;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000bd0))=0x01010101;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000bd4))=0x01010101;//pcddr4_esl,

    *((UINT32P)(EMI_APB_BASE+0x00000c08))=0x64c89664;//pcddr4_esl, AP_WR_LAT_BUDGET
    *((UINT32P)(EMI_APB_BASE+0x00000c0c))=0xffe9c896;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000c40))=0x01010101;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000c44))=0x01010101;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000c4c))=0x0000a025;//pcddr4_esl,

    *((UINT32P)(EMI_APB_BASE+0x00000c80))=0x00003e80;//pcddr4_esl, MD_LAT_MARGIN
    *((UINT32P)(EMI_APB_BASE+0x00000c84))=0x00005dc0;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000c88))=0x00007d00;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000c8c))=0x00003e80;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000c90))=0x00005dc0;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000c94))=0x00007d00;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000c98))=0x000091d5;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000c9c))=0x0000a6aa;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000cb0))=0x50a07850;//pcddr4_esl, MD_LAT_BUDGET
    *((UINT32P)(EMI_APB_BASE+0x00000cb4))=0xd5baa078;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000cf8))=0x01010101;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000cfc))=0x01010101;//pcddr4_esl,


    //no MDR/MDW/AP/MM suffle
    //MD
    //*((UINT32P)(EMI_APB_BASE+0x00000d04))=0x00000009;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d0c))=0x00000002;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d14))=0x00730000;//pcddr4_esl, no_MD
    //*((UINT32P)(EMI_APB_BASE+0x00000d18))=0x00000808;//pcddr4_esl, no_MD
    //*((UINT32P)(EMI_APB_BASE+0x00000d1c))=0x00000028;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d24))=0x00000040;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d2c))=0x00730000;//pcddr4_esl, no_MD
    //*((UINT32P)(EMI_APB_BASE+0x00000d30))=0x00000808;//pcddr4_esl, no_MD
    //AP
    //*((UINT32P)(EMI_APB_BASE+0x00000d34))=0x00000080;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d3c))=0x00000100;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d44))=0x30201008;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d48))=0x00000800;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d50))=0x00001000;//pcddr4_esl,
    //MM
    //*((UINT32P)(EMI_APB_BASE+0x00000d58))=0x00008000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d60))=0x00010000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d64))=0x00000800;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d68))=0x00020000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d6c))=0x00001000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d70))=0x08080000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d74))=0x00073030;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d78))=0x00040000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d80))=0x00080000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d84))=0x00002000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d88))=0x00100000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d8c))=0x00004000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d90))=0x08080000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000d94))=0x00074040;//pcddr4_esl,
    //MDHWR
    //*((UINT32P)(EMI_APB_BASE+0x00000d98))=0x00400000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000da0))=0x00200000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000da8))=0x10100404;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000dac))=0x01000000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000db4))=0x00800000;//pcddr4_esl,
    //GPUR
    //*((UINT32P)(EMI_APB_BASE+0x00000dbc))=0x04000000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000dc4))=0x02000000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000dcc))=0x60602010;//pcddr4_esl,
    //GCPUW
    //*((UINT32P)(EMI_APB_BASE+0x00000dd0))=0x10000000;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000dd8))=0x08000000;//pcddr4_esl,
    //AP
    //*((UINT32P)(EMI_APB_BASE+0x00000de0))=0x00000009;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000de8))=0x04400080;//pcddr4_esl,
    //*((UINT32P)(EMI_APB_BASE+0x00000df0))=0x0f170f11;//pcddr4_esl,
    //QoS Control
    //*((UINT32P)(EMI_APB_BASE+0x00000df4))=0x0303f7f7;//pcddr4_esl,

    //latency monitor
    *((UINT32P)(EMI_APB_BASE+0x00000e04))=0x00000166;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000e08))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000e0c))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000e14))=0x00400166;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000e18))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000e1c))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000e24))=0x00000266;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000e28))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000e2c))=0xffffffff;//pcddr4_esl,

    *((UINT32P)(EMI_APB_BASE+0x00000e34))=0x00400266;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000e38))=0xffffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000e3c))=0xffffffff;//pcddr4_esl,


      //weilun for new feature
    *((UINT32P)(EMI_APB_BASE+0x00000714))=0x00000000;//pcddr4_esl,

      // fine-grained qos
    *((UINT32P)(EMI_APB_BASE+0x00000050))=0x00000000;//pcddr4_esl,

      // ostd->bw
    *((UINT32P)(EMI_APB_BASE+0x0000061c))=0x08ffbbff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000624))=0xffff5b3c;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000774))=0xffff00ff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x0000077c))=0x00ffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000784))=0xffff00ff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x0000078c))=0x00ffffff;//pcddr4_esl,
    *((UINT32P)(EMI_APB_BASE+0x00000958))=0x00000000;//pcddr4_esl,

    // RGU trigger EMI self-test setting
    *((UINT32P)(EMI_APB_BASE+0x0000014c))=0xc000ff00;
    *((UINT32P)(EMI_APB_BASE+0x00000990))=0x0000ffff;
    *((UINT32P)(EMI_APB_BASE+0x00000994))=0x00000000;

    //C:-------------------END))=EMI Setting--------------------;
    //C:-------------------BEGIN))=CHANNEL EMI Setting--------------------;
#ifdef MM_COSIM_PERFORMANCE // BEGIN MM_COSIM_PERFORMANCE
#ifdef RANK_512MB  // => 2channel , dual rank , total=2G
      *((UINT32P)(EMI_CHN0_APB_BASE+0x00000000))=0x0400a051;
#else  //RANK_1G  => 2channel , dual rank , total=4G
      *((UINT32P)(EMI_CHN0_APB_BASE+0x00000000))=0x0400f051;
#endif
#ifdef BANK_INTERLEAVE_ON
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000000))=0x2400a050; // enable bank interleaving
#endif
#endif // END MM_COSIM_PERFORMANCE
    if (!is_use_ddr4) { /* SUPPORT_TYPE_DDR3 */
        *((UINT32P)(EMI_CHN0_APB_BASE+0x00000008))=0xffff6048;//pcddr4_esl, 0x00002048; // over BW limit, starvation slow down, [13:12]=2, normal dec speed
    } else { /* SUPPORT_TYPE_DDR4 */
        *((UINT32P)(EMI_CHN0_APB_BASE+0x00000008))=0xffff5048;//pcddr4_esl, 0x00002048; // over BW limit, starvation slow down, [13:12]=2
    }
    //20201105 Disable cmd age count down by 26m clk
    //*((UINT32P)(EMI_CHN0_APB_BASE+0x00000010))=0x00842084;//pcddr4_esl, PCDDR4 use Address Scramble in chn_emi,0x00000001;
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000010))=0x008420a4;//pcddr4_esl, PCDDR4 use Address Scramble in chn_emi,0x00000001;

    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000018))=0x01f08c03;//pcddr4_esl, no_MD,0x99f08c03, 0x88008c17;
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000710))=0x9a508c17;//pcddr4_esl,

#ifdef SHORT_DIS
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000048))=0x0003A037;//pcddr4_esl, //RD_INORDER_THR[20:16]=2
#else
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000048))=0x00038037;//pcddr4_esl,  //RD_INORDER_THR[20:16]=2
#endif
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000050))=0x38460002; // [1] : MD_RD_AFT_WR_EN
#ifdef MD_FAVOR
    //*((UINT32P)(EMI_CHN0_APB_BASE+0x00000050))=0x38470000;
    //*((UINT32P)(EMI_APB_BASE+0x00000078))=0x9a99fc3f; // [15:12] = 0xf : SBR
    //*((UINT32P)(EMI_CHN0_APB_BASE+0x00000018))=0x0000cc7f; // [15:14] = 0x3 : SBR
    //*((UINT32P)(EMI_CHN0_APB_BASE+0x00000158))= (*((UINT32P)(EMI_CHN0_APB_BASE+0x00000158)) & 0xff0808ff); // [23:8] = 0x0808 : SBR
    //*((UINT32P)(EMI_APB_BASE+0x0001200c))= (*((UINT32P)(EMI_APB_BASE+0x0001200c)) | 0x00c08000); // [23] = 0x1, [22] = 0x1, [15] = 0x1 : SBR enable, SBR aggressive enable, RWLS
#endif

    //*((UINT32P)(EMI_CHN0_APB_BASE+0x00000158))= (*((UINT32P)(EMI_CHN0_APB_BASE+0x00000158)) | 0x00101000); // enable LLAT to M4
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000058))=0x00000000;
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000090))=0x000002ff;//pcddr4_esl
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000098))=0x00003111;//0x000002ff;//pcddr4_esl

    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000140))=0x20407188;// pcddr4_esl, 0x20406188;
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000144))=0x20407188;// pcddr4_esl, 0x20406188;
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000148))=0x3719595e;
    *((UINT32P)(EMI_CHN0_APB_BASE+0x0000014c))=0x2719595e;//pcddr4_esl, 0x3719595e;
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000150))=0x64f3fc79;
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000154))=0x64f3fc79;
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000158))=0x01180808;//pcddr4_esl, ((*((UINT32P)(EMI_CHN0_APB_BASE+0x00000158)) & 0xffffff0f)| 0x00000060); // reserve buffer to MDMCU 1
    *((UINT32P)(EMI_CHN0_APB_BASE+0x0000015c))=0xa7410222;//pcddr4_esl, 0x82410222; //STRICT_MSK_ULTRA_EN [5]=1

#ifndef EMI_DRS_DIS
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000160))=0x0a000013; // rank grouping for CKE // rank total>10, expire>0,ultra>0 stop grouping
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000164))=0x0a000211; // rank grouping for CKE // rank total>10, expire>0,ultra>2 stop grouping
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000168))=0x20f26055; // rank1 DRS
#endif

    *((UINT32P)(EMI_CHN0_APB_BASE+0x0000016c))=0x0000f801;
    *((UINT32P)(EMI_CHN0_APB_BASE+0x00000170))=0x40000000;
    //*((UINT32P)(EMI_CHN0_APB_BASE+0x00000710))=0x8a228c17; // [24:20] = 0x2 : bank throttling (default=0x01f00000)

    *((UINT32P)(EMI_CHN0_APB_BASE+0x000001b0))=0x0008002f;//pcddr4_esl, 0x0006002f; // Rank-Aware arbitration
    *((UINT32P)(EMI_CHN0_APB_BASE+0x000001b4))=0x09090909;//pcddr4_esl, 0x01010101; // Rank-Aware arbitration
    *((UINT32P)(EMI_CHN0_APB_BASE+0x000001b8))=0x10001820;//pcddr4_esl, 0x20201840; // Rank-Aware arbitration
    // no_MD
    //#ifdef MD_BANK_PRE_MASK
    //	#ifdef BANK_MASK_ULTRA_OFF
    //		*((UINT32P)(EMI_CHN0_APB_BASE+0x00000080))=0xb00;
    //		*((UINT32P)(EMI_CHN0_APB_BASE+0x00000088))=0xb00;
    //	#else
    //		*((UINT32P)(EMI_CHN0_APB_BASE+0x00000080))=0xf00;
    //		*((UINT32P)(EMI_CHN0_APB_BASE+0x00000088))=0xb00;
    //	#endif
    //#endif
    *((UINT32P)(EMI_CHN0_APB_BASE+0x0000040c))=0x9f658033;//pcddr4_esl,
    //C:-------------------END))=CHANNEL EMI Setting--------------------;
}

void set_cen_emi_cona(unsigned int cona_val)
{
	mt_emi_sync_write(EMI_CONA, cona_val);
}

void set_cen_emi_conf(unsigned int conf_val)
{
	mt_emi_sync_write(EMI_CONF, conf_val);
}

void set_cen_emi_conh(unsigned int conh_val)
{
	mt_emi_sync_write(EMI_CONH, conh_val);
}

void set_chn_emi_cona(unsigned int cona_val)
{
	mt_emi_sync_write(CHN_EMI_CONA(EMI_CHN0_APB_BASE), cona_val);
	mt_emi_sync_write(CHN_EMI_CONA(EMI_CHN1_APB_BASE), cona_val);
}

void set_chn_emi_conc(unsigned int conc_val)
{
	mt_emi_sync_write(CHN_EMI_CONC(EMI_CHN0_APB_BASE), conc_val);
	mt_emi_sync_write(CHN_EMI_CONC(EMI_CHN1_APB_BASE), conc_val);
}

unsigned int get_cen_emi_cona(void)
{
	return mt_emi_sync_read(EMI_CONA);
}

/* assume all chn emi setting are the same */
unsigned int get_chn_emi_cona(void)
{
	unsigned int ch0_emi_cona;

	ch0_emi_cona = mt_emi_sync_read(EMI_CHN0_APB_BASE);

	return ch0_emi_cona;
}

int get_channel_nr_by_emi(void)
{
	int channel_nr;

	channel_nr = 0x1 << ((mt_emi_sync_read(EMI_CONA) >> 8) & 0x3);

#ifdef SUB_EMI_APB_BASE
	channel_nr *= 2;
#endif
#if DRAM_AUXADC_CONFIG
	U32 ret = 0, voltage = 0;
	ret = iio_read_channel_processed(5, &voltage);
	if (ret == 0)
		if (voltage < 700)
			channel_nr = CHANNEL_FOURTH;
		else
			channel_nr = CHANNEL_DUAL;
	else
		emi_log("Error! Read AUXADC value fail\n");
#endif

	return channel_nr;
}

int get_rank_nr_by_emi(void)
{
	unsigned int cen_emi_cona = mt_emi_sync_read(EMI_CONA);

	if (cen_emi_cona & (0x3 << 16))
		return 2;
	else
		return 1;
}

void get_dram_rank_size_by_EMI_CONA(u64 dram_rank_size[])
{
    unsigned col_bit, row_bit;
    u64 ch0_rank0_size, ch0_rank1_size, ch1_rank0_size, ch1_rank1_size;
#ifndef COMBO_MCP
    unsigned emi_cona = default_emi_setting.EMI_CONA_VAL;
    unsigned emi_conh = default_emi_setting.EMI_CONH_VAL;
#else
    unsigned emi_cona = *(volatile unsigned int*)(EMI_CONA);
    unsigned emi_conh = *(volatile unsigned int*)(EMI_CONH);
#endif
    unsigned nr_chan_enabled = 1;
    u64 per_chan_rank0_size = 0, per_chan_rank1_size = 0;
    unsigned shift_for_16bit = 1;	// data width = 2 bytes

    if (emi_cona & 0x2)
        shift_for_16bit = 0;		// data width = 4 bytes

    dram_rank_size[0] = 0;
    dram_rank_size[1] = 0;

    ch0_rank0_size = (emi_conh >> 16) & 0xf;
    ch0_rank1_size = (emi_conh >> 20) & 0xf;
    ch1_rank0_size = (emi_conh >> 24) & 0xf;
    ch1_rank1_size = (emi_conh >> 28) & 0xf;

    switch ((emi_cona >> 8) & 0x3) {
	    case 0:
		    nr_chan_enabled = 1;
		    break;
	    case 1:
		    nr_chan_enabled = 2;
		    break;
	    case 2:
		    nr_chan_enabled = 4;
		    break;
	    case 3:
	    default:
		    dramc_crit("invalid CHN_EN field in EMI_CONA (0x%x)\n", emi_cona);
		    // assume 4 channel by default
		    nr_chan_enabled = 2;
		    break;
    }

    // CH0 EMI
    {
        if (ch0_rank0_size == 0)
        {
            //rank 0 setting
            col_bit = ((emi_cona >> 4) & 0x03) + 9;
            row_bit = ((((emi_cona >> 24) & 0x01) << 2) + ((emi_cona >> 12) & 0x03)) + 13;
            per_chan_rank0_size = ((u64)(1 << (row_bit + col_bit))) * ((u64)(4 >> shift_for_16bit) * 8); // data width (bytes) * 8 banks
        }
        else
        {
            per_chan_rank0_size = (ch0_rank0_size * 256 << 20);
        }

        if (0 != (emi_cona & (1 << 17)))   //rank 1 exist
        {
            if (ch0_rank1_size == 0)
            {
                col_bit = ((emi_cona >> 6) & 0x03) + 9;
                row_bit = ((((emi_cona >> 25) & 0x01) << 2) + ((emi_cona >> 14) & 0x03)) + 13;
                per_chan_rank1_size = ((u64)(1 << (row_bit + col_bit))) * ((u64)(4 >> shift_for_16bit) * 8); // data width (bytes) * 8 banks
            }
            else
            {
                per_chan_rank1_size = (ch0_rank1_size * 256 << 20);
            }
        }

	if (nr_chan_enabled > 2) {
		// CH0 EMI have CHA+CHB
		dram_rank_size[0] = per_chan_rank0_size * 2;
		dram_rank_size[1] = per_chan_rank1_size * 2;
	} else {
		// CH0 EMI is CHA
		dram_rank_size[0] = per_chan_rank0_size;
		dram_rank_size[1] = per_chan_rank1_size;
	}
    }

    // CH1 EMI
    if (nr_chan_enabled >= 2)
    {
        if (ch1_rank0_size == 0)
        {
            //rank0 setting
            col_bit = ((emi_cona >> 20) & 0x03) + 9;
            row_bit = ((((emi_conh >> 4) & 0x01) << 2) + ((emi_cona >> 28) & 0x03)) + 13;
            per_chan_rank0_size = ((u64)(1 << (row_bit + col_bit))) * ((u64)(4 >> shift_for_16bit) * 8); // data width (bytes) * 8 banks
        }
        else
        {
            per_chan_rank0_size = (ch1_rank0_size * 256 << 20);
        }

        if (0 != (emi_cona & (1 << 16)))   //rank 1 exist
        {
            if (ch1_rank1_size == 0)
            {
                col_bit = ((emi_cona >> 22) & 0x03) + 9;
                row_bit = ((((emi_conh >> 5) & 0x01) << 2) + ((emi_cona >> 30) & 0x03)) + 13;
                per_chan_rank1_size = ((u64)(1 << (row_bit + col_bit))) * ((u64)(4 >> shift_for_16bit) * 8); // data width (bytes) * 8 banks
            }
            else
            {
                per_chan_rank1_size = (ch1_rank1_size * 256 << 20);
            }
        }
	if (nr_chan_enabled > 2) {
		// CH1 EMI have CHC+CHD
		dram_rank_size[0] += per_chan_rank0_size * 2;
		dram_rank_size[1] += per_chan_rank1_size * 2;
	} else {
		// CH1 EMI is CHB
		dram_rank_size[0] += per_chan_rank0_size;
		dram_rank_size[1] += per_chan_rank1_size;
	}
    }

    //dramc_debug("DRAM rank0 size:0x%llx,\nDRAM rank1 size=0x%llx\n", dram_rank_size[0], dram_rank_size[1]);
}

void phy_addr_to_dram_addr(dram_addr_t *dram_addr, unsigned long long phy_addr)
{
	unsigned int emi_cona, emi_conf;
	unsigned long long rank_size[4];
	unsigned int channel_num, rank_num;
	unsigned int bit_scramble, bit_xor, bit_shift, channel_pos, channel_width;
	unsigned int temp;
	unsigned int index;

	emi_cona = *((volatile unsigned int *)EMI_CONA);
	emi_conf = *((volatile unsigned int *)EMI_CONF) >> 8;
	get_dram_rank_size_by_EMI_CONA(rank_size);
	rank_num = (unsigned int) get_dram_rank_nr();
	channel_num = (unsigned int) get_dram_channel_nr();

	phy_addr -= 0x40000000;
	for (index = 0; index < rank_num; index++) {
		if (phy_addr >= rank_size[index])
			phy_addr -= rank_size[index];
		else
			break;
	}

	for (bit_scramble = 11; bit_scramble < 17; bit_scramble++) {
		bit_xor = (emi_conf >> (4 * (bit_scramble - 11))) & 0xf;
		bit_xor &= phy_addr >> 16;
		for (bit_shift = 0; bit_shift < 4; bit_shift++)
			phy_addr ^= ((bit_xor >> bit_shift) & 0x1) << bit_scramble;
	}

	if (channel_num > 1) {
		channel_pos = ((emi_cona >> 2) & 0x3) + 7;

		for (channel_width = bit_shift = 0; bit_shift < 4; bit_shift++) {
			if ((unsigned int)(1 << bit_shift) >= channel_num)
				break;
			channel_width++;
		}

		switch (channel_width) {
		case 2:
			dram_addr->addr = ((phy_addr & ~(((0x1 << 2) << channel_pos) - 1)) >> 2);
			break;
		default:
			dram_addr->addr = ((phy_addr & ~(((0x1 << 1) << channel_pos) - 1)) >> 1);
			break;
		}
		dram_addr->addr |= (phy_addr & ((0x1 << channel_pos) - 1));
	}

	temp = dram_addr->addr >> 1;
	switch ((emi_cona >> 4) & 0x3) {
	case 0:
		dram_addr->col = temp & 0x1FF;
		temp = temp >> 9;
		break;
	case 1:
		dram_addr->col = temp & 0x3FF;
		temp = temp >> 10;
		break;
	case 2:
	default:
		dram_addr->col = temp & 0x7FF;
		temp = temp >> 11;
		break;
	}
	dram_addr->bk = temp & 0x7;
	temp = temp >> 3;

	dram_addr->row = temp;

	//mcSHOW_DBG_MSG("ch%d, rk%d, dram addr: %x\n", dram_addr->ch, dram_addr->rk, dram_addr->addr);
	//mcSHOW_DBG_MSG("bk%x, row%x, col%x\n", dram_addr->bk, dram_addr->row, dram_addr->col);
}

void emi_config()
{
    emi_init();
    emi_init2();
    /* TINFO="EMI init done "*/
    //Wilson
#ifdef EMI_SELF_TEST
    /* TINFO="EMI start bist "*/
    *((UINT32P)(EMI_APB_BASE+0x0000014c)) = 0x104;
    *((UINT32P)(EMI_APB_BASE+0x00000990)) = 0xff;
    ///* TINFO="SUB_EMI start bist "*/
    //*((UINT32P)(SUB_EMI_APB_BASE+0x0000014c)) = 0x104;
    //*((UINT32P)(SUB_EMI_APB_BASE+0x00000990)) = 0xff;
    while (1)
    {

      if ( (*((UINT32P)(EMI_APB_BASE+0x0000014c)) & 0x00010000) >0 )
        break;
    }
    //while (1)
    //{
    //
    //  if ( (*((UINT32P)(SUB_EMI_APB_BASE+0x0000014c)) & 0x00010000) >0 )
    //    break;
    //}


    if( (*((UINT32P)(EMI_APB_BASE+0x0000014c)) & 0x01000000) >0 )
    {
    /*  TERR="EMI BIST FAIL!"*/
    }
    //if( (*((UINT32P)(SUB_EMI_APB_BASE+0x0000014c)) & 0x01000000) >0 )
    //{
    ///*  TERR="SUB_EMI BIST FAIL!"*/
    //}
    *((UINT32P)(EMI_APB_BASE+0x0000014c))=0x0;;
    //*((UINT32P)(SUB_EMI_APB_BASE+0x0000014c))=0x0;;
#endif
}

static void fmem_clk_setting(void)
{
    #ifdef  FMEM_CLK_TBA_ENABLE     /*TBA setting, gating fmem_clk*/
    *((UINT32P)(INFRA_EMI_DCM_CFG0))    = 0x0000007F;
    *((UINT32P)(INFRA_EMI_DCM_CFG1))    = (0x1<<30);
    *((UINT32P)(INFRA_EMI_DCM_CFG2))    = 0x00000044;
    *((UINT32P)(INFRA_EMI_DCM_CFG3))    |= (0x1<<0);
    *((UINT32P)(TOP_CK_ANCHOR_CFG))     = 0x0000053F;
    *((UINT32P)(INFRA_MEM_LOCAL_CG))    = 0x01;
    #else   /*free run clk*/
    *((UINT32P)(INFRA_EMI_DCM_CFG0))    = 0x001F007F;
    *((UINT32P)(INFRA_EMI_DCM_CFG1))    = 0x80000000;
    *((UINT32P)(INFRA_EMI_DCM_CFG2))    = 0x00000044;

    *((UINT32P)(TOP_CK_ANCHOR_CFG))     = 0x0000053F;
    *((UINT32P)(INFRA_MEM_LOCAL_CG))    = 0x01;
    #endif
}

void mem_init_emi(void)
{
    /*unsigned int emi_temp_data;*/

    fmem_clk_setting();
    /*TINFO ="emi_config start" */ /* *MDM_TM_TINFOMSG = 4200;*/
    emi_config();
    /*TINFO ="emi_config end" */ /* *MDM_TM_TINFOMSG = 4203;*/

    if (!is_use_ddr4) { /* SUPPORT_TYPE_DDR3 */
      /*TINFO ="emi pcddr3-16bits channel0-rank0, 1GByte per rank" */
      // reset EMI_CONA, CHN_EMI_CONA,
      *((UINT32P)(EMI_APB_BASE + 0x0))       = 0x0;
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0))  = 0x0;
      //*((UINT32P)(CHN1_EMI_APB_BASE + 0x0))  = 0x0;
      *((UINT32P)EMI_CONH)                  = 0x0;

      //1GBytes per rank
      *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x0<<1);  // DW32_en=0 in ch0-rank0, 16bit
      *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x1<<4);  // col=10bits in ch0-rank0

      *((UINT32P)(EMI_APB_BASE + 0x0))      &= (~(0x3<<12));//clear
      *((UINT32P)(EMI_APB_BASE + 0x0))      &= (~(0x1<<24));
      *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x2<<12); // 3b' 010, row=15bits in ch0-rank0, DDR3 default config 512MB
      *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x0<<24);

      *((UINT32P)(EMI_APB_BASE + 0x60))     |= (0x1<<10); // emi_enable=1
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) |= (0x0<<1);  // DW32_EN=0 in ch0-rank1, 16bit
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) |= (0x1<<4);  // col=10bits in ch0-rank0

      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) &= (~(0x3<<12));//clear
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) &= (~(0x1<<2));
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) |= (0x2<<12); // 3b' 010,row=15bits in ch0-rank0, DDR3 default config 512MB
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) |= (0x0<<2);

      *((UINT32P)(EMI_CHN0_APB_BASE + 0x10))|= (0x1);     // emi_enable=1
      // panther spec, 1 rank
      //  //#ifdef DUAL_RANK, default enable dual rank
      //  *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x1<<17); // DUAL_RANK_EN=1 in ch0-rank1
      //  *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x1<<6);  // col=10bits in ch0-rank1
      //  *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x2<<14); // row=15bits in ch0-rank1
      //  *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) |= (0x1);     // DUAL_RANK_EN=1 in ch0-rank1
      //  *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) |= (0x1<<6);  // col=10bits in ch0-rank1
      //  *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) |= (0x2<<14); // row=15bits in ch0-rank1
      //  // #endif //DUAL_RANK
      /*TINFO ="End of emi pcddr3-16bits channel0-rank0, 1GByte per rank Setting" */

    } else { /* SUPPORT_TYPE_DDR4 */
      /*TINFO ="emi pcddr4-16bits channel0-rank0, 1GByte per rank" */
      // reset EMI_CONA, CHN_EMI_CONA,
      *((UINT32P)(EMI_APB_BASE + 0x0))       = 0x0;
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0))  = 0x0;
      //*((UINT32P)(CHN1_EMI_APB_BASE + 0x0))  = 0x0;
      *((UINT32P)EMI_CONH)                  = 0x0;
      // PCDDR4 new setting, wait for JL
      *((UINT32P)EMI_CONN)                  |=( (0x1<<9) | (0x1<<10) ); // [9]:reg_chn0_ddr4_2bg, [10]:reg_chn1_ddr4_2bg
      //SEDA5
      //*((UINT32P)EMI_CONH_2ND)            |=( (0x1<<3) | (0x1<<5) | (0x1<<8) ); // [3]:reg_bg1_pos, [5]:reg_chn0_16bank_mode, [8]:reg_chn1_16bank_mode

      *((UINT32P)CHN0_EMI_CHN_EMI_CONC_2ND) |=( (0x1<<1) | (0x1<<2) ); // [1]:reg_chn0_ddr4_2bg, [2]:reg_chn1_ddr4_2bg
      //SEDA5
      //*((UINT32P)CHN0_EMI_CHN_EMI_CONA)   |=( (0x1<<10) | (0x1<<11) | (0x1<<31) ); // [31]:reg_bg1_pos, [10]:reg_chn0_16bank_mode, [11]:reg_chn1_16bank_mode

      // 2GBytes per Channel
      *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x0<<1);  // DW32_en=0 in ch0-rank0, 16bit
      *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x1<<4);  // col=10bits in ch0-rank0

      *((UINT32P)(EMI_APB_BASE + 0x0))      &= (~(0x3<<12));//clear
      *((UINT32P)(EMI_APB_BASE + 0x0))      &= (~(0x1<<24));
      *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x3<<12); // 3b' 011, row=16bits in ch0-rank0, DDR4 default config 1GB
      *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x0<<24);

      *((UINT32P)(EMI_APB_BASE + 0x60))     |= (0x1<<10); // emi_enable=1
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) |= (0x0<<1);  // DW32_EN=0 in ch0-rank1, 16bit
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) |= (0x1<<4);  // col=10bits in ch0-rank0

      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) &= (~(0x3<<12));//clear
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) &= (~(0x1<<2));
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) |= (0x3<<12); // 3b' 011, row=16bits in ch0-rank0, DDR4 default config 1GB
      *((UINT32P)(EMI_CHN0_APB_BASE + 0x0)) |= (0x0<<2);

      *((UINT32P)(EMI_CHN0_APB_BASE + 0x10))|= (0x1);     // emi_enable=1

      // panther spec, 1 rank
      ////  #ifdef DUAL_RANK, default enable dual rank
      //  *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x1<<17); // DUAL_RANK_EN=1 in ch0-rank1
      //  *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x1<<6);  // col=10bits in ch0-rank1
      //  *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x0<<14); // row=17bits in ch0-rank1
      //  *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x0<<25); // row=17bits in ch0-rank1
      //  *((UINT32P)(CHN0_EMI_BASE + 0x0)) |= (0x1);     // DUAL_RANK_EN=1 in ch0-rank1
      //  *((UINT32P)(CHN0_EMI_BASE + 0x0)) |= (0x1<<6);  // col=10bits in ch0-rank1
      //  *((UINT32P)(CHN0_EMI_BASE + 0x0)) |= (0x0<<14); // row=17bits in ch0-rank1
      //  *((UINT32P)(CHN0_EMI_BASE + 0x0)) |= (0x1<<3);  // row=17bits in ch0-rank1
      ////  #endif //DUAL_RANK
      //  #ifdef SIM_2CH, default 2ch
        /*TINFO ="emi pcddr4 channel1-rank0" */
      //  *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x1<<8);  // dual channel
      //  *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x1<<2);  // cross channel per 256 bytes,???????, set CHN_POS?
      //  *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x1<<20); // col=10bits in ch1-rank0
      //  *((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x0<<28); // row=17bits in ch1-rank0
      //  *((UINT32P)(EMI_APB_BASE + 0x38))     |= (0x1<<4);  // row=17bits in ch1-rank0 (EMI_CONH)
      //  *((UINT32P)(EMI_APB_BASE + 0x60))     |= (0x1<<10); // emi_enable=1
      //CHN0 & CHN1 use same reg
      //////  *((UINT32P)(CHN1_EMI_APB_BASE + 0x0)) |= (0x1<<4);  // col=10bits in ch1-rank0
      //////  *((UINT32P)(CHN1_EMI_APB_BASE + 0x0)) |= (0x0<<12); // row=17bits in ch1-rank0
      //////  *((UINT32P)(CHN1_EMI_APB_BASE + 0x0)) |= (0x1<<2);  // row=17bits in ch1-rank0
      //////  *((UINT32P)(CHN1_EMI_APB_BASE + 0x10))|= (0x1);     // emi_enable=1
        //#ifdef DUAL_RANK
        ///*TINFO ="emi pcddr4 channel1-rank1" */ *MDM_TM_TINFOMSG = 2960;
        //*((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x1<<16);  // CH1 dual-rank enable=1
        //*((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x1<<22);  // col=10 bits in ch1-rank1
        //*((UINT32P)(EMI_APB_BASE + 0x0))      |= (0x3<<30);  // row=16 bits in ch1-rank1
        //*((UINT32P)(CHN0_EMI_BASE + 0x0)) |= (0x1);      // CH1 dual-rank enable=1
        //*((UINT32P)(CHN0_EMI_BASE + 0x0)) |= (0x1<<6);   // col=10bits in ch1-rank1
        //*((UINT32P)(CHN0_EMI_BASE + 0x0)) |= (0x3<<14);  // row=16bits in ch1-rank1
        //#endif // DUAL_RANK
      //  #endif // SIM_2CH
      /*TINFO ="End of emi pcddr4-16bits channel0-rank0, 1GByte per rank Setting" */
    }

#ifdef LP4_CHB_ONLY
  *((UINT32P)EMI_CONA) = (*((UINT32P)EMI_CONA))|(0x1<<10);
#endif
//  /*TINFO ="disable rcmd rev3.0" */
  *((UINT32P)(EMI_CHN0_APB_BASE + 0x15c)) &= (0xfffffffe); // disable rcmd rev3.0
//  /*TINFO ="set RDF buffer=2" */
  *((UINT32P)(EMI_CHN0_APB_BASE + 0x48)) |= (0x2<<16); // set RDF buffer=2
//  /*TINFO ="CONF done" */
  *((UINT32P)CHN0_EMI_CHN_EMI_CONC) |= (0x1);// CONF done

//  /*TINFO=---===BROADCAST OFF!===---*/ *MDM_TM_TINFOMSG = 4202;
//  *DRAMC_WBR = 0x00000000;

#ifdef SIM_2P2CH
  /*TINFO ="2P2CH Hash Rule" */
  *((UINT32P)EMI_CHN_HASH0) =   0xC0000000;
  *((UINT32P)(0x1021D7A4))  =   0xD0000000;
#elif SIM_2CH
  /*TINFO ="2CH Hash Rule" */
  *((UINT32P)EMI_CHN_HASH0) = 0x80000000;
//  *((UINT32P)(0x1021D7A4))=0x90000000; // no sub_emi in 2ch
#endif

/////////#ifndef PALLADIUM
/////////  #ifndef DRAM_EMI_CONFIG
/////////    /*TINFO ="emi_config start" */
///////////    /*TINFO=---===BROADCAST ON!===---*/ *MDM_TM_TINFOMSG = 4201;
///////////    #ifdef SIM_2P2CH
///////////    *DRAMC_WBR = 0x00027f7f;
///////////    #elif SIM_2CH
///////////    *DRAMC_WBR = 0x0000007f;
///////// //   #endif
/////////    emi_config();
///////////    /*TINFO=---===BROADCAST OFF!===---*/ *MDM_TM_TINFOMSG = 4202;
///////////    *DRAMC_WBR = 0x00000000;
/////////    /*TINFO ="emi_config end" */
/////////  #endif
/////////#endif

//  /*TINFO=---===BROADCAST ON!===---*/ *MDM_TM_TINFOMSG = 4156;
//  #ifdef SIM_2P2CH
//  *DRAMC_WBR = 0x00027f7f;
//  #elif SIM_2CH
//  *DRAMC_WBR = 0x0000007f;
//  #endif
// ==============================================
// enable emi short_req for no slice
// ==============================================

// ==============================================
#ifndef FPC_TEST

//  /*TINFO="Enable chn_emi_rdata_prty_gen & chn_emi_wdata_prty_chk"*/
  *((UINT32P)CHN0_EMI_CHN_EMI_DFTC)    |= (0x1 <<2);
//  *CHN2_EMI_CHN_EMI_DFTC |= (0x1 <<2);
//  *CHN1_EMI_CHN_EMI_DFTC |= (0x1 <<2);
//  *CHN3_EMI_CHN_EMI_DFTC |= (0x1 <<2);
  #ifndef EMI_PRTY_CHK
  /*TINFO="emi prty chk set"*/
  *((UINT32P)EMI_CONN) |= (0x1 <<22);
//  *((UINT32P)SUB_EMI_EMI_CONN) |= (0x1 <<22);
  #endif
#endif

  //wait for panther spec, APMCU Early CKE
//////  /*TINFO="Enable APMCU Early CKE"*/
//////  *EMI_MCUCKE = (0x1 << 2) | (0x1 << 4) | (0x0 << 6) | (0x1 <<7) | (0x0 <<8) | (0x3 <<13) | (0x20 <<16) | (0xf <<24) | (0xf <<28) | (0x1 <<0);
////////  *SUB_EMI_EMI_MCUCKE = (0x1 << 2) | (0x1 << 4) | (0x0 << 6) | (0x1 <<7) | (0x0 <<8) | (0x3 <<13) | (0x20 <<16) | (0xf <<24) | (0xf <<28) | (0x1 <<0);
//////
//////    // wait for mcusys
////////  *APMCU_EMI_EARLY_CKE_CTL0 = *EMI_MCUCKE;
////////  *APMCU_EMI_EARLY_CKE_CTL1 = *SUB_EMI_EMI_MCUCKE;
//////
//////  *((UINT32P)(CHN0_EMI_BASE+0x090)) = (0xff <<0) | (0x1 <<9);
////////  *((UINT32P)(CHN1_EMI_APB_BASE+0x090)) = (0xff <<0) | (0x1 <<9);

//  /*TINFO="emi hash rule, no use"*/
//   *EMI_CHN_HASH0 |= (*INFRA_EMI_DISPH_CFG & 0xf);
//   *SUB_EMI_EMI_CHN_HASH0 |= (*INFRA_EMI_DISPH_CFG & 0xf);

// Panther no EBG spec
//  /*TINFO="Enable APMCU ENI EBG CTRL"*/
//   *APMCU_EMI_EBG_CTL0 = *EMI_BNK_MSK0;
//   *APMCU_EMI_EBG_CTL1 = *EMI_BNK_MSK1;
//   *APMCU_EMI_EBG_CTL2 = *EMI_BNK_MSK2;
//   *APMCU_EMI_EBG_CTL2 |= 0x10 <<10;
//   *APMCU_EMI_EBG_CTL2 |= 0x1  <<18;
//   *APMCU_EMI_EBG_CTL3 = *EMI_BNK_MSK0;
//   *APMCU_EMI_EBG_CTL4 = *EMI_BNK_MSK1;
//   *APMCU_EMI_EBG_CTL5 = *EMI_BNK_MSK2;
//   *APMCU_EMI_EBG_CTL5 |= 0x10 <<10;
//   *APMCU_EMI_EBG_CTL5 |= 0x1  <<18;
//
//  /*TINFO="Step1: specify starvation at chn_emi_reg"*/
//  /*TINFO="Step2: mask non-urgent QoS event for EBG block"*/
//  /*TINFO="Step3: enable EBG function"*/
//
//  *CHN0_EMI_CHN_EMI_EBG_CON = (0x2 << 0) | (0x0 << 6) | (0x1 << 7) | (0x2 << 8) | (0x0 << 14) | (0x1 << 15) | (0x3fff<<16);
////  *CHN2_EMI_CHN_EMI_EBG_CON = (0x2 << 0) | (0x0 << 6) | (0x1 << 7) | (0x2 << 8) | (0x0 << 14) | (0x1 << 15) | (0x3fff<<16);
////  *CHN1_EMI_CHN_EMI_EBG_CON = (0x3 << 0) | (0x0 << 6) | (0x1 << 7) | (0x2 << 8) | (0x0 << 14) | (0x1 << 15) | (0x3fff<<16);
////  *CHN3_EMI_CHN_EMI_EBG_CON = (0x4 << 0) | (0x0 << 6) | (0x1 << 7) | (0x2 << 8) | (0x0 << 14) | (0x1 << 15) | (0x3fff<<16);

//  /*TINFO="Enable EMI wdata bus encode function"*/
  *((UINT32P)EMI_CONN) |= (0x1 << 21);
//  *SUB_EMI_EMI_CONN |= (0x1 << 21);
  *((UINT32P)CHN0_EMI_CHN_EMI_DFTC) |= (0x1 <<4); //equal to CHN_EMI_TESTC
//  *CHN2_EMI_CHN_EMI_DFTC |= (0x1 <<4);
//  *CHN1_EMI_CHN_EMI_DFTC |= (0x1 <<4);
//  *CHN3_EMI_CHN_EMI_DFTC |= (0x1 <<4);

// ==============================================
// Added for EMI sideband verification - END
// ==============================================

   // need to check with mcusys owner
  //*EMI_CLUA = ((0x4 << 0) | (0x3 << 3) | (0x2 << 6) | (0x1 << 9) | (0x0 << 12));//Cluster ID setting

  //*((UINT32P)EMI_CONE) &= 0xffff7fff;//sleep protect release, [15]=0

//  /*TINFO=---===BROADCAST OFF!===---*/
//  *DRAMC_WBR = 0x00000000;
    /* TINFO="Start DRAM ACCESS Test  */
    // dram access test
//    *((UINT32P) ( 0x40100000)) = 0x22225555;
//    /* TINFO="address 0x40100000=%h",*((UINT32P)0x40100000)  */
    /* TINFO="address 0x48100000=%h",*((UINT32P)0x48100000)  */
//    /* TINFO="DRAM ACCESS Test Done  */
}

