/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2018
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

#ifndef __MTK_DRM_H__
#define __MTK_DRM_H__

#define MTK_DRM_BASE		(0x1001D000)

#define MTK_DRM_MODE		(MTK_DRM_BASE+0x0000)
#define MTK_DRM_NONRST_REG	(MTK_DRM_BASE+0x0020)
#define MTK_DRM_NONRST_REG2	(MTK_DRM_BASE+0x0024)
#define MTK_DRM_DEBUG_CTL	(MTK_DRM_BASE+0x0030)
#define MTK_DRM_DEBUG_CTL2	(MTK_DRM_BASE+0x0034)
#define MTK_DRM_DEBUG_CTL3	(MTK_DRM_BASE+0x0038)
#define MTK_DRM_LATCH_CTL	(MTK_DRM_BASE+0x0040)
#define MTK_DRM_LATCH_CTL2	(MTK_DRM_BASE+0x0044)
#define MTK_DRM_LATCH_CTL3	(MTK_DRM_BASE+0x0048)
#define MTK_DRM_LATCH_CTL4	(MTK_DRM_BASE+0x004C)
#define MTK_DRM_LATCH_CTL5	(MTK_DRM_BASE+0x0050)
#define MTK_DRM_MFG_REG		(MTK_DRM_BASE+0x0060)
#define MTK_DRM_DEBUG_0_REG	(MTK_DRM_BASE+0x0500)
#define MTK_DRM_DEBUG_1_REG	(MTK_DRM_BASE+0x0504)
#define MTK_DRM_DEBUG_2_REG	(MTK_DRM_BASE+0x0508)

/* MTK_DRM_MODE */
#define MTK_DRM_MODE_KEY		(0x22000000)
#define MTK_DRM_MODE_DDR_RESERVE	(0x00000001)

/* MTK_DRM_DEBUG_CTL */
#define MTK_DRM_DEBUG_CTL_KEY		(0x59000000)
#define MTK_DRM_DRAMC_SREF		(0x00001000)
#define MTK_DRM_DRAMC_ISO		(0x00002000)
#define MTK_DRM_DRAMC_CONF_ISO		(0x00004000)
#define MTK_DRM_DRM_LITE_MODE		(0x00008000)
#define MTK_DRM_DVFSRC_PAUSE		(0x00080000)
#define MTK_DRM_DDR_RESERVE_STA		(0x00100000)
#define MTK_DRM_DDR_SREF_STA		(0x00200000)
#define MTK_DRM_DVFSRC_SUCCESS		(0x00400000)

/* MTK_DRM_DEBUG_CTL2 */
#define MTK_DRM_DEBUG_CTL2_KEY		(0x55000000)
#define MTK_DRM_EMI_DCS_EN		(0x00000100)
#define MTK_DRM_DVFSRC_EN		(0x00000200)
#define MTK_DRM_EMI_DCS_PAUSE		(0x00200000)

/* MTK_DRM_LATCH_CTL */
#define MTK_DRM_LATCH_CTL_KEY		(0x95000000)
#define MTK_DRM_LATCH_EN		(0x00000001)
#define MTK_DRM_MCU_LATCH_SELECT	(0x00000002)
#define MTK_DRM_SPM_LATCH_SELECT	(0x00000004)
#define MTK_DRM_MCU_LATCH_EN		(0x00000010)
#define MTK_DRM_SPM_LATCH_EN		(0x00000020)
#define MTK_DRM_DRAMC_LATCH_EN		(0x00000040)
#define MTK_DRM_MP0_EXT_OFF_EN		(0x00000100)
#define MTK_DRM_GPU_EXT_OFF_EN		(0x00000200)
#define MTK_DRM_MD_EXT_OFF_EN		(0x00000400)
#define MTK_DRM_DRAMC_RD_TEST_EN	(0x00000800)
#define MTK_DRM_DRAMC_RDWT_TEST_EN	(0x00001000)
#define MTK_DRM_DVFSRC_LATCH_EN		(0x00002000)
#define MTK_DRM_EMI_LATCH_EN		(0x00004000)
#define MTK_DRM_DEBUGSYS_LATCH_EN	(0x00020000)

/* MTK_DRM_LATCH_CTL2 */
#define MTK_DRM_LATCH_CTL2_KEY		(0x95000000)
#define MTK_DRM_MCU_DFD_EN		(0x00020000)
#define MTK_DRM_MCU_DFD_TIMEOUT_MASK	(0x0001FFFF)
#define MTK_DRM_MCU_DFD_TIMEOUT_OFS	(0)
#define MTK_DRM_MCU_DFD_TIMEOUT_VALUE	(0x00A0)	/* DFD V3.0 */
/*#define MTK_DRM_MCU_DFD_TIMEOUT_VALUE	(0x5DC0)*/	/* DFD V3.5 */

enum {
	DRM_REG_CLR = 0,
	DRM_REG_SET = 1
};

int drm_dram_reserved(int enable);
int drm_is_dram_slf(void);
int drm_is_dvfsrc_enable(void);
int drm_is_dvfsrc_success(void);
int drm_is_reserve_ddr_enabled(void);
int drm_is_reserve_ddr_mode_success(void);
int drm_release_rg_dram_setting(void);
int drm_release_rg_dramc_conf_iso(void);
int drm_release_rg_dramc_iso(void);
int drm_release_rg_dramc_sref(void);

#endif   /*__MTK_DRM_H__*/
