/*
 * Copyright (c) 2020, ARM Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <common/debug.h>
#include <lib/mmio.h>

#include <devapc.h>

/* Infra_ao */
static const struct APC_PERI_DOM_16 INFRA_AO_SYS0_Devices[] = {

/* 0 */
DAPC_INFRA_AO_SYS0_ATTR("NET_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("NET_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("NET_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PCIE_AXI_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PCIE_AXI_S1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PCIE_AXI_S2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PCIE_AXI_S3",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("INFRA_TOPS_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SGMII_SBUS0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SGMII_SBUS1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_INFRA_AO_SYS0_ATTR("USXGMII_SBUS0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("USXGMII_SBUS1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("ETH2P5G_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_EAST_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_EAST_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_EAST_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_EAST_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_EAST_APB4_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 20 */
DAPC_INFRA_AO_SYS0_ATTR("BND_EAST_APB5_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_EAST_APB6_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_EAST_APB7_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_SOUTH_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_SOUTH_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_SOUTH_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_SOUTH_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_SOUTH_APB4_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_SOUTH_APB5_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_SOUTH_APB6_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 30 */
DAPC_INFRA_AO_SYS0_ATTR("BND_SOUTH_APB7_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_WEST_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_WEST_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_WEST_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_WEST_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_WEST_APB4_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_WEST_APB5_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_WEST_APB6_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_WEST_APB7_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_NORTH_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 40 */
DAPC_INFRA_AO_SYS0_ATTR("BND_NORTH_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_NORTH_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_NORTH_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_NORTH_APB4_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_NORTH_APB5_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_NORTH_APB6_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BND_NORTH_APB7_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("INFRACFG_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("INFRACFG_AO_AUTO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("INFRACFG_AO_MEM_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 50 */
DAPC_INFRA_AO_SYS0_ATTR("RESERVED_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("AP_CIRQ_EINT_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SYS_TIMER_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("CKSYS_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("CKSYS_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("CKSYS_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("TOP_CENTER_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("TOP_CENTER_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("TOP_CENTER_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("TOP_CENTER_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 60 */
DAPC_INFRA_AO_SYS0_ATTR("TOP_CENTER_APB4_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BCRM_INFRA_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BCRM_PERI_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DEBUG_CTRL_INFRA_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DEVICE_APC_INFRA_AO_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("AUDIO_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("AUDIO_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SSUSB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SSUSB_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SSUSB_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 70 */
DAPC_INFRA_AO_SYS0_ATTR("SSUSB_P1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SSUSB_P1_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SSUSB_P1_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DEBUGSYS_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH0_TOP0_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH0_TOP1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH0_TOP2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH0_TOP3_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH0_TOP4_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH0_TOP5_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 80 */
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH0_TOP6_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH1_TOP0_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH1_TOP1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH1_TOP2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH1_TOP3_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH1_TOP4_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH1_TOP5_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_CH1_TOP6_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DRAMC_MD32_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("APXGPT_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 90 */
DAPC_INFRA_AO_SYS0_ATTR("SEJ_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SECURITY_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PWM_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BCRM_PERI_AO2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DEBUG_CTRL_FMEM_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DEVICE_APC_FMEM_AO_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SYS_CIRQ_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("INFRACFG_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("INFRACFG_PDN_AUTO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("TRNG_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 100 */
DAPC_INFRA_AO_SYS0_ATTR("CQ_DMA_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SRAMROM_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("INFRACFG_MEM_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("DEVICE_APC_INFRA_PDN_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("EMI_FAKE_ENGINE_0_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("EMI_FAKE_ENGINE_1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("EMI_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("EMI_MPU_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BCRM_FMEM_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BCRM_INFRA_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 110 */
DAPC_INFRA_AO_SYS0_ATTR("BCRM_PERI_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BCRM_PERI_PDN2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PCIE_AHB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PCIE_AHB_S1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PCIE_AHB_S2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PCIE_AHB_S3",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MSDC0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("UART0_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("UART1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("UART2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 120 */
DAPC_INFRA_AO_SYS0_ATTR("SPI0_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SPI1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("SPI2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("AUXADC_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PTP_THERM_CTRL_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("I2C_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("I2C_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("I2C_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("I2C_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PERICFG_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 130 */
DAPC_INFRA_AO_SYS0_ATTR("PERICFG_PDN_AUTO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("NFI_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("NFIECC_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("APDMA_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BCRM_PERI_PAR_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PERICFG_AO_AUTO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PERICFG_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("BCRM_PERI_PAR_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
};

/* TOPS_PERI_BUS_AO_PDN */
static const struct APC_PERI_DOM_16 TOPS_PERI_BUS_AO_PDN_SYS0_Devices[] = {

/* 0 */
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCFG_0_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCFG_1_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCFG_2_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCFG_3_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCKCTL_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DMA_0_CFG_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("OS_TIMER_0_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("OS_TIMER_1_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DSP_TIMER_0_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DSP_UART_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DSPMBOX_0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DSPMBOX_1_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("WDT_0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("WDT_1_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCFG_SEC_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("DMA_1_CFG_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("ADSP_RSV_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("ADSP_RSV_1_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("ADSP_RSV_2_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("ADSP_BUSCFG_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 20 */
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("ADSP_TMBIST_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("INTC_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("TOPS_PERI_BCRM_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("TOPS_PERI_BUS_DEBUG_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("TOPS_PERI_DAPC_AO_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_PERI_BUS_AO_PDN_SYS0_ATTR("TOPS_PERI_DAPC_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
};

/* TOPS_BUS_AO_PDN */
static const struct APC_PERI_DOM_16 TOPS_BUS_AO_PDN_SYS0_Devices[] = {

/* 0 */
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("CORE_TOP_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("CORE_TOP_S-1",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("INFRA_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("INFRA_S-1",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("INFRA_S-2",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("INFRA_S-3",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("EMI_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, NO_PROTECTION, FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("SRAM_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, NO_PROTECTION, FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("NDMA_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("NDMA_S-1",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("TOPS_PERI_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("CLUST0_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("CLUST1_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("CLUST2_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("CLUST3_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("BCRM_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("BUS_DEBUG_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("DAPC_AO_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("K_BCRM_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_TOPS_BUS_AO_PDN_SYS0_ATTR("DAPC_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
};

/* CLUST_PERI_BUS_AO_PDN */
static const struct APC_PERI_DOM_16 CLUST_PERI_BUS_AO_PDN_SYS0_Devices[] = {

/* 0 */
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCFG_0_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCFG_1_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCFG_2_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCFG_3_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCKCTL_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DMA_0_CFG_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("OS_TIMER_0_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("OS_TIMER_1_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DSP_TIMER_0_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DSP_UART_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DSPMBOX_0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DSPMBOX_1_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("WDT_0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("WDT_1_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DSPCFG_SEC_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("DMA_1_CFG_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("ADSP_RSV_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("ADSP_RSV_1_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("ADSP_RSV_2_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("ADSP_BUSCFG_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 20 */
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("ADSP_TMBIST_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("INTC_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("CLUST_PERI_BCRM_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("CLUST_PERI_BUS_DEBUG_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("CLUST_PERI_DAPC_AO_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_PERI_BUS_AO_PDN_SYS0_ATTR("CLUST_PERI_DAPC_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
};

/* CLUST_BUS_AO_PDN */
static const struct APC_PERI_DOM_16 CLUST_BUS_AO_PDN_SYS0_Devices[] = {

/* 0 */
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("SRAM_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("SRAM_S-1",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("SRAM_S-2",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("SRAM_S-3",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("SRAM_S-4",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, NO_PROTECTION, FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("SRAM_S-5",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("SRAM_S-6",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("SRAM_S-7",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("DSP0_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("DSP0_S-1",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("DSP1_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("DSP1_S-1",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("DSP2_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("DSP2_S-1",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("DSP3_S",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("DSP3_S-1",
			SEC_RW_NS_R,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("TOPS0_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("TOPS0_S-1",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("TOPS1_S-1",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("CLUST_PERI_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 20 */
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("CLUST_LLCR_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("ADSP_RSV_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("BCRM_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("BUS_DEBUG_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("DAPC_AO_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("K_BCRM_S",
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_CLUST_BUS_AO_PDN_SYS0_ATTR("DAPC_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
};

/* FMEM_ao */
static const unsigned char FMEM_AO_Masters[] = {

	/* 0 */
	DAPC_MAS_DOM_ATTR("EMI_FAKE_ENGINE_0_M",DOMAIN_0),
	DAPC_MAS_DOM_ATTR("TOPS_EMI_M4", DOMAIN_8),
	DAPC_MAS_DOM_ATTR("NETSYS_INFRA_M", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("EMI_FAKE_ENGINE_1_M", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("NETSYS_EMI_M1", DOMAIN_1),
	DAPC_MAS_DOM_ATTR("MCU_M0_M", DOMAIN_0),
};

/* INFRA_ao */
static const unsigned char INFRA_AO_Masters[] = {

	/* 0 */
	DAPC_MAS_DOM_ATTR("TOPS_INFRA_M", DOMAIN_8),
	DAPC_MAS_DOM_ATTR("PWM_M", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("AUDIO_M", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("PCIE_M", DOMAIN_4),
	DAPC_MAS_DOM_ATTR("PCIE_M2", DOMAIN_4),
	DAPC_MAS_DOM_ATTR("PCIE_M1", DOMAIN_4),
	DAPC_MAS_DOM_ATTR("PCIE_M3", DOMAIN_4),
	DAPC_MAS_DOM_ATTR("EMI_L2C_M", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("SSUSB_M0", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("SSUSB_M1", DOMAIN_0),

	/* 10 */
	DAPC_MAS_DOM_ATTR("SSUSB_P1_M0", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("SSUSB_P1_M1", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("SPI0_M", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("SPI1_M", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("SPI2_M", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("MSDC0_M", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("NFI_M", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("THERM_M", DOMAIN_0),
	DAPC_MAS_DOM_ATTR("DEBUG_M", DOMAIN_0),
};

/* TOPS_BUS_AO_PDN */
static const unsigned char TOPS_BUS_AO_PDN_Masters[] = {

	/* 0 */
	DAPC_MAS_DOM_ATTR("CORE_TOP_M", DOMAIN_8),
	DAPC_MAS_DOM_ATTR("DMA_M", DOMAIN_9),
	DAPC_MAS_DOM_ATTR("NDMA_M", DOMAIN_8),
};

/* CLUST_BUS_AO_PDN */
static const unsigned char CLUST_BUS_AO_PDN_Masters[] = {

	/* 0 */
	DAPC_MAS_DOM_ATTR("DSP_M0",DOMAIN_8),
	DAPC_MAS_DOM_ATTR("DSP_M1", DOMAIN_8),
	DAPC_MAS_DOM_ATTR("DSP_M2", DOMAIN_8),
	DAPC_MAS_DOM_ATTR("DSP_M3", DOMAIN_8),
	DAPC_MAS_DOM_ATTR("DMA_M0", DOMAIN_9),
};

static const struct devapc_ao_desc devapc_ao_descs[] = {
	[DAPC_TYPE_FMEM_AO] = {
		.mas = {
			/* 6 */
			.mod_num = ARRAY_SIZE(FMEM_AO_Masters),
			.dom_num = 16,
			.base = DEVAPC_FMEM_AO_MAS_DOM_0,
			.sec_base = DEVAPC_FMEM_AO_MAS_SEC_0,
			.mas_dom = FMEM_AO_Masters,
		}
	},
	[DAPC_TYPE_INFRA_AO] = {
		.mas = {
			/* 20 */
			.mod_num = ARRAY_SIZE(INFRA_AO_Masters) + 1,
			.dom_num = 16,
			.base = DEVAPC_INFRA_AO_MAS_DOM_0,
			.sec_base = DEVAPC_INFRA_AO_MAS_SEC_0,
			.mas_dom = INFRA_AO_Masters,
		},
		.slv = {
			/* 138 */
			.mod_num = ARRAY_SIZE(INFRA_AO_SYS0_Devices),
			.dom_num = 16,
			.base = DEVAPC_INFRA_AO_SYS0_D0_APC_0,
			.dev_apc = INFRA_AO_SYS0_Devices,
		}
	},
	[DAPC_TYPE_TOPS_PERI_BUS_AO_PDN] = {
		.slv = {
			/* 26 */
			.mod_num = ARRAY_SIZE(TOPS_PERI_BUS_AO_PDN_SYS0_Devices),
			.dom_num = 16,
			.base = DEVAPC_TOPS_PERI_BUS_AO_PDN_SYS0_D0_APC_0,
			.dev_apc = TOPS_PERI_BUS_AO_PDN_SYS0_Devices,
		}
	},
	[DAPC_TYPE_TOPS_BUS_AO_PDN] = {
		.mas = {
			/* 3 */
			.mod_num = ARRAY_SIZE(TOPS_BUS_AO_PDN_Masters),
			.dom_num = 16,
			.base = DEVAPC_TOPS_BUS_AO_PDN_MAS_DOM_0,
			.sec_base = DEVAPC_TOPS_BUS_AO_PDN_MAS_SEC_0,
			.mas_dom = TOPS_BUS_AO_PDN_Masters,
		},
		.slv = {
			/* 20 */
			.mod_num = ARRAY_SIZE(TOPS_BUS_AO_PDN_SYS0_Devices),
			.dom_num = 16,
			.base = DEVAPC_TOPS_BUS_AO_PDN_SYS0_D0_APC_0,
			.dev_apc = TOPS_BUS_AO_PDN_SYS0_Devices,
		}
	},
	[DAPC_TYPE_CLUST_PERI_BUS_AO_PDN] = {
		.slv = {
			/* 26 */
			.mod_num = ARRAY_SIZE(CLUST_PERI_BUS_AO_PDN_SYS0_Devices),
			.dom_num = 16,
			.base = DEVAPC_CLUST_PERI_BUS_AO_PDN_SYS0_D0_APC_0,
			.dev_apc = CLUST_PERI_BUS_AO_PDN_SYS0_Devices,
		}
	},
	[DAPC_TYPE_CLUST_BUS_AO_PDN] = {
		.mas = {
			/* 5 */
			.mod_num = ARRAY_SIZE(CLUST_BUS_AO_PDN_Masters),
			.dom_num = 16,
			.base = DEVAPC_CLUST_BUS_AO_PDN_MAS_DOM_0,
			.sec_base = DEVAPC_CLUST_BUS_AO_PDN_MAS_SEC_0,
			.mas_dom = CLUST_BUS_AO_PDN_Masters,
		},
		.slv = {
			/* 27 */
			.mod_num = ARRAY_SIZE(CLUST_BUS_AO_PDN_SYS0_Devices),
			.dom_num = 16,
			.base = DEVAPC_CLUST_BUS_AO_PDN_SYS0_D0_APC_0,
			.dev_apc = CLUST_BUS_AO_PDN_SYS0_Devices,
		}
	}
};

static void set_module_apc(enum DEVAPC_TYPE type,
		uint32_t module, enum DOMAIN_ID domain_id,
		enum DEVAPC_PERM_TYPE perm)
{
	uint32_t apc_register_index;
	uint32_t apc_set_index;
	uintptr_t base = 0, reg;
	uint32_t clr_bit;
	uint32_t set_bit;

	if (type >= DAPC_TYPE_MAX) {
		ERROR("[DEVAPC] %s: %s, %s: 0x%08x, %s: 0x%08x, %s: 0x%08x\n",
				__func__, "invalid slave type",
				"slave_type", type,
				"module", module,
				"domain_id", domain_id);
		panic();
	}

	apc_register_index = module / MOD_NO_IN_1_DEVAPC;
	apc_set_index = module % MOD_NO_IN_1_DEVAPC;

	clr_bit = (0x3U << (apc_set_index * 2));
	set_bit = (uint32_t)perm << (apc_set_index * 2);

	if (devapc_ao_descs[type].slv.mod_num &&
		(module < devapc_ao_descs[type].slv.mod_num) &&
		(domain_id < devapc_ao_descs[type].slv.dom_num)) {
		base = devapc_ao_descs[type].slv.base;
	} else {
		ERROR("[DEVAPC] %s: %s, %s:0x%08x, %s:0x%08x, %s:0x%08x\n",
				__func__, "out of boundary",
				"slave_type", type,
				"module", module,
				"domain_id", domain_id);
		panic();
	}

	if (base != 0U) {
		reg = base + domain_id * 0x40 + apc_register_index * 4;
		mmio_clrsetbits_32(reg, clr_bit, set_bit);
	}
}

static void dump_ao_module_apc(enum DEVAPC_TYPE type)
{
	int reg_num;
	int d, i;

	if (type >= DAPC_TYPE_MAX) {
		ERROR("[DEVAPC] %s: %s, %s: 0x%08x\n",
				__func__, "invalid slave type",
				"slave_type", type);
		panic();
	}

	reg_num = (devapc_ao_descs[type].slv.mod_num - 1) / MOD_NO_IN_1_DEVAPC;
	for (d = 0; d < devapc_ao_descs[type].slv.dom_num; d++) {
		for (i = 0; i <= reg_num; i++) {
			VERBOSE("[DEVAPC] type: 0x%08x, D%d_APC_%d: 0x%08x\n",
					type, d, i, devapc_readl(
					devapc_ao_descs[type].slv.base +
					d * 0x40 + i * 4));
		}
	}
}

static void set_ao_module_apc(enum DEVAPC_TYPE type)
{
	uint32_t ao_size;
	uint32_t i;
	const struct APC_PERI_DOM_16 *devices;

	if (type >= DAPC_TYPE_MAX) {
		ERROR("[DEVAPC] %s: %s, %s: 0x%08x\n",
				__func__, "invalid slave type",
				"slave_type", type);
		panic();
	}

	devices = devapc_ao_descs[type].slv.dev_apc;
	ao_size = devapc_ao_descs[type].slv.mod_num;

	for (i = 0; i < ao_size; i++) {
		set_module_apc(type, i, DOMAIN_0, devices[i].d0_permission);
		set_module_apc(type, i, DOMAIN_1, devices[i].d1_permission);
		set_module_apc(type, i, DOMAIN_2, devices[i].d2_permission);
		set_module_apc(type, i, DOMAIN_3, devices[i].d3_permission);
		set_module_apc(type, i, DOMAIN_4, devices[i].d4_permission);
		set_module_apc(type, i, DOMAIN_5, devices[i].d5_permission);
		set_module_apc(type, i, DOMAIN_6, devices[i].d6_permission);
		set_module_apc(type, i, DOMAIN_7, devices[i].d7_permission);
		set_module_apc(type, i, DOMAIN_8, devices[i].d8_permission);
		set_module_apc(type, i, DOMAIN_9, devices[i].d9_permission);
		set_module_apc(type, i, DOMAIN_10, devices[i].d10_permission);
		set_module_apc(type, i, DOMAIN_11, devices[i].d11_permission);
		set_module_apc(type, i, DOMAIN_12, devices[i].d12_permission);
		set_module_apc(type, i, DOMAIN_13, devices[i].d13_permission);
		set_module_apc(type, i, DOMAIN_14, devices[i].d14_permission);
		set_module_apc(type, i, DOMAIN_15, devices[i].d15_permission);
	}
}

static void set_master_dom(enum DEVAPC_TYPE type,
			   uint32_t master, enum DOMAIN_ID domain_id)
{
	uint32_t mas_dom_reg_index;
	uint32_t mas_dom_set_index;
	uintptr_t base = 0, reg;
	uint32_t clr_bit;
	uint32_t set_bit;

	if (type >= DAPC_TYPE_MAX) {
		ERROR("[DEVAPC] %s: %s, %s: 0x%08x, %s: 0x%08x\n",
				__func__, "invalid master type",
				"master_type", type,
				"master", master);
		panic();
	}

	if (domain_id >= devapc_ao_descs[type].mas.dom_num) {
		ERROR("[DEVAPC] %s: %s, %s: 0x%08x, %s: 0x%08x\n",
				__func__, "invalid domain id",
				"master_type", type,
				"master", master);
		panic();
	}

	mas_dom_reg_index = master / MAS_NO_IN_1_MAS_DOM;
	mas_dom_set_index = master % MAS_NO_IN_1_MAS_DOM;

	clr_bit = (0xfU << (mas_dom_set_index * 8));
	set_bit = (uint32_t)domain_id << (mas_dom_set_index * 8);

	if ((type == DAPC_TYPE_INFRA_AO) &&
		(master < devapc_ao_descs[type].mas.mod_num - 1)) {
		base = devapc_ao_descs[type].mas.base;
	} else if (devapc_ao_descs[type].mas.mod_num &&
		(master < devapc_ao_descs[type].mas.mod_num)) {
		base = devapc_ao_descs[type].mas.base;
	} else {
		ERROR("[DEVAPC] %s: %s, %s:0x%08x, %s:0x%08x\n",
				__func__, "out of boundary",
				"master_type", type,
				"master", master);
		panic();
	}

	if (base != 0U) {
		reg = base + mas_dom_reg_index * 4;
		mmio_clrsetbits_32(reg, clr_bit, set_bit);
	}
}

static void dump_ao_master_dom(enum DEVAPC_TYPE type)
{
	int reg_num;
	int i;

	if (type >= DAPC_TYPE_MAX) {
		ERROR("[DEVAPC] %s: %s, %s: 0x%08x\n",
				__func__, "invalid master type",
				"master_type", type);
		panic();
	}

	if (type == DAPC_TYPE_INFRA_AO) {
		reg_num = (devapc_ao_descs[type].mas.mod_num - 2) / MAS_NO_IN_1_MAS_DOM;
	} else {
		reg_num = (devapc_ao_descs[type].mas.mod_num - 1) / MAS_NO_IN_1_MAS_DOM;
	}

	for (i = 0; i <= reg_num; i++) {
		VERBOSE("[DEVAPC] type: 0x%08x, MAS_DOM_%d: 0x%08x\n",
				type, i, devapc_readl(
				devapc_ao_descs[type].mas.base + i * 4));
	}

	VERBOSE("[DEVAPC] type: 0x%08x, MAS_SEC_0: 0x%08x\n", type,
		devapc_readl(devapc_ao_descs[type].mas.sec_base));
}

static void set_ao_master_dom(enum DEVAPC_TYPE type)
{
	uint32_t ao_master_size;
	uint32_t i;
	const unsigned char *mas_dom;

	if (type >= DAPC_TYPE_MAX) {
		ERROR("[DEVAPC] %s: %s, %s: 0x%08x\n",
				__func__, "invalid master type",
				"master_type", type);
		panic();
	}

	if (type == DAPC_TYPE_INFRA_AO) {
		/* skip MCU master */
		ao_master_size = devapc_ao_descs[type].mas.mod_num - 1;
	} else {
		ao_master_size = devapc_ao_descs[type].mas.mod_num;
	}

	mas_dom = devapc_ao_descs[type].mas.mas_dom;

	for (i = 0; i < ao_master_size; i++) {
		set_master_dom(type, i, mas_dom[i]);
	}
}

void infra_devapc_init(void)
{
	/* initialize DEVAPC */
	mmio_write_32(DEVAPC_FMEM_AO_APC_CON, 0x80000001);
	mmio_write_32(DEVAPC_INFRA_AO_APC_CON, 0x80000001);
	mmio_write_32(DEVAPC_INFRA_PDN_APC_CON, 0x80000001);

	/* setup master domains */
	set_ao_master_dom(DAPC_TYPE_FMEM_AO);
	set_ao_master_dom(DAPC_TYPE_INFRA_AO);

	/* dump master domains */
	dump_ao_master_dom(DAPC_TYPE_FMEM_AO);
	dump_ao_master_dom(DAPC_TYPE_INFRA_AO);

	/* setup permission */
	set_ao_module_apc(DAPC_TYPE_INFRA_AO);

	/* dump permission */
	dump_ao_module_apc(DAPC_TYPE_INFRA_AO);

	INFO("[DEVAPC] %s done\n", __func__);
}

void tops_devapc_init(void)
{
	/* initialize TOPS's DEVAPC */
	mmio_write_32(DEVAPC_TOPS_PERI_BUS_AO_PDN_APC_CON, 0x80000001);
	mmio_write_32(DEVAPC_TOPS_BUS_AO_PDN_APC_CON, 0x80000001);
	mmio_write_32(DEVAPC_CLUST_BUS_AO_PDN_APC_CON, 0x80000001);
	mmio_write_32(DEVAPC_CLUST_PERI_BUS_AO_PDN_APC_CON, 0x80000001);

	mmio_write_32(DEVAPC_TOPS_PERI_BUS_AO_PDN_PDN_APC_CON, 0x80000001);
	mmio_write_32(DEVAPC_TOPS_BUS_AO_PDN_PDN_APC_CON, 0x80000001);
	mmio_write_32(DEVAPC_CLUST_BUS_AO_PDN_PDN_APC_CON, 0x80000001);
	mmio_write_32(DEVAPC_CLUST_PERI_BUS_AO_PDN_PDN_APC_CON, 0x80000001);

	/* setup TOPS's master domains */
	set_ao_master_dom(DAPC_TYPE_TOPS_BUS_AO_PDN);
	set_ao_master_dom(DAPC_TYPE_CLUST_BUS_AO_PDN);

	/* dump TOPS's master domains */
	dump_ao_master_dom(DAPC_TYPE_TOPS_BUS_AO_PDN);
	dump_ao_master_dom(DAPC_TYPE_CLUST_BUS_AO_PDN);

	/* setup TOPS's CLUST_BUS permission */
	set_ao_module_apc(DAPC_TYPE_CLUST_PERI_BUS_AO_PDN);
	set_ao_module_apc(DAPC_TYPE_CLUST_BUS_AO_PDN);

	/* dump TOPS's CLUST_BUS permission */
	dump_ao_module_apc(DAPC_TYPE_CLUST_PERI_BUS_AO_PDN);
	dump_ao_module_apc(DAPC_TYPE_CLUST_BUS_AO_PDN);

	/* setup TOPS's TOPS_BUS permission */
	set_ao_module_apc(DAPC_TYPE_TOPS_PERI_BUS_AO_PDN);
	set_ao_module_apc(DAPC_TYPE_TOPS_BUS_AO_PDN);

	/* dump TOPS's TOPS_BUS permission */
	dump_ao_module_apc(DAPC_TYPE_TOPS_PERI_BUS_AO_PDN);
	dump_ao_module_apc(DAPC_TYPE_TOPS_BUS_AO_PDN);

	INFO("[DEVAPC] %s done\n", __func__);
}
