#ifndef __FLASHMNG_H__
#define __FLASHMNG_H__

#include <linux/types.h>

struct flmng_func {
	int (*read) (void *info, uint32_t ofs, size_t *len, u_char *buf);
	int (*write) (void *info, uint32_t ofs, size_t *len, u_char *buf);
	int (*erase) (void *info, uint32_t off, size_t size);
};

struct flmng_dev {
	void *info;
	const struct flmng_func *func;
};

int flmng_init(int);
int flmng_init_emmc(int);
int flread(void *, const void *, int);
int flwrite(void *, const void *, int);
int flerase(void *, int);

#endif /* __FLASHMNG_H__ */
