#if !defined(__SLIC_H__)
#define __SLIC_H__

#include <common.h>
#include <spi.h>
#if defined(CONFIG_NECPF_USE_PROSLIC)
#include <necpf/proslic.h>
#endif	/* CONFIG_NECPF_USE_PROSLIC */

#if defined(CONFIG_NECPF_SLIC_MAX_CH)
#define SLIC_MAX_CH CONFIG_NECPF_SLIC_MAX_CH
#else
#define SLIC_MAX_CH 1
#endif	/* CONFIG_NECPF_SLIC_MAX_CH */

#define LF_STOP 0
#define LF_NORMAL 1
#define LF_REVERSE 2
#define LF_RING 3
#define LF_KEEP -1
#define LF_OTHER -2

#define LOOP_OPEN 0
#define LOOP_CLOSE 1
#define LOOP_INVALID -1

#define CODE_INVALID -1

struct slic_config {
#if defined(CONFIG_NECPF_USE_PROSLIC)
	struct proslic_config proslic;
#endif	/* CONFIG_NECPF_USE_PROSLIC */
};

struct slic_ring_config {
	int lf;
	int delay;
	int active;
	int inactive;
	int en_amp;
	int amp;
};

int slic_init(int);
int slic_configure(int, const struct slic_config *);

int slic_reg_read(unsigned int, unsigned int, unsigned int *);
int slic_reg_write(unsigned int, unsigned int, unsigned int);

int slic_ram_read(unsigned int, unsigned int, unsigned int *);
int slic_ram_write(unsigned int, unsigned int, unsigned int);
void slic_set_usermode(int);
void slic_lock_usermode(int);

int slic_clear_irq(int);

int slic_detect_alarm(int);

int slic_linefeed(int, int);
int slic_linefeed_status(int, int *);

int slic_ring_configure(int, const struct slic_ring_config *);
int slic_ring_exec(int);

int slic_detect_loop(int, int *);

int slic_detect_dtmf(int, int *);

int slic_init_dp(int);
int slic_detect_dp(int, int *);

int slic_set_loopback(int);

int md_slic_reset(int, int);
int md_slic_reset_all(int);
int md_slic_spi_gpio_init(void);
int md_slic_spi_init(int);
struct spi_slave * md_slic_spi_setup(int);
int md_slic_irq(int);

#endif	/* __SLIC_H__ */
