/*
 * Copyright (c) 2016-2017 The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _IPQCDP_H
#define _IPQCDP_H

#ifndef DO_DEPS_ONLY
#include <generated/asm-offsets.h>
#endif

/*
 * Support for IPQ807X RUMI
 */
#define CONFIG_IPQ_RUMI

/*
 * Disabled for actual chip.
 * #define CONFIG_RUMI
 */

#define CONFIG_BOARD_EARLY_INIT_F
#define CONFIG_BOARD_LATE_INIT
#define CONFIG_SYS_NO_FLASH
#define CONFIG_SYS_CACHELINE_SIZE   64
#define CONFIG_SYS_VSNPRINTF

#define CONFIG_IPQ807X_UART
#define CONFIG_NR_DRAM_BANKS            1
#define CONFIG_SKIP_LOWLEVEL_INIT

#define CONFIG_SYS_BOOTM_LEN            (64 << 20)
#define HAVE_BLOCK_DEVICE
/*
 * Size of malloc() pool
 */

/*
 * select serial console configuration
 */
#define CONFIG_CONS_INDEX               1
#define CONFIG_SYS_DEVICE_NULLDEV

/* allow to overwrite serial and ethaddr */
#define CONFIG_BAUDRATE                 115200
#define CONFIG_SYS_BAUDRATE_TABLE       {4800, 9600, 19200, 38400, 57600,\
								115200}

#define CONFIG_SYS_CBSIZE               (512 * 2) /* Console I/O Buffer Size */

/*

          svc_sp     --> --------------
          irq_sp     --> |            |
	  fiq_sp     --> |            |
	  bd         --> |            |
          gd         --> |            |
          pgt        --> |            |
          malloc     --> |            |
          text_base  --> |------------|
*/

#define CONFIG_IPQ807x_I2C	1
#ifdef CONFIG_IPQ807x_I2C
#define CONFIG_SYS_I2C_QUP
#define CONFIG_CMD_I2C
#define CONFIG_DM_I2C
#endif

#define CONFIG_SYS_INIT_SP_ADDR 	(CONFIG_SYS_TEXT_BASE -\
			CONFIG_SYS_MALLOC_LEN - CONFIG_ENV_SIZE -\
			GENERATED_BD_INFO_SIZE)

#define CONFIG_SYS_MAXARGS              16
#define CONFIG_SYS_PBSIZE               (CONFIG_SYS_CBSIZE + \
						sizeof(CONFIG_SYS_PROMPT) + 16)

#define TLMM_BASE			0x01000000
#define GPIO_CONFIG_ADDR(x)		(TLMM_BASE + (x)*0x1000)
#define GPIO_IN_OUT_ADDR(x)		(TLMM_BASE + 0x4 + (x)*0x1000)

#define CONFIG_SYS_SDRAM_BASE           0x40000000
#define CONFIG_SYS_TEXT_BASE            0x4A900000
#define CONFIG_SYS_SDRAM_SIZE           0x10000000
#define CONFIG_MAX_RAM_BANK_SIZE        CONFIG_SYS_SDRAM_SIZE
#define CONFIG_SYS_LOAD_ADDR            (CONFIG_SYS_SDRAM_BASE + (64 << 20))

#define QCA_KERNEL_START_ADDR		CONFIG_SYS_SDRAM_BASE
#define QCA_DRAM_KERNEL_SIZE		CONFIG_SYS_SDRAM_SIZE
#define QCA_BOOT_PARAMS_ADDR		(QCA_KERNEL_START_ADDR + 0x100)

#define CONFIG_OF_COMBINE		1

#define CONFIG_QCA_SMEM_BASE		0x4AB00000

#define CONFIG_IPQ_FDT_HIGH		0x4A600000
#define CONFIG_IPQ_NO_MACS		6
#define CONFIG_ENV_IS_IN_SPI_FLASH	1
#define CONFIG_ENV_SECT_SIZE        	(64 * 1024)

#define CONFIG_SMP_PSCI_CMD

#ifdef CONFIG_SMP_PSCI_CMD
#define NR_CPUS				4
#endif
/*
 * IPQ_TFTP_MIN_ADDR: Starting address of Linux HLOS region.
 * CONFIG_TZ_END_ADDR: Ending address of Trust Zone and starting
 * address of WLAN Area.
 * TFTP file can only be written in Linux HLOS region and WLAN AREA.
 */
#define IPQ_TFTP_MIN_ADDR		(CONFIG_SYS_SDRAM_BASE + (16 << 20))
#define CONFIG_TZ_END_ADDR		(CONFIG_SYS_SDRAM_BASE + (88 << 21))
#define CONFIG_SYS_SDRAM_END	((long long)CONFIG_SYS_SDRAM_BASE + gd->ram_size)

#ifndef __ASSEMBLY__
#include <compiler.h>
extern loff_t board_env_offset;
extern loff_t board_env_range;
extern loff_t board_env_size;
#endif

#define CONFIG_IPQ807X_ENV		1
#define CONFIG_ENV_OFFSET		board_env_offset
#define CONFIG_ENV_SIZE			CONFIG_ENV_SIZE_MAX
#define CONFIG_ENV_RANGE		board_env_range
#define CONFIG_ENV_SIZE_MAX		(256 << 10) /* 256 KB */
#define CONFIG_SYS_MALLOC_LEN		(CONFIG_ENV_SIZE_MAX + (1024 << 10))

#define CONFIG_ENV_IS_IN_NAND		1

/* Allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE

/*
* SPI Flash Configs
*/
#define CONFIG_QCA_SPI
#define CONFIG_SPI_FLASH
#define CONFIG_CMD_SF
#define CONFIG_SPI_FLASH_STMICRO
#define CONFIG_SPI_FLASH_WINBOND
#define CONFIG_SPI_FLASH_MACRONIX
#define CONFIG_SPI_FLASH_GIGADEVICE
#define CONFIG_SF_DEFAULT_BUS	0
#define CONFIG_SF_DEFAULT_CS	0
#define CONFIG_SF_DEFAULT_MODE	SPI_MODE_0
#define CONFIG_SF_DEFAULT_SPEED	(48 * 1000 * 1000)
#define CONFIG_SPI_FLASH_BAR	1

#define CONFIG_EFI_PARTITION
#define CONFIG_QCA_BAM			1

/*
 * MMC configs
 */
#define CONFIG_QCA_MMC

#ifdef CONFIG_QCA_MMC
#define CONFIG_MMC
#define CONFIG_CMD_MMC
#define CONFIG_GENERIC_MMC
#define CONFIG_SDHCI
#define CONFIG_SDHCI_QCA
#define CONFIG_EFI_PARTITION
#define CONFIG_ENV_IS_IN_MMC
#define CONFIG_SYS_MMC_ENV_DEV	0
#define CONFIG_SDHCI_SUPPORT
#define CONFIG_MMC_ADMA
#endif

/*
 * NAND Flash Configs
 */

/* CONFIG_QPIC_NAND: QPIC NAND in BAM mode
 * CONFIG_IPQ_NAND: QPIC NAND in FIFO/block mode.
 * BAM is enabled by default.
 */
#define CONFIG_QPIC_NAND
#define CONFIG_CMD_NAND
#define CONFIG_CMD_NAND_YAFFS
#define CONFIG_SYS_NAND_SELF_INIT
#define CONFIG_SYS_NAND_ONFI_DETECTION

/*
 * Expose SPI driver as a pseudo NAND driver to make use
 * of U-Boot's MTD framework.
 */
#define CONFIG_SYS_MAX_NAND_DEVICE	CONFIG_IPQ_MAX_NAND_DEVICE + \
					CONFIG_IPQ_MAX_SPI_DEVICE

#define CONFIG_IPQ_MAX_NAND_DEVICE	1
#define CONFIG_IPQ_MAX_SPI_DEVICE	1

#define CONFIG_QPIC_NAND_NAND_INFO_IDX	0
#define CONFIG_IPQ_SPI_NOR_INFO_IDX	1

#define CONFIG_NAND_FLASH_INFO_IDX	CONFIG_QPIC_NAND_NAND_INFO_IDX
#define CONFIG_SPI_FLASH_INFO_IDX	CONFIG_IPQ_SPI_NOR_INFO_IDX

#define QCA_SPI_NOR_DEVICE		"spi0.0"
#define CONFIG_QUP_SPI_USE_DMA		1

/*
 * U-Boot Env Configs
 */
#define CONFIG_OF_LIBFDT	1
#define CONFIG_SYS_HUSH_PARSER
#define CONFIG_CMD_XIMG

/* MTEST */
#define CONFIG_CMD_MEMTEST
#define CONFIG_SYS_MEMTEST_START	CONFIG_SYS_SDRAM_BASE + 0x1300000
#define CONFIG_SYS_MEMTEST_END		CONFIG_SYS_MEMTEST_START + 0x100

/* NSS firmware loaded using bootm */
#define CONFIG_BOOTCOMMAND  "bootipq"
#define CONFIG_BOOTARGS "console=ttyMSM0,115200n8"
#define QCA_ROOT_FS_PART_NAME "rootfs"

#define CONFIG_BOOTDELAY	2

#define CONFIG_MTD_DEVICE
#define CONFIG_CMD_MTDPARTS
#define CONFIG_MTD_PARTITIONS
#define NUM_ALT_PARTITION	16

#define CONFIG_CMD_UBI
#define CONFIG_RBTREE

#define CONFIG_CMD_BOOTZ

#define CONFIG_OF_BOARD_SETUP

#ifdef CONFIG_OF_BOARD_SETUP
#define DLOAD_DISABLE		0x1
#define RESERVE_ADDRESS_START	0x4AB00000 /*TZAPPS, SMEM and TZ Regions */
#define RESERVE_ADDRESS_SIZE	0x5500000

/*
 * Below Configs need to be updated after enabling reset_crashdump
 * Included now to avoid build failure
 */
#define SET_MAGIC				0x1
#define CLEAR_MAGIC				0x0
#define SCM_CMD_TZ_CONFIG_HW_FOR_RAM_DUMP_ID	0x9
#define SCM_CMD_TZ_FORCE_DLOAD_ID		0x10
#define BOOT_VERSION				0
#define TZ_VERSION				1
#define RPM_VERSION				3
#endif

#define CONFIG_FDT_FIXUP_PARTITIONS

/*
 * USB Support
 */
#define CONFIG_USB_XHCI_IPQ
#ifdef CONFIG_USB_XHCI_IPQ
#define CONFIG_USB_XHCI
#define CONFIG_USB_XHCI_DWC3
#define CONFIG_CMD_USB
#define CONFIG_DOS_PARTITION
#define CONFIG_USB_STORAGE
#define CONFIG_SYS_USB_XHCI_MAX_ROOT_PORTS      2
#define CONFIG_USB_MAX_CONTROLLER_COUNT         2
#endif

#define CONFIG_PCI_IPQ
#define PCI_MAX_DEVICES	2
#ifdef CONFIG_PCI_IPQ
#define CONFIG_PCI
#define CONFIG_CMD_PCI
#define CONFIG_PCI_SCAN_SHOW
#endif

#define CONFIG_IPQ807X_EDMA		1
#define CONFIG_IPQ807X_BRIDGED_MODE	1
#define CONFIG_NET_RETRY_COUNT		5
#define CONFIG_SYS_RX_ETH_BUFFER	16
#define CONFIG_CMD_PING
#define CONFIG_CMD_DHCP
#define CONFIG_MII
#define CONFIG_CMD_MII
#define CONFIG_IPADDR	192.168.10.10
#define CONFIG_NETMASK	255.255.255.0
#define CONFIG_SERVERIP	192.168.10.1
#define CONFIG_CMD_TFTPPUT
#define CONFIG_IPQ_MDIO			1
#define CONFIG_QCA8075_PHY		1
#define CONFIG_QCA8033_PHY		1
#define CONFIG_QCA_AQUANTIA_PHY		1
#define CONFIG_IPQ_ETH_INIT_DEFER

/*
 * CRASH DUMP ENABLE
 */
#define CONFIG_QCA_APPSBL_DLOAD

#ifdef CONFIG_QCA_APPSBL_DLOAD
#define CONFIG_CMD_TFTPPUT
/* We will be uploading very big files */
#undef CONFIG_NET_RETRY_COUNT
#define CONFIG_NET_RETRY_COUNT  500

#define IPQ_TEMP_DUMP_ADDR 0x44000000
#endif

#define CONFIG_QCA_KERNEL_CRASHDUMP_ADDRESS	*((unsigned int *)0x08600658)
#define CONFIG_CPU_CONTEXT_DUMP_SIZE		4096
#define CONFIG_TLV_DUMP_SIZE			2048

/* L1 cache line size is 64 bytes, L2 cache line size is 128 bytes
 * Cache flush and invalidation based on L1 cache, so the cache line
 * size is configured to 64 */
#define CONFIG_SYS_CACHELINE_SIZE  64
/*#define CONFIG_SYS_DCACHE_OFF*/

/* Enabling this flag will report any L2 errors.
 * By default we are disabling it */
/*#define CONFIG_IPQ_REPORT_L2ERR*/

/*
 * FAT FS commands
 */
#define	CONFIG_FS_FAT
#define	CONFIG_CMD_FAT

/*
 * Other commands
 */

/*NECPF CONFIG_NECPF_SOUで自動選択されるのでwarning発生 */
/*NECPF #define CONFIG_CMD_RUN */
#define CONFIG_ARMV7_PSCI

#if defined(CONFIG_NECPF)
/*
 * NECPF
 */
#define CONFIG_NECPF_GPIO_INIT
#define CONFIG_BOARD_EARLY_INIT_R
#undef CONFIG_IPADDR
#define CONFIG_IPADDR 192.168.0.1
/* #define CONFIG_NECPF_LANIF "eth0" */
#define CONFIG_NECPF_SOU_LINK_WAIT 3000
#define CONFIG_NECPF_BOOTPW_PROMPT "Password:"
#define CONFIG_SYS_LONGHELP

#if defined(CONFIG_NECPF_WATCHDOG) || defined(CONFIG_NECPF_TP_RESET_WDT)
#define CONFIG_HW_WATCHDOG
#endif	/* CONFIG_NECPF_WATCHDOG || CONFIG_NECPF_TP_RESET_WDT */

#if defined(CONFIG_CMD_PMIC) && defined(CONFIG_PMIC_PM8916)
#define CONFIG_NECPF_PMIC_DEFAULT "pm8916@0"
#endif	/* CONFIG_CMD_PMIC && CONFIG_PMIC_PM8916 */

#if defined(CONFIG_NECPF_TP_USB)
#define CONFIG_NECPF_XHCI_USB20_TEST
#define CONFIG_NECPF_USB_FS_WA
#define CONFIG_NECPF_USB_SSHUB_WA
#undef CONFIG_USB_STORAGE
#endif	/* CONFIG_NECPF_TP_USB */

#if defined(CONFIG_NECPF_SLABSLIC)
#define CONFIG_NECPF_SPI_BLSP2
#define CONFIG_NECPF_SPI_SLIC_MODE
#define CONFIG_NECPF_SLIC_MAX_CH 1
#undef CONFIG_NECPF_RING_HW_TIMER
#endif	/* CONFIG_NECPF_SLABSLIC */

#if defined(CONFIG_NECPF_PCM)
#define CONFIG_NECPF_PCM_MAX_CH 1
#define CONFIG_NECPF_PCM_XFER_SAMPLES 80 /* 10ms */
#endif	/* CONFIG_NECPF_PCM */

#if defined(CONFIG_NECPF_SLAC)
#define CONFIG_NECPF_SLAC_MAX_CH 1
#endif	/* CONFIG_NECPF_SLAC */

/* BUG#34842 [ROATRY] boot consoleでCR+LFの改行に対応していない */
#define CONFIG_NECPF_SUPPORT_CRLF

/* BUG#34844 [ROTARY] boot consoleでコマンドヒストリ機能がない */
#define CONFIG_CMDLINE_EDITING

/* BUG#35780 [ROTARY] netconsoleにおいてtftpが非常に遅い */
/* #define CONFIG_NECPF_TXBUF 32 */
#define CONFIG_NECPF_TXBUF 128	/* 暫定 */
/* #define CONFIG_NECPF_RXBUF 32 */
/* #undef CONFIG_SYS_RX_ETH_BUFFER */
/* #define CONFIG_SYS_RX_ETH_BUFFER (CONFIG_NECPF_RXBUF) */

/* BUG#36384 [ROTARY] netconsole で errorlog read が正しく表示されない */
#define CONFIG_NECPF_SOU_DELAY 8
#define CONFIG_NECPF_SOU_DELAY_PACKETS 10

/* FLASHMNG */
#define CONFIG_NECPF_FLASH_BLOCK_SIZE	(64 * 1024)
#define CONFIG_NECPF_EMMC_BLOCK_SIZE	512
#define CONFIG_NECPF_FLASHMNG_FLCACHE	/* flash read cache 機能 */

/* APPSBLENV 2面化 */
#define CONFIG_NECPF_DUAL_APPSBLENV
#ifdef CONFIG_NECPF_DUAL_APPSBLENV
#ifndef __ASSEMBLY__
#include <compiler.h>
extern loff_t board_env_back_offset;
extern loff_t board_env_back_size;
#endif

#define CONFIG_ENV_SIZE_REDUND		CONFIG_ENV_SIZE
#define CONFIG_ENV_OFFSET_REDUND	board_env_back_offset
#endif	/* CONFIG_NECPF_DUAL_APPSBLENV */

/* facotry data */
#define CONFIG_NECPF_FACTORY_DATA

/* Kernel Crashlog */
#define CONFIG_NECPF_CMD_K_ERRORLOG

/* BUG#48715 eMMC erase timeout */
#define CONFIG_NECPF_ERASE_TIMEOUT	60000

/* kernel read error handling */
#define CONFIG_NECPF_ERR_HANDLING

/* pkg_info */
#define CONFIG_NECPF_CMD_PKGINFO

/* Magic Number of Version data */
#define CONFIG_VER_MAGIC 0x31403910

/* BUG#49033 [ACE] HW_ES2 Malibu LED 設定変更 */
#define CONFIG_NECPF_MALIBU_LED

/* arp時間短縮 (loopback試験対応) */
#define CONFIG_ARP_TIMEOUT 1000
#define CONFIG_NECPF_ARP_TIMEOUT_COUNT 5

/* BUG#49094 eMMC BKOPS enable */
#define CONFIG_NECPF_BKOPS_EN
#define EXT_CSD_BKOPS_SUPPORT		502
#define EXT_CSD_BKOPS_EN		163
#define BKOPS_SUPPORTED 		(1 << 0)
#define BKOPS_ENABLE			(1 << 0)

/* BUG#49195 [ACE] bootのMACアドレス設定が不正 */
#define CONFIG_NECPF_ETHADDR_ENV "eth1addr"

/* BUG#49226 [ACE] system起動しない可能性がある (bootのbuild warning) */
#if defined(CONFIG_QCA_APPSBL_DLOAD)
#define CONFIG_NECPF_APPSBL_DLOAD_WA
#endif	/* CONFIG_QCA_APPSBL_DLOAD */

/* rf-regdmn */
#define CONFIG_NECPF_CMD_RF_REGDMN

/* MDC/MDIO端子のdrive strength変更 */
#define CONFIG_NECPF_MDIO_DRVSTR

/* BUG#50186 [ACE] Ether PHY 用クロック偏差 +0ppm 設定 */
#define CONFIG_NECPF_PHY_CLOCK_DEVIATION

/* SDHCI command timeout値を変更する */
#define CONFIG_NECPF_SDHCI_CMD_TIMEOUT

#endif	/* CONFIG_NECPF */

#endif /* _IPQCDP_H */

