#ifndef __BUTTON_H__
#define __BUTTON_H__

/*
  長押し検出しない場合 (long_ms==0) msはshort_msの略

       |<-ms->|
       +--------------+
       |              |
  -----+              +------------------------
              ↓
            EV_PRESS

  長押し検出する場合 (long_ms<>0) msはshort_msの略

       |<---------------long_ms--------------->|
       |<-ms->|       |<-ms->|
       +--------------+
       |              |
  -----+              +------------------------
              ↓             ↓
            EV_PRESS       EV_SHORT_PRESS

       |<---------------long_ms--------------->|
       |<-ms->|
       +-----------------------------------------------+
       |                                               |
  -----+                                               +--------------
              ↓                               ↓
            EV_PRESS                        EV_LONG_PRESS
*/
struct button_event {
	int index;
#define BUTTON_EV_NONE 0
#define BUTTON_EV_PRESS 1
#define BUTTON_EV_SHORT_PRESS 2
#define BUTTON_EV_LONG_PRESS 3
	int event;
};

struct button_info {
	int (*detect)(void);
	int short_ms;
	int long_ms;
};

#define BUTTON_MODE_OFF 0
#define BUTTON_MODE_BOOT 1
#define BUTTON_MODE_CONSOLE 2
#define BUTTON_MODE_TEST 3

void button_init(void);
int button_detect(struct button_event *);
void button_mode_init(int);
int button_proc(void);

const struct button_info * md_button_info(void);
void md_button_mode_init(int);
int md_button_proc(int, const struct button_event *);
#endif	/* __BUTTON_H__ */
