#if !defined(__PCM_H__)
#define __PCM_H__

#include <common.h>

#if defined(CONFIG_NECPF_PCM_MAX_CH)
#define PCM_MAX_CH CONFIG_NECPF_PCM_MAX_CH
#else
#define PCM_MAX_CH 1
#endif	/* CONFIG_NECPF_PCM_MAX_CH */

#if defined(CONFIG_NECPF_PCM_XFER_SAMPLES)
#define PCM_XFER_SAMPLES CONFIG_NECPF_PCM_XFER_SAMPLES
#else
#define PCM_XFER_SAMPLES 80
#endif	/* CONFIG_NECPF_PCM_XFER_SAMPLES */

int pcm_init(int);

/* blocking */
int pcm_trx(int, void*, void*, int);

/* non-blocking */
int pcm_tx_start(int, void *, int);
int pcm_rx_start(int, void *, int);
int pcm_tx_run(int);
int pcm_rx_run(int);
int pcm_tx_stop(int);
int pcm_rx_stop(int);

int md_pcm_gpio_init(void);
int md_pcm_init(void);
int md_pcm_dma_init(void);
int md_pcm_start(void);
int md_pcm_tx_open(int);
int md_pcm_rx_open(int);
int md_pcm_tx(int, void *, int);
int md_pcm_rx(int, void *, int);
int md_pcm_tx_close(int);
int md_pcm_rx_close(int);

#endif	/* !__PCM_H__ */
