#ifndef __TP_H__
#define __TP_H__

#include <common.h>
#include <command.h>
#include <usb.h>

#define TP_PASS 0
#define TP_FAIL 1
#define TP_ABORT -1

#define TP_MODE_DIAG 0
#define TP_MODE_POST 1
#define TP_MODE_AGEING 2

void tp_set_mode(int);
int tp_get_mode(void);

#define LED_ALL_OFF 0
#define LED_ALL_ON 1
#define LED_ALL_GREEN 2
#define LED_ALL_RED 3
#define LED_ALL_ORANGE 4
#define LED_TP_START 5
#define LED_TP_PASS 6
#define LED_TP_FAIL 7
#define LED_POST_START 8
#define LED_POST_PASS 9
#define LED_POST_FAIL 10
#define LED_AGE_RUN_RAM 11
#define LED_AGE_RUN_WAN 12
#define LED_AGE_RUN_LAN10G 13
#define LED_AGE_RUN_LAN1G 14
#define LED_AGE_RUN_SLIC 15
#define LED_AGE_ERR_RAM 16
#define LED_AGE_ERR_WAN 17
#define LED_AGE_ERR_LAN10G 18
#define LED_AGE_ERR_LAN1G 19
#define LED_AGE_ERR_SLIC 20

void tp_led_start(void);
void tp_led_end(int);
void md_tp_led(int);

int tp_keyabort(int, int);
int md_msec_expired(uint32_t *, uint32_t);

#if defined(CONFIG_NECPF_TP_AGEING) || defined(CONFIG_NECPF_TP_POST)
struct tp_list {
	const char *cmd;
	const int do_age;
	const int do_post;
	const char *disp_run;
	const char *disp_err;
	const int led_run;
	const int led_err;
	const int use_stdout;
	const int show_pass;
	int err_cnt;
};

struct tp_list * md_tp_list(void);
void tp_clear_count(void);
void tp_incr_count(void);
int tp_get_count(void);
#if defined(CONFIG_NECPF_TP_AGEING)
int do_tp_ageing(cmd_tbl_t *, int, int, char * const []);
int do_tp_err(cmd_tbl_t *, int, int, char * const []);
#endif	/* CONFIG_NECPF_TP_AGEING */
#if defined(CONFIG_NECPF_TP_POST)
int do_tp_post(cmd_tbl_t *, int, int, char * const []);
#endif	/* CONFIG_NECPF_TP_POST */
#endif	/* CONFIG_NECPF_TP_AGEING || CONFIG_NECPF_TP_POST */

#if defined(CONFIG_NECPF_TP_FXO)
int do_tp_fxo(cmd_tbl_t *, int, int, char * const []);
#endif	/* CONFIG_NECPF_TP_FXO */

#if defined(CONFIG_NECPF_TP_RAM)
struct ram_region {
	int index;
	uintptr_t start;
	uintptr_t end;
	ulong size;
};

struct ram_bank_info {
	int banks;
	ulong bank_size;
};

struct ram_phy_brc {
	int bank;
	int row;
	int column;
};

struct ram_phy_addr {
	struct ram_phy_brc start;
	struct ram_phy_brc end;
};

int do_tp_ram(cmd_tbl_t *, int, int, char * const []);
int md_init_ram_test(void);
const struct ram_region * md_ram_get_region(void);
int md_ram_region_next(void);
int md_ram_region_num(void);
int md_ram_cache_off(void);
int md_ram_cache_on(void);
void md_ram_bank_info(struct ram_bank_info *);
void md_ram_phy_info(struct ram_phy_addr *);
uintptr_t md_ram_phy_addr(int, int, int);
int md_ram_phy_next_part(void);
#endif	/* CONFIG_NECPF_TP_RAM */

#if defined(CONFIG_NECPF_TP_RESET)
int do_tp_reset(cmd_tbl_t *, int, int, char * const []);

#if defined(CONFIG_NECPF_TP_RESET_GPIO)
struct reset_gpio {
	const char *name;
	const char *help;
	int gpio;
	int value;
	int hold_us;
};
const struct reset_gpio * md_reset_gpio_tbl(void);
void md_init_reset_gpio(void);
#endif	/* CONFIG_NECPF_TP_RESET_GPIO */
#endif	/* CONFIG_NECPF_TP_RESET */

#if defined(CONFIG_NECPF_TP_SETSW)
int do_tp_setsw(cmd_tbl_t *, int, int, char * const []);
void md_tp_setsw_init(int, char * const []);
void md_tp_setsw_exit(int);
#endif	/* CONFIG_NECPF_TP_SETSW */

#if defined(CONFIG_NECPF_TP_SLIC)
int do_tp_slic(cmd_tbl_t *, int, int, char * const []);
#endif	/* CONFIG_NECPF_TP_SLIC */

#if defined(CONFIG_NECPF_TP_USB)
struct usb_device *usb_find_device(int);
int do_tp_usb(cmd_tbl_t *, int, int, char * const []);
int md_usb_max_port(void);
int md_usb_hub_port(int, int *, int *);

#if defined(CONFIG_NECPF_TP_USB_POWER)
void md_usb_power(int, int);
#endif	/* CONFIG_NECPF_TP_USB_POWER */

#if defined(CONFIG_NECPF_TP_USB_OC)
int md_usb_overcurrent(int);
#endif	/* CONFIG_NECPF_TP_USB_OC */
#endif	/* CONFIG_NECPF_TP_USB */

#if defined(CONFIG_NECPF_CMD_PKGINFO)
int md_get_pkg_type(void);
const char *md_get_pkg_name(int);
uint32_t md_read_cpuid(void);
#endif	/* CONFIG_NECPF_CMD_PKGINFO */

#if defined(CONFIG_NECPF_TP_VOICE)
struct pcm_lpbk {
	int msec;
	int bytes_per_sample;
	int samples_per_cycle;
	int tx_samples;
	void *tx_data;
};
int do_tp_voice(cmd_tbl_t *, int, int, char * const []);
int is_tp_voice_auto(void);
int md_init_pcm_lpbk(struct pcm_lpbk *);
int md_exit_pcm_lpbk(const struct pcm_lpbk *);
int md_verify_pcm_lpbk(const struct pcm_lpbk *, const void *);
#endif	/* CONFIG_NECPF_TP_VOICE */

#if defined(CONFIG_NECPF_TP_ETHER)
struct phy_ops {
	int (*reset)(int, int);
	int (*read_id)(int, uint32_t *);
	int (*power)(int, int);
	int (*loopback)(int, int);
};
struct ether_phy {
	const char *name;
	uint32_t id;
	uint32_t id_mask;
	struct phy_ops ops;
};
struct ether_port {
	const char *name;
	const char *eth;
	const struct ether_phy *phy;
	int phy_addr;
	int phy_id_all;
};
int do_tp_ether(cmd_tbl_t *, int, int, char * const []);
const struct ether_port * md_ether_port(void);
int md_ether_link_save(void);
int md_ether_link_wait(void);
#endif	/* CONFIG_NECPF_TP_ETHER */

#if defined(CONFIG_NECPF_TP_ZWAVE)
int do_tp_zwave(cmd_tbl_t *, int, int, char * const []);
#endif	/* CONFIG_NECPF_TP_ZWAVE */

#endif	/* __TP_H__ */
