# xl2tpd

xl2tpd is an implementation of the Layer 2 Tunnelling Protocol (RFC 2661).
L2TP allows you to tunnel PPP over UDP. Some ISPs use L2TP to tunnel user
sessions from dial-in servers (modem banks, ADSL DSLAMs) to back-end PPP
servers. Another important application is Virtual Private Networks where
the IPsec protocol is used to secure the L2TP connection (L2TP/IPsec,
RFC 3193). The L2TP/IPsec protocol is mainly used by Windows and
Mac OS X clients. On Linux, xl2tpd can be used in combination with IPsec
implementations such as Openswan.
Example configuration files for such a setup are included in this RPM.

xl2tpd works by opening a pseudo-tty for communicating with pppd.
It runs completely in userspace but supports kernel mode L2TP.

xl2tpd supports IPsec SA Reference tracking to enable overlapping internak
NAT'ed IP's by different clients (eg all clients connecting from their
linksys internal IP 192.168.1.101) as well as multiple clients behind
the same NAT router.

xl2tpd supports the pppol2tp kernel mode operations on 2.6.23 or higher,
or via a patch in contrib for 2.4.x kernels. Note that kernel mode and
IPsec SA Reference tracking do not yet work together.

Xl2tpd is based on the 0.69 L2TP by Jeff McAdams <jeffm@iglou.com>
It was de-facto maintained by Jacco de Leeuw <jacco2@dds.nl> in 2002 and 2003.

NOTE: In Linux kernel 4.15+ there is a kernel bug with ancillary IP_PKTINFO.
      As such, for Linux kernel 4.15+ we recommend the community use xl2tpd
      1.3.12+

## Build and install
    make
    sudo make install


## Mailing Lists

https://lists.openswan.org/cgi-bin/mailman/listinfo/xl2tpd is home of the mailing list.

Note: This is a closed list - you **must** be subscribed to post.

## Security Vulnerability

Security vulnerabilities can be e-mailed to: security@xelerance.com
