// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2019 MediaTek Inc.
 * Author: Weiyi Lu <weiyi.lu@mediatek.com>
 */

#include <linux/module.h>
#include "clkchk.h"

static const char * const off_pll_names[] = {
	"vcodecpll",
	"vencpll",
	"apll1",
	"apll2",
	"lvdspll",
	"lvdspll2",
	"msdcpll",
	"msdcpll2",
	"tvdpll",
	"mmpll",
	"armca72pll",
	"etherpll",
	NULL
};

static const char * const all_clk_names[] = {
	/* plls */
	"vcodecpll",
	"vencpll",
	"apll1",
	"apll2",
	"lvdspll",
	"lvdspll2",
	"msdcpll",
	"msdcpll2",
	"tvdpll",
	"mmpll",
	"armca72pll",
	"etherpll",
	"cvbspll",
	/* topckgen */
	"armca35pll_600m",
	"armca35pll_400m",
	"armca72pll_ck",
	"syspll1_d4",
	"syspll1_d8",
	"syspll1_d16",
	"syspll_d3",
	"syspll2_d2",
	"syspll2_d4",
	"syspll_d5",
	"syspll3_d2",
	"syspll3_d4",
	"syspll_d7",
	"syspll4_d2",
	"syspll4_d4",
	"univpll_d7",
	"univpll_d26",
	"univpll_d52",
	"univpll_d104",
	"univpll_d208",
	"univpll1_d2",
	"univpll1_d4",
	"univpll1_d8",
	"univpll_d3",
	"univpll2_d2",
	"univpll2_d4",
	"univpll2_d8",
	"univpll_d5",
	"univpll3_d2",
	"univpll3_d4",
	"univpll3_d8",
	"f_mp0_pll1_ck",
	"f_mp0_pll2_ck",
	"f_big_pll1_ck",
	"f_big_pll2_ck",
	"f_bus_pll1_ck",
	"f_bus_pll2_ck",
	"apll1_ck",
	"apll1_d2",
	"apll1_d3",
	"apll1_d4",
	"apll1_d8",
	"apll1_d16",
	"apll2_ck",
	"apll2_d2",
	"apll2_d4",
	"apll2_d8",
	"apll2_d16",
	"lvdspll_ck",
	"lvdspll_d2",
	"lvdspll_d4",
	"lvdspll_d8",
	"lvdspll2_ck",
	"lvdspll2_d2",
	"lvdspll2_d4",
	"lvdspll2_d8",
	"etherpll_125m",
	"etherpll_50m",
	"cvbs",
	"cvbs_d2",
	"sys_26m",
	"mmpll_ck",
	"mmpll_d2",
	"vencpll_ck",
	"vencpll_d2",
	"vcodecpll_ck",
	"vcodecpll_d2",
	"tvdpll_ck",
	"tvdpll_d2",
	"tvdpll_d4",
	"tvdpll_d8",
	"tvdpll_429m",
	"tvdpll_429m_d2",
	"tvdpll_429m_d4",
	"msdcpll_ck",
	"msdcpll_d2",
	"msdcpll_d4",
	"msdcpll2_ck",
	"msdcpll2_d2",
	"msdcpll2_d4",
	"clk26m_d2",
	"d2a_ulclk_6p5m",
	"vpll3_dpix",
	"vpll_dpix",
	"ltepll_fs26m",
	"dmpll_ck",
	"dsi0_lntc",
	"dsi1_lntc",
	"lvdstx3",
	"lvdstx",
	"clkrtc_ext",
	"clkrtc_int",
	"csi0",
	"apll_div0",
	"apll_div1",
	"apll_div2",
	"apll_div3",
	"apll_div4",
	"apll_div5",
	"apll_div6",
	"apll_div7",
	"apll_div_pdn0",
	"apll_div_pdn1",
	"apll_div_pdn2",
	"apll_div_pdn3",
	"apll_div_pdn4",
	"apll_div_pdn5",
	"apll_div_pdn6",
	"apll_div_pdn7",
	"nfi2x_en",
	"nfiecc_en",
	"nfi1x_ck_en",
	"mm_sel",
	"pwm_sel",
	"vdec_sel",
	"venc_sel",
	"mfg_sel",
	"camtg_sel",
	"spi_sel",
	"usb20_sel",
	"usb30_sel",
	"msdc50_0_h_sel",
	"msdc50_0_sel",
	"msdc30_1_sel",
	"msdc30_2_sel",
	"msdc30_3_sel",
	"audio_sel",
	"aud_intbus_sel",
	"pmicspi_sel",
	"dpilvds1_sel",
	"atb_sel",
	"nr_sel",
	"nfi2x_sel",
	"irda_sel",
	"aud_1_sel",
	"aud_2_sel",
	"mem_mfg_sel",
	"axi_mfg_sel",
	"scam_sel",
	"nfiecc_sel",
	"pe2_mac_p0_sel",
	"pe2_mac_p1_sel",
	"dpilvds_sel",
	"msdc50_3_h_sel",
	"hdcp_sel",
	"hdcp_24m_sel",
	"spinor_sel",
	"apll_sel",
	"apll2_sel",
	"a1sys_hp_sel",
	"a2sys_hp_sel",
	"asm_l_sel",
	"asm_m_sel",
	"asm_h_sel",
	"i2so1_sel",
	"i2so2_sel",
	"i2so3_sel",
	"tdmo0_sel",
	"tdmo1_sel",
	"i2si1_sel",
	"i2si2_sel",
	"i2si3_sel",
	"ether_125m_sel",
	"ether_50m_sel",
	"jpgdec_sel",
	"spislv_sel",
	"ether_sel",
	"cam2tg_sel",
	"di_sel",
	"tvd_sel",
	"i2c_sel",
	"pwm_infra_sel",
	"msdc0p_aes_sel",
	"cmsys_sel",
	"gcpu_sel",
	"aud_apll1_sel",
	"aud_apll2_sel",
	"apll1_ref_sel",
	"apll2_ref_sel",
	"audull_vtx_sel",
	/* bdpsys */
	"bdp_bridge_b",
	"bdp_bridge_d",
	"bdp_larb_d",
	"bdp_vdi_pxl",
	"bdp_vdi_d",
	"bdp_vdi_b",
	"bdp_fmt_b",
	"bdp_27m",
	"bdp_27m_vdout",
	"bdp_27_74_74",
	"bdp_2fs",
	"bdp_2fs74_148",
	"bdp_b",
	"bdp_vdo_d",
	"bdp_vdo_2fs",
	"bdp_vdo_b",
	"bdp_di_pxl",
	"bdp_di_d",
	"bdp_di_b",
	"bdp_nr_agent",
	"bdp_nr_d",
	"bdp_nr_b",
	"bdp_bridge_rt_b",
	"bdp_bridge_rt_d",
	"bdp_larb_rt_d",
	"bdp_tvd_tdc",
	"bdp_tvd_clk_54",
	"bdp_tvd_cbus",
	/* infracfg */
	"infra_dbgclk",
	"infra_gce",
	"infra_m4u",
	"infra_kp",
	"infra_ao_spi0",
	"infra_ao_spi1",
	"infra_ao_uart5",
	/* imgsys */
	"img_smi_larb2",
	"img_scam_en",
	"img_cam_en",
	"img_cam_sv_en",
	"img_cam_sv1_en",
	"img_cam_sv2_en",
	/* jpgdecsys */
	"jpgdec_jpgdec1",
	"jpgdec_jpgdec",
	/* mfgcfg */
	"mfg_bg3d",
	/* mmsys */
	"mm_smi_common",
	"mm_smi_larb0",
	"mm_cam_mdp",
	"mm_mdp_rdma0",
	"mm_mdp_rdma1",
	"mm_mdp_rsz0",
	"mm_mdp_rsz1",
	"mm_mdp_rsz2",
	"mm_mdp_tdshp0",
	"mm_mdp_tdshp1",
	"mm_mdp_crop",
	"mm_mdp_wdma",
	"mm_mdp_wrot0",
	"mm_mdp_wrot1",
	"mm_fake_eng",
	"mm_mutex_32k",
	"mm_disp_ovl0",
	"mm_disp_ovl1",
	"mm_disp_rdma0",
	"mm_disp_rdma1",
	"mm_disp_rdma2",
	"mm_disp_wdma0",
	"mm_disp_wdma1",
	"mm_disp_color0",
	"mm_disp_color1",
	"mm_disp_aal",
	"mm_disp_gamma",
	"mm_disp_ufoe",
	"mm_disp_split0",
	"mm_disp_od",
	"mm_pwm0_mm",
	"mm_pwm0_26m",
	"mm_pwm1_mm",
	"mm_pwm1_26m",
	"mm_dsi0_engine",
	"mm_dsi0_digital",
	"mm_dsi1_engine",
	"mm_dsi1_digital",
	"mm_dpi_pixel",
	"mm_dpi_engine",
	"mm_dpi1_pixel",
	"mm_dpi1_engine",
	"mm_lvds_pixel",
	"mm_lvds_cts",
	"mm_smi_larb4",
	"mm_smi_common1",
	"mm_smi_larb5",
	"mm_mdp_rdma2",
	"mm_mdp_tdshp2",
	"mm_disp_ovl2",
	"mm_disp_wdma2",
	"mm_disp_color2",
	"mm_disp_aal1",
	"mm_disp_od1",
	"mm_lvds1_pixel",
	"mm_lvds1_cts",
	"mm_smi_larb7",
	"mm_mdp_rdma3",
	"mm_mdp_wrot2",
	"mm_dsi2",
	"mm_dsi2_digital",
	"mm_dsi3",
	"mm_dsi3_digital",
	/* pericfg */
	"per_nfi",
	"per_therm",
	"per_pwm0",
	"per_pwm1",
	"per_pwm2",
	"per_pwm3",
	"per_pwm4",
	"per_pwm5",
	"per_pwm6",
	"per_pwm7",
	"per_pwm",
	"per_ap_dma",
	"per_msdc30_0",
	"per_msdc30_1",
	"per_msdc30_2",
	"per_msdc30_3",
	"per_uart1",
	"per_uart2",
	"per_uart3",
	"per_i2c0",
	"per_i2c1",
	"per_i2c2",
	"per_i2c3",
	"per_i2c4",
	"per_auxadc",
	"per_spi0",
	"per_spi",
	"per_i2c5",
	"per_spi2",
	"per_spi3",
	"per_spi5",
	"per_uart4",
	"per_sflash",
	"per_gmac",
	"per_pcie0",
	"per_pcie1",
	"per_gmac_pclk",
	"per_msdc50_0_en",
	"per_msdc30_1_en",
	"per_msdc30_2_en",
	"per_msdc30_3_en",
	"per_msdc50_0_h",
	"per_msdc50_3_h",
	"per_msdc30_0_q",
	"per_msdc30_3_q",
	/* vdecsys */
	"vdec_cken",
	"vdec_larb1_cken",
	"vdec_imgrz_cken",
	/* vencsys */
	"venc_smi",
	"venc_venc",
	"venc_smi_larb6",
	/* end */
	NULL
};

static const char * const compatible[] = {"mediatek,mt2712", NULL};

static struct clkchk_cfg_t cfg = {
	.aee_excp_on_fail = false,
	.warn_on_fail = true,
	.compatible = compatible,
	.off_pll_names = off_pll_names,
	.all_clk_names = all_clk_names,
};

static int __init clkchk_platform_init(void)
{
	return clkchk_init(&cfg);
}
subsys_initcall(clkchk_platform_init);
