#ifndef NEC_IMAGE_1
#define NEC_IMAGE_H

#include "common/anime_picto.h"

#include "landscape/aterm_logo_ls.h"
#include "landscape/batt_ls.h"
#include "landscape/num_ls.h"
#include "landscape/sleep_ls.h"
#include "landscape/bt_wave_ls.h"
#include "landscape/prog_bar_ls.h"

#include "landscape/legal_ls.h"

#define NEC_IMG_WIDTH  (240)  /* X */
#define NEC_IMG_HEIGHT (320)  /* Y */
#define NEC_IMG_SIZE   (NEC_IMG_WIDTH * NEC_IMG_HEIGHT) /* X * Y */

struct image_info_t {
	unsigned width;
	unsigned height;
	unsigned char *data;
};

struct coordinate_info_t {
	unsigned x_start;
	unsigned y_start;
	unsigned x_end;
	unsigned y_end;
};

struct display_info_t {
	struct coordinate_info_t *coord;
	struct image_info_t *image;
};

typedef enum _battery_level {
	/* Charging picto */
	BATT_CHG_LV1 = 0,        /* Battery Level(1)    */
	BATT_CHG_LV2,            /* Battery Level(2)    */
	BATT_CHG_LV3,            /* Battery Level(3)    */
	BATT_CHG_LV4,            /* Battery Level(4)    */
	BATT_CHG_LV5,            /* Battery Level(5)    */
	/* Discharging picto */
	BATT_LV0,            /* Battery Level(0)    */
	BATT_LV1,            /* Battery Level(1)    */
	BATT_LV2,            /* Battery Level(2)    */
	BATT_LV3,            /* Battery Level(3)    */
	BATT_LV4,            /* Battery Level(4)    */
	BATT_LV5,            /* Battery Level(5)    */
} BATTERY_LEVEL;

typedef enum _number {
	NUM0 = 0,
	NUM1,
	NUM2,
	NUM3,
	NUM4,
	NUM5,
	NUM6,
	NUM7,
	NUM8,
	NUM9,
	MINUS,
	PERCENT,
} NUMBER;

enum {
	ATERM_LOGO = 0,
	SIM_SWITCH,
	BATTERY_PICTO,
	ANIME_PICTO,
	REMAIN_NUM0_PICTO,
	REMAIN_NUM1_PICTO,
	REMAIN_NUM2_PICTO,
	REMAIN_PER_PICTO,
	SLEEP_PICTO,
	BT_WAVE_PICTO,
	PWOFF_BATTERY_PICTO,
	PWOFF_REMAIN_NUM0_PICTO,
	PWOFF_REMAIN_NUM1_PICTO,
	PWOFF_REMAIN_NUM2_PICTO,
	PWOFF_REMAIN_PER_PICTO,
	PROGRESS_BAR_PICTO,
	LEGAL_PAGE,
	PICTO_MAX,
};

struct coordinate_info_t coord_info_landscape[] = {
	{  75, 115, 106, 210 }, /* Aterm logo */
	{  46,   0, 214, 319 }, /* sim switch */
	{  80,  64, 113, 121 }, /* battery picto */
	{ 171, 152, 190, 171 }, /* animation picto */
	{ 138, 122, 171, 141 }, /* remain num0 picto */
	{ 138, 102, 171, 121 }, /* remain num1 picto */
	{ 138,  82, 171, 101 }, /* remain num2 picto */
	{ 138,  62, 171,  81 }, /* percent picto */
	{  83, 192, 172, 235 }, /* sleep picto */
	{  79, 250,  99, 270 }, /* BT wave picto */
	{  89, 131, 122, 188 }, /* quick shutdown battery picto */
	{ 138, 189, 171, 208 }, /* quick shutdown remain num0 picto */
	{ 138, 169, 171, 188 }, /* quick shutdown remain num1 picto */
	{ 138, 149, 171, 168 }, /* quick shutdown remain num2 picto */
	{ 138, 129, 171, 148 }, /* quick shutdown percent picto */
	{ 168,   0, 181, 319 }, /* progress bar */
	{   0,   0, 239, 319 }, /* legal page */
};

#endif /* BITES_IMAGE_H */
