/*
 * Copyright (c) 2013 - 2015, The Linux Foundation. All rights reserved.
 * Copyright (c) 2017 - 2021, NEC Platforms, Ltd., All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef NEC_FB_H
#define NEC_FB_H

/*****************************************************************************
 * Includes
 *****************************************************************************/
#include <linux/fb.h>

#include "nec_panel.h"


/*****************************************************************************
 * Types
 *****************************************************************************/

#define NEC_FB_NAME			"nec-fb"

#define NEC_FB_NUM_FRAMES		(2)
#define NEC_FB_NUM_PALETTE_COLOR	(16)
#define NEC_FB_NUM_PALETTES		(256)

#define NEC_FB_RGB_565			(0)
#define NEC_FB_DEFAULT_PIXEL_FORMAT	(NEC_FB_RGB_565)

#define NEC_FB_WAIT_IDLE_TIMEOUT_MS	(30 * MSEC_PER_SEC)

/* RGB565 Color */
enum {
	NEC_FB_COLOR_ID_BLACK = 0,
	NEC_FB_COLOR_ID_WHITE,
	NEC_FB_COLOR_ID_RED,
	NEC_FB_COLOR_ID_GREEN,
	NEC_FB_COLOR_ID_BLUE,
	NEC_FB_COLOR_ID_YELLOW,
	NEC_FB_COLOR_ID_CYAN,
	NEC_FB_COLOR_ID_MAGENTA,
	NEC_FB_COLOR_ID_GRAY,

	/* each bit is on */
	NEC_FB_COLOR_ID_R4,
	NEC_FB_COLOR_ID_R3,
	NEC_FB_COLOR_ID_R2,
	NEC_FB_COLOR_ID_R1,
	NEC_FB_COLOR_ID_R0,
	NEC_FB_COLOR_ID_G5,
	NEC_FB_COLOR_ID_G4,
	NEC_FB_COLOR_ID_G3,
	NEC_FB_COLOR_ID_G2,
	NEC_FB_COLOR_ID_G1,
	NEC_FB_COLOR_ID_G0,
	NEC_FB_COLOR_ID_B4,
	NEC_FB_COLOR_ID_B3,
	NEC_FB_COLOR_ID_B2,
	NEC_FB_COLOR_ID_B1,
	NEC_FB_COLOR_ID_B0,

	NEC_FB_NUM_COLOR_ID,
};

#define NEC_FB_COLOR_BLACK	(0x0000)
#define NEC_FB_COLOR_WHITE	(0xFFFF)
#define NEC_FB_COLOR_RED	(0xF800)
#define NEC_FB_COLOR_GREEN	(0x07E0)
#define NEC_FB_COLOR_BLUE	(0x001F)
#define NEC_FB_COLOR_YELLOW	(0xFFE0)
#define NEC_FB_COLOR_CYAN	(0x07FF)
#define NEC_FB_COLOR_MAGENTA	(0xF81F)
#define NEC_FB_COLOR_GRAY	(0x7BEF)
#define NEC_FB_COLOR_R4		(0x8000)
#define NEC_FB_COLOR_R3		(0x4000)
#define NEC_FB_COLOR_R2		(0x2000)
#define NEC_FB_COLOR_R1		(0x1000)
#define NEC_FB_COLOR_R0		(0x0800)
#define NEC_FB_COLOR_G5		(0x0400)
#define NEC_FB_COLOR_G4		(0x0200)
#define NEC_FB_COLOR_G3		(0x0100)
#define NEC_FB_COLOR_G2		(0x0080)
#define NEC_FB_COLOR_G1		(0x0040)
#define NEC_FB_COLOR_G0		(0x0020)
#define NEC_FB_COLOR_B4		(0x0010)
#define NEC_FB_COLOR_B3		(0x0008)
#define NEC_FB_COLOR_B2		(0x0004)
#define NEC_FB_COLOR_B1		(0x0002)
#define NEC_FB_COLOR_B0		(0x0001)

/*****************************************************************************
 * Structures
 *****************************************************************************/
struct nec_fb_data;

struct nec_fb_panel_operation {
	int  (*alloc_fb_mem)(struct nec_fb_data *nfd);

	int  (*panel_on)(int user);
	void (*panel_off)(int user);
	void (*panel_force_off)(void);
	bool (*panel_is_on)(void);

	void (*panel_disp_on)(void);
	void (*panel_disp_off)(void);

	void (*panel_reset)(bool hw_reset, bool sw_reset);

	int  (*start_dma)(struct nec_fb_data *nfd,
				struct fb_var_screeninfo *var);

	int  (*set_brightness)(int brightness);
	int  (*get_brightness)(void);
	int  (*set_backlight)(int on);
	int  (*get_backlight)(void);
	int  (*set_refresh_rate)(int refresh_rate);
	int  (*get_refresh_rate)(void);
	int  (*write_panel_cmd)(u8 cmd, u8 *data, u32 data_cnt);
	int  (*read_panel_cmd)(u8 cmd, u32 data_cnt);

	void (*print_perf)(void);
	void (*update_panel_status)(void);
};

struct nec_fb_panel_state {
	bool panel_is_on;
};

struct nec_fb_dma_data {
	u32 flag;
	struct fb_var_screeninfo var;
};

struct nec_fb_data {
	int id;
	struct platform_device *pdev;

	u32 ref_cnt;
	u32 num_page;
	u32 pixel_format;

	struct fb_info *fbi;
#ifdef NEC_PANEL_USE_ALLOCATED_DRM_FB
	struct fb_info *drm_fbi;
#endif // NEC_PANEL_USE_ALLOCATED_DRM_FB

	struct nec_panel_info         *panel_info;
	struct nec_panel_resource     *panel_res;
	struct nec_fb_panel_operation *panel_ops;

	u8 lcd_cmd;
	u8 lcd_data[NEC_PANEL_MAX_LCD_CMD_DATA];

	struct nec_fb_panel_state suspend;
	bool shutdown_pending;
};


/*****************************************************************************
 * Public function declairs
 *****************************************************************************/
int nec_fb_set_panel_operation(struct nec_fb_panel_operation *panel_ops);
struct drm_fb_helper *get_drm_fb_helper(void);
void nec_fb_set_original_fb_info(struct drm_fb_helper *helper, struct fb_var_screeninfo *ovar);
void nec_fb_set_tricked_fb_info(struct drm_fb_helper *helper, struct fb_var_screeninfo *ovar);
void nec_drm_fb_attach(struct drm_fb_helper *helper, int (*trunc)(struct drm_fb_helper *fb_helper, size_t size));
void nec_drm_fb_dettach(struct drm_fb_helper *helper);


#endif /* NEC_FB_H */
