// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2015 MediaTek Inc.
 */

#include <linux/soc/mediatek/mtk-cmdq.h>
#include "cmdq_device.h"

#define DECLAR_EVENT(event_enum, dts_name) \
	{event_enum, #event_enum, #dts_name},

static struct cmdq_event_table cmdq_events[] = {
	/* MDP start frame */
	DECLAR_EVENT(CMDQ_EVENT_MDP_RDMA0_SOF, mdp_rdma0_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_RDMA1_SOF, mdp_rdma1_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_RSZ0_SOF, mdp_rsz0_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_RSZ1_SOF, mdp_rsz1_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_RSZ2_SOF, mdp_rsz2_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_TDSHP_SOF, mdp_tdshp_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_TDSHP0_SOF, mdp_tdshp0_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_TDSHP1_SOF, mdp_tdshp1_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WDMA_SOF, mdp_wdma_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT_SOF, mdp_wrot_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT0_SOF, mdp_wrot0_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT1_SOF, mdp_wrot1_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_COLOR_SOF, mdp_color_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_MVW_SOF, mdp_mvw_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_CROP_SOF, mdp_crop_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_AAL_SOF, mdp_aal_sof)

	/* Display start frame */
	DECLAR_EVENT(CMDQ_EVENT_DISP_OVL0_SOF, disp_ovl0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_OVL1_SOF, disp_ovl1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_2L_OVL0_SOF, disp_2l_ovl0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_2L_OVL1_SOF, disp_2l_ovl1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RDMA0_SOF, disp_rdma0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RDMA1_SOF, disp_rdma1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RDMA2_SOF, disp_rdma2_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_WDMA0_SOF, disp_wdma0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_WDMA1_SOF, disp_wdma1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_COLOR_SOF, disp_color_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_COLOR0_SOF, disp_color0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_COLOR1_SOF, disp_color1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_CCORR_SOF, disp_ccorr_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_CCORR0_SOF, disp_ccorr0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_CCORR1_SOF, disp_ccorr1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_AAL_SOF, disp_aal_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_AAL0_SOF, disp_aal0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_AAL1_SOF, disp_aal1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_GAMMA_SOF, disp_gamma_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_GAMMA0_SOF, disp_gamma0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_GAMMA1_SOF, disp_gamma1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DITHER_SOF, disp_dither_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DITHER0_SOF, disp_dither0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DITHER1_SOF, disp_dither1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_UFOE_SOF, disp_ufoe_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_PWM0_SOF, disp_pwm0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_PWM1_SOF, disp_pwm1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_OD_SOF, disp_od_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DSC_SOF, disp_dsc_sof)

	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA0_L0_SOF, ufod_rdma0_l0_sof)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA0_L1_SOF, ufod_rdma0_l1_sof)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA0_L2_SOF, ufod_rdma0_l2_sof)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA0_L3_SOF, ufod_rdma0_l3_sof)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA1_L0_SOF, ufod_rdma1_l0_sof)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA1_L1_SOF, ufod_rdma1_l1_sof)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA1_L2_SOF, ufod_rdma1_l2_sof)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA1_L3_SOF, ufod_rdma1_l3_sof)

	/* MDP frame done */
	DECLAR_EVENT(CMDQ_EVENT_MDP_RDMA0_EOF, mdp_rdma0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_RDMA1_EOF, mdp_rdma1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_RSZ0_EOF, mdp_rsz0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_RSZ1_EOF, mdp_rsz1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_RSZ2_EOF, mdp_rsz2_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_TDSHP_EOF, mdp_tdshp_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_TDSHP0_EOF, mdp_tdshp0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_TDSHP1_EOF, mdp_tdshp1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WDMA_EOF, mdp_wdma_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT_WRITE_EOF, mdp_wrot_write_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT_READ_EOF, mdp_wrot_read_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT0_WRITE_EOF,
		mdp_wrot0_write_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT0_READ_EOF, mdp_wrot0_read_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT1_WRITE_EOF,
		mdp_wrot1_write_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT1_READ_EOF, mdp_wrot1_read_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT0_W_EOF, mdp_wrot0_write_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT0_R_EOF, mdp_wrot0_read_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT1_W_EOF, mdp_wrot1_write_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT1_R_EOF, mdp_wrot1_read_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_COLOR_EOF, mdp_color_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_CROP_EOF, mdp_crop_frame_done)

	/* Display frame done */
	DECLAR_EVENT(CMDQ_EVENT_DISP_OVL0_EOF, disp_ovl0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_OVL1_EOF, disp_ovl1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_2L_OVL0_EOF, disp_2l_ovl0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_2L_OVL1_EOF, disp_2l_ovl1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RDMA0_EOF, disp_rdma0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RDMA1_EOF, disp_rdma1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RDMA2_EOF, disp_rdma2_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_WDMA0_EOF, disp_wdma0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_WDMA1_EOF, disp_wdma1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_COLOR_EOF, disp_color_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_COLOR0_EOF, disp_color0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_COLOR1_EOF, disp_color1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_CCORR_EOF, disp_ccorr_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_CCORR0_EOF, disp_ccorr0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_CCORR1_EOF, disp_ccorr1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_AAL_EOF, disp_aal_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_AAL0_EOF, disp_aal0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_AAL1_EOF, disp_aal1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_GAMMA_EOF, disp_gamma_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_GAMMA0_EOF, disp_gamma0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_GAMMA1_EOF, disp_gamma1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DITHER_EOF, disp_dither_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DITHER0_EOF, disp_dither0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DITHER1_EOF, disp_dither1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_UFOE_EOF, disp_ufoe_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_OD_EOF, disp_od_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_OD_RDMA_EOF, disp_od_rdma_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_OD_WDMA_EOF, disp_od_wdma_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DSC_EOF, disp_dsc_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DSI0_EOF, disp_dsi0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DSI1_EOF, disp_dsi1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DPI0_EOF, disp_dpi0_frame_done)

	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA0_L0_EOF, ufod_rdma0_l0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA0_L1_EOF, ufod_rdma0_l1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA0_L2_EOF, ufod_rdma0_l2_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA0_L3_EOF, ufod_rdma0_l3_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA1_L0_EOF, ufod_rdma1_l0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA1_L1_EOF, ufod_rdma1_l1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA1_L2_EOF, ufod_rdma1_l2_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_UFOD_RAMA1_L3_EOF, ufod_rdma1_l3_frame_done)

	DECLAR_EVENT(CMDQ_EVENT_DISP_POSTMASK0_SOF, disp_postmask0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_POSTMASK0_FRAME_DONE,
		disp_postmask0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_POSTMASK0_FRAME_RST_DONE_PULSE,
		disp_postmask0_frame_rst_done_pulse)

	/* Mutex frame done */
	/* DISPSYS */
	DECLAR_EVENT(CMDQ_EVENT_MUTEX0_STREAM_EOF, stream_done_0)
	/* DISPSYS */
	DECLAR_EVENT(CMDQ_EVENT_MUTEX1_STREAM_EOF, stream_done_1)
	/* DISPSYS */
	DECLAR_EVENT(CMDQ_EVENT_MUTEX2_STREAM_EOF, stream_done_2)
	/* DISPSYS */
	DECLAR_EVENT(CMDQ_EVENT_MUTEX3_STREAM_EOF, stream_done_3)
	/* DISPSYS, please refer to disp_hal.h */
	DECLAR_EVENT(CMDQ_EVENT_MUTEX4_STREAM_EOF, stream_done_4)
	/* DpFramework */
	DECLAR_EVENT(CMDQ_EVENT_MUTEX5_STREAM_EOF, stream_done_5)
	/* DpFramework */
	DECLAR_EVENT(CMDQ_EVENT_MUTEX6_STREAM_EOF, stream_done_6)
	/* DpFramework */
	DECLAR_EVENT(CMDQ_EVENT_MUTEX7_STREAM_EOF, stream_done_7)
	/* DpFramework */
	DECLAR_EVENT(CMDQ_EVENT_MUTEX8_STREAM_EOF, stream_done_8)
	/* DpFramework via CMDQ_IOCTL_LOCK_MUTEX */
	DECLAR_EVENT(CMDQ_EVENT_MUTEX9_STREAM_EOF, stream_done_9)
	DECLAR_EVENT(CMDQ_EVENT_MUTEX10_STREAM_EOF, stream_done_10)
	DECLAR_EVENT(CMDQ_EVENT_MUTEX11_STREAM_EOF, stream_done_11)
	DECLAR_EVENT(CMDQ_EVENT_MUTEX12_STREAM_EOF, stream_done_12)
	DECLAR_EVENT(CMDQ_EVENT_MUTEX13_STREAM_EOF, stream_done_13)
	DECLAR_EVENT(CMDQ_EVENT_MUTEX14_STREAM_EOF, stream_done_14)
	DECLAR_EVENT(CMDQ_EVENT_MUTEX15_STREAM_EOF, stream_done_15)

	/* Display underrun */
	DECLAR_EVENT(CMDQ_EVENT_DISP_RDMA0_UNDERRUN, buf_underrun_event_0)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RDMA1_UNDERRUN, buf_underrun_event_1)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RDMA2_UNDERRUN, buf_underrun_event_2)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RDMA3_UNDERRUN, buf_underrun_event_3)

	/* Display TE */
	DECLAR_EVENT(CMDQ_EVENT_DSI_TE, dsi0_te_event)
	DECLAR_EVENT(CMDQ_EVENT_DSI0_TE, dsi0_te_event)
	DECLAR_EVENT(CMDQ_EVENT_DSI1_TE, dsi1_te_event)
	DECLAR_EVENT(CMDQ_EVENT_MDP_DSI0_TE_SOF, mdp_dsi0_te_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_DSI1_TE_SOF, mdp_dsi1_te_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DSI0_SOF, disp_dsi0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DSI1_SOF, disp_dsi1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DSI0_TO_GCE_MMCK0, dsi0_to_gce_mmck0)
	DECLAR_EVENT(CMDQ_EVENT_DSI0_TO_GCE_MMCK1, dsi0_to_gce_mmck1)
	DECLAR_EVENT(CMDQ_EVENT_DSI0_TO_GCE_MMCK2, dsi0_to_gce_mmck2)
	DECLAR_EVENT(CMDQ_EVENT_DSI0_TO_GCE_MMCK3, dsi0_to_gce_mmck3)
	DECLAR_EVENT(CMDQ_EVENT_DSI0_TO_GCE_MMCK4, dsi0_to_gce_mmck4)
	DECLAR_EVENT(CMDQ_EVENT_DSI1_TO_GCE_MMCK0, dsi1_to_gce_mmck0)
	DECLAR_EVENT(CMDQ_EVENT_DSI1_TO_GCE_MMCK1, dsi1_to_gce_mmck1)
	DECLAR_EVENT(CMDQ_EVENT_DSI1_TO_GCE_MMCK2, dsi1_to_gce_mmck2)
	DECLAR_EVENT(CMDQ_EVENT_DSI1_TO_GCE_MMCK3, dsi1_to_gce_mmck3)
	DECLAR_EVENT(CMDQ_EVENT_DSI1_TO_GCE_MMCK4, dsi1_to_gce_mmck4)
	DECLAR_EVENT(CMDQ_EVENT_DSI0_IRQ_EVENT, dsi0_irq_event)
	DECLAR_EVENT(CMDQ_EVENT_DSI0_DONE_EVENT, dsi0_done_event)
	DECLAR_EVENT(CMDQ_EVENT_DSI1_IRQ_EVENT, dsi1_irq_event)
	DECLAR_EVENT(CMDQ_EVENT_DSI1_DONE_EVENT, dsi1_done_event)

	/* Reset Event */
	DECLAR_EVENT(CMDQ_EVENT_DISP_WDMA0_RST_DONE, disp_wdma0_rst_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_WDMA1_RST_DONE, disp_wdma1_rst_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT0_RST_DONE, mdp_wrot0_rst_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WROT1_RST_DONE, mdp_wrot1_rst_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_WDMA_RST_DONE, mdp_wdma_rst_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_RDMA0_RST_DONE, mdp_rdma0_rst_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_RDMA1_RST_DONE, mdp_rdma1_rst_done)

	/* Display Mutex */
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD0,
		disp_mutex_all_module_upd0)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD1,
		disp_mutex_all_module_upd1)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD2,
		disp_mutex_all_module_upd2)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD3,
		disp_mutex_all_module_upd3)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD4,
		disp_mutex_all_module_upd4)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD5,
		disp_mutex_all_module_upd5)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD6,
		disp_mutex_all_module_upd6)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD7,
		disp_mutex_all_module_upd7)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD8,
		disp_mutex_all_module_upd8)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD9,
		disp_mutex_all_module_upd9)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD10,
		disp_mutex_all_module_upd10)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD11,
		disp_mutex_all_module_upd11)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD12,
		disp_mutex_all_module_upd12)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD13,
		disp_mutex_all_module_upd13)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD14,
		disp_mutex_all_module_upd14)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD15,
		disp_mutex_all_module_upd15)

	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE0,
		disp_mutex_reg_upd_for_module0)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE1,
		disp_mutex_reg_upd_for_module1)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE2,
		disp_mutex_reg_upd_for_module2)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE3,
		disp_mutex_reg_upd_for_module3)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE4,
		disp_mutex_reg_upd_for_module4)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE5,
		disp_mutex_reg_upd_for_module5)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE6,
		disp_mutex_reg_upd_for_module6)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE7,
		disp_mutex_reg_upd_for_module7)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE8,
		disp_mutex_reg_upd_for_module8)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE9,
		disp_mutex_reg_upd_for_module9)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE10,
		disp_mutex_reg_upd_for_module10)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE11,
		disp_mutex_reg_upd_for_module11)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE12,
		disp_mutex_reg_upd_for_module12)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE13,
		disp_mutex_reg_upd_for_module13)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE14,
		disp_mutex_reg_upd_for_module14)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE15,
		disp_mutex_reg_upd_for_module15)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE16,
		disp_mutex_reg_upd_for_module16)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE17,
		disp_mutex_reg_upd_for_module17)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE18,
		disp_mutex_reg_upd_for_module18)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE19,
		disp_mutex_reg_upd_for_module19)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE20,
		disp_mutex_reg_upd_for_module20)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE21,
		disp_mutex_reg_upd_for_module21)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE22,
		disp_mutex_reg_upd_for_module22)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE23,
		disp_mutex_reg_upd_for_module23)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE24,
		disp_mutex_reg_upd_for_module24)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE25,
		disp_mutex_reg_upd_for_module25)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE26,
		disp_mutex_reg_upd_for_module26)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE27,
		disp_mutex_reg_upd_for_module27)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE28,
		disp_mutex_reg_upd_for_module28)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE29,
		disp_mutex_reg_upd_for_module29)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE30,
		disp_mutex_reg_upd_for_module30)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE31,
		disp_mutex_reg_upd_for_module31)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE32,
		disp_mutex_reg_upd_for_module32)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE33,
		disp_mutex_reg_upd_for_module33)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE34,
		disp_mutex_reg_upd_for_module34)

	/* ISP frame done */
	DECLAR_EVENT(CMDQ_EVENT_ISP_PASS2_2_EOF, isp_frame_done_p2_2)
	DECLAR_EVENT(CMDQ_EVENT_ISP_PASS2_1_EOF, isp_frame_done_p2_1)
	DECLAR_EVENT(CMDQ_EVENT_ISP_PASS2_0_EOF, isp_frame_done_p2_0)
	DECLAR_EVENT(CMDQ_EVENT_ISP_PASS1_1_EOF, isp_frame_done_p1_1)
	DECLAR_EVENT(CMDQ_EVENT_ISP_PASS1_0_EOF, isp_frame_done_p1_0)

	/* ISP (IMGSYS) frame done */
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD0_EOF, dip_cq_thread0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD1_EOF, dip_cq_thread1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD2_EOF, dip_cq_thread2_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD3_EOF, dip_cq_thread3_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD4_EOF, dip_cq_thread4_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD5_EOF, dip_cq_thread5_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD6_EOF, dip_cq_thread6_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD7_EOF, dip_cq_thread7_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD8_EOF, dip_cq_thread8_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD9_EOF, dip_cq_thread9_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD10_EOF,
		dip_cq_thread10_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD11_EOF,
		dip_cq_thread11_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD12_EOF,
		dip_cq_thread12_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD13_EOF,
		dip_cq_thread13_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD14_EOF,
		dip_cq_thread14_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD15_EOF,
		dip_cq_thread15_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD16_EOF,
		dip_cq_thread16_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD17_EOF,
		dip_cq_thread17_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_CQ_THREAD18_EOF,
		dip_cq_thread18_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DPE_EOF, dpe_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DVE_EOF, dve_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_WMF_EOF, wmf_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_GEPF_EOF, gepf_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_GEPF_TEMP_EOF, gepf_temp_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_GEPF_BYPASS_EOF, gepf_bypass_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_RSC_EOF, rsc_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DIP_DMA_ERR_EVENT, dip_dma_err_event)

	/* ISP (IMGSYS) engine events */
	DECLAR_EVENT(CMDQ_EVENT_ISP_SENINF_CAM1_2_3_FULL,
		seninf_cam1_2_3_fifo_full)
	DECLAR_EVENT(CMDQ_EVENT_ISP_SENINF_CAM0_FULL, seninf_cam0_fifo_full)

	/* VENC frame done */
	DECLAR_EVENT(CMDQ_EVENT_VENC_EOF, venc_done)
	DECLAR_EVENT(CMDQ_EVENT_VENC_CMDQ_PAUSE_DONE, venc_cmdq_pause_done)

	/* JPEG frame done */
	DECLAR_EVENT(CMDQ_EVENT_JPEG_ENC_EOF, jpgenc_done)
	DECLAR_EVENT(CMDQ_EVENT_JPEG_ENC_PASS2_EOF, jpgenc_pass2_done)
	DECLAR_EVENT(CMDQ_EVENT_JPEG_ENC_PASS1_EOF, jpgenc_pass1_done)
	DECLAR_EVENT(CMDQ_EVENT_JPEG_DEC_EOF, jpgdec_done)

	/* VENC engine events */
	DECLAR_EVENT(CMDQ_EVENT_VENC_MB_DONE, venc_mb_done)
	DECLAR_EVENT(CMDQ_EVENT_VENC_128BYTE_CNT_DONE, venc_128byte_cnt_done)

	/* ISP (CAMSYS) frame done */
	DECLAR_EVENT(CMDQ_EVENT_ISP_FRAME_DONE_A, isp_frame_done_a)
	DECLAR_EVENT(CMDQ_EVENT_ISP_FRAME_DONE_B, isp_frame_done_b)
	DECLAR_EVENT(CMDQ_EVENT_ISP_FRAME_DONE_C, isp_frame_done_c)
	DECLAR_EVENT(CMDQ_EVENT_ISP_CAMSV_0_PASS1_DONE, camsv_0_pass1_done)
	DECLAR_EVENT(CMDQ_EVENT_ISP_CAMSV_0_2_PASS1_DONE, camsv_0_2_pass1_done)
	DECLAR_EVENT(CMDQ_EVENT_ISP_CAMSV_1_PASS1_DONE, camsv_1_pass1_done)
	DECLAR_EVENT(CMDQ_EVENT_ISP_CAMSV_2_PASS1_DONE, camsv_2_pass1_done)
	DECLAR_EVENT(CMDQ_EVENT_ISP_CAMSV_3_PASS1_DONE, camsv_3_pass1_done)
	DECLAR_EVENT(CMDQ_EVENT_ISP_TSF_DONE, tsf_done)

	DECLAR_EVENT(CMDQ_EVENT_ISP_RELAY_SOF, isp_relay_sof)
	DECLAR_EVENT(CMDQ_EVENT_IPU_RELAY_SOF, ipu_relay_sof)

	/* ISP (CAMSYS) engine events */
	DECLAR_EVENT(CMDQ_EVENT_SENINF_0_FIFO_FULL, seninf_0_fifo_full)
	DECLAR_EVENT(CMDQ_EVENT_SENINF_1_FIFO_FULL, seninf_1_fifo_full)
	DECLAR_EVENT(CMDQ_EVENT_SENINF_2_FIFO_FULL, seninf_2_fifo_full)
	DECLAR_EVENT(CMDQ_EVENT_SENINF_3_FIFO_FULL, seninf_3_fifo_full)
	DECLAR_EVENT(CMDQ_EVENT_SENINF_4_FIFO_FULL, seninf_4_fifo_full)
	DECLAR_EVENT(CMDQ_EVENT_SENINF_5_FIFO_FULL, seninf_5_fifo_full)
	DECLAR_EVENT(CMDQ_EVENT_SENINF_6_FIFO_FULL, seninf_6_fifo_full)
	DECLAR_EVENT(CMDQ_EVENT_SENINF_7_FIFO_FULL, seninf_7_fifo_full)

	DECLAR_EVENT(CMDQ_EVENT_TG_OVRUN_A_INT_DLY, tg_ovrun_a_int_dly)
	DECLAR_EVENT(CMDQ_EVENT_TG_OVRUN_B_INT_DLY, tg_ovrun_b_int_dly)
	DECLAR_EVENT(CMDQ_EVENT_TG_OVRUN_C_INT, tg_ovrun_c_int)
	DECLAR_EVENT(CMDQ_EVENT_TG_GRABERR_A_INT_DLY, tg_graberr_a_int_dly)
	DECLAR_EVENT(CMDQ_EVENT_TG_GRABERR_B_INT_DLY, tg_graberr_b_int_dly)
	DECLAR_EVENT(CMDQ_EVENT_TG_GRABERR_C_INT, tg_graberr_c_int)

	DECLAR_EVENT(CMDQ_EVENT_CQ_VR_SNAP_A_INT_DLY, cq_vr_snap_a_int_dly)
	DECLAR_EVENT(CMDQ_EVENT_CQ_VR_SNAP_B_INT_DLY, cq_vr_snap_b_int_dly)
	DECLAR_EVENT(CMDQ_EVENT_CQ_VR_SNAP_C_INT, cq_vr_snap_c_int)

	/* 6799 New Event */
	DECLAR_EVENT(CMDQ_EVENT_DISP_DSC1_SOF, disp_dsc_sof_1)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DSC2_SOF, disp_dsc_sof_2)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RSZ0_SOF, disp_rsz0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RSZ1_SOF, disp_rsz1_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DSC0_EOF, disp_dsc_frame_done_0)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DSC1_EOF, disp_dsc_frame_done_1)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RSZ0_EOF, disp_rsz0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_RSZ1_EOF, disp_rsz1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_DISP_OVL0_RST_DONE,
		disp_ovl0_frame_rst_done_pusle)
	DECLAR_EVENT(CMDQ_EVENT_DISP_OVL1_RST_DONE,
		disp_ovl1_frame_rst_done_pusle)
	DECLAR_EVENT(CMDQ_EVENT_DISP_OVL0_2L_RST_DONE,
		disp_ovl0_2l_frame_rst_done_pusle)
	DECLAR_EVENT(CMDQ_EVENT_DISP_OVL1_2L_RST_DONE,
		disp_ovl1_2l_frame_rst_done_pusle)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE35,
		disp_mutex_reg_upd_for_module35)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE36,
		disp_mutex_reg_upd_for_module36)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE37,
		disp_mutex_reg_upd_for_module37)
	DECLAR_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE38,
		disp_mutex_reg_upd_for_module38)
	DECLAR_EVENT(CMDQ_EVENT_WPE_A_EOF, wpe_a_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_EAF_EOF, eaf_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_VENC_BSDMA_FULL, venc_bsdma_full)
	DECLAR_EVENT(CMDQ_EVENT_IPU0_EOF, ipu_done_0)
	DECLAR_EVENT(CMDQ_EVENT_IPU1_EOF, ipu_done_1)
	DECLAR_EVENT(CMDQ_EVENT_IPU2_EOF, ipu_done_2)
	DECLAR_EVENT(CMDQ_EVENT_IPU3_EOF, ipu_done_3)

	/* 6759 New Event */
	DECLAR_EVENT(CMDQ_EVENT_DISP_SPLIT_SOF, disp_split_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_SPLIT_FRAME_DONE, disp_split_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_AMD_FRAME_DONE, amd_frame_done)

	DECLAR_EVENT(CMDQ_EVENT_DISP_DPI0_SOF, disp_dpi0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DSI0_TE_INFRA, dsi0_te_from_infra)

	/* 6739 New Event*/
	DECLAR_EVENT(CMDQ_EVENT_DISP_DBI0_SOF, disp_dbi0_sof)
	DECLAR_EVENT(CMDQ_EVENT_DISP_DBI0_EOF, disp_dbi0_frame_done)

	/* 6775 New Event */
	DECLAR_EVENT(CMDQ_EVENT_MDP_CCORR_SOF, mdp_ccorr_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_CCORR_FRAME_DONE, mdp_ccorr_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MDP_AAL_FRAME_DONE, mdp_aal_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_WPE_B_FRAME_DONE, wpe_b_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_MFB_DONE, mfb_done)
	DECLAR_EVENT(CMDQ_EVENT_OCC_DONE, occ_done)
	DECLAR_EVENT(CMDQ_EVENT_IPU_DONE_1_0, ipu_done_1_0)
	DECLAR_EVENT(CMDQ_EVENT_IPU_DONE_1_1, ipu_done_1_1)
	DECLAR_EVENT(CMDQ_EVENT_IPU_DONE_1_2, ipu_done_1_2)
	DECLAR_EVENT(CMDQ_EVENT_IPU_DONE_1_3, ipu_done_1_3)
	DECLAR_EVENT(CMDQ_EVENT_IPU_DONE_2_0, ipu_done_2_0)
	DECLAR_EVENT(CMDQ_EVENT_IPU_DONE_2_1, ipu_done_2_1)
	DECLAR_EVENT(CMDQ_EVENT_IPU_DONE_2_2, ipu_done_2_2)
	DECLAR_EVENT(CMDQ_EVENT_IPU_DONE_2_3, ipu_done_2_3)

	/* 6765 */
	DECLAR_EVENT(CMDQ_EVENT_MDP_CCORR0_SOF, mdp_ccorr0_sof)
	DECLAR_EVENT(CMDQ_EVENT_MDP_CCORR0_FRAME_DONE, mdp_ccorr0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG_DL_RELAY_SOF, img_dl_relay_sof)

	/* 6779 New Event */
	DECLAR_EVENT(CMDQ_EVENT_DMA_R1_ERROR_A_INT_DLY, dma_r1_error_a_int_dly)
	DECLAR_EVENT(CMDQ_EVENT_DMA_R1_ERROR_B_INT_DLY, dma_r1_error_b_int_dly)
	DECLAR_EVENT(CMDQ_EVENT_DMA_R1_ERROR_C_INT, dma_r1_error_c_int)

	DECLAR_EVENT(CMDQ_EVENT_APU_GCE_CORE0_EVENT_0, apu_gce_core0_event_0)
	DECLAR_EVENT(CMDQ_EVENT_APU_GCE_CORE0_EVENT_1, apu_gce_core0_event_1)
	DECLAR_EVENT(CMDQ_EVENT_APU_GCE_CORE0_EVENT_2, apu_gce_core0_event_2)
	DECLAR_EVENT(CMDQ_EVENT_APU_GCE_CORE0_EVENT_3, apu_gce_core0_event_3)
	DECLAR_EVENT(CMDQ_EVENT_APU_GCE_CORE1_EVENT_0, apu_gce_core1_event_0)
	DECLAR_EVENT(CMDQ_EVENT_APU_GCE_CORE1_EVENT_1, apu_gce_core1_event_1)
	DECLAR_EVENT(CMDQ_EVENT_APU_GCE_CORE1_EVENT_2, apu_gce_core1_event_2)
	DECLAR_EVENT(CMDQ_EVENT_APU_GCE_CORE1_EVENT_3, apu_gce_core1_event_3)

	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_0, vdec_event_0)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_1, vdec_event_1)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_2, vdec_event_2)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_3, vdec_event_3)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_4, vdec_event_4)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_5, vdec_event_5)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_6, vdec_event_6)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_7, vdec_event_7)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_8, vdec_event_8)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_9, vdec_event_9)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_10, vdec_event_10)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_11, vdec_event_11)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_12, vdec_event_12)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_13, vdec_event_13)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_14, vdec_event_14)
	DECLAR_EVENT(CMDQ_EVENT_VDEC_EVENT_15, vdec_event_15)

	DECLAR_EVENT(CMDQ_EVENT_FDVT_DONE, fdvt_done)
	DECLAR_EVENT(CMDQ_EVENT_FE_DONE, fe_done)
	DECLAR_EVENT(CMDQ_EVENT_DVS_DONE_ASYNC_SHOT, dvs_done_async_shot)
	DECLAR_EVENT(CMDQ_EVENT_DVP_DONE_ASYNC_SHOT, dvp_done_async_shot)

	DECLAR_EVENT(CMDQ_EVENT_VENC_FRAME_DONE, venc_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_VENC_PAUSE_DONE, venc_pause_done)

	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_0,
		dip_cq_thread0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_1,
		dip_cq_thread1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_2,
		dip_cq_thread2_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_3,
		dip_cq_thread3_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_4,
		dip_cq_thread4_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_5,
		dip_cq_thread5_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_6,
		dip_cq_thread6_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_7,
		dip_cq_thread7_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_8,
		dip_cq_thread8_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_9,
		dip_cq_thread9_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_10,
		dip_cq_thread10_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_11,
		dip_cq_thread11_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_12,
		dip_cq_thread12_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_13,
		dip_cq_thread13_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_14,
		dip_cq_thread14_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_15,
		dip_cq_thread15_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_16,
		dip_cq_thread16_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_17,
		dip_cq_thread17_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_18,
		dip_cq_thread18_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_19,
		dip_cq_thread19_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_20,
		dip_cq_thread20_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_21,
		dip_cq_thread21_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_22,
		dip_cq_thread22_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_23,
		dip_cq_thread23_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_0,
		dip2_cq_thread0_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_1,
		dip2_cq_thread1_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_2,
		dip2_cq_thread2_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_3,
		dip2_cq_thread3_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_4,
		dip2_cq_thread4_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_5,
		dip2_cq_thread5_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_6,
		dip2_cq_thread6_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_7,
		dip2_cq_thread7_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_8,
		dip2_cq_thread8_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_9,
		dip2_cq_thread9_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_10,
		dip2_cq_thread10_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_11,
		dip2_cq_thread11_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_12,
		dip2_cq_thread12_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_13,
		dip2_cq_thread13_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_14,
		dip2_cq_thread14_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_15,
		dip2_cq_thread15_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_16,
		dip2_cq_thread16_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_17,
		dip2_cq_thread17_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_18,
		dip2_cq_thread18_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_19,
		dip2_cq_thread19_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_20,
		dip2_cq_thread20_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_21,
		dip2_cq_thread21_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_22,
		dip2_cq_thread22_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_23,
		dip2_cq_thread23_frame_done)
	DECLAR_EVENT(CMDQ_EVENT_IPE_EVENT_TX_FRAME_DONE_0,
		ipe_event_tx_frame_done_0)
	DECLAR_EVENT(CMDQ_EVENT_IPE_EVENT_TX_FRAME_DONE_1,
		ipe_event_tx_frame_done_1)
	DECLAR_EVENT(CMDQ_EVENT_IPE_EVENT_TX_FRAME_DONE_2,
		ipe_event_tx_frame_done_2)
	DECLAR_EVENT(CMDQ_EVENT_IPE_EVENT_TX_FRAME_DONE_3,
		ipe_event_tx_frame_done_3)
	DECLAR_EVENT(CMDQ_EVENT_IPE_EVENT_TX_FRAME_DONE_4,
		ipe_event_tx_frame_done_4)

	/* Keep this at the end of HW events */
	DECLAR_EVENT(CMDQ_MAX_HW_EVENT_COUNT, hw_event_conunt)

	/* SW Sync Tokens (Pre-defined) */
	/* Config thread notify trigger thread */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_CONFIG_DIRTY, sw_token)
	/* Trigger thread notify config thread */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_STREAM_EOF, sw_token)
	/* Block Trigger thread until the ESD check finishes. */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_ESD_EOF, sw_token)
	/* check CABC setup finish */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_CABC_EOF, sw_token)
	/* Block Trigger thread until the path freeze finishes */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_FREEZE_EOF, sw_token)
	/* Pass-2 notifies VENC frame is ready to be encoded */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_VENC_INPUT_READY, sw_token)
	/* VENC notifies Pass-2 encode done so next frame may start */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_VENC_EOF, sw_token)

	/* Notify normal CMDQ there are some secure task done */
	DECLAR_EVENT(CMDQ_SYNC_SECURE_THR_EOF, sw_token)
	/* Lock WSM resource */
	DECLAR_EVENT(CMDQ_SYNC_SECURE_WSM_LOCK, sw_token)

	/* SW Sync Tokens (User-defined) */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_USER_0, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_USER_1, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_POLL_MONITOR, sw_token)

	/* SW Sync Tokens (Pre-defined) */
	/* Config thread notify trigger thread for external display */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_EXT_CONFIG_DIRTY, sw_token)
	/* Trigger thread notify config thread */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_EXT_STREAM_EOF, sw_token)
	/* Check CABC setup finish */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_EXT_CABC_EOF, sw_token)

	/* Secure video path notify SW token */
	DECLAR_EVENT(CMDQ_SYNC_DISP_OVL0_2NONSEC_END, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_DISP_OVL1_2NONSEC_END, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_DISP_2LOVL0_2NONSEC_END, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_DISP_2LOVL1_2NONSEC_END, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_DISP_RDMA0_2NONSEC_END, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_DISP_RDMA1_2NONSEC_END, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_DISP_WDMA0_2NONSEC_END, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_DISP_WDMA1_2NONSEC_END, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_DISP_EXT_STREAM_EOF, sw_token)

	/**
	 * Event for CMDQ to block executing command when append command
	 * Plz sync CMDQ_SYNC_TOKEN_APPEND_THR(id) in cmdq_core source file.
	 */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR0, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR1, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR2, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR3, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR4, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR5, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR6, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR7, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR8, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR9, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR10, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR11, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR12, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR13, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR14, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR15, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR16, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR17, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR18, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR19, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR20, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR21, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR22, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR23, sw_token)

	/* GPR access tokens (for HW register backup)
	 * There are 15 32-bit GPR, 3 GPR form a set
	 * (64-bit for address, 32-bit for value)
	 */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_GPR_SET_0, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_GPR_SET_1, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_GPR_SET_2, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_GPR_SET_3, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_GPR_SET_4, sw_token)

	/* Resource lock event to control resource in GCE thread */
	DECLAR_EVENT(CMDQ_SYNC_RESOURCE_WROT0, sw_token)
	DECLAR_EVENT(CMDQ_SYNC_RESOURCE_WROT1, sw_token)

	/* GCE HW TPR Event*/
	DECLAR_EVENT(CMDQ_EVENT_TIMER_00, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_01, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_02, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_03, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_04, sw_token)
	/* 5: 1us */
	DECLAR_EVENT(CMDQ_EVENT_TIMER_05, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_06, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_07, sw_token)
	/* 8: 10us */
	DECLAR_EVENT(CMDQ_EVENT_TIMER_08, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_09, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_10, sw_token)
	/* 11: 100us */
	DECLAR_EVENT(CMDQ_EVENT_TIMER_11, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_12, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_13, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_14, sw_token)
	/* 15: 1ms */
	DECLAR_EVENT(CMDQ_EVENT_TIMER_15, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_16, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_17, sw_token)
	/* 18: 10ms */
	DECLAR_EVENT(CMDQ_EVENT_TIMER_18, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_19, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_20, sw_token)
	/* 21: 100ms */
	DECLAR_EVENT(CMDQ_EVENT_TIMER_21, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_22, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_23, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_24, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_25, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_26, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_27, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_28, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_29, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_30, sw_token)
	DECLAR_EVENT(CMDQ_EVENT_TIMER_31, sw_token)

	/* event id is 10 bit */
	DECLAR_EVENT(CMDQ_SYNC_TOKEN_MAX, max_token)
};

struct cmdq_event_table *cmdq_event_get_table(void)
{
	return cmdq_events;
}

u32 cmdq_event_get_table_size(void)
{
	return ARRAY_SIZE(cmdq_events);
}
