/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2019 MediaTek Inc.
 * Author: Joey Pan <joey.pan@mediatek.com>
 */

#ifndef _DDP_REG_MMSYS_H_
#define _DDP_REG_MMSYS_H_

/* field definition */
/* ------------------------------------------------------------- */
/* Config */
#define MMCON(offset)	(DISPSYS_CONFIG_BASE + (offset))

#define DISP_REG_CONFIG_MMSYS_INTEN		MMCON(0x0)
#define DISP_REG_CONFIG_MMSYS_INTSTA		MMCON(0x4)
#define DISP_REG_CONFIG_MFG_APB_TX_CON		MMCON(0xc)

#define DISP_REG_CONFIG_MMSYS_HRT_WEIGHTING_0	MMCON(0x030)
#define DISP_REG_CONFIG_MMSYS_HRT_WEIGHTING_1	MMCON(0x034)
#define DISP_REG_CONFIG_MMSYS_HRT_WEIGHTING_2	MMCON(0x038)
#define DISP_REG_CONFIG_MMSYS_HRT_WEIGHTING_3	MMCON(0x03c)
#define DISP_REG_CONFIG_MMSYS_HRT_WEIGHTING_4	MMCON(0x040)
#define DISP_REG_CONFIG_MMSYS_HRT_WEIGHTING_5	MMCON(0x044)
#define DISP_REG_CONFIG_MMSYS_HRT_WEIGHTING_CTRL	MMCON(0x048)
#define DISP_REG_CONFIG_MMSYS_HRT_TRIGGER_TIME	MMCON(0x04c)

#define DISP_REG_CONFIG_MMSYS_MOUT_RST		MMCON(0x050)

#define DISP_REG_CONFIG_MMSYS_MISC		MMCON(0x0F0)
	#define FLD_SHARE_WROT_SEL		REG_FLD_MSB_LSB(6, 6)
	#define FLD_OVL0_ULTRA_SEL		REG_FLD_MSB_LSB(19, 16)
	#define FLD_OVL0_2L_ULTRA_SEL		REG_FLD_MSB_LSB(23, 20)
	#define FLD_OVL1_2L_ULTRA_SEL		REG_FLD_MSB_LSB(27, 24)
#define DISP_REG_CONFIG_MMSYS_SMI_LARB_SEL	MMCON(0x0F4)
#define DISP_REG_CONFIG_MMSYS_SODI_REQ_MASK	MMCON(0x0F8)
	#define	FLD_HRT_URGENT_CTRL		REG_FLD_MSB_LSB(7, 0)
	#define FLD_SODI_REQ_MASKEN		REG_FLD_MSB_LSB(11, 8)
	#define FLD_SODI_REQ_MASKEN_CG_RDMA0	REG_FLD_MSB_LSB(9, 9)
	#define FLD_SODI_REQ_MASKEN_CG_RDMA1	REG_FLD_MSB_LSB(11, 11)
	#define FLD_SODI_REQ_MASKVAL		REG_FLD_MSB_LSB(15, 12)
	#define FLD_DVFS_HALT_MASK		REG_FLD_MSB_LSB(20, 16)
	#define FLD_DVFS_HALT_MASK_RDMA0	REG_FLD_MSB_LSB(16, 16)
	#define FLD_DVFS_HALT_MASK_RDMA1	REG_FLD_MSB_LSB(17, 17)
	#define FLD_DVFS_HALT_MASK_WDMA		REG_FLD_MSB_LSB(18, 18)
	#define FLD_DRS_HALT_MASK		REG_FLD_MSB_LSB(27, 24)
#define DISP_REG_CONFIG_MMSYS_CG_CON0		MMCON(0x100)
#define DISP_REG_CONFIG_MMSYS_CG_SET0		MMCON(0x104)
#define DISP_REG_CONFIG_MMSYS_CG_CLR0		MMCON(0x108)
#define DISP_REG_CONFIG_MMSYS_CG_CON1		MMCON(0x110)
#define DISP_REG_CONFIG_MMSYS_CG_SET1		MMCON(0x114)
#define DISP_REG_CONFIG_MMSYS_CG_CLR1		MMCON(0x118)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS0	MMCON(0x120)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS_SET0	MMCON(0x124)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS_CLR0	MMCON(0x128)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS1	MMCON(0x130)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS_SET1	MMCON(0x134)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS_CLR1	MMCON(0x138)
#define DISP_REG_CONFIG_MMSYS_SW0_RST_B		MMCON(0x140)
#define DISP_REG_CONFIG_MMSYS_SW1_RST_B		MMCON(0x144)
#define DISP_REG_CONFIG_MMSYS_LCM_RST_B		MMCON(0x150)

#define DISP_REG_CONFIG_SMI_N21MUX_CFG_WR	MMCON(0x168)
#define DISP_REG_CONFIG_SMI_N21MUX_CFG_RD	MMCON(0x16c)
#define DISP_REG_CONFIG_ELA2GMC_BASE_ADDR	MMCON(0x170)
#define DISP_REG_CONFIG_ELA2GMC_BASE_ADDR_END	MMCON(0x174)
#define DISP_REG_CONFIG_ELA2GMC_FINAL_ADDR	MMCON(0x178)
#define DISP_REG_CONFIG_ELA2GMC_STATUS		MMCON(0x17c)
#define DISP_REG_CONFIG_LARB6_AXI_ASIF_CFG_WD	MMCON(0x180)
#define DISP_REG_CONFIG_LARB6_AXI_ASIF_CFG_RD	MMCON(0x184)
#define DISP_REG_CONFIG_PROC_TRACK_EMI_BUSY_CON	MMCON(0x190)

#define DISP_REG_CONFIG_DISP_FAKE_ENG_EN	MMCON(0x200)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_RST	MMCON(0x204)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_CON0	MMCON(0x208)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_CON1	MMCON(0x20c)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_RD_ADDR	MMCON(0x210)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_WR_ADDR	MMCON(0x214)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_STATE	MMCON(0x218)
#define DISP_REG_CONFIG_DISP_FAKE2_ENG_EN	MMCON(0x220)
#define DISP_REG_CONFIG_DISP_FAKE2_ENG_RST	MMCON(0x224)
#define DISP_REG_CONFIG_DISP_FAKE2_ENG_CON0	MMCON(0x228)
#define DISP_REG_CONFIG_DISP_FAKE2_ENG_CON1	MMCON(0x22c)
#define DISP_REG_CONFIG_DISP_FAKE2_ENG_RD_ADDR	MMCON(0x230)
#define DISP_REG_CONFIG_DISP_FAKE2_ENG_WR_ADDR	MMCON(0x234)
#define DISP_REG_CONFIG_DISP_FAKE2_ENG_STATE	MMCON(0x238)

#define DISP_REG_CONFIG_MMSYS_MBIST_CON		MMCON(0x800)
#define DISP_REG_CONFIG_MMSYS_MBIST_DONE0	MMCON(0x804)
#define DISP_REG_CONFIG_MMSYS_MBIST_DONE1	MMCON(0x808)
#define DISP_REG_CONFIG_MMSYS_MBIST_HOLDB	MMCON(0x80c)
#define DISP_REG_CONFIG_MMSYS_MBIST_MODE0	MMCON(0x810)
#define DISP_REG_CONFIG_MMSYS_MBIST_MODE1	MMCON(0x814)
#define DISP_REG_CONFIG_MMSYS_MBIST_MODE2	MMCON(0x818)
#define DISP_REG_CONFIG_MMSYS_MBIST_MODE3	MMCON(0x81c)
#define DISP_REG_CONFIG_MMSYS_MBIST_FAIL0	MMCON(0x820)
#define DISP_REG_CONFIG_MMSYS_MBIST_FAIL1	MMCON(0x824)
#define DISP_REG_CONFIG_MMSYS_MBIST_FAIL2	MMCON(0x828)
#define DISP_REG_CONFIG_MMSYS_MBIST_FAIL3	MMCON(0x82c)
#define DISP_REG_CONFIG_MMSYS_MBIST_DEBUG	MMCON(0x830)
#define DISP_REG_CONFIG_MMSYS_MBIST_DIAG_SCANOUT	MMCON(0x834)
#define DISP_REG_CONFIG_MMSYS_MBIST_PRE_FUSE	MMCON(0x838)

#define DISP_REG_CONFIG_MMSYS_MBIST_BSEL0	MMCON(0x83c)
#define DISP_REG_CONFIG_MMSYS_MBIST_HDEN	MMCON(0x844)

#define DISP_REG_CONFIG_MDP_RDMA0_MEM_DELSEL_0	MMCON(0x848)
#define DISP_REG_CONFIG_MDP_RDMA0_MEM_DELSEL_1	MMCON(0x84c)
#define DISP_REG_CONFIG_MDP_RDMA1_MEM_DELSEL	MMCON(0x850)
#define DISP_REG_CONFIG_MDP_RSZ_MEM_DELSEL_0	MMCON(0x854)
#define DISP_REG_CONFIG_MDP_RSZ_MEM_DELSEL_1	MMCON(0x858)
#define DISP_REG_CONFIG_MDP_RSZ_MEM_DELSEL_2	MMCON(0x85c)

#define DISP_REG_CONFIG_MDP_TDSHP_MEM_DELSEL	MMCON(0x860)

#define DISP_REG_CONFIG_MDP_WROT_MEM_DELSEL_0	MMCON(0x864)
#define DISP_REG_CONFIG_MDP_WROT_MEM_DELSEL_1	MMCON(0x868)

#define DISP_REG_CONFIG_DISP_OVL0_MEM_DELSEL_0	MMCON(0x86c)
#define DISP_REG_CONFIG_DISP_OVL0_MEM_DELSEL_1	MMCON(0x870)
#define DISP_REG_CONFIG_DISP_OVL0_2L_MEM_DELSEL	MMCON(0x874)
#define DISP_REG_CONFIG_DISP_OVL1_2L_MEM_DELSEL	MMCON(0x878)
#define DISP_REG_CONFIG_DISP_RDMA_MEM_DELSEL	MMCON(0x87c)

#define DISP_REG_CONFIG_DISP_RDMA_UFO_MEM_DELSEL	MMCON(0x880)
#define DISP_REG_CONFIG_DISP_GAMMA_MEM_DELSEL	MMCON(0x884)
#define DISP_REG_CONFIG_DISP_DSI_MEM_DELSEL	MMCON(0x888)
#define DISP_REG_CONFIG_DISP_AAL_MEM_DELSEL	MMCON(0x88c)
#define DISP_REG_CONFIG_MDP_AAL_MEM_DELSEL	MMCON(0x890)
#define DISP_REG_CONFIG_DISP_RSZ_MEM_DELSEL	MMCON(0x894)
#define DISP_REG_CONFIG_DISP_WDMA_MEM_DELSEL	MMCON(0x898)
#define DISP_REG_CONFIG_MMSYS_DEBUG_OUT_SEL	MMCON(0x89c)
#define DISP_REG_CONFIG_MMSYS_MBIST_RP_RST_B	MMCON(0x8a0)
#define DISP_REG_CONFIG_MMSYS_MBIST_RP_FAIL0	MMCON(0x8a4)
#define DISP_REG_CONFIG_MMSYS_MBIST_RP_FAIL1	MMCON(0x8a8)
#define DISP_REG_CONFIG_MMSYS_MBIST_RP_FAIL2	MMCON(0x8ac)
#define DISP_REG_CONFIG_MMSYS_MBIST_RP_OK0	MMCON(0x8b0)
#define DISP_REG_CONFIG_MMSYS_MBIST_RP_OK1	MMCON(0x8b4)
#define DISP_REG_CONFIG_MMSYS_MBIST_RP_OK2	MMCON(0x8b8)
#define DISP_REG_CONFIG_MMSYS_DUMMY0		MMCON(0x8bc)
#define DISP_REG_CONFIG_MMSYS_DUMMY1		MMCON(0x8c0)
#define DISP_REG_CONFIG_MMSYS_DUMMY2		MMCON(0x8c4)
#define DISP_REG_CONFIG_MMSYS_DUMMY3		MMCON(0x8c8)

#define DISP_REG_CONFIG_DISP_DL_VALID_0		MMCON(0x8cc)
#define DISP_REG_CONFIG_DISP_DL_VALID_1		MMCON(0x8d0)
#define DISP_REG_CONFIG_DISP_DL_VALID_2		MMCON(0x8d4)
#define DISP_REG_CONFIG_DISP_DL_VALID_3		MMCON(0x8d8)
#define DISP_REG_CONFIG_DISP_DL_VALID_4		MMCON(0x8dc)

#define DISP_REG_CONFIG_DISP_DL_READY_0		MMCON(0x8e0)
#define DISP_REG_CONFIG_DISP_DL_READY_1		MMCON(0x8e4)
#define DISP_REG_CONFIG_DISP_DL_READY_2		MMCON(0x8e8)
#define DISP_REG_CONFIG_DISP_DL_READY_3		MMCON(0x8ec)
#define DISP_REG_CONFIG_DISP_DL_READY_4		MMCON(0x8f0)
#define DISP_REG_CONFIG_SMI_LARB_GREQ		MMCON(0x8f4)
#define DISP_REG_CONFIG_DISP_MOUT_MASK_0	MMCON(0x8f8)
#define DISP_REG_CONFIG_DISP_MOUT_MASK_1	MMCON(0x8fc)
#define DISP_REG_CONFIG_DISP_MOUT_MASK_2	MMCON(0x900)
#define DISP_REG_CONFIG_POWER_READ		MMCON(0x904)
#define DISP_REG_CONFIG_HRT_WEIGHT_READ		MMCON(0x908)

#define DISP_REG_CONFIG_MMSYS_DBPI_SEL		MMCON(0x964)
#define DISP_REG_CONFIG_DISP_RDMA_VDE_SEL	MMCON(0x968)


#define DISP_REG_CONFIG_DISP_DITHER0_MOUT_EN	MMCON(0xf00)
#define DISP_REG_CONFIG_DISP_OVL0_2L_MOUT_EN	MMCON(0xf04)
#define DISP_REG_CONFIG_DISP_OVL0_MOUT_EN	MMCON(0xf08)
#define DISP_REG_CONFIG_DISP_OVL1_2L_MOUT_EN	MMCON(0xf0c)
#define DISP_REG_CONFIG_DISP_RSZ_MOUT_EN	MMCON(0xf10)
#define DISP_REG_CONFIG_DISP_OVL0_WCG_MOUT_EN	MMCON(0xf34)
#define DISP_REG_CONFIG_DISP_OVL0_2L_WCG_MOUT_EN	MMCON(0xf38)
#define DISP_REG_CONFIG_DISP_OVL1_2L_WCG_MOUT_EN	MMCON(0xf3C)
#define DISP_REG_CONFIG_DISP_RDMA0_RSZ_IN_SOUT_SEL_IN	MMCON(0xf40)
#define DISP_REG_CONFIG_DISP_RDMA0_SOUT_SEL_IN	MMCON(0xf44)
#define DISP_REG_CONFIG_DISP_RDMA1_SOUT_SEL_IN	MMCON(0xf48)
#define DISP_REG_CONFIG_DISP_TO_WROT_SOUT_SEL	MMCON(0xf4C)
#define DISP_REG_CONFIG_DISP_COLOR_OUT_SEL_IN	MMCON(0xf68)
#define DISP_REG_CONFIG_DISP_OVL0_2L_SEL_IN	MMCON(0xf6C)
#define DISP_REG_CONFIG_DISP_OVL0_SEL_IN	MMCON(0xf70)
#define DISP_REG_CONFIG_DISP_PATH0_SEL_IN	MMCON(0xf74)
#define DISP_REG_CONFIG_DISP_RDMA0_RSZ_OUT_SEL_IN	MMCON(0xf78)
#define DISP_REG_CONFIG_DISP_RSZ_SEL_IN		MMCON(0xf7C)
#define DISP_REG_CONFIG_DISP_WDMA0_PRE_SEL_IN	MMCON(0xf80)
#define DISP_REG_CONFIG_DISP_WDMA0_SEL_IN	MMCON(0xf84)
#define DISP_REG_CONFIG_DPI0_SEL_IN		MMCON(0xf88)
#define DISP_REG_CONFIG_DSI0_SEL_IN		MMCON(0xf8C)
#define DISP_REG_CONFIG_OVL_TO_R2Y_SEL_IN	MMCON(0xfBC)
#define DISP_REG_CONFIG_OVL_TO_WDMA_SEL_IN	MMCON(0xfC0)
#define DISP_REG_CONFIG_OVL_TO_WROT_SEL_IN	MMCON(0xfC4)
#define DISP_REG_CONFIG_DISP_OVL0_WCG_SEL_IN	MMCON(0xfC8)
#define DISP_REG_CONFIG_DISP_OVL0_2L_WCG_SEL_IN	MMCON(0xfCC)
#define DISP_REG_CONFIG_DISP_OVL1_2L_WCG_SEL_IN	MMCON(0xfD0)

/* field definition */
/* ------------------------------------------------------------- */

#endif /* _DDP_REG_MMSYS_H_ */
