/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2018 MediaTek Inc.
 *
 * Author: Zhiyong Tao <zhiyong.tao@mediatek.com>
 *
 */

#ifndef __PINCTRL_MTK_MT8168_H
#define __PINCTRL_MTK_MT8168_H

#include "pinctrl-paris.h"

static struct mtk_pin_desc mtk_pins_mt8168[] = {
	MTK_PIN(
		0, "GPIO0",
		MTK_EINT_FUNCTION(0, 0),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO0"),
		MTK_FUNCTION(1, "DPI_D0"),
		MTK_FUNCTION(2, "PWM_A"),
		MTK_FUNCTION(3, "I2S2_BCK"),
		MTK_FUNCTION(4, "EXT_TXD0"),
		MTK_FUNCTION(5, "CONN_MCU_TDO"),
		MTK_FUNCTION(7, "DBG_MON_A0")
	),
	MTK_PIN(
		1, "GPIO1",
		MTK_EINT_FUNCTION(0, 1),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO1"),
		MTK_FUNCTION(1, "DPI_D1"),
		MTK_FUNCTION(2, "PWM_B"),
		MTK_FUNCTION(3, "I2S2_LRCK"),
		MTK_FUNCTION(4, "EXT_TXD1"),
		MTK_FUNCTION(5, "CONN_MCU_DBGACK_N"),
		MTK_FUNCTION(7, "DBG_MON_A1")
	),
	MTK_PIN(
		2, "GPIO2",
		MTK_EINT_FUNCTION(0, 2),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO2"),
		MTK_FUNCTION(1, "DPI_D2"),
		MTK_FUNCTION(2, "PWM_C"),
		MTK_FUNCTION(3, "I2S2_MCK"),
		MTK_FUNCTION(4, "EXT_TXD2"),
		MTK_FUNCTION(5, "CONN_MCU_DBGI_N"),
		MTK_FUNCTION(7, "DBG_MON_A2")
	),
	MTK_PIN(
		3, "GPIO3",
		MTK_EINT_FUNCTION(0, 3),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO3"),
		MTK_FUNCTION(1, "DPI_D3"),
		MTK_FUNCTION(2, "CLKM0"),
		MTK_FUNCTION(3, "I2S2_DI"),
		MTK_FUNCTION(4, "EXT_TXD3"),
		MTK_FUNCTION(5, "CONN_MCU_TCK"),
		MTK_FUNCTION(6, "CONN_MCU_AICE_TCKC"),
		MTK_FUNCTION(7, "DBG_MON_A3")
	),
	MTK_PIN(
		4, "GPIO4",
		MTK_EINT_FUNCTION(0, 4),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO4"),
		MTK_FUNCTION(1, "DPI_D4"),
		MTK_FUNCTION(2, "CLKM1"),
		MTK_FUNCTION(3, "I2S1_BCK"),
		MTK_FUNCTION(4, "EXT_TXC"),
		MTK_FUNCTION(5, "CONN_MCU_TDI"),
		MTK_FUNCTION(6, "VDEC_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_A4")
	),
	MTK_PIN(
		5, "GPIO5",
		MTK_EINT_FUNCTION(0, 5),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO5"),
		MTK_FUNCTION(1, "DPI_D5"),
		MTK_FUNCTION(2, "CLKM2"),
		MTK_FUNCTION(3, "I2S1_LRCK"),
		MTK_FUNCTION(4, "EXT_RXER"),
		MTK_FUNCTION(5, "CONN_MCU_TRST_B"),
		MTK_FUNCTION(6, "MM_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_A5")
	),
	MTK_PIN(
		6, "GPIO6",
		MTK_EINT_FUNCTION(0, 6),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO6"),
		MTK_FUNCTION(1, "DPI_D6"),
		MTK_FUNCTION(2, "CLKM3"),
		MTK_FUNCTION(3, "I2S1_MCK"),
		MTK_FUNCTION(4, "EXT_RXC"),
		MTK_FUNCTION(5, "CONN_MCU_TMS"),
		MTK_FUNCTION(6, "CONN_MCU_AICE_TMSC"),
		MTK_FUNCTION(7, "DBG_MON_A6")
	),
	MTK_PIN(
		7, "GPIO7",
		MTK_EINT_FUNCTION(0, 7),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO7"),
		MTK_FUNCTION(1, "DPI_D7"),
		MTK_FUNCTION(3, "I2S1_DO"),
		MTK_FUNCTION(4, "EXT_RXDV"),
		MTK_FUNCTION(5, "CONN_DSP_JCK"),
		MTK_FUNCTION(7, "DBG_MON_A7")
	),
	MTK_PIN(
		8, "GPIO8",
		MTK_EINT_FUNCTION(0, 8),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO8"),
		MTK_FUNCTION(1, "DPI_D8"),
		MTK_FUNCTION(2, "SPI_CLK"),
		MTK_FUNCTION(3, "I2S0_BCK"),
		MTK_FUNCTION(4, "EXT_RXD0"),
		MTK_FUNCTION(5, "CONN_DSP_JINTP"),
		MTK_FUNCTION(7, "DBG_MON_A8")
	),
	MTK_PIN(
		9, "GPIO9",
		MTK_EINT_FUNCTION(0, 9),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO9"),
		MTK_FUNCTION(1, "DPI_D9"),
		MTK_FUNCTION(2, "SPI_CSB"),
		MTK_FUNCTION(3, "I2S0_LRCK"),
		MTK_FUNCTION(4, "EXT_RXD1"),
		MTK_FUNCTION(5, "CONN_DSP_JDI"),
		MTK_FUNCTION(7, "DBG_MON_A9")
	),
	MTK_PIN(
		10, "GPIO10",
		MTK_EINT_FUNCTION(0, 10),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO10"),
		MTK_FUNCTION(1, "DPI_D10"),
		MTK_FUNCTION(2, "SPI_MI"),
		MTK_FUNCTION(3, "I2S0_MCK"),
		MTK_FUNCTION(4, "EXT_RXD2"),
		MTK_FUNCTION(5, "CONN_DSP_JMS"),
		MTK_FUNCTION(7, "DBG_MON_A10")
	),
	MTK_PIN(
		11, "GPIO11",
		MTK_EINT_FUNCTION(0, 11),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO11"),
		MTK_FUNCTION(1, "DPI_D11"),
		MTK_FUNCTION(2, "SPI_MO"),
		MTK_FUNCTION(3, "I2S0_DI"),
		MTK_FUNCTION(4, "EXT_RXD3"),
		MTK_FUNCTION(5, "CONN_DSP_JDO"),
		MTK_FUNCTION(7, "DBG_MON_A11")
	),
	MTK_PIN(
		12, "GPIO12",
		MTK_EINT_FUNCTION(0, 12),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO12"),
		MTK_FUNCTION(1, "DPI_DE"),
		MTK_FUNCTION(2, "UCTS1"),
		MTK_FUNCTION(3, "I2S3_BCK"),
		MTK_FUNCTION(4, "EXT_TXEN"),
		MTK_FUNCTION(5, "O_WIFI_TXD"),
		MTK_FUNCTION(7, "DBG_MON_A12")
	),
	MTK_PIN(
		13, "GPIO13",
		MTK_EINT_FUNCTION(0, 13),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO13"),
		MTK_FUNCTION(1, "DPI_VSYNC"),
		MTK_FUNCTION(2, "URTS1"),
		MTK_FUNCTION(3, "I2S3_LRCK"),
		MTK_FUNCTION(4, "EXT_COL"),
		MTK_FUNCTION(5, "SPDIF_IN"),
		MTK_FUNCTION(7, "DBG_MON_A13")
	),
	MTK_PIN(
		14, "GPIO14",
		MTK_EINT_FUNCTION(0, 14),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO14"),
		MTK_FUNCTION(1, "DPI_CK"),
		MTK_FUNCTION(2, "UCTS2"),
		MTK_FUNCTION(3, "I2S3_MCK"),
		MTK_FUNCTION(4, "EXT_MDIO"),
		MTK_FUNCTION(5, "SPDIF_OUT"),
		MTK_FUNCTION(6, "DVFSRC_EXT_REQ"),
		MTK_FUNCTION(7, "DBG_MON_A14")
	),
	MTK_PIN(
		15, "GPIO15",
		MTK_EINT_FUNCTION(0, 15),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO15"),
		MTK_FUNCTION(1, "DPI_HSYNC"),
		MTK_FUNCTION(2, "URTS2"),
		MTK_FUNCTION(3, "I2S3_DO"),
		MTK_FUNCTION(4, "EXT_MDC"),
		MTK_FUNCTION(5, "IRRX"),
		MTK_FUNCTION(6, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(7, "DBG_MON_A15")
	),
	MTK_PIN(
		16, "GPIO16",
		MTK_EINT_FUNCTION(0, 16),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO16"),
		MTK_FUNCTION(1, "DPI_D12"),
		MTK_FUNCTION(2, "USB_DRVVBUS"),
		MTK_FUNCTION(3, "PWM_A"),
		MTK_FUNCTION(4, "CLKM0"),
		MTK_FUNCTION(5, "ANT_SEL0"),
		MTK_FUNCTION(6, "TSF_IN"),
		MTK_FUNCTION(7, "DBG_MON_A16")
	),
	MTK_PIN(
		17, "GPIO17",
		MTK_EINT_FUNCTION(0, 17),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO17"),
		MTK_FUNCTION(1, "DPI_D13"),
		MTK_FUNCTION(2, "IDDIG"),
		MTK_FUNCTION(3, "PWM_B"),
		MTK_FUNCTION(4, "CLKM1"),
		MTK_FUNCTION(5, "ANT_SEL1"),
		MTK_FUNCTION(6, "DVFSRC_EXT_REQ"),
		MTK_FUNCTION(7, "DBG_MON_A17")
	),
	MTK_PIN(
		18, "GPIO18",
		MTK_EINT_FUNCTION(0, 18),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO18"),
		MTK_FUNCTION(1, "DPI_D14"),
		MTK_FUNCTION(2, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(3, "PWM_C"),
		MTK_FUNCTION(4, "CLKM2"),
		MTK_FUNCTION(5, "ANT_SEL2"),
		MTK_FUNCTION(6, "MFG_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_A18")
	),
	MTK_PIN(
		19, "DISP_PWM",
		MTK_EINT_FUNCTION(0, 19),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO19"),
		MTK_FUNCTION(1, "DISP_PWM"),
		MTK_FUNCTION(2, "PWM_A"),
		MTK_FUNCTION(7, "DBG_MON_A19")
	),
	MTK_PIN(
		20, "LCM_RST",
		MTK_EINT_FUNCTION(0, 20),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO20"),
		MTK_FUNCTION(1, "LCM_RST"),
		MTK_FUNCTION(2, "PWM_B"),
		MTK_FUNCTION(7, "DBG_MON_A20")
	),
	MTK_PIN(
		21, "DSI_TE",
		MTK_EINT_FUNCTION(0, 21),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO21"),
		MTK_FUNCTION(1, "DSI_TE"),
		MTK_FUNCTION(2, "PWM_C"),
		MTK_FUNCTION(3, "ANT_SEL0"),
		MTK_FUNCTION(4, "DVFSRC_EXT_REQ"),
		MTK_FUNCTION(7, "DBG_MON_A21")
	),
	MTK_PIN(
		22, "KPROW0",
		MTK_EINT_FUNCTION(0, 22),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO22"),
		MTK_FUNCTION(1, "KPROW0"),
		MTK_FUNCTION(7, "DBG_MON_A22")
	),
	MTK_PIN(
		23, "KPROW1",
		MTK_EINT_FUNCTION(0, 23),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO23"),
		MTK_FUNCTION(1, "KPROW1"),
		MTK_FUNCTION(2, "IDDIG"),
		MTK_FUNCTION(3, "WIFI_TXD"),
		MTK_FUNCTION(4, "CLKM3"),
		MTK_FUNCTION(5, "ANT_SEL1"),
		MTK_FUNCTION(6, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(7, "DBG_MON_B0")
	),
	MTK_PIN(
		24, "KPCOL0",
		MTK_EINT_FUNCTION(0, 24),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO24"),
		MTK_FUNCTION(1, "KPCOL0"),
		MTK_FUNCTION(7, "DBG_MON_A23")
	),
	MTK_PIN(
		25, "KPCOL1",
		MTK_EINT_FUNCTION(0, 25),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO25"),
		MTK_FUNCTION(1, "KPCOL1"),
		MTK_FUNCTION(2, "USB_DRVVBUS"),
		MTK_FUNCTION(3, "APU_JTAG_TRST"),
		MTK_FUNCTION(4, "UDI_NTRST_XI"),
		MTK_FUNCTION(5, "DFD_NTRST_XI"),
		MTK_FUNCTION(6, "CONN_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_B1")
	),
	MTK_PIN(
		26, "SPI_CS",
		MTK_EINT_FUNCTION(0, 26),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO26"),
		MTK_FUNCTION(1, "SPI_CSB"),
		MTK_FUNCTION(3, "APU_JTAG_TMS"),
		MTK_FUNCTION(4, "UDI_TMS_XI"),
		MTK_FUNCTION(5, "DFD_TMS_XI"),
		MTK_FUNCTION(6, "CONN_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_A24")
	),
	MTK_PIN(
		27, "SPI_CK",
		MTK_EINT_FUNCTION(0, 27),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO27"),
		MTK_FUNCTION(1, "SPI_CLK"),
		MTK_FUNCTION(3, "APU_JTAG_TCK"),
		MTK_FUNCTION(4, "UDI_TCK_XI"),
		MTK_FUNCTION(5, "DFD_TCK_XI"),
		MTK_FUNCTION(6, "APU_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_A25")
	),
	MTK_PIN(
		28, "SPI_MI",
		MTK_EINT_FUNCTION(0, 28),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO28"),
		MTK_FUNCTION(1, "SPI_MI"),
		MTK_FUNCTION(2, "SPI_MO"),
		MTK_FUNCTION(3, "APU_JTAG_TDI"),
		MTK_FUNCTION(4, "UDI_TDI_XI"),
		MTK_FUNCTION(5, "DFD_TDI_XI"),
		MTK_FUNCTION(6, "DSP_TEST_CK"),
		MTK_FUNCTION(7, "DBG_MON_A26")
	),
	MTK_PIN(
		29, "SPI_MO",
		MTK_EINT_FUNCTION(0, 29),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO29"),
		MTK_FUNCTION(1, "SPI_MO"),
		MTK_FUNCTION(2, "SPI_MI"),
		MTK_FUNCTION(3, "APU_JTAG_TDO"),
		MTK_FUNCTION(4, "UDI_TDO"),
		MTK_FUNCTION(5, "DFD_TDO"),
		MTK_FUNCTION(6, "DVFSRC_EXT_REQ"),
		MTK_FUNCTION(7, "DBG_MON_A27")
	),
	MTK_PIN(
		30, "JTMS",
		MTK_EINT_FUNCTION(0, 30),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO30"),
		MTK_FUNCTION(1, "JTMS"),
		MTK_FUNCTION(2, "DFD_TMS_XI"),
		MTK_FUNCTION(3, "UDI_TMS_XI"),
		MTK_FUNCTION(4, "MCU_SPM_TMS"),
		MTK_FUNCTION(5, "CONN_MCU_TMS"),
		MTK_FUNCTION(6, "CONN_MCU_AICE_TMSC")
	),
	MTK_PIN(
		31, "JTCK",
		MTK_EINT_FUNCTION(0, 31),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO31"),
		MTK_FUNCTION(1, "JTCK"),
		MTK_FUNCTION(2, "DFD_TCK_XI"),
		MTK_FUNCTION(3, "UDI_TCK_XI"),
		MTK_FUNCTION(4, "MCU_SPM_TCK"),
		MTK_FUNCTION(5, "CONN_MCU_TCK"),
		MTK_FUNCTION(6, "CONN_MCU_AICE_TCKC")
	),
	MTK_PIN(
		32, "JTDI",
		MTK_EINT_FUNCTION(0, 32),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO32"),
		MTK_FUNCTION(1, "JTDI"),
		MTK_FUNCTION(2, "DFD_TDI_XI"),
		MTK_FUNCTION(3, "UDI_TDI_XI"),
		MTK_FUNCTION(4, "MCU_SPM_TDI"),
		MTK_FUNCTION(5, "CONN_MCU_TDI")
	),
	MTK_PIN(
		33, "JTDO",
		MTK_EINT_FUNCTION(0, 33),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO33"),
		MTK_FUNCTION(1, "JTDO"),
		MTK_FUNCTION(2, "DFD_TDO"),
		MTK_FUNCTION(3, "UDI_TDO"),
		MTK_FUNCTION(4, "MCU_SPM_TDO"),
		MTK_FUNCTION(5, "CONN_MCU_TDO")
	),
	MTK_PIN(
		34, "JTRST",
		MTK_EINT_FUNCTION(0, 34),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO34"),
		MTK_FUNCTION(1, "JTRST"),
		MTK_FUNCTION(2, "DFD_NTRST_XI"),
		MTK_FUNCTION(3, "UDI_NTRST_XI"),
		MTK_FUNCTION(4, "MCU_SPM_NTRST"),
		MTK_FUNCTION(5, "CONN_MCU_TRST_B")
	),
	MTK_PIN(
		35, "URXD0",
		MTK_EINT_FUNCTION(0, 35),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO35"),
		MTK_FUNCTION(1, "URXD0"),
		MTK_FUNCTION(2, "UTXD0"),
		MTK_FUNCTION(7, "DSP_URXD0")
	),
	MTK_PIN(
		36, "UTXD0",
		MTK_EINT_FUNCTION(0, 36),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO36"),
		MTK_FUNCTION(1, "UTXD0"),
		MTK_FUNCTION(2, "URXD0"),
		MTK_FUNCTION(7, "DSP_UTXD0")
	),
	MTK_PIN(
		37, "URXD1",
		MTK_EINT_FUNCTION(0, 37),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO37"),
		MTK_FUNCTION(1, "URXD1"),
		MTK_FUNCTION(2, "UTXD1"),
		MTK_FUNCTION(3, "UCTS2"),
		MTK_FUNCTION(4, "DVFSRC_EXT_REQ"),
		MTK_FUNCTION(5, "CONN_UART0_RXD"),
		MTK_FUNCTION(6, "I2S0_MCK"),
		MTK_FUNCTION(7, "DSP_URXD0")
	),
	MTK_PIN(
		38, "UTXD1",
		MTK_EINT_FUNCTION(0, 38),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO38"),
		MTK_FUNCTION(1, "UTXD1"),
		MTK_FUNCTION(2, "URXD1"),
		MTK_FUNCTION(3, "URTS2"),
		MTK_FUNCTION(4, "ANT_SEL2"),
		MTK_FUNCTION(5, "CONN_UART0_TXD"),
		MTK_FUNCTION(6, "I2S1_MCK"),
		MTK_FUNCTION(7, "DSP_UTXD0")
	),
	MTK_PIN(
		39, "URXD2",
		MTK_EINT_FUNCTION(0, 39),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO39"),
		MTK_FUNCTION(1, "URXD2"),
		MTK_FUNCTION(2, "UTXD2"),
		MTK_FUNCTION(3, "UCTS1"),
		MTK_FUNCTION(4, "IDDIG"),
		MTK_FUNCTION(5, "CONN_MCU_DBGACK_N"),
		MTK_FUNCTION(6, "I2S2_MCK"),
		MTK_FUNCTION(7, "DSP_URXD0")
	),
	MTK_PIN(
		40, "UTXD2",
		MTK_EINT_FUNCTION(0, 40),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO40"),
		MTK_FUNCTION(1, "UTXD2"),
		MTK_FUNCTION(2, "URXD2"),
		MTK_FUNCTION(3, "URTS1"),
		MTK_FUNCTION(4, "USB_DRVVBUS"),
		MTK_FUNCTION(5, "CONN_MCU_DBGI_N"),
		MTK_FUNCTION(6, "I2S3_MCK"),
		MTK_FUNCTION(7, "DSP_UTXD0")
	),
	MTK_PIN(
		41, "PWRAP_SPI0_MI",
		MTK_EINT_FUNCTION(0, 41),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO41"),
		MTK_FUNCTION(1, "PWRAP_SPI0_MI"),
		MTK_FUNCTION(2, "PWRAP_SPI0_MO")
	),
	MTK_PIN(
		42, "PWRAP_SPI0_MO",
		MTK_EINT_FUNCTION(0, 42),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO42"),
		MTK_FUNCTION(1, "PWRAP_SPI0_MO"),
		MTK_FUNCTION(2, "PWRAP_SPI0_MI")
	),
	MTK_PIN(
		43, "PWRAP_SPI0_CK",
		MTK_EINT_FUNCTION(0, 43),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO43"),
		MTK_FUNCTION(1, "PWRAP_SPI0_CK")
	),
	MTK_PIN(
		44, "PWRAP_SPI0_CSN",
		MTK_EINT_FUNCTION(0, 44),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO44"),
		MTK_FUNCTION(1, "PWRAP_SPI0_CSN")
	),
	MTK_PIN(
		45, "RTC32K_CK",
		MTK_EINT_FUNCTION(0, 45),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO45"),
		MTK_FUNCTION(1, "RTC32K_CK")
	),
	MTK_PIN(
		46, "WATCHDOG",
		MTK_EINT_FUNCTION(0, 46),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO46"),
		MTK_FUNCTION(1, "WATCHDOG")
	),
	MTK_PIN(
		47, "SRCLKENA0",
		MTK_EINT_FUNCTION(0, 47),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO47"),
		MTK_FUNCTION(1, "SRCLKENA0"),
		MTK_FUNCTION(2, "SRCLKENA1")
	),
	MTK_PIN(
		48, "SRCLKENA1",
		MTK_EINT_FUNCTION(0, 48),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO48"),
		MTK_FUNCTION(1, "SRCLKENA1")
	),
	MTK_PIN(
		49, "AUD_CLK_MOSI",
		MTK_EINT_FUNCTION(0, 49),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO49"),
		MTK_FUNCTION(1, "AUD_CLK_MOSI"),
		MTK_FUNCTION(2, "AUD_CLK_MISO"),
		MTK_FUNCTION(3, "I2S1_MCK")
	),
	MTK_PIN(
		50, "AUD_SYNC_MOSI",
		MTK_EINT_FUNCTION(0, 50),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO50"),
		MTK_FUNCTION(1, "AUD_SYNC_MOSI"),
		MTK_FUNCTION(2, "AUD_SYNC_MISO"),
		MTK_FUNCTION(3, "I2S1_BCK")
	),
	MTK_PIN(
		51, "AUD_DAT_MOSI0",
		MTK_EINT_FUNCTION(0, 51),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO51"),
		MTK_FUNCTION(1, "AUD_DAT_MOSI0"),
		MTK_FUNCTION(2, "AUD_DAT_MISO0"),
		MTK_FUNCTION(3, "I2S1_LRCK")
	),
	MTK_PIN(
		52, "AUD_DAT_MOSI1",
		MTK_EINT_FUNCTION(0, 52),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO52"),
		MTK_FUNCTION(1, "AUD_DAT_MOSI1"),
		MTK_FUNCTION(2, "AUD_DAT_MISO1"),
		MTK_FUNCTION(3, "I2S1_DO")
	),
	MTK_PIN(
		53, "AUD_CLK_MISO",
		MTK_EINT_FUNCTION(0, 53),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO53"),
		MTK_FUNCTION(1, "AUD_CLK_MISO"),
		MTK_FUNCTION(2, "AUD_CLK_MOSI"),
		MTK_FUNCTION(3, "I2S2_MCK")
	),
	MTK_PIN(
		54, "AUD_SYNC_MISO",
		MTK_EINT_FUNCTION(0, 54),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO54"),
		MTK_FUNCTION(1, "AUD_SYNC_MISO"),
		MTK_FUNCTION(2, "AUD_SYNC_MOSI"),
		MTK_FUNCTION(3, "I2S2_BCK")
	),
	MTK_PIN(
		55, "AUD_DAT_MISO0",
		MTK_EINT_FUNCTION(0, 55),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO55"),
		MTK_FUNCTION(1, "AUD_DAT_MISO0"),
		MTK_FUNCTION(2, "AUD_DAT_MOSI0"),
		MTK_FUNCTION(3, "I2S2_LRCK")
	),
	MTK_PIN(
		56, "AUD_DAT_MISO1",
		MTK_EINT_FUNCTION(0, 56),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO56"),
		MTK_FUNCTION(1, "AUD_DAT_MISO1"),
		MTK_FUNCTION(2, "AUD_DAT_MOSI1"),
		MTK_FUNCTION(3, "I2S2_DI")
	),
	MTK_PIN(
		57, "SDA0",
		MTK_EINT_FUNCTION(0, 57),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO57"),
		MTK_FUNCTION(1, "SDA0_0")
	),
	MTK_PIN(
		58, "SCL0",
		MTK_EINT_FUNCTION(0, 58),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO58"),
		MTK_FUNCTION(1, "SCL0_0")
	),
	MTK_PIN(
		59, "SDA1",
		MTK_EINT_FUNCTION(0, 59),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO59"),
		MTK_FUNCTION(1, "SDA1_0"),
		MTK_FUNCTION(6, "USB_SDA"),
		MTK_FUNCTION(7, "DBG_SDA")
	),
	MTK_PIN(
		60, "SCL1",
		MTK_EINT_FUNCTION(0, 60),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO60"),
		MTK_FUNCTION(1, "SCL1_0"),
		MTK_FUNCTION(6, "USB_SCL"),
		MTK_FUNCTION(7, "DBG_SCL")
	),
	MTK_PIN(
		61, "SDA2",
		MTK_EINT_FUNCTION(0, 61),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO61"),
		MTK_FUNCTION(1, "SDA2_0")
	),
	MTK_PIN(
		62, "SCL2",
		MTK_EINT_FUNCTION(0, 62),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO62"),
		MTK_FUNCTION(1, "SCL2_0")
	),
	MTK_PIN(
		63, "SDA3",
		MTK_EINT_FUNCTION(0, 63),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO63"),
		MTK_FUNCTION(1, "SDA3_0")
	),
	MTK_PIN(
		64, "SCL3",
		MTK_EINT_FUNCTION(0, 64),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO64"),
		MTK_FUNCTION(1, "SCL3_0")
	),
	MTK_PIN(
		65, "CMMCLK0",
		MTK_EINT_FUNCTION(0, 65),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO65"),
		MTK_FUNCTION(1, "CMMCLK0"),
		MTK_FUNCTION(2, "CMMCLK1"),
		MTK_FUNCTION(7, "DBG_MON_A28")
	),
	MTK_PIN(
		66, "CMMCLK1",
		MTK_EINT_FUNCTION(0, 66),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO66"),
		MTK_FUNCTION(1, "CMMCLK1"),
		MTK_FUNCTION(2, "CMMCLK0"),
		MTK_FUNCTION(7, "DBG_MON_B2")
	),
	MTK_PIN(
		67, "CMPCLK",
		MTK_EINT_FUNCTION(0, 67),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO67"),
		MTK_FUNCTION(1, "CMPCLK"),
		MTK_FUNCTION(2, "ANT_SEL0"),
		MTK_FUNCTION(4, "TDM_RX_BCK"),
		MTK_FUNCTION(5, "I2S0_BCK"),
		MTK_FUNCTION(7, "DBG_MON_B3")
	),
	MTK_PIN(
		68, "CMDAT0",
		MTK_EINT_FUNCTION(0, 68),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO68"),
		MTK_FUNCTION(1, "CMDAT0"),
		MTK_FUNCTION(2, "ANT_SEL1"),
		MTK_FUNCTION(4, "TDM_RX_LRCK"),
		MTK_FUNCTION(5, "I2S0_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_B4")
	),
	MTK_PIN(
		69, "CMDAT1",
		MTK_EINT_FUNCTION(0, 69),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO69"),
		MTK_FUNCTION(1, "CMDAT1"),
		MTK_FUNCTION(2, "ANT_SEL2"),
		MTK_FUNCTION(3, "DVFSRC_EXT_REQ"),
		MTK_FUNCTION(4, "TDM_RX_MCK"),
		MTK_FUNCTION(5, "I2S0_MCK"),
		MTK_FUNCTION(7, "DBG_MON_B5")
	),
	MTK_PIN(
		70, "CMDAT2",
		MTK_EINT_FUNCTION(0, 70),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO70"),
		MTK_FUNCTION(1, "CMDAT2"),
		MTK_FUNCTION(2, "ANT_SEL3"),
		MTK_FUNCTION(4, "TDM_RX_DI"),
		MTK_FUNCTION(5, "I2S0_DI"),
		MTK_FUNCTION(7, "DBG_MON_B6")
	),
	MTK_PIN(
		71, "CMDAT3",
		MTK_EINT_FUNCTION(0, 71),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO71"),
		MTK_FUNCTION(1, "CMDAT3"),
		MTK_FUNCTION(2, "ANT_SEL4"),
		MTK_FUNCTION(7, "DBG_MON_B7")
	),
	MTK_PIN(
		72, "CMDAT4",
		MTK_EINT_FUNCTION(0, 72),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO72"),
		MTK_FUNCTION(1, "CMDAT4"),
		MTK_FUNCTION(2, "ANT_SEL5"),
		MTK_FUNCTION(5, "I2S3_BCK"),
		MTK_FUNCTION(7, "DBG_MON_B8")
	),
	MTK_PIN(
		73, "CMDAT5",
		MTK_EINT_FUNCTION(0, 73),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO73"),
		MTK_FUNCTION(1, "CMDAT5"),
		MTK_FUNCTION(2, "ANT_SEL6"),
		MTK_FUNCTION(5, "I2S3_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_B9")
	),
	MTK_PIN(
		74, "CMDAT6",
		MTK_EINT_FUNCTION(0, 74),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO74"),
		MTK_FUNCTION(1, "CMDAT6"),
		MTK_FUNCTION(2, "ANT_SEL7"),
		MTK_FUNCTION(5, "I2S3_MCK"),
		MTK_FUNCTION(7, "DBG_MON_B10")
	),
	MTK_PIN(
		75, "CMDAT7",
		MTK_EINT_FUNCTION(0, 75),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO75"),
		MTK_FUNCTION(1, "CMDAT7"),
		MTK_FUNCTION(5, "I2S3_DO"),
		MTK_FUNCTION(7, "DBG_MON_B11")
	),
	MTK_PIN(
		76, "CMDAT8",
		MTK_EINT_FUNCTION(0, 76),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO76"),
		MTK_FUNCTION(1, "CMDAT8"),
		MTK_FUNCTION(5, "PCM_CLK"),
		MTK_FUNCTION(7, "DBG_MON_A29")
	),
	MTK_PIN(
		77, "CMDAT9",
		MTK_EINT_FUNCTION(0, 77),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO77"),
		MTK_FUNCTION(1, "CMDAT9"),
		MTK_FUNCTION(5, "PCM_SYNC"),
		MTK_FUNCTION(7, "DBG_MON_A30")
	),
	MTK_PIN(
		78, "CMHSYNC",
		MTK_EINT_FUNCTION(0, 78),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO78"),
		MTK_FUNCTION(1, "CMHSYNC"),
		MTK_FUNCTION(5, "PCM_RX"),
		MTK_FUNCTION(7, "DBG_MON_A31")
	),
	MTK_PIN(
		79, "CMVSYNC",
		MTK_EINT_FUNCTION(0, 79),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO79"),
		MTK_FUNCTION(1, "CMVSYNC"),
		MTK_FUNCTION(5, "PCM_TX"),
		MTK_FUNCTION(7, "DBG_MON_A32")
	),
	MTK_PIN(
		80, "MSDC2_CMD",
		MTK_EINT_FUNCTION(0, 80),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO80"),
		MTK_FUNCTION(1, "MSDC2_CMD"),
		MTK_FUNCTION(2, "TDM_TX_LRCK"),
		MTK_FUNCTION(3, "UTXD1"),
		MTK_FUNCTION(4, "DPI_D19"),
		MTK_FUNCTION(5, "UDI_TMS_XI"),
		MTK_FUNCTION(6, "ADSP_JTAG_TMS")
	),
	MTK_PIN(
		81, "MSDC2_CLK",
		MTK_EINT_FUNCTION(0, 81),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO81"),
		MTK_FUNCTION(1, "MSDC2_CLK"),
		MTK_FUNCTION(2, "TDM_TX_BCK"),
		MTK_FUNCTION(3, "URXD1"),
		MTK_FUNCTION(4, "DPI_D20"),
		MTK_FUNCTION(5, "UDI_TCK_XI"),
		MTK_FUNCTION(6, "ADSP_JTAG_TCK")
	),
	MTK_PIN(
		82, "MSDC2_DAT0",
		MTK_EINT_FUNCTION(0, 82),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO82"),
		MTK_FUNCTION(1, "MSDC2_DAT0"),
		MTK_FUNCTION(2, "TDM_TX_DATA0"),
		MTK_FUNCTION(3, "UTXD2"),
		MTK_FUNCTION(4, "DPI_D21"),
		MTK_FUNCTION(5, "UDI_TDI_XI"),
		MTK_FUNCTION(6, "ADSP_JTAG_TDI")
	),
	MTK_PIN(
		83, "MSDC2_DAT1",
		MTK_EINT_FUNCTION(0, 83),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO83"),
		MTK_FUNCTION(1, "MSDC2_DAT1"),
		MTK_FUNCTION(2, "TDM_TX_DATA1"),
		MTK_FUNCTION(3, "URXD2"),
		MTK_FUNCTION(4, "DPI_D22"),
		MTK_FUNCTION(5, "UDI_TDO"),
		MTK_FUNCTION(6, "ADSP_JTAG_TDO")
	),
	MTK_PIN(
		84, "MSDC2_DAT2",
		MTK_EINT_FUNCTION(0, 84),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO84"),
		MTK_FUNCTION(1, "MSDC2_DAT2"),
		MTK_FUNCTION(2, "TDM_TX_DATA2"),
		MTK_FUNCTION(3, "PWM_A"),
		MTK_FUNCTION(4, "DPI_D23"),
		MTK_FUNCTION(5, "UDI_NTRST_XI"),
		MTK_FUNCTION(6, "ADSP_JTAG_TRST")
	),
	MTK_PIN(
		85, "MSDC2_DAT3",
		MTK_EINT_FUNCTION(0, 85),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO85"),
		MTK_FUNCTION(1, "MSDC2_DAT3"),
		MTK_FUNCTION(2, "TDM_TX_DATA3"),
		MTK_FUNCTION(3, "PWM_B"),
		MTK_FUNCTION(5, "EXT_FRAME_SYNC")
	),
	MTK_PIN(
		86, "MSDC2_DSL",
		MTK_EINT_FUNCTION(0, 86),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO86"),
		MTK_FUNCTION(1, "MSDC2_DSL"),
		MTK_FUNCTION(2, "TDM_TX_MCK"),
		MTK_FUNCTION(3, "PWM_C")
	),
	MTK_PIN(
		87, "MSDC1_CMD",
		MTK_EINT_FUNCTION(0, 87),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO87"),
		MTK_FUNCTION(1, "MSDC1_CMD"),
		MTK_FUNCTION(2, "CONN_MCU_AICE_TMSC"),
		MTK_FUNCTION(3, "DFD_TMS_XI"),
		MTK_FUNCTION(4, "APU_JTAG_TMS"),
		MTK_FUNCTION(5, "MCU_SPM_TMS"),
		MTK_FUNCTION(6, "CONN_DSP_JMS"),
		MTK_FUNCTION(7, "ADSP_JTAG_TMS")
	),
	MTK_PIN(
		88, "MSDC1_CLK",
		MTK_EINT_FUNCTION(0, 88),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO88"),
		MTK_FUNCTION(1, "MSDC1_CLK"),
		MTK_FUNCTION(2, "CONN_MCU_AICE_TCKC"),
		MTK_FUNCTION(3, "DFD_TCK_XI"),
		MTK_FUNCTION(4, "APU_JTAG_TCK"),
		MTK_FUNCTION(5, "MCU_SPM_TCK"),
		MTK_FUNCTION(6, "CONN_DSP_JCK"),
		MTK_FUNCTION(7, "ADSP_JTAG_TCK")
	),
	MTK_PIN(
		89, "MSDC1_DAT0",
		MTK_EINT_FUNCTION(0, 89),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO89"),
		MTK_FUNCTION(1, "MSDC1_DAT0"),
		MTK_FUNCTION(2, "PWM_C"),
		MTK_FUNCTION(3, "DFD_TDI_XI"),
		MTK_FUNCTION(4, "APU_JTAG_TDI"),
		MTK_FUNCTION(5, "MCU_SPM_TDI"),
		MTK_FUNCTION(6, "CONN_DSP_JDI"),
		MTK_FUNCTION(7, "ADSP_JTAG_TDI")
	),
	MTK_PIN(
		90, "MSDC1_DAT1",
		MTK_EINT_FUNCTION(0, 90),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO90"),
		MTK_FUNCTION(1, "MSDC1_DAT1"),
		MTK_FUNCTION(2, "SPDIF_IN"),
		MTK_FUNCTION(3, "DFD_TDO"),
		MTK_FUNCTION(4, "APU_JTAG_TDO"),
		MTK_FUNCTION(5, "MCU_SPM_TDO"),
		MTK_FUNCTION(6, "CONN_DSP_JDO"),
		MTK_FUNCTION(7, "ADSP_JTAG_TDO")
	),
	MTK_PIN(
		91, "MSDC1_DAT2",
		MTK_EINT_FUNCTION(0, 91),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO91"),
		MTK_FUNCTION(1, "MSDC1_DAT2"),
		MTK_FUNCTION(2, "SPDIF_OUT"),
		MTK_FUNCTION(3, "DFD_NTRST_XI"),
		MTK_FUNCTION(4, "APU_JTAG_TRST"),
		MTK_FUNCTION(5, "MCU_SPM_NTRST"),
		MTK_FUNCTION(6, "CONN_DSP_JINTP"),
		MTK_FUNCTION(7, "ADSP_JTAG_TRST")
	),
	MTK_PIN(
		92, "MSDC1_DAT3",
		MTK_EINT_FUNCTION(0, 92),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO92"),
		MTK_FUNCTION(1, "MSDC1_DAT3"),
		MTK_FUNCTION(2, "IRRX"),
		MTK_FUNCTION(3, "PWM_A")
	),
	MTK_PIN(
		93, "MSDC0_DAT7",
		MTK_EINT_FUNCTION(0, 93),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO93"),
		MTK_FUNCTION(1, "MSDC0_DAT7"),
		MTK_FUNCTION(2, "NLD7")
	),
	MTK_PIN(
		94, "MSDC0_DAT6",
		MTK_EINT_FUNCTION(0, 94),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO94"),
		MTK_FUNCTION(1, "MSDC0_DAT6"),
		MTK_FUNCTION(2, "NLD6")
	),
	MTK_PIN(
		95, "MSDC0_DAT5",
		MTK_EINT_FUNCTION(0, 95),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO95"),
		MTK_FUNCTION(1, "MSDC0_DAT5"),
		MTK_FUNCTION(2, "NLD4")
	),
	MTK_PIN(
		96, "MSDC0_DAT4",
		MTK_EINT_FUNCTION(0, 96),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO96"),
		MTK_FUNCTION(1, "MSDC0_DAT4"),
		MTK_FUNCTION(2, "NLD3")
	),
	MTK_PIN(
		97, "MSDC0_RSTB",
		MTK_EINT_FUNCTION(0, 97),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO97"),
		MTK_FUNCTION(1, "MSDC0_RSTB"),
		MTK_FUNCTION(2, "NLD0")
	),
	MTK_PIN(
		98, "MSDC0_CMD",
		MTK_EINT_FUNCTION(0, 98),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO98"),
		MTK_FUNCTION(1, "MSDC0_CMD"),
		MTK_FUNCTION(2, "NALE")
	),
	MTK_PIN(
		99, "MSDC0_CLK",
		MTK_EINT_FUNCTION(0, 99),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO99"),
		MTK_FUNCTION(1, "MSDC0_CLK"),
		MTK_FUNCTION(2, "NWEB")
	),
	MTK_PIN(
		100, "MSDC0_DAT3",
		MTK_EINT_FUNCTION(0, 100),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO100"),
		MTK_FUNCTION(1, "MSDC0_DAT3"),
		MTK_FUNCTION(2, "NLD1")
	),
	MTK_PIN(
		101, "MSDC0_DAT2",
		MTK_EINT_FUNCTION(0, 101),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO101"),
		MTK_FUNCTION(1, "MSDC0_DAT2"),
		MTK_FUNCTION(2, "NLD5")
	),
	MTK_PIN(
		102, "MSDC0_DAT1",
		MTK_EINT_FUNCTION(0, 102),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO102"),
		MTK_FUNCTION(1, "MSDC0_DAT1"),
		MTK_FUNCTION(2, "NDQS")
	),
	MTK_PIN(
		103, "MSDC0_DAT0",
		MTK_EINT_FUNCTION(0, 103),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO103"),
		MTK_FUNCTION(1, "MSDC0_DAT0"),
		MTK_FUNCTION(2, "NLD2")
	),
	MTK_PIN(
		104, "MSDC0_DSL",
		MTK_EINT_FUNCTION(0, 104),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO104"),
		MTK_FUNCTION(1, "MSDC0_DSL")
	),
	MTK_PIN(
		105, "NCLE",
		MTK_EINT_FUNCTION(0, 105),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO105"),
		MTK_FUNCTION(1, "NCLE"),
		MTK_FUNCTION(2, "TDM_RX_MCK"),
		MTK_FUNCTION(7, "DBG_MON_B12")
	),
	MTK_PIN(
		106, "NCEB1",
		MTK_EINT_FUNCTION(0, 106),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO106"),
		MTK_FUNCTION(1, "NCEB1"),
		MTK_FUNCTION(2, "TDM_RX_BCK"),
		MTK_FUNCTION(7, "DBG_MON_B13")
	),
	MTK_PIN(
		107, "NCEB0",
		MTK_EINT_FUNCTION(0, 107),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO107"),
		MTK_FUNCTION(1, "NCEB0"),
		MTK_FUNCTION(2, "TDM_RX_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_B14")
	),
	MTK_PIN(
		108, "NREB",
		MTK_EINT_FUNCTION(0, 108),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO108"),
		MTK_FUNCTION(1, "NREB"),
		MTK_FUNCTION(2, "TDM_RX_DI"),
		MTK_FUNCTION(7, "DBG_MON_B15")
	),
	MTK_PIN(
		109, "NRNB",
		MTK_EINT_FUNCTION(0, 109),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO109"),
		MTK_FUNCTION(1, "NRNB"),
		MTK_FUNCTION(2, "TSF_IN"),
		MTK_FUNCTION(7, "DBG_MON_B16")
	),
	MTK_PIN(
		110, "PCM_CLK",
		MTK_EINT_FUNCTION(0, 110),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO110"),
		MTK_FUNCTION(1, "PCM_CLK"),
		MTK_FUNCTION(2, "I2S0_BCK"),
		MTK_FUNCTION(3, "I2S3_BCK"),
		MTK_FUNCTION(4, "SPDIF_IN"),
		MTK_FUNCTION(5, "DPI_D15")
	),
	MTK_PIN(
		111, "PCM_SYNC",
		MTK_EINT_FUNCTION(0, 111),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO111"),
		MTK_FUNCTION(1, "PCM_SYNC"),
		MTK_FUNCTION(2, "I2S0_LRCK"),
		MTK_FUNCTION(3, "I2S3_LRCK"),
		MTK_FUNCTION(4, "SPDIF_OUT"),
		MTK_FUNCTION(5, "DPI_D16")
	),
	MTK_PIN(
		112, "PCM_RX",
		MTK_EINT_FUNCTION(0, 112),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO112"),
		MTK_FUNCTION(1, "PCM_RX"),
		MTK_FUNCTION(2, "I2S0_DI"),
		MTK_FUNCTION(3, "I2S3_MCK"),
		MTK_FUNCTION(4, "IRRX"),
		MTK_FUNCTION(5, "DPI_D17")
	),
	MTK_PIN(
		113, "PCM_TX",
		MTK_EINT_FUNCTION(0, 113),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO113"),
		MTK_FUNCTION(1, "PCM_TX"),
		MTK_FUNCTION(2, "I2S0_MCK"),
		MTK_FUNCTION(3, "I2S3_DO"),
		MTK_FUNCTION(4, "PWM_B"),
		MTK_FUNCTION(5, "DPI_D18")
	),
	MTK_PIN(
		114, "I2S_DATA_IN",
		MTK_EINT_FUNCTION(0, 114),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO114"),
		MTK_FUNCTION(1, "I2S0_DI"),
		MTK_FUNCTION(2, "I2S1_DO"),
		MTK_FUNCTION(3, "I2S2_DI"),
		MTK_FUNCTION(4, "I2S3_DO"),
		MTK_FUNCTION(5, "PWM_A"),
		MTK_FUNCTION(6, "SPDIF_IN"),
		MTK_FUNCTION(7, "DBG_MON_B17")
	),
	MTK_PIN(
		115, "I2S_LRCK",
		MTK_EINT_FUNCTION(0, 115),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO115"),
		MTK_FUNCTION(1, "I2S0_LRCK"),
		MTK_FUNCTION(2, "I2S1_LRCK"),
		MTK_FUNCTION(3, "I2S2_LRCK"),
		MTK_FUNCTION(4, "I2S3_LRCK"),
		MTK_FUNCTION(5, "PWM_B"),
		MTK_FUNCTION(6, "SPDIF_OUT"),
		MTK_FUNCTION(7, "DBG_MON_B18")
	),
	MTK_PIN(
		116, "I2S_BCK",
		MTK_EINT_FUNCTION(0, 116),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO116"),
		MTK_FUNCTION(1, "I2S0_BCK"),
		MTK_FUNCTION(2, "I2S1_BCK"),
		MTK_FUNCTION(3, "I2S2_BCK"),
		MTK_FUNCTION(4, "I2S3_BCK"),
		MTK_FUNCTION(5, "PWM_C"),
		MTK_FUNCTION(6, "IRRX"),
		MTK_FUNCTION(7, "DBG_MON_B19")
	),
	MTK_PIN(
		117, "DMIC0_CLK",
		MTK_EINT_FUNCTION(0, 117),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO117"),
		MTK_FUNCTION(1, "DMIC0_CLK"),
		MTK_FUNCTION(2, "I2S2_BCK"),
		MTK_FUNCTION(7, "DBG_MON_B20")
	),
	MTK_PIN(
		118, "DMIC0_DAT0",
		MTK_EINT_FUNCTION(0, 118),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO118"),
		MTK_FUNCTION(1, "DMIC0_DAT0"),
		MTK_FUNCTION(2, "I2S2_DI"),
		MTK_FUNCTION(7, "DBG_MON_B21")
	),
	MTK_PIN(
		119, "DMIC0_DAT1",
		MTK_EINT_FUNCTION(0, 119),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO119"),
		MTK_FUNCTION(1, "DMIC0_DAT1"),
		MTK_FUNCTION(2, "I2S2_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_B22")
	),
	MTK_PIN(
		120, "DMIC1_CLK",
		MTK_EINT_FUNCTION(0, 120),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO120"),
		MTK_FUNCTION(1, "DMIC1_CLK"),
		MTK_FUNCTION(2, "I2S2_MCK"),
		MTK_FUNCTION(7, "DBG_MON_B23")
	),
	MTK_PIN(
		121, "DMIC1_DAT0",
		MTK_EINT_FUNCTION(0, 121),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO121"),
		MTK_FUNCTION(1, "DMIC1_DAT0"),
		MTK_FUNCTION(2, "I2S1_BCK"),
		MTK_FUNCTION(7, "DBG_MON_B24")
	),
	MTK_PIN(
		122, "DMIC1_DAT1",
		MTK_EINT_FUNCTION(0, 122),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO122"),
		MTK_FUNCTION(1, "DMIC1_DAT1"),
		MTK_FUNCTION(2, "I2S1_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_B25")
	),
	MTK_PIN(
		123, "DMIC2_CLK",
		MTK_EINT_FUNCTION(0, 123),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO123"),
		MTK_FUNCTION(1, "DMIC2_CLK"),
		MTK_FUNCTION(2, "I2S1_MCK"),
		MTK_FUNCTION(7, "DBG_MON_B26")
	),
	MTK_PIN(
		124, "DMIC2_DAT0",
		MTK_EINT_FUNCTION(0, 124),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO124"),
		MTK_FUNCTION(1, "DMIC2_DAT0"),
		MTK_FUNCTION(2, "I2S1_DO"),
		MTK_FUNCTION(7, "DBG_MON_B27")
	),
	MTK_PIN(
		125, "DMIC2_DAT1",
		MTK_EINT_FUNCTION(0, 125),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO125"),
		MTK_FUNCTION(1, "DMIC2_DAT1"),
		MTK_FUNCTION(2, "TDM_RX_BCK"),
		MTK_FUNCTION(7, "DBG_MON_B28")
	),
	MTK_PIN(
		126, "DMIC3_CLK",
		MTK_EINT_FUNCTION(0, 126),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO126"),
		MTK_FUNCTION(1, "DMIC3_CLK"),
		MTK_FUNCTION(2, "TDM_RX_LRCK")
	),
	MTK_PIN(
		127, "DMIC3_DAT0",
		MTK_EINT_FUNCTION(0, 127),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO127"),
		MTK_FUNCTION(1, "DMIC3_DAT0"),
		MTK_FUNCTION(2, "TDM_RX_DI")
	),
	MTK_PIN(
		128, "DMIC3_DAT1",
		MTK_EINT_FUNCTION(0, 128),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO128"),
		MTK_FUNCTION(1, "DMIC3_DAT1"),
		MTK_FUNCTION(2, "TDM_RX_MCK"),
		MTK_FUNCTION(3, "VAD_CLK")
	),
	MTK_PIN(
		129, "TDM_TX_BCK",
		MTK_EINT_FUNCTION(0, 129),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO129"),
		MTK_FUNCTION(1, "TDM_TX_BCK"),
		MTK_FUNCTION(2, "I2S3_BCK"),
		MTK_FUNCTION(3, "ckmon1_ck")
	),
	MTK_PIN(
		130, "TDM_TX_LRCK",
		MTK_EINT_FUNCTION(0, 130),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO130"),
		MTK_FUNCTION(1, "TDM_TX_LRCK"),
		MTK_FUNCTION(2, "I2S3_LRCK"),
		MTK_FUNCTION(3, "ckmon2_ck")
	),
	MTK_PIN(
		131, "TDM_TX_MCK",
		MTK_EINT_FUNCTION(0, 131),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO131"),
		MTK_FUNCTION(1, "TDM_TX_MCK"),
		MTK_FUNCTION(2, "I2S3_MCK"),
		MTK_FUNCTION(3, "ckmon3_ck")
	),
	MTK_PIN(
		132, "TDM_TX_DATA0",
		MTK_EINT_FUNCTION(0, 132),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO132"),
		MTK_FUNCTION(1, "TDM_TX_DATA0"),
		MTK_FUNCTION(2, "I2S3_DO"),
		MTK_FUNCTION(3, "ckmon4_ck"),
		MTK_FUNCTION(7, "DBG_MON_B29")
	),
	MTK_PIN(
		133, "TDM_TX_DATA1",
		MTK_EINT_FUNCTION(0, 133),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO133"),
		MTK_FUNCTION(1, "TDM_TX_DATA1"),
		MTK_FUNCTION(7, "DBG_MON_B30")
	),
	MTK_PIN(
		134, "TDM_TX_DATA2",
		MTK_EINT_FUNCTION(0, 134),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO134"),
		MTK_FUNCTION(1, "TDM_TX_DATA2"),
		MTK_FUNCTION(7, "DBG_MON_B31")
	),
	MTK_PIN(
		135, "TDM_TX_DATA3",
		MTK_EINT_FUNCTION(0, 135),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO135"),
		MTK_FUNCTION(1, "TDM_TX_DATA3"),
		MTK_FUNCTION(7, "DBG_MON_B32")
	),
	MTK_PIN(
		136, "CONN_TOP_CLK",
		MTK_EINT_FUNCTION(0, 136),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO136"),
		MTK_FUNCTION(1, "CONN_TOP_CLK")
	),
	MTK_PIN(
		137, "CONN_TOP_DATA",
		MTK_EINT_FUNCTION(0, 137),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO137"),
		MTK_FUNCTION(1, "CONN_TOP_DATA")
	),
	MTK_PIN(
		138, "CONN_HRST_B",
		MTK_EINT_FUNCTION(0, 138),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO138"),
		MTK_FUNCTION(1, "CONN_HRST_B")
	),
	MTK_PIN(
		139, "CONN_WB_PTA",
		MTK_EINT_FUNCTION(0, 139),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO139"),
		MTK_FUNCTION(1, "CONN_WB_PTA")
	),
	MTK_PIN(
		140, "CONN_BT_CLK",
		MTK_EINT_FUNCTION(0, 140),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO140"),
		MTK_FUNCTION(1, "CONN_BT_CLK")
	),
	MTK_PIN(
		141, "CONN_BT_DATA",
		MTK_EINT_FUNCTION(0, 141),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO141"),
		MTK_FUNCTION(1, "CONN_BT_DATA")
	),
	MTK_PIN(
		142, "CONN_WF_CTRL0",
		MTK_EINT_FUNCTION(0, 142),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO142"),
		MTK_FUNCTION(1, "CONN_WF_CTRL0")
	),
	MTK_PIN(
		143, "CONN_WF_CTRL1",
		MTK_EINT_FUNCTION(0, 143),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO143"),
		MTK_FUNCTION(1, "CONN_WF_CTRL1")
	),
	MTK_PIN(
		144, "CONN_WF_CTRL2",
		MTK_EINT_FUNCTION(0, 144),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO144"),
		MTK_FUNCTION(1, "CONN_WF_CTRL2")
	),
	MTK_PIN(
		145, "TESTMODE",
		MTK_EINT_FUNCTION(0, 145),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO145")
	),
	MTK_PIN(
		146, "SYSRSTB",
		MTK_EINT_FUNCTION(0, 146),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO146")
	),
	MTK_PIN(
		147, "BIAS_MSDC0",
		MTK_EINT_FUNCTION(0, 147),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO147")
	),
	MTK_PIN(
		148, "BIAS_IO0",
		MTK_EINT_FUNCTION(0, 148),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO148")
	),
	MTK_PIN(
		149, "BIAS1_IO1",
		MTK_EINT_FUNCTION(0, 149),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO149")
	),
	MTK_PIN(
		150, "BIAS2_IO1",
		MTK_EINT_FUNCTION(0, 150),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO150")
	),
	MTK_PIN(
		151, "BIAS_DPI",
		MTK_EINT_FUNCTION(0, 151),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO151")
	),
	MTK_PIN(
		152, "BIAS_MSDC2",
		MTK_EINT_FUNCTION(0, 152),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO152")
	),
	MTK_PIN(
		153, "BIAS_IO2",
		MTK_EINT_FUNCTION(0, 153),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO153")
	),
	MTK_PIN(
		154, "BIAS_IO3",
		MTK_EINT_FUNCTION(0, 154),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO154")
	),
	MTK_PIN(
		155, "BIAS1_MSDC1",
		MTK_EINT_FUNCTION(0, 155),
		DRV_GRP4,
		MTK_FUNCTION(0, "GPIO155")
	),
};

#endif /* __PINCTRL_MTK_MT8168_H */
