
#ifndef __NEC_CHARGER_MANAGER__
#define __NEC_CHARGER_MANAGER__

/* #define CHARGING_CONTROL_DEBUG */

/* cycle = 8800 * 10sec 24.4hours */
#define DEFAULT_COUNT_TO_FORCED_DISCHG	(8800)

#define POLLING_INTERVAL	10000	/* ms (10sec) */

enum Charging_control_state {
	CHARGING_CONTROL_STATE_0  = 0x00,	/* Doesn't control state */
	CHARGING_CONTROL_STATE_1,			/* (a) Chargeing state */
	CHARGING_CONTROL_STATE_2,			/* (b) timer state */
	CHARGING_CONTROL_STATE_3,			/* (c) Force Discharge state */
	CHARGING_CONTROL_STATE_4,			/* (d) Natural Discharge state */
	CHARGING_CONTROL_STATE_5,			/* (e) Recharging state */
};

struct charger_manager {
	struct device	*dev;

	struct power_supply *charger_psy;
	struct power_supply *battery_psy;

	int charging_control_state;
	unsigned long charging_control_start_t;

	bool power_on_state;
	bool discharge_status;
	int dischg_counter;
	int dischg_start_period;
#ifdef CHARGING_CONTROL_DEBUG
	int charging_control_debug;
#endif /* CHARGING_CONTROL_DEBUG */

	int polling_interval;

	int battery_remain;

#define LONGLIFE_DISABLE	0
	int longlife;
#define CHARGE_SAVE_DISABLE	0
	int charge_save;
};

int charger_manager_init(struct charger_manager *cm);
int charger_manager_control(struct charger_manager *cm);
void charger_manager_reset_flag(struct charger_manager *cm);
int charger_manager_get_force_discharge_info(struct charger_manager *cm);
int charger_manager_set_force_discharge_req(struct charger_manager *cm);

#ifdef CHARGING_CONTROL_DEBUG
int charger_manager_set_debug(struct charger_manager *cm,int enable);
#endif /* CHARGING_CONTROL_DEBUG */

#endif /* __NEC_CHARGER_MANAGER__ */
