#include "assert.h"
#include "boot/dev_interface/wdt_interface.h"
#include "boot/handler.h"
#include "debug.h"
#include "error_code.h"
#include <boot/commands_xml.h>
#include <boot/dev_interface/gpio_interface.h>
#include <boot/error_message.h>
#include <boot/protocol_callbacks.h>
#include <boot/system_objects.h>
#include <command_define.h>
#include <driver/register_act_util.h>

// called in bootstrap1, can NOT use malloc. can NOT use log.
int platform_early_init() { return 0; }

// called in bootstrap1, can use malloc.
int platform_init_da() {
  int ret = STATUS_ERR;
  LOGI("***Disable WDT.***\n");
  dev_wdt_disable();
  // dev_wdt_kick();
  LOGI("***Set Reset Key.***\n");
  dev_power_set_reset_key();
  LOGI("***Disable Charging To Battery.***\n");
  dev_power_disable_charging_battery();
  LOGI("***Set USB Bus Current Limit.***\n");
  dev_power_set_charging_limit(100);

  enum BOOT_TRAP_E boot_trap = gpio_get_boot_trap();

#if defined MTK_COMBO_NAND_SUPPORT
  LOGI("MTK_COMBO_NAND_SUPPORT defined.\n");
  if (boot_trap == BOOT_TRAP_PNAND || boot_trap == BOOT_TRAP_SNAND) {
    sysob_nand.type = STORAGE_NAND;
    ret = STATUS_OK;
  } else {
    set_error_msg("Load is NAND project, But device is not SNAND nor PNAND.\n");
  }
#endif
#if defined MTK_UFS_SUPPORT
  LOGI("MTK_UFS_SUPPORT defined.\n");
  if (boot_trap == BOOT_TRAP_UFS) {
    // Colgin do not support UFS
    set_error_msg("ASSERT: UFS trap detected.\n");
  }
#endif
#if defined MTK_EMMC_SUPPORT
  LOGI("MTK_EMMC_SUPPORT defined.\n");
  if (boot_trap == BOOT_TRAP_EMMC) {
    ret = interface_mmc_init();
    if (ret == STATUS_OK) {
      LOGI("\ndevice_mmc init pass.\n");

      interface_get_mmc_info(&sysob_mmc);

      LOGI("EMMC INFO boot1[%llx] user[%llx]\n", sysob_mmc.boot1_size,
           sysob_mmc.user_size);
    } else {
      LOGI("device_mmc init failed.\n");
    }
  } else {
    LOGE("device_emmc init failed.\n");
  }
#endif
  if (ret != STATUS_OK) // all storage init fail
  {
    set_error_msg("All storage init fail. check HW storage.\n");
    return STATUS_ERR;
  }

  BOOL need_init = NEED_EMI_SETTING;
  if (need_init) {
    int r = dev_dram_init();
    sysob_ram.dram.base_address = DA_DRAM_BASE_ADDRESS;
    if (r != STATUS_OK) {
      set_error_msg("DRAM Init FAIL.\n");
      return STATUS_ERR;
    }
  }

  sysob_ram.dram.type = GENERAL_DRAM;
  sysob_ram.dram.size = dev_dram_get_size();

  LOGI("dram_baseaddress: 0x%llx, dram_size: 0x%llx\n",
       sysob_ram.dram.base_address, sysob_ram.dram.size);
  return STATUS_OK;
}

status_t platform_init_hw_bottom_half(const struct progress_cb *cb) {
  return STATUS_OK;
}

void dagent_register_commands() {
  const char *ver1_0 = "1.0";
  const char *ver2_0 = "2.0";

  register_major_command(CMD_NOTIFY_INIT_HW, ver1_0, cmd_notify_init_hw);
  register_major_command(CMD_SET_HOST_INFO, ver1_0, cmd_set_host_info);
  register_major_command(CMD_BOOT_TO, ver1_0, cmd_boot_to);
  register_major_command(CMD_REBOOT, ver1_0, cmd_reboot);
  register_major_command(CMD_INIT_DRAM, ver1_0, cmd_init_dram);
  register_major_command(CMD_GET_HW_INFO, ver1_0, cmd_get_hw_info);
  register_major_command(CMD_SET_RUNTIME_PARAM, ver1_0,
                         cmd_set_runtime_parameter);
  register_major_command(CMD_RAM_TEST, ver1_0, cmd_ram_test);
  register_major_command(CMD_DEBUG_DRAM_REPAIR, ver1_0, cmd_dram_repair);

#if 0
  register_major_command(CMD_FLASH_ALL, ver1_0, cmd_flash_all);
  register_major_command(CMD_ERASE_PARTITION, ver1_0, cmd_erase_partition);
  register_major_command(CMD_ERASE_FLASH, ver1_0, cmd_erase_flash);
  register_major_command(CMD_WRITE_PARTITIONS, ver1_0, cmd_write_partitions);
  register_major_command(CMD_FLASH_ALL, ver2_0, cmd_flash_all);
  register_major_command(CMD_FLASH_UPDATE, ver2_0, cmd_flash_update);
  register_major_command(CMD_EMMC_CONTROL, ver1_0, cmd_emmc_control);
#endif
}
