#include "debug.h"
#include "error_code.h"
#include "boot/dev_interface/efuse_interface.h"
#include "boot/hal.h"

extern int da_efuse_blow(const char *efuse_img, unsigned int magic_key1, unsigned int magic_key2);

int dev_efuse_write(const char* blow_data, int length)
{
		int ret = 0;
		LOGI("\n Enter dev_efuse_write.\n");
		ret = da_efuse_blow(blow_data, EFUSE_BLOW_KEY1, EFUSE_BLOW_KEY2);
		LOGI("Exit dev_efuse_write.\n");

		if (ret == S_EFUSE_DONE) {
				return STATUS_OK;
		} else if ((ret & S_EFUSE_CONFIG_ERR) || (ret & S_EFUSE_DATA_NOT_VALID)) {
				return STATUS_EFUSE_BLOWN_INCORRECT_DATA;
		} else if (ret & S_EFUSE_BLOW_ERROR) {
				return STATUS_EFUSE_BLOW_ERR;
		} else if (ret & S_EFUSE_BLOW_PARTIAL) {
				return STATUS_EFUSE_BLOWN_PARTLY;
		} else if (ret & S_EFUSE_WRITE_TIMEOUT) {
				return STATUS_EFUSE_WRITE_TIMEOUT_WITHOUT_VERIFY;
		} else {
				return STATUS_EFUSE_UNKNOWN_ERR;
		}
}

int dev_efuse_read(char *read_data, int length)
{
	LOGI("\n Enter dev_efuse_read.==%d\n", length);
	da_efuse_read(read_data, length);
	LOGI("Exit dev_efuse_read.\n");
	return STATUS_OK;
}

