#include "stdint.h"
#include "gpio.h"
#include "debug.h"
#include <driver/register_act_util.h>
#include <boot/dev_interface/gpio_interface.h>


enum BOOT_TRAP_E gpio_get_boot_trap()
{
#if (!DA_MODE_FPGA)
  int val = DRV_Reg32(TRAP_TEST_RD) & BOOT_TRAP_MASK;
#else
#if defined MTK_COMBO_NAND_SUPPORT
  int val = BOOT_FROM_PNAND;
#endif
#if defined MTK_UFS_SUPPORT
	int val = BOOT_FROM_UFS;
#endif
#if defined MTK_EMMC_SUPPORT
  int val = BOOT_FROM_EMMC;
#endif
#endif
  LOGI("!boot trap2: 0x%x=0x%x\n", TRAP_TEST_RD, val);

  return (val == BOOT_FROM_EMMC) ? BOOT_TRAP_EMMC :
         (val == BOOT_FROM_PNAND) ? BOOT_TRAP_PNAND :
         (val == BOOT_FROM_SNAND) ? BOOT_TRAP_SNAND : BOOT_TRAP_NOT_SET;
}




