#include <sys/types.h>
#include <debug.h>
#include "assert.h"

extern int pwrap_init_preloader(void);
extern int pmifclkmgr_init(void);
extern int pmif_spmi_init(int mstid);
extern uint32_t pmic_init (void);
extern void pmic_init_setting(void);
extern void rtc_init(void);

extern int pwrap_read(unsigned int adr, unsigned int *rdata);
extern int pwrap_write(unsigned int adr, unsigned int  wdata);
	

void dev_pmic_init()
{
    int ret = -1;

    pmifclkmgr_init();
    pmif_spmi_init(1);
    ret = pmic_init();
    if (0 != ret)
    {
        ASSERT(0);
    }
    rtc_init();
    pmic_init_setting();
}

void dev_pmic_reinit()
{
    pmifclkmgr_init();
    pmif_spmi_init(1);
    pmic_reinit();
}

status_t dev_pmic_get_voltage(unsigned int type, unsigned int voltage)
{
    /* No support pmic get voltage on MT6880 */
    return 0;
}

status_t dev_pmic_set_voltage(unsigned int type, unsigned int* voltage)
{
    /* No support pmic set voltage on MT6880 */
    return 0;
}

int dev_pmic_write(unsigned int address, unsigned int value)
{
    return pmic_config_interface(address, value, 0xFF, 0);
}

unsigned char dev_pmic_read(unsigned int address)
{
    unsigned char value = 0;

    pmic_read_interface(address, value, 0xFF,0);
    return value;
}


void dev_pmic_dump_msg(void)
{
}

void dev_pmic_cold_reset(void)
{
//Move this to Preloader side.
/*
    pmic_config_interface(PMIC_RG_CRST_ADDR, 1,
                          PMIC_RG_CRST_MASK,
                          PMIC_RG_CRST_SHIFT);
*/
}

