OUTPUT_ARCH(arm)

SRAM_CODE_START = 0x200000;
SRAM_CODE_MAX_LEN = 0x38000;
SRAM_BSS_START = 0x238000;
SRAM_BSS_MAX_LEN = 0x8000;
SRAM_HEAP_START = 0x101000;
SRAM_HEAP_MAX_LEN = 0xF000;

MEMORY {
	text (rwx) : ORIGIN = 0x200000 ,LENGTH = 0x38000
	bss (rw) : ORIGIN = 0x238000 ,LENGTH = 0x8000
	heap (rw) : ORIGIN = 0x101000 ,LENGTH = 0xF000
}

ENTRY(_start)
SECTIONS
{
	. = SRAM_CODE_START;
	__text_start = .;
    .text.boot : { *(.text.boot) }
    .allc ALIGN(16) : {*(.text .data .rodata)} > text 
	.section_end ALIGN(16) : {*(.section_end)}
	. = ALIGN(16);
    .da_2nd_hash_section ALIGN(16) : {*(.da_2nd_hash_section)}
	__text_end = .;
	
	. = SRAM_BSS_START;
	__bss_start = .;
	.bss ALIGN(16) : {*(.bss)} 			> bss
	.bss_static ALIGN(16) : {.bss.*}
	. = ALIGN(16);	
	__bss_end = .;	

	
	/* heap use shared ram*/
	. = SRAM_HEAP_START;
	__heap_start = .;
	. = SRAM_HEAP_START + SRAM_HEAP_MAX_LEN;
	__heap_end = .;
	. = .;
}
