#ifndef _MT_PMIC_UPMU_HW_MT6315_H_
#define _MT_PMIC_UPMU_HW_MT6315_H_

#define PMU_FLAG_TABLE_ENTRY struct pmu_flag_table_entry_t
#define PMU_FLAGS_LIST_ENUM enum PMU_FLAGS_LIST

#define MT6315_PMIC_REG_BASE			((unsigned int)(0x0))

#define MT6315_TOP0_ID                    (MT6315_PMIC_REG_BASE+0x0)
#define MT6315_TOP0_ID_H                  (MT6315_PMIC_REG_BASE+0x1)
#define MT6315_TOP0_REV0                  (MT6315_PMIC_REG_BASE+0x2)
#define MT6315_TOP0_REV0_H                (MT6315_PMIC_REG_BASE+0x3)
#define MT6315_TOP0_DSN_DBI               (MT6315_PMIC_REG_BASE+0x4)
#define MT6315_TOP0_DSN_DBI_H             (MT6315_PMIC_REG_BASE+0x5)
#define MT6315_TOP0_DSN_DXI               (MT6315_PMIC_REG_BASE+0x6)
#define MT6315_TOP0_DMY                   (MT6315_PMIC_REG_BASE+0x7)
#define MT6315_HWCID_L                    (MT6315_PMIC_REG_BASE+0x8)
#define MT6315_HWCID_H                    (MT6315_PMIC_REG_BASE+0x9)
#define MT6315_SWCID_L                    (MT6315_PMIC_REG_BASE+0xa)
#define MT6315_SWCID_H                    (MT6315_PMIC_REG_BASE+0xb)
#define MT6315_POFFSTS                    (MT6315_PMIC_REG_BASE+0xc)
#define MT6315_PSTSCTL                    (MT6315_PMIC_REG_BASE+0xd)
#define MT6315_PG_DEB_STS0                (MT6315_PMIC_REG_BASE+0xe)
#define MT6315_PG_SDN_STS0                (MT6315_PMIC_REG_BASE+0xf)
#define MT6315_OC_SDN_STS0                (MT6315_PMIC_REG_BASE+0x10)
#define MT6315_THERMALSTATUS              (MT6315_PMIC_REG_BASE+0x11)
#define MT6315_THERMALDEB                 (MT6315_PMIC_REG_BASE+0x12)
#define MT6315_TOP_CON                    (MT6315_PMIC_REG_BASE+0x13)
#define MT6315_TEST_OUT                   (MT6315_PMIC_REG_BASE+0x14)
#define MT6315_TEST_CON0                  (MT6315_PMIC_REG_BASE+0x15)
#define MT6315_TEST_CON1                  (MT6315_PMIC_REG_BASE+0x16)
#define MT6315_TEST_CON2                  (MT6315_PMIC_REG_BASE+0x17)
#define MT6315_TEST_CON3                  (MT6315_PMIC_REG_BASE+0x18)
#define MT6315_TEST_CON4                  (MT6315_PMIC_REG_BASE+0x19)
#define MT6315_TEST_CON5                  (MT6315_PMIC_REG_BASE+0x1a)
#define MT6315_TEST_CON6                  (MT6315_PMIC_REG_BASE+0x1b)
#define MT6315_TEST_CON7                  (MT6315_PMIC_REG_BASE+0x1c)
#define MT6315_TEST_CON8                  (MT6315_PMIC_REG_BASE+0x1d)
#define MT6315_TEST_CON9                  (MT6315_PMIC_REG_BASE+0x1e)
#define MT6315_TESTMODE_SW                (MT6315_PMIC_REG_BASE+0x1f)
#define MT6315_TDSEL_CON                  (MT6315_PMIC_REG_BASE+0x20)
#define MT6315_RDSEL_CON                  (MT6315_PMIC_REG_BASE+0x21)
#define MT6315_SMT_CON0                   (MT6315_PMIC_REG_BASE+0x22)
#define MT6315_EH_CON0                    (MT6315_PMIC_REG_BASE+0x23)
#define MT6315_RSEL_CON0                  (MT6315_PMIC_REG_BASE+0x24)
#define MT6315_TOP_RSV0                   (MT6315_PMIC_REG_BASE+0x25)
#define MT6315_TOP_RSV1                   (MT6315_PMIC_REG_BASE+0x26)
#define MT6315_DRV_CON0                   (MT6315_PMIC_REG_BASE+0x27)
#define MT6315_FILTER_CON0                (MT6315_PMIC_REG_BASE+0x28)
#define MT6315_FILTER_CON1                (MT6315_PMIC_REG_BASE+0x29)
#define MT6315_TOP_STATUS                 (MT6315_PMIC_REG_BASE+0x2a)
#define MT6315_TOP_STATUS_SET             (MT6315_PMIC_REG_BASE+0x2b)
#define MT6315_TOP_STATUS_CLR             (MT6315_PMIC_REG_BASE+0x2c)
#define MT6315_TOP_PWOFF_CON              (MT6315_PMIC_REG_BASE+0x2d)
#define MT6315_TOP_TRAP                   (MT6315_PMIC_REG_BASE+0x2e)
#define MT6315_TOP1_ID                    (MT6315_PMIC_REG_BASE+0x80)
#define MT6315_TOP1_ID_H                  (MT6315_PMIC_REG_BASE+0x81)
#define MT6315_TOP1_REV0                  (MT6315_PMIC_REG_BASE+0x82)
#define MT6315_TOP1_REV0_H                (MT6315_PMIC_REG_BASE+0x83)
#define MT6315_TOP1_DSN_DBI               (MT6315_PMIC_REG_BASE+0x84)
#define MT6315_TOP1_DSN_DBI_H             (MT6315_PMIC_REG_BASE+0x85)
#define MT6315_TOP1_DSN_DXI               (MT6315_PMIC_REG_BASE+0x86)
#define MT6315_GPIO_DIR                   (MT6315_PMIC_REG_BASE+0x87)
#define MT6315_GPIO_DIR_SET               (MT6315_PMIC_REG_BASE+0x88)
#define MT6315_GPIO_DIR_CLR               (MT6315_PMIC_REG_BASE+0x89)
#define MT6315_GPIO_PULLEN0               (MT6315_PMIC_REG_BASE+0x8a)
#define MT6315_GPIO_PULLEN0_SET           (MT6315_PMIC_REG_BASE+0x8b)
#define MT6315_GPIO_PULLEN0_CLR           (MT6315_PMIC_REG_BASE+0x8c)
#define MT6315_GPIO_PULLSEL0              (MT6315_PMIC_REG_BASE+0x8d)
#define MT6315_GPIO_PULLSEL0_SET          (MT6315_PMIC_REG_BASE+0x8e)
#define MT6315_GPIO_PULLSEL0_CLR          (MT6315_PMIC_REG_BASE+0x8f)
#define MT6315_GPIO_DINV                  (MT6315_PMIC_REG_BASE+0x90)
#define MT6315_GPIO_DINV_SET              (MT6315_PMIC_REG_BASE+0x91)
#define MT6315_GPIO_DINV_CLR              (MT6315_PMIC_REG_BASE+0x92)
#define MT6315_GPIO_DOUT                  (MT6315_PMIC_REG_BASE+0x93)
#define MT6315_GPIO_DOUT_SET              (MT6315_PMIC_REG_BASE+0x94)
#define MT6315_GPIO_DOUT_CLR              (MT6315_PMIC_REG_BASE+0x95)
#define MT6315_GPIO_PI                    (MT6315_PMIC_REG_BASE+0x96)
#define MT6315_GPIO_POE                   (MT6315_PMIC_REG_BASE+0x97)
#define MT6315_GPIO_MODE0                 (MT6315_PMIC_REG_BASE+0x98)
#define MT6315_GPIO_MODE0_SET             (MT6315_PMIC_REG_BASE+0x99)
#define MT6315_GPIO_MODE0_CLR             (MT6315_PMIC_REG_BASE+0x9a)
#define MT6315_GPIO_MODE1                 (MT6315_PMIC_REG_BASE+0x9b)
#define MT6315_GPIO_MODE1_SET             (MT6315_PMIC_REG_BASE+0x9c)
#define MT6315_GPIO_MODE1_CLR             (MT6315_PMIC_REG_BASE+0x9d)
#define MT6315_GPIO_RSV                   (MT6315_PMIC_REG_BASE+0x9e)
#define MT6315_GPIO_CON                   (MT6315_PMIC_REG_BASE+0x9f)
#define MT6315_TOP2_ID                    (MT6315_PMIC_REG_BASE+0x100)
#define MT6315_TOP2_ID_H                  (MT6315_PMIC_REG_BASE+0x101)
#define MT6315_TOP2_REV0                  (MT6315_PMIC_REG_BASE+0x102)
#define MT6315_TOP2_REV0_H                (MT6315_PMIC_REG_BASE+0x103)
#define MT6315_TOP2_DSN_DBI               (MT6315_PMIC_REG_BASE+0x104)
#define MT6315_TOP2_DSN_DBI_H             (MT6315_PMIC_REG_BASE+0x105)
#define MT6315_TOP2_DSN_DXI               (MT6315_PMIC_REG_BASE+0x106)
#define MT6315_TOP_PAM0                   (MT6315_PMIC_REG_BASE+0x107)
#define MT6315_TOP_PAM0_H                 (MT6315_PMIC_REG_BASE+0x108)
#define MT6315_TOP_PAM1                   (MT6315_PMIC_REG_BASE+0x109)
#define MT6315_TOP_PAM1_H                 (MT6315_PMIC_REG_BASE+0x10a)
#define MT6315_TOP_CKPDN_CON0             (MT6315_PMIC_REG_BASE+0x10b)
#define MT6315_TOP_CKPDN_CON0_SET         (MT6315_PMIC_REG_BASE+0x10c)
#define MT6315_TOP_CKPDN_CON0_CLR         (MT6315_PMIC_REG_BASE+0x10d)
#define MT6315_TOP_CKPDN_CON1             (MT6315_PMIC_REG_BASE+0x10e)
#define MT6315_TOP_CKPDN_CON1_SET         (MT6315_PMIC_REG_BASE+0x10f)
#define MT6315_TOP_CKPDN_CON1_CLR         (MT6315_PMIC_REG_BASE+0x110)
#define MT6315_TOP_CKSEL_CON0             (MT6315_PMIC_REG_BASE+0x111)
#define MT6315_TOP_CKSEL_CON0_SET         (MT6315_PMIC_REG_BASE+0x112)
#define MT6315_TOP_CKSEL_CON0_CLR         (MT6315_PMIC_REG_BASE+0x113)
#define MT6315_TOP_CKDIVSEL_CON0          (MT6315_PMIC_REG_BASE+0x114)
#define MT6315_TOP_CKDIVSEL_CON0_SET      (MT6315_PMIC_REG_BASE+0x115)
#define MT6315_TOP_CKDIVSEL_CON0_CLR      (MT6315_PMIC_REG_BASE+0x116)
#define MT6315_TOP_CKHWEN_CON0            (MT6315_PMIC_REG_BASE+0x117)
#define MT6315_TOP_CKHWEN_CON0_SET        (MT6315_PMIC_REG_BASE+0x118)
#define MT6315_TOP_CKHWEN_CON0_CLR        (MT6315_PMIC_REG_BASE+0x119)
#define MT6315_TOP_SMPS_OSC_DBG           (MT6315_PMIC_REG_BASE+0x11a)
#define MT6315_TOP_CKTST_CON0             (MT6315_PMIC_REG_BASE+0x11b)
#define MT6315_TOP_CKTST_CON1             (MT6315_PMIC_REG_BASE+0x11c)
#define MT6315_TOP_CLK_CON0               (MT6315_PMIC_REG_BASE+0x11d)
#define MT6315_TOP_RST_CON0               (MT6315_PMIC_REG_BASE+0x11e)
#define MT6315_TOP_RST_CON0_SET           (MT6315_PMIC_REG_BASE+0x11f)
#define MT6315_TOP_RST_CON0_CLR           (MT6315_PMIC_REG_BASE+0x120)
#define MT6315_TOP_RST_CON1               (MT6315_PMIC_REG_BASE+0x121)
#define MT6315_TOP_RST_CON1_SET           (MT6315_PMIC_REG_BASE+0x122)
#define MT6315_TOP_RST_CON1_CLR           (MT6315_PMIC_REG_BASE+0x123)
#define MT6315_TOP_RST_CON2               (MT6315_PMIC_REG_BASE+0x124)
#define MT6315_TOP_RST_CON3               (MT6315_PMIC_REG_BASE+0x125)
#define MT6315_TOP_RST_MISC               (MT6315_PMIC_REG_BASE+0x126)
#define MT6315_TOP_RST_MISC_SET           (MT6315_PMIC_REG_BASE+0x127)
#define MT6315_TOP_RST_MISC_CLR           (MT6315_PMIC_REG_BASE+0x128)
#define MT6315_TOP_RST_STATUS             (MT6315_PMIC_REG_BASE+0x129)
#define MT6315_TOP_RST_STATUS_SET         (MT6315_PMIC_REG_BASE+0x12a)
#define MT6315_TOP_RST_STATUS_CLR         (MT6315_PMIC_REG_BASE+0x12b)
#define MT6315_TOP_FQMTR_CON0             (MT6315_PMIC_REG_BASE+0x12c)
#define MT6315_TOP_FQMTR_CON1             (MT6315_PMIC_REG_BASE+0x12d)
#define MT6315_TOP_FQMTR_CON2             (MT6315_PMIC_REG_BASE+0x12e)
#define MT6315_TOP_FQMTR_DAT0             (MT6315_PMIC_REG_BASE+0x12f)
#define MT6315_TOP_FQMTR_DAT1             (MT6315_PMIC_REG_BASE+0x130)
#define MT6315_TOP2_ELR_NUM               (MT6315_PMIC_REG_BASE+0x131)
#define MT6315_TOP2_ELR0                  (MT6315_PMIC_REG_BASE+0x132)
#define MT6315_TOP2_ELR1                  (MT6315_PMIC_REG_BASE+0x133)
#define MT6315_TOP2_ELR2                  (MT6315_PMIC_REG_BASE+0x134)
#define MT6315_TOP2_ELR3                  (MT6315_PMIC_REG_BASE+0x135)
#define MT6315_TOP2_ELR4                  (MT6315_PMIC_REG_BASE+0x136)
#define MT6315_TOP2_ELR5                  (MT6315_PMIC_REG_BASE+0x137)
#define MT6315_TOP2_ELR6                  (MT6315_PMIC_REG_BASE+0x138)
#define MT6315_TOP2_ELR7                  (MT6315_PMIC_REG_BASE+0x139)
#define MT6315_TOP3_ID                    (MT6315_PMIC_REG_BASE+0x180)
#define MT6315_TOP3_ID_H                  (MT6315_PMIC_REG_BASE+0x181)
#define MT6315_TOP3_REV0                  (MT6315_PMIC_REG_BASE+0x182)
#define MT6315_TOP3_REV0_H                (MT6315_PMIC_REG_BASE+0x183)
#define MT6315_TOP3_DSN_DBI               (MT6315_PMIC_REG_BASE+0x184)
#define MT6315_TOP3_DSN_DBI_H             (MT6315_PMIC_REG_BASE+0x185)
#define MT6315_TOP3_DSN_DXI               (MT6315_PMIC_REG_BASE+0x186)
#define MT6315_TOP_INT_CON0               (MT6315_PMIC_REG_BASE+0x187)
#define MT6315_TOP_INT_CON0_SET           (MT6315_PMIC_REG_BASE+0x188)
#define MT6315_TOP_INT_CON0_CLR           (MT6315_PMIC_REG_BASE+0x189)
#define MT6315_TOP_INT_MASK_CON0          (MT6315_PMIC_REG_BASE+0x18a)
#define MT6315_TOP_INT_MASK_CON0_SET      (MT6315_PMIC_REG_BASE+0x18b)
#define MT6315_TOP_INT_MASK_CON0_CLR      (MT6315_PMIC_REG_BASE+0x18c)
#define MT6315_TOP_INT_STATUS0            (MT6315_PMIC_REG_BASE+0x18d)
#define MT6315_TOP_INT_RAW_STATUS0        (MT6315_PMIC_REG_BASE+0x18e)
#define MT6315_TOP_INT_CON1               (MT6315_PMIC_REG_BASE+0x18f)
#define MT6315_PMRC_CON0                  (MT6315_PMIC_REG_BASE+0x190)
#define MT6315_PMRC_CON0_SET              (MT6315_PMIC_REG_BASE+0x191)
#define MT6315_PMRC_CON0_CLR              (MT6315_PMIC_REG_BASE+0x192)
#define MT6315_PMRC_CON1                  (MT6315_PMIC_REG_BASE+0x193)
#define MT6315_PMRC_CON1_SET              (MT6315_PMIC_REG_BASE+0x194)
#define MT6315_PMRC_CON1_CLR              (MT6315_PMIC_REG_BASE+0x195)
#define MT6315_VDIG18_CON0                (MT6315_PMIC_REG_BASE+0x196)
#define MT6315_VDIG18_CON1                (MT6315_PMIC_REG_BASE+0x197)
#define MT6315_PLT0_ID_ANA_ID             (MT6315_PMIC_REG_BASE+0x380)
#define MT6315_PLT0_ID_DIG_ID             (MT6315_PMIC_REG_BASE+0x381)
#define MT6315_PLT0_REV0                  (MT6315_PMIC_REG_BASE+0x382)
#define MT6315_PLT0_REV1                  (MT6315_PMIC_REG_BASE+0x383)
#define MT6315_PLT0_REV2                  (MT6315_PMIC_REG_BASE+0x384)
#define MT6315_PLT0_REV3                  (MT6315_PMIC_REG_BASE+0x385)
#define MT6315_PLT0_DSN_DXI               (MT6315_PMIC_REG_BASE+0x386)
#define MT6315_TOP_CLK_TRIM_0             (MT6315_PMIC_REG_BASE+0x387)
#define MT6315_TOP_CLK_TRIM_1             (MT6315_PMIC_REG_BASE+0x388)
#define MT6315_TOP_CLK_TRIM_2             (MT6315_PMIC_REG_BASE+0x389)
#define MT6315_TOP_CLK_TRIM_3             (MT6315_PMIC_REG_BASE+0x38a)
#define MT6315_PLT_CON0                   (MT6315_PMIC_REG_BASE+0x38b)
#define MT6315_OTP_CON0                   (MT6315_PMIC_REG_BASE+0x38c)
#define MT6315_OTP_CON1                   (MT6315_PMIC_REG_BASE+0x38d)
#define MT6315_OTP_CON2                   (MT6315_PMIC_REG_BASE+0x38e)
#define MT6315_OTP_CON3                   (MT6315_PMIC_REG_BASE+0x38f)
#define MT6315_OTP_CON4                   (MT6315_PMIC_REG_BASE+0x390)
#define MT6315_OTP_CON5                   (MT6315_PMIC_REG_BASE+0x391)
#define MT6315_OTP_CON6                   (MT6315_PMIC_REG_BASE+0x392)
#define MT6315_OTP_CON7                   (MT6315_PMIC_REG_BASE+0x393)
#define MT6315_OTP_CON8                   (MT6315_PMIC_REG_BASE+0x394)
#define MT6315_OTP_CON9                   (MT6315_PMIC_REG_BASE+0x395)
#define MT6315_OTP_CON10                  (MT6315_PMIC_REG_BASE+0x396)
#define MT6315_OTP_CON11                  (MT6315_PMIC_REG_BASE+0x397)
#define MT6315_OTP_CON12                  (MT6315_PMIC_REG_BASE+0x398)
#define MT6315_OTP_CON13                  (MT6315_PMIC_REG_BASE+0x399)
#define MT6315_OTP_CON14                  (MT6315_PMIC_REG_BASE+0x39a)
#define MT6315_OTP_CON15                  (MT6315_PMIC_REG_BASE+0x39b)
#define MT6315_OTP_CON16                  (MT6315_PMIC_REG_BASE+0x39c)
#define MT6315_OTP_CON17                  (MT6315_PMIC_REG_BASE+0x39d)
#define MT6315_OTP_CON18                  (MT6315_PMIC_REG_BASE+0x39e)
#define MT6315_TOP_TMA_KEY                (MT6315_PMIC_REG_BASE+0x39f)
#define MT6315_TOP_TMA_KEY_H              (MT6315_PMIC_REG_BASE+0x3a0)
#define MT6315_TOP_ANA_KEY                (MT6315_PMIC_REG_BASE+0x3a1)
#define MT6315_TOP_ANA_KEY_H              (MT6315_PMIC_REG_BASE+0x3a2)
#define MT6315_TOP_MDB_CONF0              (MT6315_PMIC_REG_BASE+0x3a3)
#define MT6315_TOP_MDB_CONF0_H            (MT6315_PMIC_REG_BASE+0x3a4)
#define MT6315_TOP_MDB_CONF1              (MT6315_PMIC_REG_BASE+0x3a5)
#define MT6315_TOP_MDB_CONF1_H            (MT6315_PMIC_REG_BASE+0x3a6)
#define MT6315_TOP_MDB_CONF2              (MT6315_PMIC_REG_BASE+0x3a7)
#define MT6315_TOP_DIG_WPK                (MT6315_PMIC_REG_BASE+0x3a8)
#define MT6315_TOP_DIG_WPK_H              (MT6315_PMIC_REG_BASE+0x3a9)
#define MT6315_SPMI_EXT_ADDR0             (MT6315_PMIC_REG_BASE+0x3aa)
#define MT6315_SPMI_EXT_ADDR0_H           (MT6315_PMIC_REG_BASE+0x3ab)
#define MT6315_SPMI_EXT_ADDR1             (MT6315_PMIC_REG_BASE+0x3ac)
#define MT6315_SPMI_EXT_ADDR2             (MT6315_PMIC_REG_BASE+0x3ad)
#define MT6315_SPMI_EXT_ADDR2_H           (MT6315_PMIC_REG_BASE+0x3ae)
#define MT6315_SPMI_RCS_FUN0              (MT6315_PMIC_REG_BASE+0x3af)
#define MT6315_SPMI_RCS_FUN1              (MT6315_PMIC_REG_BASE+0x3b0)
#define MT6315_SPMI_RCS_FUN2              (MT6315_PMIC_REG_BASE+0x3b1)
#define MT6315_SPMI_WR_ADDR               (MT6315_PMIC_REG_BASE+0x3b2)
#define MT6315_SPMI_WR_ADDR_H             (MT6315_PMIC_REG_BASE+0x3b3)
#define MT6315_SPMI_DEBUG_ADDR0           (MT6315_PMIC_REG_BASE+0x3b4)
#define MT6315_SPMI_DEBUG_ADDR0_H         (MT6315_PMIC_REG_BASE+0x3b5)
#define MT6315_SPMI_DEBUG_DATA0           (MT6315_PMIC_REG_BASE+0x3b6)
#define MT6315_SPMI_DEBUG_CMD0            (MT6315_PMIC_REG_BASE+0x3b7)
#define MT6315_SPMI_DEBUG_ADDR1           (MT6315_PMIC_REG_BASE+0x3b8)
#define MT6315_SPMI_DEBUG_ADDR1_H         (MT6315_PMIC_REG_BASE+0x3b9)
#define MT6315_SPMI_DEBUG_DATA1           (MT6315_PMIC_REG_BASE+0x3ba)
#define MT6315_SPMI_DEBUG_CMD1            (MT6315_PMIC_REG_BASE+0x3bb)
#define MT6315_SPMI_DEBUG_ADDR2           (MT6315_PMIC_REG_BASE+0x3bc)
#define MT6315_SPMI_DEBUG_ADDR2_H         (MT6315_PMIC_REG_BASE+0x3bd)
#define MT6315_SPMI_DEBUG_DATA2           (MT6315_PMIC_REG_BASE+0x3be)
#define MT6315_SPMI_DEBUG_CMD2            (MT6315_PMIC_REG_BASE+0x3bf)
#define MT6315_SPMI_DEBUG_ADDR3           (MT6315_PMIC_REG_BASE+0x3c0)
#define MT6315_SPMI_DEBUG_ADDR3_H         (MT6315_PMIC_REG_BASE+0x3c1)
#define MT6315_SPMI_DEBUG_DATA3           (MT6315_PMIC_REG_BASE+0x3c2)
#define MT6315_SPMI_DEBUG_CMD3            (MT6315_PMIC_REG_BASE+0x3c3)
#define MT6315_SPMI_PTRY_ERR0             (MT6315_PMIC_REG_BASE+0x3c4)
#define MT6315_SPMI_PTRY_ERR1             (MT6315_PMIC_REG_BASE+0x3c5)
#define MT6315_SPMI_PTRY_ERR1_H           (MT6315_PMIC_REG_BASE+0x3c6)
#define MT6315_SPMI_PTRY_ERR2             (MT6315_PMIC_REG_BASE+0x3c7)
#define MT6315_SPMI_PTRY_ERR3             (MT6315_PMIC_REG_BASE+0x3c8)
#define MT6315_SPMI_PTRY_ERR3_H           (MT6315_PMIC_REG_BASE+0x3c9)
#define MT6315_SPMI_PTRY_ERR4             (MT6315_PMIC_REG_BASE+0x3ca)
#define MT6315_SPMI_PTRY_ERR5             (MT6315_PMIC_REG_BASE+0x3cb)
#define MT6315_SPMI_PTRY_ERR5_H           (MT6315_PMIC_REG_BASE+0x3cc)
#define MT6315_SPMI_PTRY_ERR6             (MT6315_PMIC_REG_BASE+0x3cd)
#define MT6315_SPMI_PTRY_ERR7             (MT6315_PMIC_REG_BASE+0x3ce)
#define MT6315_SPMI_PTRY_ERR7_H           (MT6315_PMIC_REG_BASE+0x3cf)
#define MT6315_PLT0_ELR_NUM               (MT6315_PMIC_REG_BASE+0x3d0)
#define MT6315_PLT0_ELR0                  (MT6315_PMIC_REG_BASE+0x3d1)
#define MT6315_PLT0_ELR1                  (MT6315_PMIC_REG_BASE+0x3d2)
#define MT6315_PSC_TOP_ID_ANA             (MT6315_PMIC_REG_BASE+0x900)
#define MT6315_PSC_TOP_ID_DIG             (MT6315_PMIC_REG_BASE+0x901)
#define MT6315_PSC_TOP_REV0               (MT6315_PMIC_REG_BASE+0x902)
#define MT6315_PSC_TOP_REV1               (MT6315_PMIC_REG_BASE+0x903)
#define MT6315_PSC_TOP_DBI0               (MT6315_PMIC_REG_BASE+0x904)
#define MT6315_PSC_TOP_DBI1               (MT6315_PMIC_REG_BASE+0x905)
#define MT6315_PSC_TOP_DXI                (MT6315_PMIC_REG_BASE+0x906)
#define MT6315_PSC_TPM0                   (MT6315_PMIC_REG_BASE+0x907)
#define MT6315_PSC_TPM1                   (MT6315_PMIC_REG_BASE+0x908)
#define MT6315_PSC_TPM2                   (MT6315_PMIC_REG_BASE+0x909)
#define MT6315_PSC_TOP_RSTCTL             (MT6315_PMIC_REG_BASE+0x90a)
#define MT6315_PSC_TOP_MON_CTL            (MT6315_PMIC_REG_BASE+0x90b)
#define MT6315_PSEQ_ID_ANA                (MT6315_PMIC_REG_BASE+0x980)
#define MT6315_PSEQ_ID_DIG                (MT6315_PMIC_REG_BASE+0x981)
#define MT6315_PSEQ_REV0                  (MT6315_PMIC_REG_BASE+0x982)
#define MT6315_PSEQ_REV1                  (MT6315_PMIC_REG_BASE+0x983)
#define MT6315_PSEQ_DBI0                  (MT6315_PMIC_REG_BASE+0x984)
#define MT6315_PSEQ_DBI1                  (MT6315_PMIC_REG_BASE+0x985)
#define MT6315_PSEQ_DXI                   (MT6315_PMIC_REG_BASE+0x986)
#define MT6315_PPCCTL                     (MT6315_PMIC_REG_BASE+0x987)
#define MT6315_STRUP_CON0                 (MT6315_PMIC_REG_BASE+0x988)
#define MT6315_STRUP_CON1                 (MT6315_PMIC_REG_BASE+0x989)
#define MT6315_STRUP_PGENB0               (MT6315_PMIC_REG_BASE+0x98a)
#define MT6315_STRUP_OCENB0               (MT6315_PMIC_REG_BASE+0x98b)
#define MT6315_BUCK_KEYPWR                (MT6315_PMIC_REG_BASE+0x98c)
#define MT6315_PPCTST0                    (MT6315_PMIC_REG_BASE+0x98d)
#define MT6315_PPCCTL2                    (MT6315_PMIC_REG_BASE+0x98e)
#define MT6315_STRUP_CON4                 (MT6315_PMIC_REG_BASE+0x98f)
#define MT6315_STRUP_CON5                 (MT6315_PMIC_REG_BASE+0x990)
#define MT6315_STRUP_CON6                 (MT6315_PMIC_REG_BASE+0x991)
#define MT6315_CPSWKEY                    (MT6315_PMIC_REG_BASE+0x992)
#define MT6315_CPSWKEY_H                  (MT6315_PMIC_REG_BASE+0x993)
#define MT6315_STS_PDN_ENCODE             (MT6315_PMIC_REG_BASE+0x994)
#define MT6315_PSEQ_ELR_NUM               (MT6315_PMIC_REG_BASE+0x995)
#define MT6315_PSEQ_ELR0                  (MT6315_PMIC_REG_BASE+0x996)
#define MT6315_PSEQ_ELR1                  (MT6315_PMIC_REG_BASE+0x997)
#define MT6315_PSEQ_ELR2                  (MT6315_PMIC_REG_BASE+0x998)
#define MT6315_PSEQ_ELR3                  (MT6315_PMIC_REG_BASE+0x999)
#define MT6315_PSEQ_ELR4                  (MT6315_PMIC_REG_BASE+0x99a)
#define MT6315_PSEQ_ELR5                  (MT6315_PMIC_REG_BASE+0x99b)
#define MT6315_CPSUSA_ELR0                (MT6315_PMIC_REG_BASE+0x99c)
#define MT6315_CPSUSA_ELR1                (MT6315_PMIC_REG_BASE+0x99d)
#define MT6315_CPSUSA_ELR2                (MT6315_PMIC_REG_BASE+0x99e)
#define MT6315_CPSUSA_ELR3                (MT6315_PMIC_REG_BASE+0x99f)
#define MT6315_CPSDSA_ELR0                (MT6315_PMIC_REG_BASE+0x9a0)
#define MT6315_CPSDSA_ELR1                (MT6315_PMIC_REG_BASE+0x9a1)
#define MT6315_CPSDSA_ELR2                (MT6315_PMIC_REG_BASE+0x9a2)
#define MT6315_CPSDSA_ELR3                (MT6315_PMIC_REG_BASE+0x9a3)
#define MT6315_STRUP_ANA0_ANA_ID          (MT6315_PMIC_REG_BASE+0xa00)
#define MT6315_STRUP_ANA0_DIG_ID          (MT6315_PMIC_REG_BASE+0xa01)
#define MT6315_STRUP_ANA0_DSN_REV0        (MT6315_PMIC_REG_BASE+0xa02)
#define MT6315_STRUP_ANA0_DSN_REV1        (MT6315_PMIC_REG_BASE+0xa03)
#define MT6315_STRUP_ANA0_DBI0            (MT6315_PMIC_REG_BASE+0xa04)
#define MT6315_STRUP_ANA0_DBI1            (MT6315_PMIC_REG_BASE+0xa05)
#define MT6315_STRUP_ANA0_DXI             (MT6315_PMIC_REG_BASE+0xa06)
#define MT6315_STRUP_TOP_A10876A_ANA_CON0 (MT6315_PMIC_REG_BASE+0xa07)
#define MT6315_STRUP_TOP_A10876A_ANA_CON1 (MT6315_PMIC_REG_BASE+0xa08)
#define MT6315_STRUP_TOP_A10876A_ANA_CON2 (MT6315_PMIC_REG_BASE+0xa09)
#define MT6315_STRUP_TOP_A10876A_ANA_CON3 (MT6315_PMIC_REG_BASE+0xa0a)
#define MT6315_STRUP_TOP_A10876A_ANA_CON4 (MT6315_PMIC_REG_BASE+0xa0b)
#define MT6315_STRUP_TOP_A10876A_ANA_CON5 (MT6315_PMIC_REG_BASE+0xa0c)
#define MT6315_STRUP_TOP_A10876A_ANA_CON6 (MT6315_PMIC_REG_BASE+0xa0d)
#define MT6315_STRUP_TOP_A10876A_ANA_CON7 (MT6315_PMIC_REG_BASE+0xa0e)
#define MT6315_STRUP_TOP_A10876A_ANA_CON8 (MT6315_PMIC_REG_BASE+0xa0f)
#define MT6315_STRUP_ANA0_ELR_NUM         (MT6315_PMIC_REG_BASE+0xa10)
#define MT6315_STRUP_TOP_A10876A_ELR_0    (MT6315_PMIC_REG_BASE+0xa11)
#define MT6315_STRUP_TOP_A10876A_ELR_1    (MT6315_PMIC_REG_BASE+0xa12)
#define MT6315_STRUP_TOP_A10876A_ELR_2    (MT6315_PMIC_REG_BASE+0xa13)
#define MT6315_STRUP_TOP_A10876A_ELR_3    (MT6315_PMIC_REG_BASE+0xa14)
#define MT6315_STRUP_TOP_A10876A_ELR_4    (MT6315_PMIC_REG_BASE+0xa15)
#define MT6315_STRUP_TOP_A10876A_ELR_5    (MT6315_PMIC_REG_BASE+0xa16)
#define MT6315_STRUP_TOP_A10876A_ELR_6    (MT6315_PMIC_REG_BASE+0xa17)
#define MT6315_STRUP_TOP_A10876A_ELR_7    (MT6315_PMIC_REG_BASE+0xa18)
#define MT6315_STRUP_TOP_A10876A_ELR_8    (MT6315_PMIC_REG_BASE+0xa19)
#define MT6315_STRUP_TOP_A10876A_ELR_9    (MT6315_PMIC_REG_BASE+0xa1a)
#define MT6315_BUCK_TOP_ANA_ID            (MT6315_PMIC_REG_BASE+0x1400)
#define MT6315_BUCK_TOP_DIG_ID            (MT6315_PMIC_REG_BASE+0x1401)
#define MT6315_BUCK_TOP_REV0              (MT6315_PMIC_REG_BASE+0x1402)
#define MT6315_BUCK_TOP_REV1              (MT6315_PMIC_REG_BASE+0x1403)
#define MT6315_BUCK_TOP_DBI0              (MT6315_PMIC_REG_BASE+0x1404)
#define MT6315_BUCK_TOP_DBI1              (MT6315_PMIC_REG_BASE+0x1405)
#define MT6315_BUCK_TOP_DXI               (MT6315_PMIC_REG_BASE+0x1406)
#define MT6315_BUCK_TOP_PAM0              (MT6315_PMIC_REG_BASE+0x1407)
#define MT6315_BUCK_TOP_PAM1              (MT6315_PMIC_REG_BASE+0x1408)
#define MT6315_BUCK_TOP_PAM2              (MT6315_PMIC_REG_BASE+0x1409)
#define MT6315_BUCK_TOP_PAM3              (MT6315_PMIC_REG_BASE+0x140a)
#define MT6315_BUCK_TOP_CLK_CON0          (MT6315_PMIC_REG_BASE+0x140b)
#define MT6315_BUCK_TOP_CLK_CON0_SET      (MT6315_PMIC_REG_BASE+0x140c)
#define MT6315_BUCK_TOP_CLK_CON0_CLR      (MT6315_PMIC_REG_BASE+0x140d)
#define MT6315_BUCK_TOP_CLK_HWEN_CON0     (MT6315_PMIC_REG_BASE+0x140e)
#define MT6315_BUCK_TOP_CLK_HWEN_CON0_SET (MT6315_PMIC_REG_BASE+0x140f)
#define MT6315_BUCK_TOP_CLK_HWEN_CON0_CLR (MT6315_PMIC_REG_BASE+0x1410)
#define MT6315_BUCK_TOP_CLK_DCM_CON       (MT6315_PMIC_REG_BASE+0x1411)
#define MT6315_BUCK_TOP_SYNC_CON          (MT6315_PMIC_REG_BASE+0x1412)
#define MT6315_BUCK_TOP_STB_CON           (MT6315_PMIC_REG_BASE+0x1413)
#define MT6315_BUCK_TOP_VGP2_MINFREQ_CON0 (MT6315_PMIC_REG_BASE+0x1414)
#define MT6315_BUCK_TOP_VGP2_MINFREQ_CON1 (MT6315_PMIC_REG_BASE+0x1415)
#define MT6315_BUCK_TOP_OC_CON0           (MT6315_PMIC_REG_BASE+0x1416)
#define MT6315_BUCK_TOP_KEY_PROT0         (MT6315_PMIC_REG_BASE+0x1417)
#define MT6315_BUCK_TOP_KEY_PROT1         (MT6315_PMIC_REG_BASE+0x1418)
#define MT6315_BUCK_TOP_WDTDBG0           (MT6315_PMIC_REG_BASE+0x1419)
#define MT6315_BUCK_TOP_WDTDBG1           (MT6315_PMIC_REG_BASE+0x141a)
#define MT6315_BUCK_TOP_WDTDBG2           (MT6315_PMIC_REG_BASE+0x141b)
#define MT6315_BUCK_TOP_WDTDBG3           (MT6315_PMIC_REG_BASE+0x141c)
#define MT6315_BUCK_TOP_WDTDBG4           (MT6315_PMIC_REG_BASE+0x141d)
#define MT6315_BUCK_TOP_WDTDBG5           (MT6315_PMIC_REG_BASE+0x141e)
#define MT6315_BUCK_TOP_WDTDBG6           (MT6315_PMIC_REG_BASE+0x141f)
#define MT6315_BUCK_TOP_WDTDBG7           (MT6315_PMIC_REG_BASE+0x1420)
#define MT6315_BUCK_TOP_DBG               (MT6315_PMIC_REG_BASE+0x1421)
#define MT6315_BUCK_TOP_CON0              (MT6315_PMIC_REG_BASE+0x1440)
#define MT6315_BUCK_TOP_CON0_SET          (MT6315_PMIC_REG_BASE+0x1441)
#define MT6315_BUCK_TOP_CON0_CLR          (MT6315_PMIC_REG_BASE+0x1442)
#define MT6315_BUCK_TOP_CON1              (MT6315_PMIC_REG_BASE+0x1443)
#define MT6315_BUCK_TOP_CON1_SET          (MT6315_PMIC_REG_BASE+0x1444)
#define MT6315_BUCK_TOP_CON1_CLR          (MT6315_PMIC_REG_BASE+0x1445)
#define MT6315_BUCK_TOP_ELR_NUM           (MT6315_PMIC_REG_BASE+0x1448)
#define MT6315_BUCK_TOP_ELR0              (MT6315_PMIC_REG_BASE+0x1449)
#define MT6315_BUCK_TOP_ELR1              (MT6315_PMIC_REG_BASE+0x144a)
#define MT6315_BUCK_TOP_ELR2              (MT6315_PMIC_REG_BASE+0x144b)
#define MT6315_BUCK_TOP_ELR3              (MT6315_PMIC_REG_BASE+0x144c)
#define MT6315_BUCK_TOP_ELR4              (MT6315_PMIC_REG_BASE+0x144d)
#define MT6315_BUCK_TOP_ELR5              (MT6315_PMIC_REG_BASE+0x144e)
#define MT6315_BUCK_TOP_ELR6              (MT6315_PMIC_REG_BASE+0x144f)
#define MT6315_BUCK_TOP_ELR7              (MT6315_PMIC_REG_BASE+0x1450)
#define MT6315_BUCK_TOP_ELR8              (MT6315_PMIC_REG_BASE+0x1451)
#define MT6315_BUCK_TOP_ELR9              (MT6315_PMIC_REG_BASE+0x1452)
#define MT6315_BUCK_TOP_ELR10             (MT6315_PMIC_REG_BASE+0x1453)
#define MT6315_BUCK_TOP_ELR11             (MT6315_PMIC_REG_BASE+0x1454)
#define MT6315_BUCK_TOP_ELR12             (MT6315_PMIC_REG_BASE+0x1455)
#define MT6315_BUCK_TOP_ELR13             (MT6315_PMIC_REG_BASE+0x1456)
#define MT6315_BUCK_TOP_ELR14             (MT6315_PMIC_REG_BASE+0x1457)
#define MT6315_BUCK_TOP_ELR15             (MT6315_PMIC_REG_BASE+0x1458)
#define MT6315_BUCK_VBUCK1_ANA_ID         (MT6315_PMIC_REG_BASE+0x1480)
#define MT6315_BUCK_VBUCK1_DIG_ID         (MT6315_PMIC_REG_BASE+0x1481)
#define MT6315_BUCK_VBUCK1_REV0           (MT6315_PMIC_REG_BASE+0x1482)
#define MT6315_BUCK_VBUCK1_REV1           (MT6315_PMIC_REG_BASE+0x1483)
#define MT6315_BUCK_VBUCK1_DBI0           (MT6315_PMIC_REG_BASE+0x1484)
#define MT6315_BUCK_VBUCK1_DBI1           (MT6315_PMIC_REG_BASE+0x1485)
#define MT6315_BUCK_VBUCK1_DXI            (MT6315_PMIC_REG_BASE+0x1486)
#define MT6315_BUCK_VBUCK1_CON1           (MT6315_PMIC_REG_BASE+0x1487)
#define MT6315_BUCK_VBUCK1_CON2           (MT6315_PMIC_REG_BASE+0x1488)
#define MT6315_BUCK_VBUCK1_SLP_CON        (MT6315_PMIC_REG_BASE+0x1489)
#define MT6315_BUCK_VBUCK1_DVS_CON        (MT6315_PMIC_REG_BASE+0x148a)
#define MT6315_BUCK_VBUCK1_CFG0           (MT6315_PMIC_REG_BASE+0x148b)
#define MT6315_BUCK_VBUCK1_CFG1           (MT6315_PMIC_REG_BASE+0x148c)
#define MT6315_BUCK_VBUCK1_OP_EN_0        (MT6315_PMIC_REG_BASE+0x148d)
#define MT6315_BUCK_VBUCK1_OP_EN_0_SET    (MT6315_PMIC_REG_BASE+0x148e)
#define MT6315_BUCK_VBUCK1_OP_EN_0_CLR    (MT6315_PMIC_REG_BASE+0x148f)
#define MT6315_BUCK_VBUCK1_OP_EN_1        (MT6315_PMIC_REG_BASE+0x1490)
#define MT6315_BUCK_VBUCK1_OP_EN_1_SET    (MT6315_PMIC_REG_BASE+0x1491)
#define MT6315_BUCK_VBUCK1_OP_EN_1_CLR    (MT6315_PMIC_REG_BASE+0x1492)
#define MT6315_BUCK_VBUCK1_OP_CFG_0       (MT6315_PMIC_REG_BASE+0x1493)
#define MT6315_BUCK_VBUCK1_OP_CFG_0_SET   (MT6315_PMIC_REG_BASE+0x1494)
#define MT6315_BUCK_VBUCK1_OP_CFG_0_CLR   (MT6315_PMIC_REG_BASE+0x1495)
#define MT6315_BUCK_VBUCK1_OP_MODE_0      (MT6315_PMIC_REG_BASE+0x1496)
#define MT6315_BUCK_VBUCK1_OP_MODE_0_SET  (MT6315_PMIC_REG_BASE+0x1497)
#define MT6315_BUCK_VBUCK1_OP_MODE_0_CLR  (MT6315_PMIC_REG_BASE+0x1498)
#define MT6315_BUCK_VBUCK1_DBG0           (MT6315_PMIC_REG_BASE+0x1499)
#define MT6315_BUCK_VBUCK1_DBG1           (MT6315_PMIC_REG_BASE+0x149a)
#define MT6315_BUCK_VBUCK1_DBG2           (MT6315_PMIC_REG_BASE+0x149b)
#define MT6315_BUCK_VBUCK1_DBG3           (MT6315_PMIC_REG_BASE+0x149c)
#define MT6315_BUCK_VBUCK1_DBG4           (MT6315_PMIC_REG_BASE+0x149d)
#define MT6315_BUCK_VBUCK1_DBG5           (MT6315_PMIC_REG_BASE+0x149e)
#define MT6315_BUCK_VBUCK1_STALL_TRACK0   (MT6315_PMIC_REG_BASE+0x149f)
#define MT6315_BUCK_VBUCK2_ANA_ID         (MT6315_PMIC_REG_BASE+0x1500)
#define MT6315_BUCK_VBUCK2_DIG_ID         (MT6315_PMIC_REG_BASE+0x1501)
#define MT6315_BUCK_VBUCK2_REV0           (MT6315_PMIC_REG_BASE+0x1502)
#define MT6315_BUCK_VBUCK2_REV1           (MT6315_PMIC_REG_BASE+0x1503)
#define MT6315_BUCK_VBUCK2_DBI0           (MT6315_PMIC_REG_BASE+0x1504)
#define MT6315_BUCK_VBUCK2_DBI1           (MT6315_PMIC_REG_BASE+0x1505)
#define MT6315_BUCK_VBUCK2_DXI            (MT6315_PMIC_REG_BASE+0x1506)
#define MT6315_BUCK_VBUCK2_CON1           (MT6315_PMIC_REG_BASE+0x1507)
#define MT6315_BUCK_VBUCK2_CON2           (MT6315_PMIC_REG_BASE+0x1508)
#define MT6315_BUCK_VBUCK2_SLP_CON        (MT6315_PMIC_REG_BASE+0x1509)
#define MT6315_BUCK_VBUCK2_DVS_CON        (MT6315_PMIC_REG_BASE+0x150a)
#define MT6315_BUCK_VBUCK2_CFG0           (MT6315_PMIC_REG_BASE+0x150b)
#define MT6315_BUCK_VBUCK2_CFG1           (MT6315_PMIC_REG_BASE+0x150c)
#define MT6315_BUCK_VBUCK2_OP_EN_0        (MT6315_PMIC_REG_BASE+0x150d)
#define MT6315_BUCK_VBUCK2_OP_EN_0_SET    (MT6315_PMIC_REG_BASE+0x150e)
#define MT6315_BUCK_VBUCK2_OP_EN_0_CLR    (MT6315_PMIC_REG_BASE+0x150f)
#define MT6315_BUCK_VBUCK2_OP_EN_1        (MT6315_PMIC_REG_BASE+0x1510)
#define MT6315_BUCK_VBUCK2_OP_EN_1_SET    (MT6315_PMIC_REG_BASE+0x1511)
#define MT6315_BUCK_VBUCK2_OP_EN_1_CLR    (MT6315_PMIC_REG_BASE+0x1512)
#define MT6315_BUCK_VBUCK2_OP_CFG_0       (MT6315_PMIC_REG_BASE+0x1513)
#define MT6315_BUCK_VBUCK2_OP_CFG_0_SET   (MT6315_PMIC_REG_BASE+0x1514)
#define MT6315_BUCK_VBUCK2_OP_CFG_0_CLR   (MT6315_PMIC_REG_BASE+0x1515)
#define MT6315_BUCK_VBUCK2_OP_MODE_0      (MT6315_PMIC_REG_BASE+0x1516)
#define MT6315_BUCK_VBUCK2_OP_MODE_0_SET  (MT6315_PMIC_REG_BASE+0x1517)
#define MT6315_BUCK_VBUCK2_OP_MODE_0_CLR  (MT6315_PMIC_REG_BASE+0x1518)
#define MT6315_BUCK_VBUCK2_DBG0           (MT6315_PMIC_REG_BASE+0x1519)
#define MT6315_BUCK_VBUCK2_DBG1           (MT6315_PMIC_REG_BASE+0x151a)
#define MT6315_BUCK_VBUCK2_DBG2           (MT6315_PMIC_REG_BASE+0x151b)
#define MT6315_BUCK_VBUCK2_DBG3           (MT6315_PMIC_REG_BASE+0x151c)
#define MT6315_BUCK_VBUCK2_DBG4           (MT6315_PMIC_REG_BASE+0x151d)
#define MT6315_BUCK_VBUCK2_DBG5           (MT6315_PMIC_REG_BASE+0x151e)
#define MT6315_BUCK_VBUCK2_STALL_TRACK0   (MT6315_PMIC_REG_BASE+0x151f)
#define MT6315_BUCK_VBUCK3_ANA_ID         (MT6315_PMIC_REG_BASE+0x1580)
#define MT6315_BUCK_VBUCK3_DIG_ID         (MT6315_PMIC_REG_BASE+0x1581)
#define MT6315_BUCK_VBUCK3_REV0           (MT6315_PMIC_REG_BASE+0x1582)
#define MT6315_BUCK_VBUCK3_REV1           (MT6315_PMIC_REG_BASE+0x1583)
#define MT6315_BUCK_VBUCK3_DBI0           (MT6315_PMIC_REG_BASE+0x1584)
#define MT6315_BUCK_VBUCK3_DBI1           (MT6315_PMIC_REG_BASE+0x1585)
#define MT6315_BUCK_VBUCK3_DXI            (MT6315_PMIC_REG_BASE+0x1586)
#define MT6315_BUCK_VBUCK3_CON1           (MT6315_PMIC_REG_BASE+0x1587)
#define MT6315_BUCK_VBUCK3_CON2           (MT6315_PMIC_REG_BASE+0x1588)
#define MT6315_BUCK_VBUCK3_SLP_CON        (MT6315_PMIC_REG_BASE+0x1589)
#define MT6315_BUCK_VBUCK3_DVS_CON        (MT6315_PMIC_REG_BASE+0x158a)
#define MT6315_BUCK_VBUCK3_CFG0           (MT6315_PMIC_REG_BASE+0x158b)
#define MT6315_BUCK_VBUCK3_CFG1           (MT6315_PMIC_REG_BASE+0x158c)
#define MT6315_BUCK_VBUCK3_OP_EN_0        (MT6315_PMIC_REG_BASE+0x158d)
#define MT6315_BUCK_VBUCK3_OP_EN_0_SET    (MT6315_PMIC_REG_BASE+0x158e)
#define MT6315_BUCK_VBUCK3_OP_EN_0_CLR    (MT6315_PMIC_REG_BASE+0x158f)
#define MT6315_BUCK_VBUCK3_OP_EN_1        (MT6315_PMIC_REG_BASE+0x1590)
#define MT6315_BUCK_VBUCK3_OP_EN_1_SET    (MT6315_PMIC_REG_BASE+0x1591)
#define MT6315_BUCK_VBUCK3_OP_EN_1_CLR    (MT6315_PMIC_REG_BASE+0x1592)
#define MT6315_BUCK_VBUCK3_OP_CFG_0       (MT6315_PMIC_REG_BASE+0x1593)
#define MT6315_BUCK_VBUCK3_OP_CFG_0_SET   (MT6315_PMIC_REG_BASE+0x1594)
#define MT6315_BUCK_VBUCK3_OP_CFG_0_CLR   (MT6315_PMIC_REG_BASE+0x1595)
#define MT6315_BUCK_VBUCK3_OP_MODE_0      (MT6315_PMIC_REG_BASE+0x1596)
#define MT6315_BUCK_VBUCK3_OP_MODE_0_SET  (MT6315_PMIC_REG_BASE+0x1597)
#define MT6315_BUCK_VBUCK3_OP_MODE_0_CLR  (MT6315_PMIC_REG_BASE+0x1598)
#define MT6315_BUCK_VBUCK3_DBG0           (MT6315_PMIC_REG_BASE+0x1599)
#define MT6315_BUCK_VBUCK3_DBG1           (MT6315_PMIC_REG_BASE+0x159a)
#define MT6315_BUCK_VBUCK3_DBG2           (MT6315_PMIC_REG_BASE+0x159b)
#define MT6315_BUCK_VBUCK3_DBG3           (MT6315_PMIC_REG_BASE+0x159c)
#define MT6315_BUCK_VBUCK3_DBG4           (MT6315_PMIC_REG_BASE+0x159d)
#define MT6315_BUCK_VBUCK3_DBG5           (MT6315_PMIC_REG_BASE+0x159e)
#define MT6315_BUCK_VBUCK3_TRACK0         (MT6315_PMIC_REG_BASE+0x159f)
#define MT6315_BUCK_VBUCK3_TRACK1         (MT6315_PMIC_REG_BASE+0x15a0)
#define MT6315_BUCK_VBUCK3_TRACK2         (MT6315_PMIC_REG_BASE+0x15a1)
#define MT6315_BUCK_VBUCK3_TRACK3         (MT6315_PMIC_REG_BASE+0x15a2)
#define MT6315_BUCK_VBUCK4_ANA_ID         (MT6315_PMIC_REG_BASE+0x1600)
#define MT6315_BUCK_VBUCK4_DIG_ID         (MT6315_PMIC_REG_BASE+0x1601)
#define MT6315_BUCK_VBUCK4_REV0           (MT6315_PMIC_REG_BASE+0x1602)
#define MT6315_BUCK_VBUCK4_REV1           (MT6315_PMIC_REG_BASE+0x1603)
#define MT6315_BUCK_VBUCK4_DBI0           (MT6315_PMIC_REG_BASE+0x1604)
#define MT6315_BUCK_VBUCK4_DBI1           (MT6315_PMIC_REG_BASE+0x1605)
#define MT6315_BUCK_VBUCK4_DXI            (MT6315_PMIC_REG_BASE+0x1606)
#define MT6315_BUCK_VBUCK4_CON1           (MT6315_PMIC_REG_BASE+0x1607)
#define MT6315_BUCK_VBUCK4_CON2           (MT6315_PMIC_REG_BASE+0x1608)
#define MT6315_BUCK_VBUCK4_SLP_CON        (MT6315_PMIC_REG_BASE+0x1609)
#define MT6315_BUCK_VBUCK4_DVS_CON        (MT6315_PMIC_REG_BASE+0x160a)
#define MT6315_BUCK_VBUCK4_CFG0           (MT6315_PMIC_REG_BASE+0x160b)
#define MT6315_BUCK_VBUCK4_CFG1           (MT6315_PMIC_REG_BASE+0x160c)
#define MT6315_BUCK_VBUCK4_OP_EN_0        (MT6315_PMIC_REG_BASE+0x160d)
#define MT6315_BUCK_VBUCK4_OP_EN_0_SET    (MT6315_PMIC_REG_BASE+0x160e)
#define MT6315_BUCK_VBUCK4_OP_EN_0_CLR    (MT6315_PMIC_REG_BASE+0x160f)
#define MT6315_BUCK_VBUCK4_OP_EN_1        (MT6315_PMIC_REG_BASE+0x1610)
#define MT6315_BUCK_VBUCK4_OP_EN_1_SET    (MT6315_PMIC_REG_BASE+0x1611)
#define MT6315_BUCK_VBUCK4_OP_EN_1_CLR    (MT6315_PMIC_REG_BASE+0x1612)
#define MT6315_BUCK_VBUCK4_OP_CFG_0       (MT6315_PMIC_REG_BASE+0x1613)
#define MT6315_BUCK_VBUCK4_OP_CFG_0_SET   (MT6315_PMIC_REG_BASE+0x1614)
#define MT6315_BUCK_VBUCK4_OP_CFG_0_CLR   (MT6315_PMIC_REG_BASE+0x1615)
#define MT6315_BUCK_VBUCK4_OP_MODE_0      (MT6315_PMIC_REG_BASE+0x1616)
#define MT6315_BUCK_VBUCK4_OP_MODE_0_SET  (MT6315_PMIC_REG_BASE+0x1617)
#define MT6315_BUCK_VBUCK4_OP_MODE_0_CLR  (MT6315_PMIC_REG_BASE+0x1618)
#define MT6315_BUCK_VBUCK4_DBG0           (MT6315_PMIC_REG_BASE+0x1619)
#define MT6315_BUCK_VBUCK4_DBG1           (MT6315_PMIC_REG_BASE+0x161a)
#define MT6315_BUCK_VBUCK4_DBG2           (MT6315_PMIC_REG_BASE+0x161b)
#define MT6315_BUCK_VBUCK4_DBG3           (MT6315_PMIC_REG_BASE+0x161c)
#define MT6315_BUCK_VBUCK4_DBG4           (MT6315_PMIC_REG_BASE+0x161d)
#define MT6315_BUCK_VBUCK4_DBG5           (MT6315_PMIC_REG_BASE+0x161e)
#define MT6315_BUCK_VBUCK4_TRACK0         (MT6315_PMIC_REG_BASE+0x161f)
#define MT6315_BUCK_VBUCK4_TRACK1         (MT6315_PMIC_REG_BASE+0x1620)
#define MT6315_BUCK_VBUCK4_TRACK2         (MT6315_PMIC_REG_BASE+0x1621)
#define MT6315_BUCK_VBUCK4_TRACK3         (MT6315_PMIC_REG_BASE+0x1622)
#define MT6315_BUCK_ANA0_ANA_ID           (MT6315_PMIC_REG_BASE+0x1680)
#define MT6315_BUCK_ANA0_DIG_ID           (MT6315_PMIC_REG_BASE+0x1681)
#define MT6315_BUCK_ANA0_DSN_REV0         (MT6315_PMIC_REG_BASE+0x1682)
#define MT6315_BUCK_ANA0_DSN_REV1         (MT6315_PMIC_REG_BASE+0x1683)
#define MT6315_BUCK_ANA0_DBI0             (MT6315_PMIC_REG_BASE+0x1684)
#define MT6315_BUCK_ANA0_DBI1             (MT6315_PMIC_REG_BASE+0x1685)
#define MT6315_BUCK_ANA0_DXI              (MT6315_PMIC_REG_BASE+0x1686)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON0   (MT6315_PMIC_REG_BASE+0x1687)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON1   (MT6315_PMIC_REG_BASE+0x1688)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON2   (MT6315_PMIC_REG_BASE+0x1689)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON3   (MT6315_PMIC_REG_BASE+0x168a)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON4   (MT6315_PMIC_REG_BASE+0x168b)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON5   (MT6315_PMIC_REG_BASE+0x168c)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON6   (MT6315_PMIC_REG_BASE+0x168d)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON7   (MT6315_PMIC_REG_BASE+0x168e)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON8   (MT6315_PMIC_REG_BASE+0x168f)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON9   (MT6315_PMIC_REG_BASE+0x1690)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON10  (MT6315_PMIC_REG_BASE+0x1691)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON11  (MT6315_PMIC_REG_BASE+0x1692)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON12  (MT6315_PMIC_REG_BASE+0x1693)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON13  (MT6315_PMIC_REG_BASE+0x1694)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON14  (MT6315_PMIC_REG_BASE+0x1695)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON15  (MT6315_PMIC_REG_BASE+0x1696)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON16  (MT6315_PMIC_REG_BASE+0x1697)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON17  (MT6315_PMIC_REG_BASE+0x1698)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON18  (MT6315_PMIC_REG_BASE+0x1699)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON19  (MT6315_PMIC_REG_BASE+0x169a)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON20  (MT6315_PMIC_REG_BASE+0x169b)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON21  (MT6315_PMIC_REG_BASE+0x169c)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON22  (MT6315_PMIC_REG_BASE+0x169d)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON23  (MT6315_PMIC_REG_BASE+0x169e)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON24  (MT6315_PMIC_REG_BASE+0x169f)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON25  (MT6315_PMIC_REG_BASE+0x16a0)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON26  (MT6315_PMIC_REG_BASE+0x16a1)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON27  (MT6315_PMIC_REG_BASE+0x16a2)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON28  (MT6315_PMIC_REG_BASE+0x16a3)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON29  (MT6315_PMIC_REG_BASE+0x16a4)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON30  (MT6315_PMIC_REG_BASE+0x16a5)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON31  (MT6315_PMIC_REG_BASE+0x16a6)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON32  (MT6315_PMIC_REG_BASE+0x16a7)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON33  (MT6315_PMIC_REG_BASE+0x16a8)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON34  (MT6315_PMIC_REG_BASE+0x16a9)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON35  (MT6315_PMIC_REG_BASE+0x16aa)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON36  (MT6315_PMIC_REG_BASE+0x16ab)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON37  (MT6315_PMIC_REG_BASE+0x16ac)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON38  (MT6315_PMIC_REG_BASE+0x16ad)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON39  (MT6315_PMIC_REG_BASE+0x16ae)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON40  (MT6315_PMIC_REG_BASE+0x16af)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON41  (MT6315_PMIC_REG_BASE+0x16b0)
#define MT6315_BUCK_TOP_4PHASE_ANA_CON42  (MT6315_PMIC_REG_BASE+0x16b1)
#define MT6315_BUCK_ANA0_ELR_NUM          (MT6315_PMIC_REG_BASE+0x16b2)
#define MT6315_BUCK_TOP_4PHASE_ELR_0      (MT6315_PMIC_REG_BASE+0x16b3)
#define MT6315_BUCK_TOP_4PHASE_ELR_1      (MT6315_PMIC_REG_BASE+0x16b4)
#define MT6315_BUCK_TOP_4PHASE_ELR_2      (MT6315_PMIC_REG_BASE+0x16b5)
#define MT6315_BUCK_TOP_4PHASE_ELR_3      (MT6315_PMIC_REG_BASE+0x16b6)
#define MT6315_BUCK_TOP_4PHASE_ELR_4      (MT6315_PMIC_REG_BASE+0x16b7)
#define MT6315_BUCK_TOP_4PHASE_ELR_5      (MT6315_PMIC_REG_BASE+0x16b8)
#define MT6315_BUCK_TOP_4PHASE_ELR_6      (MT6315_PMIC_REG_BASE+0x16b9)
#define MT6315_BUCK_TOP_4PHASE_ELR_7      (MT6315_PMIC_REG_BASE+0x16ba)
#define MT6315_BUCK_TOP_4PHASE_ELR_8      (MT6315_PMIC_REG_BASE+0x16bb)
#define MT6315_BUCK_TOP_4PHASE_ELR_9      (MT6315_PMIC_REG_BASE+0x16bc)
#define MT6315_BUCK_TOP_4PHASE_ELR_10     (MT6315_PMIC_REG_BASE+0x16bd)
#define MT6315_BUCK_TOP_4PHASE_ELR_11     (MT6315_PMIC_REG_BASE+0x16be)
#define MT6315_BUCK_TOP_4PHASE_ELR_12     (MT6315_PMIC_REG_BASE+0x16bf)
#define MT6315_BUCK_TOP_4PHASE_ELR_13     (MT6315_PMIC_REG_BASE+0x16c0)
#define MT6315_BUCK_TOP_4PHASE_ELR_14     (MT6315_PMIC_REG_BASE+0x16c1)
#define MT6315_BUCK_TOP_4PHASE_ELR_15     (MT6315_PMIC_REG_BASE+0x16c2)
#define MT6315_BUCK_TOP_4PHASE_ELR_16     (MT6315_PMIC_REG_BASE+0x16c3)
#define MT6315_BUCK_TOP_4PHASE_ELR_17     (MT6315_PMIC_REG_BASE+0x16c4)
#define MT6315_BUCK_TOP_4PHASE_ELR_18     (MT6315_PMIC_REG_BASE+0x16c5)
#define MT6315_BUCK_TOP_4PHASE_ELR_19     (MT6315_PMIC_REG_BASE+0x16c6)
#define MT6315_BUCK_TOP_4PHASE_ELR_20     (MT6315_PMIC_REG_BASE+0x16c7)
#define MT6315_BUCK_TOP_4PHASE_ELR_21     (MT6315_PMIC_REG_BASE+0x16c8)
#define MT6315_BUCK_TOP_4PHASE_ELR_22     (MT6315_PMIC_REG_BASE+0x16c9)
#define MT6315_BUCK_TOP_4PHASE_ELR_23     (MT6315_PMIC_REG_BASE+0x16ca)
#define MT6315_BUCK_TOP_4PHASE_ELR_24     (MT6315_PMIC_REG_BASE+0x16cb)
#define MT6315_BUCK_TOP_4PHASE_ELR_25     (MT6315_PMIC_REG_BASE+0x16cc)
#define MT6315_BUCK_TOP_4PHASE_ELR_26     (MT6315_PMIC_REG_BASE+0x16cd)
#define MT6315_BUCK_TOP_4PHASE_ELR_27     (MT6315_PMIC_REG_BASE+0x16ce)
#define MT6315_BUCK_TOP_4PHASE_ELR_28     (MT6315_PMIC_REG_BASE+0x16cf)
#define MT6315_BUCK_TOP_4PHASE_ELR_29     (MT6315_PMIC_REG_BASE+0x16d0)
//mask is HEX;  shift is Integer
#define MT6315_PMIC_TOP0_ANA_ID_ADDR                        \
	MT6315_TOP0_ID
#define MT6315_PMIC_TOP0_ANA_ID_MASK                        0xFF
#define MT6315_PMIC_TOP0_ANA_ID_SHIFT                       0
#define MT6315_PMIC_TOP0_DIG_ID_ADDR                        \
	MT6315_TOP0_ID_H
#define MT6315_PMIC_TOP0_DIG_ID_MASK                        0xFF
#define MT6315_PMIC_TOP0_DIG_ID_SHIFT                       0
#define MT6315_PMIC_TOP0_ANA_MINOR_REV_ADDR                 \
	MT6315_TOP0_REV0
#define MT6315_PMIC_TOP0_ANA_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP0_ANA_MINOR_REV_SHIFT                0
#define MT6315_PMIC_TOP0_ANA_MAJOR_REV_ADDR                 \
	MT6315_TOP0_REV0
#define MT6315_PMIC_TOP0_ANA_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP0_ANA_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_TOP0_DIG_MINOR_REV_ADDR                 \
	MT6315_TOP0_REV0_H
#define MT6315_PMIC_TOP0_DIG_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP0_DIG_MINOR_REV_SHIFT                0
#define MT6315_PMIC_TOP0_DIG_MAJOR_REV_ADDR                 \
	MT6315_TOP0_REV0_H
#define MT6315_PMIC_TOP0_DIG_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP0_DIG_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_TOP0_DSN_CBS_ADDR                       \
	MT6315_TOP0_DSN_DBI
#define MT6315_PMIC_TOP0_DSN_CBS_MASK                       0x3
#define MT6315_PMIC_TOP0_DSN_CBS_SHIFT                      0
#define MT6315_PMIC_TOP0_DSN_BIX_ADDR                       \
	MT6315_TOP0_DSN_DBI
#define MT6315_PMIC_TOP0_DSN_BIX_MASK                       0x3
#define MT6315_PMIC_TOP0_DSN_BIX_SHIFT                      2
#define MT6315_PMIC_TOP0_DSN_ESP_ADDR                       \
	MT6315_TOP0_DSN_DBI_H
#define MT6315_PMIC_TOP0_DSN_ESP_MASK                       0xFF
#define MT6315_PMIC_TOP0_DSN_ESP_SHIFT                      0
#define MT6315_PMIC_TOP0_DSN_FPI_ADDR                       \
	MT6315_TOP0_DSN_DXI
#define MT6315_PMIC_TOP0_DSN_FPI_MASK                       0xFF
#define MT6315_PMIC_TOP0_DSN_FPI_SHIFT                      0
#define MT6315_PMIC_TOP0_DUMMY_ADDR                         \
	MT6315_TOP0_DMY
#define MT6315_PMIC_TOP0_DUMMY_MASK                         0xFF
#define MT6315_PMIC_TOP0_DUMMY_SHIFT                        0
#define MT6315_PMIC_HWCID_L_ADDR                            \
	MT6315_HWCID_L
#define MT6315_PMIC_HWCID_L_MASK                            0xFF
#define MT6315_PMIC_HWCID_L_SHIFT                           0
#define MT6315_PMIC_HWCID_H_ADDR                            \
	MT6315_HWCID_H
#define MT6315_PMIC_HWCID_H_MASK                            0xFF
#define MT6315_PMIC_HWCID_H_SHIFT                           0
#define MT6315_PMIC_SWCID_L_ADDR                            \
	MT6315_SWCID_L
#define MT6315_PMIC_SWCID_L_MASK                            0xFF
#define MT6315_PMIC_SWCID_L_SHIFT                           0
#define MT6315_PMIC_SWCID_H_ADDR                            \
	MT6315_SWCID_H
#define MT6315_PMIC_SWCID_H_MASK                            0xFF
#define MT6315_PMIC_SWCID_H_SHIFT                           0
#define MT6315_PMIC_STS_OVLO_ADDR                           \
	MT6315_POFFSTS
#define MT6315_PMIC_STS_OVLO_MASK                           0x1
#define MT6315_PMIC_STS_OVLO_SHIFT                          0
#define MT6315_PMIC_STS_UVLO_ADDR                           \
	MT6315_POFFSTS
#define MT6315_PMIC_STS_UVLO_MASK                           0x1
#define MT6315_PMIC_STS_UVLO_SHIFT                          1
#define MT6315_PMIC_STS_PGFAIL_ADDR                         \
	MT6315_POFFSTS
#define MT6315_PMIC_STS_PGFAIL_MASK                         0x1
#define MT6315_PMIC_STS_PGFAIL_SHIFT                        2
#define MT6315_PMIC_STS_PSOC_ADDR                           \
	MT6315_POFFSTS
#define MT6315_PMIC_STS_PSOC_MASK                           0x1
#define MT6315_PMIC_STS_PSOC_SHIFT                          3
#define MT6315_PMIC_STS_THRDN_ADDR                          \
	MT6315_POFFSTS
#define MT6315_PMIC_STS_THRDN_MASK                          0x1
#define MT6315_PMIC_STS_THRDN_SHIFT                         4
#define MT6315_PMIC_STS_NORMOFF_ADDR                        \
	MT6315_POFFSTS
#define MT6315_PMIC_STS_NORMOFF_MASK                        0x1
#define MT6315_PMIC_STS_NORMOFF_SHIFT                       5
#define MT6315_PMIC_STS_ABNORMOFF_ADDR                      \
	MT6315_POFFSTS
#define MT6315_PMIC_STS_ABNORMOFF_MASK                      0x1
#define MT6315_PMIC_STS_ABNORMOFF_SHIFT                     6
#define MT6315_PMIC_STS_KEYPWR_ADDR                         \
	MT6315_POFFSTS
#define MT6315_PMIC_STS_KEYPWR_MASK                         0x1
#define MT6315_PMIC_STS_KEYPWR_SHIFT                        7
#define MT6315_PMIC_RG_POFFSTS_CLR_ADDR                     \
	MT6315_PSTSCTL
#define MT6315_PMIC_RG_POFFSTS_CLR_MASK                     0x1
#define MT6315_PMIC_RG_POFFSTS_CLR_SHIFT                    0
#define MT6315_PMIC_VBUCK1_PG_DEB_ADDR                      \
	MT6315_PG_DEB_STS0
#define MT6315_PMIC_VBUCK1_PG_DEB_MASK                      0x1
#define MT6315_PMIC_VBUCK1_PG_DEB_SHIFT                     0
#define MT6315_PMIC_VBUCK2_PG_DEB_ADDR                      \
	MT6315_PG_DEB_STS0
#define MT6315_PMIC_VBUCK2_PG_DEB_MASK                      0x1
#define MT6315_PMIC_VBUCK2_PG_DEB_SHIFT                     1
#define MT6315_PMIC_VBUCK3_PG_DEB_ADDR                      \
	MT6315_PG_DEB_STS0
#define MT6315_PMIC_VBUCK3_PG_DEB_MASK                      0x1
#define MT6315_PMIC_VBUCK3_PG_DEB_SHIFT                     2
#define MT6315_PMIC_VBUCK4_PG_DEB_ADDR                      \
	MT6315_PG_DEB_STS0
#define MT6315_PMIC_VBUCK4_PG_DEB_MASK                      0x1
#define MT6315_PMIC_VBUCK4_PG_DEB_SHIFT                     3
#define MT6315_PMIC_STRUP_VBUCK1_PG_STATUS_ADDR             \
	MT6315_PG_SDN_STS0
#define MT6315_PMIC_STRUP_VBUCK1_PG_STATUS_MASK             0x1
#define MT6315_PMIC_STRUP_VBUCK1_PG_STATUS_SHIFT            0
#define MT6315_PMIC_STRUP_VBUCK2_PG_STATUS_ADDR             \
	MT6315_PG_SDN_STS0
#define MT6315_PMIC_STRUP_VBUCK2_PG_STATUS_MASK             0x1
#define MT6315_PMIC_STRUP_VBUCK2_PG_STATUS_SHIFT            1
#define MT6315_PMIC_STRUP_VBUCK3_PG_STATUS_ADDR             \
	MT6315_PG_SDN_STS0
#define MT6315_PMIC_STRUP_VBUCK3_PG_STATUS_MASK             0x1
#define MT6315_PMIC_STRUP_VBUCK3_PG_STATUS_SHIFT            2
#define MT6315_PMIC_STRUP_VBUCK4_PG_STATUS_ADDR             \
	MT6315_PG_SDN_STS0
#define MT6315_PMIC_STRUP_VBUCK4_PG_STATUS_MASK             0x1
#define MT6315_PMIC_STRUP_VBUCK4_PG_STATUS_SHIFT            3
#define MT6315_PMIC_STRUP_VBUCK1_OC_STATUS_ADDR             \
	MT6315_OC_SDN_STS0
#define MT6315_PMIC_STRUP_VBUCK1_OC_STATUS_MASK             0x1
#define MT6315_PMIC_STRUP_VBUCK1_OC_STATUS_SHIFT            0
#define MT6315_PMIC_STRUP_VBUCK2_OC_STATUS_ADDR             \
	MT6315_OC_SDN_STS0
#define MT6315_PMIC_STRUP_VBUCK2_OC_STATUS_MASK             0x1
#define MT6315_PMIC_STRUP_VBUCK2_OC_STATUS_SHIFT            1
#define MT6315_PMIC_STRUP_VBUCK3_OC_STATUS_ADDR             \
	MT6315_OC_SDN_STS0
#define MT6315_PMIC_STRUP_VBUCK3_OC_STATUS_MASK             0x1
#define MT6315_PMIC_STRUP_VBUCK3_OC_STATUS_SHIFT            2
#define MT6315_PMIC_STRUP_VBUCK4_OC_STATUS_ADDR             \
	MT6315_OC_SDN_STS0
#define MT6315_PMIC_STRUP_VBUCK4_OC_STATUS_MASK             0x1
#define MT6315_PMIC_STRUP_VBUCK4_OC_STATUS_SHIFT            3
#define MT6315_PMIC_STRUP_THERMAL0_STATUS_ADDR              \
	MT6315_THERMALSTATUS
#define MT6315_PMIC_STRUP_THERMAL0_STATUS_MASK              0x1
#define MT6315_PMIC_STRUP_THERMAL0_STATUS_SHIFT             0
#define MT6315_PMIC_STRUP_THERMAL1_STATUS_ADDR              \
	MT6315_THERMALSTATUS
#define MT6315_PMIC_STRUP_THERMAL1_STATUS_MASK              0x1
#define MT6315_PMIC_STRUP_THERMAL1_STATUS_SHIFT             1
#define MT6315_PMIC_STRUP_THERMAL2_STATUS_ADDR              \
	MT6315_THERMALSTATUS
#define MT6315_PMIC_STRUP_THERMAL2_STATUS_MASK              0x1
#define MT6315_PMIC_STRUP_THERMAL2_STATUS_SHIFT             2
#define MT6315_PMIC_STRUP_THERMAL3_STATUS_ADDR              \
	MT6315_THERMALSTATUS
#define MT6315_PMIC_STRUP_THERMAL3_STATUS_MASK              0x1
#define MT6315_PMIC_STRUP_THERMAL3_STATUS_SHIFT             3
#define MT6315_PMIC_STRUP_THERMAL4_STATUS_ADDR              \
	MT6315_THERMALSTATUS
#define MT6315_PMIC_STRUP_THERMAL4_STATUS_MASK              0x1
#define MT6315_PMIC_STRUP_THERMAL4_STATUS_SHIFT             4
#define MT6315_PMIC_PMU_THERMAL0_DEB_ADDR                   \
	MT6315_THERMALDEB
#define MT6315_PMIC_PMU_THERMAL0_DEB_MASK                   0x1
#define MT6315_PMIC_PMU_THERMAL0_DEB_SHIFT                  0
#define MT6315_PMIC_PMU_THERMAL1_DEB_ADDR                   \
	MT6315_THERMALDEB
#define MT6315_PMIC_PMU_THERMAL1_DEB_MASK                   0x1
#define MT6315_PMIC_PMU_THERMAL1_DEB_SHIFT                  1
#define MT6315_PMIC_PMU_THERMAL2_DEB_ADDR                   \
	MT6315_THERMALDEB
#define MT6315_PMIC_PMU_THERMAL2_DEB_MASK                   0x1
#define MT6315_PMIC_PMU_THERMAL2_DEB_SHIFT                  2
#define MT6315_PMIC_PMU_THERMAL3_DEB_ADDR                   \
	MT6315_THERMALDEB
#define MT6315_PMIC_PMU_THERMAL3_DEB_MASK                   0x1
#define MT6315_PMIC_PMU_THERMAL3_DEB_SHIFT                  3
#define MT6315_PMIC_PMU_THERMAL4_DEB_ADDR                   \
	MT6315_THERMALDEB
#define MT6315_PMIC_PMU_THERMAL4_DEB_MASK                   0x1
#define MT6315_PMIC_PMU_THERMAL4_DEB_SHIFT                  4
#define MT6315_PMIC_RG_SRCLKEN_IN_EN_ADDR                   \
	MT6315_TOP_CON
#define MT6315_PMIC_RG_SRCLKEN_IN_EN_MASK                   0x1
#define MT6315_PMIC_RG_SRCLKEN_IN_EN_SHIFT                  0
#define MT6315_PMIC_RG_SRCLKEN_IN_HW_MODE_ADDR              \
	MT6315_TOP_CON
#define MT6315_PMIC_RG_SRCLKEN_IN_HW_MODE_MASK              0x1
#define MT6315_PMIC_RG_SRCLKEN_IN_HW_MODE_SHIFT             1
#define MT6315_PMIC_RG_SRCLKEN_IN_SYNC_EN_ADDR              \
	MT6315_TOP_CON
#define MT6315_PMIC_RG_SRCLKEN_IN_SYNC_EN_MASK              0x1
#define MT6315_PMIC_RG_SRCLKEN_IN_SYNC_EN_SHIFT             2
#define MT6315_PMIC_RG_OSC_EN_AUTO_OFF_ADDR                 \
	MT6315_TOP_CON
#define MT6315_PMIC_RG_OSC_EN_AUTO_OFF_MASK                 0x1
#define MT6315_PMIC_RG_OSC_EN_AUTO_OFF_SHIFT                3
#define MT6315_PMIC_TEST_OUT_ADDR                           \
	MT6315_TEST_OUT
#define MT6315_PMIC_TEST_OUT_MASK                           0xFF
#define MT6315_PMIC_TEST_OUT_SHIFT                          0
#define MT6315_PMIC_RG_MON_GRP_SEL_ADDR                     \
	MT6315_TEST_CON0
#define MT6315_PMIC_RG_MON_GRP_SEL_MASK                     0x1F
#define MT6315_PMIC_RG_MON_GRP_SEL_SHIFT                    0
#define MT6315_PMIC_RG_MON_FLAG_SEL_ADDR                    \
	MT6315_TEST_CON1
#define MT6315_PMIC_RG_MON_FLAG_SEL_MASK                    0xFF
#define MT6315_PMIC_RG_MON_FLAG_SEL_SHIFT                   0
#define MT6315_PMIC_RG_DBG0_OUT_SEL_ADDR                    \
	MT6315_TEST_CON2
#define MT6315_PMIC_RG_DBG0_OUT_SEL_MASK                    0x7
#define MT6315_PMIC_RG_DBG0_OUT_SEL_SHIFT                   0
#define MT6315_PMIC_RG_DBG1_OUT_SEL_ADDR                    \
	MT6315_TEST_CON2
#define MT6315_PMIC_RG_DBG1_OUT_SEL_MASK                    0x7
#define MT6315_PMIC_RG_DBG1_OUT_SEL_SHIFT                   4
#define MT6315_PMIC_RG_DBG2_OUT_SEL_ADDR                    \
	MT6315_TEST_CON3
#define MT6315_PMIC_RG_DBG2_OUT_SEL_MASK                    0x7
#define MT6315_PMIC_RG_DBG2_OUT_SEL_SHIFT                   0
#define MT6315_PMIC_RG_DBG3_OUT_SEL_ADDR                    \
	MT6315_TEST_CON3
#define MT6315_PMIC_RG_DBG3_OUT_SEL_MASK                    0x7
#define MT6315_PMIC_RG_DBG3_OUT_SEL_SHIFT                   4
#define MT6315_PMIC_RG_NANDTREE_MODE_ADDR                   \
	MT6315_TEST_CON4
#define MT6315_PMIC_RG_NANDTREE_MODE_MASK                   0x1
#define MT6315_PMIC_RG_NANDTREE_MODE_SHIFT                  1
#define MT6315_PMIC_RG_EFUSE_MODE_ADDR                      \
	MT6315_TEST_CON4
#define MT6315_PMIC_RG_EFUSE_MODE_MASK                      0x1
#define MT6315_PMIC_RG_EFUSE_MODE_SHIFT                     2
#define MT6315_PMIC_RG_TEST_STRUP_ADDR                      \
	MT6315_TEST_CON4
#define MT6315_PMIC_RG_TEST_STRUP_MASK                      0x1
#define MT6315_PMIC_RG_TEST_STRUP_SHIFT                     3
#define MT6315_PMIC_RG_ATST_KEY0_ADDR                       \
	MT6315_TEST_CON5
#define MT6315_PMIC_RG_ATST_KEY0_MASK                       0xFF
#define MT6315_PMIC_RG_ATST_KEY0_SHIFT                      0
#define MT6315_PMIC_RG_ATST_KEY1_ADDR                       \
	MT6315_TEST_CON6
#define MT6315_PMIC_RG_ATST_KEY1_MASK                       0xFF
#define MT6315_PMIC_RG_ATST_KEY1_SHIFT                      0
#define MT6315_PMIC_RG_ATST_KEY2_ADDR                       \
	MT6315_TEST_CON7
#define MT6315_PMIC_RG_ATST_KEY2_MASK                       0xFF
#define MT6315_PMIC_RG_ATST_KEY2_SHIFT                      0
#define MT6315_PMIC_RG_ATST_KEY3_ADDR                       \
	MT6315_TEST_CON8
#define MT6315_PMIC_RG_ATST_KEY3_MASK                       0xFF
#define MT6315_PMIC_RG_ATST_KEY3_SHIFT                      0
#define MT6315_PMIC_RG_SYS_LATCH_EN_SW_SEL_ADDR             \
	MT6315_TEST_CON9
#define MT6315_PMIC_RG_SYS_LATCH_EN_SW_SEL_MASK             0x1
#define MT6315_PMIC_RG_SYS_LATCH_EN_SW_SEL_SHIFT            0
#define MT6315_PMIC_RG_SYS_LATCH_EN_SW_ADDR                 \
	MT6315_TEST_CON9
#define MT6315_PMIC_RG_SYS_LATCH_EN_SW_MASK                 0x1
#define MT6315_PMIC_RG_SYS_LATCH_EN_SW_SHIFT                1
#define MT6315_PMIC_RG_PG_OUT_SW_SEL_ADDR                   \
	MT6315_TEST_CON9
#define MT6315_PMIC_RG_PG_OUT_SW_SEL_MASK                   0x1
#define MT6315_PMIC_RG_PG_OUT_SW_SEL_SHIFT                  2
#define MT6315_PMIC_RG_PG_OUT_SW_ADDR                       \
	MT6315_TEST_CON9
#define MT6315_PMIC_RG_PG_OUT_SW_MASK                       0x1
#define MT6315_PMIC_RG_PG_OUT_SW_SHIFT                      3
#define MT6315_PMIC_RG_PG_OUT_DBG_SEL_ADDR                  \
	MT6315_TEST_CON9
#define MT6315_PMIC_RG_PG_OUT_DBG_SEL_MASK                  0x1
#define MT6315_PMIC_RG_PG_OUT_DBG_SEL_SHIFT                 4
#define MT6315_PMIC_RG_ANA_IO_SW_SEL_ADDR                   \
	MT6315_TEST_CON9
#define MT6315_PMIC_RG_ANA_IO_SW_SEL_MASK                   0x1
#define MT6315_PMIC_RG_ANA_IO_SW_SEL_SHIFT                  5
#define MT6315_PMIC_RG_ANA_IO_SW_ADDR                       \
	MT6315_TEST_CON9
#define MT6315_PMIC_RG_ANA_IO_SW_MASK                       0x1
#define MT6315_PMIC_RG_ANA_IO_SW_SHIFT                      6
#define MT6315_PMIC_RG_OSC_EN_DBG_SEL_ADDR                  \
	MT6315_TEST_CON9
#define MT6315_PMIC_RG_OSC_EN_DBG_SEL_MASK                  0x1
#define MT6315_PMIC_RG_OSC_EN_DBG_SEL_SHIFT                 7
#define MT6315_PMIC_TESTMODE_SW_ADDR                        \
	MT6315_TESTMODE_SW
#define MT6315_PMIC_TESTMODE_SW_MASK                        0x1
#define MT6315_PMIC_TESTMODE_SW_SHIFT                       0
#define MT6315_PMIC_PMU_TEST_MODE_SCAN_ADDR                 \
	MT6315_TESTMODE_SW
#define MT6315_PMIC_PMU_TEST_MODE_SCAN_MASK                 0x1
#define MT6315_PMIC_PMU_TEST_MODE_SCAN_SHIFT                1
#define MT6315_PMIC_RG_PMU_TDSEL_ADDR                       \
	MT6315_TDSEL_CON
#define MT6315_PMIC_RG_PMU_TDSEL_MASK                       0x1
#define MT6315_PMIC_RG_PMU_TDSEL_SHIFT                      0
#define MT6315_PMIC_RG_SIF_TDSEL_ADDR                       \
	MT6315_TDSEL_CON
#define MT6315_PMIC_RG_SIF_TDSEL_MASK                       0x1
#define MT6315_PMIC_RG_SIF_TDSEL_SHIFT                      1
#define MT6315_PMIC_RG_PMU_RDSEL_ADDR                       \
	MT6315_RDSEL_CON
#define MT6315_PMIC_RG_PMU_RDSEL_MASK                       0x1
#define MT6315_PMIC_RG_PMU_RDSEL_SHIFT                      0
#define MT6315_PMIC_RG_SIF_RDSEL_ADDR                       \
	MT6315_RDSEL_CON
#define MT6315_PMIC_RG_SIF_RDSEL_MASK                       0x1
#define MT6315_PMIC_RG_SIF_RDSEL_SHIFT                      1
#define MT6315_PMIC_RG_SMT_SRCLKEN_IN_ADDR                  \
	MT6315_SMT_CON0
#define MT6315_PMIC_RG_SMT_SRCLKEN_IN_MASK                  0x1
#define MT6315_PMIC_RG_SMT_SRCLKEN_IN_SHIFT                 0
#define MT6315_PMIC_RG_SMT_SCLK_ADDR                        \
	MT6315_SMT_CON0
#define MT6315_PMIC_RG_SMT_SCLK_MASK                        0x1
#define MT6315_PMIC_RG_SMT_SCLK_SHIFT                       1
#define MT6315_PMIC_RG_SMT_SDAT_ADDR                        \
	MT6315_SMT_CON0
#define MT6315_PMIC_RG_SMT_SDAT_MASK                        0x1
#define MT6315_PMIC_RG_SMT_SDAT_SHIFT                       2
#define MT6315_PMIC_RG_SMT_PMIC_INT_ADDR                    \
	MT6315_SMT_CON0
#define MT6315_PMIC_RG_SMT_PMIC_INT_MASK                    0x1
#define MT6315_PMIC_RG_SMT_PMIC_INT_SHIFT                   3
#define MT6315_PMIC_RG_SMT_WDTRSTB_IN_ADDR                  \
	MT6315_SMT_CON0
#define MT6315_PMIC_RG_SMT_WDTRSTB_IN_MASK                  0x1
#define MT6315_PMIC_RG_SMT_WDTRSTB_IN_SHIFT                 4
#define MT6315_PMIC_RG_EH_SRCLKEN_IN_ADDR                   \
	MT6315_EH_CON0
#define MT6315_PMIC_RG_EH_SRCLKEN_IN_MASK                   0x1
#define MT6315_PMIC_RG_EH_SRCLKEN_IN_SHIFT                  0
#define MT6315_PMIC_RG_EH_PMIC_INT_ADDR                     \
	MT6315_EH_CON0
#define MT6315_PMIC_RG_EH_PMIC_INT_MASK                     0x1
#define MT6315_PMIC_RG_EH_PMIC_INT_SHIFT                    1
#define MT6315_PMIC_RG_EH1_SRCLKEN_IN_ADDR                  \
	MT6315_EH_CON0
#define MT6315_PMIC_RG_EH1_SRCLKEN_IN_MASK                  0x1
#define MT6315_PMIC_RG_EH1_SRCLKEN_IN_SHIFT                 2
#define MT6315_PMIC_RG_EH1_PMIC_INT_ADDR                    \
	MT6315_EH_CON0
#define MT6315_PMIC_RG_EH1_PMIC_INT_MASK                    0x1
#define MT6315_PMIC_RG_EH1_PMIC_INT_SHIFT                   3
#define MT6315_PMIC_RG_EH2_SRCLKEN_IN_ADDR                  \
	MT6315_EH_CON0
#define MT6315_PMIC_RG_EH2_SRCLKEN_IN_MASK                  0x1
#define MT6315_PMIC_RG_EH2_SRCLKEN_IN_SHIFT                 4
#define MT6315_PMIC_RG_EH2_PMIC_INT_ADDR                    \
	MT6315_EH_CON0
#define MT6315_PMIC_RG_EH2_PMIC_INT_MASK                    0x1
#define MT6315_PMIC_RG_EH2_PMIC_INT_SHIFT                   5
#define MT6315_PMIC_RG_RSEL_SRCLKEN_IN_ADDR                 \
	MT6315_RSEL_CON0
#define MT6315_PMIC_RG_RSEL_SRCLKEN_IN_MASK                 0x1
#define MT6315_PMIC_RG_RSEL_SRCLKEN_IN_SHIFT                0
#define MT6315_PMIC_RG_RSEL_PMIC_INT_ADDR                   \
	MT6315_RSEL_CON0
#define MT6315_PMIC_RG_RSEL_PMIC_INT_MASK                   0x1
#define MT6315_PMIC_RG_RSEL_PMIC_INT_SHIFT                  1
#define MT6315_PMIC_RG_RSEL_WDTRSTB_IN_ADDR                 \
	MT6315_RSEL_CON0
#define MT6315_PMIC_RG_RSEL_WDTRSTB_IN_MASK                 0x1
#define MT6315_PMIC_RG_RSEL_WDTRSTB_IN_SHIFT                2
#define MT6315_PMIC_RG_TOP_RSV0_ADDR                        \
	MT6315_TOP_RSV0
#define MT6315_PMIC_RG_TOP_RSV0_MASK                        0x1
#define MT6315_PMIC_RG_TOP_RSV0_SHIFT                       0
#define MT6315_PMIC_RG_TOP_RSV1_ADDR                        \
	MT6315_TOP_RSV1
#define MT6315_PMIC_RG_TOP_RSV1_MASK                        0x1
#define MT6315_PMIC_RG_TOP_RSV1_SHIFT                       0
#define MT6315_PMIC_RG_OCTL_SRCLKEN_IN_ADDR                 \
	MT6315_DRV_CON0
#define MT6315_PMIC_RG_OCTL_SRCLKEN_IN_MASK                 0xF
#define MT6315_PMIC_RG_OCTL_SRCLKEN_IN_SHIFT                0
#define MT6315_PMIC_RG_OCTL_PMIC_INT_ADDR                   \
	MT6315_DRV_CON0
#define MT6315_PMIC_RG_OCTL_PMIC_INT_MASK                   0xF
#define MT6315_PMIC_RG_OCTL_PMIC_INT_SHIFT                  4
#define MT6315_PMIC_RG_SRCLKEN_IN_FILTER_EN_ADDR            \
	MT6315_FILTER_CON0
#define MT6315_PMIC_RG_SRCLKEN_IN_FILTER_EN_MASK            0x1
#define MT6315_PMIC_RG_SRCLKEN_IN_FILTER_EN_SHIFT           0
#define MT6315_PMIC_RG_SCLK_FILTER_EN_ADDR                  \
	MT6315_FILTER_CON0
#define MT6315_PMIC_RG_SCLK_FILTER_EN_MASK                  0x1
#define MT6315_PMIC_RG_SCLK_FILTER_EN_SHIFT                 1
#define MT6315_PMIC_RG_SDAT_FILTER_EN_ADDR                  \
	MT6315_FILTER_CON0
#define MT6315_PMIC_RG_SDAT_FILTER_EN_MASK                  0x1
#define MT6315_PMIC_RG_SDAT_FILTER_EN_SHIFT                 2
#define MT6315_PMIC_RG_PMIC_INT_FILTER_EN_ADDR              \
	MT6315_FILTER_CON0
#define MT6315_PMIC_RG_PMIC_INT_FILTER_EN_MASK              0x1
#define MT6315_PMIC_RG_PMIC_INT_FILTER_EN_SHIFT             3
#define MT6315_PMIC_RG_WDTRSTB_IN_FILTER_EN_ADDR            \
	MT6315_FILTER_CON0
#define MT6315_PMIC_RG_WDTRSTB_IN_FILTER_EN_MASK            0x1
#define MT6315_PMIC_RG_WDTRSTB_IN_FILTER_EN_SHIFT           4
#define MT6315_PMIC_RG_SRCLKEN_IN_RCSEL_ADDR                \
	MT6315_FILTER_CON1
#define MT6315_PMIC_RG_SRCLKEN_IN_RCSEL_MASK                0x1
#define MT6315_PMIC_RG_SRCLKEN_IN_RCSEL_SHIFT               0
#define MT6315_PMIC_RG_SCLK_RCSEL_ADDR                      \
	MT6315_FILTER_CON1
#define MT6315_PMIC_RG_SCLK_RCSEL_MASK                      0x1
#define MT6315_PMIC_RG_SCLK_RCSEL_SHIFT                     1
#define MT6315_PMIC_RG_SDAT_RCSEL_ADDR                      \
	MT6315_FILTER_CON1
#define MT6315_PMIC_RG_SDAT_RCSEL_MASK                      0x1
#define MT6315_PMIC_RG_SDAT_RCSEL_SHIFT                     2
#define MT6315_PMIC_RG_PMIC_INT_RCSEL_ADDR                  \
	MT6315_FILTER_CON1
#define MT6315_PMIC_RG_PMIC_INT_RCSEL_MASK                  0x1
#define MT6315_PMIC_RG_PMIC_INT_RCSEL_SHIFT                 3
#define MT6315_PMIC_RG_WDTRSTB_IN_RCSEL_ADDR                \
	MT6315_FILTER_CON1
#define MT6315_PMIC_RG_WDTRSTB_IN_RCSEL_MASK                0x1
#define MT6315_PMIC_RG_WDTRSTB_IN_RCSEL_SHIFT               4
#define MT6315_PMIC_TOP_STATUS_ADDR                         \
	MT6315_TOP_STATUS
#define MT6315_PMIC_TOP_STATUS_MASK                         0xFF
#define MT6315_PMIC_TOP_STATUS_SHIFT                        0
#define MT6315_PMIC_TOP_STATUS_SET_ADDR                     \
	MT6315_TOP_STATUS_SET
#define MT6315_PMIC_TOP_STATUS_SET_MASK                     0x3
#define MT6315_PMIC_TOP_STATUS_SET_SHIFT                    0
#define MT6315_PMIC_TOP_STATUS_CLR_ADDR                     \
	MT6315_TOP_STATUS_CLR
#define MT6315_PMIC_TOP_STATUS_CLR_MASK                     0x3
#define MT6315_PMIC_TOP_STATUS_CLR_SHIFT                    0
#define MT6315_PMIC_RG_SEQ_OFF_ADDR                         \
	MT6315_TOP_PWOFF_CON
#define MT6315_PMIC_RG_SEQ_OFF_MASK                         0x1
#define MT6315_PMIC_RG_SEQ_OFF_SHIFT                        0
#define MT6315_PMIC_VM_MODE_ADDR                            \
	MT6315_TOP_TRAP
#define MT6315_PMIC_VM_MODE_MASK                            0x3
#define MT6315_PMIC_VM_MODE_SHIFT                           0
#define MT6315_PMIC_TOP1_ANA_ID_ADDR                        \
	MT6315_TOP1_ID
#define MT6315_PMIC_TOP1_ANA_ID_MASK                        0xFF
#define MT6315_PMIC_TOP1_ANA_ID_SHIFT                       0
#define MT6315_PMIC_TOP1_DIG_ID_ADDR                        \
	MT6315_TOP1_ID_H
#define MT6315_PMIC_TOP1_DIG_ID_MASK                        0xFF
#define MT6315_PMIC_TOP1_DIG_ID_SHIFT                       0
#define MT6315_PMIC_TOP1_ANA_MINOR_REV_ADDR                 \
	MT6315_TOP1_REV0
#define MT6315_PMIC_TOP1_ANA_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP1_ANA_MINOR_REV_SHIFT                0
#define MT6315_PMIC_TOP1_ANA_MAJOR_REV_ADDR                 \
	MT6315_TOP1_REV0
#define MT6315_PMIC_TOP1_ANA_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP1_ANA_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_TOP1_DIG_MINOR_REV_ADDR                 \
	MT6315_TOP1_REV0_H
#define MT6315_PMIC_TOP1_DIG_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP1_DIG_MINOR_REV_SHIFT                0
#define MT6315_PMIC_TOP1_DIG_MAJOR_REV_ADDR                 \
	MT6315_TOP1_REV0_H
#define MT6315_PMIC_TOP1_DIG_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP1_DIG_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_TOP1_DSN_CBS_ADDR                       \
	MT6315_TOP1_DSN_DBI
#define MT6315_PMIC_TOP1_DSN_CBS_MASK                       0x3
#define MT6315_PMIC_TOP1_DSN_CBS_SHIFT                      0
#define MT6315_PMIC_TOP1_DSN_BIX_ADDR                       \
	MT6315_TOP1_DSN_DBI
#define MT6315_PMIC_TOP1_DSN_BIX_MASK                       0x3
#define MT6315_PMIC_TOP1_DSN_BIX_SHIFT                      2
#define MT6315_PMIC_TOP1_DSN_ESP_ADDR                       \
	MT6315_TOP1_DSN_DBI_H
#define MT6315_PMIC_TOP1_DSN_ESP_MASK                       0xFF
#define MT6315_PMIC_TOP1_DSN_ESP_SHIFT                      0
#define MT6315_PMIC_TOP1_DSN_FPI_ADDR                       \
	MT6315_TOP1_DSN_DXI
#define MT6315_PMIC_TOP1_DSN_FPI_MASK                       0xFF
#define MT6315_PMIC_TOP1_DSN_FPI_SHIFT                      0
#define MT6315_PMIC_GPIO_DIR0_ADDR                          \
	MT6315_GPIO_DIR
#define MT6315_PMIC_GPIO_DIR0_MASK                          0xF
#define MT6315_PMIC_GPIO_DIR0_SHIFT                         0
#define MT6315_PMIC_GPIO_DIR0_SET_ADDR                      \
	MT6315_GPIO_DIR_SET
#define MT6315_PMIC_GPIO_DIR0_SET_MASK                      0xF
#define MT6315_PMIC_GPIO_DIR0_SET_SHIFT                     0
#define MT6315_PMIC_GPIO_DIR0_CLR_ADDR                      \
	MT6315_GPIO_DIR_CLR
#define MT6315_PMIC_GPIO_DIR0_CLR_MASK                      0xF
#define MT6315_PMIC_GPIO_DIR0_CLR_SHIFT                     0
#define MT6315_PMIC_GPIO_PULLEN0_ADDR                       \
	MT6315_GPIO_PULLEN0
#define MT6315_PMIC_GPIO_PULLEN0_MASK                       0xF
#define MT6315_PMIC_GPIO_PULLEN0_SHIFT                      0
#define MT6315_PMIC_GPIO_PULLEN0_SET_ADDR                   \
	MT6315_GPIO_PULLEN0_SET
#define MT6315_PMIC_GPIO_PULLEN0_SET_MASK                   0xF
#define MT6315_PMIC_GPIO_PULLEN0_SET_SHIFT                  0
#define MT6315_PMIC_GPIO_PULLEN0_CLR_ADDR                   \
	MT6315_GPIO_PULLEN0_CLR
#define MT6315_PMIC_GPIO_PULLEN0_CLR_MASK                   0xF
#define MT6315_PMIC_GPIO_PULLEN0_CLR_SHIFT                  0
#define MT6315_PMIC_GPIO_PULLSEL0_ADDR                      \
	MT6315_GPIO_PULLSEL0
#define MT6315_PMIC_GPIO_PULLSEL0_MASK                      0xF
#define MT6315_PMIC_GPIO_PULLSEL0_SHIFT                     0
#define MT6315_PMIC_GPIO_PULLSEL0_SET_ADDR                  \
	MT6315_GPIO_PULLSEL0_SET
#define MT6315_PMIC_GPIO_PULLSEL0_SET_MASK                  0xF
#define MT6315_PMIC_GPIO_PULLSEL0_SET_SHIFT                 0
#define MT6315_PMIC_GPIO_PULLSEL0_CLR_ADDR                  \
	MT6315_GPIO_PULLSEL0_CLR
#define MT6315_PMIC_GPIO_PULLSEL0_CLR_MASK                  0xF
#define MT6315_PMIC_GPIO_PULLSEL0_CLR_SHIFT                 0
#define MT6315_PMIC_GPIO_DINV0_ADDR                         \
	MT6315_GPIO_DINV
#define MT6315_PMIC_GPIO_DINV0_MASK                         0xF
#define MT6315_PMIC_GPIO_DINV0_SHIFT                        0
#define MT6315_PMIC_GPIO_DINV0_SET_ADDR                     \
	MT6315_GPIO_DINV_SET
#define MT6315_PMIC_GPIO_DINV0_SET_MASK                     0xF
#define MT6315_PMIC_GPIO_DINV0_SET_SHIFT                    0
#define MT6315_PMIC_GPIO_DINV0_CLR_ADDR                     \
	MT6315_GPIO_DINV_CLR
#define MT6315_PMIC_GPIO_DINV0_CLR_MASK                     0xF
#define MT6315_PMIC_GPIO_DINV0_CLR_SHIFT                    0
#define MT6315_PMIC_GPIO_DOUT0_ADDR                         \
	MT6315_GPIO_DOUT
#define MT6315_PMIC_GPIO_DOUT0_MASK                         0xF
#define MT6315_PMIC_GPIO_DOUT0_SHIFT                        0
#define MT6315_PMIC_GPIO_DOUT0_SET_ADDR                     \
	MT6315_GPIO_DOUT_SET
#define MT6315_PMIC_GPIO_DOUT0_SET_MASK                     0xF
#define MT6315_PMIC_GPIO_DOUT0_SET_SHIFT                    0
#define MT6315_PMIC_GPIO_DOUT0_CLR_ADDR                     \
	MT6315_GPIO_DOUT_CLR
#define MT6315_PMIC_GPIO_DOUT0_CLR_MASK                     0xF
#define MT6315_PMIC_GPIO_DOUT0_CLR_SHIFT                    0
#define MT6315_PMIC_GPIO_PI0_ADDR                           \
	MT6315_GPIO_PI
#define MT6315_PMIC_GPIO_PI0_MASK                           0xF
#define MT6315_PMIC_GPIO_PI0_SHIFT                          0
#define MT6315_PMIC_GPIO_POE0_ADDR                          \
	MT6315_GPIO_POE
#define MT6315_PMIC_GPIO_POE0_MASK                          0xF
#define MT6315_PMIC_GPIO_POE0_SHIFT                         0
#define MT6315_PMIC_GPIO0_MODE_ADDR                         \
	MT6315_GPIO_MODE0
#define MT6315_PMIC_GPIO0_MODE_MASK                         0x7
#define MT6315_PMIC_GPIO0_MODE_SHIFT                        0
#define MT6315_PMIC_GPIO1_MODE_ADDR                         \
	MT6315_GPIO_MODE0
#define MT6315_PMIC_GPIO1_MODE_MASK                         0x7
#define MT6315_PMIC_GPIO1_MODE_SHIFT                        4
#define MT6315_PMIC_GPIO_MODE0_SET_ADDR                     \
	MT6315_GPIO_MODE0_SET
#define MT6315_PMIC_GPIO_MODE0_SET_MASK                     0xFF
#define MT6315_PMIC_GPIO_MODE0_SET_SHIFT                    0
#define MT6315_PMIC_GPIO_MODE0_CLR_ADDR                     \
	MT6315_GPIO_MODE0_CLR
#define MT6315_PMIC_GPIO_MODE0_CLR_MASK                     0xFF
#define MT6315_PMIC_GPIO_MODE0_CLR_SHIFT                    0
#define MT6315_PMIC_GPIO2_MODE_ADDR                         \
	MT6315_GPIO_MODE1
#define MT6315_PMIC_GPIO2_MODE_MASK                         0x7
#define MT6315_PMIC_GPIO2_MODE_SHIFT                        0
#define MT6315_PMIC_GPIO3_MODE_ADDR                         \
	MT6315_GPIO_MODE1
#define MT6315_PMIC_GPIO3_MODE_MASK                         0x7
#define MT6315_PMIC_GPIO3_MODE_SHIFT                        4
#define MT6315_PMIC_GPIO_MODE1_SET_ADDR                     \
	MT6315_GPIO_MODE1_SET
#define MT6315_PMIC_GPIO_MODE1_SET_MASK                     0xFF
#define MT6315_PMIC_GPIO_MODE1_SET_SHIFT                    0
#define MT6315_PMIC_GPIO_MODE1_CLR_ADDR                     \
	MT6315_GPIO_MODE1_CLR
#define MT6315_PMIC_GPIO_MODE1_CLR_MASK                     0xFF
#define MT6315_PMIC_GPIO_MODE1_CLR_SHIFT                    0
#define MT6315_PMIC_GPIO_RSV_ADDR                           \
	MT6315_GPIO_RSV
#define MT6315_PMIC_GPIO_RSV_MASK                           0x1
#define MT6315_PMIC_GPIO_RSV_SHIFT                          0
#define MT6315_PMIC_RG_PAD_IE_FORCE_ADDR                    \
	MT6315_GPIO_CON
#define MT6315_PMIC_RG_PAD_IE_FORCE_MASK                    0x1
#define MT6315_PMIC_RG_PAD_IE_FORCE_SHIFT                   0
#define MT6315_PMIC_TOP2_ANA_ID_ADDR                        \
	MT6315_TOP2_ID
#define MT6315_PMIC_TOP2_ANA_ID_MASK                        0xFF
#define MT6315_PMIC_TOP2_ANA_ID_SHIFT                       0
#define MT6315_PMIC_TOP2_DIG_ID_ADDR                        \
	MT6315_TOP2_ID_H
#define MT6315_PMIC_TOP2_DIG_ID_MASK                        0xFF
#define MT6315_PMIC_TOP2_DIG_ID_SHIFT                       0
#define MT6315_PMIC_TOP2_ANA_MINOR_REV_ADDR                 \
	MT6315_TOP2_REV0
#define MT6315_PMIC_TOP2_ANA_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP2_ANA_MINOR_REV_SHIFT                0
#define MT6315_PMIC_TOP2_ANA_MAJOR_REV_ADDR                 \
	MT6315_TOP2_REV0
#define MT6315_PMIC_TOP2_ANA_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP2_ANA_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_TOP2_DIG_MINOR_REV_ADDR                 \
	MT6315_TOP2_REV0_H
#define MT6315_PMIC_TOP2_DIG_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP2_DIG_MINOR_REV_SHIFT                0
#define MT6315_PMIC_TOP2_DIG_MAJOR_REV_ADDR                 \
	MT6315_TOP2_REV0_H
#define MT6315_PMIC_TOP2_DIG_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP2_DIG_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_TOP2_DSN_CBS_ADDR                       \
	MT6315_TOP2_DSN_DBI
#define MT6315_PMIC_TOP2_DSN_CBS_MASK                       0x3
#define MT6315_PMIC_TOP2_DSN_CBS_SHIFT                      0
#define MT6315_PMIC_TOP2_DSN_BIX_ADDR                       \
	MT6315_TOP2_DSN_DBI
#define MT6315_PMIC_TOP2_DSN_BIX_MASK                       0x3
#define MT6315_PMIC_TOP2_DSN_BIX_SHIFT                      2
#define MT6315_PMIC_TOP2_DSN_ESP_ADDR                       \
	MT6315_TOP2_DSN_DBI_H
#define MT6315_PMIC_TOP2_DSN_ESP_MASK                       0xFF
#define MT6315_PMIC_TOP2_DSN_ESP_SHIFT                      0
#define MT6315_PMIC_TOP2_DSN_FPI_ADDR                       \
	MT6315_TOP2_DSN_DXI
#define MT6315_PMIC_TOP2_DSN_FPI_MASK                       0xFF
#define MT6315_PMIC_TOP2_DSN_FPI_SHIFT                      0
#define MT6315_PMIC_TOP_CLK_OFFSET_ADDR                     \
	MT6315_TOP_PAM0
#define MT6315_PMIC_TOP_CLK_OFFSET_MASK                     0xFF
#define MT6315_PMIC_TOP_CLK_OFFSET_SHIFT                    0
#define MT6315_PMIC_TOP_RST_OFFSET_ADDR                     \
	MT6315_TOP_PAM0_H
#define MT6315_PMIC_TOP_RST_OFFSET_MASK                     0xFF
#define MT6315_PMIC_TOP_RST_OFFSET_SHIFT                    0
#define MT6315_PMIC_TOP_INT_OFFSET_ADDR                     \
	MT6315_TOP_PAM1
#define MT6315_PMIC_TOP_INT_OFFSET_MASK                     0xFF
#define MT6315_PMIC_TOP_INT_OFFSET_SHIFT                    0
#define MT6315_PMIC_TOP_INT_LEN_ADDR                        \
	MT6315_TOP_PAM1_H
#define MT6315_PMIC_TOP_INT_LEN_MASK                        0xFF
#define MT6315_PMIC_TOP_INT_LEN_SHIFT                       0
#define MT6315_PMIC_RG_TRIM_128K_CK_PDN_ADDR                \
	MT6315_TOP_CKPDN_CON0
#define MT6315_PMIC_RG_TRIM_128K_CK_PDN_MASK                0x1
#define MT6315_PMIC_RG_TRIM_128K_CK_PDN_SHIFT               0
#define MT6315_PMIC_RG_TRIM_4M_CK_PDN_ADDR                  \
	MT6315_TOP_CKPDN_CON0
#define MT6315_PMIC_RG_TRIM_4M_CK_PDN_MASK                  0x1
#define MT6315_PMIC_RG_TRIM_4M_CK_PDN_SHIFT                 1
#define MT6315_PMIC_RG_RSV_CK_PDN_ADDR                      \
	MT6315_TOP_CKPDN_CON0
#define MT6315_PMIC_RG_RSV_CK_PDN_MASK                      0x1
#define MT6315_PMIC_RG_RSV_CK_PDN_SHIFT                     2
#define MT6315_PMIC_RG_FQMTR_32K_CK_PDN_ADDR                \
	MT6315_TOP_CKPDN_CON0
#define MT6315_PMIC_RG_FQMTR_32K_CK_PDN_MASK                0x1
#define MT6315_PMIC_RG_FQMTR_32K_CK_PDN_SHIFT               3
#define MT6315_PMIC_RG_FQMTR_CK_PDN_ADDR                    \
	MT6315_TOP_CKPDN_CON0
#define MT6315_PMIC_RG_FQMTR_CK_PDN_MASK                    0x1
#define MT6315_PMIC_RG_FQMTR_CK_PDN_SHIFT                   4
#define MT6315_PMIC_RG_INTRP_CK_PDN_ADDR                    \
	MT6315_TOP_CKPDN_CON0
#define MT6315_PMIC_RG_INTRP_CK_PDN_MASK                    0x1
#define MT6315_PMIC_RG_INTRP_CK_PDN_SHIFT                   5
#define MT6315_PMIC_TOP_CKPDN_CON0_SET_ADDR                 \
	MT6315_TOP_CKPDN_CON0_SET
#define MT6315_PMIC_TOP_CKPDN_CON0_SET_MASK                 0xFF
#define MT6315_PMIC_TOP_CKPDN_CON0_SET_SHIFT                0
#define MT6315_PMIC_TOP_CKPDN_CON0_CLR_ADDR                 \
	MT6315_TOP_CKPDN_CON0_CLR
#define MT6315_PMIC_TOP_CKPDN_CON0_CLR_MASK                 0xFF
#define MT6315_PMIC_TOP_CKPDN_CON0_CLR_SHIFT                0
#define MT6315_PMIC_RG_PMU128K_CK_PDN_ADDR                  \
	MT6315_TOP_CKPDN_CON1
#define MT6315_PMIC_RG_PMU128K_CK_PDN_MASK                  0x1
#define MT6315_PMIC_RG_PMU128K_CK_PDN_SHIFT                 0
#define MT6315_PMIC_RG_PMU32K_CK_PDN_ADDR                   \
	MT6315_TOP_CKPDN_CON1
#define MT6315_PMIC_RG_PMU32K_CK_PDN_MASK                   0x1
#define MT6315_PMIC_RG_PMU32K_CK_PDN_SHIFT                  1
#define MT6315_PMIC_RG_EFUSE_CK_PDN_ADDR                    \
	MT6315_TOP_CKPDN_CON1
#define MT6315_PMIC_RG_EFUSE_CK_PDN_MASK                    0x1
#define MT6315_PMIC_RG_EFUSE_CK_PDN_SHIFT                   2
#define MT6315_PMIC_RG_SMPS4M_CK_PDN_ADDR                   \
	MT6315_TOP_CKPDN_CON1
#define MT6315_PMIC_RG_SMPS4M_CK_PDN_MASK                   0x1
#define MT6315_PMIC_RG_SMPS4M_CK_PDN_SHIFT                  3
#define MT6315_PMIC_RG_SMPS1M_CK_PDN_ADDR                   \
	MT6315_TOP_CKPDN_CON1
#define MT6315_PMIC_RG_SMPS1M_CK_PDN_MASK                   0x1
#define MT6315_PMIC_RG_SMPS1M_CK_PDN_SHIFT                  4
#define MT6315_PMIC_RG_RFFE_CK_PDN_ADDR                     \
	MT6315_TOP_CKPDN_CON1
#define MT6315_PMIC_RG_RFFE_CK_PDN_MASK                     0x1
#define MT6315_PMIC_RG_RFFE_CK_PDN_SHIFT                    5
#define MT6315_PMIC_RG_SPMI_CK_PDN_ADDR                     \
	MT6315_TOP_CKPDN_CON1
#define MT6315_PMIC_RG_SPMI_CK_PDN_MASK                     0x1
#define MT6315_PMIC_RG_SPMI_CK_PDN_SHIFT                    6
#define MT6315_PMIC_RG_I2C_CK_PDN_ADDR                      \
	MT6315_TOP_CKPDN_CON1
#define MT6315_PMIC_RG_I2C_CK_PDN_MASK                      0x1
#define MT6315_PMIC_RG_I2C_CK_PDN_SHIFT                     7
#define MT6315_PMIC_TOP_CKPDN_CON1_SET_ADDR                 \
	MT6315_TOP_CKPDN_CON1_SET
#define MT6315_PMIC_TOP_CKPDN_CON1_SET_MASK                 0xFF
#define MT6315_PMIC_TOP_CKPDN_CON1_SET_SHIFT                0
#define MT6315_PMIC_TOP_CKPDN_CON1_CLR_ADDR                 \
	MT6315_TOP_CKPDN_CON1_CLR
#define MT6315_PMIC_TOP_CKPDN_CON1_CLR_MASK                 0xFF
#define MT6315_PMIC_TOP_CKPDN_CON1_CLR_SHIFT                0
#define MT6315_PMIC_RG_EFUSE_CK_CKSEL_ADDR                  \
	MT6315_TOP_CKSEL_CON0
#define MT6315_PMIC_RG_EFUSE_CK_CKSEL_MASK                  0x1
#define MT6315_PMIC_RG_EFUSE_CK_CKSEL_SHIFT                 0
#define MT6315_PMIC_RG_FQMTR_CK_CKSEL_ADDR                  \
	MT6315_TOP_CKSEL_CON0
#define MT6315_PMIC_RG_FQMTR_CK_CKSEL_MASK                  0x7
#define MT6315_PMIC_RG_FQMTR_CK_CKSEL_SHIFT                 1
#define MT6315_PMIC_RG_PMU32K_CK_CKSEL_ADDR                 \
	MT6315_TOP_CKSEL_CON0
#define MT6315_PMIC_RG_PMU32K_CK_CKSEL_MASK                 0x1
#define MT6315_PMIC_RG_PMU32K_CK_CKSEL_SHIFT                4
#define MT6315_PMIC_RG_TOP_CKSEL_CON0_RSV_ADDR              \
	MT6315_TOP_CKSEL_CON0
#define MT6315_PMIC_RG_TOP_CKSEL_CON0_RSV_MASK              0x7
#define MT6315_PMIC_RG_TOP_CKSEL_CON0_RSV_SHIFT             5
#define MT6315_PMIC_TOP_CKSEL_CON0_SET_ADDR                 \
	MT6315_TOP_CKSEL_CON0_SET
#define MT6315_PMIC_TOP_CKSEL_CON0_SET_MASK                 0xFF
#define MT6315_PMIC_TOP_CKSEL_CON0_SET_SHIFT                0
#define MT6315_PMIC_TOP_CKSEL_CON0_CLR_ADDR                 \
	MT6315_TOP_CKSEL_CON0_CLR
#define MT6315_PMIC_TOP_CKSEL_CON0_CLR_MASK                 0xFF
#define MT6315_PMIC_TOP_CKSEL_CON0_CLR_SHIFT                0
#define MT6315_PMIC_RG_REG_CK_DIVSEL_ADDR                   \
	MT6315_TOP_CKDIVSEL_CON0
#define MT6315_PMIC_RG_REG_CK_DIVSEL_MASK                   0x3
#define MT6315_PMIC_RG_REG_CK_DIVSEL_SHIFT                  0
#define MT6315_PMIC_TOP_CKDIVSEL_CON0_RSV_ADDR              \
	MT6315_TOP_CKDIVSEL_CON0
#define MT6315_PMIC_TOP_CKDIVSEL_CON0_RSV_MASK              0x3F
#define MT6315_PMIC_TOP_CKDIVSEL_CON0_RSV_SHIFT             2
#define MT6315_PMIC_TOP_CKDIVSEL_CON0_SET_ADDR              \
	MT6315_TOP_CKDIVSEL_CON0_SET
#define MT6315_PMIC_TOP_CKDIVSEL_CON0_SET_MASK              0xFF
#define MT6315_PMIC_TOP_CKDIVSEL_CON0_SET_SHIFT             0
#define MT6315_PMIC_TOP_CKDIVSEL_CON0_CLR_ADDR              \
	MT6315_TOP_CKDIVSEL_CON0_CLR
#define MT6315_PMIC_TOP_CKDIVSEL_CON0_CLR_MASK              0xFF
#define MT6315_PMIC_TOP_CKDIVSEL_CON0_CLR_SHIFT             0
#define MT6315_PMIC_RG_EFUSE_CK_PDN_HWEN_ADDR               \
	MT6315_TOP_CKHWEN_CON0
#define MT6315_PMIC_RG_EFUSE_CK_PDN_HWEN_MASK               0x1
#define MT6315_PMIC_RG_EFUSE_CK_PDN_HWEN_SHIFT              0
#define MT6315_PMIC_RG_SMPS4M_CK_PDN_HWEN_ADDR              \
	MT6315_TOP_CKHWEN_CON0
#define MT6315_PMIC_RG_SMPS4M_CK_PDN_HWEN_MASK              0x1
#define MT6315_PMIC_RG_SMPS4M_CK_PDN_HWEN_SHIFT             1
#define MT6315_PMIC_RG_SMPS1M_CK_PDN_HWEN_ADDR              \
	MT6315_TOP_CKHWEN_CON0
#define MT6315_PMIC_RG_SMPS1M_CK_PDN_HWEN_MASK              0x1
#define MT6315_PMIC_RG_SMPS1M_CK_PDN_HWEN_SHIFT             2
#define MT6315_PMIC_TOP_CKHWEN_CON0_RSV_ADDR                \
	MT6315_TOP_CKHWEN_CON0
#define MT6315_PMIC_TOP_CKHWEN_CON0_RSV_MASK                0x7
#define MT6315_PMIC_TOP_CKHWEN_CON0_RSV_SHIFT               3
#define MT6315_PMIC_TOP_CKHWEN_CON0_SET_ADDR                \
	MT6315_TOP_CKHWEN_CON0_SET
#define MT6315_PMIC_TOP_CKHWEN_CON0_SET_MASK                0xFF
#define MT6315_PMIC_TOP_CKHWEN_CON0_SET_SHIFT               0
#define MT6315_PMIC_TOP_CKHWEN_CON0_CLR_ADDR                \
	MT6315_TOP_CKHWEN_CON0_CLR
#define MT6315_PMIC_TOP_CKHWEN_CON0_CLR_MASK                0xFF
#define MT6315_PMIC_TOP_CKHWEN_CON0_CLR_SHIFT               0
#define MT6315_PMIC_DA_SMPS_OSC_EN_ADDR                     \
	MT6315_TOP_SMPS_OSC_DBG
#define MT6315_PMIC_DA_SMPS_OSC_EN_MASK                     0x1
#define MT6315_PMIC_DA_SMPS_OSC_EN_SHIFT                    0
#define MT6315_PMIC_SMPS4M_CKEN_BUCK_ADDR                   \
	MT6315_TOP_SMPS_OSC_DBG
#define MT6315_PMIC_SMPS4M_CKEN_BUCK_MASK                   0x1
#define MT6315_PMIC_SMPS4M_CKEN_BUCK_SHIFT                  1
#define MT6315_PMIC_SMPS1M_CKEN_BUCK_ADDR                   \
	MT6315_TOP_SMPS_OSC_DBG
#define MT6315_PMIC_SMPS1M_CKEN_BUCK_MASK                   0x1
#define MT6315_PMIC_SMPS1M_CKEN_BUCK_SHIFT                  2
#define MT6315_PMIC_RG_PMU128K_CK_TST_DIS_ADDR              \
	MT6315_TOP_CKTST_CON0
#define MT6315_PMIC_RG_PMU128K_CK_TST_DIS_MASK              0x1
#define MT6315_PMIC_RG_PMU128K_CK_TST_DIS_SHIFT             0
#define MT6315_PMIC_RG_SMPS_CK_TST_DIS_ADDR                 \
	MT6315_TOP_CKTST_CON0
#define MT6315_PMIC_RG_SMPS_CK_TST_DIS_MASK                 0x1
#define MT6315_PMIC_RG_SMPS_CK_TST_DIS_SHIFT                1
#define MT6315_PMIC_TOP_CKTST_CON0_RSV_ADDR                 \
	MT6315_TOP_CKTST_CON0
#define MT6315_PMIC_TOP_CKTST_CON0_RSV_MASK                 0x3F
#define MT6315_PMIC_TOP_CKTST_CON0_RSV_SHIFT                2
#define MT6315_PMIC_RG_PMU128K_CK_TSTSEL_ADDR               \
	MT6315_TOP_CKTST_CON1
#define MT6315_PMIC_RG_PMU128K_CK_TSTSEL_MASK               0x1
#define MT6315_PMIC_RG_PMU128K_CK_TSTSEL_SHIFT              0
#define MT6315_PMIC_RG_SMPS_CK_TSTSEL_ADDR                  \
	MT6315_TOP_CKTST_CON1
#define MT6315_PMIC_RG_SMPS_CK_TSTSEL_MASK                  0x1
#define MT6315_PMIC_RG_SMPS_CK_TSTSEL_SHIFT                 1
#define MT6315_PMIC_RG_EFUSE_CK_TSTSEL_ADDR                 \
	MT6315_TOP_CKTST_CON1
#define MT6315_PMIC_RG_EFUSE_CK_TSTSEL_MASK                 0x1
#define MT6315_PMIC_RG_EFUSE_CK_TSTSEL_SHIFT                2
#define MT6315_PMIC_RG_FQMTR_CK_TSTSEL_ADDR                 \
	MT6315_TOP_CKTST_CON1
#define MT6315_PMIC_RG_FQMTR_CK_TSTSEL_MASK                 0x1
#define MT6315_PMIC_RG_FQMTR_CK_TSTSEL_SHIFT                3
#define MT6315_PMIC_RG_OSC_EN_SW_SEL_ADDR                   \
	MT6315_TOP_CLK_CON0
#define MT6315_PMIC_RG_OSC_EN_SW_SEL_MASK                   0x1
#define MT6315_PMIC_RG_OSC_EN_SW_SEL_SHIFT                  0
#define MT6315_PMIC_RG_OSC_EN_SW_ADDR                       \
	MT6315_TOP_CLK_CON0
#define MT6315_PMIC_RG_OSC_EN_SW_MASK                       0x1
#define MT6315_PMIC_RG_OSC_EN_SW_SHIFT                      1
#define MT6315_PMIC_RG_BUCK_LP_EN_ADDR                      \
	MT6315_TOP_CLK_CON0
#define MT6315_PMIC_RG_BUCK_LP_EN_MASK                      0x1
#define MT6315_PMIC_RG_BUCK_LP_EN_SHIFT                     4
#define MT6315_PMIC_RG_SRCLKEN_LP_EN_ADDR                   \
	MT6315_TOP_CLK_CON0
#define MT6315_PMIC_RG_SRCLKEN_LP_EN_MASK                   0x1
#define MT6315_PMIC_RG_SRCLKEN_LP_EN_SHIFT                  5
#define MT6315_PMIC_RG_BUCK_OSC_CTRL_ONLY_ADDR              \
	MT6315_TOP_CLK_CON0
#define MT6315_PMIC_RG_BUCK_OSC_CTRL_ONLY_MASK              0x1
#define MT6315_PMIC_RG_BUCK_OSC_CTRL_ONLY_SHIFT             6
#define MT6315_PMIC_RG_EFUSE_MAN_RST_ADDR                   \
	MT6315_TOP_RST_CON0
#define MT6315_PMIC_RG_EFUSE_MAN_RST_MASK                   0x1
#define MT6315_PMIC_RG_EFUSE_MAN_RST_SHIFT                  0
#define MT6315_PMIC_RG_FQMTR_RST_ADDR                       \
	MT6315_TOP_RST_CON0
#define MT6315_PMIC_RG_FQMTR_RST_MASK                       0x1
#define MT6315_PMIC_RG_FQMTR_RST_SHIFT                      2
#define MT6315_PMIC_RG_CLK_TRIM_128K_RST_ADDR               \
	MT6315_TOP_RST_CON0
#define MT6315_PMIC_RG_CLK_TRIM_128K_RST_MASK               0x1
#define MT6315_PMIC_RG_CLK_TRIM_128K_RST_SHIFT              4
#define MT6315_PMIC_RG_CLK_TRIM_4M_RST_ADDR                 \
	MT6315_TOP_RST_CON0
#define MT6315_PMIC_RG_CLK_TRIM_4M_RST_MASK                 0x1
#define MT6315_PMIC_RG_CLK_TRIM_4M_RST_SHIFT                5
#define MT6315_PMIC_RG_BUCK_SRCLKEN_RST_ADDR                \
	MT6315_TOP_RST_CON0
#define MT6315_PMIC_RG_BUCK_SRCLKEN_RST_MASK                0x1
#define MT6315_PMIC_RG_BUCK_SRCLKEN_RST_SHIFT               6
#define MT6315_PMIC_TOP_RST_CON0_SET_ADDR                   \
	MT6315_TOP_RST_CON0_SET
#define MT6315_PMIC_TOP_RST_CON0_SET_MASK                   0xFF
#define MT6315_PMIC_TOP_RST_CON0_SET_SHIFT                  0
#define MT6315_PMIC_TOP_RST_CON0_CLR_ADDR                   \
	MT6315_TOP_RST_CON0_CLR
#define MT6315_PMIC_TOP_RST_CON0_CLR_MASK                   0xFF
#define MT6315_PMIC_TOP_RST_CON0_CLR_SHIFT                  0
#define MT6315_PMIC_RG_BUCK_PROT_PMPP_RST_ADDR              \
	MT6315_TOP_RST_CON1
#define MT6315_PMIC_RG_BUCK_PROT_PMPP_RST_MASK              0x1
#define MT6315_PMIC_RG_BUCK_PROT_PMPP_RST_SHIFT             0
#define MT6315_PMIC_RG_FT_VR_SYSRSTB_ADDR                   \
	MT6315_TOP_RST_CON1
#define MT6315_PMIC_RG_FT_VR_SYSRSTB_MASK                   0x1
#define MT6315_PMIC_RG_FT_VR_SYSRSTB_SHIFT                  1
#define MT6315_PMIC_TOP_RST_CON1_RSV_ADDR                   \
	MT6315_TOP_RST_CON1
#define MT6315_PMIC_TOP_RST_CON1_RSV_MASK                   0x7
#define MT6315_PMIC_TOP_RST_CON1_RSV_SHIFT                  2
#define MT6315_PMIC_TOP_RST_CON1_SET_ADDR                   \
	MT6315_TOP_RST_CON1_SET
#define MT6315_PMIC_TOP_RST_CON1_SET_MASK                   0xFF
#define MT6315_PMIC_TOP_RST_CON1_SET_SHIFT                  0
#define MT6315_PMIC_TOP_RST_CON1_CLR_ADDR                   \
	MT6315_TOP_RST_CON1_CLR
#define MT6315_PMIC_TOP_RST_CON1_CLR_MASK                   0xFF
#define MT6315_PMIC_TOP_RST_CON1_CLR_SHIFT                  0
#define MT6315_PMIC_TOP_RST_CON2_RSV_ADDR                   \
	MT6315_TOP_RST_CON2
#define MT6315_PMIC_TOP_RST_CON2_RSV_MASK                   0xF
#define MT6315_PMIC_TOP_RST_CON2_RSV_SHIFT                  4
#define MT6315_PMIC_RG_GPIO_RST_SEL_ADDR                    \
	MT6315_TOP_RST_CON3
#define MT6315_PMIC_RG_GPIO_RST_SEL_MASK                    0x1
#define MT6315_PMIC_RG_GPIO_RST_SEL_SHIFT                   0
#define MT6315_PMIC_RG_WDTRSTB_EN_ADDR                      \
	MT6315_TOP_RST_MISC
#define MT6315_PMIC_RG_WDTRSTB_EN_MASK                      0x1
#define MT6315_PMIC_RG_WDTRSTB_EN_SHIFT                     0
#define MT6315_PMIC_RG_WDTRSTB_DEB_ADDR                     \
	MT6315_TOP_RST_MISC
#define MT6315_PMIC_RG_WDTRSTB_DEB_MASK                     0x1
#define MT6315_PMIC_RG_WDTRSTB_DEB_SHIFT                    1
#define MT6315_PMIC_WDTRSTB_STATUS_ADDR                     \
	MT6315_TOP_RST_MISC
#define MT6315_PMIC_WDTRSTB_STATUS_MASK                     0x1
#define MT6315_PMIC_WDTRSTB_STATUS_SHIFT                    2
#define MT6315_PMIC_WDTRSTB_STATUS_CLR_ADDR                 \
	MT6315_TOP_RST_MISC
#define MT6315_PMIC_WDTRSTB_STATUS_CLR_MASK                 0x1
#define MT6315_PMIC_WDTRSTB_STATUS_CLR_SHIFT                3
#define MT6315_PMIC_TOP_RST_MISC_SET_ADDR                   \
	MT6315_TOP_RST_MISC_SET
#define MT6315_PMIC_TOP_RST_MISC_SET_MASK                   0xFF
#define MT6315_PMIC_TOP_RST_MISC_SET_SHIFT                  0
#define MT6315_PMIC_TOP_RST_MISC_CLR_ADDR                   \
	MT6315_TOP_RST_MISC_CLR
#define MT6315_PMIC_TOP_RST_MISC_CLR_MASK                   0xFF
#define MT6315_PMIC_TOP_RST_MISC_CLR_SHIFT                  0
#define MT6315_PMIC_VPWRIN_RSTB_STATUS_ADDR                 \
	MT6315_TOP_RST_STATUS
#define MT6315_PMIC_VPWRIN_RSTB_STATUS_MASK                 0x1
#define MT6315_PMIC_VPWRIN_RSTB_STATUS_SHIFT                0
#define MT6315_PMIC_UVLO_RSTB_STATUS_ADDR                   \
	MT6315_TOP_RST_STATUS
#define MT6315_PMIC_UVLO_RSTB_STATUS_MASK                   0x1
#define MT6315_PMIC_UVLO_RSTB_STATUS_SHIFT                  1
#define MT6315_PMIC_TOP_RST_STATUS_RSV_ADDR                 \
	MT6315_TOP_RST_STATUS
#define MT6315_PMIC_TOP_RST_STATUS_RSV_MASK                 0x3
#define MT6315_PMIC_TOP_RST_STATUS_RSV_SHIFT                2
#define MT6315_PMIC_TOP_RST_STATUS_SET_ADDR                 \
	MT6315_TOP_RST_STATUS_SET
#define MT6315_PMIC_TOP_RST_STATUS_SET_MASK                 0xFF
#define MT6315_PMIC_TOP_RST_STATUS_SET_SHIFT                0
#define MT6315_PMIC_TOP_RST_STATUS_CLR_ADDR                 \
	MT6315_TOP_RST_STATUS_CLR
#define MT6315_PMIC_TOP_RST_STATUS_CLR_MASK                 0xFF
#define MT6315_PMIC_TOP_RST_STATUS_CLR_SHIFT                0
#define MT6315_PMIC_FQMTR_EN_ADDR                           \
	MT6315_TOP_FQMTR_CON0
#define MT6315_PMIC_FQMTR_EN_MASK                           0x1
#define MT6315_PMIC_FQMTR_EN_SHIFT                          0
#define MT6315_PMIC_FQMTR_TCKSEL_ADDR                       \
	MT6315_TOP_FQMTR_CON0
#define MT6315_PMIC_FQMTR_TCKSEL_MASK                       0x7
#define MT6315_PMIC_FQMTR_TCKSEL_SHIFT                      4
#define MT6315_PMIC_FQMTR_BUSY_ADDR                         \
	MT6315_TOP_FQMTR_CON0
#define MT6315_PMIC_FQMTR_BUSY_MASK                         0x1
#define MT6315_PMIC_FQMTR_BUSY_SHIFT                        7
#define MT6315_PMIC_FQMTR_WINSET_0_ADDR                     \
	MT6315_TOP_FQMTR_CON1
#define MT6315_PMIC_FQMTR_WINSET_0_MASK                     0xFF
#define MT6315_PMIC_FQMTR_WINSET_0_SHIFT                    0
#define MT6315_PMIC_FQMTR_WINSET_1_ADDR                     \
	MT6315_TOP_FQMTR_CON2
#define MT6315_PMIC_FQMTR_WINSET_1_MASK                     0xFF
#define MT6315_PMIC_FQMTR_WINSET_1_SHIFT                    0
#define MT6315_PMIC_FQMTR_DATA_0_ADDR                       \
	MT6315_TOP_FQMTR_DAT0
#define MT6315_PMIC_FQMTR_DATA_0_MASK                       0xFF
#define MT6315_PMIC_FQMTR_DATA_0_SHIFT                      0
#define MT6315_PMIC_FQMTR_DATA_1_ADDR                       \
	MT6315_TOP_FQMTR_DAT1
#define MT6315_PMIC_FQMTR_DATA_1_MASK                       0xFF
#define MT6315_PMIC_FQMTR_DATA_1_SHIFT                      0
#define MT6315_PMIC_TOP2_ELR_LEN_ADDR                       \
	MT6315_TOP2_ELR_NUM
#define MT6315_PMIC_TOP2_ELR_LEN_MASK                       0xFF
#define MT6315_PMIC_TOP2_ELR_LEN_SHIFT                      0
#define MT6315_PMIC_RG_SIF_SEL_ADDR                         \
	MT6315_TOP2_ELR0
#define MT6315_PMIC_RG_SIF_SEL_MASK                         0x3
#define MT6315_PMIC_RG_SIF_SEL_SHIFT                        0
#define MT6315_PMIC_RG_SIF_PULL_AUTO_ADDR                   \
	MT6315_TOP2_ELR0
#define MT6315_PMIC_RG_SIF_PULL_AUTO_MASK                   0x1
#define MT6315_PMIC_RG_SIF_PULL_AUTO_SHIFT                  2
#define MT6315_PMIC_RG_SIF_PULL_BY_EFUSE_ADDR               \
	MT6315_TOP2_ELR0
#define MT6315_PMIC_RG_SIF_PULL_BY_EFUSE_MASK               0x1
#define MT6315_PMIC_RG_SIF_PULL_BY_EFUSE_SHIFT              3
#define MT6315_PMIC_RG_SIF_PULLEN_ADDR                      \
	MT6315_TOP2_ELR0
#define MT6315_PMIC_RG_SIF_PULLEN_MASK                      0x3
#define MT6315_PMIC_RG_SIF_PULLEN_SHIFT                     4
#define MT6315_PMIC_RG_SIF_PULLSEL_ADDR                     \
	MT6315_TOP2_ELR0
#define MT6315_PMIC_RG_SIF_PULLSEL_MASK                     0x3
#define MT6315_PMIC_RG_SIF_PULLSEL_SHIFT                    6
#define MT6315_PMIC_RG_EH_SCLK_ADDR                         \
	MT6315_TOP2_ELR1
#define MT6315_PMIC_RG_EH_SCLK_MASK                         0x1
#define MT6315_PMIC_RG_EH_SCLK_SHIFT                        0
#define MT6315_PMIC_RG_EH_SDAT_ADDR                         \
	MT6315_TOP2_ELR1
#define MT6315_PMIC_RG_EH_SDAT_MASK                         0x1
#define MT6315_PMIC_RG_EH_SDAT_SHIFT                        1
#define MT6315_PMIC_RG_EH1_SCLK_ADDR                        \
	MT6315_TOP2_ELR1
#define MT6315_PMIC_RG_EH1_SCLK_MASK                        0x1
#define MT6315_PMIC_RG_EH1_SCLK_SHIFT                       2
#define MT6315_PMIC_RG_EH1_SDAT_ADDR                        \
	MT6315_TOP2_ELR1
#define MT6315_PMIC_RG_EH1_SDAT_MASK                        0x1
#define MT6315_PMIC_RG_EH1_SDAT_SHIFT                       3
#define MT6315_PMIC_RG_EH2_SCLK_ADDR                        \
	MT6315_TOP2_ELR1
#define MT6315_PMIC_RG_EH2_SCLK_MASK                        0x1
#define MT6315_PMIC_RG_EH2_SCLK_SHIFT                       4
#define MT6315_PMIC_RG_EH2_SDAT_ADDR                        \
	MT6315_TOP2_ELR1
#define MT6315_PMIC_RG_EH2_SDAT_MASK                        0x1
#define MT6315_PMIC_RG_EH2_SDAT_SHIFT                       5
#define MT6315_PMIC_RG_RSEL_SCLK_ADDR                       \
	MT6315_TOP2_ELR1
#define MT6315_PMIC_RG_RSEL_SCLK_MASK                       0x1
#define MT6315_PMIC_RG_RSEL_SCLK_SHIFT                      6
#define MT6315_PMIC_RG_RSEL_SDAT_ADDR                       \
	MT6315_TOP2_ELR1
#define MT6315_PMIC_RG_RSEL_SDAT_MASK                       0x1
#define MT6315_PMIC_RG_RSEL_SDAT_SHIFT                      7
#define MT6315_PMIC_RG_OCTL_SCLK_ADDR                       \
	MT6315_TOP2_ELR2
#define MT6315_PMIC_RG_OCTL_SCLK_MASK                       0xF
#define MT6315_PMIC_RG_OCTL_SCLK_SHIFT                      0
#define MT6315_PMIC_RG_OCTL_SDAT_ADDR                       \
	MT6315_TOP2_ELR2
#define MT6315_PMIC_RG_OCTL_SDAT_MASK                       0xF
#define MT6315_PMIC_RG_OCTL_SDAT_SHIFT                      4
#define MT6315_PMIC_RG_TOP2_RSV0_ADDR                       \
	MT6315_TOP2_ELR3
#define MT6315_PMIC_RG_TOP2_RSV0_MASK                       0xFF
#define MT6315_PMIC_RG_TOP2_RSV0_SHIFT                      0
#define MT6315_PMIC_RG_SLV_ID_ADDR                          \
	MT6315_TOP2_ELR4
#define MT6315_PMIC_RG_SLV_ID_MASK                          0xFF
#define MT6315_PMIC_RG_SLV_ID_SHIFT                         0
#define MT6315_PMIC_RG_SLV_CON0_ADDR                        \
	MT6315_TOP2_ELR5
#define MT6315_PMIC_RG_SLV_CON0_MASK                        0xFF
#define MT6315_PMIC_RG_SLV_CON0_SHIFT                       0
#define MT6315_PMIC_RG_WDTRSTB_SRC_SEL_ADDR                 \
	MT6315_TOP2_ELR6
#define MT6315_PMIC_RG_WDTRSTB_SRC_SEL_MASK                 0x1
#define MT6315_PMIC_RG_WDTRSTB_SRC_SEL_SHIFT                0
#define MT6315_PMIC_RG_SRCLKEN_SRC_SEL_ADDR                 \
	MT6315_TOP2_ELR6
#define MT6315_PMIC_RG_SRCLKEN_SRC_SEL_MASK                 0x1
#define MT6315_PMIC_RG_SRCLKEN_SRC_SEL_SHIFT                1
#define MT6315_PMIC_RG_SHUTDOWN_SRC_SEL_ADDR                \
	MT6315_TOP2_ELR6
#define MT6315_PMIC_RG_SHUTDOWN_SRC_SEL_MASK                0x1
#define MT6315_PMIC_RG_SHUTDOWN_SRC_SEL_SHIFT               2
#define MT6315_PMIC_RG_TOP2_RSV1_ADDR                       \
	MT6315_TOP2_ELR6
#define MT6315_PMIC_RG_TOP2_RSV1_MASK                       0x1F
#define MT6315_PMIC_RG_TOP2_RSV1_SHIFT                      3
#define MT6315_PMIC_RG_TOP2_RSV2_ADDR                       \
	MT6315_TOP2_ELR7
#define MT6315_PMIC_RG_TOP2_RSV2_MASK                       0xFF
#define MT6315_PMIC_RG_TOP2_RSV2_SHIFT                      0
#define MT6315_PMIC_TOP3_ANA_ID_ADDR                        \
	MT6315_TOP3_ID
#define MT6315_PMIC_TOP3_ANA_ID_MASK                        0xFF
#define MT6315_PMIC_TOP3_ANA_ID_SHIFT                       0
#define MT6315_PMIC_TOP3_DIG_ID_ADDR                        \
	MT6315_TOP3_ID_H
#define MT6315_PMIC_TOP3_DIG_ID_MASK                        0xFF
#define MT6315_PMIC_TOP3_DIG_ID_SHIFT                       0
#define MT6315_PMIC_TOP3_ANA_MINOR_REV_ADDR                 \
	MT6315_TOP3_REV0
#define MT6315_PMIC_TOP3_ANA_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP3_ANA_MINOR_REV_SHIFT                0
#define MT6315_PMIC_TOP3_ANA_MAJOR_REV_ADDR                 \
	MT6315_TOP3_REV0
#define MT6315_PMIC_TOP3_ANA_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP3_ANA_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_TOP3_DIG_MINOR_REV_ADDR                 \
	MT6315_TOP3_REV0_H
#define MT6315_PMIC_TOP3_DIG_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP3_DIG_MINOR_REV_SHIFT                0
#define MT6315_PMIC_TOP3_DIG_MAJOR_REV_ADDR                 \
	MT6315_TOP3_REV0_H
#define MT6315_PMIC_TOP3_DIG_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_TOP3_DIG_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_TOP3_DSN_CBS_ADDR                       \
	MT6315_TOP3_DSN_DBI
#define MT6315_PMIC_TOP3_DSN_CBS_MASK                       0x3
#define MT6315_PMIC_TOP3_DSN_CBS_SHIFT                      0
#define MT6315_PMIC_TOP3_DSN_BIX_ADDR                       \
	MT6315_TOP3_DSN_DBI
#define MT6315_PMIC_TOP3_DSN_BIX_MASK                       0x3
#define MT6315_PMIC_TOP3_DSN_BIX_SHIFT                      2
#define MT6315_PMIC_TOP3_DSN_ESP_ADDR                       \
	MT6315_TOP3_DSN_DBI_H
#define MT6315_PMIC_TOP3_DSN_ESP_MASK                       0xFF
#define MT6315_PMIC_TOP3_DSN_ESP_SHIFT                      0
#define MT6315_PMIC_TOP3_DSN_FPI_ADDR                       \
	MT6315_TOP3_DSN_DXI
#define MT6315_PMIC_TOP3_DSN_FPI_MASK                       0xFF
#define MT6315_PMIC_TOP3_DSN_FPI_SHIFT                      0
#define MT6315_PMIC_RG_INT_EN_VBUCK1_OC_ADDR                \
	MT6315_TOP_INT_CON0
#define MT6315_PMIC_RG_INT_EN_VBUCK1_OC_MASK                0x1
#define MT6315_PMIC_RG_INT_EN_VBUCK1_OC_SHIFT               0
#define MT6315_PMIC_RG_INT_EN_VBUCK2_OC_ADDR                \
	MT6315_TOP_INT_CON0
#define MT6315_PMIC_RG_INT_EN_VBUCK2_OC_MASK                0x1
#define MT6315_PMIC_RG_INT_EN_VBUCK2_OC_SHIFT               1
#define MT6315_PMIC_RG_INT_EN_VBUCK3_OC_ADDR                \
	MT6315_TOP_INT_CON0
#define MT6315_PMIC_RG_INT_EN_VBUCK3_OC_MASK                0x1
#define MT6315_PMIC_RG_INT_EN_VBUCK3_OC_SHIFT               2
#define MT6315_PMIC_RG_INT_EN_VBUCK4_OC_ADDR                \
	MT6315_TOP_INT_CON0
#define MT6315_PMIC_RG_INT_EN_VBUCK4_OC_MASK                0x1
#define MT6315_PMIC_RG_INT_EN_VBUCK4_OC_SHIFT               3
#define MT6315_PMIC_RG_INT_EN_TEMP_BACK_110D_ADDR           \
	MT6315_TOP_INT_CON0
#define MT6315_PMIC_RG_INT_EN_TEMP_BACK_110D_MASK           0x1
#define MT6315_PMIC_RG_INT_EN_TEMP_BACK_110D_SHIFT          4
#define MT6315_PMIC_RG_INT_EN_TEMP_OVER_125D_ADDR           \
	MT6315_TOP_INT_CON0
#define MT6315_PMIC_RG_INT_EN_TEMP_OVER_125D_MASK           0x1
#define MT6315_PMIC_RG_INT_EN_TEMP_OVER_125D_SHIFT          5
#define MT6315_PMIC_RG_INT_EN_RCS0_ADDR                     \
	MT6315_TOP_INT_CON0
#define MT6315_PMIC_RG_INT_EN_RCS0_MASK                     0x1
#define MT6315_PMIC_RG_INT_EN_RCS0_SHIFT                    6
#define MT6315_PMIC_RG_INT_EN_RCS1_ADDR                     \
	MT6315_TOP_INT_CON0
#define MT6315_PMIC_RG_INT_EN_RCS1_MASK                     0x1
#define MT6315_PMIC_RG_INT_EN_RCS1_SHIFT                    7
#define MT6315_PMIC_RG_TOP_INT_EN_CON0_SET_ADDR             \
	MT6315_TOP_INT_CON0_SET
#define MT6315_PMIC_RG_TOP_INT_EN_CON0_SET_MASK             0xFF
#define MT6315_PMIC_RG_TOP_INT_EN_CON0_SET_SHIFT            0
#define MT6315_PMIC_RG_TOP_INT_EN_CON0_CLR_ADDR             \
	MT6315_TOP_INT_CON0_CLR
#define MT6315_PMIC_RG_TOP_INT_EN_CON0_CLR_MASK             0xFF
#define MT6315_PMIC_RG_TOP_INT_EN_CON0_CLR_SHIFT            0
#define MT6315_PMIC_RG_INT_MASK_VBUCK1_OC_ADDR              \
	MT6315_TOP_INT_MASK_CON0
#define MT6315_PMIC_RG_INT_MASK_VBUCK1_OC_MASK              0x1
#define MT6315_PMIC_RG_INT_MASK_VBUCK1_OC_SHIFT             0
#define MT6315_PMIC_RG_INT_MASK_VBUCK2_OC_ADDR              \
	MT6315_TOP_INT_MASK_CON0
#define MT6315_PMIC_RG_INT_MASK_VBUCK2_OC_MASK              0x1
#define MT6315_PMIC_RG_INT_MASK_VBUCK2_OC_SHIFT             1
#define MT6315_PMIC_RG_INT_MASK_VBUCK3_OC_ADDR              \
	MT6315_TOP_INT_MASK_CON0
#define MT6315_PMIC_RG_INT_MASK_VBUCK3_OC_MASK              0x1
#define MT6315_PMIC_RG_INT_MASK_VBUCK3_OC_SHIFT             2
#define MT6315_PMIC_RG_INT_MASK_VBUCK4_OC_ADDR              \
	MT6315_TOP_INT_MASK_CON0
#define MT6315_PMIC_RG_INT_MASK_VBUCK4_OC_MASK              0x1
#define MT6315_PMIC_RG_INT_MASK_VBUCK4_OC_SHIFT             3
#define MT6315_PMIC_RG_INT_MASK_TEMP_BACK_110D_ADDR         \
	MT6315_TOP_INT_MASK_CON0
#define MT6315_PMIC_RG_INT_MASK_TEMP_BACK_110D_MASK         0x1
#define MT6315_PMIC_RG_INT_MASK_TEMP_BACK_110D_SHIFT        4
#define MT6315_PMIC_RG_INT_MASK_TEMP_OVER_125D_ADDR         \
	MT6315_TOP_INT_MASK_CON0
#define MT6315_PMIC_RG_INT_MASK_TEMP_OVER_125D_MASK         0x1
#define MT6315_PMIC_RG_INT_MASK_TEMP_OVER_125D_SHIFT        5
#define MT6315_PMIC_RG_INT_MASK_RCS0_ADDR                   \
	MT6315_TOP_INT_MASK_CON0
#define MT6315_PMIC_RG_INT_MASK_RCS0_MASK                   0x1
#define MT6315_PMIC_RG_INT_MASK_RCS0_SHIFT                  6
#define MT6315_PMIC_RG_INT_MASK_RCS1_ADDR                   \
	MT6315_TOP_INT_MASK_CON0
#define MT6315_PMIC_RG_INT_MASK_RCS1_MASK                   0x1
#define MT6315_PMIC_RG_INT_MASK_RCS1_SHIFT                  7
#define MT6315_PMIC_RG_TOP_INT_MASK_CON0_SET_ADDR           \
	MT6315_TOP_INT_MASK_CON0_SET
#define MT6315_PMIC_RG_TOP_INT_MASK_CON0_SET_MASK           0xFF
#define MT6315_PMIC_RG_TOP_INT_MASK_CON0_SET_SHIFT          0
#define MT6315_PMIC_RG_TOP_INT_MASK_CON0_CLR_ADDR           \
	MT6315_TOP_INT_MASK_CON0_CLR
#define MT6315_PMIC_RG_TOP_INT_MASK_CON0_CLR_MASK           0xFF
#define MT6315_PMIC_RG_TOP_INT_MASK_CON0_CLR_SHIFT          0
#define MT6315_PMIC_RG_INT_STATUS_VBUCK1_OC_ADDR            \
	MT6315_TOP_INT_STATUS0
#define MT6315_PMIC_RG_INT_STATUS_VBUCK1_OC_MASK            0x1
#define MT6315_PMIC_RG_INT_STATUS_VBUCK1_OC_SHIFT           0
#define MT6315_PMIC_RG_INT_STATUS_VBUCK2_OC_ADDR            \
	MT6315_TOP_INT_STATUS0
#define MT6315_PMIC_RG_INT_STATUS_VBUCK2_OC_MASK            0x1
#define MT6315_PMIC_RG_INT_STATUS_VBUCK2_OC_SHIFT           1
#define MT6315_PMIC_RG_INT_STATUS_VBUCK3_OC_ADDR            \
	MT6315_TOP_INT_STATUS0
#define MT6315_PMIC_RG_INT_STATUS_VBUCK3_OC_MASK            0x1
#define MT6315_PMIC_RG_INT_STATUS_VBUCK3_OC_SHIFT           2
#define MT6315_PMIC_RG_INT_STATUS_VBUCK4_OC_ADDR            \
	MT6315_TOP_INT_STATUS0
#define MT6315_PMIC_RG_INT_STATUS_VBUCK4_OC_MASK            0x1
#define MT6315_PMIC_RG_INT_STATUS_VBUCK4_OC_SHIFT           3
#define MT6315_PMIC_RG_INT_STATUS_TEMP_BACK_110D_ADDR       \
	MT6315_TOP_INT_STATUS0
#define MT6315_PMIC_RG_INT_STATUS_TEMP_BACK_110D_MASK       0x1
#define MT6315_PMIC_RG_INT_STATUS_TEMP_BACK_110D_SHIFT      4
#define MT6315_PMIC_RG_INT_STATUS_TEMP_OVER_125D_ADDR       \
	MT6315_TOP_INT_STATUS0
#define MT6315_PMIC_RG_INT_STATUS_TEMP_OVER_125D_MASK       0x1
#define MT6315_PMIC_RG_INT_STATUS_TEMP_OVER_125D_SHIFT      5
#define MT6315_PMIC_RG_INT_STATUS_RCS0_ADDR                 \
	MT6315_TOP_INT_STATUS0
#define MT6315_PMIC_RG_INT_STATUS_RCS0_MASK                 0x1
#define MT6315_PMIC_RG_INT_STATUS_RCS0_SHIFT                6
#define MT6315_PMIC_RG_INT_STATUS_RCS1_ADDR                 \
	MT6315_TOP_INT_STATUS0
#define MT6315_PMIC_RG_INT_STATUS_RCS1_MASK                 0x1
#define MT6315_PMIC_RG_INT_STATUS_RCS1_SHIFT                7
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK1_OC_ADDR        \
	MT6315_TOP_INT_RAW_STATUS0
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK1_OC_MASK        0x1
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK1_OC_SHIFT       0
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK2_OC_ADDR        \
	MT6315_TOP_INT_RAW_STATUS0
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK2_OC_MASK        0x1
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK2_OC_SHIFT       1
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK3_OC_ADDR        \
	MT6315_TOP_INT_RAW_STATUS0
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK3_OC_MASK        0x1
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK3_OC_SHIFT       2
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK4_OC_ADDR        \
	MT6315_TOP_INT_RAW_STATUS0
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK4_OC_MASK        0x1
#define MT6315_PMIC_RG_INT_RAW_STATUS_VBUCK4_OC_SHIFT       3
#define MT6315_PMIC_RG_INT_RAW_STATUS_TEMP_BACK_110D_ADDR   \
	MT6315_TOP_INT_RAW_STATUS0
#define MT6315_PMIC_RG_INT_RAW_STATUS_TEMP_BACK_110D_MASK   0x1
#define MT6315_PMIC_RG_INT_RAW_STATUS_TEMP_BACK_110D_SHIFT  4
#define MT6315_PMIC_RG_INT_RAW_STATUS_TEMP_OVER_125D_ADDR   \
	MT6315_TOP_INT_RAW_STATUS0
#define MT6315_PMIC_RG_INT_RAW_STATUS_TEMP_OVER_125D_MASK   0x1
#define MT6315_PMIC_RG_INT_RAW_STATUS_TEMP_OVER_125D_SHIFT  5
#define MT6315_PMIC_RG_INT_RAW_STATUS_RCS0_ADDR             \
	MT6315_TOP_INT_RAW_STATUS0
#define MT6315_PMIC_RG_INT_RAW_STATUS_RCS0_MASK             0x1
#define MT6315_PMIC_RG_INT_RAW_STATUS_RCS0_SHIFT            6
#define MT6315_PMIC_RG_INT_RAW_STATUS_RCS1_ADDR             \
	MT6315_TOP_INT_RAW_STATUS0
#define MT6315_PMIC_RG_INT_RAW_STATUS_RCS1_MASK             0x1
#define MT6315_PMIC_RG_INT_RAW_STATUS_RCS1_SHIFT            7
#define MT6315_PMIC_RG_INT_POLARITY_ADDR                    \
	MT6315_TOP_INT_CON1
#define MT6315_PMIC_RG_INT_POLARITY_MASK                    0x1
#define MT6315_PMIC_RG_INT_POLARITY_SHIFT                   0
#define MT6315_PMIC_PMRC_EN_ADDR                            \
	MT6315_PMRC_CON0
#define MT6315_PMIC_PMRC_EN_MASK                            0xFF
#define MT6315_PMIC_PMRC_EN_SHIFT                           0
#define MT6315_PMIC_RG_PMRC_CON0_SET_ADDR                   \
	MT6315_PMRC_CON0_SET
#define MT6315_PMIC_RG_PMRC_CON0_SET_MASK                   0xFF
#define MT6315_PMIC_RG_PMRC_CON0_SET_SHIFT                  0
#define MT6315_PMIC_RG_PMRC_CON0_CLR_ADDR                   \
	MT6315_PMRC_CON0_CLR
#define MT6315_PMIC_RG_PMRC_CON0_CLR_MASK                   0xFF
#define MT6315_PMIC_RG_PMRC_CON0_CLR_SHIFT                  0
#define MT6315_PMIC_RG_VR_SPM_MODE_ADDR                     \
	MT6315_PMRC_CON1
#define MT6315_PMIC_RG_VR_SPM_MODE_MASK                     0x1
#define MT6315_PMIC_RG_VR_SPM_MODE_SHIFT                    0
#define MT6315_PMIC_RG_TOP_SPM_MODE_ADDR                    \
	MT6315_PMRC_CON1
#define MT6315_PMIC_RG_TOP_SPM_MODE_MASK                    0x1
#define MT6315_PMIC_RG_TOP_SPM_MODE_SHIFT                   1
#define MT6315_PMIC_RG_PMRC_CON1_SET_ADDR                   \
	MT6315_PMRC_CON1_SET
#define MT6315_PMIC_RG_PMRC_CON1_SET_MASK                   0xFF
#define MT6315_PMIC_RG_PMRC_CON1_SET_SHIFT                  0
#define MT6315_PMIC_RG_PMRC_CON1_CLR_ADDR                   \
	MT6315_PMRC_CON1_CLR
#define MT6315_PMIC_RG_PMRC_CON1_CLR_MASK                   0xFF
#define MT6315_PMIC_RG_PMRC_CON1_CLR_SHIFT                  0
#define MT6315_PMIC_RG_LDO_VDIG18_LP_ADDR                   \
	MT6315_VDIG18_CON0
#define MT6315_PMIC_RG_LDO_VDIG18_LP_MASK                   0x1
#define MT6315_PMIC_RG_LDO_VDIG18_LP_SHIFT                  0
#define MT6315_PMIC_RG_LDO_VDIG18_SW_OP_EN_ADDR             \
	MT6315_VDIG18_CON0
#define MT6315_PMIC_RG_LDO_VDIG18_SW_OP_EN_MASK             0x1
#define MT6315_PMIC_RG_LDO_VDIG18_SW_OP_EN_SHIFT            1
#define MT6315_PMIC_RG_LDO_VDIG18_HW_OP_EN_ADDR             \
	MT6315_VDIG18_CON0
#define MT6315_PMIC_RG_LDO_VDIG18_HW_OP_EN_MASK             0x1
#define MT6315_PMIC_RG_LDO_VDIG18_HW_OP_EN_SHIFT            2
#define MT6315_PMIC_RG_VDIG18_MODE_SW_SEL_ADDR              \
	MT6315_VDIG18_CON1
#define MT6315_PMIC_RG_VDIG18_MODE_SW_SEL_MASK              0x1
#define MT6315_PMIC_RG_VDIG18_MODE_SW_SEL_SHIFT             0
#define MT6315_PMIC_RG_VDIG18_MODE_1_SW_ADDR                \
	MT6315_VDIG18_CON1
#define MT6315_PMIC_RG_VDIG18_MODE_1_SW_MASK                0x1
#define MT6315_PMIC_RG_VDIG18_MODE_1_SW_SHIFT               1
#define MT6315_PMIC_RG_VDIG18_MODE_2_SW_ADDR                \
	MT6315_VDIG18_CON1
#define MT6315_PMIC_RG_VDIG18_MODE_2_SW_MASK                0x1
#define MT6315_PMIC_RG_VDIG18_MODE_2_SW_SHIFT               2
#define MT6315_PMIC_RG_VDIG18_PWROFF_OP_EN_ADDR             \
	MT6315_VDIG18_CON1
#define MT6315_PMIC_RG_VDIG18_PWROFF_OP_EN_MASK             0x1
#define MT6315_PMIC_RG_VDIG18_PWROFF_OP_EN_SHIFT            4
#define MT6315_PMIC_PLT0_ANA_ID_ADDR                        \
	MT6315_PLT0_ID_ANA_ID
#define MT6315_PMIC_PLT0_ANA_ID_MASK                        0xFF
#define MT6315_PMIC_PLT0_ANA_ID_SHIFT                       0
#define MT6315_PMIC_PLT0_DIG_ID_ADDR                        \
	MT6315_PLT0_ID_DIG_ID
#define MT6315_PMIC_PLT0_DIG_ID_MASK                        0xFF
#define MT6315_PMIC_PLT0_DIG_ID_SHIFT                       0
#define MT6315_PMIC_PLT0_ANA_MINOR_REV_ADDR                 \
	MT6315_PLT0_REV0
#define MT6315_PMIC_PLT0_ANA_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_PLT0_ANA_MINOR_REV_SHIFT                0
#define MT6315_PMIC_PLT0_ANA_MAJOR_REV_ADDR                 \
	MT6315_PLT0_REV0
#define MT6315_PMIC_PLT0_ANA_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_PLT0_ANA_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_PLT0_DIG_MINOR_REV_ADDR                 \
	MT6315_PLT0_REV1
#define MT6315_PMIC_PLT0_DIG_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_PLT0_DIG_MINOR_REV_SHIFT                0
#define MT6315_PMIC_PLT0_DIG_MAJOR_REV_ADDR                 \
	MT6315_PLT0_REV1
#define MT6315_PMIC_PLT0_DIG_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_PLT0_DIG_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_PLT0_DSN_CBS_ADDR                       \
	MT6315_PLT0_REV2
#define MT6315_PMIC_PLT0_DSN_CBS_MASK                       0x3
#define MT6315_PMIC_PLT0_DSN_CBS_SHIFT                      0
#define MT6315_PMIC_PLT0_DSN_BIX_ADDR                       \
	MT6315_PLT0_REV2
#define MT6315_PMIC_PLT0_DSN_BIX_MASK                       0x3
#define MT6315_PMIC_PLT0_DSN_BIX_SHIFT                      2
#define MT6315_PMIC_PLT0_DSN_ESP_ADDR                       \
	MT6315_PLT0_REV3
#define MT6315_PMIC_PLT0_DSN_ESP_MASK                       0xFF
#define MT6315_PMIC_PLT0_DSN_ESP_SHIFT                      0
#define MT6315_PMIC_PLT0_DSN_FPI_ADDR                       \
	MT6315_PLT0_DSN_DXI
#define MT6315_PMIC_PLT0_DSN_FPI_MASK                       0xFF
#define MT6315_PMIC_PLT0_DSN_FPI_SHIFT                      0
#define MT6315_PMIC_DA_STRUP_OSC_TRIM_ADDR                  \
	MT6315_TOP_CLK_TRIM_0
#define MT6315_PMIC_DA_STRUP_OSC_TRIM_MASK                  0x3F
#define MT6315_PMIC_DA_STRUP_OSC_TRIM_SHIFT                 0
#define MT6315_PMIC_RG_OSC_128K_TRIM_EN_ADDR                \
	MT6315_TOP_CLK_TRIM_1
#define MT6315_PMIC_RG_OSC_128K_TRIM_EN_MASK                0x1
#define MT6315_PMIC_RG_OSC_128K_TRIM_EN_SHIFT               0
#define MT6315_PMIC_RG_OSC_128K_TRIM_RATE_ADDR              \
	MT6315_TOP_CLK_TRIM_1
#define MT6315_PMIC_RG_OSC_128K_TRIM_RATE_MASK              0x3
#define MT6315_PMIC_RG_OSC_128K_TRIM_RATE_SHIFT             1
#define MT6315_PMIC_DA_SMPS_OSC_TRIM_ADDR                   \
	MT6315_TOP_CLK_TRIM_2
#define MT6315_PMIC_DA_SMPS_OSC_TRIM_MASK                   0x3F
#define MT6315_PMIC_DA_SMPS_OSC_TRIM_SHIFT                  0
#define MT6315_PMIC_RG_SMPS_4M_TRIM_EN_ADDR                 \
	MT6315_TOP_CLK_TRIM_3
#define MT6315_PMIC_RG_SMPS_4M_TRIM_EN_MASK                 0x1
#define MT6315_PMIC_RG_SMPS_4M_TRIM_EN_SHIFT                0
#define MT6315_PMIC_RG_SMPS_4M_TRIM_RATE_ADDR               \
	MT6315_TOP_CLK_TRIM_3
#define MT6315_PMIC_RG_SMPS_4M_TRIM_RATE_MASK               0x3
#define MT6315_PMIC_RG_SMPS_4M_TRIM_RATE_SHIFT              1
#define MT6315_PMIC_RG_BUCK_BANK_LP_ACS_EN_ADDR             \
	MT6315_PLT_CON0
#define MT6315_PMIC_RG_BUCK_BANK_LP_ACS_EN_MASK             0x1
#define MT6315_PMIC_RG_BUCK_BANK_LP_ACS_EN_SHIFT            0
#define MT6315_PMIC_RG_PSC_BANK_LP_ACS_EN_ADDR              \
	MT6315_PLT_CON0
#define MT6315_PMIC_RG_PSC_BANK_LP_ACS_EN_MASK              0x1
#define MT6315_PMIC_RG_PSC_BANK_LP_ACS_EN_SHIFT             1
#define MT6315_PMIC_RG_TOP0_BANK_LP_ACS_EN_ADDR             \
	MT6315_PLT_CON0
#define MT6315_PMIC_RG_TOP0_BANK_LP_ACS_EN_MASK             0x1
#define MT6315_PMIC_RG_TOP0_BANK_LP_ACS_EN_SHIFT            2
#define MT6315_PMIC_RG_TOP1_BANK_LP_ACS_EN_ADDR             \
	MT6315_PLT_CON0
#define MT6315_PMIC_RG_TOP1_BANK_LP_ACS_EN_MASK             0x1
#define MT6315_PMIC_RG_TOP1_BANK_LP_ACS_EN_SHIFT            3
#define MT6315_PMIC_RG_TOP2_BANK_LP_ACS_EN_ADDR             \
	MT6315_PLT_CON0
#define MT6315_PMIC_RG_TOP2_BANK_LP_ACS_EN_MASK             0x1
#define MT6315_PMIC_RG_TOP2_BANK_LP_ACS_EN_SHIFT            4
#define MT6315_PMIC_RG_TOP3_BANK_LP_ACS_EN_ADDR             \
	MT6315_PLT_CON0
#define MT6315_PMIC_RG_TOP3_BANK_LP_ACS_EN_MASK             0x1
#define MT6315_PMIC_RG_TOP3_BANK_LP_ACS_EN_SHIFT            5
#define MT6315_PMIC_RG_PLT0_BANK_LP_ACS_EN_ADDR             \
	MT6315_PLT_CON0
#define MT6315_PMIC_RG_PLT0_BANK_LP_ACS_EN_MASK             0x1
#define MT6315_PMIC_RG_PLT0_BANK_LP_ACS_EN_SHIFT            6
#define MT6315_PMIC_RG_RSV_BANK_LP_ACS_EN_ADDR              \
	MT6315_PLT_CON0
#define MT6315_PMIC_RG_RSV_BANK_LP_ACS_EN_MASK              0x1
#define MT6315_PMIC_RG_RSV_BANK_LP_ACS_EN_SHIFT             7
#define MT6315_PMIC_RG_OTP_PA_ADDR                          \
	MT6315_OTP_CON0
#define MT6315_PMIC_RG_OTP_PA_MASK                          0x7F
#define MT6315_PMIC_RG_OTP_PA_SHIFT                         0
#define MT6315_PMIC_RG_OTP_PDIN_L_ADDR                      \
	MT6315_OTP_CON1
#define MT6315_PMIC_RG_OTP_PDIN_L_MASK                      0xFF
#define MT6315_PMIC_RG_OTP_PDIN_L_SHIFT                     0
#define MT6315_PMIC_RG_OTP_PDIN_H_ADDR                      \
	MT6315_OTP_CON2
#define MT6315_PMIC_RG_OTP_PDIN_H_MASK                      0xFF
#define MT6315_PMIC_RG_OTP_PDIN_H_SHIFT                     0
#define MT6315_PMIC_RG_OTP_PTM_ADDR                         \
	MT6315_OTP_CON3
#define MT6315_PMIC_RG_OTP_PTM_MASK                         0x3
#define MT6315_PMIC_RG_OTP_PTM_SHIFT                        0
#define MT6315_PMIC_RG_OTP_PWE_ADDR                         \
	MT6315_OTP_CON4
#define MT6315_PMIC_RG_OTP_PWE_MASK                         0x3
#define MT6315_PMIC_RG_OTP_PWE_SHIFT                        0
#define MT6315_PMIC_RG_OTP_PPROG_ADDR                       \
	MT6315_OTP_CON5
#define MT6315_PMIC_RG_OTP_PPROG_MASK                       0x1
#define MT6315_PMIC_RG_OTP_PPROG_SHIFT                      0
#define MT6315_PMIC_RG_OTP_PWE_SRC_ADDR                     \
	MT6315_OTP_CON6
#define MT6315_PMIC_RG_OTP_PWE_SRC_MASK                     0x1
#define MT6315_PMIC_RG_OTP_PWE_SRC_SHIFT                    0
#define MT6315_PMIC_RG_OTP_PROG_PKEY_ADDR                   \
	MT6315_OTP_CON7
#define MT6315_PMIC_RG_OTP_PROG_PKEY_MASK                   0xFF
#define MT6315_PMIC_RG_OTP_PROG_PKEY_SHIFT                  0
#define MT6315_PMIC_RG_OTP_PROG_PKEY_H_ADDR                 \
	MT6315_OTP_CON8
#define MT6315_PMIC_RG_OTP_PROG_PKEY_H_MASK                 0xFF
#define MT6315_PMIC_RG_OTP_PROG_PKEY_H_SHIFT                0
#define MT6315_PMIC_RG_OTP_RD_PKEY_ADDR                     \
	MT6315_OTP_CON9
#define MT6315_PMIC_RG_OTP_RD_PKEY_MASK                     0xFF
#define MT6315_PMIC_RG_OTP_RD_PKEY_SHIFT                    0
#define MT6315_PMIC_RG_OTP_RD_PKEY_H_ADDR                   \
	MT6315_OTP_CON10
#define MT6315_PMIC_RG_OTP_RD_PKEY_H_MASK                   0xFF
#define MT6315_PMIC_RG_OTP_RD_PKEY_H_SHIFT                  0
#define MT6315_PMIC_RG_OTP_RD_TRIG_ADDR                     \
	MT6315_OTP_CON11
#define MT6315_PMIC_RG_OTP_RD_TRIG_MASK                     0x1
#define MT6315_PMIC_RG_OTP_RD_TRIG_SHIFT                    0
#define MT6315_PMIC_RG_RD_RDY_BYPASS_ADDR                   \
	MT6315_OTP_CON12
#define MT6315_PMIC_RG_RD_RDY_BYPASS_MASK                   0x1
#define MT6315_PMIC_RG_RD_RDY_BYPASS_SHIFT                  0
#define MT6315_PMIC_RG_SKIP_OTP_OUT_ADDR                    \
	MT6315_OTP_CON13
#define MT6315_PMIC_RG_SKIP_OTP_OUT_MASK                    0x1
#define MT6315_PMIC_RG_SKIP_OTP_OUT_SHIFT                   0
#define MT6315_PMIC_RG_OTP_RD_SW_ADDR                       \
	MT6315_OTP_CON14
#define MT6315_PMIC_RG_OTP_RD_SW_MASK                       0x1
#define MT6315_PMIC_RG_OTP_RD_SW_SHIFT                      0
#define MT6315_PMIC_RG_OTP_DOUT_SW_ADDR                     \
	MT6315_OTP_CON15
#define MT6315_PMIC_RG_OTP_DOUT_SW_MASK                     0xFF
#define MT6315_PMIC_RG_OTP_DOUT_SW_SHIFT                    0
#define MT6315_PMIC_RG_OTP_DOUT_SW_H_ADDR                   \
	MT6315_OTP_CON16
#define MT6315_PMIC_RG_OTP_DOUT_SW_H_MASK                   0xFF
#define MT6315_PMIC_RG_OTP_DOUT_SW_H_SHIFT                  0
#define MT6315_PMIC_RG_OTP_RD_BUSY_ADDR                     \
	MT6315_OTP_CON17
#define MT6315_PMIC_RG_OTP_RD_BUSY_MASK                     0x1
#define MT6315_PMIC_RG_OTP_RD_BUSY_SHIFT                    0
#define MT6315_PMIC_RG_OTP_RD_ACK_ADDR                      \
	MT6315_OTP_CON17
#define MT6315_PMIC_RG_OTP_RD_ACK_MASK                      0x1
#define MT6315_PMIC_RG_OTP_RD_ACK_SHIFT                     2
#define MT6315_PMIC_RG_OTP_PA_SW_ADDR                       \
	MT6315_OTP_CON18
#define MT6315_PMIC_RG_OTP_PA_SW_MASK                       0x7F
#define MT6315_PMIC_RG_OTP_PA_SW_SHIFT                      0
#define MT6315_PMIC_TMA_KEY_ADDR                            \
	MT6315_TOP_TMA_KEY
#define MT6315_PMIC_TMA_KEY_MASK                            0xFF
#define MT6315_PMIC_TMA_KEY_SHIFT                           0
#define MT6315_PMIC_TMA_KEY_H_ADDR                          \
	MT6315_TOP_TMA_KEY_H
#define MT6315_PMIC_TMA_KEY_H_MASK                          0xFF
#define MT6315_PMIC_TMA_KEY_H_SHIFT                         0
#define MT6315_PMIC_ANA_WRITE_KEY_ADDR                      \
	MT6315_TOP_ANA_KEY
#define MT6315_PMIC_ANA_WRITE_KEY_MASK                      0xFF
#define MT6315_PMIC_ANA_WRITE_KEY_SHIFT                     0
#define MT6315_PMIC_ANA_WRITE_KEY_H_ADDR                    \
	MT6315_TOP_ANA_KEY_H
#define MT6315_PMIC_ANA_WRITE_KEY_H_MASK                    0xFF
#define MT6315_PMIC_ANA_WRITE_KEY_H_SHIFT                   0
#define MT6315_PMIC_TOP_MDB_RSV0_ADDR                       \
	MT6315_TOP_MDB_CONF0
#define MT6315_PMIC_TOP_MDB_RSV0_MASK                       0xFF
#define MT6315_PMIC_TOP_MDB_RSV0_SHIFT                      0
#define MT6315_PMIC_TOP_MDB_RSV0_H_ADDR                     \
	MT6315_TOP_MDB_CONF0_H
#define MT6315_PMIC_TOP_MDB_RSV0_H_MASK                     0xFF
#define MT6315_PMIC_TOP_MDB_RSV0_H_SHIFT                    0
#define MT6315_PMIC_TOP_MDB_RSV1_ADDR                       \
	MT6315_TOP_MDB_CONF1
#define MT6315_PMIC_TOP_MDB_RSV1_MASK                       0xFF
#define MT6315_PMIC_TOP_MDB_RSV1_SHIFT                      0
#define MT6315_PMIC_TOP_MDB_RSV1_H_ADDR                     \
	MT6315_TOP_MDB_CONF1_H
#define MT6315_PMIC_TOP_MDB_RSV1_H_MASK                     0xFF
#define MT6315_PMIC_TOP_MDB_RSV1_H_SHIFT                    0
#define MT6315_PMIC_RG_MDB_DM1_DS_EN_ADDR                   \
	MT6315_TOP_MDB_CONF2
#define MT6315_PMIC_RG_MDB_DM1_DS_EN_MASK                   0x1
#define MT6315_PMIC_RG_MDB_DM1_DS_EN_SHIFT                  0
#define MT6315_PMIC_RG_AUTO_LOAD_FORCE_ADDR                 \
	MT6315_TOP_MDB_CONF2
#define MT6315_PMIC_RG_AUTO_LOAD_FORCE_MASK                 0x1
#define MT6315_PMIC_RG_AUTO_LOAD_FORCE_SHIFT                1
#define MT6315_PMIC_RG_OTP_WRITE_SEL_ADDR                   \
	MT6315_TOP_MDB_CONF2
#define MT6315_PMIC_RG_OTP_WRITE_SEL_MASK                   0x1
#define MT6315_PMIC_RG_OTP_WRITE_SEL_SHIFT                  2
#define MT6315_PMIC_DIG_WPK_KEY_ADDR                        \
	MT6315_TOP_DIG_WPK
#define MT6315_PMIC_DIG_WPK_KEY_MASK                        0xFF
#define MT6315_PMIC_DIG_WPK_KEY_SHIFT                       0
#define MT6315_PMIC_DIG_WPK_KEY_H_ADDR                      \
	MT6315_TOP_DIG_WPK_H
#define MT6315_PMIC_DIG_WPK_KEY_H_MASK                      0xFF
#define MT6315_PMIC_DIG_WPK_KEY_H_SHIFT                     0
#define MT6315_PMIC_RG_EXTADR_REG0_W_ADDR                   \
	MT6315_SPMI_EXT_ADDR0
#define MT6315_PMIC_RG_EXTADR_REG0_W_MASK                   0xFF
#define MT6315_PMIC_RG_EXTADR_REG0_W_SHIFT                  0
#define MT6315_PMIC_RG_EXTADR_REG0_W_H_ADDR                 \
	MT6315_SPMI_EXT_ADDR0_H
#define MT6315_PMIC_RG_EXTADR_REG0_W_H_MASK                 0xFF
#define MT6315_PMIC_RG_EXTADR_REG0_W_H_SHIFT                0
#define MT6315_PMIC_RG_EXTADR_EXT_REG_RW_ADDR               \
	MT6315_SPMI_EXT_ADDR1
#define MT6315_PMIC_RG_EXTADR_EXT_REG_RW_MASK               0xFF
#define MT6315_PMIC_RG_EXTADR_EXT_REG_RW_SHIFT              0
#define MT6315_PMIC_RG_EXTADR_REG_RW_ADDR                   \
	MT6315_SPMI_EXT_ADDR2
#define MT6315_PMIC_RG_EXTADR_REG_RW_MASK                   0xFF
#define MT6315_PMIC_RG_EXTADR_REG_RW_SHIFT                  0
#define MT6315_PMIC_RG_EXTADR_REG_RW_H_ADDR                 \
	MT6315_SPMI_EXT_ADDR2_H
#define MT6315_PMIC_RG_EXTADR_REG_RW_H_MASK                 0x7
#define MT6315_PMIC_RG_EXTADR_REG_RW_H_SHIFT                0
#define MT6315_PMIC_RG_SPMI_RXDATA_MD_ADDR                  \
	MT6315_SPMI_EXT_ADDR2_H
#define MT6315_PMIC_RG_SPMI_RXDATA_MD_MASK                  0x1
#define MT6315_PMIC_RG_SPMI_RXDATA_MD_SHIFT                 3
#define MT6315_PMIC_RG_SPMI_DLY_SEL_ADDR                    \
	MT6315_SPMI_EXT_ADDR2_H
#define MT6315_PMIC_RG_SPMI_DLY_SEL_MASK                    0xF
#define MT6315_PMIC_RG_SPMI_DLY_SEL_SHIFT                   4
#define MT6315_PMIC_RG_RCS_ENABLE_ADDR                      \
	MT6315_SPMI_RCS_FUN0
#define MT6315_PMIC_RG_RCS_ENABLE_MASK                      0x1
#define MT6315_PMIC_RG_RCS_ENABLE_SHIFT                     0
#define MT6315_PMIC_RG_RCS_ABIT_ADDR                        \
	MT6315_SPMI_RCS_FUN0
#define MT6315_PMIC_RG_RCS_ABIT_MASK                        0x1
#define MT6315_PMIC_RG_RCS_ABIT_SHIFT                       1
#define MT6315_PMIC_RG_RCS_CMD_ADDR                         \
	MT6315_SPMI_RCS_FUN0
#define MT6315_PMIC_RG_RCS_CMD_MASK                         0x3
#define MT6315_PMIC_RG_RCS_CMD_SHIFT                        2
#define MT6315_PMIC_RG_RCS_ID_ADDR                          \
	MT6315_SPMI_RCS_FUN0
#define MT6315_PMIC_RG_RCS_ID_MASK                          0xF
#define MT6315_PMIC_RG_RCS_ID_SHIFT                         4
#define MT6315_PMIC_RG_RCS_ADDR_ADDR                        \
	MT6315_SPMI_RCS_FUN1
#define MT6315_PMIC_RG_RCS_ADDR_MASK                        0xFF
#define MT6315_PMIC_RG_RCS_ADDR_SHIFT                       0
#define MT6315_PMIC_RG_INT_RCS0_ADDR                        \
	MT6315_SPMI_RCS_FUN2
#define MT6315_PMIC_RG_INT_RCS0_MASK                        0x1
#define MT6315_PMIC_RG_INT_RCS0_SHIFT                       0
#define MT6315_PMIC_RG_INT_RCS1_ADDR                        \
	MT6315_SPMI_RCS_FUN2
#define MT6315_PMIC_RG_INT_RCS1_MASK                        0x1
#define MT6315_PMIC_RG_INT_RCS1_SHIFT                       1
#define MT6315_PMIC_RG_INT_RCS1_CLR_ADDR                    \
	MT6315_SPMI_RCS_FUN2
#define MT6315_PMIC_RG_INT_RCS1_CLR_MASK                    0x1
#define MT6315_PMIC_RG_INT_RCS1_CLR_SHIFT                   2
#define MT6315_PMIC_RG_PARTY_ERR_CLR_ADDR                   \
	MT6315_SPMI_RCS_FUN2
#define MT6315_PMIC_RG_PARTY_ERR_CLR_MASK                   0x1
#define MT6315_PMIC_RG_PARTY_ERR_CLR_SHIFT                  3
#define MT6315_PMIC_RG_ADDR_WR_MATCH_ADDR                   \
	MT6315_SPMI_WR_ADDR
#define MT6315_PMIC_RG_ADDR_WR_MATCH_MASK                   0xFF
#define MT6315_PMIC_RG_ADDR_WR_MATCH_SHIFT                  0
#define MT6315_PMIC_RG_ADDR_WR_MATCH_H_ADDR                 \
	MT6315_SPMI_WR_ADDR_H
#define MT6315_PMIC_RG_ADDR_WR_MATCH_H_MASK                 0xFF
#define MT6315_PMIC_RG_ADDR_WR_MATCH_H_SHIFT                0
#define MT6315_PMIC_RG_RXDBG_ADDR0_ADDR                     \
	MT6315_SPMI_DEBUG_ADDR0
#define MT6315_PMIC_RG_RXDBG_ADDR0_MASK                     0xFF
#define MT6315_PMIC_RG_RXDBG_ADDR0_SHIFT                    0
#define MT6315_PMIC_RG_RXDBG_ADDR0_H_ADDR                   \
	MT6315_SPMI_DEBUG_ADDR0_H
#define MT6315_PMIC_RG_RXDBG_ADDR0_H_MASK                   0xFF
#define MT6315_PMIC_RG_RXDBG_ADDR0_H_SHIFT                  0
#define MT6315_PMIC_RG_RXDBG_DATA0_ADDR                     \
	MT6315_SPMI_DEBUG_DATA0
#define MT6315_PMIC_RG_RXDBG_DATA0_MASK                     0xFF
#define MT6315_PMIC_RG_RXDBG_DATA0_SHIFT                    0
#define MT6315_PMIC_RG_RXDBG_CMD0_ADDR                      \
	MT6315_SPMI_DEBUG_CMD0
#define MT6315_PMIC_RG_RXDBG_CMD0_MASK                      0x3
#define MT6315_PMIC_RG_RXDBG_CMD0_SHIFT                     0
#define MT6315_PMIC_RG_RXDBG_IDX_ADDR                       \
	MT6315_SPMI_DEBUG_CMD0
#define MT6315_PMIC_RG_RXDBG_IDX_MASK                       0x3
#define MT6315_PMIC_RG_RXDBG_IDX_SHIFT                      2
#define MT6315_PMIC_RG_RXDBG_ADDR1_ADDR                     \
	MT6315_SPMI_DEBUG_ADDR1
#define MT6315_PMIC_RG_RXDBG_ADDR1_MASK                     0xFF
#define MT6315_PMIC_RG_RXDBG_ADDR1_SHIFT                    0
#define MT6315_PMIC_RG_RXDBG_ADDR1_H_ADDR                   \
	MT6315_SPMI_DEBUG_ADDR1_H
#define MT6315_PMIC_RG_RXDBG_ADDR1_H_MASK                   0xFF
#define MT6315_PMIC_RG_RXDBG_ADDR1_H_SHIFT                  0
#define MT6315_PMIC_RG_RXDBG_DATA1_ADDR                     \
	MT6315_SPMI_DEBUG_DATA1
#define MT6315_PMIC_RG_RXDBG_DATA1_MASK                     0xFF
#define MT6315_PMIC_RG_RXDBG_DATA1_SHIFT                    0
#define MT6315_PMIC_RG_RXDBG_CMD1_ADDR                      \
	MT6315_SPMI_DEBUG_CMD1
#define MT6315_PMIC_RG_RXDBG_CMD1_MASK                      0x3
#define MT6315_PMIC_RG_RXDBG_CMD1_SHIFT                     0
#define MT6315_PMIC_RG_RXDBG_ADDR2_ADDR                     \
	MT6315_SPMI_DEBUG_ADDR2
#define MT6315_PMIC_RG_RXDBG_ADDR2_MASK                     0xFF
#define MT6315_PMIC_RG_RXDBG_ADDR2_SHIFT                    0
#define MT6315_PMIC_RG_RXDBG_ADDR2_H_ADDR                   \
	MT6315_SPMI_DEBUG_ADDR2_H
#define MT6315_PMIC_RG_RXDBG_ADDR2_H_MASK                   0xFF
#define MT6315_PMIC_RG_RXDBG_ADDR2_H_SHIFT                  0
#define MT6315_PMIC_RG_RXDBG_DATA2_ADDR                     \
	MT6315_SPMI_DEBUG_DATA2
#define MT6315_PMIC_RG_RXDBG_DATA2_MASK                     0xFF
#define MT6315_PMIC_RG_RXDBG_DATA2_SHIFT                    0
#define MT6315_PMIC_RG_RXDBG_CMD2_ADDR                      \
	MT6315_SPMI_DEBUG_CMD2
#define MT6315_PMIC_RG_RXDBG_CMD2_MASK                      0x3
#define MT6315_PMIC_RG_RXDBG_CMD2_SHIFT                     0
#define MT6315_PMIC_RG_RXDBG_ADDR3_ADDR                     \
	MT6315_SPMI_DEBUG_ADDR3
#define MT6315_PMIC_RG_RXDBG_ADDR3_MASK                     0xFF
#define MT6315_PMIC_RG_RXDBG_ADDR3_SHIFT                    0
#define MT6315_PMIC_RG_RXDBG_ADDR3_H_ADDR                   \
	MT6315_SPMI_DEBUG_ADDR3_H
#define MT6315_PMIC_RG_RXDBG_ADDR3_H_MASK                   0xFF
#define MT6315_PMIC_RG_RXDBG_ADDR3_H_SHIFT                  0
#define MT6315_PMIC_RG_RXDBG_DATA3_ADDR                     \
	MT6315_SPMI_DEBUG_DATA3
#define MT6315_PMIC_RG_RXDBG_DATA3_MASK                     0xFF
#define MT6315_PMIC_RG_RXDBG_DATA3_SHIFT                    0
#define MT6315_PMIC_RG_RXDBG_CMD3_ADDR                      \
	MT6315_SPMI_DEBUG_CMD3
#define MT6315_PMIC_RG_RXDBG_CMD3_MASK                      0x3
#define MT6315_PMIC_RG_RXDBG_CMD3_SHIFT                     0
#define MT6315_PMIC_RG_PRTY_ERR_COMD0_ADDR                  \
	MT6315_SPMI_PTRY_ERR0
#define MT6315_PMIC_RG_PRTY_ERR_COMD0_MASK                  0x7
#define MT6315_PMIC_RG_PRTY_ERR_COMD0_SHIFT                 0
#define MT6315_PMIC_RG_PRTY_ERR_TYPE0_ADDR                  \
	MT6315_SPMI_PTRY_ERR0
#define MT6315_PMIC_RG_PRTY_ERR_TYPE0_MASK                  0x3
#define MT6315_PMIC_RG_PRTY_ERR_TYPE0_SHIFT                 3
#define MT6315_PMIC_RG_PRTY_ERR_IDX_ADDR                    \
	MT6315_SPMI_PTRY_ERR0
#define MT6315_PMIC_RG_PRTY_ERR_IDX_MASK                    0x7
#define MT6315_PMIC_RG_PRTY_ERR_IDX_SHIFT                   5
#define MT6315_PMIC_RG_PRTY_ERR_DATA0_ADDR                  \
	MT6315_SPMI_PTRY_ERR1
#define MT6315_PMIC_RG_PRTY_ERR_DATA0_MASK                  0xFF
#define MT6315_PMIC_RG_PRTY_ERR_DATA0_SHIFT                 0
#define MT6315_PMIC_RG_PRTY_ERR_DATA0_H_ADDR                \
	MT6315_SPMI_PTRY_ERR1_H
#define MT6315_PMIC_RG_PRTY_ERR_DATA0_H_MASK                0xF
#define MT6315_PMIC_RG_PRTY_ERR_DATA0_H_SHIFT               0
#define MT6315_PMIC_RG_PRTY_ERR_COMD1_ADDR                  \
	MT6315_SPMI_PTRY_ERR2
#define MT6315_PMIC_RG_PRTY_ERR_COMD1_MASK                  0x7
#define MT6315_PMIC_RG_PRTY_ERR_COMD1_SHIFT                 0
#define MT6315_PMIC_RG_PRTY_ERR_TYPE1_ADDR                  \
	MT6315_SPMI_PTRY_ERR2
#define MT6315_PMIC_RG_PRTY_ERR_TYPE1_MASK                  0x3
#define MT6315_PMIC_RG_PRTY_ERR_TYPE1_SHIFT                 3
#define MT6315_PMIC_RG_PRTY_ERR_DATA1_ADDR                  \
	MT6315_SPMI_PTRY_ERR3
#define MT6315_PMIC_RG_PRTY_ERR_DATA1_MASK                  0xFF
#define MT6315_PMIC_RG_PRTY_ERR_DATA1_SHIFT                 0
#define MT6315_PMIC_RG_PRTY_ERR_DATA1_H_ADDR                \
	MT6315_SPMI_PTRY_ERR3_H
#define MT6315_PMIC_RG_PRTY_ERR_DATA1_H_MASK                0xF
#define MT6315_PMIC_RG_PRTY_ERR_DATA1_H_SHIFT               0
#define MT6315_PMIC_RG_PRTY_ERR_COMD2_ADDR                  \
	MT6315_SPMI_PTRY_ERR4
#define MT6315_PMIC_RG_PRTY_ERR_COMD2_MASK                  0x7
#define MT6315_PMIC_RG_PRTY_ERR_COMD2_SHIFT                 0
#define MT6315_PMIC_RG_PRTY_ERR_TYPE2_ADDR                  \
	MT6315_SPMI_PTRY_ERR4
#define MT6315_PMIC_RG_PRTY_ERR_TYPE2_MASK                  0x3
#define MT6315_PMIC_RG_PRTY_ERR_TYPE2_SHIFT                 3
#define MT6315_PMIC_RG_PRTY_ERR_DATA2_ADDR                  \
	MT6315_SPMI_PTRY_ERR5
#define MT6315_PMIC_RG_PRTY_ERR_DATA2_MASK                  0xFF
#define MT6315_PMIC_RG_PRTY_ERR_DATA2_SHIFT                 0
#define MT6315_PMIC_RG_PRTY_ERR_DATA2_H_ADDR                \
	MT6315_SPMI_PTRY_ERR5_H
#define MT6315_PMIC_RG_PRTY_ERR_DATA2_H_MASK                0xF
#define MT6315_PMIC_RG_PRTY_ERR_DATA2_H_SHIFT               0
#define MT6315_PMIC_RG_PRTY_ERR_COMD3_ADDR                  \
	MT6315_SPMI_PTRY_ERR6
#define MT6315_PMIC_RG_PRTY_ERR_COMD3_MASK                  0x7
#define MT6315_PMIC_RG_PRTY_ERR_COMD3_SHIFT                 0
#define MT6315_PMIC_RG_PRTY_ERR_TYPE3_ADDR                  \
	MT6315_SPMI_PTRY_ERR6
#define MT6315_PMIC_RG_PRTY_ERR_TYPE3_MASK                  0x3
#define MT6315_PMIC_RG_PRTY_ERR_TYPE3_SHIFT                 3
#define MT6315_PMIC_RG_PRTY_ERR_DATA3_ADDR                  \
	MT6315_SPMI_PTRY_ERR7
#define MT6315_PMIC_RG_PRTY_ERR_DATA3_MASK                  0xFF
#define MT6315_PMIC_RG_PRTY_ERR_DATA3_SHIFT                 0
#define MT6315_PMIC_RG_PRTY_ERR_DATA3_H_ADDR                \
	MT6315_SPMI_PTRY_ERR7_H
#define MT6315_PMIC_RG_PRTY_ERR_DATA3_H_MASK                0xF
#define MT6315_PMIC_RG_PRTY_ERR_DATA3_H_SHIFT               0
#define MT6315_PMIC_PLT0_ELR_LEN_ADDR                       \
	MT6315_PLT0_ELR_NUM
#define MT6315_PMIC_PLT0_ELR_LEN_MASK                       0xFF
#define MT6315_PMIC_PLT0_ELR_LEN_SHIFT                      0
#define MT6315_PMIC_RG_OSC_128K_TRIM_ADDR                   \
	MT6315_PLT0_ELR0
#define MT6315_PMIC_RG_OSC_128K_TRIM_MASK                   0x3F
#define MT6315_PMIC_RG_OSC_128K_TRIM_SHIFT                  0
#define MT6315_PMIC_RG_SMPS_4M_TRIM_ADDR                    \
	MT6315_PLT0_ELR1
#define MT6315_PMIC_RG_SMPS_4M_TRIM_MASK                    0x3F
#define MT6315_PMIC_RG_SMPS_4M_TRIM_SHIFT                   0
#define MT6315_PMIC_PSC_TOP_ANA_ID_ADDR                     \
	MT6315_PSC_TOP_ID_ANA
#define MT6315_PMIC_PSC_TOP_ANA_ID_MASK                     0xFF
#define MT6315_PMIC_PSC_TOP_ANA_ID_SHIFT                    0
#define MT6315_PMIC_PSC_TOP_DIG_ID_ADDR                     \
	MT6315_PSC_TOP_ID_DIG
#define MT6315_PMIC_PSC_TOP_DIG_ID_MASK                     0xFF
#define MT6315_PMIC_PSC_TOP_DIG_ID_SHIFT                    0
#define MT6315_PMIC_PSC_TOP_ANA_MINOR_REV_ADDR              \
	MT6315_PSC_TOP_REV0
#define MT6315_PMIC_PSC_TOP_ANA_MINOR_REV_MASK              0xF
#define MT6315_PMIC_PSC_TOP_ANA_MINOR_REV_SHIFT             0
#define MT6315_PMIC_PSC_TOP_ANA_MAJOR_REV_ADDR              \
	MT6315_PSC_TOP_REV0
#define MT6315_PMIC_PSC_TOP_ANA_MAJOR_REV_MASK              0xF
#define MT6315_PMIC_PSC_TOP_ANA_MAJOR_REV_SHIFT             4
#define MT6315_PMIC_PSC_TOP_DIG_MINOR_REV_ADDR              \
	MT6315_PSC_TOP_REV1
#define MT6315_PMIC_PSC_TOP_DIG_MINOR_REV_MASK              0xF
#define MT6315_PMIC_PSC_TOP_DIG_MINOR_REV_SHIFT             0
#define MT6315_PMIC_PSC_TOP_DIG_MAJOR_REV_ADDR              \
	MT6315_PSC_TOP_REV1
#define MT6315_PMIC_PSC_TOP_DIG_MAJOR_REV_MASK              0xF
#define MT6315_PMIC_PSC_TOP_DIG_MAJOR_REV_SHIFT             4
#define MT6315_PMIC_PSC_TOP_CBS_ADDR                        \
	MT6315_PSC_TOP_DBI0
#define MT6315_PMIC_PSC_TOP_CBS_MASK                        0x3
#define MT6315_PMIC_PSC_TOP_CBS_SHIFT                       0
#define MT6315_PMIC_PSC_TOP_BIX_ADDR                        \
	MT6315_PSC_TOP_DBI0
#define MT6315_PMIC_PSC_TOP_BIX_MASK                        0x3
#define MT6315_PMIC_PSC_TOP_BIX_SHIFT                       2
#define MT6315_PMIC_PSC_TOP_ESP_ADDR                        \
	MT6315_PSC_TOP_DBI1
#define MT6315_PMIC_PSC_TOP_ESP_MASK                        0xFF
#define MT6315_PMIC_PSC_TOP_ESP_SHIFT                       0
#define MT6315_PMIC_PSC_TOP_FPI_ADDR                        \
	MT6315_PSC_TOP_DXI
#define MT6315_PMIC_PSC_TOP_FPI_MASK                        0xFF
#define MT6315_PMIC_PSC_TOP_FPI_SHIFT                       0
#define MT6315_PMIC_PSC_TOP_CLK_OFFSET_ADDR                 \
	MT6315_PSC_TPM0
#define MT6315_PMIC_PSC_TOP_CLK_OFFSET_MASK                 0xFF
#define MT6315_PMIC_PSC_TOP_CLK_OFFSET_SHIFT                0
#define MT6315_PMIC_PSC_TOP_RST_OFFSET_ADDR                 \
	MT6315_PSC_TPM1
#define MT6315_PMIC_PSC_TOP_RST_OFFSET_MASK                 0xFF
#define MT6315_PMIC_PSC_TOP_RST_OFFSET_SHIFT                0
#define MT6315_PMIC_PSC_TOP_INT_OFFSET_ADDR                 \
	MT6315_PSC_TPM2
#define MT6315_PMIC_PSC_TOP_INT_OFFSET_MASK                 0xFF
#define MT6315_PMIC_PSC_TOP_INT_OFFSET_SHIFT                0
#define MT6315_PMIC_BANK_PSEQ_SWRST_ADDR                    \
	MT6315_PSC_TOP_RSTCTL
#define MT6315_PMIC_BANK_PSEQ_SWRST_MASK                    0x1
#define MT6315_PMIC_BANK_PSEQ_SWRST_SHIFT                   0
#define MT6315_PMIC_BANK_STRUP_ANA0_SWRST_ADDR              \
	MT6315_PSC_TOP_RSTCTL
#define MT6315_PMIC_BANK_STRUP_ANA0_SWRST_MASK              0x1
#define MT6315_PMIC_BANK_STRUP_ANA0_SWRST_SHIFT             1
#define MT6315_PMIC_RG_PSC_MON_GRP_SEL_ADDR                 \
	MT6315_PSC_TOP_MON_CTL
#define MT6315_PMIC_RG_PSC_MON_GRP_SEL_MASK                 0x7
#define MT6315_PMIC_RG_PSC_MON_GRP_SEL_SHIFT                0
#define MT6315_PMIC_PSEQ_ANA_ID_ADDR                        \
	MT6315_PSEQ_ID_ANA
#define MT6315_PMIC_PSEQ_ANA_ID_MASK                        0xFF
#define MT6315_PMIC_PSEQ_ANA_ID_SHIFT                       0
#define MT6315_PMIC_PSEQ_DIG_ID_ADDR                        \
	MT6315_PSEQ_ID_DIG
#define MT6315_PMIC_PSEQ_DIG_ID_MASK                        0xFF
#define MT6315_PMIC_PSEQ_DIG_ID_SHIFT                       0
#define MT6315_PMIC_PSEQ_ANA_MINOR_REV_ADDR                 \
	MT6315_PSEQ_REV0
#define MT6315_PMIC_PSEQ_ANA_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_PSEQ_ANA_MINOR_REV_SHIFT                0
#define MT6315_PMIC_PSEQ_ANA_MAJOR_REV_ADDR                 \
	MT6315_PSEQ_REV0
#define MT6315_PMIC_PSEQ_ANA_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_PSEQ_ANA_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_PSEQ_DIG_MINOR_REV_ADDR                 \
	MT6315_PSEQ_REV1
#define MT6315_PMIC_PSEQ_DIG_MINOR_REV_MASK                 0xF
#define MT6315_PMIC_PSEQ_DIG_MINOR_REV_SHIFT                0
#define MT6315_PMIC_PSEQ_DIG_MAJOR_REV_ADDR                 \
	MT6315_PSEQ_REV1
#define MT6315_PMIC_PSEQ_DIG_MAJOR_REV_MASK                 0xF
#define MT6315_PMIC_PSEQ_DIG_MAJOR_REV_SHIFT                4
#define MT6315_PMIC_PSEQ_CBS_ADDR                           \
	MT6315_PSEQ_DBI0
#define MT6315_PMIC_PSEQ_CBS_MASK                           0x3
#define MT6315_PMIC_PSEQ_CBS_SHIFT                          0
#define MT6315_PMIC_PSEQ_BIX_ADDR                           \
	MT6315_PSEQ_DBI0
#define MT6315_PMIC_PSEQ_BIX_MASK                           0x3
#define MT6315_PMIC_PSEQ_BIX_SHIFT                          2
#define MT6315_PMIC_PSEQ_ESP_ADDR                           \
	MT6315_PSEQ_DBI1
#define MT6315_PMIC_PSEQ_ESP_MASK                           0xFF
#define MT6315_PMIC_PSEQ_ESP_SHIFT                          0
#define MT6315_PMIC_PSEQ_FPI_ADDR                           \
	MT6315_PSEQ_DXI
#define MT6315_PMIC_PSEQ_FPI_MASK                           0xFF
#define MT6315_PMIC_PSEQ_FPI_SHIFT                          0
#define MT6315_PMIC_RG_PGODLY_INTV_ADDR                     \
	MT6315_PPCCTL
#define MT6315_PMIC_RG_PGODLY_INTV_MASK                     0x3
#define MT6315_PMIC_RG_PGODLY_INTV_SHIFT                    0
#define MT6315_PMIC_RG_RSV_SWREG_ADDR                       \
	MT6315_STRUP_CON0
#define MT6315_PMIC_RG_RSV_SWREG_MASK                       0xFF
#define MT6315_PMIC_RG_RSV_SWREG_SHIFT                      0
#define MT6315_PMIC_RG_THR_TEST_EN_ADDR                     \
	MT6315_STRUP_CON1
#define MT6315_PMIC_RG_THR_TEST_EN_MASK                     0x1
#define MT6315_PMIC_RG_THR_TEST_EN_SHIFT                    0
#define MT6315_PMIC_RG_THR_TEST_ADDR                        \
	MT6315_STRUP_CON1
#define MT6315_PMIC_RG_THR_TEST_MASK                        0x1F
#define MT6315_PMIC_RG_THR_TEST_SHIFT                       1
#define MT6315_PMIC_RG_THR_DET_DIS_ADDR                     \
	MT6315_STRUP_CON1
#define MT6315_PMIC_RG_THR_DET_DIS_MASK                     0x1
#define MT6315_PMIC_RG_THR_DET_DIS_SHIFT                    6
#define MT6315_PMIC_RG_STRUP_VBUCK4_PG_ENB_ADDR             \
	MT6315_STRUP_PGENB0
#define MT6315_PMIC_RG_STRUP_VBUCK4_PG_ENB_MASK             0x1
#define MT6315_PMIC_RG_STRUP_VBUCK4_PG_ENB_SHIFT            4
#define MT6315_PMIC_RG_STRUP_VBUCK3_PG_ENB_ADDR             \
	MT6315_STRUP_PGENB0
#define MT6315_PMIC_RG_STRUP_VBUCK3_PG_ENB_MASK             0x1
#define MT6315_PMIC_RG_STRUP_VBUCK3_PG_ENB_SHIFT            5
#define MT6315_PMIC_RG_STRUP_VBUCK2_PG_ENB_ADDR             \
	MT6315_STRUP_PGENB0
#define MT6315_PMIC_RG_STRUP_VBUCK2_PG_ENB_MASK             0x1
#define MT6315_PMIC_RG_STRUP_VBUCK2_PG_ENB_SHIFT            6
#define MT6315_PMIC_RG_STRUP_VBUCK1_PG_ENB_ADDR             \
	MT6315_STRUP_PGENB0
#define MT6315_PMIC_RG_STRUP_VBUCK1_PG_ENB_MASK             0x1
#define MT6315_PMIC_RG_STRUP_VBUCK1_PG_ENB_SHIFT            7
#define MT6315_PMIC_RG_STRUP_VBUCK4_OC_ENB_ADDR             \
	MT6315_STRUP_OCENB0
#define MT6315_PMIC_RG_STRUP_VBUCK4_OC_ENB_MASK             0x1
#define MT6315_PMIC_RG_STRUP_VBUCK4_OC_ENB_SHIFT            4
#define MT6315_PMIC_RG_STRUP_VBUCK3_OC_ENB_ADDR             \
	MT6315_STRUP_OCENB0
#define MT6315_PMIC_RG_STRUP_VBUCK3_OC_ENB_MASK             0x1
#define MT6315_PMIC_RG_STRUP_VBUCK3_OC_ENB_SHIFT            5
#define MT6315_PMIC_RG_STRUP_VBUCK2_OC_ENB_ADDR             \
	MT6315_STRUP_OCENB0
#define MT6315_PMIC_RG_STRUP_VBUCK2_OC_ENB_MASK             0x1
#define MT6315_PMIC_RG_STRUP_VBUCK2_OC_ENB_SHIFT            6
#define MT6315_PMIC_RG_STRUP_VBUCK1_OC_ENB_ADDR             \
	MT6315_STRUP_OCENB0
#define MT6315_PMIC_RG_STRUP_VBUCK1_OC_ENB_MASK             0x1
#define MT6315_PMIC_RG_STRUP_VBUCK1_OC_ENB_SHIFT            7
#define MT6315_PMIC_RG_KEYPWR_VBUCK4_EN_ADDR                \
	MT6315_BUCK_KEYPWR
#define MT6315_PMIC_RG_KEYPWR_VBUCK4_EN_MASK                0x1
#define MT6315_PMIC_RG_KEYPWR_VBUCK4_EN_SHIFT               4
#define MT6315_PMIC_RG_KEYPWR_VBUCK3_EN_ADDR                \
	MT6315_BUCK_KEYPWR
#define MT6315_PMIC_RG_KEYPWR_VBUCK3_EN_MASK                0x1
#define MT6315_PMIC_RG_KEYPWR_VBUCK3_EN_SHIFT               5
#define MT6315_PMIC_RG_KEYPWR_VBUCK2_EN_ADDR                \
	MT6315_BUCK_KEYPWR
#define MT6315_PMIC_RG_KEYPWR_VBUCK2_EN_MASK                0x1
#define MT6315_PMIC_RG_KEYPWR_VBUCK2_EN_SHIFT               6
#define MT6315_PMIC_RG_KEYPWR_VBUCK1_EN_ADDR                \
	MT6315_BUCK_KEYPWR
#define MT6315_PMIC_RG_KEYPWR_VBUCK1_EN_MASK                0x1
#define MT6315_PMIC_RG_KEYPWR_VBUCK1_EN_SHIFT               7
#define MT6315_PMIC_RG_PSEQ_FORCE_ON_ADDR                   \
	MT6315_PPCTST0
#define MT6315_PMIC_RG_PSEQ_FORCE_ON_MASK                   0x1
#define MT6315_PMIC_RG_PSEQ_FORCE_ON_SHIFT                  0
#define MT6315_PMIC_RG_PSEQ_FORCE_TEST_EN_ADDR              \
	MT6315_PPCTST0
#define MT6315_PMIC_RG_PSEQ_FORCE_TEST_EN_MASK              0x1
#define MT6315_PMIC_RG_PSEQ_FORCE_TEST_EN_SHIFT             1
#define MT6315_PMIC_RG_PSEQ_FORCE_ALL_DOFF_ADDR             \
	MT6315_PPCTST0
#define MT6315_PMIC_RG_PSEQ_FORCE_ALL_DOFF_MASK             0x1
#define MT6315_PMIC_RG_PSEQ_FORCE_ALL_DOFF_SHIFT            2
#define MT6315_PMIC_RG_PSEQ_PG_CK_SEL_ADDR                  \
	MT6315_PPCCTL2
#define MT6315_PMIC_RG_PSEQ_PG_CK_SEL_MASK                  0x1
#define MT6315_PMIC_RG_PSEQ_PG_CK_SEL_SHIFT                 0
#define MT6315_PMIC_RG_THM_SHDN_EN_ADDR                     \
	MT6315_PPCCTL2
#define MT6315_PMIC_RG_THM_SHDN_EN_MASK                     0x1
#define MT6315_PMIC_RG_THM_SHDN_EN_SHIFT                    6
#define MT6315_PMIC_RG_OVLO_RDB_TD_ADDR                     \
	MT6315_STRUP_CON4
#define MT6315_PMIC_RG_OVLO_RDB_TD_MASK                     0x1
#define MT6315_PMIC_RG_OVLO_RDB_TD_SHIFT                    2
#define MT6315_PMIC_RG_OVLO_RDB_EN_ADDR                     \
	MT6315_STRUP_CON4
#define MT6315_PMIC_RG_OVLO_RDB_EN_MASK                     0x1
#define MT6315_PMIC_RG_OVLO_RDB_EN_SHIFT                    3
#define MT6315_PMIC_DDUVLO_DEB_EN_ADDR                      \
	MT6315_STRUP_CON5
#define MT6315_PMIC_DDUVLO_DEB_EN_MASK                      0x1
#define MT6315_PMIC_DDUVLO_DEB_EN_SHIFT                     4
#define MT6315_PMIC_RG_STRUP_FT_CTRL_ADDR                   \
	MT6315_STRUP_CON5
#define MT6315_PMIC_RG_STRUP_FT_CTRL_MASK                   0x3
#define MT6315_PMIC_RG_STRUP_FT_CTRL_SHIFT                  5
#define MT6315_PMIC_STRUP_DIG_IO_PG_FORCE_ADDR              \
	MT6315_STRUP_CON5
#define MT6315_PMIC_STRUP_DIG_IO_PG_FORCE_MASK              0x1
#define MT6315_PMIC_STRUP_DIG_IO_PG_FORCE_SHIFT             7
#define MT6315_PMIC_RG_ATST_PG_CHK_ADDR                     \
	MT6315_STRUP_CON6
#define MT6315_PMIC_RG_ATST_PG_CHK_MASK                     0x1
#define MT6315_PMIC_RG_ATST_PG_CHK_SHIFT                    0
#define MT6315_PMIC_RG_STRUP_PG_DEB_MODE_ADDR               \
	MT6315_STRUP_CON6
#define MT6315_PMIC_RG_STRUP_PG_DEB_MODE_MASK               0x1
#define MT6315_PMIC_RG_STRUP_PG_DEB_MODE_SHIFT              1
#define MT6315_PMIC_RG_CPS_W_KEY_ADDR                       \
	MT6315_CPSWKEY
#define MT6315_PMIC_RG_CPS_W_KEY_MASK                       0xFF
#define MT6315_PMIC_RG_CPS_W_KEY_SHIFT                      0
#define MT6315_PMIC_RG_CPS_W_KEY_H_ADDR                     \
	MT6315_CPSWKEY_H
#define MT6315_PMIC_RG_CPS_W_KEY_H_MASK                     0xFF
#define MT6315_PMIC_RG_CPS_W_KEY_H_SHIFT                    0
#define MT6315_PMIC_STS_PDN_ENCODE_ADDR                     \
	MT6315_STS_PDN_ENCODE
#define MT6315_PMIC_STS_PDN_ENCODE_MASK                     0x1F
#define MT6315_PMIC_STS_PDN_ENCODE_SHIFT                    0
#define MT6315_PMIC_PSEQ_ELR_LEN_ADDR                       \
	MT6315_PSEQ_ELR_NUM
#define MT6315_PMIC_PSEQ_ELR_LEN_MASK                       0xFF
#define MT6315_PMIC_PSEQ_ELR_LEN_SHIFT                      0
#define MT6315_PMIC_RG_SLOT_INTV_UP_ADDR                    \
	MT6315_PSEQ_ELR0
#define MT6315_PMIC_RG_SLOT_INTV_UP_MASK                    0x3
#define MT6315_PMIC_RG_SLOT_INTV_UP_SHIFT                   0
#define MT6315_PMIC_RG_SEQ_LEN_ADDR                         \
	MT6315_PSEQ_ELR0
#define MT6315_PMIC_RG_SEQ_LEN_MASK                         0x1F
#define MT6315_PMIC_RG_SEQ_LEN_SHIFT                        2
#define MT6315_PMIC_RG_PSEQ_ELR_RSV0_ADDR                   \
	MT6315_PSEQ_ELR0
#define MT6315_PMIC_RG_PSEQ_ELR_RSV0_MASK                   0x1
#define MT6315_PMIC_RG_PSEQ_ELR_RSV0_SHIFT                  7
#define MT6315_PMIC_RG_SLOT_INTV_DOWN_ADDR                  \
	MT6315_PSEQ_ELR1
#define MT6315_PMIC_RG_SLOT_INTV_DOWN_MASK                  0x3
#define MT6315_PMIC_RG_SLOT_INTV_DOWN_SHIFT                 0
#define MT6315_PMIC_RG_DSEQ_LEN_ADDR                        \
	MT6315_PSEQ_ELR1
#define MT6315_PMIC_RG_DSEQ_LEN_MASK                        0x1F
#define MT6315_PMIC_RG_DSEQ_LEN_SHIFT                       2
#define MT6315_PMIC_RG_PSEQ_ELR_RSV1_ADDR                   \
	MT6315_PSEQ_ELR1
#define MT6315_PMIC_RG_PSEQ_ELR_RSV1_MASK                   0x1
#define MT6315_PMIC_RG_PSEQ_ELR_RSV1_SHIFT                  7
#define MT6315_PMIC_RG_PSPG_SHDN_ENB_ADDR                   \
	MT6315_PSEQ_ELR2
#define MT6315_PMIC_RG_PSPG_SHDN_ENB_MASK                   0x3
#define MT6315_PMIC_RG_PSPG_SHDN_ENB_SHIFT                  0
#define MT6315_PMIC_RG_PSEQ_F32K_FORCE_ADDR                 \
	MT6315_PSEQ_ELR2
#define MT6315_PMIC_RG_PSEQ_F32K_FORCE_MASK                 0x1
#define MT6315_PMIC_RG_PSEQ_F32K_FORCE_SHIFT                2
#define MT6315_PMIC_RG_PSEQ_1MS_TK_EXT_ADDR                 \
	MT6315_PSEQ_ELR2
#define MT6315_PMIC_RG_PSEQ_1MS_TK_EXT_MASK                 0x1
#define MT6315_PMIC_RG_PSEQ_1MS_TK_EXT_SHIFT                3
#define MT6315_PMIC_RG_CPS_PGEXT_EN_ADDR                    \
	MT6315_PSEQ_ELR2
#define MT6315_PMIC_RG_CPS_PGEXT_EN_MASK                    0x1
#define MT6315_PMIC_RG_CPS_PGEXT_EN_SHIFT                   4
#define MT6315_PMIC_RG_SDN_DLY_ENB_ADDR                     \
	MT6315_PSEQ_ELR2
#define MT6315_PMIC_RG_SDN_DLY_ENB_MASK                     0x1
#define MT6315_PMIC_RG_SDN_DLY_ENB_SHIFT                    5
#define MT6315_PMIC_RG_STRUP_VBUCK4_PG_H2L_EN_ADDR          \
	MT6315_PSEQ_ELR3
#define MT6315_PMIC_RG_STRUP_VBUCK4_PG_H2L_EN_MASK          0x1
#define MT6315_PMIC_RG_STRUP_VBUCK4_PG_H2L_EN_SHIFT         4
#define MT6315_PMIC_RG_STRUP_VBUCK3_PG_H2L_EN_ADDR          \
	MT6315_PSEQ_ELR3
#define MT6315_PMIC_RG_STRUP_VBUCK3_PG_H2L_EN_MASK          0x1
#define MT6315_PMIC_RG_STRUP_VBUCK3_PG_H2L_EN_SHIFT         5
#define MT6315_PMIC_RG_STRUP_VBUCK2_PG_H2L_EN_ADDR          \
	MT6315_PSEQ_ELR3
#define MT6315_PMIC_RG_STRUP_VBUCK2_PG_H2L_EN_MASK          0x1
#define MT6315_PMIC_RG_STRUP_VBUCK2_PG_H2L_EN_SHIFT         6
#define MT6315_PMIC_RG_STRUP_VBUCK1_PG_H2L_EN_ADDR          \
	MT6315_PSEQ_ELR3
#define MT6315_PMIC_RG_STRUP_VBUCK1_PG_H2L_EN_MASK          0x1
#define MT6315_PMIC_RG_STRUP_VBUCK1_PG_H2L_EN_SHIFT         7
#define MT6315_PMIC_RG_PSC_ELR_RSV0_ADDR                    \
	MT6315_PSEQ_ELR4
#define MT6315_PMIC_RG_PSC_ELR_RSV0_MASK                    0xFF
#define MT6315_PMIC_RG_PSC_ELR_RSV0_SHIFT                   0
#define MT6315_PMIC_RG_PSC_ELR_RSV1_ADDR                    \
	MT6315_PSEQ_ELR5
#define MT6315_PMIC_RG_PSC_ELR_RSV1_MASK                    0xFF
#define MT6315_PMIC_RG_PSC_ELR_RSV1_SHIFT                   0
#define MT6315_PMIC_RG_VBUCK1_USA_ADDR                      \
	MT6315_CPSUSA_ELR0
#define MT6315_PMIC_RG_VBUCK1_USA_MASK                      0x1F
#define MT6315_PMIC_RG_VBUCK1_USA_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK2_USA_ADDR                      \
	MT6315_CPSUSA_ELR1
#define MT6315_PMIC_RG_VBUCK2_USA_MASK                      0x1F
#define MT6315_PMIC_RG_VBUCK2_USA_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK3_USA_ADDR                      \
	MT6315_CPSUSA_ELR2
#define MT6315_PMIC_RG_VBUCK3_USA_MASK                      0x1F
#define MT6315_PMIC_RG_VBUCK3_USA_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK4_USA_ADDR                      \
	MT6315_CPSUSA_ELR3
#define MT6315_PMIC_RG_VBUCK4_USA_MASK                      0x1F
#define MT6315_PMIC_RG_VBUCK4_USA_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK1_DSA_ADDR                      \
	MT6315_CPSDSA_ELR0
#define MT6315_PMIC_RG_VBUCK1_DSA_MASK                      0x1F
#define MT6315_PMIC_RG_VBUCK1_DSA_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK2_DSA_ADDR                      \
	MT6315_CPSDSA_ELR1
#define MT6315_PMIC_RG_VBUCK2_DSA_MASK                      0x1F
#define MT6315_PMIC_RG_VBUCK2_DSA_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK3_DSA_ADDR                      \
	MT6315_CPSDSA_ELR2
#define MT6315_PMIC_RG_VBUCK3_DSA_MASK                      0x1F
#define MT6315_PMIC_RG_VBUCK3_DSA_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK4_DSA_ADDR                      \
	MT6315_CPSDSA_ELR3
#define MT6315_PMIC_RG_VBUCK4_DSA_MASK                      0x1F
#define MT6315_PMIC_RG_VBUCK4_DSA_SHIFT                     0
#define MT6315_PMIC_STRUP_ANA0_ANA_ID_ADDR                  \
	MT6315_STRUP_ANA0_ANA_ID
#define MT6315_PMIC_STRUP_ANA0_ANA_ID_MASK                  0xFF
#define MT6315_PMIC_STRUP_ANA0_ANA_ID_SHIFT                 0
#define MT6315_PMIC_STRUP_ANA0_DIG_ID_ADDR                  \
	MT6315_STRUP_ANA0_DIG_ID
#define MT6315_PMIC_STRUP_ANA0_DIG_ID_MASK                  0xFF
#define MT6315_PMIC_STRUP_ANA0_DIG_ID_SHIFT                 0
#define MT6315_PMIC_STRUP_ANA0_ANA_MINOR_REV_ADDR           \
	MT6315_STRUP_ANA0_DSN_REV0
#define MT6315_PMIC_STRUP_ANA0_ANA_MINOR_REV_MASK           0xF
#define MT6315_PMIC_STRUP_ANA0_ANA_MINOR_REV_SHIFT          0
#define MT6315_PMIC_STRUP_ANA0_ANA_MAJOR_REV_ADDR           \
	MT6315_STRUP_ANA0_DSN_REV0
#define MT6315_PMIC_STRUP_ANA0_ANA_MAJOR_REV_MASK           0xF
#define MT6315_PMIC_STRUP_ANA0_ANA_MAJOR_REV_SHIFT          4
#define MT6315_PMIC_STRUP_ANA0_DIG_MINOR_REV_ADDR           \
	MT6315_STRUP_ANA0_DSN_REV1
#define MT6315_PMIC_STRUP_ANA0_DIG_MINOR_REV_MASK           0xF
#define MT6315_PMIC_STRUP_ANA0_DIG_MINOR_REV_SHIFT          0
#define MT6315_PMIC_STRUP_ANA0_DIG_MAJOR_REV_ADDR           \
	MT6315_STRUP_ANA0_DSN_REV1
#define MT6315_PMIC_STRUP_ANA0_DIG_MAJOR_REV_MASK           0xF
#define MT6315_PMIC_STRUP_ANA0_DIG_MAJOR_REV_SHIFT          4
#define MT6315_PMIC_STRUP_ANA0_CBS_ADDR                     \
	MT6315_STRUP_ANA0_DBI0
#define MT6315_PMIC_STRUP_ANA0_CBS_MASK                     0x3
#define MT6315_PMIC_STRUP_ANA0_CBS_SHIFT                    0
#define MT6315_PMIC_STRUP_ANA0_BIX_ADDR                     \
	MT6315_STRUP_ANA0_DBI0
#define MT6315_PMIC_STRUP_ANA0_BIX_MASK                     0x3
#define MT6315_PMIC_STRUP_ANA0_BIX_SHIFT                    2
#define MT6315_PMIC_STRUP_ANA0_ESP_ADDR                     \
	MT6315_STRUP_ANA0_DBI1
#define MT6315_PMIC_STRUP_ANA0_ESP_MASK                     0xFF
#define MT6315_PMIC_STRUP_ANA0_ESP_SHIFT                    0
#define MT6315_PMIC_STRUP_ANA0_FPI_ADDR                     \
	MT6315_STRUP_ANA0_DXI
#define MT6315_PMIC_STRUP_ANA0_FPI_MASK                     0xFF
#define MT6315_PMIC_STRUP_ANA0_FPI_SHIFT                    0
#define MT6315_PMIC_RG_VBG1_EN_ADDR                         \
	MT6315_STRUP_TOP_A10876A_ANA_CON0
#define MT6315_PMIC_RG_VBG1_EN_MASK                         0x1
#define MT6315_PMIC_RG_VBG1_EN_SHIFT                        0
#define MT6315_PMIC_RG_VBG2_EN_ADDR                         \
	MT6315_STRUP_TOP_A10876A_ANA_CON0
#define MT6315_PMIC_RG_VBG2_EN_MASK                         0x1
#define MT6315_PMIC_RG_VBG2_EN_SHIFT                        1
#define MT6315_PMIC_RG_VBGX_SEL_ADDR                        \
	MT6315_STRUP_TOP_A10876A_ANA_CON0
#define MT6315_PMIC_RG_VBGX_SEL_MASK                        0x1
#define MT6315_PMIC_RG_VBGX_SEL_SHIFT                       2
#define MT6315_PMIC_RG_VBG1_BYPASS_PREREG_ADDR              \
	MT6315_STRUP_TOP_A10876A_ANA_CON0
#define MT6315_PMIC_RG_VBG1_BYPASS_PREREG_MASK              0x1
#define MT6315_PMIC_RG_VBG1_BYPASS_PREREG_SHIFT             3
#define MT6315_PMIC_RG_VBG1_PREREG_VDB_EN_ADDR              \
	MT6315_STRUP_TOP_A10876A_ANA_CON0
#define MT6315_PMIC_RG_VBG1_PREREG_VDB_EN_MASK              0x1
#define MT6315_PMIC_RG_VBG1_PREREG_VDB_EN_SHIFT             4
#define MT6315_PMIC_RG_VBG2_LP_EN_ADDR                      \
	MT6315_STRUP_TOP_A10876A_ANA_CON0
#define MT6315_PMIC_RG_VBG2_LP_EN_MASK                      0x1
#define MT6315_PMIC_RG_VBG2_LP_EN_SHIFT                     5
#define MT6315_PMIC_RG_VBG_SCLPF_BYPASS_ADDR                \
	MT6315_STRUP_TOP_A10876A_ANA_CON0
#define MT6315_PMIC_RG_VBG_SCLPF_BYPASS_MASK                0x1
#define MT6315_PMIC_RG_VBG_SCLPF_BYPASS_SHIFT               6
#define MT6315_PMIC_RG_THERMAL_EN_ADDR                      \
	MT6315_STRUP_TOP_A10876A_ANA_CON1
#define MT6315_PMIC_RG_THERMAL_EN_MASK                      0x1
#define MT6315_PMIC_RG_THERMAL_EN_SHIFT                     0
#define MT6315_PMIC_RG_THERMAL_DET_SEL_ADDR                 \
	MT6315_STRUP_TOP_A10876A_ANA_CON1
#define MT6315_PMIC_RG_THERMAL_DET_SEL_MASK                 0x1
#define MT6315_PMIC_RG_THERMAL_DET_SEL_SHIFT                1
#define MT6315_PMIC_RG_THERMAL_TEMP_H_SEL_ADDR              \
	MT6315_STRUP_TOP_A10876A_ANA_CON1
#define MT6315_PMIC_RG_THERMAL_TEMP_H_SEL_MASK              0x3
#define MT6315_PMIC_RG_THERMAL_TEMP_H_SEL_SHIFT             2
#define MT6315_PMIC_RG_STRUP_OSC_EN_ADDR                    \
	MT6315_STRUP_TOP_A10876A_ANA_CON2
#define MT6315_PMIC_RG_STRUP_OSC_EN_MASK                    0x1
#define MT6315_PMIC_RG_STRUP_OSC_EN_SHIFT                   0
#define MT6315_PMIC_RG_SMPS_OSC_SEL_ADDR                    \
	MT6315_STRUP_TOP_A10876A_ANA_CON2
#define MT6315_PMIC_RG_SMPS_OSC_SEL_MASK                    0x1
#define MT6315_PMIC_RG_SMPS_OSC_SEL_SHIFT                   1
#define MT6315_PMIC_RG_UVLO_EN_ADDR                         \
	MT6315_STRUP_TOP_A10876A_ANA_CON2
#define MT6315_PMIC_RG_UVLO_EN_MASK                         0x1
#define MT6315_PMIC_RG_UVLO_EN_SHIFT                        2
#define MT6315_PMIC_RG_UVLO_FORCE_COMPH_ADDR                \
	MT6315_STRUP_TOP_A10876A_ANA_CON2
#define MT6315_PMIC_RG_UVLO_FORCE_COMPH_MASK                0x1
#define MT6315_PMIC_RG_UVLO_FORCE_COMPH_SHIFT               3
#define MT6315_PMIC_RG_OVLO_FORCE_COMPH_ADDR                \
	MT6315_STRUP_TOP_A10876A_ANA_CON2
#define MT6315_PMIC_RG_OVLO_FORCE_COMPH_MASK                0x1
#define MT6315_PMIC_RG_OVLO_FORCE_COMPH_SHIFT               4
#define MT6315_PMIC_RG_VBAT_FORCE_COMPH_ADDR                \
	MT6315_STRUP_TOP_A10876A_ANA_CON2
#define MT6315_PMIC_RG_VBAT_FORCE_COMPH_MASK                0x1
#define MT6315_PMIC_RG_VBAT_FORCE_COMPH_SHIFT               5
#define MT6315_PMIC_RG_ANA_TM_EN_ADDR                       \
	MT6315_STRUP_TOP_A10876A_ANA_CON3
#define MT6315_PMIC_RG_ANA_TM_EN_MASK                       0x1
#define MT6315_PMIC_RG_ANA_TM_EN_SHIFT                      0
#define MT6315_PMIC_RG_ANA_TM_SEL_ADDR                      \
	MT6315_STRUP_TOP_A10876A_ANA_CON3
#define MT6315_PMIC_RG_ANA_TM_SEL_MASK                      0x1
#define MT6315_PMIC_RG_ANA_TM_SEL_SHIFT                     1
#define MT6315_PMIC_RG_ANA_TM_MUX_SEL_ADDR                  \
	MT6315_STRUP_TOP_A10876A_ANA_CON3
#define MT6315_PMIC_RG_ANA_TM_MUX_SEL_MASK                  0xF
#define MT6315_PMIC_RG_ANA_TM_MUX_SEL_SHIFT                 2
#define MT6315_PMIC_RG_STRUP_RSV_ADDR                       \
	MT6315_STRUP_TOP_A10876A_ANA_CON4
#define MT6315_PMIC_RG_STRUP_RSV_MASK                       0xFF
#define MT6315_PMIC_RG_STRUP_RSV_SHIFT                      0
#define MT6315_PMIC_RG_PG_DISABLE_ADDR                      \
	MT6315_STRUP_TOP_A10876A_ANA_CON5
#define MT6315_PMIC_RG_PG_DISABLE_MASK                      0x1
#define MT6315_PMIC_RG_PG_DISABLE_SHIFT                     0
#define MT6315_PMIC_RG_VDIG18_DISCHARGE_EN_OPTION_ADDR      \
	MT6315_STRUP_TOP_A10876A_ANA_CON5
#define MT6315_PMIC_RG_VDIG18_DISCHARGE_EN_OPTION_MASK      0x1
#define MT6315_PMIC_RG_VDIG18_DISCHARGE_EN_OPTION_SHIFT     1
#define MT6315_PMIC_RG_VDIG18_FASTTRAN_EN_OPTION_ADDR       \
	MT6315_STRUP_TOP_A10876A_ANA_CON5
#define MT6315_PMIC_RG_VDIG18_FASTTRAN_EN_OPTION_MASK       0x1
#define MT6315_PMIC_RG_VDIG18_FASTTRAN_EN_OPTION_SHIFT      2
#define MT6315_PMIC_RG_VDIG18_RSV_ADDR                      \
	MT6315_STRUP_TOP_A10876A_ANA_CON5
#define MT6315_PMIC_RG_VDIG18_RSV_MASK                      0xF
#define MT6315_PMIC_RG_VDIG18_RSV_SHIFT                     3
#define MT6315_PMIC_RG_AUTOK_RST_ADDR                       \
	MT6315_STRUP_TOP_A10876A_ANA_CON6
#define MT6315_PMIC_RG_AUTOK_RST_MASK                       0x1
#define MT6315_PMIC_RG_AUTOK_RST_SHIFT                      0
#define MT6315_PMIC_RG_DISAUTOK_ADDR                        \
	MT6315_STRUP_TOP_A10876A_ANA_CON6
#define MT6315_PMIC_RG_DISAUTOK_MASK                        0x1
#define MT6315_PMIC_RG_DISAUTOK_SHIFT                       1
#define MT6315_PMIC_RGS_VBUCK1_PG_STATUS_ADDR               \
	MT6315_STRUP_TOP_A10876A_ANA_CON7
#define MT6315_PMIC_RGS_VBUCK1_PG_STATUS_MASK               0x1
#define MT6315_PMIC_RGS_VBUCK1_PG_STATUS_SHIFT              0
#define MT6315_PMIC_RGS_VBUCK2_PG_STATUS_ADDR               \
	MT6315_STRUP_TOP_A10876A_ANA_CON7
#define MT6315_PMIC_RGS_VBUCK2_PG_STATUS_MASK               0x1
#define MT6315_PMIC_RGS_VBUCK2_PG_STATUS_SHIFT              1
#define MT6315_PMIC_RGS_VBUCK3_PG_STATUS_ADDR               \
	MT6315_STRUP_TOP_A10876A_ANA_CON7
#define MT6315_PMIC_RGS_VBUCK3_PG_STATUS_MASK               0x1
#define MT6315_PMIC_RGS_VBUCK3_PG_STATUS_SHIFT              2
#define MT6315_PMIC_RGS_VBUCK4_PG_STATUS_ADDR               \
	MT6315_STRUP_TOP_A10876A_ANA_CON7
#define MT6315_PMIC_RGS_VBUCK4_PG_STATUS_MASK               0x1
#define MT6315_PMIC_RGS_VBUCK4_PG_STATUS_SHIFT              3
#define MT6315_PMIC_RGS_VIO18_PG_STATUS_ADDR                \
	MT6315_STRUP_TOP_A10876A_ANA_CON7
#define MT6315_PMIC_RGS_VIO18_PG_STATUS_MASK                0x1
#define MT6315_PMIC_RGS_VIO18_PG_STATUS_SHIFT               4
#define MT6315_PMIC_RGS_POFFSTS_ADDR                        \
	MT6315_STRUP_TOP_A10876A_ANA_CON8
#define MT6315_PMIC_RGS_POFFSTS_MASK                        0x1F
#define MT6315_PMIC_RGS_POFFSTS_SHIFT                       0
#define MT6315_PMIC_STRUP_ANA0_ELR_LEN_ADDR                 \
	MT6315_STRUP_ANA0_ELR_NUM
#define MT6315_PMIC_STRUP_ANA0_ELR_LEN_MASK                 0xFF
#define MT6315_PMIC_STRUP_ANA0_ELR_LEN_SHIFT                0
#define MT6315_PMIC_RG_VBG1_TC_TRIM_ADDR                    \
	MT6315_STRUP_TOP_A10876A_ELR_0
#define MT6315_PMIC_RG_VBG1_TC_TRIM_MASK                    0x1F
#define MT6315_PMIC_RG_VBG1_TC_TRIM_SHIFT                   0
#define MT6315_PMIC_RG_VBG2_TC_TRIM_ADDR                    \
	MT6315_STRUP_TOP_A10876A_ELR_1
#define MT6315_PMIC_RG_VBG2_TC_TRIM_MASK                    0xF
#define MT6315_PMIC_RG_VBG2_TC_TRIM_SHIFT                   0
#define MT6315_PMIC_RG_VBGR_IREF_TRIM_ADDR                  \
	MT6315_STRUP_TOP_A10876A_ELR_2
#define MT6315_PMIC_RG_VBGR_IREF_TRIM_MASK                  0xFF
#define MT6315_PMIC_RG_VBGR_IREF_TRIM_SHIFT                 0
#define MT6315_PMIC_RG_VBGR_VREF_TRIM_ADDR                  \
	MT6315_STRUP_TOP_A10876A_ELR_3
#define MT6315_PMIC_RG_VBGR_VREF_TRIM_MASK                  0xFF
#define MT6315_PMIC_RG_VBGR_VREF_TRIM_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK1_TRIM_ADDR                     \
	MT6315_STRUP_TOP_A10876A_ELR_4
#define MT6315_PMIC_RG_VBUCK1_TRIM_MASK                     0xF
#define MT6315_PMIC_RG_VBUCK1_TRIM_SHIFT                    0
#define MT6315_PMIC_RG_UVLO_VTHH_ADDR                       \
	MT6315_STRUP_TOP_A10876A_ELR_4
#define MT6315_PMIC_RG_UVLO_VTHH_MASK                       0x7
#define MT6315_PMIC_RG_UVLO_VTHH_SHIFT                      4
#define MT6315_PMIC_RG_VBUCK2_TRIM_ADDR                     \
	MT6315_STRUP_TOP_A10876A_ELR_5
#define MT6315_PMIC_RG_VBUCK2_TRIM_MASK                     0xF
#define MT6315_PMIC_RG_VBUCK2_TRIM_SHIFT                    0
#define MT6315_PMIC_RG_UVLO_VTHL_ADDR                       \
	MT6315_STRUP_TOP_A10876A_ELR_5
#define MT6315_PMIC_RG_UVLO_VTHL_MASK                       0x7
#define MT6315_PMIC_RG_UVLO_VTHL_SHIFT                      4
#define MT6315_PMIC_RG_VBUCK3_TRIM_ADDR                     \
	MT6315_STRUP_TOP_A10876A_ELR_6
#define MT6315_PMIC_RG_VBUCK3_TRIM_MASK                     0xF
#define MT6315_PMIC_RG_VBUCK3_TRIM_SHIFT                    0
#define MT6315_PMIC_RG_OVLO_VTHL_ADDR                       \
	MT6315_STRUP_TOP_A10876A_ELR_6
#define MT6315_PMIC_RG_OVLO_VTHL_MASK                       0x7
#define MT6315_PMIC_RG_OVLO_VTHL_SHIFT                      4
#define MT6315_PMIC_RG_VBUCK4_TRIM_ADDR                     \
	MT6315_STRUP_TOP_A10876A_ELR_7
#define MT6315_PMIC_RG_VBUCK4_TRIM_MASK                     0xF
#define MT6315_PMIC_RG_VBUCK4_TRIM_SHIFT                    0
#define MT6315_PMIC_RG_OVLO_VTHH_ADDR                       \
	MT6315_STRUP_TOP_A10876A_ELR_7
#define MT6315_PMIC_RG_OVLO_VTHH_MASK                       0x7
#define MT6315_PMIC_RG_OVLO_VTHH_SHIFT                      4
#define MT6315_PMIC_RG_VDIG18_TRIM_ADDR                     \
	MT6315_STRUP_TOP_A10876A_ELR_8
#define MT6315_PMIC_RG_VDIG18_TRIM_MASK                     0xF
#define MT6315_PMIC_RG_VDIG18_TRIM_SHIFT                    0
#define MT6315_PMIC_RG_OVLO_EN_ADDR                         \
	MT6315_STRUP_TOP_A10876A_ELR_8
#define MT6315_PMIC_RG_OVLO_EN_MASK                         0x1
#define MT6315_PMIC_RG_OVLO_EN_SHIFT                        4
#define MT6315_PMIC_RG_THERMAL_LOCATION_ADDR                \
	MT6315_STRUP_TOP_A10876A_ELR_9
#define MT6315_PMIC_RG_THERMAL_LOCATION_MASK                0x1F
#define MT6315_PMIC_RG_THERMAL_LOCATION_SHIFT               0
#define MT6315_PMIC_BUCK_TOP_ANA_ID_ADDR                    \
	MT6315_BUCK_TOP_ANA_ID
#define MT6315_PMIC_BUCK_TOP_ANA_ID_MASK                    0xFF
#define MT6315_PMIC_BUCK_TOP_ANA_ID_SHIFT                   0
#define MT6315_PMIC_BUCK_TOP_DIG_ID_ADDR                    \
	MT6315_BUCK_TOP_DIG_ID
#define MT6315_PMIC_BUCK_TOP_DIG_ID_MASK                    0xFF
#define MT6315_PMIC_BUCK_TOP_DIG_ID_SHIFT                   0
#define MT6315_PMIC_BUCK_TOP_ANA_MINOR_REV_ADDR             \
	MT6315_BUCK_TOP_REV0
#define MT6315_PMIC_BUCK_TOP_ANA_MINOR_REV_MASK             0xF
#define MT6315_PMIC_BUCK_TOP_ANA_MINOR_REV_SHIFT            0
#define MT6315_PMIC_BUCK_TOP_ANA_MAJOR_REV_ADDR             \
	MT6315_BUCK_TOP_REV0
#define MT6315_PMIC_BUCK_TOP_ANA_MAJOR_REV_MASK             0xF
#define MT6315_PMIC_BUCK_TOP_ANA_MAJOR_REV_SHIFT            4
#define MT6315_PMIC_BUCK_TOP_DIG_MINOR_REV_ADDR             \
	MT6315_BUCK_TOP_REV1
#define MT6315_PMIC_BUCK_TOP_DIG_MINOR_REV_MASK             0xF
#define MT6315_PMIC_BUCK_TOP_DIG_MINOR_REV_SHIFT            0
#define MT6315_PMIC_BUCK_TOP_DIG_MAJOR_REV_ADDR             \
	MT6315_BUCK_TOP_REV1
#define MT6315_PMIC_BUCK_TOP_DIG_MAJOR_REV_MASK             0xF
#define MT6315_PMIC_BUCK_TOP_DIG_MAJOR_REV_SHIFT            4
#define MT6315_PMIC_BUCK_TOP_CBS_ADDR                       \
	MT6315_BUCK_TOP_DBI0
#define MT6315_PMIC_BUCK_TOP_CBS_MASK                       0x3
#define MT6315_PMIC_BUCK_TOP_CBS_SHIFT                      0
#define MT6315_PMIC_BUCK_TOP_BIX_ADDR                       \
	MT6315_BUCK_TOP_DBI0
#define MT6315_PMIC_BUCK_TOP_BIX_MASK                       0x3
#define MT6315_PMIC_BUCK_TOP_BIX_SHIFT                      2
#define MT6315_PMIC_BUCK_TOP_ESP_ADDR                       \
	MT6315_BUCK_TOP_DBI1
#define MT6315_PMIC_BUCK_TOP_ESP_MASK                       0xFF
#define MT6315_PMIC_BUCK_TOP_ESP_SHIFT                      0
#define MT6315_PMIC_BUCK_TOP_FPI_ADDR                       \
	MT6315_BUCK_TOP_DXI
#define MT6315_PMIC_BUCK_TOP_FPI_MASK                       0xFF
#define MT6315_PMIC_BUCK_TOP_FPI_SHIFT                      0
#define MT6315_PMIC_BUCK_TOP_CLK_OFFSET_ADDR                \
	MT6315_BUCK_TOP_PAM0
#define MT6315_PMIC_BUCK_TOP_CLK_OFFSET_MASK                0xFF
#define MT6315_PMIC_BUCK_TOP_CLK_OFFSET_SHIFT               0
#define MT6315_PMIC_BUCK_TOP_RST_OFFSET_ADDR                \
	MT6315_BUCK_TOP_PAM1
#define MT6315_PMIC_BUCK_TOP_RST_OFFSET_MASK                0xFF
#define MT6315_PMIC_BUCK_TOP_RST_OFFSET_SHIFT               0
#define MT6315_PMIC_BUCK_TOP_INT_OFFSET_ADDR                \
	MT6315_BUCK_TOP_PAM2
#define MT6315_PMIC_BUCK_TOP_INT_OFFSET_MASK                0xFF
#define MT6315_PMIC_BUCK_TOP_INT_OFFSET_SHIFT               0
#define MT6315_PMIC_BUCK_TOP_INT_LEN_ADDR                   \
	MT6315_BUCK_TOP_PAM3
#define MT6315_PMIC_BUCK_TOP_INT_LEN_MASK                   0xFF
#define MT6315_PMIC_BUCK_TOP_INT_LEN_SHIFT                  0
#define MT6315_PMIC_RG_BUCK32K_CK_PDN_ADDR                  \
	MT6315_BUCK_TOP_CLK_CON0
#define MT6315_PMIC_RG_BUCK32K_CK_PDN_MASK                  0x1
#define MT6315_PMIC_RG_BUCK32K_CK_PDN_SHIFT                 0
#define MT6315_PMIC_RG_BUCK1M_CK_PDN_ADDR                   \
	MT6315_BUCK_TOP_CLK_CON0
#define MT6315_PMIC_RG_BUCK1M_CK_PDN_MASK                   0x1
#define MT6315_PMIC_RG_BUCK1M_CK_PDN_SHIFT                  1
#define MT6315_PMIC_RG_BUCK4M_CK_PDN_ADDR                   \
	MT6315_BUCK_TOP_CLK_CON0
#define MT6315_PMIC_RG_BUCK4M_CK_PDN_MASK                   0x1
#define MT6315_PMIC_RG_BUCK4M_CK_PDN_SHIFT                  2
#define MT6315_PMIC_RG_BUCK_RG_CK_PDN_ADDR                  \
	MT6315_BUCK_TOP_CLK_CON0
#define MT6315_PMIC_RG_BUCK_RG_CK_PDN_MASK                  0x1
#define MT6315_PMIC_RG_BUCK_RG_CK_PDN_SHIFT                 3
#define MT6315_PMIC_RG_BUCK_RG_CK_SEL_ADDR                  \
	MT6315_BUCK_TOP_CLK_CON0
#define MT6315_PMIC_RG_BUCK_RG_CK_SEL_MASK                  0x1
#define MT6315_PMIC_RG_BUCK_RG_CK_SEL_SHIFT                 4
#define MT6315_PMIC_RG_BUCK_SFCHG_SYNC_CK_FORCE_ADDR        \
	MT6315_BUCK_TOP_CLK_CON0
#define MT6315_PMIC_RG_BUCK_SFCHG_SYNC_CK_FORCE_MASK        0x1
#define MT6315_PMIC_RG_BUCK_SFCHG_SYNC_CK_FORCE_SHIFT       5
#define MT6315_PMIC_RG_BUCK_CK_RSV_ADDR                     \
	MT6315_BUCK_TOP_CLK_CON0
#define MT6315_PMIC_RG_BUCK_CK_RSV_MASK                     0x3
#define MT6315_PMIC_RG_BUCK_CK_RSV_SHIFT                    6
#define MT6315_PMIC_RG_BUCK_TOP_CLK_CON0_SET_ADDR           \
	MT6315_BUCK_TOP_CLK_CON0_SET
#define MT6315_PMIC_RG_BUCK_TOP_CLK_CON0_SET_MASK           0xFF
#define MT6315_PMIC_RG_BUCK_TOP_CLK_CON0_SET_SHIFT          0
#define MT6315_PMIC_RG_BUCK_TOP_CLK_CON0_CLR_ADDR           \
	MT6315_BUCK_TOP_CLK_CON0_CLR
#define MT6315_PMIC_RG_BUCK_TOP_CLK_CON0_CLR_MASK           0xFF
#define MT6315_PMIC_RG_BUCK_TOP_CLK_CON0_CLR_SHIFT          0
#define MT6315_PMIC_RG_BUCK32K_CK_PDN_HWEN_ADDR             \
	MT6315_BUCK_TOP_CLK_HWEN_CON0
#define MT6315_PMIC_RG_BUCK32K_CK_PDN_HWEN_MASK             0x1
#define MT6315_PMIC_RG_BUCK32K_CK_PDN_HWEN_SHIFT            0
#define MT6315_PMIC_RG_BUCK1M_CK_PDN_HWEN_ADDR              \
	MT6315_BUCK_TOP_CLK_HWEN_CON0
#define MT6315_PMIC_RG_BUCK1M_CK_PDN_HWEN_MASK              0x1
#define MT6315_PMIC_RG_BUCK1M_CK_PDN_HWEN_SHIFT             1
#define MT6315_PMIC_RG_BUCK4M_CK_PDN_HWEN_ADDR              \
	MT6315_BUCK_TOP_CLK_HWEN_CON0
#define MT6315_PMIC_RG_BUCK4M_CK_PDN_HWEN_MASK              0x1
#define MT6315_PMIC_RG_BUCK4M_CK_PDN_HWEN_SHIFT             2
#define MT6315_PMIC_RG_BUCK_RG_CK_PDN_HWEN_ADDR             \
	MT6315_BUCK_TOP_CLK_HWEN_CON0
#define MT6315_PMIC_RG_BUCK_RG_CK_PDN_HWEN_MASK             0x1
#define MT6315_PMIC_RG_BUCK_RG_CK_PDN_HWEN_SHIFT            3
#define MT6315_PMIC_RG_BUCK_SLEEP_CTRL_MODE_ADDR            \
	MT6315_BUCK_TOP_CLK_HWEN_CON0
#define MT6315_PMIC_RG_BUCK_SLEEP_CTRL_MODE_MASK            0x1
#define MT6315_PMIC_RG_BUCK_SLEEP_CTRL_MODE_SHIFT           4
#define MT6315_PMIC_RG_BUCK_CK_PDN_HWEN_RSV_ADDR            \
	MT6315_BUCK_TOP_CLK_HWEN_CON0
#define MT6315_PMIC_RG_BUCK_CK_PDN_HWEN_RSV_MASK            0x7
#define MT6315_PMIC_RG_BUCK_CK_PDN_HWEN_RSV_SHIFT           5
#define MT6315_PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_SET_ADDR      \
	MT6315_BUCK_TOP_CLK_HWEN_CON0_SET
#define MT6315_PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_SET_MASK      0xFF
#define MT6315_PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_SET_SHIFT     0
#define MT6315_PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_CLR_ADDR      \
	MT6315_BUCK_TOP_CLK_HWEN_CON0_CLR
#define MT6315_PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_CLR_MASK      0xFF
#define MT6315_PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_CLR_SHIFT     0
#define MT6315_PMIC_RG_BUCK_DLE_DCM_ADDR                    \
	MT6315_BUCK_TOP_CLK_DCM_CON
#define MT6315_PMIC_RG_BUCK_DLE_DCM_MASK                    0x1
#define MT6315_PMIC_RG_BUCK_DLE_DCM_SHIFT                   0
#define MT6315_PMIC_RG_BUCK_INIS_SET_ADDR                   \
	MT6315_BUCK_TOP_SYNC_CON
#define MT6315_PMIC_RG_BUCK_INIS_SET_MASK                   0x1
#define MT6315_PMIC_RG_BUCK_INIS_SET_SHIFT                  0
#define MT6315_PMIC_RG_BUCK_SYNC_RSV_ADDR                   \
	MT6315_BUCK_TOP_SYNC_CON
#define MT6315_PMIC_RG_BUCK_SYNC_RSV_MASK                   0x7
#define MT6315_PMIC_RG_BUCK_SYNC_RSV_SHIFT                  1
#define MT6315_PMIC_RG_BUCK_STB_MAX_ADDR                    \
	MT6315_BUCK_TOP_STB_CON
#define MT6315_PMIC_RG_BUCK_STB_MAX_MASK                    0xFF
#define MT6315_PMIC_RG_BUCK_STB_MAX_SHIFT                   0
#define MT6315_PMIC_RG_BUCK_VGP2_MINFREQ_LATENCY_MAX_ADDR   \
	MT6315_BUCK_TOP_VGP2_MINFREQ_CON0
#define MT6315_PMIC_RG_BUCK_VGP2_MINFREQ_LATENCY_MAX_MASK   0xFF
#define MT6315_PMIC_RG_BUCK_VGP2_MINFREQ_LATENCY_MAX_SHIFT  0
#define MT6315_PMIC_RG_BUCK_VGP2_MINFREQ_DURATION_MAX_ADDR  \
	MT6315_BUCK_TOP_VGP2_MINFREQ_CON1
#define MT6315_PMIC_RG_BUCK_VGP2_MINFREQ_DURATION_MAX_MASK  0x7
#define MT6315_PMIC_RG_BUCK_VGP2_MINFREQ_DURATION_MAX_SHIFT 0
#define MT6315_PMIC_RG_BUCK_VBUCK1_OC_SDN_STATUS_ADDR       \
	MT6315_BUCK_TOP_OC_CON0
#define MT6315_PMIC_RG_BUCK_VBUCK1_OC_SDN_STATUS_MASK       0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_OC_SDN_STATUS_SHIFT      0
#define MT6315_PMIC_RG_BUCK_VBUCK2_OC_SDN_STATUS_ADDR       \
	MT6315_BUCK_TOP_OC_CON0
#define MT6315_PMIC_RG_BUCK_VBUCK2_OC_SDN_STATUS_MASK       0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_OC_SDN_STATUS_SHIFT      1
#define MT6315_PMIC_RG_BUCK_VBUCK3_OC_SDN_STATUS_ADDR       \
	MT6315_BUCK_TOP_OC_CON0
#define MT6315_PMIC_RG_BUCK_VBUCK3_OC_SDN_STATUS_MASK       0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_OC_SDN_STATUS_SHIFT      2
#define MT6315_PMIC_RG_BUCK_VBUCK4_OC_SDN_STATUS_ADDR       \
	MT6315_BUCK_TOP_OC_CON0
#define MT6315_PMIC_RG_BUCK_VBUCK4_OC_SDN_STATUS_MASK       0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_OC_SDN_STATUS_SHIFT      3
#define MT6315_PMIC_BUCK_TOP_WRITE_KEY_ADDR                 \
	MT6315_BUCK_TOP_KEY_PROT0
#define MT6315_PMIC_BUCK_TOP_WRITE_KEY_MASK                 0xFF
#define MT6315_PMIC_BUCK_TOP_WRITE_KEY_SHIFT                0
#define MT6315_PMIC_BUCK_TOP_WRITE_KEY_H_ADDR               \
	MT6315_BUCK_TOP_KEY_PROT1
#define MT6315_PMIC_BUCK_TOP_WRITE_KEY_H_MASK               0xFF
#define MT6315_PMIC_BUCK_TOP_WRITE_KEY_H_SHIFT              0
#define MT6315_PMIC_BUCK_VBUCK1_WDTDBG_VOSEL_ADDR           \
	MT6315_BUCK_TOP_WDTDBG0
#define MT6315_PMIC_BUCK_VBUCK1_WDTDBG_VOSEL_MASK           0xFF
#define MT6315_PMIC_BUCK_VBUCK1_WDTDBG_VOSEL_SHIFT          0
#define MT6315_PMIC_BUCK_VBUCK1_WDTDBG_VOSEL_LSB_ADDR       \
	MT6315_BUCK_TOP_WDTDBG1
#define MT6315_PMIC_BUCK_VBUCK1_WDTDBG_VOSEL_LSB_MASK       0x1
#define MT6315_PMIC_BUCK_VBUCK1_WDTDBG_VOSEL_LSB_SHIFT      0
#define MT6315_PMIC_BUCK_VBUCK2_WDTDBG_VOSEL_ADDR           \
	MT6315_BUCK_TOP_WDTDBG2
#define MT6315_PMIC_BUCK_VBUCK2_WDTDBG_VOSEL_MASK           0xFF
#define MT6315_PMIC_BUCK_VBUCK2_WDTDBG_VOSEL_SHIFT          0
#define MT6315_PMIC_BUCK_VBUCK2_WDTDBG_VOSEL_LSB_ADDR       \
	MT6315_BUCK_TOP_WDTDBG3
#define MT6315_PMIC_BUCK_VBUCK2_WDTDBG_VOSEL_LSB_MASK       0x1
#define MT6315_PMIC_BUCK_VBUCK2_WDTDBG_VOSEL_LSB_SHIFT      0
#define MT6315_PMIC_BUCK_VBUCK3_WDTDBG_VOSEL_ADDR           \
	MT6315_BUCK_TOP_WDTDBG4
#define MT6315_PMIC_BUCK_VBUCK3_WDTDBG_VOSEL_MASK           0xFF
#define MT6315_PMIC_BUCK_VBUCK3_WDTDBG_VOSEL_SHIFT          0
#define MT6315_PMIC_BUCK_VBUCK3_WDTDBG_VOSEL_LSB_ADDR       \
	MT6315_BUCK_TOP_WDTDBG5
#define MT6315_PMIC_BUCK_VBUCK3_WDTDBG_VOSEL_LSB_MASK       0x1
#define MT6315_PMIC_BUCK_VBUCK3_WDTDBG_VOSEL_LSB_SHIFT      0
#define MT6315_PMIC_BUCK_VBUCK4_WDTDBG_VOSEL_ADDR           \
	MT6315_BUCK_TOP_WDTDBG6
#define MT6315_PMIC_BUCK_VBUCK4_WDTDBG_VOSEL_MASK           0xFF
#define MT6315_PMIC_BUCK_VBUCK4_WDTDBG_VOSEL_SHIFT          0
#define MT6315_PMIC_BUCK_VBUCK4_WDTDBG_VOSEL_LSB_ADDR       \
	MT6315_BUCK_TOP_WDTDBG7
#define MT6315_PMIC_BUCK_VBUCK4_WDTDBG_VOSEL_LSB_MASK       0x1
#define MT6315_PMIC_BUCK_VBUCK4_WDTDBG_VOSEL_LSB_SHIFT      0
#define MT6315_PMIC_RGS_BUCK_TOP_DBG_ADDR                   \
	MT6315_BUCK_TOP_DBG
#define MT6315_PMIC_RGS_BUCK_TOP_DBG_MASK                   0xFF
#define MT6315_PMIC_RGS_BUCK_TOP_DBG_SHIFT                  0
#define MT6315_PMIC_RG_BUCK_VBUCK1_EN_ADDR                  \
	MT6315_BUCK_TOP_CON0
#define MT6315_PMIC_RG_BUCK_VBUCK1_EN_MASK                  0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_EN_SHIFT                 0
#define MT6315_PMIC_RG_BUCK_VBUCK2_EN_ADDR                  \
	MT6315_BUCK_TOP_CON0
#define MT6315_PMIC_RG_BUCK_VBUCK2_EN_MASK                  0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_EN_SHIFT                 1
#define MT6315_PMIC_RG_BUCK_VBUCK3_EN_ADDR                  \
	MT6315_BUCK_TOP_CON0
#define MT6315_PMIC_RG_BUCK_VBUCK3_EN_MASK                  0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_EN_SHIFT                 2
#define MT6315_PMIC_RG_BUCK_VBUCK4_EN_ADDR                  \
	MT6315_BUCK_TOP_CON0
#define MT6315_PMIC_RG_BUCK_VBUCK4_EN_MASK                  0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_EN_SHIFT                 3
#define MT6315_PMIC_RG_BUCK_VBUCK_EN_SET_ADDR               \
	MT6315_BUCK_TOP_CON0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK_EN_SET_MASK               0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK_EN_SET_SHIFT              0
#define MT6315_PMIC_RG_BUCK_VBUCK_EN_CLR_ADDR               \
	MT6315_BUCK_TOP_CON0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK_EN_CLR_MASK               0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK_EN_CLR_SHIFT              0
#define MT6315_PMIC_RG_BUCK_VBUCK1_LP_ADDR                  \
	MT6315_BUCK_TOP_CON1
#define MT6315_PMIC_RG_BUCK_VBUCK1_LP_MASK                  0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_LP_SHIFT                 0
#define MT6315_PMIC_RG_BUCK_VBUCK2_LP_ADDR                  \
	MT6315_BUCK_TOP_CON1
#define MT6315_PMIC_RG_BUCK_VBUCK2_LP_MASK                  0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_LP_SHIFT                 1
#define MT6315_PMIC_RG_BUCK_VBUCK3_LP_ADDR                  \
	MT6315_BUCK_TOP_CON1
#define MT6315_PMIC_RG_BUCK_VBUCK3_LP_MASK                  0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_LP_SHIFT                 2
#define MT6315_PMIC_RG_BUCK_VBUCK4_LP_ADDR                  \
	MT6315_BUCK_TOP_CON1
#define MT6315_PMIC_RG_BUCK_VBUCK4_LP_MASK                  0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_LP_SHIFT                 3
#define MT6315_PMIC_RG_BUCK_VBUCK_LP_SET_ADDR               \
	MT6315_BUCK_TOP_CON1_SET
#define MT6315_PMIC_RG_BUCK_VBUCK_LP_SET_MASK               0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK_LP_SET_SHIFT              0
#define MT6315_PMIC_RG_BUCK_VBUCK_LP_CLR_ADDR               \
	MT6315_BUCK_TOP_CON1_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK_LP_CLR_MASK               0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK_LP_CLR_SHIFT              0
#define MT6315_PMIC_BUCK_TOP_ELR_LEN_ADDR                   \
	MT6315_BUCK_TOP_ELR_NUM
#define MT6315_PMIC_BUCK_TOP_ELR_LEN_MASK                   0xFF
#define MT6315_PMIC_BUCK_TOP_ELR_LEN_SHIFT                  0
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_ADDR               \
	MT6315_BUCK_TOP_ELR0
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_MASK               0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_SHIFT              0
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_LSB_ADDR           \
	MT6315_BUCK_TOP_ELR1
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_LSB_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_LSB_SHIFT          0
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_ADDR               \
	MT6315_BUCK_TOP_ELR2
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_MASK               0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_SHIFT              0
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_LSB_ADDR           \
	MT6315_BUCK_TOP_ELR3
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_LSB_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_LSB_SHIFT          0
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_ADDR               \
	MT6315_BUCK_TOP_ELR4
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_MASK               0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_SHIFT              0
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_LSB_ADDR           \
	MT6315_BUCK_TOP_ELR5
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_LSB_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_LSB_SHIFT          0
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_ADDR               \
	MT6315_BUCK_TOP_ELR6
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_MASK               0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_SHIFT              0
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_LSB_ADDR           \
	MT6315_BUCK_TOP_ELR7
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_LSB_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_LSB_SHIFT          0
#define MT6315_PMIC_RG_BUCK_VBUCK1_OC_SDN_EN_ADDR           \
	MT6315_BUCK_TOP_ELR8
#define MT6315_PMIC_RG_BUCK_VBUCK1_OC_SDN_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_OC_SDN_EN_SHIFT          0
#define MT6315_PMIC_RG_BUCK_VBUCK2_OC_SDN_EN_ADDR           \
	MT6315_BUCK_TOP_ELR8
#define MT6315_PMIC_RG_BUCK_VBUCK2_OC_SDN_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_OC_SDN_EN_SHIFT          1
#define MT6315_PMIC_RG_BUCK_VBUCK3_OC_SDN_EN_ADDR           \
	MT6315_BUCK_TOP_ELR8
#define MT6315_PMIC_RG_BUCK_VBUCK3_OC_SDN_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_OC_SDN_EN_SHIFT          2
#define MT6315_PMIC_RG_BUCK_VBUCK4_OC_SDN_EN_ADDR           \
	MT6315_BUCK_TOP_ELR8
#define MT6315_PMIC_RG_BUCK_VBUCK4_OC_SDN_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_OC_SDN_EN_SHIFT          3
#define MT6315_PMIC_RG_BUCK_DCM_MODE_ADDR                   \
	MT6315_BUCK_TOP_ELR8
#define MT6315_PMIC_RG_BUCK_DCM_MODE_MASK                   0x1
#define MT6315_PMIC_RG_BUCK_DCM_MODE_SHIFT                  4
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_LIMIT_SEL_ADDR     \
	MT6315_BUCK_TOP_ELR9
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_LIMIT_SEL_MASK     0x3
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_LIMIT_SEL_SHIFT    0
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_LIMIT_SEL_ADDR     \
	MT6315_BUCK_TOP_ELR9
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_LIMIT_SEL_MASK     0x3
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_LIMIT_SEL_SHIFT    2
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_LIMIT_SEL_ADDR     \
	MT6315_BUCK_TOP_ELR9
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_LIMIT_SEL_MASK     0x3
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_LIMIT_SEL_SHIFT    4
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_LIMIT_SEL_ADDR     \
	MT6315_BUCK_TOP_ELR9
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_LIMIT_SEL_MASK     0x3
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_LIMIT_SEL_SHIFT    6
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_VLIMIT_ADDR        \
	MT6315_BUCK_TOP_ELR10
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_VLIMIT_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_VLIMIT_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_VLIMIT_ADDR        \
	MT6315_BUCK_TOP_ELR11
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_VLIMIT_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_VLIMIT_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_VLIMIT_ADDR        \
	MT6315_BUCK_TOP_ELR12
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_VLIMIT_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_VLIMIT_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_VLIMIT_ADDR        \
	MT6315_BUCK_TOP_ELR13
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_VLIMIT_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_VLIMIT_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK1_ONSC_TD_ADDR             \
	MT6315_BUCK_TOP_ELR14
#define MT6315_PMIC_RG_BUCK_VBUCK1_ONSC_TD_MASK             0x3
#define MT6315_PMIC_RG_BUCK_VBUCK1_ONSC_TD_SHIFT            0
#define MT6315_PMIC_RG_BUCK_VBUCK2_ONSC_TD_ADDR             \
	MT6315_BUCK_TOP_ELR14
#define MT6315_PMIC_RG_BUCK_VBUCK2_ONSC_TD_MASK             0x3
#define MT6315_PMIC_RG_BUCK_VBUCK2_ONSC_TD_SHIFT            2
#define MT6315_PMIC_RG_BUCK_VBUCK3_ONSC_TD_ADDR             \
	MT6315_BUCK_TOP_ELR14
#define MT6315_PMIC_RG_BUCK_VBUCK3_ONSC_TD_MASK             0x3
#define MT6315_PMIC_RG_BUCK_VBUCK3_ONSC_TD_SHIFT            4
#define MT6315_PMIC_RG_BUCK_VBUCK4_ONSC_TD_ADDR             \
	MT6315_BUCK_TOP_ELR14
#define MT6315_PMIC_RG_BUCK_VBUCK4_ONSC_TD_MASK             0x3
#define MT6315_PMIC_RG_BUCK_VBUCK4_ONSC_TD_SHIFT            6
#define MT6315_PMIC_RG_BUCK_EFUSE_RSV_ADDR                  \
	MT6315_BUCK_TOP_ELR15
#define MT6315_PMIC_RG_BUCK_EFUSE_RSV_MASK                  0xFF
#define MT6315_PMIC_RG_BUCK_EFUSE_RSV_SHIFT                 0
#define MT6315_PMIC_BUCK_VBUCK1_ANA_ID_ADDR                 \
	MT6315_BUCK_VBUCK1_ANA_ID
#define MT6315_PMIC_BUCK_VBUCK1_ANA_ID_MASK                 0xFF
#define MT6315_PMIC_BUCK_VBUCK1_ANA_ID_SHIFT                0
#define MT6315_PMIC_BUCK_VBUCK1_DIG_ID_ADDR                 \
	MT6315_BUCK_VBUCK1_DIG_ID
#define MT6315_PMIC_BUCK_VBUCK1_DIG_ID_MASK                 0xFF
#define MT6315_PMIC_BUCK_VBUCK1_DIG_ID_SHIFT                0
#define MT6315_PMIC_BUCK_VBUCK1_ANA_MINOR_REV_ADDR          \
	MT6315_BUCK_VBUCK1_REV0
#define MT6315_PMIC_BUCK_VBUCK1_ANA_MINOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK1_ANA_MINOR_REV_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK1_ANA_MAJOR_REV_ADDR          \
	MT6315_BUCK_VBUCK1_REV0
#define MT6315_PMIC_BUCK_VBUCK1_ANA_MAJOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK1_ANA_MAJOR_REV_SHIFT         4
#define MT6315_PMIC_BUCK_VBUCK1_DIG_MINOR_REV_ADDR          \
	MT6315_BUCK_VBUCK1_REV1
#define MT6315_PMIC_BUCK_VBUCK1_DIG_MINOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK1_DIG_MINOR_REV_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK1_DIG_MAJOR_REV_ADDR          \
	MT6315_BUCK_VBUCK1_REV1
#define MT6315_PMIC_BUCK_VBUCK1_DIG_MAJOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK1_DIG_MAJOR_REV_SHIFT         4
#define MT6315_PMIC_BUCK_VBUCK1_DSN_CBS_ADDR                \
	MT6315_BUCK_VBUCK1_DBI0
#define MT6315_PMIC_BUCK_VBUCK1_DSN_CBS_MASK                0x3
#define MT6315_PMIC_BUCK_VBUCK1_DSN_CBS_SHIFT               0
#define MT6315_PMIC_BUCK_VBUCK1_DSN_BIX_ADDR                \
	MT6315_BUCK_VBUCK1_DBI0
#define MT6315_PMIC_BUCK_VBUCK1_DSN_BIX_MASK                0x3
#define MT6315_PMIC_BUCK_VBUCK1_DSN_BIX_SHIFT               2
#define MT6315_PMIC_BUCK_VBUCK1_DSN_ESP_ADDR                \
	MT6315_BUCK_VBUCK1_DBI1
#define MT6315_PMIC_BUCK_VBUCK1_DSN_ESP_MASK                0xFF
#define MT6315_PMIC_BUCK_VBUCK1_DSN_ESP_SHIFT               0
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_SSHUB_ADDR          \
	MT6315_BUCK_VBUCK1_DXI
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_SSHUB_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_SSHUB_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_TRACKING_ADDR       \
	MT6315_BUCK_VBUCK1_DXI
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_TRACKING_MASK       0x1
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_TRACKING_SHIFT      1
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_PREOC_ADDR          \
	MT6315_BUCK_VBUCK1_DXI
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_PREOC_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_PREOC_SHIFT         2
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_VOTER_ADDR          \
	MT6315_BUCK_VBUCK1_DXI
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_VOTER_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_VOTER_SHIFT         3
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_ULTRASONIC_ADDR     \
	MT6315_BUCK_VBUCK1_DXI
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_ULTRASONIC_MASK     0x1
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_ULTRASONIC_SHIFT    4
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_DLC_ADDR            \
	MT6315_BUCK_VBUCK1_DXI
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_DLC_MASK            0x1
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_DLC_SHIFT           5
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_TRAP_ADDR           \
	MT6315_BUCK_VBUCK1_DXI
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_TRAP_MASK           0x1
#define MT6315_PMIC_BUCK_VBUCK1_DSN_FPI_TRAP_SHIFT          6
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_SLEEP_ADDR         \
	MT6315_BUCK_VBUCK1_CON1
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_SLEEP_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_SLEEP_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_SLEEP_LSB_ADDR     \
	MT6315_BUCK_VBUCK1_CON2
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_SLEEP_LSB_MASK     0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_VOSEL_SLEEP_LSB_SHIFT    0
#define MT6315_PMIC_RG_BUCK_VBUCK1_SELR2R_CTRL_ADDR         \
	MT6315_BUCK_VBUCK1_SLP_CON
#define MT6315_PMIC_RG_BUCK_VBUCK1_SELR2R_CTRL_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_SELR2R_CTRL_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK1_DVS_EN_MASK_ADDR         \
	MT6315_BUCK_VBUCK1_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK1_DVS_EN_MASK_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_DVS_EN_MASK_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK1_DVS_UP_MASK_ADDR         \
	MT6315_BUCK_VBUCK1_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK1_DVS_UP_MASK_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_DVS_UP_MASK_SHIFT        1
#define MT6315_PMIC_RG_BUCK_VBUCK1_DVS_DOWN_MASK_ADDR       \
	MT6315_BUCK_VBUCK1_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK1_DVS_DOWN_MASK_MASK       0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_DVS_DOWN_MASK_SHIFT      2
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_RRATE_ADDR         \
	MT6315_BUCK_VBUCK1_CFG0
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_RRATE_MASK         0x7F
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_RRATE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_REN_ADDR           \
	MT6315_BUCK_VBUCK1_CFG0
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_REN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_REN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_FRATE_ADDR         \
	MT6315_BUCK_VBUCK1_CFG1
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_FRATE_MASK         0x7F
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_FRATE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_FEN_ADDR           \
	MT6315_BUCK_VBUCK1_CFG1
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_FEN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_SFCHG_FEN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW0_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK1_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW0_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW0_OP_EN_SHIFT          0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW1_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK1_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW1_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW1_OP_EN_SHIFT          1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW2_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK1_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW2_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW2_OP_EN_SHIFT          2
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW3_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK1_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW3_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW3_OP_EN_SHIFT          3
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW4_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK1_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW4_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW4_OP_EN_SHIFT          4
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW5_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK1_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW5_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW5_OP_EN_SHIFT          5
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW6_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK1_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW6_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW6_OP_EN_SHIFT          6
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW7_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK1_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW7_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW7_OP_EN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_0_SET_ADDR         \
	MT6315_BUCK_VBUCK1_OP_EN_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_0_SET_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_0_SET_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_0_CLR_ADDR         \
	MT6315_BUCK_VBUCK1_OP_EN_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_0_CLR_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_0_CLR_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK1_SW_OP_EN_ADDR            \
	MT6315_BUCK_VBUCK1_OP_EN_1
#define MT6315_PMIC_RG_BUCK_VBUCK1_SW_OP_EN_MASK            0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_SW_OP_EN_SHIFT           0
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_1_SET_ADDR         \
	MT6315_BUCK_VBUCK1_OP_EN_1_SET
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_1_SET_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_1_SET_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_1_CLR_ADDR         \
	MT6315_BUCK_VBUCK1_OP_EN_1_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_1_CLR_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_EN_1_CLR_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW0_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK1_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW0_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW0_OP_CFG_SHIFT         0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW1_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK1_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW1_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW1_OP_CFG_SHIFT         1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW2_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK1_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW2_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW2_OP_CFG_SHIFT         2
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW3_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK1_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW3_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW3_OP_CFG_SHIFT         3
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW4_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK1_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW4_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW4_OP_CFG_SHIFT         4
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW5_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK1_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW5_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW5_OP_CFG_SHIFT         5
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW6_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK1_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW6_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW6_OP_CFG_SHIFT         6
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW7_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK1_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW7_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW7_OP_CFG_SHIFT         7
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_CFG_0_SET_ADDR        \
	MT6315_BUCK_VBUCK1_OP_CFG_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_CFG_0_SET_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_CFG_0_SET_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_CFG_0_CLR_ADDR        \
	MT6315_BUCK_VBUCK1_OP_CFG_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_CFG_0_CLR_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_CFG_0_CLR_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW0_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK1_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW0_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW0_OP_MODE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW1_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK1_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW1_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW1_OP_MODE_SHIFT        1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW2_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK1_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW2_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW2_OP_MODE_SHIFT        2
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW3_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK1_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW3_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW3_OP_MODE_SHIFT        3
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW4_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK1_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW4_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW4_OP_MODE_SHIFT        4
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW5_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK1_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW5_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW5_OP_MODE_SHIFT        5
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW6_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK1_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW6_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW6_OP_MODE_SHIFT        6
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW7_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK1_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW7_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_HW7_OP_MODE_SHIFT        7
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_MODE_0_SET_ADDR       \
	MT6315_BUCK_VBUCK1_OP_MODE_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_MODE_0_SET_MASK       0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_MODE_0_SET_SHIFT      0
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_MODE_0_CLR_ADDR       \
	MT6315_BUCK_VBUCK1_OP_MODE_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_MODE_0_CLR_MASK       0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK1_OP_MODE_0_CLR_SHIFT      0
#define MT6315_PMIC_DA_VBUCK1_VOSEL_ADDR                    \
	MT6315_BUCK_VBUCK1_DBG0
#define MT6315_PMIC_DA_VBUCK1_VOSEL_MASK                    0xFF
#define MT6315_PMIC_DA_VBUCK1_VOSEL_SHIFT                   0
#define MT6315_PMIC_DA_VBUCK1_VOSEL_LSB_ADDR                \
	MT6315_BUCK_VBUCK1_DBG1
#define MT6315_PMIC_DA_VBUCK1_VOSEL_LSB_MASK                0x1
#define MT6315_PMIC_DA_VBUCK1_VOSEL_LSB_SHIFT               0
#define MT6315_PMIC_DA_VBUCK1_VOSEL_GRAY_ADDR               \
	MT6315_BUCK_VBUCK1_DBG2
#define MT6315_PMIC_DA_VBUCK1_VOSEL_GRAY_MASK               0xFF
#define MT6315_PMIC_DA_VBUCK1_VOSEL_GRAY_SHIFT              0
#define MT6315_PMIC_DA_VBUCK1_VOSEL_GRAY_LSB_ADDR           \
	MT6315_BUCK_VBUCK1_DBG3
#define MT6315_PMIC_DA_VBUCK1_VOSEL_GRAY_LSB_MASK           0x1
#define MT6315_PMIC_DA_VBUCK1_VOSEL_GRAY_LSB_SHIFT          0
#define MT6315_PMIC_DA_VBUCK1_EN_ADDR                       \
	MT6315_BUCK_VBUCK1_DBG4
#define MT6315_PMIC_DA_VBUCK1_EN_MASK                       0x1
#define MT6315_PMIC_DA_VBUCK1_EN_SHIFT                      0
#define MT6315_PMIC_DA_VBUCK1_STB_ADDR                      \
	MT6315_BUCK_VBUCK1_DBG4
#define MT6315_PMIC_DA_VBUCK1_STB_MASK                      0x1
#define MT6315_PMIC_DA_VBUCK1_STB_SHIFT                     1
#define MT6315_PMIC_DA_VBUCK1_LOOP_SEL_ADDR                 \
	MT6315_BUCK_VBUCK1_DBG4
#define MT6315_PMIC_DA_VBUCK1_LOOP_SEL_MASK                 0x1
#define MT6315_PMIC_DA_VBUCK1_LOOP_SEL_SHIFT                2
#define MT6315_PMIC_DA_VBUCK1_R2R_PDN_ADDR                  \
	MT6315_BUCK_VBUCK1_DBG4
#define MT6315_PMIC_DA_VBUCK1_R2R_PDN_MASK                  0x1
#define MT6315_PMIC_DA_VBUCK1_R2R_PDN_SHIFT                 3
#define MT6315_PMIC_DA_VBUCK1_DVS_EN_ADDR                   \
	MT6315_BUCK_VBUCK1_DBG4
#define MT6315_PMIC_DA_VBUCK1_DVS_EN_MASK                   0x1
#define MT6315_PMIC_DA_VBUCK1_DVS_EN_SHIFT                  4
#define MT6315_PMIC_DA_VBUCK1_DVS_UP_ADDR                   \
	MT6315_BUCK_VBUCK1_DBG4
#define MT6315_PMIC_DA_VBUCK1_DVS_UP_MASK                   0x1
#define MT6315_PMIC_DA_VBUCK1_DVS_UP_SHIFT                  5
#define MT6315_PMIC_DA_VBUCK1_DVS_DOWN_ADDR                 \
	MT6315_BUCK_VBUCK1_DBG4
#define MT6315_PMIC_DA_VBUCK1_DVS_DOWN_MASK                 0x1
#define MT6315_PMIC_DA_VBUCK1_DVS_DOWN_SHIFT                6
#define MT6315_PMIC_DA_VBUCK1_SSH_ADDR                      \
	MT6315_BUCK_VBUCK1_DBG4
#define MT6315_PMIC_DA_VBUCK1_SSH_MASK                      0x1
#define MT6315_PMIC_DA_VBUCK1_SSH_SHIFT                     7
#define MT6315_PMIC_DA_VBUCK1_MINFREQ_DISCHARGE_ADDR        \
	MT6315_BUCK_VBUCK1_DBG5
#define MT6315_PMIC_DA_VBUCK1_MINFREQ_DISCHARGE_MASK        0x1
#define MT6315_PMIC_DA_VBUCK1_MINFREQ_DISCHARGE_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK1_CK_SW_MODE_ADDR          \
	MT6315_BUCK_VBUCK1_DBG5
#define MT6315_PMIC_RG_BUCK_VBUCK1_CK_SW_MODE_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_CK_SW_MODE_SHIFT         4
#define MT6315_PMIC_RG_BUCK_VBUCK1_CK_SW_EN_ADDR            \
	MT6315_BUCK_VBUCK1_DBG5
#define MT6315_PMIC_RG_BUCK_VBUCK1_CK_SW_EN_MASK            0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_CK_SW_EN_SHIFT           5
#define MT6315_PMIC_RG_BUCK_VBUCK1_TRACK_STALL_BYPASS_ADDR  \
	MT6315_BUCK_VBUCK1_STALL_TRACK0
#define MT6315_PMIC_RG_BUCK_VBUCK1_TRACK_STALL_BYPASS_MASK  0x1
#define MT6315_PMIC_RG_BUCK_VBUCK1_TRACK_STALL_BYPASS_SHIFT 0
#define MT6315_PMIC_BUCK_VBUCK2_ANA_ID_ADDR                 \
	MT6315_BUCK_VBUCK2_ANA_ID
#define MT6315_PMIC_BUCK_VBUCK2_ANA_ID_MASK                 0xFF
#define MT6315_PMIC_BUCK_VBUCK2_ANA_ID_SHIFT                0
#define MT6315_PMIC_BUCK_VBUCK2_DIG_ID_ADDR                 \
	MT6315_BUCK_VBUCK2_DIG_ID
#define MT6315_PMIC_BUCK_VBUCK2_DIG_ID_MASK                 0xFF
#define MT6315_PMIC_BUCK_VBUCK2_DIG_ID_SHIFT                0
#define MT6315_PMIC_BUCK_VBUCK2_ANA_MINOR_REV_ADDR          \
	MT6315_BUCK_VBUCK2_REV0
#define MT6315_PMIC_BUCK_VBUCK2_ANA_MINOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK2_ANA_MINOR_REV_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK2_ANA_MAJOR_REV_ADDR          \
	MT6315_BUCK_VBUCK2_REV0
#define MT6315_PMIC_BUCK_VBUCK2_ANA_MAJOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK2_ANA_MAJOR_REV_SHIFT         4
#define MT6315_PMIC_BUCK_VBUCK2_DIG_MINOR_REV_ADDR          \
	MT6315_BUCK_VBUCK2_REV1
#define MT6315_PMIC_BUCK_VBUCK2_DIG_MINOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK2_DIG_MINOR_REV_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK2_DIG_MAJOR_REV_ADDR          \
	MT6315_BUCK_VBUCK2_REV1
#define MT6315_PMIC_BUCK_VBUCK2_DIG_MAJOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK2_DIG_MAJOR_REV_SHIFT         4
#define MT6315_PMIC_BUCK_VBUCK2_DSN_CBS_ADDR                \
	MT6315_BUCK_VBUCK2_DBI0
#define MT6315_PMIC_BUCK_VBUCK2_DSN_CBS_MASK                0x3
#define MT6315_PMIC_BUCK_VBUCK2_DSN_CBS_SHIFT               0
#define MT6315_PMIC_BUCK_VBUCK2_DSN_BIX_ADDR                \
	MT6315_BUCK_VBUCK2_DBI0
#define MT6315_PMIC_BUCK_VBUCK2_DSN_BIX_MASK                0x3
#define MT6315_PMIC_BUCK_VBUCK2_DSN_BIX_SHIFT               2
#define MT6315_PMIC_BUCK_VBUCK2_DSN_ESP_ADDR                \
	MT6315_BUCK_VBUCK2_DBI1
#define MT6315_PMIC_BUCK_VBUCK2_DSN_ESP_MASK                0xFF
#define MT6315_PMIC_BUCK_VBUCK2_DSN_ESP_SHIFT               0
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_SSHUB_ADDR          \
	MT6315_BUCK_VBUCK2_DXI
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_SSHUB_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_SSHUB_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_TRACKING_ADDR       \
	MT6315_BUCK_VBUCK2_DXI
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_TRACKING_MASK       0x1
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_TRACKING_SHIFT      1
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_PREOC_ADDR          \
	MT6315_BUCK_VBUCK2_DXI
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_PREOC_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_PREOC_SHIFT         2
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_VOTER_ADDR          \
	MT6315_BUCK_VBUCK2_DXI
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_VOTER_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_VOTER_SHIFT         3
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_ULTRASONIC_ADDR     \
	MT6315_BUCK_VBUCK2_DXI
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_ULTRASONIC_MASK     0x1
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_ULTRASONIC_SHIFT    4
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_DLC_ADDR            \
	MT6315_BUCK_VBUCK2_DXI
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_DLC_MASK            0x1
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_DLC_SHIFT           5
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_TRAP_ADDR           \
	MT6315_BUCK_VBUCK2_DXI
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_TRAP_MASK           0x1
#define MT6315_PMIC_BUCK_VBUCK2_DSN_FPI_TRAP_SHIFT          6
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_SLEEP_ADDR         \
	MT6315_BUCK_VBUCK2_CON1
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_SLEEP_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_SLEEP_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_SLEEP_LSB_ADDR     \
	MT6315_BUCK_VBUCK2_CON2
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_SLEEP_LSB_MASK     0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_VOSEL_SLEEP_LSB_SHIFT    0
#define MT6315_PMIC_RG_BUCK_VBUCK2_SELR2R_CTRL_ADDR         \
	MT6315_BUCK_VBUCK2_SLP_CON
#define MT6315_PMIC_RG_BUCK_VBUCK2_SELR2R_CTRL_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_SELR2R_CTRL_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK2_DVS_EN_MASK_ADDR         \
	MT6315_BUCK_VBUCK2_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK2_DVS_EN_MASK_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_DVS_EN_MASK_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK2_DVS_UP_MASK_ADDR         \
	MT6315_BUCK_VBUCK2_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK2_DVS_UP_MASK_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_DVS_UP_MASK_SHIFT        1
#define MT6315_PMIC_RG_BUCK_VBUCK2_DVS_DOWN_MASK_ADDR       \
	MT6315_BUCK_VBUCK2_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK2_DVS_DOWN_MASK_MASK       0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_DVS_DOWN_MASK_SHIFT      2
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_RRATE_ADDR         \
	MT6315_BUCK_VBUCK2_CFG0
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_RRATE_MASK         0x7F
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_RRATE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_REN_ADDR           \
	MT6315_BUCK_VBUCK2_CFG0
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_REN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_REN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_FRATE_ADDR         \
	MT6315_BUCK_VBUCK2_CFG1
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_FRATE_MASK         0x7F
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_FRATE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_FEN_ADDR           \
	MT6315_BUCK_VBUCK2_CFG1
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_FEN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_SFCHG_FEN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW0_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK2_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW0_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW0_OP_EN_SHIFT          0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW1_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK2_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW1_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW1_OP_EN_SHIFT          1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW2_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK2_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW2_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW2_OP_EN_SHIFT          2
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW3_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK2_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW3_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW3_OP_EN_SHIFT          3
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW4_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK2_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW4_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW4_OP_EN_SHIFT          4
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW5_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK2_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW5_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW5_OP_EN_SHIFT          5
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW6_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK2_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW6_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW6_OP_EN_SHIFT          6
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW7_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK2_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW7_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW7_OP_EN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_0_SET_ADDR         \
	MT6315_BUCK_VBUCK2_OP_EN_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_0_SET_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_0_SET_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_0_CLR_ADDR         \
	MT6315_BUCK_VBUCK2_OP_EN_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_0_CLR_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_0_CLR_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK2_SW_OP_EN_ADDR            \
	MT6315_BUCK_VBUCK2_OP_EN_1
#define MT6315_PMIC_RG_BUCK_VBUCK2_SW_OP_EN_MASK            0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_SW_OP_EN_SHIFT           0
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_1_SET_ADDR         \
	MT6315_BUCK_VBUCK2_OP_EN_1_SET
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_1_SET_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_1_SET_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_1_CLR_ADDR         \
	MT6315_BUCK_VBUCK2_OP_EN_1_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_1_CLR_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_EN_1_CLR_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW0_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK2_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW0_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW0_OP_CFG_SHIFT         0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW1_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK2_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW1_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW1_OP_CFG_SHIFT         1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW2_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK2_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW2_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW2_OP_CFG_SHIFT         2
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW3_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK2_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW3_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW3_OP_CFG_SHIFT         3
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW4_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK2_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW4_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW4_OP_CFG_SHIFT         4
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW5_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK2_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW5_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW5_OP_CFG_SHIFT         5
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW6_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK2_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW6_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW6_OP_CFG_SHIFT         6
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW7_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK2_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW7_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW7_OP_CFG_SHIFT         7
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_CFG_0_SET_ADDR        \
	MT6315_BUCK_VBUCK2_OP_CFG_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_CFG_0_SET_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_CFG_0_SET_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_CFG_0_CLR_ADDR        \
	MT6315_BUCK_VBUCK2_OP_CFG_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_CFG_0_CLR_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_CFG_0_CLR_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW0_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK2_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW0_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW0_OP_MODE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW1_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK2_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW1_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW1_OP_MODE_SHIFT        1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW2_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK2_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW2_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW2_OP_MODE_SHIFT        2
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW3_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK2_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW3_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW3_OP_MODE_SHIFT        3
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW4_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK2_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW4_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW4_OP_MODE_SHIFT        4
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW5_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK2_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW5_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW5_OP_MODE_SHIFT        5
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW6_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK2_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW6_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW6_OP_MODE_SHIFT        6
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW7_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK2_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW7_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_HW7_OP_MODE_SHIFT        7
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_MODE_0_SET_ADDR       \
	MT6315_BUCK_VBUCK2_OP_MODE_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_MODE_0_SET_MASK       0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_MODE_0_SET_SHIFT      0
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_MODE_0_CLR_ADDR       \
	MT6315_BUCK_VBUCK2_OP_MODE_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_MODE_0_CLR_MASK       0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK2_OP_MODE_0_CLR_SHIFT      0
#define MT6315_PMIC_DA_VBUCK2_VOSEL_ADDR                    \
	MT6315_BUCK_VBUCK2_DBG0
#define MT6315_PMIC_DA_VBUCK2_VOSEL_MASK                    0xFF
#define MT6315_PMIC_DA_VBUCK2_VOSEL_SHIFT                   0
#define MT6315_PMIC_DA_VBUCK2_VOSEL_LSB_ADDR                \
	MT6315_BUCK_VBUCK2_DBG1
#define MT6315_PMIC_DA_VBUCK2_VOSEL_LSB_MASK                0x1
#define MT6315_PMIC_DA_VBUCK2_VOSEL_LSB_SHIFT               0
#define MT6315_PMIC_DA_VBUCK2_VOSEL_GRAY_ADDR               \
	MT6315_BUCK_VBUCK2_DBG2
#define MT6315_PMIC_DA_VBUCK2_VOSEL_GRAY_MASK               0xFF
#define MT6315_PMIC_DA_VBUCK2_VOSEL_GRAY_SHIFT              0
#define MT6315_PMIC_DA_VBUCK2_VOSEL_GRAY_LSB_ADDR           \
	MT6315_BUCK_VBUCK2_DBG3
#define MT6315_PMIC_DA_VBUCK2_VOSEL_GRAY_LSB_MASK           0x1
#define MT6315_PMIC_DA_VBUCK2_VOSEL_GRAY_LSB_SHIFT          0
#define MT6315_PMIC_DA_VBUCK2_EN_ADDR                       \
	MT6315_BUCK_VBUCK2_DBG4
#define MT6315_PMIC_DA_VBUCK2_EN_MASK                       0x1
#define MT6315_PMIC_DA_VBUCK2_EN_SHIFT                      0
#define MT6315_PMIC_DA_VBUCK2_STB_ADDR                      \
	MT6315_BUCK_VBUCK2_DBG4
#define MT6315_PMIC_DA_VBUCK2_STB_MASK                      0x1
#define MT6315_PMIC_DA_VBUCK2_STB_SHIFT                     1
#define MT6315_PMIC_DA_VBUCK2_LOOP_SEL_ADDR                 \
	MT6315_BUCK_VBUCK2_DBG4
#define MT6315_PMIC_DA_VBUCK2_LOOP_SEL_MASK                 0x1
#define MT6315_PMIC_DA_VBUCK2_LOOP_SEL_SHIFT                2
#define MT6315_PMIC_DA_VBUCK2_R2R_PDN_ADDR                  \
	MT6315_BUCK_VBUCK2_DBG4
#define MT6315_PMIC_DA_VBUCK2_R2R_PDN_MASK                  0x1
#define MT6315_PMIC_DA_VBUCK2_R2R_PDN_SHIFT                 3
#define MT6315_PMIC_DA_VBUCK2_DVS_EN_ADDR                   \
	MT6315_BUCK_VBUCK2_DBG4
#define MT6315_PMIC_DA_VBUCK2_DVS_EN_MASK                   0x1
#define MT6315_PMIC_DA_VBUCK2_DVS_EN_SHIFT                  4
#define MT6315_PMIC_DA_VBUCK2_DVS_UP_ADDR                   \
	MT6315_BUCK_VBUCK2_DBG4
#define MT6315_PMIC_DA_VBUCK2_DVS_UP_MASK                   0x1
#define MT6315_PMIC_DA_VBUCK2_DVS_UP_SHIFT                  5
#define MT6315_PMIC_DA_VBUCK2_DVS_DOWN_ADDR                 \
	MT6315_BUCK_VBUCK2_DBG4
#define MT6315_PMIC_DA_VBUCK2_DVS_DOWN_MASK                 0x1
#define MT6315_PMIC_DA_VBUCK2_DVS_DOWN_SHIFT                6
#define MT6315_PMIC_DA_VBUCK2_SSH_ADDR                      \
	MT6315_BUCK_VBUCK2_DBG4
#define MT6315_PMIC_DA_VBUCK2_SSH_MASK                      0x1
#define MT6315_PMIC_DA_VBUCK2_SSH_SHIFT                     7
#define MT6315_PMIC_DA_VBUCK2_MINFREQ_DISCHARGE_ADDR        \
	MT6315_BUCK_VBUCK2_DBG5
#define MT6315_PMIC_DA_VBUCK2_MINFREQ_DISCHARGE_MASK        0x1
#define MT6315_PMIC_DA_VBUCK2_MINFREQ_DISCHARGE_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK2_CK_SW_MODE_ADDR          \
	MT6315_BUCK_VBUCK2_DBG5
#define MT6315_PMIC_RG_BUCK_VBUCK2_CK_SW_MODE_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_CK_SW_MODE_SHIFT         4
#define MT6315_PMIC_RG_BUCK_VBUCK2_CK_SW_EN_ADDR            \
	MT6315_BUCK_VBUCK2_DBG5
#define MT6315_PMIC_RG_BUCK_VBUCK2_CK_SW_EN_MASK            0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_CK_SW_EN_SHIFT           5
#define MT6315_PMIC_RG_BUCK_VBUCK2_TRACK_STALL_BYPASS_ADDR  \
	MT6315_BUCK_VBUCK2_STALL_TRACK0
#define MT6315_PMIC_RG_BUCK_VBUCK2_TRACK_STALL_BYPASS_MASK  0x1
#define MT6315_PMIC_RG_BUCK_VBUCK2_TRACK_STALL_BYPASS_SHIFT 0
#define MT6315_PMIC_BUCK_VBUCK3_ANA_ID_ADDR                 \
	MT6315_BUCK_VBUCK3_ANA_ID
#define MT6315_PMIC_BUCK_VBUCK3_ANA_ID_MASK                 0xFF
#define MT6315_PMIC_BUCK_VBUCK3_ANA_ID_SHIFT                0
#define MT6315_PMIC_BUCK_VBUCK3_DIG_ID_ADDR                 \
	MT6315_BUCK_VBUCK3_DIG_ID
#define MT6315_PMIC_BUCK_VBUCK3_DIG_ID_MASK                 0xFF
#define MT6315_PMIC_BUCK_VBUCK3_DIG_ID_SHIFT                0
#define MT6315_PMIC_BUCK_VBUCK3_ANA_MINOR_REV_ADDR          \
	MT6315_BUCK_VBUCK3_REV0
#define MT6315_PMIC_BUCK_VBUCK3_ANA_MINOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK3_ANA_MINOR_REV_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK3_ANA_MAJOR_REV_ADDR          \
	MT6315_BUCK_VBUCK3_REV0
#define MT6315_PMIC_BUCK_VBUCK3_ANA_MAJOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK3_ANA_MAJOR_REV_SHIFT         4
#define MT6315_PMIC_BUCK_VBUCK3_DIG_MINOR_REV_ADDR          \
	MT6315_BUCK_VBUCK3_REV1
#define MT6315_PMIC_BUCK_VBUCK3_DIG_MINOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK3_DIG_MINOR_REV_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK3_DIG_MAJOR_REV_ADDR          \
	MT6315_BUCK_VBUCK3_REV1
#define MT6315_PMIC_BUCK_VBUCK3_DIG_MAJOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK3_DIG_MAJOR_REV_SHIFT         4
#define MT6315_PMIC_BUCK_VBUCK3_DSN_CBS_ADDR                \
	MT6315_BUCK_VBUCK3_DBI0
#define MT6315_PMIC_BUCK_VBUCK3_DSN_CBS_MASK                0x3
#define MT6315_PMIC_BUCK_VBUCK3_DSN_CBS_SHIFT               0
#define MT6315_PMIC_BUCK_VBUCK3_DSN_BIX_ADDR                \
	MT6315_BUCK_VBUCK3_DBI0
#define MT6315_PMIC_BUCK_VBUCK3_DSN_BIX_MASK                0x3
#define MT6315_PMIC_BUCK_VBUCK3_DSN_BIX_SHIFT               2
#define MT6315_PMIC_BUCK_VBUCK3_DSN_ESP_ADDR                \
	MT6315_BUCK_VBUCK3_DBI1
#define MT6315_PMIC_BUCK_VBUCK3_DSN_ESP_MASK                0xFF
#define MT6315_PMIC_BUCK_VBUCK3_DSN_ESP_SHIFT               0
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_SSHUB_ADDR          \
	MT6315_BUCK_VBUCK3_DXI
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_SSHUB_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_SSHUB_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_TRACKING_ADDR       \
	MT6315_BUCK_VBUCK3_DXI
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_TRACKING_MASK       0x1
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_TRACKING_SHIFT      1
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_PREOC_ADDR          \
	MT6315_BUCK_VBUCK3_DXI
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_PREOC_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_PREOC_SHIFT         2
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_VOTER_ADDR          \
	MT6315_BUCK_VBUCK3_DXI
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_VOTER_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_VOTER_SHIFT         3
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_ULTRASONIC_ADDR     \
	MT6315_BUCK_VBUCK3_DXI
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_ULTRASONIC_MASK     0x1
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_ULTRASONIC_SHIFT    4
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_DLC_ADDR            \
	MT6315_BUCK_VBUCK3_DXI
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_DLC_MASK            0x1
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_DLC_SHIFT           5
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_TRAP_ADDR           \
	MT6315_BUCK_VBUCK3_DXI
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_TRAP_MASK           0x1
#define MT6315_PMIC_BUCK_VBUCK3_DSN_FPI_TRAP_SHIFT          6
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_SLEEP_ADDR         \
	MT6315_BUCK_VBUCK3_CON1
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_SLEEP_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_SLEEP_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_SLEEP_LSB_ADDR     \
	MT6315_BUCK_VBUCK3_CON2
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_SLEEP_LSB_MASK     0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_SLEEP_LSB_SHIFT    0
#define MT6315_PMIC_RG_BUCK_VBUCK3_SELR2R_CTRL_ADDR         \
	MT6315_BUCK_VBUCK3_SLP_CON
#define MT6315_PMIC_RG_BUCK_VBUCK3_SELR2R_CTRL_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_SELR2R_CTRL_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK3_DVS_EN_MASK_ADDR         \
	MT6315_BUCK_VBUCK3_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK3_DVS_EN_MASK_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_DVS_EN_MASK_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK3_DVS_UP_MASK_ADDR         \
	MT6315_BUCK_VBUCK3_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK3_DVS_UP_MASK_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_DVS_UP_MASK_SHIFT        1
#define MT6315_PMIC_RG_BUCK_VBUCK3_DVS_DOWN_MASK_ADDR       \
	MT6315_BUCK_VBUCK3_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK3_DVS_DOWN_MASK_MASK       0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_DVS_DOWN_MASK_SHIFT      2
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_RRATE_ADDR         \
	MT6315_BUCK_VBUCK3_CFG0
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_RRATE_MASK         0x7F
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_RRATE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_REN_ADDR           \
	MT6315_BUCK_VBUCK3_CFG0
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_REN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_REN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_FRATE_ADDR         \
	MT6315_BUCK_VBUCK3_CFG1
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_FRATE_MASK         0x7F
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_FRATE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_FEN_ADDR           \
	MT6315_BUCK_VBUCK3_CFG1
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_FEN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_SFCHG_FEN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW0_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK3_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW0_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW0_OP_EN_SHIFT          0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW1_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK3_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW1_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW1_OP_EN_SHIFT          1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW2_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK3_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW2_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW2_OP_EN_SHIFT          2
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW3_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK3_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW3_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW3_OP_EN_SHIFT          3
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW4_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK3_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW4_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW4_OP_EN_SHIFT          4
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW5_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK3_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW5_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW5_OP_EN_SHIFT          5
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW6_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK3_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW6_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW6_OP_EN_SHIFT          6
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW7_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK3_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW7_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW7_OP_EN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_0_SET_ADDR         \
	MT6315_BUCK_VBUCK3_OP_EN_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_0_SET_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_0_SET_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_0_CLR_ADDR         \
	MT6315_BUCK_VBUCK3_OP_EN_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_0_CLR_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_0_CLR_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK3_SW_OP_EN_ADDR            \
	MT6315_BUCK_VBUCK3_OP_EN_1
#define MT6315_PMIC_RG_BUCK_VBUCK3_SW_OP_EN_MASK            0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_SW_OP_EN_SHIFT           0
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_1_SET_ADDR         \
	MT6315_BUCK_VBUCK3_OP_EN_1_SET
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_1_SET_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_1_SET_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_1_CLR_ADDR         \
	MT6315_BUCK_VBUCK3_OP_EN_1_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_1_CLR_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_EN_1_CLR_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW0_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK3_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW0_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW0_OP_CFG_SHIFT         0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW1_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK3_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW1_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW1_OP_CFG_SHIFT         1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW2_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK3_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW2_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW2_OP_CFG_SHIFT         2
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW3_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK3_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW3_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW3_OP_CFG_SHIFT         3
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW4_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK3_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW4_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW4_OP_CFG_SHIFT         4
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW5_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK3_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW5_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW5_OP_CFG_SHIFT         5
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW6_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK3_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW6_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW6_OP_CFG_SHIFT         6
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW7_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK3_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW7_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW7_OP_CFG_SHIFT         7
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_CFG_0_SET_ADDR        \
	MT6315_BUCK_VBUCK3_OP_CFG_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_CFG_0_SET_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_CFG_0_SET_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_CFG_0_CLR_ADDR        \
	MT6315_BUCK_VBUCK3_OP_CFG_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_CFG_0_CLR_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_CFG_0_CLR_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW0_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK3_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW0_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW0_OP_MODE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW1_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK3_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW1_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW1_OP_MODE_SHIFT        1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW2_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK3_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW2_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW2_OP_MODE_SHIFT        2
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW3_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK3_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW3_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW3_OP_MODE_SHIFT        3
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW4_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK3_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW4_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW4_OP_MODE_SHIFT        4
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW5_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK3_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW5_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW5_OP_MODE_SHIFT        5
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW6_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK3_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW6_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW6_OP_MODE_SHIFT        6
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW7_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK3_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW7_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_HW7_OP_MODE_SHIFT        7
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_MODE_0_SET_ADDR       \
	MT6315_BUCK_VBUCK3_OP_MODE_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_MODE_0_SET_MASK       0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_MODE_0_SET_SHIFT      0
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_MODE_0_CLR_ADDR       \
	MT6315_BUCK_VBUCK3_OP_MODE_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_MODE_0_CLR_MASK       0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_OP_MODE_0_CLR_SHIFT      0
#define MT6315_PMIC_DA_VBUCK3_VOSEL_ADDR                    \
	MT6315_BUCK_VBUCK3_DBG0
#define MT6315_PMIC_DA_VBUCK3_VOSEL_MASK                    0xFF
#define MT6315_PMIC_DA_VBUCK3_VOSEL_SHIFT                   0
#define MT6315_PMIC_DA_VBUCK3_VOSEL_LSB_ADDR                \
	MT6315_BUCK_VBUCK3_DBG1
#define MT6315_PMIC_DA_VBUCK3_VOSEL_LSB_MASK                0x1
#define MT6315_PMIC_DA_VBUCK3_VOSEL_LSB_SHIFT               0
#define MT6315_PMIC_DA_VBUCK3_VOSEL_GRAY_ADDR               \
	MT6315_BUCK_VBUCK3_DBG2
#define MT6315_PMIC_DA_VBUCK3_VOSEL_GRAY_MASK               0xFF
#define MT6315_PMIC_DA_VBUCK3_VOSEL_GRAY_SHIFT              0
#define MT6315_PMIC_DA_VBUCK3_VOSEL_GRAY_LSB_ADDR           \
	MT6315_BUCK_VBUCK3_DBG3
#define MT6315_PMIC_DA_VBUCK3_VOSEL_GRAY_LSB_MASK           0x1
#define MT6315_PMIC_DA_VBUCK3_VOSEL_GRAY_LSB_SHIFT          0
#define MT6315_PMIC_DA_VBUCK3_EN_ADDR                       \
	MT6315_BUCK_VBUCK3_DBG4
#define MT6315_PMIC_DA_VBUCK3_EN_MASK                       0x1
#define MT6315_PMIC_DA_VBUCK3_EN_SHIFT                      0
#define MT6315_PMIC_DA_VBUCK3_STB_ADDR                      \
	MT6315_BUCK_VBUCK3_DBG4
#define MT6315_PMIC_DA_VBUCK3_STB_MASK                      0x1
#define MT6315_PMIC_DA_VBUCK3_STB_SHIFT                     1
#define MT6315_PMIC_DA_VBUCK3_LOOP_SEL_ADDR                 \
	MT6315_BUCK_VBUCK3_DBG4
#define MT6315_PMIC_DA_VBUCK3_LOOP_SEL_MASK                 0x1
#define MT6315_PMIC_DA_VBUCK3_LOOP_SEL_SHIFT                2
#define MT6315_PMIC_DA_VBUCK3_R2R_PDN_ADDR                  \
	MT6315_BUCK_VBUCK3_DBG4
#define MT6315_PMIC_DA_VBUCK3_R2R_PDN_MASK                  0x1
#define MT6315_PMIC_DA_VBUCK3_R2R_PDN_SHIFT                 3
#define MT6315_PMIC_DA_VBUCK3_DVS_EN_ADDR                   \
	MT6315_BUCK_VBUCK3_DBG4
#define MT6315_PMIC_DA_VBUCK3_DVS_EN_MASK                   0x1
#define MT6315_PMIC_DA_VBUCK3_DVS_EN_SHIFT                  4
#define MT6315_PMIC_DA_VBUCK3_DVS_UP_ADDR                   \
	MT6315_BUCK_VBUCK3_DBG4
#define MT6315_PMIC_DA_VBUCK3_DVS_UP_MASK                   0x1
#define MT6315_PMIC_DA_VBUCK3_DVS_UP_SHIFT                  5
#define MT6315_PMIC_DA_VBUCK3_DVS_DOWN_ADDR                 \
	MT6315_BUCK_VBUCK3_DBG4
#define MT6315_PMIC_DA_VBUCK3_DVS_DOWN_MASK                 0x1
#define MT6315_PMIC_DA_VBUCK3_DVS_DOWN_SHIFT                6
#define MT6315_PMIC_DA_VBUCK3_SSH_ADDR                      \
	MT6315_BUCK_VBUCK3_DBG4
#define MT6315_PMIC_DA_VBUCK3_SSH_MASK                      0x1
#define MT6315_PMIC_DA_VBUCK3_SSH_SHIFT                     7
#define MT6315_PMIC_DA_VBUCK3_MINFREQ_DISCHARGE_ADDR        \
	MT6315_BUCK_VBUCK3_DBG5
#define MT6315_PMIC_DA_VBUCK3_MINFREQ_DISCHARGE_MASK        0x1
#define MT6315_PMIC_DA_VBUCK3_MINFREQ_DISCHARGE_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK3_CK_SW_MODE_ADDR          \
	MT6315_BUCK_VBUCK3_DBG5
#define MT6315_PMIC_RG_BUCK_VBUCK3_CK_SW_MODE_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_CK_SW_MODE_SHIFT         4
#define MT6315_PMIC_RG_BUCK_VBUCK3_CK_SW_EN_ADDR            \
	MT6315_BUCK_VBUCK3_DBG5
#define MT6315_PMIC_RG_BUCK_VBUCK3_CK_SW_EN_MASK            0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_CK_SW_EN_SHIFT           5
#define MT6315_PMIC_RG_BUCK_VBUCK3_TRACK_EN_ADDR            \
	MT6315_BUCK_VBUCK3_TRACK0
#define MT6315_PMIC_RG_BUCK_VBUCK3_TRACK_EN_MASK            0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_TRACK_EN_SHIFT           0
#define MT6315_PMIC_RG_BUCK_VBUCK3_TRACK_MODE_ADDR          \
	MT6315_BUCK_VBUCK3_TRACK0
#define MT6315_PMIC_RG_BUCK_VBUCK3_TRACK_MODE_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK3_TRACK_MODE_SHIFT         1
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_DELTA_ADDR         \
	MT6315_BUCK_VBUCK3_TRACK0
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_DELTA_MASK         0xF
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_DELTA_SHIFT        4
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_OFFSET_ADDR        \
	MT6315_BUCK_VBUCK3_TRACK1
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_OFFSET_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_OFFSET_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_LB_ADDR            \
	MT6315_BUCK_VBUCK3_TRACK2
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_LB_MASK            0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_LB_SHIFT           0
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_HB_ADDR            \
	MT6315_BUCK_VBUCK3_TRACK3
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_HB_MASK            0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK3_VOSEL_HB_SHIFT           0
#define MT6315_PMIC_BUCK_VBUCK4_ANA_ID_ADDR                 \
	MT6315_BUCK_VBUCK4_ANA_ID
#define MT6315_PMIC_BUCK_VBUCK4_ANA_ID_MASK                 0xFF
#define MT6315_PMIC_BUCK_VBUCK4_ANA_ID_SHIFT                0
#define MT6315_PMIC_BUCK_VBUCK4_DIG_ID_ADDR                 \
	MT6315_BUCK_VBUCK4_DIG_ID
#define MT6315_PMIC_BUCK_VBUCK4_DIG_ID_MASK                 0xFF
#define MT6315_PMIC_BUCK_VBUCK4_DIG_ID_SHIFT                0
#define MT6315_PMIC_BUCK_VBUCK4_ANA_MINOR_REV_ADDR          \
	MT6315_BUCK_VBUCK4_REV0
#define MT6315_PMIC_BUCK_VBUCK4_ANA_MINOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK4_ANA_MINOR_REV_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK4_ANA_MAJOR_REV_ADDR          \
	MT6315_BUCK_VBUCK4_REV0
#define MT6315_PMIC_BUCK_VBUCK4_ANA_MAJOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK4_ANA_MAJOR_REV_SHIFT         4
#define MT6315_PMIC_BUCK_VBUCK4_DIG_MINOR_REV_ADDR          \
	MT6315_BUCK_VBUCK4_REV1
#define MT6315_PMIC_BUCK_VBUCK4_DIG_MINOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK4_DIG_MINOR_REV_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK4_DIG_MAJOR_REV_ADDR          \
	MT6315_BUCK_VBUCK4_REV1
#define MT6315_PMIC_BUCK_VBUCK4_DIG_MAJOR_REV_MASK          0xF
#define MT6315_PMIC_BUCK_VBUCK4_DIG_MAJOR_REV_SHIFT         4
#define MT6315_PMIC_BUCK_VBUCK4_DSN_CBS_ADDR                \
	MT6315_BUCK_VBUCK4_DBI0
#define MT6315_PMIC_BUCK_VBUCK4_DSN_CBS_MASK                0x3
#define MT6315_PMIC_BUCK_VBUCK4_DSN_CBS_SHIFT               0
#define MT6315_PMIC_BUCK_VBUCK4_DSN_BIX_ADDR                \
	MT6315_BUCK_VBUCK4_DBI0
#define MT6315_PMIC_BUCK_VBUCK4_DSN_BIX_MASK                0x3
#define MT6315_PMIC_BUCK_VBUCK4_DSN_BIX_SHIFT               2
#define MT6315_PMIC_BUCK_VBUCK4_DSN_ESP_ADDR                \
	MT6315_BUCK_VBUCK4_DBI1
#define MT6315_PMIC_BUCK_VBUCK4_DSN_ESP_MASK                0xFF
#define MT6315_PMIC_BUCK_VBUCK4_DSN_ESP_SHIFT               0
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_SSHUB_ADDR          \
	MT6315_BUCK_VBUCK4_DXI
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_SSHUB_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_SSHUB_SHIFT         0
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_TRACKING_ADDR       \
	MT6315_BUCK_VBUCK4_DXI
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_TRACKING_MASK       0x1
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_TRACKING_SHIFT      1
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_PREOC_ADDR          \
	MT6315_BUCK_VBUCK4_DXI
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_PREOC_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_PREOC_SHIFT         2
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_VOTER_ADDR          \
	MT6315_BUCK_VBUCK4_DXI
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_VOTER_MASK          0x1
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_VOTER_SHIFT         3
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_ULTRASONIC_ADDR     \
	MT6315_BUCK_VBUCK4_DXI
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_ULTRASONIC_MASK     0x1
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_ULTRASONIC_SHIFT    4
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_DLC_ADDR            \
	MT6315_BUCK_VBUCK4_DXI
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_DLC_MASK            0x1
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_DLC_SHIFT           5
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_TRAP_ADDR           \
	MT6315_BUCK_VBUCK4_DXI
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_TRAP_MASK           0x1
#define MT6315_PMIC_BUCK_VBUCK4_DSN_FPI_TRAP_SHIFT          6
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_SLEEP_ADDR         \
	MT6315_BUCK_VBUCK4_CON1
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_SLEEP_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_SLEEP_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_SLEEP_LSB_ADDR     \
	MT6315_BUCK_VBUCK4_CON2
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_SLEEP_LSB_MASK     0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_SLEEP_LSB_SHIFT    0
#define MT6315_PMIC_RG_BUCK_VBUCK4_SELR2R_CTRL_ADDR         \
	MT6315_BUCK_VBUCK4_SLP_CON
#define MT6315_PMIC_RG_BUCK_VBUCK4_SELR2R_CTRL_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_SELR2R_CTRL_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK4_DVS_EN_MASK_ADDR         \
	MT6315_BUCK_VBUCK4_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK4_DVS_EN_MASK_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_DVS_EN_MASK_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK4_DVS_UP_MASK_ADDR         \
	MT6315_BUCK_VBUCK4_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK4_DVS_UP_MASK_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_DVS_UP_MASK_SHIFT        1
#define MT6315_PMIC_RG_BUCK_VBUCK4_DVS_DOWN_MASK_ADDR       \
	MT6315_BUCK_VBUCK4_DVS_CON
#define MT6315_PMIC_RG_BUCK_VBUCK4_DVS_DOWN_MASK_MASK       0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_DVS_DOWN_MASK_SHIFT      2
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_RRATE_ADDR         \
	MT6315_BUCK_VBUCK4_CFG0
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_RRATE_MASK         0x7F
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_RRATE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_REN_ADDR           \
	MT6315_BUCK_VBUCK4_CFG0
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_REN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_REN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_FRATE_ADDR         \
	MT6315_BUCK_VBUCK4_CFG1
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_FRATE_MASK         0x7F
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_FRATE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_FEN_ADDR           \
	MT6315_BUCK_VBUCK4_CFG1
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_FEN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_SFCHG_FEN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW0_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK4_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW0_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW0_OP_EN_SHIFT          0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW1_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK4_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW1_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW1_OP_EN_SHIFT          1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW2_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK4_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW2_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW2_OP_EN_SHIFT          2
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW3_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK4_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW3_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW3_OP_EN_SHIFT          3
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW4_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK4_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW4_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW4_OP_EN_SHIFT          4
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW5_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK4_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW5_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW5_OP_EN_SHIFT          5
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW6_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK4_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW6_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW6_OP_EN_SHIFT          6
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW7_OP_EN_ADDR           \
	MT6315_BUCK_VBUCK4_OP_EN_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW7_OP_EN_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW7_OP_EN_SHIFT          7
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_0_SET_ADDR         \
	MT6315_BUCK_VBUCK4_OP_EN_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_0_SET_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_0_SET_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_0_CLR_ADDR         \
	MT6315_BUCK_VBUCK4_OP_EN_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_0_CLR_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_0_CLR_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK4_SW_OP_EN_ADDR            \
	MT6315_BUCK_VBUCK4_OP_EN_1
#define MT6315_PMIC_RG_BUCK_VBUCK4_SW_OP_EN_MASK            0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_SW_OP_EN_SHIFT           0
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_1_SET_ADDR         \
	MT6315_BUCK_VBUCK4_OP_EN_1_SET
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_1_SET_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_1_SET_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_1_CLR_ADDR         \
	MT6315_BUCK_VBUCK4_OP_EN_1_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_1_CLR_MASK         0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_EN_1_CLR_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW0_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK4_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW0_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW0_OP_CFG_SHIFT         0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW1_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK4_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW1_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW1_OP_CFG_SHIFT         1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW2_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK4_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW2_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW2_OP_CFG_SHIFT         2
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW3_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK4_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW3_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW3_OP_CFG_SHIFT         3
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW4_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK4_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW4_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW4_OP_CFG_SHIFT         4
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW5_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK4_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW5_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW5_OP_CFG_SHIFT         5
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW6_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK4_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW6_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW6_OP_CFG_SHIFT         6
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW7_OP_CFG_ADDR          \
	MT6315_BUCK_VBUCK4_OP_CFG_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW7_OP_CFG_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW7_OP_CFG_SHIFT         7
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_CFG_0_SET_ADDR        \
	MT6315_BUCK_VBUCK4_OP_CFG_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_CFG_0_SET_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_CFG_0_SET_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_CFG_0_CLR_ADDR        \
	MT6315_BUCK_VBUCK4_OP_CFG_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_CFG_0_CLR_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_CFG_0_CLR_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW0_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK4_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW0_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW0_OP_MODE_SHIFT        0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW1_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK4_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW1_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW1_OP_MODE_SHIFT        1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW2_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK4_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW2_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW2_OP_MODE_SHIFT        2
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW3_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK4_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW3_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW3_OP_MODE_SHIFT        3
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW4_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK4_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW4_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW4_OP_MODE_SHIFT        4
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW5_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK4_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW5_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW5_OP_MODE_SHIFT        5
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW6_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK4_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW6_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW6_OP_MODE_SHIFT        6
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW7_OP_MODE_ADDR         \
	MT6315_BUCK_VBUCK4_OP_MODE_0
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW7_OP_MODE_MASK         0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_HW7_OP_MODE_SHIFT        7
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_MODE_0_SET_ADDR       \
	MT6315_BUCK_VBUCK4_OP_MODE_0_SET
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_MODE_0_SET_MASK       0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_MODE_0_SET_SHIFT      0
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_MODE_0_CLR_ADDR       \
	MT6315_BUCK_VBUCK4_OP_MODE_0_CLR
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_MODE_0_CLR_MASK       0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_OP_MODE_0_CLR_SHIFT      0
#define MT6315_PMIC_DA_VBUCK4_VOSEL_ADDR                    \
	MT6315_BUCK_VBUCK4_DBG0
#define MT6315_PMIC_DA_VBUCK4_VOSEL_MASK                    0xFF
#define MT6315_PMIC_DA_VBUCK4_VOSEL_SHIFT                   0
#define MT6315_PMIC_DA_VBUCK4_VOSEL_LSB_ADDR                \
	MT6315_BUCK_VBUCK4_DBG1
#define MT6315_PMIC_DA_VBUCK4_VOSEL_LSB_MASK                0x1
#define MT6315_PMIC_DA_VBUCK4_VOSEL_LSB_SHIFT               0
#define MT6315_PMIC_DA_VBUCK4_VOSEL_GRAY_ADDR               \
	MT6315_BUCK_VBUCK4_DBG2
#define MT6315_PMIC_DA_VBUCK4_VOSEL_GRAY_MASK               0xFF
#define MT6315_PMIC_DA_VBUCK4_VOSEL_GRAY_SHIFT              0
#define MT6315_PMIC_DA_VBUCK4_VOSEL_GRAY_LSB_ADDR           \
	MT6315_BUCK_VBUCK4_DBG3
#define MT6315_PMIC_DA_VBUCK4_VOSEL_GRAY_LSB_MASK           0x1
#define MT6315_PMIC_DA_VBUCK4_VOSEL_GRAY_LSB_SHIFT          0
#define MT6315_PMIC_DA_VBUCK4_EN_ADDR                       \
	MT6315_BUCK_VBUCK4_DBG4
#define MT6315_PMIC_DA_VBUCK4_EN_MASK                       0x1
#define MT6315_PMIC_DA_VBUCK4_EN_SHIFT                      0
#define MT6315_PMIC_DA_VBUCK4_STB_ADDR                      \
	MT6315_BUCK_VBUCK4_DBG4
#define MT6315_PMIC_DA_VBUCK4_STB_MASK                      0x1
#define MT6315_PMIC_DA_VBUCK4_STB_SHIFT                     1
#define MT6315_PMIC_DA_VBUCK4_LOOP_SEL_ADDR                 \
	MT6315_BUCK_VBUCK4_DBG4
#define MT6315_PMIC_DA_VBUCK4_LOOP_SEL_MASK                 0x1
#define MT6315_PMIC_DA_VBUCK4_LOOP_SEL_SHIFT                2
#define MT6315_PMIC_DA_VBUCK4_R2R_PDN_ADDR                  \
	MT6315_BUCK_VBUCK4_DBG4
#define MT6315_PMIC_DA_VBUCK4_R2R_PDN_MASK                  0x1
#define MT6315_PMIC_DA_VBUCK4_R2R_PDN_SHIFT                 3
#define MT6315_PMIC_DA_VBUCK4_DVS_EN_ADDR                   \
	MT6315_BUCK_VBUCK4_DBG4
#define MT6315_PMIC_DA_VBUCK4_DVS_EN_MASK                   0x1
#define MT6315_PMIC_DA_VBUCK4_DVS_EN_SHIFT                  4
#define MT6315_PMIC_DA_VBUCK4_DVS_UP_ADDR                   \
	MT6315_BUCK_VBUCK4_DBG4
#define MT6315_PMIC_DA_VBUCK4_DVS_UP_MASK                   0x1
#define MT6315_PMIC_DA_VBUCK4_DVS_UP_SHIFT                  5
#define MT6315_PMIC_DA_VBUCK4_DVS_DOWN_ADDR                 \
	MT6315_BUCK_VBUCK4_DBG4
#define MT6315_PMIC_DA_VBUCK4_DVS_DOWN_MASK                 0x1
#define MT6315_PMIC_DA_VBUCK4_DVS_DOWN_SHIFT                6
#define MT6315_PMIC_DA_VBUCK4_SSH_ADDR                      \
	MT6315_BUCK_VBUCK4_DBG4
#define MT6315_PMIC_DA_VBUCK4_SSH_MASK                      0x1
#define MT6315_PMIC_DA_VBUCK4_SSH_SHIFT                     7
#define MT6315_PMIC_DA_VBUCK4_MINFREQ_DISCHARGE_ADDR        \
	MT6315_BUCK_VBUCK4_DBG5
#define MT6315_PMIC_DA_VBUCK4_MINFREQ_DISCHARGE_MASK        0x1
#define MT6315_PMIC_DA_VBUCK4_MINFREQ_DISCHARGE_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK4_CK_SW_MODE_ADDR          \
	MT6315_BUCK_VBUCK4_DBG5
#define MT6315_PMIC_RG_BUCK_VBUCK4_CK_SW_MODE_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_CK_SW_MODE_SHIFT         4
#define MT6315_PMIC_RG_BUCK_VBUCK4_CK_SW_EN_ADDR            \
	MT6315_BUCK_VBUCK4_DBG5
#define MT6315_PMIC_RG_BUCK_VBUCK4_CK_SW_EN_MASK            0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_CK_SW_EN_SHIFT           5
#define MT6315_PMIC_RG_BUCK_VBUCK4_TRACK_EN_ADDR            \
	MT6315_BUCK_VBUCK4_TRACK0
#define MT6315_PMIC_RG_BUCK_VBUCK4_TRACK_EN_MASK            0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_TRACK_EN_SHIFT           0
#define MT6315_PMIC_RG_BUCK_VBUCK4_TRACK_MODE_ADDR          \
	MT6315_BUCK_VBUCK4_TRACK0
#define MT6315_PMIC_RG_BUCK_VBUCK4_TRACK_MODE_MASK          0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_TRACK_MODE_SHIFT         1
#define MT6315_PMIC_RG_BUCK_VBUCK4_TRACK_CFG_ADDR           \
	MT6315_BUCK_VBUCK4_TRACK0
#define MT6315_PMIC_RG_BUCK_VBUCK4_TRACK_CFG_MASK           0x1
#define MT6315_PMIC_RG_BUCK_VBUCK4_TRACK_CFG_SHIFT          2
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_DELTA_ADDR         \
	MT6315_BUCK_VBUCK4_TRACK0
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_DELTA_MASK         0xF
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_DELTA_SHIFT        4
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_OFFSET_ADDR        \
	MT6315_BUCK_VBUCK4_TRACK1
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_OFFSET_MASK        0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_OFFSET_SHIFT       0
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_LB_ADDR            \
	MT6315_BUCK_VBUCK4_TRACK2
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_LB_MASK            0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_LB_SHIFT           0
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_HB_ADDR            \
	MT6315_BUCK_VBUCK4_TRACK3
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_HB_MASK            0xFF
#define MT6315_PMIC_RG_BUCK_VBUCK4_VOSEL_HB_SHIFT           0
#define MT6315_PMIC_BUCK_ANA0_ANA_ID_ADDR                   \
	MT6315_BUCK_ANA0_ANA_ID
#define MT6315_PMIC_BUCK_ANA0_ANA_ID_MASK                   0xFF
#define MT6315_PMIC_BUCK_ANA0_ANA_ID_SHIFT                  0
#define MT6315_PMIC_BUCK_ANA0_DIG_ID_ADDR                   \
	MT6315_BUCK_ANA0_DIG_ID
#define MT6315_PMIC_BUCK_ANA0_DIG_ID_MASK                   0xFF
#define MT6315_PMIC_BUCK_ANA0_DIG_ID_SHIFT                  0
#define MT6315_PMIC_BUCK_ANA0_ANA_MINOR_REV_ADDR            \
	MT6315_BUCK_ANA0_DSN_REV0
#define MT6315_PMIC_BUCK_ANA0_ANA_MINOR_REV_MASK            0xF
#define MT6315_PMIC_BUCK_ANA0_ANA_MINOR_REV_SHIFT           0
#define MT6315_PMIC_BUCK_ANA0_ANA_MAJOR_REV_ADDR            \
	MT6315_BUCK_ANA0_DSN_REV0
#define MT6315_PMIC_BUCK_ANA0_ANA_MAJOR_REV_MASK            0xF
#define MT6315_PMIC_BUCK_ANA0_ANA_MAJOR_REV_SHIFT           4
#define MT6315_PMIC_BUCK_ANA0_DIG_MINOR_REV_ADDR            \
	MT6315_BUCK_ANA0_DSN_REV1
#define MT6315_PMIC_BUCK_ANA0_DIG_MINOR_REV_MASK            0xF
#define MT6315_PMIC_BUCK_ANA0_DIG_MINOR_REV_SHIFT           0
#define MT6315_PMIC_BUCK_ANA0_DIG_MAJOR_REV_ADDR            \
	MT6315_BUCK_ANA0_DSN_REV1
#define MT6315_PMIC_BUCK_ANA0_DIG_MAJOR_REV_MASK            0xF
#define MT6315_PMIC_BUCK_ANA0_DIG_MAJOR_REV_SHIFT           4
#define MT6315_PMIC_BUCK_ANA0_CBS_ADDR                      \
	MT6315_BUCK_ANA0_DBI0
#define MT6315_PMIC_BUCK_ANA0_CBS_MASK                      0x3
#define MT6315_PMIC_BUCK_ANA0_CBS_SHIFT                     0
#define MT6315_PMIC_BUCK_ANA0_BIX_ADDR                      \
	MT6315_BUCK_ANA0_DBI0
#define MT6315_PMIC_BUCK_ANA0_BIX_MASK                      0x3
#define MT6315_PMIC_BUCK_ANA0_BIX_SHIFT                     2
#define MT6315_PMIC_BUCK_ANA0_ESP_ADDR                      \
	MT6315_BUCK_ANA0_DBI1
#define MT6315_PMIC_BUCK_ANA0_ESP_MASK                      0xFF
#define MT6315_PMIC_BUCK_ANA0_ESP_SHIFT                     0
#define MT6315_PMIC_BUCK_ANA0_FPI_ADDR                      \
	MT6315_BUCK_ANA0_DXI
#define MT6315_PMIC_BUCK_ANA0_FPI_MASK                      0xFF
#define MT6315_PMIC_BUCK_ANA0_FPI_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK1_NDIS_EN_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON0
#define MT6315_PMIC_RG_VBUCK1_NDIS_EN_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK1_NDIS_EN_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK1_SLEEP_TIME_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON0
#define MT6315_PMIC_RG_VBUCK1_SLEEP_TIME_MASK               0x3
#define MT6315_PMIC_RG_VBUCK1_SLEEP_TIME_SHIFT              1
#define MT6315_PMIC_RG_VBUCK1_LOOPSEL_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON0
#define MT6315_PMIC_RG_VBUCK1_LOOPSEL_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK1_LOOPSEL_DIS_SHIFT             3
#define MT6315_PMIC_RG_VBUCK1_OVP_EN_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON0
#define MT6315_PMIC_RG_VBUCK1_OVP_EN_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK1_OVP_EN_SHIFT                  4
#define MT6315_PMIC_RG_VBUCK1_OVP_VREFSEL_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON0
#define MT6315_PMIC_RG_VBUCK1_OVP_VREFSEL_MASK              0x1
#define MT6315_PMIC_RG_VBUCK1_OVP_VREFSEL_SHIFT             5
#define MT6315_PMIC_RG_VBUCK1_TB_DIS_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON0
#define MT6315_PMIC_RG_VBUCK1_TB_DIS_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK1_TB_DIS_SHIFT                  6
#define MT6315_PMIC_RG_VBUCK1_TB_PFM_OFF_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON0
#define MT6315_PMIC_RG_VBUCK1_TB_PFM_OFF_MASK               0x1
#define MT6315_PMIC_RG_VBUCK1_TB_PFM_OFF_SHIFT              7
#define MT6315_PMIC_RG_VBUCK1_TB_VREFSEL_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON1
#define MT6315_PMIC_RG_VBUCK1_TB_VREFSEL_MASK               0x3
#define MT6315_PMIC_RG_VBUCK1_TB_VREFSEL_SHIFT              0
#define MT6315_PMIC_RG_VBUCK1_TON_EXTEND_EN_ADDR            \
	MT6315_BUCK_TOP_4PHASE_ANA_CON1
#define MT6315_PMIC_RG_VBUCK1_TON_EXTEND_EN_MASK            0x1
#define MT6315_PMIC_RG_VBUCK1_TON_EXTEND_EN_SHIFT           2
#define MT6315_PMIC_RG_VBUCK1_VBAT_LOW_DIS_ADDR             \
	MT6315_BUCK_TOP_4PHASE_ANA_CON1
#define MT6315_PMIC_RG_VBUCK1_VBAT_LOW_DIS_MASK             0x1
#define MT6315_PMIC_RG_VBUCK1_VBAT_LOW_DIS_SHIFT            3
#define MT6315_PMIC_RG_VBUCK1_VBAT_HI_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON1
#define MT6315_PMIC_RG_VBUCK1_VBAT_HI_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK1_VBAT_HI_DIS_SHIFT             4
#define MT6315_PMIC_RG_VBUCK1_VOUT_HI_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON1
#define MT6315_PMIC_RG_VBUCK1_VOUT_HI_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK1_VOUT_HI_DIS_SHIFT             5
#define MT6315_PMIC_RG_VBUCK1_FUGON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON1
#define MT6315_PMIC_RG_VBUCK1_FUGON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK1_FUGON_SHIFT                   6
#define MT6315_PMIC_RG_VBUCK1_FLGON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON1
#define MT6315_PMIC_RG_VBUCK1_FLGON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK1_FLGON_SHIFT                   7
#define MT6315_PMIC_RG_VBUCK1_RAMP_AC_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON2
#define MT6315_PMIC_RG_VBUCK1_RAMP_AC_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK1_RAMP_AC_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK1_URT_EN_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON2
#define MT6315_PMIC_RG_VBUCK1_URT_EN_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK1_URT_EN_SHIFT                  2
#define MT6315_PMIC_RG_VBUCK1_RETENTION_EN_ADDR             \
	MT6315_BUCK_TOP_4PHASE_ANA_CON2
#define MT6315_PMIC_RG_VBUCK1_RETENTION_EN_MASK             0x1
#define MT6315_PMIC_RG_VBUCK1_RETENTION_EN_SHIFT            3
#define MT6315_PMIC_RG_VBUCK1_SONIC_EN_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ANA_CON2
#define MT6315_PMIC_RG_VBUCK1_SONIC_EN_MASK                 0x1
#define MT6315_PMIC_RG_VBUCK1_SONIC_EN_SHIFT                4
#define MT6315_PMIC_RG_VBUCK1_GROUNDSEL_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ANA_CON2
#define MT6315_PMIC_RG_VBUCK1_GROUNDSEL_MASK                0x1
#define MT6315_PMIC_RG_VBUCK1_GROUNDSEL_SHIFT               5
#define MT6315_PMIC_RG_VBUCK1_DLC_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON2
#define MT6315_PMIC_RG_VBUCK1_DLC_MASK                      0x3
#define MT6315_PMIC_RG_VBUCK1_DLC_SHIFT                     6
#define MT6315_PMIC_RG_VBUCK1_RCB_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON3
#define MT6315_PMIC_RG_VBUCK1_RCB_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK1_RCB_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK1_UG_SR_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON3
#define MT6315_PMIC_RG_VBUCK1_UG_SR_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK1_UG_SR_SHIFT                   3
#define MT6315_PMIC_RG_VBUCK1_LG_SR_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON3
#define MT6315_PMIC_RG_VBUCK1_LG_SR_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK1_LG_SR_SHIFT                   5
#define MT6315_PMIC_RG_VBUCK1_ECOT_EN_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON3
#define MT6315_PMIC_RG_VBUCK1_ECOT_EN_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK1_ECOT_EN_SHIFT                 7
#define MT6315_PMIC_RG_VBUCK1_OCP_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON4
#define MT6315_PMIC_RG_VBUCK1_OCP_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK1_OCP_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK1_OCN_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON4
#define MT6315_PMIC_RG_VBUCK1_OCN_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK1_OCN_SHIFT                     3
#define MT6315_PMIC_RG_VBUCK1_DUMMY_LOAD_EN_ADDR            \
	MT6315_BUCK_TOP_4PHASE_ANA_CON4
#define MT6315_PMIC_RG_VBUCK1_DUMMY_LOAD_EN_MASK            0x1
#define MT6315_PMIC_RG_VBUCK1_DUMMY_LOAD_EN_SHIFT           6
#define MT6315_PMIC_RG_VBUCK1_RON_TM_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON4
#define MT6315_PMIC_RG_VBUCK1_RON_TM_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK1_RON_TM_SHIFT                  7
#define MT6315_PMIC_RG_VBUCK1_DIGMON_SEL_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON5
#define MT6315_PMIC_RG_VBUCK1_DIGMON_SEL_MASK               0x3F
#define MT6315_PMIC_RG_VBUCK1_DIGMON_SEL_SHIFT              0
#define MT6315_PMIC_RGS_VBUCK1_OC_STATUS_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON6
#define MT6315_PMIC_RGS_VBUCK1_OC_STATUS_MASK               0x1
#define MT6315_PMIC_RGS_VBUCK1_OC_STATUS_SHIFT              0
#define MT6315_PMIC_RGS_VBUCK1_DIG_MON_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ANA_CON6
#define MT6315_PMIC_RGS_VBUCK1_DIG_MON_MASK                 0x1
#define MT6315_PMIC_RGS_VBUCK1_DIG_MON_SHIFT                1
#define MT6315_PMIC_RG_VBUCK1_UG_ONSR_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON6
#define MT6315_PMIC_RG_VBUCK1_UG_ONSR_MASK                  0x3
#define MT6315_PMIC_RG_VBUCK1_UG_ONSR_SHIFT                 2
#define MT6315_PMIC_RG_VBUCK1_LXRON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON6
#define MT6315_PMIC_RG_VBUCK1_LXRON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK1_LXRON_SHIFT                   4
#define MT6315_PMIC_RG_VBUCK1_RSVH_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON7
#define MT6315_PMIC_RG_VBUCK1_RSVH_MASK                     0xFF
#define MT6315_PMIC_RG_VBUCK1_RSVH_SHIFT                    0
#define MT6315_PMIC_RG_VBUCK1_RSVL_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON8
#define MT6315_PMIC_RG_VBUCK1_RSVL_MASK                     0xFF
#define MT6315_PMIC_RG_VBUCK1_RSVL_SHIFT                    0
#define MT6315_PMIC_RG_VBUCK1_TM_ADDR                       \
	MT6315_BUCK_TOP_4PHASE_ANA_CON9
#define MT6315_PMIC_RG_VBUCK1_TM_MASK                       0xF
#define MT6315_PMIC_RG_VBUCK1_TM_SHIFT                      0
#define MT6315_PMIC_RG_VBUCK1_TM_KEY_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON9
#define MT6315_PMIC_RG_VBUCK1_TM_KEY_MASK                   0x3
#define MT6315_PMIC_RG_VBUCK1_TM_KEY_SHIFT                  4
#define MT6315_PMIC_RG_VBUCK2_NDIS_EN_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON10
#define MT6315_PMIC_RG_VBUCK2_NDIS_EN_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK2_NDIS_EN_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK2_SLEEP_TIME_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON10
#define MT6315_PMIC_RG_VBUCK2_SLEEP_TIME_MASK               0x3
#define MT6315_PMIC_RG_VBUCK2_SLEEP_TIME_SHIFT              1
#define MT6315_PMIC_RG_VBUCK2_LOOPSEL_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON10
#define MT6315_PMIC_RG_VBUCK2_LOOPSEL_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK2_LOOPSEL_DIS_SHIFT             3
#define MT6315_PMIC_RG_VBUCK2_OVP_EN_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON10
#define MT6315_PMIC_RG_VBUCK2_OVP_EN_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK2_OVP_EN_SHIFT                  4
#define MT6315_PMIC_RG_VBUCK2_OVP_VREFSEL_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON10
#define MT6315_PMIC_RG_VBUCK2_OVP_VREFSEL_MASK              0x1
#define MT6315_PMIC_RG_VBUCK2_OVP_VREFSEL_SHIFT             5
#define MT6315_PMIC_RG_VBUCK2_TB_DIS_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON10
#define MT6315_PMIC_RG_VBUCK2_TB_DIS_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK2_TB_DIS_SHIFT                  6
#define MT6315_PMIC_RG_VBUCK2_TB_PFM_OFF_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON10
#define MT6315_PMIC_RG_VBUCK2_TB_PFM_OFF_MASK               0x1
#define MT6315_PMIC_RG_VBUCK2_TB_PFM_OFF_SHIFT              7
#define MT6315_PMIC_RG_VBUCK2_TB_VREFSEL_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON11
#define MT6315_PMIC_RG_VBUCK2_TB_VREFSEL_MASK               0x3
#define MT6315_PMIC_RG_VBUCK2_TB_VREFSEL_SHIFT              0
#define MT6315_PMIC_RG_VBUCK2_TON_EXTEND_EN_ADDR            \
	MT6315_BUCK_TOP_4PHASE_ANA_CON11
#define MT6315_PMIC_RG_VBUCK2_TON_EXTEND_EN_MASK            0x1
#define MT6315_PMIC_RG_VBUCK2_TON_EXTEND_EN_SHIFT           2
#define MT6315_PMIC_RG_VBUCK2_VBAT_LOW_DIS_ADDR             \
	MT6315_BUCK_TOP_4PHASE_ANA_CON11
#define MT6315_PMIC_RG_VBUCK2_VBAT_LOW_DIS_MASK             0x1
#define MT6315_PMIC_RG_VBUCK2_VBAT_LOW_DIS_SHIFT            3
#define MT6315_PMIC_RG_VBUCK2_VBAT_HI_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON11
#define MT6315_PMIC_RG_VBUCK2_VBAT_HI_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK2_VBAT_HI_DIS_SHIFT             4
#define MT6315_PMIC_RG_VBUCK2_VOUT_HI_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON11
#define MT6315_PMIC_RG_VBUCK2_VOUT_HI_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK2_VOUT_HI_DIS_SHIFT             5
#define MT6315_PMIC_RG_VBUCK2_FUGON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON11
#define MT6315_PMIC_RG_VBUCK2_FUGON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK2_FUGON_SHIFT                   6
#define MT6315_PMIC_RG_VBUCK2_FLGON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON11
#define MT6315_PMIC_RG_VBUCK2_FLGON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK2_FLGON_SHIFT                   7
#define MT6315_PMIC_RG_VBUCK2_RAMP_AC_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON12
#define MT6315_PMIC_RG_VBUCK2_RAMP_AC_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK2_RAMP_AC_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK2_URT_EN_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON12
#define MT6315_PMIC_RG_VBUCK2_URT_EN_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK2_URT_EN_SHIFT                  2
#define MT6315_PMIC_RG_VBUCK2_RETENTION_EN_ADDR             \
	MT6315_BUCK_TOP_4PHASE_ANA_CON12
#define MT6315_PMIC_RG_VBUCK2_RETENTION_EN_MASK             0x1
#define MT6315_PMIC_RG_VBUCK2_RETENTION_EN_SHIFT            3
#define MT6315_PMIC_RG_VBUCK2_SONIC_EN_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ANA_CON12
#define MT6315_PMIC_RG_VBUCK2_SONIC_EN_MASK                 0x1
#define MT6315_PMIC_RG_VBUCK2_SONIC_EN_SHIFT                4
#define MT6315_PMIC_RG_VBUCK2_GROUNDSEL_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ANA_CON12
#define MT6315_PMIC_RG_VBUCK2_GROUNDSEL_MASK                0x1
#define MT6315_PMIC_RG_VBUCK2_GROUNDSEL_SHIFT               5
#define MT6315_PMIC_RG_VBUCK2_DLC_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON12
#define MT6315_PMIC_RG_VBUCK2_DLC_MASK                      0x3
#define MT6315_PMIC_RG_VBUCK2_DLC_SHIFT                     6
#define MT6315_PMIC_RG_VBUCK2_RCB_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON13
#define MT6315_PMIC_RG_VBUCK2_RCB_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK2_RCB_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK2_UG_SR_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON13
#define MT6315_PMIC_RG_VBUCK2_UG_SR_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK2_UG_SR_SHIFT                   3
#define MT6315_PMIC_RG_VBUCK2_LG_SR_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON13
#define MT6315_PMIC_RG_VBUCK2_LG_SR_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK2_LG_SR_SHIFT                   5
#define MT6315_PMIC_RG_VBUCK2_ECOT_EN_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON13
#define MT6315_PMIC_RG_VBUCK2_ECOT_EN_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK2_ECOT_EN_SHIFT                 7
#define MT6315_PMIC_RG_VBUCK2_OCP_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON14
#define MT6315_PMIC_RG_VBUCK2_OCP_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK2_OCP_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK2_OCN_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON14
#define MT6315_PMIC_RG_VBUCK2_OCN_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK2_OCN_SHIFT                     3
#define MT6315_PMIC_RG_VBUCK2_DUMMY_LOAD_EN_ADDR            \
	MT6315_BUCK_TOP_4PHASE_ANA_CON14
#define MT6315_PMIC_RG_VBUCK2_DUMMY_LOAD_EN_MASK            0x1
#define MT6315_PMIC_RG_VBUCK2_DUMMY_LOAD_EN_SHIFT           6
#define MT6315_PMIC_RG_VBUCK2_RON_TM_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON14
#define MT6315_PMIC_RG_VBUCK2_RON_TM_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK2_RON_TM_SHIFT                  7
#define MT6315_PMIC_RG_VBUCK2_DIGMON_SEL_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON15
#define MT6315_PMIC_RG_VBUCK2_DIGMON_SEL_MASK               0x3F
#define MT6315_PMIC_RG_VBUCK2_DIGMON_SEL_SHIFT              0
#define MT6315_PMIC_RGS_VBUCK2_OC_STATUS_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON16
#define MT6315_PMIC_RGS_VBUCK2_OC_STATUS_MASK               0x1
#define MT6315_PMIC_RGS_VBUCK2_OC_STATUS_SHIFT              0
#define MT6315_PMIC_RGS_VBUCK2_DIG_MON_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ANA_CON16
#define MT6315_PMIC_RGS_VBUCK2_DIG_MON_MASK                 0x1
#define MT6315_PMIC_RGS_VBUCK2_DIG_MON_SHIFT                1
#define MT6315_PMIC_RG_VBUCK2_UG_ONSR_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON16
#define MT6315_PMIC_RG_VBUCK2_UG_ONSR_MASK                  0x3
#define MT6315_PMIC_RG_VBUCK2_UG_ONSR_SHIFT                 2
#define MT6315_PMIC_RG_VBUCK2_LXRON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON16
#define MT6315_PMIC_RG_VBUCK2_LXRON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK2_LXRON_SHIFT                   4
#define MT6315_PMIC_RG_VBUCK2_RSVH_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON17
#define MT6315_PMIC_RG_VBUCK2_RSVH_MASK                     0xFF
#define MT6315_PMIC_RG_VBUCK2_RSVH_SHIFT                    0
#define MT6315_PMIC_RG_VBUCK2_RSVL_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON18
#define MT6315_PMIC_RG_VBUCK2_RSVL_MASK                     0xFF
#define MT6315_PMIC_RG_VBUCK2_RSVL_SHIFT                    0
#define MT6315_PMIC_RG_VBUCK2_TM_ADDR                       \
	MT6315_BUCK_TOP_4PHASE_ANA_CON19
#define MT6315_PMIC_RG_VBUCK2_TM_MASK                       0xF
#define MT6315_PMIC_RG_VBUCK2_TM_SHIFT                      0
#define MT6315_PMIC_RG_VBUCK2_TM_KEY_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON19
#define MT6315_PMIC_RG_VBUCK2_TM_KEY_MASK                   0x3
#define MT6315_PMIC_RG_VBUCK2_TM_KEY_SHIFT                  4
#define MT6315_PMIC_RG_VBUCK3_NDIS_EN_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON20
#define MT6315_PMIC_RG_VBUCK3_NDIS_EN_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK3_NDIS_EN_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK3_SLEEP_TIME_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON20
#define MT6315_PMIC_RG_VBUCK3_SLEEP_TIME_MASK               0x3
#define MT6315_PMIC_RG_VBUCK3_SLEEP_TIME_SHIFT              1
#define MT6315_PMIC_RG_VBUCK3_LOOPSEL_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON20
#define MT6315_PMIC_RG_VBUCK3_LOOPSEL_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK3_LOOPSEL_DIS_SHIFT             3
#define MT6315_PMIC_RG_VBUCK3_OVP_EN_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON20
#define MT6315_PMIC_RG_VBUCK3_OVP_EN_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK3_OVP_EN_SHIFT                  4
#define MT6315_PMIC_RG_VBUCK3_OVP_VREFSEL_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON20
#define MT6315_PMIC_RG_VBUCK3_OVP_VREFSEL_MASK              0x1
#define MT6315_PMIC_RG_VBUCK3_OVP_VREFSEL_SHIFT             5
#define MT6315_PMIC_RG_VBUCK3_TB_DIS_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON20
#define MT6315_PMIC_RG_VBUCK3_TB_DIS_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK3_TB_DIS_SHIFT                  6
#define MT6315_PMIC_RG_VBUCK3_TB_PFM_OFF_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON20
#define MT6315_PMIC_RG_VBUCK3_TB_PFM_OFF_MASK               0x1
#define MT6315_PMIC_RG_VBUCK3_TB_PFM_OFF_SHIFT              7
#define MT6315_PMIC_RG_VBUCK3_TB_VREFSEL_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON21
#define MT6315_PMIC_RG_VBUCK3_TB_VREFSEL_MASK               0x3
#define MT6315_PMIC_RG_VBUCK3_TB_VREFSEL_SHIFT              0
#define MT6315_PMIC_RG_VBUCK3_TON_EXTEND_EN_ADDR            \
	MT6315_BUCK_TOP_4PHASE_ANA_CON21
#define MT6315_PMIC_RG_VBUCK3_TON_EXTEND_EN_MASK            0x1
#define MT6315_PMIC_RG_VBUCK3_TON_EXTEND_EN_SHIFT           2
#define MT6315_PMIC_RG_VBUCK3_VBAT_LOW_DIS_ADDR             \
	MT6315_BUCK_TOP_4PHASE_ANA_CON21
#define MT6315_PMIC_RG_VBUCK3_VBAT_LOW_DIS_MASK             0x1
#define MT6315_PMIC_RG_VBUCK3_VBAT_LOW_DIS_SHIFT            3
#define MT6315_PMIC_RG_VBUCK3_VBAT_HI_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON21
#define MT6315_PMIC_RG_VBUCK3_VBAT_HI_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK3_VBAT_HI_DIS_SHIFT             4
#define MT6315_PMIC_RG_VBUCK3_VOUT_HI_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON21
#define MT6315_PMIC_RG_VBUCK3_VOUT_HI_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK3_VOUT_HI_DIS_SHIFT             5
#define MT6315_PMIC_RG_VBUCK3_FUGON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON21
#define MT6315_PMIC_RG_VBUCK3_FUGON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK3_FUGON_SHIFT                   6
#define MT6315_PMIC_RG_VBUCK3_FLGON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON21
#define MT6315_PMIC_RG_VBUCK3_FLGON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK3_FLGON_SHIFT                   7
#define MT6315_PMIC_RG_VBUCK3_RAMP_AC_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON22
#define MT6315_PMIC_RG_VBUCK3_RAMP_AC_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK3_RAMP_AC_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK3_URT_EN_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON22
#define MT6315_PMIC_RG_VBUCK3_URT_EN_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK3_URT_EN_SHIFT                  2
#define MT6315_PMIC_RG_VBUCK3_RETENTION_EN_ADDR             \
	MT6315_BUCK_TOP_4PHASE_ANA_CON22
#define MT6315_PMIC_RG_VBUCK3_RETENTION_EN_MASK             0x1
#define MT6315_PMIC_RG_VBUCK3_RETENTION_EN_SHIFT            3
#define MT6315_PMIC_RG_VBUCK3_SONIC_EN_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ANA_CON22
#define MT6315_PMIC_RG_VBUCK3_SONIC_EN_MASK                 0x1
#define MT6315_PMIC_RG_VBUCK3_SONIC_EN_SHIFT                4
#define MT6315_PMIC_RG_VBUCK3_GROUNDSEL_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ANA_CON22
#define MT6315_PMIC_RG_VBUCK3_GROUNDSEL_MASK                0x1
#define MT6315_PMIC_RG_VBUCK3_GROUNDSEL_SHIFT               5
#define MT6315_PMIC_RG_VBUCK3_DLC_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON22
#define MT6315_PMIC_RG_VBUCK3_DLC_MASK                      0x3
#define MT6315_PMIC_RG_VBUCK3_DLC_SHIFT                     6
#define MT6315_PMIC_RG_VBUCK3_RCB_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON23
#define MT6315_PMIC_RG_VBUCK3_RCB_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK3_RCB_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK3_UG_SR_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON23
#define MT6315_PMIC_RG_VBUCK3_UG_SR_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK3_UG_SR_SHIFT                   3
#define MT6315_PMIC_RG_VBUCK3_LG_SR_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON23
#define MT6315_PMIC_RG_VBUCK3_LG_SR_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK3_LG_SR_SHIFT                   5
#define MT6315_PMIC_RG_VBUCK3_ECOT_EN_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON23
#define MT6315_PMIC_RG_VBUCK3_ECOT_EN_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK3_ECOT_EN_SHIFT                 7
#define MT6315_PMIC_RG_VBUCK3_OCP_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON24
#define MT6315_PMIC_RG_VBUCK3_OCP_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK3_OCP_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK3_OCN_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON24
#define MT6315_PMIC_RG_VBUCK3_OCN_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK3_OCN_SHIFT                     3
#define MT6315_PMIC_RG_VBUCK3_DUMMY_LOAD_EN_ADDR            \
	MT6315_BUCK_TOP_4PHASE_ANA_CON24
#define MT6315_PMIC_RG_VBUCK3_DUMMY_LOAD_EN_MASK            0x1
#define MT6315_PMIC_RG_VBUCK3_DUMMY_LOAD_EN_SHIFT           6
#define MT6315_PMIC_RG_VBUCK3_RON_TM_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON24
#define MT6315_PMIC_RG_VBUCK3_RON_TM_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK3_RON_TM_SHIFT                  7
#define MT6315_PMIC_RG_VBUCK3_DIGMON_SEL_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON25
#define MT6315_PMIC_RG_VBUCK3_DIGMON_SEL_MASK               0x3F
#define MT6315_PMIC_RG_VBUCK3_DIGMON_SEL_SHIFT              0
#define MT6315_PMIC_RGS_VBUCK3_OC_STATUS_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON26
#define MT6315_PMIC_RGS_VBUCK3_OC_STATUS_MASK               0x1
#define MT6315_PMIC_RGS_VBUCK3_OC_STATUS_SHIFT              0
#define MT6315_PMIC_RGS_VBUCK3_DIG_MON_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ANA_CON26
#define MT6315_PMIC_RGS_VBUCK3_DIG_MON_MASK                 0x1
#define MT6315_PMIC_RGS_VBUCK3_DIG_MON_SHIFT                1
#define MT6315_PMIC_RG_VBUCK3_UG_ONSR_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON26
#define MT6315_PMIC_RG_VBUCK3_UG_ONSR_MASK                  0x3
#define MT6315_PMIC_RG_VBUCK3_UG_ONSR_SHIFT                 2
#define MT6315_PMIC_RG_VBUCK3_LXRON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON26
#define MT6315_PMIC_RG_VBUCK3_LXRON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK3_LXRON_SHIFT                   4
#define MT6315_PMIC_RG_VBUCK3_RSVH_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON27
#define MT6315_PMIC_RG_VBUCK3_RSVH_MASK                     0xFF
#define MT6315_PMIC_RG_VBUCK3_RSVH_SHIFT                    0
#define MT6315_PMIC_RG_VBUCK3_RSVL_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON28
#define MT6315_PMIC_RG_VBUCK3_RSVL_MASK                     0xFF
#define MT6315_PMIC_RG_VBUCK3_RSVL_SHIFT                    0
#define MT6315_PMIC_RG_VBUCK3_TM_ADDR                       \
	MT6315_BUCK_TOP_4PHASE_ANA_CON29
#define MT6315_PMIC_RG_VBUCK3_TM_MASK                       0xF
#define MT6315_PMIC_RG_VBUCK3_TM_SHIFT                      0
#define MT6315_PMIC_RG_VBUCK3_TM_KEY_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON29
#define MT6315_PMIC_RG_VBUCK3_TM_KEY_MASK                   0x3
#define MT6315_PMIC_RG_VBUCK3_TM_KEY_SHIFT                  4
#define MT6315_PMIC_RG_VBUCK4_NDIS_EN_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON30
#define MT6315_PMIC_RG_VBUCK4_NDIS_EN_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK4_NDIS_EN_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK4_SLEEP_TIME_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON30
#define MT6315_PMIC_RG_VBUCK4_SLEEP_TIME_MASK               0x3
#define MT6315_PMIC_RG_VBUCK4_SLEEP_TIME_SHIFT              1
#define MT6315_PMIC_RG_VBUCK4_LOOPSEL_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON30
#define MT6315_PMIC_RG_VBUCK4_LOOPSEL_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK4_LOOPSEL_DIS_SHIFT             3
#define MT6315_PMIC_RG_VBUCK4_OVP_EN_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON30
#define MT6315_PMIC_RG_VBUCK4_OVP_EN_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK4_OVP_EN_SHIFT                  4
#define MT6315_PMIC_RG_VBUCK4_OVP_VREFSEL_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON30
#define MT6315_PMIC_RG_VBUCK4_OVP_VREFSEL_MASK              0x1
#define MT6315_PMIC_RG_VBUCK4_OVP_VREFSEL_SHIFT             5
#define MT6315_PMIC_RG_VBUCK4_TB_DIS_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON30
#define MT6315_PMIC_RG_VBUCK4_TB_DIS_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK4_TB_DIS_SHIFT                  6
#define MT6315_PMIC_RG_VBUCK4_TB_PFM_OFF_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON30
#define MT6315_PMIC_RG_VBUCK4_TB_PFM_OFF_MASK               0x1
#define MT6315_PMIC_RG_VBUCK4_TB_PFM_OFF_SHIFT              7
#define MT6315_PMIC_RG_VBUCK4_TB_VREFSEL_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON31
#define MT6315_PMIC_RG_VBUCK4_TB_VREFSEL_MASK               0x3
#define MT6315_PMIC_RG_VBUCK4_TB_VREFSEL_SHIFT              0
#define MT6315_PMIC_RG_VBUCK4_TON_EXTEND_EN_ADDR            \
	MT6315_BUCK_TOP_4PHASE_ANA_CON31
#define MT6315_PMIC_RG_VBUCK4_TON_EXTEND_EN_MASK            0x1
#define MT6315_PMIC_RG_VBUCK4_TON_EXTEND_EN_SHIFT           2
#define MT6315_PMIC_RG_VBUCK4_VBAT_LOW_DIS_ADDR             \
	MT6315_BUCK_TOP_4PHASE_ANA_CON31
#define MT6315_PMIC_RG_VBUCK4_VBAT_LOW_DIS_MASK             0x1
#define MT6315_PMIC_RG_VBUCK4_VBAT_LOW_DIS_SHIFT            3
#define MT6315_PMIC_RG_VBUCK4_VBAT_HI_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON31
#define MT6315_PMIC_RG_VBUCK4_VBAT_HI_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK4_VBAT_HI_DIS_SHIFT             4
#define MT6315_PMIC_RG_VBUCK4_VOUT_HI_DIS_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ANA_CON31
#define MT6315_PMIC_RG_VBUCK4_VOUT_HI_DIS_MASK              0x1
#define MT6315_PMIC_RG_VBUCK4_VOUT_HI_DIS_SHIFT             5
#define MT6315_PMIC_RG_VBUCK4_FUGON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON31
#define MT6315_PMIC_RG_VBUCK4_FUGON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK4_FUGON_SHIFT                   6
#define MT6315_PMIC_RG_VBUCK4_FLGON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON31
#define MT6315_PMIC_RG_VBUCK4_FLGON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK4_FLGON_SHIFT                   7
#define MT6315_PMIC_RG_VBUCK4_RAMP_AC_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON32
#define MT6315_PMIC_RG_VBUCK4_RAMP_AC_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK4_RAMP_AC_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK4_URT_EN_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON32
#define MT6315_PMIC_RG_VBUCK4_URT_EN_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK4_URT_EN_SHIFT                  2
#define MT6315_PMIC_RG_VBUCK4_RETENTION_EN_ADDR             \
	MT6315_BUCK_TOP_4PHASE_ANA_CON32
#define MT6315_PMIC_RG_VBUCK4_RETENTION_EN_MASK             0x1
#define MT6315_PMIC_RG_VBUCK4_RETENTION_EN_SHIFT            3
#define MT6315_PMIC_RG_VBUCK4_SONIC_EN_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ANA_CON32
#define MT6315_PMIC_RG_VBUCK4_SONIC_EN_MASK                 0x1
#define MT6315_PMIC_RG_VBUCK4_SONIC_EN_SHIFT                4
#define MT6315_PMIC_RG_VBUCK4_GROUNDSEL_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ANA_CON32
#define MT6315_PMIC_RG_VBUCK4_GROUNDSEL_MASK                0x1
#define MT6315_PMIC_RG_VBUCK4_GROUNDSEL_SHIFT               5
#define MT6315_PMIC_RG_VBUCK4_DLC_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON32
#define MT6315_PMIC_RG_VBUCK4_DLC_MASK                      0x3
#define MT6315_PMIC_RG_VBUCK4_DLC_SHIFT                     6
#define MT6315_PMIC_RG_VBUCK4_RCB_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON33
#define MT6315_PMIC_RG_VBUCK4_RCB_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK4_RCB_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK4_UG_SR_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON33
#define MT6315_PMIC_RG_VBUCK4_UG_SR_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK4_UG_SR_SHIFT                   3
#define MT6315_PMIC_RG_VBUCK4_LG_SR_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON33
#define MT6315_PMIC_RG_VBUCK4_LG_SR_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK4_LG_SR_SHIFT                   5
#define MT6315_PMIC_RG_VBUCK4_ECOT_EN_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON33
#define MT6315_PMIC_RG_VBUCK4_ECOT_EN_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK4_ECOT_EN_SHIFT                 7
#define MT6315_PMIC_RG_VBUCK4_OCP_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON34
#define MT6315_PMIC_RG_VBUCK4_OCP_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK4_OCP_SHIFT                     0
#define MT6315_PMIC_RG_VBUCK4_OCN_ADDR                      \
	MT6315_BUCK_TOP_4PHASE_ANA_CON34
#define MT6315_PMIC_RG_VBUCK4_OCN_MASK                      0x7
#define MT6315_PMIC_RG_VBUCK4_OCN_SHIFT                     3
#define MT6315_PMIC_RG_VBUCK4_DUMMY_LOAD_EN_ADDR            \
	MT6315_BUCK_TOP_4PHASE_ANA_CON34
#define MT6315_PMIC_RG_VBUCK4_DUMMY_LOAD_EN_MASK            0x1
#define MT6315_PMIC_RG_VBUCK4_DUMMY_LOAD_EN_SHIFT           6
#define MT6315_PMIC_RG_VBUCK4_RON_TM_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON34
#define MT6315_PMIC_RG_VBUCK4_RON_TM_MASK                   0x1
#define MT6315_PMIC_RG_VBUCK4_RON_TM_SHIFT                  7
#define MT6315_PMIC_RG_VBUCK4_DIGMON_SEL_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON35
#define MT6315_PMIC_RG_VBUCK4_DIGMON_SEL_MASK               0x3F
#define MT6315_PMIC_RG_VBUCK4_DIGMON_SEL_SHIFT              0
#define MT6315_PMIC_RGS_VBUCK4_OC_STATUS_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON36
#define MT6315_PMIC_RGS_VBUCK4_OC_STATUS_MASK               0x1
#define MT6315_PMIC_RGS_VBUCK4_OC_STATUS_SHIFT              0
#define MT6315_PMIC_RGS_VBUCK4_DIG_MON_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ANA_CON36
#define MT6315_PMIC_RGS_VBUCK4_DIG_MON_MASK                 0x1
#define MT6315_PMIC_RGS_VBUCK4_DIG_MON_SHIFT                1
#define MT6315_PMIC_RG_VBUCK4_UG_ONSR_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON36
#define MT6315_PMIC_RG_VBUCK4_UG_ONSR_MASK                  0x3
#define MT6315_PMIC_RG_VBUCK4_UG_ONSR_SHIFT                 2
#define MT6315_PMIC_RG_VBUCK4_LXRON_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ANA_CON36
#define MT6315_PMIC_RG_VBUCK4_LXRON_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK4_LXRON_SHIFT                   4
#define MT6315_PMIC_RG_VBUCK4_RSVH_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON37
#define MT6315_PMIC_RG_VBUCK4_RSVH_MASK                     0xFF
#define MT6315_PMIC_RG_VBUCK4_RSVH_SHIFT                    0
#define MT6315_PMIC_RG_VBUCK4_RSVL_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON38
#define MT6315_PMIC_RG_VBUCK4_RSVL_MASK                     0xFF
#define MT6315_PMIC_RG_VBUCK4_RSVL_SHIFT                    0
#define MT6315_PMIC_RG_VBUCK4_TM_ADDR                       \
	MT6315_BUCK_TOP_4PHASE_ANA_CON39
#define MT6315_PMIC_RG_VBUCK4_TM_MASK                       0xF
#define MT6315_PMIC_RG_VBUCK4_TM_SHIFT                      0
#define MT6315_PMIC_RG_VBUCK4_TM_KEY_ADDR                   \
	MT6315_BUCK_TOP_4PHASE_ANA_CON39
#define MT6315_PMIC_RG_VBUCK4_TM_KEY_MASK                   0x3
#define MT6315_PMIC_RG_VBUCK4_TM_KEY_SHIFT                  4
#define MT6315_PMIC_RG_VBUCK1234_TMDL_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ANA_CON40
#define MT6315_PMIC_RG_VBUCK1234_TMDL_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK1234_TMDL_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK1234_SR_VBAT_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON40
#define MT6315_PMIC_RG_VBUCK1234_SR_VBAT_MASK               0x1
#define MT6315_PMIC_RG_VBUCK1234_SR_VBAT_SHIFT              1
#define MT6315_PMIC_RG_4PH_CONFIG_LAT_RSVH_ADDR             \
	MT6315_BUCK_TOP_4PHASE_ANA_CON40
#define MT6315_PMIC_RG_4PH_CONFIG_LAT_RSVH_MASK             0x1
#define MT6315_PMIC_RG_4PH_CONFIG_LAT_RSVH_SHIFT            2
#define MT6315_PMIC_RG_4PH_RECONFIG_RSVH_ADDR               \
	MT6315_BUCK_TOP_4PHASE_ANA_CON40
#define MT6315_PMIC_RG_4PH_RECONFIG_RSVH_MASK               0x1
#define MT6315_PMIC_RG_4PH_RECONFIG_RSVH_SHIFT              3
#define MT6315_PMIC_RG_4PH_RECONFIG_EN_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ANA_CON40
#define MT6315_PMIC_RG_4PH_RECONFIG_EN_MASK                 0x1
#define MT6315_PMIC_RG_4PH_RECONFIG_EN_SHIFT                4
#define MT6315_PMIC_RGS_4PH1_VBUCK1_DIGCFG_EN_ADDR          \
	MT6315_BUCK_TOP_4PHASE_ANA_CON40
#define MT6315_PMIC_RGS_4PH1_VBUCK1_DIGCFG_EN_MASK          0x1
#define MT6315_PMIC_RGS_4PH1_VBUCK1_DIGCFG_EN_SHIFT         5
#define MT6315_PMIC_RGS_4PH2_VBUCK2_DIGCFG_EN_ADDR          \
	MT6315_BUCK_TOP_4PHASE_ANA_CON40
#define MT6315_PMIC_RGS_4PH2_VBUCK2_DIGCFG_EN_MASK          0x1
#define MT6315_PMIC_RGS_4PH2_VBUCK2_DIGCFG_EN_SHIFT         6
#define MT6315_PMIC_RGS_4PH3_VBUCK3_DIGCFG_EN_ADDR          \
	MT6315_BUCK_TOP_4PHASE_ANA_CON40
#define MT6315_PMIC_RGS_4PH3_VBUCK3_DIGCFG_EN_MASK          0x1
#define MT6315_PMIC_RGS_4PH3_VBUCK3_DIGCFG_EN_SHIFT         7
#define MT6315_PMIC_RGS_4PH4_VBUCK4_DIGCFG_EN_ADDR          \
	MT6315_BUCK_TOP_4PHASE_ANA_CON41
#define MT6315_PMIC_RGS_4PH4_VBUCK4_DIGCFG_EN_MASK          0x1
#define MT6315_PMIC_RGS_4PH4_VBUCK4_DIGCFG_EN_SHIFT         0
#define MT6315_PMIC_RG_VBUCK1_FCCM_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON42
#define MT6315_PMIC_RG_VBUCK1_FCCM_MASK                     0x1
#define MT6315_PMIC_RG_VBUCK1_FCCM_SHIFT                    0
#define MT6315_PMIC_RG_VBUCK2_FCCM_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON42
#define MT6315_PMIC_RG_VBUCK2_FCCM_MASK                     0x1
#define MT6315_PMIC_RG_VBUCK2_FCCM_SHIFT                    1
#define MT6315_PMIC_RG_VBUCK3_FCCM_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON42
#define MT6315_PMIC_RG_VBUCK3_FCCM_MASK                     0x1
#define MT6315_PMIC_RG_VBUCK3_FCCM_SHIFT                    2
#define MT6315_PMIC_RG_VBUCK4_FCCM_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ANA_CON42
#define MT6315_PMIC_RG_VBUCK4_FCCM_MASK                     0x1
#define MT6315_PMIC_RG_VBUCK4_FCCM_SHIFT                    3
#define MT6315_PMIC_BUCK_ANA0_ELR_LEN_ADDR                  \
	MT6315_BUCK_ANA0_ELR_NUM
#define MT6315_PMIC_BUCK_ANA0_ELR_LEN_MASK                  0xFF
#define MT6315_PMIC_BUCK_ANA0_ELR_LEN_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK1_ZC_TRIM_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ELR_0
#define MT6315_PMIC_RG_VBUCK1_ZC_TRIM_MASK                  0x3F
#define MT6315_PMIC_RG_VBUCK1_ZC_TRIM_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK1_CCOMP_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_0
#define MT6315_PMIC_RG_VBUCK1_CCOMP_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK1_CCOMP_SHIFT                   6
#define MT6315_PMIC_RG_VBUCK1_NLIM_TRIM_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_1
#define MT6315_PMIC_RG_VBUCK1_NLIM_TRIM_MASK                0xF
#define MT6315_PMIC_RG_VBUCK1_NLIM_TRIM_SHIFT               0
#define MT6315_PMIC_RG_VBUCK1_RCOMP_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_1
#define MT6315_PMIC_RG_VBUCK1_RCOMP_MASK                    0xF
#define MT6315_PMIC_RG_VBUCK1_RCOMP_SHIFT                   4
#define MT6315_PMIC_RG_VBUCK1_TON_TRIM_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_2
#define MT6315_PMIC_RG_VBUCK1_TON_TRIM_MASK                 0x7F
#define MT6315_PMIC_RG_VBUCK1_TON_TRIM_SHIFT                0
#define MT6315_PMIC_RG_VBUCK1_FB_D2_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_2
#define MT6315_PMIC_RG_VBUCK1_FB_D2_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK1_FB_D2_SHIFT                   7
#define MT6315_PMIC_RG_VBUCK1_PFM_PEAK_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_3
#define MT6315_PMIC_RG_VBUCK1_PFM_PEAK_MASK                 0xF
#define MT6315_PMIC_RG_VBUCK1_PFM_PEAK_SHIFT                0
#define MT6315_PMIC_RG_VBUCK1_SONIC_PFM_PEAK_ADDR           \
	MT6315_BUCK_TOP_4PHASE_ELR_3
#define MT6315_PMIC_RG_VBUCK1_SONIC_PFM_PEAK_MASK           0xF
#define MT6315_PMIC_RG_VBUCK1_SONIC_PFM_PEAK_SHIFT          4
#define MT6315_PMIC_RG_VBUCK1_ECOT_TRIM_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_4
#define MT6315_PMIC_RG_VBUCK1_ECOT_TRIM_MASK                0x7
#define MT6315_PMIC_RG_VBUCK1_ECOT_TRIM_SHIFT               0
#define MT6315_PMIC_RG_VBUCK1_CSNSLP_TRIM_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ELR_4
#define MT6315_PMIC_RG_VBUCK1_CSNSLP_TRIM_MASK              0x1F
#define MT6315_PMIC_RG_VBUCK1_CSNSLP_TRIM_SHIFT             3
#define MT6315_PMIC_RG_VBUCK1_CSPSLP_TRIM_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ELR_5
#define MT6315_PMIC_RG_VBUCK1_CSPSLP_TRIM_MASK              0x1F
#define MT6315_PMIC_RG_VBUCK1_CSPSLP_TRIM_SHIFT             0
#define MT6315_PMIC_RG_VBUCK1_RAMP_SLP_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_5
#define MT6315_PMIC_RG_VBUCK1_RAMP_SLP_MASK                 0x7
#define MT6315_PMIC_RG_VBUCK1_RAMP_SLP_SHIFT                5
#define MT6315_PMIC_RG_VBUCK1_DRIVER_SR_TRIM_ADDR           \
	MT6315_BUCK_TOP_4PHASE_ELR_6
#define MT6315_PMIC_RG_VBUCK1_DRIVER_SR_TRIM_MASK           0x7
#define MT6315_PMIC_RG_VBUCK1_DRIVER_SR_TRIM_SHIFT          0
#define MT6315_PMIC_RG_VBUCK1_OC_D2P5_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ELR_6
#define MT6315_PMIC_RG_VBUCK1_OC_D2P5_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK1_OC_D2P5_SHIFT                 3
#define MT6315_PMIC_RG_VBUCK1_RSV_EFUSE_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_6
#define MT6315_PMIC_RG_VBUCK1_RSV_EFUSE_MASK                0xF
#define MT6315_PMIC_RG_VBUCK1_RSV_EFUSE_SHIFT               4
#define MT6315_PMIC_RG_VBUCK2_ZC_TRIM_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ELR_7
#define MT6315_PMIC_RG_VBUCK2_ZC_TRIM_MASK                  0x3F
#define MT6315_PMIC_RG_VBUCK2_ZC_TRIM_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK2_CCOMP_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_7
#define MT6315_PMIC_RG_VBUCK2_CCOMP_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK2_CCOMP_SHIFT                   6
#define MT6315_PMIC_RG_VBUCK2_NLIM_TRIM_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_8
#define MT6315_PMIC_RG_VBUCK2_NLIM_TRIM_MASK                0xF
#define MT6315_PMIC_RG_VBUCK2_NLIM_TRIM_SHIFT               0
#define MT6315_PMIC_RG_VBUCK2_RCOMP_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_8
#define MT6315_PMIC_RG_VBUCK2_RCOMP_MASK                    0xF
#define MT6315_PMIC_RG_VBUCK2_RCOMP_SHIFT                   4
#define MT6315_PMIC_RG_VBUCK2_TON_TRIM_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_9
#define MT6315_PMIC_RG_VBUCK2_TON_TRIM_MASK                 0x7F
#define MT6315_PMIC_RG_VBUCK2_TON_TRIM_SHIFT                0
#define MT6315_PMIC_RG_VBUCK2_FB_D2_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_9
#define MT6315_PMIC_RG_VBUCK2_FB_D2_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK2_FB_D2_SHIFT                   7
#define MT6315_PMIC_RG_VBUCK2_PFM_PEAK_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_10
#define MT6315_PMIC_RG_VBUCK2_PFM_PEAK_MASK                 0xF
#define MT6315_PMIC_RG_VBUCK2_PFM_PEAK_SHIFT                0
#define MT6315_PMIC_RG_VBUCK2_SONIC_PFM_PEAK_ADDR           \
	MT6315_BUCK_TOP_4PHASE_ELR_10
#define MT6315_PMIC_RG_VBUCK2_SONIC_PFM_PEAK_MASK           0xF
#define MT6315_PMIC_RG_VBUCK2_SONIC_PFM_PEAK_SHIFT          4
#define MT6315_PMIC_RG_VBUCK2_ECOT_TRIM_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_11
#define MT6315_PMIC_RG_VBUCK2_ECOT_TRIM_MASK                0x7
#define MT6315_PMIC_RG_VBUCK2_ECOT_TRIM_SHIFT               0
#define MT6315_PMIC_RG_VBUCK2_CSNSLP_TRIM_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ELR_11
#define MT6315_PMIC_RG_VBUCK2_CSNSLP_TRIM_MASK              0x1F
#define MT6315_PMIC_RG_VBUCK2_CSNSLP_TRIM_SHIFT             3
#define MT6315_PMIC_RG_VBUCK2_CSPSLP_TRIM_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ELR_12
#define MT6315_PMIC_RG_VBUCK2_CSPSLP_TRIM_MASK              0x1F
#define MT6315_PMIC_RG_VBUCK2_CSPSLP_TRIM_SHIFT             0
#define MT6315_PMIC_RG_VBUCK2_RAMP_SLP_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_12
#define MT6315_PMIC_RG_VBUCK2_RAMP_SLP_MASK                 0x7
#define MT6315_PMIC_RG_VBUCK2_RAMP_SLP_SHIFT                5
#define MT6315_PMIC_RG_VBUCK2_DRIVER_SR_TRIM_ADDR           \
	MT6315_BUCK_TOP_4PHASE_ELR_13
#define MT6315_PMIC_RG_VBUCK2_DRIVER_SR_TRIM_MASK           0x7
#define MT6315_PMIC_RG_VBUCK2_DRIVER_SR_TRIM_SHIFT          0
#define MT6315_PMIC_RG_VBUCK2_OC_D2P5_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ELR_13
#define MT6315_PMIC_RG_VBUCK2_OC_D2P5_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK2_OC_D2P5_SHIFT                 3
#define MT6315_PMIC_RG_VBUCK2_RSV_EFUSE_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_13
#define MT6315_PMIC_RG_VBUCK2_RSV_EFUSE_MASK                0xF
#define MT6315_PMIC_RG_VBUCK2_RSV_EFUSE_SHIFT               4
#define MT6315_PMIC_RG_VBUCK3_ZC_TRIM_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ELR_14
#define MT6315_PMIC_RG_VBUCK3_ZC_TRIM_MASK                  0x3F
#define MT6315_PMIC_RG_VBUCK3_ZC_TRIM_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK3_CCOMP_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_14
#define MT6315_PMIC_RG_VBUCK3_CCOMP_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK3_CCOMP_SHIFT                   6
#define MT6315_PMIC_RG_VBUCK3_NLIM_TRIM_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_15
#define MT6315_PMIC_RG_VBUCK3_NLIM_TRIM_MASK                0xF
#define MT6315_PMIC_RG_VBUCK3_NLIM_TRIM_SHIFT               0
#define MT6315_PMIC_RG_VBUCK3_RCOMP_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_15
#define MT6315_PMIC_RG_VBUCK3_RCOMP_MASK                    0xF
#define MT6315_PMIC_RG_VBUCK3_RCOMP_SHIFT                   4
#define MT6315_PMIC_RG_VBUCK3_TON_TRIM_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_16
#define MT6315_PMIC_RG_VBUCK3_TON_TRIM_MASK                 0x7F
#define MT6315_PMIC_RG_VBUCK3_TON_TRIM_SHIFT                0
#define MT6315_PMIC_RG_VBUCK3_FB_D2_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_16
#define MT6315_PMIC_RG_VBUCK3_FB_D2_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK3_FB_D2_SHIFT                   7
#define MT6315_PMIC_RG_VBUCK3_PFM_PEAK_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_17
#define MT6315_PMIC_RG_VBUCK3_PFM_PEAK_MASK                 0xF
#define MT6315_PMIC_RG_VBUCK3_PFM_PEAK_SHIFT                0
#define MT6315_PMIC_RG_VBUCK3_SONIC_PFM_PEAK_ADDR           \
	MT6315_BUCK_TOP_4PHASE_ELR_17
#define MT6315_PMIC_RG_VBUCK3_SONIC_PFM_PEAK_MASK           0xF
#define MT6315_PMIC_RG_VBUCK3_SONIC_PFM_PEAK_SHIFT          4
#define MT6315_PMIC_RG_VBUCK3_ECOT_TRIM_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_18
#define MT6315_PMIC_RG_VBUCK3_ECOT_TRIM_MASK                0x7
#define MT6315_PMIC_RG_VBUCK3_ECOT_TRIM_SHIFT               0
#define MT6315_PMIC_RG_VBUCK3_CSNSLP_TRIM_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ELR_18
#define MT6315_PMIC_RG_VBUCK3_CSNSLP_TRIM_MASK              0x1F
#define MT6315_PMIC_RG_VBUCK3_CSNSLP_TRIM_SHIFT             3
#define MT6315_PMIC_RG_VBUCK3_CSPSLP_TRIM_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ELR_19
#define MT6315_PMIC_RG_VBUCK3_CSPSLP_TRIM_MASK              0x1F
#define MT6315_PMIC_RG_VBUCK3_CSPSLP_TRIM_SHIFT             0
#define MT6315_PMIC_RG_VBUCK3_RAMP_SLP_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_19
#define MT6315_PMIC_RG_VBUCK3_RAMP_SLP_MASK                 0x7
#define MT6315_PMIC_RG_VBUCK3_RAMP_SLP_SHIFT                5
#define MT6315_PMIC_RG_VBUCK3_DRIVER_SR_TRIM_ADDR           \
	MT6315_BUCK_TOP_4PHASE_ELR_20
#define MT6315_PMIC_RG_VBUCK3_DRIVER_SR_TRIM_MASK           0x7
#define MT6315_PMIC_RG_VBUCK3_DRIVER_SR_TRIM_SHIFT          0
#define MT6315_PMIC_RG_VBUCK3_OC_D2P5_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ELR_20
#define MT6315_PMIC_RG_VBUCK3_OC_D2P5_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK3_OC_D2P5_SHIFT                 3
#define MT6315_PMIC_RG_VBUCK3_RSV_EFUSE_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_20
#define MT6315_PMIC_RG_VBUCK3_RSV_EFUSE_MASK                0xF
#define MT6315_PMIC_RG_VBUCK3_RSV_EFUSE_SHIFT               4
#define MT6315_PMIC_RG_VBUCK4_ZC_TRIM_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ELR_21
#define MT6315_PMIC_RG_VBUCK4_ZC_TRIM_MASK                  0x3F
#define MT6315_PMIC_RG_VBUCK4_ZC_TRIM_SHIFT                 0
#define MT6315_PMIC_RG_VBUCK4_CCOMP_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_21
#define MT6315_PMIC_RG_VBUCK4_CCOMP_MASK                    0x3
#define MT6315_PMIC_RG_VBUCK4_CCOMP_SHIFT                   6
#define MT6315_PMIC_RG_VBUCK4_NLIM_TRIM_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_22
#define MT6315_PMIC_RG_VBUCK4_NLIM_TRIM_MASK                0xF
#define MT6315_PMIC_RG_VBUCK4_NLIM_TRIM_SHIFT               0
#define MT6315_PMIC_RG_VBUCK4_RCOMP_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_22
#define MT6315_PMIC_RG_VBUCK4_RCOMP_MASK                    0xF
#define MT6315_PMIC_RG_VBUCK4_RCOMP_SHIFT                   4
#define MT6315_PMIC_RG_VBUCK4_TON_TRIM_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_23
#define MT6315_PMIC_RG_VBUCK4_TON_TRIM_MASK                 0x7F
#define MT6315_PMIC_RG_VBUCK4_TON_TRIM_SHIFT                0
#define MT6315_PMIC_RG_VBUCK4_FB_D2_ADDR                    \
	MT6315_BUCK_TOP_4PHASE_ELR_23
#define MT6315_PMIC_RG_VBUCK4_FB_D2_MASK                    0x1
#define MT6315_PMIC_RG_VBUCK4_FB_D2_SHIFT                   7
#define MT6315_PMIC_RG_VBUCK4_PFM_PEAK_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_24
#define MT6315_PMIC_RG_VBUCK4_PFM_PEAK_MASK                 0xF
#define MT6315_PMIC_RG_VBUCK4_PFM_PEAK_SHIFT                0
#define MT6315_PMIC_RG_VBUCK4_SONIC_PFM_PEAK_ADDR           \
	MT6315_BUCK_TOP_4PHASE_ELR_24
#define MT6315_PMIC_RG_VBUCK4_SONIC_PFM_PEAK_MASK           0xF
#define MT6315_PMIC_RG_VBUCK4_SONIC_PFM_PEAK_SHIFT          4
#define MT6315_PMIC_RG_VBUCK4_ECOT_TRIM_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_25
#define MT6315_PMIC_RG_VBUCK4_ECOT_TRIM_MASK                0x7
#define MT6315_PMIC_RG_VBUCK4_ECOT_TRIM_SHIFT               0
#define MT6315_PMIC_RG_VBUCK4_CSNSLP_TRIM_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ELR_25
#define MT6315_PMIC_RG_VBUCK4_CSNSLP_TRIM_MASK              0x1F
#define MT6315_PMIC_RG_VBUCK4_CSNSLP_TRIM_SHIFT             3
#define MT6315_PMIC_RG_VBUCK4_CSPSLP_TRIM_ADDR              \
	MT6315_BUCK_TOP_4PHASE_ELR_26
#define MT6315_PMIC_RG_VBUCK4_CSPSLP_TRIM_MASK              0x1F
#define MT6315_PMIC_RG_VBUCK4_CSPSLP_TRIM_SHIFT             0
#define MT6315_PMIC_RG_VBUCK4_RAMP_SLP_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_26
#define MT6315_PMIC_RG_VBUCK4_RAMP_SLP_MASK                 0x7
#define MT6315_PMIC_RG_VBUCK4_RAMP_SLP_SHIFT                5
#define MT6315_PMIC_RG_VBUCK4_DRIVER_SR_TRIM_ADDR           \
	MT6315_BUCK_TOP_4PHASE_ELR_27
#define MT6315_PMIC_RG_VBUCK4_DRIVER_SR_TRIM_MASK           0x7
#define MT6315_PMIC_RG_VBUCK4_DRIVER_SR_TRIM_SHIFT          0
#define MT6315_PMIC_RG_VBUCK4_OC_D2P5_ADDR                  \
	MT6315_BUCK_TOP_4PHASE_ELR_27
#define MT6315_PMIC_RG_VBUCK4_OC_D2P5_MASK                  0x1
#define MT6315_PMIC_RG_VBUCK4_OC_D2P5_SHIFT                 3
#define MT6315_PMIC_RG_VBUCK4_RSV_EFUSE_ADDR                \
	MT6315_BUCK_TOP_4PHASE_ELR_27
#define MT6315_PMIC_RG_VBUCK4_RSV_EFUSE_MASK                0xF
#define MT6315_PMIC_RG_VBUCK4_RSV_EFUSE_SHIFT               4
#define MT6315_PMIC_RG_4PH_CONFIG1_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ELR_28
#define MT6315_PMIC_RG_4PH_CONFIG1_MASK                     0x1
#define MT6315_PMIC_RG_4PH_CONFIG1_SHIFT                    0
#define MT6315_PMIC_RG_4PH_CONFIG2_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ELR_28
#define MT6315_PMIC_RG_4PH_CONFIG2_MASK                     0x1
#define MT6315_PMIC_RG_4PH_CONFIG2_SHIFT                    1
#define MT6315_PMIC_RG_4PH_CONFIG3_ADDR                     \
	MT6315_BUCK_TOP_4PHASE_ELR_28
#define MT6315_PMIC_RG_4PH_CONFIG3_MASK                     0x1
#define MT6315_PMIC_RG_4PH_CONFIG3_SHIFT                    2
#define MT6315_PMIC_RG_4PH_23PHIN_TRIM_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_28
#define MT6315_PMIC_RG_4PH_23PHIN_TRIM_MASK                 0xF
#define MT6315_PMIC_RG_4PH_23PHIN_TRIM_SHIFT                3
#define MT6315_PMIC_RG_4PH_34PHIN_TRIM_ADDR                 \
	MT6315_BUCK_TOP_4PHASE_ELR_29
#define MT6315_PMIC_RG_4PH_34PHIN_TRIM_MASK                 0xF
#define MT6315_PMIC_RG_4PH_34PHIN_TRIM_SHIFT                0

#if 0
enum PMU_FLAGS_LIST {
	PMIC_TOP0_ANA_ID,
	PMIC_TOP0_DIG_ID,
	PMIC_TOP0_ANA_MINOR_REV,
	PMIC_TOP0_ANA_MAJOR_REV,
	PMIC_TOP0_DIG_MINOR_REV,
	PMIC_TOP0_DIG_MAJOR_REV,
	PMIC_TOP0_DSN_CBS,
	PMIC_TOP0_DSN_BIX,
	PMIC_TOP0_DSN_ESP,
	PMIC_TOP0_DSN_FPI,
	PMIC_TOP0_DUMMY,
	PMIC_HWCID_L,
	PMIC_HWCID_H,
	PMIC_SWCID_L,
	PMIC_SWCID_H,
	PMIC_STS_OVLO,
	PMIC_STS_UVLO,
	PMIC_STS_PGFAIL,
	PMIC_STS_PSOC,
	PMIC_STS_THRDN,
	PMIC_STS_NORMOFF,
	PMIC_STS_ABNORMOFF,
	PMIC_STS_KEYPWR,
	PMIC_RG_POFFSTS_CLR,
	PMIC_VBUCK1_PG_DEB,
	PMIC_VBUCK2_PG_DEB,
	PMIC_VBUCK3_PG_DEB,
	PMIC_VBUCK4_PG_DEB,
	PMIC_STRUP_VBUCK1_PG_STATUS,
	PMIC_STRUP_VBUCK2_PG_STATUS,
	PMIC_STRUP_VBUCK3_PG_STATUS,
	PMIC_STRUP_VBUCK4_PG_STATUS,
	PMIC_STRUP_VBUCK1_OC_STATUS,
	PMIC_STRUP_VBUCK2_OC_STATUS,
	PMIC_STRUP_VBUCK3_OC_STATUS,
	PMIC_STRUP_VBUCK4_OC_STATUS,
	PMIC_STRUP_THERMAL0_STATUS,
	PMIC_STRUP_THERMAL1_STATUS,
	PMIC_STRUP_THERMAL2_STATUS,
	PMIC_STRUP_THERMAL3_STATUS,
	PMIC_STRUP_THERMAL4_STATUS,
	PMIC_PMU_THERMAL0_DEB,
	PMIC_PMU_THERMAL1_DEB,
	PMIC_PMU_THERMAL2_DEB,
	PMIC_PMU_THERMAL3_DEB,
	PMIC_PMU_THERMAL4_DEB,
	PMIC_RG_SRCLKEN_IN_EN,
	PMIC_RG_SRCLKEN_IN_HW_MODE,
	PMIC_RG_SRCLKEN_IN_SYNC_EN,
	PMIC_RG_OSC_EN_AUTO_OFF,
	PMIC_TEST_OUT,
	PMIC_RG_MON_GRP_SEL,
	PMIC_RG_MON_FLAG_SEL,
	PMIC_RG_DBG0_OUT_SEL,
	PMIC_RG_DBG1_OUT_SEL,
	PMIC_RG_DBG2_OUT_SEL,
	PMIC_RG_DBG3_OUT_SEL,
	PMIC_RG_NANDTREE_MODE,
	PMIC_RG_EFUSE_MODE,
	PMIC_RG_TEST_STRUP,
	PMIC_RG_ATST_KEY0,
	PMIC_RG_ATST_KEY1,
	PMIC_RG_ATST_KEY2,
	PMIC_RG_ATST_KEY3,
	PMIC_RG_SYS_LATCH_EN_SW_SEL,
	PMIC_RG_SYS_LATCH_EN_SW,
	PMIC_RG_PG_OUT_SW_SEL,
	PMIC_RG_PG_OUT_SW,
	PMIC_RG_PG_OUT_DBG_SEL,
	PMIC_RG_ANA_IO_SW_SEL,
	PMIC_RG_ANA_IO_SW,
	PMIC_RG_OSC_EN_DBG_SEL,
	PMIC_TESTMODE_SW,
	PMIC_PMU_TEST_MODE_SCAN,
	PMIC_RG_PMU_TDSEL,
	PMIC_RG_SIF_TDSEL,
	PMIC_RG_PMU_RDSEL,
	PMIC_RG_SIF_RDSEL,
	PMIC_RG_SMT_SRCLKEN_IN,
	PMIC_RG_SMT_SCLK,
	PMIC_RG_SMT_SDAT,
	PMIC_RG_SMT_PMIC_INT,
	PMIC_RG_SMT_WDTRSTB_IN,
	PMIC_RG_EH_SRCLKEN_IN,
	PMIC_RG_EH_PMIC_INT,
	PMIC_RG_EH1_SRCLKEN_IN,
	PMIC_RG_EH1_PMIC_INT,
	PMIC_RG_EH2_SRCLKEN_IN,
	PMIC_RG_EH2_PMIC_INT,
	PMIC_RG_RSEL_SRCLKEN_IN,
	PMIC_RG_RSEL_PMIC_INT,
	PMIC_RG_RSEL_WDTRSTB_IN,
	PMIC_RG_TOP_RSV0,
	PMIC_RG_TOP_RSV1,
	PMIC_RG_OCTL_SRCLKEN_IN,
	PMIC_RG_OCTL_PMIC_INT,
	PMIC_RG_SRCLKEN_IN_FILTER_EN,
	PMIC_RG_SCLK_FILTER_EN,
	PMIC_RG_SDAT_FILTER_EN,
	PMIC_RG_PMIC_INT_FILTER_EN,
	PMIC_RG_WDTRSTB_IN_FILTER_EN,
	PMIC_RG_SRCLKEN_IN_RCSEL,
	PMIC_RG_SCLK_RCSEL,
	PMIC_RG_SDAT_RCSEL,
	PMIC_RG_PMIC_INT_RCSEL,
	PMIC_RG_WDTRSTB_IN_RCSEL,
	PMIC_TOP_STATUS,
	PMIC_TOP_STATUS_SET,
	PMIC_TOP_STATUS_CLR,
	PMIC_RG_SEQ_OFF,
	PMIC_VM_MODE,
	PMIC_TOP1_ANA_ID,
	PMIC_TOP1_DIG_ID,
	PMIC_TOP1_ANA_MINOR_REV,
	PMIC_TOP1_ANA_MAJOR_REV,
	PMIC_TOP1_DIG_MINOR_REV,
	PMIC_TOP1_DIG_MAJOR_REV,
	PMIC_TOP1_DSN_CBS,
	PMIC_TOP1_DSN_BIX,
	PMIC_TOP1_DSN_ESP,
	PMIC_TOP1_DSN_FPI,
	PMIC_GPIO_DIR0,
	PMIC_GPIO_DIR0_SET,
	PMIC_GPIO_DIR0_CLR,
	PMIC_GPIO_PULLEN0,
	PMIC_GPIO_PULLEN0_SET,
	PMIC_GPIO_PULLEN0_CLR,
	PMIC_GPIO_PULLSEL0,
	PMIC_GPIO_PULLSEL0_SET,
	PMIC_GPIO_PULLSEL0_CLR,
	PMIC_GPIO_DINV0,
	PMIC_GPIO_DINV0_SET,
	PMIC_GPIO_DINV0_CLR,
	PMIC_GPIO_DOUT0,
	PMIC_GPIO_DOUT0_SET,
	PMIC_GPIO_DOUT0_CLR,
	PMIC_GPIO_PI0,
	PMIC_GPIO_POE0,
	PMIC_GPIO0_MODE,
	PMIC_GPIO1_MODE,
	PMIC_GPIO_MODE0_SET,
	PMIC_GPIO_MODE0_CLR,
	PMIC_GPIO2_MODE,
	PMIC_GPIO3_MODE,
	PMIC_GPIO_MODE1_SET,
	PMIC_GPIO_MODE1_CLR,
	PMIC_GPIO_RSV,
	PMIC_RG_PAD_IE_FORCE,
	PMIC_TOP2_ANA_ID,
	PMIC_TOP2_DIG_ID,
	PMIC_TOP2_ANA_MINOR_REV,
	PMIC_TOP2_ANA_MAJOR_REV,
	PMIC_TOP2_DIG_MINOR_REV,
	PMIC_TOP2_DIG_MAJOR_REV,
	PMIC_TOP2_DSN_CBS,
	PMIC_TOP2_DSN_BIX,
	PMIC_TOP2_DSN_ESP,
	PMIC_TOP2_DSN_FPI,
	PMIC_TOP_CLK_OFFSET,
	PMIC_TOP_RST_OFFSET,
	PMIC_TOP_INT_OFFSET,
	PMIC_TOP_INT_LEN,
	PMIC_RG_TRIM_128K_CK_PDN,
	PMIC_RG_TRIM_4M_CK_PDN,
	PMIC_RG_RSV_CK_PDN,
	PMIC_RG_FQMTR_32K_CK_PDN,
	PMIC_RG_FQMTR_CK_PDN,
	PMIC_RG_INTRP_CK_PDN,
	PMIC_TOP_CKPDN_CON0_SET,
	PMIC_TOP_CKPDN_CON0_CLR,
	PMIC_RG_PMU128K_CK_PDN,
	PMIC_RG_PMU32K_CK_PDN,
	PMIC_RG_EFUSE_CK_PDN,
	PMIC_RG_SMPS4M_CK_PDN,
	PMIC_RG_SMPS1M_CK_PDN,
	PMIC_RG_RFFE_CK_PDN,
	PMIC_RG_SPMI_CK_PDN,
	PMIC_RG_I2C_CK_PDN,
	PMIC_TOP_CKPDN_CON1_SET,
	PMIC_TOP_CKPDN_CON1_CLR,
	PMIC_RG_EFUSE_CK_CKSEL,
	PMIC_RG_FQMTR_CK_CKSEL,
	PMIC_RG_PMU32K_CK_CKSEL,
	PMIC_RG_TOP_CKSEL_CON0_RSV,
	PMIC_TOP_CKSEL_CON0_SET,
	PMIC_TOP_CKSEL_CON0_CLR,
	PMIC_RG_REG_CK_DIVSEL,
	PMIC_TOP_CKDIVSEL_CON0_RSV,
	PMIC_TOP_CKDIVSEL_CON0_SET,
	PMIC_TOP_CKDIVSEL_CON0_CLR,
	PMIC_RG_EFUSE_CK_PDN_HWEN,
	PMIC_RG_SMPS4M_CK_PDN_HWEN,
	PMIC_RG_SMPS1M_CK_PDN_HWEN,
	PMIC_TOP_CKHWEN_CON0_RSV,
	PMIC_TOP_CKHWEN_CON0_SET,
	PMIC_TOP_CKHWEN_CON0_CLR,
	PMIC_DA_SMPS_OSC_EN,
	PMIC_SMPS4M_CKEN_BUCK,
	PMIC_SMPS1M_CKEN_BUCK,
	PMIC_RG_PMU128K_CK_TST_DIS,
	PMIC_RG_SMPS_CK_TST_DIS,
	PMIC_TOP_CKTST_CON0_RSV,
	PMIC_RG_PMU128K_CK_TSTSEL,
	PMIC_RG_SMPS_CK_TSTSEL,
	PMIC_RG_EFUSE_CK_TSTSEL,
	PMIC_RG_FQMTR_CK_TSTSEL,
	PMIC_RG_OSC_EN_SW_SEL,
	PMIC_RG_OSC_EN_SW,
	PMIC_RG_BUCK_LP_EN,
	PMIC_RG_SRCLKEN_LP_EN,
	PMIC_RG_BUCK_OSC_CTRL_ONLY,
	PMIC_RG_EFUSE_MAN_RST,
	PMIC_RG_FQMTR_RST,
	PMIC_RG_CLK_TRIM_128K_RST,
	PMIC_RG_CLK_TRIM_4M_RST,
	PMIC_RG_BUCK_SRCLKEN_RST,
	PMIC_TOP_RST_CON0_SET,
	PMIC_TOP_RST_CON0_CLR,
	PMIC_RG_BUCK_PROT_PMPP_RST,
	PMIC_RG_FT_VR_SYSRSTB,
	PMIC_TOP_RST_CON1_RSV,
	PMIC_TOP_RST_CON1_SET,
	PMIC_TOP_RST_CON1_CLR,
	PMIC_TOP_RST_CON2_RSV,
	PMIC_RG_GPIO_RST_SEL,
	PMIC_RG_WDTRSTB_EN,
	PMIC_RG_WDTRSTB_DEB,
	PMIC_WDTRSTB_STATUS,
	PMIC_WDTRSTB_STATUS_CLR,
	PMIC_TOP_RST_MISC_SET,
	PMIC_TOP_RST_MISC_CLR,
	PMIC_VPWRIN_RSTB_STATUS,
	PMIC_UVLO_RSTB_STATUS,
	PMIC_TOP_RST_STATUS_RSV,
	PMIC_TOP_RST_STATUS_SET,
	PMIC_TOP_RST_STATUS_CLR,
	PMIC_FQMTR_EN,
	PMIC_FQMTR_TCKSEL,
	PMIC_FQMTR_BUSY,
	PMIC_FQMTR_WINSET_0,
	PMIC_FQMTR_WINSET_1,
	PMIC_FQMTR_DATA_0,
	PMIC_FQMTR_DATA_1,
	PMIC_TOP2_ELR_LEN,
	PMIC_RG_SIF_SEL,
	PMIC_RG_SIF_PULL_AUTO,
	PMIC_RG_SIF_PULL_BY_EFUSE,
	PMIC_RG_SIF_PULLEN,
	PMIC_RG_SIF_PULLSEL,
	PMIC_RG_EH_SCLK,
	PMIC_RG_EH_SDAT,
	PMIC_RG_EH1_SCLK,
	PMIC_RG_EH1_SDAT,
	PMIC_RG_EH2_SCLK,
	PMIC_RG_EH2_SDAT,
	PMIC_RG_RSEL_SCLK,
	PMIC_RG_RSEL_SDAT,
	PMIC_RG_OCTL_SCLK,
	PMIC_RG_OCTL_SDAT,
	PMIC_RG_TOP2_RSV0,
	PMIC_RG_SLV_ID,
	PMIC_RG_SLV_CON0,
	PMIC_RG_WDTRSTB_SRC_SEL,
	PMIC_RG_SRCLKEN_SRC_SEL,
	PMIC_RG_SHUTDOWN_SRC_SEL,
	PMIC_RG_TOP2_RSV1,
	PMIC_RG_TOP2_RSV2,
	PMIC_TOP3_ANA_ID,
	PMIC_TOP3_DIG_ID,
	PMIC_TOP3_ANA_MINOR_REV,
	PMIC_TOP3_ANA_MAJOR_REV,
	PMIC_TOP3_DIG_MINOR_REV,
	PMIC_TOP3_DIG_MAJOR_REV,
	PMIC_TOP3_DSN_CBS,
	PMIC_TOP3_DSN_BIX,
	PMIC_TOP3_DSN_ESP,
	PMIC_TOP3_DSN_FPI,
	PMIC_RG_INT_EN_VBUCK1_OC,
	PMIC_RG_INT_EN_VBUCK2_OC,
	PMIC_RG_INT_EN_VBUCK3_OC,
	PMIC_RG_INT_EN_VBUCK4_OC,
	PMIC_RG_INT_EN_TEMP_BACK_110D,
	PMIC_RG_INT_EN_TEMP_OVER_125D,
	PMIC_RG_INT_EN_RCS0,
	PMIC_RG_INT_EN_RCS1,
	PMIC_RG_TOP_INT_EN_CON0_SET,
	PMIC_RG_TOP_INT_EN_CON0_CLR,
	PMIC_RG_INT_MASK_VBUCK1_OC,
	PMIC_RG_INT_MASK_VBUCK2_OC,
	PMIC_RG_INT_MASK_VBUCK3_OC,
	PMIC_RG_INT_MASK_VBUCK4_OC,
	PMIC_RG_INT_MASK_TEMP_BACK_110D,
	PMIC_RG_INT_MASK_TEMP_OVER_125D,
	PMIC_RG_INT_MASK_RCS0,
	PMIC_RG_INT_MASK_RCS1,
	PMIC_RG_TOP_INT_MASK_CON0_SET,
	PMIC_RG_TOP_INT_MASK_CON0_CLR,
	PMIC_RG_INT_STATUS_VBUCK1_OC,
	PMIC_RG_INT_STATUS_VBUCK2_OC,
	PMIC_RG_INT_STATUS_VBUCK3_OC,
	PMIC_RG_INT_STATUS_VBUCK4_OC,
	PMIC_RG_INT_STATUS_TEMP_BACK_110D,
	PMIC_RG_INT_STATUS_TEMP_OVER_125D,
	PMIC_RG_INT_STATUS_RCS0,
	PMIC_RG_INT_STATUS_RCS1,
	PMIC_RG_INT_RAW_STATUS_VBUCK1_OC,
	PMIC_RG_INT_RAW_STATUS_VBUCK2_OC,
	PMIC_RG_INT_RAW_STATUS_VBUCK3_OC,
	PMIC_RG_INT_RAW_STATUS_VBUCK4_OC,
	PMIC_RG_INT_RAW_STATUS_TEMP_BACK_110D,
	PMIC_RG_INT_RAW_STATUS_TEMP_OVER_125D,
	PMIC_RG_INT_RAW_STATUS_RCS0,
	PMIC_RG_INT_RAW_STATUS_RCS1,
	PMIC_RG_INT_POLARITY,
	PMIC_PMRC_EN,
	PMIC_RG_PMRC_CON0_SET,
	PMIC_RG_PMRC_CON0_CLR,
	PMIC_RG_VR_SPM_MODE,
	PMIC_RG_TOP_SPM_MODE,
	PMIC_RG_PMRC_CON1_SET,
	PMIC_RG_PMRC_CON1_CLR,
	PMIC_RG_LDO_VDIG18_LP,
	PMIC_RG_LDO_VDIG18_SW_OP_EN,
	PMIC_RG_LDO_VDIG18_HW_OP_EN,
	PMIC_RG_VDIG18_MODE_SW_SEL,
	PMIC_RG_VDIG18_MODE_1_SW,
	PMIC_RG_VDIG18_MODE_2_SW,
	PMIC_RG_VDIG18_PWROFF_OP_EN,
	PMIC_PLT0_ANA_ID,
	PMIC_PLT0_DIG_ID,
	PMIC_PLT0_ANA_MINOR_REV,
	PMIC_PLT0_ANA_MAJOR_REV,
	PMIC_PLT0_DIG_MINOR_REV,
	PMIC_PLT0_DIG_MAJOR_REV,
	PMIC_PLT0_DSN_CBS,
	PMIC_PLT0_DSN_BIX,
	PMIC_PLT0_DSN_ESP,
	PMIC_PLT0_DSN_FPI,
	PMIC_DA_STRUP_OSC_TRIM,
	PMIC_RG_OSC_128K_TRIM_EN,
	PMIC_RG_OSC_128K_TRIM_RATE,
	PMIC_DA_SMPS_OSC_TRIM,
	PMIC_RG_SMPS_4M_TRIM_EN,
	PMIC_RG_SMPS_4M_TRIM_RATE,
	PMIC_RG_BUCK_BANK_LP_ACS_EN,
	PMIC_RG_PSC_BANK_LP_ACS_EN,
	PMIC_RG_TOP0_BANK_LP_ACS_EN,
	PMIC_RG_TOP1_BANK_LP_ACS_EN,
	PMIC_RG_TOP2_BANK_LP_ACS_EN,
	PMIC_RG_TOP3_BANK_LP_ACS_EN,
	PMIC_RG_PLT0_BANK_LP_ACS_EN,
	PMIC_RG_RSV_BANK_LP_ACS_EN,
	PMIC_RG_OTP_PA,
	PMIC_RG_OTP_PDIN_L,
	PMIC_RG_OTP_PDIN_H,
	PMIC_RG_OTP_PTM,
	PMIC_RG_OTP_PWE,
	PMIC_RG_OTP_PPROG,
	PMIC_RG_OTP_PWE_SRC,
	PMIC_RG_OTP_PROG_PKEY,
	PMIC_RG_OTP_PROG_PKEY_H,
	PMIC_RG_OTP_RD_PKEY,
	PMIC_RG_OTP_RD_PKEY_H,
	PMIC_RG_OTP_RD_TRIG,
	PMIC_RG_RD_RDY_BYPASS,
	PMIC_RG_SKIP_OTP_OUT,
	PMIC_RG_OTP_RD_SW,
	PMIC_RG_OTP_DOUT_SW,
	PMIC_RG_OTP_DOUT_SW_H,
	PMIC_RG_OTP_RD_BUSY,
	PMIC_RG_OTP_RD_ACK,
	PMIC_RG_OTP_PA_SW,
	PMIC_TMA_KEY,
	PMIC_TMA_KEY_H,
	PMIC_ANA_WRITE_KEY,
	PMIC_ANA_WRITE_KEY_H,
	PMIC_TOP_MDB_RSV0,
	PMIC_TOP_MDB_RSV0_H,
	PMIC_TOP_MDB_RSV1,
	PMIC_TOP_MDB_RSV1_H,
	PMIC_RG_MDB_DM1_DS_EN,
	PMIC_RG_AUTO_LOAD_FORCE,
	PMIC_RG_OTP_WRITE_SEL,
	PMIC_DIG_WPK_KEY,
	PMIC_DIG_WPK_KEY_H,
	PMIC_RG_EXTADR_REG0_W,
	PMIC_RG_EXTADR_REG0_W_H,
	PMIC_RG_EXTADR_EXT_REG_RW,
	PMIC_RG_EXTADR_REG_RW,
	PMIC_RG_EXTADR_REG_RW_H,
	PMIC_RG_SPMI_RXDATA_MD,
	PMIC_RG_SPMI_DLY_SEL,
	PMIC_RG_RCS_ENABLE,
	PMIC_RG_RCS_ABIT,
	PMIC_RG_RCS_CMD,
	PMIC_RG_RCS_ID,
	PMIC_RG_RCS_ADDR,
	PMIC_RG_INT_RCS0,
	PMIC_RG_INT_RCS1,
	PMIC_RG_INT_RCS1_CLR,
	PMIC_RG_PARTY_ERR_CLR,
	PMIC_RG_ADDR_WR_MATCH,
	PMIC_RG_ADDR_WR_MATCH_H,
	PMIC_RG_RXDBG_ADDR0,
	PMIC_RG_RXDBG_ADDR0_H,
	PMIC_RG_RXDBG_DATA0,
	PMIC_RG_RXDBG_CMD0,
	PMIC_RG_RXDBG_IDX,
	PMIC_RG_RXDBG_ADDR1,
	PMIC_RG_RXDBG_ADDR1_H,
	PMIC_RG_RXDBG_DATA1,
	PMIC_RG_RXDBG_CMD1,
	PMIC_RG_RXDBG_ADDR2,
	PMIC_RG_RXDBG_ADDR2_H,
	PMIC_RG_RXDBG_DATA2,
	PMIC_RG_RXDBG_CMD2,
	PMIC_RG_RXDBG_ADDR3,
	PMIC_RG_RXDBG_ADDR3_H,
	PMIC_RG_RXDBG_DATA3,
	PMIC_RG_RXDBG_CMD3,
	PMIC_RG_PRTY_ERR_COMD0,
	PMIC_RG_PRTY_ERR_TYPE0,
	PMIC_RG_PRTY_ERR_IDX,
	PMIC_RG_PRTY_ERR_DATA0,
	PMIC_RG_PRTY_ERR_DATA0_H,
	PMIC_RG_PRTY_ERR_COMD1,
	PMIC_RG_PRTY_ERR_TYPE1,
	PMIC_RG_PRTY_ERR_DATA1,
	PMIC_RG_PRTY_ERR_DATA1_H,
	PMIC_RG_PRTY_ERR_COMD2,
	PMIC_RG_PRTY_ERR_TYPE2,
	PMIC_RG_PRTY_ERR_DATA2,
	PMIC_RG_PRTY_ERR_DATA2_H,
	PMIC_RG_PRTY_ERR_COMD3,
	PMIC_RG_PRTY_ERR_TYPE3,
	PMIC_RG_PRTY_ERR_DATA3,
	PMIC_RG_PRTY_ERR_DATA3_H,
	PMIC_PLT0_ELR_LEN,
	PMIC_RG_OSC_128K_TRIM,
	PMIC_RG_SMPS_4M_TRIM,
	PMIC_PSC_TOP_ANA_ID,
	PMIC_PSC_TOP_DIG_ID,
	PMIC_PSC_TOP_ANA_MINOR_REV,
	PMIC_PSC_TOP_ANA_MAJOR_REV,
	PMIC_PSC_TOP_DIG_MINOR_REV,
	PMIC_PSC_TOP_DIG_MAJOR_REV,
	PMIC_PSC_TOP_CBS,
	PMIC_PSC_TOP_BIX,
	PMIC_PSC_TOP_ESP,
	PMIC_PSC_TOP_FPI,
	PMIC_PSC_TOP_CLK_OFFSET,
	PMIC_PSC_TOP_RST_OFFSET,
	PMIC_PSC_TOP_INT_OFFSET,
	PMIC_BANK_PSEQ_SWRST,
	PMIC_BANK_STRUP_ANA0_SWRST,
	PMIC_RG_PSC_MON_GRP_SEL,
	PMIC_PSEQ_ANA_ID,
	PMIC_PSEQ_DIG_ID,
	PMIC_PSEQ_ANA_MINOR_REV,
	PMIC_PSEQ_ANA_MAJOR_REV,
	PMIC_PSEQ_DIG_MINOR_REV,
	PMIC_PSEQ_DIG_MAJOR_REV,
	PMIC_PSEQ_CBS,
	PMIC_PSEQ_BIX,
	PMIC_PSEQ_ESP,
	PMIC_PSEQ_FPI,
	PMIC_RG_PGODLY_INTV,
	PMIC_RG_RSV_SWREG,
	PMIC_RG_THR_TEST_EN,
	PMIC_RG_THR_TEST,
	PMIC_RG_THR_DET_DIS,
	PMIC_RG_STRUP_VBUCK4_PG_ENB,
	PMIC_RG_STRUP_VBUCK3_PG_ENB,
	PMIC_RG_STRUP_VBUCK2_PG_ENB,
	PMIC_RG_STRUP_VBUCK1_PG_ENB,
	PMIC_RG_STRUP_VBUCK4_OC_ENB,
	PMIC_RG_STRUP_VBUCK3_OC_ENB,
	PMIC_RG_STRUP_VBUCK2_OC_ENB,
	PMIC_RG_STRUP_VBUCK1_OC_ENB,
	PMIC_RG_KEYPWR_VBUCK4_EN,
	PMIC_RG_KEYPWR_VBUCK3_EN,
	PMIC_RG_KEYPWR_VBUCK2_EN,
	PMIC_RG_KEYPWR_VBUCK1_EN,
	PMIC_RG_PSEQ_FORCE_ON,
	PMIC_RG_PSEQ_FORCE_TEST_EN,
	PMIC_RG_PSEQ_FORCE_ALL_DOFF,
	PMIC_RG_PSEQ_PG_CK_SEL,
	PMIC_RG_THM_SHDN_EN,
	PMIC_RG_OVLO_RDB_TD,
	PMIC_RG_OVLO_RDB_EN,
	PMIC_DDUVLO_DEB_EN,
	PMIC_RG_STRUP_FT_CTRL,
	PMIC_STRUP_DIG_IO_PG_FORCE,
	PMIC_RG_ATST_PG_CHK,
	PMIC_RG_STRUP_PG_DEB_MODE,
	PMIC_RG_CPS_W_KEY,
	PMIC_RG_CPS_W_KEY_H,
	PMIC_STS_PDN_ENCODE,
	PMIC_PSEQ_ELR_LEN,
	PMIC_RG_SLOT_INTV_UP,
	PMIC_RG_SEQ_LEN,
	PMIC_RG_PSEQ_ELR_RSV0,
	PMIC_RG_SLOT_INTV_DOWN,
	PMIC_RG_DSEQ_LEN,
	PMIC_RG_PSEQ_ELR_RSV1,
	PMIC_RG_PSPG_SHDN_ENB,
	PMIC_RG_PSEQ_F32K_FORCE,
	PMIC_RG_PSEQ_1MS_TK_EXT,
	PMIC_RG_CPS_PGEXT_EN,
	PMIC_RG_SDN_DLY_ENB,
	PMIC_RG_STRUP_VBUCK4_PG_H2L_EN,
	PMIC_RG_STRUP_VBUCK3_PG_H2L_EN,
	PMIC_RG_STRUP_VBUCK2_PG_H2L_EN,
	PMIC_RG_STRUP_VBUCK1_PG_H2L_EN,
	PMIC_RG_PSC_ELR_RSV0,
	PMIC_RG_PSC_ELR_RSV1,
	PMIC_RG_VBUCK1_USA,
	PMIC_RG_VBUCK2_USA,
	PMIC_RG_VBUCK3_USA,
	PMIC_RG_VBUCK4_USA,
	PMIC_RG_VBUCK1_DSA,
	PMIC_RG_VBUCK2_DSA,
	PMIC_RG_VBUCK3_DSA,
	PMIC_RG_VBUCK4_DSA,
	PMIC_STRUP_ANA0_ANA_ID,
	PMIC_STRUP_ANA0_DIG_ID,
	PMIC_STRUP_ANA0_ANA_MINOR_REV,
	PMIC_STRUP_ANA0_ANA_MAJOR_REV,
	PMIC_STRUP_ANA0_DIG_MINOR_REV,
	PMIC_STRUP_ANA0_DIG_MAJOR_REV,
	PMIC_STRUP_ANA0_CBS,
	PMIC_STRUP_ANA0_BIX,
	PMIC_STRUP_ANA0_ESP,
	PMIC_STRUP_ANA0_FPI,
	PMIC_RG_VBG1_EN,
	PMIC_RG_VBG2_EN,
	PMIC_RG_VBGX_SEL,
	PMIC_RG_VBG1_BYPASS_PREREG,
	PMIC_RG_VBG1_PREREG_VDB_EN,
	PMIC_RG_VBG2_LP_EN,
	PMIC_RG_VBG_SCLPF_BYPASS,
	PMIC_RG_THERMAL_EN,
	PMIC_RG_THERMAL_DET_SEL,
	PMIC_RG_THERMAL_TEMP_H_SEL,
	PMIC_RG_STRUP_OSC_EN,
	PMIC_RG_SMPS_OSC_SEL,
	PMIC_RG_UVLO_EN,
	PMIC_RG_UVLO_FORCE_COMPH,
	PMIC_RG_OVLO_FORCE_COMPH,
	PMIC_RG_VBAT_FORCE_COMPH,
	PMIC_RG_ANA_TM_EN,
	PMIC_RG_ANA_TM_SEL,
	PMIC_RG_ANA_TM_MUX_SEL,
	PMIC_RG_STRUP_RSV,
	PMIC_RG_PG_DISABLE,
	PMIC_RG_VDIG18_DISCHARGE_EN_OPTION,
	PMIC_RG_VDIG18_FASTTRAN_EN_OPTION,
	PMIC_RG_VDIG18_RSV,
	PMIC_RG_AUTOK_RST,
	PMIC_RG_DISAUTOK,
	PMIC_RGS_VBUCK1_PG_STATUS,
	PMIC_RGS_VBUCK2_PG_STATUS,
	PMIC_RGS_VBUCK3_PG_STATUS,
	PMIC_RGS_VBUCK4_PG_STATUS,
	PMIC_RGS_VIO18_PG_STATUS,
	PMIC_RGS_POFFSTS,
	PMIC_STRUP_ANA0_ELR_LEN,
	PMIC_RG_VBG1_TC_TRIM,
	PMIC_RG_VBG2_TC_TRIM,
	PMIC_RG_VBGR_IREF_TRIM,
	PMIC_RG_VBGR_VREF_TRIM,
	PMIC_RG_VBUCK1_TRIM,
	PMIC_RG_UVLO_VTHH,
	PMIC_RG_VBUCK2_TRIM,
	PMIC_RG_UVLO_VTHL,
	PMIC_RG_VBUCK3_TRIM,
	PMIC_RG_OVLO_VTHL,
	PMIC_RG_VBUCK4_TRIM,
	PMIC_RG_OVLO_VTHH,
	PMIC_RG_VDIG18_TRIM,
	PMIC_RG_OVLO_EN,
	PMIC_RG_THERMAL_LOCATION,
	PMIC_BUCK_TOP_ANA_ID,
	PMIC_BUCK_TOP_DIG_ID,
	PMIC_BUCK_TOP_ANA_MINOR_REV,
	PMIC_BUCK_TOP_ANA_MAJOR_REV,
	PMIC_BUCK_TOP_DIG_MINOR_REV,
	PMIC_BUCK_TOP_DIG_MAJOR_REV,
	PMIC_BUCK_TOP_CBS,
	PMIC_BUCK_TOP_BIX,
	PMIC_BUCK_TOP_ESP,
	PMIC_BUCK_TOP_FPI,
	PMIC_BUCK_TOP_CLK_OFFSET,
	PMIC_BUCK_TOP_RST_OFFSET,
	PMIC_BUCK_TOP_INT_OFFSET,
	PMIC_BUCK_TOP_INT_LEN,
	PMIC_RG_BUCK32K_CK_PDN,
	PMIC_RG_BUCK1M_CK_PDN,
	PMIC_RG_BUCK4M_CK_PDN,
	PMIC_RG_BUCK_RG_CK_PDN,
	PMIC_RG_BUCK_RG_CK_SEL,
	PMIC_RG_BUCK_SFCHG_SYNC_CK_FORCE,
	PMIC_RG_BUCK_CK_RSV,
	PMIC_RG_BUCK_TOP_CLK_CON0_SET,
	PMIC_RG_BUCK_TOP_CLK_CON0_CLR,
	PMIC_RG_BUCK32K_CK_PDN_HWEN,
	PMIC_RG_BUCK1M_CK_PDN_HWEN,
	PMIC_RG_BUCK4M_CK_PDN_HWEN,
	PMIC_RG_BUCK_RG_CK_PDN_HWEN,
	PMIC_RG_BUCK_SLEEP_CTRL_MODE,
	PMIC_RG_BUCK_CK_PDN_HWEN_RSV,
	PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_SET,
	PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_CLR,
	PMIC_RG_BUCK_DLE_DCM,
	PMIC_RG_BUCK_INIS_SET,
	PMIC_RG_BUCK_SYNC_RSV,
	PMIC_RG_BUCK_STB_MAX,
	PMIC_RG_BUCK_VGP2_MINFREQ_LATENCY_MAX,
	PMIC_RG_BUCK_VGP2_MINFREQ_DURATION_MAX,
	PMIC_RG_BUCK_VBUCK1_OC_SDN_STATUS,
	PMIC_RG_BUCK_VBUCK2_OC_SDN_STATUS,
	PMIC_RG_BUCK_VBUCK3_OC_SDN_STATUS,
	PMIC_RG_BUCK_VBUCK4_OC_SDN_STATUS,
	PMIC_BUCK_TOP_WRITE_KEY,
	PMIC_BUCK_TOP_WRITE_KEY_H,
	PMIC_BUCK_VBUCK1_WDTDBG_VOSEL,
	PMIC_BUCK_VBUCK1_WDTDBG_VOSEL_LSB,
	PMIC_BUCK_VBUCK2_WDTDBG_VOSEL,
	PMIC_BUCK_VBUCK2_WDTDBG_VOSEL_LSB,
	PMIC_BUCK_VBUCK3_WDTDBG_VOSEL,
	PMIC_BUCK_VBUCK3_WDTDBG_VOSEL_LSB,
	PMIC_BUCK_VBUCK4_WDTDBG_VOSEL,
	PMIC_BUCK_VBUCK4_WDTDBG_VOSEL_LSB,
	PMIC_RGS_BUCK_TOP_DBG,
	PMIC_RG_BUCK_VBUCK1_EN,
	PMIC_RG_BUCK_VBUCK2_EN,
	PMIC_RG_BUCK_VBUCK3_EN,
	PMIC_RG_BUCK_VBUCK4_EN,
	PMIC_RG_BUCK_VBUCK_EN_SET,
	PMIC_RG_BUCK_VBUCK_EN_CLR,
	PMIC_RG_BUCK_VBUCK1_LP,
	PMIC_RG_BUCK_VBUCK2_LP,
	PMIC_RG_BUCK_VBUCK3_LP,
	PMIC_RG_BUCK_VBUCK4_LP,
	PMIC_RG_BUCK_VBUCK_LP_SET,
	PMIC_RG_BUCK_VBUCK_LP_CLR,
	PMIC_BUCK_TOP_ELR_LEN,
	PMIC_RG_BUCK_VBUCK1_VOSEL,
	PMIC_RG_BUCK_VBUCK1_VOSEL_LSB,
	PMIC_RG_BUCK_VBUCK2_VOSEL,
	PMIC_RG_BUCK_VBUCK2_VOSEL_LSB,
	PMIC_RG_BUCK_VBUCK3_VOSEL,
	PMIC_RG_BUCK_VBUCK3_VOSEL_LSB,
	PMIC_RG_BUCK_VBUCK4_VOSEL,
	PMIC_RG_BUCK_VBUCK4_VOSEL_LSB,
	PMIC_RG_BUCK_VBUCK1_OC_SDN_EN,
	PMIC_RG_BUCK_VBUCK2_OC_SDN_EN,
	PMIC_RG_BUCK_VBUCK3_OC_SDN_EN,
	PMIC_RG_BUCK_VBUCK4_OC_SDN_EN,
	PMIC_RG_BUCK_DCM_MODE,
	PMIC_RG_BUCK_VBUCK1_VOSEL_LIMIT_SEL,
	PMIC_RG_BUCK_VBUCK2_VOSEL_LIMIT_SEL,
	PMIC_RG_BUCK_VBUCK3_VOSEL_LIMIT_SEL,
	PMIC_RG_BUCK_VBUCK4_VOSEL_LIMIT_SEL,
	PMIC_RG_BUCK_VBUCK1_VOSEL_VLIMIT,
	PMIC_RG_BUCK_VBUCK2_VOSEL_VLIMIT,
	PMIC_RG_BUCK_VBUCK3_VOSEL_VLIMIT,
	PMIC_RG_BUCK_VBUCK4_VOSEL_VLIMIT,
	PMIC_RG_BUCK_VBUCK1_ONSC_TD,
	PMIC_RG_BUCK_VBUCK2_ONSC_TD,
	PMIC_RG_BUCK_VBUCK3_ONSC_TD,
	PMIC_RG_BUCK_VBUCK4_ONSC_TD,
	PMIC_RG_BUCK_EFUSE_RSV,
	PMIC_BUCK_VBUCK1_ANA_ID,
	PMIC_BUCK_VBUCK1_DIG_ID,
	PMIC_BUCK_VBUCK1_ANA_MINOR_REV,
	PMIC_BUCK_VBUCK1_ANA_MAJOR_REV,
	PMIC_BUCK_VBUCK1_DIG_MINOR_REV,
	PMIC_BUCK_VBUCK1_DIG_MAJOR_REV,
	PMIC_BUCK_VBUCK1_DSN_CBS,
	PMIC_BUCK_VBUCK1_DSN_BIX,
	PMIC_BUCK_VBUCK1_DSN_ESP,
	PMIC_BUCK_VBUCK1_DSN_FPI_SSHUB,
	PMIC_BUCK_VBUCK1_DSN_FPI_TRACKING,
	PMIC_BUCK_VBUCK1_DSN_FPI_PREOC,
	PMIC_BUCK_VBUCK1_DSN_FPI_VOTER,
	PMIC_BUCK_VBUCK1_DSN_FPI_ULTRASONIC,
	PMIC_BUCK_VBUCK1_DSN_FPI_DLC,
	PMIC_BUCK_VBUCK1_DSN_FPI_TRAP,
	PMIC_RG_BUCK_VBUCK1_VOSEL_SLEEP,
	PMIC_RG_BUCK_VBUCK1_VOSEL_SLEEP_LSB,
	PMIC_RG_BUCK_VBUCK1_SELR2R_CTRL,
	PMIC_RG_BUCK_VBUCK1_DVS_EN_MASK,
	PMIC_RG_BUCK_VBUCK1_DVS_UP_MASK,
	PMIC_RG_BUCK_VBUCK1_DVS_DOWN_MASK,
	PMIC_RG_BUCK_VBUCK1_SFCHG_RRATE,
	PMIC_RG_BUCK_VBUCK1_SFCHG_REN,
	PMIC_RG_BUCK_VBUCK1_SFCHG_FRATE,
	PMIC_RG_BUCK_VBUCK1_SFCHG_FEN,
	PMIC_RG_BUCK_VBUCK1_HW0_OP_EN,
	PMIC_RG_BUCK_VBUCK1_HW1_OP_EN,
	PMIC_RG_BUCK_VBUCK1_HW2_OP_EN,
	PMIC_RG_BUCK_VBUCK1_HW3_OP_EN,
	PMIC_RG_BUCK_VBUCK1_HW4_OP_EN,
	PMIC_RG_BUCK_VBUCK1_HW5_OP_EN,
	PMIC_RG_BUCK_VBUCK1_HW6_OP_EN,
	PMIC_RG_BUCK_VBUCK1_HW7_OP_EN,
	PMIC_RG_BUCK_VBUCK1_OP_EN_0_SET,
	PMIC_RG_BUCK_VBUCK1_OP_EN_0_CLR,
	PMIC_RG_BUCK_VBUCK1_SW_OP_EN,
	PMIC_RG_BUCK_VBUCK1_OP_EN_1_SET,
	PMIC_RG_BUCK_VBUCK1_OP_EN_1_CLR,
	PMIC_RG_BUCK_VBUCK1_HW0_OP_CFG,
	PMIC_RG_BUCK_VBUCK1_HW1_OP_CFG,
	PMIC_RG_BUCK_VBUCK1_HW2_OP_CFG,
	PMIC_RG_BUCK_VBUCK1_HW3_OP_CFG,
	PMIC_RG_BUCK_VBUCK1_HW4_OP_CFG,
	PMIC_RG_BUCK_VBUCK1_HW5_OP_CFG,
	PMIC_RG_BUCK_VBUCK1_HW6_OP_CFG,
	PMIC_RG_BUCK_VBUCK1_HW7_OP_CFG,
	PMIC_RG_BUCK_VBUCK1_OP_CFG_0_SET,
	PMIC_RG_BUCK_VBUCK1_OP_CFG_0_CLR,
	PMIC_RG_BUCK_VBUCK1_HW0_OP_MODE,
	PMIC_RG_BUCK_VBUCK1_HW1_OP_MODE,
	PMIC_RG_BUCK_VBUCK1_HW2_OP_MODE,
	PMIC_RG_BUCK_VBUCK1_HW3_OP_MODE,
	PMIC_RG_BUCK_VBUCK1_HW4_OP_MODE,
	PMIC_RG_BUCK_VBUCK1_HW5_OP_MODE,
	PMIC_RG_BUCK_VBUCK1_HW6_OP_MODE,
	PMIC_RG_BUCK_VBUCK1_HW7_OP_MODE,
	PMIC_RG_BUCK_VBUCK1_OP_MODE_0_SET,
	PMIC_RG_BUCK_VBUCK1_OP_MODE_0_CLR,
	PMIC_DA_VBUCK1_VOSEL,
	PMIC_DA_VBUCK1_VOSEL_LSB,
	PMIC_DA_VBUCK1_VOSEL_GRAY,
	PMIC_DA_VBUCK1_VOSEL_GRAY_LSB,
	PMIC_DA_VBUCK1_EN,
	PMIC_DA_VBUCK1_STB,
	PMIC_DA_VBUCK1_LOOP_SEL,
	PMIC_DA_VBUCK1_R2R_PDN,
	PMIC_DA_VBUCK1_DVS_EN,
	PMIC_DA_VBUCK1_DVS_UP,
	PMIC_DA_VBUCK1_DVS_DOWN,
	PMIC_DA_VBUCK1_SSH,
	PMIC_DA_VBUCK1_MINFREQ_DISCHARGE,
	PMIC_RG_BUCK_VBUCK1_CK_SW_MODE,
	PMIC_RG_BUCK_VBUCK1_CK_SW_EN,
	PMIC_RG_BUCK_VBUCK1_TRACK_STALL_BYPASS,
	PMIC_BUCK_VBUCK2_ANA_ID,
	PMIC_BUCK_VBUCK2_DIG_ID,
	PMIC_BUCK_VBUCK2_ANA_MINOR_REV,
	PMIC_BUCK_VBUCK2_ANA_MAJOR_REV,
	PMIC_BUCK_VBUCK2_DIG_MINOR_REV,
	PMIC_BUCK_VBUCK2_DIG_MAJOR_REV,
	PMIC_BUCK_VBUCK2_DSN_CBS,
	PMIC_BUCK_VBUCK2_DSN_BIX,
	PMIC_BUCK_VBUCK2_DSN_ESP,
	PMIC_BUCK_VBUCK2_DSN_FPI_SSHUB,
	PMIC_BUCK_VBUCK2_DSN_FPI_TRACKING,
	PMIC_BUCK_VBUCK2_DSN_FPI_PREOC,
	PMIC_BUCK_VBUCK2_DSN_FPI_VOTER,
	PMIC_BUCK_VBUCK2_DSN_FPI_ULTRASONIC,
	PMIC_BUCK_VBUCK2_DSN_FPI_DLC,
	PMIC_BUCK_VBUCK2_DSN_FPI_TRAP,
	PMIC_RG_BUCK_VBUCK2_VOSEL_SLEEP,
	PMIC_RG_BUCK_VBUCK2_VOSEL_SLEEP_LSB,
	PMIC_RG_BUCK_VBUCK2_SELR2R_CTRL,
	PMIC_RG_BUCK_VBUCK2_DVS_EN_MASK,
	PMIC_RG_BUCK_VBUCK2_DVS_UP_MASK,
	PMIC_RG_BUCK_VBUCK2_DVS_DOWN_MASK,
	PMIC_RG_BUCK_VBUCK2_SFCHG_RRATE,
	PMIC_RG_BUCK_VBUCK2_SFCHG_REN,
	PMIC_RG_BUCK_VBUCK2_SFCHG_FRATE,
	PMIC_RG_BUCK_VBUCK2_SFCHG_FEN,
	PMIC_RG_BUCK_VBUCK2_HW0_OP_EN,
	PMIC_RG_BUCK_VBUCK2_HW1_OP_EN,
	PMIC_RG_BUCK_VBUCK2_HW2_OP_EN,
	PMIC_RG_BUCK_VBUCK2_HW3_OP_EN,
	PMIC_RG_BUCK_VBUCK2_HW4_OP_EN,
	PMIC_RG_BUCK_VBUCK2_HW5_OP_EN,
	PMIC_RG_BUCK_VBUCK2_HW6_OP_EN,
	PMIC_RG_BUCK_VBUCK2_HW7_OP_EN,
	PMIC_RG_BUCK_VBUCK2_OP_EN_0_SET,
	PMIC_RG_BUCK_VBUCK2_OP_EN_0_CLR,
	PMIC_RG_BUCK_VBUCK2_SW_OP_EN,
	PMIC_RG_BUCK_VBUCK2_OP_EN_1_SET,
	PMIC_RG_BUCK_VBUCK2_OP_EN_1_CLR,
	PMIC_RG_BUCK_VBUCK2_HW0_OP_CFG,
	PMIC_RG_BUCK_VBUCK2_HW1_OP_CFG,
	PMIC_RG_BUCK_VBUCK2_HW2_OP_CFG,
	PMIC_RG_BUCK_VBUCK2_HW3_OP_CFG,
	PMIC_RG_BUCK_VBUCK2_HW4_OP_CFG,
	PMIC_RG_BUCK_VBUCK2_HW5_OP_CFG,
	PMIC_RG_BUCK_VBUCK2_HW6_OP_CFG,
	PMIC_RG_BUCK_VBUCK2_HW7_OP_CFG,
	PMIC_RG_BUCK_VBUCK2_OP_CFG_0_SET,
	PMIC_RG_BUCK_VBUCK2_OP_CFG_0_CLR,
	PMIC_RG_BUCK_VBUCK2_HW0_OP_MODE,
	PMIC_RG_BUCK_VBUCK2_HW1_OP_MODE,
	PMIC_RG_BUCK_VBUCK2_HW2_OP_MODE,
	PMIC_RG_BUCK_VBUCK2_HW3_OP_MODE,
	PMIC_RG_BUCK_VBUCK2_HW4_OP_MODE,
	PMIC_RG_BUCK_VBUCK2_HW5_OP_MODE,
	PMIC_RG_BUCK_VBUCK2_HW6_OP_MODE,
	PMIC_RG_BUCK_VBUCK2_HW7_OP_MODE,
	PMIC_RG_BUCK_VBUCK2_OP_MODE_0_SET,
	PMIC_RG_BUCK_VBUCK2_OP_MODE_0_CLR,
	PMIC_DA_VBUCK2_VOSEL,
	PMIC_DA_VBUCK2_VOSEL_LSB,
	PMIC_DA_VBUCK2_VOSEL_GRAY,
	PMIC_DA_VBUCK2_VOSEL_GRAY_LSB,
	PMIC_DA_VBUCK2_EN,
	PMIC_DA_VBUCK2_STB,
	PMIC_DA_VBUCK2_LOOP_SEL,
	PMIC_DA_VBUCK2_R2R_PDN,
	PMIC_DA_VBUCK2_DVS_EN,
	PMIC_DA_VBUCK2_DVS_UP,
	PMIC_DA_VBUCK2_DVS_DOWN,
	PMIC_DA_VBUCK2_SSH,
	PMIC_DA_VBUCK2_MINFREQ_DISCHARGE,
	PMIC_RG_BUCK_VBUCK2_CK_SW_MODE,
	PMIC_RG_BUCK_VBUCK2_CK_SW_EN,
	PMIC_RG_BUCK_VBUCK2_TRACK_STALL_BYPASS,
	PMIC_BUCK_VBUCK3_ANA_ID,
	PMIC_BUCK_VBUCK3_DIG_ID,
	PMIC_BUCK_VBUCK3_ANA_MINOR_REV,
	PMIC_BUCK_VBUCK3_ANA_MAJOR_REV,
	PMIC_BUCK_VBUCK3_DIG_MINOR_REV,
	PMIC_BUCK_VBUCK3_DIG_MAJOR_REV,
	PMIC_BUCK_VBUCK3_DSN_CBS,
	PMIC_BUCK_VBUCK3_DSN_BIX,
	PMIC_BUCK_VBUCK3_DSN_ESP,
	PMIC_BUCK_VBUCK3_DSN_FPI_SSHUB,
	PMIC_BUCK_VBUCK3_DSN_FPI_TRACKING,
	PMIC_BUCK_VBUCK3_DSN_FPI_PREOC,
	PMIC_BUCK_VBUCK3_DSN_FPI_VOTER,
	PMIC_BUCK_VBUCK3_DSN_FPI_ULTRASONIC,
	PMIC_BUCK_VBUCK3_DSN_FPI_DLC,
	PMIC_BUCK_VBUCK3_DSN_FPI_TRAP,
	PMIC_RG_BUCK_VBUCK3_VOSEL_SLEEP,
	PMIC_RG_BUCK_VBUCK3_VOSEL_SLEEP_LSB,
	PMIC_RG_BUCK_VBUCK3_SELR2R_CTRL,
	PMIC_RG_BUCK_VBUCK3_DVS_EN_MASK,
	PMIC_RG_BUCK_VBUCK3_DVS_UP_MASK,
	PMIC_RG_BUCK_VBUCK3_DVS_DOWN_MASK,
	PMIC_RG_BUCK_VBUCK3_SFCHG_RRATE,
	PMIC_RG_BUCK_VBUCK3_SFCHG_REN,
	PMIC_RG_BUCK_VBUCK3_SFCHG_FRATE,
	PMIC_RG_BUCK_VBUCK3_SFCHG_FEN,
	PMIC_RG_BUCK_VBUCK3_HW0_OP_EN,
	PMIC_RG_BUCK_VBUCK3_HW1_OP_EN,
	PMIC_RG_BUCK_VBUCK3_HW2_OP_EN,
	PMIC_RG_BUCK_VBUCK3_HW3_OP_EN,
	PMIC_RG_BUCK_VBUCK3_HW4_OP_EN,
	PMIC_RG_BUCK_VBUCK3_HW5_OP_EN,
	PMIC_RG_BUCK_VBUCK3_HW6_OP_EN,
	PMIC_RG_BUCK_VBUCK3_HW7_OP_EN,
	PMIC_RG_BUCK_VBUCK3_OP_EN_0_SET,
	PMIC_RG_BUCK_VBUCK3_OP_EN_0_CLR,
	PMIC_RG_BUCK_VBUCK3_SW_OP_EN,
	PMIC_RG_BUCK_VBUCK3_OP_EN_1_SET,
	PMIC_RG_BUCK_VBUCK3_OP_EN_1_CLR,
	PMIC_RG_BUCK_VBUCK3_HW0_OP_CFG,
	PMIC_RG_BUCK_VBUCK3_HW1_OP_CFG,
	PMIC_RG_BUCK_VBUCK3_HW2_OP_CFG,
	PMIC_RG_BUCK_VBUCK3_HW3_OP_CFG,
	PMIC_RG_BUCK_VBUCK3_HW4_OP_CFG,
	PMIC_RG_BUCK_VBUCK3_HW5_OP_CFG,
	PMIC_RG_BUCK_VBUCK3_HW6_OP_CFG,
	PMIC_RG_BUCK_VBUCK3_HW7_OP_CFG,
	PMIC_RG_BUCK_VBUCK3_OP_CFG_0_SET,
	PMIC_RG_BUCK_VBUCK3_OP_CFG_0_CLR,
	PMIC_RG_BUCK_VBUCK3_HW0_OP_MODE,
	PMIC_RG_BUCK_VBUCK3_HW1_OP_MODE,
	PMIC_RG_BUCK_VBUCK3_HW2_OP_MODE,
	PMIC_RG_BUCK_VBUCK3_HW3_OP_MODE,
	PMIC_RG_BUCK_VBUCK3_HW4_OP_MODE,
	PMIC_RG_BUCK_VBUCK3_HW5_OP_MODE,
	PMIC_RG_BUCK_VBUCK3_HW6_OP_MODE,
	PMIC_RG_BUCK_VBUCK3_HW7_OP_MODE,
	PMIC_RG_BUCK_VBUCK3_OP_MODE_0_SET,
	PMIC_RG_BUCK_VBUCK3_OP_MODE_0_CLR,
	PMIC_DA_VBUCK3_VOSEL,
	PMIC_DA_VBUCK3_VOSEL_LSB,
	PMIC_DA_VBUCK3_VOSEL_GRAY,
	PMIC_DA_VBUCK3_VOSEL_GRAY_LSB,
	PMIC_DA_VBUCK3_EN,
	PMIC_DA_VBUCK3_STB,
	PMIC_DA_VBUCK3_LOOP_SEL,
	PMIC_DA_VBUCK3_R2R_PDN,
	PMIC_DA_VBUCK3_DVS_EN,
	PMIC_DA_VBUCK3_DVS_UP,
	PMIC_DA_VBUCK3_DVS_DOWN,
	PMIC_DA_VBUCK3_SSH,
	PMIC_DA_VBUCK3_MINFREQ_DISCHARGE,
	PMIC_RG_BUCK_VBUCK3_CK_SW_MODE,
	PMIC_RG_BUCK_VBUCK3_CK_SW_EN,
	PMIC_RG_BUCK_VBUCK3_TRACK_EN,
	PMIC_RG_BUCK_VBUCK3_TRACK_MODE,
	PMIC_RG_BUCK_VBUCK3_VOSEL_DELTA,
	PMIC_RG_BUCK_VBUCK3_VOSEL_OFFSET,
	PMIC_RG_BUCK_VBUCK3_VOSEL_LB,
	PMIC_RG_BUCK_VBUCK3_VOSEL_HB,
	PMIC_BUCK_VBUCK4_ANA_ID,
	PMIC_BUCK_VBUCK4_DIG_ID,
	PMIC_BUCK_VBUCK4_ANA_MINOR_REV,
	PMIC_BUCK_VBUCK4_ANA_MAJOR_REV,
	PMIC_BUCK_VBUCK4_DIG_MINOR_REV,
	PMIC_BUCK_VBUCK4_DIG_MAJOR_REV,
	PMIC_BUCK_VBUCK4_DSN_CBS,
	PMIC_BUCK_VBUCK4_DSN_BIX,
	PMIC_BUCK_VBUCK4_DSN_ESP,
	PMIC_BUCK_VBUCK4_DSN_FPI_SSHUB,
	PMIC_BUCK_VBUCK4_DSN_FPI_TRACKING,
	PMIC_BUCK_VBUCK4_DSN_FPI_PREOC,
	PMIC_BUCK_VBUCK4_DSN_FPI_VOTER,
	PMIC_BUCK_VBUCK4_DSN_FPI_ULTRASONIC,
	PMIC_BUCK_VBUCK4_DSN_FPI_DLC,
	PMIC_BUCK_VBUCK4_DSN_FPI_TRAP,
	PMIC_RG_BUCK_VBUCK4_VOSEL_SLEEP,
	PMIC_RG_BUCK_VBUCK4_VOSEL_SLEEP_LSB,
	PMIC_RG_BUCK_VBUCK4_SELR2R_CTRL,
	PMIC_RG_BUCK_VBUCK4_DVS_EN_MASK,
	PMIC_RG_BUCK_VBUCK4_DVS_UP_MASK,
	PMIC_RG_BUCK_VBUCK4_DVS_DOWN_MASK,
	PMIC_RG_BUCK_VBUCK4_SFCHG_RRATE,
	PMIC_RG_BUCK_VBUCK4_SFCHG_REN,
	PMIC_RG_BUCK_VBUCK4_SFCHG_FRATE,
	PMIC_RG_BUCK_VBUCK4_SFCHG_FEN,
	PMIC_RG_BUCK_VBUCK4_HW0_OP_EN,
	PMIC_RG_BUCK_VBUCK4_HW1_OP_EN,
	PMIC_RG_BUCK_VBUCK4_HW2_OP_EN,
	PMIC_RG_BUCK_VBUCK4_HW3_OP_EN,
	PMIC_RG_BUCK_VBUCK4_HW4_OP_EN,
	PMIC_RG_BUCK_VBUCK4_HW5_OP_EN,
	PMIC_RG_BUCK_VBUCK4_HW6_OP_EN,
	PMIC_RG_BUCK_VBUCK4_HW7_OP_EN,
	PMIC_RG_BUCK_VBUCK4_OP_EN_0_SET,
	PMIC_RG_BUCK_VBUCK4_OP_EN_0_CLR,
	PMIC_RG_BUCK_VBUCK4_SW_OP_EN,
	PMIC_RG_BUCK_VBUCK4_OP_EN_1_SET,
	PMIC_RG_BUCK_VBUCK4_OP_EN_1_CLR,
	PMIC_RG_BUCK_VBUCK4_HW0_OP_CFG,
	PMIC_RG_BUCK_VBUCK4_HW1_OP_CFG,
	PMIC_RG_BUCK_VBUCK4_HW2_OP_CFG,
	PMIC_RG_BUCK_VBUCK4_HW3_OP_CFG,
	PMIC_RG_BUCK_VBUCK4_HW4_OP_CFG,
	PMIC_RG_BUCK_VBUCK4_HW5_OP_CFG,
	PMIC_RG_BUCK_VBUCK4_HW6_OP_CFG,
	PMIC_RG_BUCK_VBUCK4_HW7_OP_CFG,
	PMIC_RG_BUCK_VBUCK4_OP_CFG_0_SET,
	PMIC_RG_BUCK_VBUCK4_OP_CFG_0_CLR,
	PMIC_RG_BUCK_VBUCK4_HW0_OP_MODE,
	PMIC_RG_BUCK_VBUCK4_HW1_OP_MODE,
	PMIC_RG_BUCK_VBUCK4_HW2_OP_MODE,
	PMIC_RG_BUCK_VBUCK4_HW3_OP_MODE,
	PMIC_RG_BUCK_VBUCK4_HW4_OP_MODE,
	PMIC_RG_BUCK_VBUCK4_HW5_OP_MODE,
	PMIC_RG_BUCK_VBUCK4_HW6_OP_MODE,
	PMIC_RG_BUCK_VBUCK4_HW7_OP_MODE,
	PMIC_RG_BUCK_VBUCK4_OP_MODE_0_SET,
	PMIC_RG_BUCK_VBUCK4_OP_MODE_0_CLR,
	PMIC_DA_VBUCK4_VOSEL,
	PMIC_DA_VBUCK4_VOSEL_LSB,
	PMIC_DA_VBUCK4_VOSEL_GRAY,
	PMIC_DA_VBUCK4_VOSEL_GRAY_LSB,
	PMIC_DA_VBUCK4_EN,
	PMIC_DA_VBUCK4_STB,
	PMIC_DA_VBUCK4_LOOP_SEL,
	PMIC_DA_VBUCK4_R2R_PDN,
	PMIC_DA_VBUCK4_DVS_EN,
	PMIC_DA_VBUCK4_DVS_UP,
	PMIC_DA_VBUCK4_DVS_DOWN,
	PMIC_DA_VBUCK4_SSH,
	PMIC_DA_VBUCK4_MINFREQ_DISCHARGE,
	PMIC_RG_BUCK_VBUCK4_CK_SW_MODE,
	PMIC_RG_BUCK_VBUCK4_CK_SW_EN,
	PMIC_RG_BUCK_VBUCK4_TRACK_EN,
	PMIC_RG_BUCK_VBUCK4_TRACK_MODE,
	PMIC_RG_BUCK_VBUCK4_TRACK_CFG,
	PMIC_RG_BUCK_VBUCK4_VOSEL_DELTA,
	PMIC_RG_BUCK_VBUCK4_VOSEL_OFFSET,
	PMIC_RG_BUCK_VBUCK4_VOSEL_LB,
	PMIC_RG_BUCK_VBUCK4_VOSEL_HB,
	PMIC_BUCK_ANA0_ANA_ID,
	PMIC_BUCK_ANA0_DIG_ID,
	PMIC_BUCK_ANA0_ANA_MINOR_REV,
	PMIC_BUCK_ANA0_ANA_MAJOR_REV,
	PMIC_BUCK_ANA0_DIG_MINOR_REV,
	PMIC_BUCK_ANA0_DIG_MAJOR_REV,
	PMIC_BUCK_ANA0_CBS,
	PMIC_BUCK_ANA0_BIX,
	PMIC_BUCK_ANA0_ESP,
	PMIC_BUCK_ANA0_FPI,
	PMIC_RG_VBUCK1_NDIS_EN,
	PMIC_RG_VBUCK1_SLEEP_TIME,
	PMIC_RG_VBUCK1_LOOPSEL_DIS,
	PMIC_RG_VBUCK1_OVP_EN,
	PMIC_RG_VBUCK1_OVP_VREFSEL,
	PMIC_RG_VBUCK1_TB_DIS,
	PMIC_RG_VBUCK1_TB_PFM_OFF,
	PMIC_RG_VBUCK1_TB_VREFSEL,
	PMIC_RG_VBUCK1_TON_EXTEND_EN,
	PMIC_RG_VBUCK1_VBAT_LOW_DIS,
	PMIC_RG_VBUCK1_VBAT_HI_DIS,
	PMIC_RG_VBUCK1_VOUT_HI_DIS,
	PMIC_RG_VBUCK1_FUGON,
	PMIC_RG_VBUCK1_FLGON,
	PMIC_RG_VBUCK1_RAMP_AC,
	PMIC_RG_VBUCK1_URT_EN,
	PMIC_RG_VBUCK1_RETENTION_EN,
	PMIC_RG_VBUCK1_SONIC_EN,
	PMIC_RG_VBUCK1_GROUNDSEL,
	PMIC_RG_VBUCK1_DLC,
	PMIC_RG_VBUCK1_RCB,
	PMIC_RG_VBUCK1_UG_SR,
	PMIC_RG_VBUCK1_LG_SR,
	PMIC_RG_VBUCK1_ECOT_EN,
	PMIC_RG_VBUCK1_OCP,
	PMIC_RG_VBUCK1_OCN,
	PMIC_RG_VBUCK1_DUMMY_LOAD_EN,
	PMIC_RG_VBUCK1_RON_TM,
	PMIC_RG_VBUCK1_DIGMON_SEL,
	PMIC_RGS_VBUCK1_OC_STATUS,
	PMIC_RGS_VBUCK1_DIG_MON,
	PMIC_RG_VBUCK1_UG_ONSR,
	PMIC_RG_VBUCK1_LXRON,
	PMIC_RG_VBUCK1_RSVH,
	PMIC_RG_VBUCK1_RSVL,
	PMIC_RG_VBUCK1_TM,
	PMIC_RG_VBUCK1_TM_KEY,
	PMIC_RG_VBUCK2_NDIS_EN,
	PMIC_RG_VBUCK2_SLEEP_TIME,
	PMIC_RG_VBUCK2_LOOPSEL_DIS,
	PMIC_RG_VBUCK2_OVP_EN,
	PMIC_RG_VBUCK2_OVP_VREFSEL,
	PMIC_RG_VBUCK2_TB_DIS,
	PMIC_RG_VBUCK2_TB_PFM_OFF,
	PMIC_RG_VBUCK2_TB_VREFSEL,
	PMIC_RG_VBUCK2_TON_EXTEND_EN,
	PMIC_RG_VBUCK2_VBAT_LOW_DIS,
	PMIC_RG_VBUCK2_VBAT_HI_DIS,
	PMIC_RG_VBUCK2_VOUT_HI_DIS,
	PMIC_RG_VBUCK2_FUGON,
	PMIC_RG_VBUCK2_FLGON,
	PMIC_RG_VBUCK2_RAMP_AC,
	PMIC_RG_VBUCK2_URT_EN,
	PMIC_RG_VBUCK2_RETENTION_EN,
	PMIC_RG_VBUCK2_SONIC_EN,
	PMIC_RG_VBUCK2_GROUNDSEL,
	PMIC_RG_VBUCK2_DLC,
	PMIC_RG_VBUCK2_RCB,
	PMIC_RG_VBUCK2_UG_SR,
	PMIC_RG_VBUCK2_LG_SR,
	PMIC_RG_VBUCK2_ECOT_EN,
	PMIC_RG_VBUCK2_OCP,
	PMIC_RG_VBUCK2_OCN,
	PMIC_RG_VBUCK2_DUMMY_LOAD_EN,
	PMIC_RG_VBUCK2_RON_TM,
	PMIC_RG_VBUCK2_DIGMON_SEL,
	PMIC_RGS_VBUCK2_OC_STATUS,
	PMIC_RGS_VBUCK2_DIG_MON,
	PMIC_RG_VBUCK2_UG_ONSR,
	PMIC_RG_VBUCK2_LXRON,
	PMIC_RG_VBUCK2_RSVH,
	PMIC_RG_VBUCK2_RSVL,
	PMIC_RG_VBUCK2_TM,
	PMIC_RG_VBUCK2_TM_KEY,
	PMIC_RG_VBUCK3_NDIS_EN,
	PMIC_RG_VBUCK3_SLEEP_TIME,
	PMIC_RG_VBUCK3_LOOPSEL_DIS,
	PMIC_RG_VBUCK3_OVP_EN,
	PMIC_RG_VBUCK3_OVP_VREFSEL,
	PMIC_RG_VBUCK3_TB_DIS,
	PMIC_RG_VBUCK3_TB_PFM_OFF,
	PMIC_RG_VBUCK3_TB_VREFSEL,
	PMIC_RG_VBUCK3_TON_EXTEND_EN,
	PMIC_RG_VBUCK3_VBAT_LOW_DIS,
	PMIC_RG_VBUCK3_VBAT_HI_DIS,
	PMIC_RG_VBUCK3_VOUT_HI_DIS,
	PMIC_RG_VBUCK3_FUGON,
	PMIC_RG_VBUCK3_FLGON,
	PMIC_RG_VBUCK3_RAMP_AC,
	PMIC_RG_VBUCK3_URT_EN,
	PMIC_RG_VBUCK3_RETENTION_EN,
	PMIC_RG_VBUCK3_SONIC_EN,
	PMIC_RG_VBUCK3_GROUNDSEL,
	PMIC_RG_VBUCK3_DLC,
	PMIC_RG_VBUCK3_RCB,
	PMIC_RG_VBUCK3_UG_SR,
	PMIC_RG_VBUCK3_LG_SR,
	PMIC_RG_VBUCK3_ECOT_EN,
	PMIC_RG_VBUCK3_OCP,
	PMIC_RG_VBUCK3_OCN,
	PMIC_RG_VBUCK3_DUMMY_LOAD_EN,
	PMIC_RG_VBUCK3_RON_TM,
	PMIC_RG_VBUCK3_DIGMON_SEL,
	PMIC_RGS_VBUCK3_OC_STATUS,
	PMIC_RGS_VBUCK3_DIG_MON,
	PMIC_RG_VBUCK3_UG_ONSR,
	PMIC_RG_VBUCK3_LXRON,
	PMIC_RG_VBUCK3_RSVH,
	PMIC_RG_VBUCK3_RSVL,
	PMIC_RG_VBUCK3_TM,
	PMIC_RG_VBUCK3_TM_KEY,
	PMIC_RG_VBUCK4_NDIS_EN,
	PMIC_RG_VBUCK4_SLEEP_TIME,
	PMIC_RG_VBUCK4_LOOPSEL_DIS,
	PMIC_RG_VBUCK4_OVP_EN,
	PMIC_RG_VBUCK4_OVP_VREFSEL,
	PMIC_RG_VBUCK4_TB_DIS,
	PMIC_RG_VBUCK4_TB_PFM_OFF,
	PMIC_RG_VBUCK4_TB_VREFSEL,
	PMIC_RG_VBUCK4_TON_EXTEND_EN,
	PMIC_RG_VBUCK4_VBAT_LOW_DIS,
	PMIC_RG_VBUCK4_VBAT_HI_DIS,
	PMIC_RG_VBUCK4_VOUT_HI_DIS,
	PMIC_RG_VBUCK4_FUGON,
	PMIC_RG_VBUCK4_FLGON,
	PMIC_RG_VBUCK4_RAMP_AC,
	PMIC_RG_VBUCK4_URT_EN,
	PMIC_RG_VBUCK4_RETENTION_EN,
	PMIC_RG_VBUCK4_SONIC_EN,
	PMIC_RG_VBUCK4_GROUNDSEL,
	PMIC_RG_VBUCK4_DLC,
	PMIC_RG_VBUCK4_RCB,
	PMIC_RG_VBUCK4_UG_SR,
	PMIC_RG_VBUCK4_LG_SR,
	PMIC_RG_VBUCK4_ECOT_EN,
	PMIC_RG_VBUCK4_OCP,
	PMIC_RG_VBUCK4_OCN,
	PMIC_RG_VBUCK4_DUMMY_LOAD_EN,
	PMIC_RG_VBUCK4_RON_TM,
	PMIC_RG_VBUCK4_DIGMON_SEL,
	PMIC_RGS_VBUCK4_OC_STATUS,
	PMIC_RGS_VBUCK4_DIG_MON,
	PMIC_RG_VBUCK4_UG_ONSR,
	PMIC_RG_VBUCK4_LXRON,
	PMIC_RG_VBUCK4_RSVH,
	PMIC_RG_VBUCK4_RSVL,
	PMIC_RG_VBUCK4_TM,
	PMIC_RG_VBUCK4_TM_KEY,
	PMIC_RG_VBUCK1234_TMDL,
	PMIC_RG_VBUCK1234_SR_VBAT,
	PMIC_RG_4PH_CONFIG_LAT_RSVH,
	PMIC_RG_4PH_RECONFIG_RSVH,
	PMIC_RG_4PH_RECONFIG_EN,
	PMIC_RGS_4PH1_VBUCK1_DIGCFG_EN,
	PMIC_RGS_4PH2_VBUCK2_DIGCFG_EN,
	PMIC_RGS_4PH3_VBUCK3_DIGCFG_EN,
	PMIC_RGS_4PH4_VBUCK4_DIGCFG_EN,
	PMIC_RG_VBUCK1_FCCM,
	PMIC_RG_VBUCK2_FCCM,
	PMIC_RG_VBUCK3_FCCM,
	PMIC_RG_VBUCK4_FCCM,
	PMIC_BUCK_ANA0_ELR_LEN,
	PMIC_RG_VBUCK1_ZC_TRIM,
	PMIC_RG_VBUCK1_CCOMP,
	PMIC_RG_VBUCK1_NLIM_TRIM,
	PMIC_RG_VBUCK1_RCOMP,
	PMIC_RG_VBUCK1_TON_TRIM,
	PMIC_RG_VBUCK1_FB_D2,
	PMIC_RG_VBUCK1_PFM_PEAK,
	PMIC_RG_VBUCK1_SONIC_PFM_PEAK,
	PMIC_RG_VBUCK1_ECOT_TRIM,
	PMIC_RG_VBUCK1_CSNSLP_TRIM,
	PMIC_RG_VBUCK1_CSPSLP_TRIM,
	PMIC_RG_VBUCK1_RAMP_SLP,
	PMIC_RG_VBUCK1_DRIVER_SR_TRIM,
	PMIC_RG_VBUCK1_OC_D2P5,
	PMIC_RG_VBUCK1_RSV_EFUSE,
	PMIC_RG_VBUCK2_ZC_TRIM,
	PMIC_RG_VBUCK2_CCOMP,
	PMIC_RG_VBUCK2_NLIM_TRIM,
	PMIC_RG_VBUCK2_RCOMP,
	PMIC_RG_VBUCK2_TON_TRIM,
	PMIC_RG_VBUCK2_FB_D2,
	PMIC_RG_VBUCK2_PFM_PEAK,
	PMIC_RG_VBUCK2_SONIC_PFM_PEAK,
	PMIC_RG_VBUCK2_ECOT_TRIM,
	PMIC_RG_VBUCK2_CSNSLP_TRIM,
	PMIC_RG_VBUCK2_CSPSLP_TRIM,
	PMIC_RG_VBUCK2_RAMP_SLP,
	PMIC_RG_VBUCK2_DRIVER_SR_TRIM,
	PMIC_RG_VBUCK2_OC_D2P5,
	PMIC_RG_VBUCK2_RSV_EFUSE,
	PMIC_RG_VBUCK3_ZC_TRIM,
	PMIC_RG_VBUCK3_CCOMP,
	PMIC_RG_VBUCK3_NLIM_TRIM,
	PMIC_RG_VBUCK3_RCOMP,
	PMIC_RG_VBUCK3_TON_TRIM,
	PMIC_RG_VBUCK3_FB_D2,
	PMIC_RG_VBUCK3_PFM_PEAK,
	PMIC_RG_VBUCK3_SONIC_PFM_PEAK,
	PMIC_RG_VBUCK3_ECOT_TRIM,
	PMIC_RG_VBUCK3_CSNSLP_TRIM,
	PMIC_RG_VBUCK3_CSPSLP_TRIM,
	PMIC_RG_VBUCK3_RAMP_SLP,
	PMIC_RG_VBUCK3_DRIVER_SR_TRIM,
	PMIC_RG_VBUCK3_OC_D2P5,
	PMIC_RG_VBUCK3_RSV_EFUSE,
	PMIC_RG_VBUCK4_ZC_TRIM,
	PMIC_RG_VBUCK4_CCOMP,
	PMIC_RG_VBUCK4_NLIM_TRIM,
	PMIC_RG_VBUCK4_RCOMP,
	PMIC_RG_VBUCK4_TON_TRIM,
	PMIC_RG_VBUCK4_FB_D2,
	PMIC_RG_VBUCK4_PFM_PEAK,
	PMIC_RG_VBUCK4_SONIC_PFM_PEAK,
	PMIC_RG_VBUCK4_ECOT_TRIM,
	PMIC_RG_VBUCK4_CSNSLP_TRIM,
	PMIC_RG_VBUCK4_CSPSLP_TRIM,
	PMIC_RG_VBUCK4_RAMP_SLP,
	PMIC_RG_VBUCK4_DRIVER_SR_TRIM,
	PMIC_RG_VBUCK4_OC_D2P5,
	PMIC_RG_VBUCK4_RSV_EFUSE,
	PMIC_RG_4PH_CONFIG1,
	PMIC_RG_4PH_CONFIG2,
	PMIC_RG_4PH_CONFIG3,
	PMIC_RG_4PH_23PHIN_TRIM,
	PMIC_RG_4PH_34PHIN_TRIM,
	PMU_COMMAND_MAX
};

struct pmu_flag_table_entry_t {
	enum PMU_FLAGS_LIST flagname;
	unsigned short offset;
	unsigned short mask;
	unsigned char shift;
};
#endif

#endif		/* _MT_PMIC_UPMU_HW_MT6315_H_ */
