#ifndef __LINUX_REGULATOR_MT6330_H_
#define __LINUX_REGULATOR_MT6330_H_

#include <typedefs.h>
#include "pal_log.h"

#define PMIC_PRELOADER 1
#define LDO_SUPPORT
#define LDO_VOTRIM_SUPPORT
#define MT6330_DEBUG 1

#if MT6330_DEBUG
#define PMUTAG                "[MT6330] "
#define mreg_dbg_print(fmt, arg...) dbg_print(PMUTAG fmt, ##arg)
#else
#define mreg_dbg_print(...) do { } while(0)
#endif

enum {
	MTK_REGULATOR_VMD12,
	MTK_REGULATOR_VRFDIG,
	MTK_REGULATOR_VCORE,
	MTK_REGULATOR_VMD11,
	MTK_REGULATOR_VSRAM_MD,
	MTK_REGULATOR_VSRAM_CORE,
	MTK_REGULATOR_VSRAM_PROC,
	MTK_REGULATOR_VSRAM_RFDIG,
#ifdef LDO_SUPPORT
	MTK_REGULATOR_VIO18_2,
	MTK_REGULATOR_LDO_SUPPORT = MTK_REGULATOR_VIO18_2,
	MTK_REGULATOR_VMDD2,
	MTK_REGULATOR_VEFUSE,
	MTK_REGULATOR_VIO18_1,
	MTK_REGULATOR_VMDDR,
	MTK_REGULATOR_VMDDQ,
#endif /*--LDO_SUPPORT--*/
#ifdef EXT_BUCK_MT6315
	MTK_REGULATOR_MT6315_5_VBUCK1,
	MTK_REGULATOR_MT6315_5_VBUCK3,
#endif
	MTK_REGULATOR_MAX_NR,
};

typedef enum {
	DISABLE_REGULATOR,
	ENABLE_REGULATOR,
} enset;

typedef enum {
	AUTOMODE,
	PWMMODE,
} modeset;

#ifdef LDO_SUPPORT
typedef enum {
	VOLTOSEL,
	SELTOVOL,
} volseltran;
#endif /*--LDO_SUPPORT--*/

#ifdef LDO_VOTRIM_SUPPORT
typedef enum {
	TRIMTOSEL,
	SELTOTRIM,
} trimseltran;
#endif /*--LDO_VOTRIM_SUPPORT--*/

typedef enum {
	NON_REGULAR_VOLTAGE,
	FIXED_REGULAR_VOLTAGE,
	REGULAR_VOLTAGE,
} regulator_type;

#ifdef LDO_VOTRIM_SUPPORT
struct mt6330_ldo_trim_info {
	unsigned short trim_reg;
	unsigned short trim_mask;
	unsigned short trim_shift;
	const void *trim_voltages;
	unsigned int trim_size;
};
#endif /*--LDO_VOTRIM_SUPPORT--*/

#ifdef LDO_SUPPORT
static unsigned int mt6330_ldo_convert_data(unsigned char id,
	unsigned int cnvdata, volseltran transtype);

struct mt6330_ldo_info {
	const void *pvoltages;
	const void *idxs;
	unsigned int n_size;
};
#endif /*--LDO_SUPPORT--*/

/*--abstrac the same parameter--*/
struct mt6330_regulator_info {
	unsigned int min_uV;
	unsigned int max_uV;
	unsigned short vol_reg;
	unsigned short vol_mask;
	unsigned short vol_shift;
	unsigned short da_vol_reg;
	unsigned short da_vol_mask;
	unsigned short da_vol_shift;
	unsigned short vocal_reg;
	unsigned short vocal_mask;
	unsigned short vocal_shift;
	unsigned short enable_reg;
	unsigned short enable_shift;
	unsigned short mode_reg;
	unsigned short mode_shift;
#ifdef LDO_SUPPORT
	struct mt6330_ldo_info *extinfo;
#endif /*--LDO_SUPPORT--*/
#ifdef LDO_VOTRIM_SUPPORT
	struct mt6330_ldo_trim_info *triminfo;
#endif /*--LDO_VOTRIM_SUPPORT--*/
	unsigned short step_uV;
	regulator_type rtype;
};

extern void mt6330_wdtdbg_vosel(void);
extern int mt6330_probe(void);

#ifdef LDO_VOTRIM_SUPPORT
#define mt6330_ldo_trim_decl(_name, trim_array)\
{ \
	.trim_reg = _name##_trim_reg, \
	.trim_mask = _name##_trim_mask, \
	.trim_shift = _name##_trim_shift, \
	.trim_voltages = (void *)(trim_array), \
	.trim_size = ARRAY_SIZE(trim_array),    \
}
#endif /*--LDO_VOTRIM_SUPPORT--*/

#ifdef LDO_SUPPORT
#define mt6330_ldo_decl(volt_array, idx_array)\
{ \
	.pvoltages = (void *)(volt_array), \
	.idxs = (void *)(idx_array), \
	.n_size = ARRAY_SIZE(volt_array),   \
}
#endif /*--LDO_SUPPORT--*/

#define mt6330_decl(_name)\
{ \
	.min_uV = _name##_min_uV, \
	.max_uV = _name##_max_uV, \
	.vol_reg = _name##_vol_reg, \
	.vol_mask = _name##_vol_mask, \
	.vol_shift = _name##_vol_shift, \
	.da_vol_reg = _name##_da_vol_reg, \
	.da_vol_mask = _name##_da_vol_mask, \
	.da_vol_shift = _name##_da_vol_shift, \
	.vocal_reg = _name##_vocal_reg, \
	.vocal_mask = _name##_vocal_mask, \
	.vocal_shift = _name##_vocal_shift, \
	.enable_reg = _name##_enable_reg, \
	.enable_shift = _name##_enable_shift, \
	.mode_reg = _name##_mode_reg, \
	.mode_shift = _name##_mode_shift, \
	.step_uV = _name##_step_uV, \
	.rtype = _name##_volt_type, \
}

/* -------Code Gen Start-------*/
#define vmd12_vol_reg                   PMIC_RG_BUCK_VMD12_VOSEL_ADDR
#define vmd12_vol_mask                  PMIC_RG_BUCK_VMD12_VOSEL_MASK
#define vmd12_vol_shift                 PMIC_RG_BUCK_VMD12_VOSEL_SHIFT
#define vmd12_da_vol_reg                PMIC_DA_VMD12_VOSEL_ADDR
#define vmd12_da_vol_mask               PMIC_DA_VMD12_VOSEL_MASK
#define vmd12_da_vol_shift              PMIC_DA_VMD12_VOSEL_SHIFT
#define vmd12_vocal_reg                 0
#define vmd12_vocal_mask                0
#define vmd12_vocal_shift               0
#define vmd12_enable_reg                PMIC_RG_BUCK_VMD12_EN_ADDR
#define vmd12_enable_shift              PMIC_RG_BUCK_VMD12_EN_SHIFT
#define vmd12_mode_reg                  PMIC_RG_VMD12_FCCM_ADDR
#define vmd12_mode_shift                PMIC_RG_VMD12_FCCM_SHIFT
#define vmd12_trim_reg                  0
#define vmd12_trim_mask                 0
#define vmd12_trim_shift                0
#define vmd12_min_uV                    400000
#define vmd12_max_uV                    1193750
#define vmd12_step_uV                   6250
#define vmd12_volt_type                 REGULAR_VOLTAGE
#define vmd12_stb                       200


#define vrfdig_vol_reg                  PMIC_RG_BUCK_VRFDIG_VOSEL_ADDR
#define vrfdig_vol_mask                 PMIC_RG_BUCK_VRFDIG_VOSEL_MASK
#define vrfdig_vol_shift                PMIC_RG_BUCK_VRFDIG_VOSEL_SHIFT
#define vrfdig_da_vol_reg               PMIC_DA_VRFDIG_VOSEL_ADDR
#define vrfdig_da_vol_mask              PMIC_DA_VRFDIG_VOSEL_MASK
#define vrfdig_da_vol_shift             PMIC_DA_VRFDIG_VOSEL_SHIFT
#define vrfdig_vocal_reg                0
#define vrfdig_vocal_mask               0
#define vrfdig_vocal_shift              0
#define vrfdig_enable_reg               PMIC_RG_BUCK_VRFDIG_EN_ADDR
#define vrfdig_enable_shift             PMIC_RG_BUCK_VRFDIG_EN_SHIFT
#define vrfdig_mode_reg                 PMIC_RG_VRFDIG_FCCM_ADDR
#define vrfdig_mode_shift               PMIC_RG_VRFDIG_FCCM_SHIFT
#define vrfdig_trim_reg                 0
#define vrfdig_trim_mask                0
#define vrfdig_trim_shift               0
#define vrfdig_min_uV                   400000
#define vrfdig_max_uV                   1193750
#define vrfdig_step_uV                  6250
#define vrfdig_volt_type                REGULAR_VOLTAGE
#define vrfdig_stb                      200


#define vcore_vol_reg                   PMIC_RG_BUCK_VCORE_VOSEL_ADDR
#define vcore_vol_mask                  PMIC_RG_BUCK_VCORE_VOSEL_MASK
#define vcore_vol_shift                 PMIC_RG_BUCK_VCORE_VOSEL_SHIFT
#define vcore_da_vol_reg                PMIC_DA_VCORE_VOSEL_ADDR
#define vcore_da_vol_mask               PMIC_DA_VCORE_VOSEL_MASK
#define vcore_da_vol_shift              PMIC_DA_VCORE_VOSEL_SHIFT
#define vcore_vocal_reg                 0
#define vcore_vocal_mask                0
#define vcore_vocal_shift               0
#define vcore_enable_reg                PMIC_RG_BUCK_VCORE_EN_ADDR
#define vcore_enable_shift              PMIC_RG_BUCK_VCORE_EN_SHIFT
#define vcore_mode_reg                  PMIC_RG_VCORE_FCCM_ADDR
#define vcore_mode_shift                PMIC_RG_VCORE_FCCM_SHIFT
#define vcore_trim_reg                  0
#define vcore_trim_mask                 0
#define vcore_trim_shift                0
#define vcore_min_uV                    400000
#define vcore_max_uV                    1193750
#define vcore_step_uV                   6250
#define vcore_volt_type                 REGULAR_VOLTAGE
#define vcore_stb                       200


#define vmd11_vol_reg                   PMIC_RG_BUCK_VMD11_VOSEL_ADDR
#define vmd11_vol_mask                  PMIC_RG_BUCK_VMD11_VOSEL_MASK
#define vmd11_vol_shift                 PMIC_RG_BUCK_VMD11_VOSEL_SHIFT
#define vmd11_da_vol_reg                PMIC_DA_VMD11_VOSEL_ADDR
#define vmd11_da_vol_mask               PMIC_DA_VMD11_VOSEL_MASK
#define vmd11_da_vol_shift              PMIC_DA_VMD11_VOSEL_SHIFT
#define vmd11_vocal_reg                 0
#define vmd11_vocal_mask                0
#define vmd11_vocal_shift               0
#define vmd11_enable_reg                PMIC_RG_BUCK_VMD11_EN_ADDR
#define vmd11_enable_shift              PMIC_RG_BUCK_VMD11_EN_SHIFT
#define vmd11_mode_reg                  PMIC_RG_VMD11_FCCM_ADDR
#define vmd11_mode_shift                PMIC_RG_VMD11_FCCM_SHIFT
#define vmd11_trim_reg                  0
#define vmd11_trim_mask                 0
#define vmd11_trim_shift                0
#define vmd11_min_uV                    400000
#define vmd11_max_uV                    1193750
#define vmd11_step_uV                   6250
#define vmd11_volt_type                 REGULAR_VOLTAGE
#define vmd11_stb                       200


#define vsram_md_vol_reg                PMIC_RG_BUCK_VSRAM_MD_VOSEL_ADDR
#define vsram_md_vol_mask               PMIC_RG_BUCK_VSRAM_MD_VOSEL_MASK
#define vsram_md_vol_shift              PMIC_RG_BUCK_VSRAM_MD_VOSEL_SHIFT
#define vsram_md_da_vol_reg             PMIC_DA_VSRAM_MD_VOSEL_ADDR
#define vsram_md_da_vol_mask            PMIC_DA_VSRAM_MD_VOSEL_MASK
#define vsram_md_da_vol_shift           PMIC_DA_VSRAM_MD_VOSEL_SHIFT
#define vsram_md_vocal_reg              0
#define vsram_md_vocal_mask             0
#define vsram_md_vocal_shift            0
#define vsram_md_enable_reg             PMIC_RG_BUCK_VSRAM_MD_EN_ADDR
#define vsram_md_enable_shift           PMIC_RG_BUCK_VSRAM_MD_EN_SHIFT
#define vsram_md_mode_reg               PMIC_RG_VSRAM_MD_FCCM_ADDR
#define vsram_md_mode_shift             PMIC_RG_VSRAM_MD_FCCM_SHIFT
#define vsram_md_trim_reg               0
#define vsram_md_trim_mask              0
#define vsram_md_trim_shift             0
#define vsram_md_min_uV                 400000
#define vsram_md_max_uV                 1193750
#define vsram_md_step_uV                6250
#define vsram_md_volt_type              REGULAR_VOLTAGE
#define vsram_md_stb                    200


#define vsram_core_vol_reg              PMIC_RG_LDO_VSRAM_CORE_VOSEL_ADDR
#define vsram_core_vol_mask             PMIC_RG_LDO_VSRAM_CORE_VOSEL_MASK
#define vsram_core_vol_shift            PMIC_RG_LDO_VSRAM_CORE_VOSEL_SHIFT
#define vsram_core_da_vol_reg           PMIC_DA_VSRAM_CORE_VOSEL_ADDR
#define vsram_core_da_vol_mask          PMIC_DA_VSRAM_CORE_VOSEL_MASK
#define vsram_core_da_vol_shift         PMIC_DA_VSRAM_CORE_VOSEL_SHIFT
#define vsram_core_vocal_reg            0
#define vsram_core_vocal_mask           0
#define vsram_core_vocal_shift          0
#define vsram_core_enable_reg           PMIC_RG_LDO_VSRAM_CORE_EN_ADDR
#define vsram_core_enable_shift         PMIC_RG_LDO_VSRAM_CORE_EN_SHIFT
#define vsram_core_mode_reg             0
#define vsram_core_mode_shift           0
#define vsram_core_trim_reg             0
#define vsram_core_trim_mask            0
#define vsram_core_trim_shift           0
#define vsram_core_min_uV               500000
#define vsram_core_max_uV               1293750
#define vsram_core_step_uV              6250
#define vsram_core_volt_type            REGULAR_VOLTAGE
#define vsram_core_stb                  210


#define vsram_proc_vol_reg              PMIC_RG_LDO_VSRAM_PROC_VOSEL_ADDR
#define vsram_proc_vol_mask             PMIC_RG_LDO_VSRAM_PROC_VOSEL_MASK
#define vsram_proc_vol_shift            PMIC_RG_LDO_VSRAM_PROC_VOSEL_SHIFT
#define vsram_proc_da_vol_reg           PMIC_DA_VSRAM_PROC_VOSEL_ADDR
#define vsram_proc_da_vol_mask          PMIC_DA_VSRAM_PROC_VOSEL_MASK
#define vsram_proc_da_vol_shift         PMIC_DA_VSRAM_PROC_VOSEL_SHIFT
#define vsram_proc_vocal_reg            0
#define vsram_proc_vocal_mask           0
#define vsram_proc_vocal_shift          0
#define vsram_proc_enable_reg           PMIC_RG_LDO_VSRAM_PROC_EN_ADDR
#define vsram_proc_enable_shift         PMIC_RG_LDO_VSRAM_PROC_EN_SHIFT
#define vsram_proc_mode_reg             0
#define vsram_proc_mode_shift           0
#define vsram_proc_trim_reg             0
#define vsram_proc_trim_mask            0
#define vsram_proc_trim_shift           0
#define vsram_proc_min_uV               500000
#define vsram_proc_max_uV               1293750
#define vsram_proc_step_uV              6250
#define vsram_proc_volt_type            REGULAR_VOLTAGE
#define vsram_proc_stb                  210


#define vsram_rfdig_vol_reg             PMIC_RG_LDO_VSRAM_RFDIG_VOSEL_ADDR
#define vsram_rfdig_vol_mask            PMIC_RG_LDO_VSRAM_RFDIG_VOSEL_MASK
#define vsram_rfdig_vol_shift           PMIC_RG_LDO_VSRAM_RFDIG_VOSEL_SHIFT
#define vsram_rfdig_da_vol_reg          PMIC_DA_VSRAM_RFDIG_VOSEL_ADDR
#define vsram_rfdig_da_vol_mask         PMIC_DA_VSRAM_RFDIG_VOSEL_MASK
#define vsram_rfdig_da_vol_shift        PMIC_DA_VSRAM_RFDIG_VOSEL_SHIFT
#define vsram_rfdig_vocal_reg           0
#define vsram_rfdig_vocal_mask          0
#define vsram_rfdig_vocal_shift         0
#define vsram_rfdig_enable_reg          PMIC_RG_LDO_VSRAM_RFDIG_EN_ADDR
#define vsram_rfdig_enable_shift        PMIC_RG_LDO_VSRAM_RFDIG_EN_SHIFT
#define vsram_rfdig_mode_reg            0
#define vsram_rfdig_mode_shift          0
#define vsram_rfdig_trim_reg            0
#define vsram_rfdig_trim_mask           0
#define vsram_rfdig_trim_shift          0
#define vsram_rfdig_min_uV              500000
#define vsram_rfdig_max_uV              1293750
#define vsram_rfdig_step_uV             6250
#define vsram_rfdig_volt_type           REGULAR_VOLTAGE
#define vsram_rfdig_stb                 210


#define vio18_2_vol_reg                 PMIC_RG_VIO18_2_VOSEL_ADDR
#define vio18_2_vol_mask                PMIC_RG_VIO18_2_VOSEL_MASK
#define vio18_2_vol_shift               PMIC_RG_VIO18_2_VOSEL_SHIFT
#define vio18_2_da_vol_reg              0
#define vio18_2_da_vol_mask             0
#define vio18_2_da_vol_shift            0
#define vio18_2_vocal_reg               PMIC_RG_VIO18_2_VOCAL_ADDR
#define vio18_2_vocal_mask              PMIC_RG_VIO18_2_VOCAL_MASK
#define vio18_2_vocal_shift             PMIC_RG_VIO18_2_VOCAL_SHIFT
#define vio18_2_enable_reg              PMIC_RG_LDO_VIO18_2_EN_ADDR
#define vio18_2_enable_shift            PMIC_RG_LDO_VIO18_2_EN_SHIFT
#define vio18_2_mode_reg                0
#define vio18_2_mode_shift              0
#define vio18_2_trim_reg                PMIC_RG_VIO18_2_VOTRIM_ADDR
#define vio18_2_trim_mask               PMIC_RG_VIO18_2_VOTRIM_MASK
#define vio18_2_trim_shift              PMIC_RG_VIO18_2_VOTRIM_SHIFT
#define vio18_2_min_uV                  1600000
#define vio18_2_max_uV                  1800000
#define vio18_2_step_uV                 0
#define vio18_2_volt_type               NON_REGULAR_VOLTAGE
#define vio18_2_stb                     720


#define vmdd2_vol_reg                   PMIC_RG_VMDD2_VOSEL_ADDR
#define vmdd2_vol_mask                  PMIC_RG_VMDD2_VOSEL_MASK
#define vmdd2_vol_shift                 PMIC_RG_VMDD2_VOSEL_SHIFT
#define vmdd2_da_vol_reg                0
#define vmdd2_da_vol_mask               0
#define vmdd2_da_vol_shift              0
#define vmdd2_vocal_reg                 PMIC_RG_VMDD2_VOCAL_ADDR
#define vmdd2_vocal_mask                PMIC_RG_VMDD2_VOCAL_MASK
#define vmdd2_vocal_shift               PMIC_RG_VMDD2_VOCAL_SHIFT
#define vmdd2_enable_reg                PMIC_RG_LDO_VMDD2_EN_ADDR
#define vmdd2_enable_shift              PMIC_RG_LDO_VMDD2_EN_SHIFT
#define vmdd2_mode_reg                  0
#define vmdd2_mode_shift                0
#define vmdd2_trim_reg                  PMIC_RG_VMDD2_VOTRIM_ADDR
#define vmdd2_trim_mask                 PMIC_RG_VMDD2_VOTRIM_MASK
#define vmdd2_trim_shift                PMIC_RG_VMDD2_VOTRIM_SHIFT
#define vmdd2_min_uV                    1000000
#define vmdd2_max_uV                    1150000
#define vmdd2_step_uV                   0
#define vmdd2_volt_type                 NON_REGULAR_VOLTAGE
#define vmdd2_stb                       720


#define vefuse_vol_reg                  PMIC_RG_VEFUSE_VOSEL_ADDR
#define vefuse_vol_mask                 PMIC_RG_VEFUSE_VOSEL_MASK
#define vefuse_vol_shift                PMIC_RG_VEFUSE_VOSEL_SHIFT
#define vefuse_da_vol_reg               0
#define vefuse_da_vol_mask              0
#define vefuse_da_vol_shift             0
#define vefuse_vocal_reg                PMIC_RG_VEFUSE_VOCAL_ADDR
#define vefuse_vocal_mask               PMIC_RG_VEFUSE_VOCAL_MASK
#define vefuse_vocal_shift              PMIC_RG_VEFUSE_VOCAL_SHIFT
#define vefuse_enable_reg               PMIC_RG_LDO_VEFUSE_EN_ADDR
#define vefuse_enable_shift             PMIC_RG_LDO_VEFUSE_EN_SHIFT
#define vefuse_mode_reg                 0
#define vefuse_mode_shift               0
#define vefuse_trim_reg                 PMIC_RG_VEFUSE_VOTRIM_ADDR
#define vefuse_trim_mask                PMIC_RG_VEFUSE_VOTRIM_MASK
#define vefuse_trim_shift               PMIC_RG_VEFUSE_VOTRIM_SHIFT
#define vefuse_min_uV                   1700000
#define vefuse_max_uV                   2000000
#define vefuse_step_uV                  0
#define vefuse_volt_type                NON_REGULAR_VOLTAGE
#define vefuse_stb                      720


#define vio18_1_vol_reg                 PMIC_RG_VIO18_1_VOSEL_ADDR
#define vio18_1_vol_mask                PMIC_RG_VIO18_1_VOSEL_MASK
#define vio18_1_vol_shift               PMIC_RG_VIO18_1_VOSEL_SHIFT
#define vio18_1_da_vol_reg              0
#define vio18_1_da_vol_mask             0
#define vio18_1_da_vol_shift            0
#define vio18_1_vocal_reg               PMIC_RG_VIO18_1_VOCAL_ADDR
#define vio18_1_vocal_mask              PMIC_RG_VIO18_1_VOCAL_MASK
#define vio18_1_vocal_shift             PMIC_RG_VIO18_1_VOCAL_SHIFT
#define vio18_1_enable_reg              PMIC_RG_LDO_VIO18_1_EN_ADDR
#define vio18_1_enable_shift            PMIC_RG_LDO_VIO18_1_EN_SHIFT
#define vio18_1_mode_reg                0
#define vio18_1_mode_shift              0
#define vio18_1_trim_reg                PMIC_RG_VIO18_1_VOTRIM_ADDR
#define vio18_1_trim_mask               PMIC_RG_VIO18_1_VOTRIM_MASK
#define vio18_1_trim_shift              PMIC_RG_VIO18_1_VOTRIM_SHIFT
#define vio18_1_min_uV                  1600000
#define vio18_1_max_uV                  1800000
#define vio18_1_step_uV                 0
#define vio18_1_volt_type               NON_REGULAR_VOLTAGE
#define vio18_1_stb                     720


#define vmddr_vol_reg                   PMIC_RG_VMDDR_VOSEL_ADDR
#define vmddr_vol_mask                  PMIC_RG_VMDDR_VOSEL_MASK
#define vmddr_vol_shift                 PMIC_RG_VMDDR_VOSEL_SHIFT
#define vmddr_da_vol_reg                0
#define vmddr_da_vol_mask               0
#define vmddr_da_vol_shift              0
#define vmddr_vocal_reg                 PMIC_RG_VMDDR_VOCAL_ADDR
#define vmddr_vocal_mask                PMIC_RG_VMDDR_VOCAL_MASK
#define vmddr_vocal_shift               PMIC_RG_VMDDR_VOCAL_SHIFT
#define vmddr_enable_reg                PMIC_RG_LDO_VMDDR_EN_ADDR
#define vmddr_enable_shift              PMIC_RG_LDO_VMDDR_EN_SHIFT
#define vmddr_mode_reg                  0
#define vmddr_mode_shift                0
#define vmddr_trim_reg                  PMIC_RG_VMDDR_VOTRIM_ADDR
#define vmddr_trim_mask                 PMIC_RG_VMDDR_VOTRIM_MASK
#define vmddr_trim_shift                PMIC_RG_VMDDR_VOTRIM_SHIFT
#define vmddr_min_uV                    700000
#define vmddr_max_uV                    800000
#define vmddr_step_uV                   0
#define vmddr_volt_type                 NON_REGULAR_VOLTAGE
#define vmddr_stb                       720


#define vmddq_vol_reg                   PMIC_RG_VMDDQ_VOSEL_ADDR
#define vmddq_vol_mask                  PMIC_RG_VMDDQ_VOSEL_MASK
#define vmddq_vol_shift                 PMIC_RG_VMDDQ_VOSEL_SHIFT
#define vmddq_da_vol_reg                0
#define vmddq_da_vol_mask               0
#define vmddq_da_vol_shift              0
#define vmddq_vocal_reg                 PMIC_RG_VMDDQ_VOCAL_ADDR
#define vmddq_vocal_mask                PMIC_RG_VMDDQ_VOCAL_MASK
#define vmddq_vocal_shift               PMIC_RG_VMDDQ_VOCAL_SHIFT
#define vmddq_enable_reg                PMIC_RG_LDO_VMDDQ_EN_ADDR
#define vmddq_enable_shift              PMIC_RG_LDO_VMDDQ_EN_SHIFT
#define vmddq_mode_reg                  0
#define vmddq_mode_shift                0
#define vmddq_trim_reg                  PMIC_RG_VMDDQ_VOTRIM_ADDR
#define vmddq_trim_mask                 PMIC_RG_VMDDQ_VOTRIM_MASK
#define vmddq_trim_shift                PMIC_RG_VMDDQ_VOTRIM_SHIFT
#define vmddq_min_uV                    550000
#define vmddq_max_uV                    650000
#define vmddq_step_uV                   0
#define vmddq_volt_type                 NON_REGULAR_VOLTAGE
#define vmddq_stb                       720

#endif /* __LINUX_REGULATOR_MT6330_H_ */
