/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 * 
 * MediaTek Inc. (C) 2010. All rights reserved.
 * 
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#ifndef __MT_RTC_H__
#define __MT_RTC_H__

#include <typedefs.h>

#define RTC_FQMTR_LOW_BASE	(794 - 2)
#define RTC_FQMTR_HIGH_BASE (794 + 2)

//**	frequency meter related		*//
#define RG_BANK_FQMTR_RST			PMIC_RG_BANK_FQMTR_RST_ADDR
#define RG_FQMTR_TCKSEL				PMIC_FQMTR_TCKSEL_ADDR
#define RG_FQMTR_WINSET				PMIC_FQMTR_WINSET_L_ADDR
#define RG_FQMTR_BUSY				PMIC_FQMTR_BUSY_ADDR
#define RG_FQMTR_DCXO26M_EN			PMIC_FQMTR_DCXO26M_EN_ADDR
#define RG_FQMTR_DATA				PMIC_FQMTR_DATA_L_ADDR
#define RG_FQMTR_EN 				PMIC_FQMTR_EN_ADDR

#define RG_FQMTR_32K_CLK_PDN_SET	PMIC_TOP_CKPDN_CON0_SET_ADDR
#define RG_FQMTR_32K_CLK_PDN_CLR	PMIC_TOP_CKPDN_CON0_CLR_ADDR
#define RG_FQMTR_32K_CLK_PDN_MASK	PMIC_RG_FQMTR_32K_CK_PDN_MASK
#define RG_FQMTR_32K_CLK_PDN_SHIFT	PMIC_RG_FQMTR_32K_CK_PDN_SHIFT

#define FQMTR_CLK_CK_PDN_SET		PMIC_TOP_CKPDN_CON0_SET_ADDR
#define FQMTR_CLK_CK_PDN_CLR		PMIC_TOP_CKPDN_CON0_CLR_ADDR
#define FQMTR_CLK_CK_PDN_MASK		PMIC_RG_FQMTR_CK_PDN_MASK
#define FQMTR_CLK_CK_PDN_SHIFT		PMIC_RG_FQMTR_CK_PDN_SHIFT

#define RG_FQMTR_CKSEL				PMIC_RG_FQMTR_CK_CKSEL_ADDR
#define RG_FQMTR_CKSEL_SET 			PMIC_TOP_CKSEL_CON0_SET_ADDR
#define RG_FQMTR_CKSEL_CLR 			PMIC_TOP_CKSEL_CON0_CLR_ADDR
#define RG_FQMTR_CKSEL_MASK			PMIC_RG_FQMTR_CK_CKSEL_MASK
#define RG_FQMTR_CKSEL_SHIFT		PMIC_RG_FQMTR_CK_CKSEL_SHIFT
#define RG_FQMTR_TCKSEL_MASK		PMIC_FQMTR_TCKSEL_MASK
#define RG_FQMTR_TCKSEL_SHIFT		PMIC_FQMTR_TCKSEL_SHIFT

#define FQMTR_FIX_CLK_26M			(0 << RG_FQMTR_CKSEL_SHIFT)
#define FQMTR_FIX_CLK_XOSC_32K_DET	(1 << RG_FQMTR_CKSEL_SHIFT)
#define FQMTR_FIX_CLK_EOSC_32K		(2 << RG_FQMTR_CKSEL_SHIFT)
#define FQMTR_FIX_CLK_RTC_32K		(3 << RG_FQMTR_CKSEL_SHIFT)
#define FQMTR_FIX_CLK_SMPS_CK		(4 << RG_FQMTR_CKSEL_SHIFT)
#define FQMTR_FIX_CLK_TCK_SEC		(5 << RG_FQMTR_CKSEL_SHIFT)
#define FQMTR_FIX_CLK_PMU_75K		(6 << RG_FQMTR_CKSEL_SHIFT)


#define BANK_FQMTR_RST				(1U << PMIC_RG_BANK_FQMTR_RST_SHIFT)
#define FQMTR_EN					(1U << PMIC_FQMTR_EN_SHIFT)
#define FQMTR_BUSY					(1U << PMIC_FQMTR_BUSY_SHIFT)
#define FQMTR_DCXO26M_EN			(1U << PMIC_FQMTR_DCXO26M_EN_SHIFT)
#define FQMTR_XOSC32_CK				0
#define	FQMTR_DCXO_F32K_CK 			1
#define	FQMTR_EOSC32_CK		 		2
#define	FQMTR_XOSC32_CK_DETECTON 	3
#define	FQMTR_FQM26M_CK 			4
#define	FQMTR_FQM32K_CK 			5
#define	FQMTR_TEST_CK 				6
#define FQMTR_WINSET    			0x0000

#define RG_75K_32K_SEL				PMIC_TOP_CKSEL_CON0_SET_ADDR
#define RTC_75K_TO_32K				(1U << PMIC_RG_RTC_32K1V8_SEL_SHIFT)

/* we map HW YEA 0 (2000) to 1968 not 1970 because 2000 is the leap year */
#define RTC_MIN_YEAR            1968
#define RTC_NUM_YEARS           128
//#define RTC_MAX_YEAR          (RTC_MIN_YEAR + RTC_NUM_YEARS - 1)

struct rtc_time {
	U16 tm_sec;
	U16 tm_min;
	U16 tm_hour;
	U16 tm_mday;
	U16 tm_mon;
	U16 tm_year;
};

extern void rtc_bbpu_power_on(void);
extern void rtc_mark_bypass_pwrkey(void);
extern void rtc_init(void);
extern bool rtc_boot_check(void);
extern void pl_power_off(void);
extern bool rtc_2sec_reboot_check(void);
extern void rtc_get_time(struct rtc_time *tm);
extern void rtc_bbpu_power_clear(void);

#endif /* __MT_RTC_H__ */
