#ifndef _SPM_MTCMOS_
#define _SPM_MTCMOS_

#include "platform.h"
#define STA_POWER_DOWN  0
#define STA_POWER_ON    1

#define UINT32 unsigned int
#define UINT32P unsigned int*
/*
 * 1. for non-CPU MTCMOS: VDEC, VENC, ISP, DISP, MFG, INFRA, DDRPHY, MDSYS1, MDSYS2
 * 2. call spm_mtcmos_noncpu_lock/unlock() before/after any operations
 */

/* for  MTCMOS on/off APIs */

#define POWERON_CONFIG_EN (SPM_BASE + 0x000)
#define PWR_STATUS        (SPM_BASE + 0x16C)
#define PWR_STATUS_2ND    (SPM_BASE + 0x170)
#define OTHER_PWR_STATUS  (SPM_BASE + 0x178)  /* for MT6853 VPU only need check*/
#define MD_EXT_BUCK_ISO_CON (SPM_BASE + 0x398)


#define MD1_PWR_CON             (SPM_BASE + 0x300)
#define CONN_PWR_CON            (SPM_BASE + 0x304)
#define MFG0_PWR_CON            (SPM_BASE + 0x308)
#define PEXTP_D_2LX1_PHY_PWR_CON            (SPM_BASE + 0x30C)
#define PEXTP_R_2LX1_PHY_PWR_CON            (SPM_BASE + 0x310)
#define PEXTP_R_1LX2_0P_PHY_PWR_CON         (SPM_BASE + 0x314)
#define PEXTP_R_1LX2_1P_PHY_PWR_CON         (SPM_BASE + 0x318)
#define SSUSB_PHY_PWR_CON            (SPM_BASE + 0x31C)
#define IFR_PWR_CON             (SPM_BASE + 0x324)
#define EIP97_PWR_CON             (SPM_BASE + 0x328)
#define DPY_PWR_CON             (SPM_BASE + 0x32C)
#define PEXTP_D_2LX1_PWR_CON             (SPM_BASE + 0x330)
#define PEXTP_R_2LX1_PWR_CON             (SPM_BASE + 0x334)
#define PEXTP_R_1LX2_PWR_CON             (SPM_BASE + 0x338)
#define ETH_PWR_CON             (SPM_BASE + 0x33C)
#define SSUSB_PWR_CON           (SPM_BASE + 0x340)
#define HSMTOP_PWR_CON             (SPM_BASE + 0x344)
#define NETSYS_PWR_CON             (SPM_BASE + 0x34C)
#define DIS_PWR_CON             (SPM_BASE + 0x350)
#define AUDIO_PWR_CON           (SPM_BASE + 0x354)
#define SGMII_0_PHY_PWR_CON            (SPM_BASE + 0x358)
#define SGMII_1_PHY_PWR_CON            (SPM_BASE + 0x35C)
#define SGMII_0_TOP_PWR_CON        (SPM_BASE + 0x360)
#define SGMII_1_TOP_PWR_CON        (SPM_BASE + 0x364)
#define DRAMC_MD32_PWR_CON        (SPM_BASE + 0x368)
#define MSDC_PWR_CON    (SPM_BASE + 0x3A4)
#define MCUPM_PWR_CON   (SPM_BASE + 0x3C0)
#define DPY2_PWR_CON    (SPM_BASE + 0x3C4)
#define PERI_PWR_CON  (SPM_BASE + 0x3D0)

#define INFRA_TOPAXI_PROTECTEN			(INFRACFG_AO_BASE + 0x0220)
#define INFRA_TOPAXI_PROTECTEN_SET		(INFRACFG_AO_BASE + 0x02A0)
#define INFRA_TOPAXI_PROTECTEN_CLR		(INFRACFG_AO_BASE + 0x02A4)
#define INFRA_TOPAXI_PROTECTEN_STA0		(INFRACFG_AO_BASE + 0x0224)
#define INFRA_TOPAXI_PROTECTEN_STA1		(INFRACFG_AO_BASE + 0x0228)

#define INFRA_TOPAXI_PROTECTEN_1		(INFRACFG_AO_BASE + 0x0250)
#define INFRA_TOPAXI_PROTECTEN_1_SET		(INFRACFG_AO_BASE + 0x02A8)
#define INFRA_TOPAXI_PROTECTEN_1_CLR		(INFRACFG_AO_BASE + 0x02AC)
#define INFRA_TOPAXI_PROTECTEN_STA0_1		(INFRACFG_AO_BASE + 0x0254)
#define INFRA_TOPAXI_PROTECTEN_STA1_1		(INFRACFG_AO_BASE + 0x0258)

#define INFRA_TOPAXI_PROTECTEN_MCU		(INFRACFG_AO_BASE + 0x02C0)
#define INFRA_TOPAXI_PROTECTEN_MCU_STA0		(INFRACFG_AO_BASE + 0x02E0)
#define INFRA_TOPAXI_PROTECTEN_MCU_STA1		(INFRACFG_AO_BASE + 0x02E4)
#define INFRA_TOPAXI_PROTECTEN_MCU_SET		(INFRACFG_AO_BASE + 0x02C4)
#define INFRA_TOPAXI_PROTECTEN_MCU_CLR		(INFRACFG_AO_BASE + 0x02C8)

#define INFRA_TOPAXI_PROTECTEN_MM		(INFRACFG_AO_BASE + 0x02D0)
#define INFRA_TOPAXI_PROTECTEN_MM_SET		(INFRACFG_AO_BASE + 0x02D4)
#define INFRA_TOPAXI_PROTECTEN_MM_CLR		(INFRACFG_AO_BASE + 0x02D8)
#define INFRA_TOPAXI_PROTECTEN_MM_STA0		(INFRACFG_AO_BASE + 0x02E8)
#define INFRA_TOPAXI_PROTECTEN_MM_STA1		(INFRACFG_AO_BASE + 0x02EC)

#define INFRA_TOPAXI_PROTECTEN_2		(INFRACFG_AO_BASE + 0x0710)
#define INFRA_TOPAXI_PROTECTEN_2_SET		(INFRACFG_AO_BASE + 0x0714)
#define INFRA_TOPAXI_PROTECTEN_2_CLR		(INFRACFG_AO_BASE + 0x0718)
#define INFRA_TOPAXI_PROTECTEN_STA0_2		(INFRACFG_AO_BASE + 0x0720)
#define INFRA_TOPAXI_PROTECTEN_STA1_2		(INFRACFG_AO_BASE + 0x0724)

#define INFRA_TOPAXI_PROTECTEN_MM_2		(INFRACFG_AO_BASE + 0x0DC8)
#define INFRA_TOPAXI_PROTECTEN_MM_2_SET		(INFRACFG_AO_BASE + 0x0DCC)
#define INFRA_TOPAXI_PROTECTEN_MM_2_CLR		(INFRACFG_AO_BASE + 0x0DD0)
#define INFRA_TOPAXI_PROTECTEN_MM_2_STA0	(INFRACFG_AO_BASE + 0x0DD4)
#define INFRA_TOPAXI_PROTECTEN_MM_2_STA1	(INFRACFG_AO_BASE + 0x0DD8)

#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR		(INFRACFG_AO_BASE + 0x0B80)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_SET		(INFRACFG_AO_BASE + 0x0B84)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_CLR		(INFRACFG_AO_BASE + 0x0B88)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_STA0		(INFRACFG_AO_BASE + 0x0B8c)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_STA1		(INFRACFG_AO_BASE + 0x0B90)

#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1		(INFRACFG_AO_BASE + 0x0BA0)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1_SET		(INFRACFG_AO_BASE + 0x0BA4)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1_CLR		(INFRACFG_AO_BASE + 0x0BA8)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1_STA0	(INFRACFG_AO_BASE + 0x0BAc)
#define INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1_STA1	(INFRACFG_AO_BASE + 0x0BB0)

#define INFRA_TOPAXI_PROTECTEN_SUB_INFRA_VDNR		(INFRACFG_AO_BASE + 0x0BB4)
#define INFRA_TOPAXI_PROTECTEN_SUB_INFRA_VDNR_SET	(INFRACFG_AO_BASE + 0x0BB8)
#define INFRA_TOPAXI_PROTECTEN_SUB_INFRA_VDNR_CLR	(INFRACFG_AO_BASE + 0x0BBC)
#define INFRA_TOPAXI_PROTECTEN_SUB_INFRA_VDNR_STA0	(INFRACFG_AO_BASE + 0x0BC0)
#define INFRA_TOPAXI_PROTECTEN_SUB_INFRA_VDNR_STA1	(INFRACFG_AO_BASE + 0x0BC4)

unsigned int spm_read(UINT32P reg_addr);
void spm_write(UINT32P reg_addr, unsigned int wdata);
int spm_mtcmos_ctrl_md1(int state);
int spm_mtcmos_ctrl_dis(int state);
int spm_mtcmos_ctrl_hsmtop(int state);
/*int spm_mtcmos_ctrl_conn(int state);
int spm_mtcmos_ctrl_mfg0(int state);
int spm_mtcmos_ctrl_pextp_d_2lx1_phy(int state);
int spm_mtcmos_ctrl_pextp_r_2lx1_phy(int state);
int spm_mtcmos_ctrl_pextp_r_1lx2_0p_phy(int state);
int spm_mtcmos_ctrl_pextp_r_1lx2_1p_phy(int state);
int spm_mtcmos_ctrl_ssusb_phy(int state);
int spm_mtcmos_ctrl_sgmii_0_phy(int state);
int spm_mtcmos_ctrl_ifr(int state);
int spm_mtcmos_ctrl_sgmii_1_phy(int state);
int spm_mtcmos_ctrl_dpy(int state);
int spm_mtcmos_ctrl_pextp_d_2lx1(int state);
int spm_mtcmos_ctrl_pextp_r_2lx1(int state);
int spm_mtcmos_ctrl_pextp_r_1lx2(int state);
int spm_mtcmos_ctrl_eth(int state);
int spm_mtcmos_ctrl_ssusb(int state);
int spm_mtcmos_ctrl_sgmii_0_top(int state);
int spm_mtcmos_ctrl_sgmii_1_top(int state);
int spm_mtcmos_ctrl_netsys(int state);
int spm_mtcmos_ctrl_audio(int state);
int spm_mtcmos_ctrl_eip97(int state);
int spm_mtcmos_ctrl_hsmtop(int state);
int spm_mtcmos_ctrl_dramc_md32(int state);
int spm_mtcmos_ctrl_dpy2(int state);
int spm_mtcmos_ctrl_mcupm(int state);
int spm_mtcmos_ctrl_msdc(int state);
int spm_mtcmos_ctrl_peri(int state);
*/
#endif

