#ifndef SPM_REGISTER_H
#define SPM_REGISTER_H

#define SPM_BASE_ADDRESS 0x10006000

//Page SPM_1
#define SPM_POWERON_CONFIG_EN (SPM_BASE_ADDRESS + 0x000)
    #define POWERON_CONFIG_EN_BCLK_CG_EN Fld(1,0)//[0:0]
    #define POWERON_CONFIG_EN_PROJECT_CODE Fld(16,16)//[31:16]
#define SPM_POWER_ON_VAL0 (SPM_BASE_ADDRESS + 0x004)
    #define SPM_POWER_ON_VAL0_SC_26M_CK_OFF              Fld(1,0)
    #define SPM_POWER_ON_VAL0_SC_TX_TRACK_RETRY_EN       Fld(1,1)
    #define SPM_POWER_ON_VAL0_SC_MEM_CK_OFF              Fld(1,2)
    #define SPM_POWER_ON_VAL0_SC_AXI_CK_OFF              Fld(1,3)
    #define SPM_POWER_ON_VAL0_SC_DR_SRAM_LOAD            Fld(1,4)
    #define SPM_POWER_ON_VAL0_SC_MD26M_CK_OFF            Fld(1,5)
    #define SPM_POWER_ON_VAL0_SC_DPY_MODE_SW             Fld(1,6)
    #define SPM_POWER_ON_VAL0_SC_DMSUS_OFF               Fld(1,7)
    #define SPM_POWER_ON_VAL0_SC_DPY_2ND_DLL_EN          Fld(1,8)
    #define SPM_POWER_ON_VAL0_SC_DR_SRAM_RESTORE         Fld(1,9)
    #define SPM_POWER_ON_VAL0_SC_MPLLOUT_OFF             Fld(1,10)
    #define SPM_POWER_ON_VAL0_SC_TX_TRACKING_DIS         Fld(1,11)
    #define SPM_POWER_ON_VAL0_SC_DPY_DLL_EN              Fld(1,12)
    #define SPM_POWER_ON_VAL0_SC_DPY_DLL_CK_EN           Fld(1,13)
    #define SPM_POWER_ON_VAL0_SC_DPY_VREF_EN             Fld(1,14)
    #define SPM_POWER_ON_VAL0_SC_PHYPLL_EN               Fld(1,15)
    #define SPM_POWER_ON_VAL0_SC_DDRPHY_FB_CK_EN         Fld(1,16)
    #define SPM_POWER_ON_VAL0_SC_DPY_BCLK_ENABLE         Fld(1,17)
    #define SPM_POWER_ON_VAL0_SC_MPLL_OFF                Fld(1,18)
    #define SPM_POWER_ON_VAL0_SC_SHU_RESTORE             Fld(1,19)
    #define SPM_POWER_ON_VAL0_SC_CKSQ0_OFF               Fld(1,20)
    #define SPM_POWER_ON_VAL0_SC_DR_SHU_LEVEL_SRAM_LATCH Fld(1,21)
    #define SPM_POWER_ON_VAL0_SC_DR_SHU_EN               Fld(1,22)
    #define SPM_POWER_ON_VAL0_SC_DPHY_PRECAL_UP          Fld(1,23)
    #define SPM_POWER_ON_VAL0_SC_MPLL_S_OFF              Fld(1,24)
    #define SPM_POWER_ON_VAL0_SC_DPHY_RXDLY_TRACK_EN     Fld(1,25)
    #define SPM_POWER_ON_VAL0_SC_PHYPLL_SHU_EN           Fld(1,26)
    #define SPM_POWER_ON_VAL0_SC_PHYPLL2_SHU_EN          Fld(1,27)
    #define SPM_POWER_ON_VAL0_SC_PHYPLL_MODE_SW          Fld(1,28)
    #define SPM_POWER_ON_VAL0_SC_PHYPLL2_MODE_SW         Fld(1,29)
    #define SPM_POWER_ON_VAL0_SC_DR_SHU_LEVEL0           Fld(1,30)
    #define SPM_POWER_ON_VAL0_SC_DR_SHU_LEVEL1           Fld(1,31)
#define SPM_POWER_ON_VAL1 (SPM_BASE_ADDRESS + 0x008)
    #define SPM_POWER_ON_VAL1_PWRAP_SLEEP_REQ            Fld(1,0)
    #define SPM_POWER_ON_VAL1_EMI_CLK_OFF_REQ            Fld(1,1)
    #define SPM_POWER_ON_VAL1_PCM_BUS_PROTECT_REQ        Fld(1,2)
    #define SPM_POWER_ON_VAL1_SPM_CK_UPDATE              Fld(1,3)
    #define SPM_POWER_ON_VAL1_SPM_CK_SEL0                Fld(1,4)
    #define SPM_POWER_ON_VAL1_SPM_CK_SEL1                Fld(1,5)
    #define SPM_POWER_ON_VAL1_SPM_LEAVE_DEEPIDLE_REQ     Fld(1,6)
    #define SPM_POWER_ON_VAL1_FREQH_PAUSE_MPLL           Fld(1,7)
    #define SPM_POWER_ON_VAL1_SC_26M_CK_SEL              Fld(1,8)
    #define SPM_POWER_ON_VAL1_PCM_TIMER_SET              Fld(1,9)
    #define SPM_POWER_ON_VAL1_PCM_TIMER_CLR              Fld(1,10)
    #define SPM_POWER_ON_VAL1_SPM_LEAVE_SUSPEND_REQ      Fld(1,11)
    #define SPM_POWER_ON_VAL1_CSYSPWRUPACK               Fld(1,12)
    #define SPM_POWER_ON_VAL1_IM_SLEEP_ENABLE            Fld(1,13)
    #define SPM_POWER_ON_VAL1_SRCCLKENO                  Fld(1,14)
    #define SPM_POWER_ON_VAL1_FORCE_DDREN_ON             Fld(1,15)
    #define SPM_POWER_ON_VAL1_SPM_APSRC_INTERNAL_ACK     Fld(1,16)
    #define SPM_POWER_ON_VAL1_CPU_SYS_TIMER_CLK_SEL      Fld(1,17)
    #define SPM_POWER_ON_VAL1_SC_AXI_DCM_DIS             Fld(1,18)
    #define SPM_POWER_ON_VAL1_FREQH_PAUSE_MEM            Fld(1,19)
    #define SPM_POWER_ON_VAL1_FREQH_PAUSE_MAIN           Fld(1,20)
    #define SPM_POWER_ON_VAL1_SRCCLKENO1                 Fld(1,21)
    #define SPM_POWER_ON_VAL1_WDT_KICK_P                 Fld(1,22)
    #define SPM_POWER_ON_VAL1_SPM2EMI_S1_MODE_ASYNC      Fld(1,23)
    #define SPM_POWER_ON_VAL1_SC_DDR_PST_REQ             Fld(1,24)
    #define SPM_POWER_ON_VAL1_SC_DDR_PST_ABORT_REQ       Fld(1,25)
    #define SPM_POWER_ON_VAL1_PMIC_IRQ_REQ_EN            Fld(1,26)
    #define SPM_POWER_ON_VAL1_FORCE_VTCXO_ON             Fld(1,27)
    #define SPM_POWER_ON_VAL1_FORCE_APSRC_ON             Fld(1,28)
    #define SPM_POWER_ON_VAL1_FORCE_INFRA_ON             Fld(1,29)
    #define SPM_POWER_ON_VAL1_FORCE_VRF18_ON             Fld(1,30)
    #define SPM_POWER_ON_VAL1_SPM_DDR_EN_INTERNAL_ACK    Fld(1,31)
#define SPM_CLK_CON (SPM_BASE_ADDRESS + 0x00C)
    #define SPM_CLK_CON_REG_SRCCLKEN0_CTL Fld(2,0)//[1:0]
    #define SPM_CLK_CON_REG_SRCCLKEN1_CTL Fld(2,2)//[3:2]
    #define SPM_CLK_CON_SYS_SETTLE_SEL Fld(1,4)//[4:4]
    #define SPM_CLK_CON_REG_SPM_LOCK_INFRA_DCM Fld(1,5)//[5:5]
    #define SPM_CLK_CON_REG_SRCCLKEN_MASK Fld(3,6)//[8:6]
    #define SPM_CLK_CON_REG_MD1_C32RM_EN Fld(1,9)//[9:9]
    #define SPM_CLK_CON_REG_MD2_C32RM_EN Fld(1,10)//[10:10]
    #define SPM_CLK_CON_REG_CLKSQ0_SEL_CTRL Fld(1,11)//[11:11]
    #define SPM_CLK_CON_REG_CLKSQ1_SEL_CTRL Fld(1,12)//[12:12]
    #define SPM_CLK_CON_REG_SRCCLKEN0_EN Fld(1,13)//[13:13]
    #define SPM_CLK_CON_REG_SRCCLKEN1_EN Fld(1,14)//[14:14]
    #define SPM_CLK_CON_SCP_DCM_EN Fld(1,15)//[15:15]
    #define SPM_CLK_CON_REG_SYSCLK0_SRC_MASK_B Fld(8,16)//[23:16]
    #define SPM_CLK_CON_REG_SYSCLK1_SRC_MASK_B Fld(8,24)//[31:24]
#define SPM_CLK_SETTLE (SPM_BASE_ADDRESS + 0x010)
    #define SPM_CLK_SETTLE_SYSCLK_SETTLE Fld(28,0)//[27:0]
#define SPM_AP_STANDBY_CON (SPM_BASE_ADDRESS + 0x014)
    #define SPM_AP_STANDBY_CON_REG_CONN_APSRC_SEL Fld(1,29)//[29:29]
    #define SPM_AP_STANDBY_CON_REG_MD_APSRC_0_SEL Fld(1,26)//[26:26]
    #define SPM_AP_STANDBY_CON_REG_MD_APSRC_1_SEL Fld(1,25)//[25:25]
    #define SPM_AP_STANDBY_CON_REG_MCUSYS_IDLE_MASK Fld(1,4)//[4:4]
    #define SPM_AP_STANDBY_CON_REG_MP1_CPUTOP_IDLE_MASK Fld(1,3)//[3:3]
    #define SPM_AP_STANDBY_CON_REG_MP0_CPUTOP_IDLE_MASK Fld(1,2)//[2:2]
    #define SPM_AP_STANDBY_CON_REG_WFI_TYPE Fld(1,1)//[1:1]
    #define SPM_AP_STANDBY_CON_REG_WFI_OP Fld(1,0)//[0:0]
#define PCM_CON0 (SPM_BASE_ADDRESS + 0x018)
    #define PCM_CON0_PCM_CK_EN Fld(1,2)//[2:2]
    #define PCM_CON0_RG_EN_IM_SLEEP_DVS Fld(1,3)//[3:3]
    #define PCM_CON0_PCM_CK_FROM_CKSYS Fld(1,4)//[4:4]
    #define PCM_CON0_PCM_SW_RESET Fld(1,15)//[15:15]
    #define PCM_CON0_PROJECT_CODE Fld(16,16)//[31:16]
#define PCM_CON1 (SPM_BASE_ADDRESS + 0x01C)
    #define PCM_CON1_RG_IM_SLAVE Fld(1,0)//[0:0]
    #define PCM_CON1_RG_IM_SLEEP Fld(1,1)//[1:1]
    #define PCM_CON1_REG_SPM_SRAM_CTRL_MUX Fld(1,2)//[2:2]
    #define PCM_CON1_RG_AHBMIF_APBEN Fld(1,3)//[3:3]
    #define PCM_CON1_RG_IM_PDN Fld(1,4)//[4:4]
    #define PCM_CON1_RG_PCM_TIMER_EN Fld(1,5)//[5:5]
    #define PCM_CON1_SPM_EVENT_COUNTER_CLR Fld(1,6)//[6:6]
    #define PCM_CON1_RG_DIS_MIF_PROT Fld(1,7)//[7:7]
    #define PCM_CON1_RG_PCM_WDT_EN Fld(1,8)//[8:8]
    #define PCM_CON1_RG_PCM_WDT_WAKE Fld(1,9)//[9:9]
    #define PCM_CON1_REG_SPM_SRAM_SLEEP_B Fld(1,10)//[10:10]
    #define PCM_CON1_REG_SPM_SRAM_ISOINT_B Fld(1,11)//[11:11]
    #define PCM_CON1_REG_EVENT_LOCK_EN Fld(1,12)//[12:12]
    #define PCM_CON1_REG_SRCCLKEN_FAST_RESP Fld(1,13)//[13:13]
    #define PCM_CON1_REG_MD32_APB_INTERNAL_EN Fld(1,14)//[14:14]
    #define PCM_CON1_RG_PCM_IRQ_MSK Fld(1,15)//[15:15]
    #define PCM_CON1_PROJECT_CODE Fld(16,16)//[31:16]
#define SPM_POWER_ON_VAL2 (SPM_BASE_ADDRESS + 0x020)
    #define SPM_POWER_ON_VAL2_POWER_ON_VAL2 Fld(32,0)//[31:0]
#define SPM_POWER_ON_VAL3 (SPM_BASE_ADDRESS + 0x024)
    #define SPM_POWER_ON_VAL3_POWER_ON_VAL3 Fld(32,0)//[31:0]
#define PCM_REG_DATA_INI (SPM_BASE_ADDRESS + 0x028)
    #define PCM_REG_DATA_INI_PCM_REG_DATA_INI Fld(32,0)//[31:0]
#define PCM_PWR_IO_EN (SPM_BASE_ADDRESS + 0x02C)
    #define PCM_PWR_IO_EN_PCM_PWR_IO_EN Fld(8,0)//[7:0]
    #define PCM_PWR_IO_EN_RG_RF_SYNC_EN Fld(8,16)//[23:16]
#define PCM_TIMER_VAL (SPM_BASE_ADDRESS + 0x030)
    #define PCM_TIMER_VAL_REG_PCM_TIMER_VAL Fld(32,0)//[31:0]
#define PCM_WDT_VAL (SPM_BASE_ADDRESS + 0x034)
    #define PCM_WDT_VAL_RG_PCM_WDT_VAL Fld(32,0)//[31:0]
#define SPM_SW_RST_CON (SPM_BASE_ADDRESS + 0x040)
    #define SPM_SW_RST_CON_SPM_SW_RST_CON Fld(16,0)//[15:0]
    #define SPM_SW_RST_CON_PROJECT_CODE Fld(16,16)//[31:16]
#define SPM_SW_RST_CON_SET (SPM_BASE_ADDRESS + 0x044)
    #define SPM_SW_RST_CON_SET_SPM_SW_RST_CON_SET Fld(16,0)//[15:0]
    #define SPM_SW_RST_CON_SET_PROJECT_CODE Fld(16,16)//[31:16]
#define SPM_SW_RST_CON_CLR (SPM_BASE_ADDRESS + 0x048)
    #define SPM_SW_RST_CON_CLR_SPM_SW_RST_CON_CLR Fld(16,0)//[15:0]
    #define SPM_SW_RST_CON_CLR_PROJECT_CODE Fld(16,16)//[31:16]
#define VS1_PSR_MASK_B (SPM_BASE_ADDRESS + 0x04C)
    #define VS1_PSR_MASK_B_VS1_OPP0_PSR_MASK_B Fld(8,0)//[7:0]
    #define VS1_PSR_MASK_B_VS1_OPP1_PSR_MASK_B Fld(8,8)//[15:8]
#define VS2_PSR_MASK_B (SPM_BASE_ADDRESS + 0x050)
    #define VS2_PSR_MASK_B_VS2_OPP0_PSR_MASK_B Fld(8,0)//[7:0]
    #define VS2_PSR_MASK_B_VS2_OPP1_PSR_MASK_B Fld(8,8)//[15:8]
    #define VS2_PSR_MASK_B_VS2_OPP2_PSR_MASK_B Fld(8,16)//[23:16]
#define MD32_CLK_CON (SPM_BASE_ADDRESS + 0x084)
    #define MD32_CLK_CON_REG_MD32_26M_CK_SEL Fld(1,0)//[0:0]
    #define MD32_CLK_CON_REG_MD32_DCM_EN Fld(1,1)//[1:1]
#define SPM_SRAM_RSV_CON (SPM_BASE_ADDRESS + 0x088)
    #define SPM_SRAM_RSV_CON_SPM_SRAM_SLEEP_B_ECO_EN Fld(1,0)//[0:0]
#define SPM_SWINT (SPM_BASE_ADDRESS + 0x08C)
    #define SPM_SWINT_SPM_SWINT Fld(32,0)//[31:0]
#define SPM_SWINT_SET (SPM_BASE_ADDRESS + 0x090)
    #define SPM_SWINT_SET_SPM_SWINT_SET Fld(32,0)//[31:0]
#define SPM_SWINT_CLR (SPM_BASE_ADDRESS + 0x094)
    #define SPM_SWINT_CLR_SPM_SWINT_CLR Fld(32,0)//[31:0]
#define SPM_SCP_MAILBOX (SPM_BASE_ADDRESS + 0x098)
    #define SPM_SCP_MAILBOX_SPM_SCP_MAILBOX Fld(32,0)//[31:0]
#define SCP_SPM_MAILBOX (SPM_BASE_ADDRESS + 0x09C)
    #define SCP_SPM_MAILBOX_SCP_SPM_MAILBOX Fld(32,0)//[31:0]
#define SPM_TWAM_CON (SPM_BASE_ADDRESS + 0x0A0)
    #define SPM_TWAM_CON_REG_TWAM_ENABLE Fld(1,0)//[0:0]
    #define SPM_TWAM_CON_REG_TWAM_SPEED_MODE_EN Fld(1,1)//[1:1]
    #define SPM_TWAM_CON_REG_TWAM_SW_RST Fld(1,2)//[2:2]
    #define SPM_TWAM_CON_REG_TWAM_IRQ_MASK Fld(1,3)//[3:3]
    #define SPM_TWAM_CON_REG_TWAM_MON_TYPE_0 Fld(2,4)//[5:4]
    #define SPM_TWAM_CON_REG_TWAM_MON_TYPE_1 Fld(2,6)//[7:6]
    #define SPM_TWAM_CON_REG_TWAM_MON_TYPE_2 Fld(2,8)//[9:8]
    #define SPM_TWAM_CON_REG_TWAM_MON_TYPE_3 Fld(2,10)//[11:10]
#define SPM_TWAM_WINDOW_LEN (SPM_BASE_ADDRESS + 0x0A4)
    #define SPM_TWAM_WINDOW_LEN_REG_TWAM_WINDOW_LEN Fld(32,0)//[31:0]
#define SPM_TWAM_IDLE_SEL (SPM_BASE_ADDRESS + 0x0A8)
    #define SPM_TWAM_IDLE_SEL_REG_TWAM_SIG_SEL_0 Fld(7,0)//[6:0]
    #define SPM_TWAM_IDLE_SEL_REG_TWAM_SIG_SEL_1 Fld(7,8)//[14:8]
    #define SPM_TWAM_IDLE_SEL_REG_TWAM_SIG_SEL_2 Fld(7,16)//[22:16]
    #define SPM_TWAM_IDLE_SEL_REG_TWAM_SIG_SEL_3 Fld(7,24)//[30:24]
#define SPM_SCP_IRQ (SPM_BASE_ADDRESS + 0x0AC)
    #define SPM_SCP_IRQ_SC_SPM2SCP_WAKEUP Fld(1,0)//[0:0]
    #define SPM_SCP_IRQ_SC_SCP2SPM_WAKEUP Fld(1,4)//[4:4]
#define SPM_CPU_WAKEUP_EVENT (SPM_BASE_ADDRESS + 0x0B0)
    #define SPM_CPU_WAKEUP_EVENT_REG_CPU_WAKEUP Fld(1,0)//[0:0]
#define SPM_IRQ_MASK (SPM_BASE_ADDRESS + 0x0B4)
    #define SPM_IRQ_MASK_REG_SPM_IRQ_MASK Fld(32,0)//[31:0]
#define SPM_SRC_REQ (SPM_BASE_ADDRESS + 0x0B8)
    #define SPM_SRC_REQ_REG_SPM_APSRC_REQ Fld(1,0)//[0:0]
    #define SPM_SRC_REQ_REG_SPM_F26M_REQ Fld(1,1)//[1:1]
    #define SPM_SRC_REQ_REG_SPM_INFRA_REQ Fld(1,3)//[3:3]
    #define SPM_SRC_REQ_REG_SPM_VRF18_REQ Fld(1,4)//[4:4]
    #define SPM_SRC_REQ_REG_SPM_DDR_EN_REQ Fld(1,7)//[7:7]
    #define SPM_SRC_REQ_REG_SPM_DVFS_REQ Fld(1,8)//[8:8]
    #define SPM_SRC_REQ_REG_SPM_SW_MAILBOX_REQ Fld(1,9)//[9:9]
    #define SPM_SRC_REQ_REG_SPM_SSPM_MAILBOX_REQ Fld(1,10)//[10:10]
    #define SPM_SRC_REQ_REG_SPM_ADSP_MAILBOX_REQ Fld(1,11)//[11:11]
    #define SPM_SRC_REQ_REG_SPM_SCP_MAILBOX_REQ Fld(1,12)//[12:12]
#define SPM_SRC_MASK (SPM_BASE_ADDRESS + 0x0BC)
    #define SPM_SRC_MASK_REG_MD_SRCCLKENA_0_MASK_B Fld(1,0)//[0:0]
    #define SPM_SRC_MASK_REG_MD_SRCCLKENA2INFRA_REQ_0_MASK_B Fld(1,1)//[1:1]
    #define SPM_SRC_MASK_REG_MD_APSRC2INFRA_REQ_0_MASK_B Fld(1,2)//[2:2]
    #define SPM_SRC_MASK_REG_MD_APSRC_REQ_0_MASK_B Fld(1,3)//[3:3]
    #define SPM_SRC_MASK_REG_MD_VRF18_REQ_0_MASK_B Fld(1,4)//[4:4]
    #define SPM_SRC_MASK_REG_MD_DDR_EN_0_MASK_B Fld(1,5)//[5:5]
    #define SPM_SRC_MASK_REG_MD_SRCCLKENA_1_MASK_B Fld(1,6)//[6:6]
    #define SPM_SRC_MASK_REG_MD_SRCCLKENA2INFRA_REQ_1_MASK_B Fld(1,7)//[7:7]
    #define SPM_SRC_MASK_REG_MD_APSRC2INFRA_REQ_1_MASK_B Fld(1,8)//[8:8]
    #define SPM_SRC_MASK_REG_MD_APSRC_REQ_1_MASK_B Fld(1,9)//[9:9]
    #define SPM_SRC_MASK_REG_MD_VRF18_REQ_1_MASK_B Fld(1,10)//[10:10]
    #define SPM_SRC_MASK_REG_MD_DDR_EN_1_MASK_B Fld(1,11)//[11:11]
    #define SPM_SRC_MASK_REG_CONN_SRCCLKENA_MASK_B Fld(1,12)//[12:12]
    #define SPM_SRC_MASK_REG_CONN_SRCCLKENB_MASK_B Fld(1,13)//[13:13]
    #define SPM_SRC_MASK_REG_CONN_INFRA_REQ_MASK_B Fld(1,14)//[14:14]
    #define SPM_SRC_MASK_REG_CONN_APSRC_REQ_MASK_B Fld(1,15)//[15:15]
    #define SPM_SRC_MASK_REG_CONN_VRF18_REQ_MASK_B Fld(1,16)//[16:16]
    #define SPM_SRC_MASK_REG_CONN_DDR_EN_MASK_B Fld(1,17)//[17:17]
    #define SPM_SRC_MASK_REG_CONN_VFE28_MASK_B Fld(1,18)//[18:18]
    #define SPM_SRC_MASK_REG_SRCCLKENI0_SRCCLKENA_MASK_B Fld(1,19)//[19:19]
    #define SPM_SRC_MASK_REG_SRCCLKENI0_INFRA_REQ_MASK_B Fld(1,20)//[20:20]
    #define SPM_SRC_MASK_REG_SRCCLKENI1_SRCCLKENA_MASK_B Fld(1,21)//[21:21]
    #define SPM_SRC_MASK_REG_SRCCLKENI1_INFRA_REQ_MASK_B Fld(1,22)//[22:22]
    #define SPM_SRC_MASK_REG_SRCCLKENI2_SRCCLKENA_MASK_B Fld(1,23)//[23:23]
    #define SPM_SRC_MASK_REG_SRCCLKENI2_INFRA_REQ_MASK_B Fld(1,24)//[24:24]
    #define SPM_SRC_MASK_REG_INFRASYS_APSRC_REQ_MASK_B Fld(1,25)//[25:25]
    #define SPM_SRC_MASK_REG_INFRASYS_DDR_EN_MASK_B Fld(1,26)//[26:26]
    #define SPM_SRC_MASK_REG_MD32_SRCCLKENA_MASK_B Fld(1,27)//[27:27]
    #define SPM_SRC_MASK_REG_MD32_INFRA_REQ_MASK_B Fld(1,28)//[28:28]
    #define SPM_SRC_MASK_REG_MD32_APSRC_REQ_MASK_B Fld(1,29)//[29:29]
    #define SPM_SRC_MASK_REG_MD32_VRF18_REQ_MASK_B Fld(1,30)//[30:30]
    #define SPM_SRC_MASK_REG_MD32_DDR_EN_MASK_B Fld(1,31)//[31:31]
#define SPM_SRC2_MASK (SPM_BASE_ADDRESS + 0x0C0)
    #define SPM_SRC2_MASK_REG_SCP_SRCCLKENA_MASK_B Fld(1,0)//[0:0]
    #define SPM_SRC2_MASK_REG_SCP_INFRA_REQ_MASK_B Fld(1,1)//[1:1]
    #define SPM_SRC2_MASK_REG_SCP_APSRC_REQ_MASK_B Fld(1,2)//[2:2]
    #define SPM_SRC2_MASK_REG_SCP_VRF18_REQ_MASK_B Fld(1,3)//[3:3]
    #define SPM_SRC2_MASK_REG_SCP_DDR_EN_MASK_B Fld(1,4)//[4:4]
    #define SPM_SRC2_MASK_REG_AUDIO_DSP_SRCCLKENA_MASK_B Fld(1,5)//[5:5]
    #define SPM_SRC2_MASK_REG_AUDIO_DSP_INFRA_REQ_MASK_B Fld(1,6)//[6:6]
    #define SPM_SRC2_MASK_REG_AUDIO_DSP_APSRC_REQ_MASK_B Fld(1,7)//[7:7]
    #define SPM_SRC2_MASK_REG_AUDIO_DSP_VRF18_REQ_MASK_B Fld(1,8)//[8:8]
    #define SPM_SRC2_MASK_REG_AUDIO_DSP_DDR_EN_MASK_B Fld(1,9)//[9:9]
    #define SPM_SRC2_MASK_REG_UFS_SRCCLKENA_MASK_B Fld(1,10)//[10:10]
    #define SPM_SRC2_MASK_REG_UFS_INFRA_REQ_MASK_B Fld(1,11)//[11:11]
    #define SPM_SRC2_MASK_REG_UFS_APSRC_REQ_MASK_B Fld(1,12)//[12:12]
    #define SPM_SRC2_MASK_REG_UFS_VRF18_REQ_MASK_B Fld(1,13)//[13:13]
    #define SPM_SRC2_MASK_REG_UFS_DDR_EN_MASK_B Fld(1,14)//[14:14]
    #define SPM_SRC2_MASK_REG_DISP0_APSRC_REQ_MASK_B Fld(1,15)//[15:15]
    #define SPM_SRC2_MASK_REG_DISP0_DDR_EN_MASK_B Fld(1,16)//[16:16]
    #define SPM_SRC2_MASK_REG_DISP1_APSRC_REQ_MASK_B Fld(1,17)//[17:17]
    #define SPM_SRC2_MASK_REG_DISP1_DDR_EN_MASK_B Fld(1,18)//[18:18]
    #define SPM_SRC2_MASK_REG_GCE_INFRA_REQ_MASK_B Fld(1,19)//[19:19]
    #define SPM_SRC2_MASK_REG_GCE_APSRC_REQ_MASK_B Fld(1,20)//[20:20]
    #define SPM_SRC2_MASK_REG_GCE_VRF18_REQ_MASK_B Fld(1,21)//[21:21]
    #define SPM_SRC2_MASK_REG_GCE_DDR_EN_MASK_B Fld(1,22)//[22:22]
    #define SPM_SRC2_MASK_REG_APU_SRCCLKENA_MASK_B Fld(1,23)//[23:23]
    #define SPM_SRC2_MASK_REG_APU_INFRA_REQ_MASK_B Fld(1,24)//[24:24]
    #define SPM_SRC2_MASK_REG_APU_APSRC_REQ_MASK_B Fld(1,25)//[25:25]
    #define SPM_SRC2_MASK_REG_APU_VRF18_REQ_MASK_B Fld(1,26)//[26:26]
    #define SPM_SRC2_MASK_REG_APU_DDR_EN_MASK_B Fld(1,27)//[27:27]
    #define SPM_SRC2_MASK_REG_CG_CHECK_SRCCLKENA_MASK_B Fld(1,28)//[28:28]
    #define SPM_SRC2_MASK_REG_CG_CHECK_APSRC_REQ_MASK_B Fld(1,29)//[29:29]
    #define SPM_SRC2_MASK_REG_CG_CHECK_VRF18_REQ_MASK_B Fld(1,30)//[30:30]
    #define SPM_SRC2_MASK_REG_CG_CHECK_DDR_EN_MASK_B Fld(1,31)//[31:31]
#define SPM_SRC3_MASK (SPM_BASE_ADDRESS + 0x0C4)
    #define SPM_SRC3_MASK_REG_DVFSRC_EVENT_TRIGGER_MASK_B Fld(1,0)//[0:0]
    #define SPM_SRC3_MASK_REG_SW2SPM_INT0_MASK_B Fld(1,1)//[1:1]
    #define SPM_SRC3_MASK_REG_SW2SPM_INT1_MASK_B Fld(1,2)//[2:2]
    #define SPM_SRC3_MASK_REG_SW2SPM_INT2_MASK_B Fld(1,3)//[3:3]
    #define SPM_SRC3_MASK_REG_SW2SPM_INT3_MASK_B Fld(1,4)//[4:4]
    #define SPM_SRC3_MASK_REG_SC_ADSP2SPM_WAKEUP_MASK_B Fld(1,5)//[5:5]
    #define SPM_SRC3_MASK_REG_SC_SSPM2SPM_WAKEUP_MASK_B Fld(4,6)//[9:6]
    #define SPM_SRC3_MASK_REG_SC_SCP2SPM_WAKEUP_MASK_B Fld(1,10)//[10:10]
    #define SPM_SRC3_MASK_REG_CSYSPWRREQ_MASK Fld(1,11)//[11:11]
    #define SPM_SRC3_MASK_REG_SPM_SRCCLKENA_RESERVED_MASK_B Fld(1,12)//[12:12]
    #define SPM_SRC3_MASK_REG_SPM_INFRA_REQ_RESERVED_MASK_B Fld(1,13)//[13:13]
    #define SPM_SRC3_MASK_REG_SPM_APSRC_REQ_RESERVED_MASK_B Fld(1,14)//[14:14]
    #define SPM_SRC3_MASK_REG_SPM_VRF18_REQ_RESERVED_MASK_B Fld(1,15)//[15:15]
    #define SPM_SRC3_MASK_REG_SPM_DDR_EN_RESERVED_MASK_B Fld(1,16)//[16:16]
    #define SPM_SRC3_MASK_REG_MCUPM_SRCCLKENA_MASK_B Fld(1,17)//[17:17]
    #define SPM_SRC3_MASK_REG_MCUPM_INFRA_REQ_MASK_B Fld(1,18)//[18:18]
    #define SPM_SRC3_MASK_REG_MCUPM_APSRC_REQ_MASK_B Fld(1,19)//[19:19]
    #define SPM_SRC3_MASK_REG_MCUPM_VRF18_REQ_MASK_B Fld(1,20)//[20:20]
    #define SPM_SRC3_MASK_REG_MCUPM_DDR_EN_MASK_B Fld(1,21)//[21:21]
    #define SPM_SRC3_MASK_REG_MSDC0_SRCCLKENA_MASK_B Fld(1,22)//[22:22]
    #define SPM_SRC3_MASK_REG_MSDC0_INFRA_REQ_MASK_B Fld(1,23)//[23:23]
    #define SPM_SRC3_MASK_REG_MSDC0_APSRC_REQ_MASK_B Fld(1,24)//[24:24]
    #define SPM_SRC3_MASK_REG_MSDC0_VRF18_REQ_MASK_B Fld(1,25)//[25:25]
    #define SPM_SRC3_MASK_REG_MSDC0_DDR_EN_MASK_B Fld(1,26)//[26:26]
    #define SPM_SRC3_MASK_REG_MSDC1_SRCCLKENA_MASK_B Fld(1,27)//[27:27]
    #define SPM_SRC3_MASK_REG_MSDC1_INFRA_REQ_MASK_B Fld(1,28)//[28:28]
    #define SPM_SRC3_MASK_REG_MSDC1_APSRC_REQ_MASK_B Fld(1,29)//[29:29]
    #define SPM_SRC3_MASK_REG_MSDC1_VRF18_REQ_MASK_B Fld(1,30)//[30:30]
    #define SPM_SRC3_MASK_REG_MSDC1_DDR_EN_MASK_B Fld(1,31)//[31:31]
#define SPM_SRC4_MASK (SPM_BASE_ADDRESS + 0x0C8)
    #define SPM_SRC4_MASK_CCIF_EVENT_MASK_B Fld(16,0)//[15:0]
    #define SPM_SRC4_MASK_REG_BAK_PSRI_SRCCLKENA_MASK_B Fld(1,16)//[16:16]
    #define SPM_SRC4_MASK_REG_BAK_PSRI_INFRA_REQ_MASK_B Fld(1,17)//[17:17]
    #define SPM_SRC4_MASK_REG_BAK_PSRI_APSRC_REQ_MASK_B Fld(1,18)//[18:18]
    #define SPM_SRC4_MASK_REG_BAK_PSRI_VRF18_REQ_MASK_B Fld(1,19)//[19:19]
    #define SPM_SRC4_MASK_REG_BAK_PSRI_DDR_EN_MASK_B Fld(1,20)//[20:20]
    #define SPM_SRC4_MASK_REG_DRAMC0_MD32_INFRA_REQ_MASK_B Fld(1,21)//[21:21]
    #define SPM_SRC4_MASK_REG_DRAMC0_MD32_VRF18_REQ_MASK_B Fld(1,22)//[22:22]
    #define SPM_SRC4_MASK_REG_DRAMC1_MD32_INFRA_REQ_MASK_B Fld(1,23)//[23:23]
    #define SPM_SRC4_MASK_REG_DRAMC1_MD32_VRF18_REQ_MASK_B Fld(1,24)//[24:24]
    #define SPM_SRC4_MASK_REG_CONN_SRCCLKENB2PWRAP_MASK_B Fld(1,25)//[25:25]
    #define SPM_SRC4_MASK_REG_DRAMC0_MD32_WAKEUP_MASK Fld(1,26)//[26:26]
    #define SPM_SRC4_MASK_REG_DRAMC1_MD32_WAKEUP_MASK Fld(1,27)//[27:27]
#define SPM_SRC5_MASK (SPM_BASE_ADDRESS + 0x0CC)
    #define SPM_SRC5_MASK_REG_MCUSYS_MERGE_APSRC_REQ_MASK_B Fld(9,0)//[8:0]
    #define SPM_SRC5_MASK_REG_MCUSYS_MERGE_DDR_EN_MASK_B Fld(9,9)//[17:9]
    #define SPM_SRC5_MASK_REG_MSDC2_SRCCLKENA_MASK_B Fld(1,18)//[18:18]
    #define SPM_SRC5_MASK_REG_MSDC2_INFRA_REQ_MASK_B Fld(1,19)//[19:19]
    #define SPM_SRC5_MASK_REG_MSDC2_APSRC_REQ_MASK_B Fld(1,20)//[20:20]
    #define SPM_SRC5_MASK_REG_MSDC2_VRF18_REQ_MASK_B Fld(1,21)//[21:21]
    #define SPM_SRC5_MASK_REG_MSDC2_DDR_EN_MASK_B Fld(1,22)//[22:22]
    #define SPM_SRC5_MASK_REG_PCIE_SRCCLKENA_MASK_B Fld(1,23)//[23:23]
    #define SPM_SRC5_MASK_REG_PCIE_INFRA_REQ_MASK_B Fld(1,24)//[24:24]
    #define SPM_SRC5_MASK_REG_PCIE_APSRC_REQ_MASK_B Fld(1,25)//[25:25]
    #define SPM_SRC5_MASK_REG_PCIE_VRF18_REQ_MASK_B Fld(1,26)//[26:26]
    #define SPM_SRC5_MASK_REG_PCIE_DDR_EN_MASK_B Fld(1,27)//[27:27]
#define SPM_SRC6_MASK (SPM_BASE_ADDRESS + 0x038)
    #define SPM_SRC6_MASK_REG_DPMAIF_SRCCLKENA_MASK_B Fld(1,0)//[0:0]
    #define SPM_SRC6_MASK_REG_DPMAIF_INFRA_REQ_MASK_B Fld(1,1)//[1:1]
    #define SPM_SRC6_MASK_REG_DPMAIF_APSRC_REQ_MASK_B Fld(1,2)//[2:2]
    #define SPM_SRC6_MASK_REG_DPMAIF_VRF18_REQ_MASK_B Fld(1,3)//[3:3]
    #define SPM_SRC6_MASK_REG_DPMAIF_DDR_EN_MASK_B Fld(1,4)//[4:4]
#define SPM_WAKEUP_EVENT_MASK (SPM_BASE_ADDRESS + 0x0D0)
    #define SPM_WAKEUP_EVENT_MASK_REG_WAKEUP_EVENT_MASK Fld(32,0)//[31:0]
#define SPM_WAKEUP_EVENT_EXT_MASK (SPM_BASE_ADDRESS + 0x0D4)
    #define SPM_WAKEUP_EVENT_EXT_MASK_REG_EXT_WAKEUP_EVENT_MASK Fld(32,0)//[31:0]
#define SPM_TWAM_EVENT_CLEAR (SPM_BASE_ADDRESS + 0x0D8)
    #define SPM_TWAM_EVENT_CLEAR_SPM_TWAM_EVENT_CLEAR Fld(1,0)//[0:0]
#define SCP_CLK_CON (SPM_BASE_ADDRESS + 0x0DC)
    #define SCP_CLK_CON_REG_SCP_26M_CK_SEL Fld(1,0)//[0:0]
    #define SCP_CLK_CON_REG_SCP_DCM_EN Fld(1,1)//[1:1]
    #define SCP_CLK_CON_SCP_SECURE_V_REQ_MASK Fld(1,2)//[2:2]
    #define SCP_CLK_CON_SCP_SLP_REQ Fld(1,3)//[3:3]
    #define SCP_CLK_CON_SCP_SLP_ACK Fld(1,4)//[4:4]
#define PCM_DEBUG_CON (SPM_BASE_ADDRESS + 0x0E0)
    #define PCM_DEBUG_CON_PCM_DEBUG_OUT_ENABLE Fld(1,0)//[0:0]
#define AHB_BUS_CON (SPM_BASE_ADDRESS + 0x0E4)
    #define AHB_BUS_CON_AHB_HADDR_EXT Fld(2,0)//[1:0]
    #define AHB_BUS_CON_REG_AHB_LOCK Fld(1,8)//[8:8]
#define DDR_EN_DBC_CON0 (SPM_BASE_ADDRESS + 0x0E8)
    #define DDR_EN_DBC_CON0_REG_ALL_DDR_EN_DBC_LEN Fld(10,0)//[9:0]
    #define DDR_EN_DBC_CON0_REG_MD_DDR_EN_0_DBC_LEN Fld(10,10)//[19:10]
    #define DDR_EN_DBC_CON0_REG_HW_S1_DBC_LEN Fld(10,20)//[29:20]
#define DDR_EN_DBC_CON1 (SPM_BASE_ADDRESS + 0x0EC)
    #define DDR_EN_DBC_CON1_REG_ALL_DDR_EN_DBC_EN Fld(1,0)//[0:0]
    #define DDR_EN_DBC_CON1_REG_MD_DDR_EN_0_DBC_EN Fld(1,1)//[1:1]
    #define DDR_EN_DBC_CON1_REG_HW_S1_DBC_EN Fld(1,2)//[2:2]
#define SPM_RESOURCE_ACK_CON0 (SPM_BASE_ADDRESS + 0x0F0)
    #define SPM_RESOURCE_ACK_CON0_REG_MD_SRCCLKENA_ACK_0_MASK Fld(1,0)//[0:0]
    #define SPM_RESOURCE_ACK_CON0_REG_MD_INFRA_ACK_0_MASK Fld(1,1)//[1:1]
    #define SPM_RESOURCE_ACK_CON0_REG_MD_APSRC_ACK_0_MASK Fld(1,2)//[2:2]
    #define SPM_RESOURCE_ACK_CON0_REG_MD_VRF18_ACK_0_MASK Fld(1,3)//[3:3]
    #define SPM_RESOURCE_ACK_CON0_REG_MD_DDR_EN_ACK_0_MASK Fld(1,4)//[4:4]
    #define SPM_RESOURCE_ACK_CON0_REG_MD_SRCCLKENA_ACK_1_MASK Fld(1,5)//[5:5]
    #define SPM_RESOURCE_ACK_CON0_REG_MD_INFRA_ACK_1_MASK Fld(1,6)//[6:6]
    #define SPM_RESOURCE_ACK_CON0_REG_MD_APSRC_ACK_1_MASK Fld(1,7)//[7:7]
    #define SPM_RESOURCE_ACK_CON0_REG_MD_VRF18_ACK_1_MASK Fld(1,8)//[8:8]
    #define SPM_RESOURCE_ACK_CON0_REG_MD_DDR_EN_ACK_1_MASK Fld(1,9)//[9:9]
    #define SPM_RESOURCE_ACK_CON0_REG_CONN_SRCCLKENA_ACK_MASK Fld(1,10)//[10:10]
    #define SPM_RESOURCE_ACK_CON0_REG_CONN_INFRA_ACK_MASK Fld(1,11)//[11:11]
    #define SPM_RESOURCE_ACK_CON0_REG_CONN_APSRC_ACK_MASK Fld(1,12)//[12:12]
    #define SPM_RESOURCE_ACK_CON0_REG_CONN_VRF18_ACK_MASK Fld(1,13)//[13:13]
    #define SPM_RESOURCE_ACK_CON0_REG_CONN_DDR_EN_ACK_MASK Fld(1,14)//[14:14]
    #define SPM_RESOURCE_ACK_CON0_REG_MD32_SRCCLKENA_ACK_MASK Fld(1,15)//[15:15]
    #define SPM_RESOURCE_ACK_CON0_REG_MD32_INFRA_ACK_MASK Fld(1,16)//[16:16]
    #define SPM_RESOURCE_ACK_CON0_REG_MD32_APSRC_ACK_MASK Fld(1,17)//[17:17]
    #define SPM_RESOURCE_ACK_CON0_REG_MD32_VRF18_ACK_MASK Fld(1,18)//[18:18]
    #define SPM_RESOURCE_ACK_CON0_REG_MD32_DDR_EN_ACK_MASK Fld(1,19)//[19:19]
    #define SPM_RESOURCE_ACK_CON0_REG_SCP_SRCCLKENA_ACK_MASK Fld(1,20)//[20:20]
    #define SPM_RESOURCE_ACK_CON0_REG_SCP_INFRA_ACK_MASK Fld(1,21)//[21:21]
    #define SPM_RESOURCE_ACK_CON0_REG_SCP_APSRC_ACK_MASK Fld(1,22)//[22:22]
    #define SPM_RESOURCE_ACK_CON0_REG_SCP_VRF18_ACK_MASK Fld(1,23)//[23:23]
    #define SPM_RESOURCE_ACK_CON0_REG_SCP_DDR_EN_ACK_MASK Fld(1,24)//[24:24]
    #define SPM_RESOURCE_ACK_CON0_REG_AUDIO_DSP_SRCCLKENA_ACK_MASK Fld(1,25)//[25:25]
    #define SPM_RESOURCE_ACK_CON0_REG_AUDIO_DSP_INFRA_ACK_MASK Fld(1,26)//[26:26]
    #define SPM_RESOURCE_ACK_CON0_REG_AUDIO_DSP_APSRC_ACK_MASK Fld(1,27)//[27:27]
    #define SPM_RESOURCE_ACK_CON0_REG_AUDIO_DSP_VRF18_ACK_MASK Fld(1,28)//[28:28]
    #define SPM_RESOURCE_ACK_CON0_REG_AUDIO_DSP_DDR_EN_ACK_MASK Fld(1,29)//[29:29]
    #define SPM_RESOURCE_ACK_CON0_REG_DISP0_DDR_EN_ACK_MASK Fld(1,30)//[30:30]
    #define SPM_RESOURCE_ACK_CON0_REG_DISP1_APSRC_ACK_MASK Fld(1,31)//[31:31]

//Page SPM_2
#define SPM_RESOURCE_ACK_CON1 (SPM_BASE_ADDRESS + 0x0F4)
    #define SPM_RESOURCE_ACK_CON1_REG_UFS_SRCCLKENA_ACK_MASK Fld(1,0)//[0:0]
    #define SPM_RESOURCE_ACK_CON1_REG_UFS_INFRA_ACK_MASK Fld(1,1)//[1:1]
    #define SPM_RESOURCE_ACK_CON1_REG_UFS_APSRC_ACK_MASK Fld(1,2)//[2:2]
    #define SPM_RESOURCE_ACK_CON1_REG_UFS_VRF18_ACK_MASK Fld(1,3)//[3:3]
    #define SPM_RESOURCE_ACK_CON1_REG_UFS_DDR_EN_ACK_MASK Fld(1,4)//[4:4]
    #define SPM_RESOURCE_ACK_CON1_REG_APU_SRCCLKENA_ACK_MASK Fld(1,5)//[5:5]
    #define SPM_RESOURCE_ACK_CON1_REG_APU_INFRA_ACK_MASK Fld(1,6)//[6:6]
    #define SPM_RESOURCE_ACK_CON1_REG_APU_APSRC_ACK_MASK Fld(1,7)//[7:7]
    #define SPM_RESOURCE_ACK_CON1_REG_APU_VRF18_ACK_MASK Fld(1,8)//[8:8]
    #define SPM_RESOURCE_ACK_CON1_REG_APU_DDR_EN_ACK_MASK Fld(1,9)//[9:9]
    #define SPM_RESOURCE_ACK_CON1_REG_MCUPM_SRCCLKENA_ACK_MASK Fld(1,10)//[10:10]
    #define SPM_RESOURCE_ACK_CON1_REG_MCUPM_INFRA_ACK_MASK Fld(1,11)//[11:11]
    #define SPM_RESOURCE_ACK_CON1_REG_MCUPM_APSRC_ACK_MASK Fld(1,12)//[12:12]
    #define SPM_RESOURCE_ACK_CON1_REG_MCUPM_VRF18_ACK_MASK Fld(1,13)//[13:13]
    #define SPM_RESOURCE_ACK_CON1_REG_MCUPM_DDR_EN_ACK_MASK Fld(1,14)//[14:14]
    #define SPM_RESOURCE_ACK_CON1_REG_MSDC0_SRCCLKENA_ACK_MASK Fld(1,15)//[15:15]
    #define SPM_RESOURCE_ACK_CON1_REG_MSDC0_INFRA_ACK_MASK Fld(1,16)//[16:16]
    #define SPM_RESOURCE_ACK_CON1_REG_MSDC0_APSRC_ACK_MASK Fld(1,17)//[17:17]
    #define SPM_RESOURCE_ACK_CON1_REG_MSDC0_VRF18_ACK_MASK Fld(1,18)//[18:18]
    #define SPM_RESOURCE_ACK_CON1_REG_MSDC0_DDR_EN_ACK_MASK Fld(1,19)//[19:19]
    #define SPM_RESOURCE_ACK_CON1_REG_MSDC1_SRCCLKENA_ACK_MASK Fld(1,20)//[20:20]
    #define SPM_RESOURCE_ACK_CON1_REG_MSDC1_INFRA_ACK_MASK Fld(1,21)//[21:21]
    #define SPM_RESOURCE_ACK_CON1_REG_MSDC1_APSRC_ACK_MASK Fld(1,22)//[22:22]
    #define SPM_RESOURCE_ACK_CON1_REG_MSDC1_VRF18_ACK_MASK Fld(1,23)//[23:23]
    #define SPM_RESOURCE_ACK_CON1_REG_MSDC1_DDR_EN_ACK_MASK Fld(1,24)//[24:24]
    #define SPM_RESOURCE_ACK_CON1_REG_DISP0_APSRC_ACK_MASK Fld(1,25)//[25:25]
    #define SPM_RESOURCE_ACK_CON1_REG_DISP1_DDR_EN_ACK_MASK Fld(1,26)//[26:26]
    #define SPM_RESOURCE_ACK_CON1_REG_GCE_INFRA_ACK_MASK Fld(1,27)//[27:27]
    #define SPM_RESOURCE_ACK_CON1_REG_GCE_APSRC_ACK_MASK Fld(1,28)//[28:28]
    #define SPM_RESOURCE_ACK_CON1_REG_GCE_VRF18_ACK_MASK Fld(1,29)//[29:29]
    #define SPM_RESOURCE_ACK_CON1_REG_GCE_DDR_EN_ACK_MASK Fld(1,30)//[30:30]
#define SPM_RESOURCE_ACK_CON2 (SPM_BASE_ADDRESS + 0x0F8)
    #define SPM_RESOURCE_ACK_CON2_SPM_F26M_ACK_WAIT_CYCLE Fld(8,0)//[7:0]
    #define SPM_RESOURCE_ACK_CON2_SPM_INFRA_ACK_WAIT_CYCLE Fld(8,8)//[15:8]
    #define SPM_RESOURCE_ACK_CON2_SPM_APSRC_ACK_WAIT_CYCLE Fld(8,16)//[23:16]
    #define SPM_RESOURCE_ACK_CON2_SPM_VRF18_ACK_WAIT_CYCLE Fld(8,24)//[31:24]
#define SPM_RESOURCE_ACK_CON3 (SPM_BASE_ADDRESS + 0x0FC)
    #define SPM_RESOURCE_ACK_CON3_SPM_DDR_EN_ACK_WAIT_CYCLE Fld(8,0)//[7:0]
    #define SPM_RESOURCE_ACK_CON3_REG_BAK_PSRI_SRCCLKENA_ACK_MASK Fld(1,8)//[8:8]
    #define SPM_RESOURCE_ACK_CON3_REG_BAK_PSRI_INFRA_ACK_MASK Fld(1,9)//[9:9]
    #define SPM_RESOURCE_ACK_CON3_REG_BAK_PSRI_APSRC_ACK_MASK Fld(1,10)//[10:10]
    #define SPM_RESOURCE_ACK_CON3_REG_BAK_PSRI_VRF18_ACK_MASK Fld(1,11)//[11:11]
    #define SPM_RESOURCE_ACK_CON3_REG_BAK_PSRI_DDR_EN_ACK_MASK Fld(1,12)//[12:12]
    #define SPM_RESOURCE_ACK_CON3_REG_MSDC2_SRCCLKENA_ACK_MASK Fld(1,13)//[13:13]
    #define SPM_RESOURCE_ACK_CON3_REG_MSDC2_INFRA_ACK_MASK Fld(1,14)//[14:14]
    #define SPM_RESOURCE_ACK_CON3_REG_MSDC2_APSRC_ACK_MASK Fld(1,15)//[15:15]
    #define SPM_RESOURCE_ACK_CON3_REG_MSDC2_VRF18_ACK_MASK Fld(1,16)//[16:16]
    #define SPM_RESOURCE_ACK_CON3_REG_MSDC2_DDR_EN_ACK_MASK Fld(1,17)//[17:17]
    #define SPM_RESOURCE_ACK_CON3_REG_PCIE_SRCCLKENA_ACK_MASK Fld(1,18)//[18:18]
    #define SPM_RESOURCE_ACK_CON3_REG_PCIE_INFRA_ACK_MASK Fld(1,19)//[19:19]
    #define SPM_RESOURCE_ACK_CON3_REG_PCIE_APSRC_ACK_MASK Fld(1,20)//[20:20]
    #define SPM_RESOURCE_ACK_CON3_REG_PCIE_VRF18_ACK_MASK Fld(1,21)//[21:21]
    #define SPM_RESOURCE_ACK_CON3_REG_PCIE_DDR_EN_ACK_MASK Fld(1,22)//[22:22]
    #define SPM_RESOURCE_ACK_CON3_REG_DPMAIF_SRCCLKENA_ACK_MASK Fld(1,23)//[23:23]
    #define SPM_RESOURCE_ACK_CON3_REG_DPMAIF_INFRA_ACK_MASK Fld(1,24)//[24:24]
    #define SPM_RESOURCE_ACK_CON3_REG_DPMAIF_APSRC_ACK_MASK Fld(1,25)//[25:25]
    #define SPM_RESOURCE_ACK_CON3_REG_DPMAIF_VRF18_ACK_MASK Fld(1,26)//[26:26]
    #define SPM_RESOURCE_ACK_CON3_REG_DPMAIF_DDR_EN_ACK_MASK Fld(1,27)//[27:27]
#define PCM_REG0_DATA (SPM_BASE_ADDRESS + 0x100)
    #define PCM_REG0_DATA_PCM_REG0_RF Fld(32,0)//[31:0]
#define PCM_REG2_DATA (SPM_BASE_ADDRESS + 0x104)
    #define PCM_REG2_DATA_PCM_REG2_RF Fld(32,0)//[31:0]
#define PCM_REG6_DATA (SPM_BASE_ADDRESS + 0x108)
    #define PCM_REG6_DATA_PCM_REG6_RF Fld(32,0)//[31:0]
#define PCM_REG7_DATA (SPM_BASE_ADDRESS + 0x10C)
    #define PCM_REG7_DATA_PCM_REG7_RF Fld(32,0)//[31:0]
#define PCM_REG13_DATA (SPM_BASE_ADDRESS + 0x110)
    #define PCM_REG13_DATA_PCM_REG13_RF Fld(32,0)//[31:0]
#define SRC_REQ_STA_0 (SPM_BASE_ADDRESS + 0x114)
    #define SRC_REQ_STA_0_MD_SRCCLKENA_0 Fld(1,0)//[0:0]
    #define SRC_REQ_STA_0_MD_SRCCLKENA2INFRA_REQ_0 Fld(1,1)//[1:1]
    #define SRC_REQ_STA_0_MD_APSRC2INFRA_REQ_0 Fld(1,2)//[2:2]
    #define SRC_REQ_STA_0_MD_APSRC_REQ_0 Fld(1,3)//[3:3]
    #define SRC_REQ_STA_0_MD_VRF18_REQ_0 Fld(1,4)//[4:4]
    #define SRC_REQ_STA_0_MD_DDR_EN_0 Fld(1,5)//[5:5]
    #define SRC_REQ_STA_0_MD_SRCCLKENA_1 Fld(1,6)//[6:6]
    #define SRC_REQ_STA_0_MD_SRCCLKENA2INFRA_REQ_1 Fld(1,7)//[7:7]
    #define SRC_REQ_STA_0_MD_APSRC2INFRA_REQ_1 Fld(1,8)//[8:8]
    #define SRC_REQ_STA_0_MD_APSRC_REQ_1 Fld(1,9)//[9:9]
    #define SRC_REQ_STA_0_MD_VRF18_REQ_1 Fld(1,10)//[10:10]
    #define SRC_REQ_STA_0_MD_DDR_EN_1 Fld(1,11)//[11:11]
    #define SRC_REQ_STA_0_CONN_SRCCLKENA Fld(1,12)//[12:12]
    #define SRC_REQ_STA_0_CONN_SRCCLKENB Fld(1,13)//[13:13]
    #define SRC_REQ_STA_0_CONN_INFRA_REQ Fld(1,14)//[14:14]
    #define SRC_REQ_STA_0_CONN_APSRC_REQ Fld(1,15)//[15:15]
    #define SRC_REQ_STA_0_CONN_VRF18_REQ Fld(1,16)//[16:16]
    #define SRC_REQ_STA_0_CONN_DDR_EN Fld(1,17)//[17:17]
    #define SRC_REQ_STA_0_SRCCLKENI Fld(3,18)//[20:18]
    #define SRC_REQ_STA_0_MD32_SRCCLKENA Fld(1,21)//[21:21]
    #define SRC_REQ_STA_0_MD32_INFRA_REQ Fld(1,22)//[22:22]
    #define SRC_REQ_STA_0_MD32_APSRC_REQ Fld(1,23)//[23:23]
    #define SRC_REQ_STA_0_MD32_VRF18_REQ Fld(1,24)//[24:24]
    #define SRC_REQ_STA_0_MD32_DDR_EN Fld(1,25)//[25:25]
    #define SRC_REQ_STA_0_DISP0_APSRC_REQ Fld(1,26)//[26:26]
    #define SRC_REQ_STA_0_DISP0_DDR_EN Fld(1,27)//[27:27]
    #define SRC_REQ_STA_0_DISP1_APSRC_REQ Fld(1,28)//[28:28]
    #define SRC_REQ_STA_0_DISP1_DDR_EN Fld(1,29)//[29:29]
    #define SRC_REQ_STA_0_DVFSRC_EVENT_TRIGGER Fld(1,30)//[30:30]
#define SRC_REQ_STA_1 (SPM_BASE_ADDRESS + 0x118)
    #define SRC_REQ_STA_1_SCP_SRCCLKENA Fld(1,0)//[0:0]
    #define SRC_REQ_STA_1_SCP_INFRA_REQ Fld(1,1)//[1:1]
    #define SRC_REQ_STA_1_SCP_APSRC_REQ Fld(1,2)//[2:2]
    #define SRC_REQ_STA_1_SCP_VRF18_REQ Fld(1,3)//[3:3]
    #define SRC_REQ_STA_1_SCP_DDR_EN Fld(1,4)//[4:4]
    #define SRC_REQ_STA_1_AUDIO_DSP_SRCCLKENA Fld(1,5)//[5:5]
    #define SRC_REQ_STA_1_AUDIO_DSP_INFRA_REQ Fld(1,6)//[6:6]
    #define SRC_REQ_STA_1_AUDIO_DSP_APSRC_REQ Fld(1,7)//[7:7]
    #define SRC_REQ_STA_1_AUDIO_DSP_VRF18_REQ Fld(1,8)//[8:8]
    #define SRC_REQ_STA_1_AUDIO_DSP_DDR_EN Fld(1,9)//[9:9]
    #define SRC_REQ_STA_1_UFS_SRCCLKENA Fld(1,10)//[10:10]
    #define SRC_REQ_STA_1_UFS_INFRA_REQ Fld(1,11)//[11:11]
    #define SRC_REQ_STA_1_UFS_APSRC_REQ Fld(1,12)//[12:12]
    #define SRC_REQ_STA_1_UFS_VRF18_REQ Fld(1,13)//[13:13]
    #define SRC_REQ_STA_1_UFS_DDR_EN Fld(1,14)//[14:14]
    #define SRC_REQ_STA_1_GCE_INFRA_REQ Fld(1,15)//[15:15]
    #define SRC_REQ_STA_1_GCE_APSRC_REQ Fld(1,16)//[16:16]
    #define SRC_REQ_STA_1_GCE_VRF18_REQ Fld(1,17)//[17:17]
    #define SRC_REQ_STA_1_GCE_DDR_EN Fld(1,18)//[18:18]
    #define SRC_REQ_STA_1_INFRASYS_APSRC_REQ Fld(1,19)//[19:19]
    #define SRC_REQ_STA_1_INFRASYS_DDR_EN Fld(1,20)//[20:20]
    #define SRC_REQ_STA_1_MSDC0_SRCCLKENA Fld(1,21)//[21:21]
    #define SRC_REQ_STA_1_MSDC0_INFRA_REQ Fld(1,22)//[22:22]
    #define SRC_REQ_STA_1_MSDC0_APSRC_REQ Fld(1,23)//[23:23]
    #define SRC_REQ_STA_1_MSDC0_VRF18_REQ Fld(1,24)//[24:24]
    #define SRC_REQ_STA_1_MSDC0_DDR_EN Fld(1,25)//[25:25]
    #define SRC_REQ_STA_1_MSDC1_SRCCLKENA Fld(1,26)//[26:26]
    #define SRC_REQ_STA_1_MSDC1_INFRA_REQ Fld(1,27)//[27:27]
    #define SRC_REQ_STA_1_MSDC1_APSRC_REQ Fld(1,28)//[28:28]
    #define SRC_REQ_STA_1_MSDC1_VRF18_REQ Fld(1,29)//[29:29]
    #define SRC_REQ_STA_1_MSDC1_DDR_EN Fld(1,30)//[30:30]
#define SRC_REQ_STA_2 (SPM_BASE_ADDRESS + 0x11C)
    #define SRC_REQ_STA_2_MCUSYS_MERGE_DDR_EN Fld(9,0)//[8:0]
    #define SRC_REQ_STA_2_EMI_SELF_REFRESH_CH Fld(2,9)//[10:9]
    #define SRC_REQ_STA_2_SW2SPM_INT Fld(4,11)//[14:11]
    #define SRC_REQ_STA_2_SC_ADSP2SPM_WAKEUP Fld(1,15)//[15:15]
    #define SRC_REQ_STA_2_SC_SSPM2SPM_WAKEUP Fld(4,16)//[19:16]
    #define SRC_REQ_STA_2_SC_SCP2SPM_WAKEUP Fld(1,20)//[20:20]
    #define SRC_REQ_STA_2_SPM_SRCCLKENA_RESERVED Fld(1,21)//[21:21]
    #define SRC_REQ_STA_2_SPM_INFRA_REQ_RESERVED Fld(1,22)//[22:22]
    #define SRC_REQ_STA_2_SPM_APSRC_REQ_RESERVED Fld(1,23)//[23:23]
    #define SRC_REQ_STA_2_SPM_VRF18_REQ_RESERVED Fld(1,24)//[24:24]
    #define SRC_REQ_STA_2_SPM_DDR_EN_RESERVED Fld(1,25)//[25:25]
    #define SRC_REQ_STA_2_MCUPM_SRCCLKENA Fld(1,26)//[26:26]
    #define SRC_REQ_STA_2_MCUPM_INFRA_REQ Fld(1,27)//[27:27]
    #define SRC_REQ_STA_2_MCUPM_APSRC_REQ Fld(1,28)//[28:28]
    #define SRC_REQ_STA_2_MCUPM_VRF18_REQ Fld(1,29)//[29:29]
    #define SRC_REQ_STA_2_MCUPM_DDR_EN Fld(1,30)//[30:30]
#define PCM_TIMER_OUT (SPM_BASE_ADDRESS + 0x120)
    #define PCM_TIMER_OUT_PCM_TIMER Fld(32,0)//[31:0]
#define PCM_WDT_OUT (SPM_BASE_ADDRESS + 0x124)
    #define PCM_WDT_OUT_PCM_WDT_TIMER_VAL_OUT Fld(32,0)//[31:0]
#define SPM_IRQ_STA (SPM_BASE_ADDRESS + 0x128)
    #define SPM_IRQ_STA_PCM_IRQ Fld(1,3)//[3:3]
    #define SPM_IRQ_STA_TWAM_IRQ Fld(1,2)//[2:2]
#define SRC_REQ_STA_4 (SPM_BASE_ADDRESS + 0x12C)
    #define SRC_REQ_STA_4_APU_SRCCLKENA Fld(1,0)//[0:0]
    #define SRC_REQ_STA_4_APU_INFRA_REQ Fld(1,1)//[1:1]
    #define SRC_REQ_STA_4_APU_APSRC_REQ Fld(1,2)//[2:2]
    #define SRC_REQ_STA_4_APU_VRF18_REQ Fld(1,3)//[3:3]
    #define SRC_REQ_STA_4_APU_DDR_EN Fld(1,4)//[4:4]
    #define SRC_REQ_STA_4_BAK_PSRI_SRCCLKENA Fld(1,5)//[5:5]
    #define SRC_REQ_STA_4_BAK_PSRI_INFRA_REQ Fld(1,6)//[6:6]
    #define SRC_REQ_STA_4_BAK_PSRI_APSRC_REQ Fld(1,7)//[7:7]
    #define SRC_REQ_STA_4_BAK_PSRI_VRF18_REQ Fld(1,8)//[8:8]
    #define SRC_REQ_STA_4_BAK_PSRI_DDR_EN Fld(1,9)//[9:9]
    #define SRC_REQ_STA_4_MSDC2_SRCCLKENA Fld(1,10)//[10:10]
    #define SRC_REQ_STA_4_MSDC2_INFRA_REQ Fld(1,11)//[11:11]
    #define SRC_REQ_STA_4_MSDC2_APSRC_REQ Fld(1,12)//[12:12]
    #define SRC_REQ_STA_4_MSDC2_VRF18_REQ Fld(1,13)//[13:13]
    #define SRC_REQ_STA_4_MSDC2_DDR_EN Fld(1,14)//[14:14]
    #define SRC_REQ_STA_4_PCIE_SRCCLKENA Fld(1,15)//[15:15]
    #define SRC_REQ_STA_4_PCIE_INFRA_REQ Fld(1,16)//[16:16]
    #define SRC_REQ_STA_4_PCIE_APSRC_REQ Fld(1,17)//[17:17]
    #define SRC_REQ_STA_4_PCIE_VRF18_REQ Fld(1,18)//[18:18]
    #define SRC_REQ_STA_4_PCIE_DDR_EN Fld(1,19)//[19:19]
    #define SRC_REQ_STA_4_DPMAIF_SRCCLKENA Fld(1,20)//[20:20]
    #define SRC_REQ_STA_4_DPMAIF_INFRA_REQ Fld(1,21)//[21:21]
    #define SRC_REQ_STA_4_DPMAIF_APSRC_REQ Fld(1,22)//[22:22]
    #define SRC_REQ_STA_4_DPMAIF_VRF18_REQ Fld(1,23)//[23:23]
    #define SRC_REQ_STA_4_DPMAIF_DDR_EN Fld(1,24)//[24:24]
#define MD32PCM_WAKEUP_STA (SPM_BASE_ADDRESS + 0x130)
    #define MD32PCM_WAKEUP_STA_MD32PCM_WAKEUP_STA Fld(32,0)//[31:0]
#define MD32PCM_EVENT_STA (SPM_BASE_ADDRESS + 0x134)
    #define MD32PCM_EVENT_STA_MD32PCM_EVENT_STA Fld(32,0)//[31:0]
#define SPM_WAKEUP_STA (SPM_BASE_ADDRESS + 0x138)
    #define SPM_WAKEUP_STA_F32K_WAKEUP_EVENT_L Fld(16,0)//[15:0]
    #define SPM_WAKEUP_STA_ASYN_WAKEUP_EVENT_L Fld(16,16)//[31:16]
#define SPM_WAKEUP_EXT_STA (SPM_BASE_ADDRESS + 0x13C)
    #define SPM_WAKEUP_EXT_STA_EXT_WAKEUP_EVENT Fld(32,0)//[31:0]
#define SPM_WAKEUP_MISC (SPM_BASE_ADDRESS + 0x140)
    #define SPM_WAKEUP_MISC_GIC_WAKEUP Fld(10,0)//[9:0]
    #define SPM_WAKEUP_MISC_DVFSRC_IRQ Fld(1,16)//[16:16]
    #define SPM_WAKEUP_MISC_REG_CPU_WAKEUP Fld(1,17)//[17:17]
    #define SPM_WAKEUP_MISC_PCM_TIMER_EVENT Fld(1,18)//[18:18]
    #define SPM_WAKEUP_MISC_PMIC_EINT_OUT_B Fld(2,19)//[20:19]
    #define SPM_WAKEUP_MISC_TWAM_IRQ_B Fld(1,21)//[21:21]
    #define SPM_WAKEUP_MISC_PMSR_IRQ_B_SET0 Fld(1,22)//[22:22]
    #define SPM_WAKEUP_MISC_PMSR_IRQ_B_SET1 Fld(1,23)//[23:23]
    #define SPM_WAKEUP_MISC_PMSR_IRQ_B_SET2 Fld(1,24)//[24:24]
    #define SPM_WAKEUP_MISC_SPM_ACK_CHK_WAKEUP_0 Fld(1,25)//[25:25]
    #define SPM_WAKEUP_MISC_SPM_ACK_CHK_WAKEUP_1 Fld(1,26)//[26:26]
    #define SPM_WAKEUP_MISC_SPM_ACK_CHK_WAKEUP_2 Fld(1,27)//[27:27]
    #define SPM_WAKEUP_MISC_SPM_ACK_CHK_WAKEUP_3 Fld(1,28)//[28:28]
    #define SPM_WAKEUP_MISC_SPM_ACK_CHK_WAKEUP_ALL Fld(1,29)//[29:29]
    #define SPM_WAKEUP_MISC_PMIC_IRQ_ACK Fld(1,30)//[30:30]
    #define SPM_WAKEUP_MISC_PMIC_SCP_IRQ Fld(1,31)//[31:31]
#define MM_DVFS_HALT (SPM_BASE_ADDRESS + 0x144)
    #define MM_DVFS_HALT_MM_DVFS_HALT Fld(5,0)//[4:0]
#define BUS_PROTECT_RDY (SPM_BASE_ADDRESS + 0x150)
    #define BUS_PROTECT_RDY_PROTECT_READY Fld(32,0)//[31:0]
#define BUS_PROTECT1_RDY (SPM_BASE_ADDRESS + 0x154)
    #define BUS_PROTECT1_RDY_PROTECT1_READY Fld(32,0)//[31:0]
#define BUS_PROTECT2_RDY (SPM_BASE_ADDRESS + 0x158)
    #define BUS_PROTECT2_RDY_PROTECT2_READY Fld(32,0)//[31:0]
#define BUS_PROTECT3_RDY (SPM_BASE_ADDRESS + 0x15C)
    #define BUS_PROTECT3_RDY_PROTECT3_READY Fld(32,0)//[31:0]
#define SUBSYS_IDLE_STA (SPM_BASE_ADDRESS + 0x160)
    #define SUBSYS_IDLE_STA_SUBSYS_IDLE_SIGNALS Fld(32,0)//[31:0]
#define PCM_STA (SPM_BASE_ADDRESS + 0x164)
    #define PCM_STA_PCM_CK_SEL_O Fld(4,0)//[3:0]
    #define PCM_STA_EXT_SRC_STA Fld(3,4)//[6:4]
#define SRC_REQ_STA_3 (SPM_BASE_ADDRESS + 0x168)
    #define SRC_REQ_STA_3_CCIF_EVENT_RAW_STATUS Fld(16,0)//[15:0]
    #define SRC_REQ_STA_3_F26M_STATE Fld(1,16)//[16:16]
    #define SRC_REQ_STA_3_INFRA_STATE Fld(1,17)//[17:17]
    #define SRC_REQ_STA_3_APSRC_STATE Fld(1,18)//[18:18]
    #define SRC_REQ_STA_3_VRF18_STATE Fld(1,19)//[19:19]
    #define SRC_REQ_STA_3_DDR_EN_STATE Fld(1,20)//[20:20]
    #define SRC_REQ_STA_3_DVFS_STATE Fld(1,21)//[21:21]
    #define SRC_REQ_STA_3_SW_MAILBOX_STATE Fld(1,22)//[22:22]
    #define SRC_REQ_STA_3_SSPM_MAILBOX_STATE Fld(1,23)//[23:23]
    #define SRC_REQ_STA_3_ADSP_MAILBOX_STATE Fld(1,24)//[24:24]
    #define SRC_REQ_STA_3_SCP_MAILBOX_STATE Fld(1,25)//[25:25]
#define SPM_PWR_STATUS (SPM_BASE_ADDRESS + 0x16C)
    #define SPM_PWR_STATUS_PWR_STATUS Fld(32,0)//[31:0]
#define SPM_PWR_STATUS_2ND (SPM_BASE_ADDRESS + 0x170)
    #define SPM_PWR_STATUS_2ND_PWR_STATUS_2ND Fld(32,0)//[31:0]
#define CPU_PWR_STATUS (SPM_BASE_ADDRESS + 0x174)
    #define CPU_PWR_STATUS_MCUSYS_SPMC_PWR_ON_ACK Fld(1,9)//[9:9]
    #define CPU_PWR_STATUS_MP0_SPMC_PWR_ON_ACK_CPUTOP Fld(1,8)//[8:8]
    #define CPU_PWR_STATUS_MP0_SPMC_PWR_ON_ACK_CPU7 Fld(1,7)//[7:7]
    #define CPU_PWR_STATUS_MP0_SPMC_PWR_ON_ACK_CPU6 Fld(1,6)//[6:6]
    #define CPU_PWR_STATUS_MP0_SPMC_PWR_ON_ACK_CPU5 Fld(1,5)//[5:5]
    #define CPU_PWR_STATUS_MP0_SPMC_PWR_ON_ACK_CPU4 Fld(1,4)//[4:4]
    #define CPU_PWR_STATUS_MP0_SPMC_PWR_ON_ACK_CPU3 Fld(1,3)//[3:3]
    #define CPU_PWR_STATUS_MP0_SPMC_PWR_ON_ACK_CPU2 Fld(1,2)//[2:2]
    #define CPU_PWR_STATUS_MP0_SPMC_PWR_ON_ACK_CPU1 Fld(1,1)//[1:1]
    #define CPU_PWR_STATUS_MP0_SPMC_PWR_ON_ACK_CPU0 Fld(1,0)//[0:0]
#define OTHER_PWR_STATUS (SPM_BASE_ADDRESS + 0x178)
    #define OTHER_PWR_STATUS_OTHER_PWR_STATUS Fld(32,0)//[31:0]
#define SPM_VTCXO_EVENT_COUNT_STA (SPM_BASE_ADDRESS + 0x17C)
    #define SPM_VTCXO_EVENT_COUNT_STA_SPM_VTCXO_SLEEP_COUNT Fld(16,0)//[15:0]
    #define SPM_VTCXO_EVENT_COUNT_STA_SPM_VTCXO_WAKE_COUNT Fld(16,16)//[31:16]
#define SPM_INFRA_EVENT_COUNT_STA (SPM_BASE_ADDRESS + 0x180)
    #define SPM_INFRA_EVENT_COUNT_STA_SPM_INFRA_SLEEP_COUNT Fld(16,0)//[15:0]
    #define SPM_INFRA_EVENT_COUNT_STA_SPM_INFRA_WAKE_COUNT Fld(16,16)//[31:16]
#define SPM_VRF18_EVENT_COUNT_STA (SPM_BASE_ADDRESS + 0x184)
    #define SPM_VRF18_EVENT_COUNT_STA_SPM_VRF18_SLEEP_COUNT Fld(16,0)//[15:0]
    #define SPM_VRF18_EVENT_COUNT_STA_SPM_VRF18_WAKE_COUNT Fld(16,16)//[31:16]
#define SPM_APSRC_EVENT_COUNT_STA (SPM_BASE_ADDRESS + 0x188)
    #define SPM_APSRC_EVENT_COUNT_STA_SPM_APSRC_SLEEP_COUNT Fld(16,0)//[15:0]
    #define SPM_APSRC_EVENT_COUNT_STA_SPM_APSRC_WAKE_COUNT Fld(16,16)//[31:16]
#define SPM_DDREN_EVENT_COUNT_STA (SPM_BASE_ADDRESS + 0x18C)
    #define SPM_DDREN_EVENT_COUNT_STA_SPM_DDREN_SLEEP_COUNT Fld(16,0)//[15:0]
    #define SPM_DDREN_EVENT_COUNT_STA_SPM_DDREN_WAKE_COUNT Fld(16,16)//[31:16]
#define MD32PCM_STA (SPM_BASE_ADDRESS + 0x190)
    #define MD32PCM_STA_MD32PCM_HALT Fld(1,0)//[0:0]
    #define MD32PCM_STA_MD32PCM_GATED Fld(1,1)//[1:1]
#define MD32PCM_PC (SPM_BASE_ADDRESS + 0x194)
    #define MD32PCM_PC_MON_PC Fld(32,0)//[31:0]
#define DVFSRC_EVENT_STA (SPM_BASE_ADDRESS + 0x1A4)
    #define DVFSRC_EVENT_STA_DVFSRC_EVENT Fld(32,0)//[31:0]
#define BUS_PROTECT4_RDY (SPM_BASE_ADDRESS + 0x1A8)
    #define BUS_PROTECT4_RDY_PROTECT4_READY Fld(32,0)//[31:0]
#define BUS_PROTECT5_RDY (SPM_BASE_ADDRESS + 0x1AC)
    #define BUS_PROTECT5_RDY_PROTECT5_READY Fld(32,0)//[31:0]
#define BUS_PROTECT6_RDY (SPM_BASE_ADDRESS + 0x1B0)
    #define BUS_PROTECT6_RDY_PROTECT6_READY Fld(32,0)//[31:0]
#define BUS_PROTECT7_RDY (SPM_BASE_ADDRESS + 0x1B4)
    #define BUS_PROTECT7_RDY_PROTECT7_READY Fld(32,0)//[31:0]
#define BUS_PROTECT8_RDY (SPM_BASE_ADDRESS + 0x1B8)
    #define BUS_PROTECT8_RDY_PROTECT8_READY Fld(32,0)//[31:0]
#define SPM_TWAM_LAST_STA0 (SPM_BASE_ADDRESS + 0x1D0)
    #define SPM_TWAM_LAST_STA0_LAST_IDLE_CNT_0 Fld(32,0)//[31:0]
#define SPM_TWAM_LAST_STA1 (SPM_BASE_ADDRESS + 0x1D4)
    #define SPM_TWAM_LAST_STA1_LAST_IDLE_CNT_1 Fld(32,0)//[31:0]
#define SPM_TWAM_LAST_STA2 (SPM_BASE_ADDRESS + 0x1D8)
    #define SPM_TWAM_LAST_STA2_LAST_IDLE_CNT_2 Fld(32,0)//[31:0]
#define SPM_TWAM_LAST_STA3 (SPM_BASE_ADDRESS + 0x1DC)
    #define SPM_TWAM_LAST_STA3_LAST_IDLE_CNT_3 Fld(32,0)//[31:0]
#define SPM_TWAM_CURR_STA0 (SPM_BASE_ADDRESS + 0x1E0)
    #define SPM_TWAM_CURR_STA0_CURRENT_IDLE_CNT_0 Fld(32,0)//[31:0]
#define SPM_TWAM_CURR_STA1 (SPM_BASE_ADDRESS + 0x1E4)
    #define SPM_TWAM_CURR_STA1_CURRENT_IDLE_CNT_1 Fld(32,0)//[31:0]
#define SPM_TWAM_CURR_STA2 (SPM_BASE_ADDRESS + 0x1E8)
    #define SPM_TWAM_CURR_STA2_CURRENT_IDLE_CNT_2 Fld(32,0)//[31:0]
#define SPM_TWAM_CURR_STA3 (SPM_BASE_ADDRESS + 0x1EC)
    #define SPM_TWAM_CURR_STA3_CURRENT_IDLE_CNT_3 Fld(32,0)//[31:0]
#define SPM_TWAM_TIMER_OUT (SPM_BASE_ADDRESS + 0x1F0)
    #define SPM_TWAM_TIMER_OUT_TWAM_TIMER Fld(32,0)//[31:0]
#define SPM_CG_CHECK_STA (SPM_BASE_ADDRESS + 0x1F4)
    #define SPM_CG_CHECK_STA_SPM_CG_CHECK_SLEEP_REQ_0 Fld(1,0)//[0:0]
    #define SPM_CG_CHECK_STA_SPM_CG_CHECK_SLEEP_REQ_1 Fld(1,1)//[1:1]
    #define SPM_CG_CHECK_STA_SPM_CG_CHECK_SLEEP_REQ_2 Fld(1,2)//[2:2]
#define SPM_DVFS_STA (SPM_BASE_ADDRESS + 0x1F8)
    #define SPM_DVFS_STA_TARGET_DVFS_LEVEL Fld(32,0)//[31:0]
#define SPM_DVFS_OPP_STA (SPM_BASE_ADDRESS + 0x1FC)
    #define SPM_DVFS_OPP_STA_TARGET_DVFS_OPP Fld(5,0)//[4:0]
    #define SPM_DVFS_OPP_STA_CURRENT_DVFS_OPP Fld(5,5)//[9:5]
    #define SPM_DVFS_OPP_STA_RELAY_DVFS_OPP Fld(5,10)//[14:10]

//Page SPM_3
#define SPM_MCUSYS_PWR_CON (SPM_BASE_ADDRESS + 0x200)
    #define SPM_MCUSYS_PWR_CON_MCUSYS_SPMC_PWR_ON_ACK Fld(1,31)//[31:31]
    #define SPM_MCUSYS_PWR_CON_MCUSYS_VPROC_EXT_OFF Fld(1,7)//[7:7]
    #define SPM_MCUSYS_PWR_CON_MCUSYS_SPMC_DORMANT_EN Fld(1,6)//[6:6]
    #define SPM_MCUSYS_PWR_CON_MCUSYS_SPMC_RESETPWRON_CONFIG Fld(1,5)//[5:5]
    #define SPM_MCUSYS_PWR_CON_MCUSYS_SPMC_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define SPM_MCUSYS_PWR_CON_MCUSYS_SPMC_PWR_ON Fld(1,2)//[2:2]
    #define SPM_MCUSYS_PWR_CON_MCUSYS_SPMC_PWR_RST_B Fld(1,0)//[0:0]
#define SPM_CPUTOP_PWR_CON (SPM_BASE_ADDRESS + 0x204)
    #define SPM_CPUTOP_PWR_CON_MP0_SPMC_PWR_ON_ACK_CPUTOP Fld(1,31)//[31:31]
    #define SPM_CPUTOP_PWR_CON_MP0_VSRAM_EXT_OFF Fld(1,8)//[8:8]
    #define SPM_CPUTOP_PWR_CON_MP0_VPROC_EXT_OFF Fld(1,7)//[7:7]
    #define SPM_CPUTOP_PWR_CON_MP0_SPMC_DORMANT_EN_CPUTOP Fld(1,6)//[6:6]
    #define SPM_CPUTOP_PWR_CON_MP0_SPMC_RESETPWRON_CONFIG_CPUTOP Fld(1,5)//[5:5]
    #define SPM_CPUTOP_PWR_CON_MP0_SPMC_PWR_CLK_DIS_CPUTOP Fld(1,4)//[4:4]
    #define SPM_CPUTOP_PWR_CON_MP0_SPMC_PWR_ON_CPUTOP Fld(1,2)//[2:2]
    #define SPM_CPUTOP_PWR_CON_MP0_SPMC_PWR_RST_B_CPUTOP Fld(1,0)//[0:0]
#define SPM_CPU0_PWR_CON (SPM_BASE_ADDRESS + 0x208)
    #define SPM_CPU0_PWR_CON_MP0_SPMC_PWR_ON_ACK_CPU0 Fld(1,31)//[31:31]
    #define SPM_CPU0_PWR_CON_MP0_VPROC_EXT_OFF_CPU0 Fld(1,7)//[7:7]
    #define SPM_CPU0_PWR_CON_MP0_SPMC_RESETPWRON_CONFIG_CPU0 Fld(1,5)//[5:5]
    #define SPM_CPU0_PWR_CON_MP0_SPMC_PWR_ON_CPU0 Fld(1,2)//[2:2]
    #define SPM_CPU0_PWR_CON_MP0_SPMC_PWR_RST_B_CPU0 Fld(1,0)//[0:0]
#define SPM_CPU1_PWR_CON (SPM_BASE_ADDRESS + 0x20C)
    #define SPM_CPU1_PWR_CON_MP0_SPMC_PWR_ON_ACK_CPU1 Fld(1,31)//[31:31]
    #define SPM_CPU1_PWR_CON_MP0_VPROC_EXT_OFF_CPU1 Fld(1,7)//[7:7]
    #define SPM_CPU1_PWR_CON_MP0_SPMC_RESETPWRON_CONFIG_CPU1 Fld(1,5)//[5:5]
    #define SPM_CPU1_PWR_CON_MP0_SPMC_PWR_ON_CPU1 Fld(1,2)//[2:2]
    #define SPM_CPU1_PWR_CON_MP0_SPMC_PWR_RST_B_CPU1 Fld(1,0)//[0:0]
#define SPM_CPU2_PWR_CON (SPM_BASE_ADDRESS + 0x210)
    #define SPM_CPU2_PWR_CON_MP0_SPMC_PWR_ON_ACK_CPU2 Fld(1,31)//[31:31]
    #define SPM_CPU2_PWR_CON_MP0_VPROC_EXT_OFF_CPU2 Fld(1,7)//[7:7]
    #define SPM_CPU2_PWR_CON_MP0_SPMC_RESETPWRON_CONFIG_CPU2 Fld(1,5)//[5:5]
    #define SPM_CPU2_PWR_CON_MP0_SPMC_PWR_ON_CPU2 Fld(1,2)//[2:2]
    #define SPM_CPU2_PWR_CON_MP0_SPMC_PWR_RST_B_CPU2 Fld(1,0)//[0:0]
#define SPM_CPU3_PWR_CON (SPM_BASE_ADDRESS + 0x214)
    #define SPM_CPU3_PWR_CON_MP0_SPMC_PWR_ON_ACK_CPU3 Fld(1,31)//[31:31]
    #define SPM_CPU3_PWR_CON_MP0_VPROC_EXT_OFF_CPU3 Fld(1,7)//[7:7]
    #define SPM_CPU3_PWR_CON_MP0_SPMC_RESETPWRON_CONFIG_CPU3 Fld(1,5)//[5:5]
    #define SPM_CPU3_PWR_CON_MP0_SPMC_PWR_ON_CPU3 Fld(1,2)//[2:2]
    #define SPM_CPU3_PWR_CON_MP0_SPMC_PWR_RST_B_CPU3 Fld(1,0)//[0:0]
#define SPM_CPU4_PWR_CON (SPM_BASE_ADDRESS + 0x218)
    #define SPM_CPU4_PWR_CON_MP0_SPMC_PWR_ON_ACK_CPU4 Fld(1,31)//[31:31]
    #define SPM_CPU4_PWR_CON_MP0_VPROC_EXT_OFF_CPU4 Fld(1,7)//[7:7]
    #define SPM_CPU4_PWR_CON_MP0_SPMC_RESETPWRON_CONFIG_CPU4 Fld(1,5)//[5:5]
    #define SPM_CPU4_PWR_CON_MP0_SPMC_PWR_ON_CPU4 Fld(1,2)//[2:2]
    #define SPM_CPU4_PWR_CON_MP0_SPMC_PWR_RST_B_CPU4 Fld(1,0)//[0:0]
#define SPM_CPU5_PWR_CON (SPM_BASE_ADDRESS + 0x21C)
    #define SPM_CPU5_PWR_CON_MP0_SPMC_PWR_ON_ACK_CPU5 Fld(1,31)//[31:31]
    #define SPM_CPU5_PWR_CON_MP0_VPROC_EXT_OFF_CPU5 Fld(1,7)//[7:7]
    #define SPM_CPU5_PWR_CON_MP0_SPMC_RESETPWRON_CONFIG_CPU5 Fld(1,5)//[5:5]
    #define SPM_CPU5_PWR_CON_MP0_SPMC_PWR_ON_CPU5 Fld(1,2)//[2:2]
    #define SPM_CPU5_PWR_CON_MP0_SPMC_PWR_RST_B_CPU5 Fld(1,0)//[0:0]
#define SPM_CPU6_PWR_CON (SPM_BASE_ADDRESS + 0x220)
    #define SPM_CPU6_PWR_CON_MP0_SPMC_PWR_ON_ACK_CPU6 Fld(1,31)//[31:31]
    #define SPM_CPU6_PWR_CON_MP0_VPROC_EXT_OFF_CPU6 Fld(1,7)//[7:7]
    #define SPM_CPU6_PWR_CON_MP0_SPMC_RESETPWRON_CONFIG_CPU6 Fld(1,5)//[5:5]
    #define SPM_CPU6_PWR_CON_MP0_SPMC_PWR_ON_CPU6 Fld(1,2)//[2:2]
    #define SPM_CPU6_PWR_CON_MP0_SPMC_PWR_RST_B_CPU6 Fld(1,0)//[0:0]
#define SPM_CPU7_PWR_CON (SPM_BASE_ADDRESS + 0x224)
    #define SPM_CPU7_PWR_CON_MP0_SPMC_PWR_ON_ACK_CPU7 Fld(1,31)//[31:31]
    #define SPM_CPU7_PWR_CON_MP0_VPROC_EXT_OFF_CPU7 Fld(1,7)//[7:7]
    #define SPM_CPU7_PWR_CON_MP0_SPMC_RESETPWRON_CONFIG_CPU7 Fld(1,5)//[5:5]
    #define SPM_CPU7_PWR_CON_MP0_SPMC_PWR_ON_CPU7 Fld(1,2)//[2:2]
    #define SPM_CPU7_PWR_CON_MP0_SPMC_PWR_RST_B_CPU7 Fld(1,0)//[0:0]
#define ARMPLL_CLK_CON (SPM_BASE_ADDRESS + 0x22C)
    #define ARMPLL_CLK_CON_SC_ARM_FHC_PAUSE Fld(6,0)//[5:0]
    #define ARMPLL_CLK_CON_SC_ARM_CK_OFF Fld(6,6)//[11:6]
    #define ARMPLL_CLK_CON_SC_ARMPLL_OFF Fld(1,12)//[12:12]
    #define ARMPLL_CLK_CON_SC_ARMBPLL_OFF Fld(1,13)//[13:13]
    #define ARMPLL_CLK_CON_SC_ARMBPLL1_OFF Fld(1,14)//[14:14]
    #define ARMPLL_CLK_CON_SC_ARMBPLL2_OFF Fld(1,15)//[15:15]
    #define ARMPLL_CLK_CON_SC_ARMBPLL3_OFF Fld(1,16)//[16:16]
    #define ARMPLL_CLK_CON_SC_CCIPLL_CKOFF Fld(1,17)//[17:17]
    #define ARMPLL_CLK_CON_SC_ARMDDS_OFF Fld(1,18)//[18:18]
    #define ARMPLL_CLK_CON_SC_ARMBPLL_S_OFF Fld(1,19)//[19:19]
    #define ARMPLL_CLK_CON_SC_ARMBPLL1_S_OFF Fld(1,20)//[20:20]
    #define ARMPLL_CLK_CON_SC_ARMBPLL2_S_OFF Fld(1,21)//[21:21]
    #define ARMPLL_CLK_CON_SC_ARMBPLL3_S_OFF Fld(1,22)//[22:22]
    #define ARMPLL_CLK_CON_SC_CCIPLL_PWROFF Fld(1,23)//[23:23]
    #define ARMPLL_CLK_CON_SC_ARMPLLOUT_OFF Fld(1,24)//[24:24]
    #define ARMPLL_CLK_CON_SC_ARMBPLLOUT_OFF Fld(1,25)//[25:25]
    #define ARMPLL_CLK_CON_SC_ARMBPLLOUT1_OFF Fld(1,26)//[26:26]
    #define ARMPLL_CLK_CON_SC_ARMBPLLOUT2_OFF Fld(1,27)//[27:27]
    #define ARMPLL_CLK_CON_SC_ARMBPLLOUT3_OFF Fld(1,28)//[28:28]
    #define ARMPLL_CLK_CON_SC_CCIPLL_OUT_OFF Fld(1,29)//[29:29]
#define MCUSYS_IDLE_STA (SPM_BASE_ADDRESS + 0x230)
    #define MCUSYS_IDLE_STA_ARMBUS_IDLE_TO_26M Fld(1,0)//[0:0]
    #define MCUSYS_IDLE_STA_MP0_CLUSTER_IDLE_TO_PWR_OFF Fld(1,1)//[1:1]
    #define MCUSYS_IDLE_STA_MCUSYS_DDR_EN_0 Fld(1,2)//[2:2]
    #define MCUSYS_IDLE_STA_MCUSYS_DDR_EN_1 Fld(1,3)//[3:3]
    #define MCUSYS_IDLE_STA_MCUSYS_DDR_EN_2 Fld(1,4)//[4:4]
    #define MCUSYS_IDLE_STA_MCUSYS_DDR_EN_3 Fld(1,5)//[5:5]
    #define MCUSYS_IDLE_STA_MCUSYS_DDR_EN_4 Fld(1,6)//[6:6]
    #define MCUSYS_IDLE_STA_MCUSYS_DDR_EN_5 Fld(1,7)//[7:7]
    #define MCUSYS_IDLE_STA_MCUSYS_DDR_EN_6 Fld(1,8)//[8:8]
    #define MCUSYS_IDLE_STA_MCUSYS_DDR_EN_7 Fld(1,9)//[9:9]
    #define MCUSYS_IDLE_STA_MP0_CPU_IDLE_TO_PWR_OFF Fld(8,16)//[23:16]
    #define MCUSYS_IDLE_STA_WFI_AF_SEL Fld(8,24)//[31:24]
#define GIC_WAKEUP_STA (SPM_BASE_ADDRESS + 0x234)
    #define GIC_WAKEUP_STA_GIC_WAKEUP Fld(10,10)//[19:10]
#define CPU_SPARE_CON (SPM_BASE_ADDRESS + 0x238)
    #define CPU_SPARE_CON_CPU_SPARE_CON Fld(32,0)//[31:0]
#define CPU_SPARE_CON_SET (SPM_BASE_ADDRESS + 0x23C)
    #define CPU_SPARE_CON_SET_CPU_SPARE_CON_SET Fld(32,0)//[31:0]
#define CPU_SPARE_CON_CLR (SPM_BASE_ADDRESS + 0x240)
    #define CPU_SPARE_CON_CLR_CPU_SPARE_CON_CLR Fld(32,0)//[31:0]
#define ARMPLL_CLK_SEL (SPM_BASE_ADDRESS + 0x244)
    #define ARMPLL_CLK_SEL_ARMPLL_CLK_SEL Fld(15,0)//[14:0]
#define EXT_INT_WAKEUP_REQ (SPM_BASE_ADDRESS + 0x248)
    #define EXT_INT_WAKEUP_REQ_EXT_INT_WAKEUP_REQ Fld(10,0)//[9:0]
#define EXT_INT_WAKEUP_REQ_SET (SPM_BASE_ADDRESS + 0x24C)
    #define EXT_INT_WAKEUP_REQ_SET_EXT_INT_WAKEUP_REQ_SET Fld(10,0)//[9:0]
#define EXT_INT_WAKEUP_REQ_CLR (SPM_BASE_ADDRESS + 0x250)
    #define EXT_INT_WAKEUP_REQ_CLR_EXT_INT_WAKEUP_REQ_CLR Fld(10,0)//[9:0]
#define MP0_CPU0_IRQ_MASK (SPM_BASE_ADDRESS + 0x260)
    #define MP0_CPU0_IRQ_MASK_MP0_CPU0_IRQ_MASK Fld(1,0)//[0:0]
    #define MP0_CPU0_IRQ_MASK_MP0_CPU0_AUX Fld(11,8)//[18:8]
#define MP0_CPU1_IRQ_MASK (SPM_BASE_ADDRESS + 0x264)
    #define MP0_CPU1_IRQ_MASK_MP0_CPU1_IRQ_MASK Fld(1,0)//[0:0]
    #define MP0_CPU1_IRQ_MASK_MP0_CPU1_AUX Fld(11,8)//[18:8]
#define MP0_CPU2_IRQ_MASK (SPM_BASE_ADDRESS + 0x268)
    #define MP0_CPU2_IRQ_MASK_MP0_CPU2_IRQ_MASK Fld(1,0)//[0:0]
    #define MP0_CPU2_IRQ_MASK_MP0_CPU2_AUX Fld(11,8)//[18:8]
#define MP0_CPU3_IRQ_MASK (SPM_BASE_ADDRESS + 0x26C)
    #define MP0_CPU3_IRQ_MASK_MP0_CPU3_IRQ_MASK Fld(1,0)//[0:0]
    #define MP0_CPU3_IRQ_MASK_MP0_CPU3_AUX Fld(11,8)//[18:8]
#define MP1_CPU0_IRQ_MASK (SPM_BASE_ADDRESS + 0x270)
    #define MP1_CPU0_IRQ_MASK_MP1_CPU0_IRQ_MASK Fld(1,0)//[0:0]
    #define MP1_CPU0_IRQ_MASK_MP1_CPU0_AUX Fld(11,8)//[18:8]
#define MP1_CPU1_IRQ_MASK (SPM_BASE_ADDRESS + 0x274)
    #define MP1_CPU1_IRQ_MASK_MP1_CPU1_IRQ_MASK Fld(1,0)//[0:0]
    #define MP1_CPU1_IRQ_MASK_MP1_CPU1_AUX Fld(11,8)//[18:8]
#define MP1_CPU2_IRQ_MASK (SPM_BASE_ADDRESS + 0x278)
    #define MP1_CPU2_IRQ_MASK_MP1_CPU2_IRQ_MASK Fld(1,0)//[0:0]
    #define MP1_CPU2_IRQ_MASK_MP1_CPU2_AUX Fld(11,8)//[18:8]
#define MP1_CPU3_IRQ_MASK (SPM_BASE_ADDRESS + 0x27C)
    #define MP1_CPU3_IRQ_MASK_MP1_CPU3_IRQ_MASK Fld(1,0)//[0:0]
    #define MP1_CPU3_IRQ_MASK_MP1_CPU3_AUX Fld(11,8)//[18:8]
#define MP0_CPU0_WFI_EN (SPM_BASE_ADDRESS + 0x280)
    #define MP0_CPU0_WFI_EN_MP0_CPU0_WFI_EN Fld(1,0)//[0:0]
#define MP0_CPU1_WFI_EN (SPM_BASE_ADDRESS + 0x284)
    #define MP0_CPU1_WFI_EN_MP0_CPU1_WFI_EN Fld(1,0)//[0:0]
#define MP0_CPU2_WFI_EN (SPM_BASE_ADDRESS + 0x288)
    #define MP0_CPU2_WFI_EN_MP0_CPU2_WFI_EN Fld(1,0)//[0:0]
#define MP0_CPU3_WFI_EN (SPM_BASE_ADDRESS + 0x28C)
    #define MP0_CPU3_WFI_EN_MP0_CPU3_WFI_EN Fld(1,0)//[0:0]
#define MP0_CPU4_WFI_EN (SPM_BASE_ADDRESS + 0x290)
    #define MP0_CPU4_WFI_EN_MP0_CPU4_WFI_EN Fld(1,0)//[0:0]
#define MP0_CPU5_WFI_EN (SPM_BASE_ADDRESS + 0x294)
    #define MP0_CPU5_WFI_EN_MP0_CPU5_WFI_EN Fld(1,0)//[0:0]
#define MP0_CPU6_WFI_EN (SPM_BASE_ADDRESS + 0x298)
    #define MP0_CPU6_WFI_EN_MP0_CPU6_WFI_EN Fld(1,0)//[0:0]
#define MP0_CPU7_WFI_EN (SPM_BASE_ADDRESS + 0x29C)
    #define MP0_CPU7_WFI_EN_MP0_CPU7_WFI_EN Fld(1,0)//[0:0]
#define ROOT_CPUTOP_ADDR (SPM_BASE_ADDRESS + 0x2A0)
    #define ROOT_CPUTOP_ADDR_ROOT_CPUTOP_ADDR Fld(32,0)//[31:0]
#define ROOT_CORE_ADDR (SPM_BASE_ADDRESS + 0x2A4)
    #define ROOT_CORE_ADDR_ROOT_CORE_ADDR Fld(32,0)//[31:0]
#define SPM2SW_MAILBOX_0 (SPM_BASE_ADDRESS + 0x2D0)
    #define SPM2SW_MAILBOX_0_SPM2SW_MAILBOX_0 Fld(32,0)//[31:0]
#define SPM2SW_MAILBOX_1 (SPM_BASE_ADDRESS + 0x2D4)
    #define SPM2SW_MAILBOX_1_SPM2SW_MAILBOX_1 Fld(32,0)//[31:0]
#define SPM2SW_MAILBOX_2 (SPM_BASE_ADDRESS + 0x2D8)
    #define SPM2SW_MAILBOX_2_SPM2SW_MAILBOX_2 Fld(32,0)//[31:0]
#define SPM2SW_MAILBOX_3 (SPM_BASE_ADDRESS + 0x2DC)
    #define SPM2SW_MAILBOX_3_SPM2SW_MAILBOX_3 Fld(32,0)//[31:0]
#define SW2SPM_INT (SPM_BASE_ADDRESS + 0x2E0)
    #define SW2SPM_INT_SW2SPM_INT Fld(4,0)//[3:0]
#define SW2SPM_INT_SET (SPM_BASE_ADDRESS + 0x2E4)
    #define SW2SPM_INT_SET_SW2SPM_INT_SET Fld(4,0)//[3:0]
#define SW2SPM_INT_CLR (SPM_BASE_ADDRESS + 0x2E8)
    #define SW2SPM_INT_CLR_SW2SPM_INT_CLR Fld(4,0)//[3:0]
#define SW2SPM_MAILBOX_0 (SPM_BASE_ADDRESS + 0x2EC)
    #define SW2SPM_MAILBOX_0_SW2SPM_MAILBOX_0 Fld(32,0)//[31:0]
#define SW2SPM_MAILBOX_1 (SPM_BASE_ADDRESS + 0x2F0)
    #define SW2SPM_MAILBOX_1_SW2SPM_MAILBOX_1 Fld(32,0)//[31:0]
#define SW2SPM_MAILBOX_2 (SPM_BASE_ADDRESS + 0x2F4)
    #define SW2SPM_MAILBOX_2_SW2SPM_MAILBOX_2 Fld(32,0)//[31:0]
#define SW2SPM_MAILBOX_3 (SPM_BASE_ADDRESS + 0x2F8)
    #define SW2SPM_MAILBOX_3_SW2SPM_MAILBOX_3 Fld(32,0)//[31:0]
#define SW2SPM_CFG (SPM_BASE_ADDRESS + 0x2FC)
    #define SW2SPM_CFG_SWU2SPM_INT_MASK_B Fld(4,0)//[3:0]
#define MD1_PWR_CON (SPM_BASE_ADDRESS + 0x300)
    #define MD1_PWR_CON_MD1_PWR_RST_B Fld(1,0)//[0:0]
    #define MD1_PWR_CON_MD1_PWR_ISO Fld(1,1)//[1:1]
    #define MD1_PWR_CON_MD1_PWR_ON Fld(1,2)//[2:2]
    #define MD1_PWR_CON_MD1_PWR_ON_2ND Fld(1,3)//[3:3]
    #define MD1_PWR_CON_MD1_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define MD1_PWR_CON_MD1_SRAM_PDN Fld(1,8)//[8:8]
    #define MD1_PWR_CON_SC_MD1_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define CONN_PWR_CON (SPM_BASE_ADDRESS + 0x304)
    #define CONN_PWR_CON_CONN_PWR_RST_B Fld(1,0)//[0:0]
    #define CONN_PWR_CON_CONN_PWR_ISO Fld(1,1)//[1:1]
    #define CONN_PWR_CON_CONN_PWR_ON Fld(1,2)//[2:2]
    #define CONN_PWR_CON_CONN_PWR_ON_2ND Fld(1,3)//[3:3]
    #define CONN_PWR_CON_CONN_PWR_CLK_DIS Fld(1,4)//[4:4]
#define MFG0_PWR_CON (SPM_BASE_ADDRESS + 0x308)
    #define MFG0_PWR_CON_MFG0_PWR_RST_B Fld(1,0)//[0:0]
    #define MFG0_PWR_CON_MFG0_PWR_ISO Fld(1,1)//[1:1]
    #define MFG0_PWR_CON_MFG0_PWR_ON Fld(1,2)//[2:2]
    #define MFG0_PWR_CON_MFG0_PWR_ON_2ND Fld(1,3)//[3:3]
    #define MFG0_PWR_CON_MFG0_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define MFG0_PWR_CON_MFG0_SRAM_PDN Fld(1,8)//[8:8]
    #define MFG0_PWR_CON_SC_MFG0_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define MFG1_PWR_CON (SPM_BASE_ADDRESS + 0x30C)
    #define MFG1_PWR_CON_MFG1_PWR_RST_B Fld(1,0)//[0:0]
    #define MFG1_PWR_CON_MFG1_PWR_ISO Fld(1,1)//[1:1]
    #define MFG1_PWR_CON_MFG1_PWR_ON Fld(1,2)//[2:2]
    #define MFG1_PWR_CON_MFG1_PWR_ON_2ND Fld(1,3)//[3:3]
    #define MFG1_PWR_CON_MFG1_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define MFG1_PWR_CON_MFG1_SRAM_PDN Fld(1,8)//[8:8]
    #define MFG1_PWR_CON_SC_MFG1_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define MFG2_PWR_CON (SPM_BASE_ADDRESS + 0x310)
    #define MFG2_PWR_CON_MFG2_PWR_RST_B Fld(1,0)//[0:0]
    #define MFG2_PWR_CON_MFG2_PWR_ISO Fld(1,1)//[1:1]
    #define MFG2_PWR_CON_MFG2_PWR_ON Fld(1,2)//[2:2]
    #define MFG2_PWR_CON_MFG2_PWR_ON_2ND Fld(1,3)//[3:3]
    #define MFG2_PWR_CON_MFG2_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define MFG2_PWR_CON_MFG2_SRAM_PDN Fld(1,8)//[8:8]
    #define MFG2_PWR_CON_SC_MFG2_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define MFG3_PWR_CON (SPM_BASE_ADDRESS + 0x314)
    #define MFG3_PWR_CON_MFG3_PWR_RST_B Fld(1,0)//[0:0]
    #define MFG3_PWR_CON_MFG3_PWR_ISO Fld(1,1)//[1:1]
    #define MFG3_PWR_CON_MFG3_PWR_ON Fld(1,2)//[2:2]
    #define MFG3_PWR_CON_MFG3_PWR_ON_2ND Fld(1,3)//[3:3]
    #define MFG3_PWR_CON_MFG3_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define MFG3_PWR_CON_MFG3_SRAM_PDN Fld(1,8)//[8:8]
    #define MFG3_PWR_CON_SC_MFG3_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define MFG4_PWR_CON (SPM_BASE_ADDRESS + 0x318)
    #define MFG4_PWR_CON_MFG4_PWR_RST_B Fld(1,0)//[0:0]
    #define MFG4_PWR_CON_MFG4_PWR_ISO Fld(1,1)//[1:1]
    #define MFG4_PWR_CON_MFG4_PWR_ON Fld(1,2)//[2:2]
    #define MFG4_PWR_CON_MFG4_PWR_ON_2ND Fld(1,3)//[3:3]
    #define MFG4_PWR_CON_MFG4_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define MFG4_PWR_CON_MFG4_SRAM_PDN Fld(1,8)//[8:8]
    #define MFG4_PWR_CON_SC_MFG4_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define MFG5_PWR_CON (SPM_BASE_ADDRESS + 0x31C)
    #define MFG5_PWR_CON_MFG5_PWR_RST_B Fld(1,0)//[0:0]
    #define MFG5_PWR_CON_MFG5_PWR_ISO Fld(1,1)//[1:1]
    #define MFG5_PWR_CON_MFG5_PWR_ON Fld(1,2)//[2:2]
    #define MFG5_PWR_CON_MFG5_PWR_ON_2ND Fld(1,3)//[3:3]
    #define MFG5_PWR_CON_MFG5_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define MFG5_PWR_CON_MFG5_SRAM_PDN Fld(1,8)//[8:8]
    #define MFG5_PWR_CON_SC_MFG5_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define MFG6_PWR_CON (SPM_BASE_ADDRESS + 0x320)
    #define MFG6_PWR_CON_MFG6_PWR_RST_B Fld(1,0)//[0:0]
    #define MFG6_PWR_CON_MFG6_PWR_ISO Fld(1,1)//[1:1]
    #define MFG6_PWR_CON_MFG6_PWR_ON Fld(1,2)//[2:2]
    #define MFG6_PWR_CON_MFG6_PWR_ON_2ND Fld(1,3)//[3:3]
    #define MFG6_PWR_CON_MFG6_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define MFG6_PWR_CON_MFG6_SRAM_PDN Fld(1,8)//[8:8]
    #define MFG6_PWR_CON_SC_MFG6_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define IFR_PWR_CON (SPM_BASE_ADDRESS + 0x324)
    #define IFR_PWR_CON_IFR_PWR_RST_B Fld(1,0)//[0:0]
    #define IFR_PWR_CON_IFR_PWR_ISO Fld(1,1)//[1:1]
    #define IFR_PWR_CON_IFR_PWR_ON Fld(1,2)//[2:2]
    #define IFR_PWR_CON_IFR_PWR_ON_2ND Fld(1,3)//[3:3]
    #define IFR_PWR_CON_IFR_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define IFR_PWR_CON_IFR_SRAM_PDN Fld(1,8)//[8:8]
    #define IFR_PWR_CON_SC_IFR_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define IFR_SUB_PWR_CON (SPM_BASE_ADDRESS + 0x328)
    #define IFR_SUB_PWR_CON_IFR_SUB_PWR_RST_B Fld(1,0)//[0:0]
    #define IFR_SUB_PWR_CON_IFR_SUB_PWR_ISO Fld(1,1)//[1:1]
    #define IFR_SUB_PWR_CON_IFR_SUB_PWR_ON Fld(1,2)//[2:2]
    #define IFR_SUB_PWR_CON_IFR_SUB_PWR_ON_2ND Fld(1,3)//[3:3]
    #define IFR_SUB_PWR_CON_IFR_SUB_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define IFR_SUB_PWR_CON_IFR_SUB_SRAM_PDN Fld(1,8)//[8:8]
    #define IFR_SUB_PWR_CON_SC_IFR_SUB_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define DPY_PWR_CON (SPM_BASE_ADDRESS + 0x32C)
    #define DPY_PWR_CON_DPY_PWR_RST_B Fld(1,0)//[0:0]
    #define DPY_PWR_CON_DPY_PWR_ISO Fld(1,1)//[1:1]
    #define DPY_PWR_CON_DPY_PWR_ON Fld(1,2)//[2:2]
    #define DPY_PWR_CON_DPY_PWR_ON_2ND Fld(1,3)//[3:3]
    #define DPY_PWR_CON_DPY_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define DPY_PWR_CON_DPY_SRAM_PDN Fld(1,8)//[8:8]
    #define DPY_PWR_CON_SC_DPY_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define ISP_PWR_CON (SPM_BASE_ADDRESS + 0x330)
    #define ISP_PWR_CON_ISP_PWR_RST_B Fld(1,0)//[0:0]
    #define ISP_PWR_CON_ISP_PWR_ISO Fld(1,1)//[1:1]
    #define ISP_PWR_CON_ISP_PWR_ON Fld(1,2)//[2:2]
    #define ISP_PWR_CON_ISP_PWR_ON_2ND Fld(1,3)//[3:3]
    #define ISP_PWR_CON_ISP_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define ISP_PWR_CON_ISP_SRAM_PDN Fld(1,8)//[8:8]
    #define ISP_PWR_CON_SC_ISP_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define ISP2_PWR_CON (SPM_BASE_ADDRESS + 0x334)
    #define ISP2_PWR_CON_ISP2_PWR_RST_B Fld(1,0)//[0:0]
    #define ISP2_PWR_CON_ISP2_PWR_ISO Fld(1,1)//[1:1]
    #define ISP2_PWR_CON_ISP2_PWR_ON Fld(1,2)//[2:2]
    #define ISP2_PWR_CON_ISP2_PWR_ON_2ND Fld(1,3)//[3:3]
    #define ISP2_PWR_CON_ISP2_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define ISP2_PWR_CON_ISP2_SRAM_PDN Fld(1,8)//[8:8]
    #define ISP2_PWR_CON_SC_ISP2_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define IPE_PWR_CON (SPM_BASE_ADDRESS + 0x338)
    #define IPE_PWR_CON_IPE_PWR_RST_B Fld(1,0)//[0:0]
    #define IPE_PWR_CON_IPE_PWR_ISO Fld(1,1)//[1:1]
    #define IPE_PWR_CON_IPE_PWR_ON Fld(1,2)//[2:2]
    #define IPE_PWR_CON_IPE_PWR_ON_2ND Fld(1,3)//[3:3]
    #define IPE_PWR_CON_IPE_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define IPE_PWR_CON_IPE_SRAM_PDN Fld(1,8)//[8:8]
    #define IPE_PWR_CON_SC_IPE_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define VDE_PWR_CON (SPM_BASE_ADDRESS + 0x33C)
    #define VDE_PWR_CON_VDE_PWR_RST_B Fld(1,0)//[0:0]
    #define VDE_PWR_CON_VDE_PWR_ISO Fld(1,1)//[1:1]
    #define VDE_PWR_CON_VDE_PWR_ON Fld(1,2)//[2:2]
    #define VDE_PWR_CON_VDE_PWR_ON_2ND Fld(1,3)//[3:3]
    #define VDE_PWR_CON_VDE_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define VDE_PWR_CON_VDE_SRAM_PDN Fld(1,8)//[8:8]
    #define VDE_PWR_CON_SC_VDE_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define VDE2_PWR_CON (SPM_BASE_ADDRESS + 0x340)
    #define VDE2_PWR_CON_VDE2_PWR_RST_B Fld(1,0)//[0:0]
    #define VDE2_PWR_CON_VDE2_PWR_ISO Fld(1,1)//[1:1]
    #define VDE2_PWR_CON_VDE2_PWR_ON Fld(1,2)//[2:2]
    #define VDE2_PWR_CON_VDE2_PWR_ON_2ND Fld(1,3)//[3:3]
    #define VDE2_PWR_CON_VDE2_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define VDE2_PWR_CON_VDE2_SRAM_PDN Fld(1,8)//[8:8]
    #define VDE2_PWR_CON_SC_VDE2_SRAM_PDN_ACK Fld(1,12)//[12:12]

//Page SPM_4
#define VEN_PWR_CON (SPM_BASE_ADDRESS + 0x344)
    #define VEN_PWR_CON_VEN_PWR_RST_B Fld(1,0)//[0:0]
    #define VEN_PWR_CON_VEN_PWR_ISO Fld(1,1)//[1:1]
    #define VEN_PWR_CON_VEN_PWR_ON Fld(1,2)//[2:2]
    #define VEN_PWR_CON_VEN_PWR_ON_2ND Fld(1,3)//[3:3]
    #define VEN_PWR_CON_VEN_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define VEN_PWR_CON_VEN_SRAM_PDN Fld(1,8)//[8:8]
    #define VEN_PWR_CON_SC_VEN_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define VEN_CORE1_PWR_CON (SPM_BASE_ADDRESS + 0x348)
    #define VEN_CORE1_PWR_CON_VEN_CORE1_PWR_RST_B Fld(1,0)//[0:0]
    #define VEN_CORE1_PWR_CON_VEN_CORE1_PWR_ISO Fld(1,1)//[1:1]
    #define VEN_CORE1_PWR_CON_VEN_CORE1_PWR_ON Fld(1,2)//[2:2]
    #define VEN_CORE1_PWR_CON_VEN_CORE1_PWR_ON_2ND Fld(1,3)//[3:3]
    #define VEN_CORE1_PWR_CON_VEN_CORE1_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define VEN_CORE1_PWR_CON_VEN_CORE1_SRAM_PDN Fld(1,8)//[8:8]
    #define VEN_CORE1_PWR_CON_SC_VEN_CORE1_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define MDP_PWR_CON (SPM_BASE_ADDRESS + 0x34C)
    #define MDP_PWR_CON_MDP_PWR_RST_B Fld(1,0)//[0:0]
    #define MDP_PWR_CON_MDP_PWR_ISO Fld(1,1)//[1:1]
    #define MDP_PWR_CON_MDP_PWR_ON Fld(1,2)//[2:2]
    #define MDP_PWR_CON_MDP_PWR_ON_2ND Fld(1,3)//[3:3]
    #define MDP_PWR_CON_MDP_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define MDP_PWR_CON_MDP_SRAM_PDN Fld(1,8)//[8:8]
    #define MDP_PWR_CON_SC_MDP_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define SPM_DIS_PWR_CON (SPM_BASE_ADDRESS + 0x350)
    #define DIS_PWR_CON_DIS_PWR_RST_B Fld(1,0)//[0:0]
    #define DIS_PWR_CON_DIS_PWR_ISO Fld(1,1)//[1:1]
    #define DIS_PWR_CON_DIS_PWR_ON Fld(1,2)//[2:2]
    #define DIS_PWR_CON_DIS_PWR_ON_2ND Fld(1,3)//[3:3]
    #define DIS_PWR_CON_DIS_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define DIS_PWR_CON_DIS_SRAM_PDN Fld(1,8)//[8:8]
    #define DIS_PWR_CON_SC_DIS_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define AUDIO_PWR_CON (SPM_BASE_ADDRESS + 0x354)
    #define AUDIO_PWR_CON_AUDIO_PWR_RST_B Fld(1,0)//[0:0]
    #define AUDIO_PWR_CON_AUDIO_PWR_ISO Fld(1,1)//[1:1]
    #define AUDIO_PWR_CON_AUDIO_PWR_ON Fld(1,2)//[2:2]
    #define AUDIO_PWR_CON_AUDIO_PWR_ON_2ND Fld(1,3)//[3:3]
    #define AUDIO_PWR_CON_AUDIO_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define AUDIO_PWR_CON_AUDIO_SRAM_PDN Fld(1,8)//[8:8]
    #define AUDIO_PWR_CON_SC_AUDIO_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define ADSP_PWR_CON (SPM_BASE_ADDRESS + 0x358)
    #define ADSP_PWR_CON_ADSP_PWR_RST_B Fld(1,0)//[0:0]
    #define ADSP_PWR_CON_ADSP_PWR_ISO Fld(1,1)//[1:1]
    #define ADSP_PWR_CON_ADSP_PWR_ON Fld(1,2)//[2:2]
    #define ADSP_PWR_CON_ADSP_PWR_ON_2ND Fld(1,3)//[3:3]
    #define ADSP_PWR_CON_ADSP_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define ADSP_PWR_CON_ADSP_SRAM_CKISO Fld(1,5)//[5:5]
    #define ADSP_PWR_CON_ADSP_SRAM_ISOINT_B Fld(1,6)//[6:6]
    #define ADSP_PWR_CON_ADSP_SRAM_PDN Fld(1,8)//[8:8]
    #define ADSP_PWR_CON_ADSP_SRAM_SLEEP_B Fld(1,9)//[9:9]
    #define ADSP_PWR_CON_SC_ADSP_SRAM_PDN_ACK Fld(1,12)//[12:12]
    #define ADSP_PWR_CON_SC_ADSP_SRAM_SLEEP_B_ACK Fld(1,13)//[13:13]
#define CAM_PWR_CON (SPM_BASE_ADDRESS + 0x35C)
    #define CAM_PWR_CON_CAM_PWR_RST_B Fld(1,0)//[0:0]
    #define CAM_PWR_CON_CAM_PWR_ISO Fld(1,1)//[1:1]
    #define CAM_PWR_CON_CAM_PWR_ON Fld(1,2)//[2:2]
    #define CAM_PWR_CON_CAM_PWR_ON_2ND Fld(1,3)//[3:3]
    #define CAM_PWR_CON_CAM_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define CAM_PWR_CON_CAM_SRAM_PDN Fld(1,8)//[8:8]
    #define CAM_PWR_CON_SC_CAM_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define CAM_RAWA_PWR_CON (SPM_BASE_ADDRESS + 0x360)
    #define CAM_RAWA_PWR_CON_CAM_RAWA_PWR_RST_B Fld(1,0)//[0:0]
    #define CAM_RAWA_PWR_CON_CAM_RAWA_PWR_ISO Fld(1,1)//[1:1]
    #define CAM_RAWA_PWR_CON_CAM_RAWA_PWR_ON Fld(1,2)//[2:2]
    #define CAM_RAWA_PWR_CON_CAM_RAWA_PWR_ON_2ND Fld(1,3)//[3:3]
    #define CAM_RAWA_PWR_CON_CAM_RAWA_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define CAM_RAWA_PWR_CON_CAM_RAWA_SRAM_PDN Fld(1,8)//[8:8]
    #define CAM_RAWA_PWR_CON_SC_CAM_RAWA_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define CAM_RAWB_PWR_CON (SPM_BASE_ADDRESS + 0x364)
    #define CAM_RAWB_PWR_CON_CAM_RAWB_PWR_RST_B Fld(1,0)//[0:0]
    #define CAM_RAWB_PWR_CON_CAM_RAWB_PWR_ISO Fld(1,1)//[1:1]
    #define CAM_RAWB_PWR_CON_CAM_RAWB_PWR_ON Fld(1,2)//[2:2]
    #define CAM_RAWB_PWR_CON_CAM_RAWB_PWR_ON_2ND Fld(1,3)//[3:3]
    #define CAM_RAWB_PWR_CON_CAM_RAWB_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define CAM_RAWB_PWR_CON_CAM_RAWB_SRAM_PDN Fld(1,8)//[8:8]
    #define CAM_RAWB_PWR_CON_SC_CAM_RAWB_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define CAM_RAWC_PWR_CON (SPM_BASE_ADDRESS + 0x368)
    #define CAM_RAWC_PWR_CON_CAM_RAWC_PWR_RST_B Fld(1,0)//[0:0]
    #define CAM_RAWC_PWR_CON_CAM_RAWC_PWR_ISO Fld(1,1)//[1:1]
    #define CAM_RAWC_PWR_CON_CAM_RAWC_PWR_ON Fld(1,2)//[2:2]
    #define CAM_RAWC_PWR_CON_CAM_RAWC_PWR_ON_2ND Fld(1,3)//[3:3]
    #define CAM_RAWC_PWR_CON_CAM_RAWC_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define CAM_RAWC_PWR_CON_CAM_RAWC_SRAM_PDN Fld(1,8)//[8:8]
    #define CAM_RAWC_PWR_CON_SC_CAM_RAWC_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define SYSRAM_CON (SPM_BASE_ADDRESS + 0x36C)
    #define SYSRAM_CON_SYSRAM_SRAM_PDN Fld(4,16)//[19:16]
    #define SYSRAM_CON_SYSRAM_SRAM_SLEEP_B Fld(4,4)//[7:4]
    #define SYSRAM_CON_SYSRAM_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define SYSRAM_CON_SYSRAM_SRAM_CKISO Fld(1,0)//[0:0]
#define SYSROM_CON (SPM_BASE_ADDRESS + 0x370)
    #define SYSROM_CON_SYSROM_SRAM_PDN Fld(6,0)//[5:0]
#define SSPM_SRAM_CON (SPM_BASE_ADDRESS + 0x374)
    #define SSPM_SRAM_CON_SSPM_SRAM_PDN Fld(1,16)//[16:16]
    #define SSPM_SRAM_CON_SSPM_SRAM_SLEEP_B Fld(1,4)//[4:4]
    #define SSPM_SRAM_CON_SSPM_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define SSPM_SRAM_CON_SSPM_SRAM_CKISO Fld(1,0)//[0:0]
#define SCP_SRAM_CON (SPM_BASE_ADDRESS + 0x378)
    #define SCP_SRAM_CON_SCP_SRAM_PDN Fld(1,16)//[16:16]
    #define SCP_SRAM_CON_SCP_SRAM_SLEEP_B Fld(1,4)//[4:4]
    #define SCP_SRAM_CON_SCP_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define SCP_SRAM_CON_SCP_SRAM_CKISO Fld(1,0)//[0:0]
#define DPY_SHU_SRAM_CON (SPM_BASE_ADDRESS + 0x37C)
    #define DPY_SHU_SRAM_CON_DPY_SHU_SRAM_PDN Fld(2,16)//[17:16]
    #define DPY_SHU_SRAM_CON_DPY_SHU_SRAM_SLEEP_B Fld(2,4)//[5:4]
    #define DPY_SHU_SRAM_CON_DPY_SHU_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define DPY_SHU_SRAM_CON_DPY_SHU_SRAM_CKISO Fld(1,0)//[0:0]
#define UFS_SRAM_CON (SPM_BASE_ADDRESS + 0x380)
    #define UFS_SRAM_CON_UFS_SRAM_PDN Fld(5,16)//[20:16]
    #define UFS_SRAM_CON_UFS_SRAM_SLEEP_B Fld(5,4)//[8:4]
    #define UFS_SRAM_CON_UFS_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define UFS_SRAM_CON_UFS_SRAM_CKISO Fld(1,0)//[0:0]
#define DEVAPC_IFR_SRAM_CON (SPM_BASE_ADDRESS + 0x384)
    #define DEVAPC_IFR_SRAM_CON_DEVAPC_IFR_SRAM_PDN Fld(6,16)//[21:16]
    #define DEVAPC_IFR_SRAM_CON_DEVAPC_IFR_SRAM_SLEEP_B Fld(6,4)//[9:4]
    #define DEVAPC_IFR_SRAM_CON_DEVAPC_IFR_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define DEVAPC_IFR_SRAM_CON_DEVAPC_IFR_SRAM_CKISO Fld(1,0)//[0:0]
#define DEVAPC_SUBIFR_SRAM_CON (SPM_BASE_ADDRESS + 0x388)
    #define DEVAPC_SUBIFR_SRAM_CON_DEVAPC_SUBIFR_SRAM_PDN Fld(6,16)//[21:16]
    #define DEVAPC_SUBIFR_SRAM_CON_DEVAPC_SUBIFR_SRAM_SLEEP_B Fld(6,4)//[9:4]
    #define DEVAPC_SUBIFR_SRAM_CON_DEVAPC_SUBIFR_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define DEVAPC_SUBIFR_SRAM_CON_DEVAPC_SUBIFR_SRAM_CKISO Fld(1,0)//[0:0]
#define DEVAPC_ACP_SRAM_CON (SPM_BASE_ADDRESS + 0x38C)
    #define DEVAPC_ACP_SRAM_CON_DEVAPC_ACP_SRAM_PDN Fld(6,16)//[21:16]
    #define DEVAPC_ACP_SRAM_CON_DEVAPC_ACP_SRAM_SLEEP_B Fld(6,4)//[9:4]
    #define DEVAPC_ACP_SRAM_CON_DEVAPC_ACP_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define DEVAPC_ACP_SRAM_CON_DEVAPC_ACP_SRAM_CKISO Fld(1,0)//[0:0]
#define USB_SRAM_CON (SPM_BASE_ADDRESS + 0x390)
    #define USB_SRAM_CON_USB_SRAM_PDN Fld(9,0)//[8:0]
#define DUMMY_SRAM_CON (SPM_BASE_ADDRESS + 0x394)
    #define DUMMY_SRAM_CON_DUMMY_SRAM_PDN Fld(8,16)//[23:16]
    #define DUMMY_SRAM_CON_DUMMY_SRAM_SLEEP_B Fld(8,4)//[11:4]
    #define DUMMY_SRAM_CON_DUMMY_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define DUMMY_SRAM_CON_DUMMY_SRAM_CKISO Fld(1,0)//[0:0]
#define MD_EXT_BUCK_ISO_CON (SPM_BASE_ADDRESS + 0x398)
    #define MD_EXT_BUCK_ISO_CON_VMODEM_EXT_BUCK_ISO Fld(1,0)//[0:0]
    #define MD_EXT_BUCK_ISO_CON_VMD_EXT_BUCK_ISO Fld(1,1)//[1:1]
#define SPM_EXT_BUCK_ISO (SPM_BASE_ADDRESS + 0x39C)
    #define SPM_EXT_BUCK_ISO_VIMVO_EXT_BUCK_ISO Fld(1,0)//[0:0]
    #define SPM_EXT_BUCK_ISO_GPU_EXT_BUCK_ISO Fld(1,1)//[1:1]
    #define SPM_EXT_BUCK_ISO_ADSP_EXT_BUCK_ISO Fld(1,2)//[2:2]
    #define SPM_EXT_BUCK_ISO_IPU_EXT_BUCK_ISO Fld(3,5)//[7:5]
#define DXCC_SRAM_CON (SPM_BASE_ADDRESS + 0x3A0)
    #define DXCC_SRAM_CON_DXCC_SRAM_PDN Fld(1,16)//[16:16]
    #define DXCC_SRAM_CON_DXCC_SRAM_SLEEP_B Fld(1,4)//[4:4]
    #define DXCC_SRAM_CON_DXCC_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define DXCC_SRAM_CON_DXCC_SRAM_CKISO Fld(1,0)//[0:0]
#define MSDC_PWR_CON (SPM_BASE_ADDRESS + 0x3A4)
    #define MSDC_PWR_CON_MSDC_PWR_RST_B Fld(1,0)//[0:0]
    #define MSDC_PWR_CON_MSDC_PWR_ISO Fld(1,1)//[1:1]
    #define MSDC_PWR_CON_MSDC_PWR_ON Fld(1,2)//[2:2]
    #define MSDC_PWR_CON_MSDC_PWR_ON_2ND Fld(1,3)//[3:3]
    #define MSDC_PWR_CON_MSDC_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define MSDC_PWR_CON_MSDC_SRAM_CKISO Fld(1,5)//[5:5]
    #define MSDC_PWR_CON_MSDC_SRAM_ISOINT_B Fld(1,6)//[6:6]
    #define MSDC_PWR_CON_MSDC_SRAM_PDN Fld(1,8)//[8:8]
    #define MSDC_PWR_CON_MSDC_SRAM_SLEEP_B Fld(1,9)//[9:9]
    #define MSDC_PWR_CON_SC_MSDC_SRAM_PDN_ACK Fld(1,12)//[12:12]
    #define MSDC_PWR_CON_SC_MSDC_SRAM_SLEEP_B_ACK Fld(1,13)//[13:13]
#define DEBUGTOP_SRAM_CON (SPM_BASE_ADDRESS + 0x3A8)
    #define DEBUGTOP_SRAM_CON_DEBUGTOP_SRAM_PDN Fld(1,0)//[0:0]
#define DP_TX_PWR_CON (SPM_BASE_ADDRESS + 0x3AC)
    #define DP_TX_PWR_CON_DP_TX_PWR_RST_B Fld(1,0)//[0:0]
    #define DP_TX_PWR_CON_DP_TX_PWR_ISO Fld(1,1)//[1:1]
    #define DP_TX_PWR_CON_DP_TX_PWR_ON Fld(1,2)//[2:2]
    #define DP_TX_PWR_CON_DP_TX_PWR_ON_2ND Fld(1,3)//[3:3]
    #define DP_TX_PWR_CON_DP_TX_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define DP_TX_PWR_CON_DP_TX_SRAM_PDN Fld(1,8)//[8:8]
    #define DP_TX_PWR_CON_SC_DP_TX_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define DPMAIF_SRAM_CON (SPM_BASE_ADDRESS + 0x3B0)
    #define DPMAIF_SRAM_CON_DPMAIF_SRAM_PDN Fld(1,16)//[16:16]
    #define DPMAIF_SRAM_CON_DPMAIF_SRAM_SLEEP_B Fld(1,4)//[4:4]
    #define DPMAIF_SRAM_CON_DPMAIF_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define DPMAIF_SRAM_CON_DPMAIF_SRAM_CKISO Fld(1,0)//[0:0]
#define DPY_SHU2_SRAM_CON (SPM_BASE_ADDRESS + 0x3B4)
    #define DPY_SHU2_SRAM_CON_DPY_SHU2_SRAM_PDN Fld(2,16)//[17:16]
    #define DPY_SHU2_SRAM_CON_DPY_SHU2_SRAM_SLEEP_B Fld(2,4)//[5:4]
    #define DPY_SHU2_SRAM_CON_DPY_SHU2_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define DPY_SHU2_SRAM_CON_DPY_SHU2_SRAM_CKISO Fld(1,0)//[0:0]
#define DRAMC_MCU2_SRAM_CON (SPM_BASE_ADDRESS + 0x3B8)
    #define DRAMC_MCU2_SRAM_CON_DRAMC_MCU2_SRAM_PDN Fld(1,16)//[16:16]
    #define DRAMC_MCU2_SRAM_CON_DRAMC_MCU2_SRAM_SLEEP_B Fld(1,4)//[4:4]
    #define DRAMC_MCU2_SRAM_CON_DRAMC_MCU2_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define DRAMC_MCU2_SRAM_CON_DRAMC_MCU2_SRAM_CKISO Fld(1,0)//[0:0]
#define DRAMC_MCU_SRAM_CON (SPM_BASE_ADDRESS + 0x3BC)
    #define DRAMC_MCU_SRAM_CON_DRAMC_MCU_SRAM_PDN Fld(1,16)//[16:16]
    #define DRAMC_MCU_SRAM_CON_DRAMC_MCU_SRAM_SLEEP_B Fld(1,4)//[4:4]
    #define DRAMC_MCU_SRAM_CON_DRAMC_MCU_SRAM_ISOINT_B Fld(1,1)//[1:1]
    #define DRAMC_MCU_SRAM_CON_DRAMC_MCU_SRAM_CKISO Fld(1,0)//[0:0]
#define MCUPM_PWR_CON (SPM_BASE_ADDRESS + 0x3C0)
    #define MCUPM_PWR_CON_MCUPM_PWR_RST_B Fld(1,0)//[0:0]
    #define MCUPM_PWR_CON_MCUPM_PWR_ISO Fld(1,1)//[1:1]
    #define MCUPM_PWR_CON_MCUPM_PWR_ON Fld(1,2)//[2:2]
    #define MCUPM_PWR_CON_MCUPM_PWR_ON_2ND Fld(1,3)//[3:3]
    #define MCUPM_PWR_CON_MCUPM_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define MCUPM_PWR_CON_MCUPM_SRAM_CKISO Fld(1,5)//[5:5]
    #define MCUPM_PWR_CON_MCUPM_SRAM_ISOINT_B Fld(1,6)//[6:6]
    #define MCUPM_PWR_CON_MCUPM_SRAM_PDN Fld(1,8)//[8:8]
    #define MCUPM_PWR_CON_MCUPM_SRAM_SLEEP_B Fld(1,9)//[9:9]
    #define MCUPM_PWR_CON_SC_MCUPM_SRAM_PDN_ACK Fld(1,12)//[12:12]
    #define MCUPM_PWR_CON_SC_MCUPM_SRAM_SLEEP_B_ACK Fld(1,13)//[13:13]
#define DPY2_PWR_CON (SPM_BASE_ADDRESS + 0x3C4)
    #define DPY2_PWR_CON_DPY2_PWR_RST_B Fld(1,0)//[0:0]
    #define DPY2_PWR_CON_DPY2_PWR_ISO Fld(1,1)//[1:1]
    #define DPY2_PWR_CON_DPY2_PWR_ON Fld(1,2)//[2:2]
    #define DPY2_PWR_CON_DPY2_PWR_ON_2ND Fld(1,3)//[3:3]
    #define DPY2_PWR_CON_DPY2_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define DPY2_PWR_CON_DPY2_SRAM_PDN Fld(1,8)//[8:8]
    #define DPY2_PWR_CON_SC_DPY2_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define PERI_PWR_CON (SPM_BASE_ADDRESS + 0x3C8)
    #define PERI_PWR_CON_PERI_PWR_RST_B Fld(1,0)//[0:0]
    #define PERI_PWR_CON_PERI_PWR_ISO Fld(1,1)//[1:1]
    #define PERI_PWR_CON_PERI_PWR_ON Fld(1,2)//[2:2]
    #define PERI_PWR_CON_PERI_PWR_ON_2ND Fld(1,3)//[3:3]
    #define PERI_PWR_CON_PERI_PWR_CLK_DIS Fld(1,4)//[4:4]
    #define PERI_PWR_CON_PERI_SRAM_PDN Fld(1,8)//[8:8]
    #define PERI_PWR_CON_SC_PERI_SRAM_PDN_ACK Fld(1,12)//[12:12]
#define SPM_MEM_CK_SEL (SPM_BASE_ADDRESS + 0x400)
    #define SPM_MEM_CK_SEL_SC_MEM_CK_SEL Fld(1,0)//[0:0]
    #define SPM_MEM_CK_SEL_SPM2CKSYS_MEM_CK_MUX_UPDATE Fld(1,1)//[1:1]
#define SPM_BUS_PROTECT_MASK_B (SPM_BASE_ADDRESS + 0x404)
    #define SPM_BUS_PROTECT_MASK_B_SPM_BUS_PROTECT_MASK_B Fld(32,0)//[31:0]
#define SPM_BUS_PROTECT1_MASK_B (SPM_BASE_ADDRESS + 0x408)
    #define SPM_BUS_PROTECT1_MASK_B_SPM_BUS_PROTECT1_MASK_B Fld(32,0)//[31:0]
#define SPM_BUS_PROTECT2_MASK_B (SPM_BASE_ADDRESS + 0x40C)
    #define SPM_BUS_PROTECT2_MASK_B_SPM_BUS_PROTECT2_MASK_B Fld(32,0)//[31:0]
#define SPM_BUS_PROTECT3_MASK_B (SPM_BASE_ADDRESS + 0x410)
    #define SPM_BUS_PROTECT3_MASK_B_SPM_BUS_PROTECT3_MASK_B Fld(32,0)//[31:0]
#define SPM_BUS_PROTECT4_MASK_B (SPM_BASE_ADDRESS + 0x414)
    #define SPM_BUS_PROTECT4_MASK_B_SPM_BUS_PROTECT4_MASK_B Fld(32,0)//[31:0]
#define SPM_EMI_BW_MODE (SPM_BASE_ADDRESS + 0x418)
    #define SPM_EMI_BW_MODE_EMI_BW_MODE Fld(1,0)//[0:0]
    #define SPM_EMI_BW_MODE_EMI_BOOST_MODE Fld(1,1)//[1:1]
    #define SPM_EMI_BW_MODE_EMI_BW_MODE_2 Fld(1,2)//[2:2]
    #define SPM_EMI_BW_MODE_EMI_BOOST_MODE_2 Fld(1,3)//[3:3]
#define AP2MD_PEER_WAKEUP (SPM_BASE_ADDRESS + 0x41C)
    #define AP2MD_PEER_WAKEUP_AP2MD_PEER_WAKEUP Fld(1,0)//[0:0]
#define SPM_ULPOSC_CON (SPM_BASE_ADDRESS + 0x420)
    #define SPM_ULPOSC_CON_ULPOSC_EN Fld(1,0)//[0:0]
    #define SPM_ULPOSC_CON_ULPOSC_RST Fld(1,1)//[1:1]
    #define SPM_ULPOSC_CON_ULPOSC_CG_EN Fld(1,2)//[2:2]
    #define SPM_ULPOSC_CON_ULPOSC_CLK_SEL Fld(1,3)//[3:3]
#define SPM2MM_CON (SPM_BASE_ADDRESS + 0x424)
    #define SPM2MM_CON_SPM2MM_FORCE_ULTRA Fld(1,0)//[0:0]
    #define SPM2MM_CON_SPM2MM_DBL_OSTD_ACT Fld(1,1)//[1:1]
    #define SPM2MM_CON_SPM2MM_ULTRAREQ Fld(1,2)//[2:2]
    #define SPM2MM_CON_SPM2MD_ULTRAREQ Fld(1,3)//[3:3]
    #define SPM2MM_CON_SPM2ISP_ULTRAREQ Fld(1,4)//[4:4]
    #define SPM2MM_CON_MM2SPM_FORCE_ULTRA_ACK_D2T Fld(1,16)//[16:16]
    #define SPM2MM_CON_MM2SPM_DBL_OSTD_ACT_ACK_D2T Fld(1,17)//[17:17]
    #define SPM2MM_CON_SPM2ISP_ULTRAACK_D2T Fld(1,18)//[18:18]
    #define SPM2MM_CON_SPM2MM_ULTRAACK_D2T Fld(1,19)//[19:19]
    #define SPM2MM_CON_SPM2MD_ULTRAACK_D2T Fld(1,20)//[20:20]
#define SPM_BUS_PROTECT5_MASK_B (SPM_BASE_ADDRESS + 0x428)
    #define SPM_BUS_PROTECT5_MASK_B_SPM_BUS_PROTECT5_MASK_B Fld(32,0)//[31:0]
#define SPM2MCUPM_CON (SPM_BASE_ADDRESS + 0x42C)
    #define SPM2MCUPM_CON_SPM2MCUPM_SW_RST_B Fld(1,0)//[0:0]
    #define SPM2MCUPM_CON_SPM2MCUPM_SW_INT Fld(1,1)//[1:1]
#define AP_MDSRC_REQ (SPM_BASE_ADDRESS + 0x430)
    #define AP_MDSRC_REQ_AP_MDSMSRC_REQ Fld(1,0)//[0:0]
    #define AP_MDSRC_REQ_AP_L1SMSRC_REQ Fld(1,1)//[1:1]
    #define AP_MDSRC_REQ_AP_MD2SRC_REQ Fld(1,2)//[2:2]
    #define AP_MDSRC_REQ_AP_MDSMSRC_ACK Fld(1,4)//[4:4]
    #define AP_MDSRC_REQ_AP_L1SMSRC_ACK Fld(1,5)//[5:5]
    #define AP_MDSRC_REQ_AP_MD2SRC_ACK Fld(1,6)//[6:6]
#define SPM2EMI_ENTER_ULPM (SPM_BASE_ADDRESS + 0x434)
    #define SPM2EMI_ENTER_ULPM_SPM2EMI_ENTER_ULPM Fld(1,0)//[0:0]
#define SPM2MD_DVFS_CON (SPM_BASE_ADDRESS + 0x438)
    #define SPM2MD_DVFS_CON_SPM2MD_DVFS_CON Fld(32,0)//[31:0]
#define MD2SPM_DVFS_CON (SPM_BASE_ADDRESS + 0x43C)
    #define MD2SPM_DVFS_CON_MD2SPM_DVFS_CON Fld(32,0)//[31:0]
#define SPM_BUS_PROTECT6_MASK_B (SPM_BASE_ADDRESS + 0x440)
    #define SPM_BUS_PROTECT6_MASK_B_SPM_BUS_PROTECT6_MASK_B Fld(32,0)//[31:0]
#define SPM_BUS_PROTECT7_MASK_B (SPM_BASE_ADDRESS + 0x444)
    #define SPM_BUS_PROTECT7_MASK_B_SPM_BUS_PROTECT7_MASK_B Fld(32,0)//[31:0]
#define SPM_BUS_PROTECT8_MASK_B (SPM_BASE_ADDRESS + 0x448)
    #define SPM_BUS_PROTECT8_MASK_B_SPM_BUS_PROTECT8_MASK_B Fld(32,0)//[31:0]
#define SPM_PLL_CON (SPM_BASE_ADDRESS + 0x44C)
    #define SPM_PLL_CON_SC_MAINPLLOUT_OFF Fld(1,0)//[0:0]
    #define SPM_PLL_CON_SC_UNIPLLOUT_OFF Fld(1,1)//[1:1]
    #define SPM_PLL_CON_SC_MAINPLL_OFF Fld(1,4)//[4:4]
    #define SPM_PLL_CON_SC_UNIPLL_OFF Fld(1,5)//[5:5]
    #define SPM_PLL_CON_SC_MAINPLL_S_OFF Fld(1,8)//[8:8]
    #define SPM_PLL_CON_SC_UNIPLL_S_OFF Fld(1,9)//[9:9]
    #define SPM_PLL_CON_SC_SMI_CK_OFF Fld(1,16)//[16:16]
    #define SPM_PLL_CON_SC_MD32K_CK_OFF Fld(1,17)//[17:17]
    #define SPM_PLL_CON_SC_CKSQ1_OFF Fld(1,18)//[18:18]
    #define SPM_PLL_CON_SC_AXI_MEM_CK_OFF Fld(1,19)//[19:19]
#define CPU_DVFS_REQ (SPM_BASE_ADDRESS + 0x450)
    #define CPU_DVFS_REQ_CPU_DVFS_REQ Fld(32,0)//[31:0]
#define SPM_DRAM_MCU_SW_CON_0 (SPM_BASE_ADDRESS + 0x454)
    #define SPM_DRAM_MCU_SW_CON_0_SW_DDR_PST_REQ Fld(2,0)//[1:0]
    #define SPM_DRAM_MCU_SW_CON_0_SW_DDR_PST_ABORT_REQ Fld(2,2)//[3:2]
#define SPM_DRAM_MCU_SW_CON_1 (SPM_BASE_ADDRESS + 0x458)
    #define SPM_DRAM_MCU_SW_CON_1_SW_DDR_PST_CH0 Fld(32,0)//[31:0]
#define SPM_DRAM_MCU_SW_CON_2 (SPM_BASE_ADDRESS + 0x45C)
    #define SPM_DRAM_MCU_SW_CON_2_SW_DDR_PST_CH1 Fld(32,0)//[31:0]
#define SPM_DRAM_MCU_SW_CON_3 (SPM_BASE_ADDRESS + 0x460)
    #define SPM_DRAM_MCU_SW_CON_3_SW_DDR_RESERVED_CH0 Fld(32,0)//[31:0]
#define SPM_DRAM_MCU_SW_CON_4 (SPM_BASE_ADDRESS + 0x464)
    #define SPM_DRAM_MCU_SW_CON_4_SW_DDR_RESERVED_CH1 Fld(32,0)//[31:0]
#define SPM_DRAM_MCU_STA_0 (SPM_BASE_ADDRESS + 0x468)
    #define SPM_DRAM_MCU_STA_0_SC_DDR_PST_ACK Fld(2,0)//[1:0]
    #define SPM_DRAM_MCU_STA_0_SC_DDR_PST_ABORT_ACK Fld(2,2)//[3:2]
#define SPM_DRAM_MCU_STA_1 (SPM_BASE_ADDRESS + 0x46C)
    #define SPM_DRAM_MCU_STA_1_SC_DDR_CUR_PST_STA_CH0 Fld(32,0)//[31:0]
#define SPM_DRAM_MCU_STA_2 (SPM_BASE_ADDRESS + 0x470)
    #define SPM_DRAM_MCU_STA_2_SC_DDR_CUR_PST_STA_CH1 Fld(32,0)//[31:0]
#define SPM_DRAM_MCU_SW_SEL_0 (SPM_BASE_ADDRESS + 0x474)
    #define SPM_DRAM_MCU_SW_SEL_0_SW_DDR_PST_REQ_SEL Fld(2,0)//[1:0]
    #define SPM_DRAM_MCU_SW_SEL_0_SW_DDR_PST_ABORT_REQ_SEL Fld(2,4)//[5:4]
    #define SPM_DRAM_MCU_SW_SEL_0_SW_DDR_PST_SEL Fld(2,2)//[3:2]
    #define SPM_DRAM_MCU_SW_SEL_0_SW_DDR_RESERVED_SEL Fld(2,6)//[7:6]
    #define SPM_DRAM_MCU_SW_SEL_0_SW_DDR_PST_ACK_SEL Fld(2,8)//[9:8]
    #define SPM_DRAM_MCU_SW_SEL_0_SW_DDR_PST_ABORT_ACK_SEL Fld(2,10)//[11:10]

//Page SPM_5
#define RELAY_DVFS_LEVEL (SPM_BASE_ADDRESS + 0x478)
    #define RELAY_DVFS_LEVEL_RELAY_DVFS_LEVEL Fld(32,0)//[31:0]
#define DRAMC_DPY_CLK_SW_CON_0 (SPM_BASE_ADDRESS + 0x480)
    #define DRAMC_DPY_CLK_SW_CON_0_SW_PHYPLL_EN Fld(2,0)//[1:0]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_DPY_VREF_EN Fld(2,2)//[3:2]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_DPY_DLL_CK_EN Fld(2,4)//[5:4]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_DPY_DLL_EN Fld(2,6)//[7:6]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_DPY_2ND_DLL_EN Fld(2,8)//[9:8]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_MEM_CK_OFF Fld(2,10)//[11:10]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_DMSUS_OFF Fld(2,12)//[13:12]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_DPY_MODE_SW Fld(2,14)//[15:14]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_EMI_CLK_OFF Fld(2,16)//[17:16]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_DDRPHY_FB_CK_EN Fld(2,18)//[19:18]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_DR_GATE_RETRY_EN Fld(2,20)//[21:20]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_DPHY_PRECAL_UP Fld(2,24)//[25:24]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_DPY_BCLK_ENABLE Fld(2,26)//[27:26]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_TX_TRACKING_DIS Fld(2,28)//[29:28]
    #define DRAMC_DPY_CLK_SW_CON_0_SW_DPHY_RXDLY_TRACKING_EN Fld(2,30)//[31:30]
#define DRAMC_DPY_CLK_SW_CON_1 (SPM_BASE_ADDRESS + 0x484)
    #define DRAMC_DPY_CLK_SW_CON_1_SW_SHU_RESTORE Fld(2,0)//[1:0]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DMYRD_MOD Fld(2,2)//[3:2]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DMYRD_INTV Fld(2,4)//[5:4]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DMYRD_EN Fld(2,6)//[7:6]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DRS_DIS_REQ Fld(2,8)//[9:8]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DR_SRAM_LOAD Fld(2,10)//[11:10]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DR_SRAM_RESTORE Fld(2,12)//[13:12]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DR_SHU_LEVEL_SRAM_LATCH Fld(2,14)//[15:14]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_TX_TRACK_RETRY_EN Fld(2,16)//[17:16]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DPY_MIDPI_EN Fld(2,18)//[19:18]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DPY_PI_RESETB_EN Fld(2,20)//[21:20]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DPY_MCK8X_EN Fld(2,22)//[23:22]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DR_SHU_LEVEL_SRAM_CH0 Fld(4,24)//[27:24]
    #define DRAMC_DPY_CLK_SW_CON_1_SW_DR_SHU_LEVEL_SRAM_CH1 Fld(4,28)//[31:28]
#define SPM_DRAMC_DPY_CLK_SW_CON_2 (SPM_BASE_ADDRESS + 0x488)
    #define SPM_DRAMC_DPY_CLK_SW_CON_2_SW_DR_SHU_LEVEL Fld(2,0)//[1:0]
    #define SPM_DRAMC_DPY_CLK_SW_CON_2_SW_DR_SHU_EN Fld(1,2)//[2:2]
    #define SPM_DRAMC_DPY_CLK_SW_CON_2_SW_DR_SHORT_QUEUE Fld(1,3)//[3:3]
    #define SPM_DRAMC_DPY_CLK_SW_CON_2_SW_PHYPLL_MODE_SW Fld(1,4)//[4:4]
    #define SPM_DRAMC_DPY_CLK_SW_CON_2_SW_PHYPLL2_MODE_SW Fld(1,5)//[5:5]
    #define SPM_DRAMC_DPY_CLK_SW_CON_2_SW_PHYPLL_SHU_EN Fld(1,6)//[6:6]
    #define SPM_DRAMC_DPY_CLK_SW_CON_2_SW_PHYPLL2_SHU_EN Fld(1,7)//[7:7]
    #define SPM_DRAMC_DPY_CLK_SW_CON_2_SW_DR_RESERVED_0 Fld(2,24)//[25:24]
    #define SPM_DRAMC_DPY_CLK_SW_CON_2_SW_DR_RESERVED_1 Fld(2,26)//[27:26]
    #define SPM_DRAMC_DPY_CLK_SW_CON_2_SW_DR_RESERVED_2 Fld(2,28)//[29:28]
    #define SPM_DRAMC_DPY_CLK_SW_CON_2_SW_DR_RESERVED_3 Fld(2,30)//[31:30]
#define DRAMC_DPY_CLK_SW_CON_3 (SPM_BASE_ADDRESS + 0x48C)
    #define DRAMC_DPY_CLK_SW_CON_3_SC_DR_SHU_EN_ACK Fld(4,0)//[3:0]
    #define DRAMC_DPY_CLK_SW_CON_3_SC_EMI_CLK_OFF_ACK Fld(4,4)//[7:4]
    #define DRAMC_DPY_CLK_SW_CON_3_SC_DR_SHORT_QUEUE_ACK Fld(4,8)//[11:8]
    #define DRAMC_DPY_CLK_SW_CON_3_SC_DRAMC_DFS_STA Fld(4,12)//[15:12]
    #define DRAMC_DPY_CLK_SW_CON_3_SC_DRS_DIS_ACK Fld(4,16)//[19:16]
    #define DRAMC_DPY_CLK_SW_CON_3_SC_DR_SRAM_LOAD_ACK Fld(4,20)//[23:20]
    #define DRAMC_DPY_CLK_SW_CON_3_SC_DR_SRAM_PLL_LOAD_ACK Fld(4,24)//[27:24]
    #define DRAMC_DPY_CLK_SW_CON_3_SC_DR_SRAM_RESTORE_ACK Fld(4,28)//[31:28]
#define DRAMC_DPY_CLK_SW_SEL_0 (SPM_BASE_ADDRESS + 0x490)
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_PHYPLL_EN_SEL Fld(2,0)//[1:0]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_DPY_VREF_EN_SEL Fld(2,2)//[3:2]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_DPY_DLL_CK_EN_SEL Fld(2,4)//[5:4]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_DPY_DLL_EN_SEL Fld(2,6)//[7:6]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_DPY_2ND_DLL_EN_SEL Fld(2,8)//[9:8]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_MEM_CK_OFF_SEL Fld(2,10)//[11:10]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_DMSUS_OFF_SEL Fld(2,12)//[13:12]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_DPY_MODE_SW_SEL Fld(2,14)//[15:14]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_EMI_CLK_OFF_SEL Fld(2,16)//[17:16]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_DDRPHY_FB_CK_EN_SEL Fld(2,18)//[19:18]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_DR_GATE_RETRY_EN_SEL Fld(2,20)//[21:20]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_DPHY_PRECAL_UP_SEL Fld(2,24)//[25:24]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_DPY_BCLK_ENABLE_SEL Fld(2,26)//[27:26]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_TX_TRACKING_DIS_SEL Fld(2,28)//[29:28]
    #define DRAMC_DPY_CLK_SW_SEL_0_SW_DPHY_RXDLY_TRACKING_EN_SEL Fld(2,30)//[31:30]
#define DRAMC_DPY_CLK_SW_SEL_1 (SPM_BASE_ADDRESS + 0x494)
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_SHU_RESTORE_SEL Fld(2,0)//[1:0]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_DMYRD_MOD_SEL Fld(2,2)//[3:2]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_DMYRD_INTV_SEL Fld(2,4)//[5:4]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_DMYRD_EN_SEL Fld(2,6)//[7:6]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_DRS_DIS_REQ_SEL Fld(2,8)//[9:8]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_DR_SRAM_LOAD_SEL Fld(2,10)//[11:10]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_DR_SRAM_RESTORE_SEL Fld(2,12)//[13:12]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_DR_SHU_LEVEL_SRAM_LATCH_SEL Fld(2,14)//[15:14]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_TX_TRACK_RETRY_EN_SEL Fld(2,16)//[17:16]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_DPY_MIDPI_EN_SEL Fld(2,18)//[19:18]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_DPY_PI_RESETB_EN_SEL Fld(2,20)//[21:20]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_DPY_MCK8X_EN_SEL Fld(2,22)//[23:22]
    #define DRAMC_DPY_CLK_SW_SEL_1_SW_DR_SHU_LEVEL_SRAM_SEL Fld(2,24)//[25:24]
#define DRAMC_DPY_CLK_SW_SEL_2 (SPM_BASE_ADDRESS + 0x498)
    #define DRAMC_DPY_CLK_SW_SEL_2_SW_DR_SHU_LEVEL_SEL Fld(1,0)//[0:0]
    #define DRAMC_DPY_CLK_SW_SEL_2_SW_DR_SHU_EN_SEL Fld(1,2)//[2:2]
    #define DRAMC_DPY_CLK_SW_SEL_2_SW_DR_SHORT_QUEUE_SEL Fld(1,3)//[3:3]
    #define DRAMC_DPY_CLK_SW_SEL_2_SW_PHYPLL_MODE_SW_SEL Fld(1,4)//[4:4]
    #define DRAMC_DPY_CLK_SW_SEL_2_SW_PHYPLL2_MODE_SW_SEL Fld(1,5)//[5:5]
    #define DRAMC_DPY_CLK_SW_SEL_2_SW_PHYPLL_SHU_EN_SEL Fld(1,6)//[6:6]
    #define DRAMC_DPY_CLK_SW_SEL_2_SW_PHYPLL2_SHU_EN_SEL Fld(1,7)//[7:7]
    #define DRAMC_DPY_CLK_SW_SEL_2_SW_DR_RESERVED_0_SEL Fld(2,24)//[25:24]
    #define DRAMC_DPY_CLK_SW_SEL_2_SW_DR_RESERVED_1_SEL Fld(2,26)//[27:26]
    #define DRAMC_DPY_CLK_SW_SEL_2_SW_DR_RESERVED_2_SEL Fld(2,28)//[29:28]
    #define DRAMC_DPY_CLK_SW_SEL_2_SW_DR_RESERVED_3_SEL Fld(2,30)//[31:30]
#define DRAMC_DPY_CLK_SW_SEL_3 (SPM_BASE_ADDRESS + 0x49C)
    #define DRAMC_DPY_CLK_SW_SEL_3_SC_DR_SHU_EN_ACK_SEL Fld(4,0)//[3:0]
    #define DRAMC_DPY_CLK_SW_SEL_3_SC_EMI_CLK_OFF_ACK_SEL Fld(4,4)//[7:4]
    #define DRAMC_DPY_CLK_SW_SEL_3_SC_DR_SHORT_QUEUE_ACK_SEL Fld(4,8)//[11:8]
    #define DRAMC_DPY_CLK_SW_SEL_3_SC_DRAMC_DFS_STA_SEL Fld(4,12)//[15:12]
    #define DRAMC_DPY_CLK_SW_SEL_3_SC_DRS_DIS_ACK_SEL Fld(4,16)//[19:16]
    #define DRAMC_DPY_CLK_SW_SEL_3_SC_DR_SRAM_LOAD_ACK_SEL Fld(4,20)//[23:20]
    #define DRAMC_DPY_CLK_SW_SEL_3_SC_DR_SRAM_PLL_LOAD_ACK_SEL Fld(4,24)//[27:24]
    #define DRAMC_DPY_CLK_SW_SEL_3_SC_DR_SRAM_RESTORE_ACK_SEL Fld(4,28)//[31:28]
#define DRAMC_DPY_CLK_SPM_CON (SPM_BASE_ADDRESS + 0x4A0)
    #define DRAMC_DPY_CLK_SPM_CON_SC_DMYRD_EN_MOD_SEL_PCM Fld(1,0)//[0:0]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DMYRD_INTV_SEL_PCM Fld(1,1)//[1:1]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DMYRD_EN_PCM Fld(1,2)//[2:2]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DRS_DIS_REQ_PCM Fld(1,3)//[3:3]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DR_SHU_LEVEL_SRAM_PCM Fld(4,4)//[7:4]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DR_GATE_RETRY_EN_PCM Fld(1,8)//[8:8]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DR_SHORT_QUEUE_PCM Fld(1,9)//[9:9]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DPY_MIDPI_EN_PCM Fld(1,10)//[10:10]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DPY_PI_RESETB_EN_PCM Fld(1,11)//[11:11]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DPY_MCK8X_EN_PCM Fld(1,12)//[12:12]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DR_RESERVED_0_PCM Fld(1,13)//[13:13]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DR_RESERVED_1_PCM Fld(1,14)//[14:14]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DR_RESERVED_2_PCM Fld(1,15)//[15:15]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DR_RESERVED_3_PCM Fld(1,16)//[16:16]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DMDRAMCSHU_ACK_ALL Fld(1,24)//[24:24]
    #define DRAMC_DPY_CLK_SPM_CON_SC_EMI_CLK_OFF_ACK_ALL Fld(1,25)//[25:25]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DR_SHORT_QUEUE_ACK_ALL Fld(1,26)//[26:26]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DRAMC_DFS_STA_ALL Fld(1,27)//[27:27]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DRS_DIS_ACK_ALL Fld(1,28)//[28:28]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DR_SRAM_LOAD_ACK_ALL Fld(1,29)//[29:29]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DR_SRAM_PLL_LOAD_ACK_ALL Fld(1,30)//[30:30]
    #define DRAMC_DPY_CLK_SPM_CON_SC_DR_SRAM_RESTORE_ACK_ALL Fld(1,31)//[31:31]
#define SPM_DVFS_LEVEL (SPM_BASE_ADDRESS + 0x4A4)
    #define SPM_DVFS_LEVEL_SPM_DVFS_LEVEL Fld(32,0)//[31:0]
#define SPM_CIRQ_CON (SPM_BASE_ADDRESS + 0x4A8)
    #define SPM_CIRQ_CON_CIRQ_CLK_SEL Fld(1,0)//[0:0]
#define SPM_DVFS_MISC (SPM_BASE_ADDRESS + 0x4AC)
    #define SPM_DVFS_MISC_MSDC_DVFS_REQUEST Fld(1,0)//[0:0]
    #define SPM_DVFS_MISC_SPM2EMI_SLP_PROT_EN Fld(1,1)//[1:1]
    #define SPM_DVFS_MISC_SPM_DVFS_FORCE_ENABLE Fld(1,2)//[2:2]
    #define SPM_DVFS_MISC_FORCE_DVFS_WAKE Fld(1,3)//[3:3]
    #define SPM_DVFS_MISC_SPM_DVFSRC_ENABLE Fld(1,4)//[4:4]
    #define SPM_DVFS_MISC_SPM_DVFS_DONE Fld(1,5)//[5:5]
    #define SPM_DVFS_MISC_DVFSRC_IRQ_WAKEUP_EVENT_MASK Fld(1,6)//[6:6]
    #define SPM_DVFS_MISC_SPM2RC_EVENT_ABORT Fld(1,7)//[7:7]
    #define SPM_DVFS_MISC_EMI_SLP_IDLE Fld(1,14)//[14:14]
    #define SPM_DVFS_MISC_SDIO_READY_TO_SPM Fld(1,15)//[15:15]
#define SPM_VS1_VS2_RC_CON (SPM_BASE_ADDRESS + 0x4B0)
    #define SPM_VS1_VS2_RC_CON_VS1_INIT_LEVEL Fld(2,0)//[1:0]
    #define SPM_VS1_VS2_RC_CON_VS1_INIT Fld(1,2)//[2:2]
    #define SPM_VS1_VS2_RC_CON_VS1_CURR_LEVEL Fld(2,3)//[4:3]
    #define SPM_VS1_VS2_RC_CON_VS1_NEXT_LEVEL Fld(2,5)//[6:5]
    #define SPM_VS1_VS2_RC_CON_VS1_VOTE_LEVEL Fld(2,7)//[8:7]
    #define SPM_VS1_VS2_RC_CON_VS1_TRIGGER Fld(1,9)//[9:9]
    #define SPM_VS1_VS2_RC_CON_VS2_INIT_LEVEL Fld(3,10)//[12:10]
    #define SPM_VS1_VS2_RC_CON_VS2_INIT Fld(1,13)//[13:13]
    #define SPM_VS1_VS2_RC_CON_VS2_CURR_LEVEL Fld(3,14)//[16:14]
    #define SPM_VS1_VS2_RC_CON_VS2_NEXT_LEVEL Fld(3,17)//[19:17]
    #define SPM_VS1_VS2_RC_CON_VS2_VOTE_LEVEL Fld(3,20)//[22:20]
    #define SPM_VS1_VS2_RC_CON_VS2_TRIGGER Fld(1,23)//[23:23]
    #define SPM_VS1_VS2_RC_CON_VS1_FORCE Fld(1,24)//[24:24]
    #define SPM_VS1_VS2_RC_CON_VS2_FORCE Fld(1,25)//[25:25]
    #define SPM_VS1_VS2_RC_CON_VS1_VOTE_LEVEL_FORCE Fld(2,26)//[27:26]
    #define SPM_VS1_VS2_RC_CON_VS2_VOTE_LEVEL_FORCE Fld(3,28)//[30:28]
#define RG_MODULE_SW_CG_0_MASK_REQ_0 (SPM_BASE_ADDRESS + 0x4B4)
    #define RG_MODULE_SW_CG_0_MASK_REQ_0_RG_MODULE_SW_CG_0_MASK_REQ_0 Fld(32,0)//[31:0]
#define RG_MODULE_SW_CG_0_MASK_REQ_1 (SPM_BASE_ADDRESS + 0x4B8)
    #define RG_MODULE_SW_CG_0_MASK_REQ_1_RG_MODULE_SW_CG_0_MASK_REQ_1 Fld(32,0)//[31:0]
#define RG_MODULE_SW_CG_0_MASK_REQ_2 (SPM_BASE_ADDRESS + 0x4BC)
    #define RG_MODULE_SW_CG_0_MASK_REQ_2_RG_MODULE_SW_CG_0_MASK_REQ_2 Fld(32,0)//[31:0]
#define RG_MODULE_SW_CG_1_MASK_REQ_0 (SPM_BASE_ADDRESS + 0x4C0)
    #define RG_MODULE_SW_CG_1_MASK_REQ_0_RG_MODULE_SW_CG_1_MASK_REQ_0 Fld(32,0)//[31:0]
#define RG_MODULE_SW_CG_1_MASK_REQ_1 (SPM_BASE_ADDRESS + 0x4C4)
    #define RG_MODULE_SW_CG_1_MASK_REQ_1_RG_MODULE_SW_CG_1_MASK_REQ_1 Fld(32,0)//[31:0]
#define RG_MODULE_SW_CG_1_MASK_REQ_2 (SPM_BASE_ADDRESS + 0x4C8)
    #define RG_MODULE_SW_CG_1_MASK_REQ_2_RG_MODULE_SW_CG_1_MASK_REQ_2 Fld(32,0)//[31:0]
#define RG_MODULE_SW_CG_2_MASK_REQ_0 (SPM_BASE_ADDRESS + 0x4CC)
    #define RG_MODULE_SW_CG_2_MASK_REQ_0_RG_MODULE_SW_CG_2_MASK_REQ_0 Fld(32,0)//[31:0]
#define RG_MODULE_SW_CG_2_MASK_REQ_1 (SPM_BASE_ADDRESS + 0x4D0)
    #define RG_MODULE_SW_CG_2_MASK_REQ_1_RG_MODULE_SW_CG_2_MASK_REQ_1 Fld(32,0)//[31:0]
#define RG_MODULE_SW_CG_2_MASK_REQ_2 (SPM_BASE_ADDRESS + 0x4D4)
    #define RG_MODULE_SW_CG_2_MASK_REQ_2_RG_MODULE_SW_CG_2_MASK_REQ_2 Fld(32,0)//[31:0]
#define RG_MODULE_SW_CG_3_MASK_REQ_0 (SPM_BASE_ADDRESS + 0x4D8)
    #define RG_MODULE_SW_CG_3_MASK_REQ_0_RG_MODULE_SW_CG_3_MASK_REQ_0 Fld(32,0)//[31:0]
#define RG_MODULE_SW_CG_3_MASK_REQ_1 (SPM_BASE_ADDRESS + 0x4DC)
    #define RG_MODULE_SW_CG_3_MASK_REQ_1_RG_MODULE_SW_CG_3_MASK_REQ_1 Fld(32,0)//[31:0]
#define RG_MODULE_SW_CG_3_MASK_REQ_2 (SPM_BASE_ADDRESS + 0x4E0)
    #define RG_MODULE_SW_CG_3_MASK_REQ_2_RG_MODULE_SW_CG_3_MASK_REQ_2 Fld(32,0)//[31:0]
#define PWR_STATUS_MASK_REQ_0 (SPM_BASE_ADDRESS + 0x4E4)
    #define PWR_STATUS_MASK_REQ_0_PWR_STATUS_MASK_REQ_0 Fld(32,0)//[31:0]
#define PWR_STATUS_MASK_REQ_1 (SPM_BASE_ADDRESS + 0x4E8)
    #define PWR_STATUS_MASK_REQ_1_PWR_STATUS_MASK_REQ_1 Fld(32,0)//[31:0]
#define PWR_STATUS_MASK_REQ_2 (SPM_BASE_ADDRESS + 0x4EC)
    #define PWR_STATUS_MASK_REQ_2_PWR_STATUS_MASK_REQ_2 Fld(32,0)//[31:0]
#define SPM_CG_CHECK_CON (SPM_BASE_ADDRESS + 0x4F0)
    #define SPM_CG_CHECK_CON_APMIXEDSYS_BUSY_MASK_REQ_0 Fld(5,0)//[4:0]
    #define SPM_CG_CHECK_CON_APMIXEDSYS_BUSY_MASK_REQ_1 Fld(5,8)//[12:8]
    #define SPM_CG_CHECK_CON_APMIXEDSYS_BUSY_MASK_REQ_2 Fld(5,16)//[20:16]
    #define SPM_CG_CHECK_CON_AUDIOSYS_BUSY_MASK_REQ_0 Fld(1,24)//[24:24]
    #define SPM_CG_CHECK_CON_AUDIOSYS_BUSY_MASK_REQ_1 Fld(1,25)//[25:25]
    #define SPM_CG_CHECK_CON_AUDIOSYS_BUSY_MASK_REQ_2 Fld(1,26)//[26:26]
    #define SPM_CG_CHECK_CON_SSUSB_BUSY_MASK_REQ_0 Fld(1,27)//[27:27]
    #define SPM_CG_CHECK_CON_SSUSB_BUSY_MASK_REQ_1 Fld(1,28)//[28:28]
    #define SPM_CG_CHECK_CON_SSUSB_BUSY_MASK_REQ_2 Fld(1,29)//[29:29]
#define SPM_SRC_RDY_STA (SPM_BASE_ADDRESS + 0x4F4)
    #define SPM_SRC_RDY_STA_SPM_INFRA_INTERNAL_ACK Fld(1,0)//[0:0]
    #define SPM_SRC_RDY_STA_SPM_VRF18_INTERNAL_ACK Fld(1,1)//[1:1]
#define SPM_DVS_DFS_LEVEL (SPM_BASE_ADDRESS + 0x4F8)
    #define SPM_DVS_DFS_LEVEL_SPM_DFS_LEVEL Fld(16,0)//[15:0]
    #define SPM_DVS_DFS_LEVEL_SPM_DVS_LEVEL Fld(16,16)//[31:16]
#define SPM_FORCE_DVFS (SPM_BASE_ADDRESS + 0x4FC)
    #define SPM_FORCE_DVFS_FORCE_DVFS_LEVEL Fld(32,0)//[31:0]
#define SRCLKEN_RC_CFG (SPM_BASE_ADDRESS + 0x500)
    #define SRCLKEN_RC_CFG_SRCLKEN_RC_CFG Fld(32,0)//[31:0]
#define RC_CENTRAL_CFG1 (SPM_BASE_ADDRESS + 0x504)
    #define RC_CENTRAL_CFG1_RC_CENTRAL_CFG1 Fld(32,0)//[31:0]
#define RC_CENTRAL_CFG2 (SPM_BASE_ADDRESS + 0x508)
    #define RC_CENTRAL_CFG2_RC_CENTRAL_CFG2 Fld(32,0)//[31:0]
#define RC_CMD_ARB_CFG (SPM_BASE_ADDRESS + 0x50C)
    #define RC_CMD_ARB_CFG_RC_CMD_ARB_CFG Fld(32,0)//[31:0]
#define RC_PMIC_RCEN_ADDR (SPM_BASE_ADDRESS + 0x510)
    #define RC_PMIC_RCEN_ADDR_RC_PMIC_RCEN_ADDR Fld(16,0)//[15:0]
    #define RC_PMIC_RCEN_ADDR_RC_PMIC_RCEN_RESERVE Fld(16,16)//[31:16]
#define RC_PMIC_RCEN_SET_CLR_ADDR (SPM_BASE_ADDRESS + 0x514)
    #define RC_PMIC_RCEN_SET_CLR_ADDR_RC_PMIC_RCEN_SET_ADDR Fld(16,0)//[15:0]
    #define RC_PMIC_RCEN_SET_CLR_ADDR_RC_PMIC_RCEN_CLR_ADDR Fld(16,16)//[31:16]
#define RC_DCXO_FPM_CFG (SPM_BASE_ADDRESS + 0x518)
    #define RC_DCXO_FPM_CFG_RC_DCXO_FPM_CFG Fld(32,0)//[31:0]
#define RC_CENTRAL_CFG3 (SPM_BASE_ADDRESS + 0x51C)
    #define RC_CENTRAL_CFG3_RC_CENTRAL_CFG3 Fld(32,0)//[31:0]
#define RC_M00_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x520)
    #define RC_M00_SRCLKEN_CFG_RC_M00_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M01_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x524)
    #define RC_M01_SRCLKEN_CFG_RC_M01_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M02_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x528)
    #define RC_M02_SRCLKEN_CFG_RC_M02_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M03_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x52C)
    #define RC_M03_SRCLKEN_CFG_RC_M03_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M04_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x530)
    #define RC_M04_SRCLKEN_CFG_RC_M04_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M05_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x534)
    #define RC_M05_SRCLKEN_CFG_RC_M05_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M06_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x538)
    #define RC_M06_SRCLKEN_CFG_RC_M06_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M07_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x53C)
    #define RC_M07_SRCLKEN_CFG_RC_M07_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M08_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x540)
    #define RC_M08_SRCLKEN_CFG_RC_M08_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M09_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x544)
    #define RC_M09_SRCLKEN_CFG_RC_M09_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M10_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x548)
    #define RC_M10_SRCLKEN_CFG_RC_M10_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M11_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x54C)
    #define RC_M11_SRCLKEN_CFG_RC_M11_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_M12_SRCLKEN_CFG (SPM_BASE_ADDRESS + 0x550)
    #define RC_M12_SRCLKEN_CFG_RC_M12_SRCLKEN_CFG Fld(32,0)//[31:0]
#define RC_SRCLKEN_SW_CON_CFG (SPM_BASE_ADDRESS + 0x554)
    #define RC_SRCLKEN_SW_CON_CFG_RC_SRCLKEN_SW_CON_CFG Fld(32,0)//[31:0]
#define RC_CENTRAL_CFG4 (SPM_BASE_ADDRESS + 0x558)
    #define RC_CENTRAL_CFG4_RC_CENTRAL_CFG4 Fld(32,0)//[31:0]
#define RC_PROTOCOL_CHK_CFG (SPM_BASE_ADDRESS + 0x560)
    #define RC_PROTOCOL_CHK_CFG_RC_PROTOCOL_CHK_CFG Fld(32,0)//[31:0]
#define RC_DEBUG_CFG (SPM_BASE_ADDRESS + 0x564)
    #define RC_DEBUG_CFG_RC_DEBUG_CFG Fld(32,0)//[31:0]
#define RC_MISC_0 (SPM_BASE_ADDRESS + 0x5B4)
    #define RC_MISC_0_SRCCLKENO Fld(2,0)//[1:0]
    #define RC_MISC_0_PCM_SRCCLKENO Fld(2,3)//[4:3]
    #define RC_MISC_0_RC_VREQ Fld(1,5)//[5:5]
    #define RC_MISC_0_RC_SPM_SRCCLKENO_0_ACK Fld(1,6)//[6:6]
#define RC_SPM_CTRL (SPM_BASE_ADDRESS + 0x5B8)
    #define RC_SPM_CTRL_SPM_AP_26M_RDY Fld(1,0)//[0:0]
    #define RC_SPM_CTRL_KEEP_RC_SPI_ACTIVE Fld(1,1)//[1:1]
    #define RC_SPM_CTRL_SPM2RC_DMY_CTRL Fld(6,2)//[7:2]
#define SUBSYS_INTF_CFG (SPM_BASE_ADDRESS + 0x5BC)
    #define SUBSYS_INTF_CFG_SRCLKEN_FPM_MASK_B Fld(13,0)//[12:0]
    #define SUBSYS_INTF_CFG_SRCLKEN_BBLPM_MASK_B Fld(13,16)//[28:16]
#define PCM_WDT_LATCH_25 (SPM_BASE_ADDRESS + 0x5C0)
    #define PCM_WDT_LATCH_25_PCM_WDT_LATCH_25 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_26 (SPM_BASE_ADDRESS + 0x5C4)
    #define PCM_WDT_LATCH_26_PCM_WDT_LATCH_26 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_27 (SPM_BASE_ADDRESS + 0x5C8)
    #define PCM_WDT_LATCH_27_PCM_WDT_LATCH_27 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_28 (SPM_BASE_ADDRESS + 0x5CC)
    #define PCM_WDT_LATCH_28_PCM_WDT_LATCH_28 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_29 (SPM_BASE_ADDRESS + 0x5D0)
    #define PCM_WDT_LATCH_29_PCM_WDT_LATCH_29 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_30 (SPM_BASE_ADDRESS + 0x5D4)
    #define PCM_WDT_LATCH_30_PCM_WDT_LATCH_30 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_31 (SPM_BASE_ADDRESS + 0x5D8)
    #define PCM_WDT_LATCH_31_PCM_WDT_LATCH_31 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_32 (SPM_BASE_ADDRESS + 0x5DC)
    #define PCM_WDT_LATCH_32_PCM_WDT_LATCH_32 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_33 (SPM_BASE_ADDRESS + 0x5E0)
    #define PCM_WDT_LATCH_33_PCM_WDT_LATCH_33 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_34 (SPM_BASE_ADDRESS + 0x5E4)
    #define PCM_WDT_LATCH_34_PCM_WDT_LATCH_34 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_35 (SPM_BASE_ADDRESS + 0x5EC)
    #define PCM_WDT_LATCH_35_PCM_WDT_LATCH_35 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_36 (SPM_BASE_ADDRESS + 0x5F0)
    #define PCM_WDT_LATCH_36_PCM_WDT_LATCH_36 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_37 (SPM_BASE_ADDRESS + 0x5F4)
    #define PCM_WDT_LATCH_37_PCM_WDT_LATCH_37 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_38 (SPM_BASE_ADDRESS + 0x5F8)
    #define PCM_WDT_LATCH_38_PCM_WDT_LATCH_38 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_39 (SPM_BASE_ADDRESS + 0x5FC)
    #define PCM_WDT_LATCH_39_PCM_WDT_LATCH_39 Fld(32,0)//[31:0]
#define SPM_DVFS_CON (SPM_BASE_ADDRESS + 0x700)
    #define SPM_DVFS_CON_SPM_DVFS_CON Fld(32,0)//[31:0]
#define SPM_DVFS_CON_STA (SPM_BASE_ADDRESS + 0x704)
    #define SPM_DVFS_CON_STA_SPM_DVFS_CON_STA Fld(32,0)//[31:0]
#define SPM_PMIC_SPMI_CON (SPM_BASE_ADDRESS + 0x708)
    #define SPM_PMIC_SPMI_CON_SPM_PMIC_SPMI_CMD Fld(2,0)//[1:0]
    #define SPM_PMIC_SPMI_CON_SPM_PMIC_SPMI_SLAVEID Fld(4,2)//[5:2]
    #define SPM_PMIC_SPMI_CON_SPM_PMIC_SPMI_PMIFID Fld(1,6)//[6:6]
    #define SPM_PMIC_SPMI_CON_SPM_PMIC_SPMI_DBCNT Fld(1,7)//[7:7]
#define SPM_DVFS_CMD0 (SPM_BASE_ADDRESS + 0x710)
    #define SPM_DVFS_CMD0_SPM_DVFS_CMD0 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD1 (SPM_BASE_ADDRESS + 0x714)
    #define SPM_DVFS_CMD1_SPM_DVFS_CMD1 Fld(32,0)//[31:0]

//Page SPM_6
#define SPM_DVFS_CMD2 (SPM_BASE_ADDRESS + 0x718)
    #define SPM_DVFS_CMD2_SPM_DVFS_CMD2 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD3 (SPM_BASE_ADDRESS + 0x71C)
    #define SPM_DVFS_CMD3_SPM_DVFS_CMD3 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD4 (SPM_BASE_ADDRESS + 0x720)
    #define SPM_DVFS_CMD4_SPM_DVFS_CMD4 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD5 (SPM_BASE_ADDRESS + 0x724)
    #define SPM_DVFS_CMD5_SPM_DVFS_CMD5 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD6 (SPM_BASE_ADDRESS + 0x728)
    #define SPM_DVFS_CMD6_SPM_DVFS_CMD6 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD7 (SPM_BASE_ADDRESS + 0x72C)
    #define SPM_DVFS_CMD7_SPM_DVFS_CMD7 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD8 (SPM_BASE_ADDRESS + 0x730)
    #define SPM_DVFS_CMD8_SPM_DVFS_CMD8 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD9 (SPM_BASE_ADDRESS + 0x734)
    #define SPM_DVFS_CMD9_SPM_DVFS_CMD9 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD10 (SPM_BASE_ADDRESS + 0x738)
    #define SPM_DVFS_CMD10_SPM_DVFS_CMD10 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD11 (SPM_BASE_ADDRESS + 0x73C)
    #define SPM_DVFS_CMD11_SPM_DVFS_CMD11 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD12 (SPM_BASE_ADDRESS + 0x740)
    #define SPM_DVFS_CMD12_SPM_DVFS_CMD12 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD13 (SPM_BASE_ADDRESS + 0x744)
    #define SPM_DVFS_CMD13_SPM_DVFS_CMD13 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD14 (SPM_BASE_ADDRESS + 0x748)
    #define SPM_DVFS_CMD14_SPM_DVFS_CMD14 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD15 (SPM_BASE_ADDRESS + 0x74C)
    #define SPM_DVFS_CMD15_SPM_DVFS_CMD15 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD16 (SPM_BASE_ADDRESS + 0x750)
    #define SPM_DVFS_CMD16_SPM_DVFS_CMD16 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD17 (SPM_BASE_ADDRESS + 0x754)
    #define SPM_DVFS_CMD17_SPM_DVFS_CMD17 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD18 (SPM_BASE_ADDRESS + 0x758)
    #define SPM_DVFS_CMD18_SPM_DVFS_CMD18 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD19 (SPM_BASE_ADDRESS + 0x75C)
    #define SPM_DVFS_CMD19_SPM_DVFS_CMD19 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD20 (SPM_BASE_ADDRESS + 0x760)
    #define SPM_DVFS_CMD20_SPM_DVFS_CMD20 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD21 (SPM_BASE_ADDRESS + 0x764)
    #define SPM_DVFS_CMD21_SPM_DVFS_CMD21 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD22 (SPM_BASE_ADDRESS + 0x768)
    #define SPM_DVFS_CMD22_SPM_DVFS_CMD22 Fld(32,0)//[31:0]
#define SPM_DVFS_CMD23 (SPM_BASE_ADDRESS + 0x76C)
    #define SPM_DVFS_CMD23_SPM_DVFS_CMD23 Fld(32,0)//[31:0]
#define SYS_TIMER_VALUE_L (SPM_BASE_ADDRESS + 0x770)
    #define SYS_TIMER_VALUE_L_SYS_TIMER_VALUE_L Fld(32,0)//[31:0]
#define SYS_TIMER_VALUE_H (SPM_BASE_ADDRESS + 0x774)
    #define SYS_TIMER_VALUE_H_SYS_TIMER_VALUE_H Fld(32,0)//[31:0]
#define SYS_TIMER_START_L (SPM_BASE_ADDRESS + 0x778)
    #define SYS_TIMER_START_L_SYS_TIMER_START_L Fld(32,0)//[31:0]
#define SYS_TIMER_START_H (SPM_BASE_ADDRESS + 0x77C)
    #define SYS_TIMER_START_H_SYS_TIMER_START_H Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_00 (SPM_BASE_ADDRESS + 0x780)
    #define SYS_TIMER_LATCH_L_00_SYS_TIMER_LATCH_L_00 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_00 (SPM_BASE_ADDRESS + 0x784)
    #define SYS_TIMER_LATCH_H_00_SYS_TIMER_LATCH_H_00 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_01 (SPM_BASE_ADDRESS + 0x788)
    #define SYS_TIMER_LATCH_L_01_SYS_TIMER_LATCH_L_01 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_01 (SPM_BASE_ADDRESS + 0x78C)
    #define SYS_TIMER_LATCH_H_01_SYS_TIMER_LATCH_H_01 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_02 (SPM_BASE_ADDRESS + 0x790)
    #define SYS_TIMER_LATCH_L_02_SYS_TIMER_LATCH_L_02 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_02 (SPM_BASE_ADDRESS + 0x794)
    #define SYS_TIMER_LATCH_H_02_SYS_TIMER_LATCH_H_02 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_03 (SPM_BASE_ADDRESS + 0x798)
    #define SYS_TIMER_LATCH_L_03_SYS_TIMER_LATCH_L_03 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_03 (SPM_BASE_ADDRESS + 0x79C)
    #define SYS_TIMER_LATCH_H_03_SYS_TIMER_LATCH_H_03 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_04 (SPM_BASE_ADDRESS + 0x7A0)
    #define SYS_TIMER_LATCH_L_04_SYS_TIMER_LATCH_L_04 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_04 (SPM_BASE_ADDRESS + 0x7A4)
    #define SYS_TIMER_LATCH_H_04_SYS_TIMER_LATCH_H_04 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_05 (SPM_BASE_ADDRESS + 0x7A8)
    #define SYS_TIMER_LATCH_L_05_SYS_TIMER_LATCH_L_05 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_05 (SPM_BASE_ADDRESS + 0x7AC)
    #define SYS_TIMER_LATCH_H_05_SYS_TIMER_LATCH_H_05 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_06 (SPM_BASE_ADDRESS + 0x7B0)
    #define SYS_TIMER_LATCH_L_06_SYS_TIMER_LATCH_L_06 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_06 (SPM_BASE_ADDRESS + 0x7B4)
    #define SYS_TIMER_LATCH_H_06_SYS_TIMER_LATCH_H_06 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_07 (SPM_BASE_ADDRESS + 0x7B8)
    #define SYS_TIMER_LATCH_L_07_SYS_TIMER_LATCH_L_07 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_07 (SPM_BASE_ADDRESS + 0x7BC)
    #define SYS_TIMER_LATCH_H_07_SYS_TIMER_LATCH_H_07 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_08 (SPM_BASE_ADDRESS + 0x7C0)
    #define SYS_TIMER_LATCH_L_08_SYS_TIMER_LATCH_L_08 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_08 (SPM_BASE_ADDRESS + 0x7C4)
    #define SYS_TIMER_LATCH_H_08_SYS_TIMER_LATCH_H_08 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_09 (SPM_BASE_ADDRESS + 0x7C8)
    #define SYS_TIMER_LATCH_L_09_SYS_TIMER_LATCH_L_09 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_09 (SPM_BASE_ADDRESS + 0x7CC)
    #define SYS_TIMER_LATCH_H_09_SYS_TIMER_LATCH_H_09 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_10 (SPM_BASE_ADDRESS + 0x7D0)
    #define SYS_TIMER_LATCH_L_10_SYS_TIMER_LATCH_L_10 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_10 (SPM_BASE_ADDRESS + 0x7D4)
    #define SYS_TIMER_LATCH_H_10_SYS_TIMER_LATCH_H_10 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_11 (SPM_BASE_ADDRESS + 0x7D8)
    #define SYS_TIMER_LATCH_L_11_SYS_TIMER_LATCH_L_11 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_11 (SPM_BASE_ADDRESS + 0x7DC)
    #define SYS_TIMER_LATCH_H_11_SYS_TIMER_LATCH_H_11 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_12 (SPM_BASE_ADDRESS + 0x7E0)
    #define SYS_TIMER_LATCH_L_12_SYS_TIMER_LATCH_L_12 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_12 (SPM_BASE_ADDRESS + 0x7E4)
    #define SYS_TIMER_LATCH_H_12_SYS_TIMER_LATCH_H_12 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_13 (SPM_BASE_ADDRESS + 0x7E8)
    #define SYS_TIMER_LATCH_L_13_SYS_TIMER_LATCH_L_13 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_13 (SPM_BASE_ADDRESS + 0x7EC)
    #define SYS_TIMER_LATCH_H_13_SYS_TIMER_LATCH_H_13 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_14 (SPM_BASE_ADDRESS + 0x7F0)
    #define SYS_TIMER_LATCH_L_14_SYS_TIMER_LATCH_L_14 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_14 (SPM_BASE_ADDRESS + 0x7F4)
    #define SYS_TIMER_LATCH_H_14_SYS_TIMER_LATCH_H_14 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_L_15 (SPM_BASE_ADDRESS + 0x7F8)
    #define SYS_TIMER_LATCH_L_15_SYS_TIMER_LATCH_L_15 Fld(32,0)//[31:0]
#define SYS_TIMER_LATCH_H_15 (SPM_BASE_ADDRESS + 0x7FC)
    #define SYS_TIMER_LATCH_H_15_SYS_TIMER_LATCH_H_15 Fld(32,0)//[31:0]
#define SPM_SW_FLAG_0 (SPM_BASE_ADDRESS + 0x600)
    #define SPM_SW_FLAG_0_SPM_SW_FLAG Fld(32,0)//[31:0]
#define SPM_SW_DEBUG_0 (SPM_BASE_ADDRESS + 0x604)
    #define SPM_SW_DEBUG_0_SPM_SW_DEBUG_0 Fld(32,0)//[31:0]
#define SPM_SW_FLAG_1 (SPM_BASE_ADDRESS + 0x608)
    #define SPM_SW_FLAG_1_SPM_SW_FLAG_1 Fld(32,0)//[31:0]
#define SPM_SW_DEBUG_1 (SPM_BASE_ADDRESS + 0x60C)
    #define SPM_SW_DEBUG_1_SPM_SW_DEBUG_1 Fld(32,0)//[31:0]
#define SPM_SW_RSV_0 (SPM_BASE_ADDRESS + 0x610)
    #define SPM_SW_RSV_0_SPM_SW_RSV_0 Fld(32,0)//[31:0]
#define SPM_SW_RSV_1 (SPM_BASE_ADDRESS + 0x614)
    #define SPM_SW_RSV_1_SPM_SW_RSV_1 Fld(32,0)//[31:0]
#define SPM_SW_RSV_2 (SPM_BASE_ADDRESS + 0x618)
    #define SPM_SW_RSV_2_SPM_SW_RSV_2 Fld(32,0)//[31:0]
#define SPM_SW_RSV_3 (SPM_BASE_ADDRESS + 0x61C)
    #define SPM_SW_RSV_3_SPM_SW_RSV_3 Fld(32,0)//[31:0]
#define SPM_SW_RSV_4 (SPM_BASE_ADDRESS + 0x620)
    #define SPM_SW_RSV_4_SPM_SW_RSV_4 Fld(32,0)//[31:0]
#define SPM_SW_RSV_5 (SPM_BASE_ADDRESS + 0x624)
    #define SPM_SW_RSV_5_SPM_SW_RSV_5 Fld(32,0)//[31:0]
#define SPM_SW_RSV_6 (SPM_BASE_ADDRESS + 0x628)
    #define SPM_SW_RSV_6_SPM_SW_RSV_6 Fld(32,0)//[31:0]
#define SPM_SW_RSV_7 (SPM_BASE_ADDRESS + 0x62C)
    #define SPM_SW_RSV_7_SPM_SW_RSV_7 Fld(32,0)//[31:0]
#define SPM_SW_RSV_8 (SPM_BASE_ADDRESS + 0x630)
    #define SPM_SW_RSV_8_SPM_SW_RSV_8 Fld(32,0)//[31:0]
#define SPM_BK_WAKE_EVENT (SPM_BASE_ADDRESS + 0x634)
    #define SPM_BK_WAKE_EVENT_SPM_BK_WAKE_EVENT Fld(32,0)//[31:0]
#define SPM_BK_VTCXO_DUR (SPM_BASE_ADDRESS + 0x638)
    #define SPM_BK_VTCXO_DUR_SPM_BK_VTCXO_DUR Fld(32,0)//[31:0]
#define SPM_BK_WAKE_MISC (SPM_BASE_ADDRESS + 0x63C)
    #define SPM_BK_WAKE_MISC_SPM_BK_WAKE_MISC Fld(32,0)//[31:0]
#define SPM_BK_PCM_TIMER (SPM_BASE_ADDRESS + 0x640)
    #define SPM_BK_PCM_TIMER_SPM_BK_PCM_TIMER Fld(32,0)//[31:0]
#define SPM_RSV_CON_0 (SPM_BASE_ADDRESS + 0x650)
    #define SPM_RSV_CON_0_SPM_RSV_CON_0 Fld(32,0)//[31:0]
#define SPM_RSV_CON_1 (SPM_BASE_ADDRESS + 0x654)
    #define SPM_RSV_CON_1_SPM_RSV_CON_1 Fld(32,0)//[31:0]
#define SPM_RSV_STA_0 (SPM_BASE_ADDRESS + 0x658)
    #define SPM_RSV_STA_0_SPM_RSV_STA_0 Fld(32,0)//[31:0]
#define SPM_RSV_STA_1 (SPM_BASE_ADDRESS + 0x65C)
    #define SPM_RSV_STA_1_SPM_RSV_STA_1 Fld(32,0)//[31:0]
#define SPM_SPARE_CON (SPM_BASE_ADDRESS + 0x660)
    #define SPM_SPARE_CON_SPM_SPARE_CON Fld(32,0)//[31:0]
#define SPM_SPARE_CON_SET (SPM_BASE_ADDRESS + 0x664)
    #define SPM_SPARE_CON_SET_SPM_SPARE_CON_SET Fld(32,0)//[31:0]
#define SPM_SPARE_CON_CLR (SPM_BASE_ADDRESS + 0x668)
    #define SPM_SPARE_CON_CLR_SPM_SPARE_CON_CLR Fld(32,0)//[31:0]
#define SPM_CROSS_WAKE_M00_REQ (SPM_BASE_ADDRESS + 0x66C)
    #define SPM_CROSS_WAKE_M00_REQ_SPM_CROSS_WAKE_M00_CHK Fld(5,8)//[12:8]
    #define SPM_CROSS_WAKE_M00_REQ_SPM_CROSS_WAKE_M00_REQ Fld(5,0)//[4:0]
#define SPM_CROSS_WAKE_M01_REQ (SPM_BASE_ADDRESS + 0x670)
    #define SPM_CROSS_WAKE_M01_REQ_SPM_CROSS_WAKE_M01_CHK Fld(5,8)//[12:8]
    #define SPM_CROSS_WAKE_M01_REQ_SPM_CROSS_WAKE_M01_REQ Fld(5,0)//[4:0]
#define SPM_CROSS_WAKE_M02_REQ (SPM_BASE_ADDRESS + 0x674)
    #define SPM_CROSS_WAKE_M02_REQ_SPM_CROSS_WAKE_M02_CHK Fld(5,8)//[12:8]
    #define SPM_CROSS_WAKE_M02_REQ_SPM_CROSS_WAKE_M02_REQ Fld(5,0)//[4:0]
#define SPM_CROSS_WAKE_M03_REQ (SPM_BASE_ADDRESS + 0x678)
    #define SPM_CROSS_WAKE_M03_REQ_SPM_CROSS_WAKE_M03_CHK Fld(5,8)//[12:8]
    #define SPM_CROSS_WAKE_M03_REQ_SPM_CROSS_WAKE_M03_REQ Fld(5,0)//[4:0]
#define SPM_CROSS_WAKE_M04_REQ (SPM_BASE_ADDRESS + 0x688)
    #define SPM_CROSS_WAKE_M04_REQ_SPM_CROSS_WAKE_M04_CHK Fld(5,8)//[12:8]
    #define SPM_CROSS_WAKE_M04_REQ_SPM_CROSS_WAKE_M04_REQ Fld(5,0)//[4:0]
#define SCP_VCORE_LEVEL (SPM_BASE_ADDRESS + 0x67C)
    #define SCP_VCORE_LEVEL_SCP_VCORE_LEVEL Fld(16,0)//[15:0]
#define SC_MM_CK_SEL_CON (SPM_BASE_ADDRESS + 0x680)
    #define SC_MM_CK_SEL_CON_SC_MM_CK_SEL Fld(4,0)//[3:0]
    #define SC_MM_CK_SEL_CON_SC_MM_CK_SEL_EN Fld(1,4)//[4:4]
#define SPARE_ACK_MASK (SPM_BASE_ADDRESS + 0x684)
    #define SPARE_ACK_MASK_SPARE_ACK_MASK_B Fld(32,0)//[31:0]
#define SPM_DV_CON_0 (SPM_BASE_ADDRESS + 0x68C)
    #define SPM_DV_CON_0_SPM_DV_CON_0 Fld(32,0)//[31:0]
#define SPM_DV_CON_1 (SPM_BASE_ADDRESS + 0x690)
    #define SPM_DV_CON_1_SPM_DV_CON_1 Fld(32,0)//[31:0]
#define SPM_DV_STA (SPM_BASE_ADDRESS + 0x694)
    #define SPM_DV_STA_SPM_DV_STA Fld(32,0)//[31:0]
#define CONN_XOWCN_DEBUG_EN (SPM_BASE_ADDRESS + 0x698)
    #define CONN_XOWCN_DEBUG_EN_CONN_XOWCN_DEBUG_EN Fld(1,0)//[0:0]
#define SPM_SEMA_M0 (SPM_BASE_ADDRESS + 0x69C)
    #define SPM_SEMA_M0_SPM_SEMA_M0 Fld(8,0)//[7:0]
#define SPM_SEMA_M1 (SPM_BASE_ADDRESS + 0x6A0)
    #define SPM_SEMA_M1_SPM_SEMA_M1 Fld(8,0)//[7:0]
#define SPM_SEMA_M2 (SPM_BASE_ADDRESS + 0x6A4)
    #define SPM_SEMA_M2_SPM_SEMA_M2 Fld(8,0)//[7:0]
#define SPM_SEMA_M3 (SPM_BASE_ADDRESS + 0x6A8)
    #define SPM_SEMA_M3_SPM_SEMA_M3 Fld(8,0)//[7:0]
#define SPM_SEMA_M4 (SPM_BASE_ADDRESS + 0x6AC)
    #define SPM_SEMA_M4_SPM_SEMA_M4 Fld(8,0)//[7:0]
#define SPM_SEMA_M5 (SPM_BASE_ADDRESS + 0x6B0)
    #define SPM_SEMA_M5_SPM_SEMA_M5 Fld(8,0)//[7:0]
#define SPM_SEMA_M6 (SPM_BASE_ADDRESS + 0x6B4)
    #define SPM_SEMA_M6_SPM_SEMA_M6 Fld(8,0)//[7:0]
#define SPM_SEMA_M7 (SPM_BASE_ADDRESS + 0x6B8)
    #define SPM_SEMA_M7_SPM_SEMA_M7 Fld(8,0)//[7:0]
#define SPM2ADSP_MAILBOX (SPM_BASE_ADDRESS + 0x6BC)
    #define SPM2ADSP_MAILBOX_SPM2ADSP_MAILBOX Fld(32,0)//[31:0]
#define ADSP2SPM_MAILBOX (SPM_BASE_ADDRESS + 0x6C0)
    #define ADSP2SPM_MAILBOX_ADSP2SPM_MAILBOX Fld(32,0)//[31:0]
#define SPM_ADSP_IRQ (SPM_BASE_ADDRESS + 0x6C4)
    #define SPM_ADSP_IRQ_SC_SPM2ADSP_WAKEUP Fld(1,0)//[0:0]
    #define SPM_ADSP_IRQ_SC_ADSP2SPM_WAKEUP Fld(1,4)//[4:4]
#define SPM_MD32_IRQ (SPM_BASE_ADDRESS + 0x6C8)
    #define SPM_MD32_IRQ_SC_SPM2SSPM_WAKEUP Fld(4,0)//[3:0]
    #define SPM_MD32_IRQ_SC_SSPM2SPM_WAKEUP Fld(4,4)//[7:4]
#define SPM2PCU_MAILBOX_0 (SPM_BASE_ADDRESS + 0x6CC)
    #define SPM2PCU_MAILBOX_0_SPM2PCU_MAILBOX_0 Fld(32,0)//[31:0]
#define SPM2PCU_MAILBOX_1 (SPM_BASE_ADDRESS + 0x6D0)
    #define SPM2PCU_MAILBOX_1_SPM2PCU_MAILBOX_1 Fld(32,0)//[31:0]
#define SPM2PCU_MAILBOX_2 (SPM_BASE_ADDRESS + 0x6D4)
    #define SPM2PCU_MAILBOX_2_SPM2PCU_MAILBOX_2 Fld(32,0)//[31:0]
#define SPM2PCU_MAILBOX_3 (SPM_BASE_ADDRESS + 0x6D8)
    #define SPM2PCU_MAILBOX_3_SPM2PCU_MAILBOX_3 Fld(32,0)//[31:0]
#define PCU2SPM_MAILBOX_0 (SPM_BASE_ADDRESS + 0x6DC)
    #define PCU2SPM_MAILBOX_0_PCU2SPM_MAILBOX_0 Fld(32,0)//[31:0]
#define PCU2SPM_MAILBOX_1 (SPM_BASE_ADDRESS + 0x6E0)
    #define PCU2SPM_MAILBOX_1_PCU2SPM_MAILBOX_1 Fld(32,0)//[31:0]
#define PCU2SPM_MAILBOX_2 (SPM_BASE_ADDRESS + 0x6E4)
    #define PCU2SPM_MAILBOX_2_PCU2SPM_MAILBOX_2 Fld(32,0)//[31:0]
#define PCU2SPM_MAILBOX_3 (SPM_BASE_ADDRESS + 0x6E8)
    #define PCU2SPM_MAILBOX_3_PCU2SPM_MAILBOX_3 Fld(32,0)//[31:0]
#define UFS_PSRI_SW (SPM_BASE_ADDRESS + 0x6EC)
    #define UFS_PSRI_SW_UFS_PSRI_SW Fld(1,0)//[0:0]
#define UFS_PSRI_SW_SET (SPM_BASE_ADDRESS + 0x6F0)
    #define UFS_PSRI_SW_SET_UFS_PSRI_SW_SET Fld(1,0)//[0:0]
#define UFS_PSRI_SW_CLR (SPM_BASE_ADDRESS + 0x6F4)
    #define UFS_PSRI_SW_CLR_UFS_PSRI_SW_CLR Fld(1,0)//[0:0]
#define SPM_AP_SEMA (SPM_BASE_ADDRESS + 0x6F8)
    #define SPM_AP_SEMA_SPM_AP_SEMA Fld(1,0)//[0:0]
#define SPM_SPM_SEMA (SPM_BASE_ADDRESS + 0x6FC)
    #define SPM_SPM_SEMA_SPM_SPM_SEMA Fld(1,0)//[0:0]
#define PCM_WDT_LATCH_0 (SPM_BASE_ADDRESS + 0x800)
    #define PCM_WDT_LATCH_0_PCM_WDT_LATCH_0 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_1 (SPM_BASE_ADDRESS + 0x804)
    #define PCM_WDT_LATCH_1_PCM_WDT_LATCH_1 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_2 (SPM_BASE_ADDRESS + 0x808)
    #define PCM_WDT_LATCH_2_PCM_WDT_LATCH_2 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_3 (SPM_BASE_ADDRESS + 0x80C)
    #define PCM_WDT_LATCH_3_PCM_WDT_LATCH_3 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_4 (SPM_BASE_ADDRESS + 0x810)
    #define PCM_WDT_LATCH_4_PCM_WDT_LATCH_4 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_5 (SPM_BASE_ADDRESS + 0x814)
    #define PCM_WDT_LATCH_5_PCM_WDT_LATCH_5 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_6 (SPM_BASE_ADDRESS + 0x818)
    #define PCM_WDT_LATCH_6_PCM_WDT_LATCH_6 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_7 (SPM_BASE_ADDRESS + 0x81C)
    #define PCM_WDT_LATCH_7_PCM_WDT_LATCH_7 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_8 (SPM_BASE_ADDRESS + 0x820)
    #define PCM_WDT_LATCH_8_PCM_WDT_LATCH_8 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_9 (SPM_BASE_ADDRESS + 0x824)
    #define PCM_WDT_LATCH_9_PCM_WDT_LATCH_9 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_10 (SPM_BASE_ADDRESS + 0x828)
    #define PCM_WDT_LATCH_10_PCM_WDT_LATCH_10 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_11 (SPM_BASE_ADDRESS + 0x82C)
    #define PCM_WDT_LATCH_11_PCM_WDT_LATCH_11 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_12 (SPM_BASE_ADDRESS + 0x830)
    #define PCM_WDT_LATCH_12_PCM_WDT_LATCH_12 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_13 (SPM_BASE_ADDRESS + 0x834)
    #define PCM_WDT_LATCH_13_PCM_WDT_LATCH_13 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_14 (SPM_BASE_ADDRESS + 0x838)
    #define PCM_WDT_LATCH_14_PCM_WDT_LATCH_14 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_15 (SPM_BASE_ADDRESS + 0x83C)
    #define PCM_WDT_LATCH_15_PCM_WDT_LATCH_15 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_16 (SPM_BASE_ADDRESS + 0x840)
    #define PCM_WDT_LATCH_16_PCM_WDT_LATCH_16 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_17 (SPM_BASE_ADDRESS + 0x844)
    #define PCM_WDT_LATCH_17_PCM_WDT_LATCH_17 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_18 (SPM_BASE_ADDRESS + 0x848)
    #define PCM_WDT_LATCH_18_PCM_WDT_LATCH_18 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_SPARE_0 (SPM_BASE_ADDRESS + 0x84C)
    #define PCM_WDT_LATCH_SPARE_0_PCM_WDT_LATCH_SPARE_0 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_SPARE_1 (SPM_BASE_ADDRESS + 0x850)
    #define PCM_WDT_LATCH_SPARE_1_PCM_WDT_LATCH_SPARE_1 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_SPARE_2 (SPM_BASE_ADDRESS + 0x854)
    #define PCM_WDT_LATCH_SPARE_2_PCM_WDT_LATCH_SPARE_2 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_CONN_0 (SPM_BASE_ADDRESS + 0x870)
    #define PCM_WDT_LATCH_CONN_0_PCM_WDT_LATCH_CONN_0 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_CONN_1 (SPM_BASE_ADDRESS + 0x874)
    #define PCM_WDT_LATCH_CONN_1_PCM_WDT_LATCH_CONN_1 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_CONN_2 (SPM_BASE_ADDRESS + 0x878)
    #define PCM_WDT_LATCH_CONN_2_PCM_WDT_LATCH_CONN_2 Fld(32,0)//[31:0]
#define DRAMC_GATING_ERR_LATCH_CH0_0 (SPM_BASE_ADDRESS + 0x8A0)
    #define DRAMC_GATING_ERR_LATCH_CH0_0_DRAMC_GATING_ERR_LATCH_CH0_0 Fld(32,0)//[31:0]
#define DRAMC_GATING_ERR_LATCH_CH0_1 (SPM_BASE_ADDRESS + 0x8A4)
    #define DRAMC_GATING_ERR_LATCH_CH0_1_DRAMC_GATING_ERR_LATCH_CH0_1 Fld(32,0)//[31:0]
#define DRAMC_GATING_ERR_LATCH_CH0_2 (SPM_BASE_ADDRESS + 0x8A8)
    #define DRAMC_GATING_ERR_LATCH_CH0_2_DRAMC_GATING_ERR_LATCH_CH0_2 Fld(32,0)//[31:0]
#define DRAMC_GATING_ERR_LATCH_CH0_3 (SPM_BASE_ADDRESS + 0x8AC)
    #define DRAMC_GATING_ERR_LATCH_CH0_3_DRAMC_GATING_ERR_LATCH_CH0_3 Fld(32,0)//[31:0]
#define DRAMC_GATING_ERR_LATCH_CH0_4 (SPM_BASE_ADDRESS + 0x8B0)
    #define DRAMC_GATING_ERR_LATCH_CH0_4_DRAMC_GATING_ERR_LATCH_CH0_4 Fld(32,0)//[31:0]
#define DRAMC_GATING_ERR_LATCH_CH0_5 (SPM_BASE_ADDRESS + 0x8B4)
    #define DRAMC_GATING_ERR_LATCH_CH0_5_DRAMC_GATING_ERR_LATCH_CH0_5 Fld(32,0)//[31:0]
#define DRAMC_GATING_ERR_LATCH_CH0_6 (SPM_BASE_ADDRESS + 0x8B8)
    #define DRAMC_GATING_ERR_LATCH_CH0_6_DRAMC_GATING_ERR_LATCH_CH0_6 Fld(32,0)//[31:0]
#define DRAMC_GATING_ERR_LATCH_SPARE_0 (SPM_BASE_ADDRESS + 0x8F4)
    #define DRAMC_GATING_ERR_LATCH_SPARE_0_DRAMC_GATING_ERR_LATCH_SPARE_0 Fld(32,0)//[31:0]
#define SPM_ACK_CHK_CON_0 (SPM_BASE_ADDRESS + 0x900)
    #define SPM_ACK_CHK_CON_0_SPM_ACK_CHK_FAIL_0 Fld(1,15)//[15:15]
    #define SPM_ACK_CHK_CON_0_SPM_ACK_CHK_HW_MODE_0 Fld(3,9)//[11:9]
    #define SPM_ACK_CHK_CON_0_SPM_ACK_CHK_HW_EN_0 Fld(1,8)//[8:8]
    #define SPM_ACK_CHK_CON_0_SPM_ACK_CHK_LOCK_PC_TRACE_EN_0 Fld(1,7)//[7:7]
    #define SPM_ACK_CHK_CON_0_SPM_ACK_CHK_WDT_EN_0 Fld(1,6)//[6:6]
    #define SPM_ACK_CHK_CON_0_SPM_ACK_CHK_WAKEUP_EN_0 Fld(1,5)//[5:5]
    #define SPM_ACK_CHK_CON_0_SPM_ACK_CHK_STA_EN_0 Fld(1,4)//[4:4]
    #define SPM_ACK_CHK_CON_0_SPM_ACK_CHK_CLR_IRQ_0 Fld(1,3)//[3:3]
    #define SPM_ACK_CHK_CON_0_SPM_ACK_CHK_CLR_TIMER_0 Fld(1,2)//[2:2]
    #define SPM_ACK_CHK_CON_0_SPM_ACK_CHK_CLR_ALL_0 Fld(1,1)//[1:1]
    #define SPM_ACK_CHK_CON_0_SPM_ACK_CHK_SW_EN_0 Fld(1,0)//[0:0]
#define SPM_ACK_CHK_PC_0 (SPM_BASE_ADDRESS + 0x904)
    #define SPM_ACK_CHK_PC_0_SPM_ACK_CHK_HW_TARG_PC_VAL_0 Fld(16,16)//[31:16]
    #define SPM_ACK_CHK_PC_0_SPM_ACK_CHK_HW_TRIG_PC_VAL_0 Fld(16,0)//[15:0]

//Page SPM_7
#define SPM_ACK_CHK_SEL_0 (SPM_BASE_ADDRESS + 0x908)
    #define SPM_ACK_CHK_SEL_0_SPM_ACK_CHK_HW_TARG_GROUP_SEL_0 Fld(3,21)//[23:21]
    #define SPM_ACK_CHK_SEL_0_SPM_ACK_CHK_HW_TARG_SIGNAL_SEL_0 Fld(5,16)//[20:16]
    #define SPM_ACK_CHK_SEL_0_SPM_ACK_CHK_HW_TRIG_GROUP_SEL_0 Fld(3,5)//[7:5]
    #define SPM_ACK_CHK_SEL_0_SPM_ACK_CHK_HW_TRIG_SIGNAL_SEL_0 Fld(5,0)//[4:0]
#define SPM_ACK_CHK_TIMER_0 (SPM_BASE_ADDRESS + 0x90C)
    #define SPM_ACK_CHK_TIMER_0_SPM_ACK_CHK_TIMER_0 Fld(16,16)//[31:16]
    #define SPM_ACK_CHK_TIMER_0_SPM_ACK_CHK_TIMER_VAL_0 Fld(16,0)//[15:0]
#define SPM_ACK_CHK_STA_0 (SPM_BASE_ADDRESS + 0x910)
    #define SPM_ACK_CHK_STA_0_SPM_ACK_CHK_STA_0 Fld(32,0)//[31:0]
#define SPM_ACK_CHK_SWINT_0 (SPM_BASE_ADDRESS + 0x914)
    #define SPM_ACK_CHK_SWINT_0_SPM_ACK_CHK_SWINT_EN_0 Fld(32,0)//[31:0]
#define SPM_ACK_CHK_CON_1 (SPM_BASE_ADDRESS + 0x920)
    #define SPM_ACK_CHK_CON_1_SPM_ACK_CHK_FAIL_1 Fld(1,15)//[15:15]
    #define SPM_ACK_CHK_CON_1_SPM_ACK_CHK_HW_MODE_1 Fld(3,9)//[11:9]
    #define SPM_ACK_CHK_CON_1_SPM_ACK_CHK_HW_EN_1 Fld(1,8)//[8:8]
    #define SPM_ACK_CHK_CON_1_SPM_ACK_CHK_LOCK_PC_TRACE_EN_1 Fld(1,7)//[7:7]
    #define SPM_ACK_CHK_CON_1_SPM_ACK_CHK_WDT_EN_1 Fld(1,6)//[6:6]
    #define SPM_ACK_CHK_CON_1_SPM_ACK_CHK_WAKEUP_EN_1 Fld(1,5)//[5:5]
    #define SPM_ACK_CHK_CON_1_SPM_ACK_CHK_STA_EN_1 Fld(1,4)//[4:4]
    #define SPM_ACK_CHK_CON_1_SPM_ACK_CHK_CLR_IRQ_1 Fld(1,3)//[3:3]
    #define SPM_ACK_CHK_CON_1_SPM_ACK_CHK_CLR_TIMER_1 Fld(1,2)//[2:2]
    #define SPM_ACK_CHK_CON_1_SPM_ACK_CHK_CLR_ALL_1 Fld(1,1)//[1:1]
    #define SPM_ACK_CHK_CON_1_SPM_ACK_CHK_SW_EN_1 Fld(1,0)//[0:0]
#define SPM_ACK_CHK_PC_1 (SPM_BASE_ADDRESS + 0x924)
    #define SPM_ACK_CHK_PC_1_SPM_ACK_CHK_HW_TARG_PC_VAL_1 Fld(16,16)//[31:16]
    #define SPM_ACK_CHK_PC_1_SPM_ACK_CHK_HW_TRIG_PC_VAL_1 Fld(16,0)//[15:0]
#define SPM_ACK_CHK_SEL_1 (SPM_BASE_ADDRESS + 0x928)
    #define SPM_ACK_CHK_SEL_1_SPM_ACK_CHK_HW_TARG_GROUP_SEL_1 Fld(3,21)//[23:21]
    #define SPM_ACK_CHK_SEL_1_SPM_ACK_CHK_HW_TARG_SIGNAL_SEL_1 Fld(5,16)//[20:16]
    #define SPM_ACK_CHK_SEL_1_SPM_ACK_CHK_HW_TRIG_GROUP_SEL_1 Fld(3,5)//[7:5]
    #define SPM_ACK_CHK_SEL_1_SPM_ACK_CHK_HW_TRIG_SIGNAL_SEL_1 Fld(5,0)//[4:0]
#define SPM_ACK_CHK_TIMER_1 (SPM_BASE_ADDRESS + 0x92C)
    #define SPM_ACK_CHK_TIMER_1_SPM_ACK_CHK_TIMER_1 Fld(16,16)//[31:16]
    #define SPM_ACK_CHK_TIMER_1_SPM_ACK_CHK_TIMER_VAL_1 Fld(16,0)//[15:0]
#define SPM_ACK_CHK_STA_1 (SPM_BASE_ADDRESS + 0x930)
    #define SPM_ACK_CHK_STA_1_SPM_ACK_CHK_STA_1 Fld(32,0)//[31:0]
#define SPM_ACK_CHK_SWINT_1 (SPM_BASE_ADDRESS + 0x934)
    #define SPM_ACK_CHK_SWINT_1_SPM_ACK_CHK_SWINT_EN_1 Fld(32,0)//[31:0]
#define SPM_ACK_CHK_CON_2 (SPM_BASE_ADDRESS + 0x940)
    #define SPM_ACK_CHK_CON_2_SPM_ACK_CHK_FAIL_2 Fld(1,15)//[15:15]
    #define SPM_ACK_CHK_CON_2_SPM_ACK_CHK_HW_MODE_2 Fld(3,9)//[11:9]
    #define SPM_ACK_CHK_CON_2_SPM_ACK_CHK_HW_EN_2 Fld(1,8)//[8:8]
    #define SPM_ACK_CHK_CON_2_SPM_ACK_CHK_LOCK_PC_TRACE_EN_2 Fld(1,7)//[7:7]
    #define SPM_ACK_CHK_CON_2_SPM_ACK_CHK_WDT_EN_2 Fld(1,6)//[6:6]
    #define SPM_ACK_CHK_CON_2_SPM_ACK_CHK_WAKEUP_EN_2 Fld(1,5)//[5:5]
    #define SPM_ACK_CHK_CON_2_SPM_ACK_CHK_STA_EN_2 Fld(1,4)//[4:4]
    #define SPM_ACK_CHK_CON_2_SPM_ACK_CHK_CLR_IRQ_2 Fld(1,3)//[3:3]
    #define SPM_ACK_CHK_CON_2_SPM_ACK_CHK_CLR_TIMER_2 Fld(1,2)//[2:2]
    #define SPM_ACK_CHK_CON_2_SPM_ACK_CHK_CLR_ALL_2 Fld(1,1)//[1:1]
    #define SPM_ACK_CHK_CON_2_SPM_ACK_CHK_SW_EN_2 Fld(1,0)//[0:0]
#define SPM_ACK_CHK_PC_2 (SPM_BASE_ADDRESS + 0x944)
    #define SPM_ACK_CHK_PC_2_SPM_ACK_CHK_HW_TARG_PC_VAL_2 Fld(16,16)//[31:16]
    #define SPM_ACK_CHK_PC_2_SPM_ACK_CHK_HW_TRIG_PC_VAL_2 Fld(16,0)//[15:0]
#define SPM_ACK_CHK_SEL_2 (SPM_BASE_ADDRESS + 0x948)
    #define SPM_ACK_CHK_SEL_2_SPM_ACK_CHK_HW_TARG_GROUP_SEL_2 Fld(3,21)//[23:21]
    #define SPM_ACK_CHK_SEL_2_SPM_ACK_CHK_HW_TARG_SIGNAL_SEL_2 Fld(5,16)//[20:16]
    #define SPM_ACK_CHK_SEL_2_SPM_ACK_CHK_HW_TRIG_GROUP_SEL_2 Fld(3,5)//[7:5]
    #define SPM_ACK_CHK_SEL_2_SPM_ACK_CHK_HW_TRIG_SIGNAL_SEL_2 Fld(5,0)//[4:0]
#define SPM_ACK_CHK_TIMER_2 (SPM_BASE_ADDRESS + 0x94C)
    #define SPM_ACK_CHK_TIMER_2_SPM_ACK_CHK_TIMER_2 Fld(16,16)//[31:16]
    #define SPM_ACK_CHK_TIMER_2_SPM_ACK_CHK_TIMER_VAL_2 Fld(16,0)//[15:0]
#define SPM_ACK_CHK_STA_2 (SPM_BASE_ADDRESS + 0x950)
    #define SPM_ACK_CHK_STA_2_SPM_ACK_CHK_STA_2 Fld(32,0)//[31:0]
#define SPM_ACK_CHK_SWINT_2 (SPM_BASE_ADDRESS + 0x954)
    #define SPM_ACK_CHK_SWINT_2_SPM_ACK_CHK_SWINT_EN_2 Fld(32,0)//[31:0]
#define SPM_ACK_CHK_CON_3 (SPM_BASE_ADDRESS + 0x960)
    #define SPM_ACK_CHK_CON_3_SPM_ACK_CHK_FAIL_3 Fld(1,15)//[15:15]
    #define SPM_ACK_CHK_CON_3_SPM_ACK_CHK_HW_MODE_3 Fld(3,9)//[11:9]
    #define SPM_ACK_CHK_CON_3_SPM_ACK_CHK_HW_EN_3 Fld(1,8)//[8:8]
    #define SPM_ACK_CHK_CON_3_SPM_ACK_CHK_LOCK_PC_TRACE_EN_3 Fld(1,7)//[7:7]
    #define SPM_ACK_CHK_CON_3_SPM_ACK_CHK_WDT_EN_3 Fld(1,6)//[6:6]
    #define SPM_ACK_CHK_CON_3_SPM_ACK_CHK_WAKEUP_EN_3 Fld(1,5)//[5:5]
    #define SPM_ACK_CHK_CON_3_SPM_ACK_CHK_STA_EN_3 Fld(1,4)//[4:4]
    #define SPM_ACK_CHK_CON_3_SPM_ACK_CHK_CLR_IRQ_3 Fld(1,3)//[3:3]
    #define SPM_ACK_CHK_CON_3_SPM_ACK_CHK_CLR_TIMER_3 Fld(1,2)//[2:2]
    #define SPM_ACK_CHK_CON_3_SPM_ACK_CHK_CLR_ALL_3 Fld(1,1)//[1:1]
    #define SPM_ACK_CHK_CON_3_SPM_ACK_CHK_SW_EN_3 Fld(1,0)//[0:0]
#define SPM_ACK_CHK_PC_3 (SPM_BASE_ADDRESS + 0x964)
    #define SPM_ACK_CHK_PC_3_SPM_ACK_CHK_HW_TARG_PC_VAL_3 Fld(16,16)//[31:16]
    #define SPM_ACK_CHK_PC_3_SPM_ACK_CHK_HW_TRIG_PC_VAL_3 Fld(16,0)//[15:0]
#define SPM_ACK_CHK_SEL_3 (SPM_BASE_ADDRESS + 0x968)
    #define SPM_ACK_CHK_SEL_3_SPM_ACK_CHK_HW_TARG_GROUP_SEL_3 Fld(3,21)//[23:21]
    #define SPM_ACK_CHK_SEL_3_SPM_ACK_CHK_HW_TARG_SIGNAL_SEL_3 Fld(5,16)//[20:16]
    #define SPM_ACK_CHK_SEL_3_SPM_ACK_CHK_HW_TRIG_GROUP_SEL_3 Fld(3,5)//[7:5]
    #define SPM_ACK_CHK_SEL_3_SPM_ACK_CHK_HW_TRIG_SIGNAL_SEL_3 Fld(5,0)//[4:0]
#define SPM_ACK_CHK_TIMER_3 (SPM_BASE_ADDRESS + 0x96C)
    #define SPM_ACK_CHK_TIMER_3_SPM_ACK_CHK_TIMER_3 Fld(16,16)//[31:16]
    #define SPM_ACK_CHK_TIMER_3_SPM_ACK_CHK_TIMER_VAL_3 Fld(16,0)//[15:0]
#define SPM_ACK_CHK_STA_3 (SPM_BASE_ADDRESS + 0x970)
    #define SPM_ACK_CHK_STA_3_SPM_ACK_CHK_STA_3 Fld(32,0)//[31:0]
#define SPM_ACK_CHK_SWINT_3 (SPM_BASE_ADDRESS + 0x974)
    #define SPM_ACK_CHK_SWINT_3_SPM_ACK_CHK_SWINT_EN_3 Fld(32,0)//[31:0]
#define SPM_COUNTER_0 (SPM_BASE_ADDRESS + 0x978)
    #define SPM_COUNTER_0_SPM_COUNTER_VAL_0 Fld(14,0)//[13:0]
    #define SPM_COUNTER_0_SPM_COUNTER_OUT_0 Fld(14,14)//[27:14]
    #define SPM_COUNTER_0_SPM_COUNTER_EN_0 Fld(1,28)//[28:28]
    #define SPM_COUNTER_0_SPM_COUNTER_CLR_0 Fld(1,29)//[29:29]
    #define SPM_COUNTER_0_SPM_COUNTER_TIMEOUT_0 Fld(1,30)//[30:30]
    #define SPM_COUNTER_0_SPM_COUNTER_WAKEUP_EN_0 Fld(1,31)//[31:31]
#define SPM_COUNTER_1 (SPM_BASE_ADDRESS + 0x97C)
    #define SPM_COUNTER_1_SPM_COUNTER_VAL_1 Fld(14,0)//[13:0]
    #define SPM_COUNTER_1_SPM_COUNTER_OUT_1 Fld(14,14)//[27:14]
    #define SPM_COUNTER_1_SPM_COUNTER_EN_1 Fld(1,28)//[28:28]
    #define SPM_COUNTER_1_SPM_COUNTER_CLR_1 Fld(1,29)//[29:29]
    #define SPM_COUNTER_1_SPM_COUNTER_TIMEOUT_1 Fld(1,30)//[30:30]
    #define SPM_COUNTER_1_SPM_COUNTER_WAKEUP_EN_1 Fld(1,31)//[31:31]
#define SPM_COUNTER_2 (SPM_BASE_ADDRESS + 0x980)
    #define SPM_COUNTER_2_SPM_COUNTER_VAL_2 Fld(14,0)//[13:0]
    #define SPM_COUNTER_2_SPM_COUNTER_OUT_2 Fld(14,14)//[27:14]
    #define SPM_COUNTER_2_SPM_COUNTER_EN_2 Fld(1,28)//[28:28]
    #define SPM_COUNTER_2_SPM_COUNTER_CLR_2 Fld(1,29)//[29:29]
    #define SPM_COUNTER_2_SPM_COUNTER_TIMEOUT_2 Fld(1,30)//[30:30]
    #define SPM_COUNTER_2_SPM_COUNTER_WAKEUP_EN_2 Fld(1,31)//[31:31]
#define SYS_TIMER_CON (SPM_BASE_ADDRESS + 0x98C)
    #define SYS_TIMER_CON_SYS_TIMER_START_EN Fld(1,0)//[0:0]
    #define SYS_TIMER_CON_SYS_TIMER_LATCH_EN Fld(1,1)//[1:1]
    #define SYS_TIMER_CON_SYS_TIMER_ID Fld(8,8)//[15:8]
    #define SYS_TIMER_CON_SYS_TIMER_VALID Fld(1,31)//[31:31]
#define RC_FSM_STA_0 (SPM_BASE_ADDRESS + 0xE00)
    #define RC_FSM_STA_0_RC_FSM_STA_0 Fld(32,0)//[31:0]
#define RC_CMD_STA_0 (SPM_BASE_ADDRESS + 0xE04)
    #define RC_CMD_STA_0_RC_CMD_STA_0 Fld(32,0)//[31:0]
#define RC_CMD_STA_1 (SPM_BASE_ADDRESS + 0xE08)
    #define RC_CMD_STA_1_RC_CMD_STA_1 Fld(32,0)//[31:0]
#define RC_SPI_STA_0 (SPM_BASE_ADDRESS + 0xE0C)
    #define RC_SPI_STA_0_RC_SPI_STA_0 Fld(32,0)//[31:0]
#define RC_PI_PO_STA_0 (SPM_BASE_ADDRESS + 0xE10)
    #define RC_PI_PO_STA_0_RC_PI_PO_STA_0 Fld(32,0)//[31:0]
#define RC_M00_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE14)
    #define RC_M00_REQ_STA_0_RC_M00_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M01_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE1C)
    #define RC_M01_REQ_STA_0_RC_M01_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M02_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE20)
    #define RC_M02_REQ_STA_0_RC_M02_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M03_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE24)
    #define RC_M03_REQ_STA_0_RC_M03_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M04_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE28)
    #define RC_M04_REQ_STA_0_RC_M04_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M05_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE2C)
    #define RC_M05_REQ_STA_0_RC_M05_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M06_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE30)
    #define RC_M06_REQ_STA_0_RC_M06_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M07_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE34)
    #define RC_M07_REQ_STA_0_RC_M07_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M08_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE38)
    #define RC_M08_REQ_STA_0_RC_M08_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M09_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE3C)
    #define RC_M09_REQ_STA_0_RC_M09_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M10_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE40)
    #define RC_M10_REQ_STA_0_RC_M10_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M11_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE44)
    #define RC_M11_REQ_STA_0_RC_M11_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_M12_REQ_STA_0 (SPM_BASE_ADDRESS + 0xE48)
    #define RC_M12_REQ_STA_0_RC_M12_REQ_STA_0 Fld(32,0)//[31:0]
#define RC_DEBUG_STA_0 (SPM_BASE_ADDRESS + 0xE4C)
    #define RC_DEBUG_STA_0_RC_DEBUG_STA_0 Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_0_LSB (SPM_BASE_ADDRESS + 0xE50)
    #define RC_DEBUG_TRACE_0_LSB_RO_PMRC_TRACE_00_LSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_0_MSB (SPM_BASE_ADDRESS + 0xE54)
    #define RC_DEBUG_TRACE_0_MSB_RO_PMRC_TRACE_00_MSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_1_LSB (SPM_BASE_ADDRESS + 0xE5C)
    #define RC_DEBUG_TRACE_1_LSB_RO_PMRC_TRACE_01_LSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_1_MSB (SPM_BASE_ADDRESS + 0xE60)
    #define RC_DEBUG_TRACE_1_MSB_RO_PMRC_TRACE_01_MSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_2_LSB (SPM_BASE_ADDRESS + 0xE64)
    #define RC_DEBUG_TRACE_2_LSB_RO_PMRC_TRACE_02_LSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_2_MSB (SPM_BASE_ADDRESS + 0xE6C)
    #define RC_DEBUG_TRACE_2_MSB_RO_PMRC_TRACE_02_MSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_3_LSB (SPM_BASE_ADDRESS + 0xE70)
    #define RC_DEBUG_TRACE_3_LSB_RO_PMRC_TRACE_03_LSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_3_MSB (SPM_BASE_ADDRESS + 0xE74)
    #define RC_DEBUG_TRACE_3_MSB_RO_PMRC_TRACE_03_MSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_4_LSB (SPM_BASE_ADDRESS + 0xE78)
    #define RC_DEBUG_TRACE_4_LSB_RO_PMRC_TRACE_04_LSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_4_MSB (SPM_BASE_ADDRESS + 0xE7C)
    #define RC_DEBUG_TRACE_4_MSB_RO_PMRC_TRACE_04_MSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_5_LSB (SPM_BASE_ADDRESS + 0xE80)
    #define RC_DEBUG_TRACE_5_LSB_RO_PMRC_TRACE_05_LSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_5_MSB (SPM_BASE_ADDRESS + 0xE84)
    #define RC_DEBUG_TRACE_5_MSB_RO_PMRC_TRACE_05_MSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_6_LSB (SPM_BASE_ADDRESS + 0xE88)
    #define RC_DEBUG_TRACE_6_LSB_RO_PMRC_TRACE_06_LSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_6_MSB (SPM_BASE_ADDRESS + 0xE8C)
    #define RC_DEBUG_TRACE_6_MSB_RO_PMRC_TRACE_06_MSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_7_LSB (SPM_BASE_ADDRESS + 0xE90)
    #define RC_DEBUG_TRACE_7_LSB_RO_PMRC_TRACE_07_LSB Fld(32,0)//[31:0]
#define RC_DEBUG_TRACE_7_MSB (SPM_BASE_ADDRESS + 0xE94)
    #define RC_DEBUG_TRACE_7_MSB_RO_PMRC_TRACE_07_MSB Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_0_LSB (SPM_BASE_ADDRESS + 0xE98)
    #define RC_SYS_TIMER_LATCH_0_LSB_RC_SYS_TIMER_LATCH_L_00 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_0_MSB (SPM_BASE_ADDRESS + 0xE9C)
    #define RC_SYS_TIMER_LATCH_0_MSB_RC_SYS_TIMER_LATCH_H_00 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_1_LSB (SPM_BASE_ADDRESS + 0xEA0)
    #define RC_SYS_TIMER_LATCH_1_LSB_RC_SYS_TIMER_LATCH_L_01 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_1_MSB (SPM_BASE_ADDRESS + 0xEA4)
    #define RC_SYS_TIMER_LATCH_1_MSB_RC_SYS_TIMER_LATCH_H_01 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_2_LSB (SPM_BASE_ADDRESS + 0xEA8)
    #define RC_SYS_TIMER_LATCH_2_LSB_RC_SYS_TIMER_LATCH_L_02 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_2_MSB (SPM_BASE_ADDRESS + 0xEAC)
    #define RC_SYS_TIMER_LATCH_2_MSB_RC_SYS_TIMER_LATCH_H_02 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_3_LSB (SPM_BASE_ADDRESS + 0xEB0)
    #define RC_SYS_TIMER_LATCH_3_LSB_RC_SYS_TIMER_LATCH_L_03 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_3_MSB (SPM_BASE_ADDRESS + 0xEB4)
    #define RC_SYS_TIMER_LATCH_3_MSB_RC_SYS_TIMER_LATCH_H_03 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_4_LSB (SPM_BASE_ADDRESS + 0xEB8)
    #define RC_SYS_TIMER_LATCH_4_LSB_RC_SYS_TIMER_LATCH_L_04 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_4_MSB (SPM_BASE_ADDRESS + 0xEBC)
    #define RC_SYS_TIMER_LATCH_4_MSB_RC_SYS_TIMER_LATCH_H_04 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_5_LSB (SPM_BASE_ADDRESS + 0xEC0)
    #define RC_SYS_TIMER_LATCH_5_LSB_RC_SYS_TIMER_LATCH_L_05 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_5_MSB (SPM_BASE_ADDRESS + 0xEC4)
    #define RC_SYS_TIMER_LATCH_5_MSB_RC_SYS_TIMER_LATCH_H_05 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_6_LSB (SPM_BASE_ADDRESS + 0xEC8)
    #define RC_SYS_TIMER_LATCH_6_LSB_RC_SYS_TIMER_LATCH_L_06 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_6_MSB (SPM_BASE_ADDRESS + 0xECC)
    #define RC_SYS_TIMER_LATCH_6_MSB_RC_SYS_TIMER_LATCH_H_06 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_7_LSB (SPM_BASE_ADDRESS + 0xED0)
    #define RC_SYS_TIMER_LATCH_7_LSB_RC_SYS_TIMER_LATCH_L_07 Fld(32,0)//[31:0]
#define RC_SYS_TIMER_LATCH_7_MSB (SPM_BASE_ADDRESS + 0xED4)
    #define RC_SYS_TIMER_LATCH_7_MSB_RC_SYS_TIMER_LATCH_H_07 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_19 (SPM_BASE_ADDRESS + 0xED8)
    #define PCM_WDT_LATCH_19_PCM_WDT_LATCH_19 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_20 (SPM_BASE_ADDRESS + 0xEDC)
    #define PCM_WDT_LATCH_20_PCM_WDT_LATCH_20 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_21 (SPM_BASE_ADDRESS + 0xEE0)
    #define PCM_WDT_LATCH_21_PCM_WDT_LATCH_21 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_22 (SPM_BASE_ADDRESS + 0xEE4)
    #define PCM_WDT_LATCH_22_PCM_WDT_LATCH_22 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_23 (SPM_BASE_ADDRESS + 0xEE8)
    #define PCM_WDT_LATCH_23_PCM_WDT_LATCH_23 Fld(32,0)//[31:0]
#define PCM_WDT_LATCH_24 (SPM_BASE_ADDRESS + 0xEEC)
    #define PCM_WDT_LATCH_24_PCM_WDT_LATCH_24 Fld(32,0)//[31:0]
#define PMSR_LAST_DAT (SPM_BASE_ADDRESS + 0xF00)
    #define PMSR_LAST_DAT_PMSR_LAST_DAT Fld(32,0)//[31:0]
#define PMSR_LAST_CNT (SPM_BASE_ADDRESS + 0xF04)
    #define PMSR_LAST_CNT_PMSR_LAST_CMD Fld(30,0)//[29:0]
    #define PMSR_LAST_CNT_PMSR_LAST_REQ Fld(1,30)//[30:30]
#define PMSR_LAST_ACK (SPM_BASE_ADDRESS + 0xF08)
    #define PMSR_LAST_ACK_PMSR_LAST_ACK Fld(1,0)//[0:0]
#define SPM_PMSR_SEL_CON0 (SPM_BASE_ADDRESS + 0xF10)
    #define SPM_PMSR_SEL_CON0_REG_PMSR_SIG_SEL_0 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON0_REG_PMSR_SIG_SEL_1 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON0_REG_PMSR_SIG_SEL_2 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON0_REG_PMSR_SIG_SEL_3 Fld(8,24)//[31:24]
#define SPM_PMSR_SEL_CON1 (SPM_BASE_ADDRESS + 0xF14)
    #define SPM_PMSR_SEL_CON1_REG_PMSR_SIG_SEL_4 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON1_REG_PMSR_SIG_SEL_5 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON1_REG_PMSR_SIG_SEL_6 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON1_REG_PMSR_SIG_SEL_7 Fld(8,24)//[31:24]
#define SPM_PMSR_SEL_CON2 (SPM_BASE_ADDRESS + 0xF18)
    #define SPM_PMSR_SEL_CON2_REG_PMSR_SIG_SEL_8 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON2_REG_PMSR_SIG_SEL_9 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON2_REG_PMSR_SIG_SEL_10 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON2_REG_PMSR_SIG_SEL_11 Fld(8,24)//[31:24]
#define SPM_PMSR_SEL_CON3 (SPM_BASE_ADDRESS + 0xF1C)
    #define SPM_PMSR_SEL_CON3_REG_PMSR_SIG_SEL_12 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON3_REG_PMSR_SIG_SEL_13 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON3_REG_PMSR_SIG_SEL_14 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON3_REG_PMSR_SIG_SEL_15 Fld(8,24)//[31:24]
#define SPM_PMSR_SEL_CON4 (SPM_BASE_ADDRESS + 0xF20)
    #define SPM_PMSR_SEL_CON4_REG_PMSR_SIG_SEL_16 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON4_REG_PMSR_SIG_SEL_17 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON4_REG_PMSR_SIG_SEL_18 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON4_REG_PMSR_SIG_SEL_19 Fld(8,24)//[31:24]
#define SPM_PMSR_SEL_CON5 (SPM_BASE_ADDRESS + 0xF24)
    #define SPM_PMSR_SEL_CON5_REG_PMSR_SIG_SEL_20 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON5_REG_PMSR_SIG_SEL_21 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON5_REG_PMSR_SIG_SEL_22 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON5_REG_PMSR_SIG_SEL_23 Fld(8,24)//[31:24]
#define SPM_PMSR_SEL_CON6 (SPM_BASE_ADDRESS + 0xF28)
    #define SPM_PMSR_SEL_CON6_REG_PMSR_SIG_SEL_24 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON6_REG_PMSR_SIG_SEL_25 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON6_REG_PMSR_SIG_SEL_26 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON6_REG_PMSR_SIG_SEL_27 Fld(8,24)//[31:24]
#define SPM_PMSR_SEL_CON7 (SPM_BASE_ADDRESS + 0xF2C)
    #define SPM_PMSR_SEL_CON7_REG_PMSR_SIG_SEL_28 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON7_REG_PMSR_SIG_SEL_29 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON7_REG_PMSR_SIG_SEL_30 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON7_REG_PMSR_SIG_SEL_31 Fld(8,24)//[31:24]
#define SPM_PMSR_SEL_CON8 (SPM_BASE_ADDRESS + 0xF30)
    #define SPM_PMSR_SEL_CON8_REG_PMSR_SIG_SEL_32 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON8_REG_PMSR_SIG_SEL_33 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON8_REG_PMSR_SIG_SEL_34 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON8_REG_PMSR_SIG_SEL_35 Fld(8,24)//[31:24]
#define SPM_PMSR_SEL_CON9 (SPM_BASE_ADDRESS + 0xF34)
    #define SPM_PMSR_SEL_CON9_REG_PMSR_SIG_SEL_36 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON9_REG_PMSR_SIG_SEL_37 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON9_REG_PMSR_SIG_SEL_38 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON9_REG_PMSR_SIG_SEL_39 Fld(8,24)//[31:24]
#define SPM_PMSR_SEL_CON10 (SPM_BASE_ADDRESS + 0xF3C)
    #define SPM_PMSR_SEL_CON10_REG_PMSR_SIG_SEL_40 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON10_REG_PMSR_SIG_SEL_41 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON10_REG_PMSR_SIG_SEL_42 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON10_REG_PMSR_SIG_SEL_43 Fld(8,24)//[31:24]
#define SPM_PMSR_SEL_CON11 (SPM_BASE_ADDRESS + 0xF40)
    #define SPM_PMSR_SEL_CON11_REG_PMSR_SIG_SEL_44 Fld(8,0)//[7:0]
    #define SPM_PMSR_SEL_CON11_REG_PMSR_SIG_SEL_45 Fld(8,8)//[15:8]
    #define SPM_PMSR_SEL_CON11_REG_PMSR_SIG_SEL_46 Fld(8,16)//[23:16]
    #define SPM_PMSR_SEL_CON11_REG_PMSR_SIG_SEL_47 Fld(8,24)//[31:24]
#define SPM_PMSR_TIEMR_STA0 (SPM_BASE_ADDRESS + 0xFB8)
    #define SPM_PMSR_TIEMR_STA0_PMSR_TIMER_SET0 Fld(32,0)//[31:0]
#define SPM_PMSR_TIEMR_STA1 (SPM_BASE_ADDRESS + 0xFBC)
    #define SPM_PMSR_TIEMR_STA1_PMSR_TIMER_SET1 Fld(32,0)//[31:0]
#define SPM_PMSR_TIEMR_STA2 (SPM_BASE_ADDRESS + 0xFC0)
    #define SPM_PMSR_TIEMR_STA2_PMSR_TIMER_SET2 Fld(32,0)//[31:0]
#define SPM_PMSR_GENERAL_CON0 (SPM_BASE_ADDRESS + 0xFC4)
    #define SPM_PMSR_GENERAL_CON0_PMSR_ENABLE_SET0 Fld(1,0)//[0:0]
    #define SPM_PMSR_GENERAL_CON0_PMSR_ENABLE_SET1 Fld(1,1)//[1:1]
    #define SPM_PMSR_GENERAL_CON0_PMSR_ENABLE_SET2 Fld(1,2)//[2:2]
    #define SPM_PMSR_GENERAL_CON0_PMSR_IRQ_CLR_SET0 Fld(1,3)//[3:3]
    #define SPM_PMSR_GENERAL_CON0_PMSR_IRQ_CLR_SET1 Fld(1,4)//[4:4]
    #define SPM_PMSR_GENERAL_CON0_PMSR_IRQ_CLR_SET2 Fld(1,5)//[5:5]
    #define SPM_PMSR_GENERAL_CON0_PMSR_SPEED_MODE_EN_SET0 Fld(1,6)//[6:6]
    #define SPM_PMSR_GENERAL_CON0_PMSR_SPEED_MODE_EN_SET1 Fld(1,7)//[7:7]
    #define SPM_PMSR_GENERAL_CON0_PMSR_SPEED_MODE_EN_SET2 Fld(1,8)//[8:8]
    #define SPM_PMSR_GENERAL_CON0_PMSR_EVENT_CLR_SET0 Fld(1,9)//[9:9]
    #define SPM_PMSR_GENERAL_CON0_PMSR_EVENT_CLR_SET1 Fld(1,10)//[10:10]
    #define SPM_PMSR_GENERAL_CON0_PMSR_EVENT_CLR_SET2 Fld(1,11)//[11:11]
    #define SPM_PMSR_GENERAL_CON0_REG_PMSR_IRQ_MASK_SET0 Fld(1,12)//[12:12]
    #define SPM_PMSR_GENERAL_CON0_REG_PMSR_IRQ_MASK_SET1 Fld(1,13)//[13:13]
    #define SPM_PMSR_GENERAL_CON0_REG_PMSR_IRQ_MASK_SET2 Fld(1,14)//[14:14]
    #define SPM_PMSR_GENERAL_CON0_REG_PMSR_IRQ_WAKEUP_EVENT_MASK_SET0 Fld(1,15)//[15:15]
    #define SPM_PMSR_GENERAL_CON0_REG_PMSR_IRQ_WAKEUP_EVENT_MASK_SET1 Fld(1,16)//[16:16]
    #define SPM_PMSR_GENERAL_CON0_REG_PMSR_IRQ_WAKEUP_EVENT_MASK_SET2 Fld(1,17)//[17:17]
    #define SPM_PMSR_GENERAL_CON0_PMSR_GEN_SW_RST_EN Fld(1,18)//[18:18]
    #define SPM_PMSR_GENERAL_CON0_PMSR_MODULE_ENABLE Fld(1,19)//[19:19]
    #define SPM_PMSR_GENERAL_CON0_PMSR_MODE Fld(2,20)//[21:20]
    #define SPM_PMSR_GENERAL_CON0_PMSR_IRQ_B_SET0 Fld(1,29)//[29:29]
    #define SPM_PMSR_GENERAL_CON0_PMSR_IRQ_B_SET1 Fld(1,30)//[30:30]
    #define SPM_PMSR_GENERAL_CON0_PMSR_IRQ_B_SET2 Fld(1,31)//[31:31]

//Page SPM_8
#define SPM_PMSR_GENERAL_CON1 (SPM_BASE_ADDRESS + 0xFC8)
    #define SPM_PMSR_GENERAL_CON1_PMSR_COUNTER_THRES Fld(32,0)//[31:0]
#define SPM_PMSR_GENERAL_CON2 (SPM_BASE_ADDRESS + 0xFCC)
    #define SPM_PMSR_GENERAL_CON2_PMSR_DEBUG_IN_0_MASK_B Fld(32,0)//[31:0]
#define SPM_PMSR_GENERAL_CON3 (SPM_BASE_ADDRESS + 0xFD0)
    #define SPM_PMSR_GENERAL_CON3_PMSR_DEBUG_IN_1_MASK_B Fld(32,0)//[31:0]
#define SPM_PMSR_GENERAL_CON4 (SPM_BASE_ADDRESS + 0xFD4)
    #define SPM_PMSR_GENERAL_CON4_PMSR_DEBUG_IN_2_MASK_B Fld(32,0)//[31:0]
#define SPM_PMSR_GENERAL_CON5 (SPM_BASE_ADDRESS + 0xFD8)
    #define SPM_PMSR_GENERAL_CON5_PMSR_DEBUG_IN_3_MASK_B Fld(32,0)//[31:0]
#define SPM_PMSR_SW_RESET (SPM_BASE_ADDRESS + 0xFDC)
    #define SPM_PMSR_SW_RESET_PMSR_SW_RST_EN_SET0 Fld(1,0)//[0:0]
    #define SPM_PMSR_SW_RESET_PMSR_SW_RST_EN_SET1 Fld(1,1)//[1:1]
    #define SPM_PMSR_SW_RESET_PMSR_SW_RST_EN_SET2 Fld(1,2)//[2:2]
#define SPM_PMSR_MON_CON0 (SPM_BASE_ADDRESS + 0xFE0)
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_0 Fld(2,0)//[1:0]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_1 Fld(2,2)//[3:2]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_2 Fld(2,4)//[5:4]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_3 Fld(2,6)//[7:6]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_4 Fld(2,8)//[9:8]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_5 Fld(2,10)//[11:10]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_6 Fld(2,12)//[13:12]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_7 Fld(2,14)//[15:14]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_8 Fld(2,16)//[17:16]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_9 Fld(2,18)//[19:18]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_10 Fld(2,20)//[21:20]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_11 Fld(2,22)//[23:22]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_12 Fld(2,24)//[25:24]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_13 Fld(2,26)//[27:26]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_14 Fld(2,28)//[29:28]
    #define SPM_PMSR_MON_CON0_REG_PMSR_MON_TYPE_15 Fld(2,30)//[31:30]
#define SPM_PMSR_MON_CON1 (SPM_BASE_ADDRESS + 0xFE4)
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_16 Fld(2,0)//[1:0]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_17 Fld(2,2)//[3:2]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_18 Fld(2,4)//[5:4]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_19 Fld(2,6)//[7:6]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_20 Fld(2,8)//[9:8]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_21 Fld(2,10)//[11:10]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_22 Fld(2,12)//[13:12]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_23 Fld(2,14)//[15:14]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_24 Fld(2,16)//[17:16]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_25 Fld(2,18)//[19:18]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_26 Fld(2,20)//[21:20]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_27 Fld(2,22)//[23:22]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_28 Fld(2,24)//[25:24]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_29 Fld(2,26)//[27:26]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_30 Fld(2,28)//[29:28]
    #define SPM_PMSR_MON_CON1_REG_PMSR_MON_TYPE_31 Fld(2,30)//[31:30]
#define SPM_PMSR_MON_CON2 (SPM_BASE_ADDRESS + 0xFE8)
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_32 Fld(2,0)//[1:0]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_33 Fld(2,2)//[3:2]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_34 Fld(2,4)//[5:4]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_35 Fld(2,6)//[7:6]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_36 Fld(2,8)//[9:8]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_37 Fld(2,10)//[11:10]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_38 Fld(2,12)//[13:12]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_39 Fld(2,14)//[15:14]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_40 Fld(2,16)//[17:16]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_41 Fld(2,18)//[19:18]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_42 Fld(2,20)//[21:20]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_43 Fld(2,22)//[23:22]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_44 Fld(2,24)//[25:24]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_45 Fld(2,26)//[27:26]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_46 Fld(2,28)//[29:28]
    #define SPM_PMSR_MON_CON2_REG_PMSR_MON_TYPE_47 Fld(2,30)//[31:30]
#define SPM_PMSR_LEN_CON0 (SPM_BASE_ADDRESS + 0xFEC)
    #define SPM_PMSR_LEN_CON0_REG_PMSR_WINDOW_LEN_SET0 Fld(32,0)//[31:0]
#define SPM_PMSR_LEN_CON1 (SPM_BASE_ADDRESS + 0xFF0)
    #define SPM_PMSR_LEN_CON1_REG_PMSR_WINDOW_LEN_SET1 Fld(32,0)//[31:0]
#define SPM_PMSR_LEN_CON2 (SPM_BASE_ADDRESS + 0xFF4)
    #define SPM_PMSR_LEN_CON2_REG_PMSR_WINDOW_LEN_SET2 Fld(32,0)//[31:0]





#endif //SPM_REGISTER_H

