
#ifndef _MT_SSUSB_SIFSLV_IPPC_H_
#define _MT_SSUSB_SIFSLV_IPPC_H_

/* SSUSB_SIFSLV_IPPC REGISTER DEFINITION */

/* referenecd from ssusb_USB20_PHY_regmap_com_T28.xls */
#define U3D_USBPHYACR0				(SSUSB_SIFSLV_U2PHY_COM_SIV_B_BASE+0x0000) /* bit 2~bit 30 */
#define U3D_USBPHYACR1				(SSUSB_SIFSLV_U2PHY_COM_SIV_B_BASE+0x0004)
#define U3D_USBPHYACR2				(SSUSB_SIFSLV_U2PHY_COM_SIV_B_BASE+0x0008) /* bit 0~ bit15 */
#define U3D_USBPHYACR4				(SSUSB_SIFSLV_U2PHY_COM_SIV_B_BASE+0x0010)
#define U3D_USBPHYACR5				(SSUSB_SIFSLV_U2PHY_COM_SIV_B_BASE+0x0014)
#define U3D_USBPHYACR6				(SSUSB_SIFSLV_U2PHY_COM_SIV_B_BASE+0x0018)
#define U3D_U2PHYACR3				(SSUSB_SIFSLV_U2PHY_COM_SIV_B_BASE+0x001c)
#define U3D_U2PHYACR4_0				(SSUSB_SIFSLV_U2PHY_COM_SIV_B_BASE+0x0020) /* bit0~ bit5 */

#define U3D_U2PHYACR4				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x0020) /* bit8~ bit18 */
#define U3D_U2PHYAMON0				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x0024)
#define U3D_U2PHYDCR0				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x0060)
#define U3D_U2PHYDCR1				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x0064)
#define U3D_U2PHYDTM0				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x0068)
#define U3D_U2PHYDTM1				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x006C)
#define U3D_U2PHYDMON0				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x0070)
#define U3D_U2PHYDMON1				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x0074)
#define U3D_U2PHYDMON2				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x0078)
#define U3D_U2PHYDMON3				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x007C)
#define U3D_U2PHYBC12C				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x0080)
#define U3D_U2PHYBC12C1				(SSUSB_SIFSLV_U2PHY_COM_BASE+0x0084)
#define U3D_U2PHYREGFPPC			(SSUSB_SIFSLV_U2PHY_COM_BASE+0x00e0)
#define U3D_U2PHYVERSIONC			(SSUSB_SIFSLV_U2PHY_COM_BASE+0x00f0)
#define U3D_U2PHYREGFCOM			(SSUSB_SIFSLV_U2PHY_COM_BASE+0x00fc)

#define U3D_USB30_PHYA_REG0         (SSUSB_USB30_PHYA_SIV_B_BASE+0x0000)
#define U3D_USB30_PHYA_REG6         (SSUSB_USB30_PHYA_SIV_B_BASE+0x0018)
#define U3D_PHYD_CDR1               (SSUSB_SIFSLV_U3PHYD_BASE+0x5c)

#define U3D_U3PHYA_DA_REG0          (SSUSB_SIFSLV_U3PHYA_DA_BASE+0x0000)
#define U3D_U3PHYA_DA_REG36         (SSUSB_SIFSLV_U3PHYA_DA_BASE+0x0070)
#define U3D_PHYD_RXDET2             (SSUSB_USB30_PHYA_SIV_B2_BASE+0x2c)

#define U3D_SPLLC_XTALCTL3          (SSUSB_SIFSLV_SPLLC_BASE+0x0018)

#define U3D_SSUSB_IP_PW_CTRL0			(SSUSB_SIFSLV_IPPC_BASE+0x0000)
#define U3D_SSUSB_IP_PW_CTRL1			(SSUSB_SIFSLV_IPPC_BASE+0x0004)
#define U3D_SSUSB_IP_PW_CTRL2			(SSUSB_SIFSLV_IPPC_BASE+0x0008)
#define U3D_SSUSB_IP_PW_CTRL3			(SSUSB_SIFSLV_IPPC_BASE+0x000C)
#define U3D_SSUSB_IP_PW_STS1			(SSUSB_SIFSLV_IPPC_BASE+0x0010)
#define U3D_SSUSB_IP_PW_STS2			(SSUSB_SIFSLV_IPPC_BASE+0x0014)
#define U3D_SSUSB_IP_MAC_CAP			(SSUSB_SIFSLV_IPPC_BASE+0x0020)
#define U3D_SSUSB_IP_XHCI_CAP			(SSUSB_SIFSLV_IPPC_BASE+0x0024)
#define U3D_SSUSB_IP_DEV_CAP			(SSUSB_SIFSLV_IPPC_BASE+0x0028)
#define U3D_SSUSB_U3_CTRL_0P			(SSUSB_SIFSLV_IPPC_BASE+0x0030)
#define U3D_SSUSB_U3_CTRL_1P			(SSUSB_SIFSLV_IPPC_BASE+0x0038)
#define U3D_SSUSB_U3_CTRL_2P			(SSUSB_SIFSLV_IPPC_BASE+0x0040)
#define U3D_SSUSB_U3_CTRL_3P			(SSUSB_SIFSLV_IPPC_BASE+0x0048)
#define U3D_SSUSB_U2_CTRL_0P			(SSUSB_SIFSLV_IPPC_BASE+0x0050)
#define U3D_SSUSB_U2_CTRL_1P			(SSUSB_SIFSLV_IPPC_BASE+0x0058)
#define U3D_SSUSB_U2_CTRL_2P			(SSUSB_SIFSLV_IPPC_BASE+0x0060)
#define U3D_SSUSB_U2_CTRL_3P			(SSUSB_SIFSLV_IPPC_BASE+0x0068)
#define U3D_SSUSB_U2_CTRL_4P			(SSUSB_SIFSLV_IPPC_BASE+0x0070)
#define U3D_SSUSB_U2_CTRL_5P			(SSUSB_SIFSLV_IPPC_BASE+0x0078)
#define U3D_SSUSB_U2_PHY_PLL			(SSUSB_SIFSLV_IPPC_BASE+0x007C)
#define U3D_SSUSB_DMA_CTRL			    (SSUSB_SIFSLV_IPPC_BASE+0x0080)
#define U3D_SSUSB_MAC_CK_CTRL			(SSUSB_SIFSLV_IPPC_BASE+0x0084)
#define U3D_SSUSB_CSR_CK_CTRL			(SSUSB_SIFSLV_IPPC_BASE+0x0088)
#define U3D_SSUSB_REF_CK_CTRL			(SSUSB_SIFSLV_IPPC_BASE+0x008C)
#define U3D_SSUSB_XHCI_CK_CTRL			(SSUSB_SIFSLV_IPPC_BASE+0x0090)
#define U3D_SSUSB_XHCI_RST_CTRL			(SSUSB_SIFSLV_IPPC_BASE+0x0094)
#define U3D_SSUSB_DEV_RST_CTRL			(SSUSB_SIFSLV_IPPC_BASE+0x0098)
#define U3D_SSUSB_SYS_CK_CTRL			(SSUSB_SIFSLV_IPPC_BASE+0x009C)
#define U3D_SSUSB_HW_ID			    	(SSUSB_SIFSLV_IPPC_BASE+0x00A0)
#define U3D_SSUSB_HW_SUB_ID			    (SSUSB_SIFSLV_IPPC_BASE+0x00A4)
#define U3D_SSUSB_PRB_CTRL0			    (SSUSB_SIFSLV_IPPC_BASE+0x00B0)
#define U3D_SSUSB_PRB_CTRL1			    (SSUSB_SIFSLV_IPPC_BASE+0x00B4)
#define U3D_SSUSB_PRB_CTRL2			    (SSUSB_SIFSLV_IPPC_BASE+0x00B8)
#define U3D_SSUSB_PRB_CTRL3			    (SSUSB_SIFSLV_IPPC_BASE+0x00BC)
#define U3D_SSUSB_PRB_CTRL4			    (SSUSB_SIFSLV_IPPC_BASE+0x00C0)
#define U3D_SSUSB_PRB_CTRL5			    (SSUSB_SIFSLV_IPPC_BASE+0x00C4)
#define U3D_SSUSB_IP_SPARE0			    (SSUSB_SIFSLV_IPPC_BASE+0x00C8)
#define U3D_SSUSB_IP_SPARE1			    (SSUSB_SIFSLV_IPPC_BASE+0x00CC)
#define U3D_SSUSB_FPGA_I2C_OUT_0P		(SSUSB_SIFSLV_IPPC_BASE+0x00D0)
#define U3D_SSUSB_FPGA_I2C_IN_0P		(SSUSB_SIFSLV_IPPC_BASE+0x00D4)
#define U3D_SSUSB_FPGA_I2C_OUT_1P		(SSUSB_SIFSLV_IPPC_BASE+0x00D8)
#define U3D_SSUSB_FPGA_I2C_IN_1P		(SSUSB_SIFSLV_IPPC_BASE+0x00DC)
#define U3D_SSUSB_FPGA_I2C_OUT_2P		(SSUSB_SIFSLV_IPPC_BASE+0x00E0)
#define U3D_SSUSB_FPGA_I2C_IN_2P		(SSUSB_SIFSLV_IPPC_BASE+0x00E4)
#define U3D_SSUSB_FPGA_I2C_OUT_3P		(SSUSB_SIFSLV_IPPC_BASE+0x00E8)
#define U3D_SSUSB_FPGA_I2C_IN_3P		(SSUSB_SIFSLV_IPPC_BASE+0x00EC)
#define U3D_SSUSB_FPGA_I2C_OUT_4P		(SSUSB_SIFSLV_IPPC_BASE+0x00F0)
#define U3D_SSUSB_FPGA_I2C_IN_4P		(SSUSB_SIFSLV_IPPC_BASE+0x00F4)
#define U3D_SSUSB_IP_SLV_TMOUT			(SSUSB_SIFSLV_IPPC_BASE+0x00F8)

//U3D_reg0
#define E60802_RG_PCIE_SPEED_PE2D                 (0x1<<24) //24:24
#define E60802_RG_PCIE_SPEED_PE2H                 (0x1<<23) //23:23
#define E60802_RG_PCIE_SPEED_PE1D                 (0x1<<22) //22:22
#define E60802_RG_PCIE_SPEED_PE1H                 (0x1<<21) //21:21
#define E60802_RG_PCIE_SPEED_U3                   (0x1<<20) //20:20
#define E60802_RG_SSUSB_XTAL_EXT_EN_PE2D          (0x3<<18) //19:18
#define E60802_RG_SSUSB_XTAL_EXT_EN_PE2H          (0x3<<16) //17:16
#define E60802_RG_SSUSB_XTAL_EXT_EN_PE1D          (0x3<<14) //15:14
#define E60802_RG_SSUSB_XTAL_EXT_EN_PE1H          (0x3<<12) //13:12
#define E60802_RG_SSUSB_XTAL_EXT_EN_U3            (0x3<<10) //11:10
#define E60802_RG_SSUSB_CDR_REFCK_SEL_PE2D        (0x3<<8) //9:8
#define E60802_RG_SSUSB_CDR_REFCK_SEL_PE2H        (0x3<<6) //7:6
#define E60802_RG_SSUSB_CDR_REFCK_SEL_PE1D        (0x3<<4) //5:4
#define E60802_RG_SSUSB_CDR_REFCK_SEL_PE1H        (0x3<<2) //3:2
#define E60802_RG_SSUSB_CDR_REFCK_SEL_U3          (0x3<<0) //1:0
#define E60802_RG_PCIE_SPEED_PE2D_OFST            (24)
#define E60802_RG_PCIE_SPEED_PE2H_OFST            (23)
#define E60802_RG_PCIE_SPEED_PE1D_OFST            (22)
#define E60802_RG_PCIE_SPEED_PE1H_OFST            (21)
#define E60802_RG_PCIE_SPEED_U3_OFST              (20)
#define E60802_RG_SSUSB_XTAL_EXT_EN_PE2D_OFST     (18)
#define E60802_RG_SSUSB_XTAL_EXT_EN_PE2H_OFST     (16)
#define E60802_RG_SSUSB_XTAL_EXT_EN_PE1D_OFST     (14)
#define E60802_RG_SSUSB_XTAL_EXT_EN_PE1H_OFST     (12)
#define E60802_RG_SSUSB_XTAL_EXT_EN_U3_OFST       (10)
#define E60802_RG_SSUSB_CDR_REFCK_SEL_PE2D_OFST   (8)
#define E60802_RG_SSUSB_CDR_REFCK_SEL_PE2H_OFST   (6)
#define E60802_RG_SSUSB_CDR_REFCK_SEL_PE1D_OFST   (4)
#define E60802_RG_SSUSB_CDR_REFCK_SEL_PE1H_OFST   (2)
#define E60802_RG_SSUSB_CDR_REFCK_SEL_U3_OFST     (0)

/* U3D_reg32 */
#define RG_SSUSB_EQ_RSTEP1_PE2D            (0x3<<30)	/* 31:30 */
#define RG_SSUSB_EQ_RSTEP1_PE2H            (0x3<<28)	/* 29:28 */
#define RG_SSUSB_EQ_RSTEP1_PE1D            (0x3<<26)	/* 27:26 */
#define RG_SSUSB_EQ_RSTEP1_PE1H            (0x3<<24)	/* 25:24 */
#define RG_SSUSB_EQ_RSTEP1_U3              (0x3<<22)	/* 23:22 */
#define RG_SSUSB_LFPS_DEGLITCH_PE2D        (0x3<<20)	/* 21:20 */
#define RG_SSUSB_LFPS_DEGLITCH_PE2H        (0x3<<18)	/* 19:18 */
#define RG_SSUSB_LFPS_DEGLITCH_PE1D        (0x3<<16)	/* 17:16 */
#define RG_SSUSB_LFPS_DEGLITCH_PE1H        (0x3<<14)	/* 15:14 */
#define RG_SSUSB_LFPS_DEGLITCH_U3          (0x3<<12)	/* 13:12 */
#define RG_SSUSB_CDR_KVSEL_PE2D            (0x1<<11)	/* 11:11 */
#define RG_SSUSB_CDR_KVSEL_PE2H            (0x1<<10)	/* 10:10 */
#define RG_SSUSB_CDR_KVSEL_PE1D            (0x1<<9)	/* 9:9 */
#define RG_SSUSB_CDR_KVSEL_PE1H            (0x1<<8)	/* 8:8 */
#define RG_SSUSB_CDR_KVSEL_U3              (0x1<<7)	/* 7:7 */
#define RG_SSUSB_CDR_FBDIV_PE2D            (0x7f<<0)	/* 6:0 */
#define RG_SSUSB_EQ_RSTEP1_PE2D_OFST       (30)
#define RG_SSUSB_EQ_RSTEP1_PE2H_OFST       (28)
#define RG_SSUSB_EQ_RSTEP1_PE1D_OFST       (26)
#define RG_SSUSB_EQ_RSTEP1_PE1H_OFST       (24)
#define RG_SSUSB_EQ_RSTEP1_U3_OFST         (22)
#define RG_SSUSB_LFPS_DEGLITCH_PE2D_OFST   (20)
#define RG_SSUSB_LFPS_DEGLITCH_PE2H_OFST   (18)
#define RG_SSUSB_LFPS_DEGLITCH_PE1D_OFST   (16)
#define RG_SSUSB_LFPS_DEGLITCH_PE1H_OFST   (14)
#define RG_SSUSB_LFPS_DEGLITCH_U3_OFST     (12)
#define RG_SSUSB_CDR_KVSEL_PE2D_OFST       (11)
#define RG_SSUSB_CDR_KVSEL_PE2H_OFST       (10)
#define RG_SSUSB_CDR_KVSEL_PE1D_OFST       (9)
#define RG_SSUSB_CDR_KVSEL_PE1H_OFST       (8)
#define RG_SSUSB_CDR_KVSEL_U3_OFST         (7)
#define RG_SSUSB_CDR_FBDIV_PE2D_OFST       (0)

//U3D_XTALCTL3
#define E60802_RG_SSUSB_XTALCTL_REV                      (0xf<<12) //15:12
#define E60802_RG_SSUSB_BIASIMR_EN                       (0x1<<11) //11:11
#define E60802_RG_SSUSB_FORCE_BIASIMR_EN                 (0x1<<10) //10:10
#define E60802_RG_SSUSB_XTAL_RX_PWD                      (0x1<<9) //9:9
#define E60802_RG_SSUSB_FRC_XTAL_RX_PWD                  (0x1<<8) //8:8
#define E60802_RG_SSUSB_CKBG_PROB_SEL                    (0x3<<6) //7:6
#define E60802_RG_SSUSB_XTAL_PROB_SEL                    (0x3<<4) //5:4
#define E60802_RG_SSUSB_XTAL_VREGBIAS_LPF_ENB            (0x1<<3) //3:3
#define E60802_RG_SSUSB_XTAL_FRC_VREGBIAS_LPF_ENB        (0x1<<2) //2:2
#define E60802_RG_SSUSB_XTAL_VREGBIAS_PWD                (0x1<<1) //1:1
#define E60802_RG_SSUSB_XTAL_FRC_VREGBIAS_PWD            (0x1<<0) //0:0
#define E60802_RG_SSUSB_XTALCTL_REV_OFST                 (12)
#define E60802_RG_SSUSB_BIASIMR_EN_OFST                  (11)
#define E60802_RG_SSUSB_FORCE_BIASIMR_EN_OFST            (10)
#define E60802_RG_SSUSB_XTAL_RX_PWD_OFST                 (9)
#define E60802_RG_SSUSB_FRC_XTAL_RX_PWD_OFST             (8)
#define E60802_RG_SSUSB_CKBG_PROB_SEL_OFST               (6)
#define E60802_RG_SSUSB_XTAL_PROB_SEL_OFST               (4)
#define E60802_RG_SSUSB_XTAL_VREGBIAS_LPF_ENB_OFST       (3)
#define E60802_RG_SSUSB_XTAL_FRC_VREGBIAS_LPF_ENB_OFST   (2)
#define E60802_RG_SSUSB_XTAL_VREGBIAS_PWD_OFST           (1)
#define E60802_RG_SSUSB_XTAL_FRC_VREGBIAS_PWD_OFST       (0)

/* U3 PLL BAND*/
#define RG_SSUSB_DA_SSUSB_PLL_BAND_OFST (11)
#define RG_SSUSB_DA_SSUSB_PLL_BAND      (0x3F<<11)

/* U3D_B2_PHYD_RXDET2 */
#define RG_SSUSB_PHYD_TRAINDEC_FORCE_CGEN_OFST (31)
#define RG_SSUSB_PHYD_BERTLB_FORCE_CGEN_OFST (30)
#define RG_SSUSB_PHYD_T2RLB_FORCE_CGEN_OFST (29)
#define RG_SSUSB_LCK2REF_EXT_EN_OFST       (28)
#define RG_SSUSB_G2_LCK2REF_EXT_SEL_OFST   (24)
#define RG_SSUSB_LCK2REF_EXT_SEL_OFST      (20)
#define RG_SSUSB_PDN_T_SEL_OFST            (18)
#define RG_SSUSB_RXDET_STB3_SET_P3_OFST    (9)
#define RG_SSUSB_RXDET_STB2_SET_P3_OFST    (0)

/* U3D_B2_PHYD_RXDET2 */
#define RG_SSUSB_PHYD_TRAINDEC_FORCE_CGEN  (0x1<<31)	/* 31:31 */
#define RG_SSUSB_PHYD_BERTLB_FORCE_CGEN    (0x1<<30)	/* 30:30 */
#define RG_SSUSB_PHYD_T2RLB_FORCE_CGEN     (0x1<<29)	/* 29:29 */
#define RG_SSUSB_LCK2REF_EXT_EN            (0x1<<28)	/* 28:28 */
#define RG_SSUSB_G2_LCK2REF_EXT_SEL        (0xf<<24)	/* 27:24 */
#define RG_SSUSB_LCK2REF_EXT_SEL           (0xf<<20)	/* 23:20 */
#define RG_SSUSB_PDN_T_SEL                 (0x3<<18)	/* 19:18 */
#define RG_SSUSB_RXDET_STB3_SET_P3         (0x1ff<<9)	/* 17:9 */
#define RG_SSUSB_RXDET_STB2_SET_P3         (0x1ff<<0)	/* 8:0 */

// U3D_USB30_PHYA_REG0
#define RG_SSUSB_VUSB10_ON          (1<<5)
#define RG_SSUSB_VUSB10_ON_OFST     (5)

// U3D_USB30_PHYA_REG6
#define RG_SSUSB_TX_EIDLE_CM_OFST       (28)
#define RG_SSUSB_TX_EIDLE_CM            (0xf<<28)

// U3D_PHYD_CDR1
#define RG_SSUSB_CDR_BIR_LTD1_OFST      (24)
#define RG_SSUSB_CDR_BIR_LTD1           (0x1f<<24)
#define RG_SSUSB_CDR_BIR_LTD0_OFST      (8)
#define RG_SSUSB_CDR_BIR_LTD0           (0x1f<<8)

/* SSUSB_SIFSLV_IPPC FIELD DEFINITION */

/* U3D_SSUSB_IP_PW_CTRL0 */
#define SSUSB_IP_U2_ENTER_SLEEP_CNT		(0xff << 8) /* 15:8 */
#define SSUSB_IP_SW_RST				(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_IP_PW_CTRL1 */
#define SSUSB_IP_HOST_PDN			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_IP_PW_CTRL2 */
#define SSUSB_IP_DEV_PDN			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_IP_PW_CTRL3 */
#define SSUSB_IP_PCIE_PDN			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_IP_PW_STS1 */
#define SSUSB_U2_MAC_RST_B_STS_5P		(0x1 << 29) /* 29:29 */
#define SSUSB_U2_MAC_RST_B_STS_4P		(0x1 << 28) /* 28:28 */
#define SSUSB_U2_MAC_RST_B_STS_3P		(0x1 << 27) /* 27:27 */
#define SSUSB_U2_MAC_RST_B_STS_2P		(0x1 << 26) /* 26:26 */
#define SSUSB_U2_MAC_RST_B_STS_1P		(0x1 << 25) /* 25:25 */
#define SSUSB_U2_MAC_RST_B_STS			(0x1 << 24) /* 24:24 */
#define SSUSB_U3_MAC_RST_B_STS_3P		(0x1 << 19) /* 19:19 */
#define SSUSB_U3_MAC_RST_B_STS_2P		(0x1 << 18) /* 18:18 */
#define SSUSB_U3_MAC_RST_B_STS_1P		(0x1 << 17) /* 17:17 */
#define SSUSB_U3_MAC_RST_B_STS			(0x1 << 16) /* 16:16 */
#define SSUSB_DEV_DRAM_RST_B_STS		(0x1 << 13) /* 13:13 */
#define SSUSB_XHCI_DRAM_RST_B_STS		(0x1 << 12) /* 12:12 */
#define SSUSB_XHCI_RST_B_STS			(0x1 << 11) /* 11:11 */
#define SSUSB_SYS125_RST_B_STS			(0x1 << 10) /* 10:10 */
#define SSUSB_SYS60_RST_B_STS			(0x1 << 9) /* 9:9 */
#define SSUSB_REF_RST_B_STS			(0x1 << 8) /* 8:8 */
#define SSUSB_DEV_RST_B_STS			(0x1 << 3) /* 3:3 */
#define SSUSB_DEV_BMU_RST_B_STS			(0x1 << 2) /* 2:2 */
#define SSUSB_DEV_QMU_RST_B_STS			(0x1 << 1) /* 1:1 */
#define SSUSB_SYSPLL_STABLE			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_IP_PW_STS2 */
#define SSUSB_U2_MAC_SYS_RST_B_STS_5P		(0x1 << 5) /* 5:5 */
#define SSUSB_U2_MAC_SYS_RST_B_STS_4P		(0x1 << 4) /* 4:4 */
#define SSUSB_U2_MAC_SYS_RST_B_STS_3P		(0x1 << 3) /* 3:3 */
#define SSUSB_U2_MAC_SYS_RST_B_STS_2P		(0x1 << 2) /* 2:2 */
#define SSUSB_U2_MAC_SYS_RST_B_STS_1P		(0x1 << 1) /* 1:1 */
#define SSUSB_U2_MAC_SYS_RST_B_STS		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_IP_MAC_CAP */
#define SSUSB_IP_MAC_U2_PORT_NO			(0xff << 8) /* 15:8 */
#define SSUSB_IP_MAC_U3_PORT_NO			(0xff << 0) /* 7:0 */

/* U3D_SSUSB_IP_XHCI_CAP */
#define SSUSB_IP_XHCI_U2_PORT_NO		(0xff << 8) /* 15:8 */
#define SSUSB_IP_XHCI_U3_PORT_NO		(0xff << 0) /* 7:0 */

/* U3D_SSUSB_IP_DEV_CAP */
#define SSUSB_IP_DEV_U2_PORT_NO			(0xff << 8) /* 15:8 */
#define SSUSB_IP_DEV_U3_PORT_NO			(0xff << 0) /* 7:0 */

/* U3D_SSUSB_U3_CTRL_0P */
#define SSUSB_U3_PORT_PHYD_RST			(0x1 << 5) /* 5:5 */
#define SSUSB_U3_PORT_MAC_RST			(0x1 << 4) /* 4:4 */
#define SSUSB_U3_PORT_U2_CG_EN			(0x1 << 3) /* 3:3 */
#define SSUSB_U3_PORT_HOST_SEL			(0x1 << 2) /* 2:2 */
#define SSUSB_U3_PORT_PDN			(0x1 << 1) /* 1:1 */
#define SSUSB_U3_PORT_DIS			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_U3_CTRL_1P */
#define SSUSB_U3_PORT_PHYD_RST_1P		(0x1 << 5) /* 5:5 */
#define SSUSB_U3_PORT_MAC_RST_1P		(0x1 << 4) /* 4:4 */
#define SSUSB_U3_PORT_U2_CG_EN_1P		(0x1 << 3) /* 3:3 */
#define SSUSB_U3_PORT_HOST_SEL_1P		(0x1 << 2) /* 2:2 */
#define SSUSB_U3_PORT_PDN_1P			(0x1 << 1) /* 1:1 */
#define SSUSB_U3_PORT_DIS_1P			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_U3_CTRL_2P */
#define SSUSB_U3_PORT_PHYD_RST_2P		(0x1 << 5) /* 5:5 */
#define SSUSB_U3_PORT_MAC_RST_2P		(0x1 << 4) /* 4:4 */
#define SSUSB_U3_PORT_U2_CG_EN_2P		(0x1 << 3) /* 3:3 */
#define SSUSB_U3_PORT_HOST_SEL_2P		(0x1 << 2) /* 2:2 */
#define SSUSB_U3_PORT_PDN_2P			(0x1 << 1) /* 1:1 */
#define SSUSB_U3_PORT_DIS_2P			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_U3_CTRL_3P */
#define SSUSB_U3_PORT_PHYD_RST_3P		(0x1 << 5) /* 5:5 */
#define SSUSB_U3_PORT_MAC_RST_3P		(0x1 << 4) /* 4:4 */
#define SSUSB_U3_PORT_U2_CG_EN_3P		(0x1 << 3) /* 3:3 */
#define SSUSB_U3_PORT_HOST_SEL_3P		(0x1 << 2) /* 2:2 */
#define SSUSB_U3_PORT_PDN_3P			(0x1 << 1) /* 1:1 */
#define SSUSB_U3_PORT_DIS_3P			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_U2_CTRL_0P */
#define SSUSB_U2_PORT_SYS_CK_SEL		(0x1 << 6) /* 6:6 */
#define SSUSB_U2_PORT_PHYD_RST			(0x1 << 5) /* 5:5 */
#define SSUSB_U2_PORT_MAC_RST			(0x1 << 4) /* 4:4 */
#define SSUSB_U2_PORT_U2_CG_EN			(0x1 << 3) /* 3:3 */
#define SSUSB_U2_PORT_HOST_SEL			(0x1 << 2) /* 2:2 */
#define SSUSB_U2_PORT_PDN			(0x1 << 1) /* 1:1 */
#define SSUSB_U2_PORT_DIS			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_U2_CTRL_1P */
#define SSUSB_U2_PORT_SYS_CK_SEL_1P		(0x1 << 6) /* 6:6 */
#define SSUSB_U2_PORT_PHYD_RST_1P		(0x1 << 5) /* 5:5 */
#define SSUSB_U2_PORT_MAC_RST_1P		(0x1 << 4) /* 4:4 */
#define SSUSB_U2_PORT_U2_CG_EN_1P		(0x1 << 3) /* 3:3 */
#define SSUSB_U2_PORT_HOST_SEL_1P		(0x1 << 2) /* 2:2 */
#define SSUSB_U2_PORT_PDN_1P			(0x1 << 1) /* 1:1 */
#define SSUSB_U2_PORT_DIS_1P			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_U2_CTRL_2P */
#define SSUSB_U2_PORT_SYS_CK_SEL_2P		(0x1 << 6) /* 6:6 */
#define SSUSB_U2_PORT_PHYD_RST_2P		(0x1 << 5) /* 5:5 */
#define SSUSB_U2_PORT_MAC_RST_2P		(0x1 << 4) /* 4:4 */
#define SSUSB_U2_PORT_U2_CG_EN_2P		(0x1 << 3) /* 3:3 */
#define SSUSB_U2_PORT_HOST_SEL_2P		(0x1 << 2) /* 2:2 */
#define SSUSB_U2_PORT_PDN_2P			(0x1 << 1) /* 1:1 */
#define SSUSB_U2_PORT_DIS_2P			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_U2_CTRL_3P */
#define SSUSB_U2_PORT_SYS_CK_SEL_3P		(0x1 << 6) /* 6:6 */
#define SSUSB_U2_PORT_PHYD_RST_3P		(0x1 << 5) /* 5:5 */
#define SSUSB_U2_PORT_MAC_RST_3P		(0x1 << 4) /* 4:4 */
#define SSUSB_U2_PORT_U2_CG_EN_3P		(0x1 << 3) /* 3:3 */
#define SSUSB_U2_PORT_HOST_SEL_3P		(0x1 << 2) /* 2:2 */
#define SSUSB_U2_PORT_PDN_3P			(0x1 << 1) /* 1:1 */
#define SSUSB_U2_PORT_DIS_3P			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_U2_CTRL_4P */
#define SSUSB_U2_PORT_SYS_CK_SEL_4P		(0x1 << 6) /* 6:6 */
#define SSUSB_U2_PORT_PHYD_RST_4P		(0x1 << 5) /* 5:5 */
#define SSUSB_U2_PORT_MAC_RST_4P		(0x1 << 4) /* 4:4 */
#define SSUSB_U2_PORT_U2_CG_EN_4P		(0x1 << 3) /* 3:3 */
#define SSUSB_U2_PORT_HOST_SEL_4P		(0x1 << 2) /* 2:2 */
#define SSUSB_U2_PORT_PDN_4P			(0x1 << 1) /* 1:1 */
#define SSUSB_U2_PORT_DIS_4P			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_U2_CTRL_5P */
#define SSUSB_U2_PORT_SYS_CK_SEL_5P		(0x1 << 6) /* 6:6 */
#define SSUSB_U2_PORT_PHYD_RST_5P		(0x1 << 5) /* 5:5 */
#define SSUSB_U2_PORT_MAC_RST_5P		(0x1 << 4) /* 4:4 */
#define SSUSB_U2_PORT_U2_CG_EN_5P		(0x1 << 3) /* 3:3 */
#define SSUSB_U2_PORT_HOST_SEL_5P		(0x1 << 2) /* 2:2 */
#define SSUSB_U2_PORT_PDN_5P			(0x1 << 1) /* 1:1 */
#define SSUSB_U2_PORT_DIS_5P			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_U2_PHY_PLL */
#define SSUSB_U2_PORT_PLL_STABLE_TIMER		(0xff << 8) /* 15:8 */
#define SSUSB_U2_PORT_1US_TIMER			(0xff << 0) /* 7:0 */

/* U3D_SSUSB_DMA_CTRL */
#define SSUSB_IP_DMA_BUS_CK_GATE_DIS		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_MAC_CK_CTRL */
#define SSUSB_MAC3_SYS_CK_GATE_MASK_TIME	(0xff << 16) /* 23:16 */
#define SSUSB_MAC2_SYS_CK_GATE_MASK_TIME	(0xff << 8) /* 15:8 */
#define SSUSB_MAC3_SYS_CK_GATE_MODE		(0x3 << 2) /* 3:2 */
#define SSUSB_MAC2_SYS_CK_GATE_MODE		(0x3 << 0) /* 1:0 */

/* U3D_SSUSB_CSR_CK_CTRL */
#define SSUSB_CSR_MCU_BUS_CK_GATE_EN		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_REF_CK_CTRL */
#define SSUSB_REF_MAC3_CK_GATE_EN		(0x1 << 3) /* 3:3 */
#define SSUSB_REF_CK_GATE_EN			(0x1 << 2) /* 2:2 */
#define SSUSB_REF_PHY_CK_GATE_EN		(0x1 << 1) /* 1:1 */
#define SSUSB_REF_MAC_CK_GATE_EN		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_XHCI_CK_CTRL */
#define SSUSB_XACT3_XHCI_CK_GATE_MASK_TIME	(0xff << 8) /* 15:8 */
#define SSUSB_XACT3_XHCI_CK_GATE_MODE		(0x3 << 4) /* 5:4 */
#define SSUSB_XHCI_CK_DIV2_EN			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_XHCI_RST_CTRL */
#define SSUSB_XHCI_SW_DRAM_RST			(0x1 << 4) /* 4:4 */
#define SSUSB_XHCI_SW_SYS60_RST			(0x1 << 3) /* 3:3 */
#define SSUSB_XHCI_SW_SYS125_RST		(0x1 << 2) /* 2:2 */
#define SSUSB_XHCI_SW_XHCI_RST			(0x1 << 1) /* 1:1 */
#define SSUSB_XHCI_SW_RST			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_DEV_RST_CTRL */
#define SSUSB_DEV_SW_DRAM_RST			(0x1 << 3) /* 3:3 */
#define SSUSB_DEV_SW_QMU_RST			(0x1 << 2) /* 2:2 */
#define SSUSB_DEV_SW_BMU_RST			(0x1 << 1) /* 1:1 */
#define SSUSB_DEV_SW_RST			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_SYS_CK_CTRL */
#define SSUSB_SYS_CK_DIV2_EN			(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_HW_ID */
#define SSUSB_HW_ID				(0xffffffff << 0) /* 31:0 */

/* U3D_SSUSB_HW_SUB_ID */
#define SSUSB_HW_SUB_ID				(0xffffffff << 0) /* 31:0 */

/* U3D_SSUSB_PRB_CTRL0 */
#define PRB_BYTE3_EN				(0x1 << 3) /* 3:3 */
#define PRB_BYTE2_EN				(0x1 << 2) /* 2:2 */
#define PRB_BYTE1_EN				(0x1 << 1) /* 1:1 */
#define PRB_BYTE0_EN				(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_PRB_CTRL1 */
#define PRB_BYTE1_SEL				(0xffff << 16) /* 31:16 */
#define PRB_BYTE0_SEL				(0xffff << 0) /* 15:0 */

/* U3D_SSUSB_PRB_CTRL2 */
#define PRB_BYTE3_SEL				(0xffff << 16) /* 31:16 */
#define PRB_BYTE2_SEL				(0xffff << 0) /* 15:0 */

/* U3D_SSUSB_PRB_CTRL3 */
#define PRB_BYTE3_MODULE_SEL			(0xff << 24) /* 31:24 */
#define PRB_BYTE2_MODULE_SEL			(0xff << 16) /* 23:16 */
#define PRB_BYTE1_MODULE_SEL			(0xff << 8) /* 15:8 */
#define PRB_BYTE0_MODULE_SEL			(0xff << 0) /* 7:0 */

/* U3D_SSUSB_PRB_CTRL4 */
#define SW_PRB_OUT				(0xffffffff << 0) /* 31:0 */

/* U3D_SSUSB_PRB_CTRL5 */
#define PRB_RD_DATA				(0xffffffff << 0) /* 31:0 */

/* U3D_SSUSB_IP_SPARE0 */
#define SSUSB_IP_SPARE0				(0xffffffff << 0) /* 31:0 */

/* U3D_SSUSB_IP_SPARE1 */
#define SSUSB_IP_SPARE1				(0xffffffff << 0) /* 31:0 */

/* U3D_SSUSB_FPGA_I2C_OUT_0P */
#define SSUSB_FPGA_I2C_SCL_OEN_0P		(0x1 << 3) /* 3:3 */
#define SSUSB_FPGA_I2C_SCL_OUT_0P		(0x1 << 2) /* 2:2 */
#define SSUSB_FPGA_I2C_SDA_OEN_0P		(0x1 << 1) /* 1:1 */
#define SSUSB_FPGA_I2C_SDA_OUT_0P		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_FPGA_I2C_IN_0P */
#define SSUSB_FPGA_I2C_SCL_IN_0P		(0x1 << 1) /* 1:1 */
#define SSUSB_FPGA_I2C_SDA_IN_0P		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_FPGA_I2C_OUT_1P */
#define SSUSB_FPGA_I2C_SCL_OEN_1P		(0x1 << 3) /* 3:3 */
#define SSUSB_FPGA_I2C_SCL_OUT_1P		(0x1 << 2) /* 2:2 */
#define SSUSB_FPGA_I2C_SDA_OEN_1P		(0x1 << 1) /* 1:1 */
#define SSUSB_FPGA_I2C_SDA_OUT_1P		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_FPGA_I2C_IN_1P */
#define SSUSB_FPGA_I2C_SCL_IN_1P		(0x1 << 1) /* 1:1 */
#define SSUSB_FPGA_I2C_SDA_IN_1P		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_FPGA_I2C_OUT_2P */
#define SSUSB_FPGA_I2C_SCL_OEN_2P		(0x1 << 3) /* 3:3 */
#define SSUSB_FPGA_I2C_SCL_OUT_2P		(0x1 << 2) /* 2:2 */
#define SSUSB_FPGA_I2C_SDA_OEN_2P		(0x1 << 1) /* 1:1 */
#define SSUSB_FPGA_I2C_SDA_OUT_2P		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_FPGA_I2C_IN_2P */
#define SSUSB_FPGA_I2C_SCL_IN_2P		(0x1 << 1) /* 1:1 */
#define SSUSB_FPGA_I2C_SDA_IN_2P		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_FPGA_I2C_OUT_3P */
#define SSUSB_FPGA_I2C_SCL_OEN_3P		(0x1 << 3) /* 3:3 */
#define SSUSB_FPGA_I2C_SCL_OUT_3P		(0x1 << 2) /* 2:2 */
#define SSUSB_FPGA_I2C_SDA_OEN_3P		(0x1 << 1) /* 1:1 */
#define SSUSB_FPGA_I2C_SDA_OUT_3P		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_FPGA_I2C_IN_3P */
#define SSUSB_FPGA_I2C_SCL_IN_3P		(0x1 << 1) /* 1:1 */
#define SSUSB_FPGA_I2C_SDA_IN_3P		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_FPGA_I2C_OUT_4P */
#define SSUSB_FPGA_I2C_SCL_OEN_4P		(0x1 << 3) /* 3:3 */
#define SSUSB_FPGA_I2C_SCL_OUT_4P		(0x1 << 2) /* 2:2 */
#define SSUSB_FPGA_I2C_SDA_OEN_4P		(0x1 << 1) /* 1:1 */
#define SSUSB_FPGA_I2C_SDA_OUT_4P		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_FPGA_I2C_IN_4P */
#define SSUSB_FPGA_I2C_SCL_IN_4P		(0x1 << 1) /* 1:1 */
#define SSUSB_FPGA_I2C_SDA_IN_4P		(0x1 << 0) /* 0:0 */

/* U3D_SSUSB_IP_SLV_TMOUT */
#define SSUSB_IP_SLV_TMOUT			(0xffffffff << 0) /* 31:0 */

/* SSUSB_SIFSLV_IPPC FIELD OFFSET DEFINITION */
/* U3D_SSUSB_IP_PW_CTRL0 */
#define SSUSB_IP_U2_ENTER_SLEEP_CNT_OFST	(8)
#define SSUSB_IP_SW_RST_OFST			(0)

/* U3D_SSUSB_IP_PW_CTRL1 */
#define SSUSB_IP_HOST_PDN_OFST			(0)

/* U3D_SSUSB_IP_PW_CTRL2 */
#define SSUSB_IP_DEV_PDN_OFST			(0)

/* U3D_SSUSB_IP_PW_CTRL3 */
#define SSUSB_IP_PCIE_PDN_OFST			(0)

/* U3D_SSUSB_IP_PW_STS1 */
#define SSUSB_U2_MAC_RST_B_STS_5P_OFST		(29)
#define SSUSB_U2_MAC_RST_B_STS_4P_OFST		(28)
#define SSUSB_U2_MAC_RST_B_STS_3P_OFST		(27)
#define SSUSB_U2_MAC_RST_B_STS_2P_OFST		(26)
#define SSUSB_U2_MAC_RST_B_STS_1P_OFST		(25)
#define SSUSB_U2_MAC_RST_B_STS_OFST		(24)
#define SSUSB_U3_MAC_RST_B_STS_3P_OFST		(19)
#define SSUSB_U3_MAC_RST_B_STS_2P_OFST		(18)
#define SSUSB_U3_MAC_RST_B_STS_1P_OFST		(17)
#define SSUSB_U3_MAC_RST_B_STS_OFST		(16)
#define SSUSB_DEV_DRAM_RST_B_STS_OFST		(13)
#define SSUSB_XHCI_DRAM_RST_B_STS_OFST		(12)
#define SSUSB_XHCI_RST_B_STS_OFST		(11)
#define SSUSB_SYS125_RST_B_STS_OFST		(10)
#define SSUSB_SYS60_RST_B_STS_OFST		(9)
#define SSUSB_REF_RST_B_STS_OFST		(8)
#define SSUSB_DEV_RST_B_STS_OFST		(3)
#define SSUSB_DEV_BMU_RST_B_STS_OFST		(2)
#define SSUSB_DEV_QMU_RST_B_STS_OFST		(1)
#define SSUSB_SYSPLL_STABLE_OFST		(0)

/* U3D_SSUSB_IP_PW_STS2 */
#define SSUSB_U2_MAC_SYS_RST_B_STS_5P_OFST	(5)
#define SSUSB_U2_MAC_SYS_RST_B_STS_4P_OFST	(4)
#define SSUSB_U2_MAC_SYS_RST_B_STS_3P_OFST	(3)
#define SSUSB_U2_MAC_SYS_RST_B_STS_2P_OFST	(2)
#define SSUSB_U2_MAC_SYS_RST_B_STS_1P_OFST	(1)
#define SSUSB_U2_MAC_SYS_RST_B_STS_OFST		(0)

/* U3D_SSUSB_IP_MAC_CAP */
#define SSUSB_IP_MAC_U2_PORT_NO_OFST		(8)
#define SSUSB_IP_MAC_U3_PORT_NO_OFST		(0)

/* U3D_SSUSB_IP_XHCI_CAP */
#define SSUSB_IP_XHCI_U2_PORT_NO_OFST		(8)
#define SSUSB_IP_XHCI_U3_PORT_NO_OFST		(0)

/* U3D_SSUSB_IP_DEV_CAP */
#define SSUSB_IP_DEV_U2_PORT_NO_OFST		(8)
#define SSUSB_IP_DEV_U3_PORT_NO_OFST		(0)

/* U3D_SSUSB_U3_CTRL_0P */
#define SSUSB_U3_PORT_PHYD_RST_OFST		(5)
#define SSUSB_U3_PORT_MAC_RST_OFST		(4)
#define SSUSB_U3_PORT_U2_CG_EN_OFST		(3)
#define SSUSB_U3_PORT_HOST_SEL_OFST		(2)
#define SSUSB_U3_PORT_PDN_OFST			(1)
#define SSUSB_U3_PORT_DIS_OFST			(0)

/* U3D_SSUSB_U3_CTRL_1P */
#define SSUSB_U3_PORT_PHYD_RST_1P_OFST		(5)
#define SSUSB_U3_PORT_MAC_RST_1P_OFST		(4)
#define SSUSB_U3_PORT_U2_CG_EN_1P_OFST		(3)
#define SSUSB_U3_PORT_HOST_SEL_1P_OFST		(2)
#define SSUSB_U3_PORT_PDN_1P_OFST		(1)
#define SSUSB_U3_PORT_DIS_1P_OFST		(0)

/* U3D_SSUSB_U3_CTRL_2P */
#define SSUSB_U3_PORT_PHYD_RST_2P_OFST		(5)
#define SSUSB_U3_PORT_MAC_RST_2P_OFST		(4)
#define SSUSB_U3_PORT_U2_CG_EN_2P_OFST		(3)
#define SSUSB_U3_PORT_HOST_SEL_2P_OFST		(2)
#define SSUSB_U3_PORT_PDN_2P_OFST		(1)
#define SSUSB_U3_PORT_DIS_2P_OFST		(0)

/* U3D_SSUSB_U3_CTRL_3P */
#define SSUSB_U3_PORT_PHYD_RST_3P_OFST		(5)
#define SSUSB_U3_PORT_MAC_RST_3P_OFST		(4)
#define SSUSB_U3_PORT_U2_CG_EN_3P_OFST		(3)
#define SSUSB_U3_PORT_HOST_SEL_3P_OFST		(2)
#define SSUSB_U3_PORT_PDN_3P_OFST		(1)
#define SSUSB_U3_PORT_DIS_3P_OFST		(0)

/* U3D_SSUSB_U2_CTRL_0P */
#define SSUSB_U2_PORT_SYS_CK_SEL_OFST		(6)
#define SSUSB_U2_PORT_PHYD_RST_OFST		(5)
#define SSUSB_U2_PORT_MAC_RST_OFST		(4)
#define SSUSB_U2_PORT_U2_CG_EN_OFST		(3)
#define SSUSB_U2_PORT_HOST_SEL_OFST		(2)
#define SSUSB_U2_PORT_PDN_OFST			(1)
#define SSUSB_U2_PORT_DIS_OFST			(0)

/* U3D_SSUSB_U2_CTRL_1P */
#define SSUSB_U2_PORT_SYS_CK_SEL_1P_OFST	(6)
#define SSUSB_U2_PORT_PHYD_RST_1P_OFST		(5)
#define SSUSB_U2_PORT_MAC_RST_1P_OFST		(4)
#define SSUSB_U2_PORT_U2_CG_EN_1P_OFST		(3)
#define SSUSB_U2_PORT_HOST_SEL_1P_OFST		(2)
#define SSUSB_U2_PORT_PDN_1P_OFST		(1)
#define SSUSB_U2_PORT_DIS_1P_OFST		(0)

/* U3D_SSUSB_U2_CTRL_2P */
#define SSUSB_U2_PORT_SYS_CK_SEL_2P_OFST	(6)
#define SSUSB_U2_PORT_PHYD_RST_2P_OFST		(5)
#define SSUSB_U2_PORT_MAC_RST_2P_OFST		(4)
#define SSUSB_U2_PORT_U2_CG_EN_2P_OFST		(3)
#define SSUSB_U2_PORT_HOST_SEL_2P_OFST		(2)
#define SSUSB_U2_PORT_PDN_2P_OFST		(1)
#define SSUSB_U2_PORT_DIS_2P_OFST		(0)

/* U3D_SSUSB_U2_CTRL_3P */
#define SSUSB_U2_PORT_SYS_CK_SEL_3P_OFST	(6)
#define SSUSB_U2_PORT_PHYD_RST_3P_OFST		(5)
#define SSUSB_U2_PORT_MAC_RST_3P_OFST		(4)
#define SSUSB_U2_PORT_U2_CG_EN_3P_OFST		(3)
#define SSUSB_U2_PORT_HOST_SEL_3P_OFST		(2)
#define SSUSB_U2_PORT_PDN_3P_OFST		(1)
#define SSUSB_U2_PORT_DIS_3P_OFST		(0)

/* U3D_SSUSB_U2_CTRL_4P */
#define SSUSB_U2_PORT_SYS_CK_SEL_4P_OFST	(6)
#define SSUSB_U2_PORT_PHYD_RST_4P_OFST		(5)
#define SSUSB_U2_PORT_MAC_RST_4P_OFST		(4)
#define SSUSB_U2_PORT_U2_CG_EN_4P_OFST		(3)
#define SSUSB_U2_PORT_HOST_SEL_4P_OFST		(2)
#define SSUSB_U2_PORT_PDN_4P_OFST		(1)
#define SSUSB_U2_PORT_DIS_4P_OFST		(0)

/* U3D_SSUSB_U2_CTRL_5P */
#define SSUSB_U2_PORT_SYS_CK_SEL_5P_OFST	(6)
#define SSUSB_U2_PORT_PHYD_RST_5P_OFST		(5)
#define SSUSB_U2_PORT_MAC_RST_5P_OFST		(4)
#define SSUSB_U2_PORT_U2_CG_EN_5P_OFST		(3)
#define SSUSB_U2_PORT_HOST_SEL_5P_OFST		(2)
#define SSUSB_U2_PORT_PDN_5P_OFST		(1)
#define SSUSB_U2_PORT_DIS_5P_OFST		(0)

/* U3D_SSUSB_U2_PHY_PLL */
#define SSUSB_U2_PORT_PLL_STABLE_TIMER_OFST	(8)
#define SSUSB_U2_PORT_1US_TIMER_OFST		(0)

/* U3D_SSUSB_DMA_CTRL */
#define SSUSB_IP_DMA_BUS_CK_GATE_DIS_OFST	(0)

/* U3D_SSUSB_MAC_CK_CTRL */
#define SSUSB_MAC3_SYS_CK_GATE_MASK_TIME_OFST	(16)
#define SSUSB_MAC2_SYS_CK_GATE_MASK_TIME_OFST	(8)
#define SSUSB_MAC3_SYS_CK_GATE_MODE_OFST	(2)
#define SSUSB_MAC2_SYS_CK_GATE_MODE_OFST	(0)

/* U3D_SSUSB_CSR_CK_CTRL */
#define SSUSB_CSR_MCU_BUS_CK_GATE_EN_OFST	(0)

/* U3D_SSUSB_REF_CK_CTRL */
#define SSUSB_REF_MAC3_CK_GATE_EN_OFST		(3)
#define SSUSB_REF_CK_GATE_EN_OFST		(2)
#define SSUSB_REF_PHY_CK_GATE_EN_OFST		(1)
#define SSUSB_REF_MAC_CK_GATE_EN_OFST		(0)

/* U3D_SSUSB_XHCI_CK_CTRL */
#define SSUSB_XACT3_XHCI_CK_GATE_MASK_TIME_OFST	(8)
#define SSUSB_XACT3_XHCI_CK_GATE_MODE_OFST	(4)
#define SSUSB_XHCI_CK_DIV2_EN_OFST		(0)

/* U3D_SSUSB_XHCI_RST_CTRL */
#define SSUSB_XHCI_SW_DRAM_RST_OFST		(4)
#define SSUSB_XHCI_SW_SYS60_RST_OFST		(3)
#define SSUSB_XHCI_SW_SYS125_RST_OFST		(2)
#define SSUSB_XHCI_SW_XHCI_RST_OFST		(1)
#define SSUSB_XHCI_SW_RST_OFST			(0)

/* U3D_SSUSB_DEV_RST_CTRL */
#define SSUSB_DEV_SW_DRAM_RST_OFST		(3)
#define SSUSB_DEV_SW_QMU_RST_OFST		(2)
#define SSUSB_DEV_SW_BMU_RST_OFST		(1)
#define SSUSB_DEV_SW_RST_OFST			(0)

/* U3D_SSUSB_SYS_CK_CTRL */
#define SSUSB_SYS_CK_DIV2_EN_OFST		(0)

/* U3D_SSUSB_HW_ID */
#define SSUSB_HW_ID_OFST			(0)

/* U3D_SSUSB_HW_SUB_ID */
#define SSUSB_HW_SUB_ID_OFST			(0)

/* U3D_SSUSB_PRB_CTRL0 */
#define PRB_BYTE3_EN_OFST			(3)
#define PRB_BYTE2_EN_OFST			(2)
#define PRB_BYTE1_EN_OFST			(1)
#define PRB_BYTE0_EN_OFST			(0)

/* U3D_SSUSB_PRB_CTRL1 */
#define PRB_BYTE1_SEL_OFST			(16)
#define PRB_BYTE0_SEL_OFST			(0)

/* U3D_SSUSB_PRB_CTRL2 */
#define PRB_BYTE3_SEL_OFST			(16)
#define PRB_BYTE2_SEL_OFST			(0)

/* U3D_SSUSB_PRB_CTRL3 */
#define PRB_BYTE3_MODULE_SEL_OFST		(24)
#define PRB_BYTE2_MODULE_SEL_OFST		(16)
#define PRB_BYTE1_MODULE_SEL_OFST		(8)
#define PRB_BYTE0_MODULE_SEL_OFST		(0)

/* U3D_SSUSB_PRB_CTRL4 */
#define SW_PRB_OUT_OFST				(0)

/* U3D_SSUSB_PRB_CTRL5 */
#define PRB_RD_DATA_OFST			(0)

/* U3D_SSUSB_IP_SPARE0 */
#define SSUSB_IP_SPARE0_OFST			(0)

/* U3D_SSUSB_IP_SPARE1 */
#define SSUSB_IP_SPARE1_OFST			(0)

/* U3D_SSUSB_FPGA_I2C_OUT_0P */
#define SSUSB_FPGA_I2C_SCL_OEN_0P_OFST		(3)
#define SSUSB_FPGA_I2C_SCL_OUT_0P_OFST		(2)
#define SSUSB_FPGA_I2C_SDA_OEN_0P_OFST		(1)
#define SSUSB_FPGA_I2C_SDA_OUT_0P_OFST		(0)

/* U3D_SSUSB_FPGA_I2C_IN_0P */
#define SSUSB_FPGA_I2C_SCL_IN_0P_OFST		(1)
#define SSUSB_FPGA_I2C_SDA_IN_0P_OFST		(0)

/* U3D_SSUSB_FPGA_I2C_OUT_1P */
#define SSUSB_FPGA_I2C_SCL_OEN_1P_OFST		(3)
#define SSUSB_FPGA_I2C_SCL_OUT_1P_OFST		(2)
#define SSUSB_FPGA_I2C_SDA_OEN_1P_OFST		(1)
#define SSUSB_FPGA_I2C_SDA_OUT_1P_OFST		(0)

/* U3D_SSUSB_FPGA_I2C_IN_1P */
#define SSUSB_FPGA_I2C_SCL_IN_1P_OFST		(1)
#define SSUSB_FPGA_I2C_SDA_IN_1P_OFST		(0)

/* U3D_SSUSB_FPGA_I2C_OUT_2P */
#define SSUSB_FPGA_I2C_SCL_OEN_2P_OFST		(3)
#define SSUSB_FPGA_I2C_SCL_OUT_2P_OFST		(2)
#define SSUSB_FPGA_I2C_SDA_OEN_2P_OFST		(1)
#define SSUSB_FPGA_I2C_SDA_OUT_2P_OFST		(0)

/* U3D_SSUSB_FPGA_I2C_IN_2P */
#define SSUSB_FPGA_I2C_SCL_IN_2P_OFST		(1)
#define SSUSB_FPGA_I2C_SDA_IN_2P_OFST		(0)

/* U3D_SSUSB_FPGA_I2C_OUT_3P */
#define SSUSB_FPGA_I2C_SCL_OEN_3P_OFST		(3)
#define SSUSB_FPGA_I2C_SCL_OUT_3P_OFST		(2)
#define SSUSB_FPGA_I2C_SDA_OEN_3P_OFST		(1)
#define SSUSB_FPGA_I2C_SDA_OUT_3P_OFST		(0)

/* U3D_SSUSB_FPGA_I2C_IN_3P */
#define SSUSB_FPGA_I2C_SCL_IN_3P_OFST		(1)
#define SSUSB_FPGA_I2C_SDA_IN_3P_OFST		(0)

/* U3D_SSUSB_FPGA_I2C_OUT_4P */
#define SSUSB_FPGA_I2C_SCL_OEN_4P_OFST		(3)
#define SSUSB_FPGA_I2C_SCL_OUT_4P_OFST		(2)
#define SSUSB_FPGA_I2C_SDA_OEN_4P_OFST		(1)
#define SSUSB_FPGA_I2C_SDA_OUT_4P_OFST		(0)

/* U3D_SSUSB_FPGA_I2C_IN_4P */
#define SSUSB_FPGA_I2C_SCL_IN_4P_OFST		(1)
#define SSUSB_FPGA_I2C_SDA_IN_4P_OFST		(0)

/* U3D_SSUSB_IP_SLV_TMOUT */
#define SSUSB_IP_SLV_TMOUT_OFST			(0)

#endif
