#include "platform.h"
#include "sec_devinfo.h"
#include "mtk_vcore_opp.h"
#include <dconfig_env.h>



/*#define VCORE_HV_ENABLE*/
/*#define VCORE_LV_ENABLE*/


#define DVFSRC_BASE (0x10012000)
#define DVFSRC_PCIE_VCORE_REQ  (DVFSRC_BASE + 0xE0)
#define DVFSRC_PCIE_VCORE_REQ_2 (DVFSRC_BASE + 0xEC)
#define VCORE_VMODE_SHIFT 0
#define VCORE_DRM_SHIFT 31


#ifdef MTK_AGING_FLAVOR_LOAD
#define VCORE_LV_ENABLE
#endif


static int vcore_uv_table[VCORE_OPP_NUM];
static int dvfs_v_mode;


#ifdef DDR_RESERVE_MODE
static void dvfsrc_reserve_dump(void);
#endif


void set_vcore_uv_table(int vcore_opp, int vcore_uv)
{
	vcore_uv_table[vcore_opp] = vcore_uv;
}

int get_vcore_uv_table(int vcore_opp)
{
	return vcore_uv_table[vcore_opp];
}

void dvfsrc_opp_level_mapping(void)
{
	char *doe_vcore;
	u32 rsv4 = 0;
	int vcore_opp_0_uv, vcore_opp_1_uv, vcore_opp_2_uv, vcore_opp_3_uv;

#if defined(VCORE_LV_ENABLE) || defined(MTK_LV_AGING_ENABLE)
	dvfs_v_mode = 3;
#elif defined(VCORE_HV_ENABLE)
	dvfs_v_mode = 1;
#endif

	doe_vcore = dconfig_getenv("dvfs_v_mode");
	if (doe_vcore) {
		dvfs_v_mode = atoi(doe_vcore);
		print("Vcore dvfs_v_mode : %d\n", dvfs_v_mode);
	}

	vcore_opp_0_uv = 750000;
	vcore_opp_1_uv = 650000;
	vcore_opp_2_uv = 600000;
	vcore_opp_3_uv = 550000;

	if (dvfs_v_mode == 3) {
		/* LV */
		rsv4 |= dvfs_v_mode << VCORE_VMODE_SHIFT;
		vcore_opp_0_uv = 712500;
		vcore_opp_1_uv = 612500;
		vcore_opp_2_uv = 568750;
		vcore_opp_3_uv = 518750;

	} else if (dvfs_v_mode == 1) {
		/* HV */
		rsv4 |= dvfs_v_mode << VCORE_VMODE_SHIFT;
		vcore_opp_0_uv = 787500;
		vcore_opp_1_uv = 687500;
		vcore_opp_2_uv = 631250;
		vcore_opp_3_uv = 581250;
	}

	mt_reg_sync_writel(rsv4, DVFSRC_BASE + 0x610);

	print("%s: VMODE=%d, RSV4=%x\n",
			__func__,
			dvfs_v_mode,
			__raw_readl(DVFSRC_BASE + 0x610));

	print("%s: FINAL vcore_opp_uv: %d, %d, %d, %d\n",
			__func__,
			vcore_opp_0_uv,
			vcore_opp_1_uv,
			vcore_opp_2_uv,
			vcore_opp_3_uv);

	set_vcore_uv_table(VCORE_OPP_0, vcore_opp_0_uv);
	set_vcore_uv_table(VCORE_OPP_1, vcore_opp_1_uv);
	set_vcore_uv_table(VCORE_OPP_2, vcore_opp_2_uv);
	set_vcore_uv_table(VCORE_OPP_3, vcore_opp_3_uv);

#ifdef DDR_RESERVE_MODE
	if (drm_is_reserve_ddr_enabled())
		dvfsrc_reserve_dump();
#endif
	/* init dvfsrc pcie setting*/
	mt_reg_sync_writel(0x4938001, DVFSRC_PCIE_VCORE_REQ);
	mt_reg_sync_writel(0x0000111, DVFSRC_PCIE_VCORE_REQ_2);
}

#ifdef DDR_RESERVE_MODE
#define DVFSRC_DUMP	(DVFSRC_BASE + 0xBF0)
#define DVFSRC_SIZE	0x100
#define DVFSRC_LAST_L	(DVFSRC_BASE + 0xAE8)
#define SPM_WDT_LATCH_0	(SPM_BASE + 0x800)

static void dvfsrc_reserve_dump(void)
{
	unsigned int i;
	unsigned val;
	int dvfsrc_success = drm_is_dvfsrc_success();
	int dvfsrc_en = drm_is_dvfsrc_enable();

	if (dvfsrc_en == 1 && dvfsrc_success == 0) {
		val = __raw_readl(SPM_WDT_LATCH_0);
		print("SPM(0x%x) = 0x%x\n", SPM_WDT_LATCH_0, val);

		val = __raw_readl(DVFSRC_LAST_L);
		print("DVFSRC(0x%x) = 0x%x\n", DVFSRC_LAST_L, val);

		for (i = 0; i < DVFSRC_SIZE; i += 4) {
			val = __raw_readl(DVFSRC_DUMP + i);
			print("DVFSRC(0x%x) = 0x%x\n", DVFSRC_DUMP + i, val);
		}
	}
}

#define DVFSRC_SW_REQ4 (DVFSRC_BASE + 0x10)
#define DVFSRC_RSRV_4 (DVFSRC_BASE + 0x610)

void disable_dvfsrc(void)
{
	unsigned val;

	mt_reg_sync_writel(0x6000, DVFSRC_SW_REQ4);
	val = __raw_readl(DVFSRC_RSRV_4);
	val |= 1 << VCORE_DRM_SHIFT;
	mt_reg_sync_writel(val, DVFSRC_RSRV_4);
	print("%s: RSV4=%x\n", __func__, __raw_readl(DVFSRC_RSRV_4));
}
#endif
