#include <typedefs.h>
#include <platform.h>
#include <pmic.h>

#define pmic_set_register_value(flagname, val) \
	pmic_config_interface(flagname##_ADDR, (val), flagname##_MASK, flagname##_SHIFT)

#define pmic_get_register_value(flagname) \
({	\
	unsigned int val = 0;	\
	pmic_read_interface(flagname##_ADDR, &val, flagname##_MASK, flagname##_SHIFT);	\
	val;	\
})

unsigned int pmic_read_efuse_nolock(int i)
{
	unsigned int efuse_data = 0;

	/* 1. enable efuse ctrl engine clock */
	pmic_config_interface(MT6330_TOP_CKHWEN_CON0_CLR, 1, PMIC_RG_EFUSE_CK_PDN_HWEN_MASK, PMIC_RG_EFUSE_CK_PDN_HWEN_SHIFT);
	pmic_config_interface(MT6330_TOP_CKPDN_CON1_CLR, 1, PMIC_RG_EFUSE_CK_PDN_MASK, PMIC_RG_EFUSE_CK_PDN_SHIFT);
	pmic_set_register_value(PMIC_RG_OTP_OSC_CK_EN_SW_SEL, 1);
	pmic_set_register_value(PMIC_RG_OTP_OSC_CK_EN_SW, 1);

	/* 2. */
	pmic_set_register_value(PMIC_RG_OTP_RD_SW, 1);
	/* 3. Set row to read */
	pmic_set_register_value(PMIC_RG_OTP_PA, i * 2);
	/* 4. Toggle RG_OTP_RD_TRIG */
	if (pmic_get_register_value(PMIC_RG_OTP_RD_TRIG) == 0)
		pmic_set_register_value(PMIC_RG_OTP_RD_TRIG, 1);
	else
		pmic_set_register_value(PMIC_RG_OTP_RD_TRIG, 0);
	/* 5. Polling RG_OTP_RD_BUSY = 0 */
	udelay(300);
	while (pmic_get_register_value(PMIC_RG_OTP_RD_BUSY) == 1)
		;
	/* 6. Read RG_OTP_DOUT_SW */
	udelay(100);
	pmic_read_interface_burst(PMIC_RG_OTP_DOUT_SW_L_ADDR, &efuse_data);
	/* 7. disable efuse ctrl engine clock */
	pmic_config_interface(MT6330_TOP_CKHWEN_CON0_SET, 1, PMIC_RG_EFUSE_CK_PDN_HWEN_MASK, PMIC_RG_EFUSE_CK_PDN_HWEN_SHIFT);
	pmic_config_interface(MT6330_TOP_CKPDN_CON1_SET, 1, PMIC_RG_EFUSE_CK_PDN_MASK, PMIC_RG_EFUSE_CK_PDN_SHIFT);
	pmic_set_register_value(PMIC_RG_OTP_OSC_CK_EN_SW_SEL, 0 );
	pmic_set_register_value(PMIC_RG_OTP_OSC_CK_EN_SW, 0 );

	return efuse_data;
}

/* PMIC EFUSE SW load need to check EFUSE_TABLE */
void pmic_efuse_sw_load(void)
{
	int VAUX18, VBG12;
	unsigned int efuse_data = 0;

	/* bit 512 ~ 527 */
	efuse_data = pmic_read_efuse_nolock(32);

	/* dump VAUX18/VBG12 TRIM value */
	VAUX18 = pmic_get_register_value(PMIC_AUXADC_EFUSE_VAUX18);
	VBG12 = pmic_get_register_value(PMIC_AUXADC_EFUSE_VBG12);
	pal_log_info("VAUX18=%d.%dmV (0x%x), VBG12=%d.%dmV (0x%x)\n",
		(18000 + VAUX18 * 5) / 10,
		(18000 + VAUX18 * 5) % 10,
		VAUX18,
		(VBG12 >> 6) ? (120500 + (VBG12 - 0x80) * 25) / 100 : (120500 + VBG12 * 25) / 100,
		(VBG12 >> 6) ? (120500 + (VBG12 - 0x80) * 25) % 100 : (120500 + VBG12 * 25) % 100,
		VBG12);

	/*768~783 for 776~778*/
	efuse_data = pmic_read_efuse_nolock(48);
	if ((pmic_get_chip_version() & 0xff) == 0x20){
		pal_log_info("pmic e2\n");
	}
	else {
		pmic_config_interface(MT6330_AUXADC_ANA_CON0, ((efuse_data & 0x0600) >> 9), 0x3, 6);
		pmic_config_interface(MT6330_AUXADC_ANA_CON1, ((efuse_data & 0x0100) >> 8), 0x1, 0);
		pal_log_info("pmic e3, efuse_data %x, rsv0 : %x, rsv1 : %x\n", efuse_data, pmic_get_register_value(PMIC_RG_AUX_RSV0), pmic_get_register_value(PMIC_RG_AUX_RSV1));
	}
}
