#include <typedefs.h>
#include <platform.h>
#include <pmic.h>
#include <regulator/mtk_regulator.h>
#include <mt6330.h>
#include <spmi.h>

/*
 * CONFIG OPTION SET
 */
/* Enable this option when pmic initial setting is verified */
#define INIT_SETTING_VERIFIED	1

/* Enable this option when pmic need efuse sw load */
/* if enable, please also check pmic_efuse.c or pmic_efuse_xxxx.c */
#define EFUSE_SW_LOAD		1


static struct pmic_setting init_setting[] = {
	{0x11, 0xA, 0xA, 0},
	{0x13, 0x1F, 0x1F, 0},
	{0x1B, 0x1, 0x1, 0},
	{0x3C, 0x0, 0xFF, 0},
	{0x3F, 0x0, 0x80, 0},
	{0x8E, 0xF0, 0xFF, 0},
	{0x91, 0x0, 0x3, 0},
	{0x10F, 0x10, 0x10, 0},
	{0x112, 0x4, 0x4, 0},
	{0x12D, 0x1, 0x1, 0},
	{0x139, 0x20, 0x20, 0},
	{0x14B, 0x3, 0x3, 0},
	{0x187, 0xFF, 0xFF, 0},
	{0x188, 0xFF, 0xFF, 0},
	{0x189, 0xFE, 0xFE, 0},
	{0x19A, 0x0, 0x1, 0},
	{0x413, 0x7, 0xFF, 0},
	{0x416, 0xD, 0xFF, 0},
	{0x417, 0x0, 0x7, 0},
	{0x418, 0x10, 0xF0, 0},
	{0x41A, 0x0, 0x20, 0},
	{0x444, 0xD, 0xFF, 0},
	{0x445, 0x0, 0x7, 0},
	{0x448, 0x0, 0x8, 0},
	{0x50C, 0x1, 0x1, 0},
	{0x557, 0x1, 0x1, 0},
	{0x790, 0x3, 0x3, 0},
	{0x796, 0x40, 0xFF, 0},
	{0x797, 0x1D, 0x3F, 0},
	{0x798, 0x40, 0xFF, 0},
	{0x799, 0x1D, 0x3F, 0},
	{0x7A7, 0xF8, 0xFC, 0},
	{0x7A8, 0x0, 0x80, 0},
	{0x7A9, 0x0, 0x2, 0},
	{0x98A, 0x10, 0x10, 0},
	{0xA08, 0x1, 0x1, 0},
	{0xA0C, 0x1, 0x3, 0},
	{0xA0E, 0x0, 0x2, 0},
	{0xA0F, 0x1, 0x1, 0},
	{0xA10, 0xE0, 0xE0, 0},
	{0xA1B, 0xFF, 0xFF, 0},
	{0xA1C, 0xFF, 0xFF, 0},
	{0xA1D, 0xFF, 0xFF, 0},
	{0xA2D, 0x54, 0x7C, 0},
	{0xA2E, 0x1, 0x1F, 0},
	{0xA2F, 0x15, 0x1F, 0},
	{0xA30, 0x2, 0x1F, 0},
	{0xA31, 0x2, 0x1F, 0},
	{0xA32, 0x3, 0x1F, 0},
	{0xA33, 0x3, 0x1F, 0},
	{0xA34, 0x4, 0x1F, 0},
	{0xA35, 0x5, 0x1F, 0},
	{0xA36, 0x6, 0x1F, 0},
	{0xA37, 0x6, 0x1F, 0},
	{0xA38, 0x7, 0x1F, 0},
	{0xA39, 0x7, 0x1F, 0},
	{0xA3A, 0x8, 0x1F, 0},
	{0xA3B, 0x8, 0x1F, 0},
	{0xA3C, 0x9, 0x1F, 0},
	{0xA3D, 0xA, 0x1F, 0},
	{0xA3E, 0x10, 0x1F, 0},
	{0xA3F, 0x10, 0x1F, 0},
	{0xA40, 0x0, 0x1F, 0},
	{0xA41, 0x11, 0x1F, 0},
	{0xA42, 0x12, 0x1F, 0},
	{0xA43, 0x13, 0x1F, 0},
	{0xA44, 0x15, 0x1F, 0},
	{0xA45, 0x14, 0x1F, 0},
	{0xA46, 0x14, 0x1F, 0},
	{0xA93, 0x1, 0x1, 0},
	{0xF8C, 0x15, 0x15, 0},
	{0xF8D, 0x5, 0x5, 0},
	{0x100B, 0x1C, 0x3C, 0},
	{0x100C, 0x1B, 0x3F, 0},
	{0x1188, 0x0, 0x80, 0},
	{0x1190, 0x13, 0xFF, 0},
	{0x1196, 0x20, 0xFF, 0},
	{0x1198, 0x60, 0x70, 0},
	{0x119B, 0x60, 0x70, 0},
	{0x11BE, 0xF, 0xF, 0},
	{0x11BF, 0x0, 0xF, 0},
	{0x140E, 0x8, 0x8, 0},
	{0x1487, 0x18, 0x7F, 0},
	{0x1507, 0x14, 0x7F, 0},
	{0x1607, 0x18, 0x7F, 0},
	{0x1687, 0x18, 0x7F, 0},
	// VS1 sleep voltage: 1.86V
	{0x1707, 0x55, 0x7F, 0},
	// VS2 sleep voltage: 1.26V
	{0x1787, 0x25, 0x7F, 0},
	// VS3 sleep voltage: 0.85V
	{0x1807, 0x48, 0x7F, 0},
	{0x1889, 0x24, 0x2C, 0},
	{0x188A, 0x8, 0xC, 0},
	{0x188B, 0x2C, 0x3F, 0},
	{0x188C, 0x1E, 0x1E, 0},
	{0x188D, 0x9F, 0xFF, 0},
	{0x188E, 0x86, 0xFF, 0},
	{0x1890, 0xC, 0x3C, 0},
	{0x1891, 0x98, 0xD8, 0},
	{0x1892, 0x4, 0xF, 0},
	{0x1894, 0x24, 0x2C, 0},
	{0x1895, 0x8, 0xC, 0},
	{0x1896, 0x2C, 0x3F, 0},
	{0x1897, 0x1E, 0x1E, 0},
	{0x1898, 0x9F, 0xFF, 0},
	{0x1899, 0x86, 0xFF, 0},
	{0x189B, 0xC, 0x3C, 0},
	{0x189C, 0x98, 0xD8, 0},
	{0x189D, 0x4, 0xF, 0},
	{0x189F, 0x6, 0x2E, 0},
	{0x18A0, 0x8, 0x8, 0},
	{0x18A1, 0x2C, 0x3F, 0},
	{0x18A2, 0x1E, 0x1E, 0},
	{0x18A3, 0xDF, 0xFF, 0},
	{0x18A4, 0x86, 0xFF, 0},
	{0x18A7, 0x49, 0x59, 0},
	{0x18A8, 0x4, 0x7, 0},
	{0x18AC, 0x8, 0x98, 0},
	{0x18AD, 0x40, 0x40, 0},
	{0x18AE, 0x58, 0x7E, 0},
	{0x18AF, 0x1E, 0x1E, 0},
	{0x18B1, 0xFF, 0xFF, 0},
	{0x18B2, 0x82, 0xFF, 0},
	{0x18B3, 0x80, 0x80, 0},
	{0x18B4, 0x9, 0x19, 0},
	{0x18B5, 0x0, 0xF, 0},
	{0x18B7, 0x8, 0x98, 0},
	{0x18B8, 0x40, 0x40, 0},
	{0x18B9, 0x58, 0x7E, 0},
	{0x18BA, 0x1E, 0x1E, 0},
	{0x18BC, 0xFF, 0xFF, 0},
	{0x18BD, 0x82, 0xFF, 0},
	{0x18BE, 0x80, 0x80, 0},
	{0x18BF, 0x9, 0x19, 0},
	{0x18C0, 0x4, 0xF, 0},
	{0x1B0D, 0xF, 0xF, 0},
	{0x1B0E, 0x1, 0x1, 0},
	{0x1B10, 0xFF, 0xFF, 0},
	{0x1B13, 0xFF, 0xFF, 0},
	{0x1B16, 0xFF, 0xFF, 0},
	{0x1B2A, 0x8, 0x8, 0},
	{0x1B89, 0x0, 0x80, 0},
	{0x1B99, 0x0, 0x80, 0},
	{0x1BA9, 0x0, 0x80, 0},
	{0x1BB9, 0x0, 0x80, 0},
	{0x1BBE, 0x40, 0x40, 0},
	{0x1BC9, 0x0, 0x80, 0},
	{0x1BCE, 0x40, 0x40, 0},
	{0x1BD9, 0x0, 0x80, 0},
	{0x1BDE, 0x40, 0x40, 0},
	{0x1C09, 0x0, 0x80, 0},
	{0x1C1A, 0x0, 0x80, 0},
	{0x1C2B, 0x0, 0x80, 0},
	{0x1C3B, 0x0, 0x80, 0},
	{0x1C4B, 0x0, 0x80, 0},
	{0x1C5B, 0x0, 0x80, 0},
	{0x1C89, 0x0, 0x80, 0},
	{0x1C99, 0x0, 0x80, 0},
	{0x1CA9, 0x0, 0x80, 0},
	{0x1CB9, 0x0, 0x80, 0},
	{0x1CC9, 0x0, 0x80, 0},
	{0x1CD9, 0x0, 0x80, 0},
	{0x1D09, 0x0, 0x80, 0},
	{0x1D19, 0x0, 0x80, 0},
	{0x1D29, 0x0, 0x80, 0},
	{0x1D89, 0x0, 0x80, 0},
	{0x1D8C, 0x10, 0x7F, 0},
	{0x1D90, 0xF, 0x7F, 0},
	{0x1D91, 0x14, 0x7F, 0},
	{0x1DA1, 0x0, 0x80, 0},
	{0x1DA4, 0x28, 0x7F, 0},
	{0x1DA8, 0xF, 0x7F, 0},
	{0x1DA9, 0x1F, 0x7F, 0},
	{0x1DB9, 0x10, 0x7F, 0},
	{0x1DBB, 0x7F, 0x7F, 0},
	{0x1E09, 0x0, 0x80, 0},
	// VSRAM_RFDIG sleep voltage: 0.6V
	{0x1E0C, 0x10, 0x7F, 0},
	{0x1E10, 0xF, 0x7F, 0},
	{0x1E11, 0x1F, 0x7F, 0},
};

static void wk_oc_thd_setting(void)
{
	u8 val = 0;
	unsigned int efuse_data = 0;

	/* bit 512 ~ 527 */
	efuse_data = pmic_read_efuse_nolock(32);
	pal_log_info("%s: efuse_data: 0x%x\n", __func__, efuse_data);

	if (efuse_data & 0x8000) {
		pal_log_info("%s: no need adjust vmdd2/vio18_2\n");
	} else {
		/*--VIO18_2--*/
		pmic_read_interface(PMIC_RG_VIO18_2_OC_TRIM_ADDR, &val,
			PMIC_RG_VIO18_2_OC_TRIM_MASK,
			PMIC_RG_VIO18_2_OC_TRIM_SHIFT);
		switch (val) {
		case 0:
			pmic_config_interface(PMIC_RG_VIO18_2_OC_TRIM_ADDR, 5,
				PMIC_RG_VIO18_2_OC_TRIM_MASK,
				PMIC_RG_VIO18_2_OC_TRIM_SHIFT);
			break;
		case 1:
			pmic_config_interface(PMIC_RG_VIO18_2_OC_TRIM_ADDR, 6,
				PMIC_RG_VIO18_2_OC_TRIM_MASK,
				PMIC_RG_VIO18_2_OC_TRIM_SHIFT);
			break;
		case 2:
			pmic_config_interface(PMIC_RG_VIO18_2_OC_TRIM_ADDR, 7,
				PMIC_RG_VIO18_2_OC_TRIM_MASK,
				PMIC_RG_VIO18_2_OC_TRIM_SHIFT);
			break;
		case 3:
			pmic_config_interface(PMIC_RG_VIO18_2_OC_TRIM_ADDR, 0,
				PMIC_RG_VIO18_2_OC_TRIM_MASK,
				PMIC_RG_VIO18_2_OC_TRIM_SHIFT);
			break;
		default:
			pal_log_info("%s: no need adjust vio18_2 oc threshold\n", __func__);
			break;
		}
		/*--VMDD2--*/
		pmic_read_interface(PMIC_RG_VMDD2_OC_TRIM_ADDR, &val,
			PMIC_RG_VMDD2_OC_TRIM_MASK,
			PMIC_RG_VMDD2_OC_TRIM_SHIFT);
		switch (val) {
		case 0:
			pmic_config_interface(PMIC_RG_VMDD2_OC_TRIM_ADDR, 4,
				PMIC_RG_VMDD2_OC_TRIM_MASK,
				PMIC_RG_VMDD2_OC_TRIM_SHIFT);
			break;
		case 1:
			pmic_config_interface(PMIC_RG_VMDD2_OC_TRIM_ADDR, 5,
				PMIC_RG_VMDD2_OC_TRIM_MASK,
				PMIC_RG_VMDD2_OC_TRIM_SHIFT);
			break;
		case 2:
			pmic_config_interface(PMIC_RG_VMDD2_OC_TRIM_ADDR, 6,
				PMIC_RG_VMDD2_OC_TRIM_MASK,
				PMIC_RG_VMDD2_OC_TRIM_SHIFT);
			break;
		case 3:
			pmic_config_interface(PMIC_RG_VMDD2_OC_TRIM_ADDR, 7,
				PMIC_RG_VMDD2_OC_TRIM_MASK,
				PMIC_RG_VMDD2_OC_TRIM_SHIFT);
			break;
		default:
			pal_log_info("%s: no need adjust vmdd2 oc threshold\n", __func__);
			break;
		}
	}
}

static void adjust_buck_vcore_oc_thd(void)
{
	pmic_config_interface(PMIC_RG_VCORE_RSV_EFUSE_ADDR, 2,
			PMIC_RG_VCORE_RSV_EFUSE_MASK,
			PMIC_RG_VCORE_RSV_EFUSE_SHIFT);
}

static void wk_rf_power_setting(void)
{
	/* VRF09 */
	pmic_config_interface(PMIC_RG_VRF09_VOSEL_ADDR, 0,
			PMIC_RG_VRF09_VOSEL_MASK,
			PMIC_RG_VRF09_VOSEL_SHIFT);
	pmic_config_interface(PMIC_RG_LDO_VRF09_OP_EN0_SET_ADDR, 0x2,
			PMIC_RG_LDO_VRF09_OP_EN0_SET_MASK,
			PMIC_RG_LDO_VRF09_OP_EN0_SET_SHIFT);
	pmic_config_interface(PMIC_RG_LDO_VRF09_OP_MODE_ADDR, 0x5,
			PMIC_RG_LDO_VRF09_OP_MODE_MASK,
			PMIC_RG_LDO_VRF09_OP_MODE_SHIFT);
	/* VRF13 */
	pmic_config_interface(PMIC_RG_VRF13_VOSEL_ADDR, 0x04,
			PMIC_RG_VRF13_VOSEL_MASK,
			PMIC_RG_VRF13_VOSEL_SHIFT);
	pmic_config_interface(PMIC_RG_LDO_VRF13_OP_EN0_SET_ADDR, 0x2,
			PMIC_RG_LDO_VRF13_OP_EN0_SET_MASK,
			PMIC_RG_LDO_VRF13_OP_EN0_SET_SHIFT);
	pmic_config_interface(PMIC_RG_LDO_VRF13_OP_MODE_ADDR, 0x5,
			PMIC_RG_LDO_VRF13_OP_MODE_MASK,
			PMIC_RG_LDO_VRF13_OP_MODE_SHIFT);
	/* VRF18 */
	pmic_config_interface(PMIC_RG_VRF18_VOSEL_ADDR, 0x06,
			PMIC_RG_VRF18_VOSEL_MASK,
			PMIC_RG_VRF18_VOSEL_SHIFT);
	pmic_config_interface(PMIC_RG_LDO_VRF18_OP_EN0_SET_ADDR, 0x2,
			PMIC_RG_LDO_VRF18_OP_EN0_SET_MASK,
			PMIC_RG_LDO_VRF18_OP_EN0_SET_SHIFT);
	pmic_config_interface(PMIC_RG_LDO_VRF18_OP_MODE_ADDR, 0x5,
			PMIC_RG_LDO_VRF18_OP_MODE_MASK,
			PMIC_RG_LDO_VRF18_OP_MODE_SHIFT);
}

static void pmic_vrc_control(void) {
	pmic_config_interface(PMIC_RG_BUCK_VMD11_SPMI_CFG_ADDR, 1,
			PMIC_RG_BUCK_VMD11_SPMI_CFG_MASK,
			PMIC_RG_BUCK_VMD11_SPMI_CFG_SHIFT);
	pmic_config_interface(PMIC_RG_BUCK_VSRAM_MD_SPMI_CFG_ADDR, 1,
			PMIC_RG_BUCK_VSRAM_MD_SPMI_CFG_MASK,
			PMIC_RG_BUCK_VSRAM_MD_SPMI_CFG_SHIFT);
	pmic_config_interface(PMIC_RG_BUCK_VRFDIG_SPMI_CFG_ADDR, 1,
			PMIC_RG_BUCK_VRFDIG_SPMI_CFG_MASK,
			PMIC_RG_BUCK_VRFDIG_SPMI_CFG_SHIFT);
}

static const struct mtk_regulator empty_regulator;
void pmic_default_voltage(void)
{
	int ret = 0;
	struct mtk_regulator reg_vsram_core = empty_regulator;
	struct mtk_regulator reg_vsram_proc = empty_regulator;
	struct mtk_regulator reg_vsram_md = empty_regulator;
	struct mtk_regulator reg_vrfdig = empty_regulator;
	struct mtk_regulator reg_vcore = empty_regulator;
	struct mtk_regulator reg_vmd11 = empty_regulator;
	int vmd11_vol = 825000;
	int vsram_md_vol = 825000;
	int vrfdig_vol = 700000;

	/*--Get regulator handle--*/
	if (mtk_regulator_get("vsram_core", &reg_vsram_core))
		ret |= (1 << 0);

	if (mtk_regulator_get("vsram_proc", &reg_vsram_proc))
		ret |= (1 << 1);

	if (mtk_regulator_get("vsram_md", &reg_vsram_md))
		ret |= (1 << 2);

	if (mtk_regulator_get("vrfdig", &reg_vrfdig))
		ret |= (1 << 3);

	if (mtk_regulator_get("vcore", &reg_vcore))
		ret |= (1 << 4);

	if (mtk_regulator_get("vmd11", &reg_vmd11))
		ret |= (1 << 5);

	if (ret) {
		pal_log_err("mtk_regulator_get failed.(0x%x)\n", ret);
		return;
	}

	/*--Set voltage--*/
	if (mtk_regulator_set_voltage(&reg_vmd11, vmd11_vol, vmd11_vol))
		ret |= (1 << 0);
	if (mtk_regulator_set_voltage(&reg_vsram_md, vsram_md_vol, vsram_md_vol))
		ret |= (1 << 1);
	if (mtk_regulator_set_voltage(&reg_vrfdig, vrfdig_vol, vrfdig_vol))
		ret |= (1 << 2);
	if (ret) {
		pal_log_err("mtk_regulator_set_voltage failed.(0x%x)\n", ret);
		ret = 0;
	}

/*
 * Bring up only, for voltage adjustment experiment
 * Modify 2nd parameter to the voltage(uV) you want
 */
#if 0
	mtk_regulator_set_voltage(&reg_vsram_core, 900000, 900000);
	mtk_regulator_set_voltage(&reg_vsram_proc, 900000, 900000);
	mtk_regulator_set_voltage(&reg_vsram_md, 900000, 900000);
	mtk_regulator_set_voltage(&reg_vsram_rfdig, 900000, 900000);
	mtk_regulator_set_voltage(&reg_vcore, 800000, 800000);
	mtk_regulator_set_voltage(&reg_vmd11, 800000, 800000);
#endif

	/*--RF LP setting--*/
	wk_rf_power_setting();

	/*--Get voltage--*/
	pal_log_info("vsram_core = %d uV\n", mtk_regulator_get_voltage(&reg_vsram_core));
	pal_log_info("vsram_proc = %d uV\n", mtk_regulator_get_voltage(&reg_vsram_proc));
	pal_log_info("vsram_md = %d uV\n", mtk_regulator_get_voltage(&reg_vsram_md));
	pal_log_info("vrfdig = %d uV\n", mtk_regulator_get_voltage(&reg_vrfdig));
	pal_log_info("vcore = %d uV\n", mtk_regulator_get_voltage(&reg_vcore));
	pal_log_info("vmd11 = %d uV\n", mtk_regulator_get_voltage(&reg_vmd11));

	/*--enable--, most regulators are default on, no need to enable it */
#if 0
	if (mtk_regulator_enable(&reg_vsram_md, 1))
		ret |= (1 << MTK_REGULATOR_VSRAM_MD);
	if (ret) {
		pal_log_err("mtk_regulator_enable failed.(0x%x)\n", ret);
		ret = 0;
	}
#endif
}

void pmic_init_setting(void)
{
	unsigned int ret = 0;
	U16 i;

	pal_log_info("[PMIC_INIT_SETTING] start\n");

#if INIT_SETTING_VERIFIED
	/* TOP_TMA_KEY */
	pmic_config_interface(PMIC_TMA_KEY_L_ADDR, 0xcf,
			      PMIC_TMA_KEY_L_MASK,
			      PMIC_TMA_KEY_L_SHIFT);
	pmic_config_interface(PMIC_TMA_KEY_H_ADDR, 0x9c,
			      PMIC_TMA_KEY_H_MASK,
			      PMIC_TMA_KEY_H_SHIFT);
	/* HK_TOP_WKEY */
	pmic_config_interface(PMIC_HK_AUXADC_KEY_L_ADDR, 0x30,
			      PMIC_HK_AUXADC_KEY_L_MASK,
			      PMIC_HK_AUXADC_KEY_L_SHIFT);
	pmic_config_interface(PMIC_HK_AUXADC_KEY_H_ADDR, 0x63,
			      PMIC_HK_AUXADC_KEY_H_MASK,
			      PMIC_HK_AUXADC_KEY_H_SHIFT);
	/* BUCK_TOP_KEY_PROT */
	pmic_config_interface(PMIC_BUCK_TOP_WRITE_KEY_LO_ADDR, 0x43,
			      PMIC_BUCK_TOP_WRITE_KEY_LO_MASK,
			      PMIC_BUCK_TOP_WRITE_KEY_LO_SHIFT);
	pmic_config_interface(PMIC_BUCK_TOP_WRITE_KEY_HI_ADDR, 0x55,
			      PMIC_BUCK_TOP_WRITE_KEY_HI_MASK,
			      PMIC_BUCK_TOP_WRITE_KEY_HI_SHIFT);
	/* PLT_KEY */
	pmic_config_interface(PMIC_PLT_WPK_KEY_ADDR, 0xcf,
			      PMIC_PLT_WPK_KEY_MASK,
			      PMIC_PLT_WPK_KEY_SHIFT);
	pmic_config_interface(PMIC_PLT_WPK_KEY_H_ADDR, 0x9c,
			      PMIC_PLT_WPK_KEY_H_MASK,
			      PMIC_PLT_WPK_KEY_H_SHIFT);
	/* CPS_WKEY */
	pmic_config_interface(PMIC_RG_CPS_W_KEY_ADDR, 0x29,
			      PMIC_RG_CPS_W_KEY_MASK,
			      PMIC_RG_CPS_W_KEY_SHIFT);
	pmic_config_interface(PMIC_RG_CPS_W_KEY_H_ADDR, 0x47,
			      PMIC_RG_CPS_W_KEY_H_MASK,
			      PMIC_RG_CPS_W_KEY_H_SHIFT);

	for (i = 0; i < ARRAY_SIZE(init_setting); i++) {
		ret = pmic_config_interface(
			init_setting[i].addr, init_setting[i].val,
			init_setting[i].mask, init_setting[i].shift);
	}

	/* Adjust buck control to SPMI-P */
	pmic_vrc_control();

	/* Adjust VMDD2 & VIO18_2 OC threshold*/
	wk_oc_thd_setting();

	/* Adjust VCORE OC threshold*/
	adjust_buck_vcore_oc_thd();

#if EFUSE_SW_LOAD
	/* PMIC SW load EFUSE to target register */
	pmic_efuse_sw_load();
#else
	pal_log_info("No EFUSE SW Load\n");
#endif

	/* TOP_TMA_KEY */
	pmic_config_interface(PMIC_TMA_KEY_L_ADDR, 0,
			      PMIC_TMA_KEY_L_MASK,
			      PMIC_TMA_KEY_L_SHIFT);
	pmic_config_interface(PMIC_TMA_KEY_H_ADDR, 0,
			      PMIC_TMA_KEY_H_MASK,
			      PMIC_TMA_KEY_H_SHIFT);
	/* HK_TOP_WKEY */
	pmic_config_interface(PMIC_HK_AUXADC_KEY_L_ADDR, 0,
			      PMIC_HK_AUXADC_KEY_L_MASK,
			      PMIC_HK_AUXADC_KEY_L_SHIFT);
	pmic_config_interface(PMIC_HK_AUXADC_KEY_H_ADDR, 0,
			      PMIC_HK_AUXADC_KEY_H_MASK,
			      PMIC_HK_AUXADC_KEY_H_SHIFT);
	/* BUCK_TOP_KEY_PROT */
	pmic_config_interface(PMIC_BUCK_TOP_WRITE_KEY_LO_ADDR, 0,
			      PMIC_BUCK_TOP_WRITE_KEY_LO_MASK,
			      PMIC_BUCK_TOP_WRITE_KEY_LO_SHIFT);
	pmic_config_interface(PMIC_BUCK_TOP_WRITE_KEY_HI_ADDR, 0,
			      PMIC_BUCK_TOP_WRITE_KEY_HI_MASK,
			      PMIC_BUCK_TOP_WRITE_KEY_HI_SHIFT);
	/* PLT_KEY */
	pmic_config_interface(PMIC_PLT_WPK_KEY_ADDR, 0,
			      PMIC_PLT_WPK_KEY_MASK,
			      PMIC_PLT_WPK_KEY_SHIFT);
	pmic_config_interface(PMIC_PLT_WPK_KEY_H_ADDR, 0,
			      PMIC_PLT_WPK_KEY_H_MASK,
			      PMIC_PLT_WPK_KEY_H_SHIFT);
	/* CPS_WKEY */
	pmic_config_interface(PMIC_RG_CPS_W_KEY_ADDR, 0,
			      PMIC_RG_CPS_W_KEY_MASK,
			      PMIC_RG_CPS_W_KEY_SHIFT);
	pmic_config_interface(PMIC_RG_CPS_W_KEY_H_ADDR, 0,
			      PMIC_RG_CPS_W_KEY_H_MASK,
			      PMIC_RG_CPS_W_KEY_H_SHIFT);

	pal_log_info("[PMIC_INIT_SETTING] done v200804\n");
	pmic_config_interface(0x11BE, 0x4F, 0x4F, 0);
#endif
	pmic_default_voltage();

	pmic_config_interface(PMIC_RG_WDT_VOSEL_DBG_EN_ADDR, 1,
			      PMIC_RG_WDT_VOSEL_DBG_EN_MASK,
			      PMIC_RG_WDT_VOSEL_DBG_EN_SHIFT);
}
