//#include <project.h>
#include <spm_mtcmos.h>
//#include <cmessage.h>
//#include <API.h>
//#include "API_DELAY.h"

#ifdef FORCE_ENABLE_ACK_CHK
#elif  FORCE_BYPASS_ACK_CHK
  #define IGNORE_MTCMOS_CHECK
#elif  ENABLE_ACK_CHK
#elif  BYPASS_ACK_CHK
  #define IGNORE_MTCMOS_CHECK
#else
#endif

#define UINT32 unsigned int
#define UINT32P unsigned int*
#define  SPM_PROJECT_CODE    0xB16

/* Define MTCMOS power control */
#define PWR_RST_B                        (0x1 << 0)
#define PWR_ISO                          (0x1 << 1)
#define PWR_ON                           (0x1 << 2)
#define PWR_ON_2ND                       (0x1 << 3)
#define PWR_CLK_DIS                      (0x1 << 4)
#define SRAM_CKISO                       (0x1 << 5)
#define DORMANT_ENABLE                   (0x1 << 6)
#define SRAM_ISOINT_B                    (0x1 << 6)
#define VPROC_EXT_OFF                    (0x1 << 7)
#define SLPB_CLAMP                       (0x1 << 7)

/* Define MTCMOS Bus Protect Mask */
#define MD1_PROT_STEP1_0_MASK            ((0x1 << 7))
#define MD1_PROT_STEP1_0_ACK_MASK        ((0x1 << 7))
#define MD1_PROT_STEP2_0_MASK            ((0x1 << 2)|(0x1 << 10))
#define MD1_PROT_STEP2_0_ACK_MASK        ((0x1 << 2)|(0x1 << 10))
#define MD1_PROT_STEP2_1_MASK            ((0x1 << 6))
#define MD1_PROT_STEP2_1_ACK_MASK        ((0x1 << 6))
#define DIS_PROT_STEP1_0_MASK            ((0x1 << 10))
#define DIS_PROT_STEP1_0_ACK_MASK        ((0x1 << 10))
#define DIS_PROT_STEP2_0_MASK            ((0x1 << 6))
#define DIS_PROT_STEP2_0_ACK_MASK        ((0x1 << 6))

/* Define MTCMOS Power Status Mask */

#define MD1_PWR_STA_MASK                 (0x1 << 0)
#define DIS_PWR_STA_MASK                 (0x1 << 20)
#define HSMTOP_PWR_STA_MASK              (0x1 << 23)

/* Define CPU SRAM Mask */

/* Define Non-CPU SRAM Mask */
#define MD1_SRAM_PDN                     (0x1 << 8)
#define MD1_SRAM_PDN_ACK                 (0x0 << 12)
#define MD1_SRAM_PDN_ACK_BIT0            (0x1 << 12)
#define DIS_SRAM_PDN                     (0x1 << 8)
#define DIS_SRAM_PDN_ACK                 (0x1 << 12)
#define DIS_SRAM_PDN_ACK_BIT0            (0x1 << 12)
#define HSMTOP_SRAM_PDN                  (0x1 << 8)
#define HSMTOP_SRAM_PDN_ACK              (0x0 << 12)
#define HSMTOP_SRAM_PDN_ACK_BIT0         (0x1 << 12)
#define HSMTOP_SRAM_SLEEP_B              (0x1 << 9)
#define HSMTOP_SRAM_SLEEP_B_ACK          (0x1 << 13)
#define HSMTOP_SRAM_SLEEP_B_ACK_BIT0     (0x1 << 13)

unsigned int spm_read(UINT32P reg_addr)
{
  unsigned int rdata;
  rdata = *((UINT32P)(reg_addr));
  return rdata;
}

void spm_write(UINT32P reg_addr, unsigned int wdata)
{
  *((UINT32P)(reg_addr)) = wdata;
}

int check_efuse(int id)
{
  unsigned int tmp;
  static const char * const mtcmos[] = {
		"mfg0",
		"eth",
		"netsys",
		"dis",
		"audio",
		"eip97",
		"md1",
		"conn",
		"ssusb",
		"sgmii_0",
		"sgmii_1",
		"pextp_d_2lx1",
		"pextp_r_2lx1",
		"pextp_r_1lx2",
		"dramc_md32",
		"hsmtop",
	};

  tmp = seclib_get_devinfo_with_index(7);
  if(tmp&(0x1 << id)){
    dbg_print("efuse of id : %s is 1\n",mtcmos[id]);
    return 1;
  }
	else
		return 0;
}

int spm_mtcmos_ctrl_md1(int state)
{
  int err = 0;

  err = check_efuse(6);
	if(err)
		return err;

  spm_write(POWERON_CONFIG_EN, (SPM_PROJECT_CODE << 16) | (0x1 << 0));

  if (state == STA_POWER_DOWN) {
      spm_write(INFRA_TOPAXI_PROTECTEN_SET, MD1_PROT_STEP1_0_MASK);
      while ((spm_read(INFRA_TOPAXI_PROTECTEN_STA1) & MD1_PROT_STEP1_0_ACK_MASK) 
          != MD1_PROT_STEP1_0_ACK_MASK)
              ;
      spm_write(INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_SET, MD1_PROT_STEP2_0_MASK);
      while ((spm_read(INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_STA1) & MD1_PROT_STEP2_0_ACK_MASK)
          != MD1_PROT_STEP2_0_ACK_MASK)
              ;
      spm_write(INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1_SET, MD1_PROT_STEP2_1_MASK);
      while ((spm_read(INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1_STA1) & MD1_PROT_STEP2_1_ACK_MASK)
          != MD1_PROT_STEP2_1_ACK_MASK)
              ;
      spm_write(MD1_PWR_CON, spm_read(MD1_PWR_CON) & ~PWR_ON);
      while (spm_read(PWR_STATUS) & MD1_PWR_STA_MASK)
          ;
      spm_write(MD_EXT_BUCK_ISO_CON, spm_read(MD_EXT_BUCK_ISO_CON) | (0x1 << 0));
      spm_write(MD_EXT_BUCK_ISO_CON, spm_read(MD_EXT_BUCK_ISO_CON) | (0x1 << 1));
      spm_write(MD1_PWR_CON, spm_read(MD1_PWR_CON) & ~PWR_RST_B);
  } else {
      spm_write(MD_EXT_BUCK_ISO_CON, spm_read(MD_EXT_BUCK_ISO_CON) & ~(0x1 << 0));
      spm_write(MD_EXT_BUCK_ISO_CON, spm_read(MD_EXT_BUCK_ISO_CON) & ~(0x1 << 1));
      spm_write(MD1_PWR_CON, spm_read(MD1_PWR_CON) | PWR_RST_B);
      spm_write(MD1_PWR_CON, spm_read(MD1_PWR_CON) | PWR_ON);
      while ((spm_read(PWR_STATUS) & MD1_PWR_STA_MASK) != MD1_PWR_STA_MASK)
          ;
      spm_write(INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_CLR, MD1_PROT_STEP2_0_MASK);
      spm_write(INFRA_TOPAXI_PROTECTEN_INFRA_VDNR_1_CLR, MD1_PROT_STEP2_1_MASK);
      spm_write(INFRA_TOPAXI_PROTECTEN_CLR, MD1_PROT_STEP1_0_MASK);
  }
  return err;
}

int spm_mtcmos_ctrl_dis(int state)
{
  int err = 0;

  err = check_efuse(3);
	if(err)
		return err;

  spm_write(POWERON_CONFIG_EN, (SPM_PROJECT_CODE << 16) | (0x1 << 0));

  if (state == STA_POWER_DOWN) {
      spm_write(INFRA_TOPAXI_PROTECTEN_MM_SET, DIS_PROT_STEP1_0_MASK);
      while ((spm_read(INFRA_TOPAXI_PROTECTEN_MM_STA1) & DIS_PROT_STEP1_0_ACK_MASK)
          != DIS_PROT_STEP1_0_ACK_MASK)
              ;
      spm_write(INFRA_TOPAXI_PROTECTEN_SET, DIS_PROT_STEP2_0_MASK);
      while ((spm_read(INFRA_TOPAXI_PROTECTEN_STA1) & DIS_PROT_STEP2_0_ACK_MASK)
          != DIS_PROT_STEP2_0_ACK_MASK)
              ;
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) | DIS_SRAM_PDN);
      while ((spm_read(DIS_PWR_CON) & DIS_SRAM_PDN_ACK) != DIS_SRAM_PDN_ACK)
          ;
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) | PWR_ISO);
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) | PWR_CLK_DIS);
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) & ~PWR_RST_B);
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) & ~PWR_ON);
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) & ~PWR_ON_2ND);
      while ((spm_read(PWR_STATUS) & DIS_PWR_STA_MASK)
          || (spm_read(PWR_STATUS_2ND) & DIS_PWR_STA_MASK))
              ;
  } else {
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) | PWR_ON);
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) | PWR_ON_2ND);
      while (((spm_read(PWR_STATUS) & DIS_PWR_STA_MASK) != DIS_PWR_STA_MASK)
          || ((spm_read(PWR_STATUS_2ND) & DIS_PWR_STA_MASK) != DIS_PWR_STA_MASK))
              ;
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) & ~PWR_CLK_DIS);
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) & ~PWR_ISO);
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) | PWR_RST_B);
      spm_write(DIS_PWR_CON, spm_read(DIS_PWR_CON) & ~(0x1 << 8));
      while (spm_read(DIS_PWR_CON) & DIS_SRAM_PDN_ACK_BIT0)
          ;
      spm_write(INFRA_TOPAXI_PROTECTEN_CLR, DIS_PROT_STEP2_0_MASK);
      spm_write(INFRA_TOPAXI_PROTECTEN_MM_CLR, DIS_PROT_STEP1_0_MASK);
  }
  return err;
}

int spm_mtcmos_ctrl_hsmtop(int state)
{
	int err = 0;

	err = check_efuse(15);
	if(err)
		return err;

	spm_write(POWERON_CONFIG_EN, (SPM_PROJECT_CODE << 16) | (0x1 << 0));

	if (state == STA_POWER_DOWN) {
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) | HSMTOP_SRAM_PDN);
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) | PWR_ISO);
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) | PWR_CLK_DIS);
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) & ~PWR_RST_B);
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) & ~PWR_ON);
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) & ~PWR_ON_2ND);
		while ((spm_read(PWR_STATUS) & HSMTOP_PWR_STA_MASK)
		       || (spm_read(PWR_STATUS_2ND) & HSMTOP_PWR_STA_MASK))
				   ;
	} else {
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) | PWR_ON);
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) | PWR_ON_2ND);
		while (((spm_read(PWR_STATUS) & HSMTOP_PWR_STA_MASK) != HSMTOP_PWR_STA_MASK)
		       || ((spm_read(PWR_STATUS_2ND) & HSMTOP_PWR_STA_MASK) != HSMTOP_PWR_STA_MASK))
		   ;
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) & ~PWR_CLK_DIS);
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) & ~PWR_ISO);
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) | PWR_RST_B);
		spm_write(HSMTOP_PWR_CON, spm_read(HSMTOP_PWR_CON) & ~(0x1 << 8));
	}
	return err;
}
