/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2019. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */
/*
 * MTK SPMI Driver
 *
 * Copyright 2018 MediaTek Co.,Ltd.
 *
 * DESCRIPTION:
 *     This file provides API for other drivers to access PMIC registers
 *
 */

#include <spmi.h>
#include <pmif.h>
#include <pmif_sw.h>
#include <spmi_sw.h>
#include <pmif_clkmgr.h>

int mt6xxx_spmi_regs[] = {
	[SPMI_OP_ST_CTRL] =		0x0000,
	[SPMI_GRP_ID_EN] =		0x0004,
	[SPMI_OP_ST_STA] =		0x0008,
	[SPMI_SAMPL_CTRL] =		0x000c,
	[SPMI_REQ_EN] =			0x0010,
	[SPMI_RCS_CTRL] =		0x0014,
	[SPMI_SLV_3_0_EINT] =		0x0020,
	[SPMI_SLV_7_4_EINT] =		0x0024,
	[SPMI_SLV_B_8_EINT] =		0x0028,
	[SPMI_SLV_F_C_EINT] =		0x002c,
	[SPMI_REC_CTRL] =		0x0040,
	[SPMI_REC0] =			0x0044,
	[SPMI_REC1] =			0x0048,
	[SPMI_REC2] =			0x004c,
	[SPMI_REC3] =			0x0050,
	[SPMI_REC4] =			0x0054,
	[SPMI_REC_CMD_DEC] =		0x005C,
	[SPMI_DEC_DBG] =		0x00f8,
	[SPMI_MST_DBG] =		0x00fc,
};

static struct pmif *pmif_spmi_arb_ctrl[SPMI_MASTER_MAX];
struct spmi_device spmi_dev[] = {
	{
#if CFG_FPGA_PLATFORM
		.slvid = SPMI_SLAVE_0,
#else
		.slvid = SPMI_SLAVE_4,
#endif
		.grpiden = 0x1 << 0xB,
		.type = MAIN_PMIC,
		.type_id = MAIN_PMIC_ID,
		.mstid = SPMI_MASTER_1,/* spmi-m */
		.hwcid_addr = 0x0009,
		.hwcid_val = 0x30,
		.swcid_addr = 0x000B,
		.swcid_val = 0x30,
		.wpk_key_addr = 0x3A7,
		.wpk_key_val = 0x9CCF,
		.tma_key_addr = 0x39E,
		.tma_key_val = 0x9CCF,
		.pmif_arb = NULL,
	}, {
#if CFG_FPGA_PLATFORM
		.slvid = SPMI_SLAVE_0,
#else
		.slvid = SPMI_SLAVE_4,
#endif
		.grpiden = 0x1 << 0xB,
		.type = BUCK_MD,
		.type_id = BUCK_MD_ID,
		.mstid = SPMI_MASTER_P_1,/* spmi-p */
		.hwcid_addr = 0x01AC, /* TOP_VRCTL_VOSEL_VBUCK0 */
		.hwcid_val = 0x38, /* 0.75V = 0x38 */
		.pmif_arb = NULL,
#ifdef EXT_BUCK_MT6315
	}, {
		.slvid = SPMI_SLAVE_5,
		.grpiden = 0x1 << 0xB,
		.type = BUCK_CPU,
		.type_id = BUCK_CPU_ID,
		.mstid = SPMI_MASTER_1,/* spmi-m */
		.hwcid_addr = 0x09,
		.hwcid_val = 0x15,
		.swcid_addr = 0x0b,
		.swcid_val = 0x15,
		.wpk_key_addr = 0x3A8,
		.wpk_key_val = 0x6315,
		.tma_key_addr = 0x39F,
		.tma_key_val = 0x9CEA,
		.pmif_arb = NULL,
#endif
	},
};
unsigned char spmi_device_cnt;

/* spmi internal API declaration */
static int spmi_register_rw_set_extaddr(struct spmi_device *dev,
		unsigned int ext_addr, unsigned int ext_addr_h,
		unsigned int addr, bool en);
static int spmi_config_io(int mstid, int driving);
static int spmi_config_master(int mstid, bool en);
static int spmi_config_slave(int mstid, struct spmi_device *dev);
static int spmi_cali_rd_clock_polarity(int mstid, struct spmi_device *dev);
static int spmi_ctrl_op_st(int mstid, unsigned int grpiden,
	unsigned int sid, unsigned int cmd);
static int spmi_read_check(struct spmi_device *dev);
#if SPMI_DEBUG
static int spmi_rw_test(struct spmi_device *dev);
static int spmi_drv_ut(struct spmi_device *dev, unsigned int ut);
#endif
void spmi_lock_slave_reg(struct spmi_device *dev);
void spmi_unlock_slave_reg(struct spmi_device *dev);

#if SPMI_NO_PMIC
int spmi_init(struct pmif *pmif_arb)
{
	SPMI_INFO("do Nothing.\n");
	return 0;
}

#else /* #ifdef SPMI_NO_PMIC */
/*
 * Function : mtk_spmi_readl()
 * Description : mtk spmi controller read api
 * Parameter :
 * Return :
 */
u32 spmi_readl(int mstid, enum spmi_regs reg)
{
	struct pmif *arb = get_pmif_controller(PMIF_SPMI, mstid);

	return DRV_Reg32(arb->spmimst_base + arb->spmimst_regs[reg]);
}

/*
 * Function : mtk_spmi_writel()
 * Description : mtk spmi controller write api
 * Parameter :
 * Return :
 */
void spmi_writel(int mstid, enum spmi_regs reg, unsigned int val)
{
	struct pmif *arb = get_pmif_controller(PMIF_SPMI, mstid);

	DRV_WriteReg32(arb->spmimst_base + arb->spmimst_regs[reg], val);
}

/*
 * Function : spmi_lock_slave_reg()
 * Description : protect spmi slv register to be write
 * Parameter :
 * Return :
 */
void spmi_lock_slave_reg(struct spmi_device *dev)
{
	u16 wdata = 0;

	/* enable wpk_key, write 0x0 */
	spmi_ext_register_writel(dev, dev->wpk_key_addr, &wdata, 2);
	/* enable tma_key, write 0x0 */
	spmi_ext_register_writel(dev, dev->tma_key_addr, &wdata, 2);
}

/*
 * Function : spmi_unlock_slave_reg()
 * Description : unlock spmi slv register to write
 * Parameter :
 * Return :
 */
void spmi_unlock_slave_reg(struct spmi_device *dev)
{
	/* disable wpk_key */
	spmi_ext_register_writel(dev, dev->wpk_key_addr, &dev->wpk_key_val, 2);
	/* disable tma_key */
	spmi_ext_register_writel(dev, dev->tma_key_addr, &dev->tma_key_val, 2);
}

static int spmi_config_io(int mstid, int driving)
{
	if (driving == 2) {
		/* 0'b000
		 * SPMI_SCL[20:18]; SPMI_SDA[23:21]
		 * SPMI_P_SCL[26:24]; SPMI_P_SDA[29:27]
		 */
		DRV_WriteReg32(SPMI_SCL_DRV_ADDR + 8, 0x7 << SPMI_SCL_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SDA_DRV_ADDR + 8, 0x7 << SPMI_SDA_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SCL_DRV_ADDR + 8, 0x7 << SPMI_SCL_P_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SDA_DRV_ADDR + 8, 0x7 << SPMI_SDA_P_DRV_OFFSET);
	} else if (driving == 4) {
		/* 0'b001
		 * SPMI_SCL[20:18]; SPMI_SDA[23:21]
		 * SPMI_P_SCL[26:24]; SPMI_P_SDA[29:27]
		 */
		DRV_WriteReg32(SPMI_SCL_DRV_ADDR + 4, 0x1 << SPMI_SCL_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SCL_DRV_ADDR + 8, 0x6 << SPMI_SCL_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SDA_DRV_ADDR + 4, 0x1 << SPMI_SDA_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SDA_DRV_ADDR + 8, 0x6 << SPMI_SDA_DRV_OFFSET);

		DRV_WriteReg32(SPMI_SCL_DRV_ADDR + 4, 0x1 << SPMI_SCL_P_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SCL_DRV_ADDR + 8, 0x6 << SPMI_SCL_P_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SDA_DRV_ADDR + 4, 0x1 << SPMI_SDA_P_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SDA_DRV_ADDR + 8, 0x6 << SPMI_SDA_P_DRV_OFFSET);
	} else if (driving == 6) {
		/* 0'b010
		 * SPMI_SCL[20:18]; SPMI_SDA[23:21]
		 * SPMI_P_SCL[26:24]; SPMI_P_SDA[29:27]
		 */
		DRV_WriteReg32(SPMI_SCL_DRV_ADDR + 4, 0x2 << SPMI_SCL_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SCL_DRV_ADDR + 8, 0x5 << SPMI_SCL_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SDA_DRV_ADDR + 4, 0x2 << SPMI_SDA_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SDA_DRV_ADDR + 8, 0x5 << SPMI_SDA_DRV_OFFSET);

		DRV_WriteReg32(SPMI_SCL_DRV_ADDR + 4, 0x2 << SPMI_SCL_P_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SCL_DRV_ADDR + 8, 0x5 << SPMI_SCL_P_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SDA_DRV_ADDR + 4, 0x2 << SPMI_SDA_P_DRV_OFFSET);
		DRV_WriteReg32(SPMI_SDA_DRV_ADDR + 8, 0x5 << SPMI_SDA_P_DRV_OFFSET);
	}
	/* EH_CHG0, SPMI_SCL[22:18]=0; SPMI_SDA[27:23]=0 */
	DRV_WriteReg32(IOCFG_BM_EH_CFG0_CLR, 0x3FF << 18);
	/* EH_CHG0, SPMI_P_SCL[4:0]=0; SPMI_P_SDA[9:5]=0 */
	DRV_WriteReg32(IOCFG_BM_EH_CFG1_CLR, 0x3FF);
	/* RDSEL_CFG1, SPMI_SCL[3:2]=0; SPMI_SCL[5:4]=0 */
	/* RDSEL_CFG1, SPMI_P_SCL[7:6]=0; SPMI_P_SCL[9:8]=0 */
	DRV_WriteReg32(IOCFG_BM_RDSEL_CFG1_CLR, 0xFF << 2);
	/* TDSEL_CFG1, SPMI_SCL[7:4]=0; SPMI_SCL[11:8]=0 */
	/* TDSEL_CFG1, SPMI_SCL[15:12]=0; SPMI_SCL[19:16]=0 */
	DRV_WriteReg32(IOCFG_BM_TDSEL_CFG2_CLR, 0xFFFF << 4);
#if 0 /* These GPIO setting should be set by dws, no need to implement at here*/
	/* IES_CFG0, SPMI_SCL[24]=0; SPMI_SCL[25]=1 */
	DRV_WriteReg32(IOCFG_LM_IES_CFG0_CLR, 0x1 << 24);
	DRV_WriteReg32(IOCFG_LM_IES_CFG0_SET, 0x1 << 25);
	/* PD_CFG0, SPMI_SCL[24]=0; SPMI_SCL[25]=0 */
	DRV_WriteReg32(IOCFG_LM_PD_CFG0_CLR, 0x3 << 24);
	/* PU_CFG0, SPMI_SCL[24]=0; SPMI_SCL[25]=0 */
	DRV_WriteReg32(IOCFG_LM_PU_CFG0_CLR, 0x3 << 24);
	/* SMT_CFG0, SPMI_SCL[9]=1; SPMI_SCL[10]=1 */
	DRV_WriteReg32(IOCFG_LM_SMT_CFG0_SET, 0x3 << 9);
#endif
	return 0;
}

static int spmi_config_master(int mstid, bool en)
{
	switch (mstid) {
	case SPMI_MASTER_1:
		/* Software reset */
		DRV_WriteReg32(WDT_SWSYSRST2, (0x85 << 24) | (0x1 << 4));
#if !CFG_FPGA_PLATFORM
		DRV_WriteReg32(CLK_CFG_6_CLR, (0x7 << 16) | (0x1 << 20) | (0x1 << 23));
		DRV_WriteReg32(CLK_CFG_6_SET, 0x3 << 16);
		DRV_WriteReg32(CLK_CFG_UPDATE, 0x1 << 26);
#endif
		/* Software reset */
		DRV_WriteReg32(WDT_SWSYSRST2, (0x85 << 24));
		break;
	case SPMI_MASTER_P_1:
#if !CFG_FPGA_PLATFORM
		DRV_WriteReg32(CLK_CFG_6_CLR, (0xF << 24) | (0x1 << 28) | (0x1 << 31));
		DRV_WriteReg32(CLK_CFG_6_SET, 0x7 << 24);
		DRV_WriteReg32(CLK_CFG_UPDATE, 0x1 << 27);
#endif
		break;
	}

	/* Enable SPMI */
	spmi_writel(mstid, SPMI_REQ_EN, en);

	SPMI_INFO("%s done\n", __func__);

	return 0;
}

static int spmi_config_slave(int mstid, struct spmi_device *dev)
{
	u8 wdata = 0;

	switch (dev->slvid) {
#if CFG_FPGA_PLATFORM
	case SPMI_SLAVE_0:
#else
	case SPMI_SLAVE_4:
#endif
		/* set RG_RCS_ID=slave id */
		spmi_ext_register_writel(dev, 0x419, &dev->slvid, 1);
		/* set RG_RCS_ENABLE=1, RG_RCS_ID=Master ID */
		wdata = 0x5 | (mstid << 4);
		spmi_ext_register_writel(dev, 0x418, &wdata, 1);
		break;
	default:
		SPMI_DBG("%s slvid:%d no rcs\n", __func__, dev->slvid);
		break;
	}
	return 0;
}

static int spmi_cali_rd_clock_polarity(int mstid, struct spmi_device *dev)
{
	unsigned int i;
	struct cali cali_data[] = {
		{SPMI_CK_NO_DLY, SPMI_CK_POL_POS},
		{SPMI_CK_NO_DLY, SPMI_CK_POL_NEG},
		{SPMI_CK_DLY_1T, SPMI_CK_POL_POS},
		{SPMI_CK_DLY_1T, SPMI_CK_POL_NEG}
	};

	/* Indicate sampling clock polarity, 1: Positive 0: Negative  */
	for (i = 0; i < ARRAY_SIZE(cali_data); i++) {
		spmi_writel(mstid, SPMI_SAMPL_CTRL,
			(cali_data[i].dly << 0x1) | cali_data[i].pol);
		/* for exception reboot, we only call UT/spmi_read_check w/o
		 * write test. It avoid to affect exception record.
		 */
		if (spmi_read_check(dev) == 0) {
			SPMI_CRI("non-rcs dly:%d, pol:%d, sampl:0x%x\n",
					cali_data[i].dly, cali_data[i].pol,
					spmi_readl(mstid, SPMI_SAMPL_CTRL));
			break;
		}
	}
	if (i == ARRAY_SIZE(cali_data)) {
		SPMI_ERR("%s FATAL ERROR\n", __func__);
		/* ASSERT(0); */
	}

	return 0;
}

static int spmi_cali_rd_clock_polarity_rcs(int mstid, struct spmi_device *dev)
{
	unsigned int i, non_rcs_cali_dly;
	struct cali cali_data[] = {
		{SPMI_CK_NO_DLY, SPMI_CK_POL_POS},
		{SPMI_CK_NO_DLY, SPMI_CK_POL_NEG},
		{SPMI_CK_DLY_1T, SPMI_CK_POL_POS},
		{SPMI_CK_DLY_1T, SPMI_CK_POL_NEG},
		{SPMI_CK_DLY_2T, SPMI_CK_POL_POS},
		{SPMI_CK_DLY_2T, SPMI_CK_POL_NEG}
	};

	non_rcs_cali_dly = spmi_readl(mstid, SPMI_SAMPL_CTRL) & 0xE;
	/* Indicate sampling clock polarity, 1: Positive 0: Negative  */
	for (i = 0; i < ARRAY_SIZE(cali_data); i++) {
		spmi_writel(mstid, SPMI_SAMPL_CTRL,
			non_rcs_cali_dly | (cali_data[i].dly << 4) | cali_data[i].pol);
		/* for exception reboot, we only call UT/spmi_read_check w/o
		 * write test. It avoid to affect exception record.
		 */
		if (spmi_read_check(dev) == 0) {
			SPMI_CRI("rcs_en dly:%d, pol:%d, sampl:0x%x\n",
					cali_data[i].dly, cali_data[i].pol,
					spmi_readl(mstid, SPMI_SAMPL_CTRL));
			break;
		}
	}
	if (i == ARRAY_SIZE(cali_data)) {
		SPMI_ERR("%s FATAL ERROR\n", __func__);
		/* ASSERT(0); */
	}

	return 0;
}

#if SPMI_EXTADDR_SUPPORT
static int spmi_register_zero_write_extaddr(struct spmi_device *dev,
		unsigned int ext_addr, unsigned int ext_addr_h,
		unsigned int addr, unsigned char data)
{
	unsigned char wdata = 0;

	spmi_unlock_slave_reg(dev);

	/* assign specific addr */
	/* ext_addr = MT6315_PMIC_RG_EXTADR_REG0_W_ADDR */
	wdata = (addr & 0xff);
	spmi_ext_register_writel(dev, ext_addr, &wdata, 1);
	/* ext_addr_h = MT6315_PMIC_RG_EXTADR_REG0_W_H_ADDR */
	wdata = ((addr >> 8) & 0xff);
	spmi_ext_register_writel(dev, ext_addr_h, &wdata, 1);

	spmi_lock_slave_reg(dev);

	return dev->pmif_arb->write_cmd(dev->pmif_arb, SPMI_CMD_ZERO_WRITE,
					dev->slvid, addr, &data, 1);
}

static int spmi_register_zero_write_set_extaddr(struct spmi_device *dev,
		unsigned int ext_addr, unsigned int ext_addr_h,
		unsigned int addr, bool en)
{
	unsigned char wdata = 0;

	spmi_unlock_slave_reg(dev);

	if (en == true) {
		/* assign specific addr */
		/* ext_addr = MT6315_PMIC_RG_EXTADR_REG0_W_ADDR */
		wdata = (addr & 0xff);
		spmi_ext_register_writel(dev, ext_addr, &wdata, 1);
		/* ext_addr_h = MT6315_PMIC_RG_EXTADR_REG0_W_H_ADDR */
		wdata = ((addr >> 8) & 0xff);
		spmi_ext_register_writel(dev, ext_addr_h, &wdata, 1);
	} else {
		/* assign specific addr */
		wdata = 0;
		spmi_ext_register_writel(dev, ext_addr, &wdata, 1);
		spmi_ext_register_writel(dev, ext_addr_h, &wdata, 1);
	}

	spmi_lock_slave_reg(dev);

	return 0;
}

static int spmi_register_read_extaddr(struct spmi_device *dev,
		unsigned int ext_addr, unsigned int ext_addr_h,
		unsigned int addr, unsigned char *buf)
{
	unsigned char wdata = 0;

	spmi_unlock_slave_reg(dev);

	/* assign specific addr */
	wdata = ((addr >> 5) & 0xff);
	spmi_ext_register_writel(dev, ext_addr, &wdata, 1);
	wdata = (((addr >> 5) & 0xff00) >> 8);
	spmi_ext_register_writel(dev, ext_addr_h, &wdata, 1);

	spmi_lock_slave_reg(dev);

	return dev->pmif_arb->read_cmd(dev->pmif_arb, SPMI_CMD_READ,
					dev->slvid, addr, buf, 1);
}

static int spmi_register_write_extaddr(struct spmi_device *dev,
		unsigned int ext_addr, unsigned int ext_addr_h,
		unsigned int addr, unsigned char data)
{
	unsigned char wdata = 0;

	spmi_unlock_slave_reg(dev);

	/* assign specific addr */
	wdata = ((addr >> 5) & 0xff);
	spmi_ext_register_writel(dev, ext_addr, &wdata, 1);
	wdata = (((addr >> 5) & 0xff00) >> 8);
	spmi_ext_register_writel(dev, ext_addr_h, &wdata, 1);

	spmi_lock_slave_reg(dev);

	return dev->pmif_arb->write_cmd(dev->pmif_arb, SPMI_CMD_WRITE,
					dev->slvid, addr, &data, 1);
}

static int spmi_ext_register_read_extaddr(struct spmi_device *dev,
		unsigned int ext_addr, unsigned int addr,
		unsigned char *buf, unsigned short len)
{
	unsigned char wdata = 0;

	spmi_unlock_slave_reg(dev);

	/* assign specific addr */
	/* ext_addr = MT6315_PMIC_RG_EXTADR_EXT_REG_RW_ADDR */
	wdata = ((addr >> 8) & 0xff);
	spmi_ext_register_writel(dev, ext_addr, &wdata, 1);

	spmi_lock_slave_reg(dev);

	return dev->pmif_arb->read_cmd(dev->pmif_arb, SPMI_CMD_EXT_READ,
					dev->slvid, addr, buf, len);
}

static int spmi_ext_register_write_extaddr(struct spmi_device *dev,
		unsigned int ext_addr, unsigned int addr,
		const unsigned char *buf, unsigned short len)
{
	unsigned char wdata = 0;

	spmi_unlock_slave_reg(dev);

	/* assign specific addr */
	/* ext_addr = MT6315_PMIC_RG_EXTADR_EXT_REG_RW_ADDR */
	wdata = ((addr >> 8) & 0xff);
	spmi_ext_register_writel(dev, ext_addr, &wdata, 1);

	spmi_lock_slave_reg(dev);

	return dev->pmif_arb->write_cmd(dev->pmif_arb, SPMI_CMD_EXT_WRITE,
					dev->slvid, addr, buf, len);
}

static int spmi_ext_register_rw_set_extaddr(struct spmi_device *dev,
		unsigned int ext_addr, unsigned int addr, bool en)
{
	unsigned char wdata = 0;

	spmi_unlock_slave_reg(dev);

	/* ext_addr = MT6315_PMIC_RG_EXTADR_EXT_REG_RW_ADDR */
	if (en == true) {
		wdata = ((addr >> 8) & 0xff);
		spmi_ext_register_writel(dev, ext_addr, &wdata, 1);
	} else {
		wdata = 0;
		spmi_ext_register_writel(dev, ext_addr, &wdata, 1);
	}

	spmi_lock_slave_reg(dev);

	return 0;
}
#else
/* exclusive api, extaddr api need permission to add here. */
static int spmi_register_rw_set_extaddr(struct spmi_device *dev,
		unsigned int ext_addr, unsigned int ext_addr_h,
		unsigned int addr, bool en)
{
	unsigned char wdata = 0;

	spmi_unlock_slave_reg(dev);

	if (en == true) {
		/* assign specific addr */
		wdata = ((addr >> 5) & 0xff);
		spmi_ext_register_writel(dev, ext_addr, &wdata, 1);
		wdata = (((addr >> 5) & 0xff00) >> 8);
		spmi_ext_register_writel(dev, ext_addr_h, &wdata, 1);
	} else {
		/* assign specific addr */
		wdata = 0;
		spmi_ext_register_writel(dev, ext_addr, &wdata, 1);
		spmi_ext_register_writel(dev, ext_addr_h, &wdata, 1);
	}

	spmi_lock_slave_reg(dev);

	return 0;
}
#endif /* end of SPMI_EXTADDR_SUPPORT */

static int spmi_ctrl_op_st(int mstid, unsigned int grpiden, unsigned int sid,
		unsigned int cmd)
{
	unsigned int rdata = 0x0;

	/* gid is 0x800 */
	spmi_writel(mstid, SPMI_GRP_ID_EN, grpiden);
#if MT63xx_EVB
	if (grpiden == (1 << SPMI_GROUP_ID))
		spmi_writel(mstid, SPMI_OP_ST_CTRL,
			(cmd << 0x4) | SPMI_GROUP_ID);
#else
	if (grpiden == 0x100)
		spmi_writel(mstid, SPMI_OP_ST_CTRL, (cmd << 0x4) | 0x8);
#endif
	else
		spmi_writel(mstid, SPMI_OP_ST_CTRL, (cmd << 0x4) | sid);

	SPMI_WARN("spmi_ctrl_op_st 0x%x\n", spmi_readl(mstid, SPMI_OP_ST_CTRL));

	do
	{
		rdata = spmi_readl(mstid, SPMI_OP_ST_STA);
		SPMI_DBG("spmi_ctrl_op_st 0x%x\n", rdata);

		if (((rdata >> 0x1) & SPMI_OP_ST_NACK) == SPMI_OP_ST_NACK) {
			spmi_dump_mst_record_reg(mstid);
			break;
		}
		}while((rdata & SPMI_OP_ST_BUSY) == SPMI_OP_ST_BUSY);

	return 0;
}

int spmi_command_reset(int mstid, struct spmi_device *dev, unsigned int grpiden)
{
#if MT63xx_EVB
	if (grpiden != (1 << SPMI_GROUP_ID))
		dev->slvid = grpiden;
#else
	if (grpiden != 0x100)
		dev->slvid = grpiden;
#endif
	return spmi_ctrl_op_st(mstid, grpiden, dev->slvid, SPMI_RESET);
}
int spmi_command_sleep(int mstid, struct spmi_device *dev, unsigned int grpiden)
{
#if MT63xx_EVB
	if (grpiden != (1 << SPMI_GROUP_ID))
		dev->slvid = grpiden;
#else
	if (grpiden != 0x100)
		dev->slvid = grpiden;
#endif
	return spmi_ctrl_op_st(mstid, grpiden, dev->slvid, SPMI_SLEEP);
}
int spmi_command_wakeup(int mstid, struct spmi_device *dev, unsigned int grpiden)
{
#if MT63xx_EVB
	if (grpiden != (1 << SPMI_GROUP_ID))
		dev->slvid = grpiden;
#else
	if (grpiden != 0x100)
		dev->slvid = grpiden;
#endif
	return spmi_ctrl_op_st(mstid, grpiden, dev->slvid, SPMI_WAKEUP);
}
int spmi_command_shutdown(int mstid, struct spmi_device *dev, unsigned int grpiden)
{
#if MT63xx_EVB
	if (grpiden != (1 << SPMI_GROUP_ID))
		dev->slvid = grpiden;
#else
	if (grpiden != 0x100)
		dev->slvid = grpiden;
#endif
	return spmi_ctrl_op_st(mstid, grpiden, dev->slvid, SPMI_SHUTDOWN);
}

int spmi_enable_group_id(int mstid, unsigned int grpiden)
{
	spmi_writel(mstid, SPMI_GRP_ID_EN, grpiden);

	return 0;
}

static int spmi_read_check(struct spmi_device *dev)
{
	u8 rdata = 0;

	spmi_ext_register_readl(dev, dev->hwcid_addr, &rdata, 1);
	if (rdata != dev->hwcid_val) {
		SPMI_ERR("%s next, slvid:%d rdata = 0x%x.\n",
			__func__, dev->slvid, rdata);
		return -EIO;
	} else
		SPMI_CRI("%s done, slvid:%d\n", __func__, dev->slvid);

	return 0;
}

#if SPMI_DEBUG
static int spmi_rw_test(struct spmi_device *dev)
{
	unsigned int rdata = 0, backup;
	u8 wdata[] = {0xAB, 0xCD};
	int i, ret;

	if (dev->mstid == SPMI_MASTER_P_1) {
		SPMI_INFO("SPMI-P doesn't do %s\n", __func__);
		return 0;
	}
	spmi_ext_register_readl(dev, dev->wpk_key_addr, &rdata, 1);
	backup = rdata;
	for (i = 0; i < ARRAY_SIZE(wdata); i++) {
		spmi_ext_register_writel(dev, dev->wpk_key_addr, &wdata[i], 1);
		spmi_ext_register_readl(dev, dev->wpk_key_addr, &rdata, 1);
		if (rdata != wdata[i]) {
			SPMI_ERR("%s fail, slvid:%d, rdata = 0x%x\n",
				__func__, dev->slvid, rdata);
			return -EIO;
		}
	}
	spmi_ext_register_writel(dev, dev->wpk_key_addr, &backup, 1);

	return 0;
}

static int spmi_drv_ut(struct spmi_device *dev, unsigned int ut)
{
	int ret = 0;

	switch (ut) {
		case 1:
			ret = spmi_rw_test(dev);
			break;
		case 2:
			ret = spmi_read_check(dev);
			break;
		case 3:
			break;
		default:
			break;
	}

	return ret;
}
#endif /* end of #if SPMI_DEBUG */

struct spmi_device *get_spmi_device(int mstid, int slaveid)
{
	unsigned int i;

	for (i = 0; i < spmi_device_cnt; i++) {
		if (slaveid == spmi_dev[i].slvid) {
			return &spmi_dev[i];
		}
	}

	return NULL;
}

static void wk_mt6330_driving(struct spmi_device *sdev)
{
	u8 data = 0;

	if (sdev->mstid == SPMI_MASTER_1 && sdev->slvid == SPMI_SLAVE_4) {
		/* pause debug log feature by setting RG_DEBUG_DIS_TRIG 0->1->0 */
		/*
		 * RG_DEBUG_DIS_TRIG_ADDR=0x42C
		 * RG_DEBUG_DIS_TRIG_SHIFT=0x7
		 */
		data = 0x1 << 7;
		spmi_ext_register_writel(sdev, 0x42C, &data, 1);
		data = 0;
		spmi_ext_register_writel(sdev, 0x42C, &data, 1);

		/* driving setting */
		spmi_ext_register_readl(sdev, 0x14E, &data, 1);
		spmi_unlock_slave_reg(sdev);
		data |= (0xF); /* RG_SPMI_x_SCL_E22 and RG_SPMI_x_SDA_E22 */
		spmi_ext_register_writel(sdev, 0x14E, &data, 1);
		spmi_lock_slave_reg(sdev);
	}
}

int spmi_init(struct pmif *pmif_arb)
{
	int i, ret = 0;

	if (pmif_arb == NULL) /* null check */ {
		SPMI_ERR("arguments err\n");
		return -EINVAL;
	}

	pmif_arb->spmimst_regs = mt6xxx_spmi_regs;
	pmif_spmi_arb_ctrl[pmif_arb->mstid] = pmif_arb;
	spmi_device_cnt = ARRAY_SIZE(spmi_dev);

	/* config IOCFG */
	spmi_config_io(pmif_arb->mstid, 6);
	spmi_config_master(pmif_arb->mstid, TRUE);
	for (i = 0; i < spmi_device_cnt; i++) {
		if (pmif_arb->mstid == spmi_dev[i].mstid) {
			spmi_dev[i].pmif_arb = pmif_spmi_arb_ctrl[pmif_arb->mstid];
#ifdef EXT_BUCK_MT6315
			/* set SPMI slave driving for MT6890 platform */
			wk_mt6330_driving(&spmi_dev[i]);
#endif
			/* non-rcs calibration */
			spmi_cali_rd_clock_polarity(pmif_arb->mstid, &spmi_dev[i]);
#if SPMI_MONITOR_SUPPORT
			/* dump 1st time slave debug register when booting */
			if (spmi_dev[i].mstid == SPMI_MASTER_1 &&
			    spmi_dev[i].slvid == SPMI_SLAVE_4) {
				mt6330_dump_record_reg(&spmi_dev[i]);
				udelay(10);
			}
#endif
			/* rcs related config */
			switch (spmi_dev[i].mstid) {
			case SPMI_MASTER_1:
				/* config slave, include enable slave rcs */
				spmi_config_slave(pmif_arb->mstid, &spmi_dev[i]);
				/* enable master rcs support */
				spmi_writel(pmif_arb->mstid, SPMI_RCS_CTRL, 0x5);
				/* rcs calibration */
				spmi_cali_rd_clock_polarity_rcs(pmif_arb->mstid, &spmi_dev[i]);
				break;
			case SPMI_MASTER_P_1:
				/* SPMI-P no rcs, no need to enable slave/master rcs */
				spmi_writel(pmif_arb->mstid, SPMI_RCS_CTRL, 0x1);
				break;
			}
#if SPMI_DEBUG
			ret = spmi_drv_ut(&spmi_dev[i], 1);
			if(ret) {
				SPMI_ERR("EIO err\n");
				return ret;
			}
#endif
		}
	}
	SPMI_INFO("%s done\n", __func__);

	return 0;
}

#endif /* #ifdef SPMI_NO_PMIC */
