/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2019. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */
/******************************************************************************
 * MTK TIA Driver
 *
 * Copyright 2019 MediaTek Co.,Ltd.
 *
 * DESCRIPTION:
 *     This file init TIA for GPS/MD to get temperature data from PMIC
 *
 ******************************************************************************/

#include <tia.h>

#define DLY_CODE(us_dly)	(us_dly) * 26

void tia_init(void)
{
	DRV_WriteReg32(TIA2_ADC_INI_DLY, DLY_CODE(1540)); /* 1.54ms */
	DRV_WriteReg32(TIA2_RC_30K_DLY, DLY_CODE(462)); /* 0.462ms */
	DRV_WriteReg32(TIA2_RC_100K_DLY, DLY_CODE(1540)); /* 1.54ms */
	DRV_WriteReg32(TIA2_RC_400K_DLY, DLY_CODE(6160)); /* 6.16ms */
	DRV_WriteReg32(TIA2_ADC15_CON_DLY, DLY_CODE(1210)); /* 1.21ms */
	DRV_WriteReg32(TIA2_ADC12_30K_CON_DLY, DLY_CODE(6138)); /* 6.138ms */
	DRV_WriteReg32(TIA2_ADC12_100K_CON_DLY, DLY_CODE(5060)); /* 5.06ms */
	DRV_WriteReg32(TIA2_ADC12_400K_CON_DLY0, DLY_CODE(2860)); /* 2.86ms */
	DRV_WriteReg32(TIA2_ADC12_400K_CON_DLY1, DLY_CODE(4290)); /* 4.29ms */
	DRV_WriteReg32(TIA2_ADC12_CON_SRCLK, DLY_CODE(1760)); /* 1.76ms */
	/*
	 * SDMADC_CON0 = 0x11BD
	 * SDMADC_CON0[2:0]: 0/1/2/3/4 => TSX/T0/T1/T2/T3
	 * SDMADC_CON0[4:3]: 0/1/2/ => 100K/30K/400K
	 * SDMADC_CON0[5]: 0/1 => TSX/DCXO
	 * SDMADC_CON0[7]: 0/1 => small AVG/larger AVG
	 */
	DRV_WriteReg32(TIA2_ADC_SET_ADDR, 0x11BD);
	/* TSX with RC */
	DRV_WriteReg32(TIA2_TSX_100K_CMD, 0x4F80);
	DRV_WriteReg32(TIA2_TSX_30K_CMD, 0x4F88);
	DRV_WriteReg32(TIA2_TSX_400K_CMD, 0x4F90);
	/* DCXO */
	DRV_WriteReg32(TIA2_ADC15_DCXO_CMD, 0x4FA0);
	DRV_WriteReg32(TIA2_ADC12_DCXO_CMD, 0x4F80);
	/* T0 with RC */
	DRV_WriteReg32(TIA2_T0_100K_CMD, 0x4F81);
	DRV_WriteReg32(TIA2_T0_30K_CMD, 0x4F89);
	DRV_WriteReg32(TIA2_T0_400K_CMD, 0x4F91);
	/* T1 with RC */
	DRV_WriteReg32(TIA2_T1_100K_CMD, 0x4F82);
	DRV_WriteReg32(TIA2_T1_30K_CMD, 0x4F8A);
	DRV_WriteReg32(TIA2_T1_400K_CMD, 0x4F92);
	/* T2 with RC */
	DRV_WriteReg32(TIA2_T2_100K_CMD, 0x4F83);
	DRV_WriteReg32(TIA2_T2_30K_CMD, 0x4F8B);
	DRV_WriteReg32(TIA2_T2_400K_CMD, 0x4F93);
	/* T3 with RC */
	DRV_WriteReg32(TIA2_T3_100K_CMD, 0x4F84);
	DRV_WriteReg32(TIA2_T3_30K_CMD, 0x4F8C);
	DRV_WriteReg32(TIA2_T3_400K_CMD, 0x4F94);

	DRV_WriteReg32(TIA2_ADC15_TRIG_ADDR, 0x110D); /* SDMADC_RQST_CH0 ADDR */
	DRV_WriteReg32(TIA2_ADC15_TRIG_CMD, 0x1); /* SDMADC_RQST_CH0 SHIFT */
	DRV_WriteReg32(TIA2_ADC15_READ_ADDR, 0x10E8); /* SDMADC_ADC_OUT_CH0_L ADDR */

	DRV_WriteReg32(TIA2_ADC12_TRIG_ADDR, 0x110A); /* AUXADC_RQST_CH7_BY_GPS ADDR */
	DRV_WriteReg32(TIA2_ADC12_TRIG_CMD0, 0x10); /* AUXADC_RQST_CH7_BY_GPS SHIFT */
	DRV_WriteReg32(TIA2_ADC12_TRIG_CMD1, 0x50); /* AUXADC_RQST_CH7_BY_GPS + AUXADC_RQST_DCXO_BY_GPS SHIFT */
	DRV_WriteReg32(TIA2_ADC12_READ_ADDR0, 0x10A2); /* AUXADC_ADC_OUT_CH7_BY_GPS_L ADDR */
	DRV_WriteReg32(TIA2_ADC12_READ_ADDR1, 0x10BC); /* AUXADC_ADC_OUT_DCXO_BY_GPS_L ADDR */

	/*
	 * SPMI_CMD = 0x3
	 * SPMI_PMIFID = 0x0 for SPMI-M
	 * SPMI_BYTECNT = 0x1
	 * SPMI_SLVID = 0x4 for MT6330
	 */
	DRV_WriteReg32(TIA2_SPMI_CMD, 0x4B);
	DRV_WriteReg32(TIA2_MODE_CTRL, 0x23); /* sel TIA 2.0, enable GPS RC, enable TIA */
	TIA_CRI("TIA init done\n");
}
