#include "utils/includes.h"

#include "utils/common.h"
#include "utils/eloop.h"
#include "utils/uuid.h"
#include "common/wpa_ctrl.h"
#include "common/ieee802_11_defs.h"
#include "common/ieee802_11_common.h"
#include "eapol_auth/eapol_auth_sm.h"
#include "eapol_auth/eapol_auth_sm_i.h"
#include "wps/wps.h"
#include "wps/wps_i.h"
#include "wps/wps_defs.h"
#include "wps/wps_dev_attr.h"
#include "wps/wps_attr_parse.h"
#include "ap/hostapd.h"
#include "ap/ap_config.h"
#include "ap/ap_drv_ops.h"
#include "ap/beacon.h"
#include "ap/sta_info.h"
#include "ap/wps_hostapd.h"
#include "wps_custom_nec.h"

#include <regex.h>

int check_encryption_support(const ENCRYPTION_SUPPORT_CHECK *enc_sup_check_tbl,
			 u16 auth, u16 encr, u32 support_type,
			 u16 *set_auth, u16 *set_encr)
{
    int i = 0;
    int j = 0;

    for (i = 0; (enc_sup_check_tbl+i)->cred_auth_type != 0; i++) {
        if (auth == (enc_sup_check_tbl+i)->cred_auth_type && encr == (enc_sup_check_tbl+i)->cred_encr_type) {
            for (j = 0; (enc_sup_check_tbl+i)->enc_sup_tbl[j].support_type != 0; j++) {
                if (support_type & (enc_sup_check_tbl+i)->enc_sup_tbl[j].support_type) {
                    *set_auth = (enc_sup_check_tbl+i)->enc_sup_tbl[j].auth_type;
                    *set_encr = (enc_sup_check_tbl+i)->enc_sup_tbl[j].encr_type;
                    return 0;
                }
            }
        }
    }

    return -1;
}

u8 get_key_mgmt(u16 set_auth)
{
    int key_mgmt = 0;

    switch (set_auth) {
    case WPS_AUTH_OPEN:
        key_mgmt = WPA_KEY_MGMT_NONE;
        break;
    case WPS_AUTH_WPAPSK:
    case WPS_AUTH_WPA2PSK:
    case WPS_AUTH_WPA_WPA2:
        key_mgmt = WPA_KEY_MGMT_PSK;
        break;
    default:
        key_mgmt = 0;
        wpa_printf(MSG_ERROR, "%s: key_mgmt is 0(set_auth=%d)", __func__, set_auth);
        break;
    }

    return key_mgmt;
}

u8 get_proto(u16 set_auth)
{
    u8 proto = 0;

    switch (set_auth) {
    case WPS_AUTH_OPEN:
        proto = 0;
        break;
    case WPS_AUTH_WPAPSK:
        proto = WPA_PROTO_WPA;
        break;
    case WPS_AUTH_WPA2PSK:
        proto = WPA_PROTO_RSN;
        break;
    case WPS_AUTH_WPA_WPA2:
        proto = WPA_PROTO_MIX;
        break;
    default:
        proto = 0;
        wpa_printf(MSG_ERROR, "%s: proto is 0(set_auth=%d)", __func__, set_auth);
        break;
    }

    return proto;
}

u8 get_cipher(u16 set_encr)
{
    u8 cipher = 0;

    switch (set_encr) {
    case WPS_ENCR_NONE:
        cipher = WPA_CIPHER_NONE;
        break;
    case WPS_ENCR_TKIP:
        cipher = WPA_CIPHER_TKIP;
        break;
    case WPS_ENCR_AES:
        cipher = WPA_CIPHER_CCMP;
        break;
    case WPS_ENCR_TKIP_AES:
        cipher = WPA_CIPHER_MIX;
        break;
    default:
        cipher = 0;
        wpa_printf(MSG_ERROR, "%s: cipher is 0(set_encr=%d)", __func__, set_encr);
        break;
    }

    return cipher;
}

int check_str(const char *strings, const char *ptrn)
{
    regex_t reg;
    int err;

    if ((err = regcomp(&reg, ptrn, REG_EXTENDED))) {
        wpa_printf(MSG_ERROR, "CONFIG: %s: regcomp Error[%d]",
                   __func__, err);
        return -1;
    }

    if ((err = regexec(&reg, strings, 0, NULL, 0))) {
        regfree(&reg);
        wpa_printf(MSG_ERROR, "CONFIG: %s: regexec Error[%d]",
                   __func__, err);
        return -1;
    }

    regfree(&reg);

    return 0;
}
