#ifndef _WPS_CUSTOM_NEC_H_
#define _WPS_CUSTOM_NEC_H_

#include "ap/hostapd.h"

/* Support Encryption Type */
#define SUPPORT_NO_ENCR                 0x0001
#define SUPPORT_WEP                     0x0002
#define SUPPORT_WPA_PSK_TKIP            0x0010
#define SUPPORT_WPA2_PSK_TKIP           0x0020
#define SUPPORT_WPA_WPA2_PSK_TKIP       0x0040
#define SUPPORT_WPA_PSK_AES             0x0080
#define SUPPORT_WPA2_PSK_AES            0x0100
#define SUPPORT_WPA_WPA2_PSK_AES        0x0200
#define SUPPORT_WPA_WPA2_PSK_TKIP_AES   0x0400
#define PRIORITY_NUM                    (9+1)

#define WPS_AUTH_WPA_WPA2 (WPS_AUTH_WPAPSK | WPS_AUTH_WPA2PSK)
#define WPS_ENCR_TKIP_AES (WPS_ENCR_TKIP | WPS_ENCR_AES)

#define WPA_PROTO_MIX   (WPA_PROTO_WPA|WPA_PROTO_RSN)
#define WPA_CIPHER_MIX  (WPA_CIPHER_CCMP|WPA_CIPHER_TKIP)

typedef struct {
  const u32 support_type;
  const u16 auth_type;
  const u16 encr_type;
} ENCRYPTION_SUPPORT;

typedef struct {
  const u16 cred_auth_type;
  const u16 cred_encr_type;
  ENCRYPTION_SUPPORT enc_sup_tbl[PRIORITY_NUM];
} ENCRYPTION_SUPPORT_CHECK;

void nec_init_wps_encryption(int encryption_support,struct wps_context *wps);

int check_encryption_support(const ENCRYPTION_SUPPORT_CHECK *enc_sup_check_tbl,
			 u16 auth, u16 encr, u32 enc_sup,
			     u16 *set_auth, u16 *set_encr);

u8 get_key_mgmt(u16 set_auth);
u8 get_proto(u16 set_auth);
u8 get_cipher(u16 set_encr);

/* Character String Check */
#define CHECKSTR_WEPKEY_ASCII           "^(([a-zA-Z0-9]{5})|([a-zA-Z0-9]{13}))\\??$"
#define CHECKSTR_WEPKEY_HEX             "^(([a-fA-F0-9]{10})|([a-fA-F0-9]{26}))\\??$"
#define CHECKSTR_PSKKEY                 "^(([!->@-~]{8,63})|([a-fA-F0-9]{64}))\\??$"
#define CHECKSTR_SSID                   "^[a-zA-Z0-9_-]{1,32}\\??$"

#define VS_AP_CHECKSTR_PSKKEY           "^(([!-~]{8,63})|([a-fA-F0-9]{64}))\\??$"
#define VS_AP_CHECKSTR_SSID             "^[ -~]{1,32}\\??$"
#define VS_STA_CHECKSTR_PSKKEY          "^(([!->@-~]{8,63})|([a-fA-F0-9]{64}))\\??$"
#define VS_STA_CHECKSTR_SSID            "^[a-zA-Z0-9_-]{1,32}\\??$"

#ifdef USE_TRANS_WIFI_CFG
#define TRANS_WIFI_CHECKSTR_PSKKEY      "^(([!-~]{8,63})|([a-fA-F0-9]{64}))\\??$"
#endif

#define CHECKLEN_WEPKEY_64_ASCII        5
#define CHECKLEN_WEPKEY_64_HEX          10
#define CHECKLEN_WEPKEY_128_ASCII       13
#define CHECKLEN_WEPKEY_128_HEX         26

int check_str(const char *strings, const char *ptrn);

#endif /* _WPS_CUSTOM_NEC_H_ */

