#include "includes.h"

#include "common.h"
#include "crypto/random.h"
#include "crypto/sha1.h"
#include "eapol_supp/eapol_supp_sm.h"
#include "eap_peer/eap.h"
#include "eap_peer/eap_proxy.h"
#include "eap_server/eap_methods.h"
#include "rsn_supp/wpa.h"
#include "eloop.h"
#include "config.h"
#include "utils/ext_password.h"
#include "l2_packet/l2_packet.h"
#include "wpa_supplicant_i.h"
#include "driver_i.h"
#include "ctrl_iface.h"
#include "pcsc_funcs.h"
#include "common/version.h"
#include "rsn_supp/preauth.h"
#include "rsn_supp/pmksa_cache.h"
#include "common/wpa_ctrl.h"
#include "common/ieee802_11_defs.h"
#include "common/hw_features_common.h"
#include "p2p/p2p.h"
#include "fst/fst.h"
//#include "blacklist.h"
#include "wpas_glue.h"
#include "wps_supplicant.h"
#include "ibss_rsn.h"
#include "sme.h"
#include "gas_query.h"
#include "ap.h"
#include "p2p_supplicant.h"
#include "wifi_display.h"
#include "notify.h"
#include "bgscan.h"
#include "autoscan.h"
#include "bss.h"
#include "scan.h"
#include "offchannel.h"
#include "hs20_supplicant.h"
#include "wnm_sta.h"
#include "wpas_kay.h"
#include "mesh.h"
#include "wps_custom_nec.h"
#include "wps_custom_nec_sta.h"

#ifdef USE_WLANAPI
#include <libwlanapi.h>
#endif

ENCRYPTION_SUPPORT_CHECK enc_sup_check_tbl_vs_ap[] = {
    {WPS_AUTH_OPEN, WPS_ENCR_NONE, {
            {SUPPORT_NO_ENCR, WPS_AUTH_OPEN, WPS_ENCR_NONE},
            {0, 0, 0}}},
    {WPS_AUTH_WPAPSK, WPS_ENCR_TKIP, {
            {SUPPORT_WPA_PSK_TKIP, WPS_AUTH_WPAPSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {0, 0, 0}}},
    {WPS_AUTH_WPAPSK, WPS_ENCR_AES, {
            {SUPPORT_WPA_PSK_AES, WPS_AUTH_WPAPSK, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {0, 0, 0}}},
    {WPS_AUTH_WPAPSK, WPS_ENCR_TKIP_AES, {
            {SUPPORT_WPA_PSK_AES, WPS_AUTH_WPAPSK, WPS_ENCR_AES},
            {SUPPORT_WPA_PSK_TKIP, WPS_AUTH_WPAPSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {0, 0, 0}}},
    {WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP, {
            {SUPPORT_WPA2_PSK_TKIP, WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {0, 0, 0}}},
    {WPS_AUTH_WPA2PSK, WPS_ENCR_AES, {
            {SUPPORT_WPA2_PSK_AES, WPS_AUTH_WPA2PSK, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {0, 0, 0}}},
    {WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP_AES, {
            {SUPPORT_WPA2_PSK_AES, WPS_AUTH_WPA2PSK, WPS_ENCR_AES},
            {SUPPORT_WPA2_PSK_TKIP, WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {0, 0, 0}}},
    {WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP, {
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {SUPPORT_WPA2_PSK_TKIP, WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_PSK_TKIP, WPS_AUTH_WPAPSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {0, 0, 0}}},
    {WPS_AUTH_WPA_WPA2, WPS_ENCR_AES, {
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {SUPPORT_WPA2_PSK_AES, WPS_AUTH_WPA2PSK, WPS_ENCR_AES},
            {SUPPORT_WPA_PSK_AES, WPS_AUTH_WPAPSK, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {0, 0, 0}}},
    {WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES, {
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {SUPPORT_WPA2_PSK_AES, WPS_AUTH_WPA2PSK, WPS_ENCR_AES},
            {SUPPORT_WPA2_PSK_TKIP, WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_PSK_AES, WPS_AUTH_WPAPSK, WPS_ENCR_AES},
            {SUPPORT_WPA_PSK_TKIP, WPS_AUTH_WPAPSK, WPS_ENCR_TKIP},
            {0, 0, 0}}},
    {0, 0, {
            {0, 0, 0}}},
};

ENCRYPTION_SUPPORT_CHECK enc_sup_check_tbl_vs_sta[] = {
    {WPS_AUTH_OPEN, WPS_ENCR_NONE, {
            {SUPPORT_NO_ENCR, WPS_AUTH_OPEN, WPS_ENCR_NONE},
            {0, 0, 0}}},
    {WPS_AUTH_WPAPSK, WPS_ENCR_TKIP, {
            {SUPPORT_WPA_PSK_TKIP, WPS_AUTH_WPAPSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {0, 0, 0}}},
    {WPS_AUTH_WPAPSK, WPS_ENCR_AES, {
            {SUPPORT_WPA_PSK_AES, WPS_AUTH_WPAPSK, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {0, 0, 0}}},
    {WPS_AUTH_WPAPSK, WPS_ENCR_TKIP_AES, {
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {SUPPORT_WPA_PSK_AES, WPS_AUTH_WPAPSK, WPS_ENCR_AES},
            {SUPPORT_WPA_PSK_TKIP, WPS_AUTH_WPAPSK, WPS_ENCR_TKIP},
            {0, 0, 0}}},
    {WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP, {
            {SUPPORT_WPA2_PSK_TKIP, WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {0, 0, 0}}},
    {WPS_AUTH_WPA2PSK, WPS_ENCR_AES, {
            {SUPPORT_WPA2_PSK_AES, WPS_AUTH_WPA2PSK, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {0, 0, 0}}},
    {WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP_AES, {
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {SUPPORT_WPA2_PSK_AES, WPS_AUTH_WPA2PSK, WPS_ENCR_AES},
            {SUPPORT_WPA2_PSK_TKIP, WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {0, 0, 0}}},
    {WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP, {
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {SUPPORT_WPA2_PSK_TKIP, WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_PSK_TKIP, WPS_AUTH_WPAPSK, WPS_ENCR_TKIP},
            {0, 0, 0}}},
    {WPS_AUTH_WPA_WPA2, WPS_ENCR_AES, {
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {SUPPORT_WPA2_PSK_AES, WPS_AUTH_WPA2PSK, WPS_ENCR_AES},
            {SUPPORT_WPA_PSK_AES, WPS_AUTH_WPAPSK, WPS_ENCR_AES},
            {0, 0, 0}}},
    {WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES, {
            {SUPPORT_WPA_WPA2_PSK_TKIP_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP_AES},
            {SUPPORT_WPA_WPA2_PSK_AES, WPS_AUTH_WPA_WPA2, WPS_ENCR_AES},
            {SUPPORT_WPA_WPA2_PSK_TKIP, WPS_AUTH_WPA_WPA2, WPS_ENCR_TKIP},
            {SUPPORT_WPA2_PSK_AES, WPS_AUTH_WPA2PSK, WPS_ENCR_AES},
            {SUPPORT_WPA2_PSK_TKIP, WPS_AUTH_WPA2PSK, WPS_ENCR_TKIP},
            {SUPPORT_WPA_PSK_AES, WPS_AUTH_WPAPSK, WPS_ENCR_AES},
            {SUPPORT_WPA_PSK_TKIP, WPS_AUTH_WPAPSK, WPS_ENCR_TKIP},
            {0, 0, 0}}},
    {0, 0, {
            {0, 0, 0}}},
};

static char * auth2str(const u16 auth_type)
{
    switch(auth_type) {
    case WPS_AUTH_WPAPSK:
        return "WPA-PSK";
    case WPS_AUTH_WPA2PSK:
        return "WPA2-PSK";
    case WPS_AUTH_WPA_WPA2:
        return "WPA/WPA2-PSK";
    case WPS_AUTH_OPEN:
        return "OPEN";
    default:
        return "ERR";
    }
}

static char * encr2str(const u16 encr_type)
{
    switch(encr_type) {
    case WPS_ENCR_TKIP:
        return "TKIP";
    case WPS_ENCR_AES:
        return "AES";
    case WPS_ENCR_TKIP_AES:
        return "TKIP/AES";
    case WPS_ENCR_NONE:
        return "NONE";
    default:
        return "ERR";
    }
}

int cfg_wps_vs_ap_enc_sup_get(const struct wps_credential *cred, u32 enc_sup,
			  u16 *set_auth, u16 *set_encr)
{
    int ret;

    wpa_printf(MSG_DEBUG, "WPS: AP's encryption <%s %s>", auth2str(cred->auth_type), encr2str(cred->encr_type));

    ret = check_encryption_support(enc_sup_check_tbl_vs_ap, cred->auth_type, cred->encr_type,
                                    enc_sup, set_auth, set_encr);
    if (ret == 0)
	    wpa_printf(MSG_DEBUG, "WPS: set encryption <%s %s>", auth2str(*set_auth), encr2str(*set_encr));

    return ret;
}

int cfg_wps_vs_sta_enc_sup_get(const struct wps_credential *cred, u32 enc_sup,
                           u16 *set_auth, u16 *set_encr)
{
    int ret;

    wpa_printf(MSG_DEBUG, "WPS: AP's encryption <%s %s>", auth2str(cred->auth_type), encr2str(cred->encr_type));

    ret = check_encryption_support(enc_sup_check_tbl_vs_sta, cred->auth_type, cred->encr_type,
                                    enc_sup, set_auth, set_encr);
    if (ret == 0)
        wpa_printf(MSG_DEBUG, "WPS: set encryption <%s %s>", auth2str(*set_auth), encr2str(*set_encr));

    return ret;
}

int cfg_wps_essid_str_check(const struct wps_credential *cred, int vs_sta)
{
    char ssid[CONFIG_SSID_LEN];
    const char *checkstr_ssid = VS_AP_CHECKSTR_SSID;
    const char *debug_msg = "VS_AP";

    if (vs_sta) {
        checkstr_ssid = VS_STA_CHECKSTR_SSID;
        debug_msg = "VS_STA";
    }

    /* ESSID STR CHECK*/
    os_memset(ssid, 0, sizeof(ssid));
    os_memcpy(ssid, cred->ssid, cred->ssid_len);

    if (check_str(ssid, checkstr_ssid)) {
        wpa_printf(MSG_ERROR, "WPS: %s: SSID STR ERR (%s) (%s)",
                   __func__, debug_msg, ssid);
        return -1;
    }

    return 0;
}

int cfg_wps_enckey_str_check(struct wpa_supplicant *wpa_s, const struct wps_credential *cred, int vs_sta)
{
    char key[CONFIG_NETWORK_KEY_LEN];
    const char *checkstr_pskkey = VS_AP_CHECKSTR_PSKKEY;
    const char *debug_msg = "VS_AP";

    if (vs_sta) {
        checkstr_pskkey = VS_STA_CHECKSTR_PSKKEY;
        debug_msg = "VS_STA";
    }

#ifdef USE_TRANS_WIFI_CFG
    if (libwlanapi_get_trans_wifi_cfg_state(wpa_s->ifname) == TRANS_WIFI_CFG_START) {
        checkstr_pskkey = TRANS_WIFI_CHECKSTR_PSKKEY;
        debug_msg = "TRANS_WIFI_CFG";
    }
#endif

    /* ENC KEY STR CHECK*/
    if (!(cred->auth_type & WPS_AUTH_WPA_WPA2)) {
        wpa_printf(MSG_DEBUG, "WPS: %s: NOT ENCKEY (%s)",
                   __func__, debug_msg);
        return 0;
    }

    os_memset(key, 0, sizeof(key));
    os_memcpy(key, cred->key, cred->key_len);

    if (check_str(key, checkstr_pskkey)) {
        wpa_printf(MSG_ERROR, "WPS: %s: ENCKEY STR ERR (%s) (%s)",
                   __func__, debug_msg, key);
        return -1;
    }

    return 0;
}



/* #################WPA_SUPPLICANT CALLED#################### */
int wps_cred_is_assoc_ap_config(struct wpa_supplicant *wpa_s,const struct wps_credential *cred)
{
    wpa_printf(MSG_INFO, "WPS: Assoc AP ESSID[%.*s]",
               wpa_s->current_bss->ssid_len, wpa_s->current_bss->ssid);

    wpa_printf(MSG_DEBUG, "WPS: Cred ESSID[%.*s]",cred->ssid_len, cred->ssid);

    if (os_strcmp((char *)cred->ssid, (char *)wpa_s->current_bss->ssid) == 0) {
        wpa_printf(MSG_DEBUG, "WPS: ASSOC AP ESSID Found!!");
        return 1;
    }
    return 0;
}

#ifdef USE_WLANAPI
static u32 get_enc_sup(u32 support_enc)
{
	u32 enc_sup = 0;

	if (support_enc & LIBWLANAPI_SUPPORT_NO_ENCR)
		enc_sup |= SUPPORT_NO_ENCR;

	if (support_enc & LIBWLANAPI_SUPPORT_WPA_PSK_TKIP)
		enc_sup |= SUPPORT_WPA_PSK_TKIP;

	if (support_enc & LIBWLANAPI_SUPPORT_WPA2_PSK_TKIP)
		enc_sup |= SUPPORT_WPA2_PSK_TKIP;

	if (support_enc & LIBWLANAPI_SUPPORT_WPA_WPA2_PSK_TKIP)
		enc_sup |= SUPPORT_WPA_WPA2_PSK_TKIP;

	if (support_enc & LIBWLANAPI_SUPPORT_WPA_PSK_AES)
		enc_sup |= SUPPORT_WPA_PSK_AES;

	if (support_enc & LIBWLANAPI_SUPPORT_WPA2_PSK_AES)
		enc_sup |= SUPPORT_WPA2_PSK_AES;

	if (support_enc & LIBWLANAPI_SUPPORT_WPA_WPA2_PSK_AES)
		enc_sup |= SUPPORT_WPA_WPA2_PSK_AES;

	if (support_enc & LIBWLANAPI_SUPPORT_WPA_WPA2_PSK_TKIP_AES)
		enc_sup |= SUPPORT_WPA_WPA2_PSK_TKIP_AES;

	return enc_sup;
}
#ifdef USE_TRANS_WIFI_CFG
static u8 get_key_mgmt_trans_wifi_cfg(u16 set_auth)
{
    int key_mgmt = 0;

    switch (set_auth) {
    case WPS_AUTH_OPEN:
        key_mgmt = LIBWLANAPI_WPA_KEY_MGMT_NONE;
        break;
    case WPS_AUTH_WPAPSK:
    case WPS_AUTH_WPA2PSK:
    case WPS_AUTH_WPA_WPA2:
        key_mgmt = LIBWLANAPI_WPA_KEY_MGMT_PSK;
        break;
    default:
        key_mgmt = 0;
        wpa_printf(MSG_ERROR, "%s: key_mgmt is 0(set_auth=%d)", __func__, set_auth);
        break;
    }

    return key_mgmt;
}

static u8 get_proto_trans_wifi_cfg(u16 set_auth)
{
    u8 proto = 0;

    switch (set_auth) {
    case WPS_AUTH_OPEN:
        proto = LIBWLANAPI_WPA_PROTO_OPEN;
        break;
    case WPS_AUTH_WPAPSK:
        proto = LIBWLANAPI_WPA_PROTO_WPA;
        break;
    case WPS_AUTH_WPA2PSK:
        proto = LIBWLANAPI_WPA_PROTO_RSN;
        break;
    case WPS_AUTH_WPA_WPA2:
        proto = LIBWLANAPI_WPA_PROTO_MIX;
        break;
    default:
        proto = 0;
        wpa_printf(MSG_ERROR, "%s: proto is 0(set_auth=%d)", __func__, set_auth);
        break;
    }

    return proto;
}

static u8 get_cipher_trans_wifi_cfg(u16 set_encr)
{
    u8 cipher = 0;

    switch (set_encr) {
    case WPS_ENCR_NONE:
        cipher = LIBWLANAPI_WPA_CIPHER_NONE;
        break;
    case WPS_ENCR_TKIP:
        cipher = LIBWLANAPI_WPA_CIPHER_TKIP;
        break;
    case WPS_ENCR_AES:
        cipher = LIBWLANAPI_WPA_CIPHER_CCMP;
        break;
    case WPS_ENCR_TKIP_AES:
        cipher = LIBWLANAPI_WPA_CIPHER_MIX;
        break;
    default:
        cipher = 0;
        wpa_printf(MSG_ERROR, "%s: cipher is 0(set_encr=%d)", __func__, set_encr);
        break;
    }

    return cipher;
}
#endif /* USE_TRANS_WIFI_CFG */
#endif /* USE_WLANAPI */

int cfg_wps_set_vs_sta_cred(struct wpa_supplicant *wpa_s, const struct wps_credential *cred)
{
    int freq = wpa_s->current_bss->freq;
    u32 enc_sup = 0;
    u16 set_auth = 0;
    u16 set_encr = 0;
    u8 key_mgmt;
    u8 proto;
    u8 cipher;
    int invalid_ssid = 0;
    int invalid_key = 0;

    wpa_printf(MSG_INFO, "WPS: Assoc AP Freq[%d]",freq);

#ifdef USE_WLANAPI
    enc_sup = get_enc_sup(LIBWLANAPI_SUPPORT_ENC_PRI);
#endif

    wpa_printf(MSG_INFO, "WPS: Cred Info essid[%.*s], "
               "auth_type=0x%04x, encr_type=0x%04x",
               cred->ssid_len,cred->ssid,cred->auth_type,cred->encr_type);

    wpa_printf(MSG_INFO, "WPS: encryption support:0x%04x", enc_sup);

    if (cfg_wps_vs_sta_enc_sup_get(cred, enc_sup, &set_auth, &set_encr) < 0) {
        wpa_printf(MSG_ERROR, "WPS: Not Encryption Support=0x%04x Skip", enc_sup);
        return -1;
    }

    wpa_printf(MSG_INFO, "WPS: set_auth_type=0x%04x, set_encr_type=0x%04x",set_auth, set_encr);

    if (cfg_wps_essid_str_check(cred, 1)){
        invalid_ssid = 1;
    }

    if (cfg_wps_enckey_str_check(wpa_s, cred, 1)){
        invalid_key = 1;
    }

#if defined(USE_TRANS_WIFI_CFG) && defined(USE_WLANAPI)
    if (libwlanapi_get_trans_wifi_cfg_state(wpa_s->ifname) == TRANS_WIFI_CFG_START) {
	    key_mgmt = get_key_mgmt_trans_wifi_cfg(set_auth);
	    proto = get_proto_trans_wifi_cfg(set_auth);
	    cipher = get_cipher_trans_wifi_cfg(set_encr);

	    libwlanapi_trans_wifi_cfg_out(wpa_s->ifname, key_mgmt, proto, cipher,
                                          (invalid_ssid ? NULL : cred->ssid), cred->ssid_len,
                                          (invalid_key ? NULL : (char *)cred->key), cred->key_len);
    }
#endif

    return 0;
}
