/*
 * Copyright (C) 2010 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * $Revision: 8252 $
 * $Date: 2010-01-29 14:04:02 +0800 (??? 29 一??2010) $
 *
 * Purpose : RTK switch high-level API for RTL8367/RTL8367B
 * Feature : Here is a list of all functions and variables in this module.
 *
 */

#include <rtl8367b_asicdrv_acl.h>
#include <rtl8367b_asicdrv.h>
#include <rtl8367b_asicdrv_dot1x.h>
#include <rtl8367b_asicdrv_qos.h>
#include <rtl8367b_asicdrv_scheduling.h>
#include <rtl8367b_asicdrv_fc.h>
#include <rtl8367b_asicdrv_port.h>
#include <rtl8367b_asicdrv_phy.h>
#include <rtl8367b_asicdrv_igmp.h>
#include <rtl8367b_asicdrv_unknownMulticast.h>
#include <rtl8367b_asicdrv_rma.h>
#include <rtl8367b_asicdrv_vlan.h>
#include <rtl8367b_asicdrv_lut.h>
#include <rtl8367b_asicdrv_led.h>
#include <rtl8367b_asicdrv_svlan.h>
#include <rtl8367b_asicdrv_meter.h>
#include <rtl8367b_asicdrv_inbwctrl.h>
#include <rtl8367b_asicdrv_storm.h>
#include <rtl8367b_asicdrv_misc.h>
#include <rtl8367b_asicdrv_portIsolation.h>
#include <rtl8367b_asicdrv_cputag.h>
#include <rtl8367b_asicdrv_trunking.h>
#include <rtl8367b_asicdrv_mirror.h>
#include <rtl8367b_asicdrv_mib.h>
#include <rtl8367b_asicdrv_interrupt.h>
#include <rtl8367b_asicdrv_green.h>
#include <rtl8367b_asicdrv_eee.h>
#include <rtl8367b_asicdrv_eav.h>
#include <rtl8367b_asicdrv_hsb.h>

#include <rtk_api.h>

#include <rtk_api_ext.h>
#include <rtk_error.h>

#include <linux/string.h>
#include <linux/seq_file.h>

#ifdef __KERNEL__
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0)
#define CONFIG_RTL_PROC_NEW	1
#endif
#endif

#ifdef CONFIG_OPENWRT_SDK
#include <linux/kernel.h> 
#include "../common/smi.h"
#endif

#define DELAY_800MS_FOR_CHIP_STATABLE() {  }

rtk_uint16      (*init_para)[2];
rtk_uint16      init_size;
rtk_api_ret_t rtk_forceFull_init(void);
extern int smi_write(unsigned int mAddrs, unsigned int rData);
#define EEE_OCP_PHY_ADDR    (0xA5D0)

#if defined(CHIP_RTL8363SB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT) || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData00[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}, {0x2017, 0xA11F}, {0x2077, 0xA11F}, {0x2097, 0xA11F}
 };
/*End of ChipData00[][2]*/

rtk_uint16 ChipData01[][2]= {
/*Code of Func*/
{0x1303, 0x0778}, {0x1304, 0x7777}, {0x13E2, 0x01FE}, {0x1310, 0x1075},
{0x1305, 0x0003}, {0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000},
{0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096},
{0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002},
{0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000},
{0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000},
{0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000},
{0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86},
{0x2206, 0x800E}, {0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200},
{0x6107, 0xE58B}, {0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000},
{0x220F, 0x0100}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000},
{0x2206, 0x0280}, {0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7},
{0x2206, 0xA080}, {0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153},
{0x2206, 0x0201}, {0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201},
{0x2206, 0x7CE0}, {0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E},
{0x2206, 0x01E1}, {0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000},
{0x2206, 0xE4AE}, {0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE},
{0x2206, 0x8AFD}, {0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE},
{0x2206, 0xFFF7}, {0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E},
{0x2206, 0xAD20}, {0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04},
{0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548},
{0x2206, 0xE08A}, {0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00},
{0x2206, 0x009E}, {0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE},
{0x2206, 0x8AE5}, {0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A},
{0x2206, 0xFDE2}, {0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102},
{0x2206, 0x2DAC}, {0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4},
{0x2206, 0x03EE}, {0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0},
{0x2206, 0x00EE}, {0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115},
{0x2206, 0xE685}, {0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08},
{0x2206, 0xEE85}, {0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100},
{0x2206, 0xFDFC}, {0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701},
{0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x207F, 0x0002},
{0x2073, 0x1D22}, {0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010}, {0x2000, 0x1940},
{0x2060, 0x1940}, {0x2080, 0x1940}, {0x2017, 0xA100}, {0x2077, 0xA100},
{0x2097, 0xA100}, };
/*End of ChipData01[][2]*/
#endif

#if defined(CHIP_RTL8365MB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT) || defined(CHIP_AUTO_DETECT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData10[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}, {0x2097, 0xA11F}
 };
/*End of ChipData10[][2]*/

rtk_uint16 ChipData11[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000}, {0x121E, 0x03CA},
{0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096}, {0x1238, 0x0078},
{0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200}, {0x6107, 0xE58B},
{0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x207F, 0x0002}, {0x2073, 0x1D22},
{0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x2080, 0x1940}, {0x2097, 0xA100},
};
/*End of ChipData11[][2]*/

rtk_uint16 ChipData12[][2]= {
{0x1d32, 0x0002}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x1200, 0x7FCB}
};/*End of ChipData12[][2]*/

#endif

#if defined(CHIP_RTL8367_VB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData20[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000},
{0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000},
{0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002},
{0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000},
{0x2057, 0x0000}, {0x205F, 0x0000}, {0x1200, 0x7FC4}, {0x0301, 0x0028},
{0x1700, 0x010E}, {0x1701, 0x0018}, {0x13EB, 0x11BB}, {0x12A4, 0x110A},
{0x12A6, 0x150A}, {0x13F1, 0x0013}, {0x13F4, 0x0010}, {0x13F5, 0x0000},
{0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00}, {0x0078, 0x0F00},
{0x0098, 0x0F00}, {0x12B6, 0x0C02}, {0x12B7, 0x030F}, {0x12B8, 0x11FF},
{0x12BC, 0x0004}, {0x1362, 0x0115}, {0x1363, 0x0002}, {0x1363, 0x0000},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0007}, {0x221E, 0x002D},
{0x2218, 0xF030}, {0x221F, 0x0007}, {0x221E, 0x0023}, {0x2216, 0x0005},
{0x2215, 0x00B9}, {0x2219, 0x0044}, {0x2215, 0x00BA}, {0x2219, 0x0020},
{0x2215, 0x00BB}, {0x2219, 0x00C1}, {0x2215, 0x0148}, {0x2219, 0x0096},
{0x2215, 0x016E}, {0x2219, 0x0026}, {0x2216, 0x0000}, {0x2216, 0x0000},
{0x221E, 0x002D}, {0x2218, 0xF010}, {0x221F, 0x0007}, {0x221E, 0x0020},
{0x2215, 0x0D00}, {0x221F, 0x0000}, {0x221F, 0x0000}, {0x2217, 0x2160},
{0x221F, 0x0001}, {0x2210, 0xF25E}, {0x221F, 0x0007}, {0x221E, 0x0042},
{0x2215, 0x0F00}, {0x2215, 0x0F00}, {0x2216, 0x7408}, {0x2215, 0x0E00},
{0x2215, 0x0F00}, {0x2215, 0x0F01}, {0x2216, 0x4000}, {0x2215, 0x0E01},
{0x2215, 0x0F01}, {0x2215, 0x0F02}, {0x2216, 0x9400}, {0x2215, 0x0E02},
{0x2215, 0x0F02}, {0x2215, 0x0F03}, {0x2216, 0x7408}, {0x2215, 0x0E03},
{0x2215, 0x0F03}, {0x2215, 0x0F04}, {0x2216, 0x4008}, {0x2215, 0x0E04},
{0x2215, 0x0F04}, {0x2215, 0x0F05}, {0x2216, 0x9400}, {0x2215, 0x0E05},
{0x2215, 0x0F05}, {0x2215, 0x0F06}, {0x2216, 0x0803}, {0x2215, 0x0E06},
{0x2215, 0x0F06}, {0x2215, 0x0D00}, {0x2215, 0x0100}, {0x221F, 0x0001},
{0x2210, 0xF05E}, {0x221F, 0x0000}, {0x2217, 0x2100}, {0x221F, 0x0000},
{0x220D, 0x0003}, {0x220E, 0x0015}, {0x220D, 0x4003}, {0x220E, 0x0006},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133F, 0x0010}, {0x12A0, 0x0058},
{0x12A1, 0x0058}, {0x133E, 0x000E}, {0x133F, 0x0030}, {0x221F, 0x0000},
{0x2210, 0x0166}, {0x221F, 0x0000}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0xFFF6},
{0x2206, 0x0080}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0x8000}, {0x2206, 0x0280}, {0x2206, 0x28F7}, {0x2206, 0x00E0},
{0x2206, 0xFFF7}, {0x2206, 0xA080}, {0x2206, 0x02AE}, {0x2206, 0xF602},
{0x2206, 0x0153}, {0x2206, 0x0201}, {0x2206, 0x6602}, {0x2206, 0x80B9},
{0x2206, 0xE08B}, {0x2206, 0x8CE1}, {0x2206, 0x8B8D}, {0x2206, 0x1E01},
{0x2206, 0xE18B}, {0x2206, 0x8E1E}, {0x2206, 0x01A0}, {0x2206, 0x00E7},
{0x2206, 0xAEDB}, {0x2206, 0xEEE0}, {0x2206, 0x120E}, {0x2206, 0xEEE0},
{0x2206, 0x1300}, {0x2206, 0xEEE0}, {0x2206, 0x2001}, {0x2206, 0xEEE0},
{0x2206, 0x2166}, {0x2206, 0xEEE0}, {0x2206, 0xC463}, {0x2206, 0xEEE0},
{0x2206, 0xC5E8}, {0x2206, 0xEEE0}, {0x2206, 0xC699}, {0x2206, 0xEEE0},
{0x2206, 0xC7C2}, {0x2206, 0xEEE0}, {0x2206, 0xC801}, {0x2206, 0xEEE0},
{0x2206, 0xC913}, {0x2206, 0xEEE0}, {0x2206, 0xCA30}, {0x2206, 0xEEE0},
{0x2206, 0xCB3E}, {0x2206, 0xEEE0}, {0x2206, 0xDCE1}, {0x2206, 0xEEE0},
{0x2206, 0xDD00}, {0x2206, 0xEEE2}, {0x2206, 0x0001}, {0x2206, 0xEEE2},
{0x2206, 0x0100}, {0x2206, 0xEEE4}, {0x2206, 0x8860}, {0x2206, 0xEEE4},
{0x2206, 0x8902}, {0x2206, 0xEEE4}, {0x2206, 0x8C00}, {0x2206, 0xEEE4},
{0x2206, 0x8D30}, {0x2206, 0xEEEA}, {0x2206, 0x1480}, {0x2206, 0xEEEA},
{0x2206, 0x1503}, {0x2206, 0xEEEA}, {0x2206, 0xC600}, {0x2206, 0xEEEA},
{0x2206, 0xC706}, {0x2206, 0xEE85}, {0x2206, 0xEE00}, {0x2206, 0xEE85},
{0x2206, 0xEF00}, {0x2206, 0xEE8B}, {0x2206, 0x6750}, {0x2206, 0xEE8B},
{0x2206, 0x6632}, {0x2206, 0xEE8A}, {0x2206, 0xD448}, {0x2206, 0xEE8A},
{0x2206, 0xD548}, {0x2206, 0xEE8A}, {0x2206, 0xD649}, {0x2206, 0xEE8A},
{0x2206, 0xD7F8}, {0x2206, 0xEE8B}, {0x2206, 0x85E2}, {0x2206, 0xEE8B},
{0x2206, 0x8700}, {0x2206, 0xEEFF}, {0x2206, 0xF600}, {0x2206, 0xEEFF},
{0x2206, 0xF7FC}, {0x2206, 0x04F8}, {0x2206, 0xE08B}, {0x2206, 0x8EAD},
{0x2206, 0x2023}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x8E02},
{0x2206, 0x2877}, {0x2206, 0x0225}, {0x2206, 0xC702}, {0x2206, 0x26A1},
{0x2206, 0x0281}, {0x2206, 0xB302}, {0x2206, 0x8496}, {0x2206, 0x0202},
{0x2206, 0xA102}, {0x2206, 0x27F1}, {0x2206, 0x0228}, {0x2206, 0xF902},
{0x2206, 0x2AA0}, {0x2206, 0x0282}, {0x2206, 0xB8E0}, {0x2206, 0x8B8E},
{0x2206, 0xAD21}, {0x2206, 0x08F6}, {0x2206, 0x21E4}, {0x2206, 0x8B8E},
{0x2206, 0x0202}, {0x2206, 0x80E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD22},
{0x2206, 0x05F6}, {0x2206, 0x22E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x2305}, {0x2206, 0xF623}, {0x2206, 0xE48B},
{0x2206, 0x8EE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD24}, {0x2206, 0x08F6},
{0x2206, 0x24E4}, {0x2206, 0x8B8E}, {0x2206, 0x0227}, {0x2206, 0x6AE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD25}, {0x2206, 0x05F6}, {0x2206, 0x25E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x260B},
{0x2206, 0xF626}, {0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x830D},
{0x2206, 0x021D}, {0x2206, 0x6BE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD27},
{0x2206, 0x05F6}, {0x2206, 0x27E4}, {0x2206, 0x8B8E}, {0x2206, 0x0281},
{0x2206, 0x4402}, {0x2206, 0x045C}, {0x2206, 0xFC04}, {0x2206, 0xF8E0},
{0x2206, 0x8B83}, {0x2206, 0xAD23}, {0x2206, 0x30E0}, {0x2206, 0xE022},
{0x2206, 0xE1E0}, {0x2206, 0x2359}, {0x2206, 0x02E0}, {0x2206, 0x85EF},
{0x2206, 0xE585}, {0x2206, 0xEFAC}, {0x2206, 0x2907}, {0x2206, 0x1F01},
{0x2206, 0x9E51}, {0x2206, 0xAD29}, {0x2206, 0x20E0}, {0x2206, 0x8B83},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD28},
{0x2206, 0x42E0}, {0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD29}, {0x2206, 0x36BF}, {0x2206, 0x34BF},
{0x2206, 0x022C}, {0x2206, 0x31AE}, {0x2206, 0x2EE0}, {0x2206, 0x8B83},
{0x2206, 0xAD21}, {0x2206, 0x10E0}, {0x2206, 0x8B84}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8ADA}, {0x2206, 0x00EE},
{0x2206, 0x8ADB}, {0x2206, 0x00E0}, {0x2206, 0x8B85}, {0x2206, 0xAD21},
{0x2206, 0x0CE0}, {0x2206, 0x8B84}, {0x2206, 0xF621}, {0x2206, 0xE48B},
{0x2206, 0x84EE}, {0x2206, 0x8B72}, {0x2206, 0xFFBF}, {0x2206, 0x34C2},
{0x2206, 0x022C}, {0x2206, 0x31FC}, {0x2206, 0x04F8}, {0x2206, 0xFAEF},
{0x2206, 0x69E0}, {0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x42E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2358}, {0x2206, 0xC059},
{0x2206, 0x021E}, {0x2206, 0x01E1}, {0x2206, 0x8B72}, {0x2206, 0x1F10},
{0x2206, 0x9E2F}, {0x2206, 0xE48B}, {0x2206, 0x72AD}, {0x2206, 0x2123},
{0x2206, 0xE18B}, {0x2206, 0x84F7}, {0x2206, 0x29E5}, {0x2206, 0x8B84},
{0x2206, 0xAC27}, {0x2206, 0x10AC}, {0x2206, 0x2605}, {0x2206, 0x0205},
{0x2206, 0x23AE}, {0x2206, 0x1602}, {0x2206, 0x0535}, {0x2206, 0x0282},
{0x2206, 0x30AE}, {0x2206, 0x0E02}, {0x2206, 0x056A}, {0x2206, 0x0282},
{0x2206, 0x75AE}, {0x2206, 0x0602}, {0x2206, 0x04DC}, {0x2206, 0x0282},
{0x2206, 0x04EF}, {0x2206, 0x96FE}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x2321}, {0x2206, 0xE0EA},
{0x2206, 0x14E1}, {0x2206, 0xEA15}, {0x2206, 0xAD26}, {0x2206, 0x18F6},
{0x2206, 0x27E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F6},
{0x2206, 0x26E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F7},
{0x2206, 0x27E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15FD},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x233A}, {0x2206, 0xAD22}, {0x2206, 0x37E0}, {0x2206, 0xE020},
{0x2206, 0xE1E0}, {0x2206, 0x21AC}, {0x2206, 0x212E}, {0x2206, 0xE0EA},
{0x2206, 0x14E1}, {0x2206, 0xEA15}, {0x2206, 0xF627}, {0x2206, 0xE4EA},
{0x2206, 0x14E5}, {0x2206, 0xEA15}, {0x2206, 0xE2EA}, {0x2206, 0x12E3},
{0x2206, 0xEA13}, {0x2206, 0x5A8F}, {0x2206, 0x6A20}, {0x2206, 0xE6EA},
{0x2206, 0x12E7}, {0x2206, 0xEA13}, {0x2206, 0xF726}, {0x2206, 0xE4EA},
{0x2206, 0x14E5}, {0x2206, 0xEA15}, {0x2206, 0xF727}, {0x2206, 0xE4EA},
{0x2206, 0x14E5}, {0x2206, 0xEA15}, {0x2206, 0xFDFC}, {0x2206, 0x04F8},
{0x2206, 0xF9E0}, {0x2206, 0x8B87}, {0x2206, 0xAD23}, {0x2206, 0x38AD},
{0x2206, 0x2135}, {0x2206, 0xE0E0}, {0x2206, 0x20E1}, {0x2206, 0xE021},
{0x2206, 0xAC21}, {0x2206, 0x2CE0}, {0x2206, 0xEA14}, {0x2206, 0xE1EA},
{0x2206, 0x15F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA},
{0x2206, 0x15E2}, {0x2206, 0xEA12}, {0x2206, 0xE3EA}, {0x2206, 0x135A},
{0x2206, 0x8FE6}, {0x2206, 0xEA12}, {0x2206, 0xE7EA}, {0x2206, 0x13F7},
{0x2206, 0x26E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F7},
{0x2206, 0x27E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15FD},
{0x2206, 0xFC04}, {0x2206, 0xF8FA}, {0x2206, 0xEF69}, {0x2206, 0xE08B},
{0x2206, 0x86AD}, {0x2206, 0x2146}, {0x2206, 0xE0E0}, {0x2206, 0x22E1},
{0x2206, 0xE023}, {0x2206, 0x58C0}, {0x2206, 0x5902}, {0x2206, 0x1E01},
{0x2206, 0xE18B}, {0x2206, 0x651F}, {0x2206, 0x109E}, {0x2206, 0x33E4},
{0x2206, 0x8B65}, {0x2206, 0xAD21}, {0x2206, 0x22AD}, {0x2206, 0x272A},
{0x2206, 0xD400}, {0x2206, 0x01BF}, {0x2206, 0x34F2}, {0x2206, 0x022C},
{0x2206, 0xA2BF}, {0x2206, 0x34F5}, {0x2206, 0x022C}, {0x2206, 0xE0E0},
{0x2206, 0x8B67}, {0x2206, 0x1B10}, {0x2206, 0xAA14}, {0x2206, 0xE18B},
{0x2206, 0x660D}, {0x2206, 0x1459}, {0x2206, 0x0FAE}, {0x2206, 0x05E1},
{0x2206, 0x8B66}, {0x2206, 0x590F}, {0x2206, 0xBF85}, {0x2206, 0x6102},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xF9FA}, {0x2206, 0xFBEF}, {0x2206, 0x79E2}, {0x2206, 0x8AD2},
{0x2206, 0xAC19}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37EF}, {0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x019E},
{0x2206, 0x1F7A}, {0x2206, 0x0159}, {0x2206, 0x019F}, {0x2206, 0x0ABF},
{0x2206, 0x348E}, {0x2206, 0x022C}, {0x2206, 0x31F6}, {0x2206, 0x06AE},
{0x2206, 0x0FF6}, {0x2206, 0x0302}, {0x2206, 0x0470}, {0x2206, 0xF703},
{0x2206, 0xF706}, {0x2206, 0xBF34}, {0x2206, 0x9302}, {0x2206, 0x2C31},
{0x2206, 0xAC1A}, {0x2206, 0x25E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x23EF}, {0x2206, 0x300D}, {0x2206, 0x311F}, {0x2206, 0x325B},
{0x2206, 0x029E}, {0x2206, 0x157A}, {0x2206, 0x0258}, {0x2206, 0xC4A0},
{0x2206, 0x0408}, {0x2206, 0xBF34}, {0x2206, 0x9E02}, {0x2206, 0x2C31},
{0x2206, 0xAE06}, {0x2206, 0xBF34}, {0x2206, 0x9C02}, {0x2206, 0x2C31},
{0x2206, 0xAC1B}, {0x2206, 0x4AE0}, {0x2206, 0xE012}, {0x2206, 0xE1E0},
{0x2206, 0x13EF}, {0x2206, 0x300D}, {0x2206, 0x331F}, {0x2206, 0x325B},
{0x2206, 0x1C9E}, {0x2206, 0x3AEF}, {0x2206, 0x325B}, {0x2206, 0x1C9F},
{0x2206, 0x09BF}, {0x2206, 0x3498}, {0x2206, 0x022C}, {0x2206, 0x3102},
{0x2206, 0x83C5}, {0x2206, 0x5A03}, {0x2206, 0x0D03}, {0x2206, 0x581C},
{0x2206, 0x1E20}, {0x2206, 0x0207}, {0x2206, 0xA0A0}, {0x2206, 0x000E},
{0x2206, 0x0284}, {0x2206, 0x17AD}, {0x2206, 0x1817}, {0x2206, 0xBF34},
{0x2206, 0x9A02}, {0x2206, 0x2C31}, {0x2206, 0xAE0F}, {0x2206, 0xBF34},
{0x2206, 0xC802}, {0x2206, 0x2C31}, {0x2206, 0xBF34}, {0x2206, 0xC502},
{0x2206, 0x2C31}, {0x2206, 0x0284}, {0x2206, 0x52E6}, {0x2206, 0x8AD2},
{0x2206, 0xEF97}, {0x2206, 0xFFFE}, {0x2206, 0xFDFC}, {0x2206, 0x04F8},
{0x2206, 0xBF34}, {0x2206, 0xDA02}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xD3BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xE00C},
{0x2206, 0x1159}, {0x2206, 0x02E0}, {0x2206, 0x8AD3}, {0x2206, 0x1E01},
{0x2206, 0xE48A}, {0x2206, 0xD3D1}, {0x2206, 0x00BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2D1}, {0x2206, 0x01BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34CB}, {0x2206, 0x022C},
{0x2206, 0xE0E5}, {0x2206, 0x8ACE}, {0x2206, 0xBF85}, {0x2206, 0x6702},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xCFBF}, {0x2206, 0x8564},
{0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8AD0}, {0x2206, 0xBF85},
{0x2206, 0x6A02}, {0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD1FC},
{0x2206, 0x04F8}, {0x2206, 0xE18A}, {0x2206, 0xD1BF}, {0x2206, 0x856A},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD0}, {0x2206, 0xBF85},
{0x2206, 0x6402}, {0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xCFBF},
{0x2206, 0x8567}, {0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8ACE},
{0x2206, 0xBF34}, {0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xE18A},
{0x2206, 0xD3BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD3}, {0x2206, 0x0D11}, {0x2206, 0xBF34}, {0x2206, 0xD402},
{0x2206, 0x2CA2}, {0x2206, 0xFC04}, {0x2206, 0xF9A0}, {0x2206, 0x0405},
{0x2206, 0xE38A}, {0x2206, 0xD4AE}, {0x2206, 0x13A0}, {0x2206, 0x0805},
{0x2206, 0xE38A}, {0x2206, 0xD5AE}, {0x2206, 0x0BA0}, {0x2206, 0x0C05},
{0x2206, 0xE38A}, {0x2206, 0xD6AE}, {0x2206, 0x03E3}, {0x2206, 0x8AD7},
{0x2206, 0xEF13}, {0x2206, 0xBF34}, {0x2206, 0xCB02}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D11}, {0x2206, 0xBF85}, {0x2206, 0x6702},
{0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D14}, {0x2206, 0xBF85},
{0x2206, 0x6402}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D17},
{0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CA2}, {0x2206, 0xFD04},
{0x2206, 0xF8E0}, {0x2206, 0x8B85}, {0x2206, 0xAD27}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37E1}, {0x2206, 0x8B73},
{0x2206, 0x1F10}, {0x2206, 0x9E20}, {0x2206, 0xE48B}, {0x2206, 0x73AC},
{0x2206, 0x200B}, {0x2206, 0xAC21}, {0x2206, 0x0DAC}, {0x2206, 0x250F},
{0x2206, 0xAC27}, {0x2206, 0x0EAE}, {0x2206, 0x0F02}, {0x2206, 0x84CC},
{0x2206, 0xAE0A}, {0x2206, 0x0284}, {0x2206, 0xD1AE}, {0x2206, 0x05AE},
{0x2206, 0x0302}, {0x2206, 0x84D8}, {0x2206, 0xFC04}, {0x2206, 0xEE8B},
{0x2206, 0x6800}, {0x2206, 0x0402}, {0x2206, 0x84E5}, {0x2206, 0x0285},
{0x2206, 0x2804}, {0x2206, 0x0285}, {0x2206, 0x4904}, {0x2206, 0xEE8B},
{0x2206, 0x6800}, {0x2206, 0xEE8B}, {0x2206, 0x6902}, {0x2206, 0x04F8},
{0x2206, 0xF9E0}, {0x2206, 0x8B85}, {0x2206, 0xAD26}, {0x2206, 0x38D0},
{0x2206, 0x0B02}, {0x2206, 0x2B4D}, {0x2206, 0x5882}, {0x2206, 0x7882},
{0x2206, 0x9F2D}, {0x2206, 0xE08B}, {0x2206, 0x68E1}, {0x2206, 0x8B69},
{0x2206, 0x1F10}, {0x2206, 0x9EC8}, {0x2206, 0x10E4}, {0x2206, 0x8B68},
{0x2206, 0xE0E0}, {0x2206, 0x00E1}, {0x2206, 0xE001}, {0x2206, 0xF727},
{0x2206, 0xE4E0}, {0x2206, 0x00E5}, {0x2206, 0xE001}, {0x2206, 0xE2E0},
{0x2206, 0x20E3}, {0x2206, 0xE021}, {0x2206, 0xAD30}, {0x2206, 0xF7F6},
{0x2206, 0x27E4}, {0x2206, 0xE000}, {0x2206, 0xE5E0}, {0x2206, 0x01FD},
{0x2206, 0xFC04}, {0x2206, 0xF8FA}, {0x2206, 0xEF69}, {0x2206, 0xE08B},
{0x2206, 0x86AD}, {0x2206, 0x2212}, {0x2206, 0xE0E0}, {0x2206, 0x14E1},
{0x2206, 0xE015}, {0x2206, 0xAD26}, {0x2206, 0x9CE1}, {0x2206, 0x85E0},
{0x2206, 0xBF85}, {0x2206, 0x6D02}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0},
{0x2206, 0x8B86}, {0x2206, 0xAD22}, {0x2206, 0x09E1}, {0x2206, 0x85E1},
{0x2206, 0xBF85}, {0x2206, 0x6D02}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x0464}, {0x2206, 0xE48C}, {0x2206, 0xFDE4},
{0x2206, 0x80CA}, {0x2206, 0xE480}, {0x2206, 0x66E0}, {0x2206, 0x8E70},
{0x2206, 0xE076}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133E, 0x000E}, {0x133F, 0x0010}
};
/*End of ChipData20[][2]*/

rtk_uint16 ChipData21[][2]= {
/*Code of Func*/
{0x1305, 0xC000}, {0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064},
{0x1237, 0x0096}, {0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030},
{0x0201, 0x0064}, {0x0202, 0x0064}, {0x0203, 0x0096}, {0x0204, 0x0096},
{0x0205, 0x0096}, {0x0206, 0x0096}, {0x0207, 0x0096}, {0x1B03, 0x0876},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005},
{0x2205, 0x8B86}, {0x2206, 0x800E}, {0x221F, 0x0000}, {0x133F, 0x0010},
{0x12A3, 0x2200}, {0x6107, 0xE58B}, {0x6103, 0xA970}, {0x1200, 0x7FC4},
{0x13EB, 0x11BB}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x207F, 0x0002}, {0x2073, 0x1D22}, {0x207F, 0x0000},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340}, {0x133E, 0x000E},
{0x133F, 0x0010}, };
/*End of ChipData21[][2]*/

#endif

#if defined(CHIP_RTL8367RB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData30[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}, {0x13E0, 0x0010}
};
/*End of ChipData30[][2]*/
#endif

#if defined(CHIP_RTL8367RB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST) || defined(CONFIG_RTL_8367R_SUPPORT)
rtk_uint16 ChipData31[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000}, {0x121E, 0x03CA},
{0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096}, {0x1238, 0x0078},
{0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200}, {0x6107, 0xE58B},
{0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x13E0, 0x0010}, {0x207F, 0x0002}, {0x2073, 0x1D22},
{0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340},
{0x133E, 0x000E}, {0x133F, 0x0010}, };
/*End of ChipData21[][2]*/

rtk_uint16 ChipData32[][2]= {
/*Code of Func*/
{0x1d32, 0x0002}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x1200, 0x7FCB}
};/*End of ChipData32[][2]*/
#endif

#if defined(CHIP_RTL8367R_VB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT) || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData40[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}
};
/*End of ChipData40[][2]*/
#endif

#if defined(CHIP_RTL8367R_VB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT) || defined(CONFIG_RTL8367B_ASICDRV_TEST) || defined(CONFIG_RTL_8367R_SUPPORT)
rtk_uint16 ChipData41[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000}, {0x121E, 0x03CA},
{0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096}, {0x1238, 0x0078},
{0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200}, {0x6107, 0xE58B},
{0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x207F, 0x0002}, {0x2073, 0x1D22},
{0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340},
{0x133E, 0x000E}, {0x133F, 0x0010}, };
/*End of ChipData41[][2]*/

#endif

#if defined(CHIP_RTL8367MB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST) || defined(CONFIG_RTL_8367MB_SUPPORT)
rtk_uint16 ChipData50[][2]= { };

rtk_uint16 ChipData51[][2]= {
/*Code of Func*/
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86},
{0x2206, 0x800E}, {0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200},
{0x6107, 0xE58B}, {0x6103, 0xA970}, {0x1B03, 0x0876}, {0x1200, 0x7FC4},
{0x1305, 0xC000}, {0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064},
{0x1237, 0x0096}, {0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030},
{0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00}, {0x0078, 0x0F00},
{0x0098, 0x0F00}, {0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000},
{0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000},
{0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002},
{0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000},
{0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E}, {0x221F, 0x0000},
{0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005},
{0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0xFFF6},
{0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280}, {0x2206, 0x2BF7},
{0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080}, {0x2206, 0x02AE},
{0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201}, {0x2206, 0x6602},
{0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0}, {0x2206, 0x8B8C},
{0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1}, {0x2206, 0x8B8E},
{0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE}, {0x2206, 0xD8EE},
{0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1}, {0x2206, 0x00EE},
{0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD}, {0x2206, 0x73EE},
{0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7}, {0x2206, 0xFC04},
{0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20}, {0x2206, 0x0302},
{0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B},
{0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A}, {0x2206, 0xE4E1},
{0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E}, {0x2206, 0x35EE},
{0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5}, {0x2206, 0x00E0},
{0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2}, {0x2206, 0x85C0},
{0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC}, {0x2206, 0xAD20},
{0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE}, {0x2206, 0x8AE5},
{0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685}, {0x2206, 0xC0E7},
{0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85}, {0x2206, 0xC000},
{0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC}, {0x2206, 0x0400},
{0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405},
{0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}, {0x207F, 0x0002}, {0x2073, 0x1D22}, {0x207F, 0x0000},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340}, {0x133E, 0x000E},
{0x133F, 0x0010}, };
/*End of ChipData51[][2]*/
#endif

#if defined(CHIP_RTL8367M_VB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData60[][2]= {
/*Code of Func*/
{0x1B00, 0x14F1}, {0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026},
{0x1722, 0x0E14}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080},
{0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000},
{0x2206, 0x0280}, {0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7},
{0x2206, 0xA080}, {0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153},
{0x2206, 0x0201}, {0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B},
{0x2206, 0x8CE1}, {0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B},
{0x2206, 0x8E1E}, {0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB},
{0x2206, 0xEEE0}, {0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300},
{0x2206, 0xEEE0}, {0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166},
{0x2206, 0xEEE0}, {0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8},
{0x2206, 0xEEE0}, {0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2},
{0x2206, 0xEEE0}, {0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913},
{0x2206, 0xEEE0}, {0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E},
{0x2206, 0xEEE0}, {0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00},
{0x2206, 0xEEE2}, {0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100},
{0x2206, 0xEEE4}, {0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902},
{0x2206, 0xEEE4}, {0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30},
{0x2206, 0xEEEA}, {0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503},
{0x2206, 0xEEEA}, {0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706},
{0x2206, 0xEE85}, {0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00},
{0x2206, 0xEE8B}, {0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632},
{0x2206, 0xEE8A}, {0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548},
{0x2206, 0xEE8A}, {0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8},
{0x2206, 0xEE8B}, {0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700},
{0x2206, 0xEEFF}, {0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC},
{0x2206, 0x04F8}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023},
{0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877},
{0x2206, 0x0225}, {0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281},
{0x2206, 0xB302}, {0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102},
{0x2206, 0x27F1}, {0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0},
{0x2206, 0x0282}, {0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21},
{0x2206, 0x08F6}, {0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202},
{0x2206, 0x80E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6},
{0x2206, 0x22E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD},
{0x2206, 0x2305}, {0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4},
{0x2206, 0x8B8E}, {0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD25}, {0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D},
{0x2206, 0x6BE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6},
{0x2206, 0x27E4}, {0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402},
{0x2206, 0x045C}, {0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83},
{0x2206, 0xAD23}, {0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2359}, {0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585},
{0x2206, 0xEFAC}, {0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51},
{0x2206, 0xAD29}, {0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21},
{0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84},
{0x2206, 0xAD29}, {0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C},
{0x2206, 0x31AE}, {0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21},
{0x2206, 0x10E0}, {0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B},
{0x2206, 0x84EE}, {0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB},
{0x2206, 0x00E0}, {0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0},
{0x2206, 0x8B84}, {0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8B72}, {0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C},
{0x2206, 0x31FC}, {0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022},
{0x2206, 0xE1E0}, {0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E},
{0x2206, 0x01E1}, {0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F},
{0x2206, 0xE48B}, {0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B},
{0x2206, 0x84F7}, {0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27},
{0x2206, 0x10AC}, {0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE},
{0x2206, 0x1602}, {0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE},
{0x2206, 0x0E02}, {0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE},
{0x2206, 0x0602}, {0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF},
{0x2206, 0x96FE}, {0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B},
{0x2206, 0x87AD}, {0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1},
{0x2206, 0xEA15}, {0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04},
{0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A},
{0x2206, 0xAD22}, {0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0},
{0x2206, 0x21AC}, {0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1},
{0x2206, 0xEA15}, {0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5},
{0x2206, 0xEA15}, {0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13},
{0x2206, 0x5A8F}, {0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7},
{0x2206, 0xEA13}, {0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5},
{0x2206, 0xEA15}, {0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5},
{0x2206, 0xEA15}, {0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0},
{0x2206, 0x8B87}, {0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135},
{0x2206, 0xE0E0}, {0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21},
{0x2206, 0x2CE0}, {0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6},
{0x2206, 0x27E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2},
{0x2206, 0xEA12}, {0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6},
{0x2206, 0xEA12}, {0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04},
{0x2206, 0xF8FA}, {0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD},
{0x2206, 0x2146}, {0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023},
{0x2206, 0x58C0}, {0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B},
{0x2206, 0x651F}, {0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65},
{0x2206, 0xAD21}, {0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400},
{0x2206, 0x01BF}, {0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34F5}, {0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67},
{0x2206, 0x1B10}, {0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D},
{0x2206, 0x1459}, {0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66},
{0x2206, 0x590F}, {0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2},
{0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA},
{0x2206, 0xFBEF}, {0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19},
{0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A},
{0x2206, 0x0159}, {0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E},
{0x2206, 0x022C}, {0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6},
{0x2206, 0x0302}, {0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706},
{0x2206, 0xBF34}, {0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A},
{0x2206, 0x25E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF},
{0x2206, 0x300D}, {0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E},
{0x2206, 0x157A}, {0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408},
{0x2206, 0xBF34}, {0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06},
{0x2206, 0xBF34}, {0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B},
{0x2206, 0x4AE0}, {0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF},
{0x2206, 0x300D}, {0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E},
{0x2206, 0x3AEF}, {0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF},
{0x2206, 0x3498}, {0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5},
{0x2206, 0x5A03}, {0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20},
{0x2206, 0x0207}, {0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284},
{0x2206, 0x17AD}, {0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02},
{0x2206, 0x2C31}, {0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802},
{0x2206, 0x2C31}, {0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31},
{0x2206, 0x0284}, {0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97},
{0x2206, 0xFFFE}, {0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34},
{0x2206, 0xDA02}, {0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF},
{0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159},
{0x2206, 0x02E0}, {0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A},
{0x2206, 0xD3D1}, {0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C},
{0x2206, 0xA2D1}, {0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C},
{0x2206, 0xA2BF}, {0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8ACE}, {0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C},
{0x2206, 0xE0E5}, {0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8},
{0x2206, 0xE18A}, {0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF},
{0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3},
{0x2206, 0x0D11}, {0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2},
{0x2206, 0xFC04}, {0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A},
{0x2206, 0xD4AE}, {0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A},
{0x2206, 0xD5AE}, {0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A},
{0x2206, 0xD6AE}, {0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13},
{0x2206, 0xBF34}, {0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D11}, {0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402},
{0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85},
{0x2206, 0x6A02}, {0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0},
{0x2206, 0x8B85}, {0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036},
{0x2206, 0xE1E0}, {0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10},
{0x2206, 0x9E20}, {0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B},
{0x2206, 0xAC21}, {0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27},
{0x2206, 0x0EAE}, {0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A},
{0x2206, 0x0284}, {0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302},
{0x2206, 0x84D8}, {0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800},
{0x2206, 0x0402}, {0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804},
{0x2206, 0x0285}, {0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800},
{0x2206, 0xEE8B}, {0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0},
{0x2206, 0x8B85}, {0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02},
{0x2206, 0x2B4D}, {0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D},
{0x2206, 0xE08B}, {0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10},
{0x2206, 0x9EC8}, {0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0},
{0x2206, 0x00E1}, {0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0},
{0x2206, 0x00E5}, {0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3},
{0x2206, 0xE021}, {0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4},
{0x2206, 0xE000}, {0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04},
{0x2206, 0xF8FA}, {0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD},
{0x2206, 0x2212}, {0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015},
{0x2206, 0xAD26}, {0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85},
{0x2206, 0x6D02}, {0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86},
{0x2206, 0xAD22}, {0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85},
{0x2206, 0x6D02}, {0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC},
{0x2206, 0x0464}, {0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA},
{0x2206, 0xE480}, {0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076},
{0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405},
{0x220F, 0x0000}, {0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x13EB, 0x11BB}
};
/*End of ChipData60[][2]*/

rtk_uint16 ChipData61[][2]= {
/*Code of Func*/
{0x1305, 0xC000}, {0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064},
{0x1237, 0x0096}, {0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030},
{0x1B00, 0x14F1}, {0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0018, 0x0F00},
{0x0038, 0x0F00}, {0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005},
{0x2205, 0x8B86}, {0x2206, 0x800E}, {0x221F, 0x0000}, {0x133F, 0x0010},
{0x12A3, 0x2200}, {0x6107, 0xE58B}, {0x6103, 0xA970}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000},
{0x220F, 0x0100}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000},
{0x2206, 0x0280}, {0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7},
{0x2206, 0xA080}, {0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153},
{0x2206, 0x0201}, {0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201},
{0x2206, 0x7CE0}, {0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E},
{0x2206, 0x01E1}, {0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000},
{0x2206, 0xE4AE}, {0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE},
{0x2206, 0x8AFD}, {0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE},
{0x2206, 0xFFF7}, {0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E},
{0x2206, 0xAD20}, {0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04},
{0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548},
{0x2206, 0xE08A}, {0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00},
{0x2206, 0x009E}, {0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE},
{0x2206, 0x8AE5}, {0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A},
{0x2206, 0xFDE2}, {0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102},
{0x2206, 0x2DAC}, {0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4},
{0x2206, 0x03EE}, {0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0},
{0x2206, 0x00EE}, {0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115},
{0x2206, 0xE685}, {0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08},
{0x2206, 0xEE85}, {0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100},
{0x2206, 0xFDFC}, {0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701},
{0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x207F, 0x0002},
{0x2073, 0x1D22}, {0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010}, };
/*End of ChipData61[][2]*/

#endif

#if defined(CHIP_RTL8368MB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData70[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}
};
/*End of ChipData70[][2]*/

rtk_uint16 ChipData71[][2]= {
/*Code of Func*/
{0x1305, 0xC000}, {0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064},
{0x1237, 0x0096}, {0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030},
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200}, {0x6107, 0xE58B},
{0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x207F, 0x0002}, {0x2073, 0x1D22}, {0x207F, 0x0000},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340}, {0x133E, 0x000E},
{0x133F, 0x0010}, };
/*End of ChipData71[][2]*/

#endif

#if defined(CHIP_RTL8305MB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT) || defined(CHIP_AUTO_DETECT) || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData80[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2209, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x2097, 0xA11F}
};
/*End of ChipData80[][2]*/

rtk_uint16 ChipData81[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000}, {0x121E, 0x03CA},
{0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096}, {0x1238, 0x0078},
{0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200}, {0x6107, 0xE58B},
{0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0000},
{0x2209, 0x0C00}, {0x221F, 0x0000}, {0x133F, 0x0010}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x2200, 0x1340}, {0x133F, 0x0010}, {0x13EB, 0x11BB},
{0x207F, 0x0002}, {0x2073, 0x1D22}, {0x207F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x2080, 0x1940}, {0x2097, 0xA100}, };
/*End of ChipData81[][2]*/
#endif

#if defined(CHIP_RTL8307M_VB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData90[][2]= {
/*Code of Func*/
};
/*End of ChipData90[][2]*/

rtk_uint16 ChipData91[][2]= {
/*Code of Func*/
{0x1305, 0xC000}, {0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064},
{0x1237, 0x0096}, {0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030},
{0x1B00, 0x14F1}, {0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0018, 0x0F00},
{0x0038, 0x0F00}, {0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005},
{0x2205, 0x8B86}, {0x2206, 0x800E}, {0x221F, 0x0000}, {0x133F, 0x0010},
{0x12A3, 0x2200}, {0x6107, 0xE58B}, {0x6103, 0xA970}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000},
{0x220F, 0x0100}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000},
{0x2206, 0x0280}, {0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7},
{0x2206, 0xA080}, {0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153},
{0x2206, 0x0201}, {0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201},
{0x2206, 0x7CE0}, {0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E},
{0x2206, 0x01E1}, {0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000},
{0x2206, 0xE4AE}, {0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE},
{0x2206, 0x8AFD}, {0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE},
{0x2206, 0xFFF7}, {0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E},
{0x2206, 0xAD20}, {0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04},
{0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548},
{0x2206, 0xE08A}, {0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00},
{0x2206, 0x009E}, {0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE},
{0x2206, 0x8AE5}, {0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A},
{0x2206, 0xFDE2}, {0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102},
{0x2206, 0x2DAC}, {0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4},
{0x2206, 0x03EE}, {0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0},
{0x2206, 0x00EE}, {0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115},
{0x2206, 0xE685}, {0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08},
{0x2206, 0xEE85}, {0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100},
{0x2206, 0xFDFC}, {0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701},
{0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x201F, 0x0000}, {0x2009, 0x0C00},
{0x201F, 0x0000}, {0x203F, 0x0000}, {0x2029, 0x0C00}, {0x203F, 0x0000},
{0x205F, 0x0000}, {0x2049, 0x0C00}, {0x205F, 0x0000}, {0x207F, 0x0000},
{0x2069, 0x0C00}, {0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x2200, 0x1340}, {0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x207F, 0x0002},
{0x2073, 0x1D22}, {0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010}, };
/*End of ChipData91[][2]*/

#endif

#if defined(CHIP_RTL8367N) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData100[][2]= {
/*Code of Func*/
};
/*End of ChipData100[][2]*/

rtk_uint16 ChipData101[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000}, {0x121E, 0x03CA},
{0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096}, {0x1238, 0x0078},
{0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x12A3, 0x2200},
{0x6107, 0xE58B}, {0x6103, 0xA970}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002C}, {0x2219, 0x0504}, {0x221F, 0x0000},
{0x133F, 0x0010}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x13EB, 0x11BB}, {0x207F, 0x0002},
{0x2073, 0x1D22}, {0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x2200, 0x1940}, {0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000},
{0x220F, 0x0100}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x221F, 0x0007},
{0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007}, {0x221E, 0x0023},
{0x2216, 0x0005}, {0x2215, 0x0095}, {0x2219, 0x001A}, {0x2215, 0x009A},
{0x2219, 0x0017}, {0x2215, 0x009D}, {0x2219, 0x000E}, {0x2215, 0x009F},
{0x2219, 0x0003}, {0x2215, 0x00A2}, {0x2219, 0x0050}, {0x2215, 0x00A3},
{0x2219, 0x0081}, {0x2215, 0x00A4}, {0x2219, 0x00BC}, {0x2215, 0x00A5},
{0x2219, 0x001B}, {0x2215, 0x00A6}, {0x2219, 0x00EE}, {0x2215, 0x00A7},
{0x2219, 0x00A4}, {0x2215, 0x00A8}, {0x2219, 0x002B}, {0x2215, 0x00A9},
{0x2219, 0x00EB}, {0x2215, 0x00AA}, {0x2219, 0x00C7}, {0x2215, 0x00AB},
{0x2219, 0x0050}, {0x2215, 0x00AC}, {0x2219, 0x0080}, {0x2215, 0x00AD},
{0x2219, 0x00E0}, {0x2215, 0x00AE}, {0x2219, 0x0094}, {0x2215, 0x00AF},
{0x2219, 0x00E0}, {0x2215, 0x00B0}, {0x2219, 0x0000}, {0x2215, 0x00B1},
{0x2219, 0x0044}, {0x2215, 0x00B2}, {0x2219, 0x0021}, {0x2215, 0x00B3},
{0x2219, 0x0044}, {0x2215, 0x00B4}, {0x2219, 0x0020}, {0x2215, 0x00B5},
{0x2219, 0x0094}, {0x2215, 0x00B6}, {0x2219, 0x00FF}, {0x2215, 0x00B7},
{0x2219, 0x004A}, {0x2215, 0x00B8}, {0x2219, 0x0001}, {0x2215, 0x00B9},
{0x2219, 0x002A}, {0x2215, 0x00BA}, {0x2219, 0x0094}, {0x2215, 0x00BB},
{0x2219, 0x007F}, {0x2215, 0x0171}, {0x2219, 0x004B}, {0x2215, 0x0172},
{0x2219, 0x0019}, {0x2215, 0x0174}, {0x2219, 0x0041}, {0x2215, 0x0175},
{0x2219, 0x0039}, {0x2215, 0x0178}, {0x2219, 0x0079}, {0x2215, 0x017E},
{0x2219, 0x009C}, {0x2215, 0x018F}, {0x2219, 0x0071}, {0x2215, 0x0192},
{0x2219, 0x0079}, {0x2215, 0x0197}, {0x2219, 0x0079}, {0x2215, 0x01AD},
{0x2219, 0x009D}, {0x2215, 0x01B4}, {0x2219, 0x009C}, {0x2215, 0x01C0},
{0x2219, 0x0042}, {0x2215, 0x01C1}, {0x2219, 0x0037}, {0x2215, 0x01C2},
{0x2219, 0x00E1}, {0x2215, 0x01C3}, {0x2219, 0x00D7}, {0x2215, 0x01C4},
{0x2219, 0x00E1}, {0x2215, 0x01C5}, {0x2219, 0x00D7}, {0x2215, 0x01C6},
{0x2219, 0x00E1}, {0x2215, 0x01C7}, {0x2219, 0x00D7}, {0x2215, 0x01C8},
{0x2219, 0x00E1}, {0x2215, 0x01C9}, {0x2219, 0x00D7}, {0x2215, 0x01CA},
{0x2219, 0x00E1}, {0x2215, 0x01CB}, {0x2219, 0x00D7}, {0x2215, 0x01CC},
{0x2219, 0x00E1}, {0x2215, 0x01CD}, {0x2219, 0x00D7}, {0x2215, 0x01CE},
{0x2219, 0x00E1}, {0x2215, 0x01CF}, {0x2219, 0x00D7}, {0x2215, 0x01D0},
{0x2219, 0x00E1}, {0x2215, 0x01D1}, {0x2219, 0x00D7}, {0x2215, 0x01D2},
{0x2219, 0x00E1}, {0x2215, 0x01D3}, {0x2219, 0x00D7}, {0x2215, 0x01D4},
{0x2219, 0x00E1}, {0x2215, 0x01D5}, {0x2219, 0x00D7}, {0x2215, 0x01D6},
{0x2219, 0x00C1}, {0x2215, 0x01D7}, {0x2219, 0x009D}, {0x2215, 0x01D8},
{0x2219, 0x0095}, {0x2215, 0x01D9}, {0x2219, 0x009E}, {0x2215, 0x01DA},
{0x2219, 0x009A}, {0x2215, 0x01DB}, {0x2219, 0x0089}, {0x2215, 0x01DC},
{0x2219, 0x007B}, {0x2215, 0x01DD}, {0x2219, 0x00A4}, {0x2215, 0x01DE},
{0x2219, 0x002B}, {0x2215, 0x01DF}, {0x2219, 0x00F8}, {0x2215, 0x01E0},
{0x2219, 0x00A2}, {0x2215, 0x01E1}, {0x2219, 0x001C}, {0x2215, 0x01E2},
{0x2219, 0x0009}, {0x2215, 0x01E3}, {0x2219, 0x00E0}, {0x2215, 0x01E4},
{0x2219, 0x0081}, {0x2215, 0x01E5}, {0x2219, 0x00E0}, {0x2215, 0x01E6},
{0x2219, 0x0081}, {0x2215, 0x01E7}, {0x2219, 0x00E0}, {0x2215, 0x01E8},
{0x2219, 0x0081}, {0x2215, 0x01E9}, {0x2219, 0x00E0}, {0x2215, 0x01EA},
{0x2219, 0x0081}, {0x2215, 0x01F3}, {0x2219, 0x00D7}, {0x2216, 0x0000},
{0x221F, 0x0007}, {0x221E, 0x0040}, {0x2218, 0x0004}, {0x221F, 0x0000},
{0x2217, 0x2160}, {0x221F, 0x0007}, {0x221E, 0x0040}, {0x2218, 0x0874},
{0x2219, 0x8C00}, {0x2218, 0x08A4}, {0x2219, 0x4000}, {0x2218, 0x08B4},
{0x2219, 0x0400}, {0x2218, 0x08C4}, {0x2219, 0xFF00}, {0x2218, 0x08D4},
{0x2219, 0x0500}, {0x2218, 0x08E4}, {0x2219, 0x8500}, {0x2218, 0x08F4},
{0x2219, 0x8C00}, {0x2218, 0x0904}, {0x2219, 0xFA00}, {0x2218, 0x0914},
{0x2219, 0xE000}, {0x2218, 0x0924}, {0x2219, 0x0000}, {0x2218, 0x0934},
{0x2219, 0x4000}, {0x2218, 0x0944}, {0x2219, 0x4400}, {0x2218, 0x0954},
{0x2219, 0x5400}, {0x2218, 0x0964}, {0x2219, 0xFF00}, {0x2218, 0x0994},
{0x2219, 0x1400}, {0x2218, 0x0A84}, {0x2219, 0x1400}, {0x2218, 0x0B84},
{0x2219, 0x1400}, {0x2218, 0x1944}, {0x2219, 0x8C00}, {0x2218, 0x1974},
{0x2219, 0x4000}, {0x2218, 0x1984}, {0x2219, 0x0400}, {0x2218, 0x1994},
{0x2219, 0xFF00}, {0x2218, 0x19A4}, {0x2219, 0x0500}, {0x2218, 0x19B4},
{0x2219, 0x8500}, {0x2218, 0x19C4}, {0x2219, 0x8C00}, {0x2218, 0x19D4},
{0x2219, 0xFA00}, {0x2218, 0x19E4}, {0x2219, 0xE000}, {0x2218, 0x19F4},
{0x2219, 0x0000}, {0x2218, 0x1A04}, {0x2219, 0x4000}, {0x2218, 0x1A14},
{0x2219, 0x4400}, {0x2218, 0x1A24}, {0x2219, 0x5400}, {0x2218, 0x1A34},
{0x2219, 0xFF00}, {0x2218, 0x1A64}, {0x2219, 0x1400}, {0x2218, 0x1B54},
{0x2219, 0x1400}, {0x2218, 0x1C54}, {0x2219, 0x1400}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0007}, {0x221E, 0x0040}, {0x2218, 0x0000},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x221F, 0x0000},
{0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E}, {0x221F, 0x0007},
{0x221E, 0x0042}, {0x2215, 0x0F02}, {0x2216, 0x9406}, {0x2215, 0x0E02},
{0x2215, 0x0F02}, {0x2215, 0x0F06}, {0x2216, 0x950A}, {0x2215, 0x0E06},
{0x2215, 0x0F06}, {0x2215, 0x0F07}, {0x2216, 0x7408}, {0x2215, 0x0E07},
{0x2215, 0x0F07}, {0x2215, 0x0F08}, {0x2216, 0x5808}, {0x2215, 0x0E08},
{0x2215, 0x0F08}, {0x2215, 0x0F09}, {0x2216, 0x080C}, {0x2215, 0x0E09},
{0x2215, 0x0F09}, {0x2215, 0x0F0A}, {0x2216, 0x7408}, {0x2215, 0x0E0A},
{0x2215, 0x0F0A}, {0x2215, 0x0F0B}, {0x2216, 0x5800}, {0x2215, 0x0E0B},
{0x2215, 0x0F0B}, {0x2215, 0x0F0C}, {0x2216, 0x9400}, {0x2215, 0x0E0C},
{0x2215, 0x0F0C}, {0x2215, 0x0F0D}, {0x2216, 0x0803}, {0x2215, 0x0E0D},
{0x2215, 0x0F0D}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0007},
{0x221E, 0x0042}, {0x2215, 0x0D00}, {0x2215, 0x0100}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0005}, {0x2205, 0x8000}, {0x2206, 0x0280}, {0x2206, 0x28F7},
{0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080}, {0x2206, 0x02AE},
{0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201}, {0x2206, 0x6602},
{0x2206, 0x8074}, {0x2206, 0xE08B}, {0x2206, 0x8CE1}, {0x2206, 0x8B8D},
{0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E}, {0x2206, 0x01A0},
{0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEE85}, {0x2206, 0xDE00},
{0x2206, 0xEE85}, {0x2206, 0xDF00}, {0x2206, 0xEE8A}, {0x2206, 0xFC07},
{0x2206, 0xEE8A}, {0x2206, 0xFD73}, {0x2206, 0xD483}, {0x2206, 0x83E4},
{0x2206, 0x8B92}, {0x2206, 0xE58B}, {0x2206, 0x93D4}, {0x2206, 0x837A},
{0x2206, 0xE48B}, {0x2206, 0x94E5}, {0x2206, 0x8B95}, {0x2206, 0xD483},
{0x2206, 0x71E4}, {0x2206, 0x8B96}, {0x2206, 0xE58B}, {0x2206, 0x97EE},
{0x2206, 0xE144}, {0x2206, 0x77EE}, {0x2206, 0xE145}, {0x2206, 0x85EE},
{0x2206, 0xE150}, {0x2206, 0xFFEE}, {0x2206, 0xE151}, {0x2206, 0xFEEE},
{0x2206, 0x8B82}, {0x2206, 0x85EE}, {0x2206, 0x8B87}, {0x2206, 0x80EE},
{0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7}, {0x2206, 0xFE04},
{0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20}, {0x2206, 0x26F6},
{0x2206, 0x20E4}, {0x2206, 0x8B8E}, {0x2206, 0x0229}, {0x2206, 0x2102},
{0x2206, 0x2671}, {0x2206, 0x0227}, {0x2206, 0x4B02}, {0x2206, 0x8155},
{0x2206, 0x0282}, {0x2206, 0x3302}, {0x2206, 0x02B0}, {0x2206, 0x0228},
{0x2206, 0x9B02}, {0x2206, 0x8102}, {0x2206, 0x0229}, {0x2206, 0xFB02},
{0x2206, 0x2BA2}, {0x2206, 0x0229}, {0x2206, 0x91E0}, {0x2206, 0x8B8E},
{0x2206, 0xAD21}, {0x2206, 0x08F6}, {0x2206, 0x21E4}, {0x2206, 0x8B8E},
{0x2206, 0x0202}, {0x2206, 0x8FE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD22},
{0x2206, 0x05F6}, {0x2206, 0x22E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x2305}, {0x2206, 0xF623}, {0x2206, 0xE48B},
{0x2206, 0x8EE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD24}, {0x2206, 0x08F6},
{0x2206, 0x24E4}, {0x2206, 0x8B8E}, {0x2206, 0x0228}, {0x2206, 0x14E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD25}, {0x2206, 0x05F6}, {0x2206, 0x25E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x260B},
{0x2206, 0xF626}, {0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x069E},
{0x2206, 0x021E}, {0x2206, 0x15E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD27},
{0x2206, 0x05F6}, {0x2206, 0x27E4}, {0x2206, 0x8B8E}, {0x2206, 0x0204},
{0x2206, 0x1902}, {0x2206, 0x0488}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85DE}, {0x2206, 0xE385}, {0x2206, 0xDF02}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85DE}, {0x2206, 0x00EE},
{0x2206, 0x85DF}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xDEE7}, {0x2206, 0x85DF}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xDE00}, {0x2206, 0xEE85}, {0x2206, 0xDF00}, {0x2206, 0xFDFC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x3FE0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2C}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2120}, {0x2206, 0xE18B}, {0x2206, 0x70F7},
{0x2206, 0x29E5}, {0x2206, 0x8B70}, {0x2206, 0xAC27}, {0x2206, 0x0DAC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x58AE}, {0x2206, 0x1302},
{0x2206, 0x056A}, {0x2206, 0xAE0E}, {0x2206, 0x0281}, {0x2206, 0xA302},
{0x2206, 0x8300}, {0x2206, 0xAE06}, {0x2206, 0x0205}, {0x2206, 0x0E02},
{0x2206, 0x8346}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04D1},
{0x2206, 0x02BF}, {0x2206, 0x351E}, {0x2206, 0x022E}, {0x2206, 0x88BF},
{0x2206, 0x2A58}, {0x2206, 0x022E}, {0x2206, 0xC6AC}, {0x2206, 0x280B},
{0x2206, 0x0281}, {0x2206, 0xEED1}, {0x2206, 0x01BF}, {0x2206, 0x3533},
{0x2206, 0x022E}, {0x2206, 0x88D0}, {0x2206, 0x1102}, {0x2206, 0x2D33},
{0x2206, 0x5903}, {0x2206, 0xEF01}, {0x2206, 0xD100}, {0x2206, 0xA000},
{0x2206, 0x02D1}, {0x2206, 0x01BF}, {0x2206, 0x3521}, {0x2206, 0x022E},
{0x2206, 0x88D1}, {0x2206, 0x11AD}, {0x2206, 0x2002}, {0x2206, 0x0C11},
{0x2206, 0xAD21}, {0x2206, 0x020C}, {0x2206, 0x12BF}, {0x2206, 0x3524},
{0x2206, 0x022E}, {0x2206, 0x8802}, {0x2206, 0x2AB0}, {0x2206, 0x0206},
{0x2206, 0x5B04}, {0x2206, 0xF8E0}, {0x2206, 0x8B80}, {0x2206, 0xAD27},
{0x2206, 0x3CEE}, {0x2206, 0xE232}, {0x2206, 0x00EE}, {0x2206, 0xE233},
{0x2206, 0x07EE}, {0x2206, 0xE230}, {0x2206, 0x00EE}, {0x2206, 0xE231},
{0x2206, 0xBDE0}, {0x2206, 0xEACA}, {0x2206, 0xE1EA}, {0x2206, 0xCBAD},
{0x2206, 0x2A13}, {0x2206, 0xE0EA}, {0x2206, 0xCCE1}, {0x2206, 0xEACD},
{0x2206, 0xAD2A}, {0x2206, 0x0AEE}, {0x2206, 0xE238}, {0x2206, 0x00EE},
{0x2206, 0xE239}, {0x2206, 0x3BAE}, {0x2206, 0x08EE}, {0x2206, 0xE238},
{0x2206, 0x00EE}, {0x2206, 0xE239}, {0x2206, 0x0CEE}, {0x2206, 0xE232},
{0x2206, 0x00EE}, {0x2206, 0xE233}, {0x2206, 0x00FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2730}, {0x2206, 0xE0E0},
{0x2206, 0x36E1}, {0x2206, 0xE037}, {0x2206, 0xE18B}, {0x2206, 0x731F},
{0x2206, 0x109E}, {0x2206, 0x23E4}, {0x2206, 0x8B73}, {0x2206, 0xAC20},
{0x2206, 0x0BAC}, {0x2206, 0x210D}, {0x2206, 0xAC25}, {0x2206, 0x0FAC},
{0x2206, 0x2711}, {0x2206, 0xAE12}, {0x2206, 0x022C}, {0x2206, 0x88AE},
{0x2206, 0x0D02}, {0x2206, 0x826C}, {0x2206, 0xAE08}, {0x2206, 0x0282},
{0x2206, 0x73AE}, {0x2206, 0x0302}, {0x2206, 0x2CA7}, {0x2206, 0xFC04},
{0x2206, 0x0282}, {0x2206, 0xBD02}, {0x2206, 0x2CF7}, {0x2206, 0x04F8},
{0x2206, 0xF901}, {0x2206, 0x11E0}, {0x2206, 0x8B87}, {0x2206, 0xAD26},
{0x2206, 0x08D1}, {0x2206, 0x01BF}, {0x2206, 0x2D30}, {0x2206, 0x022E},
{0x2206, 0x88FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA}, {0x2206, 0xEF69},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x2726}, {0x2206, 0xD00B},
{0x2206, 0x022D}, {0x2206, 0x33AC}, {0x2206, 0x2A05}, {0x2206, 0xBF83},
{0x2206, 0xF2AE}, {0x2206, 0x03BF}, {0x2206, 0x83F5}, {0x2206, 0x022E},
{0x2206, 0xC6AC}, {0x2206, 0x2810}, {0x2206, 0xD101}, {0x2206, 0xBF83},
{0x2206, 0xF802}, {0x2206, 0x2E88}, {0x2206, 0xD100}, {0x2206, 0xBF83},
{0x2206, 0xF802}, {0x2206, 0x2E88}, {0x2206, 0xEF96}, {0x2206, 0xFEFC},
{0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85}, {0x2206, 0xAD26},
{0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2D33}, {0x2206, 0x5882},
{0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B}, {0x2206, 0x68E1},
{0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9E23}, {0x2206, 0x10E4},
{0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1}, {0x2206, 0xE001},
{0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5}, {0x2206, 0xE001},
{0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021}, {0x2206, 0xAD30},
{0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000}, {0x2206, 0xE5E0},
{0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA}, {0x2206, 0xEF69},
{0x2206, 0xE08B}, {0x2206, 0x82AD}, {0x2206, 0x2737}, {0x2206, 0xBF83},
{0x2206, 0xEC02}, {0x2206, 0x2EC6}, {0x2206, 0xAC28}, {0x2206, 0x2ED1},
{0x2206, 0x01BF}, {0x2206, 0x83EF}, {0x2206, 0x022E}, {0x2206, 0x88BF},
{0x2206, 0x83E9}, {0x2206, 0x022E}, {0x2206, 0xC6E5}, {0x2206, 0x85DD},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0xAC2E},
{0x2206, 0x04D1}, {0x2206, 0x01AE}, {0x2206, 0x02D1}, {0x2206, 0x00BF},
{0x2206, 0x83E9}, {0x2206, 0x022E}, {0x2206, 0x88D1}, {0x2206, 0x01BF},
{0x2206, 0x83EC}, {0x2206, 0x022E}, {0x2206, 0x88EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8FA}, {0x2206, 0xEF69}, {0x2206, 0xBF83},
{0x2206, 0xEF02}, {0x2206, 0x2EC6}, {0x2206, 0xAD28}, {0x2206, 0x19D1},
{0x2206, 0x00BF}, {0x2206, 0x83EC}, {0x2206, 0x022E}, {0x2206, 0x88E1},
{0x2206, 0x85DD}, {0x2206, 0xBF83}, {0x2206, 0xE902}, {0x2206, 0x2E88},
{0x2206, 0xD100}, {0x2206, 0xBF83}, {0x2206, 0xEF02}, {0x2206, 0x2E88},
{0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04EE}, {0x2206, 0xE08E},
{0x2206, 0x32EE}, {0x2206, 0xE08F}, {0x2206, 0x2105}, {0x2206, 0xEEE0},
{0x2206, 0x8E32}, {0x2206, 0xEEE0}, {0x2206, 0x8F20}, {0x2206, 0x05F8},
{0x2206, 0xE0E0}, {0x2206, 0x38E1}, {0x2206, 0xE039}, {0x2206, 0xAD2F},
{0x2206, 0x10E0}, {0x2206, 0xE034}, {0x2206, 0xE1E0}, {0x2206, 0x35F7},
{0x2206, 0x26E4}, {0x2206, 0xE034}, {0x2206, 0xE5E0}, {0x2206, 0x35AE},
{0x2206, 0x0EE0}, {0x2206, 0xE2D6}, {0x2206, 0xE1E2}, {0x2206, 0xD7F7},
{0x2206, 0x28E4}, {0x2206, 0xE2D6}, {0x2206, 0xE5E2}, {0x2206, 0xD7E0},
{0x2206, 0xE232}, {0x2206, 0xE1E2}, {0x2206, 0x33F7}, {0x2206, 0x2DE4},
{0x2206, 0xE232}, {0x2206, 0xE5E2}, {0x2206, 0x33D0}, {0x2206, 0x7DB0},
{0x2206, 0xFEE0}, {0x2206, 0xE232}, {0x2206, 0xE1E2}, {0x2206, 0x33F6},
{0x2206, 0x2DE4}, {0x2206, 0xE232}, {0x2206, 0xE5E2}, {0x2206, 0x33E0},
{0x2206, 0xE034}, {0x2206, 0xE1E0}, {0x2206, 0x35F6}, {0x2206, 0x26E4},
{0x2206, 0xE034}, {0x2206, 0xE5E0}, {0x2206, 0x35E0}, {0x2206, 0xE2D6},
{0x2206, 0xE1E2}, {0x2206, 0xD7F6}, {0x2206, 0x28E4}, {0x2206, 0xE2D6},
{0x2206, 0xE5E2}, {0x2206, 0xD7FC}, {0x2206, 0x0555}, {0x2206, 0xE020},
{0x2206, 0x55E2}, {0x2206, 0xD600}, {0x2206, 0xE24A}, {0x2206, 0x65E0},
{0x2206, 0x0887}, {0x2206, 0xE008}, {0x2206, 0x44E0}, {0x2206, 0x2800},
{0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405},
{0x220F, 0x0000}, {0x221F, 0x0007}, {0x221E, 0x0041}, {0x2216, 0x1345},
{0x221F, 0x0000}, {0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x808E},
{0x221F, 0x0003}, {0x2218, 0x8001}, {0x2205, 0x8B80}, {0x2206, 0x4890},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x2000, 0x1340}, {0x2020, 0x1340},
{0x2040, 0x1340}, {0x2060, 0x1340}, {0x2080, 0x1340}
};
/*End of ChipData101[][2]*/

rtk_uint16 ChipData102[][2]= {
{0x1d32, 0x0002}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x1200, 0x7FCB}
};
/*End of ChipData102[][2]*/

#endif

CONST_T rtk_uint8 filter_templateField[RTL8367B_ACLTEMPLATENO][RTL8367B_ACLRULEFIELDNO] = {
    {ACL_DMAC0,   			ACL_DMAC1, 		 	ACL_DMAC2, 	 		ACL_SMAC0,   		ACL_SMAC1, 			ACL_SMAC2, 			ACL_ETHERTYPE, 		ACL_FIELD_SELECT15},
    {ACL_IP4SIP0, 			ACL_IP4SIP1, 		ACL_IP4DIP0, 		ACL_IP4DIP1, 		ACL_FIELD_SELECT13, ACL_FIELD_SELECT14, ACL_FIELD_SELECT02, ACL_FIELD_SELECT15},
    {ACL_IP6SIP0WITHIPV4,	ACL_IP6SIP1WITHIPV4,ACL_FIELD_SELECT03, ACL_FIELD_SELECT04, ACL_FIELD_SELECT05,	ACL_FIELD_SELECT06, ACL_FIELD_SELECT07,	ACL_FIELD_SELECT08},
    {ACL_IP6DIP0WITHIPV4,	ACL_IP6DIP1WITHIPV4,ACL_FIELD_SELECT09, ACL_FIELD_SELECT10, ACL_FIELD_SELECT11,	ACL_FIELD_SELECT12, ACL_FIELD_SELECT13,	ACL_FIELD_SELECT14},
    {ACL_VIDRANGE,			ACL_IPRANGE, 		ACL_PORTRANGE,  	ACL_CTAG,  			ACL_STAG, 			ACL_FIELD_SELECT13, ACL_FIELD_SELECT14,	ACL_FIELD_SELECT15}
};

CONST_T rtk_uint8 filter_advanceCaretagField[RTL8367B_ACLTEMPLATENO][2] = {
    {TRUE,		7},
    {TRUE,		7},
    {FALSE,		0},
    {FALSE,		0},
    {TRUE,		7},
};


CONST_T rtk_uint8 filter_fieldTemplateIndex[FILTER_FIELD_END][RTK_FILTER_FIELD_USED_MAX] = {
	{0x00, 0x01,0x02},
	{0x03, 0x04,0x05},
	{0x06},
	{0x43},
	{0x44},
	{0x10, 0x11},
	{0x12, 0x13},
	{0x24},
	{0x25},
	{0x35},
	{0x35},
	{0x20, 0x21,0x22,0x23},
	{0x30, 0x31,0x32,0x33},
	{0x26},
	{0x27},
	{0x14},
	{0x15},
	{0x16},
	{0x14},
	{0x15},
	{0x14},
	{0x14},
	{0x14},

	{0x40},
	{0x41},
	{0x42},

	{0x14},
	{0x15},
	{0x16},
	{0x22},
	{0x23},
	{0x24},
	{0x25},
	{0x26},
	{0x27},
	{0x32},
	{0x33},
	{0x34},
	{0x35},
	{0x36},
	{0x37},
	{0x47},

    {0xFF} /* Pattern Match */
};

CONST_T rtk_uint8 filter_fieldSize[FILTER_FIELD_END] = {
    3, 3, 1, 1, 1,
    2, 2, 1, 1, 1, 1, 4, 4, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    8
};

CONST_T rtk_uint16 field_selector[RTL8367B_FIELDSEL_FORMAT_NUMBER][2] =
{
    {FIELDSEL_FORMAT_DEFAULT, 0},    /* Field Selector 0 */
    {FIELDSEL_FORMAT_DEFAULT, 0},    /* Field Selector 1 */
    {FIELDSEL_FORMAT_IPPAYLOAD, 12}, /* Field Selector 2 */
    {FIELDSEL_FORMAT_IPV6, 10},      /* Field Selector 3 */
    {FIELDSEL_FORMAT_IPV6, 8},       /* Field Selector 4 */
    {FIELDSEL_FORMAT_IPV4, 0},       /* Field Selector 5 */
    {FIELDSEL_FORMAT_IPV4, 8},       /* Field Selector 6 */
    {FIELDSEL_FORMAT_IPV6, 0},       /* Field Selector 7 */
    {FIELDSEL_FORMAT_IPV6, 6},       /* Field Selector 8 */
    {FIELDSEL_FORMAT_IPV6, 26},      /* Field Selector 9 */
    {FIELDSEL_FORMAT_IPV6, 24},      /* Field Selector 10 */
    {FIELDSEL_FORMAT_DEFAULT, 0},    /* Field Selector 11 */
    {FIELDSEL_FORMAT_IPV4, 6},       /* Field Selector 12 */
    {FIELDSEL_FORMAT_IPPAYLOAD, 0},  /* Field Selector 13 */
    {FIELDSEL_FORMAT_IPPAYLOAD, 2},  /* Field Selector 14 */
    {FIELDSEL_FORMAT_DEFAULT, 0}     /* Field Selector 15 */
};


static rtk_api_ret_t _rtk_filter_igrAcl_writeDataField(rtl8367b_aclrule *aclRule, rtk_filter_field_t *fieldPtr);
static rtk_api_ret_t _rtk_switch_init_setreg(rtk_uint32 reg, rtk_uint32 data);

/* Function Name:
 *      rtk_rate_shareMeter_set
 * Description:
 *      Set meter configuration
 * Input:
 *      index       - shared meter index
 *      rate        - rate of share meter
 *      ifg_include - include IFG or not, ENABLE:include DISABLE:exclude
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_FILTER_METER_ID  - Invalid meter
 *      RT_ERR_RATE             - Invalid rate
 *      RT_ERR_INPUT            - Invalid input parameters
 * Note:
 *      The API can set shared meter rate and ifg include for each meter.
 *      The rate unit is 1 kbps and the range is from 8k to 1048568k.
 *      The granularity of rate is 8 kbps. The ifg_include parameter is used
 *      for rate calculation with/without inter-frame-gap and preamble.
 */
rtk_api_ret_t rtk_rate_shareMeter_set(rtk_meter_id_t index, rtk_rate_t rate, rtk_enable_t ifg_include)
{
    rtk_api_ret_t retVal;

    if (index >= RTL8367B_METERNO)
        return RT_ERR_FILTER_METER_ID;

    if (rate > RTL8367B_QOS_RATE_INPUT_MAX || rate < RTL8367B_QOS_RATE_INPUT_MIN)
        return RT_ERR_RATE ;

    if (ifg_include >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicShareMeter(index, rate >> 3, ifg_include)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_rate_shareMeter_get
 * Description:
 *      Get meter configuration
 * Input:
 *      index        - shared meter index
 * Output:
 *      pRate        - pointer of rate of share meter
 *      pIfg_include - include IFG or not, ENABLE:include DISABLE:exclude
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_FILTER_METER_ID  - Invalid meter
 * Note:
 *      The API can get shared meter rate and ifg include for each meter.
 *      The rate unit is 1 kbps and the granularity of rate is 8 kbps.
 *      The ifg_include parameter is used for rate calculation with/without inter-frame-gap and preamble
 */
rtk_api_ret_t rtk_rate_shareMeter_get(rtk_meter_id_t index, rtk_rate_t *pRate , rtk_enable_t *pIfg_include)
{
    rtk_api_ret_t retVal;
    rtk_uint32 regData;

    if (index > RTL8367B_METERNO)
        return RT_ERR_FILTER_METER_ID;

    if ((retVal = rtl8367b_getAsicShareMeter(index, &regData, pIfg_include)) != RT_ERR_OK)
        return retVal;

    *pRate = regData<<3;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_rate_shareMeterBucket_set
 * Description:
 *      Set meter Bucket Size
 * Input:
 *      index        - shared meter index
 *      bucket_size  - Bucket Size
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_INPUT            - Error Input
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_FILTER_METER_ID  - Invalid meter
 * Note:
 *      The API can set shared meter bucket size.
 */
rtk_api_ret_t rtk_rate_shareMeterBucket_set(rtk_meter_id_t index, rtk_uint32 bucket_size)
{
    rtk_api_ret_t retVal;

    if (index > RTL8367B_METERNO)
        return RT_ERR_FILTER_METER_ID;

    if(bucket_size > RTL8367B_METERBUCKETSIZEMAX)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicShareMeterBucketSize(index, bucket_size)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_rate_shareMeterBucket_get
 * Description:
 *      Get meter Bucket Size
 * Input:
 *      index        - shared meter index
 * Output:
 *      pBucket_size - Bucket Size
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_FILTER_METER_ID  - Invalid meter
 * Note:
 *      The API can get shared meter bucket size.
 */
rtk_api_ret_t rtk_rate_shareMeterBucket_get(rtk_meter_id_t index, rtk_uint32 *pBucket_size)
{
    rtk_api_ret_t retVal;

    if (index > RTL8367B_METERNO)
        return RT_ERR_FILTER_METER_ID;

    if ((retVal = rtl8367b_getAsicShareMeterBucketSize(index, pBucket_size)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_rate_igrBandwidthCtrlRate_set
 * Description:
 *      Set port ingress bandwidth control
 * Input:
 *      port        - Port id
 *      rate        - Rate of share meter
 *      ifg_include - include IFG or not, ENABLE:include DISABLE:exclude
 *      fc_enable   - enable flow control or not, ENABLE:use flow control DISABLE:drop
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 *      RT_ERR_ENABLE 		- Invalid IFG parameter.
 *      RT_ERR_INBW_RATE 	- Invalid ingress rate parameter.
 * Note:
 *      The rate unit is 1 kbps and the range is from 8k to 1048568k. The granularity of rate is 8 kbps.
 *      The ifg_include parameter is used for rate calculation with/without inter-frame-gap and preamble.
 */
rtk_api_ret_t rtk_rate_igrBandwidthCtrlRate_set(rtk_port_t port, rtk_rate_t rate,  rtk_enable_t ifg_include, rtk_enable_t fc_enable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((rate > RTL8367B_QOS_RATE_INPUT_MAX) || (rate < RTL8367B_QOS_RATE_INPUT_MIN))
        return RT_ERR_INBW_RATE ;

    if (ifg_include >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsicPortIngressBandwidth(port, rate>>3, ifg_include,fc_enable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_rate_igrBandwidthCtrlRate_get
 * Description:
 *      Get port ingress bandwidth control
 * Input:
 *      port - Port id
 * Output:
 *      pRate           - Rate of share meter
 *      pIfg_include    - Rate's calculation including IFG, ENABLE:include DISABLE:exclude
 *      pFc_enable      - enable flow control or not, ENABLE:use flow control DISABLE:drop
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *     The rate unit is 1 kbps and the range is from 8k to 1048568k. The granularity of rate is 8 kbps.
 *     The ifg_include parameter is used for rate calculation with/without inter-frame-gap and preamble.
 */
rtk_api_ret_t rtk_rate_igrBandwidthCtrlRate_get(rtk_port_t port, rtk_rate_t *pRate, rtk_enable_t *pIfg_include, rtk_enable_t *pFc_enable)
{
    rtk_api_ret_t retVal;
    rtk_uint32 regData;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortIngressBandwidth(port, &regData, pIfg_include, pFc_enable)) != RT_ERR_OK)
        return retVal;

    *pRate = regData<<3;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_rate_egrBandwidthCtrlRate_set
 * Description:
 *      Set port egress bandwidth control
 * Input:
 *      port        - Port id
 *      rate        - Rate of egress bandwidth
 *      ifg_include - include IFG or not, ENABLE:include DISABLE:exclude
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_QOS_EBW_RATE - Invalid egress bandwidth/rate
 * Note:
 *     The rate unit is 1 kbps and the range is from 8k to 1048568k. The granularity of rate is 8 kbps.
 *     The ifg_include parameter is used for rate calculation with/without inter-frame-gap and preamble.
 */
rtk_api_ret_t rtk_rate_egrBandwidthCtrlRate_set( rtk_port_t port, rtk_rate_t rate,  rtk_enable_t ifg_include)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((rate > RTL8367B_QOS_RATE_INPUT_MAX) || (rate < RTL8367B_QOS_RATE_INPUT_MIN))
        return RT_ERR_QOS_EBW_RATE ;

    if (ifg_include >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsicPortEgressRate(port, rate>>3)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPortEgressRateIfg(ifg_include)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_rate_egrBandwidthCtrlRate_get
 * Description:
 *      Get port egress bandwidth control
 * Input:
 *      port - Port id
 * Output:
 *      pRate           - Rate of egress bandwidth
 *      pIfg_include    - Rate's calculation including IFG, ENABLE:include DISABLE:exclude
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *     The rate unit is 1 kbps and the range is from 8k to 1048568k. The granularity of rate is 8 kbps.
 *     The ifg_include parameter is used for rate calculation with/without inter-frame-gap and preamble.
 */
rtk_api_ret_t rtk_rate_egrBandwidthCtrlRate_get(rtk_port_t port, rtk_rate_t *pRate, rtk_enable_t *pIfg_include)
{
    rtk_api_ret_t retVal;
    rtk_uint32 regData;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortEgressRate(port, &regData)) != RT_ERR_OK)
        return retVal;

    *pRate = regData << 3;

    if ((retVal = rtl8367b_getAsicPortEgressRateIfg((rtk_uint32*)pIfg_include)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}


/* Function Name:
 *      rtk_rate_egrQueueBwCtrlEnable_get
 * Description:
 *      Get enable status of egress bandwidth control on specified queue.
 * Input:
 *      unit    - unit id
 *      port    - port id
 *      queue   - queue id
 * Output:
 *      pEnable - Pointer to enable status of egress queue bandwidth control
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_PORT_ID          - invalid port id
 *      RT_ERR_QUEUE_ID         - invalid queue id
 *      RT_ERR_NULL_POINTER     - input parameter may be null pointer
 * Note:
 *      None
 */
rtk_api_ret_t rtk_rate_egrQueueBwCtrlEnable_get(rtk_port_t port, rtk_qid_t queue, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    /*for whole port function, the queue value should be 0xFF*/
    if (queue != RTK_WHOLE_SYSTEM)
        return RT_ERR_QUEUE_ID;

    if ((retVal = rtl8367b_getAsicAprEnable(port,pEnable))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_rate_egrQueueBwCtrlEnable_set
 * Description:
 *      Set enable status of egress bandwidth control on specified queue.
 * Input:
 *      port   - port id
 *      queue  - queue id
 *      enable - enable status of egress queue bandwidth control
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_PORT_ID          - invalid port id
 *      RT_ERR_QUEUE_ID         - invalid queue id
 *      RT_ERR_INPUT            - invalid input parameter
 * Note:
 *      None
 */
rtk_api_ret_t rtk_rate_egrQueueBwCtrlEnable_set(rtk_port_t port, rtk_qid_t queue, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    /*for whole port function, the queue value should be 0xFF*/
    if (queue != RTK_WHOLE_SYSTEM)
        return RT_ERR_QUEUE_ID;

    if (enable>=RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicAprEnable(port,enable))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_rate_egrQueueBwCtrlRate_get
 * Description:
 *      Get rate of egress bandwidth control on specified queue.
 * Input:
 *      port  - port id
 *      queue - queue id
 *      pIndex - shared meter index
 * Output:
 *      pRate - pointer to rate of egress queue bandwidth control
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_PORT_ID          - invalid port id
 *      RT_ERR_QUEUE_ID         - invalid queue id
 *      RT_ERR_FILTER_METER_ID  - Invalid meter id
 * Note:
 *    The actual rate control is set in shared meters.
 *    The unit of granularity is 8Kbps.
 */
rtk_api_ret_t rtk_rate_egrQueueBwCtrlRate_get(rtk_port_t port, rtk_qid_t queue, rtk_meter_id_t *pIndex)
{
    rtk_api_ret_t retVal;
    rtk_uint32 offset_idx;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (queue >= RTK_MAX_NUM_OF_QUEUE)
        return RT_ERR_QUEUE_ID;


    if ((retVal=rtl8367b_getAsicAprMeter(port,queue,&offset_idx))!=RT_ERR_OK)
        return retVal;

    *pIndex = offset_idx + ((port%4)*8);

     return RT_ERR_OK;
}


/* Function Name:
 *      rtk_rate_egrQueueBwCtrlRate_set
 * Description:
 *      Set rate of egress bandwidth control on specified queue.
 * Input:
 *      port  - port id
 *      queue - queue id
 *      index - shared meter index
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 *      RT_ERR_PORT_ID          - invalid port id
 *      RT_ERR_QUEUE_ID         - invalid queue id
 *      RT_ERR_FILTER_METER_ID  - Invalid meter id
 * Note:
 *    The actual rate control is set in shared meters.
 *    The unit of granularity is 8Kbps.
 */
rtk_api_ret_t rtk_rate_egrQueueBwCtrlRate_set(rtk_port_t port, rtk_qid_t queue, rtk_meter_id_t index)
{
    rtk_api_ret_t retVal;
    rtk_uint32 offset_idx;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (queue >= RTK_MAX_NUM_OF_QUEUE)
        return RT_ERR_QUEUE_ID;

    if (index>=RTK_MAX_NUM_OF_METER)
        return RT_ERR_FILTER_METER_ID;

    if (index < ((port%4)*8) ||  index > (7 + (port%4)*8))
        return RT_ERR_FILTER_METER_ID;

    offset_idx = index - ((port%4)*8);

    if ((retVal=rtl8367b_setAsicAprMeter(port,queue,offset_idx))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}


/* Function Name:
 *      rtk_qos_init
 * Description:
 *      Configure Qos default settings with queue number assigment to each port.
 * Input:
 *      queueNum - Queue number of each port.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_QUEUE_NUM 	- Invalid queue number.
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API will initialize related Qos setting with queue number assigment.
 *      The queue number is from 1 to 8.
 */
rtk_api_ret_t rtk_qos_init(rtk_queue_num_t queueNum)
{
    CONST_T rtk_uint16 g_prioritytToQid[8][8]= {
            {0, 0,0,0,0,0,0,0},
            {0, 0,0,0,7,7,7,7},
            {0, 0,0,0,1,1,7,7},
            {0, 0,1,1,2,2,7,7},
            {0, 0,1,1,2,3,7,7},
            {0, 0,1,2,3,4,7,7},
            {0, 0,1,2,3,4,5,7},
            {0,1,2,3,4,5,6,7}
    };

    CONST_T rtk_uint32 g_priorityDecision[8] = {0x01, 0x80,0x04,0x02,0x20,0x40,0x10,0x08};
    CONST_T rtk_uint32 g_prioritytRemap[8] = {0,1,2,3,4,5,6,7};

    rtk_api_ret_t retVal;
    rtk_uint32 qmapidx;
    rtk_uint32 priority;
    rtk_uint32 priDec;
    rtk_uint32 port;
    rtk_uint32 dscp;

    if (queueNum <= 0 || queueNum > RTL8367B_QUEUENO)
        return RT_ERR_QUEUE_NUM;

    /*Set Output Queue Number*/
    if (RTL8367B_QUEUENO == queueNum)
        qmapidx = 0;
    else
        qmapidx = queueNum;

    for (port = 0; port < RTK_MAX_NUM_OF_PORT; port++)
    {
        if ((retVal = rtl8367b_setAsicOutputQueueMappingIndex(port, qmapidx)) != RT_ERR_OK)
            return retVal;
    }

    /*Set Priority to Qid*/
    for (priority = 0; priority <= RTL8367B_PRIMAX; priority++)
    {
        if ((retVal = rtl8367b_setAsicPriorityToQIDMappingTable((queueNum - 1), priority, g_prioritytToQid[queueNum - 1][priority])) != RT_ERR_OK)
            return retVal;
    }

    /*Set Flow Control Type to Ingress Flow Control*/
    if ((retVal = rtl8367b_setAsicFlowControlSelect(FC_INGRESS)) != RT_ERR_OK)
        return retVal;


    /*Priority Decision Order*/
    for (priDec = 0;priDec < PRIDEC_END;priDec++)
    {
        if ((retVal = rtl8367b_setAsicPriorityDecision(priDec, g_priorityDecision[priDec])) != RT_ERR_OK)
            return retVal;
    }

    /*Set Port-based Priority to 0*/
    for (port = 0;port < RTK_MAX_NUM_OF_PORT;port++)
    {
        if ((retVal = rtl8367b_setAsicPriorityPortBased(port, 0)) != RT_ERR_OK)
            return retVal;
    }

    /*Disable 1p Remarking*/
    for (port = 0; port < RTK_MAX_NUM_OF_PORT; port++)
    {
        if ((retVal = rtl8367b_setAsicRemarkingDot1pAbility(port, DISABLE)) != RT_ERR_OK)
            return retVal;
    }

    /*Disable DSCP Remarking*/
    if ((retVal = rtl8367b_setAsicRemarkingDscpAbility(DISABLE)) != RT_ERR_OK)
        return retVal;

    /*Set 1p & DSCP  Priority Remapping & Remarking*/
    for (priority = 0; priority <= RTL8367B_PRIMAX; priority++)
    {
        if ((retVal = rtl8367b_setAsicPriorityDot1qRemapping(priority, g_prioritytRemap[priority])) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicRemarkingDot1pParameter(priority, 0)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicRemarkingDscpParameter(priority, 0)) != RT_ERR_OK)
            return retVal;
    }

    /*Set DSCP Priority*/
    for (dscp = 0; dscp <= 63; dscp++)
    {
        if ((retVal = rtl8367b_setAsicPriorityDscpBased(dscp, 0)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_priSel_set
 * Description:
 *      Configure the priority order among different priority mechanism.
 * Input:
 *      pPriDec - Priority assign for port, dscp, 802.1p, cvlan, svlan, acl based priority decision.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              		- OK
 *      RT_ERR_FAILED          		- Failed
 *      RT_ERR_SMI             		- SMI access error
 *      RT_ERR_QOS_SEL_PRI_SOURCE 	- Invalid priority decision source parameter.
 * Note:
 *      ASIC will follow user priority setting of mechanisms to select mapped queue priority for receiving frame.
 *      If two priority mechanisms are the same, the ASIC will chose the highest priority from mechanisms to
 *      assign queue priority to receiving frame.
 *      The priority sources are:
 *      - PRIDEC_PORT
 *      - PRIDEC_ACL
 *      - PRIDEC_DSCP
 *      - PRIDEC_1Q
 *      - PRIDEC_1AD
 *      - PRIDEC_CVLAN
 *      - PRIDEC_DA
 *      - PRIDEC_SA
 */
rtk_api_ret_t rtk_qos_priSel_set(rtk_priority_select_t *pPriDec)
{
    rtk_api_ret_t retVal;
    rtk_uint32 port_pow;
    rtk_uint32 dot1q_pow;
    rtk_uint32 dscp_pow;
    rtk_uint32 acl_pow;
    rtk_uint32 svlan_pow;
    rtk_uint32 cvlan_pow;
    rtk_uint32 smac_pow;
    rtk_uint32 dmac_pow;
    rtk_uint32 i;

    if (pPriDec->port_pri > 8 || pPriDec->dot1q_pri > 8 || pPriDec->acl_pri > 8 || pPriDec->dscp_pri > 8 ||
       pPriDec->cvlan_pri > 8 || pPriDec->svlan_pri > 8 || pPriDec->dmac_pri > 8 || pPriDec->smac_pri > 8)
        return RT_ERR_QOS_SEL_PRI_SOURCE;

    port_pow = 1;
    for (i = pPriDec->port_pri; i > 0; i--)
        port_pow = (port_pow)*2;

    dot1q_pow = 1;
    for (i = pPriDec->dot1q_pri; i > 0; i--)
        dot1q_pow = (dot1q_pow)*2;

    acl_pow = 1;
    for (i = pPriDec->acl_pri; i > 0; i--)
        acl_pow = (acl_pow)*2;

    dscp_pow = 1;
    for (i = pPriDec->dscp_pri; i > 0; i--)
        dscp_pow = (dscp_pow)*2;

    svlan_pow = 1;
    for (i = pPriDec->svlan_pri; i > 0; i--)
        svlan_pow = (svlan_pow)*2;

    cvlan_pow = 1;
    for (i = pPriDec->cvlan_pri; i > 0; i--)
        cvlan_pow = (cvlan_pow)*2;

    dmac_pow = 1;
    for (i = pPriDec->dmac_pri; i > 0; i--)
        dmac_pow = (dmac_pow)*2;

    smac_pow = 1;
    for (i = pPriDec->smac_pri; i > 0; i--)
        smac_pow = (smac_pow)*2;

    if ((retVal = rtl8367b_setAsicPriorityDecision(PRIDEC_PORT, port_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPriorityDecision(PRIDEC_ACL, acl_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPriorityDecision(PRIDEC_DSCP, dscp_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPriorityDecision(PRIDEC_1Q, dot1q_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPriorityDecision(PRIDEC_1AD, svlan_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPriorityDecision(PRIDEC_CVLAN, cvlan_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPriorityDecision(PRIDEC_DA, dmac_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPriorityDecision(PRIDEC_SA, smac_pow)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_priSel_get
 * Description:
 *      Get the priority order configuration among different priority mechanism.
 * Input:
 *      None
 * Output:
 *      pPriDec - Priority assign for port, dscp, 802.1p, cvlan, svlan, acl based priority decision .
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      ASIC will follow user priority setting of mechanisms to select mapped queue priority for receiving frame.
 *      If two priority mechanisms are the same, the ASIC will chose the highest priority from mechanisms to
 *      assign queue priority to receiving frame.
 *      The priority sources are:
 *      - PRIDEC_PORT,
 *      - PRIDEC_ACL,
 *      - PRIDEC_DSCP,
 *      - PRIDEC_1Q,
 *      - PRIDEC_1AD,
 *      - PRIDEC_CVLAN,
 *      - PRIDEC_DA,
 *      - PRIDEC_SA,
 */
rtk_api_ret_t rtk_qos_priSel_get(rtk_priority_select_t *pPriDec)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtk_uint32 port_pow;
    rtk_uint32 dot1q_pow;
    rtk_uint32 dscp_pow;
    rtk_uint32 acl_pow;
    rtk_uint32 svlan_pow;
    rtk_uint32 cvlan_pow;
    rtk_uint32 smac_pow;
    rtk_uint32 dmac_pow;

    if ((retVal = rtl8367b_getAsicPriorityDecision(PRIDEC_PORT, &port_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPriorityDecision(PRIDEC_ACL, &acl_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPriorityDecision(PRIDEC_DSCP, &dscp_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPriorityDecision(PRIDEC_1Q, &dot1q_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPriorityDecision(PRIDEC_1AD, &svlan_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPriorityDecision(PRIDEC_CVLAN, &cvlan_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPriorityDecision(PRIDEC_DA, &dmac_pow)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPriorityDecision(PRIDEC_SA, &smac_pow)) != RT_ERR_OK)
        return retVal;

    for (i = 31; i >= 0; i--)
    {
        if (port_pow & (1 << i))
        {
            pPriDec->port_pri = i;
            break;
        }
    }

    for (i = 31; i >= 0; i--)
    {
        if (dot1q_pow & (1 << i))
        {
            pPriDec->dot1q_pri = i;
            break;
        }
    }

    for (i = 31; i >= 0; i--)
    {
        if (acl_pow & (1 << i))
        {
            pPriDec->acl_pri = i;
            break;
        }
    }

    for (i = 31; i >= 0; i--)
    {
        if (dscp_pow & (1 << i))
        {
            pPriDec->dscp_pri = i;
            break;
        }
    }

    for (i = 31; i >= 0; i--)
    {
        if (svlan_pow & (1 << i))
        {
            pPriDec->svlan_pri = i;
            break;
        }
    }

    for (i = 31;i  >= 0; i--)
    {
        if (cvlan_pow & (1 << i))
        {
            pPriDec->cvlan_pri = i;
            break;
        }
    }

    for (i = 31; i >= 0; i--)
    {
        if (dmac_pow&(1<<i))
        {
            pPriDec->dmac_pri = i;
            break;
        }
    }

    for (i = 31; i >= 0; i--)
    {
        if (smac_pow & (1 << i))
        {
            pPriDec->smac_pri = i;
            break;
        }
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_1pPriRemap_set
 * Description:
 *      Configure 1Q priorities mapping to internal absolute priority.
 * Input:
 *      dot1p_pri   - 802.1p priority value.
 *      int_pri     - internal priority value.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_INPUT 			- Invalid input parameters.
 *      RT_ERR_VLAN_PRIORITY 	- Invalid 1p priority.
 *      RT_ERR_QOS_INT_PRIORITY - Invalid priority.
 * Note:
 *      Priority of 802.1Q assignment for internal asic priority, and it is used for queue usage and packet scheduling.
 */
rtk_api_ret_t rtk_qos_1pPriRemap_set(rtk_pri_t dot1p_pri, rtk_pri_t int_pri)
{
    rtk_api_ret_t retVal;

    if (int_pri > RTL8367B_PRIMAX)
        return  RT_ERR_QOS_INT_PRIORITY;

    if (dot1p_pri > RTL8367B_PRIMAX || int_pri > RTL8367B_PRIMAX)
        return  RT_ERR_VLAN_PRIORITY;

    if ((retVal = rtl8367b_setAsicPriorityDot1qRemapping(dot1p_pri, int_pri)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_1pPriRemap_get
 * Description:
 *      Get 1Q priorities mapping to internal absolute priority.
 * Input:
 *      dot1p_pri - 802.1p priority value .
 * Output:
 *      pInt_pri - internal priority value.
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_VLAN_PRIORITY 	- Invalid priority.
 *      RT_ERR_QOS_INT_PRIORITY - Invalid priority.
 * Note:
 *      Priority of 802.1Q assigment for internal asic priority, and it is uesed for queue usage and packet scheduling.
 */
rtk_api_ret_t rtk_qos_1pPriRemap_get(rtk_pri_t dot1p_pri, rtk_pri_t *pInt_pri)
{
    rtk_api_ret_t retVal;

    if (dot1p_pri > RTL8367B_PRIMAX)
        return  RT_ERR_QOS_INT_PRIORITY;

    if ((retVal = rtl8367b_getAsicPriorityDot1qRemapping(dot1p_pri, pInt_pri)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_dscpPriRemap_set
 * Description:
 *      Map dscp value to internal priority.
 * Input:
 *      dscp    - Dscp value of receiving frame
 *      int_pri - internal priority value .
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_INPUT 			- Invalid input parameters.
 *      RT_ERR_QOS_DSCP_VALUE 	- Invalid DSCP value.
 *      RT_ERR_QOS_INT_PRIORITY - Invalid priority.
 * Note:
 *      The Differentiated Service Code Point is a selector for router's per-hop behaviors. As a selector, there is no implication that a numerically
 *      greater DSCP implies a better network service. As can be seen, the DSCP totally overlaps the old precedence field of TOS. So if values of
 *      DSCP are carefully chosen then backward compatibility can be achieved.
 */
rtk_api_ret_t rtk_qos_dscpPriRemap_set(rtk_dscp_t dscp, rtk_pri_t int_pri)
{
    rtk_api_ret_t retVal;

    if (int_pri > RTL8367B_PRIMAX )
        return RT_ERR_QOS_INT_PRIORITY;

    if (dscp > RTL8367B_DSCPMAX)
        return RT_ERR_QOS_DSCP_VALUE;

    if ((retVal = rtl8367b_setAsicPriorityDscpBased(dscp, int_pri)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_dscpPriRemap_get
 * Description:
 *      Get dscp value to internal priority.
 * Input:
 *      dscp - Dscp value of receiving frame
 * Output:
 *      pInt_pri - internal priority value.
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_QOS_DSCP_VALUE 	- Invalid DSCP value.
 * Note:
 *      The Differentiated Service Code Point is a selector for router's per-hop behaviors. As a selector, there is no implication that a numerically
 *      greater DSCP implies a better network service. As can be seen, the DSCP totally overlaps the old precedence field of TOS. So if values of
 *      DSCP are carefully chosen then backward compatibility can be achieved.
 */
rtk_api_ret_t rtk_qos_dscpPriRemap_get(rtk_dscp_t dscp, rtk_pri_t *pInt_pri)
{
    rtk_api_ret_t retVal;

    if (dscp > RTL8367B_DSCPMAX)
        return RT_ERR_QOS_DSCP_VALUE;

    if ((retVal = rtl8367b_getAsicPriorityDscpBased(dscp, pInt_pri)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_portPri_set
 * Description:
 *      Configure priority usage to each port.
 * Input:
 *      port - Port id.
 *      int_pri - internal priority value.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_QOS_SEL_PORT_PRI - Invalid port priority.
 *      RT_ERR_QOS_INT_PRIORITY - Invalid priority.
 * Note:
 *      The API can set priority of port assignments for queue usage and packet scheduling.
 */
rtk_api_ret_t rtk_qos_portPri_set(rtk_port_t port, rtk_pri_t int_pri)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (int_pri > RTL8367B_PRIMAX )
        return RT_ERR_QOS_INT_PRIORITY;

    if ((retVal = rtl8367b_setAsicPriorityPortBased(port, int_pri)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_portPri_get
 * Description:
 *      Get priority usage to each port.
 * Input:
 *      port - Port id.
 * Output:
 *      pInt_pri - internal priority value.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can get priority of port assignments for queue usage and packet scheduling.
 */
rtk_api_ret_t rtk_qos_portPri_get(rtk_port_t port, rtk_pri_t *pInt_pri)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPriorityPortBased(port, pInt_pri)) != RT_ERR_OK)
        return retVal;


    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_queueNum_set
 * Description:
 *      Set output queue number for each port.
 * Input:
 *      port    - Port id.
 *      index   - Mapping queue number (1~8)
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 *      RT_ERR_QUEUE_NUM 	- Invalid queue number.
 * Note:
 *      The API can set the output queue number of the specified port. The queue number is from 1 to 8.
 */
rtk_api_ret_t rtk_qos_queueNum_set(rtk_port_t port, rtk_queue_num_t queue_num)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((0 == queue_num) || (queue_num > RTL8367B_QUEUENO))
        return RT_ERR_FAILED;

    if (RTL8367B_QUEUENO == queue_num)
        queue_num = 0;

    if ((retVal = rtl8367b_setAsicOutputQueueMappingIndex(port, queue_num)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_queueNum_get
 * Description:
 *      Get output queue number.
 * Input:
 *      port - Port id.
 * Output:
 *      pQueue_num - Mapping queue number
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 * Note:
 *      The API will return the output queue number of the specified port. The queue number is from 1 to 8.
 */
rtk_api_ret_t rtk_qos_queueNum_get(rtk_port_t port, rtk_queue_num_t *pQueue_num)
{
    rtk_api_ret_t retVal;
    rtk_uint32 qidx;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicOutputQueueMappingIndex(port, &qidx)) != RT_ERR_OK)
        return retVal;

    if (0 == qidx)
        *pQueue_num = 8;
    else
        *pQueue_num = qidx;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_priMap_set
 * Description:
 *      Set output queue number for each port.
 * Input:
 *      queue_num   - Queue number usage.
 *      pPri2qid    - Priority mapping to queue ID.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_INPUT 			- Invalid input parameters.
 *      RT_ERR_QUEUE_NUM 		- Invalid queue number.
 *      RT_ERR_QUEUE_ID 		- Invalid queue id.
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_QOS_INT_PRIORITY - Invalid priority.
 * Note:
 *      ASIC supports priority mapping to queue with different queue number from 1 to 8.
 *      For different queue numbers usage, ASIC supports different internal available queue IDs.
 */
rtk_api_ret_t rtk_qos_priMap_set(rtk_queue_num_t queue_num, rtk_qos_pri2queue_t *pPri2qid)
{
    rtk_api_ret_t retVal;
    rtk_uint32 pri;

    if ((0 == queue_num) || (queue_num > RTL8367B_QUEUENO))
        return RT_ERR_QUEUE_NUM;

    for (pri = 0; pri <= RTL8367B_PRIMAX; pri++)
    {
        if (pPri2qid->pri2queue[pri] > RTL8367B_QIDMAX)
            return RT_ERR_QUEUE_ID;

        if ((retVal = rtl8367b_setAsicPriorityToQIDMappingTable(queue_num - 1, pri, pPri2qid->pri2queue[pri])) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_priMap_get
 * Description:
 *      Get priority to queue ID mapping table parameters.
 * Input:
 *      queue_num - Queue number usage.
 * Output:
 *      pPri2qid - Priority mapping to queue ID.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_QUEUE_NUM 	- Invalid queue number.
 * Note:
 *      The API can return the mapping queue id of the specified priority and queue number.
 *      The queue number is from 1 to 8.
 */
rtk_api_ret_t rtk_qos_priMap_get(rtk_queue_num_t queue_num, rtk_qos_pri2queue_t *pPri2qid)
{
    rtk_api_ret_t retVal;
    rtk_uint32 pri;

    if ((0 == queue_num) || (queue_num > RTL8367B_QUEUENO))
        return RT_ERR_QUEUE_NUM;

    for (pri = 0; pri <= RTL8367B_PRIMAX; pri++)
    {
        if ((retVal = rtl8367b_getAsicPriorityToQIDMappingTable(queue_num-1, pri, &pPri2qid->pri2queue[pri])) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_schedulingQueue_set
 * Description:
 *      Set weight and type of queues in dedicated port.
 * Input:
 *      port        - Port id.
 *      pQweights   - The array of weights for WRR/WFQ queue (0 for STRICT_PRIORITY queue).
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_QOS_QUEUE_WEIGHT - Invalid queue weight.
 * Note:
 *      The API can set weight and type, strict priority or weight fair queue (WFQ) for
 *      dedicated port for using queues. If queue id is not included in queue usage,
 *      then its type and weight setting in dummy for setting. There are priorities
 *      as queue id in strict queues. It means strict queue id 5 carrying higher priority
 *      than strict queue id 4. The WFQ queue weight is from 1 to 128, and weight 0 is
 *      for strict priority queue type.
 */
rtk_api_ret_t rtk_qos_schedulingQueue_set(rtk_port_t port, rtk_qos_queue_weights_t *pQweights)
{
    rtk_api_ret_t retVal;
    rtk_uint32 qid;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_FAILED;


    for (qid = 0; qid < RTL8367B_QUEUENO; qid ++)
    {

        if (pQweights->weights[qid] > QOS_WEIGHT_MAX)
            return RT_ERR_QOS_QUEUE_WEIGHT;

        if (0 == pQweights->weights[qid])
        {
            if ((retVal = rtl8367b_setAsicQueueType(port, qid, QTYPE_STRICT)) != RT_ERR_OK)
                return retVal;
        }
        else
        {
            if ((retVal = rtl8367b_setAsicQueueType(port, qid, QTYPE_WFQ)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicWFQWeight(port,qid, pQweights->weights[qid])) != RT_ERR_OK)
                return retVal;
        }
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_schedulingQueue_get
 * Description:
 *      Get weight and type of queues in dedicated port.
 * Input:
 *      port - Port id.
 * Output:
 *      pQweights - The array of weights for WRR/WFQ queue (0 for STRICT_PRIORITY queue).
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_PORT_ID 		- Invalid port number.
 * Note:
 *      The API can get weight and type, strict priority or weight fair queue (WFQ) for dedicated port for using queues.
 *      The WFQ queue weight is from 1 to 128, and weight 0 is for strict priority queue type.
 */
rtk_api_ret_t rtk_qos_schedulingQueue_get(rtk_port_t port, rtk_qos_queue_weights_t *pQweights)
{
    rtk_api_ret_t retVal;
    rtk_uint32 qid,qtype,qweight;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_FAILED;

    for (qid = 0; qid < RTL8367B_QUEUENO; qid++)
    {
        if ((retVal = rtl8367b_getAsicQueueType(port, qid, &qtype)) != RT_ERR_OK)
            return retVal;

        if (QTYPE_STRICT == qtype)
        {
            pQweights->weights[qid] = 0;
        }
        else if (QTYPE_WFQ == qtype)
        {
            if ((retVal = rtl8367b_getAsicWFQWeight(port, qid, &qweight)) != RT_ERR_OK)
                return retVal;
            pQweights->weights[qid] = qweight;
        }
    }
    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_1pRemarkEnable_set
 * Description:
 *      Set 1p Remarking state
 * Input:
 *      port        - Port id.
 *      enable      - State of per-port 1p Remarking
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 *      RT_ERR_ENABLE 		- Invalid enable parameter.
 * Note:
 *      The API can enable or disable 802.1p remarking ability for whole system.
 *      The status of 802.1p remark:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_qos_1pRemarkEnable_set(rtk_port_t port, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_FAILED;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicRemarkingDot1pAbility(port, enable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_1pRemarkEnable_get
 * Description:
 *      Get 802.1p remarking ability.
 * Input:
 *      port - Port id.
 * Output:
 *      pEnable - Status of 802.1p remark.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 * Note:
 *      The API can get 802.1p remarking ability.
 *      The status of 802.1p remark:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_qos_1pRemarkEnable_get(rtk_port_t port, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_FAILED;

    if ((retVal = rtl8367b_getAsicRemarkingDot1pAbility(port, pEnable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_1pRemark_set
 * Description:
 *      Set 802.1p remarking parameter.
 * Input:
 *      int_pri     - Internal priority value.
 *      dot1p_pri   - 802.1p priority value.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_VLAN_PRIORITY 	- Invalid 1p priority.
 *      RT_ERR_QOS_INT_PRIORITY - Invalid priority.
 * Note:
 *      The API can set 802.1p parameters source priority and new priority.
 */
rtk_api_ret_t rtk_qos_1pRemark_set(rtk_pri_t int_pri, rtk_pri_t dot1p_pri)
{
    rtk_api_ret_t retVal;

    if (int_pri > RTL8367B_PRIMAX )
        return RT_ERR_QOS_INT_PRIORITY;

    if (dot1p_pri > RTL8367B_PRIMAX)
        return RT_ERR_VLAN_PRIORITY;

    if ((retVal = rtl8367b_setAsicRemarkingDot1pParameter(int_pri, dot1p_pri)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_1pRemark_get
 * Description:
 *      Get 802.1p remarking parameter.
 * Input:
 *      int_pri - Internal priority value.
 * Output:
 *      pDot1p_pri - 802.1p priority value.
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_QOS_INT_PRIORITY - Invalid priority.
 * Note:
 *      The API can get 802.1p remarking parameters. It would return new priority of ingress priority.
 */
rtk_api_ret_t rtk_qos_1pRemark_get(rtk_pri_t int_pri, rtk_pri_t *pDot1p_pri)
{
    rtk_api_ret_t retVal;

    if (int_pri > RTL8367B_PRIMAX )
        return RT_ERR_QOS_INT_PRIORITY;

    if ((retVal = rtl8367b_getAsicRemarkingDot1pParameter(int_pri, pDot1p_pri)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_dscpRemarkEnable_set
 * Description:
 *      Set DSCP remarking ability.
 * Input:
 *      port    - Port id.
 *      enable  - status of DSCP remark.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_QOS_INT_PRIORITY - Invalid priority.
 *      RT_ERR_ENABLE 			- Invalid enable parameter.
 * Note:
 *      The API can enable or disable DSCP remarking ability for whole system.
 *      The status of DSCP remark:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_qos_dscpRemarkEnable_set(rtk_port_t port, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    /*for whole system function, the port value should be 0xFF*/
    if (port != RTK_WHOLE_SYSTEM)
        return RT_ERR_PORT_ID;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicRemarkingDscpAbility(enable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_dscpRemarkEnable_get
 * Description:
 *      Get DSCP remarking ability.
 * Input:
 *      port - Port id.
 * Output:
 *      pEnable - status of DSCP remarking.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 * Note:
 *      The API can get DSCP remarking ability.
 *      The status of DSCP remark:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_qos_dscpRemarkEnable_get(rtk_port_t port, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    /*for whole system function, the port value should be 0xFF*/
    if (port != RTK_WHOLE_SYSTEM)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicRemarkingDscpAbility(pEnable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_qos_dscpRemark_set
 * Description:
 *      Set DSCP remarking parameter.
 * Input:
 *      int_pri - Internal priority value.
 *      dscp    - DSCP value.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_QOS_INT_PRIORITY - Invalid priority.
 *      RT_ERR_QOS_DSCP_VALUE 	- Invalid DSCP value.
 * Note:
 *      The API can set DSCP value and mapping priority.
 */
rtk_api_ret_t rtk_qos_dscpRemark_set(rtk_pri_t int_pri, rtk_dscp_t dscp)
{
    rtk_api_ret_t retVal;

    if (int_pri > RTL8367B_PRIMAX )
        return RT_ERR_QOS_INT_PRIORITY;

    if (dscp > RTL8367B_DSCPMAX)
        return RT_ERR_QOS_DSCP_VALUE;

    if ((retVal = rtl8367b_setAsicRemarkingDscpParameter(int_pri, dscp)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}


/* Function Name:
 *      rtk_qos_dscpRemark_get
 * Description:
 *      Get DSCP remarking parameter.
 * Input:
 *      int_pri - Internal priority value.
 * Output:
 *      Dscp - DSCP value.
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_QOS_INT_PRIORITY - Invalid priority.
 * Note:
 *      The API can get DSCP parameters. It would return DSCP value for mapping priority.
 */
rtk_api_ret_t rtk_qos_dscpRemark_get(rtk_pri_t int_pri, rtk_dscp_t *pDscp)
{
    rtk_api_ret_t retVal;

    if (int_pri > RTL8367B_PRIMAX )
        return RT_ERR_QOS_INT_PRIORITY;

    if ((retVal = rtl8367b_getAsicRemarkingDscpParameter(int_pri, pDscp)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trap_unknownUnicastPktAction_set
 * Description:
 *      Set unknown unicast packet action configuration.
 * Input:
 *      type            - Unknown unicast packet type.
 *      ucast_action    - Unknown unicast action.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_NOT_ALLOWED 		- Invalid action.
 *      RT_ERR_INPUT 			- Invalid input parameters.
 * Note:
 *      This API can set unknown unicast packet action configuration.
 *      (1) The unknown unicast packet type is as following:
 *          - UCAST_UNKNOWNDA
 *          - UCAST_UNKNOWNSA
 *          - UCAST_UNMATCHSA
 *      (2) The unknown unicast action is as following:
 *          - UCAST_ACTION_FORWARD
 *          - UCAST_ACTION_DROP
 *          - UCAST_ACTION_TRAP2CPU
 */
rtk_api_ret_t rtk_trap_unknownUnicastPktAction_set(rtk_trap_ucast_type_t type, rtk_trap_ucast_action_t ucast_action)
{
    rtk_api_ret_t retVal;

    if (type >= UCAST_END)
        return RT_ERR_INPUT;

    if (ucast_action >= UCAST_ACTION_END)
        return RT_ERR_INPUT;


    switch (type)
    {
        case UCAST_UNKNOWNDA:
            if ((retVal = rtl8367b_setAsicPortUnknownDaBehavior(ucast_action)) != RT_ERR_OK)
                return retVal;
            break;
        case UCAST_UNKNOWNSA:
            if ((retVal = rtl8367b_setAsicPortUnknownSaBehavior(ucast_action)) != RT_ERR_OK)
                return retVal;
            break;
        case UCAST_UNMATCHSA:
            if ((retVal = rtl8367b_setAsicPortUnmatchedSaBehavior(ucast_action)) != RT_ERR_OK)
                return retVal;
            break;
        default:
            break;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trap_unknownUnicastPktAction_get
 * Description:
 *      Get unknown unicast packet action configuration.
 * Input:
 *      type - unknown unicast packet type.
 * Output:
 *      pUcast_action - unknown unicast action.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can get unknown unicast packet action configuration.
 *      (1) The unknown unicast packet type is as following:
 *          - UCAST_UNKNOWNDA
 *          - UCAST_UNKNOWNSA
 *          - UCAST_UNMATCHSA
 *      (2) The unknown unicast action is as following:
 *          - UCAST_ACTION_FORWARD
 *          - UCAST_ACTION_DROP
 *          - UCAST_ACTION_TRAP2CPU
 */
rtk_api_ret_t rtk_trap_unknownUnicastPktAction_get(rtk_trap_ucast_type_t type, rtk_trap_ucast_action_t *pUcast_action)
{
    rtk_api_ret_t retVal;

    if (type >= UCAST_END)
        return RT_ERR_INPUT;

    switch (type)
    {
        case UCAST_UNKNOWNDA:
            if ((retVal = rtl8367b_getAsicPortUnknownDaBehavior(pUcast_action)) != RT_ERR_OK)
                return retVal;
            break;
        case UCAST_UNKNOWNSA:
            if ((retVal = rtl8367b_getAsicPortUnknownSaBehavior((rtk_uint32*)pUcast_action)) != RT_ERR_OK)
                return retVal;
            break;
        case UCAST_UNMATCHSA:
            if ((retVal = rtl8367b_getAsicPortUnmatchedSaBehavior((rtk_uint32*)pUcast_action)) != RT_ERR_OK)
                return retVal;
            break;
        default:
            break;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trap_rmaAction_set
 * Description:
 *      Set reserved multicast address frame trap to CPU.
 * Input:
 *      pRma_frame - Reserved multicast address.
 *      rma_action - RMA action.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_NOT_ALLOWED 		- Invalid action.
 *      RT_ERR_INPUT 			- Invalid input parameters.
 * Note:
 *      There are 48 types of Reserved Multicast Address frame for application usage.
 *      (1) They are as following definition.
 *      - DMAC                        Assignment
 *      - 01-80-C2-00-00-00           Bridge Group Address
 *      - 01-80-C2-00-00-01           IEEE Std 802.3, 1988 Edition Full Duplex PAUSE operation
 *      - 01-80-C2-00-00-02           IEEE Std 802.3ad Slow Protocols-Multicast Address
 *      - 01-80-C2-00-00-03           IEEE Std 802.1X PAE address
 *      - 01-80-C2-00-00-04           Undefined 802.1 bridge address 04
 *      - 01-80-C2-00-00-05           Undefined 802.1 bridge address 05
 *      - 01-80-C2-00-00-06           Undefined 802.1 bridge address 06
 *      - 01-80-C2-00-00-07           Undefined 802.1 bridge address 07
 *      - 01-80-C2-00-00-08           Provider Bridge Group Address
 *      - 01-80-C2-00-00-09           Undefined 802.1 bridge address 09
 *      - 01-80-C2-00-00-0A           Undefined 802.1 bridge address 0A
 *      - 01-80-C2-00-00-0B           Undefined 802.1 bridge address 0B
 *      - 01-80-C2-00-00-0C           Undefined 802.1 bridge address 0C
 *      - 01-80-C2-00-00-0D           Provider Bridge GVRP Address
 *      - 01-80-C2-00-00-0E           IEEE Std 802.1ab Link Layer Discovery Protocol Multicast address
 *      - 01-80-C2-00-00-0F           Undefined 802.1 bridge address
 *      - 01-80-C2-00-00-10           All LANs Bridge Management Group Address
 *      - 01-80-C2-00-00-11~1F        Undefined address 11~1F
 *      - 01-80-C2-00-00-20           GMRP Address
 *      - 01-80-C2-00-00-21           GVRP address
 *      - 01-80-C2-00-00-22~2F        Undefined GARP address 22~2F
 *      (2) The RMA action is as following:
 *      - RMA_ACTION_FORWARD
 *      - RMA_ACTION_TRAP2CPU
 *      - RMA_ACTION_DROP
 *      - RMA_ACTION_FORWARD_EXCLUDE_CPU
 */
rtk_api_ret_t rtk_trap_rmaAction_set(rtk_mac_t *pRma_frame, rtk_trap_rma_action_t rma_action)
{
    rtk_api_ret_t retVal;
    rtl8367b_rma_t rmacfg;

    if (pRma_frame->octet[0] != 0x01 && pRma_frame->octet[1] != 0x80 && pRma_frame->octet[2] != 0xC2
        && pRma_frame->octet[3] != 0 && pRma_frame->octet[4] != 0 && pRma_frame->octet[5] > 0x2F)
        return RT_ERR_RMA_ADDR;

    if (rma_action >= RMA_ACTION_END)
        return RT_ERR_RMA_ACTION;

    if ((retVal = rtl8367b_getAsicRma(pRma_frame->octet[5], &rmacfg)) != RT_ERR_OK)
        return retVal;

    rmacfg.operation = rma_action;

    if ((retVal = rtl8367b_setAsicRma(pRma_frame->octet[5], &rmacfg)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trap_rmaAction_get
 * Description:
 *      Get reserved multicast address frame trap to CPU.
 * Input:
 *      type - unknown unicast packet type.
 * Output:
 *      pRma_action - RMA action.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can retrieved RMA configuration.
 *      (1) They are as following definition.
 *      - DMAC                        Assignment
 *      - 01-80-C2-00-00-00           Bridge Group Address
 *      - 01-80-C2-00-00-01           IEEE Std 802.3, 1988 Edition Full Duplex PAUSE operation
 *      - 01-80-C2-00-00-02           IEEE Std 802.3ad Slow Protocols-Multicast Address
 *      - 01-80-C2-00-00-03           IEEE Std 802.1X PAE address
 *      - 01-80-C2-00-00-04           Undefined 802.1 bridge address 04
 *      - 01-80-C2-00-00-05           Undefined 802.1 bridge address 05
 *      - 01-80-C2-00-00-06           Undefined 802.1 bridge address 06
 *      - 01-80-C2-00-00-07           Undefined 802.1 bridge address 07
 *      - 01-80-C2-00-00-08           Provider Bridge Group Address
 *      - 01-80-C2-00-00-09           Undefined 802.1 bridge address 09
 *      - 01-80-C2-00-00-0A           Undefined 802.1 bridge address 0A
 *      - 01-80-C2-00-00-0B           Undefined 802.1 bridge address 0B
 *      - 01-80-C2-00-00-0C           Undefined 802.1 bridge address 0C
 *      - 01-80-C2-00-00-0D           Provider Bridge GVRP Address
 *      - 01-80-C2-00-00-0E           IEEE Std 802.1ab Link Layer Discovery Protocol Multicast address
 *      - 01-80-C2-00-00-0F           Undefined 802.1 bridge address
 *      - 01-80-C2-00-00-10           All LANs Bridge Management Group Address
 *      - 01-80-C2-00-00-11~1F        Undefined address 11~1F
 *      - 01-80-C2-00-00-20           GMRP Address
 *      - 01-80-C2-00-00-21           GVRP address
 *      - 01-80-C2-00-00-22~2F        Undefined GARP address 22~2F
 *      (2) The RMA action is as following:
 *      - RMA_ACTION_FORWARD
 *      - RMA_ACTION_TRAP2CPU
 *      - RMA_ACTION_DROP
 *      - RMA_ACTION_FORWARD_EXCLUDE_CPU
 */
rtk_api_ret_t rtk_trap_rmaAction_get(rtk_mac_t *pRma_frame, rtk_trap_rma_action_t *pRma_action)
{
    rtk_api_ret_t retVal;
    rtl8367b_rma_t rmacfg;

    if (pRma_frame->octet[0] != 0x01 && pRma_frame->octet[1] != 0x80 && pRma_frame->octet[2] != 0xC2
        && pRma_frame->octet[3] !=0 && pRma_frame->octet[4] != 0 && pRma_frame->octet[5] > 0x2F)
        return RT_ERR_RMA_ADDR;

    if ((retVal = rtl8367b_getAsicRma(pRma_frame->octet[5], &rmacfg)) != RT_ERR_OK)
        return retVal;

    *pRma_action = rmacfg.operation;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trap_igmpCtrlPktAction_set
 * Description:
 *      Set IGMP/MLD trap function
 * Input:
 *      type        - IGMP/MLD packet type.
 *      igmp_action - IGMP/MLD action.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_NOT_ALLOWED 	- Invalid igmp action.
 * Note:
 *      This API can set both IPv4 IGMP/IPv6 MLD with/without PPPoE header trapping function.
 *      All 4 kinds of IGMP/MLD function can be set seperately.
 *      (1) The IGMP/MLD packet type is as following:
 *          - IGMP_IPV4
 *          - IGMP_PPPOE_IPV4
 *          - IGMP_MLD
 *          - IGMP_PPPOE_MLD
 *      (2) The IGMP/MLD action is as following:
 *          - IGMP_ACTION_FORWARD
 *          - IGMP_ACTION_TRAP2CPU
 *          - IGMP_ACTION_DROP
 *          - IGMP_ACTION_FORWARD_EXCLUDE_CPU
 */
rtk_api_ret_t rtk_trap_igmpCtrlPktAction_set(rtk_igmp_type_t type, rtk_trap_igmp_action_t igmp_action)
{
    rtk_api_ret_t   retVal;
    rtk_uint32          igmp_op;
    rtk_port_t      port;

    if (type >= IGMP_TYPE_END)
        return RT_ERR_INPUT;

    if (igmp_action >= IGMP_ACTION_END)
        return RT_ERR_NOT_ALLOWED;

    switch (igmp_action)
    {
        case IGMP_ACTION_FORWARD:
            igmp_op = PROTOCOL_OP_FLOOD;
            break;
        case IGMP_ACTION_TRAP2CPU:
            igmp_op = PROTOCOL_OP_TRAP;
            break;
        case IGMP_ACTION_DROP:
            igmp_op = PROTOCOL_OP_DROP;
            break;
        case IGMP_ACTION_FORWARD_EXCLUDE_CPU:
            return RT_ERR_CHIP_NOT_SUPPORTED;
        case IGMP_ACTION_ASIC:
            igmp_op = PROTOCOL_OP_ASIC;
            break;
        default:
            return RT_ERR_CHIP_NOT_SUPPORTED;
    }

    switch (type)
    {
        case IGMP_MLD:
            for(port = 0; port <= RTK_PORT_ID_MAX; port++)
            {
                if ((retVal = rtl8367b_setAsicMLDv1Opeartion(port, igmp_op)) != RT_ERR_OK)
                    return retVal;
                if ((retVal = rtl8367b_setAsicMLDv2Opeartion(port, igmp_op)) != RT_ERR_OK)
                    return retVal;
            }
            break;
        case IGMP_IPV4:
            for(port = 0; port <= RTK_PORT_ID_MAX; port++)
            {
                if ((retVal = rtl8367b_setAsicIGMPv1Opeartion(port, igmp_op)) != RT_ERR_OK)
                    return retVal;
                if ((retVal = rtl8367b_setAsicIGMPv2Opeartion(port, igmp_op)) != RT_ERR_OK)
                    return retVal;
                if ((retVal = rtl8367b_setAsicIGMPv3Opeartion(port, igmp_op)) != RT_ERR_OK)
                    return retVal;
            }
            break;
        case IGMP_PPPOE_IPV4:
        case IGMP_PPPOE_MLD:
        default:
            return RT_ERR_CHIP_NOT_SUPPORTED;
    }

    return RT_ERR_OK;
}


/* Function Name:
 *      rtk_trap_igmpCtrlPktAction_get
 * Description:
 *      Get IGMP/MLD trap function
 * Input:
 *      type - IGMP/MLD packet type.
 * Output:
 *      pIgmp_action - IGMP/MLD action.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can get both IPv4 IGMP/IPv6 MLD with/without PPPoE header trapping function.
 *      (1) The IGMP/MLD packet type is as following:
 *          - IGMP_IPV4
 *          - IGMP_PPPOE_IPV4
 *          - IGMP_MLD
 *          - IGMP_PPPOE_MLD
 *      (2) The IGMP/MLD action is as following:
 *          - IGMP_ACTION_FORWARD
 *          - IGMP_ACTION_TRAP2CPU
 *          - IGMP_ACTION_DROP
 *          - IGMP_ACTION_FORWARD_EXCLUDE_CPU
 */
rtk_api_ret_t rtk_trap_igmpCtrlPktAction_get(rtk_igmp_type_t type, rtk_trap_igmp_action_t *pIgmp_action)
{
    rtk_api_ret_t   retVal;
    rtk_uint32          igmp_op;

    if (type >= IGMP_TYPE_END)
        return RT_ERR_INPUT;

    switch (type)
    {
        case IGMP_IPV4:
            if ((retVal = rtl8367b_getAsicIGMPv1Opeartion(0, &igmp_op)) != RT_ERR_OK)
                return retVal;
            break;
        case IGMP_PPPOE_IPV4:
            return RT_ERR_CHIP_NOT_SUPPORTED;
        case IGMP_MLD:
            if ((retVal = rtl8367b_getAsicMLDv1Opeartion(0, &igmp_op)) != RT_ERR_OK)
                return retVal;
            break;
        case IGMP_PPPOE_MLD:
            return RT_ERR_CHIP_NOT_SUPPORTED;
        default:
            return RT_ERR_CHIP_NOT_SUPPORTED;
    }

    switch(igmp_op)
    {
        case PROTOCOL_OP_ASIC:
            *pIgmp_action = IGMP_ACTION_ASIC;
            break;
        case PROTOCOL_OP_FLOOD:
            *pIgmp_action = IGMP_ACTION_FORWARD;
            break;
        case PROTOCOL_OP_TRAP:
            *pIgmp_action = IGMP_ACTION_TRAP2CPU;
            break;
        case PROTOCOL_OP_DROP:
            *pIgmp_action = IGMP_ACTION_DROP;
            break;
        default:
            return RT_ERR_CHIP_NOT_SUPPORTED;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trap_unknownMcastPktAction_set
 * Description:
 *      Set behavior of unknown multicast
 * Input:
 *      port            - Port id.
 *      type            - unknown multicast packet type.
 *      mcast_action    - unknown multicast action.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 *      RT_ERR_NOT_ALLOWED 	- Invalid action.
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      When receives an unknown multicast packet, switch may trap, drop or flood this packet
 *      (1) The unknown multicast packet type is as following:
 *          - MCAST_L2
 *          - MCAST_IPV4
 *          - MCAST_IPV6
 *      (2) The unknown multicast action is as following:
 *          - MCAST_ACTION_FORWARD
 *          - MCAST_ACTION_DROP
 *          - MCAST_ACTION_TRAP2CPU
 */
rtk_api_ret_t rtk_trap_unknownMcastPktAction_set(rtk_port_t port, rtk_mcast_type_t type, rtk_trap_mcast_action_t mcast_action)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (type >= MCAST_END)
        return RT_ERR_INPUT;

    if (mcast_action >= MCAST_ACTION_END)
        return RT_ERR_INPUT;


    switch (type)
    {
        case MCAST_L2:
            if (MCAST_ACTION_ROUTER_PORT == mcast_action)
                return RT_ERR_INPUT;
            if ((retVal = rtl8367b_setAsicUnknownL2MulticastBehavior(port, mcast_action)) != RT_ERR_OK)
                return retVal;
            break;
        case MCAST_IPV4:
            if ((retVal = rtl8367b_setAsicUnknownIPv4MulticastBehavior(port, mcast_action)) != RT_ERR_OK)
                return retVal;
            break;
        case MCAST_IPV6:
            if ((retVal = rtl8367b_setAsicUnknownIPv6MulticastBehavior(port, mcast_action)) != RT_ERR_OK)
                return retVal;
            break;
        default:
            break;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trap_unknownMcastPktAction_get
 * Description:
 *      Get behavior of unknown multicast
 * Input:
 *      type - unknown multicast packet type.
 * Output:
 *      pMcast_action - unknown multicast action.
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_NOT_ALLOWED 		- Invalid operation.
 *      RT_ERR_INPUT 			- Invalid input parameters.
 * Note:
 *      When receives an unknown multicast packet, switch may trap, drop or flood this packet
 *      (1) The unknown multicast packet type is as following:
 *          - MCAST_L2
 *          - MCAST_IPV4
 *          - MCAST_IPV6
 *      (2) The unknown multicast action is as following:
 *          - MCAST_ACTION_FORWARD
 *          - MCAST_ACTION_DROP
 *          - MCAST_ACTION_TRAP2CPU
 */
rtk_api_ret_t rtk_trap_unknownMcastPktAction_get(rtk_port_t port, rtk_mcast_type_t type, rtk_trap_mcast_action_t *pMcast_action)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (type >= MCAST_END)
        return RT_ERR_INPUT;

    switch (type)
    {
        case MCAST_L2:
            if ((retVal = rtl8367b_getAsicUnknownL2MulticastBehavior(port, pMcast_action)) != RT_ERR_OK)
                return retVal;
            break;
        case MCAST_IPV4:
            if ((retVal = rtl8367b_getAsicUnknownIPv4MulticastBehavior(port, pMcast_action)) != RT_ERR_OK)
                return retVal;
            break;
        case MCAST_IPV6:
            if ((retVal = rtl8367b_getAsicUnknownIPv6MulticastBehavior(port, (rtk_uint32*)pMcast_action)) != RT_ERR_OK)
                return retVal;
            break;
        default:
            break;
    }
    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trap_ethernetAv_set
 * Description:
 *      Set Ethetnet AV.
 * Input:
 *      enable - enable trap
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_QOS_INT_PRIORITY - Invalid priority.
 *      RT_ERR_ENABLE 			- Invalid enable parameter.
 * Note:
 *      The API can enable or disable ethernet AV function. If the function is enabled,
 *      packets with ethernet type 0x88F7 will be trap to CPU with time stamp.
 *      The status of Ethernet AV:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_trap_ethernetAv_set(rtk_enable_t enable)
{
    rtk_api_ret_t retVal;
    rtk_port_t port;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    for(port = 0; port <= RTK_PORT_ID_MAX; port++)
    {
        if ((retVal = rtl8367b_setAsicEavEnable(port, enable)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trap_ethernetAv_get
 * Description:
 *      Get ethernet AV setup.
 * Input:
 * Output:
 *      pEnable - status of ethernet AV.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 * Note:
 *      The API can get ethernet AV status. If the function is enabled,
 *      packets with ethernet type 0x88F7 will be trap to CPU with time stamp.
 *      The status of Ethernet AV:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_trap_ethernetAv_get(rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicEavEnable(0, pEnable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_storm_controlRate_set
 * Description:
 *      Set per-port storm filter control rate.
 * Input:
 *      port        - Port id
 *      storm_type  - Storm filter control type
 *      rate        - Rate of storm filter control
 *      ifg_include - include IFG or not, ENABLE:include DISABLE:exclude
 *      mode        - Mode
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              		- OK
 *      RT_ERR_FAILED          		- Failed
 *      RT_ERR_SMI             		- SMI access error
 *      RT_ERR_PORT_ID 				- Invalid port number.
 *      RT_ERR_INPUT 				- Invalid input parameters.
 *      RT_ERR_SFC_UNKNOWN_GROUP 	- unknown storm filter group.
 *      RT_ERR_ENABLE 				- Invalid IFG parameter
 *      RT_ERR_RATE 				- Invalid rate
 * Note:
 *      This API can set per-port stomr filter control rate.
 *      The storm filter control type can be:
 *          - STORM_GROUP_UNKNOWN_UNICAST
 *          - STORM_GROUP_UNKNOWN_MULTICAST
 *          - STORM_GROUP_MULTICAST
 *          - STORM_GROUP_BROADCAST
 *      The rate unit is 1 kbps and the range is from 8k to 1048568k. The granularity of rate is 8 kbps.
 *      The ifg_include parameter is used for rate calculation with/without inter-frame-gap and preamble.
 *      In mode 0:
 *      Use rate to assign storm control rate.
 *      Use ifg_include to control inter-frame-gap include or not.
 *      In mode 1:
 *      Use rate to assign storm control shared meter index.
 *      Use ifg_include to be storm control enable/disable parameter.
 */
rtk_api_ret_t rtk_storm_controlRate_set(rtk_port_t port, rtk_rate_storm_group_t storm_type, rtk_rate_t rate, rtk_enable_t ifg_include, rtk_mode_t mode)
{
    rtk_api_ret_t retVal;
    rtk_uint32 enable;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (storm_type >= STORM_GROUP_END)
        return RT_ERR_SFC_UNKNOWN_GROUP;

    if (mode >= MODE_END)
        return RT_ERR_INPUT;

    if (mode == MODE0)
    {
        if (rate > RTL8367B_QOS_RATE_INPUT_MAX || rate < RTL8367B_QOS_RATE_INPUT_MIN || (rate % RTL8367B_QOS_GRANULARTY_UNIT_KBPS))
            return RT_ERR_RATE ;

        if (RTL8367B_QOS_RATE_INPUT_MAX == rate)
            enable = FALSE;
        else
            enable = TRUE;

        switch (storm_type)
        {
            case STORM_GROUP_UNKNOWN_UNICAST:
                if ((retVal = rtl8367b_setAsicStormFilterUnknownUnicastEnable(port, enable)) != RT_ERR_OK)
                    return retVal;
                if (enable)
                {
                    if ((retVal = rtl8367b_setAsicStormFilterUnknownUnicastMeter(port, STORM_UNUC_INDEX)) != RT_ERR_OK)
                        return retVal;
                    if ((retVal = rtl8367b_setAsicShareMeter(STORM_UNUC_INDEX, rate >> 3, ifg_include)) != RT_ERR_OK)
                        return retVal;
                }
                break;
            case STORM_GROUP_UNKNOWN_MULTICAST:
                if ((retVal = rtl8367b_setAsicStormFilterUnknownMulticastEnable(port, enable)) != RT_ERR_OK)
                    return retVal;
                if (enable)
                {
                    if ((retVal = rtl8367b_setAsicStormFilterUnknownMulticastMeter(port,STORM_UNMC_INDEX)) != RT_ERR_OK)
                        return retVal;
                    if ((retVal = rtl8367b_setAsicShareMeter(STORM_UNMC_INDEX, rate >> 3, ifg_include)) != RT_ERR_OK)
                        return retVal;
                }
                break;
            case STORM_GROUP_MULTICAST:
                if ((retVal = rtl8367b_setAsicStormFilterMulticastEnable(port, enable)) != RT_ERR_OK)
                    return retVal;
                if (enable)
                {
                    if ((retVal = rtl8367b_setAsicStormFilterMulticastMeter(port, STORM_MC_INDEX)) != RT_ERR_OK)
                        return retVal;
                    if ((retVal = rtl8367b_setAsicShareMeter(STORM_MC_INDEX, rate >> 3, ifg_include)) != RT_ERR_OK)
                        return retVal;
                }
                break;
            case STORM_GROUP_BROADCAST:
                if ((retVal = rtl8367b_setAsicStormFilterBroadcastEnable(port, enable)) != RT_ERR_OK)
                    return retVal;
                if (enable)
                {
                    if ((retVal = rtl8367b_setAsicStormFilterBroadcastMeter(port, STORM_BC_INDEX)) != RT_ERR_OK)
                        return retVal;
                    if ((retVal = rtl8367b_setAsicShareMeter(STORM_BC_INDEX, rate >> 3, ifg_include)) != RT_ERR_OK)
                        return retVal;
                }
            default:
                break;
        }
    }
    else
    {
        /*Use rate to assign storm control shared meter index in mode 1.*/
        if (rate >= RTK_MAX_NUM_OF_METER)
            return RT_ERR_FILTER_METER_ID;

        /*Use ifg_include to be storm control enable/disable parameter in mode 1.*/
        enable = ifg_include;

        switch (storm_type)
        {
            case STORM_GROUP_UNKNOWN_UNICAST:
                if ((retVal = rtl8367b_setAsicStormFilterUnknownUnicastEnable(port,enable))!=RT_ERR_OK)
                    return retVal;
                if ((retVal = rtl8367b_setAsicStormFilterUnknownUnicastMeter(port,rate))!=RT_ERR_OK)
                    return retVal;
                break;
            case STORM_GROUP_UNKNOWN_MULTICAST:
                if ((retVal = rtl8367b_setAsicStormFilterUnknownMulticastEnable(port,enable))!=RT_ERR_OK)
                    return retVal;
                if ((retVal = rtl8367b_setAsicStormFilterUnknownMulticastMeter(port,rate))!=RT_ERR_OK)
                    return retVal;
                break;
            case STORM_GROUP_MULTICAST:
                if ((retVal = rtl8367b_setAsicStormFilterMulticastEnable(port,enable))!=RT_ERR_OK)
                    return retVal;
                if ((retVal = rtl8367b_setAsicStormFilterMulticastMeter(port,rate))!=RT_ERR_OK)
                    return retVal;
                break;
            case STORM_GROUP_BROADCAST:
                if ((retVal = rtl8367b_setAsicStormFilterBroadcastEnable(port,enable))!=RT_ERR_OK)
                    return retVal;
                if ((retVal = rtl8367b_setAsicStormFilterBroadcastMeter(port,rate))!=RT_ERR_OK)
                    return retVal;
            default:
                break;
        }
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_storm_controlRate_get
 * Description:
 *      Get per-port packet storm filter control rate.
 * Input:
 *      port        - Port id
 *      storm_type  - Storm filter control type.
 *      mode        - Mode
 * Output:
 *      pRate           - Rate of storm filter control.
 *      pIfg_include    - Rate's calculation including IFG, ENABLE:include DISABLE:exclude
 * Return:
 *      RT_ERR_OK              		- OK
 *      RT_ERR_FAILED          		- Failed
 *      RT_ERR_SMI             		- SMI access error
 *      RT_ERR_PORT_ID 				- Invalid port number.
 *      RT_ERR_INPUT 				- Invalid input parameters.
 *      RT_ERR_SFC_UNKNOWN_GROUP 	- unknown storm filter group.
 * Note:
 *      The storm filter control type can be:
 *          - STORM_GROUP_UNKNOWN_UNICAST
 *          - STORM_GROUP_UNKNOWN_MULTICAST
 *          - STORM_GROUP_MULTICAST
 *          - STORM_GROUP_BROADCAST
 *      In mode 0:
 *      pRate is assigned to get storm control rate.
 *      pIfg_include is assigned to get inter-frame-gap include or not.
 *      In mode 1:
 *      pRate is assigned to get storm control shared meter index.
 *      pIfg_include is assigned to get storm control enable/disable parameter.
 */
rtk_api_ret_t rtk_storm_controlRate_get(rtk_port_t port, rtk_rate_storm_group_t storm_type, rtk_rate_t *pRate, rtk_enable_t *pIfg_include, rtk_mode_t mode)
{
    rtk_api_ret_t retVal;
    rtk_uint32 enable;
    rtk_uint32 index;
    rtk_uint32 regData;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (storm_type >= STORM_GROUP_END)
        return RT_ERR_SFC_UNKNOWN_GROUP;

    if (mode >= MODE_END)
        return RT_ERR_INPUT;

    if (mode == MODE0)
    {
        switch (storm_type)
        {
            case STORM_GROUP_UNKNOWN_UNICAST:
                if ((retVal = rtl8367b_getAsicStormFilterUnknownUnicastEnable(port, &enable)) != RT_ERR_OK)
                    return retVal;
                if (enable)
                {
                    if ((retVal = rtl8367b_getAsicStormFilterUnknownUnicastMeter(port, &index)) != RT_ERR_OK)
                        return retVal;
                    if ((retVal = rtl8367b_getAsicShareMeter(index, &regData, pIfg_include)) != RT_ERR_OK)
                        return retVal;
                    *pRate = regData << 3;
                }
                else
                {
                    *pRate = 0x1FFFF << 3;
                }
                break;
            case STORM_GROUP_UNKNOWN_MULTICAST:
                if ((retVal = rtl8367b_getAsicStormFilterUnknownMulticastEnable(port, &enable)) != RT_ERR_OK)
                    return retVal;
                if (enable)
                {
                    if ((retVal = rtl8367b_getAsicStormFilterUnknownMulticastMeter(port, &index)) != RT_ERR_OK)
                        return retVal;
                    if ((retVal = rtl8367b_getAsicShareMeter(index, &regData, pIfg_include)) != RT_ERR_OK)
                        return retVal;
                    *pRate = regData << 3;
                }
                else
                {
                    *pRate = 0x1FFFF << 3;
                }
                break;
            case STORM_GROUP_MULTICAST:
                if ((retVal = rtl8367b_getAsicStormFilterMulticastEnable(port, &enable)) != RT_ERR_OK)
                    return retVal;
                if (enable)
                {
                    if ((retVal = rtl8367b_getAsicStormFilterMulticastMeter(port, &index)) != RT_ERR_OK)
                        return retVal;
                    if ((retVal = rtl8367b_getAsicShareMeter(index, &regData, pIfg_include)) != RT_ERR_OK)
                        return retVal;
                    *pRate = regData << 3;
                }
                else
                {
                    *pRate = 0x1FFFF << 3;
                }
                break;
            case STORM_GROUP_BROADCAST:
                if ((retVal = rtl8367b_getAsicStormFilterBroadcastEnable(port, &enable)) != RT_ERR_OK)
                    return retVal;
                if (enable)
                {
                    if ((retVal = rtl8367b_getAsicStormFilterBroadcastMeter(port, &index)) != RT_ERR_OK)
                        return retVal;
                    if ((retVal = rtl8367b_getAsicShareMeter(index, &regData, pIfg_include)) != RT_ERR_OK)
                        return retVal;
                    *pRate = regData << 3;
                }
                else
                {
                    *pRate = 0x1FFFF << 3;
                }
                break;
            default:
                break;
        }
    }
    else
    {
        /*Use pRate to assign storm control shared meter index in mode 1.*/
        /*Use pIfg_include to be storm control enable/disable parameter in mode 1.*/
        switch (storm_type)
        {
            case STORM_GROUP_UNKNOWN_UNICAST:
                if ((retVal = rtl8367b_getAsicStormFilterUnknownUnicastEnable(port,pIfg_include))!=RT_ERR_OK)
                    return retVal;
                if ((retVal = rtl8367b_getAsicStormFilterUnknownUnicastMeter(port,pRate))!=RT_ERR_OK)
                    return retVal;
                break;
            case STORM_GROUP_UNKNOWN_MULTICAST:
                if ((retVal = rtl8367b_getAsicStormFilterUnknownMulticastEnable(port,pIfg_include))!=RT_ERR_OK)
                    return retVal;
                if ((retVal = rtl8367b_getAsicStormFilterUnknownMulticastMeter(port,pRate))!=RT_ERR_OK)
                    return retVal;
                break;
            case STORM_GROUP_MULTICAST:
                if ((retVal = rtl8367b_getAsicStormFilterMulticastEnable(port,pIfg_include))!=RT_ERR_OK)
                    return retVal;
                if ((retVal = rtl8367b_getAsicStormFilterMulticastMeter(port,pRate))!=RT_ERR_OK)
                    return retVal;
                break;
            case STORM_GROUP_BROADCAST:
                if ((retVal = rtl8367b_getAsicStormFilterBroadcastEnable(port,pIfg_include))!=RT_ERR_OK)
                    return retVal;
                if ((retVal = rtl8367b_getAsicStormFilterBroadcastMeter(port,pRate))!=RT_ERR_OK)
                    return retVal;
                break;
            default:
                break;
        }
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_storm_bypass_set
 * Description:
 *      Set bypass storm filter control configuration.
 * Input:
 *      type    - Bypass storm filter control type.
 *      enable  - Bypass status.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_ENABLE 		- Invalid IFG parameter
 * Note:
 *
 *      This API can set per-port bypass stomr filter control frame type including RMA and igmp.
 *      The bypass frame type is as following:
 *      - BYPASS_BRG_GROUP,
 *      - BYPASS_FD_PAUSE,
 *      - BYPASS_SP_MCAST,
 *      - BYPASS_1X_PAE,
 *      - BYPASS_UNDEF_BRG_04,
 *      - BYPASS_UNDEF_BRG_05,
 *      - BYPASS_UNDEF_BRG_06,
 *      - BYPASS_UNDEF_BRG_07,
 *      - BYPASS_PROVIDER_BRIDGE_GROUP_ADDRESS,
 *      - BYPASS_UNDEF_BRG_09,
 *      - BYPASS_UNDEF_BRG_0A,
 *      - BYPASS_UNDEF_BRG_0B,
 *      - BYPASS_UNDEF_BRG_0C,
 *      - BYPASS_PROVIDER_BRIDGE_GVRP_ADDRESS,
 *      - BYPASS_8021AB,
 *      - BYPASS_UNDEF_BRG_0F,
 *      - BYPASS_BRG_MNGEMENT,
 *      - BYPASS_UNDEFINED_11,
 *      - BYPASS_UNDEFINED_12,
 *      - BYPASS_UNDEFINED_13,
 *      - BYPASS_UNDEFINED_14,
 *      - BYPASS_UNDEFINED_15,
 *      - BYPASS_UNDEFINED_16,
 *      - BYPASS_UNDEFINED_17,
 *      - BYPASS_UNDEFINED_18,
 *      - BYPASS_UNDEFINED_19,
 *      - BYPASS_UNDEFINED_1A,
 *      - BYPASS_UNDEFINED_1B,
 *      - BYPASS_UNDEFINED_1C,
 *      - BYPASS_UNDEFINED_1D,
 *      - BYPASS_UNDEFINED_1E,
 *      - BYPASS_UNDEFINED_1F,
 *      - BYPASS_GMRP,
 *      - BYPASS_GVRP,
 *      - BYPASS_UNDEF_GARP_22,
 *      - BYPASS_UNDEF_GARP_23,
 *      - BYPASS_UNDEF_GARP_24,
 *      - BYPASS_UNDEF_GARP_25,
 *      - BYPASS_UNDEF_GARP_26,
 *      - BYPASS_UNDEF_GARP_27,
 *      - BYPASS_UNDEF_GARP_28,
 *      - BYPASS_UNDEF_GARP_29,
 *      - BYPASS_UNDEF_GARP_2A,
 *      - BYPASS_UNDEF_GARP_2B,
 *      - BYPASS_UNDEF_GARP_2C,
 *      - BYPASS_UNDEF_GARP_2D,
 *      - BYPASS_UNDEF_GARP_2E,
 *      - BYPASS_UNDEF_GARP_2F,
 *      - BYPASS_IGMP.
 */
rtk_api_ret_t rtk_storm_bypass_set(rtk_storm_bypass_t type, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;
    rtl8367b_rma_t rmacfg;

    if (type >= BYPASS_END)
        return RT_ERR_INPUT;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if (type >= 0 && type <= BYPASS_UNDEF_GARP_2F)
    {
        if ((retVal = rtl8367b_getAsicRma(type, &rmacfg)) != RT_ERR_OK)
            return retVal;

        rmacfg.discard_storm_filter = enable;

        if ((retVal = rtl8367b_setAsicRma(type, &rmacfg)) != RT_ERR_OK)
            return retVal;
    }
    else if(type == BYPASS_IGMP)
    {
        if ((retVal = rtl8367b_setAsicIGMPBypassStormCTRL(enable)) != RT_ERR_OK)
            return retVal;
    }
    else
        return RT_ERR_INPUT;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_storm_bypass_get
 * Description:
 *      Get bypass storm filter control configuration.
 * Input:
 *      type - Bypass storm filter control type.
 * Output:
 *      pEnable - Bypass status.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can get per-port bypass stomr filter control frame type including RMA and igmp.
 *      The bypass frame type is as following:
 *      - BYPASS_BRG_GROUP,
 *      - BYPASS_FD_PAUSE,
 *      - BYPASS_SP_MCAST,
 *      - BYPASS_1X_PAE,
 *      - BYPASS_UNDEF_BRG_04,
 *      - BYPASS_UNDEF_BRG_05,
 *      - BYPASS_UNDEF_BRG_06,
 *      - BYPASS_UNDEF_BRG_07,
 *      - BYPASS_PROVIDER_BRIDGE_GROUP_ADDRESS,
 *      - BYPASS_UNDEF_BRG_09,
 *      - BYPASS_UNDEF_BRG_0A,
 *      - BYPASS_UNDEF_BRG_0B,
 *      - BYPASS_UNDEF_BRG_0C,
 *      - BYPASS_PROVIDER_BRIDGE_GVRP_ADDRESS,
 *      - BYPASS_8021AB,
 *      - BYPASS_UNDEF_BRG_0F,
 *      - BYPASS_BRG_MNGEMENT,
 *      - BYPASS_UNDEFINED_11,
 *      - BYPASS_UNDEFINED_12,
 *      - BYPASS_UNDEFINED_13,
 *      - BYPASS_UNDEFINED_14,
 *      - BYPASS_UNDEFINED_15,
 *      - BYPASS_UNDEFINED_16,
 *      - BYPASS_UNDEFINED_17,
 *      - BYPASS_UNDEFINED_18,
 *      - BYPASS_UNDEFINED_19,
 *      - BYPASS_UNDEFINED_1A,
 *      - BYPASS_UNDEFINED_1B,
 *      - BYPASS_UNDEFINED_1C,
 *      - BYPASS_UNDEFINED_1D,
 *      - BYPASS_UNDEFINED_1E,
 *      - BYPASS_UNDEFINED_1F,
 *      - BYPASS_GMRP,
 *      - BYPASS_GVRP,
 *      - BYPASS_UNDEF_GARP_22,
 *      - BYPASS_UNDEF_GARP_23,
 *      - BYPASS_UNDEF_GARP_24,
 *      - BYPASS_UNDEF_GARP_25,
 *      - BYPASS_UNDEF_GARP_26,
 *      - BYPASS_UNDEF_GARP_27,
 *      - BYPASS_UNDEF_GARP_28,
 *      - BYPASS_UNDEF_GARP_29,
 *      - BYPASS_UNDEF_GARP_2A,
 *      - BYPASS_UNDEF_GARP_2B,
 *      - BYPASS_UNDEF_GARP_2C,
 *      - BYPASS_UNDEF_GARP_2D,
 *      - BYPASS_UNDEF_GARP_2E,
 *      - BYPASS_UNDEF_GARP_2F,
 *      - BYPASS_IGMP.
 */
rtk_api_ret_t rtk_storm_bypass_get(rtk_storm_bypass_t type, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;
    rtl8367b_rma_t rmacfg;

    if (type >= BYPASS_END)
        return RT_ERR_INPUT;

    if (type >= 0 && type <= BYPASS_UNDEF_GARP_2F)
    {
        if ((retVal = rtl8367b_getAsicRma(type, &rmacfg)) != RT_ERR_OK)
            return retVal;

        *pEnable = rmacfg.discard_storm_filter;
    }
    else if(type == BYPASS_IGMP)
    {
        if ((retVal = rtl8367b_getAsicIGMPBypassStormCTRL(pEnable)) != RT_ERR_OK)
            return retVal;
    }
    else
        return RT_ERR_INPUT;

    return RT_ERR_OK;
}

static rtk_api_ret_t _rtk_port_FiberModeAbility_set(rtk_port_t port, rtk_port_phy_ability_t *pAbility)
{
    rtk_api_ret_t   retVal;
    rtk_uint32 data;

    if (port != RTK_PORT_COMBO_ID)
        return RT_ERR_PORT_ID;

    if((retVal = rtl8367b_setAsicReg(0x13C2, 0x0249)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1300, &data)) != RT_ERR_OK)
        return retVal;

    if( (data == 0x0276) || (data == 0x0597) || (data == 0x6367) )
    {
        if( (pAbility->Full_1000 == 1) && (pAbility->Full_100 == 1) && (pAbility->AutoNegotiation == 1) )
        {
            if ((retVal = rtl8367b_setAsicRegBit(RTL8367B_REG_FIBER_CFG_1, RTL8367B_SDS_FRC_MODE_OFFSET, 0)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicRegBits(RTL8367B_REG_FIBER_CFG_1, RTL8367B_SDS_MODE_MASK, 0)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicRegBit(0x6200, 12, 1)) != RT_ERR_OK)
                return retVal;
        }
        else if(pAbility->Full_1000 == 1)
        {
            if ((retVal = rtl8367b_setAsicRegBit(RTL8367B_REG_FIBER_CFG_1, RTL8367B_SDS_FRC_MODE_OFFSET, 1)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicRegBits(RTL8367B_REG_FIBER_CFG_1, RTL8367B_SDS_MODE_MASK, 4)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicRegBit(0x6200, 12, 1)) != RT_ERR_OK)
                return retVal;
        }
        else if(pAbility->Full_100 == 1)
        {
            if ((retVal = rtl8367b_setAsicRegBit(RTL8367B_REG_FIBER_CFG_1, RTL8367B_SDS_FRC_MODE_OFFSET, 1)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicRegBits(RTL8367B_REG_FIBER_CFG_1, RTL8367B_SDS_MODE_MASK, 5)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicRegBit(0x6200, 12, 0)) != RT_ERR_OK)
                return retVal;
        }
    }
    else
    {
        if( (pAbility->Full_1000 == 1) && (pAbility->Full_100 == 1) && (pAbility->AutoNegotiation == 1) )
        {
            if ((retVal = rtl8367b_setAsicReg(RTL8367B_REG_FIBER_CFG_1, 0x000F)) != RT_ERR_OK)
                return retVal;
        }
        else if(pAbility->Full_1000 == 1)
        {
            if ((retVal = rtl8367b_setAsicReg(RTL8367B_REG_FIBER_CFG_1, 0x000C)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicReg(RTL8367B_REG_FIB_CFG00, 0x1140)) != RT_ERR_OK)
                return retVal;
        }
        else if(pAbility->Full_100 == 1)
        {
            if ((retVal = rtl8367b_setAsicReg(RTL8367B_REG_FIBER_CFG_1, 0x000D)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicReg(RTL8367B_REG_FIB_CFG00, 0x2100)) != RT_ERR_OK)
                return retVal;
        }
    }

    return RT_ERR_OK;
}

static rtk_api_ret_t _rtk_port_FiberModeAbility_get(rtk_port_t port, rtk_port_phy_ability_t *pAbility)
{
    rtk_api_ret_t   retVal;
    rtk_uint32      data, speed;

    if (port != RTK_PORT_COMBO_ID)
        return RT_ERR_PORT_ID;

    memset(pAbility, 0x00, sizeof(rtk_port_phy_ability_t));

    if((retVal = rtl8367b_setAsicReg(0x13C2, 0x0249)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1300, &data)) != RT_ERR_OK)
        return retVal;

    if( (data == 0x0276) || (data == 0x0597) || (data == 0x6367) )
    {
        if ((retVal = rtl8367b_getAsicRegBit(RTL8367B_REG_FIBER_CFG_1, RTL8367B_SDS_FRC_MODE_OFFSET, &data)) != RT_ERR_OK)
            return retVal;

        if(data == 0)
        {
            pAbility->AutoNegotiation = 1;
            pAbility->Full_1000 = 1;
            pAbility->Full_100 = 1;
        }
        else
        {
            if ((retVal = rtl8367b_getAsicRegBits(RTL8367B_REG_FIBER_CFG_1, RTL8367B_SDS_MODE_MASK, &data)) != RT_ERR_OK)
                return retVal;

            if(data == 4)
                pAbility->Full_1000 = 1;
            else if(data == 5)
                pAbility->Full_100 = 1;
            else
                return RT_ERR_FAILED;
        }
    }
    else
    {
        if ((retVal = rtl8367b_getAsicRegBits(RTL8367B_REG_SDS_CFG4, RTL8367B_CFG_FRC_SDS_MODE_MASK, &speed)) != RT_ERR_OK)
            return retVal;

        if(speed == 0x000F)
        {
            pAbility->Full_1000 = 1;
            pAbility->Full_100 = 1;
            pAbility->AutoNegotiation = 1;
        }
        else if(speed == 0x000C)
            pAbility->Full_1000 = 1;
        else if(speed == 0x000D)
            pAbility->Full_100 = 1;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyAutoNegoAbility_set
 * Description:
 *      Set ethernet PHY auto-negotiation desired ability.
 * Input:
 *      port        - port id.
 *      pAbility    - Ability structure
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_PHY_REG_ID 		- Invalid PHY address
 *      RT_ERR_INPUT 			- Invalid input parameters.
 *      RT_ERR_BUSYWAIT_TIMEOUT - PHY access busy
 * Note:
 *      If Full_1000 bit is set to 1, the AutoNegotiation will be automatic set to 1. While both AutoNegotiation and Full_1000 are set to 0, the PHY speed and duplex selection will
 *      be set as following 100F > 100H > 10F > 10H priority sequence.
 */
rtk_api_ret_t rtk_port_phyAutoNegoAbility_set(rtk_port_t port, rtk_port_phy_ability_t *pAbility)
{
    rtk_api_ret_t       retVal;
    rtk_uint32          phyData;
    rtk_uint32          phyEnMsk0;
    rtk_uint32          phyEnMsk4;
    rtk_uint32          phyEnMsk9;
    rtk_port_media_t    media_type;


    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (pAbility->Half_10 >= RTK_ENABLE_END || pAbility->Full_10 >= RTK_ENABLE_END ||
       pAbility->Half_100 >= RTK_ENABLE_END || pAbility->Full_100 >= RTK_ENABLE_END ||
       pAbility->Full_1000 >= RTK_ENABLE_END || pAbility->AutoNegotiation >= RTK_ENABLE_END ||
       pAbility->AsyFC >= RTK_ENABLE_END || pAbility->FC >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    /*for PHY auto mode setup*/
    pAbility->AutoNegotiation = 1;

    if (port == RTK_PORT_COMBO_ID)
    {
        if ((retVal = rtk_port_phyComboPortMedia_get(port, &media_type)) != RT_ERR_OK)
            return retVal;

        if(media_type == PORT_MEDIA_FIBER)
        {
            return _rtk_port_FiberModeAbility_set(port, pAbility);
        }
    }

    phyEnMsk0 = 0;
    phyEnMsk4 = 0;
    phyEnMsk9 = 0;

    if (1 == pAbility->Half_10)
    {
        /*10BASE-TX half duplex capable in reg 4.5*/
        phyEnMsk4 = phyEnMsk4 | (1 << 5);

        /*Speed selection [1:0] */
        /* 11=Reserved*/
        /* 10= 1000Mpbs*/
        /* 01= 100Mpbs*/
        /* 00= 10Mpbs*/
        phyEnMsk0 = phyEnMsk0 & (~(1 << 6));
        phyEnMsk0 = phyEnMsk0 & (~(1 << 13));
    }

    if (1 == pAbility->Full_10)
    {
        /*10BASE-TX full duplex capable in reg 4.6*/
        phyEnMsk4 = phyEnMsk4 | (1 << 6);
        /*Speed selection [1:0] */
        /* 11=Reserved*/
        /* 10= 1000Mpbs*/
        /* 01= 100Mpbs*/
        /* 00= 10Mpbs*/
        phyEnMsk0 = phyEnMsk0 & (~(1 << 6));
        phyEnMsk0 = phyEnMsk0 & (~(1 << 13));

        /*Full duplex mode in reg 0.8*/
        phyEnMsk0 = phyEnMsk0 | (1 << 8);

    }

    if (1 == pAbility->Half_100)
    {
        /*100BASE-TX half duplex capable in reg 4.7*/
        phyEnMsk4 = phyEnMsk4 | (1 << 7);
        /*Speed selection [1:0] */
        /* 11=Reserved*/
        /* 10= 1000Mpbs*/
        /* 01= 100Mpbs*/
        /* 00= 10Mpbs*/
        phyEnMsk0 = phyEnMsk0 & (~(1 << 6));
        phyEnMsk0 = phyEnMsk0 | (1 << 13);
    }


    if (1 == pAbility->Full_100)
    {
        /*100BASE-TX full duplex capable in reg 4.8*/
        phyEnMsk4 = phyEnMsk4 | (1 << 8);
        /*Speed selection [1:0] */
        /* 11=Reserved*/
        /* 10= 1000Mpbs*/
        /* 01= 100Mpbs*/
        /* 00= 10Mpbs*/
        phyEnMsk0 = phyEnMsk0 & (~(1 << 6));
        phyEnMsk0 = phyEnMsk0 | (1 << 13);
        /*Full duplex mode in reg 0.8*/
        phyEnMsk0 = phyEnMsk0 | (1 << 8);
    }


    if (1 == pAbility->Full_1000)
    {
        /*1000 BASE-T FULL duplex capable setting in reg 9.9*/
        phyEnMsk9 = phyEnMsk9 | (1 << 9);

        /*Speed selection [1:0] */
        /* 11=Reserved*/
        /* 10= 1000Mpbs*/
        /* 01= 100Mpbs*/
        /* 00= 10Mpbs*/
        phyEnMsk0 = phyEnMsk0 | (1 << 6);
        phyEnMsk0 = phyEnMsk0 & (~(1 << 13));
        phyEnMsk0 = phyEnMsk0 | (1 << 8);

        /*Auto-Negotiation setting in reg 0.12*/
        phyEnMsk0 = phyEnMsk0 | (1 << 12);

     }

    if (1 == pAbility->AutoNegotiation)
    {
        /*Auto-Negotiation setting in reg 0.12*/
        phyEnMsk0 = phyEnMsk0 | (1 << 12);
    }

    if (1 == pAbility->AsyFC)
    {
        /*Asymetric flow control in reg 4.11*/
        phyEnMsk4 = phyEnMsk4 | (1 << 11);
    }
    if (1 == pAbility->FC)
    {
        /*Flow control in reg 4.10*/
        phyEnMsk4 = phyEnMsk4 | (1 << 10);
    }

    if ((retVal = rtl8367b_setAsicPHYReg(port, RTL8367B_PHY_PAGE_ADDRESS, 0)) != RT_ERR_OK)
        return retVal;

    /*1000 BASE-T control register setting*/
    if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_1000_BASET_CONTROL_REG, &phyData)) != RT_ERR_OK)
        return retVal;

    phyData = (phyData & (~0x0200)) | phyEnMsk9 ;

    if ((retVal = rtl8367b_setAsicPHYReg(port, PHY_1000_BASET_CONTROL_REG, phyData)) != RT_ERR_OK)
        return retVal;

    /*Auto-Negotiation control register setting*/
    if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_AN_ADVERTISEMENT_REG, &phyData)) != RT_ERR_OK)
        return retVal;

    phyData = (phyData & (~0x0DE0)) | phyEnMsk4;
    if ((retVal = rtl8367b_setAsicPHYReg(port, PHY_AN_ADVERTISEMENT_REG, phyData)) != RT_ERR_OK)
        return retVal;

    /*Control register setting and restart auto*/
    if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_CONTROL_REG, &phyData)) != RT_ERR_OK)
        return retVal;

    phyData = (phyData & (~0x3140)) | phyEnMsk0;
    /*If have auto-negotiation capable, then restart auto negotiation*/
    if (1 == pAbility->AutoNegotiation)
    {
        phyData = phyData | (1 << 9);
    }

    if ((retVal = rtl8367b_setAsicPHYReg(port, PHY_CONTROL_REG, phyData)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyAutoNegoAbility_get
 * Description:
 *      Get PHY ability through PHY registers.
 * Input:
 *      port - Port id.
 * Output:
 *      pAbility - Ability structure
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_PHY_REG_ID 		- Invalid PHY address
 *      RT_ERR_INPUT 			- Invalid input parameters.
 *      RT_ERR_BUSYWAIT_TIMEOUT - PHY access busy
 * Note:
 *      Get the capablity of specified PHY.
 */
rtk_api_ret_t rtk_port_phyAutoNegoAbility_get(rtk_port_t port, rtk_port_phy_ability_t *pAbility)
{
    rtk_api_ret_t       retVal;
    rtk_uint32          phyData0;
    rtk_uint32          phyData4;
    rtk_uint32          phyData9;
    rtk_port_media_t    media_type;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (port == RTK_PORT_COMBO_ID)
    {
        if ((retVal = rtk_port_phyComboPortMedia_get(port, &media_type)) != RT_ERR_OK)
            return retVal;

        if(media_type == PORT_MEDIA_FIBER)
        {
            return _rtk_port_FiberModeAbility_set(port, pAbility);
        }
    }

    if ((retVal = rtl8367b_setAsicPHYReg(port, RTL8367B_PHY_PAGE_ADDRESS, 0)) != RT_ERR_OK)
        return retVal;

    /*Control register setting and restart auto*/
    if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_CONTROL_REG, &phyData0)) != RT_ERR_OK)
        return retVal;

    /*Auto-Negotiation control register setting*/
    if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_AN_ADVERTISEMENT_REG, &phyData4)) != RT_ERR_OK)
        return retVal;

    /*1000 BASE-T control register setting*/
    if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_1000_BASET_CONTROL_REG, &phyData9)) != RT_ERR_OK)
        return retVal;

    if (phyData9 & (1 << 9))
        pAbility->Full_1000 = 1;
    else
        pAbility->Full_1000 = 0;

    if (phyData4 & (1 << 11))
        pAbility->AsyFC = 1;
    else
        pAbility->AsyFC = 0;

    if (phyData4 & (1 << 10))
        pAbility->FC = 1;
    else
        pAbility->FC = 0;


    if (phyData4 & (1 << 8))
        pAbility->Full_100 = 1;
    else
        pAbility->Full_100 = 0;

    if (phyData4 & (1 << 7))
        pAbility->Half_100 = 1;
    else
        pAbility->Half_100 = 0;

    if (phyData4 & (1 << 6))
        pAbility->Full_10 = 1;
    else
        pAbility->Full_10 = 0;

    if (phyData4 & (1 << 5))
        pAbility->Half_10 = 1;
    else
        pAbility->Half_10 = 0;


    if (phyData0 & (1 << 12))
        pAbility->AutoNegotiation = 1;
    else
        pAbility->AutoNegotiation = 0;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyForceModeAbility_set
 * Description:
 *      Set the port speed/duplex mode/pause/asy_pause in the PHY force mode.
 * Input:
 *      port        - port id.
 *      pAbility    - Ability structure
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_PHY_REG_ID 		- Invalid PHY address
 *      RT_ERR_INPUT 			- Invalid input parameters.
 *      RT_ERR_BUSYWAIT_TIMEOUT - PHY access busy
 * Note:
 *      If Full_1000 bit is set to 1, the AutoNegotiation will be automatic set to 1.
 *      While both AutoNegotiation and Full_1000 are set to 0, the PHY speed and duplex selection will
 *      be set as following 100F > 100H > 10F > 10H priority sequence.
 *      This API can be used to configure combo port in fiber mode.
 *      The possible parameters in fiber mode are Full_1000 and Full 100.
 *      All the other fields in rtk_port_phy_ability_t will be ignored in fiber port.
 */
rtk_api_ret_t rtk_port_phyForceModeAbility_set(rtk_port_t port, rtk_port_phy_ability_t *pAbility)
{
     rtk_api_ret_t      retVal;
     rtk_uint32         phyData;
     rtk_uint32         phyEnMsk0;
     rtk_uint32         phyEnMsk4;
     rtk_uint32         phyEnMsk9;
     rtk_port_media_t   media_type;

     if (port > RTK_PHY_ID_MAX)
         return RT_ERR_PORT_ID;

     if (pAbility->Half_10 >= RTK_ENABLE_END || pAbility->Full_10 >= RTK_ENABLE_END ||
        pAbility->Half_100 >= RTK_ENABLE_END || pAbility->Full_100 >= RTK_ENABLE_END ||
        pAbility->Full_1000 >= RTK_ENABLE_END || pAbility->AutoNegotiation >= RTK_ENABLE_END ||
        pAbility->AsyFC >= RTK_ENABLE_END || pAbility->FC >= RTK_ENABLE_END)
         return RT_ERR_INPUT;

     if (1 == pAbility->Full_1000)
         return RT_ERR_INPUT;

     if (port == RTK_PORT_COMBO_ID)
     {
         if ((retVal = rtk_port_phyComboPortMedia_get(port, &media_type)) != RT_ERR_OK)
             return retVal;

         if(media_type == PORT_MEDIA_FIBER)
         {
             return _rtk_port_FiberModeAbility_set(port, pAbility);
         }
     }

     /*for PHY force mode setup*/
     pAbility->AutoNegotiation = 0;

     phyEnMsk0 = 0;
     phyEnMsk4 = 0;
     phyEnMsk9 = 0;

     if (1 == pAbility->Half_10)
     {
         /*10BASE-TX half duplex capable in reg 4.5*/
         phyEnMsk4 = phyEnMsk4 | (1 << 5);

         /*Speed selection [1:0] */
         /* 11=Reserved*/
         /* 10= 1000Mpbs*/
         /* 01= 100Mpbs*/
         /* 00= 10Mpbs*/
         phyEnMsk0 = phyEnMsk0 & (~(1 << 6));
         phyEnMsk0 = phyEnMsk0 & (~(1 << 13));
     }

     if (1 == pAbility->Full_10)
     {
         /*10BASE-TX full duplex capable in reg 4.6*/
         phyEnMsk4 = phyEnMsk4 | (1 << 6);
         /*Speed selection [1:0] */
         /* 11=Reserved*/
         /* 10= 1000Mpbs*/
         /* 01= 100Mpbs*/
         /* 00= 10Mpbs*/
         phyEnMsk0 = phyEnMsk0 & (~(1 << 6));
         phyEnMsk0 = phyEnMsk0 & (~(1 << 13));

         /*Full duplex mode in reg 0.8*/
         phyEnMsk0 = phyEnMsk0 | (1 << 8);

     }

     if (1 == pAbility->Half_100)
     {
         /*100BASE-TX half duplex capable in reg 4.7*/
         phyEnMsk4 = phyEnMsk4 | (1 << 7);
         /*Speed selection [1:0] */
         /* 11=Reserved*/
         /* 10= 1000Mpbs*/
         /* 01= 100Mpbs*/
         /* 00= 10Mpbs*/
         phyEnMsk0 = phyEnMsk0 & (~(1 << 6));
         phyEnMsk0 = phyEnMsk0 | (1 << 13);
     }


     if (1 == pAbility->Full_100)
     {
         /*100BASE-TX full duplex capable in reg 4.8*/
         phyEnMsk4 = phyEnMsk4 | (1 << 8);
         /*Speed selection [1:0] */
         /* 11=Reserved*/
         /* 10= 1000Mpbs*/
         /* 01= 100Mpbs*/
         /* 00= 10Mpbs*/
         phyEnMsk0 = phyEnMsk0 & (~(1 << 6));
         phyEnMsk0 = phyEnMsk0 | (1 << 13);
         /*Full duplex mode in reg 0.8*/
         phyEnMsk0 = phyEnMsk0 | (1 << 8);
     }

     if (1 == pAbility->AsyFC)
     {
         /*Asymetric flow control in reg 4.11*/
         phyEnMsk4 = phyEnMsk4 | (1 << 11);
     }
     if (1 == pAbility->FC)
     {
         /*Flow control in reg 4.10*/
         phyEnMsk4 = phyEnMsk4 | ((1 << 10));
     }

     if ((retVal = rtl8367b_setAsicPHYReg(port, RTL8367B_PHY_PAGE_ADDRESS, 0)) != RT_ERR_OK)
         return retVal;

     /*1000 BASE-T control register setting*/
     if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_1000_BASET_CONTROL_REG, &phyData)) != RT_ERR_OK)
         return retVal;

     phyData = (phyData & (~0x0200)) | phyEnMsk9 ;

     if ((retVal = rtl8367b_setAsicPHYReg(port, PHY_1000_BASET_CONTROL_REG, phyData)) != RT_ERR_OK)
         return retVal;

     /*Auto-Negotiation control register setting*/
     if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_AN_ADVERTISEMENT_REG, &phyData)) != RT_ERR_OK)
         return retVal;

     phyData = (phyData & (~0x0DE0)) | phyEnMsk4;
     if ((retVal = rtl8367b_setAsicPHYReg(port, PHY_AN_ADVERTISEMENT_REG, phyData)) != RT_ERR_OK)
         return retVal;

     /*Control register setting and power off/on*/
     phyData = phyEnMsk0 & (~(1 << 12));
     phyData |= (1 << 11);   /* power down PHY, bit 11 should be set to 1 */
     if ((retVal = rtl8367b_setAsicPHYReg(port, PHY_CONTROL_REG, phyData)) != RT_ERR_OK)
         return retVal;

     phyData = phyData & (~(1 << 11));   /* power on PHY, bit 11 should be set to 0*/
     if ((retVal = rtl8367b_setAsicPHYReg(port, PHY_CONTROL_REG, phyData)) != RT_ERR_OK)
         return retVal;

     return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyForceModeAbility_get
 * Description:
 *      Get PHY ability through PHY registers.
 * Input:
 *      port - Port id.
 * Output:
 *      pAbility - Ability structure
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_PHY_REG_ID 		- Invalid PHY address
 *      RT_ERR_INPUT 			- Invalid input parameters.
 *      RT_ERR_BUSYWAIT_TIMEOUT - PHY access busy
 * Note:
 *      Get the capablity of specified PHY.
 */
rtk_api_ret_t rtk_port_phyForceModeAbility_get(rtk_port_t port, rtk_port_phy_ability_t *pAbility)
{
    rtk_api_ret_t       retVal;
    rtk_uint32          phyData0;
    rtk_uint32          phyData4;
    rtk_uint32          phyData9;
    rtk_port_media_t    media_type;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

     if (port == RTK_PORT_COMBO_ID)
     {
         if ((retVal = rtk_port_phyComboPortMedia_get(port, &media_type)) != RT_ERR_OK)
             return retVal;

         if(media_type == PORT_MEDIA_FIBER)
         {
             return _rtk_port_FiberModeAbility_get(port, pAbility);
         }
     }

    if ((retVal = rtl8367b_setAsicPHYReg(port, RTL8367B_PHY_PAGE_ADDRESS, 0)) != RT_ERR_OK)
        return retVal;

    /*Control register setting and restart auto*/
    if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_CONTROL_REG, &phyData0)) != RT_ERR_OK)
        return retVal;

    /*Auto-Negotiation control register setting*/
    if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_AN_ADVERTISEMENT_REG, &phyData4)) != RT_ERR_OK)
        return retVal;

    /*1000 BASE-T control register setting*/
    if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_1000_BASET_CONTROL_REG, &phyData9)) != RT_ERR_OK)
        return retVal;

    if (phyData9 & (1 << 9))
        pAbility->Full_1000 = 1;
    else
        pAbility->Full_1000 = 0;

    if (phyData4 & (1 << 11))
        pAbility->AsyFC = 1;
    else
        pAbility->AsyFC = 0;

    if (phyData4 & ((1 << 10)))
        pAbility->FC = 1;
    else
        pAbility->FC = 0;


    if (phyData4 & (1 << 8))
        pAbility->Full_100 = 1;
    else
        pAbility->Full_100 = 0;

    if (phyData4 & (1 << 7))
        pAbility->Half_100 = 1;
    else
        pAbility->Half_100 = 0;

    if (phyData4 & (1 << 6))
        pAbility->Full_10 = 1;
    else
        pAbility->Full_10 = 0;

    if (phyData4 & (1 << 5))
        pAbility->Half_10 = 1;
    else
        pAbility->Half_10 = 0;


    if (phyData0 & (1 << 12))
        pAbility->AutoNegotiation = 1;
    else
        pAbility->AutoNegotiation = 0;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyStatus_get
 * Description:
 *      Get ethernet PHY linking status
 * Input:
 *      port - Port id.
 * Output:
 *      linkStatus  - PHY link status
 *      speed       - PHY link speed
 *      duplex      - PHY duplex mode
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_PHY_REG_ID 		- Invalid PHY address
 *      RT_ERR_INPUT 			- Invalid input parameters.
 *      RT_ERR_BUSYWAIT_TIMEOUT - PHY access busy
 * Note:
 *      API will return auto negotiation status of phy.
 */
rtk_api_ret_t rtk_port_phyStatus_get(rtk_port_t port, rtk_port_linkStatus_t *pLinkStatus, rtk_data_t *pSpeed, rtk_data_t *pDuplex)
{
    rtk_api_ret_t retVal;
    rtk_uint32 phyData;
    rtk_uint32 data;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if((retVal = rtl8367b_setAsicReg(0x13C2, 0x0249)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1300, &data)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPHYReg(port, RTL8367B_PHY_PAGE_ADDRESS, 0)) != RT_ERR_OK)
        return retVal;

    /*Get PHY status register*/
    if (RT_ERR_OK != rtl8367b_getAsicPHYReg(port, PHY_STATUS_REG, &phyData))
        return RT_ERR_FAILED;

    if (RT_ERR_OK != rtl8367b_getAsicPHYReg(port, PHY_STATUS_REG, &phyData))
        return RT_ERR_FAILED;

    /*check link status*/
    if (phyData & (1<<2))
    {
        *pLinkStatus = 1;

        if( (data == 0x0276) || (data == 0x0597) || (data == 0x6367) )
        {
            /*Get PHY resolved register*/
            if ((retVal = rtl8367b_getAsicPHYReg(port, 26, &phyData)) != RT_ERR_OK)
                return retVal;

            /*check link speed*/
            *pSpeed = (phyData&0x0030) >> 4;

            /*check link duplex*/
            *pDuplex = (phyData&0x0008) >> 3;
        }
        else
        {
            /*Get PHY resolved register*/
            if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_RESOLVED_REG, &phyData)) != RT_ERR_OK)
                return retVal;

            /*check resolution is complete or not*/
            if (!(phyData&(1 << 11)))
                return RT_ERR_BUSYWAIT_TIMEOUT;

            /*check link speed*/
            *pSpeed = (phyData&0xC000) >> 14;

            /*check link duplex*/
            *pDuplex = (phyData&0x2000) >> 13;
        }
    }
    else
    {
        *pLinkStatus = 0;
        *pSpeed = 0;
        *pDuplex = 0;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phy1000BaseTMasterSlave_set
 * Description:
 *      Set PHY control enable MASTER/SLAVE manual configuration.
 * Input:
 *      port - port id.
 *      enable - Manual configuration function 1:enable 0:disable.
 *      masterslave - Manual config mode 1:master 0: slave
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_BUSYWAIT_TIMEOUT - PHY access busy
 *      RT_ERR_ENABLE 			- Invalid enable input.
 * Note:
 *      Set enable/disable MASTER/SLAVE manual configuration under 1000Base-T with register 9.12-9.11. If MASTER/SLAVE manual configuration is enabled with MASTER, the
 *      link partner must be set as SLAVE or auto negotiation will fail.
 */
rtk_api_ret_t rtk_port_phy1000BaseTMasterSlave_set(rtk_port_t port, rtk_enable_t enable, rtk_enable_t masterslave)
{
    rtk_api_ret_t retVal;
    rtk_uint32 phyData;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_setAsicPHYReg(port, RTL8367B_PHY_PAGE_ADDRESS, 0)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_1000_BASET_CONTROL_REG, &phyData)) != RT_ERR_OK)
        return retVal;

    phyData = (phyData & (~(0x3 << 11))) | (enable << 12) | (masterslave << 11);

    if ((retVal = rtl8367b_setAsicPHYReg(port, PHY_1000_BASET_CONTROL_REG, phyData)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPHYReg(port, PHY_1000_BASET_CONTROL_REG, phyData)) != RT_ERR_OK)
        return retVal;

    /*Restart N-way*/
    if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_CONTROL_REG, &phyData)) != RT_ERR_OK)
        return retVal;


    phyData = phyData | (1 << 9);
    if ((retVal = rtl8367b_setAsicPHYReg(port, PHY_CONTROL_REG, phyData)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_macForceLink_set
 * Description:
 *      Set port force linking configuration.
 * Input:
 *      port            - port id.
 *      pPortability    - port ability configuration
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 * Note:
 *      This API can set Port/MAC force mode properties.
 */
rtk_api_ret_t rtk_port_macForceLink_set(rtk_port_t port, rtk_port_mac_ability_t *pPortability)
{
    rtk_api_ret_t retVal;
    rtl8367b_port_ability_t ability;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (pPortability->forcemode >1|| pPortability->speed > 2 || pPortability->duplex > 1 ||
       pPortability->link > 1 || pPortability->nway > 1 || pPortability->txpause > 1 || pPortability->rxpause > 1)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_getAsicPortForceLink(port, &ability)) != RT_ERR_OK)
        return retVal;

    ability.forcemode = pPortability->forcemode;
    ability.speed     = pPortability->speed;
    ability.duplex    = pPortability->duplex;
    ability.link      = pPortability->link;
    ability.nway      = pPortability->nway;
    ability.txpause   = pPortability->txpause;
    ability.rxpause   = pPortability->rxpause;

    if ((retVal = rtl8367b_setAsicPortForceLink(port, &ability)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_macForceLink_get
 * Description:
 *      Get port force linking configuration.
 * Input:
 *      port - Port id.
 * Output:
 *      pPortability - port ability configuration
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can get Port/MAC force mode properties.
 */
rtk_api_ret_t rtk_port_macForceLink_get(rtk_port_t port, rtk_port_mac_ability_t *pPortability)
{
    rtk_api_ret_t retVal;
    rtl8367b_port_ability_t ability;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortForceLink(port, &ability)) != RT_ERR_OK)
        return retVal;

    pPortability->forcemode = ability.forcemode;
    pPortability->speed     = ability.speed;
    pPortability->duplex    = ability.duplex;
    pPortability->link      = ability.link;
    pPortability->nway      = ability.nway;
    pPortability->txpause   = ability.txpause;
    pPortability->rxpause   = ability.rxpause;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_macForceLinkExt0_set
 * Description:
 *      Set external interface 0 force linking configuration.
 * Input:
 *      mode            - external interface mode
 *      pPortability    - port ability configuration
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can set external interface 0 force mode properties.
 *      The external interface can be set to:
 *      - MODE_EXT_DISABLE,
 *      - MODE_EXT_RGMII,
 *      - MODE_EXT_MII_MAC,
 *      - MODE_EXT_MII_PHY,
 *      - MODE_EXT_TMII_MAC,
 *      - MODE_EXT_TMII_PHY,
 *      - MODE_EXT_GMII,
 *      - MODE_EXT_RMII_MAC,
 */
rtk_api_ret_t rtk_port_macForceLinkExt0_set(rtk_mode_ext_t mode, rtk_port_mac_ability_t *pPortability)
{
    return rtk_port_macForceLinkExt_set(EXT_PORT_1, mode, pPortability);
}

/* Function Name:
 *      rtk_port_macForceLinkExt0_get
 * Description:
 *      Get external interface 0 force linking configuration.
 * Input:
 *      None
 * Output:
 *      pMode           - external interface mode
 *      pPortability    - port ability configuration
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can get external interface 0 force mode properties.
 */
rtk_api_ret_t rtk_port_macForceLinkExt0_get(rtk_mode_ext_t *pMode, rtk_port_mac_ability_t *pPortability)
{
    return rtk_port_macForceLinkExt_get(EXT_PORT_1, pMode, pPortability);
}


/* Function Name:
 *      rtk_port_macForceLinkExt1_set
 * Description:
 *      Set external interface 1 force linking configuration.
 * Input:
 *      mode            - external interface mode
 *      pPortability    - port ability configuration
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can set external interface 1 force mode properties.
 *      The external interface can be set to:
 *      - MODE_EXT_DISABLE,
 *      - MODE_EXT_RGMII,
 *      - MODE_EXT_MII_MAC,
 *      - MODE_EXT_MII_PHY,
 *      - MODE_EXT_TMII_MAC,
 *      - MODE_EXT_TMII_PHY,
 *      - MODE_EXT_GMII,
 *      - MODE_EXT_RMII_MAC,
 */
rtk_api_ret_t rtk_port_macForceLinkExt1_set(rtk_mode_ext_t mode, rtk_port_mac_ability_t *pPortability)
{
    return rtk_port_macForceLinkExt_set(EXT_PORT_0, mode, pPortability);
}

/* Function Name:
 *      rtk_port_macForceLinkExt1_get
 * Description:
 *      Get external interface 1 force linking configuration.
 * Input:
 *      None
 * Output:
 *      pMode           - external interface mode
 *      pPortability    - port ability configuration
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can get external interface 1 force mode properties.
 */
rtk_api_ret_t rtk_port_macForceLinkExt1_get(rtk_mode_ext_t *pMode, rtk_port_mac_ability_t *pPortability)
{
    return rtk_port_macForceLinkExt_get(EXT_PORT_0, pMode, pPortability);
}

/* Function Name:
 *      rtk_port_macForceLinkExt_set
 * Description:
 *      Set external interface force linking configuration.
 * Input:
 *      port            - external port ID
 *      mode            - external interface mode
 *      pPortability    - port ability configuration
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can set external interface force mode properties.
 *      The external interface can be set to:
 *      - MODE_EXT_DISABLE,
 *      - MODE_EXT_RGMII,
 *      - MODE_EXT_MII_MAC,
 *      - MODE_EXT_MII_PHY,
 *      - MODE_EXT_TMII_MAC,
 *      - MODE_EXT_TMII_PHY,
 *      - MODE_EXT_GMII,
 *      - MODE_EXT_RMII_MAC,
 */
rtk_api_ret_t rtk_port_macForceLinkExt_set(rtk_ext_port_t port, rtk_mode_ext_t mode, rtk_port_mac_ability_t *pPortability)
{
    rtk_api_ret_t retVal;
    rtl8367b_port_ability_t ability;
    rtk_uint32  reg, mask;

    if (port >= EXT_PORT_END)
        return RT_ERR_INPUT;

    if (mode >=MODE_EXT_END)
        return RT_ERR_INPUT;

    if ((mode == MODE_EXT_RGMII_33V) || (mode == MODE_EXT_RMII_PHY))
        return RT_ERR_INPUT;

    if (pPortability->forcemode > 1 || pPortability->speed > 2 || pPortability->duplex > 1 ||
       pPortability->link > 1 || pPortability->nway > 1 || pPortability->txpause > 1 || pPortability->rxpause > 1)
        return RT_ERR_INPUT;

    if(port == EXT_PORT_0)
    {
        reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT;
        mask = RTL8367B_SELECT_GMII_0_MASK;
    }
    else if(port == EXT_PORT_1)
    {
        reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT;
        mask = RTL8367B_SELECT_GMII_1_MASK;
    }
    else if(port == EXT_PORT_2)
    {
        reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT_1;
        mask = RTL8367B_SELECT_RGMII_2_MASK;
    }
    else
        return RT_ERR_INPUT;

    if(mode == MODE_EXT_DISABLE)
    {
        memset(&ability, 0x00, sizeof(rtl8367b_port_ability_t));
        if ((retVal = rtl8367b_setAsicPortForceLinkExt( (rtk_uint32)port, &ability)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicPortExtMode(port, mode)) != RT_ERR_OK)
            return retVal;
    }
    else
    {
        if ((retVal = rtl8367b_setAsicPortExtMode(port, mode)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_getAsicPortForceLinkExt( (rtk_uint32)port, &ability)) != RT_ERR_OK)
            return retVal;

        ability.forcemode = pPortability->forcemode;
        ability.speed     = pPortability->speed;
        ability.duplex    = pPortability->duplex;
        ability.link      = pPortability->link;
        ability.nway      = pPortability->nway;
        ability.txpause   = pPortability->txpause;
        ability.rxpause   = pPortability->rxpause;

        if ((retVal = rtl8367b_setAsicPortForceLinkExt( (rtk_uint32)port, &ability)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_macForceLinkExt_get
 * Description:
 *      Set external interface force linking configuration.
 * Input:
 *      port            - external port ID
 * Output:
 *      pMode           - external interface mode
 *      pPortability    - port ability configuration
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can get external interface force mode properties.
 */
rtk_api_ret_t rtk_port_macForceLinkExt_get(rtk_ext_port_t port, rtk_mode_ext_t *pMode, rtk_port_mac_ability_t *pPortability)
{
    rtk_api_ret_t retVal;
    rtl8367b_port_ability_t ability;
    rtk_uint32  reg, mask;

    if (port >= EXT_PORT_END)
        return RT_ERR_INPUT;

    if(port == EXT_PORT_0)
    {
        reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT;
        mask = RTL8367B_SELECT_GMII_0_MASK;
    }
    else if(port == EXT_PORT_1)
    {
        reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT;
        mask = RTL8367B_SELECT_GMII_1_MASK;
    }
    else if(port == EXT_PORT_2)
    {
        reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT_1;
        mask = RTL8367B_SELECT_RGMII_2_MASK;
    }
    else
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_getAsicPortExtMode(port, (rtk_uint32 *)pMode)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPortForceLinkExt( (rtk_uint32)port, &ability)) != RT_ERR_OK)
        return retVal;

    pPortability->forcemode = ability.forcemode;
    pPortability->speed     = ability.speed;
    pPortability->duplex    = ability.duplex;
    pPortability->link      = ability.link;
    pPortability->nway      = ability.nway;
    pPortability->txpause   = ability.txpause;
    pPortability->rxpause   = ability.rxpause;

    return RT_ERR_OK;

}

/* Function Name:
 *      rtk_port_macStatus_get
 * Description:
 *      Get port link status.
 * Input:
 *      port - Port id.
 * Output:
 *      pPortstatus - port ability configuration
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 * Note:
 *      This API can get Port/PHY properties.
 */
rtk_api_ret_t rtk_port_macStatus_get(rtk_port_t port, rtk_port_mac_ability_t *pPortstatus)
{
    rtk_api_ret_t retVal;
    rtl8367b_port_status_t status;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortStatus(port, &status)) != RT_ERR_OK)
        return retVal;

    pPortstatus->speed     = status.speed;
    pPortstatus->duplex    = status.duplex;
    pPortstatus->link      = status.link;
    pPortstatus->nway      = status.nway;
    pPortstatus->txpause   = status.txpause;
    pPortstatus->rxpause   = status.rxpause;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_macLocalLoopbackEnable_set
 * Description:
 *      Set Port Local Loopback. (Redirect TX to RX.)
 * Input:
 *      port    - Port id.
 *      enable  - Loopback state, 0:disable, 1:enable
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 * Note:
 *      This API can enable/disable Local loopback in MAC.
 *      For UTP port, This API will also enable the digital
 *      loopback bit in PHY register for sync of speed between
 *      PHY and MAC. For EXT port, users need to force the
 *      link state by themself.
 */
rtk_api_ret_t rtk_port_macLocalLoopbackEnable_set(rtk_port_t port, rtk_enable_t enable)
{
    rtk_api_ret_t   retVal;
    rtk_uint32      data;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_setAsicPortLoopback(port, enable)) != RT_ERR_OK)
        return retVal;

    if(port <= RTK_PHY_ID_MAX)
    {
        if ((retVal = rtl8367b_getAsicPHYReg(port, PHY_CONTROL_REG, &data)) != RT_ERR_OK)
            return retVal;

        if(enable == ENABLED)
            data |= (0x0001 << 14);
        else
            data &= ~(0x0001 << 14);

        if ((retVal = rtl8367b_setAsicPHYReg(port, PHY_CONTROL_REG, data)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_macLocalLoopbackEnable_get
 * Description:
 *      Get Port Local Loopback. (Redirect TX to RX.)
 * Input:
 *      port    - Port id.
 * Output:
 *      pEnable  - Loopback state, 0:disable, 1:enable
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port number.
 * Note:
 *      None.
 */
rtk_api_ret_t rtk_port_macLocalLoopbackEnable_get(rtk_port_t port, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortLoopback(port, pEnable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyReg_set
 * Description:
 *      Set PHY register data of the specific port.
 * Input:
 *      port    - port id.
 *      reg     - Register id
 *      regData - Register data
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_PORT_ID          - Invalid port number.
 *      RT_ERR_PHY_REG_ID       - Invalid PHY address
 *      RT_ERR_BUSYWAIT_TIMEOUT - PHY access busy
 * Note:
 *      This API can set PHY register data of the specific port.
 */
rtk_api_ret_t rtk_port_phyReg_set(rtk_port_t port, rtk_port_phy_reg_t reg, rtk_port_phy_data_t regData)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PHY_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_setAsicPHYReg(port, RTL8367B_PHY_PAGE_ADDRESS, 0)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPHYReg(port, reg, regData)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyReg_get
 * Description:
 *      Get PHY register data of the specific port.
 * Input:
 *      port    - Port id.
 *      reg     - Register id
 * Output:
 *      pData   - Register data
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_PORT_ID          - Invalid port number.
 *      RT_ERR_PHY_REG_ID       - Invalid PHY address
 *      RT_ERR_BUSYWAIT_TIMEOUT - PHY access busy
 * Note:
 *      This API can get PHY register data of the specific port.
 */
rtk_api_ret_t rtk_port_phyReg_get(rtk_port_t port, rtk_port_phy_reg_t reg, rtk_port_phy_data_t *pData)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PHY_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_setAsicPHYReg(port, RTL8367B_PHY_PAGE_ADDRESS, 0)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPHYReg(port, reg, pData)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_backpressureEnable_set
 * Description:
 *      Set the half duplex backpressure enable status of the specific port.
 * Input:
 *      port    - port id.
 *      enable  - Back pressure status.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_ENABLE       - Invalid enable input.
 * Note:
 *      This API can set the half duplex backpressure enable status of the specific port.
 *      The half duplex backpressure enable status of the port is as following:
 *      - DISABLE
 *      - ENABLE
 */
rtk_api_ret_t rtk_port_backpressureEnable_set(rtk_port_t port, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    if (port != RTK_WHOLE_SYSTEM)
        return RT_ERR_PORT_ID;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicPortJamMode(!enable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_backpressureEnable_get
 * Description:
 *      Get the half duplex backpressure enable status of the specific port.
 * Input:
 *      port - Port id.
 * Output:
 *      pEnable - Back pressure status.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      This API can get the half duplex backpressure enable status of the specific port.
 *      The half duplex backpressure enable status of the port is as following:
 *      - DISABLE
 *      - ENABLE
 */
rtk_api_ret_t rtk_port_backpressureEnable_get(rtk_port_t port, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;
    rtk_uint32 regData;

    if (port != RTK_WHOLE_SYSTEM)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortJamMode(&regData)) != RT_ERR_OK)
        return retVal;

    *pEnable = !regData;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_adminEnable_set
 * Description:
 *      Set port admin configuration of the specific port.
 * Input:
 *      port    - port id.
 *      enable  - Back pressure status.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_ENABLE       - Invalid enable input.
 * Note:
 *      This API can set port admin configuration of the specific port.
 *      The port admin configuration of the port is as following:
 *      - DISABLE
 *      - ENABLE
 */
rtk_api_ret_t rtk_port_adminEnable_set(rtk_port_t port, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;
    rtk_uint32      data;

    if (port > RTK_PHY_ID_MAX)
        return RT_ERR_PORT_ID;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if ((retVal = rtk_port_phyReg_get(port, PHY_CONTROL_REG, &data)) != RT_ERR_OK)
        return retVal;

    if (ENABLED == enable)
    {
        data &= 0xF7FF;
        data |= 0x0200;
    }
    else if (DISABLED == enable)
    {
        data |= 0x0800;
    }

    if ((retVal = rtk_port_phyReg_set(port, PHY_CONTROL_REG, data)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_adminEnable_get
 * Description:
 *      Get port admin configurationof the specific port.
 * Input:
 *      port - Port id.
 * Output:
 *      pEnable - Back pressure status.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      This API can get port admin configuration of the specific port.
 *      The port admin configuration of the port is as following:
 *      - DISABLE
 *      - ENABLE
 */
rtk_api_ret_t rtk_port_adminEnable_get(rtk_port_t port, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;
    rtk_uint32      data;

    if (port > RTK_PHY_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtk_port_phyReg_get(port, PHY_CONTROL_REG, &data)) != RT_ERR_OK)
        return retVal;

    if ( (data & 0x0800) == 0x0800)
    {
        *pEnable = DISABLED;
    }
    else
    {
        *pEnable = ENABLED;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_isolation_set
 * Description:
 *      Set permitted port isolation portmask
 * Input:
 *      port        - port id.
 *      portmask    - Permit port mask
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_PORT_MASK    - Invalid portmask.
 * Note:
 *      This API set the port mask that a port can trasmit packet to of each port
 *      A port can only transmit packet to ports included in permitted portmask
 */
rtk_api_ret_t rtk_port_isolation_set(rtk_port_t port, rtk_portmask_t portmask)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ( portmask.bits[0] > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    if ((retVal = rtl8367b_setAsicPortIsolationPermittedPortmask(port, portmask.bits[0])) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_isolation_get
 * Description:
 *      Get permitted port isolation portmask
 * Input:
 *      port - Port id.
 * Output:
 *      pPortmask - Permit port mask
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      This API get the port mask that a port can trasmit packet to of each port
 *      A port can only transmit packet to ports included in permitted portmask
 */
rtk_api_ret_t rtk_port_isolation_get(rtk_port_t port, rtk_portmask_t *pPortmask)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortIsolationPermittedPortmask(port, &pPortmask->bits[0])) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_rgmiiDelayExt0_set
 * Description:
 *      Set RGMII interface 0 delay value for TX and RX.
 * Input:
 *      txDelay - TX delay value, 1 for delay 2ns and 0 for no-delay
 *      rxDelay - RX delay value, 0~7 for delay setup.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      This API can set external interface 0 RGMII delay.
 *      In TX delay, there are 2 selection: no-delay and 2ns delay.
 *      In RX dekay, there are 8 steps for delay tunning. 0 for n0-delay, and 7 for maximum delay.
 */
rtk_api_ret_t rtk_port_rgmiiDelayExt0_set(rtk_data_t txDelay, rtk_data_t rxDelay)
{
    return rtk_port_rgmiiDelayExt_set(EXT_PORT_1, txDelay, rxDelay);
}

/* Function Name:
 *      rtk_port_rgmiiDelayExt0_get
 * Description:
 *      Get RGMII interface 0 delay value for TX and RX.
 * Input:
 *      None
 * Output:
 *      pTxDelay - TX delay value
 *      pRxDelay - RX delay value
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can set external interface 0 RGMII delay.
 *      In TX delay, there are 2 selection: no-delay and 2ns delay.
 *      In RX dekay, there are 8 steps for delay tunning. 0 for n0-delay, and 7 for maximum delay.
 */
rtk_api_ret_t rtk_port_rgmiiDelayExt0_get(rtk_data_t *pTxDelay, rtk_data_t *pRxDelay)
{
    return rtk_port_rgmiiDelayExt_get(EXT_PORT_1, pTxDelay, pRxDelay);
}

/* Function Name:
 *      rtk_port_rgmiiDelayExt1_set
 * Description:
 *      Set RGMII interface 1 delay value for TX and RX.
 * Input:
 *      txDelay - TX delay value, 1 for delay 2ns and 0 for no-delay
 *      rxDelay - RX delay value, 0~7 for delay setup.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can set external interface 1 RGMII delay.
 *      In TX delay, there are 2 selection: no-delay and 2ns delay.
 *      In RX dekay, there are 8 steps for delay tunning. 0 for n0-delay, and 7 for maximum delay.
 */
rtk_api_ret_t rtk_port_rgmiiDelayExt1_set(rtk_data_t txDelay, rtk_data_t rxDelay)
{
    return rtk_port_rgmiiDelayExt_set(EXT_PORT_0, txDelay, rxDelay);
}

/* Function Name:
 *      rtk_port_rgmiiDelayExt1_get
 * Description:
 *      Get RGMII interface 1 delay value for TX and RX.
 * Input:
 *      None
 * Output:
 *      pTxDelay - TX delay value
 *      pRxDelay - RX delay value
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can set external interface 1 RGMII delay.
 *      In TX delay, there are 2 selection: no-delay and 2ns delay.
 *      In RX dekay, there are 8 steps for delay tunning. 0 for n0-delay, and 7 for maximum delay.
 */
rtk_api_ret_t rtk_port_rgmiiDelayExt1_get(rtk_data_t *pTxDelay, rtk_data_t *pRxDelay)
{
    return rtk_port_rgmiiDelayExt_get(EXT_PORT_0, pTxDelay, pRxDelay);
}

/* Function Name:
 *      rtk_port_rgmiiDelayExt_set
 * Description:
 *      Set RGMII interface delay value for TX and RX.
 * Input:
 *      port    - EXT port
 *      txDelay - TX delay value, 1 for delay 2ns and 0 for no-delay
 *      rxDelay - RX delay value, 0~7 for delay setup.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can set external interface 2 RGMII delay.
 *      In TX delay, there are 2 selection: no-delay and 2ns delay.
 *      In RX dekay, there are 8 steps for delay tunning. 0 for no-delay, and 7 for maximum delay.
 */
rtk_api_ret_t rtk_port_rgmiiDelayExt_set(rtk_ext_port_t port, rtk_data_t txDelay, rtk_data_t rxDelay)
{
    rtk_api_ret_t retVal;
    rtk_uint32 regAddr, regData;

    if ((txDelay > 1) || (rxDelay > 7))
        return RT_ERR_INPUT;

    if (port >= EXT_PORT_END)
        return RT_ERR_INPUT;

    if(port == EXT_PORT_0)
        regAddr = RTL8367B_REG_EXT0_RGMXF;
    else if(port == EXT_PORT_1)
        regAddr = RTL8367B_REG_EXT1_RGMXF;
    else if(port == EXT_PORT_2)
        regAddr = RTL8367B_REG_EXT2_RGMXF;
    else
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_getAsicReg(regAddr, &regData)) != RT_ERR_OK)
        return retVal;

    regData = (regData & 0xFFF0) | ((txDelay << 3) & 0x0008) | (rxDelay & 0x0007);

    if ((retVal = rtl8367b_setAsicReg(regAddr, regData)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_rgmiiDelayExt_get
 * Description:
 *      Get RGMII interface delay value for TX and RX.
 * Input:
 *      None
 * Output:
 *      port     - EXT port
 *      pTxDelay - TX delay value
 *      pRxDelay - RX delay value
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can set external interface 2 RGMII delay.
 *      In TX delay, there are 2 selection: no-delay and 2ns delay.
 *      In RX dekay, there are 8 steps for delay tunning. 0 for n0-delay, and 7 for maximum delay.
 */
rtk_api_ret_t rtk_port_rgmiiDelayExt_get(rtk_ext_port_t port, rtk_data_t *pTxDelay, rtk_data_t *pRxDelay)
{
    rtk_api_ret_t retVal;
    rtk_uint32 regAddr, regData;

    if (port >= EXT_PORT_END)
        return RT_ERR_INPUT;

    if(port == EXT_PORT_0)
        regAddr = RTL8367B_REG_EXT0_RGMXF;
    else if(port == EXT_PORT_1)
        regAddr = RTL8367B_REG_EXT1_RGMXF;
    else if(port == EXT_PORT_2)
        regAddr = RTL8367B_REG_EXT2_RGMXF;
    else
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_getAsicReg(regAddr, &regData)) != RT_ERR_OK)
        return retVal;

    *pTxDelay = (regData & 0x0008) >> 3;
    *pRxDelay = regData & 0x0007;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyEnableAll_set
 * Description:
 *      Set all PHY enable status.
 * Input:
 *      enable - PHY Enable State.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_ENABLE       - Invalid enable input.
 * Note:
 *      This API can set all PHY status.
 *      The configuration of all PHY is as following:
 *      - DISABLE
 *      - ENABLE
 */
rtk_api_ret_t rtk_port_phyEnableAll_set(rtk_enable_t enable)
{
    rtk_api_ret_t retVal;
    rtk_uint32 data;
    rtk_uint32 port;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if((retVal = rtl8367b_setAsicReg(0x13C2, 0x0249)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1300, &data)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPortEnableAll(enable)) != RT_ERR_OK)
        return retVal;

    if( (data == 0x0276) || (data == 0x0597) || (data == 0x6367) )
    {
        for(port = 0; port <= RTK_PHY_ID_MAX; port++)
        {
            if ((retVal = rtk_port_phyReg_get(port, PHY_CONTROL_REG, &data)) != RT_ERR_OK)
                return retVal;

            if (ENABLED == enable)
            {
                data &= 0xF7FF;
                data |= 0x0200;
            }
            else
            {
                data |= 0x0800;
            }

            if ((retVal = rtk_port_phyReg_set(port, PHY_CONTROL_REG, data)) != RT_ERR_OK)
                return retVal;
        }
    }

    return RT_ERR_OK;

}

/* Function Name:
 *      rtk_port_phyEnableAll_get
 * Description:
 *      Get all PHY enable status.
 * Input:
 *      None
 * Output:
 *      pEnable - PHY Enable State.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      This API can set all PHY status.
 *      The configuration of all PHY is as following:
 *      - DISABLE
 *      - ENABLE
 */
rtk_api_ret_t rtk_port_phyEnableAll_get(rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicPortEnableAll(pEnable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_efid_set
 * Description:
 *      Set port-based enhanced filtering database
 * Input:
 *      port - Port id.
 *      efid - Specified enhanced filtering database.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_L2_FID - Invalid fid.
 *      RT_ERR_INPUT - Invalid input parameter.
 *      RT_ERR_PORT_ID - Invalid port ID.
 * Note:
 *      The API can set port-based enhanced filtering database.
 */
rtk_api_ret_t rtk_port_efid_set(rtk_port_t port, rtk_data_t efid)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    /* efid must be 0~7 */
    if (efid > RTK_EFID_MAX)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicPortIsolationEfid(port, efid))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_efid_get
 * Description:
 *      Get port-based enhanced filtering database
 * Input:
 *      port - Port id.
 * Output:
 *      pEfid - Specified enhanced filtering database.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_INPUT - Invalid input parameters.
 *      RT_ERR_PORT_ID - Invalid port ID.
 * Note:
 *      The API can get port-based enhanced filtering database status.
 */
rtk_api_ret_t rtk_port_efid_get(rtk_port_t port, rtk_data_t *pEfid)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortIsolationEfid(port, pEfid))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyComboPortMedia_set
 * Description:
 *      Set Combo port media type
 * Input:
 *      port    - Port id. (Should be Port 4)
 *      media   - Media (COPPER or FIBER)
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_INPUT            - Invalid input parameters.
 *      RT_ERR_PORT_ID          - Invalid port ID.
 * Note:
 *      The API can Set Combo port media type.
 */
rtk_api_ret_t rtk_port_phyComboPortMedia_set(rtk_port_t port, rtk_port_media_t media)
{
    rtk_api_ret_t retVal;
    rtk_uint32 data;

    if (port != RTK_PORT_COMBO_ID)
        return RT_ERR_PORT_ID;

    if (media >= PORT_MEDIA_END)
        return RT_ERR_INPUT;

    if((retVal = rtl8367b_setAsicReg(0x13C2, 0x0249)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1300, &data)) != RT_ERR_OK)
        return retVal;

    if( (data == 0x0276) || (data == 0x0597) || (data == 0x6367) )
    {
        if(media == PORT_MEDIA_FIBER)
        {
            if ((retVal = rtl8367b_setAsicReg(0x6602, 0x8CD3))!=RT_ERR_OK)
            return retVal;

            if ((retVal = rtl8367b_setAsicReg(0x6601, 0x0426))!=RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicReg(0x6600, 0x00C0))!=RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicRegBit(RTL8367B_REG_UTP_FIB_DET, RTL8367B_UTP_FIRST_OFFSET, 0))!=RT_ERR_OK)
                return retVal;
        }
        else
        {
            if ((retVal = rtl8367b_setAsicRegBit(RTL8367B_REG_UTP_FIB_DET, RTL8367B_UTP_FIRST_OFFSET, 1))!=RT_ERR_OK)
                return retVal;
        }
    }
    else
    {
        if(media == PORT_MEDIA_FIBER)
        {
            if ((retVal = rtl8367b_setAsicReg(RTL8367B_REG_FIBER_CFG_2, 0x3f55))!=RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicReg(RTL8367B_REG_UTP_FIB_DET, 0xd1b9))!=RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicRegBit(RTL8367B_REG_SDS_EXT_CFG15, 14, 1))!=RT_ERR_OK)
                return retVal;
        }
        else
        {
            if ((retVal = rtl8367b_setAsicReg(RTL8367B_REG_FIBER_CFG_2, 0x35ff))!=RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicReg(RTL8367B_REG_UTP_FIB_DET, 0x11bb))!=RT_ERR_OK)
                return retVal;
        }
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyComboPortMedia_get
 * Description:
 *      Get Combo port media type
 * Input:
 *      port    - Port id. (Should be Port 4)
 * Output:
 *      pMedia  - Media (COPPER or FIBER)
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_INPUT            - Invalid input parameters.
 *      RT_ERR_PORT_ID          - Invalid port ID.
 * Note:
 *      The API can Set Combo port media type.
 */
rtk_api_ret_t rtk_port_phyComboPortMedia_get(rtk_port_t port, rtk_port_media_t *pMedia)
{
    rtk_api_ret_t   retVal;
    rtk_uint32      data, data1, data2;

    if (port != RTK_PORT_COMBO_ID)
        return RT_ERR_PORT_ID;

    if((retVal = rtl8367b_setAsicReg(0x13C2, 0x0249)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1300, &data)) != RT_ERR_OK)
        return retVal;

    if( (data == 0x0276) || (data == 0x0597) || (data == 0x6367) )
    {
        if ((retVal = rtl8367b_getAsicRegBit(RTL8367B_REG_UTP_FIB_DET, RTL8367B_UTP_FIRST_OFFSET, &data))!=RT_ERR_OK)
            return retVal;

        if(data == 1)
            *pMedia = PORT_MEDIA_COPPER;
        else
            *pMedia = PORT_MEDIA_FIBER;
    }
    else
    {
        if ((retVal = rtl8367b_getAsicReg(RTL8367B_REG_FIBER_CFG_2, &data1))!=RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_getAsicReg(RTL8367B_REG_UTP_FIB_DET, &data2))!=RT_ERR_OK)
            return retVal;

        if ((data1 == 0x3f55) && (data2 == 0xd1b9))
            *pMedia = PORT_MEDIA_FIBER;
        else
            *pMedia = PORT_MEDIA_COPPER;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_rtctEnable_set
 * Description:
 *      Enable RTCT test
 * Input:
 *      portmask    - Port mask of RTCT enabled port
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_PORT_MASK        - Invalid port mask.
 * Note:
 *      The API can enable RTCT Test
 */
rtk_api_ret_t rtk_port_rtctEnable_set(rtk_portmask_t portmask)
{
    rtk_api_ret_t   retVal;

    if (portmask.bits[0] >= (0x0001 << RTL8367B_PHYNO))
        return RT_ERR_PORT_MASK;

    if ((retVal = rtl8367b_setAsicPortRTCT(portmask.bits[0]))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_rtctResult_get
 * Description:
 *      Get the result of RTCT test
 * Input:
 *      port        - Port ID
 * Output:
 *      pRtctResult - The result of RTCT result
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_PORT_ID              - Invalid port ID.
 *      RT_ERR_PHY_RTCT_NOT_FINISH  - Testing does not finish.
 * Note:
 *      The API can get RTCT test result.
 *      RTCT test may takes 4.8 seconds to finish its test at most.
 *      Thus, if this API return RT_ERR_PHY_RTCT_NOT_FINISH or
 *      other error code, the result can not be referenced and
 *      user should call this API again until this API returns
 *      a RT_ERR_OK.
 *      The result is stored at pRtctResult->ge_result
 *      pRtctResult->linkType is unused.
 *      The unit of channel length is 2.5cm. Ex. 300 means 300 * 2.5 = 750cm = 7.5M
 */
rtk_api_ret_t rtk_port_rtctResult_get(rtk_port_t port, rtk_rtctResult_t *pRtctResult)
{
    rtk_api_ret_t               retVal;
    rtl8367b_port_rtct_result_t result;

    if (port > RTL8367B_PHYIDMAX)
        return RT_ERR_PORT_ID;

    memset(pRtctResult, 0x00, sizeof(rtk_rtctResult_t));
    if ((retVal = rtl8367b_getAsicPortRTCTResult(port, &result))!=RT_ERR_OK)
        return retVal;

    pRtctResult->result.ge_result.channelALen = result.channelALen;
    pRtctResult->result.ge_result.channelBLen = result.channelBLen;
    pRtctResult->result.ge_result.channelCLen = result.channelCLen;
    pRtctResult->result.ge_result.channelDLen = result.channelDLen;

    pRtctResult->result.ge_result.channelALinedriver = result.channelALinedriver;
    pRtctResult->result.ge_result.channelBLinedriver = result.channelBLinedriver;
    pRtctResult->result.ge_result.channelCLinedriver = result.channelCLinedriver;
    pRtctResult->result.ge_result.channelDLinedriver = result.channelDLinedriver;

    pRtctResult->result.ge_result.channelAMismatch = result.channelAMismatch;
    pRtctResult->result.ge_result.channelBMismatch = result.channelBMismatch;
    pRtctResult->result.ge_result.channelCMismatch = result.channelCMismatch;
    pRtctResult->result.ge_result.channelDMismatch = result.channelDMismatch;

    pRtctResult->result.ge_result.channelAOpen = result.channelAOpen;
    pRtctResult->result.ge_result.channelBOpen = result.channelBOpen;
    pRtctResult->result.ge_result.channelCOpen = result.channelCOpen;
    pRtctResult->result.ge_result.channelDOpen = result.channelDOpen;

    pRtctResult->result.ge_result.channelAShort = result.channelAShort;
    pRtctResult->result.ge_result.channelBShort = result.channelBShort;
    pRtctResult->result.ge_result.channelCShort = result.channelCShort;
    pRtctResult->result.ge_result.channelDShort = result.channelDShort;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_leaky_vlan_set
 * Description:
 *      Set VLAN leaky.
 * Input:
 *      type - Packet type for VLAN leaky.
 *      enable - Leaky status.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_ENABLE       - Invalid enable input
 * Note:
 *      This API can set VLAN leaky for RMA and IGMP/MLD packets.
 *      The leaky frame types are as following:
 *      - LEAKY_BRG_GROUP,
 *      - LEAKY_FD_PAUSE,
 *      - LEAKY_SP_MCAST,
 *      - LEAKY_1X_PAE,
 *      - LEAKY_UNDEF_BRG_04,
 *      - LEAKY_UNDEF_BRG_05,
 *      - LEAKY_UNDEF_BRG_06,
 *      - LEAKY_UNDEF_BRG_07,
 *      - LEAKY_PROVIDER_BRIDGE_GROUP_ADDRESS,
 *      - LEAKY_UNDEF_BRG_09,
 *      - LEAKY_UNDEF_BRG_0A,
 *      - LEAKY_UNDEF_BRG_0B,
 *      - LEAKY_UNDEF_BRG_0C,
 *      - LEAKY_PROVIDER_BRIDGE_GVRP_ADDRESS,
 *      - LEAKY_8021AB,
 *      - LEAKY_UNDEF_BRG_0F,
 *      - LEAKY_BRG_MNGEMENT,
 *      - LEAKY_UNDEFINED_11,
 *      - LEAKY_UNDEFINED_12,
 *      - LEAKY_UNDEFINED_13,
 *      - LEAKY_UNDEFINED_14,
 *      - LEAKY_UNDEFINED_15,
 *      - LEAKY_UNDEFINED_16,
 *      - LEAKY_UNDEFINED_17,
 *      - LEAKY_UNDEFINED_18,
 *      - LEAKY_UNDEFINED_19,
 *      - LEAKY_UNDEFINED_1A,
 *      - LEAKY_UNDEFINED_1B,
 *      - LEAKY_UNDEFINED_1C,
 *      - LEAKY_UNDEFINED_1D,
 *      - LEAKY_UNDEFINED_1E,
 *      - LEAKY_UNDEFINED_1F,
 *      - LEAKY_GMRP,
 *      - LEAKY_GVRP,
 *      - LEAKY_UNDEF_GARP_22,
 *      - LEAKY_UNDEF_GARP_23,
 *      - LEAKY_UNDEF_GARP_24,
 *      - LEAKY_UNDEF_GARP_25,
 *      - LEAKY_UNDEF_GARP_26,
 *      - LEAKY_UNDEF_GARP_27,
 *      - LEAKY_UNDEF_GARP_28,
 *      - LEAKY_UNDEF_GARP_29,
 *      - LEAKY_UNDEF_GARP_2A,
 *      - LEAKY_UNDEF_GARP_2B,
 *      - LEAKY_UNDEF_GARP_2C,
 *      - LEAKY_UNDEF_GARP_2D,
 *      - LEAKY_UNDEF_GARP_2E,
 *      - LEAKY_UNDEF_GARP_2F,
 *      - LEAKY_IGMP,
 *      - LEAKY_IPMULTICAST.
 */
rtk_api_ret_t rtk_leaky_vlan_set(rtk_leaky_type_t type, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;
    rtk_uint32 port;
    rtl8367b_rma_t rmacfg;

    if (type >= LEAKY_END)
        return RT_ERR_INPUT;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if (type >= 0 && type <= LEAKY_UNDEF_GARP_2F)
    {
        if ((retVal = rtl8367b_getAsicRma(type, &rmacfg)) != RT_ERR_OK)
            return retVal;

        rmacfg.vlan_leaky = enable;

        if ((retVal = rtl8367b_setAsicRma(type, &rmacfg)) != RT_ERR_OK)
            return retVal;
    }
    else if (LEAKY_IPMULTICAST == type)
    {
        for (port = 0; port <= RTK_PORT_ID_MAX; port++)
        {
            if ((retVal = rtl8367b_setAsicIpMulticastVlanLeaky(port,enable)) != RT_ERR_OK)
                return retVal;
        }
    }
    else if (LEAKY_IGMP == type)
    {
        if ((retVal = rtl8367b_setAsicIGMPVLANLeaky(enable)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_leaky_vlan_get
 * Description:
 *      Get VLAN leaky.
 * Input:
 *      type - Packet type for VLAN leaky.
 * Output:
 *      pEnable - Leaky status.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can get VLAN leaky status for RMA and IGMP/MLD packets.
 *      The leaky frame types are as following:
 *      - LEAKY_BRG_GROUP,
 *      - LEAKY_FD_PAUSE,
 *      - LEAKY_SP_MCAST,
 *      - LEAKY_1X_PAE,
 *      - LEAKY_UNDEF_BRG_04,
 *      - LEAKY_UNDEF_BRG_05,
 *      - LEAKY_UNDEF_BRG_06,
 *      - LEAKY_UNDEF_BRG_07,
 *      - LEAKY_PROVIDER_BRIDGE_GROUP_ADDRESS,
 *      - LEAKY_UNDEF_BRG_09,
 *      - LEAKY_UNDEF_BRG_0A,
 *      - LEAKY_UNDEF_BRG_0B,
 *      - LEAKY_UNDEF_BRG_0C,
 *      - LEAKY_PROVIDER_BRIDGE_GVRP_ADDRESS,
 *      - LEAKY_8021AB,
 *      - LEAKY_UNDEF_BRG_0F,
 *      - LEAKY_BRG_MNGEMENT,
 *      - LEAKY_UNDEFINED_11,
 *      - LEAKY_UNDEFINED_12,
 *      - LEAKY_UNDEFINED_13,
 *      - LEAKY_UNDEFINED_14,
 *      - LEAKY_UNDEFINED_15,
 *      - LEAKY_UNDEFINED_16,
 *      - LEAKY_UNDEFINED_17,
 *      - LEAKY_UNDEFINED_18,
 *      - LEAKY_UNDEFINED_19,
 *      - LEAKY_UNDEFINED_1A,
 *      - LEAKY_UNDEFINED_1B,
 *      - LEAKY_UNDEFINED_1C,
 *      - LEAKY_UNDEFINED_1D,
 *      - LEAKY_UNDEFINED_1E,
 *      - LEAKY_UNDEFINED_1F,
 *      - LEAKY_GMRP,
 *      - LEAKY_GVRP,
 *      - LEAKY_UNDEF_GARP_22,
 *      - LEAKY_UNDEF_GARP_23,
 *      - LEAKY_UNDEF_GARP_24,
 *      - LEAKY_UNDEF_GARP_25,
 *      - LEAKY_UNDEF_GARP_26,
 *      - LEAKY_UNDEF_GARP_27,
 *      - LEAKY_UNDEF_GARP_28,
 *      - LEAKY_UNDEF_GARP_29,
 *      - LEAKY_UNDEF_GARP_2A,
 *      - LEAKY_UNDEF_GARP_2B,
 *      - LEAKY_UNDEF_GARP_2C,
 *      - LEAKY_UNDEF_GARP_2D,
 *      - LEAKY_UNDEF_GARP_2E,
 *      - LEAKY_UNDEF_GARP_2F,
 *      - LEAKY_IGMP,
 *      - LEAKY_IPMULTICAST.
 */
rtk_api_ret_t rtk_leaky_vlan_get(rtk_leaky_type_t type, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;
    rtk_uint32 port,tmp;
    rtl8367b_rma_t rmacfg;

    if (type >= LEAKY_END)
        return RT_ERR_INPUT;

    if (type >= 0 && type <= LEAKY_UNDEF_GARP_2F)
    {
        if ((retVal = rtl8367b_getAsicRma(type, &rmacfg)) != RT_ERR_OK)
            return retVal;

        *pEnable = rmacfg.vlan_leaky;

    }
    else if (LEAKY_IPMULTICAST == type)
    {
        for (port = 0; port <= RTK_PORT_ID_MAX; port++)
        {
            if ((retVal = rtl8367b_getAsicIpMulticastVlanLeaky(port, &tmp)) != RT_ERR_OK)
                return retVal;
            if (port>0&&(tmp!=*pEnable))
                return RT_ERR_FAILED;
            *pEnable = tmp;
        }
    }
    else if (LEAKY_IGMP == type)
    {
        if ((retVal = rtl8367b_getAsicIGMPVLANLeaky(&tmp)) != RT_ERR_OK)
            return retVal;

        *pEnable = tmp;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_leaky_portIsolation_set
 * Description:
 *      Set port isolation leaky.
 * Input:
 *      type - Packet type for port isolation leaky.
 *      enable - Leaky status.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_ENABLE       - Invalid enable input
 * Note:
 *      This API can set port isolation leaky for RMA and IGMP/MLD packets.
 *      The leaky frame types are as following:
 *      - LEAKY_BRG_GROUP,
 *      - LEAKY_FD_PAUSE,
 *      - LEAKY_SP_MCAST,
 *      - LEAKY_1X_PAE,
 *      - LEAKY_UNDEF_BRG_04,
 *      - LEAKY_UNDEF_BRG_05,
 *      - LEAKY_UNDEF_BRG_06,
 *      - LEAKY_UNDEF_BRG_07,
 *      - LEAKY_PROVIDER_BRIDGE_GROUP_ADDRESS,
 *      - LEAKY_UNDEF_BRG_09,
 *      - LEAKY_UNDEF_BRG_0A,
 *      - LEAKY_UNDEF_BRG_0B,
 *      - LEAKY_UNDEF_BRG_0C,
 *      - LEAKY_PROVIDER_BRIDGE_GVRP_ADDRESS,
 *      - LEAKY_8021AB,
 *      - LEAKY_UNDEF_BRG_0F,
 *      - LEAKY_BRG_MNGEMENT,
 *      - LEAKY_UNDEFINED_11,
 *      - LEAKY_UNDEFINED_12,
 *      - LEAKY_UNDEFINED_13,
 *      - LEAKY_UNDEFINED_14,
 *      - LEAKY_UNDEFINED_15,
 *      - LEAKY_UNDEFINED_16,
 *      - LEAKY_UNDEFINED_17,
 *      - LEAKY_UNDEFINED_18,
 *      - LEAKY_UNDEFINED_19,
 *      - LEAKY_UNDEFINED_1A,
 *      - LEAKY_UNDEFINED_1B,
 *      - LEAKY_UNDEFINED_1C,
 *      - LEAKY_UNDEFINED_1D,
 *      - LEAKY_UNDEFINED_1E,
 *      - LEAKY_UNDEFINED_1F,
 *      - LEAKY_GMRP,
 *      - LEAKY_GVRP,
 *      - LEAKY_UNDEF_GARP_22,
 *      - LEAKY_UNDEF_GARP_23,
 *      - LEAKY_UNDEF_GARP_24,
 *      - LEAKY_UNDEF_GARP_25,
 *      - LEAKY_UNDEF_GARP_26,
 *      - LEAKY_UNDEF_GARP_27,
 *      - LEAKY_UNDEF_GARP_28,
 *      - LEAKY_UNDEF_GARP_29,
 *      - LEAKY_UNDEF_GARP_2A,
 *      - LEAKY_UNDEF_GARP_2B,
 *      - LEAKY_UNDEF_GARP_2C,
 *      - LEAKY_UNDEF_GARP_2D,
 *      - LEAKY_UNDEF_GARP_2E,
 *      - LEAKY_UNDEF_GARP_2F,
 *      - LEAKY_IGMP,
 *      - LEAKY_IPMULTICAST.
 */
rtk_api_ret_t rtk_leaky_portIsolation_set(rtk_leaky_type_t type, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;
    rtk_uint32 port;
    rtl8367b_rma_t rmacfg;

    if (type >= LEAKY_END)
        return RT_ERR_INPUT;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if (type >= 0 && type <= LEAKY_UNDEF_GARP_2F)
    {
        if ((retVal = rtl8367b_getAsicRma(type, &rmacfg)) != RT_ERR_OK)
            return retVal;

        rmacfg.portiso_leaky = enable;

        if ((retVal = rtl8367b_setAsicRma(type, &rmacfg)) != RT_ERR_OK)
            return retVal;
    }
    else if (LEAKY_IPMULTICAST == type)
    {
        for (port = 0; port < RTK_MAX_NUM_OF_PORT; port++)
        {
            if ((retVal = rtl8367b_setAsicIpMulticastPortIsoLeaky(port,enable)) != RT_ERR_OK)
                return retVal;
        }
    }
    else if (LEAKY_IGMP == type)
    {
        if ((retVal = rtl8367b_setAsicIGMPIsoLeaky(enable)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_leaky_portIsolation_get
 * Description:
 *      Get port isolation leaky.
 * Input:
 *      type - Packet type for port isolation leaky.
 * Output:
 *      pEnable - Leaky status.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can get port isolation leaky status for RMA and IGMP/MLD packets.
 *      The leaky frame types are as following:
 *      - LEAKY_BRG_GROUP,
 *      - LEAKY_FD_PAUSE,
 *      - LEAKY_SP_MCAST,
 *      - LEAKY_1X_PAE,
 *      - LEAKY_UNDEF_BRG_04,
 *      - LEAKY_UNDEF_BRG_05,
 *      - LEAKY_UNDEF_BRG_06,
 *      - LEAKY_UNDEF_BRG_07,
 *      - LEAKY_PROVIDER_BRIDGE_GROUP_ADDRESS,
 *      - LEAKY_UNDEF_BRG_09,
 *      - LEAKY_UNDEF_BRG_0A,
 *      - LEAKY_UNDEF_BRG_0B,
 *      - LEAKY_UNDEF_BRG_0C,
 *      - LEAKY_PROVIDER_BRIDGE_GVRP_ADDRESS,
 *      - LEAKY_8021AB,
 *      - LEAKY_UNDEF_BRG_0F,
 *      - LEAKY_BRG_MNGEMENT,
 *      - LEAKY_UNDEFINED_11,
 *      - LEAKY_UNDEFINED_12,
 *      - LEAKY_UNDEFINED_13,
 *      - LEAKY_UNDEFINED_14,
 *      - LEAKY_UNDEFINED_15,
 *      - LEAKY_UNDEFINED_16,
 *      - LEAKY_UNDEFINED_17,
 *      - LEAKY_UNDEFINED_18,
 *      - LEAKY_UNDEFINED_19,
 *      - LEAKY_UNDEFINED_1A,
 *      - LEAKY_UNDEFINED_1B,
 *      - LEAKY_UNDEFINED_1C,
 *      - LEAKY_UNDEFINED_1D,
 *      - LEAKY_UNDEFINED_1E,
 *      - LEAKY_UNDEFINED_1F,
 *      - LEAKY_GMRP,
 *      - LEAKY_GVRP,
 *      - LEAKY_UNDEF_GARP_22,
 *      - LEAKY_UNDEF_GARP_23,
 *      - LEAKY_UNDEF_GARP_24,
 *      - LEAKY_UNDEF_GARP_25,
 *      - LEAKY_UNDEF_GARP_26,
 *      - LEAKY_UNDEF_GARP_27,
 *      - LEAKY_UNDEF_GARP_28,
 *      - LEAKY_UNDEF_GARP_29,
 *      - LEAKY_UNDEF_GARP_2A,
 *      - LEAKY_UNDEF_GARP_2B,
 *      - LEAKY_UNDEF_GARP_2C,
 *      - LEAKY_UNDEF_GARP_2D,
 *      - LEAKY_UNDEF_GARP_2E,
 *      - LEAKY_UNDEF_GARP_2F,
 *      - LEAKY_IGMP,
 *      - LEAKY_IPMULTICAST.
 */
rtk_api_ret_t rtk_leaky_portIsolation_get(rtk_leaky_type_t type, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;
    rtk_uint32 port, tmp;
    rtl8367b_rma_t rmacfg;

    if (type >= LEAKY_END)
        return RT_ERR_INPUT;

    if (type >= 0 && type <= LEAKY_UNDEF_GARP_2F)
    {
        if ((retVal = rtl8367b_getAsicRma(type, &rmacfg)) != RT_ERR_OK)
            return retVal;

        *pEnable = rmacfg.portiso_leaky;

    }
    else if (LEAKY_IPMULTICAST == type)
    {
        for (port = 0; port < RTK_MAX_NUM_OF_PORT; port++)
        {
            if ((retVal = rtl8367b_getAsicIpMulticastPortIsoLeaky(port, &tmp)) != RT_ERR_OK)
                return retVal;
            if (port > 0 &&(tmp != *pEnable))
                return RT_ERR_FAILED;
            *pEnable = tmp;
        }
    }
    else if (LEAKY_IGMP == type)
    {
        if ((retVal = rtl8367b_getAsicIGMPIsoLeaky(&tmp)) != RT_ERR_OK)
            return retVal;

        *pEnable = tmp;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_init
 * Description:
 *      Initialize VLAN.
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      VLAN is disabled by default. User has to call this API to enable VLAN before
 *      using it. And It will set a default VLAN(vid 1) including all ports and set
 *      all ports PVID to the default VLAN.
 */
rtk_api_ret_t rtk_vlan_init(void)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtl8367b_user_vlan4kentry vlan4K;
    rtl8367b_vlanconfiguser vlanMC;


    /* clean 32 VLAN member configuration */
    for (i = 0; i <= RTL8367B_CVIDXMAX; i++)
    {
        vlanMC.evid = 0;
        vlanMC.mbr = 0;
        vlanMC.fid_msti = 0;
        vlanMC.envlanpol = 0;
        vlanMC.meteridx = 0;
        vlanMC.vbpen = 0;
        vlanMC.vbpri = 0;
        if ((retVal = rtl8367b_setAsicVlanMemberConfig(i, &vlanMC)) != RT_ERR_OK)
            return retVal;
    }

    /* Set a default VLAN with vid 1 to 4K table for all ports */
    memset(&vlan4K, 0, sizeof(rtl8367b_user_vlan4kentry));
    vlan4K.vid = 1;
    vlan4K.mbr = RTK_MAX_PORT_MASK;
    vlan4K.untag = RTK_MAX_PORT_MASK;
    vlan4K.fid_msti = 0;
    if ((retVal = rtl8367b_setAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
        return retVal;


    /* Also set the default VLAN to 32 member configuration index 0 */
    memset(&vlanMC, 0, sizeof(rtl8367b_vlanconfiguser));
    vlanMC.evid = 1;
    vlanMC.mbr = RTK_MAX_PORT_MASK;
    vlanMC.fid_msti = 0;
    if ((retVal = rtl8367b_setAsicVlanMemberConfig(0, &vlanMC)) != RT_ERR_OK)
            return retVal;

    /* Set all ports PVID to default VLAN and tag-mode to original */
    for (i = 0; i < RTK_MAX_NUM_OF_PORT; i++)
    {
        if ((retVal = rtl8367b_setAsicVlanPortBasedVID(i, 0, 0)) != RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicVlanEgressTagMode(i, EG_TAG_MODE_ORI)) != RT_ERR_OK)
            return retVal;
    }

    /* enable VLAN */
    if ((retVal = rtl8367b_setAsicVlanFilter(TRUE)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_set
 * Description:
 *      Set a VLAN entry.
 * Input:
 *      vid - VLAN ID to configure.
 *      mbrmsk - VLAN member set portmask.
 *      untagmsk - VLAN untag set portmask.
 *      fid - filtering database.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_INPUT 		        - Invalid input parameters.
 *      RT_ERR_L2_FID               - Invalid FID.
 *      RT_ERR_VLAN_PORT_MBR_EXIST  - Invalid member port mask.
 *      RT_ERR_VLAN_VID             - Invalid VID parameter.
 * Note:
 *      There are 4K VLAN entry supported. User could configure the member set and untag set
 *      for specified vid through this API. The portmask's bit N means port N.
 *      For example, mbrmask 23=0x17=010111 means port 0,1,2,4 in the member set.
 *      FID is for SVL/IVL usage, specify 0~15, the VLAN would be configured as SVL mode.
 *      If FID is specified as RTK_IVL_MODE_FID, the VLAN would be configured as IVL mode.
 */
rtk_api_ret_t rtk_vlan_set(rtk_vlan_t vid, rtk_portmask_t mbrmsk, rtk_portmask_t untagmsk, rtk_fid_t fid)
{
    rtk_api_ret_t retVal;
    rtl8367b_user_vlan4kentry vlan4K;

    /* vid must be 0~4095 */
    if (vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    if (mbrmsk.bits[0] > RTK_MAX_PORT_MASK)
        return RT_ERR_VLAN_PORT_MBR_EXIST;

    if (untagmsk.bits[0] > RTK_MAX_PORT_MASK)
        return RT_ERR_VLAN_PORT_MBR_EXIST;

    /* fid must be 0~15 */
    if ( (fid != RTK_IVL_MODE_FID) && (fid > RTL8367B_FIDMAX) )
        return RT_ERR_L2_FID;

    /* update 4K table */
    memset(&vlan4K, 0, sizeof(rtl8367b_user_vlan4kentry));
    vlan4K.vid = vid;
    vlan4K.mbr = mbrmsk.bits[0];
    vlan4K.untag = untagmsk.bits[0];

    if(fid == RTK_IVL_MODE_FID)
    {
        vlan4K.ivl_svl  = 1;
        vlan4K.fid_msti = 0;
    }
    else
        vlan4K.fid_msti = fid;

    if ((retVal = rtl8367b_setAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
            return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_get
 * Description:
 *      Get a VLAN entry.
 * Input:
 *      vid - VLAN ID to configure.
 * Output:
 *      pMbrmsk - VLAN member set portmask.
 *      pUntagmsk - VLAN untag set portmask.
 *      pFid - filtering database.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_VLAN_VID     - Invalid VID parameter.
 * Note:
 *     The API can get the member set, untag set and fid settings for specified vid.
 */
rtk_api_ret_t rtk_vlan_get(rtk_vlan_t vid, rtk_portmask_t *pMbrmsk, rtk_portmask_t *pUntagmsk, rtk_fid_t *pFid)
{
    rtk_api_ret_t retVal;
    rtl8367b_user_vlan4kentry vlan4K;

    /* vid must be 0~4095 */
    if (vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    vlan4K.vid = vid;

    if ((retVal = rtl8367b_getAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
        return retVal;

    pMbrmsk->bits[0] = vlan4K.mbr;
    pUntagmsk->bits[0] = vlan4K.untag;

    if(vlan4K.ivl_svl == 1)
        *pFid = RTK_IVL_MODE_FID;
    else
        *pFid = vlan4K.fid_msti;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_mbrCfg_set
 * Description:
 *      Set a VLAN Member Configuration entry by index.
 * Input:
 *      idx     - Index of VLAN Member Configuration.
 *      pMbrcfg - VLAN member Configuration.
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_VLAN_VID     - Invalid VID parameter.
 * Note:
 *     Set a VLAN Member Configuration entry by index.
 */
rtk_api_ret_t rtk_vlan_mbrCfg_set(rtk_uint32 idx, rtk_vlan_mbrcfg_t *pMbrcfg)
{
    rtk_api_ret_t           retVal;

    /* Error check */
    if(pMbrcfg == NULL)
        return RT_ERR_NULL_POINTER;

    if(idx > RTL8367B_CVIDXMAX)
        return RT_ERR_INPUT;

    if(pMbrcfg->evid > RTL8367B_EVIDMAX)
        return RT_ERR_INPUT;

    if(pMbrcfg->mbr > RTL8367B_PORTMASK)
        return RT_ERR_PORT_MASK;

    if(pMbrcfg->fid_msti > RTL8367B_FIDMAX)
        return RT_ERR_L2_FID;

    if(pMbrcfg->envlanpol >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if(pMbrcfg->meteridx > RTL8367B_METERMAX)
        return RT_ERR_FILTER_METER_ID;

    if(pMbrcfg->vbpen >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if(pMbrcfg->vbpri > RTL8367B_PRIMAX)
        return RT_ERR_QOS_INT_PRIORITY;

    if ((retVal = rtl8367b_setAsicVlanMemberConfig(idx, (rtl8367b_vlanconfiguser *)pMbrcfg)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;

}

/* Function Name:
 *      rtk_vlan_mbrCfg_get
 * Description:
 *      Get a VLAN Member Configuration entry by index.
 * Input:
 *      idx - Index of VLAN Member Configuration.
 * Output:
 *      pMbrcfg - VLAN member Configuration.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_VLAN_VID     - Invalid VID parameter.
 * Note:
 *     Get a VLAN Member Configuration entry by index.
 */
rtk_api_ret_t rtk_vlan_mbrCfg_get(rtk_uint32 idx, rtk_vlan_mbrcfg_t *pMbrcfg)
{
    rtk_api_ret_t           retVal;

    /* Error check */
    if(pMbrcfg == NULL)
        return RT_ERR_NULL_POINTER;

    if(idx > RTL8367B_CVIDXMAX)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_getAsicVlanMemberConfig(idx, (rtl8367b_vlanconfiguser *)pMbrcfg)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *     rtk_vlan_portPvid_set
 * Description:
 *      Set port to specified VLAN ID(PVID).
 * Input:
 *      port - Port id.
 *      pvid - Specified VLAN ID.
 *      priority - 802.1p priority for the PVID.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_PORT_ID              - Invalid port number.
 *      RT_ERR_VLAN_PRIORITY        - Invalid priority.
 *      RT_ERR_VLAN_ENTRY_NOT_FOUND - VLAN entry not found.
 *      RT_ERR_VLAN_VID             - Invalid VID parameter.
 * Note:
 *       The API is used for Port-based VLAN. The untagged frame received from the
 *       port will be classified to the specified VLAN and assigned to the specified priority.
 */
rtk_api_ret_t rtk_vlan_portPvid_set(rtk_port_t port, rtk_vlan_t pvid, rtk_pri_t priority)
{
    rtk_api_ret_t retVal;
    rtk_int32 i;
    rtk_uint32 j;
    rtk_uint32 k;
    rtk_uint32 index,empty_idx;
    rtk_uint32 gvidx, proc;
    rtk_uint32 bUsed, pri;
    rtl8367b_user_vlan4kentry vlan4K;
    rtl8367b_vlanconfiguser vlanMC;
    rtl8367b_protocolvlancfg ppb_vlan_cfg;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    /* vid must be 0~4095 */
    if (pvid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    /* priority must be 0~7 */
    if (priority > RTL8367B_PRIMAX)
        return RT_ERR_VLAN_PRIORITY;


      empty_idx = 0xFFFF;

    for (i = RTL8367B_CVIDXMAX; i >= 0; i--)
    {
        if ((retVal = rtl8367b_getAsicVlanMemberConfig(i, &vlanMC)) != RT_ERR_OK)
            return retVal;

        if (pvid == vlanMC.evid)
        {
            if ((retVal = rtl8367b_setAsicVlanPortBasedVID(port, i, priority)) != RT_ERR_OK)
                return retVal;

            return RT_ERR_OK;
        }
        else if (vlanMC.evid == 0 && vlanMC.mbr == 0)
        {
            empty_idx = i;
        }
    }


    /*
        vid doesn't exist in 32 member configuration. Find an empty entry in
        32 member configuration, then copy entry from 4K. If 32 member configuration
        are all full, then find an entry which not used by Port-based VLAN and
        then replace it with 4K. Finally, assign the index to the port.
    */

    if (empty_idx != 0xFFFF)
    {
        vlan4K.vid = pvid;
        if ((retVal = rtl8367b_getAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
            return retVal;

        vlanMC.evid = pvid;
        vlanMC.mbr = vlan4K.mbr;
        vlanMC.fid_msti = vlan4K.fid_msti;
        vlanMC.meteridx= vlan4K.meteridx;
        vlanMC.envlanpol= vlan4K.envlanpol;
        vlanMC.vbpen = vlan4K.vbpen;
        vlanMC.vbpri = vlan4K.vbpri;

        if ((retVal = rtl8367b_setAsicVlanMemberConfig(empty_idx, &vlanMC)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicVlanPortBasedVID(port,empty_idx, priority)) != RT_ERR_OK)
            return retVal;

        return RT_ERR_OK;
     }

    if ((retVal = rtl8367b_getAsic1xGuestVidx(&gvidx)) != RT_ERR_OK)
        return retVal;

    /* 32 member configuration is full, found a unused entry to replace */
    for (i = 0; i <= RTL8367B_CVIDXMAX; i++)
    {
        bUsed = FALSE;

        for (j = 0; j < RTK_MAX_NUM_OF_PORT; j++)
        {
            if ((retVal = rtl8367b_getAsicVlanPortBasedVID(j, &index, &pri)) != RT_ERR_OK)
                return retVal;

            if (i == index)/*index i is in use by port j*/
            {
                bUsed = TRUE;
                break;
            }

            if (i == gvidx)
            {
                if ((retVal = rtl8367b_getAsic1xProcConfig(j, &proc)) != RT_ERR_OK)
                    return retVal;
                if (DOT1X_UNAUTH_GVLAN == proc )
                {
                    bUsed = TRUE;
                    break;
                }
            }

            for (k = 0; k <= RTL8367B_PROTOVLAN_GIDX_MAX; k++)
            {
                if ((retVal = rtl8367b_getAsicVlanPortAndProtocolBased(port, k, &ppb_vlan_cfg)) != RT_ERR_OK)
                    return retVal;
                if (ppb_vlan_cfg.valid == TRUE && ppb_vlan_cfg.vlan_idx == i)
                {
                    bUsed = TRUE;
                    break;
                }
            }
        }

        if (FALSE == bUsed)/*found a unused index, replace it*/
        {
            vlan4K.vid = pvid;
            if ((retVal = rtl8367b_getAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
                return retVal;
            vlanMC.evid = pvid;
            vlanMC.mbr = vlan4K.mbr;
            vlanMC.fid_msti = vlan4K.fid_msti;
            vlanMC.meteridx= vlan4K.meteridx;
            vlanMC.envlanpol= vlan4K.envlanpol;
            vlanMC.vbpen = vlan4K.vbpen;
            vlanMC.vbpri = vlan4K.vbpri;
            if ((retVal = rtl8367b_setAsicVlanMemberConfig(i, &vlanMC)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicVlanPortBasedVID(port, i, priority)) != RT_ERR_OK)
                return retVal;

            return RT_ERR_OK;
        }
    }

    return RT_ERR_FAILED;
}

/* Function Name:
 *      rtk_vlan_portPvid_get
 * Description:
 *      Get VLAN ID(PVID) on specified port.
 * Input:
 *      port - Port id.
 * Output:
 *      pPvid - Specified VLAN ID.
 *      pPriority - 802.1p priority for the PVID.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *     The API can get the PVID and 802.1p priority for the PVID of Port-based VLAN.
 */
rtk_api_ret_t rtk_vlan_portPvid_get(rtk_port_t port, rtk_vlan_t *pPvid, rtk_pri_t *pPriority)
{
    rtk_api_ret_t retVal;
    rtk_uint32 index, pri;
    rtl8367b_vlanconfiguser vlanMC;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicVlanPortBasedVID(port, &index, &pri)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicVlanMemberConfig(index, &vlanMC)) != RT_ERR_OK)
        return retVal;

    *pPvid = vlanMC.evid;
    *pPriority = pri;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_portIgrFilterEnable_set
 * Description:
 *      Set VLAN ingress for each port.
 * Input:
 *      port - Port id.
 *      igr_filter - VLAN ingress function enable status.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number
 *      RT_ERR_ENABLE       - Invalid enable input
 * Note:
 *      The status of vlan ingress filter is as following:
 *      - DISABLED
 *      - ENABLED
 *      While VLAN function is enabled, ASIC will decide VLAN ID for each received frame and get belonged member
 *      ports from VLAN table. If received port is not belonged to VLAN member ports, ASIC will drop received frame if VLAN ingress function is enabled.
 */
rtk_api_ret_t rtk_vlan_portIgrFilterEnable_set(rtk_port_t port, rtk_enable_t igr_filter)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (igr_filter >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsicVlanIngressFilter(port, igr_filter)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_portIgrFilterEnable_get
 * Description:
 *      Get VLAN Ingress Filter
 * Input:
 *      port        - Port id.
 * Output:
 *      pIgr_filter - VLAN ingress function enable status.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *     The API can Get the VLAN ingress filter status.
 *     The status of vlan ingress filter is as following:
 *     - DISABLED
 *     - ENABLED
 */
rtk_api_ret_t rtk_vlan_portIgrFilterEnable_get(rtk_port_t port, rtk_enable_t *pIgr_filter)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicVlanIngressFilter(port, pIgr_filter)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_portAcceptFrameType_set
 * Description:
 *      Set VLAN accept_frame_type
 * Input:
 *      port                - Port id.
 *      accept_frame_type   - accept frame type
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_PORT_ID                  - Invalid port number.
 *      RT_ERR_VLAN_ACCEPT_FRAME_TYPE   - Invalid frame type.
 * Note:
 *      The API is used for checking 802.1Q tagged frames.
 *      The accept frame type as following:
 *      - ACCEPT_FRAME_TYPE_ALL
 *      - ACCEPT_FRAME_TYPE_TAG_ONLY
 *      - ACCEPT_FRAME_TYPE_UNTAG_ONLY
 */
rtk_api_ret_t rtk_vlan_portAcceptFrameType_set(rtk_port_t port, rtk_vlan_acceptFrameType_t accept_frame_type)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (accept_frame_type >= ACCEPT_FRAME_TYPE_END)
        return RT_ERR_VLAN_ACCEPT_FRAME_TYPE;

    if ((retVal = rtl8367b_setAsicVlanAccpetFrameType(port, (rtl8367b_accframetype)accept_frame_type)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_portAcceptFrameType_get
 * Description:
 *      Get VLAN accept_frame_type
 * Input:
 *      port - Port id.
 * Output:
 *      pAccept_frame_type - accept frame type
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *     The API can Get the VLAN ingress filter.
 *     The accept frame type as following:
 *     - ACCEPT_FRAME_TYPE_ALL
 *     - ACCEPT_FRAME_TYPE_TAG_ONLY
 *     - ACCEPT_FRAME_TYPE_UNTAG_ONLY
 */
rtk_api_ret_t rtk_vlan_portAcceptFrameType_get(rtk_port_t port, rtk_vlan_acceptFrameType_t *pAccept_frame_type)
{
    rtk_api_ret_t retVal;
    rtl8367b_accframetype   acc_frm_type;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicVlanAccpetFrameType(port, &acc_frm_type)) != RT_ERR_OK)
        return retVal;

    *pAccept_frame_type = (rtk_vlan_acceptFrameType_t)acc_frm_type;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_vlanBasedPriority_set
 * Description:
 *      Set VLAN priority for each CVLAN.
 * Input:
 *      vid - Specified VLAN ID.
 *      priority - 802.1p priority for the PVID.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_VLAN_VID         - Invalid VID parameter.
 *      RT_ERR_VLAN_PRIORITY    - Invalid priority.
 * Note:
 *      This API is used to set priority per VLAN.
 */
rtk_api_ret_t rtk_vlan_vlanBasedPriority_set(rtk_vlan_t vid, rtk_pri_t priority)
{
    rtk_api_ret_t retVal;
    rtl8367b_user_vlan4kentry vlan4K;

    /* vid must be 0~4095 */
    if (vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    /* priority must be 0~7 */
    if (priority > RTL8367B_PRIMAX)
        return RT_ERR_VLAN_PRIORITY;

    /* update 4K table */
    vlan4K.vid = vid;
    if ((retVal = rtl8367b_getAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
        return retVal;

    vlan4K.vbpen = 1;
    vlan4K.vbpri = priority;
    if ((retVal = rtl8367b_setAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_vlanBasedPriority_get
 * Description:
 *      Get VLAN priority for each CVLAN.
 * Input:
 *      vid - Specified VLAN ID.
 * Output:
 *      pPriority - 802.1p priority for the PVID.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_VLAN_VID     - Invalid VID parameter.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *     This API is used to set priority per VLAN.
 */
rtk_api_ret_t rtk_vlan_vlanBasedPriority_get(rtk_vlan_t vid, rtk_pri_t *pPriority)
{
    rtk_api_ret_t retVal;
    rtl8367b_user_vlan4kentry vlan4K;

    /* vid must be 0~4095 */
    if (vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    /* update 4K table */
    vlan4K.vid = vid;
    if ((retVal = rtl8367b_getAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
        return retVal;

    if (vlan4K.vbpen != 1)
        return RT_ERR_FAILED;

    *pPriority = vlan4K.vbpri;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_protoAndPortBasedVlan_add
 * Description:
 *      Add the protocol-and-port-based vlan to the specified port of device.
 * Input:
 *      port - Port id.
 *      info - Protocol and port based VLAN configuration information.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_PORT_ID          - Invalid port number.
 *      RT_ERR_VLAN_VID         - Invalid VID parameter.
 *      RT_ERR_VLAN_PRIORITY    - Invalid priority.
 *      RT_ERR_TBL_FULL         - Table is full.
 *      RT_ERR_OUT_OF_RANGE     - input out of range.
 * Note:
 *      The incoming packet which match the protocol-and-port-based vlan will use the configure vid for ingress pipeline
 *      The frame type is shown in the following:
 *      - FRAME_TYPE_ETHERNET
 *      - FRAME_TYPE_RFC1042
 *      - FRAME_TYPE_LLCOTHER
 */
rtk_api_ret_t rtk_vlan_protoAndPortBasedVlan_add(rtk_port_t port, rtk_vlan_protoAndPortInfo_t info)
{
    rtk_api_ret_t retVal, i;
    rtk_uint32 exist, empty, used;
    rtl8367b_protocolgdatacfg ppb_data_cfg;
    rtl8367b_protocolvlancfg ppb_vlan_cfg;
    rtl8367b_user_vlan4kentry vlan4K;
    rtl8367b_vlanconfiguser vlanMC;
    rtl8367b_provlan_frametype tmp;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (info.proto_type > RTK_MAX_NUM_OF_PROTO_TYPE)
        return RT_ERR_OUT_OF_RANGE;

    if (info.frame_type >= FRAME_TYPE_END)
        return RT_ERR_OUT_OF_RANGE;

    if (info.cvid >= RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    if (info.cpri > RTL8367B_PRIMAX)
        return RT_ERR_VLAN_PRIORITY;

    exist = 0xFF;
    empty = 0xFF;
    for (i = RTL8367B_PROTOVLAN_GIDX_MAX; i >= 0; i--)
    {
        if ((retVal = rtl8367b_getAsicVlanProtocolBasedGroupData(i, &ppb_data_cfg)) != RT_ERR_OK)
            return retVal;
        tmp = info.frame_type;
        if (ppb_data_cfg.etherType == info.proto_type && ppb_data_cfg.frameType == tmp)
        {
            /*Already exist*/
            exist = i;
            break;
        }
        else if (ppb_data_cfg.etherType == 0 && ppb_data_cfg.frameType == 0)
        {
            /*find empty index*/
            empty = i;
        }
    }

    used = 0xFF;
    /*No empty and exist index*/
    if (0xFF == exist && 0xFF == empty)
        return RT_ERR_TBL_FULL;
    else if (exist<RTL8367B_PROTOVLAN_GROUPNO)
    {
       /*exist index*/
       used = exist;
    }
    else if (empty<RTL8367B_PROTOVLAN_GROUPNO)
    {
        /*No exist index, but have empty index*/
        ppb_data_cfg.frameType = info.frame_type;
        ppb_data_cfg.etherType = info.proto_type;
        if ((retVal = rtl8367b_setAsicVlanProtocolBasedGroupData(empty, &ppb_data_cfg)) != RT_ERR_OK)
            return retVal;
        used = empty;
    }
    else
        return RT_ERR_FAILED;

    /*
        Search 32 member configuration to see if the entry already existed.
        If existed, update the priority and assign the index to the port.
    */
    for (i = 0; i <= RTL8367B_CVIDXMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicVlanMemberConfig(i, &vlanMC)) != RT_ERR_OK)
            return retVal;
        if (info.cvid == vlanMC.evid)
        {
            if ((retVal = rtl8367b_getAsicVlanPortAndProtocolBased(port, used, &ppb_vlan_cfg)) != RT_ERR_OK)
                return retVal;
            if (FALSE == ppb_vlan_cfg.valid)
            {
                ppb_vlan_cfg.vlan_idx = i;
                ppb_vlan_cfg.valid = TRUE;
                ppb_vlan_cfg.priority = info.cpri;
                if ((retVal = rtl8367b_setAsicVlanPortAndProtocolBased(port, used, &ppb_vlan_cfg)) != RT_ERR_OK)
                    return retVal;
                return RT_ERR_OK;
            }
            else
                return RT_ERR_VLAN_EXIST;
        }
    }

    /*
        vid doesn't exist in 32 member configuration. Find an empty entry in
        32 member configuration, then copy entry from 4K. If 32 member configuration
        are all full, then find an entry which not used by Port-based VLAN and
        then replace it with 4K. Finally, assign the index to the port.
    */
    for (i = 0; i <= RTL8367B_CVIDXMAX; i++)
    {
        if (rtl8367b_getAsicVlanMemberConfig(i, &vlanMC) != RT_ERR_OK)
            return RT_ERR_FAILED;

        if (vlanMC.evid == 0 && vlanMC.mbr == 0)
        {
            vlan4K.vid = info.cvid;
            if ((retVal = rtl8367b_getAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
                return retVal;

            vlanMC.evid = info.cvid;
            vlanMC.mbr = vlan4K.mbr;
            vlanMC.fid_msti = vlan4K.fid_msti;
            vlanMC.meteridx= vlan4K.meteridx;
            vlanMC.envlanpol= vlan4K.envlanpol;
            vlanMC.vbpen = vlan4K.vbpen;
            vlanMC.vbpri = vlan4K.vbpri;

            if ((retVal = rtl8367b_setAsicVlanMemberConfig(i, &vlanMC)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_getAsicVlanPortAndProtocolBased(port, used, &ppb_vlan_cfg)) != RT_ERR_OK)
                return retVal;
            if (FALSE == ppb_vlan_cfg.valid)
            {
                ppb_vlan_cfg.vlan_idx = i;
                ppb_vlan_cfg.valid = TRUE;
                ppb_vlan_cfg.priority = info.cpri;
                if ((retVal = rtl8367b_setAsicVlanPortAndProtocolBased(port, used, &ppb_vlan_cfg)) != RT_ERR_OK)
                    return retVal;
                return RT_ERR_OK;
            }
            else
                return RT_ERR_VLAN_EXIST;
        }
    }

    return RT_ERR_FAILED;
}

/* Function Name:
 *      rtk_vlan_protoAndPortBasedVlan_get
 * Description:
 *      Get the protocol-and-port-based vlan to the specified port of device.
 * Input:
 *      port - Port id.
 *      proto_type - protocol-and-port-based vlan protocol type.
 *      frame_type - protocol-and-port-based vlan frame type.
 * Output:
 *      pInfo - Protocol and port based VLAN configuration information.
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_PORT_ID          - Invalid port number.
 *      RT_ERR_OUT_OF_RANGE     - input out of range.
 *      RT_ERR_TBL_FULL         - Table is full.
 * Note:
 *     The incoming packet which match the protocol-and-port-based vlan will use the configure vid for ingress pipeline
 *     The frame type is shown in the following:
 *      - FRAME_TYPE_ETHERNET
 *      - FRAME_TYPE_RFC1042
 *      - FRAME_TYPE_LLCOTHER
 */
rtk_api_ret_t rtk_vlan_protoAndPortBasedVlan_get(rtk_port_t port, rtk_vlan_proto_type_t proto_type, rtk_vlan_protoVlan_frameType_t frame_type, rtk_vlan_protoAndPortInfo_t *pInfo)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtk_uint32 ppb_idx;
    rtl8367b_vlanconfiguser vlanMC;
    rtl8367b_protocolgdatacfg ppb_data_cfg;
    rtl8367b_protocolvlancfg ppb_vlan_cfg;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (proto_type > RTK_MAX_NUM_OF_PROTO_TYPE)
        return RT_ERR_OUT_OF_RANGE;

    if (frame_type >= FRAME_TYPE_END)
        return RT_ERR_OUT_OF_RANGE;

   ppb_idx = 0;

    for (i = 0; i<= RTL8367B_PROTOVLAN_GIDX_MAX; i++)
    {
        if ((retVal = rtl8367b_getAsicVlanProtocolBasedGroupData(i, &ppb_data_cfg)) != RT_ERR_OK)
            return retVal;

        if (ppb_data_cfg.frameType == (rtl8367b_provlan_frametype)frame_type && ppb_data_cfg.etherType == proto_type)
        {
            ppb_idx = i;
            break;
        }
        else if (RTL8367B_PROTOVLAN_GIDX_MAX == i)
            return RT_ERR_TBL_FULL;
    }

    if ((retVal = rtl8367b_getAsicVlanPortAndProtocolBased(port, ppb_idx, &ppb_vlan_cfg)) != RT_ERR_OK)
        return retVal;

    if (FALSE == ppb_vlan_cfg.valid)
        return RT_ERR_FAILED;

    if ((retVal = rtl8367b_getAsicVlanMemberConfig(ppb_vlan_cfg.vlan_idx, &vlanMC)) != RT_ERR_OK)
        return retVal;

    pInfo->frame_type = frame_type;
    pInfo->proto_type = proto_type;
    pInfo->cvid = vlanMC.evid;
    pInfo->cpri = ppb_vlan_cfg.priority;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_protoAndPortBasedVlan_del
 * Description:
 *      Delete the protocol-and-port-based vlan from the specified port of device.
 * Input:
 *      port        - Port id.
 *      proto_type  - protocol-and-port-based vlan protocol type.
 *      frame_type  - protocol-and-port-based vlan frame type.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_PORT_ID          - Invalid port number.
 *      RT_ERR_OUT_OF_RANGE     - input out of range.
 *      RT_ERR_TBL_FULL         - Table is full.
 * Note:
 *     The incoming packet which match the protocol-and-port-based vlan will use the configure vid for ingress pipeline
 *     The frame type is shown in the following:
 *      - FRAME_TYPE_ETHERNET
 *      - FRAME_TYPE_RFC1042
 *      - FRAME_TYPE_LLCOTHER
 */
rtk_api_ret_t rtk_vlan_protoAndPortBasedVlan_del(rtk_port_t port, rtk_vlan_proto_type_t proto_type, rtk_vlan_protoVlan_frameType_t frame_type)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i, bUsed;
    rtk_uint32 ppb_idx;
    rtl8367b_protocolgdatacfg ppb_data_cfg;
    rtl8367b_protocolvlancfg ppb_vlan_cfg;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (proto_type > RTK_MAX_NUM_OF_PROTO_TYPE)
        return RT_ERR_OUT_OF_RANGE;

    if (frame_type >= FRAME_TYPE_END)
        return RT_ERR_OUT_OF_RANGE;

   ppb_idx = 0;

    for (i = 0; i<= RTL8367B_PROTOVLAN_GIDX_MAX; i++)
    {
        if ((retVal = rtl8367b_getAsicVlanProtocolBasedGroupData(i, &ppb_data_cfg)) != RT_ERR_OK)
            return retVal;

        if (ppb_data_cfg.frameType == (rtl8367b_provlan_frametype)frame_type && ppb_data_cfg.etherType == proto_type)
        {
            ppb_idx = i;
            ppb_vlan_cfg.valid = FALSE;
            ppb_vlan_cfg.vlan_idx = 0;
            ppb_vlan_cfg.priority = 0;
            if ((retVal = rtl8367b_setAsicVlanPortAndProtocolBased(port, ppb_idx, &ppb_vlan_cfg)) != RT_ERR_OK)
                return retVal;
        }
    }

    bUsed = FALSE;
    for (i = 0; i < RTK_MAX_NUM_OF_PORT; i++)
    {
        if ((retVal = rtl8367b_getAsicVlanPortAndProtocolBased(i, ppb_idx, &ppb_vlan_cfg)) != RT_ERR_OK)
            return retVal;

        if (TRUE == ppb_vlan_cfg.valid)
        {
            bUsed = TRUE;
                break;
        }
    }

    if (FALSE == bUsed) /*No Port use this PPB Index, Delete it*/
    {
        ppb_data_cfg.etherType=0;
        ppb_data_cfg.frameType=0;
        if ((retVal = rtl8367b_setAsicVlanProtocolBasedGroupData(ppb_idx, &ppb_data_cfg)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_protoAndPortBasedVlan_delAll
 * Description:
 *     Delete all protocol-and-port-based vlans from the specified port of device.
 * Input:
 *      port - Port id.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_PORT_ID          - Invalid port number.
 *      RT_ERR_OUT_OF_RANGE     - input out of range.
 * Note:
 *     The incoming packet which match the protocol-and-port-based vlan will use the configure vid for ingress pipeline
 *     Delete all flow table protocol-and-port-based vlan entries.
 */
rtk_api_ret_t rtk_vlan_protoAndPortBasedVlan_delAll(rtk_port_t port)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i, j, bUsed[4];
    rtl8367b_protocolgdatacfg ppb_data_cfg;
    rtl8367b_protocolvlancfg ppb_vlan_cfg;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    for (i = 0; i<= RTL8367B_PROTOVLAN_GIDX_MAX; i++)
    {
        ppb_vlan_cfg.valid = FALSE;
        ppb_vlan_cfg.vlan_idx = 0;
        ppb_vlan_cfg.priority = 0;
        if ((retVal = rtl8367b_setAsicVlanPortAndProtocolBased(port, i, &ppb_vlan_cfg)) != RT_ERR_OK)
            return retVal;
    }

    bUsed[0] = FALSE;
    bUsed[1] = FALSE;
    bUsed[2] = FALSE;
    bUsed[3] = FALSE;
    for (i = 0; i < RTK_MAX_NUM_OF_PORT; i++)
    {
        for (j = 0; j <= RTL8367B_PROTOVLAN_GIDX_MAX; j++)
        {
            if ((retVal = rtl8367b_getAsicVlanPortAndProtocolBased(i,j, &ppb_vlan_cfg)) != RT_ERR_OK)
                return retVal;

            if (TRUE == ppb_vlan_cfg.valid)
            {
                bUsed[j] = TRUE;
            }
        }
    }

    for (i = 0; i<= RTL8367B_PROTOVLAN_GIDX_MAX; i++)
    {
        if (FALSE == bUsed[i]) /*No Port use this PPB Index, Delete it*/
        {
            ppb_data_cfg.etherType=0;
            ppb_data_cfg.frameType=0;
            if ((retVal = rtl8367b_setAsicVlanProtocolBasedGroupData(i, &ppb_data_cfg)) != RT_ERR_OK)
                return retVal;
        }
    }



    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_tagMode_set
 * Description:
 *      Set CVLAN egress tag mode
 * Input:
 *      port        - Port id.
 *      tag_mode    - The egress tag mode.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_INPUT        - Invalid input parameter.
 *      RT_ERR_ENABLE       - Invalid enable input.
 * Note:
 *      The API can set Egress tag mode. There are 4 mode for egress tag:
 *      - VLAN_TAG_MODE_ORIGINAL,
 *      - VLAN_TAG_MODE_KEEP_FORMAT,
 *      - VLAN_TAG_MODE_PRI.
 *      - VLAN_TAG_MODE_REAL_KEEP_FORMAT,
 */
rtk_api_ret_t rtk_vlan_tagMode_set(rtk_port_t port, rtk_vlan_tagMode_t tag_mode)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (tag_mode >= VLAN_TAG_MODE_END)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_setAsicVlanEgressTagMode(port, tag_mode)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_tagMode_get
 * Description:
 *      Get CVLAN egress tag mode
 * Input:
 *      port - Port id.
 * Output:
 *      pTag_mode - The egress tag mode.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The API can get Egress tag mode. There are 4 mode for egress tag:
 *      - VLAN_TAG_MODE_ORIGINAL,
 *      - VLAN_TAG_MODE_KEEP_FORMAT,
 *      - VLAN_TAG_MODE_PRI.
 *      - VLAN_TAG_MODE_REAL_KEEP_FORMAT,
 */
rtk_api_ret_t rtk_vlan_tagMode_get(rtk_port_t port, rtk_vlan_tagMode_t *pTag_mode)
{
    rtk_api_ret_t retVal;
    rtl8367b_egtagmode  mode;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicVlanEgressTagMode(port, &mode)) != RT_ERR_OK)
        return retVal;

    *pTag_mode = (rtk_vlan_tagMode_t)mode;
    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_transparent_set
 * Description:
 *      Set VLAN transparent mode
 * Input:
 *      egr_port        - Egress Port id.
 *      igr_pmask       - Ingress Port Mask.
 *      enabled         - VLAN Transparent. Enabled: Ignore VLAN egress Filtering, Disable: Follow VLAN egress Filtering
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      None.
 */
rtk_api_ret_t rtk_vlan_transparent_set(rtk_port_t egr_port, rtk_portmask_t igr_pmask, rtk_enable_t enable)
{
     rtk_api_ret_t retVal;

     if (egr_port > RTK_PORT_ID_MAX)
         return RT_ERR_PORT_ID;

     if ((retVal = rtl8367b_setAsicVlanTransparent(enable)) != RT_ERR_OK)
         return retVal;

     if ((retVal = rtl8367b_setAsicVlanEgressKeep(egr_port, igr_pmask.bits[0])) != RT_ERR_OK)
         return retVal;

     return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_transparent_get
 * Description:
 *      Get VLAN transparent mode
 * Input:
 *      egr_port        - Egress Port id.
 * Output:
 *      pIgr_pmask      - Ingress Port Mask
 *      pEnabled        - VLAN Transparent. Enabled: Ignore VLAN egress Filtering, Disable: Follow VLAN egress Filtering
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      None.
 */
rtk_api_ret_t rtk_vlan_transparent_get(rtk_port_t egr_port, rtk_portmask_t *pIgr_pmask, rtk_enable_t *pEnable)
{
     rtk_api_ret_t retVal;
     rtk_uint32    pmask;

     if (egr_port > RTK_PORT_ID_MAX)
         return RT_ERR_PORT_ID;

     if ((retVal = rtl8367b_getAsicVlanTransparent(pEnable)) != RT_ERR_OK)
         return retVal;

     if ((retVal = rtl8367b_getAsicVlanEgressKeep(egr_port, &pmask)) != RT_ERR_OK)
         return retVal;

     pIgr_pmask->bits[0] = pmask;
     return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_stg_set
 * Description:
 *      Set spanning tree group instance of the vlan to the specified device
 * Input:
 *      vid - Specified VLAN ID.
 *      stg - spanning tree group instance.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_MSTI         - Invalid msti parameter
 *      RT_ERR_INPUT        - Invalid input parameter.
 *      RT_ERR_VLAN_VID     - Invalid VID parameter.
 * Note:
 *      The API can set spanning tree group instance of the vlan to the specified device.
 */
rtk_api_ret_t rtk_vlan_stg_set(rtk_vlan_t vid, rtk_stg_t stg)
{
    rtk_api_ret_t retVal;
    rtl8367b_user_vlan4kentry vlan4K;

    /* vid must be 0~4095 */
    if (vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    /* priority must be 0~15 */
    if (stg > RTL8367B_MSTIMAX)
        return RT_ERR_MSTI;

    /* update 4K table */
    vlan4K.vid = vid;
    if ((retVal = rtl8367b_getAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
        return retVal;

    vlan4K.fid_msti= stg;
    if ((retVal = rtl8367b_setAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_stg_get
 * Description:
 *      Get spanning tree group instance of the vlan to the specified device
 * Input:
 *      vid - Specified VLAN ID.
 * Output:
 *      pStg - spanning tree group instance.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_VLAN_VID     - Invalid VID parameter.
 * Note:
 *      The API can get spanning tree group instance of the vlan to the specified device.
 */
rtk_api_ret_t rtk_vlan_stg_get(rtk_vlan_t vid, rtk_stg_t *pStg)
{
    rtk_api_ret_t retVal;
    rtl8367b_user_vlan4kentry vlan4K;

    /* vid must be 0~4095 */
    if (vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    /* update 4K table */
    vlan4K.vid = vid;
    if ((retVal = rtl8367b_getAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
        return retVal;

    *pStg = vlan4K.fid_msti;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_portFid_set
 * Description:
 *      Set port-based filtering database
 * Input:
 *      port - Port id.
 *      enable - ebable port-based FID
 *      fid - Specified filtering database.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_L2_FID - Invalid fid.
 *      RT_ERR_INPUT - Invalid input parameter.
 *      RT_ERR_PORT_ID - Invalid port ID.
 * Note:
 *      The API can set port-based filtering database. If the function is enabled, all input
 *      packets will be assigned to the port-based fid regardless vlan tag.
 */
rtk_api_ret_t rtk_vlan_portFid_set(rtk_port_t port, rtk_enable_t enable, rtk_fid_t fid)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (enable>=RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    /* fid must be 0~4095 */
    if (fid > RTK_FID_MAX)
        return RT_ERR_L2_FID;

    if ((retVal = rtl8367b_setAsicPortBasedFidEn(port, enable))!=RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicPortBasedFid(port, fid))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_vlan_portFid_get
 * Description:
 *      Get port-based filtering database
 * Input:
 *      port - Port id.
 * Output:
 *      pEnable - ebable port-based FID
 *      pFid - Specified filtering database.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_INPUT - Invalid input parameters.
 *      RT_ERR_PORT_ID - Invalid port ID.
 * Note:
 *      The API can get port-based filtering database status. If the function is enabled, all input
 *      packets will be assigned to the port-based fid regardless vlan tag.
 */
rtk_api_ret_t rtk_vlan_portFid_get(rtk_port_t port, rtk_enable_t *pEnable, rtk_fid_t *pFid)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortBasedFidEn(port, pEnable))!=RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPortBasedFid(port, pFid))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_stp_init
 * Description:
 *      Initialize stp module of the specified device
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      Initialize stp module before calling any vlan APIs
 */
rtk_api_ret_t rtk_stp_init(void)
{
    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_stp_mstpState_set
 * Description:
 *      Configure spanning tree state per each port.
 * Input:
 *      port - Port id
 *      msti - Multiple spanning tree instance.
 *      stp_state - Spanning tree state for msti
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_MSTI         - Invalid msti parameter.
 *      RT_ERR_MSTP_STATE   - Invalid STP state.
 * Note:
 *      System supports per-port multiple spanning tree state for each msti.
 *      There are four states supported by ASIC.
 *      - STP_STATE_DISABLED
 *      - STP_STATE_BLOCKING
 *      - STP_STATE_LEARNING
 *      - STP_STATE_FORWARDING
 */
rtk_api_ret_t rtk_stp_mstpState_set(rtk_stp_msti_id_t msti, rtk_port_t port, rtk_stp_state_t stp_state)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (msti > RTK_MAX_NUM_OF_MSTI)
        return RT_ERR_MSTI;

    if (stp_state >= STP_STATE_END)
        return RT_ERR_MSTP_STATE;

    if ((retVal = rtl8367b_setAsicSpanningTreeStatus(port, msti, stp_state)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_stp_mstpState_get
 * Description:
 *      Get spanning tree state per each port.
 * Input:
 *      port - Port id.
 *      msti - Multiple spanning tree instance.
 * Output:
 *      pStp_state - Spanning tree state for msti
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_MSTI         - Invalid msti parameter.
 * Note:
 *      System supports per-port multiple spanning tree state for each msti.
 *      There are four states supported by ASIC.
 *      - STP_STATE_DISABLED
 *      - STP_STATE_BLOCKING
 *      - STP_STATE_LEARNING
 *      - STP_STATE_FORWARDING
 */
rtk_api_ret_t rtk_stp_mstpState_get(rtk_stp_msti_id_t msti, rtk_port_t port, rtk_stp_state_t *pStp_state)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicSpanningTreeStatus(port, msti, pStp_state)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_init
 * Description:
 *      Initialize l2 module of the specified device.
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK          - OK
 *      RT_ERR_FAILED      - Failed
 *      RT_ERR_SMI         - SMI access error
 * Note:
 *      Initialize l2 module before calling any l2 APIs.
 */
rtk_api_ret_t rtk_l2_init(void)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;

    if ((retVal = rtl8367b_setAsicLutIpMulticastLookup(DISABLE)) != RT_ERR_OK)
        return retVal;

    /*Enable CAM Usage*/
    if ((retVal = rtl8367b_setAsicLutCamTbUsage(ENABLE)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicLutAgeTimerSpeed(6,2)) != RT_ERR_OK)
        return retVal;

    for (i = 0; i <= RTK_PORT_ID_MAX; i++)
    {
        if ((retVal = rtl8367b_setAsicLutLearnLimitNo(i,2112)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}


/* Function Name:
 *      rtk_l2_addr_add
 * Description:
 *      Add LUT unicast entry.
 * Input:
 *      pMac - 6 bytes unicast(I/G bit is 0) mac address to be written into LUT.
 *      pL2_data - Unicast entry parameter
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_PORT_ID          - Invalid port number.
 *      RT_ERR_MAC              - Invalid MAC address.
 *      RT_ERR_L2_FID           - Invalid FID .
 *      RT_ERR_L2_INDEXTBL_FULL - hashed index is full of entries.
 *      RT_ERR_INPUT            - Invalid input parameters.
 * Note:
 *      If the unicast mac address already existed in LUT, it will udpate the status of the entry.
 *      Otherwise, it will find an empty or asic auto learned entry to write. If all the entries
 *      with the same hash value can't be replaced, ASIC will return a RT_ERR_L2_INDEXTBL_FULL error.
 */
rtk_api_ret_t rtk_l2_addr_add(rtk_mac_t *pMac, rtk_l2_ucastAddr_t *pL2_data)
{
    rtk_api_ret_t retVal;
    rtk_uint32 method;
    rtl8367b_luttb l2Table;

    /* must be unicast address */
    if ((pMac == NULL) || (pMac->octet[0] & 0x1))
        return RT_ERR_MAC;

    if (pL2_data->port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (pL2_data->ivl >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if (pL2_data->cvid > RTL8367B_VIDMAX)
        return RT_ERR_L2_VID;

    if (pL2_data->fid > RTL8367B_FIDMAX)
        return RT_ERR_L2_FID;

    if (pL2_data->is_static>= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if (pL2_data->sa_block>= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if (pL2_data->da_block>= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if (pL2_data->auth>= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if (pL2_data->efid> RTL8367B_EFIDMAX)
        return RT_ERR_INPUT;

    if (pL2_data->priority > RTL8367B_PRIMAX)
        return RT_ERR_INPUT;

    if (pL2_data->sa_pri_en >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if (pL2_data->fwd_pri_en >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    memset(&l2Table, 0, sizeof(rtl8367b_luttb));

    /* fill key (MAC,FID) to get L2 entry */
    memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
    l2Table.ivl_svl     = pL2_data->ivl;
    l2Table.fid         = pL2_data->fid;
    l2Table.cvid_fid    = pL2_data->cvid;
    l2Table.efid        = pL2_data->efid;
    method = LUTREADMETHOD_MAC;
    retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table);
    if (RT_ERR_OK == retVal )
    {
        memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
        l2Table.ivl_svl     = pL2_data->ivl;
        l2Table.cvid_fid    = pL2_data->cvid;
        l2Table.fid         = pL2_data->fid;
        l2Table.efid        = pL2_data->efid;
        l2Table.spa         = pL2_data->port;
        l2Table.nosalearn   = pL2_data->is_static;
        l2Table.sa_block    = pL2_data->sa_block;
        l2Table.da_block    = pL2_data->da_block;
        l2Table.l3lookup    = 0;
        l2Table.auth        = pL2_data->auth;
        l2Table.age         = 6;
        l2Table.lut_pri     = pL2_data->priority;
        l2Table.sa_en       = pL2_data->sa_pri_en;
        l2Table.fwd_en      = pL2_data->fwd_pri_en;
        retVal = rtl8367b_setAsicL2LookupTb(&l2Table);

        return retVal;
    }
    else if (RT_ERR_L2_ENTRY_NOTFOUND == retVal )
    {
        memset(&l2Table, 0, sizeof(rtl8367b_luttb));
        memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
        l2Table.ivl_svl     = pL2_data->ivl;
        l2Table.cvid_fid    = pL2_data->cvid;
        l2Table.fid         = pL2_data->fid;
        l2Table.efid        = pL2_data->efid;
        l2Table.spa         = pL2_data->port;
        l2Table.nosalearn   = pL2_data->is_static;
        l2Table.sa_block    = pL2_data->sa_block;
        l2Table.da_block    = pL2_data->da_block;
        l2Table.l3lookup    = 0;
        l2Table.auth        = pL2_data->auth;
        l2Table.age         = 6;
        l2Table.lut_pri     = pL2_data->priority;
        l2Table.sa_en       = pL2_data->sa_pri_en;
        l2Table.fwd_en      = pL2_data->fwd_pri_en;

        if ((retVal = rtl8367b_setAsicL2LookupTb(&l2Table)) != RT_ERR_OK)
            return retVal;

        method = LUTREADMETHOD_MAC;
        retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table);
        if (RT_ERR_L2_ENTRY_NOTFOUND == retVal )
            return RT_ERR_L2_INDEXTBL_FULL;
        else
            return retVal;
    }
    else
        return retVal;

}

/* Function Name:
 *      rtk_l2_addr_get
 * Description:
 *      Get LUT unicast entry.
 * Input:
 *      pMac    - 6 bytes unicast(I/G bit is 0) mac address to be written into LUT.
 * Output:
 *      pL2_data - Unicast entry parameter
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_PORT_ID              - Invalid port number.
 *      RT_ERR_MAC                  - Invalid MAC address.
 *      RT_ERR_L2_FID               - Invalid FID .
 *      RT_ERR_L2_ENTRY_NOTFOUND    - No such LUT entry.
 *      RT_ERR_INPUT                - Invalid input parameters.
 * Note:
 *      If the unicast mac address existed in LUT, it will return the port and fid where
 *      the mac is learned. Otherwise, it will return a RT_ERR_L2_ENTRY_NOTFOUND error.
 */
rtk_api_ret_t rtk_l2_addr_get(rtk_mac_t *pMac, rtk_l2_ucastAddr_t *pL2_data)
{
    rtk_api_ret_t retVal;
    rtk_uint32 method;
    rtl8367b_luttb l2Table;

    /* must be unicast address */
    if ((pMac == NULL) || (pMac->octet[0] & 0x1))
        return RT_ERR_MAC;

    if (pL2_data->fid > RTL8367B_FIDMAX || pL2_data->efid > RTL8367B_EFIDMAX)
        return RT_ERR_L2_FID;

    memset(&l2Table, 0, sizeof(rtl8367b_luttb));

    memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
    l2Table.ivl_svl     = pL2_data->ivl;
    l2Table.cvid_fid    = pL2_data->cvid;
    l2Table.fid         = pL2_data->fid;
    l2Table.efid        = pL2_data->efid;
    method = LUTREADMETHOD_MAC;

    if ((retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table)) != RT_ERR_OK)
        return retVal;

    memcpy(pL2_data->mac.octet, pMac->octet,ETHER_ADDR_LEN);
    pL2_data->port      = l2Table.spa;
    pL2_data->fid       = l2Table.fid;
    pL2_data->efid      = l2Table.efid;
    pL2_data->ivl       = l2Table.ivl_svl;
    pL2_data->cvid      = l2Table.cvid_fid;
    pL2_data->is_static = l2Table.nosalearn;
    pL2_data->auth      = l2Table.auth;
    pL2_data->sa_block  = l2Table.sa_block;
    pL2_data->da_block  = l2Table.da_block;
    pL2_data->priority  = l2Table.lut_pri;
    pL2_data->sa_pri_en = l2Table.sa_en;
    pL2_data->fwd_pri_en= l2Table.fwd_en;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_addr_next_get
 * Description:
 *      Get Next LUT unicast entry.
 * Input:
 *      read_method     - The reading method.
 *      port            - The port number if the read_metohd is READMETHOD_NEXT_L2UCSPA
 *      pAddress        - The Address ID
 * Output:
 *      pL2_data - Unicast entry parameter
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_PORT_ID              - Invalid port number.
 *      RT_ERR_MAC                  - Invalid MAC address.
 *      RT_ERR_L2_FID               - Invalid FID .
 *      RT_ERR_L2_ENTRY_NOTFOUND    - No such LUT entry.
 *      RT_ERR_INPUT                - Invalid input parameters.
 * Note:
 *      Get the next unicast entry after the current entry pointed by pAddress.
 *      The address of next entry is returned by pAddress. User can use (address + 1)
 *      as pAddress to call this API again for dumping all entries is LUT.
 */
rtk_api_ret_t rtk_l2_addr_next_get(rtk_l2_read_method_t read_method, rtk_port_t port, rtk_uint32 *pAddress, rtk_l2_ucastAddr_t *pL2_data)
{
    rtk_api_ret_t   retVal;
    rtk_uint32      method;
    rtl8367b_luttb  l2Table;

    /* Error Checking */
    if ((pL2_data == NULL) || (pAddress == NULL))
        return RT_ERR_MAC;

    if(read_method == READMETHOD_NEXT_L2UC)
        method = LUTREADMETHOD_NEXT_L2UC;
    else if(read_method == READMETHOD_NEXT_L2UCSPA)
        method = LUTREADMETHOD_NEXT_L2UCSPA;
    else
        return RT_ERR_INPUT;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if(*pAddress > RTK_MAX_LUT_ADDR_ID )
        return RT_ERR_L2_L2UNI_PARAM;

    memset(&l2Table, 0, sizeof(rtl8367b_luttb));
    l2Table.address = *pAddress;

    if(read_method == READMETHOD_NEXT_L2UCSPA)
        l2Table.spa = port;

    if ((retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table)) != RT_ERR_OK)
        return retVal;

    if(l2Table.address < *pAddress)
        return RT_ERR_L2_ENTRY_NOTFOUND;

    memcpy(pL2_data->mac.octet, l2Table.mac.octet, ETHER_ADDR_LEN);
    pL2_data->port      = l2Table.spa;
    pL2_data->fid       = l2Table.fid;
    pL2_data->efid      = l2Table.efid;
    pL2_data->ivl       = l2Table.ivl_svl;
    pL2_data->cvid      = l2Table.cvid_fid;
    pL2_data->is_static = l2Table.nosalearn;
    pL2_data->auth      = l2Table.auth;
    pL2_data->sa_block  = l2Table.sa_block;
    pL2_data->da_block  = l2Table.da_block;
    pL2_data->priority  = l2Table.lut_pri;
    pL2_data->sa_pri_en = l2Table.sa_en;
    pL2_data->fwd_pri_en= l2Table.fwd_en;

    *pAddress = l2Table.address;

    return RT_ERR_OK;

}

/* Function Name:
 *      rtk_l2_addr_del
 * Description:
 *      Delete LUT unicast entry.
 * Input:
 *      pMac - 6 bytes unicast(I/G bit is 0) mac address to be written into LUT.
 *      fid - Filtering database
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_PORT_ID              - Invalid port number.
 *      RT_ERR_MAC                  - Invalid MAC address.
 *      RT_ERR_L2_FID               - Invalid FID .
 *      RT_ERR_L2_ENTRY_NOTFOUND    - No such LUT entry.
 *      RT_ERR_INPUT                - Invalid input parameters.
 * Note:
 *      If the mac has existed in the LUT, it will be deleted. Otherwise, it will return RT_ERR_L2_ENTRY_NOTFOUND.
 */
rtk_api_ret_t rtk_l2_addr_del(rtk_mac_t *pMac, rtk_l2_ucastAddr_t *pL2_data)
{
    rtk_api_ret_t retVal;
    rtk_uint32 method;
    rtl8367b_luttb l2Table;

    /* must be unicast address */
    if ((pMac == NULL) || (pMac->octet[0] & 0x1))
        return RT_ERR_MAC;

    if (pL2_data->fid > RTL8367B_FIDMAX || pL2_data->efid > RTL8367B_EFIDMAX)
        return RT_ERR_L2_FID;

    memset(&l2Table, 0, sizeof(rtl8367b_luttb));

    /* fill key (MAC,FID) to get L2 entry */
    memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
    l2Table.ivl_svl     = pL2_data->ivl;
    l2Table.cvid_fid    = pL2_data->cvid;
    l2Table.fid         = pL2_data->fid;
    l2Table.efid        = pL2_data->efid;
    method = LUTREADMETHOD_MAC;
    retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table);
    if (RT_ERR_OK ==  retVal)
    {
        memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
        l2Table.ivl_svl     = pL2_data->ivl;
        l2Table.cvid_fid    = pL2_data->cvid;
	    l2Table.fid = pL2_data->fid;
	    l2Table.efid = pL2_data->efid;
        l2Table.spa = 0;
        l2Table.nosalearn = 0;
        l2Table.sa_block = 0;
        l2Table.da_block = 0;
        l2Table.auth = 0;
        l2Table.age = 0;
        l2Table.lut_pri = 0;
        l2Table.sa_en = 0;
        l2Table.fwd_en = 0;
        retVal = rtl8367b_setAsicL2LookupTb(&l2Table);
        return retVal;
    }
    else
        return retVal;
}

/* Function Name:
 *      rtk_l2_mcastAddr_add
 * Description:
 *      Add LUT multicast entry.
 * Input:
 *      pMac        - 6 bytes multicast(I/G bit is 1) mac address to be written into LUT.
 *      ivl         - IVL/SVL setting, 1:IVL, 0:SVL
 *      cvid_fid    - CVID or FID for the input LUT entry.
 *      portmask    - Port mask to be forwarded to.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_PORT_ID          - Invalid port number.
 *      RT_ERR_MAC              - Invalid MAC address.
 *      RT_ERR_L2_FID           - Invalid FID .
 *      RT_ERR_L2_VID           - Invalid VID .
 *      RT_ERR_L2_INDEXTBL_FULL - hashed index is full of entries.
 *      RT_ERR_PORT_MASK        - Invalid portmask.
 *      RT_ERR_INPUT            - Invalid input parameters.
 * Note:
 *      If the multicast mac address already existed in the LUT, it will udpate the
 *      port mask of the entry. Otherwise, it will find an empty or asic auto learned
 *      entry to write. If all the entries with the same hash value can't be replaced,
 *      ASIC will return a RT_ERR_L2_INDEXTBL_FULL error.
 */
rtk_api_ret_t rtk_l2_mcastAddr_add(rtk_mac_t *pMac, rtk_data_t ivl, rtk_data_t cvid_fid, rtk_portmask_t portmask)
{
    rtk_api_ret_t   retVal;
    rtk_uint32      method;
    rtl8367b_luttb  l2Table;

    /* must be L2 multicast address */
    if ((pMac == NULL) || (!(pMac->octet[0] & 0x1)))
        return RT_ERR_MAC;

    if (portmask.bits[0]> RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    if(ivl == 1)
    {
        if (cvid_fid > RTL8367B_VIDMAX)
            return RT_ERR_L2_VID;
    }
    else if(ivl == 0)
    {
        if (cvid_fid > RTL8367B_FIDMAX)
            return RT_ERR_L2_FID;
    }
    else
        return RT_ERR_INPUT;

    memset(&l2Table, 0, sizeof(rtl8367b_luttb));

    /* fill key (MAC,FID) to get L2 entry */
    memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
    l2Table.ivl_svl     = ivl;
    l2Table.cvid_fid    = cvid_fid;
    method = LUTREADMETHOD_MAC;
    retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table);
    if (RT_ERR_OK == retVal)
    {
        memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
        l2Table.ivl_svl     = ivl;
        l2Table.cvid_fid    = cvid_fid;
        l2Table.mbr         = portmask.bits[0];
        l2Table.nosalearn   = 1;
        l2Table.l3lookup    = 0;
        retVal = rtl8367b_setAsicL2LookupTb(&l2Table);
        return retVal;
    }
    else if (RT_ERR_L2_ENTRY_NOTFOUND == retVal)
    {
        memset(&l2Table, 0, sizeof(rtl8367b_luttb));
        memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
        l2Table.ivl_svl     = ivl;
        l2Table.cvid_fid    = cvid_fid;
        l2Table.mbr         = portmask.bits[0];
        l2Table.nosalearn   = 1;
        if ((retVal = rtl8367b_setAsicL2LookupTb(&l2Table)) != RT_ERR_OK)
            return retVal;

        method = LUTREADMETHOD_MAC;
        retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table);
        if (RT_ERR_L2_ENTRY_NOTFOUND == retVal)
            return     RT_ERR_L2_INDEXTBL_FULL;
        else
            return retVal;

    }
    else
        return retVal;

}

/* Function Name:
 *      rtk_l2_mcastAddr_get
 * Description:
 *      Get LUT multicast entry.
 * Input:
 *      pMac        - 6 bytes multicast(I/G bit is 1) mac address to be written into LUT.
 *      ivl         - IVL/SVL setting, 1:IVL, 0:SVL
 *      cvid_fid    - Filtering database
 * Output:
 *      pPortmask   - Port mask to be forwarded to.
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_MAC                  - Invalid MAC address.
 *      RT_ERR_L2_FID               - Invalid FID .
 *      RT_ERR_L2_VID               - Invalid VID .
 *      RT_ERR_L2_ENTRY_NOTFOUND    - No such LUT entry.
 *      RT_ERR_INPUT                - Invalid input parameters.
 * Note:
 *      If the multicast mac address existed in the LUT, it will return the port where
 *      the mac is learned. Otherwise, it will return a RT_ERR_L2_ENTRY_NOTFOUND error.
 */
rtk_api_ret_t rtk_l2_mcastAddr_get(rtk_mac_t *pMac, rtk_data_t ivl, rtk_data_t cvid_fid, rtk_portmask_t *pPortmask)
{
    rtk_api_ret_t retVal;
    rtk_uint32 method;
    rtl8367b_luttb l2Table;

    /* must be unicast address */
    if ((pMac == NULL) || !(pMac->octet[0] & 0x1))
        return RT_ERR_MAC;

    if(ivl == 1)
    {
        if (cvid_fid > RTL8367B_VIDMAX)
            return RT_ERR_L2_VID;
    }
    else if(ivl == 0)
    {
        if (cvid_fid > RTL8367B_FIDMAX)
            return RT_ERR_L2_FID;
    }
    else
        return RT_ERR_INPUT;

    memset(&l2Table, 0, sizeof(rtl8367b_luttb));
    memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
    l2Table.ivl_svl     = ivl;
    l2Table.cvid_fid    = cvid_fid;
    method = LUTREADMETHOD_MAC;

    if ((retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table)) != RT_ERR_OK)
        return retVal;

    pPortmask->bits[0] = l2Table.mbr;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_mcastAddr_next_get
 * Description:
 *      Get Next L2 Multicast entry.
 * Input:
 *      pAddress        - The Address ID
 * Output:
 *      pMac            - Multicast MAC address
 *      pIvl            - IVL/SVL setting, 1:IVL, 0:SVL
 *      pCvid_fid       - CVID or FID
 *      pPortmask       - Member Port Mask
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_L2_ENTRY_NOTFOUND    - No such LUT entry.
 *      RT_ERR_INPUT                - Invalid input parameters.
 * Note:
 *      Get the next L2 multicast entry after the current entry pointed by pAddress.
 *      The address of next entry is returned by pAddress. User can use (address + 1)
 *      as pAddress to call this API again for dumping all multicast entries is LUT.
 */
rtk_api_ret_t rtk_l2_mcastAddr_next_get(rtk_uint32 *pAddress, rtk_mac_t *pMac, rtk_data_t *pIvl, rtk_data_t *pCvid_fid, rtk_portmask_t *pPortmask)
{
    rtk_api_ret_t   retVal;
    rtl8367b_luttb  l2Table;

    /* Error Checking */
    if ((pAddress == NULL) || (pMac == NULL) || (pIvl == NULL) || (pCvid_fid == NULL) || (pPortmask == NULL))
        return RT_ERR_INPUT;

    if(*pAddress > RTK_MAX_LUT_ADDR_ID )
        return RT_ERR_L2_L2UNI_PARAM;

    memset(&l2Table, 0, sizeof(rtl8367b_luttb));
    l2Table.address = *pAddress;

    if ((retVal = rtl8367b_getAsicL2LookupTb(LUTREADMETHOD_NEXT_L2MC, &l2Table)) != RT_ERR_OK)
        return retVal;

    if(l2Table.address < *pAddress)
        return RT_ERR_L2_ENTRY_NOTFOUND;

    memcpy(pMac->octet, l2Table.mac.octet, ETHER_ADDR_LEN);
    *pIvl       = l2Table.ivl_svl;
    *pCvid_fid  = l2Table.cvid_fid;
    pPortmask->bits[0] = l2Table.mbr;

    *pAddress = l2Table.address;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_mcastAddr_del
 * Description:
 *      Delete LUT multicast entry.
 * Input:
 *      pMac        - 6 bytes multicast(I/G bit is 1) mac address to be written into LUT.
 *      ivl         - IVL/SVL setting, 1:IVL, 0:SVL
 *      cvid_fid    - Filtering database
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_MAC                  - Invalid MAC address.
 *      RT_ERR_L2_FID               - Invalid FID .
 *      RT_ERR_L2_VID               - Invalid VID .
 *      RT_ERR_L2_ENTRY_NOTFOUND    - No such LUT entry.
 *      RT_ERR_INPUT                - Invalid input parameters.
 * Note:
 *      If the mac has existed in the LUT, it will be deleted. Otherwise, it will return RT_ERR_L2_ENTRY_NOTFOUND.
 */
rtk_api_ret_t rtk_l2_mcastAddr_del(rtk_mac_t *pMac, rtk_data_t ivl, rtk_data_t cvid_fid)
{
    rtk_api_ret_t retVal;
    rtk_uint32 method;
    rtl8367b_luttb l2Table;

    /* must be unicast address */
    if ((pMac == NULL) || !(pMac->octet[0] & 0x1))
        return RT_ERR_MAC;

    if(ivl == 1)
    {
        if (cvid_fid > RTL8367B_VIDMAX)
            return RT_ERR_L2_VID;
    }
    else if(ivl == 0)
    {
        if (cvid_fid > RTL8367B_FIDMAX)
            return RT_ERR_L2_FID;
    }
    else
        return RT_ERR_INPUT;

    memset(&l2Table, 0, sizeof(rtl8367b_luttb));

    /* fill key (MAC,FID) to get L2 entry */
    memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
    l2Table.ivl_svl     = ivl;
    l2Table.cvid_fid    = cvid_fid;
    method = LUTREADMETHOD_MAC;
    retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table);
    if (RT_ERR_OK == retVal)
    {
        memcpy(l2Table.mac.octet, pMac->octet, ETHER_ADDR_LEN);
        l2Table.ivl_svl     = ivl;
        l2Table.cvid_fid    = cvid_fid;
        l2Table.mbr         = 0;
        l2Table.nosalearn   = 0;
        l2Table.sa_block    = 0;
        l2Table.l3lookup    = 0;
        retVal = rtl8367b_setAsicL2LookupTb(&l2Table);
        return retVal;
    }
    else
        return retVal;
}

/* Function Name:
 *      rtk_l2_ipMcastAddr_add
 * Description:
 *      Add Lut IP multicast entry
 * Input:
 *      dip - Destination IP Address.
 *      sip - Source IP Address.
 *      portmask - Destination port mask.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_PORT_ID          - Invalid port number.
 *      RT_ERR_L2_INDEXTBL_FULL - hashed index is full of entries.
 *      RT_ERR_PORT_MASK        - Invalid portmask.
 *      RT_ERR_INPUT            - Invalid input parameters.
 * Note:
 *      System supports L2 entry with IP multicast DIP/SIP to forward IP multicasting frame as user
 *      desired. If this function is enabled, then system will be looked up L2 IP multicast entry to
 *      forward IP multicast frame directly without flooding.
 */
rtk_api_ret_t rtk_l2_ipMcastAddr_add(ipaddr_t sip, ipaddr_t dip, rtk_portmask_t portmask)
{
    rtk_api_ret_t retVal;
    rtk_uint32 method;
    rtl8367b_luttb l2Table;

    if (portmask.bits[0]> RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_ID;

    l2Table.sip = sip;
    l2Table.dip = dip;
    l2Table.l3lookup = 1;
    method = LUTREADMETHOD_MAC;
    retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table);
    if (RT_ERR_OK == retVal)
    {
        l2Table.sip = sip;
        l2Table.dip = dip;
        l2Table.mbr= portmask.bits[0];
        l2Table.nosalearn = 1;
        l2Table.l3lookup = 1;
        retVal = rtl8367b_setAsicL2LookupTb(&l2Table);
        return retVal;
    }
    else if (RT_ERR_L2_ENTRY_NOTFOUND == retVal)
    {
        memset(&l2Table, 0, sizeof(rtl8367b_luttb));
        l2Table.sip = sip;
        l2Table.dip = dip;
        l2Table.mbr= portmask.bits[0];
        l2Table.nosalearn = 1;
        l2Table.l3lookup = 1;
        if ((retVal = rtl8367b_setAsicL2LookupTb(&l2Table)) != RT_ERR_OK)
            return retVal;

        method = LUTREADMETHOD_MAC;
        retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table);
        if (RT_ERR_L2_ENTRY_NOTFOUND == retVal)
            return     RT_ERR_L2_INDEXTBL_FULL;
        else
            return retVal;

    }
    else
        return retVal;

}

/* Function Name:
 *      rtk_l2_ipMcastAddr_get
 * Description:
 *      Get LUT IP multicast entry.
 * Input:
 *      dip - Destination IP Address.
 *      sip - Source IP Address.
 * Output:
 *      pPortmask - Destination port mask.
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_L2_ENTRY_NOTFOUND    - No such LUT entry.
 *      RT_ERR_INPUT                - Invalid input parameters.
 * Note:
 *      The API can get Lut table of IP multicast entry.
 */
rtk_api_ret_t rtk_l2_ipMcastAddr_get(ipaddr_t sip, ipaddr_t dip, rtk_portmask_t *pPortmask)
{
    rtk_api_ret_t retVal;
    rtk_uint32 method;
    rtl8367b_luttb l2Table;

    l2Table.sip = sip;
    l2Table.dip = dip;
    l2Table.l3lookup = 1;
    method = LUTREADMETHOD_MAC;
    if ((retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table)) != RT_ERR_OK)
        return retVal;

     pPortmask->bits[0] = l2Table.mbr;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_ipMcastAddr_next_get
 * Description:
 *      Get Next IP Multicast entry.
 * Input:
 *      pAddress        - The Address ID
 * Output:
 *      pSip            - Source IP
 *      pDip            - Destination IP
 *      pPortmask       - Member Port Mask
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_L2_ENTRY_NOTFOUND    - No such LUT entry.
 *      RT_ERR_INPUT                - Invalid input parameters.
 * Note:
 *      Get the next IP multicast entry after the current entry pointed by pAddress.
 *      The address of next entry is returned by pAddress. User can use (address + 1)
 *      as pAddress to call this API again for dumping all IP multicast entries is LUT.
 */
rtk_api_ret_t rtk_l2_ipMcastAddr_next_get(rtk_uint32 *pAddress, ipaddr_t *pSip, ipaddr_t *pDip, rtk_portmask_t *pPortmask)
{
    rtk_api_ret_t   retVal;
    rtl8367b_luttb  l2Table;

    /* Error Checking */
    if ((pAddress == NULL) || (pSip == NULL) || (pDip == NULL) || (pPortmask == NULL))
        return RT_ERR_INPUT;

    if(*pAddress > RTK_MAX_LUT_ADDR_ID )
        return RT_ERR_L2_L2UNI_PARAM;

    memset(&l2Table, 0, sizeof(rtl8367b_luttb));
    l2Table.address = *pAddress;

    if ((retVal = rtl8367b_getAsicL2LookupTb(LUTREADMETHOD_NEXT_L3MC, &l2Table)) != RT_ERR_OK)
        return retVal;

    if(l2Table.address < *pAddress)
        return RT_ERR_L2_ENTRY_NOTFOUND;

    *pSip = l2Table.sip;
    *pDip = l2Table.dip;
    pPortmask->bits[0] = l2Table.mbr;

    *pAddress = l2Table.address;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_ipMcastAddr_del
 * Description:
 *      Delete a ip multicast address entry from the specified device.
 * Input:
 *      pMac    - 6 bytes multicast(I/G bit is 1) mac address to be written into LUT.
 *      fid     - Filtering database
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_L2_ENTRY_NOTFOUND    - No such LUT entry.
 *      RT_ERR_INPUT                - Invalid input parameters.
 * Note:
 *      The API can delete a IP multicast address entry from the specified device.
 */
rtk_api_ret_t rtk_l2_ipMcastAddr_del(ipaddr_t sip, ipaddr_t dip)
{
    rtk_api_ret_t retVal;
    rtk_uint32 method;
    rtl8367b_luttb l2Table;

    l2Table.sip = sip;
    l2Table.dip = dip;
    l2Table.l3lookup = 1;
    method = LUTREADMETHOD_MAC;
    retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table);
    if (RT_ERR_OK == retVal)
    {
        l2Table.sip = sip;
        l2Table.dip = dip;
        l2Table.mbr= 0;
        l2Table.nosalearn = 0;
        l2Table.l3lookup = 1;
        retVal = rtl8367b_setAsicL2LookupTb(&l2Table);
        return retVal;
    }
    else
        return retVal;
}

/* Function Name:
 *      rtk_l2_flushType_set
 * Description:
 *      Flush L2 mac address by type in the specified device.
 * Input:
 *      type - flush type
 *      vid - VLAN id
 *      portOrTid - port id or trunk id
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_VLAN_VID     - Invalid VID parameter.
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      This function trigger flushing of per-port L2 learning.
 *      When flushing operaton completes, the corresponding bit will be clear.
 *      The flush type as following:
 *      - FLUSH_TYPE_BY_PORT        (physical port)
 *      - FLUSH_TYPE_BY_PORT_VID    (physical port + VID)
 */
rtk_api_ret_t rtk_l2_flushType_set(rtk_l2_flushType_t type, rtk_vlan_t vid, rtk_l2_flushItem_t portOrTid)
{
    rtk_api_ret_t retVal;

    if (type>=FLUSH_TYPE_END)
        return RT_ERR_INPUT;

    if (portOrTid > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    switch (type)
    {
        case FLUSH_TYPE_BY_PORT:
            if ((retVal = rtl8367b_setAsicLutFlushMode(FLUSHMDOE_PORT)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicLutForceFlush(1<<portOrTid)) != RT_ERR_OK)
                return retVal;

            break;
        case FLUSH_TYPE_BY_PORT_VID:
            if ((retVal = rtl8367b_setAsicLutFlushMode(FLUSHMDOE_VID)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicLutFlushVid(vid)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicLutForceFlush(1<<portOrTid)) != RT_ERR_OK)
                return retVal;

            break;
        default:
            break;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_ucastAddr_flush
 * Description:
 *      Flush L2 mac address by type in the specified device (both dynamic and static).
 * Input:
 *      pConfig - flush configuration
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_VLAN_VID     - Invalid VID parameter.
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      flushByVid          - 1: Flush by VID, 0: Don't flush by VID
 *      vid                 - VID (0 ~ 4095)
 *      flushByPort         - 1: Flush by Port, 0: Don't flush by Port
 *      reserved            - Unused
 *      port                - Port ID
 *      flushByMac          - Not Supported
 *      ucastAddr           - Not Supported
 *      flushStaticAddr     - 1: Flush both Static and Dynamic entries, 0: Flush only Dynamic entries
 *      flushAddrOnAllPorts - 1: Flush VID-matched entries at all ports, 0: Flush VID-matched entries per port.
 */
rtk_api_ret_t rtk_l2_ucastAddr_flush(rtk_l2_flushCfg_t *pConfig)
{
    rtk_api_ret_t   retVal;

    if(pConfig == NULL)
        return RT_ERR_NULL_POINTER;

    if(pConfig->flushByVid >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if(pConfig->flushByPort >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if(pConfig->flushByMac >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if(pConfig->flushStaticAddr >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if(pConfig->flushAddrOnAllPorts >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if(pConfig->vid >= RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    if(pConfig->port >= RTL8367B_PORTIDMAX)
        return RT_ERR_PORT_ID;

    if(pConfig->flushByVid == ENABLED)
    {
        if ((retVal = rtl8367b_setAsicLutFlushMode(FLUSHMDOE_VID)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicLutFlushVid(pConfig->vid)) != RT_ERR_OK)
                return retVal;

        if ((retVal = rtl8367b_setAsicLutFlushType((pConfig->flushStaticAddr == ENABLED) ? FLUSHTYPE_BOTH : FLUSHTYPE_DYNAMIC)) != RT_ERR_OK)
            return retVal;

        if(pConfig->flushAddrOnAllPorts == ENABLED)
        {
            if ((retVal = rtl8367b_setAsicLutForceFlush(RTL8367B_PORTMASK)) != RT_ERR_OK)
                return retVal;
        }
        else if(pConfig->flushByPort == ENABLED)
        {
            if ((retVal = rtl8367b_setAsicLutForceFlush(1<<pConfig->port)) != RT_ERR_OK)
                return retVal;
        }
        else
            return RT_ERR_INPUT;
    }
    else if(pConfig->flushByPort == ENABLED)
    {
        if ((retVal = rtl8367b_setAsicLutFlushType((pConfig->flushStaticAddr == ENABLED) ? FLUSHTYPE_BOTH : FLUSHTYPE_DYNAMIC)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicLutFlushMode(FLUSHMDOE_PORT)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicLutForceFlush(1<<pConfig->port)) != RT_ERR_OK)
            return retVal;
    }
    else if(pConfig->flushByMac == ENABLED)
    {
        /* Should use API "rtk_l2_addr_del" to remove a specified entry*/
        return RT_ERR_CHIP_NOT_SUPPORTED;
    }
    else
        return RT_ERR_INPUT;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_flushLinkDownPortAddrEnable_set
 * Description:
 *      Set HW flush linkdown port mac configuration of the specified device.
 * Input:
 *      port - Port id.
 *      enable - link down flush status
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_ENABLE       - Invalid enable input.
 * Note:
 *      The status of flush linkdown port address is as following:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_l2_flushLinkDownPortAddrEnable_set(rtk_port_t port, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    if (port != RTK_WHOLE_SYSTEM)
        return RT_ERR_PORT_ID;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsicLutLinkDownForceAging(enable)) != RT_ERR_OK)
        return retVal;


    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_flushLinkDownPortAddrEnable_get
 * Description:
 *      Get HW flush linkdown port mac configuration of the specified device.
 * Input:
 *      port - Port id.
 * Output:
 *      pEnable - link down flush status
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The status of flush linkdown port address is as following:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_l2_flushLinkDownPortAddrEnable_get(rtk_port_t port, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if (port != RTK_WHOLE_SYSTEM)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicLutLinkDownForceAging(pEnable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_agingEnable_set
 * Description:
 *      Set L2 LUT aging status per port setting.
 * Input:
 *      port    - Port id.
 *      enable  - Aging status
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_ENABLE       - Invalid enable input.
 * Note:
 *      This API can be used to set L2 LUT aging status per port.
 */
rtk_api_ret_t rtk_l2_agingEnable_set(rtk_port_t port, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if(enable == 1)
        enable = 0;
    else
        enable = 1;

    if ((retVal = rtl8367b_setAsicLutDisableAging(port,enable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_agingEnable_get
 * Description:
 *      Get L2 LUT aging status per port setting.
 * Input:
 *      port - Port id.
 * Output:
 *      pEnable - Aging status
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      This API can be used to get L2 LUT aging function per port.
 */
rtk_api_ret_t rtk_l2_agingEnable_get(rtk_port_t port, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicLutDisableAging(port, pEnable)) != RT_ERR_OK)
        return retVal;

    if(*pEnable == 1)
        *pEnable = 0;
    else
        *pEnable = 1;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_limitLearningCnt_set
 * Description:
 *      Set per-Port auto learning limit number
 * Input:
 *      port    - Port id.
 *      mac_cnt - Auto learning entries limit number
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_PORT_ID              - Invalid port number.
 *      RT_ERR_LIMITED_L2ENTRY_NUM  - Invalid auto learning limit number
 * Note:
 *      The API can set per-port ASIC auto learning limit number from 0(disable learning)
 *      to 8k.
 */
rtk_api_ret_t rtk_l2_limitLearningCnt_set(rtk_port_t port, rtk_mac_cnt_t mac_cnt)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (mac_cnt > RTK_MAX_NUM_OF_LEARN_LIMIT)
        return RT_ERR_LIMITED_L2ENTRY_NUM;

    if ((retVal = rtl8367b_setAsicLutLearnLimitNo(port, mac_cnt)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_limitLearningCnt_get
 * Description:
 *      Get per-Port auto learning limit number
 * Input:
 *      port - Port id.
 * Output:
 *      pMac_cnt - Auto learning entries limit number
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The API can get per-port ASIC auto learning limit number.
 */
rtk_api_ret_t rtk_l2_limitLearningCnt_get(rtk_port_t port, rtk_mac_cnt_t *pMac_cnt)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicLutLearnLimitNo(port, pMac_cnt)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_limitLearningCntAction_set
 * Description:
 *      Configure auto learn over limit number action.
 * Input:
 *      port - Port id.
 *      action - Auto learning entries limit number
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_NOT_ALLOWED  - Invalid learn over action
 * Note:
 *      The API can set SA unknown packet action while auto learn limit number is over
 *      The action symbol as following:
 *      - LIMIT_LEARN_CNT_ACTION_DROP,
 *      - LIMIT_LEARN_CNT_ACTION_FORWARD,
 *      - LIMIT_LEARN_CNT_ACTION_TO_CPU,
 */
rtk_api_ret_t rtk_l2_limitLearningCntAction_set(rtk_port_t port, rtk_l2_limitLearnCntAction_t action)
{
    rtk_api_ret_t retVal;
    rtk_uint32 data;

    if (port != RTK_WHOLE_SYSTEM)
        return RT_ERR_PORT_ID;

    if ( LIMIT_LEARN_CNT_ACTION_DROP == action )
        data = 1;
    else if ( LIMIT_LEARN_CNT_ACTION_FORWARD == action )
        data = 0;
    else if ( LIMIT_LEARN_CNT_ACTION_TO_CPU == action )
        data = 2;
    else
        return RT_ERR_NOT_ALLOWED;

    if ((retVal = rtl8367b_setAsicLutLearnOverAct(data)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_limitLearningCntAction_get
 * Description:
 *      Get auto learn over limit number action.
 * Input:
 *      port - Port id.
 * Output:
 *      pAction - Learn over action
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The API can get SA unknown packet action while auto learn limit number is over
 *      The action symbol as following:
 *      - LIMIT_LEARN_CNT_ACTION_DROP,
 *      - LIMIT_LEARN_CNT_ACTION_FORWARD,
 *      - LIMIT_LEARN_CNT_ACTION_TO_CPU,
 */
rtk_api_ret_t rtk_l2_limitLearningCntAction_get(rtk_port_t port, rtk_l2_limitLearnCntAction_t *pAction)
{
    rtk_api_ret_t retVal;
    rtk_uint32 action;

    if (port != RTK_WHOLE_SYSTEM)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicLutLearnOverAct(&action)) != RT_ERR_OK)
        return retVal;

    if ( 1 == action )
        *pAction = LIMIT_LEARN_CNT_ACTION_DROP;
    else if ( 0 == action )
        *pAction = LIMIT_LEARN_CNT_ACTION_FORWARD;
    else if ( 2 == action )
        *pAction = LIMIT_LEARN_CNT_ACTION_TO_CPU;
    else
    *pAction = action;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_learningCnt_get
 * Description:
 *      Get per-Port current auto learning number
 * Input:
 *      port - Port id.
 * Output:
 *      pMac_cnt - ASIC auto learning entries number
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The API can get per-port ASIC auto learning number
 */
rtk_api_ret_t rtk_l2_learningCnt_get(rtk_port_t port, rtk_mac_cnt_t *pMac_cnt)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicLutLearnNo(port, pMac_cnt)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_floodPortMask_set
 * Description:
 *      Set flooding portmask
 * Input:
 *      type - flooding type.
 *      flood_portmask - flooding porkmask
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_MASK    - Invalid portmask.
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      This API can set the flooding mask.
 *      The flooding type is as following:
 *      - FLOOD_UNKNOWNDA
 *      - FLOOD_UNKNOWNMC
 *      - FLOOD_BC
 */
rtk_api_ret_t rtk_l2_floodPortMask_set(rtk_l2_flood_type_t floood_type, rtk_portmask_t flood_portmask)
{
    rtk_api_ret_t retVal;

    if (floood_type >= FLOOD_END)
        return RT_ERR_INPUT;

    if (flood_portmask.bits[0] > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    switch (floood_type)
    {
        case FLOOD_UNKNOWNDA:
            if ((retVal = rtl8367b_setAsicPortUnknownDaFloodingPortmask(flood_portmask.bits[0])) != RT_ERR_OK)
                return retVal;
            break;
        case FLOOD_UNKNOWNMC:
            if ((retVal = rtl8367b_setAsicPortUnknownMulticastFloodingPortmask(flood_portmask.bits[0])) != RT_ERR_OK)
                return retVal;
            break;
        case FLOOD_BC:
            if ((retVal = rtl8367b_setAsicPortBcastFloodingPortmask(flood_portmask.bits[0])) != RT_ERR_OK)
                return retVal;
            break;
        default:
            break;
    }

    return RT_ERR_OK;
}
/* Function Name:
 *      rtk_l2_floodPortMask_get
 * Description:
 *      Get flooding portmask
 * Input:
 *      type - flooding type.
 * Output:
 *      pFlood_portmask - flooding porkmask
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      This API can get the flooding mask.
 *      The flooding type is as following:
 *      - FLOOD_UNKNOWNDA
 *      - FLOOD_UNKNOWNMC
 *      - FLOOD_BC
 */
rtk_api_ret_t rtk_l2_floodPortMask_get(rtk_l2_flood_type_t floood_type, rtk_portmask_t *pFlood_portmask)
{
    rtk_api_ret_t retVal;

    if (floood_type >= FLOOD_END)
        return RT_ERR_INPUT;

    switch (floood_type)
    {
        case FLOOD_UNKNOWNDA:
            if ((retVal = rtl8367b_getAsicPortUnknownDaFloodingPortmask(&pFlood_portmask->bits[0])) != RT_ERR_OK)
                return retVal;
            break;
        case FLOOD_UNKNOWNMC:
            if ((retVal = rtl8367b_getAsicPortUnknownMulticastFloodingPortmask(&pFlood_portmask->bits[0])) != RT_ERR_OK)
                return retVal;
            break;
        case FLOOD_BC:
            if ((retVal = rtl8367b_getAsicPortBcastFloodingPortmask(&pFlood_portmask->bits[0])) != RT_ERR_OK)
                return retVal;
            break;
        default:
            break;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_localPktPermit_set
 * Description:
 *      Set permittion of frames if source port and destination port are the same.
 * Input:
 *      port - Port id.
 *      permit - permittion status
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_ENABLE       - Invalid permit value.
 * Note:
 *      This API is setted to permit frame if its source port is equal to destination port.
 */
rtk_api_ret_t rtk_l2_localPktPermit_set(rtk_port_t port, rtk_enable_t permit)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (permit >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsicPortBlockSpa(port, permit)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_localPktPermit_get
 * Description:
 *      Get permittion of frames if source port and destination port are the same.
 * Input:
 *      port - Port id.
 * Output:
 *      pPermit - permittion status
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      This API is to get permittion status for frames if its source port is equal to destination port.
 */
rtk_api_ret_t rtk_l2_localPktPermit_get(rtk_port_t port, rtk_enable_t *pPermit)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortBlockSpa(port, pPermit)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_aging_set
 * Description:
 *      Set LUT agging out speed
 * Input:
 *      aging_time - Agging out time.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_OUT_OF_RANGE     - input out of range.
 * Note:
 *      The API can set LUT agging out period for each entry and the range is from 45s to 458s.
 */
rtk_api_ret_t rtk_l2_aging_set(rtk_l2_age_time_t aging_time)
{
    rtk_uint32 i;
    CONST_T rtk_uint32 agePara[10][3] = {
        {45, 0, 1}, {88, 0, 2}, {133, 0, 3}, {177, 0, 4}, {221, 0, 5}, {266, 0, 6}, {310, 0, 7},
        {354, 2, 6}, {413, 2, 7}, {458, 3, 7}};

    if (aging_time>agePara[9][0])
        return RT_ERR_OUT_OF_RANGE;

    for (i = 0; i<10; i++)
    {
        if (aging_time<=agePara[i][0])
        {
            return rtl8367b_setAsicLutAgeTimerSpeed(agePara[i][2], agePara[i][1]);
        }
    }

    return RT_ERR_FAILED;
}

/* Function Name:
 *      rtk_l2_aging_get
 * Description:
 *      Get LUT agging out time
 * Input:
 *      None
 * Output:
 *      pEnable - Aging status
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The API can get LUT agging out period for each entry.
 */
rtk_api_ret_t rtk_l2_aging_get(rtk_l2_age_time_t *pAging_time)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i,time, speed;
    CONST_T rtk_uint32 agePara[10][3] = {
        {45, 0, 1}, {88, 0, 2}, {133, 0, 3}, {177, 0, 4}, {221, 0, 5}, {266, 0, 6}, {310, 0, 7},
        {354, 2, 6}, {413, 2, 7}, {458, 3, 7}};

    if ((retVal = rtl8367b_getAsicLutAgeTimerSpeed(&time, &speed)) != RT_ERR_OK)
        return retVal;

    for (i = 0; i<10; i++)
    {
        if (time==agePara[i][2]&&speed==agePara[i][1])
        {
            *pAging_time = agePara[i][0];
            return RT_ERR_OK;
        }
    }

    return RT_ERR_FAILED;
}

/* Function Name:
 *      rtk_l2_ipMcastAddrLookup_set
 * Description:
 *      Set Lut IP multicast lookup function
 * Input:
 *      type - Lookup type for IPMC packet.
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK          - OK
 *      RT_ERR_FAILED      - Failed
 *      RT_ERR_SMI         - SMI access error
 * Note:
 *      This API can work with rtk_l2_ipMcastAddrLookupException_add.
 *      If users set the lookup type to DIP, the group in exception table
 *      will be lookup by DIP+SIP
 *      If users set the lookup type to DIP+SIP, the group in exception table
 *      will be lookup by only DIP
 */
rtk_api_ret_t rtk_l2_ipMcastAddrLookup_set(rtk_l2_lookup_type_t type)
{
    rtk_api_ret_t retVal;

    if(type == LOOKUP_MAC)
    {
        if((retVal = rtl8367b_setAsicLutIpMulticastLookup(DISABLE)) != RT_ERR_OK)
            return retVal;
    }
    else if(type == LOOKUP_SIP_DIP)
    {
        if((retVal = rtl8367b_setAsicLutIpMulticastLookup(ENABLE)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicLutIpLookupMethod(0))!=RT_ERR_OK)
            return retVal;
    }
    else if(type == LOOKUP_DIP)
    {
        if((retVal = rtl8367b_setAsicLutIpMulticastLookup(ENABLE)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicLutIpLookupMethod(1))!=RT_ERR_OK)
            return retVal;
    }
    else
        return RT_ERR_FAILED;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_ipMcastAddrLookup_get
 * Description:
 *      Get Lut IP multicast lookup function
 * Input:
 *      None.
 * Output:
 *      pType - Lookup type for IPMC packet.
 * Return:
 *      RT_ERR_OK          - OK
 *      RT_ERR_FAILED      - Failed
 *      RT_ERR_SMI         - SMI access error
 * Note:
 *      None.
 */
rtk_api_ret_t rtk_l2_ipMcastAddrLookup_get(rtk_l2_lookup_type_t *pType)
{
    rtk_api_ret_t       retVal;
    rtk_uint32          enabled, dip_lookup;

    if((retVal = rtl8367b_getAsicLutIpMulticastLookup(&enabled)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicLutIpLookupMethod(&dip_lookup))!=RT_ERR_OK)
        return retVal;

    if(enabled == ENABLE)
    {
        if(dip_lookup == ENABLE)
            *pType = LOOKUP_DIP;
        else
            *pType = LOOKUP_SIP_DIP;
    }
    else
        *pType = LOOKUP_MAC;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_ipMcastAddrLookupException_add
 * Description:
 *      Add an IP Multicast Exception group
 * Input:
 *      ip_addr     - IP address
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK          - OK
 *      RT_ERR_FAILED      - Failed
 *      RT_ERR_SMI         - SMI access error
 *      RT_ERR_TBL_FULL    - Table Full
 * Note:
 *      Add an entry to IP Multicast exception table.
 */
rtk_api_ret_t rtk_l2_ipMcastAddrLookupException_add(ipaddr_t ip_addr)
{
    rtk_uint32      empty_idx = 0xFFFF;
    rtk_int32       index;
    ipaddr_t        group_addr;
    rtk_api_ret_t   retVal;

    if( (ip_addr & 0xF0000000) != 0xE0000000)    /* not in 224.0.0.0 ~ 239.255.255.255 */
        return RT_ERR_INPUT;

    for(index = RTL8367B_LUT_IPMCGRP_TABLE_MAX; index >= 0; index--)
    {
        if ((retVal = rtl8367b_getAsicLutIPMCGroup((rtk_uint32)index, &group_addr))!=RT_ERR_OK)
            return retVal;

        if(group_addr == ip_addr)
            return RT_ERR_OK;

        if(group_addr == 0xE0000000) /* Unused */
            empty_idx = (rtk_uint32)index;
    }

    if(empty_idx == 0xFFFF)
        return RT_ERR_TBL_FULL;

    if ((retVal = rtl8367b_setAsicLutIPMCGroup(empty_idx, ip_addr))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_l2_ipMcastAddrLookupException_del
 * Description:
 *      Delete an IP Multicast Exception group
 * Input:
 *      ip_addr     - IP address
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK          - OK
 *      RT_ERR_FAILED      - Failed
 *      RT_ERR_SMI         - SMI access error
 *      RT_ERR_TBL_FULL    - Table Full
 * Note:
 *      Delete an entry to IP Multicast exception table.
 */
rtk_api_ret_t rtk_l2_ipMcastAddrLookupException_del(ipaddr_t ip_addr)
{
    rtk_uint32      index;
    ipaddr_t        group_addr;
    rtk_api_ret_t   retVal;

    if( (ip_addr & 0xF0000000) != 0xE0000000)    /* not in 224.0.0.0 ~ 239.255.255.255 */
        return RT_ERR_INPUT;

    for(index = 0; index <= RTL8367B_LUT_IPMCGRP_TABLE_MAX; index++)
    {
        if ((retVal = rtl8367b_getAsicLutIPMCGroup(index, &group_addr))!=RT_ERR_OK)
            return retVal;

        if(group_addr == ip_addr)
        {
            if ((retVal = rtl8367b_setAsicLutIPMCGroup(index, 0xE0000000))!=RT_ERR_OK)
                return retVal;

            return RT_ERR_OK;
        }
    }

    return RT_ERR_FAILED;
}

/* Function Name:
 *      rtk_l2_entry_get
 * Description:
 *      Get LUT unicast entry.
 * Input:
 *      pL2_entry - Index field in the structure.
 * Output:
 *      pL2_entry - other fields such as MAC, port, age...
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_L2_EMPTY_ENTRY   - Empty LUT entry.
 *      RT_ERR_INPUT            - Invalid input parameters.
 * Note:
 *      This API is used to get address by index from 1~2112.
 */
rtk_api_ret_t rtk_l2_entry_get(rtk_l2_addr_table_t *pL2_entry)
{
    rtk_api_ret_t retVal;
    rtk_uint32 method;
    rtl8367b_luttb l2Table;

    if ((pL2_entry->index>RTK_MAX_NUM_OF_LEARN_LIMIT)||(pL2_entry->index<1))
        return RT_ERR_INPUT;

    l2Table.address= pL2_entry->index-1;
    method = LUTREADMETHOD_ADDRESS;
    if ((retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table)) != RT_ERR_OK)
        return retVal;

    if ((pL2_entry->index>0x800)&&(l2Table.lookup_hit==0))
         return RT_ERR_L2_EMPTY_ENTRY;

    if(l2Table.l3lookup)
    {
        memset(&pL2_entry->mac, 0, sizeof(rtk_mac_t));
        pL2_entry->is_ipmul  = l2Table.l3lookup;
        pL2_entry->sip       = l2Table.sip;
        pL2_entry->dip       = l2Table.dip;
        pL2_entry->is_static = l2Table.nosalearn;
        pL2_entry->portmask  = l2Table.mbr;
        pL2_entry->fid       = 0;
        pL2_entry->age       = 0;
        pL2_entry->auth      = 0;
        pL2_entry->sa_block  = 0;
    }
    else if(l2Table.mac.octet[0]&0x01)
    {
        memset(&pL2_entry->sip, 0, sizeof(ipaddr_t));
        memset(&pL2_entry->dip, 0, sizeof(ipaddr_t));
        pL2_entry->mac.octet[0] = l2Table.mac.octet[0];
        pL2_entry->mac.octet[1] = l2Table.mac.octet[1];
        pL2_entry->mac.octet[2] = l2Table.mac.octet[2];
        pL2_entry->mac.octet[3] = l2Table.mac.octet[3];
        pL2_entry->mac.octet[4] = l2Table.mac.octet[4];
        pL2_entry->mac.octet[5] = l2Table.mac.octet[5];
        pL2_entry->is_ipmul  = l2Table.l3lookup;
        pL2_entry->is_static = l2Table.nosalearn;
        pL2_entry->portmask  = l2Table.mbr;
        pL2_entry->ivl       = l2Table.ivl_svl;
        if(l2Table.ivl_svl == 1) /* IVL */
        {
            pL2_entry->cvid      = l2Table.cvid_fid;
            pL2_entry->fid       = 0;
        }
        else /* SVL*/
        {
            pL2_entry->cvid      = 0;
            pL2_entry->fid       = l2Table.cvid_fid;
        }
        pL2_entry->auth      = l2Table.auth;
        pL2_entry->sa_block  = l2Table.sa_block;
        pL2_entry->age       = 0;
    }
    else if((l2Table.age != 0)||(l2Table.nosalearn == 1))
    {
        memset(&pL2_entry->sip, 0, sizeof(ipaddr_t));
        memset(&pL2_entry->dip, 0, sizeof(ipaddr_t));
        pL2_entry->mac.octet[0] = l2Table.mac.octet[0];
        pL2_entry->mac.octet[1] = l2Table.mac.octet[1];
        pL2_entry->mac.octet[2] = l2Table.mac.octet[2];
        pL2_entry->mac.octet[3] = l2Table.mac.octet[3];
        pL2_entry->mac.octet[4] = l2Table.mac.octet[4];
        pL2_entry->mac.octet[5] = l2Table.mac.octet[5];
        pL2_entry->is_ipmul  = l2Table.l3lookup;
        pL2_entry->is_static = l2Table.nosalearn;
        pL2_entry->portmask  = 1<<(l2Table.spa);
        pL2_entry->ivl       = l2Table.ivl_svl;
        pL2_entry->cvid      = l2Table.cvid_fid;
        pL2_entry->fid       = l2Table.fid;
        pL2_entry->auth      = l2Table.auth;
        pL2_entry->sa_block  = l2Table.sa_block;
        pL2_entry->age       = l2Table.age;
    }
    else
       return RT_ERR_L2_EMPTY_ENTRY;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_init
 * Description:
 *      Initialize SVLAN Configuration
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      Ether type of S-tag in 802.1ad is 0x88a8 and there are existed ether type 0x9100 and 0x9200 for Q-in-Q SLAN design.
 *      User can set mathced ether type as service provider supported protocol.
 */
rtk_api_ret_t rtk_svlan_init(void)
{
    rtk_uint32 i;
    rtk_api_ret_t retVal;
    rtl8367b_svlan_memconf_t svlanMemConf;
    rtl8367b_svlan_s2c_t svlanSP2CConf;
    rtl8367b_svlan_mc2s_t svlanMC2SConf;

    /*default use C-priority*/
    if ((retVal = rtl8367b_setAsicSvlanPrioritySel(SPRISEL_CTAGPRI)) != RT_ERR_OK)
        return retVal;

    /*Drop SVLAN untag frame*/
    if ((retVal = rtl8367b_setAsicSvlanIngressUntag(DISABLED)) != RT_ERR_OK)
        return retVal;

    /*Drop SVLAN unmatch frame*/
    if ((retVal = rtl8367b_setAsicSvlanIngressUnmatch(DISABLED)) != RT_ERR_OK)
        return retVal;

    /*Set TPID to 0x88a8*/
    if ((retVal = rtl8367b_setAsicSvlanTpid(0x88a8)) != RT_ERR_OK)
        return retVal;

    /*Clean Uplink Port Mask to none*/
    if ((retVal = rtl8367b_setAsicSvlanUplinkPortMask(0)) != RT_ERR_OK)
        return retVal;

    /*Clean SVLAN Member Configuration*/
    for (i=0; i<= RTL8367B_SVIDXMAX; i++)
    {
        memset(&svlanMemConf, 0, sizeof(rtl8367b_svlan_memconf_t));
        if ((retVal = rtl8367b_setAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
            return retVal;
    }

    /*Clean C2S Configuration*/
    for (i=0; i<= RTL8367B_C2SIDXMAX; i++)
    {
        if ((retVal = rtl8367b_setAsicSvlanC2SConf(i, 0,0,0)) != RT_ERR_OK)
            return retVal;
    }

    /*Clean SP2C Configuration*/
    for (i=0; i <= RTL8367B_SP2CMAX ; i++)
    {
        memset(&svlanSP2CConf, 0, sizeof(rtl8367b_svlan_s2c_t));
        if ((retVal = rtl8367b_setAsicSvlanSP2CConf(i, &svlanSP2CConf)) != RT_ERR_OK)
            return retVal;
    }

    /*Clean MC2S Configuration*/
    for (i=0 ; i<= RTL8367B_MC2SIDXMAX; i++)
    {
        memset(&svlanMC2SConf, 0, sizeof(rtl8367b_svlan_mc2s_t));
        if ((retVal = rtl8367b_setAsicSvlanMC2SConf(i, &svlanMC2SConf)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_servicePort_add
 * Description:
 *      Add one service port in the specified device
 * Input:
 *      port - Port id.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      This API is setting which port is connected to provider switch. All frames receiving from this port must
 *      contain accept SVID in S-tag field.
 */
rtk_api_ret_t rtk_svlan_servicePort_add(rtk_port_t port)
{
    rtk_api_ret_t retVal;
    rtk_uint32 pmsk;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicSvlanUplinkPortMask(&pmsk)) != RT_ERR_OK)
        return retVal;

    pmsk = pmsk | (1<<port);

    if ((retVal = rtl8367b_setAsicSvlanUplinkPortMask(pmsk)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_servicePort_get
 * Description:
 *      Get service ports in the specified device.
 * Input:
 *      None
 * Output:
 *      pSvlan_portmask - pointer buffer of svlan ports.
 * Return:
 *      RT_ERR_OK          - OK
 *      RT_ERR_FAILED      - Failed
 *      RT_ERR_SMI         - SMI access error
 * Note:
 *      This API is setting which port is connected to provider switch. All frames receiving from this port must
 *      contain accept SVID in S-tag field.
 */
rtk_api_ret_t rtk_svlan_servicePort_get(rtk_portmask_t *pSvlan_portmask)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicSvlanUplinkPortMask(&pSvlan_portmask->bits[0])) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_servicePort_del
 * Description:
 *      Delete one service port in the specified device
 * Input:
 *      port - Port id.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      This API is removing SVLAN service port in the specified device.
 */
rtk_api_ret_t rtk_svlan_servicePort_del(rtk_port_t port)
{
    rtk_api_ret_t retVal;
    rtk_uint32 pmsk;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicSvlanUplinkPortMask(&pmsk)) != RT_ERR_OK)
        return retVal;

    pmsk = pmsk & ~(1<<port);

    if ((retVal = rtl8367b_setAsicSvlanUplinkPortMask(pmsk)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_tpidEntry_set
 * Description:
 *      Configure accepted S-VLAN ether type.
 * Input:
 *      svlan_tag_id - Ether type of S-tag frame parsing in uplink ports.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameter.
 * Note:
 *      Ether type of S-tag in 802.1ad is 0x88a8 and there are existed ether type 0x9100 and 0x9200 for Q-in-Q SLAN design.
 *      User can set mathced ether type as service provider supported protocol.
 */
rtk_api_ret_t rtk_svlan_tpidEntry_set(rtk_svlan_tpid_t svlan_tag_id)
{
    rtk_api_ret_t retVal;

    if (svlan_tag_id>RTK_MAX_NUM_OF_PROTO_TYPE)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicSvlanTpid(svlan_tag_id)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_tpidEntry_get
 * Description:
 *      Get accepted S-VLAN ether type setting.
 * Input:
 *      None
 * Output:
 *      pSvlan_tag_id -  Ether type of S-tag frame parsing in uplink ports.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      This API is setting which port is connected to provider switch. All frames receiving from this port must
 *      contain accept SVID in S-tag field.
 */
rtk_api_ret_t rtk_svlan_tpidEntry_get(rtk_svlan_tpid_t *pSvlan_tag_id)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicSvlanTpid(pSvlan_tag_id)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_priorityRef_set
 * Description:
 *      Set S-VLAN upstream priority reference setting.
 * Input:
 *      ref - reference selection parameter.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameter.
 * Note:
 *      The API can set the upstream SVLAN tag priority reference source. The related priority
 *      sources are as following:
 *      - REF_INTERNAL_PRI,
 *      - REF_CTAG_PRI,
 *      - REF_SVLAN_PRI.
 */
rtk_api_ret_t rtk_svlan_priorityRef_set(rtk_svlan_pri_ref_t ref)
{
    rtk_api_ret_t retVal;

    if (ref>REF_PRI_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicSvlanPrioritySel(ref)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_priorityRef_get
 * Description:
 *      Get S-VLAN upstream priority reference setting.
 * Input:
 *      None
 * Output:
 *      pRef - reference selection parameter.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      The API can get the upstream SVLAN tag priority reference source. The related priority
 *      sources are as following:
 *      - REF_INTERNAL_PRI,
 *      - REF_CTAG_PRI,
 *      - REF_SVLAN_PRI.
 */
rtk_api_ret_t rtk_svlan_priorityRef_get(rtk_svlan_pri_ref_t *pRef)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicSvlanPrioritySel(pRef)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_memberPortEntry_set
 * Description:
 *      Configure system SVLAN member content
 * Input:
 *      svid - SVLAN id
 *      psvlan_cfg - SVLAN member configuration
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_INPUT            - Invalid input parameter.
 *      RT_ERR_SVLAN_VID        - Invalid SVLAN VID parameter.
 *      RT_ERR_PORT_MASK        - Invalid portmask.
 *      RT_ERR_SVLAN_TABLE_FULL - SVLAN configuration is full.
 * Note:
 *      The API can set system 64 accepted s-tag frame format. Only 64 SVID S-tag frame will be accpeted
 *      to receiving from uplink ports. Other SVID S-tag frame or S-untagged frame will be droped by default setup.
 *      - rtk_svlan_memberCfg_t->svid is SVID of SVLAN member configuration.
 *      - rtk_svlan_memberCfg_t->memberport is member port mask of SVLAN member configuration.
 *      - rtk_svlan_memberCfg_t->fid is filtering database of SVLAN member configuration.
 *      - rtk_svlan_memberCfg_t->priority is priority of SVLAN member configuration.
 */
rtk_api_ret_t rtk_svlan_memberPortEntry_set(rtk_vlan_t svid, rtk_svlan_memberCfg_t *pSvlan_cfg)
{
    rtk_api_ret_t retVal;
    rtk_int32 i;
    rtk_uint32 empty_idx;
    rtl8367b_svlan_memconf_t svlanMemConf;

    if ((svid > RTL8367B_VIDMAX) || (svid != pSvlan_cfg->svid))
        return RT_ERR_SVLAN_VID;

    if (pSvlan_cfg->svid>RTL8367B_VIDMAX)
        return RT_ERR_SVLAN_VID;

    if (pSvlan_cfg->memberport > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    if (pSvlan_cfg->untagport > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    if (pSvlan_cfg->fiden > ENABLED)
        return RT_ERR_ENABLE;

    if (pSvlan_cfg->fid > RTL8367B_FIDMAX)
        return RT_ERR_L2_FID;

    if (pSvlan_cfg->priority > RTL8367B_PRIMAX)
        return RT_ERR_VLAN_PRIORITY;

    if (pSvlan_cfg->efiden > ENABLED)
        return RT_ERR_ENABLE;

    if (pSvlan_cfg->efid > RTL8367B_FIDMAX)
        return RT_ERR_L2_FID;

    empty_idx = 0xFF;

    for (i = 0; i<= RTL8367B_SVIDXMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
            return retVal;

        if (svid == svlanMemConf.vs_svid)
        {
            if(pSvlan_cfg->memberport == 0x00)
                svlanMemConf.vs_svid    = 0;
            else
                svlanMemConf.vs_svid    = pSvlan_cfg->svid;

            svlanMemConf.vs_member      = pSvlan_cfg->memberport;
            svlanMemConf.vs_untag       = pSvlan_cfg->untagport;
            svlanMemConf.vs_force_fid   = pSvlan_cfg->fiden;
            svlanMemConf.vs_fid_msti    = pSvlan_cfg->fid;
            svlanMemConf.vs_priority    = pSvlan_cfg->priority;
            svlanMemConf.vs_efiden      = pSvlan_cfg->efiden;
            svlanMemConf.vs_efid        = pSvlan_cfg->efid;

            if ((retVal = rtl8367b_setAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
                return retVal;

            return RT_ERR_OK;
        }
        else if (svlanMemConf.vs_svid==0 && svlanMemConf.vs_member==0)
        {
            if(i < empty_idx)
                empty_idx = i;
        }
    }

    if (empty_idx != 0xFF)
    {
        memset(&svlanMemConf, 0, sizeof(rtl8367b_svlan_memconf_t));
        svlanMemConf.vs_svid        = pSvlan_cfg->svid;
        svlanMemConf.vs_member      = pSvlan_cfg->memberport;
        svlanMemConf.vs_untag       = pSvlan_cfg->untagport;
        svlanMemConf.vs_force_fid   = pSvlan_cfg->fiden;
        svlanMemConf.vs_fid_msti    = pSvlan_cfg->fid;
        svlanMemConf.vs_priority    = pSvlan_cfg->priority;
        svlanMemConf.vs_efiden      = pSvlan_cfg->efiden;
        svlanMemConf.vs_efid        = pSvlan_cfg->efid;

        if ((retVal = rtl8367b_setAsicSvlanMemberConfiguration(empty_idx, &svlanMemConf)) != RT_ERR_OK)
        {
            return retVal;
        }

        return RT_ERR_OK;
    }

    return RT_ERR_SVLAN_TABLE_FULL;
}

/* Function Name:
 *      rtk_svlan_memberPortEntry_get
 * Description:
 *      Get SVLAN member Configure.
 * Input:
 *      svid - SVLAN id
 * Output:
 *      pSvlan_cfg - SVLAN member configuration
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_SVLAN_ENTRY_NOT_FOUND    - specified svlan entry not found.
 *      RT_ERR_INPUT                    - Invalid input parameters.
 * Note:
 *      The API can get system 64 accepted s-tag frame format. Only 64 SVID S-tag frame will be accpeted
 *      to receiving from uplink ports. Other SVID S-tag frame or S-untagged frame will be droped.
 */
rtk_api_ret_t rtk_svlan_memberPortEntry_get(rtk_vlan_t svid, rtk_svlan_memberCfg_t *pSvlan_cfg)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtl8367b_svlan_memconf_t svlanMemConf;

    if (svid > RTL8367B_VIDMAX)
        return RT_ERR_SVLAN_VID;


    for (i = 0; i<= RTL8367B_SVIDXMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
            return retVal;
        if (svid == svlanMemConf.vs_svid)
        {
            pSvlan_cfg->svid        = svlanMemConf.vs_svid;
            pSvlan_cfg->memberport  = svlanMemConf.vs_member;
            pSvlan_cfg->untagport   = svlanMemConf.vs_untag;
            pSvlan_cfg->fiden       = svlanMemConf.vs_force_fid;
            pSvlan_cfg->fid         = svlanMemConf.vs_fid_msti;
            pSvlan_cfg->priority    = svlanMemConf.vs_priority;
            pSvlan_cfg->efiden      = svlanMemConf.vs_efiden;
            pSvlan_cfg->efid        = svlanMemConf.vs_efid;

            return RT_ERR_OK;
        }
    }

    return RT_ERR_SVLAN_ENTRY_NOT_FOUND;

}

/* Function Name:
 *      rtk_svlan_memberPortEntry_adv_set
 * Description:
 *      Configure system SVLAN member by index
 * Input:
 *      idx         - Index (0 ~ 63)
 *      psvlan_cfg  - SVLAN member configuration
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_INPUT            - Invalid input parameter.
 *      RT_ERR_SVLAN_VID        - Invalid SVLAN VID parameter.
 *      RT_ERR_PORT_MASK        - Invalid portmask.
 *      RT_ERR_SVLAN_TABLE_FULL - SVLAN configuration is full.
 * Note:
 *      The API can set system 64 accepted s-tag frame format by index.
 *      - rtk_svlan_memberCfg_t->svid is SVID of SVLAN member configuration.
 *      - rtk_svlan_memberCfg_t->memberport is member port mask of SVLAN member configuration.
 *      - rtk_svlan_memberCfg_t->fid is filtering database of SVLAN member configuration.
 *      - rtk_svlan_memberCfg_t->priority is priority of SVLAN member configuration.
 */
rtk_api_ret_t rtk_svlan_memberPortEntry_adv_set(rtk_uint32 idx, rtk_svlan_memberCfg_t *pSvlan_cfg)
{
    rtk_api_ret_t retVal;
    rtl8367b_svlan_memconf_t svlanMemConf;

    if (idx > RTL8367B_SVIDXMAX)
        return RT_ERR_SVLAN_ENTRY_INDEX;

    if (pSvlan_cfg->svid>RTL8367B_VIDMAX)
        return RT_ERR_SVLAN_VID;

    if (pSvlan_cfg->memberport > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    if (pSvlan_cfg->untagport > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    if (pSvlan_cfg->fiden > ENABLED)
        return RT_ERR_ENABLE;

    if (pSvlan_cfg->fid > RTL8367B_FIDMAX)
        return RT_ERR_L2_FID;

    if (pSvlan_cfg->priority > RTL8367B_PRIMAX)
        return RT_ERR_VLAN_PRIORITY;

    if (pSvlan_cfg->efiden > ENABLED)
        return RT_ERR_ENABLE;

    if (pSvlan_cfg->efid > RTL8367B_FIDMAX)
        return RT_ERR_L2_FID;

    memset(&svlanMemConf, 0, sizeof(rtl8367b_svlan_memconf_t));
    svlanMemConf.vs_svid        = pSvlan_cfg->svid;
    svlanMemConf.vs_member      = pSvlan_cfg->memberport;
    svlanMemConf.vs_untag       = pSvlan_cfg->untagport;
    svlanMemConf.vs_force_fid   = pSvlan_cfg->fiden;
    svlanMemConf.vs_fid_msti    = pSvlan_cfg->fid;
    svlanMemConf.vs_priority    = pSvlan_cfg->priority;
    svlanMemConf.vs_efiden      = pSvlan_cfg->efiden;
    svlanMemConf.vs_efid        = pSvlan_cfg->efid;

    if ((retVal = rtl8367b_setAsicSvlanMemberConfiguration(idx, &svlanMemConf)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_memberPortEntry_adv_get
 * Description:
 *      Get SVLAN member Configure by index.
 * Input:
 *      idx         - Index (0 ~ 63)
 * Output:
 *      pSvlan_cfg  - SVLAN member configuration
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_SVLAN_ENTRY_NOT_FOUND    - specified svlan entry not found.
 *      RT_ERR_INPUT                    - Invalid input parameters.
 * Note:
 *      The API can get system 64 accepted s-tag frame format. Only 64 SVID S-tag frame will be accpeted
 *      to receiving from uplink ports. Other SVID S-tag frame or S-untagged frame will be droped.
 */
rtk_api_ret_t rtk_svlan_memberPortEntry_adv_get(rtk_uint32 idx, rtk_svlan_memberCfg_t *pSvlan_cfg)
{
    rtk_api_ret_t retVal;
    rtl8367b_svlan_memconf_t svlanMemConf;

    if (idx > RTL8367B_SVIDXMAX)
        return RT_ERR_SVLAN_ENTRY_INDEX;

    if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(idx, &svlanMemConf)) != RT_ERR_OK)
        return retVal;

    pSvlan_cfg->svid        = svlanMemConf.vs_svid;
    pSvlan_cfg->memberport  = svlanMemConf.vs_member;
    pSvlan_cfg->untagport   = svlanMemConf.vs_untag;
    pSvlan_cfg->fiden       = svlanMemConf.vs_force_fid;
    pSvlan_cfg->fid         = svlanMemConf.vs_fid_msti;
    pSvlan_cfg->priority    = svlanMemConf.vs_priority;
    pSvlan_cfg->efiden      = svlanMemConf.vs_efiden;
    pSvlan_cfg->efid        = svlanMemConf.vs_efid;

    return RT_ERR_OK;

}

/* Function Name:
 *      rtk_svlan_defaultSvlan_set
 * Description:
 *      Configure default egress SVLAN.
 * Input:
 *      port - Source port
 *      svid - SVLAN id
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_INPUT                    - Invalid input parameter.
 *      RT_ERR_SVLAN_VID                - Invalid SVLAN VID parameter.
 *      RT_ERR_SVLAN_ENTRY_NOT_FOUND    - specified svlan entry not found.
 * Note:
 *      The API can set port n S-tag format index while receiving frame from port n
 *      is transmit through uplink port with s-tag field
 */
rtk_api_ret_t rtk_svlan_defaultSvlan_set(rtk_port_t port, rtk_vlan_t svid)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtl8367b_svlan_memconf_t svlanMemConf;

    /* Port ID 0 ~ 7 */
    if(port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    /* svid must be 0~4095 */
    if (svid > RTL8367B_VIDMAX)
        return RT_ERR_SVLAN_VID;

    for (i = 0; i < RTL8367B_SVIDXNO; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
            return retVal;

        if (svid == svlanMemConf.vs_svid)
        {
            if ((retVal = rtl8367b_setAsicSvlanDefaultVlan(port, i)) != RT_ERR_OK)
                return retVal;

            return RT_ERR_OK;
        }
    }

    return RT_ERR_SVLAN_ENTRY_NOT_FOUND;
}

/* Function Name:
 *      rtk_svlan_defaultSvlan_get
 * Description:
 *      Get the configure default egress SVLAN.
 * Input:
 *      port - Source port
 * Output:
 *      pSvid - SVLAN VID
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      The API can get port n S-tag format index while receiving frame from port n
 *      is transmit through uplink port with s-tag field
 */
rtk_api_ret_t rtk_svlan_defaultSvlan_get(rtk_port_t port, rtk_vlan_t *pSvid)
{
    rtk_api_ret_t retVal;
    rtk_uint32 idx;
    rtl8367b_svlan_memconf_t svlanMemConf;

    /* Port ID 0 ~ 7 */
    if(port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicSvlanDefaultVlan(port, &idx)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(idx, &svlanMemConf)) != RT_ERR_OK)
        return retVal;

    *pSvid = svlanMemConf.vs_svid;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_c2s_add
 * Description:
 *      Configure SVLAN C2S table
 * Input:
 *      vid - VLAN ID
 *      src_port - Ingress Port
 *      svid - SVLAN VID
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port ID.
 *      RT_ERR_SVLAN_VID    - Invalid SVLAN VID parameter.
 *      RT_ERR_VLAN_VID     - Invalid VID parameter.
 *      RT_ERR_OUT_OF_RANGE - input out of range.
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      The API can set system C2S configuration. ASIC will check upstream's VID and assign related
 *      SVID to mathed packet. There are 128 SVLAN C2S configurations.
 */
rtk_api_ret_t rtk_svlan_c2s_add(rtk_vlan_t vid, rtk_port_t src_port, rtk_vlan_t svid)
{
    rtk_api_ret_t retVal, i;
    rtk_uint32 empty_idx;
    rtk_uint32 evid, pmsk, svidx, c2s_svidx;
    rtl8367b_svlan_memconf_t svlanMemConf;
    rtk_uint16 doneFlag;

    if (vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    if (svid > RTL8367B_VIDMAX)
        return RT_ERR_SVLAN_VID;

    if(src_port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    empty_idx = 0xFFFF;
    svidx = 0xFFFF;
    doneFlag = FALSE;

    for (i = 0; i<= RTL8367B_SVIDXMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
            return retVal;

        if (svid == svlanMemConf.vs_svid)
        {
            svidx = i;
            break;
        }
    }

    if (0xFFFF == svidx)
        return RT_ERR_SVLAN_VID;

    for (i=RTL8367B_C2SIDXMAX; i>=0; i--)
    {
        if ((retVal = rtl8367b_getAsicSvlanC2SConf(i, &evid, &pmsk, &c2s_svidx)) != RT_ERR_OK)
                return retVal;

        if (evid == vid)
        {
            /* Check Src_port */
            if(pmsk & (1 << src_port))
            {
                /* Check SVIDX */
                if(c2s_svidx == svidx)
                {
                    /* All the same, do nothing */

                }
                else
                {
                    /* New svidx, remove src_port and find a new slot to add a new enrty */
                    pmsk = pmsk & ~(1 << src_port);
                    if(pmsk == 0)
                        c2s_svidx = 0;

                    if ((retVal = rtl8367b_setAsicSvlanC2SConf(i, vid, pmsk, c2s_svidx)) != RT_ERR_OK)
                        return retVal;
                }
            }
            else
            {
                if(c2s_svidx == svidx && doneFlag == FALSE)
                {
                    pmsk = pmsk | (1 << src_port);
                    if ((retVal = rtl8367b_setAsicSvlanC2SConf(i, vid, pmsk, svidx)) != RT_ERR_OK)
                        return retVal;

                    doneFlag = TRUE;
                }
            }
        }
        else if (evid==0&&pmsk==0)
        {
            empty_idx = i;
        }
    }

    if (0xFFFF != empty_idx && doneFlag ==FALSE)
    {
       if ((retVal = rtl8367b_setAsicSvlanC2SConf(empty_idx, vid, (1<<src_port), svidx)) != RT_ERR_OK)
           return retVal;
       return RT_ERR_OK;
    }
    else if(doneFlag == TRUE)
    {
       return RT_ERR_OK;
    }

    return RT_ERR_OUT_OF_RANGE;
}
/* Function Name:
 *      rtk_svlan_c2s_del
 * Description:
 *      Delete one C2S entry
 * Input:
 *      vid - VLAN ID
 *      src_port - Ingress Port
 *      svid - SVLAN VID
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_VLAN_VID         - Invalid VID parameter.
 *      RT_ERR_PORT_ID          - Invalid port ID.
 *      RT_ERR_OUT_OF_RANGE     - input out of range.
 * Note:
 *      The API can delete system C2S configuration. There are 128 SVLAN C2S configurations.
 */
rtk_api_ret_t rtk_svlan_c2s_del(rtk_vlan_t vid, rtk_port_t src_port)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtk_uint32 evid, pmsk, svidx;
    if (vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    if(src_port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    for (i = 0; i <= RTL8367B_C2SIDXMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanC2SConf(i, &evid, &pmsk, &svidx)) != RT_ERR_OK)
            return retVal;

        if (evid == vid)
        {
            if(pmsk & (1 << src_port))
            {
                pmsk = pmsk & ~(1 << src_port);
                if(pmsk == 0)
                {
                    vid = 0;
                    svidx = 0;
                }

                if ((retVal = rtl8367b_setAsicSvlanC2SConf(i, vid, pmsk, svidx)) != RT_ERR_OK)
                    return retVal;

                return RT_ERR_OK;
            }
        }
    }

    return RT_ERR_OUT_OF_RANGE;
}

/* Function Name:
 *      rtk_svlan_c2s_get
 * Description:
 *      Get configure SVLAN C2S table
 * Input:
 *      vid - VLAN ID
 *      src_port - Ingress Port
 * Output:
 *      pSvid - SVLAN ID
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port ID.
 *      RT_ERR_OUT_OF_RANGE - input out of range.
 * Note:
 *     The API can get system C2S configuration. There are 128 SVLAN C2S configurations.
 */
rtk_api_ret_t rtk_svlan_c2s_get(rtk_vlan_t vid, rtk_port_t src_port, rtk_vlan_t *pSvid)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtk_uint32 evid, pmsk, svidx;
    rtl8367b_svlan_memconf_t svlanMemConf;

    if (vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    if(src_port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    for (i = 0; i <= RTL8367B_C2SIDXMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanC2SConf(i, &evid, &pmsk, &svidx)) != RT_ERR_OK)
            return retVal;

        if (evid == vid)
        {
            if(pmsk & (1 << src_port))
            {
                if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(svidx, &svlanMemConf)) != RT_ERR_OK)
                    return retVal;

                *pSvid = svlanMemConf.vs_svid;
                return RT_ERR_OK;
            }
        }
    }

    return RT_ERR_OUT_OF_RANGE;
}

/* Function Name:
 *      rtk_svlan_untag_action_set
 * Description:
 *      Configure Action of downstream UnStag packet
 * Input:
 *      action  - Action for UnStag
 *      svid    - The SVID assigned to UnStag packet
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_SVLAN_VID                - Invalid SVLAN VID parameter.
 *      RT_ERR_SVLAN_ENTRY_NOT_FOUND    - specified svlan entry not found.
 *      RT_ERR_OUT_OF_RANGE             - input out of range.
 *      RT_ERR_INPUT                    - Invalid input parameters.
 * Note:
 *      The API can configure action of downstream Un-Stag packet. A SVID assigned
 *      to the un-stag is also supported by this API. The parameter of svid is
 *      only referenced when the action is set to UNTAG_ASSIGN
 */
rtk_api_ret_t rtk_svlan_untag_action_set(rtk_svlan_untag_action_t action, rtk_vlan_t svid)
{
    rtk_api_ret_t   retVal;
    rtk_uint32      i;
    rtl8367b_svlan_memconf_t svlanMemConf;

    if (action >= UNTAG_END)
        return RT_ERR_OUT_OF_RANGE;

    if(action == UNTAG_ASSIGN)
    {
        if (svid > RTL8367B_VIDMAX)
            return RT_ERR_SVLAN_VID;
    }

    if ((retVal = rtl8367b_setAsicSvlanIngressUntag((rtk_uint32)action)) != RT_ERR_OK)
        return retVal;

    if(action == UNTAG_ASSIGN)
    {
        for (i = 0; i < RTL8367B_SVIDXNO; i++)
        {
            if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
                return retVal;

            if (svid == svlanMemConf.vs_svid)
            {
                if ((retVal = rtl8367b_setAsicSvlanUntagVlan(i)) != RT_ERR_OK)
                    return retVal;

                return RT_ERR_OK;
            }
        }

        return RT_ERR_SVLAN_ENTRY_NOT_FOUND;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_untag_action_get
 * Description:
 *      Get Action of downstream UnStag packet
 * Input:
 *      None
 * Output:
 *      pAction  - Action for UnStag
 *      pSvid    - The SVID assigned to UnStag packet
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_SVLAN_VID                - Invalid SVLAN VID parameter.
 *      RT_ERR_SVLAN_ENTRY_NOT_FOUND    - specified svlan entry not found.
 *      RT_ERR_OUT_OF_RANGE             - input out of range.
 *      RT_ERR_INPUT                    - Invalid input parameters.
 * Note:
 *      The API can Get action of downstream Un-Stag packet. A SVID assigned
 *      to the un-stag is also retrieved by this API. The parameter pSvid is
 *      only refernced when the action is UNTAG_ASSIGN
 */
rtk_api_ret_t rtk_svlan_untag_action_get(rtk_svlan_untag_action_t *pAction, rtk_vlan_t *pSvid)
{
    rtk_api_ret_t   retVal;
    rtk_uint32      svidx;
    rtl8367b_svlan_memconf_t svlanMemConf;

    if ((retVal = rtl8367b_getAsicSvlanIngressUntag(pAction)) != RT_ERR_OK)
        return retVal;

    if(*pAction == UNTAG_ASSIGN)
    {
        if ((retVal = rtl8367b_getAsicSvlanUntagVlan(&svidx)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(svidx, &svlanMemConf)) != RT_ERR_OK)
            return retVal;

        *pSvid = svlanMemConf.vs_svid;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_unmatch_action_set
 * Description:
 *      Configure Action of downstream Unmatch packet
 * Input:
 *      action  - Action for Unmatch
 *      svid    - The SVID assigned to Unmatch packet
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_SVLAN_VID                - Invalid SVLAN VID parameter.
 *      RT_ERR_SVLAN_ENTRY_NOT_FOUND    - specified svlan entry not found.
 *      RT_ERR_OUT_OF_RANGE             - input out of range.
 *      RT_ERR_INPUT                    - Invalid input parameters.
 * Note:
 *      The API can configure action of downstream Un-match packet. A SVID assigned
 *      to the un-match is also supported by this API. The parameter od svid is
 *      only refernced when the action is set to UNMATCH_ASSIGN
 */
rtk_api_ret_t rtk_svlan_unmatch_action_set(rtk_svlan_unmatch_action_t action, rtk_vlan_t svid)
{
    rtk_api_ret_t   retVal;
    rtk_uint32      i;
    rtl8367b_svlan_memconf_t svlanMemConf;

    if (action >= UNMATCH_END)
        return RT_ERR_OUT_OF_RANGE;

    if (action == UNMATCH_ASSIGN)
    {
        if (svid > RTL8367B_VIDMAX)
            return RT_ERR_SVLAN_VID;
    }

    if ((retVal = rtl8367b_setAsicSvlanIngressUnmatch((rtk_uint32)action)) != RT_ERR_OK)
        return retVal;

    if(action == UNMATCH_ASSIGN)
    {
        for (i = 0; i < RTL8367B_SVIDXNO; i++)
        {
            if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
                return retVal;

            if (svid == svlanMemConf.vs_svid)
            {
                if ((retVal = rtl8367b_setAsicSvlanUnmatchVlan(i)) != RT_ERR_OK)
                    return retVal;

                return RT_ERR_OK;
            }
        }

        return RT_ERR_SVLAN_ENTRY_NOT_FOUND;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_unmatch_action_get
 * Description:
 *      Get Action of downstream Unmatch packet
 * Input:
 *      None
 * Output:
 *      pAction  - Action for Unmatch
 *      pSvid    - The SVID assigned to Unmatch packet
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_SVLAN_VID                - Invalid SVLAN VID parameter.
 *      RT_ERR_SVLAN_ENTRY_NOT_FOUND    - specified svlan entry not found.
 *      RT_ERR_OUT_OF_RANGE             - input out of range.
 *      RT_ERR_INPUT                    - Invalid input parameters.
 * Note:
 *      The API can Get action of downstream Un-match packet. A SVID assigned
 *      to the un-match is also retrieved by this API. The parameter pSvid is
 *      only refernced when the action is UNMATCH_ASSIGN
 */
rtk_api_ret_t rtk_svlan_unmatch_action_get(rtk_svlan_unmatch_action_t *pAction, rtk_vlan_t *pSvid)
{
    rtk_api_ret_t   retVal;
    rtk_uint32      svidx;
    rtl8367b_svlan_memconf_t svlanMemConf;

    if ((retVal = rtl8367b_getAsicSvlanIngressUnmatch(pAction)) != RT_ERR_OK)
        return retVal;

    if(*pAction == UNMATCH_ASSIGN)
    {
        if ((retVal = rtl8367b_getAsicSvlanUnmatchVlan(&svidx)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(svidx, &svlanMemConf)) != RT_ERR_OK)
            return retVal;

        *pSvid = svlanMemConf.vs_svid;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_dmac_vidsel_set
 * Description:
 *      Set DMAC CVID selection
 * Input:
 *      port    - Port
 *      enable  - state of DMAC CVID Selection
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_SVLAN_VID                - Invalid SVLAN VID parameter.
 *      RT_ERR_SVLAN_ENTRY_NOT_FOUND    - specified svlan entry not found.
 *      RT_ERR_OUT_OF_RANGE             - input out of range.
 *      RT_ERR_INPUT                    - Invalid input parameters.
 * Note:
 *      This API can set DMAC CVID Selection state
 */
rtk_api_ret_t rtk_svlan_dmac_vidsel_set(rtk_port_t port, rtk_enable_t enable)
{
    rtk_api_ret_t   retVal;

    if(port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsicSvlanDmacCvidSel(port, enable)) != RT_ERR_OK)
            return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_dmac_vidsel_get
 * Description:
 *      Get DMAC CVID selection
 * Input:
 *      port    - Port
 * Output:
 *      pEnable - state of DMAC CVID Selection
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_SVLAN_VID                - Invalid SVLAN VID parameter.
 *      RT_ERR_SVLAN_ENTRY_NOT_FOUND    - specified svlan entry not found.
 *      RT_ERR_OUT_OF_RANGE             - input out of range.
 *      RT_ERR_INPUT                    - Invalid input parameters.
 * Note:
 *      This API can get DMAC CVID Selection state
 */
rtk_api_ret_t rtk_svlan_dmac_vidsel_get(rtk_port_t port, rtk_enable_t *pEnable)
{
    rtk_api_ret_t   retVal;

    if(port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicSvlanDmacCvidSel(port, pEnable)) != RT_ERR_OK)
            return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_svlan_ipmc2s_add
 * Description:
 *      add ip multicast address to SVLAN
 * Input:
 *      svid - SVLAN VID
 *      ipmc - ip multicast address
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_SVLAN_VID                - Invalid SVLAN VID parameter.
 *      RT_ERR_SVLAN_ENTRY_NOT_FOUND    - specified svlan entry not found.
 *      RT_ERR_OUT_OF_RANGE             - input out of range.
 *      RT_ERR_INPUT                    - Invalid input parameters.
 * Note:
 *      The API can set IP mutlicast to SVID configuration. If upstream packet is IPv4 multicast
 *      packet and DIP is matched MC2S configuration, ASIC will assign egress SVID to the packet.
 *      There are 32 SVLAN multicast configurations for IP and L2 multicast.
 */
rtk_api_ret_t rtk_svlan_ipmc2s_add(ipaddr_t ipmc, rtk_vlan_t svid)
{
    rtk_api_ret_t retVal, i;
    rtk_uint32 empty_idx;
    rtk_uint32 svidx;
    rtl8367b_svlan_memconf_t svlanMemConf;
    rtl8367b_svlan_mc2s_t svlanMC2SConf;

    if (svid > RTL8367B_VIDMAX)
        return RT_ERR_SVLAN_VID;

    if ((ipmc&0xF0000000)!=0xE0000000)
        return RT_ERR_INPUT;

    svidx = 0xFFFF;

    for (i = 0; i < RTL8367B_SVIDXNO; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
            return retVal;

        if (svid == svlanMemConf.vs_svid)
        {
            svidx = i;
            break;
        }
    }

    if (0xFFFF == svidx)
            return RT_ERR_SVLAN_ENTRY_NOT_FOUND;


    empty_idx = 0xFFFF;

    for (i = RTL8367B_MC2SIDXMAX; i >= 0; i--)
    {
        if ((retVal = rtl8367b_getAsicSvlanMC2SConf(i, &svlanMC2SConf)) != RT_ERR_OK)
            return retVal;

        if (TRUE == svlanMC2SConf.valid)
        {
            if (svlanMC2SConf.format == SVLAN_MC2S_MODE_IP && svlanMC2SConf.sdata==ipmc&&svlanMC2SConf.smask!=0)
            {
                svlanMC2SConf.svidx = svidx;
                if ((retVal = rtl8367b_setAsicSvlanMC2SConf(i, &svlanMC2SConf)) != RT_ERR_OK)
                    return retVal;
            }
        }
        else
        {
            empty_idx = i;
        }
    }

    if (empty_idx!=0xFFFF)
    {
        svlanMC2SConf.valid = TRUE;
        svlanMC2SConf.svidx = svidx;
        svlanMC2SConf.format = SVLAN_MC2S_MODE_IP;
        svlanMC2SConf.sdata = ipmc;
        svlanMC2SConf.smask = 0xFFFFFFFF;
        if ((retVal = rtl8367b_setAsicSvlanMC2SConf(empty_idx, &svlanMC2SConf)) != RT_ERR_OK)
            return retVal;
        return RT_ERR_OK;
    }

    return RT_ERR_OUT_OF_RANGE;

}

/* Function Name:
 *      rtk_svlan_ipmc2s_del
 * Description:
 *      delete ip multicast address to SVLAN
 * Input:
 *      ipmc - ip multicast address
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_SVLAN_VID        - Invalid SVLAN VID parameter.
 *      RT_ERR_OUT_OF_RANGE     - input out of range.
 * Note:
 *      The API can delete IP mutlicast to SVID configuration. There are 32 SVLAN multicast configurations for IP and L2 multicast.
 */
rtk_api_ret_t rtk_svlan_ipmc2s_del(ipaddr_t ipmc)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtl8367b_svlan_mc2s_t svlanMC2SConf;

    if ((ipmc&0xF0000000)!=0xE0000000)
        return RT_ERR_INPUT;

    for (i = 0; i <= RTL8367B_MC2SIDXMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMC2SConf(i, &svlanMC2SConf)) != RT_ERR_OK)
            return retVal;

        if (TRUE == svlanMC2SConf.valid)
        {
            if (svlanMC2SConf.format == SVLAN_MC2S_MODE_IP && svlanMC2SConf.sdata==ipmc&&svlanMC2SConf.smask!=0)
            {
                memset(&svlanMC2SConf, 0, sizeof(rtl8367b_svlan_mc2s_t));
                if ((retVal = rtl8367b_setAsicSvlanMC2SConf(i, &svlanMC2SConf)) != RT_ERR_OK)
                    return retVal;
                return RT_ERR_OK;
            }
        }
    }

    return RT_ERR_OUT_OF_RANGE;
}

/* Function Name:
 *      rtk_svlan_ipmc2s_get
 * Description:
 *      Get ip multicast address to SVLAN
 * Input:
 *      ipmc - ip multicast address
 * Output:
 *      pSvid - SVLAN VID
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_OUT_OF_RANGE - input out of range.
 * Note:
 *      The API can get IP mutlicast to SVID configuration. There are 32 SVLAN multicast configurations for IP and L2 multicast.
 */
rtk_api_ret_t rtk_svlan_ipmc2s_get(ipaddr_t ipmc, rtk_vlan_t *pSvid)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtl8367b_svlan_memconf_t svlanMemConf;
    rtl8367b_svlan_mc2s_t svlanMC2SConf;

    if ((ipmc&0xF0000000)!=0xE0000000)
        return RT_ERR_INPUT;

    for (i = 0; i <= RTL8367B_MC2SIDXMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMC2SConf(i, &svlanMC2SConf)) != RT_ERR_OK)
            return retVal;

        if (TRUE == svlanMC2SConf.valid && svlanMC2SConf.format == SVLAN_MC2S_MODE_IP && svlanMC2SConf.sdata == ipmc && svlanMC2SConf.smask != 0)
        {
            if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(svlanMC2SConf.svidx, &svlanMemConf)) != RT_ERR_OK)
                return retVal;
            *pSvid = svlanMemConf.vs_svid;
            return RT_ERR_OK;
        }
    }

    return RT_ERR_OUT_OF_RANGE;
}

/* Function Name:
 *      rtk_svlan_l2mc2s_add
 * Description:
 *      Add L2 multicast address to SVLAN
 * Input:
 *      svid - SVLAN VID
 *      mac - L2 multicast address
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                       - OK
 *      RT_ERR_FAILED                   - Failed
 *      RT_ERR_SMI                      - SMI access error
 *      RT_ERR_SVLAN_VID                - Invalid SVLAN VID parameter.
 *      RT_ERR_SVLAN_ENTRY_NOT_FOUND    - specified svlan entry not found.
 *      RT_ERR_OUT_OF_RANGE             - input out of range.
 *      RT_ERR_INPUT                    - Invalid input parameters.
 * Note:
 *      The API can set L2 Mutlicast to SVID configuration. If upstream packet is L2 multicast
 *      packet and DMAC is matched, ASIC will assign egress SVID to the packet. There are 32
 *      SVLAN multicast configurations for IP and L2 multicast.
 */
rtk_api_ret_t rtk_svlan_l2mc2s_add(rtk_vlan_t svid, rtk_mac_t mac)
{
    rtk_api_ret_t retVal, i;
    rtk_uint32 empty_idx;
    rtk_uint32 svidx, l2add;
    rtl8367b_svlan_memconf_t svlanMemConf;
    rtl8367b_svlan_mc2s_t svlanMC2SConf;

    if (svid > RTL8367B_VIDMAX)
        return RT_ERR_SVLAN_VID;

    if (mac.octet[0]!= 1&&mac.octet[1]!=0)
        return RT_ERR_INPUT;

    memcpy(&l2add, &mac.octet[2],4);

     svidx = 0xFFFF;

    for (i = 0; i < RTL8367B_SVIDXNO; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
            return retVal;

        if (svid == svlanMemConf.vs_svid)
        {
            svidx = i;
            break;
        }
    }

    if (0xFFFF == svidx)
        return RT_ERR_SVLAN_ENTRY_NOT_FOUND;

    empty_idx = 0xFFFF;

    for (i = RTL8367B_MC2SIDXMAX; i >=0; i--)
    {
        if ((retVal = rtl8367b_getAsicSvlanMC2SConf(i, &svlanMC2SConf)) != RT_ERR_OK)
            return retVal;

        if (TRUE == svlanMC2SConf.valid)
        {
            if (svlanMC2SConf.format == SVLAN_MC2S_MODE_MAC && svlanMC2SConf.sdata==l2add&&svlanMC2SConf.smask!=0)
            {
                svlanMC2SConf.svidx = svidx;
                if ((retVal = rtl8367b_setAsicSvlanMC2SConf(i, &svlanMC2SConf)) != RT_ERR_OK)
                    return retVal;
            }
        }
        else
        {
            empty_idx = i;
        }
    }

    if (empty_idx!=0xFFFF)
    {
        svlanMC2SConf.valid = TRUE;
        svlanMC2SConf.svidx = svidx;
        svlanMC2SConf.format = SVLAN_MC2S_MODE_MAC;
        svlanMC2SConf.sdata = l2add;
        svlanMC2SConf.smask = 0xFFFFFFFF;

        if ((retVal = rtl8367b_setAsicSvlanMC2SConf(empty_idx, &svlanMC2SConf)) != RT_ERR_OK)
            return retVal;
        return RT_ERR_OK;
    }

    return RT_ERR_OUT_OF_RANGE;
}

/* Function Name:
 *      rtk_svlan_l2mc2s_del
 * Description:
 *      delete L2 multicast address to SVLAN
 * Input:
 *      mac - L2 multicast address
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_SVLAN_VID        - Invalid SVLAN VID parameter.
 *      RT_ERR_OUT_OF_RANGE     - input out of range.
 * Note:
 *      The API can delete Mutlicast to SVID configuration. There are 32 SVLAN multicast configurations for IP and L2 multicast.
 */
rtk_api_ret_t rtk_svlan_l2mc2s_del(rtk_mac_t mac)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtk_uint32 l2add;
    rtl8367b_svlan_mc2s_t svlanMC2SConf;

      if (mac.octet[0]!= 1&&mac.octet[1]!=0)
        return RT_ERR_INPUT;

    memcpy(&l2add, &mac.octet[2],4);

    for (i = 0; i <= RTL8367B_MC2SIDXMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMC2SConf(i, &svlanMC2SConf)) != RT_ERR_OK)
            return retVal;

        if (TRUE == svlanMC2SConf.valid)
        {
            if (svlanMC2SConf.format == SVLAN_MC2S_MODE_MAC && svlanMC2SConf.sdata==l2add&&svlanMC2SConf.smask!=0)
            {
                memset(&svlanMC2SConf, 0, sizeof(rtl8367b_svlan_mc2s_t));
                if ((retVal = rtl8367b_setAsicSvlanMC2SConf(i, &svlanMC2SConf)) != RT_ERR_OK)
                    return retVal;
                return RT_ERR_OK;
            }
        }
    }

    return RT_ERR_OUT_OF_RANGE;
}

/* Function Name:
 *      rtk_svlan_l2mc2s_get
 * Description:
 *      Get L2 multicast address to SVLAN
 * Input:
 *      mac - L2 multicast address
 * Output:
 *      pSvid - SVLAN VID
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_INPUT            - Invalid input parameters.
 *      RT_ERR_OUT_OF_RANGE     - input out of range.
 * Note:
 *      The API can get L2 mutlicast to SVID configuration. There are 32 SVLAN multicast configurations for IP and L2 multicast.
 */
rtk_api_ret_t rtk_svlan_l2mc2s_get(rtk_mac_t mac, rtk_vlan_t *pSvid)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtk_uint32 l2add;
    rtl8367b_svlan_memconf_t svlanMemConf;
    rtl8367b_svlan_mc2s_t svlanMC2SConf;

    if (mac.octet[0]!= 1&&mac.octet[1]!=0)
        return RT_ERR_INPUT;

    memcpy(&l2add, &mac.octet[2],4);

    for (i = 0; i <= RTL8367B_MC2SIDXMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMC2SConf(i, &svlanMC2SConf)) != RT_ERR_OK)
            return retVal;

        if (TRUE == svlanMC2SConf.valid)
        {
            if (svlanMC2SConf.format == SVLAN_MC2S_MODE_MAC && svlanMC2SConf.sdata==l2add&&svlanMC2SConf.smask!=0)
            {
                if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(svlanMC2SConf.svidx, &svlanMemConf)) != RT_ERR_OK)
                    return retVal;
                *pSvid = svlanMemConf.vs_svid;

                return RT_ERR_OK;
            }
        }
    }

    return RT_ERR_OUT_OF_RANGE;
}

/* Function Name:
 *      rtk_svlan_sp2c_add
 * Description:
 *      Add system SP2C configuration
 * Input:
 *      cvid        - VLAN ID
 *      dst_port    - Destination port of SVLAN to CVLAN configuration
 *      svid        - SVLAN VID
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_SVLAN_VID    - Invalid SVLAN VID parameter.
 *      RT_ERR_VLAN_VID     - Invalid VID parameter.
 *      RT_ERR_OUT_OF_RANGE - input out of range.
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      The API can add SVID & Destination Port to CVLAN configuration. The downstream frames with assigned
 *      SVID will be add C-tag with assigned CVID if the output port is the assigned destination port.
 *      There are 128 SP2C configurations.
 */
rtk_api_ret_t rtk_svlan_sp2c_add(rtk_vlan_t svid, rtk_port_t dst_port, rtk_vlan_t cvid)
{
    rtk_api_ret_t retVal, i;
    rtk_uint32 empty_idx, svidx;
    rtl8367b_svlan_memconf_t svlanMemConf;
    rtl8367b_svlan_s2c_t svlanSP2CConf;

    if (svid > RTL8367B_VIDMAX)
        return RT_ERR_SVLAN_VID;

    if (cvid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

      if (dst_port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    svidx = 0xFFFF;

    for (i = 0; i < RTL8367B_SVIDXNO; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
            return retVal;

        if (svid == svlanMemConf.vs_svid)
        {
            svidx = i;
            break;
        }
    }

    if (0xFFFF == svidx)
        return RT_ERR_SVLAN_ENTRY_NOT_FOUND;

    empty_idx = 0xFFFF;

    for (i=RTL8367B_SP2CMAX; i >=0 ; i--)
    {
        if ((retVal = rtl8367b_getAsicSvlanSP2CConf(i, &svlanSP2CConf)) != RT_ERR_OK)
            return retVal;

        if ( (svlanSP2CConf.svidx == svidx) && (svlanSP2CConf.dstport == dst_port) && (svlanSP2CConf.valid == 1))
        {
            empty_idx = i;
            break;
        }
        else if (svlanSP2CConf.valid == 0)
        {
            empty_idx = i;
        }
    }

    if (empty_idx!=0xFFFF)
    {
        svlanSP2CConf.valid     = 1;
        svlanSP2CConf.vid       = cvid;
        svlanSP2CConf.svidx     = svidx;
        svlanSP2CConf.dstport   = dst_port;

        if ((retVal = rtl8367b_setAsicSvlanSP2CConf(empty_idx, &svlanSP2CConf)) != RT_ERR_OK)
            return retVal;
        return RT_ERR_OK;
    }

    return RT_ERR_OUT_OF_RANGE;

}

/* Function Name:
 *      rtk_svlan_sp2c_get
 * Description:
 *      Get configure system SP2C content
 * Input:
 *      svid 	    - SVLAN VID
 *      dst_port 	- Destination port of SVLAN to CVLAN configuration
 * Output:
 *      pCvid - VLAN ID
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_OUT_OF_RANGE - input out of range.
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_SVLAN_VID    - Invalid SVLAN VID parameter.
 * Note:
 *     The API can get SVID & Destination Port to CVLAN configuration. There are 128 SP2C configurations.
 */
rtk_api_ret_t rtk_svlan_sp2c_get(rtk_vlan_t svid, rtk_port_t dst_port, rtk_vlan_t *pCvid)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i, svidx;
    rtl8367b_svlan_memconf_t svlanMemConf;
    rtl8367b_svlan_s2c_t svlanSP2CConf;

    if (svid > RTL8367B_VIDMAX)
        return RT_ERR_SVLAN_VID;

    if (dst_port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    svidx = 0xFFFF;

    for (i = 0; i < RTL8367B_SVIDXNO; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
            return retVal;

        if (svid == svlanMemConf.vs_svid)
        {
            svidx = i;
            break;
        }
    }

    if (0xFFFF == svidx)
        return RT_ERR_SVLAN_ENTRY_NOT_FOUND;

    for (i = 0; i <= RTL8367B_SP2CMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanSP2CConf(i, &svlanSP2CConf)) != RT_ERR_OK)
            return retVal;

        if ( (svlanSP2CConf.svidx == svidx) && (svlanSP2CConf.dstport == dst_port) && (svlanSP2CConf.valid == 1) )
        {
            *pCvid = svlanSP2CConf.vid;
            return RT_ERR_OK;
        }
    }

    return RT_ERR_OUT_OF_RANGE;
}

/* Function Name:
 *      rtk_svlan_sp2c_del
 * Description:
 *      Delete system SP2C configuration
 * Input:
 *      svid        - SVLAN VID
 *      dst_port    - Destination port of SVLAN to CVLAN configuration
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_SVLAN_VID    - Invalid SVLAN VID parameter.
 *      RT_ERR_OUT_OF_RANGE - input out of range.
 * Note:
 *      The API can delete SVID & Destination Port to CVLAN configuration. There are 128 SP2C configurations.
 */
rtk_api_ret_t rtk_svlan_sp2c_del(rtk_vlan_t svid, rtk_port_t dst_port)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i, svidx;
    rtl8367b_svlan_memconf_t svlanMemConf;
    rtl8367b_svlan_s2c_t svlanSP2CConf;

    if (svid > RTL8367B_VIDMAX)
        return RT_ERR_SVLAN_VID;

    if (dst_port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    svidx = 0xFFFF;

    for (i = 0; i < RTL8367B_SVIDXNO; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanMemberConfiguration(i, &svlanMemConf)) != RT_ERR_OK)
            return retVal;

        if (svid == svlanMemConf.vs_svid)
        {
            svidx = i;
            break;
        }
    }

    if (0xFFFF == svidx)
        return RT_ERR_SVLAN_ENTRY_NOT_FOUND;

    for (i = 0; i <= RTL8367B_SP2CMAX; i++)
    {
        if ((retVal = rtl8367b_getAsicSvlanSP2CConf(i, &svlanSP2CConf)) != RT_ERR_OK)
            return retVal;

        if ( (svlanSP2CConf.svidx == svidx) && (svlanSP2CConf.dstport == dst_port) && (svlanSP2CConf.valid == 1) )
        {
            svlanSP2CConf.valid     = 0;
            svlanSP2CConf.vid       = 0;
            svlanSP2CConf.svidx     = 0;
            svlanSP2CConf.dstport   = 0;

            if ((retVal = rtl8367b_setAsicSvlanSP2CConf(i, &svlanSP2CConf)) != RT_ERR_OK)
                return retVal;
            return RT_ERR_OK;
        }

    }

    return RT_ERR_OUT_OF_RANGE;
}

/* Function Name:
 *      rtk_cpu_enable_set
 * Description:
 *      Set CPU port function enable/disable.
 * Input:
 *      enable - CPU port function enable
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameter.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The API can set CPU port function enable/disable.
 */
rtk_api_ret_t rtk_cpu_enable_set(rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsicCputagEnable(enable)) != RT_ERR_OK)
        return retVal;

    if (DISABLED == enable)
    {
        if ((retVal = rtl8367b_setAsicCputagPortmask(0)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_cpu_enable_get
 * Description:
 *      Get CPU port and its setting.
 * Input:
 *      None
 * Output:
 *      pEnable - CPU port function enable
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_INPUT            - Invalid input parameters.
 *      RT_ERR_L2_NO_CPU_PORT   - CPU port is not exist
 * Note:
 *      The API can get CPU port function enable/disable.
 */
rtk_api_ret_t rtk_cpu_enable_get(rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicCputagEnable(pEnable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_cpu_tagPort_set
 * Description:
 *      Set CPU port and CPU tag insert mode.
 * Input:
 *      port - Port id.
 *      mode - CPU tag insert for packets egress from CPU port.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameter.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The API can set CPU port and inserting proprietary CPU tag mode (Length/Type 0x8899)
 *      to the frame that transmitting to CPU port.
 *      The inset cpu tag mode is as following:
 *      - CPU_INSERT_TO_ALL
 *      - CPU_INSERT_TO_TRAPPING
 *      - CPU_INSERT_TO_NONE
 */
rtk_api_ret_t rtk_cpu_tagPort_set(rtk_port_t port, rtk_cpu_insert_t mode)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_INPUT;

    if (mode >= CPU_INSERT_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicCputagPortmask(1<<port)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicCputagTrapPort(port)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicCputagInsertMode(mode)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_cpu_tagPort_get
 * Description:
 *      Get CPU port and CPU tag insert mode.
 * Input:
 *      None
 * Output:
 *      pPort - Port id.
 *      pMode - CPU tag insert for packets egress from CPU port, 0:all insert 1:Only for trapped packets 2:no insert.
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_INPUT            - Invalid input parameters.
 *      RT_ERR_L2_NO_CPU_PORT   - CPU port is not exist
 * Note:
 *      The API can get configured CPU port and its setting.
 *      The inset cpu tag mode is as following:
 *      - CPU_INSERT_TO_ALL
 *      - CPU_INSERT_TO_TRAPPING
 *      - CPU_INSERT_TO_NONE
 */
rtk_api_ret_t rtk_cpu_tagPort_get(rtk_port_t *pPort, rtk_cpu_insert_t *pMode)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i, pmsk, port;

    if ((retVal = rtl8367b_getAsicCputagPortmask(&pmsk)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicCputagTrapPort(&port)) != RT_ERR_OK)
        return retVal;

    for (i = 0; i< RTK_MAX_NUM_OF_PORT; i++)
    {
        if ((pmsk&(1<<i))!=0)
        {
            if (i==port)
                *pPort = port;
            else
                return RT_ERR_FAILED;
        }
    }

    if ((retVal = rtl8367b_getAsicCputagInsertMode(pMode)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_unauthPacketOper_set
 * Description:
 *      Set 802.1x unauth action configuration.
 * Input:
 *      port            - Port id.
 *      unauth_action   - 802.1X unauth action.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_INPUT        - Invalid input parameter.
 * Note:
 *      This API can set 802.1x unauth action configuration.
 *      The unauth action is as following:
 *      - DOT1X_ACTION_DROP
 *      - DOT1X_ACTION_TRAP2CPU
 *      - DOT1X_ACTION_GUESTVLAN
 */
rtk_api_ret_t rtk_dot1x_unauthPacketOper_set(rtk_port_t port, rtk_dot1x_unauth_action_t unauth_action)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (unauth_action >= DOT1X_ACTION_END)
        return RT_ERR_DOT1X_PROC;

    if ((retVal = rtl8367b_setAsic1xProcConfig(port, unauth_action)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_unauthPacketOper_get
 * Description:
 *      Get 802.1x unauth action configuration.
 * Input:
 *      port - Port id.
 * Output:
 *      pUnauth_action - 802.1X unauth action.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      This API can get 802.1x unauth action configuration.
 *      The unauth action is as following:
 *      - DOT1X_ACTION_DROP
 *      - DOT1X_ACTION_TRAP2CPU
 *      - DOT1X_ACTION_GUESTVLAN
 */
rtk_api_ret_t rtk_dot1x_unauthPacketOper_get(rtk_port_t port, rtk_dot1x_unauth_action_t *pUnauth_action)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsic1xProcConfig(port, pUnauth_action)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_eapolFrame2CpuEnable_set
 * Description:
 *      Set 802.1x EAPOL packet trap to CPU configuration
 * Input:
 *      enable - The status of 802.1x EAPOL packet.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_ENABLE       - Invalid enable input.
 * Note:
 *      To support 802.1x authentication functionality, EAPOL frame (ether type = 0x888E) has to
 *      be trapped to CPU.
 *      The status of EAPOL frame trap to CPU is as following:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_dot1x_eapolFrame2CpuEnable_set(rtk_enable_t enable)
{
    rtk_api_ret_t retVal;
    rtl8367b_rma_t rmacfg;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_getAsicRma(3, &rmacfg)) != RT_ERR_OK)
        return retVal;

    if (ENABLED == enable)
        rmacfg.operation = RMAOP_TRAP_TO_CPU;
    else if (DISABLED == enable)
        rmacfg.operation = RMAOP_FORWARD;
    else
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicRma(3, &rmacfg)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_eapolFrame2CpuEnable_get
 * Description:
 *      Get 802.1x EAPOL packet trap to CPU configuration
 * Input:
 *      None
 * Output:
 *      pEnable - The status of 802.1x EAPOL packet.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      To support 802.1x authentication functionality, EAPOL frame (ether type = 0x888E) has to
 *      be trapped to CPU.
 *      The status of EAPOL frame trap to CPU is as following:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_dot1x_eapolFrame2CpuEnable_get(rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;
    rtl8367b_rma_t rmacfg;

    if ((retVal = rtl8367b_getAsicRma(3, &rmacfg)) != RT_ERR_OK)
        return retVal;

    if (RMAOP_TRAP_TO_CPU == rmacfg.operation)
        *pEnable = ENABLED;
    else
        *pEnable = DISABLED;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_portBasedEnable_set
 * Description:
 *      Set 802.1x port-based enable configuration
 * Input:
 *      port - Port id.
 *      enable - The status of 802.1x port.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_PORT_ID              - Invalid port number.
 *      RT_ERR_ENABLE               - Invalid enable input.
 *      RT_ERR_DOT1X_PORTBASEDPNEN  - 802.1X port-based enable error
 * Note:
 *      The API can update the port-based port enable register content. If a port is 802.1x
 *      port based network access control "enabled", it should be authenticated so packets
 *      from that port won't be dropped or trapped to CPU.
 *      The status of 802.1x port-based network access control is as following:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_dot1x_portBasedEnable_set(rtk_port_t port, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsic1xPBEnConfig(port,enable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_portBasedEnable_get
 * Description:
 *      Get 802.1x port-based enable configuration
 * Input:
 *      port - Port id.
 * Output:
 *      pEnable - The status of 802.1x port.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The API can get the 802.1x port-based port status.
 */
rtk_api_ret_t rtk_dot1x_portBasedEnable_get(rtk_port_t port, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsic1xPBEnConfig(port, pEnable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_portBasedAuthStatus_set
 * Description:
 *      Set 802.1x port-based auth. port configuration
 * Input:
 *      port - Port id.
 *      port_auth - The status of 802.1x port.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_PORT_ID              - Invalid port number.
 *     RT_ERR_DOT1X_PORTBASEDAUTH   - 802.1X port-based auth error
 * Note:
 *      The authenticated status of 802.1x port-based network access control is as following:
 *      - UNAUTH
 *      - AUTH
 */
rtk_api_ret_t rtk_dot1x_portBasedAuthStatus_set(rtk_port_t port, rtk_dot1x_auth_status_t port_auth)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

     if (port_auth >= AUTH_STATUS_END)
        return RT_ERR_DOT1X_PORTBASEDAUTH;

    if ((retVal = rtl8367b_setAsic1xPBAuthConfig(port, port_auth)) != RT_ERR_OK)
        return retVal;


    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_portBasedAuthStatus_get
 * Description:
 *      Get 802.1x port-based auth. port configuration
 * Input:
 *      port - Port id.
 * Output:
 *      pPort_auth - The status of 802.1x port.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The API can get 802.1x port-based port auth.information.
 */
rtk_api_ret_t rtk_dot1x_portBasedAuthStatus_get(rtk_port_t port, rtk_dot1x_auth_status_t *pPort_auth)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsic1xPBAuthConfig(port, pPort_auth)) != RT_ERR_OK)
        return retVal;
    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_portBasedDirection_set
 * Description:
 *      Set 802.1x port-based operational direction configuration
 * Input:
 *      port            - Port id.
 *      port_direction  - Operation direction
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_PORT_ID              - Invalid port number.
 *      RT_ERR_DOT1X_PORTBASEDOPDIR - 802.1X port-based operation direction error
 * Note:
 *      The operate controlled direction of 802.1x port-based network access control is as following:
 *      - BOTH
 *      - IN
 */
rtk_api_ret_t rtk_dot1x_portBasedDirection_set(rtk_port_t port, rtk_dot1x_direction_t port_direction)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (port_direction >= DIRECTION_END)
        return RT_ERR_DOT1X_PORTBASEDOPDIR;

    if ((retVal = rtl8367b_setAsic1xPBOpdirConfig(port, port_direction)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_portBasedDirection_get
 * Description:
 *      Get 802.1X port-based operational direction configuration
 * Input:
 *      port - Port id.
 * Output:
 *      pPort_direction - Operation direction
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The API can get 802.1x port-based operational direction information.
 */
rtk_api_ret_t rtk_dot1x_portBasedDirection_get(rtk_port_t port, rtk_dot1x_direction_t *pPort_direction)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsic1xPBOpdirConfig(port, pPort_direction)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_macBasedEnable_set
 * Description:
 *      Set 802.1x mac-based port enable configuration
 * Input:
 *      port - Port id.
 *      enable - The status of 802.1x port.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_PORT_ID              - Invalid port number.
 *      RT_ERR_ENABLE               - Invalid enable input.
 *      RT_ERR_DOT1X_MACBASEDPNEN   - 802.1X mac-based enable error
 * Note:
 *      If a port is 802.1x MAC based network access control "enabled", the incoming packets should
 *       be authenticated so packets from that port won't be dropped or trapped to CPU.
 *      The status of 802.1x MAC-based network access control is as following:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_dot1x_macBasedEnable_set(rtk_port_t port, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsic1xMBEnConfig(port,enable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_macBasedEnable_get
 * Description:
 *      Get 802.1x mac-based port enable configuration
 * Input:
 *      port - Port id.
 * Output:
 *      pEnable - The status of 802.1x port.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      If a port is 802.1x MAC based network access control "enabled", the incoming packets should
 *      be authenticated so packets from that port wont be dropped or trapped to CPU.
 *      The status of 802.1x MAC-based network access control is as following:
 *      - DISABLED
 *      - ENABLED
 */
rtk_api_ret_t rtk_dot1x_macBasedEnable_get(rtk_port_t port, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsic1xMBEnConfig(port, pEnable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_macBasedAuthMac_add
 * Description:
 *      Add an authenticated MAC to ASIC
 * Input:
 *      port        - Port id.
 *      pAuth_mac   - The authenticated MAC.
 *      fid         - filtering database.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_PORT_ID              - Invalid port number.
 *      RT_ERR_ENABLE               - Invalid enable input.
 *      RT_ERR_DOT1X_MACBASEDPNEN   - 802.1X mac-based enable error
 * Note:
 *      The API can add a 802.1x authenticated MAC address to port. If the MAC does not exist in LUT,
 *      user can't add this MAC to auth status.
 */
rtk_api_ret_t rtk_dot1x_macBasedAuthMac_add(rtk_port_t port, rtk_mac_t *pAuth_mac, rtk_fid_t fid)
{
    rtk_api_ret_t retVal;
      rtk_uint32 method;
    rtl8367b_luttb l2Table;

    /* must be unicast address */
    if ((pAuth_mac == NULL) || (pAuth_mac->octet[0] & 0x1))
        return RT_ERR_MAC;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (fid > RTL8367B_FIDMAX)
        return RT_ERR_L2_FID;

    memset(&l2Table, 0, sizeof(rtl8367b_luttb));

    /* fill key (MAC,FID) to get L2 entry */
    memcpy(l2Table.mac.octet, pAuth_mac->octet, ETHER_ADDR_LEN);
    l2Table.fid = fid;
    method = LUTREADMETHOD_MAC;
    retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table);
    if ( RT_ERR_OK == retVal)
    {
        if (l2Table.spa != port)
            return RT_ERR_DOT1X_MAC_PORT_MISMATCH;

        memcpy(l2Table.mac.octet, pAuth_mac->octet, ETHER_ADDR_LEN);
        l2Table.fid = fid;
        l2Table.efid = 0;
        l2Table.auth = 1;
        retVal = rtl8367b_setAsicL2LookupTb(&l2Table);
        return retVal;
    }
    else
        return retVal;

}

/* Function Name:
 *      rtk_dot1x_macBasedAuthMac_del
 * Description:
 *      Delete an authenticated MAC to ASIC
 * Input:
 *      port - Port id.
 *      pAuth_mac - The authenticated MAC.
 *      fid - filtering database.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_MAC          - Invalid MAC address.
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      The API can delete a 802.1x authenticated MAC address to port. It only change the auth status of
 *      the MAC and won't delete it from LUT.
 */
rtk_api_ret_t rtk_dot1x_macBasedAuthMac_del(rtk_port_t port, rtk_mac_t *pAuth_mac, rtk_fid_t fid)
{
    rtk_api_ret_t retVal;
    rtk_uint32 method;
    rtl8367b_luttb l2Table;

    /* must be unicast address */
    if ((pAuth_mac == NULL) || (pAuth_mac->octet[0] & 0x1))
        return RT_ERR_MAC;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (fid > RTL8367B_FIDMAX)
        return RT_ERR_L2_FID;

    memset(&l2Table, 0, sizeof(rtl8367b_luttb));

    /* fill key (MAC,FID) to get L2 entry */
    memcpy(l2Table.mac.octet, pAuth_mac->octet, ETHER_ADDR_LEN);
    l2Table.fid = fid;
    method = LUTREADMETHOD_MAC;
    retVal = rtl8367b_getAsicL2LookupTb(method, &l2Table);
    if (RT_ERR_OK == retVal)
    {
        if (l2Table.spa != port)
            return RT_ERR_DOT1X_MAC_PORT_MISMATCH;

        memcpy(l2Table.mac.octet, pAuth_mac->octet, ETHER_ADDR_LEN);
        l2Table.fid = fid;
        l2Table.auth = 0;
        retVal = rtl8367b_setAsicL2LookupTb(&l2Table);
        return retVal;
    }
    else
        return retVal;

}

/* Function Name:
 *      rtk_dot1x_macBasedDirection_set
 * Description:
 *      Set 802.1x mac-based operational direction configuration
 * Input:
 *      mac_direction - Operation direction
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_INPUT                - Invalid input parameter.
 *      RT_ERR_DOT1X_MACBASEDOPDIR  - 802.1X mac-based operation direction error
 * Note:
 *      The operate controlled direction of 802.1x mac-based network access control is as following:
 *      - BOTH
 *      - IN
 */
rtk_api_ret_t rtk_dot1x_macBasedDirection_set(rtk_dot1x_direction_t mac_direction)
{
    rtk_api_ret_t retVal;

    if (mac_direction >= DIRECTION_END)
        return RT_ERR_DOT1X_MACBASEDOPDIR;

    if ((retVal = rtl8367b_setAsic1xMBOpdirConfig(mac_direction)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_macBasedDirection_get
 * Description:
 *      Get 802.1x mac-based operational direction configuration
 * Input:
 *      port - Port id.
 * Output:
 *      pMac_direction - Operation direction
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      The API can get 802.1x mac-based operational direction information.
 */
rtk_api_ret_t rtk_dot1x_macBasedDirection_get(rtk_dot1x_direction_t *pMac_direction)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsic1xMBOpdirConfig(pMac_direction)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      Set 802.1x guest VLAN configuration
 * Description:
 *      Set 802.1x mac-based operational direction configuration
 * Input:
 *      vid - 802.1x guest VLAN ID
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameter.
 * Note:
 *      The operate controlled 802.1x guest VLAN
 */
rtk_api_ret_t rtk_dot1x_guestVlan_set(rtk_vlan_t vid)
{
    rtk_api_ret_t retVal;
    rtk_int32 i;
    rtk_uint32 empty_idx;
    rtl8367b_user_vlan4kentry vlan4K;
    rtl8367b_vlanconfiguser vlanMC;

    /* vid must be 0~4095 */
    if (vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    empty_idx = 0xFFFF;

    for (i = RTL8367B_CVIDXMAX; i >=0 ; i--)
    {
        if ((retVal = rtl8367b_getAsicVlanMemberConfig(i, &vlanMC)) != RT_ERR_OK)
            return retVal;
        if (vid == vlanMC.evid)
        {
            if ((retVal = rtl8367b_setAsic1xGuestVidx(i)) != RT_ERR_OK)
                return retVal;
            return RT_ERR_OK;
        }
        else if (vlanMC.evid == 0 && vlanMC.mbr == 0)
        {
             empty_idx = i;
        }

    }

    /*
        vid doesn't exist in 32 member configuration. Find an empty entry in
        32 member configuration, then copy entry from 4K. If 32 member configuration
        are all full, then find an entry which not used by Port-based VLAN and
        then replace it with 4K. Finally, assign the index to the port.
    */
    if (empty_idx!=0xFFFF)
        {
            vlan4K.vid = vid;
            if ((retVal = rtl8367b_getAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
                return retVal;

            vlanMC.evid = vid;
            vlanMC.mbr = vlan4K.mbr;
            vlanMC.fid_msti = vlan4K.fid_msti;
            vlanMC.meteridx= vlan4K.meteridx;
            vlanMC.envlanpol= vlan4K.envlanpol;

        if ((retVal = rtl8367b_setAsicVlanMemberConfig(empty_idx, &vlanMC)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsic1xGuestVidx(empty_idx)) != RT_ERR_OK)
                return retVal;

            return RT_ERR_OK;
        }

    return RT_ERR_FAILED;
}

/* Function Name:
 *      rtk_dot1x_guestVlan_get
 * Description:
 *      Get 802.1x guest VLAN configuration
 * Input:
 *      None
 * Output:
 *      pVid - 802.1x guest VLAN ID
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      The API can get 802.1x guest VLAN information.
 */
rtk_api_ret_t rtk_dot1x_guestVlan_get(rtk_vlan_t *pVid)
{
    rtk_api_ret_t retVal;
    rtk_uint32 gvidx;
    rtl8367b_vlanconfiguser vlanMC;

    if ((retVal = rtl8367b_getAsic1xGuestVidx(&gvidx)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicVlanMemberConfig(gvidx, &vlanMC)) != RT_ERR_OK)
        return retVal;

    *pVid = vlanMC.evid;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_guestVlan2Auth_set
 * Description:
 *      Set 802.1x guest VLAN to auth host configuration
 * Input:
 *      enable - The status of guest VLAN to auth host.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameter.
 * Note:
 *      The operational direction of 802.1x guest VLAN to auth host control is as following:
 *      - ENABLED
 *      - DISABLED
 */
rtk_api_ret_t rtk_dot1x_guestVlan2Auth_set(rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsic1xGVOpdir(enable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_dot1x_guestVlan2Auth_get
 * Description:
 *      Get 802.1x guest VLAN to auth host configuration
 * Input:
 *      None
 * Output:
 *      pEnable - The status of guest VLAN to auth host.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      The API can get 802.1x guest VLAN to auth host information.
 */
rtk_api_ret_t rtk_dot1x_guestVlan2Auth_get(rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsic1xGVOpdir(pEnable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trunk_port_set
 * Description:
 *      Set trunking group available port mask
 * Input:
 *      trk_gid                 - trunk group id
 *      trunk_member_portmask   - Logic trunking member port mask
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_LA_TRUNK_ID  - Invalid trunking group
 *      RT_ERR_PORT_MASK    - Invalid portmask.
 * Note:
 *      The API can set 4 port trunking group enabled port mask. Each port trunking group has max 4 ports.
 *      If enabled port mask has less than 2 ports available setting, then this trunking group function is disabled.
 *      The group port members for trunk group are as following:
 *      - TRUNK_GROUP0: port 0 to port 3.
 *      - TRUNK_GROUP1: port 4 to port 7.
 */
rtk_api_ret_t rtk_trunk_port_set(rtk_trunk_group_t trk_gid, rtk_portmask_t trunk_member_portmask)
{
    rtk_api_ret_t retVal;
    rtk_uint32 pmsk;

    if (trk_gid>=TRUNK_GROUP2)
        return RT_ERR_LA_TRUNK_ID;

    if (trunk_member_portmask.bits[0] > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    if ((trunk_member_portmask.bits[0]|RTL8367B_PORT_TRUNK_GROUP_MASK_MASK(trk_gid))!=RTL8367B_PORT_TRUNK_GROUP_MASK_MASK(trk_gid))
        return RT_ERR_PORT_MASK;

    pmsk = (trunk_member_portmask.bits[0]&RTL8367B_PORT_TRUNK_GROUP_MASK_MASK(trk_gid))>>RTL8367B_PORT_TRUNK_GROUP_MASK_OFFSET(trk_gid);

    if ((retVal = rtl8367b_setAsicTrunkingGroup(trk_gid, pmsk)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trunk_port_get
 * Description:
 *      Get trunking group available port mask
 * Input:
 *      trk_gid - trunk group id
 * Output:
 *      pTrunk_member_portmask - Logic trunking member port mask
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_LA_TRUNK_ID  - Invalid trunking group
 * Note:
 *      The API can get 4 port trunking group enabled port mask. Each port trunking group has max 4 ports.
 *      If enabled port mask has less than 2 ports available setting, then this trunking group function is disabled.
 *      The group port members for trunk group are as following:
 *      - TRUNK_GROUP0: port 0 to port 3.
 *      - TRUNK_GROUP1: port 4 to port 7.
 */
rtk_api_ret_t rtk_trunk_port_get(rtk_trunk_group_t trk_gid, rtk_portmask_t *pTrunk_member_portmask)
{
    rtk_api_ret_t retVal;

    rtk_uint32 pmsk;

    if (trk_gid>=TRUNK_GROUP2)
        return RT_ERR_LA_TRUNK_ID;

    if ((retVal = rtl8367b_getAsicTrunkingGroup(trk_gid, &pmsk)) != RT_ERR_OK)
        return retVal;

    pTrunk_member_portmask->bits[0] = pmsk<<RTL8367B_PORT_TRUNK_GROUP_MASK_OFFSET(trk_gid);

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trunk_distributionAlgorithm_set
 * Description:
 *      Set port trunking hash select sources
 * Input:
 *      trk_gid         - trunk group id
 *      algo_bitmask    - Bitmask of the distribution algorithm
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_LA_TRUNK_ID  - Invalid trunking group
 *      RT_ERR_LA_HASHMASK  - Hash algorithm selection error.
 *      RT_ERR_PORT_MASK    - Invalid portmask.
 * Note:
 *      The API can set port trunking hash algorithm sources.
 *      7 bits mask for link aggregation group0 hash parameter selection {DIP, SIP, DMAC, SMAC, SPA}
 *      - 0b0000001: SPA
 *      - 0b0000010: SMAC
 *      - 0b0000100: DMAC
 *      - 0b0001000: SIP
 *      - 0b0010000: DIP
 *      - 0b0100000: TCP/UDP Source Port
 *      - 0b1000000: TCP/UDP Destination Port
 *      Example:
 *      - 0b0000011: SMAC & SPA
 *      - Note that it could be an arbitrary combination or independent set
 */
rtk_api_ret_t rtk_trunk_distributionAlgorithm_set(rtk_trunk_group_t trk_gid, rtk_trunk_hashVal2Port_t algo_bitmask)
{
    rtk_api_ret_t retVal;

    if (trk_gid != RTK_WHOLE_SYSTEM)
        return RT_ERR_LA_TRUNK_ID;

    if (algo_bitmask.value[0]>=128)
        return RT_ERR_LA_HASHMASK;

    if ((retVal = rtl8367b_setAsicTrunkingHashSelect(algo_bitmask.value[0])) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trunk_distributionAlgorithm_get
 * Description:
 *      Get port trunking hash select sources
 * Input:
 *      trk_gid - trunk group id
 * Output:
 *      pAlgo_bitmask -  Bitmask of the distribution algorithm
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_LA_TRUNK_ID  - Invalid trunking group
 * Note:
 *      The API can get port trunking hash algorithm sources.
 */
rtk_api_ret_t rtk_trunk_distributionAlgorithm_get(rtk_trunk_group_t trk_gid, rtk_trunk_hashVal2Port_t *pAlgo_bitmask)
{
    rtk_api_ret_t retVal;

    if (trk_gid != RTK_WHOLE_SYSTEM)
        return RT_ERR_LA_TRUNK_ID;

    if ((retVal = rtl8367b_getAsicTrunkingHashSelect((rtk_uint32*)&pAlgo_bitmask->value[0])) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_trunk_qeueuEmptyStatus_get
 * Description:
 *      Get current output queue if empty status
 * Input:
 *      trk_gid - trunk group id
 * Output:
 *      pPortmask - queue empty port mask, 1 for empty and 0 for not empty
 * Return:
 *      RT_ERR_OK       - OK
 *      RT_ERR_FAILED   - Failed
 *      RT_ERR_SMI      - SMI access error
 * Note:
 *      The API can get queues are empty port mask
 */
rtk_api_ret_t rtk_trunk_qeueuEmptyStatus_get(rtk_portmask_t *pPortmask)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicQeueuEmptyStatus(&pPortmask->bits[0])) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

static rtk_api_ret_t _rtk_switch_init_setreg(rtk_uint32 reg, rtk_uint32 data)
{
#ifndef MDC_MDIO_OPERATION
    rtk_uint32      busyFlag, cnt;
#endif
    rtk_api_ret_t   retVal;

#ifdef MDC_MDIO_OPERATION
    if((retVal = rtl8367b_setAsicReg(reg, data) != RT_ERR_OK))
            return retVal;
#else
    if ((reg & 0xF000) == 0x2000)
    {
        cnt = 0;
        busyFlag = 1;
        while (busyFlag&&cnt<5)
        {
            cnt++;
            if ((retVal = rtl8367b_getAsicRegBit(RTK_INDRECT_ACCESS_STATUS, RTK_PHY_BUSY_OFFSET,&busyFlag)) !=  RT_ERR_OK)
                return retVal;
        }
        if (5 == cnt)
            return RT_ERR_BUSYWAIT_TIMEOUT;

        if ((retVal = rtl8367b_setAsicReg(RTK_INDRECT_ACCESS_WRITE_DATA, data)) !=  RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicReg(RTK_INDRECT_ACCESS_ADDRESS, reg)) !=  RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicReg(RTK_INDRECT_ACCESS_CRTL, RTK_CMD_MASK | RTK_RW_MASK)) !=  RT_ERR_OK)
            return retVal;
    }
    else
    {
        if((retVal = rtl8367b_setAsicReg(reg, data)) != RT_ERR_OK)
            return retVal;
    }
#endif

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_switch_init
 * Description:
 *      Set chip to default configuration enviroment
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      The API can set chip registers to default configuration for different release chip model.
 */

rtk_uint32 r8367_cpu_port = RTL8367B_PORT6_ENABLE_OFFSET;

rtk_api_ret_t rtk_switch_init(void)
{
    rtk_uint16      i;
    rtk_uint32      data, data2, regData;
    rtk_api_ret_t   retVal;
    rtk_uint32      phy;
#if defined(CHIP_AUTO_DETECT)
    rtk_uint32      polling_time;
    rtk_uint32      chip_idx = 0;
#endif

    if((retVal = rtl8367b_setAsicReg(0x13C2, 0x0249)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1301, &data)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1300, &data2)) != RT_ERR_OK)
        return retVal;

#if defined(CHIP_AUTO_DETECT)
    if((retVal = rtl8367b_setAsicReg(0x1371, 0x000F)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_setAsicReg(0x1370, 0x0002)) != RT_ERR_OK)
        return retVal;

    polling_time = 0;
    while(polling_time < 10000)
    {
        if((retVal = rtl8367b_getAsicReg(0x1370, &data)) != RT_ERR_OK)
            return retVal;

        if((data & 0x0004) == 0)
            break;

        polling_time++;
    }

    if(polling_time >= 10000)
        return RT_ERR_BUSYWAIT_TIMEOUT;

    if((retVal = rtl8367b_getAsicReg(0x1373, &data)) != RT_ERR_OK)
        return retVal;

    chip_idx |= ((data & 0x000F) << 4);

    if((retVal = rtl8367b_setAsicReg(0x1371, 0x000D)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_setAsicReg(0x1370, 0x0002)) != RT_ERR_OK)
        return retVal;

    polling_time = 0;
    while(polling_time < 10000)
    {
        if((retVal = rtl8367b_getAsicReg(0x1370, &data)) != RT_ERR_OK)
            return retVal;

        if((data & 0x0004) == 0)
            break;

        polling_time++;
    }

    if(polling_time >= 10000)
        return RT_ERR_BUSYWAIT_TIMEOUT;

    if((retVal = rtl8367b_getAsicReg(0x1373, &data)) != RT_ERR_OK)
        return retVal;

    chip_idx |= (data & 0x000F);


    if((chip_idx & 0x00F0) == 0x0000)
    {
        /* RTL8365MB & RTL8305MB */
        if((chip_idx & 0x000F) >> 3)
        {
            /* RTL8305MB */
            init_para = ChipData81;
            init_size = (sizeof(ChipData81) / ((sizeof(rtk_uint16))*2));
        }
        else if((chip_idx & 0x000F) >> 2)
        {
            /* RTL8365MB */
            init_para = ChipData11;
            init_size = (sizeof(ChipData11) / ((sizeof(rtk_uint16))*2));
        }
        else if((chip_idx & 0x000F) >> 1)
        {
            /* RTL8305MB */
            init_para = ChipData81;
            init_size = (sizeof(ChipData81) / ((sizeof(rtk_uint16))*2));
        }
        else if(chip_idx & 0x000F)
        {
            /* RTL8365MB */
            init_para = ChipData11;
            init_size = (sizeof(ChipData11) / ((sizeof(rtk_uint16))*2));
        }
        else
            return RT_ERR_CHIP_NOT_SUPPORTED;
    }
    else
        return RT_ERR_CHIP_NOT_SUPPORTED;

#elif defined(RTK_X86_ASICDRV)
    if(init_para == ChipData00)
    {
        if(data & 0xF000)
        {
            init_para = ChipData01;
            init_size = (sizeof(ChipData01) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData00) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData10)
    {
        if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
        {
            init_para = ChipData12;
            init_size = (sizeof(ChipData12) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            if(data & 0xF000)
            {
                init_para = ChipData11;
                init_size = (sizeof(ChipData11) / ((sizeof(rtk_uint16))*2));
            }
            else
                init_size = (sizeof(ChipData10) / ((sizeof(rtk_uint16))*2));
        }
    }
    else if(init_para == ChipData20)
    {
        if(data & 0xF000)
        {
            init_para = ChipData21;
            init_size = (sizeof(ChipData21) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData20) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData30)
    {
        if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
        {
            init_para = ChipData32;
            init_size = (sizeof(ChipData32) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            if(data & 0xF000)
            {
                init_para = ChipData31;
                init_size = (sizeof(ChipData31) / ((sizeof(rtk_uint16))*2));
            }
            else
                init_size = (sizeof(ChipData30) / ((sizeof(rtk_uint16))*2));
        }
    }
    else if(init_para == ChipData40)
    {
        if(data & 0xF000)
        {
            init_para = ChipData41;
            init_size = (sizeof(ChipData41) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData40) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData50)
    {
        if(data & 0xF000)
        {
            init_para = ChipData51;
            init_size = (sizeof(ChipData51) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData50) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData60)
    {
        if(data & 0xF000)
        {
            init_para = ChipData61;
            init_size = (sizeof(ChipData61) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData60) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData70)
    {
        if(data & 0xF000)
        {
            init_para = ChipData71;
            init_size = (sizeof(ChipData71) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData70) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData80)
    {
        if(data & 0xF000)
        {
            init_para = ChipData81;
            init_size = (sizeof(ChipData81) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData80) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData90)
    {
        if(data & 0xF000)
        {
            init_para = ChipData91;
            init_size = (sizeof(ChipData91) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData90) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData100)
    {
        if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
        {
            init_para = ChipData102;
            init_size = (sizeof(ChipData102) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            if(data & 0xF000)
            {
                init_para = ChipData101;
                init_size = (sizeof(ChipData101) / ((sizeof(rtk_uint16))*2));
            }
            else
                init_size = (sizeof(ChipData100) / ((sizeof(rtk_uint16))*2));
        }
    }

#elif defined(CHIP_RTL8363SB)
    if(data & 0xF000)
    {
        init_para = ChipData01;
        init_size = (sizeof(ChipData01) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData00;
        init_size = (sizeof(ChipData00) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8365MB)
    if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
    {
        init_para = ChipData12;
        init_size = (sizeof(ChipData12) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        if(data & 0xF000)
        {
            init_para = ChipData11;
            init_size = (sizeof(ChipData11) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            init_para = ChipData10;
            init_size = (sizeof(ChipData10) / ((sizeof(rtk_uint16))*2));
        }
    }

#elif defined(CHIP_RTL8367_VB)
    if(data & 0xF000)
    {
        init_para = ChipData21;
        init_size = (sizeof(ChipData21) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData20;
        init_size = (sizeof(ChipData20) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8367RB)
    if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
    {
        init_para = ChipData32;
        init_size = (sizeof(ChipData32) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        if(data & 0xF000)
        {
            init_para = ChipData31;
            init_size = (sizeof(ChipData31) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            init_para = ChipData30;
            init_size = (sizeof(ChipData30) / ((sizeof(rtk_uint16))*2));
        }
    }

#elif defined(CHIP_RTL8367R_VB)
    if(data & 0xF000)
    {
        init_para = ChipData41;
        init_size = (sizeof(ChipData41) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData40;
        init_size = (sizeof(ChipData40) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8367MB)
    if(data & 0xF000)
    {
        init_para = ChipData51;
        init_size = (sizeof(ChipData51) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData50;
        init_size = (sizeof(ChipData50) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8367M_VB)
    if(data & 0xF000)
    {
        init_para = ChipData61;
        init_size = (sizeof(ChipData61) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData60;
        init_size = (sizeof(ChipData60) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8368MB)
    if(data & 0xF000)
    {
        init_para = ChipData71;
        init_size = (sizeof(ChipData71) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData70;
        init_size = (sizeof(ChipData70) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8305MB)
    if(data & 0xF000)
    {
        init_para = ChipData81;
        init_size = (sizeof(ChipData81) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData80;
        init_size = (sizeof(ChipData80) / ((sizeof(rtk_uint16))*2));
    }
#elif defined(CHIP_RTL8307M_VB)
    if(data & 0xF000)
    {
        init_para = ChipData91;
        init_size = (sizeof(ChipData91) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData90;
        init_size = (sizeof(ChipData90) / ((sizeof(rtk_uint16))*2));
    }
#elif defined(CHIP_RTL8367N)
    if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
    {
        init_para = ChipData102;
        init_size = (sizeof(ChipData102) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        if(data & 0xF000)
        {
            init_para = ChipData101;
            init_size = (sizeof(ChipData101) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            init_para = ChipData100;
            init_size = (sizeof(ChipData100) / ((sizeof(rtk_uint16))*2));
        }
    }
#else
    /* Not define CHIP, Error */
    init_para = NULL;
#endif

#if defined(CONFIG_RTL_8367MB_SUPPORT)
    if(data & 0xF000)
    {
        init_para = ChipData51;
        init_size = (sizeof(ChipData51) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData50;
        init_size = (sizeof(ChipData50) / ((sizeof(rtk_uint16))*2));
    }
	// if the RGMII port which connected to 8197D is changed to EXT1, cpu port should set to 6
	r8367_cpu_port = RTL8367B_PORT5_ENABLE_OFFSET;	
	
#elif defined(CONFIG_RTL_8367R_SUPPORT)
	if ((data & 0x00F0) == 0x0010) {  // RTL8367R_VB
		r8367_cpu_port = RTL8367B_PORT5_ENABLE_OFFSET;

		init_para = ChipData41;
		init_size = (sizeof(ChipData41) / ((sizeof(rtk_uint16))*2));
	}	
	else  {	// RTL8367RB or RTL8367RB-VB
		if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))	// RTL8367RB-VB
		{
			init_para = ChipData32;
			init_size = (sizeof(ChipData32) / ((sizeof(rtk_uint16))*2));
		}
		else	// RTL8367RB
		{
			init_para = ChipData31;
			init_size = (sizeof(ChipData31) / ((sizeof(rtk_uint16))*2));
		}	
		r8367_cpu_port = RTL8367B_PORT6_ENABLE_OFFSET;
	}
#else //should not happen
	if ((data & 0x00F0) == 0x0010) {  // RTL8367R_VB
		r8367_cpu_port = RTL8367B_PORT5_ENABLE_OFFSET;
	}	
	else  {	// RTL8367RB
		r8367_cpu_port = RTL8367B_PORT6_ENABLE_OFFSET;
	}

    if(init_para == NULL)
        return RT_ERR_CHIP_NOT_SUPPORTED;
#endif

    if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367) )
    {
        for(phy = 0; phy <= RTK_PHY_ID_MAX; phy++)
        {
            if((retVal = rtl8367b_getAsicPHYOCPReg(phy, 0xA428, &regData)) != RT_ERR_OK)
                return retVal;

            regData &= ~(0x0200);
            if((retVal = rtl8367b_setAsicPHYOCPReg(phy, 0xA428, regData)) != RT_ERR_OK)
                return retVal;
        }

        if((retVal = rtl8367b_setAsicReg(RTL8367B_REG_UTP_FIB_DET, 0x15BB)) != RT_ERR_OK)
            return retVal;
    }

    if( (data2 != 0x0276) && (data2 != 0x0597) && (data2 != 0x6367) )
    {
        /* Analog parameter update. ID:0001 */
        for(phy = 0; phy <= RTK_PHY_ID_MAX; phy++)
        {
            if((retVal = rtl8367b_setAsicPHYReg(phy, 31, 0x7)) != RT_ERR_OK)
                return retVal;

            if((retVal = rtl8367b_setAsicPHYReg(phy, 30, 0x2c)) != RT_ERR_OK)
                return retVal;

            if((retVal = rtl8367b_setAsicPHYReg(phy, 25, 0x0504)) != RT_ERR_OK)
                return retVal;

            if((retVal = rtl8367b_setAsicPHYReg(phy, 31, 0x0)) != RT_ERR_OK)
                return retVal;
        }
    }

    for(i = 0; i < init_size; i++)
    {
        if((retVal = _rtk_switch_init_setreg((rtk_uint32)init_para[i][0], (rtk_uint32)init_para[i][1])) != RT_ERR_OK)
            return retVal;
    }

    if( (data2 != 0x0276) && (data2 != 0x0597) && (data2 != 0x6367) )
    {
        /* Analog parameter update. ID:0002 */
        if((retVal = rtl8367b_setAsicPHYReg(1, 31, 0x2)) != RT_ERR_OK)
            return retVal;

        if((retVal = rtl8367b_getAsicPHYReg(1, 17, &data)) != RT_ERR_OK)
            return retVal;

        data |= 0x01E0;

        if((retVal = rtl8367b_setAsicPHYReg(1, 17, data)) != RT_ERR_OK)
            return retVal;

        if((retVal = rtl8367b_setAsicPHYReg(1, 31, 0x0)) != RT_ERR_OK)
            return retVal;

        /* Analog parameter update. ID:0003 */
        for(phy = 0; phy <= 4; phy++)
        {
            if ((retVal = rtl8367b_setAsicPHYReg(phy, 0x1F, 0x0007)) != RT_ERR_OK)
                return retVal;
            if ((retVal = rtl8367b_setAsicPHYReg(phy, 0x1E, 0x002C)) != RT_ERR_OK)
                return retVal;
            if ((retVal = rtl8367b_setAsicPHYReg(phy, 0x18, 0x008B)) != RT_ERR_OK)
                return retVal;
            if ((retVal = rtl8367b_setAsicPHYReg(phy, 0x19, 0x0504)) != RT_ERR_OK)
                return retVal;
            if ((retVal = rtl8367b_setAsicPHYReg(phy, 0x1F, 0)) != RT_ERR_OK)
                return retVal;
        }

    }

    if((retVal = rtl8367b_setAsicRegBit(0x18e0, 0, 0)) != RT_ERR_OK)
        return retVal;

    if( (data2 != 0x0276) && (data2 != 0x0597) && (data2 != 0x6367) )
    {
        if((retVal = rtl8367b_setAsicReg(0x1303, 0x0778)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x1304, 0x7777)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x13E2, 0x01FE)) != RT_ERR_OK)
            return retVal;
    }
    else
    {
        if((retVal = rtl8367b_setAsicReg(0x1303, 0x06D6)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x1304, 0x0700)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x13E2, 0x003F)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x13F9, 0x0090)) != RT_ERR_OK)
            return retVal;

        if((retVal = rtl8367b_setAsicReg(0x121e, 0x03CA)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x1233, 0x0352)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x1237, 0x00a0)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x123a, 0x0030)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x1239, 0x0084)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x0301, 0x1000)) != RT_ERR_OK)
            return retVal;

        if((retVal = rtl8367b_setAsicReg(0x09DA, 0x0017)) != RT_ERR_OK)
            return retVal;

    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_switch_maxPktLen_set
 * Description:
 *      Set the max packet length of the specific unit
 * Input:
 *      len - max packet length
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can set max packet length of the specific unit to
 *      - MAXPKTLEN_1522B,
 *      - MAXPKTLEN_1536B,
 *      - MAXPKTLEN_1552B,
 *      - MAXPKTLEN_16000B.
 */
rtk_api_ret_t rtk_switch_maxPktLen_set(rtk_switch_maxPktLen_t len)
{
    rtk_api_ret_t retVal;

    if (len>=MAXPKTLEN_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicMaxLengthInRx(len)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_switch_maxPktLen_get
 * Description:
 *      Get the max packet length of the specific unit
 * Input:
 *      None
 * Output:
 *      pLen - pointer to the max packet length
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      The API can set max packet length of the specific unit.
 */
rtk_api_ret_t rtk_switch_maxPktLen_get(rtk_switch_maxPktLen_t *pLen)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicMaxLengthInRx(pLen)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_switch_portMaxPktLen_set
 * Description:
 *      Set 2nd max packet length configuration
 * Input:
 *      port    - Port ID
 *      length  - Length(1522 bytes, 1536 bytes, 1552 bytes, 16000 bytes)
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      The API can set 2nd max packet length configuration.
 *      The parameter "port" indicates which port would follow 2nd configuration.
 *      If the paramter "length" is as same as 1st configuration, this API
 *      would set the port back to 1st configuration. Users should always use
 *      rtk_switch_maxPktLen_set to setup 1st configuration for whole system
 *      setting and then use rtk_switch_portMaxPktLen_set to setup a per port
 *      configuration.
 */
rtk_api_ret_t rtk_switch_portMaxPktLen_set(rtk_port_t port, rtk_uint32 length)
{
    rtk_switch_maxPktLen_t  pkt_len, curr_pkt_len;
    rtk_api_ret_t           retVal;
    rtk_uint32              maxLength, pmaskGiga, pmask100M;

    if(port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if(length == 1522)
        pkt_len = MAXPKTLEN_1522B;
    else if(length == 1536)
        pkt_len = MAXPKTLEN_1536B;
    else if(length == 1552)
        pkt_len = MAXPKTLEN_1552B;
    else if(length == 16000)
        pkt_len = MAXPKTLEN_16000B;
    else
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_getAsicMaxLengthInRx(&curr_pkt_len)) != RT_ERR_OK)
        return retVal;

    if(curr_pkt_len == pkt_len)
    {
        if ((retVal = rtl8367b_getAsicMaxLengthAltTxRx(&maxLength, &pmaskGiga, &pmask100M)) != RT_ERR_OK)
            return retVal;

        pmaskGiga &= ~(0x0001 << port);
        pmask100M &= ~(0x0001 << port);

        if ((retVal = rtl8367b_setAsicMaxLengthAltTxRx(maxLength, pmaskGiga, pmask100M)) != RT_ERR_OK)
            return retVal;
    }
    else
    {
        if ((retVal = rtl8367b_getAsicMaxLengthAltTxRx(&maxLength, &pmaskGiga, &pmask100M)) != RT_ERR_OK)
            return retVal;

        pmaskGiga |= (0x0001 << port);
        pmask100M |= (0x0001 << port);

        if ((retVal = rtl8367b_setAsicMaxLengthAltTxRx(pkt_len, pmaskGiga, pmask100M)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_switch_portMaxPktLen_get
 * Description:
 *      Get 2nd max packet length configuration
 * Input:
 *      port    - Port ID
 * Output:
 *      pLength  - Length(1522 bytes, 1536 bytes, 1552 bytes, 16000 bytes)
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      The API can get 2nd max packet length configuration.
 *      If "port" is not in the 2nd configuration, the setting of
 *      1st configuration woill be returned.
 */
rtk_api_ret_t rtk_switch_portMaxPktLen_get(rtk_port_t port, rtk_uint32 *pLength)
{
    rtk_switch_maxPktLen_t  curr_pkt_len;
    rtk_api_ret_t           retVal;
    rtk_uint32              maxLength, pmaskGiga, pmask100M;

    if(port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicMaxLengthAltTxRx(&maxLength, &pmaskGiga, &pmask100M)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicMaxLengthInRx(&curr_pkt_len)) != RT_ERR_OK)
        return retVal;

    if(pmaskGiga & (0x0001 << port))
    {
        if(maxLength == MAXPKTLEN_1522B)
            *pLength = 1522;
        else if(maxLength == MAXPKTLEN_1536B)
            *pLength = 1536;
        else if(maxLength == MAXPKTLEN_1552B)
            *pLength = 1552;
        else if(maxLength == MAXPKTLEN_16000B)
            *pLength = 16000;
        else
            return RT_ERR_FAILED;
    }
    else
    {
        if(curr_pkt_len == MAXPKTLEN_1522B)
            *pLength = 1522;
        else if(curr_pkt_len == MAXPKTLEN_1536B)
            *pLength = 1536;
        else if(curr_pkt_len == MAXPKTLEN_1552B)
            *pLength = 1552;
        else if(curr_pkt_len == MAXPKTLEN_16000B)
            *pLength = 16000;
        else
            return RT_ERR_FAILED;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_switch_greenEthernet_set
 * Description:
 *      Set all Ports Green Ethernet state.
 * Input:
 *      enable - Green Ethernet state.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK       - OK
 *      RT_ERR_FAILED   - Failed
 *      RT_ERR_SMI      - SMI access error
 *      RT_ERR_ENABLE   - Invalid enable input.
 * Note:
 *      This API can set all Ports Green Ethernet state.
 *      The configuration is as following:
 *      - DISABLE
 *      - ENABLE
 */
rtk_api_ret_t rtk_switch_greenEthernet_set(rtk_enable_t enable)
{
    rtk_api_ret_t retVal;
    rtk_uint32 phy;

    if ((retVal = rtl8367b_setAsicGreenEthernet(enable))!=RT_ERR_OK)
        return retVal;

    for (phy=0;phy<=RTK_PHY_ID_MAX;phy++)
    {
        if ((retVal = rtl8367b_setAsicPowerSaving(phy,enable))!=RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_switch_greenEthernet_get
 * Description:
 *      Get all Ports Green Ethernet state.
 * Input:
 *      None
 * Output:
 *      pEnable - Green Ethernet state.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 * Note:
 *      This API can get Green Ethernet state.
 */
rtk_api_ret_t rtk_switch_greenEthernet_get(rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;
    rtk_data_t value;
    rtk_uint32 phy;

    if ((retVal = rtl8367b_getAsicGreenEthernet(&value))!=RT_ERR_OK)
        return retVal;

    if (value!=1)
    {
        *pEnable = DISABLED;
        return RT_ERR_OK;
    }

    for (phy=0;phy<=RTK_PHY_ID_MAX;phy++)
    {
        if ((retVal = rtl8367b_getAsicPowerSaving(phy,&value))!=RT_ERR_OK)
            return retVal;
        if (value!=1)
        {
            *pEnable = DISABLED;
            return RT_ERR_OK;
        }
    }

    *pEnable = ENABLED;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_mirror_portBased_set
 * Description:
 *      Set port mirror function.
 * Input:
 *      mirroring_port          - Monitor port.
 *      pMirrored_rx_portmask   - Rx mirror port mask.
 *      pMirrored_tx_portmask   - Tx mirror port mask.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number
 *      RT_ERR_PORT_MASK    - Invalid portmask.
 * Note:
 *      The API is to set mirror function of source port and mirror port.
 *      The mirror port can only be set to one port and the TX and RX mirror ports
 *      should be identical.
 */
rtk_api_ret_t rtk_mirror_portBased_set(rtk_port_t mirroring_port, rtk_portmask_t *pMirrored_rx_portmask, rtk_portmask_t *pMirrored_tx_portmask)
{
    rtk_api_ret_t retVal;
    rtk_enable_t mirRx, mirTx;
    rtk_uint32 i;
      rtk_port_t source_port;

    if (mirroring_port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (pMirrored_rx_portmask->bits[0] > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    if (pMirrored_tx_portmask->bits[0] > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    /*Only one port for tx & rx mirror*/
    if (pMirrored_tx_portmask->bits[0]!=pMirrored_rx_portmask->bits[0]&&pMirrored_tx_portmask->bits[0]!=0&&pMirrored_rx_portmask->bits[0]!=0)
        return RT_ERR_PORT_MASK;

     /*mirror port != source port*/
    if ((pMirrored_tx_portmask->bits[0]&(1<<mirroring_port))>0||(pMirrored_rx_portmask->bits[0]&(1<<mirroring_port))>0)
        return RT_ERR_PORT_MASK;

   source_port = 0;

   for (i = 0; i< RTK_MAX_NUM_OF_PORT; i++)
   {
        if (pMirrored_tx_portmask->bits[0]&(1<<i))
        {
            source_port = i;
            break;
        }

        if (pMirrored_rx_portmask->bits[0]&(1<<i))
        {
            source_port = i;
            break;
        }
    }

    if ((retVal = rtl8367b_setAsicPortMirror(source_port, mirroring_port)) != RT_ERR_OK)
        return retVal;
    if(pMirrored_rx_portmask->bits[0] != 0)
    {
        if ((retVal = rtl8367b_setAsicPortMirrorMask(pMirrored_rx_portmask->bits[0])) != RT_ERR_OK)
            return retVal;
    }
    else
    {
        if ((retVal = rtl8367b_setAsicPortMirrorMask(pMirrored_tx_portmask->bits[0])) != RT_ERR_OK)
            return retVal;
    }


    if (pMirrored_rx_portmask->bits[0])
        mirRx = ENABLED;
    else
        mirRx = DISABLED;

    if ((retVal = rtl8367b_setAsicPortMirrorRxFunction(mirRx)) != RT_ERR_OK)
        return retVal;

    if (pMirrored_tx_portmask->bits[0])
        mirTx = ENABLED;
    else
        mirTx = DISABLED;

    if ((retVal = rtl8367b_setAsicPortMirrorTxFunction(mirTx)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;

}

/* Function Name:
 *      rtk_mirror_portBased_get
 * Description:
 *      Get port mirror function.
 * Input:
 *      None
 * Output:
 *      pMirroring_port         - Monitor port.
 *      pMirrored_rx_portmask   - Rx mirror port mask.
 *      pMirrored_tx_portmask   - Tx mirror port mask.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API is to get mirror function of source port and mirror port.
 */
rtk_api_ret_t rtk_mirror_portBased_get(rtk_port_t* pMirroring_port, rtk_portmask_t *pMirrored_rx_portmask, rtk_portmask_t *pMirrored_tx_portmask)
{
    rtk_api_ret_t retVal;
    rtk_port_t source_port;
    rtk_enable_t mirRx, mirTx;
    rtk_portmask_t  src_portmask;

    if ((retVal = rtl8367b_getAsicPortMirror(&source_port, pMirroring_port)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPortMirrorRxFunction((rtk_uint32*)&mirRx)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPortMirrorTxFunction((rtk_uint32*)&mirTx)) != RT_ERR_OK)
        return retVal;

    if (DISABLED == mirRx)
        pMirrored_rx_portmask->bits[0]=0;
    else
    {
        pMirrored_rx_portmask->bits[0]=1<<source_port;

        if ((retVal = rtl8367b_getAsicPortMirrorMask(&(src_portmask.bits[0]))) != RT_ERR_OK)
            return retVal;

        pMirrored_rx_portmask->bits[0] |= src_portmask.bits[0];
    }

     if (DISABLED == mirTx)
        pMirrored_tx_portmask->bits[0]=0;
    else
    {
        pMirrored_tx_portmask->bits[0]=1<<source_port;

        if ((retVal = rtl8367b_getAsicPortMirrorMask(&(src_portmask.bits[0]))) != RT_ERR_OK)
            return retVal;

        pMirrored_tx_portmask->bits[0] |= src_portmask.bits[0];
    }

    return RT_ERR_OK;

}

/* Function Name:
 *      rtk_mirror_portIso_set
 * Description:
 *      Set mirror port isolation.
 * Input:
 *      enable |Mirror isolation status.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_ENABLE       - Invalid enable input
 * Note:
 *      The API is to set mirror isolation function that prevent normal forwarding packets to miror port.
 */
rtk_api_ret_t rtk_mirror_portIso_set(rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsicPortMirrorIsolation(enable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_mirror_portIso_get
 * Description:
 *      Get mirror port isolation.
 * Input:
 *      None
 * Output:
 *      pEnable |Mirror isolation status.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API is to get mirror isolation status.
 */
rtk_api_ret_t rtk_mirror_portIso_get(rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicPortMirrorIsolation(pEnable)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_stat_global_reset
 * Description:
 *      Reset global MIB counter.
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      Reset MIB counter of ports. API will use global reset while port mask is all-ports.
 */
rtk_api_ret_t rtk_stat_global_reset(void)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_setAsicMIBsCounterReset(TRUE,FALSE, 0)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_stat_port_reset
 * Description:
 *      Reset per port MIB counter by port.
 * Input:
 *      port - port id.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      Reset MIB counter of ports. API will use global reset while port mask is all-ports.
 */
rtk_api_ret_t rtk_stat_port_reset(rtk_port_t port)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_setAsicMIBsCounterReset(FALSE,FALSE,1<<port)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

#ifdef EMBEDDED_SUPPORT

#if 0
rtk_api_ret_t rtk_stat_global_get(rtk_stat_global_type_t cntr_idx, rtk_stat_counter_t *pCntrH, rtk_stat_counter_t *pCntrL)
{
    rtk_api_ret_t retVal;

    if (cntr_idx!=DOT1D_TP_LEARNED_ENTRY_DISCARDS_INDEX)
            return RT_ERR_STAT_INVALID_GLOBAL_CNTR;

    if ((retVal = rtl8370_getAsicMIBsCounter(0, cntr_idx, pCntrH, pCntrL)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}
#endif

#if 0
rtk_api_ret_t rtk_stat_port_get(rtk_port_t port, rtk_stat_port_type_t cntr_idx, rtk_stat_counter_t *pCntrH, rtk_stat_counter_t *pCntrL)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (cntr_idx>=STAT_PORT_CNTR_END)
        return RT_ERR_STAT_INVALID_PORT_CNTR;

    if ((retVal = rtl8370_getAsicMIBsCounter(port, cntr_idx, pCntrH, pCntrL)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}
#endif

#else

/* Function Name:
 *      rtk_stat_global_get
 * Description:
 *      Get global MIB counter
 * Input:
 *      cntr_idx - global counter index.
 * Output:
 *      pCntr - global counter value.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      Get global MIB counter by index definition.
 */
rtk_api_ret_t rtk_stat_global_get(rtk_stat_global_type_t cntr_idx, rtk_stat_counter_t *pCntr)
{
    rtk_api_ret_t retVal;

    if (cntr_idx!=DOT1D_TP_LEARNED_ENTRY_DISCARDS_INDEX)
        return RT_ERR_STAT_INVALID_GLOBAL_CNTR;

    if ((retVal = rtl8367b_getAsicMIBsCounter(0, cntr_idx, pCntr)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_stat_global_getAll
 * Description:
 *      Get all global MIB counter
 * Input:
 *      None
 * Output:
 *      pGlobal_cntrs - global counter structure.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      Get all global MIB counter by index definition.
 */
rtk_api_ret_t rtk_stat_global_getAll(rtk_stat_global_cntr_t *pGlobal_cntrs)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicMIBsCounter(0,DOT1D_TP_LEARNED_ENTRY_DISCARDS_INDEX, &pGlobal_cntrs->dot1dTpLearnedEntryDiscards)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

#define MIB_NOT_SUPPORT     (0xFFFF)
static rtk_api_ret_t _get_asic_mib_idx(rtk_stat_port_type_t cnt_idx, RTL8367B_MIBCOUNTER *pMib_idx)
{
    RTL8367B_MIBCOUNTER mib_asic_idx[STAT_PORT_CNTR_END]=
    {
        ifInOctets,                     /* STAT_IfInOctets */
        dot3StatsFCSErrors,             /* STAT_Dot3StatsFCSErrors */
        dot3StatsSymbolErrors,          /* STAT_Dot3StatsSymbolErrors */
        dot3InPauseFrames,              /* STAT_Dot3InPauseFrames */
        dot3ControlInUnknownOpcodes,    /* STAT_Dot3ControlInUnknownOpcodes */
        etherStatsFragments,            /* STAT_EtherStatsFragments */
        etherStatsJabbers,              /* STAT_EtherStatsJabbers */
        ifInUcastPkts,                  /* STAT_IfInUcastPkts */
        etherStatsDropEvents,           /* STAT_EtherStatsDropEvents */
        etherStatsOctets,               /* STAT_EtherStatsOctets */
        etherStatsUnderSizePkts,        /* STAT_EtherStatsUnderSizePkts */
        etherOversizeStats,             /* STAT_EtherOversizeStats */
        etherStatsPkts64Octets,         /* STAT_EtherStatsPkts64Octets */
        etherStatsPkts65to127Octets,    /* STAT_EtherStatsPkts65to127Octets */
        etherStatsPkts128to255Octets,   /* STAT_EtherStatsPkts128to255Octets */
        etherStatsPkts256to511Octets,   /* STAT_EtherStatsPkts256to511Octets */
        etherStatsPkts512to1023Octets,  /* STAT_EtherStatsPkts512to1023Octets */
        etherStatsPkts1024to1518Octets, /* STAT_EtherStatsPkts1024to1518Octets */
        ifInMulticastPkts,              /* STAT_EtherStatsMulticastPkts */
        ifInBroadcastPkts,              /* STAT_EtherStatsBroadcastPkts */
        ifOutOctets,                    /* STAT_IfOutOctets */
        dot3StatsSingleCollisionFrames, /* STAT_Dot3StatsSingleCollisionFrames */
        dot3StatMultipleCollisionFrames,/* STAT_Dot3StatsMultipleCollisionFrames */
        dot3sDeferredTransmissions,     /* STAT_Dot3StatsDeferredTransmissions */
        dot3StatsLateCollisions,        /* STAT_Dot3StatsLateCollisions */
        etherStatsCollisions,           /* STAT_EtherStatsCollisions */
        dot3StatsExcessiveCollisions,   /* STAT_Dot3StatsExcessiveCollisions */
        dot3OutPauseFrames,             /* STAT_Dot3OutPauseFrames */
        MIB_NOT_SUPPORT,                /* STAT_Dot1dBasePortDelayExceededDiscards */
        dot1dTpPortInDiscards,          /* STAT_Dot1dTpPortInDiscards */
        ifOutUcastPkts,                 /* STAT_IfOutUcastPkts */
        ifOutMulticastPkts,             /* STAT_IfOutMulticastPkts */
        ifOutBroadcastPkts,             /* STAT_IfOutBroadcastPkts */
        outOampduPkts,                  /* STAT_OutOampduPkts */
        inOampduPkts,                   /* STAT_InOampduPkts */
        MIB_NOT_SUPPORT,                /* STAT_PktgenPkts */
        inMldChecksumError,             /* STAT_InMldChecksumError */
        inIgmpChecksumError,            /* STAT_InIgmpChecksumError */
        inMldSpecificQuery,             /* STAT_InMldSpecificQuery */
        inMldGeneralQuery,              /* STAT_InMldGeneralQuery */
        inIgmpSpecificQuery,            /* STAT_InIgmpSpecificQuery */
        inIgmpGeneralQuery,             /* STAT_InIgmpGeneralQuery */
        inMldLeaves,                    /* STAT_InMldLeaves */
        inIgmpLeaves,          			/* STAT_InIgmpInterfaceLeaves */
        inIgmpJoinsSuccess,             /* STAT_InIgmpJoinsSuccess */
        inIgmpJoinsFail,                /* STAT_InIgmpJoinsFail */
        inMldJoinsSuccess,              /* STAT_InMldJoinsSuccess */
        inMldJoinsFail,                 /* STAT_InMldJoinsFail */
        inReportSuppressionDrop,        /* STAT_InReportSuppressionDrop */
        inLeaveSuppressionDrop,         /* STAT_InLeaveSuppressionDrop */
        outIgmpReports,                 /* STAT_OutIgmpReports */
        outIgmpLeaves,                  /* STAT_OutIgmpLeaves */
        outIgmpGeneralQuery,            /* STAT_OutIgmpGeneralQuery */
        outIgmpSpecificQuery,           /* STAT_OutIgmpSpecificQuery */
        outMldReports,                  /* STAT_OutMldReports */
        outMldLeaves,                   /* STAT_OutMldLeaves */
        outMldGeneralQuery,             /* STAT_OutMldGeneralQuery */
        outMldSpecificQuery,            /* STAT_OutMldSpecificQuery */
        inKnownMulticastPkts,           /* STAT_InKnownMulticastPkts */
        ifInMulticastPkts,              /* STAT_IfInMulticastPkts */
        ifInBroadcastPkts,              /* STAT_IfInBroadcastPkts */
    };

    if(cnt_idx >= STAT_PORT_CNTR_END)
        return RT_ERR_STAT_INVALID_PORT_CNTR;

    if(mib_asic_idx[cnt_idx] == MIB_NOT_SUPPORT)
        return RT_ERR_CHIP_NOT_SUPPORTED;

    *pMib_idx = mib_asic_idx[cnt_idx];
    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_stat_port_get
 * Description:
 *      Get per port MIB counter by index
 * Input:
 *      port        - port id.
 *      cntr_idx    - port counter index.
 * Output:
 *      pCntr - MIB retrived counter.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      Get per port MIB counter by index definition.
 */
rtk_api_ret_t rtk_stat_port_get(rtk_port_t port, rtk_stat_port_type_t cntr_idx, rtk_stat_counter_t *pCntr)
{
    rtk_api_ret_t       retVal;
    RTL8367B_MIBCOUNTER mib_idx;
    rtk_stat_counter_t  second_cnt;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (cntr_idx>=STAT_PORT_CNTR_END)
        return RT_ERR_STAT_INVALID_PORT_CNTR;

    if((retVal = _get_asic_mib_idx(cntr_idx, &mib_idx)) != RT_ERR_OK)
        return retVal;

    if(mib_idx == MIB_NOT_SUPPORT)
        return RT_ERR_CHIP_NOT_SUPPORTED;

    if ((retVal = rtl8367b_getAsicMIBsCounter(port, mib_idx, pCntr)) != RT_ERR_OK)
        return retVal;

    if(cntr_idx == STAT_EtherStatsMulticastPkts)
    {
        if((retVal = _get_asic_mib_idx(STAT_IfOutMulticastPkts, &mib_idx)) != RT_ERR_OK)
            return retVal;

        if((retVal = rtl8367b_getAsicMIBsCounter(port, mib_idx, &second_cnt)) != RT_ERR_OK)
            return retVal;

        *pCntr += second_cnt;
    }

    if(cntr_idx == STAT_EtherStatsBroadcastPkts)
    {
        if((retVal = _get_asic_mib_idx(STAT_IfOutBroadcastPkts, &mib_idx)) != RT_ERR_OK)
            return retVal;

        if((retVal = rtl8367b_getAsicMIBsCounter(port, mib_idx, &second_cnt)) != RT_ERR_OK)
            return retVal;

        *pCntr += second_cnt;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_stat_port_getAll
 * Description:
 *      Get all counters of one specified port in the specified device.
 * Input:
 *      port - port id.
 * Output:
 *      pPort_cntrs - buffer pointer of counter value.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      Get all MIB counters of one port.
 */
rtk_api_ret_t rtk_stat_port_getAll(rtk_port_t port, rtk_stat_port_cntr_t *pPort_cntrs)
{
    rtk_api_ret_t retVal;
    rtk_uint32 mibIndex;
    rtk_uint64 mibCounter;
    rtk_uint32 *accessPtr;
    /* address offset to MIBs counter */
    CONST_T rtk_uint16 mibLength[STAT_PORT_CNTR_END]= {
        2,1,1,1,1,1,1,1,1,
        2,1,1,1,1,1,1,1,1,1,1,
        2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    accessPtr = (rtk_uint32*)pPort_cntrs;
    for (mibIndex=0;mibIndex<STAT_PORT_CNTR_END;mibIndex++)
    {
        if ((retVal = rtk_stat_port_get(port, mibIndex, &mibCounter)) != RT_ERR_OK)
        {
            if (retVal == RT_ERR_CHIP_NOT_SUPPORTED)
                mibCounter = 0;
            else
                return retVal;
        }

        if (2 == mibLength[mibIndex])
            *(rtk_uint64*)accessPtr = mibCounter;
        else if (1 == mibLength[mibIndex])
            *accessPtr = mibCounter;
        else
            return RT_ERR_FAILED;

        accessPtr+=mibLength[mibIndex];
    }

    return RT_ERR_OK;
}

#endif

/* Function Name:
 *      rtk_stat_logging_counterCfg_set
 * Description:
 *      Set the type and mode of Logging Counter
 * Input:
 *      idx     - The index of Logging Counter. Should be even number only.(0,2,4,6,8.....30)
 *      mode    - 32 bits or 64 bits mode
 *      type    - Packet counter or byte counter
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_OUT_OF_RANGE - Out of range.
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      Set the type and mode of Logging Counter.
 */
rtk_api_ret_t rtk_stat_logging_counterCfg_set(rtk_uint32 idx, rtk_logging_counter_mode_t mode, rtk_logging_counter_type_t type)
{
    rtk_api_ret_t retVal;

    if(idx > RTL8367B_MIB_MAX_LOG_CNT_IDX)
        return RT_ERR_OUT_OF_RANGE;

    if((idx % 2) == 1)
        return RT_ERR_INPUT;

    if(mode >= LOGGING_MODE_END)
        return RT_ERR_OUT_OF_RANGE;

    if(type >= LOGGING_TYPE_END)
        return RT_ERR_OUT_OF_RANGE;

    if((retVal = rtl8367b_setAsicMIBsLoggingType((idx / 2), (rtk_uint32)type)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_setAsicMIBsLoggingMode((idx / 2), (rtk_uint32)mode)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_stat_logging_counterCfg_get
 * Description:
 *      Get the type and mode of Logging Counter
 * Input:
 *      idx     - The index of Logging Counter. Should be even number only.(0,2,4,6,8.....30)
 * Output:
 *      pMode   - 32 bits or 64 bits mode
 *      pType   - Packet counter or byte counter
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_OUT_OF_RANGE - Out of range.
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_NULL_POINTER - NULL Pointer
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      Get the type and mode of Logging Counter.
 */
rtk_api_ret_t rtk_stat_logging_counterCfg_get(rtk_uint32 idx, rtk_logging_counter_mode_t *pMode, rtk_logging_counter_type_t *pType)
{
    rtk_api_ret_t   retVal;
    rtk_uint32      type, mode;

    if(idx > RTL8367B_MIB_MAX_LOG_CNT_IDX)
        return RT_ERR_OUT_OF_RANGE;

    if((idx % 2) == 1)
        return RT_ERR_INPUT;

    if(pMode == NULL)
        return RT_ERR_NULL_POINTER;

    if(pType == NULL)
        return RT_ERR_NULL_POINTER;

    if((retVal = rtl8367b_getAsicMIBsLoggingType((idx / 2), &type)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicMIBsLoggingMode((idx / 2), &mode)) != RT_ERR_OK)
        return retVal;

    *pMode = (rtk_logging_counter_mode_t)mode;
    *pType = (rtk_logging_counter_type_t)type;

    return RT_ERR_OK;
}


/* Function Name:
 *      rtk_stat_logging_counter_reset
 * Description:
 *      Reset Logging Counter
 * Input:
 *      idx     - The index of Logging Counter. (0~31)
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_OUT_OF_RANGE - Out of range.
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      Reset Logging Counter.
 */
rtk_api_ret_t rtk_stat_logging_counter_reset(rtk_uint32 idx)
{
    rtk_api_ret_t   retVal;

    if(idx > RTL8367B_MIB_MAX_LOG_CNT_IDX)
        return RT_ERR_OUT_OF_RANGE;

    if((retVal = rtl8367b_setAsicMIBsResetLoggingCounter(idx)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_stat_logging_counter_get
 * Description:
 *      Get Logging Counter
 * Input:
 *      idx     - The index of Logging Counter. (0~31)
 * Output:
 *      pCnt    - Logging counter value
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_OUT_OF_RANGE - Out of range.
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      Get Logging Counter.
 */
rtk_api_ret_t rtk_stat_logging_counter_get(rtk_uint32 idx, rtk_uint32 *pCnt)
{
    rtk_api_ret_t   retVal;

    if(idx > RTL8367B_MIB_MAX_LOG_CNT_IDX)
        return RT_ERR_OUT_OF_RANGE;

    if((retVal = rtl8367b_getAsicMIBsLogCounter(idx, pCnt)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_int_polarity_set
 * Description:
 *      Set interrupt polarity configuration.
 * Input:
 *      type - Interruptpolarity type.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can set interrupt polarity configuration.
 */
rtk_api_ret_t rtk_int_polarity_set(rtk_int_polarity_t type)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_setAsicInterruptPolarity(type)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_int_polarity_get
 * Description:
 *      Get interrupt polarity configuration.
 * Input:
 *      None
 * Output:
 *      pType - Interruptpolarity type.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      The API can get interrupt polarity configuration.
 */
rtk_api_ret_t rtk_int_polarity_get(rtk_int_polarity_t *pType)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicInterruptPolarity(pType)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_int_control_set
 * Description:
 *      Set interrupt trigger status configuration.
 * Input:
 *      type - Interrupt type.
 *      enable - Interrupt status.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 *      RT_ERR_ENABLE 		- Invalid enable input.
 * Note:
 *      The API can set interrupt status configuration.
 *      The interrupt trigger status is shown in the following:
 *      - INT_TYPE_LINK_STATUS
 *      - INT_TYPE_METER_EXCEED
 *      - INT_TYPE_LEARN_LIMIT
 *      - INT_TYPE_LINK_SPEED
 *      - INT_TYPE_CONGEST
 *      - INT_TYPE_GREEN_FEATURE
 *      - INT_TYPE_LOOP_DETECT
 *      - INT_TYPE_8051,
 *      - INT_TYPE_CABLE_DIAG,
 *      - INT_TYPE_ACL,
 *      - INT_TYPE_UPS,
 *      - INT_TYPE_SLIENT
 */
rtk_api_ret_t rtk_int_control_set(rtk_int_type_t type, rtk_enable_t enable)
{
    rtk_api_ret_t retVal;
    rtk_uint32 mask;

    if (type>=INT_TYPE_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_getAsicInterruptMask(&mask)) != RT_ERR_OK)
        return retVal;

    if (ENABLED == enable)
        mask = mask | (1<<type);
    else if (DISABLED == enable)
        mask = mask & ~(1<<type);
    else
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicInterruptMask(mask)) != RT_ERR_OK)
        return retVal;


    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_int_control_get
 * Description:
 *      Get interrupt trigger status configuration.
 * Input:
 *      type - Interrupt type.
 * Output:
 *      pEnable - Interrupt status.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can get interrupt status configuration.
 *      The interrupt trigger status is shown in the following:
 *      - INT_TYPE_LINK_STATUS
 *      - INT_TYPE_METER_EXCEED
 *      - INT_TYPE_LEARN_LIMIT
 *      - INT_TYPE_LINK_SPEED
 *      - INT_TYPE_CONGEST
 *      - INT_TYPE_GREEN_FEATURE
 *      - INT_TYPE_LOOP_DETECT
 *      - INT_TYPE_8051,
 *      - INT_TYPE_CABLE_DIAG,
 *      - INT_TYPE_ACL,
 *      - INT_TYPE_UPS,
 *      - INT_TYPE_SLIENT
 */
rtk_api_ret_t rtk_int_control_get(rtk_int_type_t type, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;
    rtk_uint32 mask;

    if ((retVal = rtl8367b_getAsicInterruptMask(&mask)) != RT_ERR_OK)
        return retVal;

    if (0 == (mask&(1<<type)))
        *pEnable=DISABLED;
    else
        *pEnable=ENABLED;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_int_status_set
 * Description:
 *      Set interrupt trigger status to clean.
 * Input:
 *      None
 * Output:
 *      pStatusMask - Interrupt status bit mask.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_INPUT - Invalid input parameters.
 * Note:
 *      The API can clean interrupt trigger status when interrupt happened.
 *      The interrupt trigger status is shown in the following:
 *      - INT_TYPE_LINK_STATUS    (value[0] (Bit0))
 *      - INT_TYPE_METER_EXCEED   (value[0] (Bit1))
 *      - INT_TYPE_LEARN_LIMIT    (value[0] (Bit2))
 *      - INT_TYPE_LINK_SPEED     (value[0] (Bit3))
 *      - INT_TYPE_CONGEST        (value[0] (Bit4))
 *      - INT_TYPE_GREEN_FEATURE  (value[0] (Bit5))
 *      - INT_TYPE_LOOP_DETECT    (value[0] (Bit6))
 *      - INT_TYPE_8051           (value[0] (Bit7))
 *      - INT_TYPE_CABLE_DIAG     (value[1] (Bit0))
 *      - INT_TYPE_ACL            (value[1] (Bit1))
 *      - INT_TYPE_UPS            (value[1] (Bit2))
 *      - INT_TYPE_SLIENT         (value[1] (Bit3))
 *      The status will be cleared after execute this API.
 */
rtk_api_ret_t rtk_int_status_set(rtk_int_status_t statusMask)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_setAsicInterruptStatus((rtk_uint32)((statusMask.value[1] << 8) | statusMask.value[0])))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_int_status_get
 * Description:
 *      Get interrupt trigger status.
 * Input:
 *      None
 * Output:
 *      pStatusMask - Interrupt status bit mask.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can get interrupt trigger status when interrupt happened.
 *      The interrupt trigger status is shown in the following:
 *      - INT_TYPE_LINK_STATUS    (value[0] (Bit0))
 *      - INT_TYPE_METER_EXCEED   (value[0] (Bit1))
 *      - INT_TYPE_LEARN_LIMIT    (value[0] (Bit2))
 *      - INT_TYPE_LINK_SPEED     (value[0] (Bit3))
 *      - INT_TYPE_CONGEST        (value[0] (Bit4))
 *      - INT_TYPE_GREEN_FEATURE  (value[0] (Bit5))
 *      - INT_TYPE_LOOP_DETECT    (value[0] (Bit6))
 *      - INT_TYPE_8051           (value[0] (Bit7))
 *      - INT_TYPE_CABLE_DIAG     (value[1] (Bit0))
 *      - INT_TYPE_ACL            (value[1] (Bit1))
 *      - INT_TYPE_UPS            (value[1] (Bit2))
 *      - INT_TYPE_SLIENT         (value[1] (Bit3))
 *
 */
rtk_api_ret_t rtk_int_status_get(rtk_int_status_t* pStatusMask)
{
    rtk_api_ret_t   retVal;
    rtk_uint32          ims_mask;

    if ((retVal = rtl8367b_getAsicInterruptStatus(&ims_mask)) != RT_ERR_OK)
        return retVal;

    pStatusMask->value[0] = (ims_mask & 0x000000FF);
    pStatusMask->value[1] = ((ims_mask & 0x0000FF00) >> 8);

    return RT_ERR_OK;
}

#define ADV_NOT_SUPPORT (0xFFFF)
static rtk_api_ret_t _rtk_int_Advidx_get(rtk_int_advType_t adv_type, rtk_uint32 *pAsic_idx)
{
    rtk_uint32 asic_idx[ADV_END] =
    {
        INTRST_L2_LEARN,
        INTRST_SPEED_CHANGE,
        INTRST_SPECIAL_CONGESTION,
        INTRST_PORT_LINKDOWN,
        INTRST_PORT_LINKUP,
        INTRST_METER0_15,
        INTRST_METER16_31,
        ADV_NOT_SUPPORT,
        ADV_NOT_SUPPORT,
        INTRST_RLDP_LOOPED,
        INTRST_RLDP_RELEASED,
    };

    if(adv_type >= ADV_END)
        return RT_ERR_INPUT;

    if(asic_idx[adv_type] == ADV_NOT_SUPPORT)
        return RT_ERR_CHIP_NOT_SUPPORTED;

    *pAsic_idx = asic_idx[adv_type];
    return RT_ERR_OK;
}
/* Function Name:
 *      rtk_int_advanceInfo_get
 * Description:
 *      Get interrupt advanced information.
 * Input:
 *      adv_type - Advanced interrupt type.
 * Output:
 *      info - Information per type.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This API can get advanced information when interrupt happened.
 *      The status will be cleared after execute this API.
 */
rtk_api_ret_t rtk_int_advanceInfo_get(rtk_int_advType_t adv_type, rtk_int_info_t* info)
{
    rtk_api_ret_t   retVal;
    rtk_uint32          asic_idx;

    if(adv_type >= ADV_END)
        return RT_ERR_INPUT;

    if((retVal = _rtk_int_Advidx_get(adv_type, &asic_idx)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicInterruptRelatedStatus(asic_idx, info)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_setAsicInterruptRelatedStatus(asic_idx, 0xFFFF)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_enable_set
 * Description:
 *      Set Led enable congiuration
 * Input:
 *      group       - LED group id.
 *      portmask    - LED enable port mask.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can be used to enable LED per port per group.
 */
rtk_api_ret_t rtk_led_enable_set(rtk_led_group_t group, rtk_portmask_t portmask)
{
    rtk_api_ret_t retVal;

    if (group >= LED_GROUP_END)
        return RT_ERR_INPUT;

    if (portmask.bits[0] >= (1 << (RTK_PHY_ID_MAX + 1)))
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicLedGroupEnable(group, portmask.bits[0])) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_enable_get
 * Description:
 *      Get Led enable congiuration
 * Input:
 *      group - LED group id.
 * Output:
 *      pPortmask - LED enable port mask.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can be used to get LED enable status.
 */
rtk_api_ret_t rtk_led_enable_get(rtk_led_group_t group, rtk_portmask_t *pPortmask)
{
    rtk_api_ret_t retVal;

    if (group >= LED_GROUP_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_getAsicLedGroupEnable(group, &(pPortmask->bits[0]))) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;

}

/* Function Name:
 *      rtk_led_operation_set
 * Description:
 *      Set Led operation mode
 * Input:
 *      mode - LED operation mode.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can set Led operation mode.
 *      The modes that can be set are as following:
 *      - LED_OP_SCAN,
 *      - LED_OP_PARALLEL,
 *      - LED_OP_SERIAL,
 */
rtk_api_ret_t rtk_led_operation_set(rtk_led_operation_t mode)
{
    rtk_api_ret_t retVal;
    rtk_uint32 regData;

    if ( mode >= LED_OP_END)
      return RT_ERR_INPUT;

    if ( mode == LED_OP_SCAN)
      return RT_ERR_CHIP_NOT_SUPPORTED;

    switch (mode)
    {
        case LED_OP_PARALLEL:
            regData = LEDOP_PARALLEL;
            break;
        case LED_OP_SERIAL:
            regData = LEDOP_SERIAL;
            break;
        default:
            regData = 0;
            break;
    }

    if ((retVal = rtl8367b_setAsicLedOperationMode(regData)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_operation_get
 * Description:
 *      Get Led operation mode
 * Input:
 *      None
 * Output:
 *      pMode - Support LED operation mode.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can get Led operation mode.
 *      The modes that can be set are as following:
 *      - LED_OP_SCAN,
 *      - LED_OP_PARALLEL,
 *      - LED_OP_SERIAL,
 */
rtk_api_ret_t rtk_led_operation_get(rtk_led_operation_t *pMode)
{
    rtk_api_ret_t retVal;
    rtk_uint32 regData;

    if ((retVal = rtl8367b_getAsicLedOperationMode(&regData)) != RT_ERR_OK)
        return retVal;

    if (regData == LEDOP_SERIAL)
        *pMode = LED_OP_SERIAL;
    else if (regData ==LEDOP_PARALLEL)
        *pMode = LED_OP_PARALLEL;
    else
       return RT_ERR_FAILED;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_mode_set
 * Description:
 *      Set Led to congiuration mode
 * Input:
 *      mode - Support LED mode.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      There are three LED groups for each port for indicating information about dedicated port.
 *      LED groups are set to indicate different information of port in different mode.
 *
 *      (0) Mode0
 *          - LED0-Link, Activity Indicator. Low for link established. Link/Act Blinks every 43ms when the corresponding port is transmitting or receiving.
 *          - LED1-1000Mb/s Speed Indicator. Low for 1000Mb/s.
 *          - LED2-100Mb/s Speed Indicator. Low for 100Mb/s.
 *
 *      (1) Mode1
 *          - LED0-1000Mb/s Speed/Activity Indicator. Low for 1000Mb/s. Blinks every 43ms when the corresponding port is transmitting or receiving.
 *          - LED1-100Mb/s Speed/Activity Indicator. Low for 100Mb/s. Blinks every 43ms when the corresponding port is transmitting or receiving.
 *          - LED2-10Mb/s Speed/Activity Indicator. Low for 10Mb/s. Blinks every 43ms when the corresponding port is transmitting or receiving.
 *
 *      (2) Mode2
 *          - LED0-Collision, Full duplex Indicator. Blinking every 43ms when collision happens. Low for full duplex, and high for half duplex mode.
 *          - LED1-1000Mb/s Speed/Activity Indicator. Low for 1000Mb/s. Blinks every 43ms when the corresponding port is transmitting or receiving.
 *          - LED2-10/100Mb/s Speed/Activity Indicator. Low for 10/100Mb/s. Blinks every 43ms when the corresponding port is transmitting or receiving.
 *
 *      (3) Mode3
 *          - LED0-10Mb/s Speed/Activity Indicator. Low for 10Mb/s. Blinks every 43ms when the corresponding port is transmitting or receiving.
 *          - LED1-1000Mb/s Speed/Activity Indicator. Low for 1000Mb/s. Blinks every 43ms when the corresponding port is transmitting or receiving.
 *          - LED2-100Mb/s Speed/Activity Indicator. Low for 100Mb/s. Blinks every 43ms when the corresponding port is transmitting or receiving.
 */

rtk_api_ret_t rtk_led_mode_set(rtk_led_mode_t mode)
{
    rtk_api_ret_t retVal;

    if (mode >= LED_MODE_END)
        return RT_ERR_FAILED;

    if ((retVal = rtl8367b_setAsicLedGroupMode(mode)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_mode_get
 * Description:
 *      Get Led to congiuration mode
 * Input:
 *      None
 * Output:
 *      pMode - Support LED mode.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      There are three LED groups for each port for indicating information about dedicated port.
 *      LED groups is set to indicate different information of port in different mode.
 */
rtk_api_ret_t rtk_led_mode_get(rtk_led_mode_t *pMode)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicLedGroupMode(pMode)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;

}

/* Function Name:
 *      rtk_led_modeForce_set
 * Description:
 *      Set Led group to congiuration force mode
 * Input:
 *      group   - Support LED group id.
 *      mode    - Support LED force mode.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can force all Leds in the same group to one force mode.
 *      The force modes that can be set are as following:
 *      - LED_FORCE_NORMAL,
 *      - LED_FORCE_BLINK,
 *      - LED_FORCE_OFF,
 *      - LED_FORCE_ON.
 */
rtk_api_ret_t rtk_led_modeForce_set(rtk_led_group_t group, rtk_led_force_mode_t mode)
{
    rtk_api_ret_t retVal;
    rtk_uint32 port;

    if (group >= LED_GROUP_END)
        return RT_ERR_INPUT;

    if (mode >= LED_FORCE_END)
        return RT_ERR_NOT_ALLOWED;

    for(port = 0; port <= RTK_PORT_ID_MAX; port++)
    {
        if ((retVal = rtl8367b_setAsicForceLed(port, group, mode)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_modeForce_get
 * Description:
 *      Get Led group to congiuration force mode
 * Input:
 *      group - Support LED group id.
 *      pMode - Support LED force mode.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can get forced Led group mode.
 *      The force modes that can be set are as following:
 *      - LED_FORCE_NORMAL,
 *      - LED_FORCE_BLINK,
 *      - LED_FORCE_OFF,
 *      - LED_FORCE_ON.
 */
rtk_api_ret_t rtk_led_modeForce_get(rtk_led_group_t group, rtk_led_force_mode_t *pMode)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicForceLed(0, group, pMode)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_blinkRate_set
 * Description:
 *      Set LED blinking rate
 * Input:
 *      blinkRate - blinking rate.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      ASIC support 6 types of LED blinking rates at 43ms, 84ms, 120ms, 170ms, 340ms and 670ms.
 */
rtk_api_ret_t rtk_led_blinkRate_set(rtk_led_blink_rate_t blinkRate)
{
    rtk_api_ret_t retVal;

    if ((enum RTL8367B_LEDBLINKRATE)blinkRate >= LEDBLINKRATE_END)
        return RT_ERR_FAILED;

    if ((retVal = rtl8367b_setAsicLedBlinkRate(blinkRate)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_blinkRate_get
 * Description:
 *      Get LED blinking rate at mode 0 to mode 3
 * Input:
 *      None
 * Output:
 *      pBlinkRate - blinking rate.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      There are  6 types of LED blinking rates at 43ms, 84ms, 120ms, 170ms, 340ms and 670ms.
 */
rtk_api_ret_t rtk_led_blinkRate_get(rtk_led_blink_rate_t *pBlinkRate)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicLedBlinkRate(pBlinkRate)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_groupConfig_set
 * Description:
 *      Set per group Led to congiuration mode
 * Input:
 *      group   - LED group.
 *      config  - LED configuration
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can set LED indicated information configuration for each LED group with 1 to 1 led mapping to each port.
 *      - Definition  LED Statuses      Description
 *      - 0000        LED_Off           LED pin Tri-State.
 *      - 0001        Dup/Col           Collision, Full duplex Indicator.
 *      - 0010        Link/Act          Link, Activity Indicator.
 *      - 0011        Spd1000           1000Mb/s Speed Indicator.
 *      - 0100        Spd100            100Mb/s Speed Indicator.
 *      - 0101        Spd10             10Mb/s Speed Indicator.
 *      - 0110        Spd1000/Act       1000Mb/s Speed/Activity Indicator.
 *      - 0111        Spd100/Act        100Mb/s Speed/Activity Indicator.
 *      - 1000        Spd10/Act         10Mb/s Speed/Activity Indicator.
 *      - 1001        Spd100 (10)/Act   10/100Mb/s Speed/Activity Indicator.
 *      - 1010        LoopDetect        LoopDetect Indicator.
 *      - 1011        EEE               EEE Indicator.
 *      - 1100        Link/Rx           Link, Activity Indicator.
 *      - 1101        Link/Tx           Link, Activity Indicator.
 *      - 1110        Master            Link on Master Indicator.
 *      - 1111        Act               Activity Indicator. Low for link established.
 */
rtk_api_ret_t rtk_led_groupConfig_set(rtk_led_group_t group, rtk_led_congig_t config)
{
    rtk_api_ret_t retVal;

    if (LED_GROUP_END <= group)
        return RT_ERR_FAILED;

    if (LED_CONFIG_END <= config)
        return RT_ERR_FAILED;

    if ((retVal = rtl8367b_setAsicLedIndicateInfoConfig(group, config)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_groupConfig_get
 * Description:
 *      Get Led group congiuration mode
 * Input:
 *      group - LED group.
 * Output:
 *      pConfig - LED configuration.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *       The API can get LED indicated information configuration for each LED group.
 */
rtk_api_ret_t rtk_led_groupConfig_get(rtk_led_group_t group, rtk_led_congig_t *pConfig)
{
    rtk_api_ret_t retVal;

    if (LED_GROUP_END <= group)
        return RT_ERR_FAILED;

    if ((retVal = rtl8367b_getAsicLedIndicateInfoConfig(group, pConfig)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_serialMode_set
 * Description:
 *      Set Led serial mode active congiuration
 * Input:
 *      active - LED group.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can set LED serial mode active congiuration.
 */
rtk_api_ret_t rtk_led_serialMode_set(rtk_led_active_t active)
{
    rtk_api_ret_t retVal;

    if ( active >= LED_ACTIVE_END)
        return RT_ERR_INPUT;

     if ((retVal = rtl8367b_setAsicLedSerialModeConfig(active,1))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_led_serialMode_get
 * Description:
 *      Get Led group congiuration mode
 * Input:
 *      group - LED group.
 * Output:
 *      pConfig - LED configuration.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *       The API can get LED serial mode active configuration.
 */
rtk_api_ret_t rtk_led_serialMode_get(rtk_led_active_t *pActive)
{
    rtk_api_ret_t retVal;
    rtk_uint32 regData;

    if ((retVal = rtl8367b_getAsicLedSerialModeConfig(pActive,&regData))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_init
 * Description:
 *      ACL initialization function
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_NULL_POINTER - Pointer pFilter_field or pFilter_cfg point to NULL.
 * Note:
 *      This function enable and intialize ACL function
 */
rtk_api_ret_t rtk_filter_igrAcl_init(void)
{
    rtl8367b_acltemplate_t       aclTemp;
    rtk_uint32                 i, j;
    rtk_api_ret_t          ret;

    if ((ret = rtk_filter_igrAcl_cfg_delAll()) != RT_ERR_OK)
        return ret;

    for(i = 0; i < RTL8367B_ACLTEMPLATENO; i++)
    {
        for(j = 0; j < RTL8367B_ACLRULEFIELDNO;j++)
            aclTemp.field[j] = filter_templateField[i][j];

        if ((ret = rtl8367b_setAsicAclTemplate(i, &aclTemp)) != RT_ERR_OK)
            return ret;
    }

    for(i = 0; i < RTL8367B_FIELDSEL_FORMAT_NUMBER; i++)
    {
        if ((ret = rtl8367b_setAsicFieldSelector(i, field_selector[i][0], field_selector[i][1])) != RT_ERR_OK)
            return ret;
    }

    for(i=0; i < RTL8367B_PORTNO; i++)
    {
        if ((ret = rtl8367b_setAsicAcl(i, TRUE)) != RT_ERR_OK)
            return ret;

        if ((ret = rtl8367b_setAsicAclUnmatchedPermit(i, TRUE)) != RT_ERR_OK)
            return ret;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_field_add
 * Description:
 *      Add comparison rule to an ACL configuration
 * Input:
 *      pFilter_cfg     - The ACL configuration that this function will add comparison rule
 *      pFilter_field   - The comparison rule that will be added.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_NULL_POINTER    	- Pointer pFilter_field or pFilter_cfg point to NULL.
 *      RT_ERR_INPUT 			- Invalid input parameters.
 * Note:
 *      This function add a comparison rule (*pFilter_field) to an ACL configuration (*pFilter_cfg).
 *      Pointer pFilter_cfg points to an ACL configuration structure, this structure keeps multiple ACL
 *      comparison rules by means of linked list. Pointer pFilter_field will be added to linked
 *      list keeped by structure that pFilter_cfg points to.
 */
rtk_api_ret_t rtk_filter_igrAcl_field_add(rtk_filter_cfg_t* pFilter_cfg, rtk_filter_field_t* pFilter_field)
{
	rtk_uint32 i;
	rtk_filter_field_t *tailPtr;

    if(NULL == pFilter_cfg || NULL == pFilter_field)
        return RT_ERR_NULL_POINTER;

    if(pFilter_field->fieldType >= FILTER_FIELD_END)
        return RT_ERR_ENTRY_INDEX;

	if(0 == pFilter_field->fieldTemplateNo)
	{
		pFilter_field->fieldTemplateNo = filter_fieldSize[pFilter_field->fieldType];

		for(i = 0; i < pFilter_field->fieldTemplateNo; i++)
		{
			pFilter_field->fieldTemplateIdx[i] = filter_fieldTemplateIndex[pFilter_field->fieldType][i];
		}
	}

    if(NULL == pFilter_cfg->fieldHead)
    {
        pFilter_cfg->fieldHead = pFilter_field;
    }
    else
    {
        if (pFilter_cfg->fieldHead->next == NULL)
        {
            pFilter_cfg->fieldHead->next = pFilter_field;
        }
        else
        {
            tailPtr = pFilter_cfg->fieldHead->next;
            while( tailPtr->next != NULL)
            {
                tailPtr = tailPtr->next;
            }
            tailPtr->next = pFilter_field;
        }
    }

    return RT_ERR_OK;
}

static rtk_api_ret_t _rtk_filter_igrAcl_writeDataField(rtl8367b_aclrule *aclRule, rtk_filter_field_t *fieldPtr)
{
    rtk_uint32 i, tempIdx,fieldIdx, ipValue, ipMask;
    rtk_uint32 ip6addr[RTK_IPV6_ADDR_WORD_LENGTH];
    rtk_uint32 ip6mask[RTK_IPV6_ADDR_WORD_LENGTH];

	for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
	{
		tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;

		aclRule[tempIdx].valid = TRUE;
	}

    switch (fieldPtr->fieldType)
    {
    /* use DMAC structure as representative for mac structure */
    case FILTER_FIELD_DMAC:
    case FILTER_FIELD_SMAC:

		for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
		{
			tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
			fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

			aclRule[tempIdx].data_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.mac.value.octet[5 - i*2] | (fieldPtr->filter_pattern_union.mac.value.octet[5 - (i*2 + 1)] << 8);
			aclRule[tempIdx].care_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.mac.mask.octet[5 - i*2] | (fieldPtr->filter_pattern_union.mac.mask.octet[5 - (i*2 + 1)] << 8);
		}
   		break;
    case FILTER_FIELD_ETHERTYPE:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
			fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.etherType.value;
            aclRule[tempIdx].care_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.etherType.mask;
        }
        break;
    case FILTER_FIELD_IPV4_SIP:
    case FILTER_FIELD_IPV4_DIP:

		ipValue = fieldPtr->filter_pattern_union.sip.value;
		ipMask = fieldPtr->filter_pattern_union.sip.mask;

		for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
		{
			tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
			fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

			aclRule[tempIdx].data_bits.field[fieldIdx] = (ipValue & (0xFFFF << (i << 4))) >> (i << 4);
			aclRule[tempIdx].care_bits.field[fieldIdx] = (ipMask & (0xFFFF << (i << 4))) >> (i << 4);
		}
		break;
    case FILTER_FIELD_IPV4_TOS:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.ipTos.value & 0xFF;
            aclRule[tempIdx].care_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.ipTos.mask  & 0xFF;
        }
        break;
    case FILTER_FIELD_IPV4_PROTOCOL:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.protocol.value & 0xFF;
            aclRule[tempIdx].care_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.protocol.mask  & 0xFF;
        }
        break;
    case FILTER_FIELD_IPV6_SIPV6:
    case FILTER_FIELD_IPV6_DIPV6:
        for(i = 0; i < RTK_IPV6_ADDR_WORD_LENGTH; i++)
        {
            ip6addr[i] = fieldPtr->filter_pattern_union.sipv6.value.addr[i];
            ip6mask[i] = fieldPtr->filter_pattern_union.sipv6.mask.addr[i];
        }

		for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
		{
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
			fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            if(i < 2)
            {
                aclRule[tempIdx].data_bits.field[fieldIdx] = ((ip6addr[0] & (0xFFFF << (i * 16))) >> (i * 16));
                aclRule[tempIdx].care_bits.field[fieldIdx] = ((ip6mask[0] & (0xFFFF << (i * 16))) >> (i * 16));
            }
            else
            {
                aclRule[tempIdx].data_bits.field[fieldIdx] = ((ip6addr[3] & (0xFFFF << ((i&1) * 16))) >> ((i&1) * 16));
                aclRule[tempIdx].care_bits.field[fieldIdx] = ((ip6mask[3] & (0xFFFF << ((i&1) * 16))) >> ((i&1) * 16));
            }
		}

		break;
	case FILTER_FIELD_CTAG:
    case FILTER_FIELD_STAG:

        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] = (fieldPtr->filter_pattern_union.l2tag.pri.value << 13) | (fieldPtr->filter_pattern_union.l2tag.cfi.value << 12) | fieldPtr->filter_pattern_union.l2tag.vid.value;
            aclRule[tempIdx].care_bits.field[fieldIdx] = (fieldPtr->filter_pattern_union.l2tag.pri.mask << 13) | (fieldPtr->filter_pattern_union.l2tag.cfi.mask << 12) | fieldPtr->filter_pattern_union.l2tag.vid.mask;
        }
        break;
	case FILTER_FIELD_IPV4_FLAG:

        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] &= 0x1FFF;
            aclRule[tempIdx].data_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.ipFlag.xf.value << 15);
            aclRule[tempIdx].data_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.ipFlag.df.value << 14);
            aclRule[tempIdx].data_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.ipFlag.mf.value << 13);

            aclRule[tempIdx].care_bits.field[fieldIdx] &= 0x1FFF;
            aclRule[tempIdx].care_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.ipFlag.xf.mask << 15);
            aclRule[tempIdx].care_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.ipFlag.df.mask << 14);
            aclRule[tempIdx].care_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.ipFlag.mf.mask << 13);
        }

        break;
	case FILTER_FIELD_IPV4_OFFSET:

        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] &= 0xE000;
            aclRule[tempIdx].data_bits.field[fieldIdx] |= fieldPtr->filter_pattern_union.inData.value;

            aclRule[tempIdx].care_bits.field[fieldIdx] &= 0xE000;
            aclRule[tempIdx].care_bits.field[fieldIdx] |= fieldPtr->filter_pattern_union.inData.mask;
        }

        break;

	case FILTER_FIELD_IPV6_TRAFFIC_CLASS:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;


            aclRule[tempIdx].data_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.inData.value << 4;
            aclRule[tempIdx].care_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.inData.mask << 4;
        }
        break;
	case FILTER_FIELD_IPV6_NEXT_HEADER:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.inData.value << 8;
            aclRule[tempIdx].care_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.inData.mask << 8;
        }
        break;
    case FILTER_FIELD_TCP_SPORT:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.tcpSrcPort.value;
            aclRule[tempIdx].care_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.tcpSrcPort.mask;
        }
        break;
    case FILTER_FIELD_TCP_DPORT:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.tcpDstPort.value;
            aclRule[tempIdx].care_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.tcpDstPort.mask;
        }
        break;
	case FILTER_FIELD_TCP_FLAG:

        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.cwr.value << 7);
            aclRule[tempIdx].data_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.ece.value << 6);
            aclRule[tempIdx].data_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.urg.value << 5);
            aclRule[tempIdx].data_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.ack.value << 4);
            aclRule[tempIdx].data_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.psh.value << 3);
            aclRule[tempIdx].data_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.rst.value << 2);
            aclRule[tempIdx].data_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.syn.value << 1);
            aclRule[tempIdx].data_bits.field[fieldIdx] |= fieldPtr->filter_pattern_union.tcpFlag.fin.value;

            aclRule[tempIdx].care_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.cwr.mask << 7);
            aclRule[tempIdx].care_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.ece.mask << 6);
            aclRule[tempIdx].care_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.urg.mask << 5);
            aclRule[tempIdx].care_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.ack.mask << 4);
            aclRule[tempIdx].care_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.psh.mask << 3);
            aclRule[tempIdx].care_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.rst.mask << 2);
            aclRule[tempIdx].care_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.tcpFlag.syn.mask << 1);
            aclRule[tempIdx].care_bits.field[fieldIdx] |= fieldPtr->filter_pattern_union.tcpFlag.fin.mask;
        }
        break;
    case FILTER_FIELD_UDP_SPORT:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.udpSrcPort.value;
            aclRule[tempIdx].care_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.udpSrcPort.mask;
        }
        break;
    case FILTER_FIELD_UDP_DPORT:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.udpDstPort.value;
            aclRule[tempIdx].care_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.udpDstPort.mask;
        }
        break;
	case FILTER_FIELD_ICMP_CODE:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] &= 0xFF00;
            aclRule[tempIdx].data_bits.field[fieldIdx] |= fieldPtr->filter_pattern_union.icmpCode.value;
            aclRule[tempIdx].care_bits.field[fieldIdx] &= 0xFF00;
            aclRule[tempIdx].care_bits.field[fieldIdx] |= fieldPtr->filter_pattern_union.icmpCode.mask;
        }
        break;
	case FILTER_FIELD_ICMP_TYPE:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] &= 0x00FF;
            aclRule[tempIdx].data_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.icmpType.value << 8);
            aclRule[tempIdx].care_bits.field[fieldIdx] &= 0x00FF;
            aclRule[tempIdx].care_bits.field[fieldIdx] |= (fieldPtr->filter_pattern_union.icmpType.mask << 8);
        }
        break;
	case FILTER_FIELD_IGMP_TYPE:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] = (fieldPtr->filter_pattern_union.igmpType.value << 8);
            aclRule[tempIdx].care_bits.field[fieldIdx] = (fieldPtr->filter_pattern_union.igmpType.mask << 8);
        }
        break;
    case FILTER_FIELD_PATTERN_MATCH:
        for(i = 0; i < fieldPtr->fieldTemplateNo; i++)
        {
            tempIdx = (fieldPtr->fieldTemplateIdx[i] & 0xF0) >> 4;
            fieldIdx = fieldPtr->fieldTemplateIdx[i] & 0x0F;

            aclRule[tempIdx].data_bits.field[fieldIdx] = ((fieldPtr->filter_pattern_union.pattern.value[i/2] >> (16 * (i%2))) & 0x0000FFFF );
            aclRule[tempIdx].care_bits.field[fieldIdx] = ((fieldPtr->filter_pattern_union.pattern.mask[i/2] >> (16 * (i%2))) & 0x0000FFFF );
        }
        break;
    case FILTER_FIELD_VID_RANGE:
    case FILTER_FIELD_IP_RANGE:
    case FILTER_FIELD_PORT_RANGE:
    default:
		tempIdx = (fieldPtr->fieldTemplateIdx[0] & 0xF0) >> 4;
		fieldIdx = fieldPtr->fieldTemplateIdx[0] & 0x0F;

        aclRule[tempIdx].data_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.inData.value;
        aclRule[tempIdx].care_bits.field[fieldIdx] = fieldPtr->filter_pattern_union.inData.mask;
        break;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_cfg_add
 * Description:
 *      Add an ACL configuration to ASIC
 * Input:
 *      filter_id       - Start index of ACL configuration.
 *      pFilter_cfg     - The ACL configuration that this function will add comparison rule
 *      pFilter_action  - Action(s) of ACL configuration.
 * Output:
 *      ruleNum - number of rules written in acl table
 * Return:
 *      RT_ERR_OK              					- OK
 *      RT_ERR_FAILED          					- Failed
 *      RT_ERR_SMI             					- SMI access error
 *      RT_ERR_NULL_POINTER    					- Pointer pFilter_field or pFilter_cfg point to NULL.
 *      RT_ERR_INPUT 							- Invalid input parameters.
 *      RT_ERR_ENTRY_INDEX 						- Invalid filter_id .
 *      RT_ERR_NULL_POINTER 					- Pointer pFilter_action or pFilter_cfg point to NULL.
 *      RT_ERR_FILTER_INACL_ACT_NOT_SUPPORT 	- Action is not supported in this chip.
 *      RT_ERR_FILTER_INACL_RULE_NOT_SUPPORT 	- Rule is not supported.
 * Note:
 *      This function store pFilter_cfg, pFilter_action into ASIC. The starting
 *      index(es) is filter_id.
 */
rtk_api_ret_t rtk_filter_igrAcl_cfg_add(rtk_filter_id_t filter_id, rtk_filter_cfg_t* pFilter_cfg, rtk_filter_action_t* pFilter_action, rtk_filter_number_t *ruleNum)
{
    rtk_api_ret_t               retVal;
    rtk_uint32                  careTagData, careTagMask;
    rtk_uint32                  i,vidx, svidx, actType, ruleId;
    rtk_uint32                  aclActCtrl;
    rtk_uint32                  cpuPort;
    rtk_filter_field_t*         fieldPtr;
    rtl8367b_aclrule            aclRule[RTL8367B_ACLTEMPLATENO];
    rtl8367b_aclrule            tempRule;
    rtl8367b_acl_act_t          aclAct;
    rtk_uint32                  noRulesAdd;
    rtl8367b_vlanconfiguser     vlanMC;
    rtk_uint8                   active_portmsk;
    rtl8367b_user_vlan4kentry   vlan4K;
    rtl8367b_svlan_memconf_t    svlan_cfg;

    if(filter_id > RTL8367B_ACLRULEMAX )
        return RT_ERR_ENTRY_INDEX;

    if(NULL == pFilter_cfg)
        return RT_ERR_NULL_POINTER;

    if(NULL == pFilter_action )
        return RT_ERR_NULL_POINTER;

    fieldPtr = pFilter_cfg->fieldHead;

    /* init RULE */
    for(i = 0; i < RTL8367B_ACLTEMPLATENO; i++)
    {
        memset(&aclRule[i], 0, sizeof(rtl8367b_aclrule));

        aclRule[i].data_bits.type= i;
        aclRule[i].care_bits.type= 0x7;
    }

    while(NULL != fieldPtr)
    {
        _rtk_filter_igrAcl_writeDataField(aclRule, fieldPtr);

        fieldPtr = fieldPtr->next;
    }

	/*set care tag mask in User Defined Field 15*/
	/*Follow care tag should not be used while ACL template and User defined fields are fully control by system designer*/
    /*those advanced packet type care tag is used in default template design structure only*/
	careTagData = 0;
	careTagMask = 0;
        active_portmsk = 0;

	for(i = CARE_TAG_TCP; i < CARE_TAG_END; i++)
    {
		if(pFilter_cfg->careTag.tagType[i].mask)
			careTagMask = careTagMask | (1 << (i-CARE_TAG_TCP));

		if(pFilter_cfg->careTag.tagType[i].value)
			careTagData = careTagData | (1 << (i-CARE_TAG_TCP));
    }

	if(careTagData || careTagMask)
	{
		i = 0;
		while(i < RTL8367B_ACLTEMPLATENO)
		{
			if(aclRule[i].valid == 1 && filter_advanceCaretagField[i][0] == TRUE)
			{

				aclRule[i].data_bits.field[filter_advanceCaretagField[i][1]] = careTagData & 0xFFFF;
				aclRule[i].care_bits.field[filter_advanceCaretagField[i][1]] = careTagMask & 0xFFFF;
				break;
			}
			i++;
		}
		/*none of previous used template containing field 15*/
		if(i == RTL8367B_ACLTEMPLATENO)
		{
			i = 0;
			while(i <= RTL8367B_ACLTEMPLATENO)
			{
				if(filter_advanceCaretagField[i][0] == TRUE)
				{
					aclRule[i].data_bits.field[filter_advanceCaretagField[i][1]] = careTagData & 0xFFFF;
					aclRule[i].care_bits.field[filter_advanceCaretagField[i][1]] = careTagMask & 0xFFFF;
					aclRule[i].valid = 1;
					break;
				}
				i++;
			}
		}
	}

	/*Check rule number*/
	noRulesAdd = 0;
    for(i = 0; i < RTL8367B_ACLTEMPLATENO; i++)
    {
		if(1 == aclRule[i].valid)
		{
			noRulesAdd ++;
		}
    }

	*ruleNum = noRulesAdd;

	if((filter_id + noRulesAdd - 1) > RTL8367B_ACLRULEMAX)
	{
		return RT_ERR_ENTRY_INDEX;
	}

	/*set care tag mask in TAG Indicator*/
    careTagData = 0;
	careTagMask = 0;

    for(i = 0; i <= CARE_TAG_IPV6;i++)
    {
        if(0 == pFilter_cfg->careTag.tagType[i].mask )
        {
            careTagMask &=  ~(1 << i);
        }
        else
        {
            careTagMask |= (1 << i);
            if(0 == pFilter_cfg->careTag.tagType[i].value )
                careTagData &= ~(1 << i);
            else
                careTagData |= (1 << i);
        }
    }

    for(i = 0; i < RTL8367B_ACLTEMPLATENO; i++)
    {
        aclRule[i].data_bits.tag_exist = (careTagData) & ACL_RULE_CARETAG_MASK;
        aclRule[i].care_bits.tag_exist = (careTagMask) & ACL_RULE_CARETAG_MASK;
    }

    if(FILTER_FIELD_DATA_RANGE == pFilter_cfg->activeport.dataType)
    {

        if(pFilter_cfg->activeport.rangeStart >= RTL8367B_PORTNO || pFilter_cfg->activeport.rangeEnd >= RTL8367B_PORTNO
          || pFilter_cfg->activeport.rangeEnd > pFilter_cfg->activeport.rangeStart)
            return RT_ERR_INPUT;

        for(i = pFilter_cfg->activeport.rangeStart;i <= pFilter_cfg->activeport.rangeEnd; i++)
            active_portmsk |= 1 << i;

        for(i = 0; i < RTL8367B_ACLTEMPLATENO; i++)
        {
    		if(1 == aclRule[i].valid)
            {
                aclRule[0].data_bits.active_portmsk = active_portmsk;
                aclRule[0].care_bits.active_portmsk = 0xFF;
            }
        }
    }
    else if(FILTER_FIELD_DATA_MASK == pFilter_cfg->activeport.dataType )
    {
        if(pFilter_cfg->activeport.value >= (1 << RTL8367B_PORTNO) || pFilter_cfg->activeport.mask >= (1 << RTL8367B_PORTNO))
            return RT_ERR_INPUT;

        for(i = 0; i < RTL8367B_ACLTEMPLATENO; i++)
        {
    		if(1 == aclRule[i].valid)
    		{
    			aclRule[i].data_bits.active_portmsk = pFilter_cfg->activeport.value;
                aclRule[i].care_bits.active_portmsk = pFilter_cfg->activeport.mask;
    		}
        }
    }
    else
        return RT_ERR_INPUT;

    if(pFilter_cfg->invert >= FILTER_INVERT_END )
        return RT_ERR_INPUT;


	/*Last action gets high priority if actions are the same*/
    memset(&aclAct, 0, sizeof(rtl8367b_acl_act_t));
    aclActCtrl = 0;
    for(actType = 0; actType < FILTER_ENACT_END; actType ++)
    {
        if(pFilter_action->actEnable[actType])
        {
            switch (actType)
            {
            case FILTER_ENACT_INGRESS_CVLAN_INDEX:
                if(pFilter_action->filterIngressCvlanIdx > RTL8367B_CVIDXMAX)
                    return RT_ERR_INPUT;

                aclAct.cact = FILTER_ENACT_CVLAN_TYPE(FILTER_ENACT_CVLAN_INGRESS);
                aclAct.cvidx_cact = pFilter_action->filterIngressCvlanIdx;
                aclActCtrl |= FILTER_ENACT_CVLAN_MASK;
                break;
            case FILTER_ENACT_INGRESS_CVLAN_VID:
                if(pFilter_action->filterIngressCvlanVid > RTL8367B_VIDMAX)
                    return RT_ERR_INPUT;

				/*Search avalid vlan member configuration or create new one*/
				for(vidx = 0; vidx <= RTL8367B_CVIDXMAX; vidx ++)
				{
				    if((retVal = rtl8367b_getAsicVlanMemberConfig(vidx, &vlanMC)) != RT_ERR_OK)
				        return retVal;

					if(pFilter_action->filterIngressCvlanVid == vlanMC.evid)
						break;
				}

				/*Did not have existed matched VID, search free entries*/
				if(vidx == (RTL8367B_CVIDXMAX + 1))
				{
					for(vidx = 0; vidx <= RTL8367B_CVIDXMAX; vidx ++)
					{
					    if((retVal = rtl8367b_getAsicVlanMemberConfig(vidx, &vlanMC)) != RT_ERR_OK)
					        return retVal;

						if(0 == vlanMC.mbr && 0 == vlanMC.evid)
                        {
                            /* Empty entry, copy member and untag mask from 4K VLAN */
                            vlan4K.vid = pFilter_action->filterIngressCvlanVid;

                            if ((retVal = rtl8367b_getAsicVlan4kEntry(&vlan4K)) != RT_ERR_OK)
                                return retVal;

                            if(vlan4K.mbr == 0x00)
                                return RT_ERR_VLAN_EMPTY_ENTRY;

                            vlanMC.evid     = vlan4K.vid;
                            vlanMC.mbr      = vlan4K.mbr;
                            vlanMC.fid_msti = vlan4K.fid_msti;
                            vlanMC.meteridx = vlan4K.meteridx;
                            vlanMC.envlanpol= vlan4K.envlanpol;
                            vlanMC.vbpen    = vlan4K.vbpen;
                            vlanMC.vbpri    = vlan4K.vbpri;

                            if((retVal = rtl8367b_setAsicVlanMemberConfig(vidx, &vlanMC)) != RT_ERR_OK)
                                return retVal;

                            break;
                        }
					}

					if(vidx == (RTL8367B_CVIDXMAX + 1))
						return RT_ERR_INPUT;
				}

                aclAct.cact = FILTER_ENACT_CVLAN_TYPE(FILTER_ENACT_CVLAN_INGRESS);
                aclAct.cvidx_cact = vidx;
                aclActCtrl |= FILTER_ENACT_CVLAN_MASK;
                break;
            case FILTER_ENACT_CVLAN_INGRESS:
                if(pFilter_action->filterCvlanIdx > RTL8367B_CVIDXMAX)
                    return RT_ERR_INPUT;

                aclAct.cact = FILTER_ENACT_CVLAN_TYPE(actType);
                aclAct.cvidx_cact = pFilter_action->filterCvlanIdx;
                aclActCtrl |= FILTER_ENACT_CVLAN_MASK;
                break;
            case FILTER_ENACT_CVLAN_EGRESS:
                if(pFilter_action->filterCvlanIdx > RTL8367B_CVIDXMAX)
                    return RT_ERR_INPUT;

                aclAct.cact = FILTER_ENACT_CVLAN_TYPE(actType);
                aclAct.cvidx_cact = pFilter_action->filterCvlanIdx;
                aclActCtrl |= FILTER_ENACT_CVLAN_MASK;
                break;
             case FILTER_ENACT_CVLAN_SVID:

                aclAct.cact = FILTER_ENACT_CVLAN_TYPE(actType);
                aclActCtrl |= FILTER_ENACT_CVLAN_MASK;
                break;
             case FILTER_ENACT_POLICING_1:
                if(pFilter_action->filterPolicingIdx[1] >= (RTL8367B_METERNO * 2))
                    return RT_ERR_INPUT;

                aclAct.cact = FILTER_ENACT_CVLAN_TYPE(actType);
                aclAct.cvidx_cact = pFilter_action->filterPolicingIdx[1];
                aclActCtrl |= FILTER_ENACT_CVLAN_MASK;
                break;

            case FILTER_ENACT_EGRESS_SVLAN_INDEX:
                if(pFilter_action->filterEgressSvlanIdx > RTL8367B_SVIDXMAX )
                    return RT_ERR_INPUT;

                aclAct.sact = FILTER_ENACT_SVLAN_TYPE(FILTER_ENACT_SVLAN_EGRESS);
                aclAct.svidx_sact = pFilter_action->filterEgressSvlanIdx;
                aclActCtrl |= FILTER_ENACT_SVLAN_MASK;
                break;
            case FILTER_ENACT_SVLAN_INGRESS:
            case FILTER_ENACT_SVLAN_EGRESS:

                if(pFilter_action->filterSvlanVid > RTL8367B_VIDMAX)
                    return RT_ERR_INPUT;

                for(svidx = 0; svidx <= RTL8367B_SVIDXMAX; svidx++)
                {
                    if((retVal = rtl8367b_getAsicSvlanMemberConfiguration(svidx, &svlan_cfg)) != RT_ERR_OK)
				        return retVal;

                    if(pFilter_action->filterSvlanVid == svlan_cfg.vs_svid)
						break;
                }

                if(svidx == (RTL8367B_SVIDXMAX + 1))
                    return RT_ERR_INPUT;

                aclAct.sact = FILTER_ENACT_SVLAN_TYPE(actType);
				aclAct.svidx_sact = svidx;
                aclActCtrl |= FILTER_ENACT_SVLAN_MASK;
                break;
            case FILTER_ENACT_SVLAN_CVID:

                aclAct.sact = FILTER_ENACT_SVLAN_TYPE(actType);
                aclActCtrl |= FILTER_ENACT_SVLAN_MASK;
				break;
            case FILTER_ENACT_POLICING_2:
                if(pFilter_action->filterPolicingIdx[2] >= (RTL8367B_METERNO * 2))
                    return RT_ERR_INPUT;

                aclAct.sact = FILTER_ENACT_SVLAN_TYPE(actType);
                aclAct.svidx_sact = pFilter_action->filterPolicingIdx[2];
                aclActCtrl |= FILTER_ENACT_SVLAN_MASK;
                break;
            case FILTER_ENACT_POLICING_0:
                if(pFilter_action->filterPolicingIdx[0] >= (RTL8367B_METERNO * 2))
                    return RT_ERR_INPUT;

                aclAct.aclmeteridx = pFilter_action->filterPolicingIdx[0];
                aclActCtrl |= FILTER_ENACT_POLICING_MASK;
                break;
            case FILTER_ENACT_PRIORITY:
            case FILTER_ENACT_1P_REMARK:
                if(pFilter_action->filterPriority > RTL8367B_PRIMAX)
                    return RT_ERR_INPUT;

                aclAct.priact = FILTER_ENACT_PRI_TYPE(actType);
                aclAct.pridx = pFilter_action->filterPriority;
                aclActCtrl |= FILTER_ENACT_PRIORITY_MASK;
                break;
            case FILTER_ENACT_DSCP_REMARK:
                if(pFilter_action->filterPriority > RTL8367B_DSCPMAX)
                    return RT_ERR_INPUT;

                aclAct.priact = FILTER_ENACT_PRI_TYPE(actType);
                aclAct.pridx = pFilter_action->filterPriority;
                aclActCtrl |= FILTER_ENACT_PRIORITY_MASK;
                break;
            case FILTER_ENACT_POLICING_3:
                if(pFilter_action->filterPriority >= (RTL8367B_METERNO * 2))
                    return RT_ERR_INPUT;

                aclAct.priact = FILTER_ENACT_PRI_TYPE(actType);
                aclAct.pridx = pFilter_action->filterPolicingIdx[3];
                aclActCtrl |= FILTER_ENACT_PRIORITY_MASK;
                break;
            case FILTER_ENACT_DROP:

                aclAct.fwdact = FILTER_ENACT_FWD_TYPE(FILTER_ENACT_REDIRECT);
                aclAct.fwdpmask = 0;
                aclActCtrl |= FILTER_ENACT_FWD_MASK;
                break;
            case FILTER_ENACT_REDIRECT:
                if(pFilter_action->filterRedirectPortmask >= (1 << RTK_MAX_NUM_OF_PORT))
                    return RT_ERR_INPUT;

                aclAct.fwdact = FILTER_ENACT_FWD_TYPE(actType);
                aclAct.fwdpmask = pFilter_action->filterRedirectPortmask;
                aclActCtrl |= FILTER_ENACT_FWD_MASK;
                break;
            case FILTER_ENACT_ADD_DSTPORT:
                if(pFilter_action->filterAddDstPortmask >= (1 << RTK_MAX_NUM_OF_PORT))
                    return RT_ERR_INPUT;

                aclAct.fwdact = FILTER_ENACT_FWD_TYPE(actType);
                aclAct.fwdpmask = pFilter_action->filterAddDstPortmask;
                aclActCtrl |= FILTER_ENACT_FWD_MASK;
                break;
            case FILTER_ENACT_MIRROR:

                aclAct.fwdact = FILTER_ENACT_FWD_TYPE(actType);
                aclAct.fwdpmask = pFilter_action->filterAddDstPortmask;
                aclActCtrl |= FILTER_ENACT_FWD_MASK;
                break;
            case FILTER_ENACT_TRAP_CPU:

                aclAct.fwdact = FILTER_ENACT_FWD_TYPE(actType);
                aclActCtrl |= FILTER_ENACT_FWD_MASK;
                break;
            case FILTER_ENACT_COPY_CPU:
                if((retVal = rtl8367b_getAsicCputagTrapPort(&cpuPort)) != RT_ERR_OK)
                    return retVal;

                aclAct.fwdact = FILTER_ENACT_FWD_TYPE(FILTER_ENACT_MIRROR);
                aclAct.fwdpmask = 1 << cpuPort;
                aclActCtrl |= FILTER_ENACT_FWD_MASK;
                break;
            case FILTER_ENACT_INTERRUPT:

                aclAct.aclint = TRUE;
                aclActCtrl |= FILTER_ENACT_INTGPIO_MASK;
                break;
            case FILTER_ENACT_GPO:

                aclAct.gpio_en = TRUE;
                aclAct.gpio_pin = pFilter_action->filterPin;
                aclActCtrl |= FILTER_ENACT_INTGPIO_MASK;
                break;
            default:
                return RT_ERR_FILTER_INACL_ACT_NOT_SUPPORT;
            }
        }
    }


	/*check if free ACL rules are enough*/
    for(i = filter_id; i < (filter_id + noRulesAdd); i++)
    {
        if((retVal = rtl8367b_getAsicAclRule(i, &tempRule)) != RT_ERR_OK )
            return retVal;

        if(tempRule.valid == TRUE)
        {
            return RT_ERR_TBL_FULL;
        }
    }

	ruleId = 0;
    for(i = 0; i < RTL8367B_ACLTEMPLATENO; i++)
    {
        if(aclRule[i].valid == TRUE)
        {
            /* write ACL action control */
            if((retVal = rtl8367b_setAsicAclActCtrl(filter_id + ruleId, aclActCtrl)) != RT_ERR_OK )
                return retVal;
            /* write ACL action */
            if((retVal = rtl8367b_setAsicAclAct(filter_id + ruleId, &aclAct)) != RT_ERR_OK )
                return retVal;
            /* write ACL not */
            if((retVal = rtl8367b_setAsicAclNot(filter_id + ruleId, pFilter_cfg->invert)) != RT_ERR_OK )
                return retVal;
            /* write ACL rule */
            if((retVal = rtl8367b_setAsicAclRule(filter_id + ruleId, &aclRule[i])) != RT_ERR_OK )
                return retVal;

            /* only the first rule will be written with input action control, aclActCtrl of other rules will be zero */
            aclActCtrl = 0;
            memset(&aclAct, 0, sizeof(rtl8367b_acl_act_t));

			ruleId ++;
		}
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_cfg_del
 * Description:
 *      Delete an ACL configuration from ASIC
 * Input:
 *      filter_id   - Start index of ACL configuration.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK               - OK
 *      RT_ERR_FAILED           - Failed
 *      RT_ERR_SMI              - SMI access error
 *      RT_ERR_FILTER_ENTRYIDX  - Invalid filter_id.
 * Note:
 *      This function delete a group of ACL rules starting from filter_id.
 */
rtk_api_ret_t rtk_filter_igrAcl_cfg_del(rtk_filter_id_t filter_id)
{

    rtl8367b_aclrule initRule;
    rtl8367b_acl_act_t  initAct;
    rtk_api_ret_t ret;

    if(filter_id > RTL8367B_ACLRULEMAX )
        return RT_ERR_FILTER_ENTRYIDX;

    memset(&initRule, 0, sizeof(rtl8367b_aclrule));
    memset(&initAct, 0, sizeof(rtl8367b_acl_act_t));

    if((ret = rtl8367b_setAsicAclRule(filter_id, &initRule)) != RT_ERR_OK)
        return ret;
    if((ret = rtl8367b_setAsicAclActCtrl(filter_id, FILTER_ENACT_INIT_MASK))!= RT_ERR_OK)
        return ret;
    if((ret = rtl8367b_setAsicAclAct(filter_id, &initAct)) != RT_ERR_OK)
        return ret;
    if((ret = rtl8367b_setAsicAclNot(filter_id, DISABLED)) != RT_ERR_OK )
        return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_cfg_delAll
 * Description:
 *      Delete all ACL entries from ASIC
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      This function delete all ACL configuration from ASIC.
 */
rtk_api_ret_t rtk_filter_igrAcl_cfg_delAll(void)
{
    rtl8367b_aclrule  initRule;
    rtl8367b_acl_act_t   initAct;
    rtk_uint32            i;
    rtk_api_ret_t     ret;

    memset(&initRule, 0, sizeof(rtl8367b_aclrule));
    memset(&initAct, 0, sizeof(rtl8367b_acl_act_t));

    for(i = 0; i < RTL8367B_ACLRULENO; i++)
    {
        if((ret = rtl8367b_setAsicAclRule(i, &initRule)) != RT_ERR_OK)
            return ret;
        if((ret = rtl8367b_setAsicAclActCtrl(i, FILTER_ENACT_INIT_MASK))!= RT_ERR_OK)
            return ret;
         if ((ret = rtl8367b_setAsicAclAct(i, &initAct)) != RT_ERR_OK)
            return ret;
        if((ret = rtl8367b_setAsicAclNot(i, DISABLED)) != RT_ERR_OK )
            return ret;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_cfg_get
 * Description:
 *      Get one ingress acl configuration from ASIC.
 * Input:
 *      filter_id       - Start index of ACL configuration.
 * Output:
 *      pFilter_cfg     - buffer pointer of ingress acl data
 *      pFilter_action  - buffer pointer of ingress acl action
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_NULL_POINTER 	- Pointer pFilter_action or pFilter_cfg point to NULL.
 *      RT_ERR_FILTER_ENTRYIDX 	- Invalid entry index.
 * Note:
 *      This function delete all ACL configuration from ASIC.
 */
rtk_api_ret_t rtk_filter_igrAcl_cfg_get(rtk_filter_id_t filter_id, rtk_filter_cfg_raw_t *pFilter_cfg, rtk_filter_action_t *pAction)
{
    rtk_api_ret_t               retVal;
    rtk_uint32                  i, tmp;
    rtl8367b_aclrule            aclRule;
    rtl8367b_acl_act_t          aclAct;
    rtk_uint32                  cpuPort;
    rtl8367b_acltemplate_t      type;
    rtl8367b_svlan_memconf_t    svlan_cfg;
    rtl8367b_vlanconfiguser     vlanMC;

    if ((retVal = rtl8367b_getAsicAclRule(filter_id, &aclRule)) != RT_ERR_OK)
        return retVal;

    pFilter_cfg->activeport.dataType = FILTER_FIELD_DATA_MASK;
    pFilter_cfg->activeport.value = aclRule.data_bits.active_portmsk;
    pFilter_cfg->activeport.mask = aclRule.care_bits.active_portmsk;

    for(i = 0; i <= CARE_TAG_IPV6; i++)
    {
        if(aclRule.data_bits.tag_exist & (1 << i))
            pFilter_cfg->careTag.tagType[i].value = 1;
        else
            pFilter_cfg->careTag.tagType[i].value = 0;

        if (aclRule.care_bits.tag_exist & (1 << i))
            pFilter_cfg->careTag.tagType[i].mask = 1;
        else
            pFilter_cfg->careTag.tagType[i].mask = 0;
    }

    if(filter_advanceCaretagField[aclRule.data_bits.type][0] == TRUE)
    {
        /* Advanced Care tag setting */
        for(i = CARE_TAG_TCP; i < CARE_TAG_END; i++)
        {
            if(aclRule.data_bits.field[filter_advanceCaretagField[aclRule.data_bits.type][1]] & (0x0001 << (i-CARE_TAG_TCP)) )
                pFilter_cfg->careTag.tagType[i].value = 1;
            else
                pFilter_cfg->careTag.tagType[i].value = 0;

            if(aclRule.care_bits.field[filter_advanceCaretagField[aclRule.data_bits.type][1]] & (0x0001 << (i-CARE_TAG_TCP)) )
                pFilter_cfg->careTag.tagType[i].mask = 1;
            else
                pFilter_cfg->careTag.tagType[i].mask = 0;
        }
    }

    for(i = 0; i < RTL8367B_ACLRULEFIELDNO; i++)
    {
        pFilter_cfg->careFieldRaw[i] = aclRule.care_bits.field[i];
        pFilter_cfg->dataFieldRaw[i] = aclRule.data_bits.field[i];
    }

    if ((retVal = rtl8367b_getAsicAclNot(filter_id, &tmp))!= RT_ERR_OK)
        return retVal;

    pFilter_cfg->invert = tmp;

    pFilter_cfg->valid = aclRule.valid;

    memset(pAction, 0, sizeof(rtk_filter_action_t));

    if ((retVal = rtl8367b_getAsicAclActCtrl(filter_id, &tmp))!= RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicAclAct(filter_id, &aclAct)) != RT_ERR_OK)
        return retVal;

    if(tmp & FILTER_ENACT_FWD_MASK)
    {
        if(aclAct.fwdact == RTL8367B_ACL_FWD_TRAP )
            pAction->actEnable[FILTER_ENACT_TRAP_CPU] = TRUE;
        else if (aclAct.fwdact == RTL8367B_ACL_FWD_MIRRORFUNTION )
        {
        	pAction->actEnable[FILTER_ENACT_MIRROR] = TRUE;
			pAction->filterAddDstPortmask = aclAct.fwdpmask;
		}
        else if (aclAct.fwdact == RTL8367B_ACL_FWD_REDIRECT)
        {
            if(aclAct.fwdpmask == 0 )
                pAction->actEnable[FILTER_ENACT_DROP] = TRUE;
            else
            {
                pAction->actEnable[FILTER_ENACT_REDIRECT] = TRUE;
                pAction->filterRedirectPortmask = aclAct.fwdpmask;
            }
        }
        else if (aclAct.fwdact == RTL8367B_ACL_FWD_MIRROR)
        {
            if((retVal = rtl8367b_getAsicCputagTrapPort(&cpuPort)) != RT_ERR_OK)
                return retVal;
            if (aclAct.fwdpmask == (1 << cpuPort))
            {
                pAction->actEnable[FILTER_ENACT_COPY_CPU] = TRUE;
            }
            else
            {
                pAction->actEnable[FILTER_ENACT_ADD_DSTPORT] = TRUE;
                pAction->filterAddDstPortmask = aclAct.fwdpmask;
            }
        }
        else
        {
            return RT_ERR_FAILED;
        }
    }

    if(tmp & FILTER_ENACT_POLICING_MASK)
    {
        pAction->actEnable[FILTER_ENACT_POLICING_0] = TRUE;
        pAction->filterPolicingIdx[0] = aclAct.aclmeteridx;
    }

    if(tmp & FILTER_ENACT_PRIORITY_MASK)
    {
    	if(aclAct.priact == FILTER_ENACT_PRI_TYPE(FILTER_ENACT_PRIORITY))
        {
        	pAction->actEnable[FILTER_ENACT_PRIORITY] = TRUE;
        	pAction->filterPriority = aclAct.pridx;
    	}
		else if(aclAct.priact == FILTER_ENACT_PRI_TYPE(FILTER_ENACT_1P_REMARK))
        {
        	pAction->actEnable[FILTER_ENACT_1P_REMARK] = TRUE;
        	pAction->filterPriority = aclAct.pridx;
    	}
		else if(aclAct.priact == FILTER_ENACT_PRI_TYPE(FILTER_ENACT_DSCP_REMARK))
        {
        	pAction->actEnable[FILTER_ENACT_DSCP_REMARK] = TRUE;
        	pAction->filterPriority = aclAct.pridx;
    	}
		else if(aclAct.priact == FILTER_ENACT_PRI_TYPE(FILTER_ENACT_POLICING_3))
        {
        	pAction->actEnable[FILTER_ENACT_POLICING_3] = TRUE;
        	pAction->filterPolicingIdx[3]  = aclAct.pridx;
    	}
    }

    if(tmp & FILTER_ENACT_SVLAN_MASK)
    {
    	if(aclAct.sact == FILTER_ENACT_SVLAN_TYPE(FILTER_ENACT_SVLAN_INGRESS))
        {
            if((retVal = rtl8367b_getAsicSvlanMemberConfiguration(aclAct.svidx_sact, &svlan_cfg)) != RT_ERR_OK)
				return retVal;

        	pAction->actEnable[FILTER_ENACT_SVLAN_INGRESS] = TRUE;
        	pAction->filterSvlanIdx = aclAct.svidx_sact;
            pAction->filterSvlanVid = svlan_cfg.vs_svid;
    	}
    	else if(aclAct.sact == FILTER_ENACT_SVLAN_TYPE(FILTER_ENACT_SVLAN_EGRESS))
        {
            if((retVal = rtl8367b_getAsicSvlanMemberConfiguration(aclAct.svidx_sact, &svlan_cfg)) != RT_ERR_OK)
				return retVal;

        	pAction->actEnable[FILTER_ENACT_SVLAN_EGRESS] = TRUE;
            pAction->filterEgressSvlanIdx = aclAct.svidx_sact;
        	pAction->filterSvlanIdx = aclAct.svidx_sact;
            pAction->filterSvlanVid = svlan_cfg.vs_svid;
    	}
    	else if(aclAct.sact == FILTER_ENACT_SVLAN_TYPE(FILTER_ENACT_SVLAN_CVID))
        	pAction->actEnable[FILTER_ENACT_SVLAN_CVID] = TRUE;
    	else if(aclAct.sact == FILTER_ENACT_SVLAN_TYPE(FILTER_ENACT_POLICING_2))
        {
        	pAction->actEnable[FILTER_ENACT_POLICING_2] = TRUE;
        	pAction->filterPolicingIdx[2]  = aclAct.svidx_sact;
    	}
    }


    if(tmp & FILTER_ENACT_CVLAN_MASK)
    {
        if(aclAct.cact == FILTER_ENACT_CVLAN_TYPE(FILTER_ENACT_CVLAN_INGRESS))
        {
            if((retVal = rtl8367b_getAsicVlanMemberConfig(aclAct.cvidx_cact, &vlanMC)) != RT_ERR_OK)
                return retVal;

            pAction->actEnable[FILTER_ENACT_CVLAN_INGRESS] = TRUE;
            pAction->filterCvlanIdx         = aclAct.cvidx_cact;
            pAction->filterIngressCvlanVid  = vlanMC.evid;
            pAction->filterIngressCvlanIdx  = aclAct.cvidx_cact;
        }
        else if(aclAct.cact == FILTER_ENACT_CVLAN_TYPE(FILTER_ENACT_CVLAN_EGRESS))
        {
            pAction->actEnable[FILTER_ENACT_CVLAN_EGRESS] = TRUE;
            pAction->filterCvlanIdx = aclAct.cvidx_cact;
        }
        else if(aclAct.cact == FILTER_ENACT_CVLAN_TYPE(FILTER_ENACT_CVLAN_SVID))
        {
            pAction->actEnable[FILTER_ENACT_CVLAN_SVID] = TRUE;
        }
    	else if(aclAct.cact == FILTER_ENACT_CVLAN_TYPE(FILTER_ENACT_POLICING_1))
        {
        	pAction->actEnable[FILTER_ENACT_POLICING_1] = TRUE;
        	pAction->filterPolicingIdx[1]  = aclAct.cvidx_cact;
    	}
    }

    if(tmp & FILTER_ENACT_INTGPIO_MASK)
    {
		if(TRUE == aclAct.aclint)
		{
			pAction->actEnable[FILTER_ENACT_INTERRUPT] = TRUE;
		}

		if(TRUE == aclAct.gpio_en)
		{
			pAction->actEnable[FILTER_ENACT_GPO] = TRUE;
			pAction->filterPin = aclAct.gpio_pin;
		}
    }

    /* Get field type of RAW data */
    if ((retVal = rtl8367b_getAsicAclTemplate(aclRule.data_bits.type, &type))!= RT_ERR_OK)
        return retVal;

    for(i = 0; i < RTL8367B_ACLRULEFIELDNO; i++)
    {
        pFilter_cfg->fieldRawType[i] = type.field[i];
    }/* end of for(i...) */

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_unmatchAction_set
 * Description:
 *      Set action to packets when no ACL configuration match
 * Input:
 *      port    - Port id.
 *      action  - Action.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID 		- Invalid port id.
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      This function sets action of packets when no ACL configruation matches.
 */
rtk_api_ret_t rtk_filter_igrAcl_unmatchAction_set(rtk_port_t port, rtk_filter_unmatch_action_t action)
{
    rtk_api_ret_t ret;

    if(port > RTL8367B_PORTIDMAX )
        return RT_ERR_PORT_ID;

    if(action >= FILTER_UNMATCH_END)
        return RT_ERR_INPUT;

    if((ret = rtl8367b_setAsicAclUnmatchedPermit(port, action)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_unmatchAction_get
 * Description:
 *      Get action to packets when no ACL configuration match
 * Input:
 *      port    - Port id.
 * Output:
 *      pAction - Action.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port id.
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      This function gets action of packets when no ACL configruation matches.
 */
rtk_api_ret_t rtk_filter_igrAcl_unmatchAction_get(rtk_port_t port, rtk_filter_unmatch_action_t* pAction)
{
    rtk_api_ret_t ret;

    if(port > RTL8367B_PORTIDMAX)
        return RT_ERR_PORT_ID;

    if((ret = rtl8367b_getAsicAclUnmatchedPermit(port, pAction)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_state_set
 * Description:
 *      Set state of ingress ACL.
 * Input:
 *      port    - Port id.
 *      state   - Ingress ACL state.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port id.
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      This function gets action of packets when no ACL configruation matches.
 */
rtk_api_ret_t rtk_filter_igrAcl_state_set(rtk_port_t port, rtk_filter_state_t state)
{
    rtk_api_ret_t ret;

    if(port > RTL8367B_PORTIDMAX )
        return RT_ERR_PORT_ID;
    if(state >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if((ret = rtl8367b_setAsicAcl(port, state)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_state_get
 * Description:
 *      Get state of ingress ACL.
 * Input:
 *      port    - Port id.
 * Output:
 *      pState  - Ingress ACL state.
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port id.
 *      RT_ERR_INPUT        - Invalid input parameters.
 * Note:
 *      This function gets action of packets when no ACL configruation matches.
 */
rtk_api_ret_t rtk_filter_igrAcl_state_get(rtk_port_t port, rtk_filter_state_t* pState)
{
    rtk_api_ret_t ret;

    if(port > RTL8367B_PORTIDMAX )
        return RT_ERR_PORT_ID;

    if((ret = rtl8367b_getAsicAcl(port, pState)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}
/* Function Name:
 *      rtk_filter_igrAcl_template_set
 * Description:
 *      Set template of ingress ACL.
 * Input:
 *      template - Ingress ACL template
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_INPUT           - Invalid input parameters.
 * Note:
 *      This function set ACL template.
 */
rtk_api_ret_t rtk_filter_igrAcl_template_set(rtk_filter_template_t *aclTemplate)
{
    rtk_api_ret_t ret;
    rtk_uint32 idxField;
    rtl8367b_acltemplate_t aclType;

    if(aclTemplate->index >= RTK_MAX_NUM_OF_FILTER_TYPE)
        return RT_ERR_INPUT;

    for(idxField = 0; idxField < RTK_MAX_NUM_OF_FILTER_FIELD; idxField ++)
    {
        aclType.field[idxField] = aclTemplate->fieldType[idxField];
    }

    ret = rtl8367b_setAsicAclTemplate(aclTemplate->index, &aclType);

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_template_get
 * Description:
 *      Get template of ingress ACL.
 * Input:
 *      template - Ingress ACL template
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 * Note:
 *      This function gets template of ACL.
 */
rtk_api_ret_t rtk_filter_igrAcl_template_get(rtk_filter_template_t *aclTemplate)
{
    rtk_api_ret_t ret;
    rtk_uint32 idxField;
    rtl8367b_acltemplate_t aclType;

    if(aclTemplate->index >= RTK_MAX_NUM_OF_FILTER_TYPE)
        return RT_ERR_INPUT;

   if((ret = rtl8367b_getAsicAclTemplate(aclTemplate->index, &aclType)) != RT_ERR_OK)
       return ret;

    for(idxField = 0; idxField < RTK_MAX_NUM_OF_FILTER_FIELD; idxField ++)
    {
        aclTemplate->fieldType[idxField] = aclType.field[idxField];
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_field_sel_set
 * Description:
 *      Set user defined field selectors in HSB
 * Input:
 *      index 		- index of field selector 0-15
 *      format 		- Format of field selector
 *      offset 		- Retrieving data offset
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 * Note:
 *      System support 16 user defined field selctors.
 * 		Each selector can be enabled or disable.
 *      User can defined retrieving 16-bits in many predefiend
 * 		standard l2/l3/l4 payload.
 */
rtk_api_ret_t rtk_filter_igrAcl_field_sel_set(rtk_uint32 index, rtk_field_sel_t format, rtk_uint32 offset)
{
    rtk_api_ret_t ret;

    if(index >= RTL8367B_FIELDSEL_FORMAT_NUMBER)
        return RT_ERR_OUT_OF_RANGE;

    if(format >= FORMAT_END)
        return RT_ERR_OUT_OF_RANGE;

    if(offset > RTL8367B_FIELDSEL_MAX_OFFSET)
        return RT_ERR_OUT_OF_RANGE;

    if((ret = rtl8367b_setAsicFieldSelector(index, (rtk_uint32)format, offset)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_igrAcl_field_sel_get
 * Description:
 *      Get user defined field selectors in HSB
 * Input:
 *      index 	    - index of field selector 0-15
 * Output:
 *      pFormat 	- Format of field selector
 *      pOffset 	- Retrieving data offset
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 * Note:
 *      None.
 */
rtk_api_ret_t rtk_filter_igrAcl_field_sel_get(rtk_uint32 index, rtk_field_sel_t *pFormat, rtk_uint32 *pOffset)
{
    rtk_api_ret_t ret;

    if(index >= RTL8367B_FIELDSEL_FORMAT_NUMBER)
        return RT_ERR_OUT_OF_RANGE;

    if((ret = rtl8367b_getAsicFieldSelector(index, pFormat, pOffset)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_iprange_set
 * Description:
 *      Set IP Range check
 * Input:
 *      index 	    - index of IP Range 0-15
 *      type        - IP Range check type, 0:Delete a entry, 1: IPv4_SIP, 2: IPv4_DIP, 3:IPv6_SIP, 4:IPv6_DIP
 *      upperIp     - The upper bound of IP range
 *      lowerIp     - The lower Bound of IP range
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_OUT_OF_RANGE    - The parameter is out of range
 *      RT_ERR_INPUT           - Input error
 * Note:
 *      upperIp must be larger or equal than lowerIp.
 */
rtk_api_ret_t rtk_filter_iprange_set(rtk_uint32 index, rtk_filter_iprange_t type, ipaddr_t upperIp, ipaddr_t lowerIp)
{
    rtk_api_ret_t ret;

    if(index > RTL8367B_ACLRANGEMAX)
		return RT_ERR_OUT_OF_RANGE;

    if(type >= IPRANGE_END)
        return RT_ERR_OUT_OF_RANGE;

    if(lowerIp > upperIp)
        return RT_ERR_INPUT;

    if((ret = rtl8367b_setAsicAclIpRange(index, type, upperIp, lowerIp)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_iprange_get
 * Description:
 *      Set IP Range check
 * Input:
 *      index 	    - index of IP Range 0-15
 * Output:
 *      pType        - IP Range check type, 0:Delete a entry, 1: IPv4_SIP, 2: IPv4_DIP, 3:IPv6_SIP, 4:IPv6_DIP
 *      pUpperIp     - The upper bound of IP range
 *      pLowerIp     - The lower Bound of IP range
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_OUT_OF_RANGE    - The parameter is out of range
 * Note:
 *      None.
 */
rtk_api_ret_t rtk_filter_iprange_get(rtk_uint32 index, rtk_filter_iprange_t *pType, ipaddr_t *pUpperIp, ipaddr_t *pLowerIp)
{
    rtk_api_ret_t ret;

    if(index > RTL8367B_ACLRANGEMAX)
		return RT_ERR_OUT_OF_RANGE;

    if((ret = rtl8367b_getAsicAclIpRange(index, pType, pUpperIp, pLowerIp)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_vidrange_set
 * Description:
 *      Set VID Range check
 * Input:
 *      index 	    - index of VID Range 0-15
 *      type        - IP Range check type, 0:Delete a entry, 1: CVID, 2: SVID
 *      upperVid    - The upper bound of VID range
 *      lowerVid    - The lower Bound of VID range
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_OUT_OF_RANGE    - The parameter is out of range
 *      RT_ERR_INPUT           - Input error
 * Note:
 *      upperVid must be larger or equal than lowerVid.
 */
rtk_api_ret_t rtk_filter_vidrange_set(rtk_uint32 index, rtk_filter_vidrange_t type, rtk_uint32 upperVid, rtk_uint32 lowerVid)
{
    rtk_api_ret_t ret;

    if(index > RTL8367B_ACLRANGEMAX)
		return RT_ERR_OUT_OF_RANGE;

    if(type >= VIDRANGE_END)
        return RT_ERR_OUT_OF_RANGE;

    if(lowerVid > upperVid)
        return RT_ERR_INPUT;

    if( (upperVid > RTL8367B_VIDMAX) || (lowerVid > RTL8367B_VIDMAX))
        return RT_ERR_OUT_OF_RANGE;

    if((ret = rtl8367b_setAsicAclVidRange(index, type, upperVid, lowerVid)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_vidrange_get
 * Description:
 *      Get VID Range check
 * Input:
 *      index 	    - index of VID Range 0-15
 * Output:
 *      pType        - IP Range check type, 0:Unused, 1: CVID, 2: SVID
 *      pUpperVid    - The upper bound of VID range
 *      pLowerVid    - The lower Bound of VID range
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_OUT_OF_RANGE    - The parameter is out of range
 * Note:
 *      None.
 */
rtk_api_ret_t rtk_filter_vidrange_get(rtk_uint32 index, rtk_filter_vidrange_t *pType, rtk_uint32 *pUpperVid, rtk_uint32 *pLowerVid)
{
    rtk_api_ret_t ret;

    if(index > RTL8367B_ACLRANGEMAX)
		return RT_ERR_OUT_OF_RANGE;

    if((ret = rtl8367b_getAsicAclVidRange(index, pType, pUpperVid, pLowerVid)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_portrange_set
 * Description:
 *      Set Port Range check
 * Input:
 *      index 	    - index of Port Range 0-15
 *      type        - IP Range check type, 0:Delete a entry, 1: Source Port, 2: Destnation Port
 *      upperPort   - The upper bound of Port range
 *      lowerPort   - The lower Bound of Port range
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_OUT_OF_RANGE    - The parameter is out of range
 *      RT_ERR_INPUT           - Input error
 * Note:
 *      upperPort must be larger or equal than lowerPort.
 */
rtk_api_ret_t rtk_filter_portrange_set(rtk_uint32 index, rtk_filter_portrange_t type, rtk_uint32 upperPort, rtk_uint32 lowerPort)
{
    rtk_api_ret_t ret;

    if(index > RTL8367B_ACLRANGEMAX)
		return RT_ERR_OUT_OF_RANGE;

    if(type >= PORTRANGE_END)
        return RT_ERR_OUT_OF_RANGE;

    if(lowerPort > upperPort)
        return RT_ERR_INPUT;

    if(upperPort > RTL8367B_ACL_PORTRANGEMAX)
        return RT_ERR_INPUT;

    if(lowerPort > RTL8367B_ACL_PORTRANGEMAX)
        return RT_ERR_INPUT;

    if((ret = rtl8367b_setAsicAclPortRange(index, type, upperPort, lowerPort)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_filter_portrange_get
 * Description:
 *      Set Port Range check
 * Input:
 *      index 	    - index of Port Range 0-15
 * Output:
 *      pType       - IP Range check type, 0:Delete a entry, 1: Source Port, 2: Destnation Port
 *      pUpperPort  - The upper bound of Port range
 *      pLowerPort  - The lower Bound of Port range
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_OUT_OF_RANGE    - The parameter is out of range
 *      RT_ERR_INPUT           - Input error
 * Note:
 *      None.
 */
rtk_api_ret_t rtk_filter_portrange_get(rtk_uint32 index, rtk_filter_portrange_t *pType, rtk_uint32 *pUpperPort, rtk_uint32 *pLowerPort)
{
    rtk_api_ret_t ret;

    if(index > RTL8367B_ACLRANGEMAX)
		return RT_ERR_OUT_OF_RANGE;

    if((ret = rtl8367b_getAsicAclPortRange(index, pType, pUpperPort, pLowerPort)) != RT_ERR_OK)
       return ret;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_eee_init
 * Description:
 *      EEE function initialization.
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 * Note:
 *      This API is used to initialize EEE status.
 */
rtk_api_ret_t rtk_eee_init(void)
{
    rtk_api_ret_t retVal;

    if((retVal = rtl8367b_setAsicRegBit(0x0018, 10, 1)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_setAsicRegBit(0x0018, 11, 1)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_eee_portEnable_set
 * Description:
 *      Set enable status of EEE function.
 * Input:
 *      port - port id.
 *      enable - enable EEE status.
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_PORT_ID - Invalid port number.
 *      RT_ERR_ENABLE - Invalid enable input.
 * Note:
 *      This API can set EEE function to the specific port.
 *      The configuration of the port is as following:
 *      - DISABLE
 *      - ENABLE
 */
rtk_api_ret_t rtk_eee_portEnable_set(rtk_port_t port, rtk_enable_t enable)
{
    rtk_api_ret_t   retVal;
    rtk_uint32      regData;
    rtk_uint32      data;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if (enable>=RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if((retVal = rtl8367b_setAsicReg(0x13C2, 0x0249)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1300, &data)) != RT_ERR_OK)
        return retVal;

    if( (data == 0x0276) || (data == 0x0597) || (data == 0x6367) )
    {
        if((retVal = rtl8367b_getAsicPHYOCPReg(port, EEE_OCP_PHY_ADDR, &regData)) != RT_ERR_OK)
            return retVal;

        if(enable)
        {
            regData |= (0x0001 << 1);
            regData |= (0x0001 << 2);
        }
        else
        {
            regData &= ~(0x0001 << 1);
            regData &= ~(0x0001 << 2);
        }

        if((retVal = rtl8367b_setAsicPHYOCPReg(port, EEE_OCP_PHY_ADDR, regData)) != RT_ERR_OK)
            return retVal;
    }
    else
    {
        if ((retVal = rtl8367b_setAsicEee100M(port,enable))!=RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicEeeGiga(port,enable))!=RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicRegBit(RTL8367B_PORT_EEE_CFG_REG(port), RTL8367B_PORT0_EEECFG_EEE_TX_OFFSET, (enable == ENABLED) ? 1 : 0)) != RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicRegBit(RTL8367B_PORT_EEE_CFG_REG(port), RTL8367B_PORT0_EEECFG_EEE_RX_OFFSET, (enable == ENABLED) ? 1 : 0)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicPHYReg(port, RTL8367B_PHY_PAGE_ADDRESS, 0))!=RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicPHYReg(port, 13, 7))!=RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicPHYReg(port, 14, 60))!=RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicPHYReg(port, 13, 0x4007))!=RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicPHYReg(port, 14, (enable == ENABLED) ? 0x0006 : 0x0000))!=RT_ERR_OK)
            return retVal;
    }

    if ((retVal = rtl8367b_setAsicPHYReg(port, RTL8367B_PHY_PAGE_ADDRESS, 0))!=RT_ERR_OK)
        return retVal;
    if ((retVal = rtl8367b_getAsicPHYReg(port, 0, &regData))!=RT_ERR_OK)
        return retVal;
    regData |= 0x0200;
    if ((retVal = rtl8367b_setAsicPHYReg(port, 0, regData))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_eee_portEnable_get
 * Description:
 *      Get enable status of EEE function
 * Input:
 *      port - Port id.
 * Output:
 *      pEnable - Back pressure status.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_PORT_ID - Invalid port number.
 * Note:
 *      This API can get EEE function to the specific port.
 *      The configuration of the port is as following:
 *      - DISABLE
 *      - ENABLE
 */

rtk_api_ret_t rtk_eee_portEnable_get(rtk_port_t port, rtk_enable_t *pEnable)
{
    rtk_api_ret_t retVal;
    rtk_uint32      regData, regData1, regData2;
    rtk_uint32      data;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if((retVal = rtl8367b_setAsicReg(0x13C2, 0x0249)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1300, &data)) != RT_ERR_OK)
        return retVal;

    if( (data == 0x0276) || (data == 0x0597) || (data == 0x6367) )
    {
        if((retVal = rtl8367b_getAsicPHYOCPReg(port, EEE_OCP_PHY_ADDR, &regData)) != RT_ERR_OK)
            return retVal;

        *pEnable = ((regData & 0x0006) == 0x0006) ? ENABLED : DISABLED;
    }
    else
    {
        if ((retVal = rtl8367b_getAsicEee100M(port,&regData1))!=RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_getAsicEeeGiga(port,&regData2))!=RT_ERR_OK)
            return retVal;

        if (regData1==1&&regData2==1)
            *pEnable = ENABLED;
        else
            *pEnable = DISABLED;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_init
 * Description:
 *      This API enables H/W IGMP and set a default initial configuration.
 * Input:
 *      None.
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 * Note:
 *      This API enables H/W IGMP and set a default initial configuration.
 */
rtk_api_ret_t rtk_igmp_init(void)
{
    rtk_api_ret_t retVal;
    rtk_port_t port;

    if ((retVal = rtl8367b_setAsicLutIpMulticastLookup(ENABLED))!=RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicLutIpLookupMethod(1))!=RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicIgmp(ENABLED))!=RT_ERR_OK)
        return retVal;

    for(port = 0; port <= RTK_PORT_ID_MAX; port++)
    {
        if ((retVal = rtl8367b_setAsicIGMPv1Opeartion(port, PROTOCOL_OP_ASIC))!=RT_ERR_OK)
        return retVal;

        if ((retVal = rtl8367b_setAsicIGMPv2Opeartion(port, PROTOCOL_OP_ASIC))!=RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicIGMPv3Opeartion(port, PROTOCOL_OP_FLOOD))!=RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicMLDv1Opeartion(port, PROTOCOL_OP_ASIC))!=RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicMLDv2Opeartion(port, PROTOCOL_OP_FLOOD))!=RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_state_set
 * Description:
 *      This API set H/W IGMP state.
 * Input:
 *      enabled     - H/W IGMP state
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_INPUT           - Error parameter
 * Note:
 *      This API set H/W IGMP state.
 */
rtk_api_ret_t rtk_igmp_state_set(rtk_enable_t enabled)
{
    rtk_api_ret_t retVal;

    if (enabled >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicIgmp(enabled))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_state_get
 * Description:
 *      This API get H/W IGMP state.
 * Input:
 *      None.
 * Output:
 *      pEnabled        - H/W IGMP state
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_INPUT           - Error parameter
 * Note:
 *      This API set current H/W IGMP state.
 */
rtk_api_ret_t rtk_igmp_state_get(rtk_enable_t *pEnabled)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicIgmp(pEnabled))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_static_router_port_set
 * Description:
 *      Configure static router port
 * Input:
 *      portmask    - Static Port mask
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_PORT_MASK       - Error parameter
 * Note:
 *      This API set static router port
 */
rtk_api_ret_t rtk_igmp_static_router_port_set(rtk_portmask_t portmask)
{
    rtk_api_ret_t retVal;

    if ( portmask.bits[0] > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    if ((retVal = rtl8367b_setAsicIGMPStaticRouterPort(portmask.bits[0]))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_static_router_port_get
 * Description:
 *      Get static router port
 * Input:
 *      None.
 * Output:
 *      pPortmask       - Static port mask
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_PORT_MASK       - Error parameter
 * Note:
 *      This API get static router port
 */
rtk_api_ret_t rtk_igmp_static_router_port_get(rtk_portmask_t *pPortmask)
{
    rtk_api_ret_t retVal;

    if ((retVal = rtl8367b_getAsicIGMPStaticRouterPort(&pPortmask->bits[0]))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_protocol_set
 * Description:
 *      set IGMP/MLD protocol action
 * Input:
 *      port        - Port ID
 *      protocol    - IGMP/MLD protocol
 *      action      - Per-port and per-protocol IGMP action seeting
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_PORT_MASK       - Error parameter
 * Note:
 *      This API set IGMP/MLD protocol action
 */
rtk_api_ret_t rtk_igmp_protocol_set(rtk_port_t port, rtk_igmp_protocol_t protocol, rtk_trap_igmp_action_t action)
{
    rtk_uint32      operation;
    rtk_api_ret_t   retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if(protocol >= PROTOCOL_END)
        return RT_ERR_INPUT;

    if((action >= IGMP_ACTION_END) || (action == IGMP_ACTION_FORWARD_EXCLUDE_CPU))
        return RT_ERR_INPUT;

    switch(action)
    {
        case IGMP_ACTION_FORWARD:
            operation = PROTOCOL_OP_FLOOD;
            break;
        case IGMP_ACTION_TRAP2CPU:
            operation = PROTOCOL_OP_TRAP;
            break;
        case IGMP_ACTION_DROP:
            operation = PROTOCOL_OP_DROP;
            break;
        case IGMP_ACTION_ASIC:
            if( (protocol == PROTOCOL_IGMPv3) || (protocol == PROTOCOL_MLDv2) )
                return RT_ERR_CHIP_NOT_SUPPORTED;
            else
            operation = PROTOCOL_OP_ASIC;
            break;
        default:
            return RT_ERR_INPUT;
    }

    switch(protocol)
    {
        case PROTOCOL_IGMPv1:
            if ((retVal = rtl8367b_setAsicIGMPv1Opeartion(port, operation))!=RT_ERR_OK)
                return retVal;

            break;
        case PROTOCOL_IGMPv2:
            if ((retVal = rtl8367b_setAsicIGMPv2Opeartion(port, operation))!=RT_ERR_OK)
                return retVal;

            break;
        case PROTOCOL_IGMPv3:
            if ((retVal = rtl8367b_setAsicIGMPv3Opeartion(port, operation))!=RT_ERR_OK)
                return retVal;

            break;
        case PROTOCOL_MLDv1:
            if ((retVal = rtl8367b_setAsicMLDv1Opeartion(port, operation))!=RT_ERR_OK)
                return retVal;

            break;
        case PROTOCOL_MLDv2:
            if ((retVal = rtl8367b_setAsicMLDv2Opeartion(port, operation))!=RT_ERR_OK)
                return retVal;

            break;
        default:
            return RT_ERR_INPUT;

    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_protocol_get
 * Description:
 *      set IGMP/MLD protocol action
 * Input:
 *      port        - Port ID
 *      protocol    - IGMP/MLD protocol
 *      action      - Per-port and per-protocol IGMP action seeting
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 *      RT_ERR_PORT_MASK       - Error parameter
 * Note:
 *      This API set IGMP/MLD protocol action
 */
rtk_api_ret_t rtk_igmp_protocol_get(rtk_port_t port, rtk_igmp_protocol_t protocol, rtk_trap_igmp_action_t *pAction)
{
    rtk_uint32      operation;
    rtk_api_ret_t   retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if(protocol >= PROTOCOL_END)
        return RT_ERR_INPUT;

    switch(protocol)
    {
        case PROTOCOL_IGMPv1:
            if ((retVal = rtl8367b_getAsicIGMPv1Opeartion(port, &operation))!=RT_ERR_OK)
                return retVal;

            break;
        case PROTOCOL_IGMPv2:
            if ((retVal = rtl8367b_getAsicIGMPv2Opeartion(port, &operation))!=RT_ERR_OK)
                return retVal;

            break;
        case PROTOCOL_IGMPv3:
            if ((retVal = rtl8367b_getAsicIGMPv3Opeartion(port, &operation))!=RT_ERR_OK)
                return retVal;

            break;
        case PROTOCOL_MLDv1:
            if ((retVal = rtl8367b_getAsicMLDv1Opeartion(port, &operation))!=RT_ERR_OK)
                return retVal;

            break;
        case PROTOCOL_MLDv2:
            if ((retVal = rtl8367b_getAsicMLDv2Opeartion(port, &operation))!=RT_ERR_OK)
                return retVal;

            break;
        default:
            return RT_ERR_INPUT;

    }

    switch(operation)
    {
        case PROTOCOL_OP_FLOOD:
            *pAction = IGMP_ACTION_FORWARD;
            break;
        case PROTOCOL_OP_TRAP:
            *pAction = IGMP_ACTION_TRAP2CPU;
            break;
        case PROTOCOL_OP_DROP:
            *pAction = IGMP_ACTION_DROP;
            break;
        case PROTOCOL_OP_ASIC:
            *pAction = IGMP_ACTION_ASIC;
            break;
        default:
            return RT_ERR_FAILED;
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_fastLeave_set
 * Description:
 *      set IGMP/MLD FastLeave state
 * Input:
 *      state       - ENABLED: Enable FastLeave, DISABLED: disable FastLeave
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_INPUT           - Error Input
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 * Note:
 *      This API set IGMP/MLD FastLeave state
 */
rtk_api_ret_t rtk_igmp_fastLeave_set(rtk_enable_t state)
{
    rtk_api_ret_t   retVal;

    if(state >= RTK_ENABLE_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicIGMPFastLeaveEn((rtk_uint32)state))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_fastLeave_get
 * Description:
 *      get IGMP/MLD FastLeave state
 * Input:
 *      None
 * Output:
 *      pState      - ENABLED: Enable FastLeave, DISABLED: disable FastLeave
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_NULL_POINTER    - NULL pointer
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 * Note:
 *      This API get IGMP/MLD FastLeave state
 */
rtk_api_ret_t rtk_igmp_fastLeave_get(rtk_enable_t *pState)
{
    rtk_uint32      fast_leave;
    rtk_api_ret_t   retVal;

    if(pState == NULL)
        return RT_ERR_NULL_POINTER;

    if ((retVal = rtl8367b_getAsicIGMPFastLeaveEn(&fast_leave))!=RT_ERR_OK)
        return retVal;

    *pState = ((fast_leave == 1) ? ENABLED : DISABLED);
    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_maxGroup_set
 * Description:
 *      Set per port multicast group learning limit.
 * Input:
 *      port        - Port ID
 *      group       - The number of multicast group learning limit.
 * Output:
 *      None.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_PORT_ID         - Error Port ID
 *      RT_ERR_OUT_OF_RANGE    - parameter out of range
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 * Note:
 *      This API set per port multicast group learning limit.
 */
rtk_api_ret_t rtk_igmp_maxGroup_set(rtk_port_t port, rtk_uint32 group)
{
    rtk_api_ret_t   retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if(group > RTL8367B_IGMP_MAX_GOUP)
		return RT_ERR_OUT_OF_RANGE;

    if ((retVal = rtl8367b_setAsicIGMPPortMAXGroup(port, group))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_maxGroup_get
 * Description:
 *      Get per port multicast group learning limit.
 * Input:
 *      port        - Port ID
 * Output:
 *      pGroup      - The number of multicast group learning limit.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_PORT_ID         - Error Port ID
 *      RT_ERR_NULL_POINTER    - Null pointer
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 * Note:
 *      This API get per port multicast group learning limit.
 */
rtk_api_ret_t rtk_igmp_maxGroup_get(rtk_port_t port, rtk_uint32 *pGroup)
{
    rtk_api_ret_t   retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if(pGroup == NULL)
		return RT_ERR_NULL_POINTER;

    if ((retVal = rtl8367b_getAsicIGMPPortMAXGroup(port, pGroup))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_igmp_currentGroup_get
 * Description:
 *      Get per port multicast group learning count.
 * Input:
 *      port        - Port ID
 * Output:
 *      pGroup      - The number of multicast group learning count.
 * Return:
 *      RT_ERR_OK              - OK
 *      RT_ERR_PORT_ID         - Error Port ID
 *      RT_ERR_NULL_POINTER    - Null pointer
 *      RT_ERR_FAILED          - Failed
 *      RT_ERR_SMI             - SMI access error
 * Note:
 *      This API get per port multicast group learning count.
 */
rtk_api_ret_t rtk_igmp_currentGroup_get(rtk_port_t port, rtk_uint32 *pGroup)
{
    rtk_api_ret_t   retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if(pGroup == NULL)
		return RT_ERR_NULL_POINTER;

    if ((retVal = rtl8367b_getAsicIGMPPortCurrentGroup(port, pGroup))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyTestMode_set
 * Description:
 *      Set PHY in test mode.
 * Input:
 *      port - port id.
 *      mode - PHY test mode 0:normal 1:test mode 1 2:test mode 2 3: test mode 3 4:test mode 4 5~7:reserved
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_BUSYWAIT_TIMEOUT - PHY access busy
 *      RT_ERR_NOT_ALLOWED      - The Setting is not allowed, caused by set more than 1 port in Test mode.
 * Note:
 *      Set PHY in test mode and only one PHY can be in test mode at the same time.
 *      It means API will return FAILED if other PHY is in test mode.
 *      This API only provide test mode 1 & 4 setup, and if users want other test modes,
 *      please contact realtek FAE.
 */
rtk_api_ret_t rtk_port_phyTestMode_set(rtk_port_t port, rtk_port_phy_test_mode_t mode)
{
    rtk_uint32          data, regData, i, index, phy, reg;
    rtk_api_ret_t       retVal;
    CONST_T rtk_uint16 ParaTM_1[][2] = { {0x205F,0x0002}, {0x2053,0xAA00}, {0x2054,0xAA00}, {0x2055,0xAA00},
                                         {0x2056,0xAA00}, {0x2057,0xAA00}, {0x205F,0x0002} };

    if (port > RTK_PHY_ID_MAX)
        return RT_ERR_PORT_ID;

    if (PHY_TEST_MODE_NORMAL != mode)
    {
        /* Other port should be Normal mode */
        for(i = 0; i <= RTK_PHY_ID_MAX; i++)
        {
            if(i != port)
            {
                if ((retVal = rtl8367b_setAsicPHYReg(i, 31, 0)) != RT_ERR_OK)
                    return retVal;

                if ((retVal = rtl8367b_getAsicPHYReg(i, 9, &data)) != RT_ERR_OK)
                    return retVal;

                if((data & 0xE000) != 0)
                    return RT_ERR_NOT_ALLOWED;
            }
        }
    }

    if((retVal = rtl8367b_setAsicReg(0x13C2, 0x0249)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1300, &regData)) != RT_ERR_OK)
        return retVal;

    if( (regData != 0x0276) && (regData != 0x0597) && (regData != 0x6367) )
    {
        if (PHY_TEST_MODE_1 == mode)
        {
            for (index = 0; index < (sizeof(ParaTM_1) / ((sizeof(rtk_uint16))*2)); index++)
            {
                phy = (ParaTM_1[index][0] - 0x2000) / 0x0020;
                reg = (ParaTM_1[index][0] - 0x2000) % 0x0020;
                if ((retVal = rtl8367b_setAsicPHYReg(phy, reg, ParaTM_1[index][1])) != RT_ERR_OK)
                    return retVal;
            }
        }
    }

    if ((retVal = rtl8367b_setAsicPHYReg(port, 31, 0)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPHYReg(port, 9, &data)) != RT_ERR_OK)
        return retVal;

    data &= ~0xE000;
    data |= (mode << 13);
    if ((retVal = rtl8367b_setAsicPHYReg(port, 9, data)) != RT_ERR_OK)
        return retVal;

    if (PHY_TEST_MODE_4 == mode)
    {
        if( (regData == 0x0276) || (regData == 0x0597) )
        {
            if ((retVal = rtl8367b_setAsicPHYOCPReg(port, 0xbcc2, 0xF4F4)) != RT_ERR_OK)
                return retVal;
        }

        if( (regData == 0x6367) )
        {
            if ((retVal = rtl8367b_setAsicPHYOCPReg(port, 0xa436, 0x80c1)) != RT_ERR_OK)
                return retVal;
                
            if ((retVal = rtl8367b_setAsicPHYOCPReg(port, 0xa438, 0xfe00)) != RT_ERR_OK)
                return retVal;                
        }
    }

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_phyTestMode_get
 * Description:
 *      Get PHY in which test mode.
 * Input:
 *      port - Port id.
 * Output:
 *      mode - PHY test mode 0:normal 1:test mode 1 2:test mode 2 3: test mode 3 4:test mode 4 5~7:reserved
 * Return:
 *      RT_ERR_OK              	- OK
 *      RT_ERR_FAILED          	- Failed
 *      RT_ERR_SMI             	- SMI access error
 *      RT_ERR_PORT_ID 			- Invalid port number.
 *      RT_ERR_INPUT 			- Invalid input parameters.
 *      RT_ERR_BUSYWAIT_TIMEOUT - PHY access busy
 * Note:
 *      Get test mode of PHY from register setting 9.15 to 9.13.
 */
rtk_api_ret_t rtk_port_phyTestMode_get(rtk_port_t port, rtk_port_phy_test_mode_t *pMode)
{
    rtk_uint32      data;
    rtk_api_ret_t   retVal;

    if (port > RTK_PHY_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_setAsicPHYReg(port, 31, 0)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicPHYReg(port, 9, &data)) != RT_ERR_OK)
        return retVal;

    *pMode = (data & 0xE000) >> 13;

    return RT_ERR_OK;
}

#define REG1301_8367R_VB				0x1010
#define REG1301_8367RB					0x1000

#define CONFIG_LAN_WAN_ISOLATION 1
#define CONFIG_RTK_REFINE_PORT_DUPLEX_MODE 1

//#define RTL8367RB_USE_ONE_LED_PER_PORT		1

#if defined(CONFIG_RTL_8367MB_SUPPORT)
// now the HW is EXT0, it should be changed to EXT1 for cpu tag feature
#define EXT_PORT_FOR_HOST			EXT_PORT_0
#define EXT_PORT_FOR_RGMII2			EXT_PORT_1
#define EXT_MAC_FOR_HOST			RTK_EXT_0_MAC
#define LED_GROUP_X					LED_GROUP_2

#else // 8367RB, 8367R_VB
#define EXT_PORT_FOR_HOST			EXT_PORT_1
#define EXT_PORT_FOR_RGMII2			EXT_PORT_2
#define EXT_MAC_FOR_HOST			RTK_EXT_1_MAC
#define LED_GROUP_X					LED_GROUP_1
#endif

#ifndef CONFIG_RTL_8197F
#define ENABLE_8367RB_RGMII2	1
#endif

#ifdef ENABLE_8367RB_RGMII2
// for tr181
int rtk_rgmii_set(int enable)
{
    rtk_port_mac_ability_t mac_cfg;

    mac_cfg.forcemode = MAC_FORCE;
    mac_cfg.speed = SPD_1000M;
    mac_cfg.duplex = FULL_DUPLEX;
    if (enable == TRUE)
        mac_cfg.link = PORT_LINKUP;
    else		
        mac_cfg.link = PORT_LINKDOWN;
    mac_cfg.nway = DISABLED;
    mac_cfg.txpause = ENABLED;
    mac_cfg.rxpause = ENABLED;
    rtk_port_macForceLinkExt_set(EXT_PORT_FOR_RGMII2, MODE_EXT_RGMII, &mac_cfg);

    return 0;
}
#endif

#include <linux/delay.h>

int RTL8367R_init(void)
{
    rtk_portmask_t portmask;
    unsigned int ret;
    //unsigned int regData;

    /* Set external interface 0 to RGMII with Force mode, 1000M, Full-duple, enable TX&RX pause*/
    rtk_port_mac_ability_t mac_cfg;
    rtk_mode_ext_t mode ;

    // do the whole chip reset in case the 8367 may be set in boot loader
    rtl8367b_setAsicReg(RTL8367B_REG_CHIP_RESET, (1<<RTL8367B_CHIP_RST_OFFSET));
    mdelay(1200);
 
    /* Initial Chip */
    ret = rtk_switch_init();
 
    /* Enable LED Group 0&1 from P0 to P4 */
    portmask.bits[0]=0x1F;
    rtk_led_enable_set(LED_GROUP_0, portmask);
    rtk_led_enable_set(LED_GROUP_X, portmask);
 
    mode = MODE_EXT_RGMII ;
    mac_cfg.forcemode = MAC_FORCE;
    mac_cfg.speed = SPD_1000M;
    mac_cfg.duplex = FULL_DUPLEX;
    mac_cfg.link = PORT_LINKUP;
    mac_cfg.nway = DISABLED;
    mac_cfg.txpause = ENABLED;
    mac_cfg.rxpause = ENABLED;
    rtk_port_macForceLinkExt_set(EXT_PORT_FOR_HOST,mode,&mac_cfg);
 
#ifdef ENABLE_8367RB_RGMII2
    mode = MODE_EXT_RGMII ;
    mac_cfg.forcemode = MAC_FORCE;
    mac_cfg.speed = SPD_1000M;
    mac_cfg.duplex = FULL_DUPLEX;
    mac_cfg.link = PORT_LINKUP;
    mac_cfg.nway = DISABLED;
    mac_cfg.txpause = ENABLED;
    mac_cfg.rxpause = ENABLED;
    rtk_port_macForceLinkExt_set(EXT_PORT_FOR_RGMII2,mode,&mac_cfg);

    // the tx/rx delay is depend on the board
    //rtk_port_rgmiiDelayExt_set(EXT_PORT_FOR_RGMII2, 1, 3);
#endif

    /* Set RGMII Interface 0 TX delay to 2ns and RX to step 4 */
    // set the tx/rx delay in 8197D site
    //rtk_port_rgmiiDelayExt_set(EXT_PORT_1, 1, 4);
    //rtk_port_rgmiiDelayExt_set(EXT_PORT_1, 0, 0);
    rtk_port_rgmiiDelayExt_set(EXT_PORT_FOR_HOST, 0, 2); // change rxDelay to 2 to enhance the compatibility of 8197D and 8367RB
 
    /* set port 5 as CPU port */
    rtk_cpu_enable_set(ENABLE);
    rtk_cpu_tagPort_set(EXT_MAC_FOR_HOST, CPU_INSERT_TO_NONE);
 
    // for LED on Realtek 8197D+8367RB
#if defined(CONFIG_RTL_8367MB_SUPPORT)
	// group2 (bit11-8): 1001:Spd100(10)/Act
	// group0 (bit3-0): 0110:Spd1000/Act
    rtl8367b_setAsicReg(RTL8367B_REG_LED_CONFIGURATION, 0x906);
#else // 8367RB, 8367R_VB

    if (r8367_cpu_port == RTL8367B_PORT6_ENABLE_OFFSET) {    // 8367RB
#ifdef RTL8367RB_USE_ONE_LED_PER_PORT
        rtl8367b_setAsicReg(RTL8367B_REG_LED_CONFIGURATION, 0x0222);
#else
        /* demo board use 2 LEDs for each port */	
        rtl8367b_setAsicReg(RTL8367B_REG_LED_CONFIGURATION, 0x0936);
#endif
    }
#endif
	
#if 1
    // for 802.11ac logo 4.2.40 test (udp test item)
    rtl8367b_setAsicReg(0x121f, 0x01D6);
    rtl8367b_setAsicReg(0x1220, 0x01B8);
    rtl8367b_setAsicReg(0x1221, 0x01CC);
    rtl8367b_setAsicReg(0x1222, 0x01AE);
    rtl8367b_setAsicReg(0x1223, 0x0302);
    rtl8367b_setAsicReg(0x1224, 0x02E4);
    rtl8367b_setAsicReg(0x1225, 0x02D0);
    rtl8367b_setAsicReg(0x1226, 0x02A8);	
#endif

#ifdef CONFIG_RTL_8197F
	// for EMI
    rtl8367b_setAsicReg(0x13C3, 0x0000);	
    rtl8367b_setAsicReg(0x13C4, 0x0000);	
    rtl8367b_setAsicReg(0x1d53, 0x0001);	
    rtl8367b_setAsicReg(0x1d55, 0x000f);	
    rtl8367b_setAsicReg(0x1d54, 0x05fa);	
    rtl8367b_setAsicReg(0x1d52, 0x2473);	
    rtl8367b_setAsicReg(0x1d5a, 0x0001);	
    rtl8367b_setAsicReg(0x1d5c, 0x000f);	
    rtl8367b_setAsicReg(0x1d5b, 0x05fa);	
    rtl8367b_setAsicReg(0x1d59, 0x2473);	

    rtk_port_rgmiiDelayExt_set(EXT_PORT_FOR_HOST, 0, 5); // change rxDelay to 5 to enhance the compatibility of 8197F and 8367RB	
#endif
 
#if defined(CONFIG_RTK_REFINE_PORT_DUPLEX_MODE)
	rtk_forceFull_init();
#endif

#if defined(CONFIG_LAN_WAN_ISOLATION)
	{
	rtk_portmask_t pm;
	
	pm.bits[0] = 0xff;
	rtk_port_isolation_set(0, pm);
	rtk_port_isolation_set(1, pm);
	rtk_port_isolation_set(2, pm);
	rtk_port_isolation_set(3, pm);
	rtk_port_isolation_set(4, pm);
	}
#endif

    return ret; 
}

int RTL8367R_init_switch_mode(void)
{
    rtk_portmask_t portmask;
    unsigned int ret;
 
    /* Set external interface 0 to RGMII with Force mode, 1000M, Full-duple, enable TX&RX pause*/
    rtk_port_mac_ability_t mac_cfg;
    rtk_mode_ext_t mode ;
 
    /* Initial Chip */
    ret = rtk_switch_init();

    /* Enable LED Group 0&1 from P0 to P4 */
    portmask.bits[0]=0x1F;
    rtk_led_enable_set(LED_GROUP_0, portmask);
    rtk_led_enable_set(LED_GROUP_1, portmask);
 
    mode = MODE_EXT_RGMII ;
    mac_cfg.forcemode = MAC_FORCE;
    mac_cfg.speed = SPD_1000M;
    mac_cfg.duplex = FULL_DUPLEX;
    mac_cfg.link = PORT_LINKUP;
    mac_cfg.nway = DISABLED;
    mac_cfg.txpause = ENABLED;
    mac_cfg.rxpause = ENABLED;
    rtk_port_macForceLinkExt_set(EXT_PORT_1,mode,&mac_cfg);
 
    /* Set RGMII Interface 0 TX delay to 2ns and RX to step 4 */
    // set the tx/rx delay in 8197D site
    //rtk_port_rgmiiDelayExt_set(EXT_PORT_1, 1, 4);
    rtk_port_rgmiiDelayExt_set(EXT_PORT_1, 0, 2);
 
    /* set port 5 as CPU port */
    rtk_cpu_enable_set(ENABLE);
    rtk_cpu_tagPort_set(RTK_EXT_1_MAC, CPU_INSERT_TO_NONE);

    rtl8367b_setAsicReg(RTL8367B_REG_UNDA_FLOODING_PMSK, 0xff);
    rtl8367b_setAsicReg(RTL8367B_REG_UNMCAST_FLOADING_PMSK, 0xff);
    rtl8367b_setAsicReg(RTL8367B_REG_BCAST_FLOADING_PMSK, 0xff);

	rtk_switch_maxPktLen_set(MAXPKTLEN_16000B);
	rtl8367b_setAsicReg(0x1B03, 0x0222);

    return ret; 
}

#define BIT(nr)			(1UL << (nr))
#define WAN_VID			8
#define LAN_VID			9
#if defined(CONFIG_RTL_EXCHANGE_PORTMASK)
#define	RTL8367R_WAN			0		// WAN port is set to 8367R port 0
#else
#define	RTL8367R_WAN			4		// WAN port is set to 8367R port 4
#endif

#define	RTL_WANPORT_MASK		(0x1 << RTL8367R_WAN)
#define	RTL_LANPORT_MASK		(0x1f & (~RTL_WANPORT_MASK))

#define GATEWAY_MODE				0
#define BRIDGE_MODE				1

static  int rtl8197d_op_mode = 0;
extern rtk_uint32 r8367_cpu_port;

// refine RTL8367R_vlan_init() and RTL8367R_vlan_reinit()
#if 1

struct _vlan_conf {
	rtk_vlan_t 		vid;
	rtk_uint32		mbrmsk;
	rtk_uint32		untagmsk;
	rtk_fid_t			fid;
	rtk_pri_t 			priority;
};

#define _VID_END	(RTL8367B_VIDMAX+1)
#define _8367RB_RGMII2		7
#define BIT(nr)			(1UL << (nr))

// please assign different fid for them
struct _vlan_conf vc_gateway[] = {
#ifdef ENABLE_8367RB_RGMII2
	{ 	LAN_VID,	 	(RTL_LANPORT_MASK | BIT(_8367RB_RGMII2)),   	(RTL_LANPORT_MASK | BIT(_8367RB_RGMII2)),	0, 0 },
#else
	{ 	LAN_VID,	 	RTL_LANPORT_MASK,   	RTL_LANPORT_MASK,	0, 0 },
#endif	
	{	WAN_VID,	RTL_WANPORT_MASK,   RTL_WANPORT_MASK,	1, 0},
	{	PASSTHRU_VLAN_ID,	(RTL_LANPORT_MASK|RTL_WANPORT_MASK),   (RTL_LANPORT_MASK|RTL_WANPORT_MASK), 0, 0},//for IPv6	
	{	_VID_END,	0, 0, 0, 0}
};

struct _vlan_conf vc_bridge_svl[] = {
	{ 	LAN_VID,	 	(RTL_LANPORT_MASK | RTL_WANPORT_MASK),   	(RTL_LANPORT_MASK | RTL_WANPORT_MASK),	2, 0 },
	{	_VID_END,	0, 0, 0, 0}
};


int _vlan_setting(struct _vlan_conf vc[])
{
	int i, j, retval;
	rtk_portmask_t mbrmsk, untagmsk;

	for(i=0; vc[i].vid <= RTL8367B_VIDMAX; i++)
	{
		mbrmsk.bits[0] = (vc[i].mbrmsk) |BIT(r8367_cpu_port);
		untagmsk.bits[0] = (vc[i].untagmsk);
		retval = rtk_vlan_set(vc[i].vid, mbrmsk, untagmsk, vc[i].fid);

		if(vc[i].vid == PASSTHRU_VLAN_ID)		
			continue;
		
		/* set pvid*/	
		for(j=0;j<5;j++)
		{
			if  ((1<<j)& (vc[i].mbrmsk))
				rtk_vlan_portPvid_set(j, vc[i].vid, vc[i].priority);			
		}     	  
	}	
	return 0;
}

int RTL83XX_vlan_init(void)
{
	_vlan_setting(vc_gateway);

	rtl8197d_op_mode = GATEWAY_MODE;
	return 0;
}

int RTL83XX_vlan_reinit(int mode)
{
#if defined (CONFIG_RTL_IVL_SUPPORT)
	// when CONFIG_RTL_IVL_SUPPORT is defined, keep vc_gateway setting for gateway and bridge mode both
	
	rtk_l2_flushType_set(FLUSH_TYPE_BY_PORT, WAN_VID, r8367_cpu_port);				
#else

	if (mode==rtl8197d_op_mode) // no need tio do the re-initialization
		return 0;

	rtk_vlan_init();

	if (mode==GATEWAY_MODE)
		_vlan_setting(vc_gateway);
	
	else
		_vlan_setting(vc_bridge_svl);
		
#endif

	rtl8197d_op_mode = mode;	
	return 0;
}

#else
int RTL83XX_vlan_init(void)
{
	int i, retval;
	rtk_portmask_t mbrmsk, untagmsk;

	/* for lan */
	mbrmsk.bits[0] = RTL_LANPORT_MASK|BIT(r8367_cpu_port);
	untagmsk.bits[0] = RTL_LANPORT_MASK;
	retval = rtk_vlan_set(LAN_VID, mbrmsk, untagmsk, 0);

	for(i=0;i<5;i++) {
		if  ((1<<i)&RTL_LANPORT_MASK)
		{
			retval = rtk_vlan_portPvid_set(i, LAN_VID, 0);			
		}
	}
		
	/* for wan */
	mbrmsk.bits[0] = RTL_WANPORT_MASK|BIT(r8367_cpu_port);
	untagmsk.bits[0] = RTL_WANPORT_MASK;
	retval = rtk_vlan_set(WAN_VID, mbrmsk, untagmsk, 1);

	for(i=0;i<5;i++) {
		if  ((1<<i)&RTL_WANPORT_MASK)
		{
			retval = rtk_vlan_portPvid_set(i, WAN_VID, 0);
		}
	}

	rtl8197d_op_mode = GATEWAY_MODE;
	return 0;
}

int RTL83XX_vlan_reinit(int mode)
{
	int i, retval;
	rtk_portmask_t mbrmsk, untagmsk;

	if (mode==rtl8197d_op_mode) // no need tio do the re-initialization
		return 0;

	rtk_vlan_init();
	
	if (mode==GATEWAY_MODE)
	{
		/* for lan */
		mbrmsk.bits[0] = RTL_LANPORT_MASK|BIT(r8367_cpu_port);
		untagmsk.bits[0] = RTL_LANPORT_MASK;
		retval = rtk_vlan_set(LAN_VID, mbrmsk, untagmsk, 0);

		for(i=0;i<5;i++) {
			if  ((1<<i)&RTL_LANPORT_MASK)
			{
				retval = rtk_vlan_portPvid_set(i, LAN_VID, 0);			
			}
		}
	
		/* for wan */
		mbrmsk.bits[0] = RTL_WANPORT_MASK|BIT(r8367_cpu_port);
		untagmsk.bits[0] = RTL_WANPORT_MASK;
		retval = rtk_vlan_set(WAN_VID, mbrmsk, untagmsk, 1);

		for(i=0;i<5;i++) {
			if  ((1<<i)&RTL_WANPORT_MASK)
			{
				retval = rtk_vlan_portPvid_set(i, WAN_VID, 0);
			}
		}		
	} 
	else {
		/* for lan */
		mbrmsk.bits[0] = (RTL_LANPORT_MASK | RTL_WANPORT_MASK) |BIT(r8367_cpu_port);
		untagmsk.bits[0] = (RTL_LANPORT_MASK | RTL_WANPORT_MASK);
		retval = rtk_vlan_set(LAN_VID, mbrmsk, untagmsk, 0);

		for(i=0;i<5;i++) {
			if  ((1<<i)&(RTL_LANPORT_MASK | RTL_WANPORT_MASK))
			{
				retval = rtk_vlan_portPvid_set(i, LAN_VID, 0);			
			}
		}		
	}
	rtl8197d_op_mode = mode;
	
	return 0;
}
#endif

#define RTL8367R_WAN_PORT_BITMAP 		(1<<RTL8367R_WAN)
#define RTL8367R_LAN_PORT_BITMAP 		(0x1f - RTL8367R_WAN_PORT_BITMAP)
#define RTL8367R_LAN_EFID				2
extern int rtl865x_curOpMode;

#if defined(CONFIG_RTL_VLAN_8021Q) && defined(CONFIG_RTL_8367R_SUPPORT)
#if 0
int rtl_vlan_RTL8367R_set(unsigned short vid, unsigned int tagmask, unsigned int mask)
{
	rtk_portmask_t mbrmsk, untag;
	rtk_api_ret_t retVal;
	int i;
    unsigned untagmask;

    if(vid==WAN_VID || vid == LAN_VID)
        return 0;

    untagmask = mask&(~tagmask);
    
    mbrmsk.bits[0] = (BIT(r8367_cpu_port)|RTL8367R_WAN_PORT_BITMAP|RTL8367R_LAN_PORT_BITMAP);

    //panic_printk("untagmsk is 0x%x\n", (untagmask&RTL8367R_LAN_PORT_BITMAP));
    
    if(tagmask&RTL8367R_WAN_PORT_BITMAP)
        untag.bits[0] = 0;
    else
        untag.bits[0] = (BIT(r8367_cpu_port)|RTL8367R_WAN_PORT_BITMAP|(untagmask&RTL8367R_LAN_PORT_BITMAP));

    retVal=rtk_vlan_set(vid, mbrmsk, untag, 0); 
    
	return 0;
}
#else
int rtl_vlan_RTL8367R_set(unsigned short vid, unsigned int tagmask, unsigned int mask, unsigned int fid)
{
	int retval;
	rtk_portmask_t mbrmsk, untagmsk;
    
    unsigned untagmask;
    untagmask = mask&(~tagmask);
    if (mask == 0 && tagmask == 0)//clear
    {
		mbrmsk.bits[0] = mask;
		untagmsk.bits[0] = untagmask;
    }
    else
	{
		mbrmsk.bits[0] = (mask) |BIT(r8367_cpu_port);
		//mbrmsk.bits[0] = (mask);
		untagmsk.bits[0] = untagmask;
        //panic_printk("%s %d vid = %u mbrmsk.bits[0]=%u untagmsk.bits[0]=%u\n", __FUNCTION__, __LINE__, vid, mbrmsk.bits[0], untagmsk.bits[0]);
	}
    
    retval = rtk_vlan_set(vid, mbrmsk, untagmsk, fid);        
    
	return 0;
}

#endif

int rtl_8367r_vlan_get(unsigned int i, unsigned int *mbrmsk, unsigned int *untagmsk, unsigned int *fid)
{
	rtk_portmask_t Mbrmsk = {{0}}, Untagmsk = {{0}};
	rtk_fid_t Fid = 0;
	rtk_api_ret_t ret = 0;
	
	if (!mbrmsk || !untagmsk || !fid)
		return -1;
	
	ret = rtk_vlan_get(i, &Mbrmsk, &Untagmsk, &Fid);
	if (ret == RT_ERR_OK)
	{
		*mbrmsk = Mbrmsk.bits[0];
		*untagmsk = Untagmsk.bits[0];
		*fid = Fid;
		return 0;
	}

	return -1;
}
#endif

int RTL8367R_vlan_set(void)
{
	rtk_portmask_t mbrmsk, untag;
	rtk_api_ret_t retVal;
	int i;
	
 	for(i=0;i<4096;i++)
 	{ 	
 		//if (i==WAN_VID ||i==LAN_VID)
 		#ifdef CONFIG_RTL_VLAN_8021Q
 		if (i==WAN_VID || i==LAN_VID || i==1
		#if defined(CONFIG_RTL_CUSTOM_PASSTHRU) 
			||i==PASSTHRU_VLAN_ID
		#endif	
			)
        #else
 		if (i==WAN_VID ||i==LAN_VID || (i==10) || (i==11) || (i==12)	
		#if defined(CONFIG_RTL_CUSTOM_PASSTHRU)
			||i==PASSTHRU_VLAN_ID
		#endif	
		) /* RTK VLAN */
        #endif
 		{
 			mbrmsk.bits[0] = (BIT(r8367_cpu_port)|RTL8367R_WAN_PORT_BITMAP|RTL8367R_LAN_PORT_BITMAP);
 			untag.bits[0] = (BIT(r8367_cpu_port)|RTL8367R_WAN_PORT_BITMAP|RTL8367R_LAN_PORT_BITMAP);
 		}
 		else
 		{
 			mbrmsk.bits[0] = (BIT(r8367_cpu_port)|RTL8367R_WAN_PORT_BITMAP|RTL8367R_LAN_PORT_BITMAP);
 			untag.bits[0] = 0;
 		} 	
 		retVal=rtk_vlan_set(i, mbrmsk, untag, 0); //all vlan's fid is 0 
 	}

	/* set pvid :  wan:8   lan:9  */	
	for(i=0;i<5;i++)
	{
		#if defined (CONFIG_RTL_IVL_SUPPORT)
		if (i == RTL8367R_WAN)
			retVal=rtk_vlan_portPvid_set(i, WAN_VID,0);
		else
			retVal=rtk_vlan_portPvid_set(i, LAN_VID,0);
		#else
		if(rtl865x_curOpMode==GATEWAY_MODE){
			if (i == RTL8367R_WAN)
				retVal=rtk_vlan_portPvid_set(i, WAN_VID,0);
			else
				retVal=rtk_vlan_portPvid_set(i, LAN_VID,0);
		}else{
			retVal=rtk_vlan_portPvid_set(i, LAN_VID,0);
		}
		#endif
	}       
	
	/* set wan port efid=1, other ports efid=2 */
	for(i=0;i<5;i++)
	{
		#if defined (CONFIG_RTL_IVL_SUPPORT)
		if (i == RTL8367R_WAN)
			retVal = rtk_port_efid_set(i,1);
		else
			retVal = rtk_port_efid_set(i,RTL8367R_LAN_EFID);
		#else
		if(rtl865x_curOpMode==GATEWAY_MODE){
			if (i == RTL8367R_WAN)
				retVal = rtk_port_efid_set(i,1);
			else
				retVal = rtk_port_efid_set(i,RTL8367R_LAN_EFID);
		}else{
			retVal = rtk_port_efid_set(i,RTL8367R_LAN_EFID);
		}
		#endif
	}

	// suggested by HM-Chung
#if defined (CONFIG_RTL_IVL_SUPPORT)	
	for (i=0; i<5; i++)
	{
		if (i == RTL8367R_WAN) 
			mbrmsk.bits[0] = BIT(r8367_cpu_port);    
		else
			mbrmsk.bits[0] = 0xff & ~BIT(RTL8367R_WAN); 
		rtk_port_isolation_set(i, mbrmsk);
	}    
#else	
	for (i=0; i<5; i++)
	{
		if (rtl865x_curOpMode == GATEWAY_MODE) {
			if (i == RTL8367R_WAN) 
				mbrmsk.bits[0] = BIT(r8367_cpu_port);    
			else
				mbrmsk.bits[0] = 0xff & ~BIT(RTL8367R_WAN); 
		}
		else
			mbrmsk.bits[0] = 0xff; 
			
		rtk_port_isolation_set(i, mbrmsk);
	}    
#endif

#if defined (CONFIG_RTL_IVL_SUPPORT)
	//if (rtl865x_curOpMode != GATEWAY_MODE) 
	{	// no matter Gateway or Bridge mode, always disable wan port L2 learning
		rtk_l2_limitLearningCnt_set(RTL8367R_WAN, 0);
		rtk_l2_flushType_set(FLUSH_TYPE_BY_PORT, WAN_VID, RTL8367R_WAN);		
	}
#else
	if (rtl865x_curOpMode == GATEWAY_MODE) {
		rtk_l2_limitLearningCnt_set(RTL8367R_WAN, 0);
		rtk_l2_flushType_set(FLUSH_TYPE_BY_PORT, WAN_VID, RTL8367R_WAN);		
		rtk_l2_flushType_set(FLUSH_TYPE_BY_PORT, LAN_VID, RTL8367R_WAN);		
	}
	else {
		rtk_l2_limitLearningCnt_set(RTL8367R_WAN, 2112);
		rtk_l2_flushType_set(FLUSH_TYPE_BY_PORT, WAN_VID, RTL8367R_WAN);		
		rtk_l2_flushType_set(FLUSH_TYPE_BY_PORT, LAN_VID, RTL8367R_WAN);		
	}
#endif

	/* disable cpu port's mac addr learning ability */
	rtl8367b_setAsicLutLearnLimitNo(r8367_cpu_port,0);
	
	/* disable unknown unicast/mcast/bcast flooding between LAN ports */
	smi_write(RTL8367B_REG_UNDA_FLOODING_PMSK, BIT(r8367_cpu_port));
	smi_write(RTL8367B_REG_UNMCAST_FLOADING_PMSK, BIT(r8367_cpu_port));
	smi_write(RTL8367B_REG_BCAST_FLOADING_PMSK, BIT(r8367_cpu_port));
	
	return 0;
}

void RTL8367R_cpu_tag(int enable)
{
	if(enable){
		rtl8367b_setAsicReg(RTL8367B_REG_CPU_PORT_MASK,1<<r8367_cpu_port); //set CPU port
		rtl8367b_setAsicReg(RTL8367B_REG_CPU_CTRL,0x281|(r8367_cpu_port)<<RTL8367B_CPU_TRAP_PORT_OFFSET);
	}
	else{
		rtl8367b_setAsicReg(RTL8367B_REG_CPU_CTRL,0x280|(r8367_cpu_port)<<RTL8367B_CPU_TRAP_PORT_OFFSET);
	}
}

void set_8367r_L2(unsigned int *mac, int intf_wan, int is_static)
{
	rtk_mac_t Mac;
	rtk_l2_ucastAddr_t L2_data;
		
	memset(&L2_data, 0, sizeof(rtk_l2_ucastAddr_t));
	
	L2_data.efid= (intf_wan)? 1 : 2;
	L2_data.port=r8367_cpu_port;
	L2_data.is_static=is_static;

	memcpy(&Mac.octet[0], mac, 6);
	rtk_l2_addr_add(&Mac,  &L2_data);
}

void del_83XX_L2(rtk_mac_t *pMac)
{
	rtk_l2_ucastAddr_t L2_data;

	memset(&L2_data, 0, sizeof(rtk_l2_ucastAddr_t));
	L2_data.fid = 0;
	L2_data.efid = RTL8367R_LAN_EFID;
	
	if (rtk_l2_addr_get(pMac, &L2_data) == RT_ERR_OK)
		rtk_l2_addr_del(pMac, &L2_data);

	return;
}

#if 0
void get_all_L2(void)
{
	int i, ret;
	rtk_l2_addr_table_t p;
		
	for (i=1; i<=RTK_MAX_NUM_OF_LEARN_LIMIT;i++)
	{
		p.index = i;
		ret = rtk_l2_entry_get(&p);
		if (ret == RT_ERR_OK)
		{
			printk(" [%d] mac: %02x:%02x:%02x:%02x:%02x:%02x, portmask: 0x%x, age: %d, fid: %d\n", i,
				p.mac.octet[0],p.mac.octet[1],p.mac.octet[2],p.mac.octet[3],p.mac.octet[4],p.mac.octet[5],
				p.portmask, p.age, p.fid);			
		}
	}
	return;
}
#endif

enum 
{
	PORT_DOWN=0,
	HALF_DUPLEX_10M,
	HALF_DUPLEX_100M,
	HALF_DUPLEX_1000M,
	DUPLEX_10M,
	DUPLEX_100M,
	DUPLEX_1000M,
	PORT_AUTO
};

rtk_api_ret_t set_83XX_speed_mode(int port, int mode)
{
	rtk_port_phy_ability_t phyAbility;

	memset(&phyAbility, 0, sizeof(rtk_port_phy_ability_t));

	phyAbility.FC = 1;
	phyAbility.AsyFC = 1;
	phyAbility.AutoNegotiation = 1;

	if (mode == HALF_DUPLEX_10M) //10M half
	{
		phyAbility.Half_10 = 1;
	}
	else if (mode == DUPLEX_10M)	//10M full
	{
		phyAbility.Full_10 = 1;
	}
	else if (mode == HALF_DUPLEX_100M) // 100M half
	{
		phyAbility.Half_100 = 1;
	}
	else if (mode == DUPLEX_100M) // 100M full
	{
		phyAbility.Full_100 = 1;
	}
	else if (mode == DUPLEX_1000M) // 1000M
	{
		phyAbility.Full_1000 = 1;
	}
	else
	{
		phyAbility.Half_10 = 1;
		phyAbility.Full_10 = 1;
		phyAbility.Half_100 = 1;
		phyAbility.Full_100 = 1;
		phyAbility.Full_1000 = 1;
	}

	return (rtk_port_phyAutoNegoAbility_set(port, &phyAbility));
}

void rtl83XX_reset(void)
{
	rtl8367b_setAsicReg(RTL8367B_REG_CHIP_RESET, (1<<RTL8367B_CHIP_RST_OFFSET));	
	return;
}

#if defined(CONFIG_RTL_CUSTOM_PASSTHRU)
int rtl8367_setProtocolBasedVLAN(rtk_vlan_proto_type_t proto_type,rtk_vlan_t cvid, int cmdFlag)
{
	rtk_port_t port;
	int ret;
	rtk_vlan_protoAndPortInfo_t info;
	info.proto_type=proto_type;
   	info.frame_type=FRAME_TYPE_ETHERNET;
    info.cvid=cvid;
    info.cpri=0;
	
	if(cmdFlag==TRUE)
	{
		//printk("ADD[%s]:[%d].\n",__FUNCTION__,__LINE__);
		/*add */
		for(port=0;port<5;port++){
			
			ret=rtk_vlan_protoAndPortBasedVlan_add(port, info);
			
		}
	}
	else
	{
		//printk("DEL[%s]:[%d].\n",__FUNCTION__,__LINE__);
		/*delete */
		for(port=0;port<5;port++){
			
			ret=rtk_vlan_protoAndPortBasedVlan_del(port,  proto_type, FRAME_TYPE_ETHERNET);
		}
	}
	return ret;
}
#endif

#if defined(CONFIG_RTK_VLAN_SUPPORT) || defined(CONFIG_RTL_VLAN_8021Q) || defined(CONFIG_OPENWRT_SDK) || defined(CONFIG_RTL_HW_VLAN_SUPPORT)
int rtl865x_enableRtl8367ToCpuAcl(void)
{
	int retVal;
	rtk_filter_field_t	filter_field[2];
	rtk_filter_cfg_t	cfg;
	rtk_filter_action_t	act;
	rtk_filter_number_t	ruleNum = 0;

         memset(filter_field, 0, 2*sizeof(rtk_filter_field_t));
         memset(&cfg, 0, sizeof(rtk_filter_cfg_t));
         memset(&act, 0, sizeof(rtk_filter_action_t));
         filter_field[0].fieldType  = FILTER_FIELD_DMAC;
         if ((retVal = rtk_filter_igrAcl_field_add(&cfg,	&filter_field[0])) != RT_ERR_OK)
         	return retVal;

         /*add all ports to active ports*/
         cfg.activeport.dataType = FILTER_FIELD_DATA_MASK;
         cfg.activeport.value = 0x1F;
         cfg.activeport.mask = 0xFF;
         cfg.invert = FALSE;
         act.actEnable[FILTER_ENACT_TRAP_CPU] = TRUE;
         if ((retVal = rtk_filter_igrAcl_cfg_add(0, &cfg, &act, &ruleNum)) != RT_ERR_OK)
              	return retVal;
         return RT_ERR_OK;
}

int rtl865x_disableRtl8367ToCpuAcl(void)
{
	return rtk_filter_igrAcl_cfg_del(0);
}
#endif

#if defined(CONFIG_RTK_REFINE_PORT_DUPLEX_MODE)
#define MIB_STATE_FRAG_VAL_UPDATE_BASE		0x13A0
#define MIB_STATE_FRAG_CTL_UPDATE_BASE	0x13A4
int rtk_refinePortDuplexMode(void)
{
	rtk_stat_counter_t stateFragCounters = 0;
	int port;
	
	for(port=0; port<4; port++)
	{
		rtk_stat_port_get(port, STAT_EtherStatsFragments, &stateFragCounters);
		//if(port == 1)
			//printk("stateFragCounters is %d\n", (unsigned short)stateFragCounters);
		rtl8367b_setAsicReg(MIB_STATE_FRAG_VAL_UPDATE_BASE+port, (unsigned short)stateFragCounters);
		rtl8367b_setAsicReg(MIB_STATE_FRAG_CTL_UPDATE_BASE+port, 0x1);
	}
	return RT_ERR_OK;
}


rtk_api_ret_t rtk_forceFull_init(void)
{
    rtk_api_ret_t retVal;
//    rtk_uint32 busyFlag;    
    rtk_uint16 i,length;
    static rtk_uint8 iromCode[] = {
    0x02,0x05,0xFE,0x02,0x04,0x23,0x7D,0x06,
    0x7C,0x11,0x7F,0xC2,0x7E,0x12,0x12,0x05,
    0xE2,0x7D,0x05,0x7C,0x20,0x7F,0xC3,0x7E,
    0x12,0x12,0x05,0xE2,0x7D,0x51,0x7C,0x00,
    0x7F,0x36,0x7E,0x13,0x12,0x05,0xE2,0xE4,
    0x90,0x00,0x00,0xF0,0xA3,0xF0,0x90,0x00,
    0x06,0xF0,0xA3,0xF0,0xA3,0xF0,0xA3,0xF0,
    0x90,0x00,0x1A,0xF0,0x90,0x00,0x1A,0xE0,
    0xFF,0xC3,0x94,0x04,0x50,0x59,0x74,0x01,
    0x7E,0x00,0xA8,0x07,0x08,0x80,0x05,0xC3,
    0x33,0xCE,0x33,0xCE,0xD8,0xF9,0x54,0x0F,
    0x60,0x11,0x90,0x00,0x1A,0xE0,0x24,0x12,
    0xFF,0xE4,0x34,0x13,0xFE,0xE4,0xFD,0xFC,
    0x12,0x05,0xE2,0x90,0x00,0x1A,0xE0,0xFF,
    0x25,0xE0,0x24,0x0A,0xF5,0x82,0xE4,0x34,
    0x00,0xF5,0x83,0xE4,0xF0,0xA3,0xF0,0x74,
    0x02,0x2F,0xF5,0x82,0xE4,0x34,0x00,0xF5,
    0x83,0xE4,0xF0,0x74,0x12,0x2F,0xF5,0x82,
    0xE4,0x34,0x00,0xF5,0x83,0xE4,0xF0,0x90,
    0x00,0x1A,0xE0,0x04,0xF0,0x80,0x9D,0x12,
    0x06,0x14,0x7D,0x01,0x7C,0x00,0x7F,0x18,
    0x7E,0x11,0x12,0x05,0xE2,0x90,0x00,0x00,
    0xE0,0x70,0x02,0xA3,0xE0,0x70,0x03,0x02,
    0x02,0xB0,0xE4,0x90,0x00,0x1A,0xF0,0x90,
    0x00,0x1A,0xE0,0xFF,0xC3,0x94,0x04,0x40,
    0x03,0x02,0x02,0xB0,0x74,0x01,0x7E,0x00,
    0xA8,0x07,0x08,0x80,0x05,0xC3,0x33,0xCE,
    0x33,0xCE,0xD8,0xF9,0xFF,0x90,0x00,0x00,
    0xE0,0x5E,0xFE,0xA3,0xE0,0x5F,0x4E,0x70,
    0x03,0x02,0x02,0xA7,0x90,0x00,0x1A,0xE0,
    0xFF,0x24,0x02,0xF5,0x82,0xE4,0x34,0x00,
    0xF5,0x83,0xE0,0x70,0x67,0xEF,0x24,0xA4,
    0xFF,0xE4,0x34,0x13,0xFE,0x12,0x05,0xBE,
    0x90,0x00,0x1F,0xEE,0xF0,0xA3,0xEF,0xF0,
    0x4E,0x70,0x03,0x02,0x02,0xA7,0x90,0x00,
    0x1A,0xE0,0xFF,0x24,0x02,0xF5,0x82,0xE4,
    0x34,0x00,0xF5,0x83,0x74,0x01,0xF0,0xEF,
    0x24,0xA0,0xFF,0xE4,0x34,0x13,0xFE,0x12,
    0x05,0xBE,0x90,0x00,0x1A,0xE0,0xFD,0x25,
    0xE0,0x24,0x0A,0xF5,0x82,0xE4,0x34,0x00,
    0xF5,0x83,0xEE,0xF0,0xA3,0xEF,0xF0,0x74,
    0x12,0x2D,0xF5,0x82,0xE4,0x34,0x00,0xF5,
    0x83,0xE4,0xF0,0xED,0x24,0xA4,0xFF,0xE4,
    0x34,0x13,0xFE,0xE4,0xFD,0xFC,0x12,0x05,
    0xE2,0x02,0x02,0xA7,0xE4,0x90,0x00,0x21,
    0xF0,0x90,0x00,0x1A,0xE0,0x24,0xA4,0xFF,
    0xE4,0x34,0x13,0xFE,0x12,0x05,0xBE,0x90,
    0x00,0x1F,0xEE,0xF0,0xA3,0xEF,0xF0,0x4E,
    0x70,0x03,0x02,0x02,0x4C,0x90,0x00,0x1A,
    0xE0,0x24,0xA0,0xFF,0xE4,0x34,0x13,0xFE,
    0x12,0x05,0xBE,0x90,0x00,0x1B,0xEE,0xF0,
    0xA3,0xEF,0xF0,0x90,0x00,0x1A,0xE0,0xFD,
    0x25,0xE0,0x24,0x0A,0xF5,0x82,0xE4,0x34,
    0x00,0xF5,0x83,0xE0,0xFA,0xA3,0xE0,0x6F,
    0x70,0x02,0xEA,0x6E,0x60,0x59,0x90,0x00,
    0x1A,0xE0,0xFF,0x24,0x12,0xF5,0x82,0xE4,
    0x34,0x00,0xF5,0x83,0xE0,0x04,0xF0,0xEF,
    0x24,0xD4,0xFF,0xE4,0x34,0x12,0xFE,0x74,
    0x12,0x2D,0xF5,0x82,0xE4,0x34,0x00,0xF5,
    0x83,0xE0,0xFD,0x7C,0x00,0x12,0x05,0xE2,
    0x90,0x00,0x1A,0xE0,0x24,0xD0,0xFF,0xE4,
    0x34,0x12,0xFE,0xA3,0xE0,0xFC,0xA3,0xE0,
    0xFD,0x12,0x05,0xE2,0x90,0x00,0x1A,0xE0,
    0x24,0x12,0xF5,0x82,0xE4,0x34,0x00,0xF5,
    0x83,0xE0,0xD3,0x94,0x0A,0x40,0x34,0x90,
    0x00,0x21,0x74,0x01,0xF0,0x80,0x2C,0x90,
    0x00,0x1A,0xE0,0xFF,0x24,0x12,0xF5,0x82,
    0xE4,0x34,0x00,0xF5,0x83,0xE4,0xF0,0xEF,
    0x24,0xD4,0xFF,0xE4,0x34,0x12,0xFE,0x90,
    0x00,0x1A,0xE0,0x24,0x12,0xF5,0x82,0xE4,
    0x34,0x00,0xF5,0x83,0xE0,0xFD,0x7C,0x00,
    0x12,0x05,0xE2,0x90,0x00,0x1A,0xE0,0x24,
    0xA4,0xFF,0xE4,0x34,0x13,0xFE,0xE4,0xFD,
    0xFC,0x12,0x05,0xE2,0x90,0x00,0x21,0xE0,
    0x60,0x55,0x90,0x00,0x1A,0xE0,0x24,0x52,
    0xFF,0xE4,0x34,0x13,0xFE,0x12,0x05,0xBE,
    0xEE,0x44,0x10,0xAD,0x07,0xFC,0xED,0x54,
    0xFB,0xFD,0x90,0x00,0x1A,0xE0,0x24,0x12,
    0xFF,0xE4,0x34,0x13,0xFE,0x12,0x05,0xE2,
    0x90,0x00,0x1A,0xE0,0xFF,0x74,0x01,0x7E,
    0x00,0xA8,0x07,0x08,0x80,0x05,0xC3,0x33,
    0xCE,0x33,0xCE,0xD8,0xF9,0xFF,0xF4,0xFD,
    0xEE,0xF4,0xFC,0x90,0x00,0x00,0xE0,0x5C,
    0xF0,0xA3,0xE0,0x5D,0xF0,0x90,0x00,0x06,
    0xE0,0x4E,0xF0,0xA3,0xE0,0x4F,0xF0,0x90,
    0x00,0x1A,0xE0,0x04,0xF0,0x02,0x00,0xBF,
    0x90,0x00,0x08,0xE0,0x70,0x02,0xA3,0xE0,
    0x70,0x03,0x02,0x03,0x6A,0xE4,0x90,0x00,
    0x1A,0xF0,0x90,0x00,0x1A,0xE0,0xFF,0xC3,
    0x94,0x04,0x40,0x03,0x02,0x03,0x6A,0x74,
    0x01,0x7E,0x00,0xA8,0x07,0x08,0x80,0x05,
    0xC3,0x33,0xCE,0x33,0xCE,0xD8,0xF9,0xFF,
    0x90,0x00,0x08,0xE0,0x5E,0xFE,0xA3,0xE0,
    0x5F,0x4E,0x60,0x75,0x90,0x00,0x1A,0xE0,
    0x75,0xF0,0x20,0xA4,0x24,0x01,0xFF,0xE5,
    0xF0,0x34,0x20,0xFE,0x12,0x05,0xBE,0xEF,
    0x20,0xE2,0x5E,0x90,0x00,0x1A,0xE0,0x24,
    0x12,0xFF,0xE4,0x34,0x13,0xFE,0xE4,0xFD,
    0xFC,0x12,0x05,0xE2,0x90,0x00,0x1A,0xE0,
    0xF9,0x74,0x01,0x7E,0x00,0xA8,0x01,0x08,
    0x80,0x05,0xC3,0x33,0xCE,0x33,0xCE,0xD8,
    0xF9,0xF4,0xFF,0xEE,0xF4,0xFE,0x90,0x00,
    0x00,0xE0,0x5E,0xF0,0xA3,0xE0,0x5F,0xF0,
    0x90,0x00,0x08,0xE0,0x5E,0xF0,0xA3,0xE0,
    0x5F,0xF0,0x74,0x01,0x7E,0x00,0xA8,0x01,
    0x08,0x80,0x05,0xC3,0x33,0xCE,0x33,0xCE,
    0xD8,0xF9,0xF4,0xFF,0xEE,0xF4,0xFE,0x90,
    0x00,0x06,0xE0,0x5E,0xF0,0xA3,0xE0,0x5F,
    0xF0,0x90,0x00,0x1A,0xE0,0x04,0xF0,0x02,
    0x02,0xC2,0x90,0x00,0x00,0xE0,0xFC,0xA3,
    0xE0,0xFD,0x7F,0xC4,0x7E,0x12,0x12,0x05,
    0xE2,0x90,0x00,0x08,0xE0,0xFC,0xA3,0xE0,
    0xFD,0x7F,0xC5,0x7E,0x12,0x12,0x05,0xE2,
    0x90,0x00,0x06,0xE0,0xFC,0xA3,0xE0,0xFD,
    0x7F,0xC6,0x7E,0x12,0x12,0x05,0xE2,0x90,
    0x00,0x02,0xE0,0xFD,0x7C,0x00,0x7F,0xC8,
    0x7E,0x12,0x12,0x05,0xE2,0x90,0x00,0x03,
    0xE0,0xFD,0x7C,0x00,0x7F,0xC9,0x7E,0x12,
    0x12,0x05,0xE2,0x90,0x00,0x04,0xE0,0xFD,
    0x7C,0x00,0x7F,0xCA,0x7E,0x12,0x12,0x05,
    0xE2,0x90,0x00,0x05,0xE0,0xFD,0x7C,0x00,
    0x7F,0xCB,0x7E,0x12,0x12,0x05,0xE2,0x90,
    0x00,0x0A,0xE0,0xFC,0xA3,0xE0,0xFD,0x7F,
    0xCC,0x7E,0x12,0x12,0x05,0xE2,0x90,0x00,
    0x0C,0xE0,0xFC,0xA3,0xE0,0xFD,0x7F,0xCD,
    0x7E,0x12,0x12,0x05,0xE2,0x90,0x00,0x0E,
    0xE0,0xFC,0xA3,0xE0,0xFD,0x7F,0xCE,0x7E,
    0x12,0x12,0x05,0xE2,0x90,0x00,0x10,0xE0,
    0xFC,0xA3,0xE0,0xFD,0x7F,0xCF,0x7E,0x12,
    0x12,0x05,0xE2,0x7F,0xC1,0x7E,0x12,0x12,
    0x05,0xBE,0xEF,0x24,0x01,0xFD,0xE4,0x3E,
    0xFC,0x7F,0xC1,0x7E,0x12,0x12,0x05,0xE2,
    0x02,0x00,0xAD,0xC0,0xE0,0xC0,0xF0,0xC0,
    0x83,0xC0,0x82,0xC0,0xD0,0x75,0xD0,0x00,
    0xC0,0x00,0xC0,0x01,0xC0,0x02,0xC0,0x03,
    0xC0,0x04,0xC0,0x05,0xC0,0x06,0xC0,0x07,
    0xC2,0xAF,0x7F,0x24,0x7E,0x11,0x12,0x05,
    0xBE,0x90,0x00,0x18,0xEE,0xF0,0xA3,0xEF,
    0xF0,0x7F,0x23,0x7E,0x11,0x12,0x05,0xBE,
    0x90,0x00,0x16,0xEE,0xF0,0xA3,0xEF,0xF0,
    0x78,0x0C,0x76,0x00,0x78,0x0C,0xE6,0xFF,
    0xC3,0x94,0x04,0x40,0x03,0x02,0x05,0x5C,
    0x74,0x01,0x7E,0x00,0xA8,0x07,0x08,0x80,
    0x05,0xC3,0x33,0xCE,0x33,0xCE,0xD8,0xF9,
    0xFF,0x90,0x00,0x18,0xE0,0x5E,0xFC,0xA3,
    0xE0,0x5F,0x4C,0x70,0x03,0x02,0x05,0x56,
    0xEF,0x54,0x0F,0x70,0x03,0x02,0x05,0x56,
    0x78,0x0C,0xE6,0x75,0xF0,0x20,0xA4,0x24,
    0x05,0xFF,0xE5,0xF0,0x34,0x20,0xFE,0x12,
    0x05,0xBE,0xEE,0x30,0xE6,0x03,0x02,0x05,
    0x56,0x78,0x0C,0xE6,0x24,0x52,0xFF,0xE4,
    0x34,0x13,0xFE,0x12,0x05,0xBE,0xAD,0x07,
    0xAC,0x06,0xED,0x30,0xE2,0x03,0x02,0x05,
    0x56,0x20,0xE7,0x03,0x02,0x05,0x56,0x78,
    0x0C,0xE6,0xF9,0x74,0x01,0x7E,0x00,0xA8,
    0x01,0x08,0x80,0x05,0xC3,0x33,0xCE,0x33,
    0xCE,0xD8,0xF9,0xFF,0x90,0x00,0x06,0xE0,
    0x5E,0xFE,0xA3,0xE0,0x5F,0x4E,0x70,0x66,
    0x04,0x7E,0x00,0xA8,0x01,0x08,0x80,0x05,
    0xC3,0x33,0xCE,0x33,0xCE,0xD8,0xF9,0xFF,
    0x90,0x00,0x00,0xE0,0x4E,0xF0,0xA3,0xE0,
    0x4F,0xF0,0x74,0x01,0x7E,0x00,0xA8,0x01,
    0x08,0x80,0x05,0xC3,0x33,0xCE,0x33,0xCE,
    0xD8,0xF9,0xFF,0x90,0x00,0x08,0xE0,0x4E,
    0xF0,0xA3,0xE0,0x4F,0xF0,0xE9,0x24,0x12,
    0xFF,0xE4,0x34,0x13,0xFE,0xEC,0x44,0x10,
    0xFC,0xED,0x44,0x04,0xFD,0x12,0x05,0xE2,
    0x78,0x0C,0xE6,0x24,0xA4,0xFF,0xE4,0x34,
    0x13,0xFE,0xE4,0xFD,0xFC,0x12,0x05,0xE2,
    0x78,0x0C,0xE6,0x24,0x02,0xF5,0x82,0xE4,
    0x34,0x00,0xF5,0x83,0xE4,0xF0,0x78,0x0C,
    0x06,0x02,0x04,0x64,0x90,0x00,0x18,0xE0,
    0xFC,0xA3,0xE0,0xFD,0x7F,0x24,0x7E,0x11,
    0x12,0x05,0xE2,0x90,0x00,0x16,0xE0,0xFC,
    0xA3,0xE0,0xFD,0x7F,0x23,0x7E,0x11,0x12,
    0x05,0xE2,0x7F,0x19,0x7E,0x11,0x12,0x05,
    0xBE,0xAC,0x06,0xAD,0x07,0x7F,0x19,0x7E,
    0x11,0x12,0x05,0xE2,0x7F,0xC0,0x7E,0x12,
    0x12,0x05,0xBE,0xEF,0x24,0x01,0xFD,0xE4,
    0x3E,0xFC,0x7F,0xC0,0x7E,0x12,0x12,0x05,
    0xE2,0xD2,0xAF,0xD0,0x07,0xD0,0x06,0xD0,
    0x05,0xD0,0x04,0xD0,0x03,0xD0,0x02,0xD0,
    0x01,0xD0,0x00,0xD0,0xD0,0xD0,0x82,0xD0,
    0x83,0xD0,0xF0,0xD0,0xE0,0x32,0xC2,0xAF,
    0xAD,0x07,0xAC,0x06,0x8C,0xA2,0x8D,0xA3,
    0x75,0xA0,0x01,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0xAE,0xA1,
    0xBE,0x00,0xF0,0xAE,0xA6,0xAF,0xA7,0xD2,
    0xAF,0x22,0xC2,0xAF,0xAB,0x07,0xAA,0x06,
    0x8A,0xA2,0x8B,0xA3,0x8C,0xA4,0x8D,0xA5,
    0x75,0xA0,0x03,0x00,0x00,0x00,0xAA,0xA1,
    0xBA,0x00,0xF8,0xD2,0xAF,0x22,0x78,0x7F,
    0xE4,0xF6,0xD8,0xFD,0x75,0x81,0x0C,0x02,
    0x00,0x06,0xE4,0xF5,0xA8,0xF5,0xE8,0xD2,
    0xAF,0xD2,0xA8,0x22,0x12,0x06,0x1A,0x02,
    0x06,0x0A,0xE4,0xF5,0x8E,0x22};

    length  = (sizeof(iromCode) / sizeof(rtk_uint8));
	
    if ((retVal = rtl8367b_setAsicRegBit(0x1322, 4, 1))!=RT_ERR_OK)
        return retVal;
    if ((retVal = rtl8367b_setAsicRegBit(0x130c, 5, 1))!=RT_ERR_OK)
        return retVal;
    if ((retVal = rtl8367b_setAsicRegBit(0x1336, 1, 1))!=RT_ERR_OK)
        return retVal;
    if ((retVal = rtl8367b_setAsicRegBit(0x1322, 2, 0))!=RT_ERR_OK)
        return retVal;

    for(i=0; i<length; i++)
    {
        if(i == 0x2000)
        {
            if ((retVal = rtl8367b_setAsicRegBit(0x1336, 2, 1))!=RT_ERR_OK)
                return retVal;
        }
        rtl8367b_setAsicReg((rtk_uint32)(0xE000 + i % 0x2000), (rtk_uint32)iromCode[i]);
    }

    if ((retVal = rtl8367b_setAsicRegBit(0x1336, 2, 0))!=RT_ERR_OK)
        return retVal;
    if ((retVal = rtl8367b_setAsicRegBit(0x1336, 1, 0))!=RT_ERR_OK)
        return retVal;
    if ((retVal = rtl8367b_setAsicRegBit(0x1322, 4, 0))!=RT_ERR_OK)
        return retVal;
        
    return RT_ERR_OK;

}
#endif

#if 1//defined(CONFIG_RTL_HW_VLAN_SUPPORT)
#if defined(CONFIG_RTL_PROC_NEW)
int rtl_8367r_vlan_read(struct seq_file *s, void *v)
{
	int  i = 0, ret = 0;
    unsigned int pvid = 0, priority = 0, fid = 0;
    rtk_portmask_t Mbrmsk = {{0}}, Untagmsk={{0}};
    rtk_l2_addr_table_t l2_entry;
    
	seq_printf(s, "%s\n", "vlan:");
    for (i=1; i <= 1000; i++)
    {
		if(i!=1 && i!=8 && i!=9 && i%100!=0)
			continue;

		memset(&Mbrmsk, 0x00, sizeof(Mbrmsk));        
        memset(&Untagmsk, 0x00, sizeof(Untagmsk));
        fid =0;
        if ((rtk_vlan_get(i, &Mbrmsk, &Untagmsk, &fid)== 0) && (Mbrmsk.bits[0] != 0))
            seq_printf(s, "vid %d Mbrmsk 0x%x Untagmsk 0x%x fid %u\n", i, Mbrmsk.bits[0], Untagmsk.bits[0], fid);           
    }

	seq_printf(s, "\n%s\n", "pvid:");
    for(i=0;i<8;i++)
    {
        pvid = priority = 0;        
        if (rtk_vlan_portPvid_get(i, &pvid, &priority)==0)
            seq_printf(s, "port %d pvid %u pri %u\n", i, pvid, priority);           
    }

    
	seq_printf(s, "\n%s\n", "l2:");
     /*Get All Lookup Table and Print the valid entry*/
 
    for (i=1;i<=2112;i++)
    {
        memset(&l2_entry,0,sizeof(rtk_l2_addr_table_t));
        l2_entry.index = i;
        ret = rtk_l2_entry_get(&l2_entry);
        if (ret==RT_ERR_OK)
        {
            if(l2_entry.is_ipmul)
            {
                
                seq_printf(s, "\r\nIndex SourceIP DestinationIP MemberPort State\n");           
                seq_printf(s, "%4d ", l2_entry.index);
                seq_printf(s,"%0x ",(l2_entry.sip));
                seq_printf(s,"%0x ",(l2_entry.dip));
                seq_printf(s,"%-8x ",l2_entry.portmask);
                seq_printf(s,"%s \n",(l2_entry.is_static? "Static" : "Auto"));
            }
            else if(l2_entry.mac.octet[0]&0x01)
            {
                seq_printf(s,"%4d %2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X %-8x %-4d %-4s %-5s %s %d\n",
                l2_entry.index,
                l2_entry.mac.octet[0],l2_entry.mac.octet[1],l2_entry.mac.octet[2],
                l2_entry.mac.octet[3],l2_entry.mac.octet[4],l2_entry.mac.octet[5],
                l2_entry.portmask, l2_entry.fid, (l2_entry.auth ? "Auth" : "x"),
                (l2_entry.sa_block? "Block" : "x"), (l2_entry.is_static? "Static" : "Auto"),
                l2_entry.age);
            }
            else if((l2_entry.age!=0)||(l2_entry.is_static==1))
            {
                seq_printf(s,"%4d %2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X %-8x %-4d %-4s %-5s %s %d\n",
                l2_entry.index,l2_entry.mac.octet[0],l2_entry.mac.octet[1],l2_entry.mac.octet[2],
                l2_entry.mac.octet[3],l2_entry.mac.octet[4],l2_entry.mac.octet[5],
                l2_entry.portmask, l2_entry.fid, (l2_entry.auth ? "Auth" : "x"),
                (l2_entry.sa_block? "Block" : "x"), (l2_entry.is_static? "Static" : "Auto"),
                l2_entry.age);
            }
        }
    }


	return 0;
}

#else
int rtl_8367r_vlan_read( char *page, char **start, off_t off, int count, int *eof, void *data )
{
	int len = 0, i = 0, ret = 0;
    unsigned int pvid = 0, priority = 0, fid = 0;
    rtk_portmask_t Mbrmsk = {0}, Untagmsk={0};
    
	len = sprintf(page, "%s\n", "vlan:");
    for (i=0; i < 4096; i++)
    {
        memset(&Mbrmsk, 0x00, sizeof(Mbrmsk));        
        memset(&Untagmsk, 0x00, sizeof(Untagmsk));
        fid =0;
        if ((rtk_vlan_get(i, &Mbrmsk, &Untagmsk, &fid)== 0) && (Mbrmsk.bits[0] != 0))
            len += sprintf(page+len, "vid %d Mbrmsk 0x%x Untagmsk 0x%x fid %u\n", i, Mbrmsk.bits[0], Untagmsk.bits[0], fid);           
    }

	len += sprintf(page+len, "\n%s\n", "pvid:");
    for(i=0;i<8;i++)
    {
        pvid = priority = 0;        
        if (rtk_vlan_portPvid_get(i, &pvid, &priority)==0)
            len += sprintf(page+len, "port %d pvid %u pri %u\n", i, pvid, priority);           
    }

    
	len += sprintf(page+len, "\n%s\n", "l2:");
     /*Get All Lookup Table and Print the valid entry*/
    rtk_l2_addr_table_t l2_entry; 
    for (i=1;i<=2112;i++)
    {
        memset(&l2_entry,0,sizeof(rtk_l2_addr_table_t));
        l2_entry.index = i;
        ret = rtk_l2_entry_get(&l2_entry);
        if (ret==RT_ERR_OK)
        {
            if(l2_entry.is_ipmul)
            {
                
                len += sprintf(page+len, "\r\nIndex SourceIP DestinationIP MemberPort State\n");           
                len += sprintf(page+len, "%4d ", l2_entry.index);
                len += sprintf(page+len,"%0x ",(l2_entry.sip));
                len += sprintf(page+len,"%0x ",(l2_entry.dip));
                len += sprintf(page+len,"%-8x ",l2_entry.portmask);
                len += sprintf(page+len,"%s \n",(l2_entry.is_static? "Static" : "Auto"));
            }
            else if(l2_entry.mac.octet[0]&0x01)
            {
                len += sprintf(page+len,"%4d %2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X %-8x %-4d %-4s %-5s %s %d\n",
                l2_entry.index,
                l2_entry.mac.octet[0],l2_entry.mac.octet[1],l2_entry.mac.octet[2],
                l2_entry.mac.octet[3],l2_entry.mac.octet[4],l2_entry.mac.octet[5],
                l2_entry.portmask, l2_entry.fid, (l2_entry.auth ? "Auth" : "x"),
                (l2_entry.sa_block? "Block" : "x"), (l2_entry.is_static? "Static" : "Auto"),
                l2_entry.age);
            }
            else if((l2_entry.age!=0)||(l2_entry.is_static==1))
            {
                len += sprintf(page+len,"%4d %2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X %-8x %-4d %-4s %-5s %s %d\n",
                l2_entry.index,l2_entry.mac.octet[0],l2_entry.mac.octet[1],l2_entry.mac.octet[2],
                l2_entry.mac.octet[3],l2_entry.mac.octet[4],l2_entry.mac.octet[5],
                l2_entry.portmask, l2_entry.fid, (l2_entry.auth ? "Auth" : "x"),
                (l2_entry.sa_block? "Block" : "x"), (l2_entry.is_static? "Static" : "Auto"),
                l2_entry.age);
            }
        }
    }

     
	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len>count)
		len = count;
	if (len<0)
	  	len = 0;

	return len;
}
#endif
#endif


#if defined(CONFIG_RTL_DNS_TRAP)
int rtl_8367_add_acl_for_dns(unsigned int acl_idx)
{
	int retVal; //, acl_idx=0;
	rtk_filter_field_t	filter_field[2];
	rtk_filter_cfg_t	cfg;
	rtk_filter_action_t	act;
	rtk_filter_number_t	ruleNum = 0;

	/* disable cpu port's mac addr learning ability */
	//rtl8367b_setAsicLutLearnLimitNo(r8367_cpu_port,0);

	/* disable unknown unicast/mcast/bcast flooding between LAN ports */
	//smi_write(RTL8367B_REG_UNDA_FLOODING_PMSK, BIT(r8367_cpu_port));

    memset(&filter_field, 0, 2*sizeof(rtk_filter_field_t));
    memset(&cfg, 0, sizeof(rtk_filter_cfg_t));
    memset(&act, 0, sizeof(rtk_filter_action_t));
    /*Search all MAC (data & mask are all "0")*/
    filter_field[0].fieldType = FILTER_FIELD_UDP_DPORT;                    
    filter_field[0].filter_pattern_union.udpDstPort.dataType = FILTER_FIELD_DATA_MASK;
    filter_field[0].filter_pattern_union.udpDstPort.value = 53;
    filter_field[0].filter_pattern_union.udpDstPort.mask = 0xFFFF;
    filter_field[0].next = NULL;        
    if ((retVal = rtk_filter_igrAcl_field_add(&cfg, &filter_field[0])) != RT_ERR_OK)
       return RT_ERR_FAILED;   

    cfg.careTag.tagType[CARE_TAG_UDP].value = TRUE;
    cfg.careTag.tagType[CARE_TAG_UDP].mask = TRUE;
    /*Add port0~port4 to active ports*/
    cfg.activeport.dataType = FILTER_FIELD_DATA_MASK;
    cfg.activeport.value = 0x1F;
    cfg.activeport.mask = 0xFF; 
    cfg.invert =FALSE;         
    /*Set Action to Trap to CPU*/
    act.actEnable[FILTER_ENACT_TRAP_CPU] = TRUE;        
    if ((retVal = rtk_filter_igrAcl_cfg_add(acl_idx, &cfg, &act, &ruleNum)) != RT_ERR_OK)
        return RT_ERR_FAILED;

    return RT_ERR_OK;			
}
int rtl_8367_remove_acl_for_dns(unsigned int acl_idx)
{
	rtk_filter_igrAcl_cfg_del(acl_idx);
}
#endif
#if defined (IMPROVE_MCAST_PERFORMANCE_WITH_RTL8367)
int rtl_initMcastImprove(void)
{
	return rtk_qos_init(1);
}
int rtl865x_enableRtl8367McastPriorityAcl(int priority)
{
	int retVal;
	rtk_filter_field_t	filter_field[2];
	rtk_filter_cfg_t	cfg;
	rtk_filter_action_t	act;
	rtk_filter_number_t	ruleNum = 0;

	
	memset(filter_field, 0, 2*sizeof(rtk_filter_field_t));
	memset(&cfg, 0, sizeof(rtk_filter_cfg_t));
	memset(&act, 0, sizeof(rtk_filter_action_t));

	filter_field[0].fieldType = FILTER_FIELD_DMAC;
	filter_field[0].filter_pattern_union.dmac.dataType = FILTER_FIELD_DATA_MASK;
	filter_field[0].filter_pattern_union.dmac.value.octet[0] = 0x01;
	filter_field[0].filter_pattern_union.dmac.value.octet[1] = 0x00;
	filter_field[0].filter_pattern_union.dmac.value.octet[2] = 0x5e;
	filter_field[0].filter_pattern_union.dmac.mask.octet[0] = 0xFF;
	filter_field[0].filter_pattern_union.dmac.mask.octet[1] = 0xFF;
	filter_field[0].filter_pattern_union.dmac.mask.octet[1] = 0xFF;
	filter_field[0].next = NULL;
	if ((retVal = rtk_filter_igrAcl_field_add(&cfg, &filter_field[0])) != RT_ERR_OK)
		return retVal;
	
	
	cfg.activeport.dataType = FILTER_FIELD_DATA_MASK;
	cfg.activeport.value = 0x1F;
	cfg.activeport.mask = 0xFF;
	cfg.invert = FALSE;

	act.actEnable[FILTER_ENACT_PRIORITY] = TRUE;
	act.filterPriority = priority;

	if ((retVal = rtk_filter_igrAcl_cfg_add(1, &cfg, &act, &ruleNum)) != RT_ERR_OK)
        return retVal;

	return RT_ERR_OK;

}
int rtl865x_disableRtl8367McastPriorityAcl(void)
{
	return rtk_filter_igrAcl_cfg_del(1);
}

int rtl_enable_mCast_improve(int enable)
{
	if(enable)
	{
		rtk_qos_queueNum_set(r8367_cpu_port, 2);
		rtl865x_enableRtl8367McastPriorityAcl(7);
	}
	else
	{
		rtk_qos_queueNum_set(r8367_cpu_port, 1);
		rtl865x_disableRtl8367McastPriorityAcl();
	}
	return 0;
}
#endif

#if defined CONFIG_RTL_8367_QOS_SUPPORT || defined CONFIG_RTL_8367_QOS_TEST
#define MAX_PHY_PORT_NUM 5
#if defined(CONFIG_RTL_8198C) || defined(CONFIG_RTL_8197F)
#define MAX_RTL8367_QOS_QUEUE_NUM 8
#else
#define MAX_RTL8367_QOS_QUEUE_NUM 6
#endif
#define	QOS_VALID_MASK	0x2
#define	QOS_TYPE_MASK		0x1
#define	QOS_TYPE_STR		0x0	/*0x0|QOS_VALID_MASK*/
#define	QOS_TYPE_WFQ		0x1	/*0x1|QOS_VALID_MASK*/
#if defined CONFIG_RTL_8367_QOS_SUPPORT
#define CPU_METER_ID1        16
#define CPU_METER_ID2        17
#define UNKNOWN_OWNER_METER  0
#define WAN_METER            1
#define LAN_METER            2
#define CPU_METER            3
int qos_meter_owner[RTL8367B_METERNO];
#endif

#if defined CONFIG_RTL_8367_QOS_SUPPORT || defined CONFIG_RTL_8367_QOS_TEST
#if defined CONFIG_RTL_PROC_NEW
int rtl_8367QosReadProc(struct seq_file *s, void *v)
{
	int port, queueNum, i, queue;	
	rtk_qos_queue_weights_t qWeights;
	rtk_meter_id_t meterId;
	rtk_rate_t qRate, pRate;
	rtk_enable_t qIfg_include, pIfg_include, qEnable;
	rtk_uint32 Bucket_size;
    rtk_port_mac_ability_t mac_cfg;
    rtk_mode_ext_t mode ;
	rtk_rate_t inRate;
	rtk_enable_t inIfg_include, inFc_enable;

    rtk_port_macForceLinkExt_get(EXT_PORT_1,&mode,&mac_cfg);

	seq_printf(s, "%s\n", "rtl8367 cpu flow control");
	seq_printf(s, "\ttx pause:%d\n", mac_cfg.txpause);
	seq_printf(s, "\trx pause:%d\n", mac_cfg.rxpause);

	seq_printf(s, "%s\n", "rtl8367 qos related parameters");

	for(port=0; port<RTK_PORT_ID_MAX; port++)
	{
		rtk_qos_queueNum_get(port,&queueNum);
		rtk_rate_egrBandwidthCtrlRate_get(port, &pRate, &pIfg_include); 

		rtk_qos_schedulingQueue_get(port, &qWeights);
		rtk_rate_egrQueueBwCtrlEnable_get(port, RTK_WHOLE_SYSTEM, &qEnable); 

		seq_printf(s,"<%d> queueNum:%d portRate:%d Ifg include:%d queueBwCtrl:%s\n", 
			port, queueNum, pRate, pIfg_include, (qEnable==ENABLED)?"enabled":"disable");

		rtk_rate_igrBandwidthCtrlRate_get(port, &inRate, &inIfg_include, &inFc_enable);
		seq_printf(s,"\tingressBw:%d Ifg include:%d flowControl:%d\n", 
			inRate, inIfg_include, inFc_enable);
		
		seq_printf(s,"\tQueue Parameters:\n ");
		for(queue=0; queue<RTK_MAX_NUM_OF_QUEUE; queue++)
		{
			rtk_rate_egrQueueBwCtrlRate_get(port, queue, &meterId); 
			 
			seq_printf(s,"\t[%d] type:%s, weight:%d, MeterId:%d\n", 
				queue, (qWeights.weights[queue]==0)?"SP":"WFQ", qWeights.weights[queue], meterId);
		}

		seq_printf(s,"\tMeter Parameters:\n ");
		if(port<4)
		{
			for(i=port*8; i<=port*8+7; i++)
			{			
				rtk_rate_shareMeter_get(i, &qRate, &qIfg_include);
				rtk_rate_shareMeterBucket_get(i,&Bucket_size);
				if(i==port*8)
					seq_printf(s,"\t");
				if(i==port*8+4)
					seq_printf(s,"\n\t");
				seq_printf(s,"[%d]%d,%d,%d ", i, qRate, qIfg_include,Bucket_size);
			}
			seq_printf(s,"\n");
		}
		else
		{
			for(i=(port-4)*8; i<=(port-4)*8+7; i++)
			{	
				if(i==(port-4)*8)
					seq_printf(s,"\t");
				if(i==(port-4)*8+4)
					seq_printf(s,"\n\t");
				rtk_rate_shareMeter_get(i, &qRate, &qIfg_include);
				rtk_rate_shareMeterBucket_get(i,&Bucket_size);
				seq_printf(s,"[%d]%d,%d,%d ", i, qRate, qIfg_include, Bucket_size);
			}
			seq_printf(s,"\n");
		}

	}
	return 0;
}
#else
int rtl_8367QosReadProc(char *page, char **start, off_t off, int count, int *eof, void *data)	
{
	int len;
	
	int port, queueNum, i, queue;	
	rtk_qos_queue_weights_t qWeights;
	rtk_meter_id_t meterId;
	rtk_rate_t qRate, pRate;
	rtk_enable_t qIfg_include, pIfg_include, qEnable;
	rtk_uint32 Bucket_size;
	rtk_port_mac_ability_t mac_cfg;
    rtk_mode_ext_t mode ;
	rtk_rate_t inRate;
	rtk_enable_t inIfg_include, inFc_enable;

    rtk_port_macForceLinkExt_get(EXT_PORT_1,&mode,&mac_cfg);

	len = sprintf(page, "%s\n", "rtl8367 cpu flow control");
	len += sprintf(page+len, "\ttx pause:%d\n", mac_cfg.txpause);
	len += sprintf(page+len, "\trx pause:%d\n", mac_cfg.rxpause);
	len += sprintf(page+len, "%s\n", "rtl8367 qos related parameters");

	for(port=0; port<RTK_PORT_ID_MAX; port++)
	{
		rtk_qos_queueNum_get(port,&queueNum);
		rtk_rate_egrBandwidthCtrlRate_get(port, &pRate, &pIfg_include); 

		rtk_qos_schedulingQueue_get(port, &qWeights);
		rtk_rate_egrQueueBwCtrlEnable_get(port, RTK_WHOLE_SYSTEM, &qEnable); 

		len += sprintf(page+len,"<%d> queueNum:%d portRate:%d Ifg include:%d queueBwCtrl:%s\n", 
			port, queueNum, pRate, pIfg_include, (qEnable==ENABLED)?"enabled":"disable");
		rtk_rate_igrBandwidthCtrlRate_get(port, &inRate, &inIfg_include, &inFc_enable);
		len += sprintf(page+len,"\tingressBw:%d Ifg include:%d flowControl:%d\n", 
			inRate, inIfg_include, inFc_enable);

		len += sprintf(page+len,"\tQueue Parameters:\n ");
		for(queue=0; queue<RTK_MAX_NUM_OF_QUEUE; queue++)
		{
			rtk_rate_egrQueueBwCtrlRate_get(port, queue, &meterId); 
			 
			len += sprintf(page+len,"\t[%d] type:%s, weight:%d, MeterId:%d\n", 
				queue, (qWeights.weights[queue]==0)?"SP":"WFQ", qWeights.weights[queue], meterId);
		}

		len += sprintf(page+len,"\tMeter Parameters:\n ");
		if(port<4)
		{
			for(i=port*8; i<=port*8+7; i++)
			{			
				rtk_rate_shareMeter_get(i, &qRate, &qIfg_include);
				rtk_rate_shareMeterBucket_get(i,&Bucket_size);
				if(i==port*8)
					len += sprintf(page+len,"\t");
				if(i==port*8+4)
					len += sprintf(page+len,"\n\t");
				len += sprintf(page+len,"[%d]%d,%d,%d ", i, qRate, qIfg_include,Bucket_size);
			}
			len += sprintf(page+len,"\n");
		}
		else
		{
			for(i=(port-4)*8; i<=(port-4)*8+7; i++)
			{	
				if(i==(port-4)*8)
					len += sprintf(page+len,"\t");				
				if(i==(port-4)*8+4)
					len += sprintf(page+len,"\n\t");
				rtk_rate_shareMeter_get(i, &qRate, &qIfg_include);
				rtk_rate_shareMeterBucket_get(i,&Bucket_size);
				len += sprintf(page+len,"[%d]%d,%d,%d ", i, qRate, qIfg_include, Bucket_size);
			}
			len += sprintf(page+len,"\n");
		}

	}
				
	if (len <= off+count)
		*eof = 1;
			
	*start = page + off;
		len -= off;
			
	if (len>count)
		len = count;
			
	if (len<0) len = 0;
			
	return len;
}
#endif

int rtl_8367QosWriteProc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
#if 0
	char tmp[256];
		
	char		*strptr, *cmd_addr;
	char		*tokptr;
	int port, qid, page;
	unsigned int queue_page[RTK_MAX_NUM_OF_QUEUE];

	if (count < 2)
		return -EFAULT;
	
	if (buffer && !copy_from_user(tmp, buffer, count)) {
	
		tmp[count] = '\0';
		strptr=tmp;
		tokptr = strsep(&strptr," ");
		if (tokptr==NULL)
		{
			goto errout;
		}
		
		if (!memcmp(tokptr, "current", 7))
		{				
			printk( "Current Page for Egress Port and Queues\n");
			printk( "PortNo.  Port	 Q0 	Q1	   Q2	  Q3	 Q4 	Q5	   Q6	  Q7\n");
			for(port=0; port<RTK_PORT_ID_MAX; port++)
			{
				/*Egress Port page number*/
				rtl8367b_setAsicReg(RTL8367B_REG_FLOWCTRL_DEBUG_CTRL0,port);
				rtl8367b_getAsicReg(RTL8367B_REG_FLOWCTRL_PORT_PAGE_COUNT,&page);
				
				for(qid=0;qid<=7;qid++) 				   
				{						 
					rtl8367b_getAsicReg(RTL8367B_REG_FLOWCTRL_QUEUE0_PAGE_COUNT+qid,&queue_page[qid]);
				}
		
				printk("%2d		 %4d  %4d	%4d   %4d	%4d   %4d	%4d   %4d	%4d\n", port+1,page,
				queue_page[0],queue_page[1],queue_page[2],queue_page[3],queue_page[4],queue_page[5],queue_page[6],queue_page[7]);
			}
			
		}
		else if(!memcpy(tokptr, "max",3))
		{
			printk( "Maximum Page for Egress Port and Queues\n");
			printk( "PortNo.  Port	 Q0 	Q1	   Q2	  Q3	 Q4 	Q5	   Q6	  Q7\n");
			for(port=0; port<RTK_PORT_ID_MAX; port++)
			{
				/*Egress Port page number*/
				rtl8367b_setAsicReg(RTL8367B_REG_FLOWCTRL_DEBUG_CTRL0,port);
				rtl8367b_getAsicReg(RTL8367B_REG_FLOWCTRL_PORT_MAX_PAGE_COUNT,&page);
				 
				for(qid=0;qid<=7;qid++) 				   
				{						 
					rtl8367b_getAsicReg(RTL8367B_REG_FLOWCTRL_QUEUE0_MAX_PAGE_COUNT+qid,&queue_page[qid]);
				}
		
				printk("%2d		 %4d  %4d	%4d   %4d	%4d   %4d	%4d   %4d	%4d\n", port+1,page,
				queue_page[0],queue_page[1],queue_page[2],queue_page[3],queue_page[4],queue_page[5],queue_page[6],queue_page[7]);
		
			}
		}
		else
		{
errout:
			printk("error input!\n");
		}
	}
#endif
	return count;	
}
int rtl8367_qos_init()
{
    rtk_uint32 priority;
    rtk_api_ret_t retVal;
	rtk_queue_num_t queueNum;
	rtk_uint32 priDec;
	int i;

	//the priority to qid matrix should be equal to 97F/9xd...
	//change this matrix can't work!!!!??
	#if 0
	CONST_T rtk_uint16 g_prioritytToQid[8][8]= {
		{0,0,0,0,0,0,0,0}, 
		{0,0,0,0,5,5,5,5},	
		{0,0,0,0,1,1,5,5},
		{0,0,0,1,2,2,5,5},
		{0,0,0,1,2,3,5,5},
		{0,0,1,2,3,4,5,5},
		{0,0,1,2,3,4,5,6},
		{0,1,2,3,4,5,6,7}
		};
	#endif

	//802.1p priority based should be heighest priority
    CONST_T rtk_uint32 g_priorityDecision[8] = {0x01, 0x80,0x04,0x80,0x20,0x40,0x10,0x08};

	rtk_qos_init(1);
	#if 0
	 /*Set Priority to Qid*/
	for(queueNum = 0; priority <RTK_MAX_NUM_OF_QUEUE; priority++)
	{
	   	for (priority = 0; priority <= RTL8367B_PRIMAX; priority++)
	   	{
	      	if ((retVal = rtl8367b_setAsicPriorityToQIDMappingTable(queueNum, priority, g_prioritytToQid[queueNum][priority])) != RT_ERR_OK)
	         	return retVal;
	  	}

	}
	#endif

	/*Change Priority Decision Order*/
    for (priDec = 0;priDec < PRIDEC_END;priDec++)
    {
        if ((retVal = rtl8367b_setAsicPriorityDecision(priDec, g_priorityDecision[priDec])) != RT_ERR_OK)
            return retVal;
    }

	for(i=0; i<RTL8367B_METERNO; i++)
	{
		if(i==CPU_METER_ID1 || i==CPU_METER_ID2)
			qos_meter_owner[i] = CPU_METER;
		else
			qos_meter_owner[i] = UNKNOWN_OWNER_METER;
	}
}
#endif

#if defined CONFIG_RTL_8367_QOS_TEST
extern void rtl865x_qos_set(void);
int rtl8367_qos_test()
{
	int port, qid;
	rtk_priority_select_t PriDec;
	rtk_qos_queue_weights_t qweights;
	int prio;

	//97D 
	rtl865x_qos_set();
	
	//init qos
	rtl8367_qos_init();

	//set wan port queue num=2
	rtk_qos_queueNum_set(RTL8367B_PORT4_ENABLE_OFFSET, 2);
	//rtk_qos_queueNum_set(r8367_cpu_port, 2);

	//set port priority
	#if 0
	rtk_qos_portPri_set(0,0);
	rtk_qos_portPri_set(1,0);
	rtk_qos_portPri_set(2,7);
	rtk_qos_portPri_set(3,7);
	#endif

	//set queue parameter on CPU port
	//strict priority
	for (qid = 0; qid < RTK_MAX_NUM_OF_QUEUE; qid ++)
	{
		if(qid==0 || qid==7)
			qweights.weights[qid] = 0;
		else
			qweights.weights[qid] = 0;
	}
	#if 1
	rtk_qos_schedulingQueue_set(RTL8367B_PORT4_ENABLE_OFFSET,&qweights);	
	//rtk_rate_egrBandwidthCtrlRate_set(RTL8367B_PORT4_ENABLE_OFFSET, 204800, 1);
	
	//set queue 0 rate to 10M and queue 7 rate to 5M
	rtk_rate_shareMeter_set(0, 15360, ENABLE);
	rtk_rate_shareMeter_set(1, 10240, ENABLE);
	rtk_rate_shareMeterBucket_set(0,10000);
	rtk_rate_shareMeterBucket_set(1,30000);
	rtk_rate_egrQueueBwCtrlEnable_set(RTL8367B_PORT4_ENABLE_OFFSET,0xFF,ENABLE);
	rtk_rate_egrQueueBwCtrlRate_set(RTL8367B_PORT4_ENABLE_OFFSET,0,0);
	rtk_rate_egrQueueBwCtrlRate_set(RTL8367B_PORT4_ENABLE_OFFSET,7,1);
	#else
	rtk_qos_schedulingQueue_set(r8367_cpu_port,&qweights);	
	rtk_rate_egrBandwidthCtrlRate_set(r8367_cpu_port, 204800, 1);
	
	//set queue 0 rate to 10M and queue 7 rate to 5M
	rtk_rate_shareMeter_set(16, 204800, ENABLE);
	rtk_rate_shareMeter_set(17, 153600, ENABLE);
	rtk_rate_shareMeterBucket_set(16,10000);
	rtk_rate_shareMeterBucket_set(17,30000);
	rtk_rate_egrQueueBwCtrlEnable_set(r8367_cpu_port,0xFF,ENABLE);
	rtk_rate_egrQueueBwCtrlRate_set(r8367_cpu_port,0,16);
	rtk_rate_egrQueueBwCtrlRate_set(r8367_cpu_port,7,17);
	#endif

}
#endif

#if defined CONFIG_RTL_8367_QOS_SUPPORT
int rtl8367_qosSetIngressBandwidth(unsigned int memberPort, unsigned int Kbps)
{
	unsigned int	port;

	//todo: wait output queue empty?
	for(port=0;port<MAX_PHY_PORT_NUM;port++)
	{
		if(((1<<port)&memberPort)==0)
			continue;
		if(Kbps==0)
			rtk_rate_igrBandwidthCtrlRate_set(port, RTL8367B_QOS_RATE_INPUT_MAX, DISABLED, ENABLED);
		else
			rtk_rate_igrBandwidthCtrlRate_set(port, Kbps, ENABLED, ENABLED);		
	}
	return 0;

}

int rtl8367_qosSetBandwidth(unsigned int memberPort, unsigned int Kbps)
{
	unsigned int	port;
	int ret;

	//todo: wait output queue empty?
	for(port=0;port<MAX_PHY_PORT_NUM;port++)
	{
		if(((1<<port)&memberPort)==0)
			continue;
		ret=rtk_rate_egrBandwidthCtrlRate_set(port, Kbps, ENABLED);
	}
	return 0;
}
int rtl8367_qosFlushBandwidth(unsigned int memberPort)
{
	unsigned int port;

	//todo: wait output queue empty?
	for(port=0;port<MAX_PHY_PORT_NUM;port++)
	{
		if(((1<<port)&memberPort)==0)
			continue;
		rtk_rate_egrBandwidthCtrlRate_set(port, RTL8367B_QOS_RATE_INPUT_MAX, ENABLED);
	}
	return 0;
}

int rtl8367_qosGetMeterId(unsigned int port, unsigned int bw, unsigned int wanPortMask)
{
	rtk_meter_id_t idbegin, idend;
	rtk_meter_id_t i;
	rtk_rate_t Rate;
	rtk_data_t Ifg_include;
	
	if(port<0 || port>=MAX_PHY_PORT_NUM)
		return -1;

	if(port<4)
	{
		idbegin = port*8;
		idend = port*8+7;
	}
	else
	{
		idbegin = (port-4)*8;
		idend = (port-4)*8+7;
	}

	for(i=idbegin; i<=idend; i++)
	{
		if(qos_meter_owner[i] == UNKNOWN_OWNER_METER)
			break;
	}
	if(i > idend)
	{
		return -1;
	}

	//printk("get meter of port %d, id:%d, bw:%d, [%s:%d]\n", port, i, bw, __FUNCTION__, __LINE__);
	if(wanPortMask & (1<<port))
	{
		qos_meter_owner[i]=WAN_METER;
	}
	else
	{
		qos_meter_owner[i]=LAN_METER;
	}

	rtk_rate_shareMeter_set(i, bw, ENABLED);
	//rtk_rate_shareMeterBucket_set(j,QOS_BUCKET_SIZE);

	return i;
		
}
//ok
int rtl8367_qosFlushMeter(int port, unsigned int wanPortMask)
{
	int meterId,idbegin,idend;

	if(port<0 || port>=MAX_PHY_PORT_NUM)
		return -1;
	
	if(port<4)
	{
		idbegin = port*8;
		idend = port*8+7;
	}
	else
	{
		idbegin = (port-4)*8;
		idend = (port-4)*8+7;
	}

	//printk("flush meter of port %d, [%s:%d]\n", port, __FUNCTION__, __LINE__);

	for(meterId=idbegin; meterId<=idend; meterId++)
	{
		if(((wanPortMask & (1<<port)) && (qos_meter_owner[meterId]==WAN_METER)) 
			||(!(wanPortMask & (1<<port)) && (qos_meter_owner[meterId]==LAN_METER)))
		{
			rtk_rate_shareMeter_set(meterId, RTL8367B_QOS_RATE_INPUT_MAX, DISABLED);
			qos_meter_owner[meterId]=UNKNOWN_OWNER_METER;
			//always use default bucket size
			//rtk_rate_shareMeterBucket_set(meterId,DEFAULT_QOS_BUCKET_SIZE);
		}
	}
	return 0;
}

int rtl8367_qosProcessQueue(unsigned int memberPort, unsigned int queueNum, unsigned int *queueFlag, unsigned int *queueId, unsigned int *queueBw, unsigned int *queueWeight, unsigned int wanPortMask)
{
	unsigned int port, queue, qid, meterId;
	rtk_qos_queue_weights_t qweights;
	unsigned int set_error=0;
	unsigned int all_phyPortMask = 0x1F;

	memset(&qweights, 0, sizeof(qweights));
	
	for(port = 0; port < MAX_PHY_PORT_NUM; port++)
	{
		if(((1<<port)&memberPort)==0)
			continue;
		rtk_qos_queueNum_set(port, queueNum);
		rtk_rate_egrQueueBwCtrlEnable_set(port,RTK_WHOLE_SYSTEM, ENABLED);
		
		for (queue=0;queue<MAX_RTL8367_QOS_QUEUE_NUM;queue++)
		{
			if((queueFlag[queue]&QOS_VALID_MASK)==0 || queueBw[queue] == 0)
				continue;

			qid = queueId[queue];
			if((queueFlag[queue]&QOS_TYPE_MASK)==QOS_TYPE_STR)
			{
				qweights.weights[qid] = 0;
			}
			else
			{
				qweights.weights[qid] = queueWeight[queue];
			}

			meterId = rtl8367_qosGetMeterId(port, queueBw[queue], wanPortMask);

			if(meterId != -1)
			{
				rtk_rate_egrQueueBwCtrlRate_set(port,qid,meterId);
			}
			else
			{
				set_error = 1;
			}
				
		}
		rtk_qos_schedulingQueue_set(port,&qweights);
	}
	if(set_error)
	{
		printk("sharemeter is not enough!\n");
		rtl8367_qosFlushBandwidth(all_phyPortMask);
		rtl8367_closeQos(all_phyPortMask, wanPortMask);
	}
	return 0;
}
//ok
int rtl8367_closeQos(unsigned int memberPort, unsigned int wanPortMask)
{
	unsigned int port, qid;	
	rtk_qos_queue_weights_t qweights;

	//todo: wait output queue empty?
	for(port=0;port<MAX_PHY_PORT_NUM;port++)
	{
		if(((1<<port)&memberPort)==0)
			continue;

		
		for (qid = 0; qid < RTK_MAX_NUM_OF_QUEUE; qid ++)
		{
			qweights.weights[qid] = 0;
			if(port<4)
				rtk_rate_egrQueueBwCtrlRate_set(port, qid, port*8);
			else
				rtk_rate_egrQueueBwCtrlRate_set(port, qid, (port-4)*8);
		}

		rtk_qos_queueNum_set(port, 1);
		rtk_qos_schedulingQueue_set(port,&qweights);		
		rtk_rate_egrQueueBwCtrlEnable_set(port,RTK_WHOLE_SYSTEM,DISABLED);
		rtl8367_qosFlushMeter(port, wanPortMask);
	}

	//close 8367 cpu port flow control
	

	return 0;
	
}
void rtl8367_setFlowControl(int qosEnable)
{
    /* Set external interface 0 to RGMII with Force mode, 1000M, Full-duple, enable TX&RX pause*/
    rtk_port_mac_ability_t mac_cfg;
    rtk_mode_ext_t mode ;

    rtk_port_macForceLinkExt_get(EXT_PORT_1,&mode,&mac_cfg);
	if(((mac_cfg.txpause==ENABLED) || (mac_cfg.rxpause==ENABLED)) && qosEnable==1)
	{
		mac_cfg.txpause = DISABLED;
		mac_cfg.rxpause = DISABLED;
		rtk_port_macForceLinkExt_set(EXT_PORT_1,mode,&mac_cfg);
	}
	else if(((mac_cfg.txpause==DISABLED) || (mac_cfg.rxpause==DISABLED)) && qosEnable==0)
	{
		mac_cfg.txpause = ENABLED;
		mac_cfg.rxpause = ENABLED;		
		rtk_port_macForceLinkExt_set(EXT_PORT_1,mode,&mac_cfg);
	}
}
#endif
#endif

#if defined(CONFIG_RTL_VLAN_8021Q) || defined(CONFIG_RTL_HW_VLAN_SUPPORT)
int rtl865x_enableRtl8367BCMCToCpu(unsigned int acl_idx)
{
	int retVal;
	rtk_filter_field_t	filter_field[2];
	rtk_filter_cfg_t	cfg;
	rtk_filter_action_t act;
	rtk_filter_number_t ruleNum = 0;

	
	memset(filter_field, 0, 2*sizeof(rtk_filter_field_t));
	memset(&cfg, 0, sizeof(rtk_filter_cfg_t));
	memset(&act, 0, sizeof(rtk_filter_action_t));

	filter_field[0].fieldType = FILTER_FIELD_DMAC;
	filter_field[0].filter_pattern_union.dmac.dataType = FILTER_FIELD_DATA_MASK;
	filter_field[0].filter_pattern_union.dmac.value.octet[0] = 0x01;
	
	filter_field[0].filter_pattern_union.dmac.mask.octet[0] = 0x1;
	filter_field[0].next = NULL;
	if ((retVal = rtk_filter_igrAcl_field_add(&cfg, &filter_field[0])) != RT_ERR_OK)
		return retVal;
	
	
	cfg.activeport.dataType = FILTER_FIELD_DATA_MASK;
	cfg.activeport.value = 0x1F;
	cfg.activeport.mask = 0xFF;
	cfg.invert = FALSE;

	act.actEnable[FILTER_ENACT_TRAP_CPU] = TRUE;

	if ((retVal = rtk_filter_igrAcl_cfg_add(acl_idx, &cfg, &act, &ruleNum)) != RT_ERR_OK)
		return retVal;

	//printk("%s %d BC MC to cpu !\n", __func__, __LINE__);
	return RT_ERR_OK;

}

int rtl865x_disableRtl8367BCMCToCpu(unsigned int acl_idx)
{
	int ret = -1;
	
	ret = rtk_filter_igrAcl_cfg_del(acl_idx);

	return ret;
}
#endif

