/****************************************************************************** 
* 
* Copyright(c) 2007 - 2011 Realtek Corporation. All rights reserved. 
* 
* This program is free software; you can redistribute it and/or modify it 
* under the terms of version 2 of the GNU General Public License as 
* published by the Free Software Foundation. 
* 
* This program is distributed in the hope that it will be useful, but WITHOUT 
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
* more details. 
* 
* You should have received a copy of the GNU General Public License along with 
* this program; if not, write to the Free Software Foundation, Inc., 
* 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA 
* 
* 
******************************************************************************/

/*Image2HeaderVersion: 2.24*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8814A_SUPPORT == 1)
static BOOLEAN
CheckPositive(
	IN  PDM_ODM_T     pDM_Odm,
	IN  const u4Byte  Condition1,
	IN  const u4Byte  Condition2,
	IN	const u4Byte  Condition3,
	IN	const u4Byte  Condition4
)
{
	u1Byte    _BoardType = ((pDM_Odm->BoardType & BIT4) >> 4) << 0 | /* _GLNA*/
				((pDM_Odm->BoardType & BIT3) >> 3) << 1 | /* _GPA*/ 
				((pDM_Odm->BoardType & BIT7) >> 7) << 2 | /* _ALNA*/
				((pDM_Odm->BoardType & BIT6) >> 6) << 3 | /* _APA */
				((pDM_Odm->BoardType & BIT2) >> 2) << 4;  /* _BT*/  

	u4Byte	cond1   = Condition1, cond2 = Condition2, cond3 = Condition3, cond4 = Condition4;

	u1Byte	cut_version_for_para   = (pDM_Odm->CutVersion == ODM_CUT_A) ? 14 : pDM_Odm->CutVersion;
	u1Byte	pkg_type_for_para   = (pDM_Odm->PackageType == 0) ? 14 : pDM_Odm->PackageType;

	u4Byte    driver1 = cut_version_for_para       << 24 | 
				(pDM_Odm->SupportInterface & 0xF0) << 16 | 
				pDM_Odm->SupportPlatform  << 16 | 
				pkg_type_for_para      << 12 | 
				(pDM_Odm->SupportInterface & 0x0F) << 8  |
				_BoardType;

	u4Byte    driver2 = (pDM_Odm->TypeGLNA & 0xFF) <<  0 |  
				(pDM_Odm->TypeGPA & 0xFF)  <<  8 | 
				(pDM_Odm->TypeALNA & 0xFF) << 16 | 
				(pDM_Odm->TypeAPA & 0xFF)  << 24; 

u4Byte    driver3 = 0;

	u4Byte    driver4 = (pDM_Odm->TypeGLNA & 0xFF00) >>  8 |
				(pDM_Odm->TypeGPA & 0xFF00) |
				(pDM_Odm->TypeALNA & 0xFF00) << 8 |
				(pDM_Odm->TypeAPA & 0xFF00)  << 16;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("===> CheckPositive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n", cond1, cond2, cond3, cond4));
	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("===> CheckPositive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n", driver1, driver2, driver3, driver4));

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("	(Platform, Interface) = (0x%X, 0x%X)\n", pDM_Odm->SupportPlatform, pDM_Odm->SupportInterface));
	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("	(Board, Package) = (0x%X, 0x%X)\n", pDM_Odm->BoardType, pDM_Odm->PackageType));


	/*============== Value Defined Check ===============*/
	/*QFN Type [15:12] and Cut Version [27:24] need to do value check*/
	
	if (((cond1 & 0x0000F000) != 0) && ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return FALSE;
	if (((cond1 & 0x0F000000) != 0) && ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return FALSE;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1   &= 0x00FF0FFF; 
	driver1 &= 0x00FF0FFF; 

	if ((cond1 & driver1) == cond1) {
		u4Byte bitMask = 0;

		if ((cond1 & 0x0F) == 0) /* BoardType is DONTCARE*/
			return TRUE;

		if ((cond1 & BIT0) != 0) /*GLNA*/
			bitMask |= 0x000000FF;
		if ((cond1 & BIT1) != 0) /*GPA*/
			bitMask |= 0x0000FF00;
		if ((cond1 & BIT2) != 0) /*ALNA*/
			bitMask |= 0x00FF0000;
		if ((cond1 & BIT3) != 0) /*APA*/
			bitMask |= 0xFF000000;

		if (((cond2 & bitMask) == (driver2 & bitMask)) && ((cond4 & bitMask) == (driver4 & bitMask)))  /* BoardType of each RF path is matched*/
			return TRUE;
		else
			return FALSE;
	} else
		return FALSE;
}
static BOOLEAN
CheckNegative(
	IN  PDM_ODM_T     pDM_Odm,
	IN  const u4Byte  Condition1,
	IN  const u4Byte  Condition2
)
{
	return TRUE;
}

/******************************************************************************
*                           AGC_TAB.TXT
******************************************************************************/

u4Byte Array_MP_8814A_AGC_TAB[] = { 
	0x80000001,	0x00000055,	0x40000000,	0x00000000,
		0x81C, 0xFE000003,
		0x81C, 0xFF000003,
		0x81C, 0xFE020003,
		0x81C, 0xFD040003,
		0x81C, 0xFC060003,
		0x81C, 0xFB080003,
		0x81C, 0xFA0A0003,
		0x81C, 0xF90C0003,
		0x81C, 0xF80E0003,
		0x81C, 0xF7100003,
		0x81C, 0xF6120003,
		0x81C, 0xF5140003,
		0x81C, 0xF4160003,
		0x81C, 0xF3180003,
		0x81C, 0xF21A0003,
		0x81C, 0xF11C0003,
		0x81C, 0xF01E0003,
		0x81C, 0xEF200003,
		0x81C, 0xEE220003,
		0x81C, 0xED240003,
		0x81C, 0xEC260003,
		0x81C, 0xEB280003,
		0x81C, 0xEA2A0003,
		0x81C, 0xE92C0003,
		0x81C, 0xE82E0003,
		0x81C, 0xE7300003,
		0x81C, 0xE6320003,
		0x81C, 0xE5340003,
		0x81C, 0xE4360003,
		0x81C, 0xE3380003,
		0x81C, 0xC53A0003,
		0x81C, 0xC43C0003,
		0x81C, 0xC33E0003,
		0x81C, 0xC2400003,
		0x81C, 0xC1420003,
		0x81C, 0xA8440003,
		0x81C, 0xA7460003,
		0x81C, 0xA6480003,
		0x81C, 0xA54A0003,
		0x81C, 0xA44C0003,
		0x81C, 0xA34E0003,
		0x81C, 0xA2500003,
		0x81C, 0x65520003,
		0x81C, 0x64540003,
		0x81C, 0x63560003,
		0x81C, 0x62580003,
		0x81C, 0x615A0003,
		0x81C, 0x475C0003,
		0x81C, 0x465E0003,
		0x81C, 0x45600003,
		0x81C, 0x44620003,
		0x81C, 0x43640003,
		0x81C, 0x42660003,
		0x81C, 0x41680003,
		0x81C, 0x416A0003,
		0x81C, 0x416C0003,
		0x81C, 0x416E0003,
		0x81C, 0x41700003,
		0x81C, 0x41720003,
		0x81C, 0x41740003,
		0x81C, 0x41760003,
		0x81C, 0x41780003,
		0x81C, 0x417A0003,
		0x81C, 0x417C0003,
		0x81C, 0x417E0003,
	0x90000001,	0x000000aa,	0x40000000,	0x00000000,
		0x81C, 0xFE000003,
		0x81C, 0xFE000003,
		0x81C, 0xFD020003,
		0x81C, 0xFC040003,
		0x81C, 0xFB060003,
		0x81C, 0xFA080003,
		0x81C, 0xF90A0003,
		0x81C, 0xF80C0003,
		0x81C, 0xF70E0003,
		0x81C, 0xF6100003,
		0x81C, 0xF5120003,
		0x81C, 0xF4140003,
		0x81C, 0xF3160003,
		0x81C, 0xF2180003,
		0x81C, 0xF11A0003,
		0x81C, 0xF01C0003,
		0x81C, 0xEF1E0003,
		0x81C, 0xEE200003,
		0x81C, 0xED220003,
		0x81C, 0xEC240003,
		0x81C, 0xEB260003,
		0x81C, 0xEA280003,
		0x81C, 0xE92A0003,
		0x81C, 0xE82C0003,
		0x81C, 0xE72E0003,
		0x81C, 0xE6300003,
		0x81C, 0xE5320003,
		0x81C, 0xE4340003,
		0x81C, 0xE3360003,
		0x81C, 0xC6380003,
		0x81C, 0xC53A0003,
		0x81C, 0xC43C0003,
		0x81C, 0xC33E0003,
		0x81C, 0xC2400003,
		0x81C, 0xA9420003,
		0x81C, 0xA8440003,
		0x81C, 0xA7460003,
		0x81C, 0xA6480003,
		0x81C, 0xA54A0003,
		0x81C, 0xA44C0003,
		0x81C, 0xA34E0003,
		0x81C, 0x66500003,
		0x81C, 0x65520003,
		0x81C, 0x64540003,
		0x81C, 0x63560003,
		0x81C, 0x49580003,
		0x81C, 0x485A0003,
		0x81C, 0x475C0003,
		0x81C, 0x465E0003,
		0x81C, 0x45600003,
		0x81C, 0x44620003,
		0x81C, 0x43640003,
		0x81C, 0x42660003,
		0x81C, 0x41680003,
		0x81C, 0x416A0003,
		0x81C, 0x416C0003,
		0x81C, 0x416E0003,
		0x81C, 0x41700003,
		0x81C, 0x41720003,
		0x81C, 0x41740003,
		0x81C, 0x41760003,
		0x81C, 0x41780003,
		0x81C, 0x417A0003,
		0x81C, 0x417C0003,
		0x81C, 0x417E0003,
	0x90000001,	0x000000ff,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xDF000003,
		0x81C, 0xDF020003,
		0x81C, 0xDF040003,
		0x81C, 0xDE060003,
		0x81C, 0xDD080003,
		0x81C, 0xDC0A0003,
		0x81C, 0xDB0C0003,
		0x81C, 0xDA0E0003,
		0x81C, 0xD9100003,
		0x81C, 0xD8120003,
		0x81C, 0xD7140003,
		0x81C, 0xD6160003,
		0x81C, 0xD5180003,
		0x81C, 0xD41A0003,
		0x81C, 0xD31C0003,
		0x81C, 0xD21E0003,
		0x81C, 0xD1200003,
		0x81C, 0xD0220003,
		0x81C, 0xCF240003,
		0x81C, 0xCE260003,
		0x81C, 0xCD280003,
		0x81C, 0xCC2A0003,
		0x81C, 0xCB2C0003,
		0x81C, 0xCA2E0003,
		0x81C, 0xC9300003,
		0x81C, 0xC8320003,
		0x81C, 0xC7340003,
		0x81C, 0xC6360003,
		0x81C, 0xC5380003,
		0x81C, 0xA73A0003,
		0x81C, 0xA63C0003,
		0x81C, 0xA53E0003,
		0x81C, 0xA4400003,
		0x81C, 0xA3420003,
		0x81C, 0xA2440003,
		0x81C, 0x87460003,
		0x81C, 0x86480003,
		0x81C, 0x854A0003,
		0x81C, 0x844C0003,
		0x81C, 0x834E0003,
		0x81C, 0x82500003,
		0x81C, 0x81520003,
		0x81C, 0x64540003,
		0x81C, 0x63560003,
		0x81C, 0x62580003,
		0x81C, 0x615A0003,
		0x81C, 0x445C0003,
		0x81C, 0x435E0003,
		0x81C, 0x42600003,
		0x81C, 0x41620003,
		0x81C, 0x27640003,
		0x81C, 0x26660003,
		0x81C, 0x25680003,
		0x81C, 0x246A0003,
		0x81C, 0x236C0003,
		0x81C, 0x226E0003,
		0x81C, 0x21700003,
		0x81C, 0x21720003,
		0x81C, 0x21740003,
		0x81C, 0x21760003,
		0x81C, 0x21780003,
		0x81C, 0x217A0003,
		0x81C, 0x217C0003,
		0x81C, 0x217E0003,
	0xA0000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xFE000003,
		0x81C, 0xFD020003,
		0x81C, 0xFC040003,
		0x81C, 0xFB060003,
		0x81C, 0xFA080003,
		0x81C, 0xF90A0003,
		0x81C, 0xF80C0003,
		0x81C, 0xF70E0003,
		0x81C, 0xF6100003,
		0x81C, 0xF5120003,
		0x81C, 0xF4140003,
		0x81C, 0xF3160003,
		0x81C, 0xF2180003,
		0x81C, 0xF11A0003,
		0x81C, 0xF01C0003,
		0x81C, 0xEF1E0003,
		0x81C, 0xEE200003,
		0x81C, 0xED220003,
		0x81C, 0xCF240003,
		0x81C, 0xCE260003,
		0x81C, 0xCD280003,
		0x81C, 0xCC2A0003,
		0x81C, 0xCB2C0003,
		0x81C, 0xCA2E0003,
		0x81C, 0xC9300003,
		0x81C, 0xC8320003,
		0x81C, 0xC7340003,
		0x81C, 0xC6360003,
		0x81C, 0xC5380003,
		0x81C, 0xC43A0003,
		0x81C, 0xA63C0003,
		0x81C, 0xA53E0003,
		0x81C, 0xA4400003,
		0x81C, 0xA3420003,
		0x81C, 0xA2440003,
		0x81C, 0xA1460003,
		0x81C, 0x86480003,
		0x81C, 0x854A0003,
		0x81C, 0x844C0003,
		0x81C, 0x834E0003,
		0x81C, 0x66500003,
		0x81C, 0x65520003,
		0x81C, 0x64540003,
		0x81C, 0x63560003,
		0x81C, 0x62580003,
		0x81C, 0x615A0003,
		0x81C, 0x435C0003,
		0x81C, 0x425E0003,
		0x81C, 0x41600003,
		0x81C, 0x27620003,
		0x81C, 0x26640003,
		0x81C, 0x25660003,
		0x81C, 0x24680003,
		0x81C, 0x236A0003,
		0x81C, 0x226C0003,
		0x81C, 0x216E0003,
		0x81C, 0x21700003,
		0x81C, 0x21720003,
		0x81C, 0x21740003,
		0x81C, 0x21760003,
		0x81C, 0x21780003,
		0x81C, 0x217A0003,
		0x81C, 0x217C0003,
		0x81C, 0x217E0003,
	0xB0000000,	0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFA000103,
		0x81C, 0xF9020103,
		0x81C, 0xF8040103,
		0x81C, 0xF7060103,
		0x81C, 0xF6080103,
		0x81C, 0xF50A0103,
		0x81C, 0xF40C0103,
		0x81C, 0xF30E0103,
		0x81C, 0xF2100103,
		0x81C, 0xF1120103,
		0x81C, 0xF0140103,
		0x81C, 0xEF160103,
		0x81C, 0xEE180103,
		0x81C, 0xED1A0103,
		0x81C, 0xEC1C0103,
		0x81C, 0xEB1E0103,
		0x81C, 0xEA200103,
		0x81C, 0xE9220103,
		0x81C, 0xE8240103,
		0x81C, 0xE7260103,
		0x81C, 0xE6280103,
		0x81C, 0xE52A0103,
		0x81C, 0xE42C0103,
		0x81C, 0xE32E0103,
		0x81C, 0xE2300103,
		0x81C, 0xE1320103,
		0x81C, 0xA5340103,
		0x81C, 0xA4360103,
		0x81C, 0xA3380103,
		0x81C, 0xA23A0103,
		0x81C, 0xA13C0103,
		0x81C, 0x843E0103,
		0x81C, 0x83400103,
		0x81C, 0x82420103,
		0x81C, 0x81440103,
		0x81C, 0x64460103,
		0x81C, 0x63480103,
		0x81C, 0x624A0103,
		0x81C, 0x614C0103,
		0x81C, 0x454E0103,
		0x81C, 0x44500103,
		0x81C, 0x43520103,
		0x81C, 0x42540103,
		0x81C, 0x41560103,
		0x81C, 0x24580103,
		0x81C, 0x235A0103,
		0x81C, 0x225C0103,
		0x81C, 0x055E0103,
		0x81C, 0x04600103,
		0x81C, 0x03620103,
		0x81C, 0x02640103,
		0x81C, 0x01660103,
		0x81C, 0x01680103,
		0x81C, 0x016A0103,
		0x81C, 0x016C0103,
		0x81C, 0x016E0103,
		0x81C, 0x01700103,
		0x81C, 0x01720103,
		0x81C, 0x01740103,
		0x81C, 0x01760103,
		0x81C, 0x01780103,
		0x81C, 0x017A0103,
		0x81C, 0x017C0103,
		0x81C, 0x017E0103,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x81C, 0xF8000103,
		0x81C, 0xF7020103,
		0x81C, 0xF6040103,
		0x81C, 0xF5060103,
		0x81C, 0xF4080103,
		0x81C, 0xF30A0103,
		0x81C, 0xF20C0103,
		0x81C, 0xF10E0103,
		0x81C, 0xF0100103,
		0x81C, 0xEF120103,
		0x81C, 0xEE140103,
		0x81C, 0xED160103,
		0x81C, 0xEC180103,
		0x81C, 0xEB1A0103,
		0x81C, 0xEA1C0103,
		0x81C, 0xE91E0103,
		0x81C, 0xE8200103,
		0x81C, 0xE7220103,
		0x81C, 0xE6240103,
		0x81C, 0xE5260103,
		0x81C, 0xE4280103,
		0x81C, 0xE32A0103,
		0x81C, 0xE22C0103,
		0x81C, 0xE12E0103,
		0x81C, 0xA5300103,
		0x81C, 0xA4320103,
		0x81C, 0xA3340103,
		0x81C, 0xA2360103,
		0x81C, 0xA1380103,
		0x81C, 0x843A0103,
		0x81C, 0x833C0103,
		0x81C, 0x823E0103,
		0x81C, 0x81400103,
		0x81C, 0x64420103,
		0x81C, 0x63440103,
		0x81C, 0x62460103,
		0x81C, 0x61480103,
		0x81C, 0x454A0103,
		0x81C, 0x444C0103,
		0x81C, 0x434E0103,
		0x81C, 0x42500103,
		0x81C, 0x25520103,
		0x81C, 0x24540103,
		0x81C, 0x23560103,
		0x81C, 0x06580103,
		0x81C, 0x055A0103,
		0x81C, 0x045C0103,
		0x81C, 0x035E0103,
		0x81C, 0x02600103,
		0x81C, 0x01620103,
		0x81C, 0x01640103,
		0x81C, 0x01660103,
		0x81C, 0x01680103,
		0x81C, 0x016A0103,
		0x81C, 0x016C0103,
		0x81C, 0x016E0103,
		0x81C, 0x01700103,
		0x81C, 0x01720103,
		0x81C, 0x01740103,
		0x81C, 0x01760103,
		0x81C, 0x01780103,
		0x81C, 0x017A0103,
		0x81C, 0x017C0103,
		0x81C, 0x017E0103,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x81C, 0xFC000103,
		0x81C, 0xFB020103,
		0x81C, 0xFA040103,
		0x81C, 0xF9060103,
		0x81C, 0xF8080103,
		0x81C, 0xF70A0103,
		0x81C, 0xF60C0103,
		0x81C, 0xF50E0103,
		0x81C, 0xF4100103,
		0x81C, 0xF3120103,
		0x81C, 0xF2140103,
		0x81C, 0xF1160103,
		0x81C, 0xF0180103,
		0x81C, 0xEF1A0103,
		0x81C, 0xEE1C0103,
		0x81C, 0xED1E0103,
		0x81C, 0xEC200103,
		0x81C, 0xEB220103,
		0x81C, 0xEA240103,
		0x81C, 0xE9260103,
		0x81C, 0xE8280103,
		0x81C, 0xE72A0103,
		0x81C, 0xE62C0103,
		0x81C, 0xE52E0103,
		0x81C, 0xE4300103,
		0x81C, 0xE3320103,
		0x81C, 0xE2340103,
		0x81C, 0xE1360103,
		0x81C, 0x87380103,
		0x81C, 0x863A0103,
		0x81C, 0x853C0103,
		0x81C, 0x843E0103,
		0x81C, 0x83400103,
		0x81C, 0x82420103,
		0x81C, 0x81440103,
		0x81C, 0x64460103,
		0x81C, 0x63480103,
		0x81C, 0x624A0103,
		0x81C, 0x464C0103,
		0x81C, 0x454E0103,
		0x81C, 0x44500103,
		0x81C, 0x43520103,
		0x81C, 0x26540103,
		0x81C, 0x25560103,
		0x81C, 0x24580103,
		0x81C, 0x075A0103,
		0x81C, 0x065C0103,
		0x81C, 0x055E0103,
		0x81C, 0x04600103,
		0x81C, 0x03620103,
		0x81C, 0x02640103,
		0x81C, 0x01660103,
		0x81C, 0x01680103,
		0x81C, 0x016A0103,
		0x81C, 0x016C0103,
		0x81C, 0x016E0103,
		0x81C, 0x01700103,
		0x81C, 0x01720103,
		0x81C, 0x01740103,
		0x81C, 0x01760103,
		0x81C, 0x01780103,
		0x81C, 0x017A0103,
		0x81C, 0x017C0103,
		0x81C, 0x017E0103,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x81C, 0xF9000103,
		0x81C, 0xF8020103,
		0x81C, 0xF7040103,
		0x81C, 0xF6060103,
		0x81C, 0xF5080103,
		0x81C, 0xF40A0103,
		0x81C, 0xF30C0103,
		0x81C, 0xF20E0103,
		0x81C, 0xF1100103,
		0x81C, 0xF0120103,
		0x81C, 0xEF140103,
		0x81C, 0xEE160103,
		0x81C, 0xED180103,
		0x81C, 0xEC1A0103,
		0x81C, 0xEB1C0103,
		0x81C, 0xEA1E0103,
		0x81C, 0xE9200103,
		0x81C, 0xE8220103,
		0x81C, 0xE7240103,
		0x81C, 0xE6260103,
		0x81C, 0xE5280103,
		0x81C, 0xE42A0103,
		0x81C, 0xE32C0103,
		0x81C, 0xE22E0103,
		0x81C, 0xA6300103,
		0x81C, 0xA5320103,
		0x81C, 0xA4340103,
		0x81C, 0xA3360103,
		0x81C, 0xA2380103,
		0x81C, 0xA13A0103,
		0x81C, 0x843C0103,
		0x81C, 0x833E0103,
		0x81C, 0x82400103,
		0x81C, 0x81420103,
		0x81C, 0x64440103,
		0x81C, 0x63460103,
		0x81C, 0x62480103,
		0x81C, 0x614A0103,
		0x81C, 0x444C0103,
		0x81C, 0x434E0103,
		0x81C, 0x42500103,
		0x81C, 0x41520103,
		0x81C, 0x25540103,
		0x81C, 0x24560103,
		0x81C, 0x23580103,
		0x81C, 0x225A0103,
		0x81C, 0x055C0103,
		0x81C, 0x045E0103,
		0x81C, 0x03600103,
		0x81C, 0x02620103,
		0x81C, 0x01640103,
		0x81C, 0x01660103,
		0x81C, 0x01680103,
		0x81C, 0x016A0103,
		0x81C, 0x016C0103,
		0x81C, 0x016E0103,
		0x81C, 0x01700103,
		0x81C, 0x01720103,
		0x81C, 0x01740103,
		0x81C, 0x01760103,
		0x81C, 0x01780103,
		0x81C, 0x017A0103,
		0x81C, 0x017C0103,
		0x81C, 0x017E0103,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEF1C0103,
		0x81C, 0xEE1E0103,
		0x81C, 0xED200103,
		0x81C, 0xEC220103,
		0x81C, 0xEB240103,
		0x81C, 0xEA260103,
		0x81C, 0xE9280103,
		0x81C, 0xE82A0103,
		0x81C, 0xE72C0103,
		0x81C, 0xE62E0103,
		0x81C, 0xE5300103,
		0x81C, 0xE4320103,
		0x81C, 0xE3340103,
		0x81C, 0xE2360103,
		0x81C, 0xE1380103,
		0x81C, 0xA33A0103,
		0x81C, 0xA23C0103,
		0x81C, 0xA13E0103,
		0x81C, 0x84400103,
		0x81C, 0x83420103,
		0x81C, 0x82440103,
		0x81C, 0x81460103,
		0x81C, 0x64480103,
		0x81C, 0x634A0103,
		0x81C, 0x624C0103,
		0x81C, 0x614E0103,
		0x81C, 0x45500103,
		0x81C, 0x44520103,
		0x81C, 0x43540103,
		0x81C, 0x42560103,
		0x81C, 0x25580103,
		0x81C, 0x245A0103,
		0x81C, 0x235C0103,
		0x81C, 0x065E0103,
		0x81C, 0x05600103,
		0x81C, 0x04620103,
		0x81C, 0x03640103,
		0x81C, 0x02660103,
		0x81C, 0x01680103,
		0x81C, 0x016A0103,
		0x81C, 0x016C0103,
		0x81C, 0x016E0103,
		0x81C, 0x01700103,
		0x81C, 0x01720103,
		0x81C, 0x01740103,
		0x81C, 0x01760103,
		0x81C, 0x01780103,
		0x81C, 0x017A0103,
		0x81C, 0x017C0103,
		0x81C, 0x017E0103,
	0x90000004,	0x00550000,	0x40000000,	0x00550000,
		0x81C, 0xFF000103,
		0x81C, 0xFF020103,
		0x81C, 0xFE040103,
		0x81C, 0xFD060103,
		0x81C, 0xFC080103,
		0x81C, 0xFB0A0103,
		0x81C, 0xFA0C0103,
		0x81C, 0xF90E0103,
		0x81C, 0xF8100103,
		0x81C, 0xF7120103,
		0x81C, 0xF6140103,
		0x81C, 0xF5160103,
		0x81C, 0xF4180103,
		0x81C, 0xF31A0103,
		0x81C, 0xF21C0103,
		0x81C, 0xF11E0103,
		0x81C, 0xF0200103,
		0x81C, 0xEF220103,
		0x81C, 0xEE240103,
		0x81C, 0xED260103,
		0x81C, 0xEC280103,
		0x81C, 0xEB2A0103,
		0x81C, 0xEA2C0103,
		0x81C, 0xE92E0103,
		0x81C, 0xE8300103,
		0x81C, 0xE7320103,
		0x81C, 0xE6340103,
		0x81C, 0xE5360103,
		0x81C, 0xE4380103,
		0x81C, 0xE33A0103,
		0x81C, 0xA53C0103,
		0x81C, 0xA43E0103,
		0x81C, 0xA3400103,
		0x81C, 0xA2420103,
		0x81C, 0xA1440103,
		0x81C, 0x85460103,
		0x81C, 0x84480103,
		0x81C, 0x834A0103,
		0x81C, 0x824C0103,
		0x81C, 0x814E0103,
		0x81C, 0x64500103,
		0x81C, 0x63520103,
		0x81C, 0x62540103,
		0x81C, 0x44560103,
		0x81C, 0x43580103,
		0x81C, 0x425A0103,
		0x81C, 0x265C0103,
		0x81C, 0x255E0103,
		0x81C, 0x24600103,
		0x81C, 0x07620103,
		0x81C, 0x06640103,
		0x81C, 0x05660103,
		0x81C, 0x04680103,
		0x81C, 0x036A0103,
		0x81C, 0x026C0103,
		0x81C, 0x016E0103,
		0x81C, 0x01700103,
		0x81C, 0x01720103,
		0x81C, 0x01740103,
		0x81C, 0x01760103,
		0x81C, 0x01780103,
		0x81C, 0x017A0103,
		0x81C, 0x017C0103,
		0x81C, 0x017E0103,
	0xA0000000,	0x00000000,
		0x81C, 0xFF000103,
		0x81C, 0xFE020103,
		0x81C, 0xFD040103,
		0x81C, 0xFC060103,
		0x81C, 0xFB080103,
		0x81C, 0xFA0A0103,
		0x81C, 0xF90C0103,
		0x81C, 0xF80E0103,
		0x81C, 0xF7100103,
		0x81C, 0xF6120103,
		0x81C, 0xF5140103,
		0x81C, 0xF4160103,
		0x81C, 0xF3180103,
		0x81C, 0xF21A0103,
		0x81C, 0xF11C0103,
		0x81C, 0xF01E0103,
		0x81C, 0xEF200103,
		0x81C, 0xEE220103,
		0x81C, 0xED240103,
		0x81C, 0xEC260103,
		0x81C, 0xEB280103,
		0x81C, 0xEA2A0103,
		0x81C, 0xE92C0103,
		0x81C, 0xE82E0103,
		0x81C, 0xE7300103,
		0x81C, 0xE6320103,
		0x81C, 0xE5340103,
		0x81C, 0xE4360103,
		0x81C, 0xE3380103,
		0x81C, 0xE23A0103,
		0x81C, 0xE13C0103,
		0x81C, 0xA43E0103,
		0x81C, 0xA3400103,
		0x81C, 0xA2420103,
		0x81C, 0xA1440103,
		0x81C, 0x86460103,
		0x81C, 0x85480103,
		0x81C, 0x844A0103,
		0x81C, 0x834C0103,
		0x81C, 0x824E0103,
		0x81C, 0x81500103,
		0x81C, 0x64520103,
		0x81C, 0x63540103,
		0x81C, 0x62560103,
		0x81C, 0x61580103,
		0x81C, 0x435A0103,
		0x81C, 0x425C0103,
		0x81C, 0x415E0103,
		0x81C, 0x25600103,
		0x81C, 0x24620103,
		0x81C, 0x06640103,
		0x81C, 0x05660103,
		0x81C, 0x04680103,
		0x81C, 0x036A0103,
		0x81C, 0x026C0103,
		0x81C, 0x016E0103,
		0x81C, 0x01700103,
		0x81C, 0x01720103,
		0x81C, 0x01740103,
		0x81C, 0x01760103,
		0x81C, 0x01780103,
		0x81C, 0x017A0103,
		0x81C, 0x017C0103,
		0x81C, 0x017E0103,
	0xB0000000,	0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000203,
		0x81C, 0xFB020203,
		0x81C, 0xFA040203,
		0x81C, 0xF9060203,
		0x81C, 0xF8080203,
		0x81C, 0xF70A0203,
		0x81C, 0xF60C0203,
		0x81C, 0xF50E0203,
		0x81C, 0xF4100203,
		0x81C, 0xF3120203,
		0x81C, 0xF2140203,
		0x81C, 0xF1160203,
		0x81C, 0xF0180203,
		0x81C, 0xEF1A0203,
		0x81C, 0xEE1C0203,
		0x81C, 0xED1E0203,
		0x81C, 0xEC200203,
		0x81C, 0xEB220203,
		0x81C, 0xEA240203,
		0x81C, 0xE9260203,
		0x81C, 0xE8280203,
		0x81C, 0xE72A0203,
		0x81C, 0xE62C0203,
		0x81C, 0xE52E0203,
		0x81C, 0xE4300203,
		0x81C, 0xE3320203,
		0x81C, 0xE2340203,
		0x81C, 0xE1360203,
		0x81C, 0xA5380203,
		0x81C, 0xA43A0203,
		0x81C, 0xA33C0203,
		0x81C, 0x853E0203,
		0x81C, 0x84400203,
		0x81C, 0x83420203,
		0x81C, 0x82440203,
		0x81C, 0x81460203,
		0x81C, 0x64480203,
		0x81C, 0x634A0203,
		0x81C, 0x624C0203,
		0x81C, 0x614E0203,
		0x81C, 0x46500203,
		0x81C, 0x45520203,
		0x81C, 0x44540203,
		0x81C, 0x43560203,
		0x81C, 0x25580203,
		0x81C, 0x245A0203,
		0x81C, 0x235C0203,
		0x81C, 0x075E0203,
		0x81C, 0x06600203,
		0x81C, 0x05620203,
		0x81C, 0x04640203,
		0x81C, 0x03660203,
		0x81C, 0x02680203,
		0x81C, 0x016A0203,
		0x81C, 0x016C0203,
		0x81C, 0x016E0203,
		0x81C, 0x01700203,
		0x81C, 0x01720203,
		0x81C, 0x01740203,
		0x81C, 0x01760203,
		0x81C, 0x01780203,
		0x81C, 0x017A0203,
		0x81C, 0x017C0203,
		0x81C, 0x017E0203,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x81C, 0xF8000203,
		0x81C, 0xF7020203,
		0x81C, 0xF6040203,
		0x81C, 0xF5060203,
		0x81C, 0xF4080203,
		0x81C, 0xF30A0203,
		0x81C, 0xF20C0203,
		0x81C, 0xF10E0203,
		0x81C, 0xF0100203,
		0x81C, 0xEF120203,
		0x81C, 0xEE140203,
		0x81C, 0xED160203,
		0x81C, 0xEC180203,
		0x81C, 0xEB1A0203,
		0x81C, 0xEA1C0203,
		0x81C, 0xE91E0203,
		0x81C, 0xE8200203,
		0x81C, 0xE7220203,
		0x81C, 0xE6240203,
		0x81C, 0xE5260203,
		0x81C, 0xE4280203,
		0x81C, 0xE32A0203,
		0x81C, 0xE22C0203,
		0x81C, 0xE12E0203,
		0x81C, 0xA6300203,
		0x81C, 0xA5320203,
		0x81C, 0xA4340203,
		0x81C, 0xA3360203,
		0x81C, 0xA2380203,
		0x81C, 0x853A0203,
		0x81C, 0x843C0203,
		0x81C, 0x833E0203,
		0x81C, 0x82400203,
		0x81C, 0x81420203,
		0x81C, 0x64440203,
		0x81C, 0x63460203,
		0x81C, 0x62480203,
		0x81C, 0x614A0203,
		0x81C, 0x444C0203,
		0x81C, 0x434E0203,
		0x81C, 0x42500203,
		0x81C, 0x25520203,
		0x81C, 0x24540203,
		0x81C, 0x23560203,
		0x81C, 0x06580203,
		0x81C, 0x055A0203,
		0x81C, 0x045C0203,
		0x81C, 0x035E0203,
		0x81C, 0x02600203,
		0x81C, 0x01620203,
		0x81C, 0x01640203,
		0x81C, 0x01660203,
		0x81C, 0x01680203,
		0x81C, 0x016A0203,
		0x81C, 0x016C0203,
		0x81C, 0x016E0203,
		0x81C, 0x01700203,
		0x81C, 0x01720203,
		0x81C, 0x01740203,
		0x81C, 0x01760203,
		0x81C, 0x01780203,
		0x81C, 0x017A0203,
		0x81C, 0x017C0203,
		0x81C, 0x017E0203,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x81C, 0xFC000203,
		0x81C, 0xFB020203,
		0x81C, 0xFA040203,
		0x81C, 0xF9060203,
		0x81C, 0xF8080203,
		0x81C, 0xF70A0203,
		0x81C, 0xF60C0203,
		0x81C, 0xF50E0203,
		0x81C, 0xF4100203,
		0x81C, 0xF3120203,
		0x81C, 0xF2140203,
		0x81C, 0xF1160203,
		0x81C, 0xF0180203,
		0x81C, 0xEF1A0203,
		0x81C, 0xEE1C0203,
		0x81C, 0xED1E0203,
		0x81C, 0xEC200203,
		0x81C, 0xEB220203,
		0x81C, 0xEA240203,
		0x81C, 0xE9260203,
		0x81C, 0xE8280203,
		0x81C, 0xE72A0203,
		0x81C, 0xE62C0203,
		0x81C, 0xE52E0203,
		0x81C, 0xE4300203,
		0x81C, 0xE3320203,
		0x81C, 0xE2340203,
		0x81C, 0xE1360203,
		0x81C, 0x87380203,
		0x81C, 0x863A0203,
		0x81C, 0x853C0203,
		0x81C, 0x843E0203,
		0x81C, 0x83400203,
		0x81C, 0x82420203,
		0x81C, 0x81440203,
		0x81C, 0x64460203,
		0x81C, 0x63480203,
		0x81C, 0x624A0203,
		0x81C, 0x474C0203,
		0x81C, 0x464E0203,
		0x81C, 0x45500203,
		0x81C, 0x44520203,
		0x81C, 0x43540203,
		0x81C, 0x42560203,
		0x81C, 0x24580203,
		0x81C, 0x235A0203,
		0x81C, 0x075C0203,
		0x81C, 0x065E0203,
		0x81C, 0x05600203,
		0x81C, 0x04620203,
		0x81C, 0x03640203,
		0x81C, 0x02660203,
		0x81C, 0x01680203,
		0x81C, 0x016A0203,
		0x81C, 0x016C0203,
		0x81C, 0x016E0203,
		0x81C, 0x01700203,
		0x81C, 0x01720203,
		0x81C, 0x01740203,
		0x81C, 0x01760203,
		0x81C, 0x01780203,
		0x81C, 0x017A0203,
		0x81C, 0x017C0203,
		0x81C, 0x017E0203,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x81C, 0xF8000203,
		0x81C, 0xF7020203,
		0x81C, 0xF6040203,
		0x81C, 0xF5060203,
		0x81C, 0xF4080203,
		0x81C, 0xF30A0203,
		0x81C, 0xF20C0203,
		0x81C, 0xF10E0203,
		0x81C, 0xF0100203,
		0x81C, 0xEF120203,
		0x81C, 0xEE140203,
		0x81C, 0xED160203,
		0x81C, 0xEC180203,
		0x81C, 0xEB1A0203,
		0x81C, 0xEA1C0203,
		0x81C, 0xE91E0203,
		0x81C, 0xE8200203,
		0x81C, 0xE7220203,
		0x81C, 0xE6240203,
		0x81C, 0xE5260203,
		0x81C, 0xE4280203,
		0x81C, 0xE32A0203,
		0x81C, 0xE22C0203,
		0x81C, 0xE12E0203,
		0x81C, 0xA6300203,
		0x81C, 0xA5320203,
		0x81C, 0xA4340203,
		0x81C, 0xA3360203,
		0x81C, 0xA2380203,
		0x81C, 0xA13A0203,
		0x81C, 0x843C0203,
		0x81C, 0x833E0203,
		0x81C, 0x82400203,
		0x81C, 0x81420203,
		0x81C, 0x64440203,
		0x81C, 0x63460203,
		0x81C, 0x62480203,
		0x81C, 0x614A0203,
		0x81C, 0x444C0203,
		0x81C, 0x434E0203,
		0x81C, 0x42500203,
		0x81C, 0x41520203,
		0x81C, 0x25540203,
		0x81C, 0x24560203,
		0x81C, 0x23580203,
		0x81C, 0x065A0203,
		0x81C, 0x055C0203,
		0x81C, 0x045E0203,
		0x81C, 0x03600203,
		0x81C, 0x02620203,
		0x81C, 0x01640203,
		0x81C, 0x01660203,
		0x81C, 0x01680203,
		0x81C, 0x016A0203,
		0x81C, 0x016C0203,
		0x81C, 0x016E0203,
		0x81C, 0x01700203,
		0x81C, 0x01720203,
		0x81C, 0x01740203,
		0x81C, 0x01760203,
		0x81C, 0x01780203,
		0x81C, 0x017A0203,
		0x81C, 0x017C0203,
		0x81C, 0x017E0203,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x81C, 0xFB000203,
		0x81C, 0xFA020203,
		0x81C, 0xF9040203,
		0x81C, 0xF8060203,
		0x81C, 0xF7080203,
		0x81C, 0xF60A0203,
		0x81C, 0xF50C0203,
		0x81C, 0xF40E0203,
		0x81C, 0xF3100203,
		0x81C, 0xF2120203,
		0x81C, 0xF1140203,
		0x81C, 0xF0160203,
		0x81C, 0xEF180203,
		0x81C, 0xEE1A0203,
		0x81C, 0xED1C0203,
		0x81C, 0xEC1E0203,
		0x81C, 0xEB200203,
		0x81C, 0xEA220203,
		0x81C, 0xE9240203,
		0x81C, 0xE8260203,
		0x81C, 0xE7280203,
		0x81C, 0xE62A0203,
		0x81C, 0xE52C0203,
		0x81C, 0xE42E0203,
		0x81C, 0xE3300203,
		0x81C, 0xE2320203,
		0x81C, 0xE1340203,
		0x81C, 0xA5360203,
		0x81C, 0xA4380203,
		0x81C, 0xA33A0203,
		0x81C, 0xA23C0203,
		0x81C, 0x843E0203,
		0x81C, 0x83400203,
		0x81C, 0x82420203,
		0x81C, 0x81440203,
		0x81C, 0x64460203,
		0x81C, 0x63480203,
		0x81C, 0x624A0203,
		0x81C, 0x614C0203,
		0x81C, 0x474E0203,
		0x81C, 0x46500203,
		0x81C, 0x45520203,
		0x81C, 0x44540203,
		0x81C, 0x43560203,
		0x81C, 0x25580203,
		0x81C, 0x245A0203,
		0x81C, 0x235C0203,
		0x81C, 0x075E0203,
		0x81C, 0x06600203,
		0x81C, 0x05620203,
		0x81C, 0x04640203,
		0x81C, 0x03660203,
		0x81C, 0x02680203,
		0x81C, 0x016A0203,
		0x81C, 0x016C0203,
		0x81C, 0x016E0203,
		0x81C, 0x01700203,
		0x81C, 0x01720203,
		0x81C, 0x01740203,
		0x81C, 0x01760203,
		0x81C, 0x01780203,
		0x81C, 0x017A0203,
		0x81C, 0x017C0203,
		0x81C, 0x017E0203,
	0x90000004,	0x00550000,	0x40000000,	0x00550000,
		0x81C, 0xFF000203,
		0x81C, 0xFF020203,
		0x81C, 0xFE040203,
		0x81C, 0xFD060203,
		0x81C, 0xFC080203,
		0x81C, 0xFB0A0203,
		0x81C, 0xFA0C0203,
		0x81C, 0xF90E0203,
		0x81C, 0xF8100203,
		0x81C, 0xF7120203,
		0x81C, 0xF6140203,
		0x81C, 0xF5160203,
		0x81C, 0xF4180203,
		0x81C, 0xF31A0203,
		0x81C, 0xF21C0203,
		0x81C, 0xF11E0203,
		0x81C, 0xF0200203,
		0x81C, 0xEF220203,
		0x81C, 0xEE240203,
		0x81C, 0xED260203,
		0x81C, 0xEC280203,
		0x81C, 0xEB2A0203,
		0x81C, 0xEA2C0203,
		0x81C, 0xE92E0203,
		0x81C, 0xE8300203,
		0x81C, 0xE7320203,
		0x81C, 0xE6340203,
		0x81C, 0xE5360203,
		0x81C, 0xE4380203,
		0x81C, 0xE33A0203,
		0x81C, 0xE23C0203,
		0x81C, 0xE13E0203,
		0x81C, 0xA4400203,
		0x81C, 0xA3420203,
		0x81C, 0xA2440203,
		0x81C, 0xA1460203,
		0x81C, 0x84480203,
		0x81C, 0x834A0203,
		0x81C, 0x824C0203,
		0x81C, 0x814E0203,
		0x81C, 0x64500203,
		0x81C, 0x63520203,
		0x81C, 0x62540203,
		0x81C, 0x61560203,
		0x81C, 0x45580203,
		0x81C, 0x445A0203,
		0x81C, 0x435C0203,
		0x81C, 0x425E0203,
		0x81C, 0x24600203,
		0x81C, 0x23620203,
		0x81C, 0x07640203,
		0x81C, 0x06660203,
		0x81C, 0x05680203,
		0x81C, 0x046A0203,
		0x81C, 0x036C0203,
		0x81C, 0x026E0203,
		0x81C, 0x01700203,
		0x81C, 0x01720203,
		0x81C, 0x01740203,
		0x81C, 0x01760203,
		0x81C, 0x01780203,
		0x81C, 0x017A0203,
		0x81C, 0x017C0203,
		0x81C, 0x017E0203,
	0xA0000000,	0x00000000,
		0x81C, 0xFF000203,
		0x81C, 0xFF020203,
		0x81C, 0xFE040203,
		0x81C, 0xFD060203,
		0x81C, 0xFC080203,
		0x81C, 0xFB0A0203,
		0x81C, 0xFA0C0203,
		0x81C, 0xF90E0203,
		0x81C, 0xF8100203,
		0x81C, 0xF7120203,
		0x81C, 0xF6140203,
		0x81C, 0xF5160203,
		0x81C, 0xF4180203,
		0x81C, 0xF31A0203,
		0x81C, 0xF21C0203,
		0x81C, 0xF11E0203,
		0x81C, 0xF0200203,
		0x81C, 0xEF220203,
		0x81C, 0xEE240203,
		0x81C, 0xED260203,
		0x81C, 0xEC280203,
		0x81C, 0xEB2A0203,
		0x81C, 0xEA2C0203,
		0x81C, 0xE92E0203,
		0x81C, 0xE8300203,
		0x81C, 0xE7320203,
		0x81C, 0xE6340203,
		0x81C, 0xE5360203,
		0x81C, 0xE4380203,
		0x81C, 0xE33A0203,
		0x81C, 0xE23C0203,
		0x81C, 0xE13E0203,
		0x81C, 0xA4400203,
		0x81C, 0xA3420203,
		0x81C, 0xA2440203,
		0x81C, 0xA1460203,
		0x81C, 0x85480203,
		0x81C, 0x844A0203,
		0x81C, 0x834C0203,
		0x81C, 0x824E0203,
		0x81C, 0x81500203,
		0x81C, 0x64520203,
		0x81C, 0x63540203,
		0x81C, 0x62560203,
		0x81C, 0x61580203,
		0x81C, 0x445A0203,
		0x81C, 0x435C0203,
		0x81C, 0x425E0203,
		0x81C, 0x25600203,
		0x81C, 0x24620203,
		0x81C, 0x06640203,
		0x81C, 0x05660203,
		0x81C, 0x04680203,
		0x81C, 0x036A0203,
		0x81C, 0x026C0203,
		0x81C, 0x016E0203,
		0x81C, 0x01700203,
		0x81C, 0x01720203,
		0x81C, 0x01740203,
		0x81C, 0x01760203,
		0x81C, 0x01780203,
		0x81C, 0x017A0203,
		0x81C, 0x017C0203,
		0x81C, 0x017E0203,
	0xB0000000,	0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF9000303,
		0x81C, 0xF8020303,
		0x81C, 0xF7040303,
		0x81C, 0xF6060303,
		0x81C, 0xF5080303,
		0x81C, 0xF40A0303,
		0x81C, 0xF30C0303,
		0x81C, 0xF20E0303,
		0x81C, 0xF1100303,
		0x81C, 0xF0120303,
		0x81C, 0xEF140303,
		0x81C, 0xEE160303,
		0x81C, 0xED180303,
		0x81C, 0xEC1A0303,
		0x81C, 0xEB1C0303,
		0x81C, 0xEA1E0303,
		0x81C, 0xE9200303,
		0x81C, 0xE8220303,
		0x81C, 0xE7240303,
		0x81C, 0xE6260303,
		0x81C, 0xE5280303,
		0x81C, 0xE42A0303,
		0x81C, 0xE32C0303,
		0x81C, 0xE22E0303,
		0x81C, 0xE1300303,
		0x81C, 0xA6320303,
		0x81C, 0xA5340303,
		0x81C, 0xA4360303,
		0x81C, 0xA3380303,
		0x81C, 0xA23A0303,
		0x81C, 0xA13C0303,
		0x81C, 0x853E0303,
		0x81C, 0x84400303,
		0x81C, 0x83420303,
		0x81C, 0x82440303,
		0x81C, 0x81460303,
		0x81C, 0x64480303,
		0x81C, 0x634A0303,
		0x81C, 0x624C0303,
		0x81C, 0x614E0303,
		0x81C, 0x44500303,
		0x81C, 0x43520303,
		0x81C, 0x42540303,
		0x81C, 0x41560303,
		0x81C, 0x25580303,
		0x81C, 0x245A0303,
		0x81C, 0x235C0303,
		0x81C, 0x055E0303,
		0x81C, 0x04600303,
		0x81C, 0x03620303,
		0x81C, 0x02640303,
		0x81C, 0x01660303,
		0x81C, 0x01680303,
		0x81C, 0x016A0303,
		0x81C, 0x016C0303,
		0x81C, 0x016E0303,
		0x81C, 0x01700303,
		0x81C, 0x01720303,
		0x81C, 0x01740303,
		0x81C, 0x01760303,
		0x81C, 0x01780303,
		0x81C, 0x017A0303,
		0x81C, 0x017C0303,
		0x81C, 0x017E0303,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x81C, 0xF7000303,
		0x81C, 0xF6020303,
		0x81C, 0xF5040303,
		0x81C, 0xF4060303,
		0x81C, 0xF3080303,
		0x81C, 0xF20A0303,
		0x81C, 0xF10C0303,
		0x81C, 0xF00E0303,
		0x81C, 0xEF100303,
		0x81C, 0xEE120303,
		0x81C, 0xED140303,
		0x81C, 0xEC160303,
		0x81C, 0xEB180303,
		0x81C, 0xEA1A0303,
		0x81C, 0xE91C0303,
		0x81C, 0xE81E0303,
		0x81C, 0xE7200303,
		0x81C, 0xE6220303,
		0x81C, 0xE5240303,
		0x81C, 0xE4260303,
		0x81C, 0xE3280303,
		0x81C, 0xC32A0303,
		0x81C, 0xC22C0303,
		0x81C, 0xC12E0303,
		0x81C, 0xA5300303,
		0x81C, 0xA4320303,
		0x81C, 0xA3340303,
		0x81C, 0xA2360303,
		0x81C, 0xA1380303,
		0x81C, 0x853A0303,
		0x81C, 0x843C0303,
		0x81C, 0x833E0303,
		0x81C, 0x82400303,
		0x81C, 0x81420303,
		0x81C, 0x64440303,
		0x81C, 0x63460303,
		0x81C, 0x62480303,
		0x81C, 0x614A0303,
		0x81C, 0x454C0303,
		0x81C, 0x444E0303,
		0x81C, 0x43500303,
		0x81C, 0x25520303,
		0x81C, 0x24540303,
		0x81C, 0x23560303,
		0x81C, 0x06580303,
		0x81C, 0x055A0303,
		0x81C, 0x045C0303,
		0x81C, 0x035E0303,
		0x81C, 0x02600303,
		0x81C, 0x01620303,
		0x81C, 0x01640303,
		0x81C, 0x01660303,
		0x81C, 0x01680303,
		0x81C, 0x016A0303,
		0x81C, 0x016C0303,
		0x81C, 0x016E0303,
		0x81C, 0x01700303,
		0x81C, 0x01720303,
		0x81C, 0x01740303,
		0x81C, 0x01760303,
		0x81C, 0x01780303,
		0x81C, 0x017A0303,
		0x81C, 0x017C0303,
		0x81C, 0x017E0303,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x81C, 0xF9000303,
		0x81C, 0xF8020303,
		0x81C, 0xF7040303,
		0x81C, 0xF6060303,
		0x81C, 0xF5080303,
		0x81C, 0xF40A0303,
		0x81C, 0xF30C0303,
		0x81C, 0xF20E0303,
		0x81C, 0xF1100303,
		0x81C, 0xF0120303,
		0x81C, 0xEF140303,
		0x81C, 0xEE160303,
		0x81C, 0xED180303,
		0x81C, 0xEC1A0303,
		0x81C, 0xEB1C0303,
		0x81C, 0xEA1E0303,
		0x81C, 0xE9200303,
		0x81C, 0xE8220303,
		0x81C, 0xE7240303,
		0x81C, 0xE6260303,
		0x81C, 0xE5280303,
		0x81C, 0xE42A0303,
		0x81C, 0xE32C0303,
		0x81C, 0xE22E0303,
		0x81C, 0xE1300303,
		0x81C, 0xA4320303,
		0x81C, 0xA3340303,
		0x81C, 0xA2360303,
		0x81C, 0xA1380303,
		0x81C, 0x853A0303,
		0x81C, 0x843C0303,
		0x81C, 0x833E0303,
		0x81C, 0x82400303,
		0x81C, 0x81420303,
		0x81C, 0x64440303,
		0x81C, 0x63460303,
		0x81C, 0x62480303,
		0x81C, 0x614A0303,
		0x81C, 0x444C0303,
		0x81C, 0x434E0303,
		0x81C, 0x42500303,
		0x81C, 0x25520303,
		0x81C, 0x24540303,
		0x81C, 0x23560303,
		0x81C, 0x07580303,
		0x81C, 0x065A0303,
		0x81C, 0x055C0303,
		0x81C, 0x045E0303,
		0x81C, 0x03600303,
		0x81C, 0x02620303,
		0x81C, 0x01640303,
		0x81C, 0x01660303,
		0x81C, 0x01680303,
		0x81C, 0x016A0303,
		0x81C, 0x016C0303,
		0x81C, 0x016E0303,
		0x81C, 0x01700303,
		0x81C, 0x01720303,
		0x81C, 0x01740303,
		0x81C, 0x01760303,
		0x81C, 0x01780303,
		0x81C, 0x017A0303,
		0x81C, 0x017C0303,
		0x81C, 0x017E0303,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x81C, 0xF7000303,
		0x81C, 0xF6020303,
		0x81C, 0xF5040303,
		0x81C, 0xF4060303,
		0x81C, 0xF3080303,
		0x81C, 0xF20A0303,
		0x81C, 0xF10C0303,
		0x81C, 0xF00E0303,
		0x81C, 0xEF100303,
		0x81C, 0xEE120303,
		0x81C, 0xED140303,
		0x81C, 0xEC160303,
		0x81C, 0xEB180303,
		0x81C, 0xEA1A0303,
		0x81C, 0xE91C0303,
		0x81C, 0xE81E0303,
		0x81C, 0xE7200303,
		0x81C, 0xE6220303,
		0x81C, 0xE5240303,
		0x81C, 0xE4260303,
		0x81C, 0xE3280303,
		0x81C, 0xE22A0303,
		0x81C, 0xE12C0303,
		0x81C, 0xA72E0303,
		0x81C, 0xA6300303,
		0x81C, 0xA5320303,
		0x81C, 0xA4340303,
		0x81C, 0xA3360303,
		0x81C, 0xA2380303,
		0x81C, 0xA13A0303,
		0x81C, 0x843C0303,
		0x81C, 0x833E0303,
		0x81C, 0x82400303,
		0x81C, 0x81420303,
		0x81C, 0x64440303,
		0x81C, 0x63460303,
		0x81C, 0x62480303,
		0x81C, 0x614A0303,
		0x81C, 0x454C0303,
		0x81C, 0x444E0303,
		0x81C, 0x43500303,
		0x81C, 0x42520303,
		0x81C, 0x41540303,
		0x81C, 0x24560303,
		0x81C, 0x23580303,
		0x81C, 0x065A0303,
		0x81C, 0x055C0303,
		0x81C, 0x045E0303,
		0x81C, 0x03600303,
		0x81C, 0x02620303,
		0x81C, 0x01640303,
		0x81C, 0x01660303,
		0x81C, 0x01680303,
		0x81C, 0x016A0303,
		0x81C, 0x016C0303,
		0x81C, 0x016E0303,
		0x81C, 0x01700303,
		0x81C, 0x01720303,
		0x81C, 0x01740303,
		0x81C, 0x01760303,
		0x81C, 0x01780303,
		0x81C, 0x017A0303,
		0x81C, 0x017C0303,
		0x81C, 0x017E0303,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x81C, 0xFB000303,
		0x81C, 0xFA020303,
		0x81C, 0xF9040303,
		0x81C, 0xF8060303,
		0x81C, 0xF7080303,
		0x81C, 0xF60A0303,
		0x81C, 0xF50C0303,
		0x81C, 0xF40E0303,
		0x81C, 0xF3100303,
		0x81C, 0xF2120303,
		0x81C, 0xF1140303,
		0x81C, 0xF0160303,
		0x81C, 0xEF180303,
		0x81C, 0xEE1A0303,
		0x81C, 0xED1C0303,
		0x81C, 0xEC1E0303,
		0x81C, 0xEB200303,
		0x81C, 0xEA220303,
		0x81C, 0xE9240303,
		0x81C, 0xE8260303,
		0x81C, 0xE7280303,
		0x81C, 0xE62A0303,
		0x81C, 0xE52C0303,
		0x81C, 0xE42E0303,
		0x81C, 0xE3300303,
		0x81C, 0xE2320303,
		0x81C, 0xE1340303,
		0x81C, 0xC2360303,
		0x81C, 0xC1380303,
		0x81C, 0xA33A0303,
		0x81C, 0xA23C0303,
		0x81C, 0x853E0303,
		0x81C, 0x84400303,
		0x81C, 0x83420303,
		0x81C, 0x66440303,
		0x81C, 0x65460303,
		0x81C, 0x64480303,
		0x81C, 0x634A0303,
		0x81C, 0x624C0303,
		0x81C, 0x614E0303,
		0x81C, 0x45500303,
		0x81C, 0x44520303,
		0x81C, 0x43540303,
		0x81C, 0x42560303,
		0x81C, 0x25580303,
		0x81C, 0x245A0303,
		0x81C, 0x235C0303,
		0x81C, 0x065E0303,
		0x81C, 0x05600303,
		0x81C, 0x04620303,
		0x81C, 0x03640303,
		0x81C, 0x02660303,
		0x81C, 0x01680303,
		0x81C, 0x016A0303,
		0x81C, 0x016C0303,
		0x81C, 0x016E0303,
		0x81C, 0x01700303,
		0x81C, 0x01720303,
		0x81C, 0x01740303,
		0x81C, 0x01760303,
		0x81C, 0x01780303,
		0x81C, 0x017A0303,
		0x81C, 0x017C0303,
		0x81C, 0x017E0303,
	0x90000004,	0x00550000,	0x40000000,	0x00550000,
		0x81C, 0xFE000303,
		0x81C, 0xFD020303,
		0x81C, 0xFC040303,
		0x81C, 0xFB060303,
		0x81C, 0xFA080303,
		0x81C, 0xF90A0303,
		0x81C, 0xF80C0303,
		0x81C, 0xF70E0303,
		0x81C, 0xF6100303,
		0x81C, 0xF5120303,
		0x81C, 0xF4140303,
		0x81C, 0xF3160303,
		0x81C, 0xF2180303,
		0x81C, 0xF11A0303,
		0x81C, 0xF01C0303,
		0x81C, 0xEF1E0303,
		0x81C, 0xEE200303,
		0x81C, 0xED220303,
		0x81C, 0xEC240303,
		0x81C, 0xEB260303,
		0x81C, 0xEA280303,
		0x81C, 0xE92A0303,
		0x81C, 0xE82C0303,
		0x81C, 0xE72E0303,
		0x81C, 0xE6300303,
		0x81C, 0xE5320303,
		0x81C, 0xE4340303,
		0x81C, 0xE3360303,
		0x81C, 0xC3380303,
		0x81C, 0xC23A0303,
		0x81C, 0xC13C0303,
		0x81C, 0xA43E0303,
		0x81C, 0xA3400303,
		0x81C, 0xA2420303,
		0x81C, 0xA1440303,
		0x81C, 0x85460303,
		0x81C, 0x84480303,
		0x81C, 0x834A0303,
		0x81C, 0x824C0303,
		0x81C, 0x814E0303,
		0x81C, 0x64500303,
		0x81C, 0x63520303,
		0x81C, 0x62540303,
		0x81C, 0x61560303,
		0x81C, 0x44580303,
		0x81C, 0x435A0303,
		0x81C, 0x425C0303,
		0x81C, 0x265E0303,
		0x81C, 0x25600303,
		0x81C, 0x24620303,
		0x81C, 0x06640303,
		0x81C, 0x05660303,
		0x81C, 0x04680303,
		0x81C, 0x036A0303,
		0x81C, 0x026C0303,
		0x81C, 0x016E0303,
		0x81C, 0x01700303,
		0x81C, 0x01720303,
		0x81C, 0x01740303,
		0x81C, 0x01760303,
		0x81C, 0x01780303,
		0x81C, 0x017A0303,
		0x81C, 0x017C0303,
		0x81C, 0x017E0303,
	0xA0000000,	0x00000000,
		0x81C, 0xFD000303,
		0x81C, 0xFC020303,
		0x81C, 0xFB040303,
		0x81C, 0xFA060303,
		0x81C, 0xF9080303,
		0x81C, 0xF80A0303,
		0x81C, 0xF70C0303,
		0x81C, 0xF60E0303,
		0x81C, 0xF5100303,
		0x81C, 0xF4120303,
		0x81C, 0xF3140303,
		0x81C, 0xF2160303,
		0x81C, 0xF1180303,
		0x81C, 0xF01A0303,
		0x81C, 0xEF1C0303,
		0x81C, 0xEE1E0303,
		0x81C, 0xED200303,
		0x81C, 0xEC220303,
		0x81C, 0xEB240303,
		0x81C, 0xEA260303,
		0x81C, 0xE9280303,
		0x81C, 0xE82A0303,
		0x81C, 0xE72C0303,
		0x81C, 0xE62E0303,
		0x81C, 0xE5300303,
		0x81C, 0xE4320303,
		0x81C, 0xE3340303,
		0x81C, 0xE2360303,
		0x81C, 0xE1380303,
		0x81C, 0xA53A0303,
		0x81C, 0xA43C0303,
		0x81C, 0xA33E0303,
		0x81C, 0xA2400303,
		0x81C, 0xA1420303,
		0x81C, 0x87440303,
		0x81C, 0x86460303,
		0x81C, 0x85480303,
		0x81C, 0x844A0303,
		0x81C, 0x834C0303,
		0x81C, 0x824E0303,
		0x81C, 0x81500303,
		0x81C, 0x64520303,
		0x81C, 0x63540303,
		0x81C, 0x62560303,
		0x81C, 0x61580303,
		0x81C, 0x435A0303,
		0x81C, 0x425C0303,
		0x81C, 0x415E0303,
		0x81C, 0x07600303,
		0x81C, 0x06620303,
		0x81C, 0x05640303,
		0x81C, 0x04660303,
		0x81C, 0x03680303,
		0x81C, 0x026A0303,
		0x81C, 0x016C0303,
		0x81C, 0x016E0303,
		0x81C, 0x01700303,
		0x81C, 0x01720303,
		0x81C, 0x01740303,
		0x81C, 0x01760303,
		0x81C, 0x01780303,
		0x81C, 0x017A0303,
		0x81C, 0x017C0303,
		0x81C, 0x017E0303,
	0xB0000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000020,
		0xE50, 0x00000022,
		0xE50, 0x00000020,
		0x1850, 0x00000022,
		0x1850, 0x00000020,
		0x1A50, 0x00000022,
		0x1A50, 0x00000020,

};

void
ODM_ReadAndConfig_MP_8814A_AGC_TAB(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_AGC_TAB)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_AGC_TAB;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_AGC_TAB\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigBB_AGC_8814A(pDM_Odm, v1, bMaskDWord, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_MP_8814A_AGC_TAB(void)
{
	   return 98;
}

/******************************************************************************
*                           PHY_REG.TXT
******************************************************************************/

u4Byte Array_MP_8814A_PHY_REG[] = { 
		0x800, 0x9020D010,
		0x804, 0x08011280,
		0x808, 0x0E0282FF,
		0x80C, 0x1000002F,
	0x8000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x810, 0x33303265,
	0xA0000000,	0x00000000,
		0x810, 0x33303265,
	0xB0000000,	0x00000000,
		0x814, 0x020C3D10,
		0x818, 0x04A10385,
		0x820, 0x00000000,
		0x824, 0x00033E40,
		0x828, 0x00000000,
		0x82C, 0x73985170,
		0x830, 0x79A0EA08,
		0x834, 0x042E708A,
	0x8000000f,	0x55555555,	0x40000000,	0x00000000,
		0x838, 0x86667640,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x838, 0x86667641,
	0xA0000000,	0x00000000,
		0x838, 0x86667640,
	0xB0000000,	0x00000000,
		0x83C, 0x9798B9B9,
		0x840, 0x17578F60,
		0x844, 0x4BBDFCDE,
		0x848, 0x5CD07F8B,
		0x84C, 0x6CFBF7B5,
		0x850, 0x28834706,
		0x854, 0x0001520C,
		0x858, 0x4060C000,
		0x85C, 0x74210368,
		0x860, 0x6929C321,
		0x864, 0x79727432,
		0x868, 0x8CA7A314,
		0x86C, 0x438C2878,
		0x870, 0x44444444,
		0x874, 0x21612C2E,
		0x878, 0x00003152,
		0x87C, 0x000FC000,
		0x8A0, 0x00000013,
		0x8A4, 0x7F7F7F7F,
		0x8A8, 0xA202033E,
		0x8AC, 0xF40F550A,
		0x8B0, 0x00000600,
		0x8B4, 0x000FC080,
		0x8B8, 0xEC0057FF,
		0x8BC, 0x8CA520C3,
		0x8C0, 0x3FF00020,
		0x8C4, 0x44C00000,
		0x8C8, 0x80025167,
		0x8CC, 0x08250492,
		0x8D0, 0x0000B800,
		0x8D4, 0x940008A0,
		0x8D8, 0x290B5612,
		0x8DC, 0x00000000,
		0x8E0, 0x32316407,
		0x8E4, 0x4A092925,
		0x8E8, 0xFFFFC42C,
		0x8EC, 0x99999999,
		0x8F0, 0x00009999,
		0x8F4, 0x00F80FA1,
		0x8F8, 0x400082C0,
		0x8FC, 0x00000000,
		0x900, 0x00400700,
		0x90C, 0x09004000,
		0x910, 0x0000FC00,
		0x914, 0xD6400404,
		0x918, 0x1C1028C0,
		0x91C, 0x64B11A1C,
		0x920, 0xE0767233,
		0x924, 0x055AA500,
		0x928, 0x4AB0E4E4,
		0x92C, 0xFFFE0000,
		0x930, 0xFFFFFFFE,
		0x934, 0x001FFFFF,
		0x938, 0x00008400,
		0x93C, 0x932C0642,
		0x940, 0x093E9360,
		0x944, 0x08000000,
		0x948, 0x04000000,
		0x950, 0x02010080,
		0x954, 0x86510080,
		0x960, 0x00000000,
		0x964, 0x00000000,
		0x968, 0x00000000,
		0x96C, 0x00000000,
		0x970, 0x801FFFFF,
		0x978, 0x00000000,
		0x97C, 0x00000000,
		0x980, 0x00000000,
		0x984, 0x00000000,
		0x988, 0x00000000,
		0x98C, 0x03440000,
		0x990, 0x27100000,
		0x994, 0xFFFF0100,
		0x998, 0xFFFFFF5C,
		0x99C, 0xFFFFFFFF,
		0x9A0, 0x000000FF,
		0x9A4, 0x00080080,
		0x9A8, 0x0C2F0000,
		0x9AC, 0x00560000,
		0x9B0, 0x81081008,
		0x9B4, 0x00000000,
		0x9B8, 0x01081008,
		0x9BC, 0x01081008,
		0x9D0, 0x00000000,
		0x9D4, 0x00000000,
		0x9D8, 0x00000000,
		0x9DC, 0x00000000,
		0x9E4, 0x00000002,
		0x9E8, 0x000022D5,
		0x9FC, 0xEFFFF7FF,
		0xB00, 0xE3100000,
		0xB04, 0x0000B000,
		0xB0C, 0x31EAA006,
		0xB5C, 0x41CFFFFF,
		0xC00, 0x00000007,
		0xC04, 0x00042020,
		0xC08, 0x80410231,
		0xC0C, 0x00000000,
		0xC10, 0x00000100,
		0xC14, 0x01000000,
		0xC1C, 0x40000053,
		0xC50, 0x00000020,
		0xC54, 0x00000000,
	0x8000000f,	0x55555555,	0x40000000,	0x00000000,
		0xC58, 0x3C0A0C14,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0xC58, 0x3C0A0C14,
	0xA0000000,	0x00000000,
		0xC58, 0x3C020C14,
	0xB0000000,	0x00000000,
		0xC5C, 0x0D000058,
		0xC60, 0x1B800000,
		0xC60, 0x0B800001,
		0xC60, 0x05800002,
		0xC60, 0x07800003,
		0xC60, 0x1A800004,
		0xC60, 0x0B800005,
		0xC60, 0x05800006,
		0xC60, 0x0E800007,
		0xC60, 0x1A800008,
		0xC60, 0x0B800009,
		0xC60, 0x1580000A,
		0xC60, 0x0880000B,
		0xC60, 0x1A80000C,
		0xC60, 0x0B80000D,
		0xC60, 0x0580000E,
		0xC60, 0x0E80000F,
		0xC60, 0x1A800010,
		0xC60, 0x0B800011,
		0xC60, 0x15800012,
		0xC60, 0x08800013,
		0xC60, 0x1A800014,
		0xC60, 0x0B800015,
		0xC60, 0x05800016,
		0xC60, 0x07800017,
		0xC60, 0x1A800018,
		0xC60, 0x0B800019,
		0xC60, 0x1580001A,
		0xC60, 0x0880001B,
		0xC60, 0x1B80001C,
		0xC60, 0x0B80001D,
		0xC60, 0x0580001E,
		0xC60, 0x0780001F,
		0xC60, 0x1B800020,
		0xC60, 0x0B800021,
		0xC60, 0x05800022,
		0xC60, 0x07800023,
		0xC60, 0x1B800024,
		0xC60, 0x0B800025,
		0xC60, 0x05800026,
		0xC60, 0x07800027,
		0xC60, 0x1B800028,
		0xC60, 0x0B800029,
		0xC60, 0x0580002A,
		0xC60, 0x0780002B,
		0xC60, 0x1B800030,
		0xC60, 0x0B800031,
		0xC60, 0x05800032,
		0xC60, 0x00800033,
		0xC60, 0x1B800034,
		0xC60, 0x0B800035,
		0xC60, 0x05800036,
		0xC60, 0x00800037,
		0xC60, 0x1B800038,
		0xC60, 0x0B800039,
		0xC60, 0x0580003A,
		0xC60, 0x0E80803B,
		0xC94, 0x01000401,
		0xC98, 0x00188000,
		0xCA0, 0x00002929,
		0xCA4, 0x08040201,
		0xCA8, 0x80402010,
		0xCAC, 0x77777000,
		0xCB0, 0x54775477,
		0xCB4, 0x54775477,
		0xCB8, 0x00500000,
		0xCBC, 0x77700000,
		0xCC0, 0x00000010,
		0xCC8, 0x00000010,
		0xE00, 0x00000007,
		0xE04, 0x00042020,
		0xE08, 0x80410231,
		0xE0C, 0x00000000,
		0xE10, 0x00000100,
		0xE14, 0x01000000,
		0xE1C, 0x40000053,
		0xE50, 0x00000020,
		0xE54, 0x00000000,
	0x8000000f,	0x55555555,	0x40000000,	0x00000000,
		0xE58, 0x3C0A0C14,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0xE58, 0x3C0A0C14,
	0xA0000000,	0x00000000,
		0xE58, 0x3C020C14,
	0xB0000000,	0x00000000,
		0xE5C, 0x0D000058,
		0xE60, 0x1B800000,
		0xE60, 0x0B800001,
		0xE60, 0x05800002,
		0xE60, 0x07800003,
		0xE60, 0x1A800004,
		0xE60, 0x0B800005,
		0xE60, 0x05800006,
		0xE60, 0x0E800007,
		0xE60, 0x1A800008,
		0xE60, 0x0B800009,
		0xE60, 0x1580000A,
		0xE60, 0x0880000B,
		0xE60, 0x1A80000C,
		0xE60, 0x0B80000D,
		0xE60, 0x0580000E,
		0xE60, 0x0E80000F,
		0xE60, 0x1A800010,
		0xE60, 0x0B800011,
		0xE60, 0x15800012,
		0xE60, 0x08800013,
		0xE60, 0x1A800014,
		0xE60, 0x0B800015,
		0xE60, 0x05800016,
		0xE60, 0x07800017,
		0xE60, 0x1A800018,
		0xE60, 0x0B800019,
		0xE60, 0x1580001A,
		0xE60, 0x0880001B,
		0xE60, 0x1B80001C,
		0xE60, 0x0B80001D,
		0xE60, 0x0580001E,
		0xE60, 0x0780001F,
		0xE60, 0x1B800020,
		0xE60, 0x0B800021,
		0xE60, 0x05800022,
		0xE60, 0x07800023,
		0xE60, 0x1B800024,
		0xE60, 0x0B800025,
		0xE60, 0x05800026,
		0xE60, 0x07800027,
		0xE60, 0x1B800028,
		0xE60, 0x0B800029,
		0xE60, 0x0580002A,
		0xE60, 0x0780002B,
		0xE60, 0x1B800030,
		0xE60, 0x0B800031,
		0xE60, 0x05800032,
		0xE60, 0x00800033,
		0xE60, 0x1B800034,
		0xE60, 0x0B800035,
		0xE60, 0x05800036,
		0xE60, 0x00800037,
		0xE60, 0x1B800038,
		0xE60, 0x0B800039,
		0xE60, 0x0580003A,
		0xE60, 0x0E80803B,
		0xE94, 0x01000401,
		0xE98, 0x00188000,
		0xEA0, 0x00002929,
		0xEA4, 0x08040201,
		0xEA8, 0x80402010,
		0xEAC, 0x77777000,
		0xEB0, 0x54775477,
		0xEB4, 0x54775477,
		0xEB8, 0x00500000,
		0xEBC, 0x77700000,
		0x1800, 0x00000007,
		0x1804, 0x00042020,
		0x1808, 0x80410231,
		0x180C, 0x00000000,
		0x1810, 0x00000100,
		0x1814, 0x01000000,
		0x181C, 0x40000053,
		0x1850, 0x00000020,
		0x1854, 0x00000000,
	0x8000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1858, 0x3C0A0C14,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1858, 0x3C0A0C14,
	0xA0000000,	0x00000000,
		0x1858, 0x3C020C14,
	0xB0000000,	0x00000000,
		0x185C, 0x0D000058,
		0x1860, 0x1B800000,
		0x1860, 0x0B800001,
		0x1860, 0x05800002,
		0x1860, 0x07800003,
		0x1860, 0x1A800004,
		0x1860, 0x0B800005,
		0x1860, 0x05800006,
		0x1860, 0x0E800007,
		0x1860, 0x1A800008,
		0x1860, 0x0B800009,
		0x1860, 0x1580000A,
		0x1860, 0x0880000B,
		0x1860, 0x1A80000C,
		0x1860, 0x0B80000D,
		0x1860, 0x0580000E,
		0x1860, 0x0E80000F,
		0x1860, 0x1A800010,
		0x1860, 0x0B800011,
		0x1860, 0x15800012,
		0x1860, 0x08800013,
		0x1860, 0x1A800014,
		0x1860, 0x0B800015,
		0x1860, 0x05800016,
		0x1860, 0x07800017,
		0x1860, 0x1A800018,
		0x1860, 0x0B800019,
		0x1860, 0x1580001A,
		0x1860, 0x0880001B,
		0x1860, 0x1B80001C,
		0x1860, 0x0B80001D,
		0x1860, 0x0580001E,
		0x1860, 0x0780001F,
		0x1860, 0x1B800020,
		0x1860, 0x0B800021,
		0x1860, 0x05800022,
		0x1860, 0x07800023,
		0x1860, 0x1B800024,
		0x1860, 0x0B800025,
		0x1860, 0x05800026,
		0x1860, 0x07800027,
		0x1860, 0x1B800028,
		0x1860, 0x0B800029,
		0x1860, 0x0580002A,
		0x1860, 0x0780002B,
		0x1860, 0x1B800030,
		0x1860, 0x0B800031,
		0x1860, 0x05800032,
		0x1860, 0x00800033,
		0x1860, 0x1B800034,
		0x1860, 0x0B800035,
		0x1860, 0x05800036,
		0x1860, 0x00800037,
		0x1860, 0x1B800038,
		0x1860, 0x0B800039,
		0x1860, 0x0580003A,
		0x1860, 0x0E80803B,
		0x1894, 0x01000401,
		0x1898, 0x00188000,
		0x18A0, 0x00002929,
		0x18A4, 0x08040201,
		0x18A8, 0x80402010,
		0x18AC, 0x77777000,
		0x18B0, 0x54775477,
		0x18B4, 0x54775477,
		0x18B8, 0x00500000,
		0x18BC, 0x77700000,
		0x1A00, 0x00000007,
		0x1A04, 0x00042020,
		0x1A08, 0x80410231,
		0x1A0C, 0x00000000,
		0x1A10, 0x00000100,
		0x1A14, 0x01000000,
		0x1A1C, 0x40000053,
		0x1A50, 0x00000020,
		0x1A54, 0x00000000,
	0x8000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1A58, 0x3C0A0C14,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1A58, 0x3C0A0C14,
	0xA0000000,	0x00000000,
		0x1A58, 0x3C020C14,
	0xB0000000,	0x00000000,
		0x1A5C, 0x0D000058,
		0x1A60, 0x1B800000,
		0x1A60, 0x0B800001,
		0x1A60, 0x05800002,
		0x1A60, 0x07800003,
		0x1A60, 0x1A800004,
		0x1A60, 0x0B800005,
		0x1A60, 0x05800006,
		0x1A60, 0x0E800007,
		0x1A60, 0x1A800008,
		0x1A60, 0x0B800009,
		0x1A60, 0x1580000A,
		0x1A60, 0x0880000B,
		0x1A60, 0x1A80000C,
		0x1A60, 0x0B80000D,
		0x1A60, 0x0580000E,
		0x1A60, 0x0E80000F,
		0x1A60, 0x1A800010,
		0x1A60, 0x0B800011,
		0x1A60, 0x15800012,
		0x1A60, 0x08800013,
		0x1A60, 0x1A800014,
		0x1A60, 0x0B800015,
		0x1A60, 0x05800016,
		0x1A60, 0x07800017,
		0x1A60, 0x1A800018,
		0x1A60, 0x0B800019,
		0x1A60, 0x1580001A,
		0x1A60, 0x0880001B,
		0x1A60, 0x1B80001C,
		0x1A60, 0x0B80001D,
		0x1A60, 0x0580001E,
		0x1A60, 0x0780001F,
		0x1A60, 0x1B800020,
		0x1A60, 0x0B800021,
		0x1A60, 0x05800022,
		0x1A60, 0x07800023,
		0x1A60, 0x1B800024,
		0x1A60, 0x0B800025,
		0x1A60, 0x05800026,
		0x1A60, 0x07800027,
		0x1A60, 0x1B800028,
		0x1A60, 0x0B800029,
		0x1A60, 0x0580002A,
		0x1A60, 0x0780002B,
		0x1A60, 0x1B800030,
		0x1A60, 0x0B800031,
		0x1A60, 0x05800032,
		0x1A60, 0x00800033,
		0x1A60, 0x1B800034,
		0x1A60, 0x0B800035,
		0x1A60, 0x05800036,
		0x1A60, 0x00800037,
		0x1A60, 0x1B800038,
		0x1A60, 0x0B800039,
		0x1A60, 0x0580003A,
		0x1A60, 0x0E80803B,
		0x1A94, 0x01000401,
		0x1A98, 0x00188000,
		0x1AA0, 0x00002929,
		0x1AA4, 0x08040201,
		0x1AA8, 0x80402010,
		0x1AAC, 0x77777000,
		0x1AB0, 0x54775477,
		0x1AB4, 0x54775477,
		0x1AB8, 0x00500000,
		0x1ABC, 0x77700000,
		0x1904, 0x00030000,
		0x1914, 0x00030000,
		0x1984, 0x03000000,
		0x1988, 0x00000087,
		0x198C, 0x00000007,
		0x1990, 0xFFAA5500,
		0x1994, 0x00000077,
		0x1998, 0x12801000,
		0x1998, 0x12801000,
		0x1998, 0x12801001,
		0x1998, 0x12801002,
		0x1998, 0x12801003,
		0x1998, 0x12801004,
		0x1998, 0x12801005,
		0x1998, 0x12801006,
		0x1998, 0x12801007,
		0x1998, 0x12801008,
		0x1998, 0x12801009,
		0x1998, 0x1280100A,
		0x1998, 0x1280100B,
		0x1998, 0x1280100C,
		0x1998, 0x1280100D,
		0x1998, 0x1280100E,
		0x1998, 0x1280100F,
		0x1998, 0x12801010,
		0x1998, 0x12801011,
		0x1998, 0x12801012,
		0x1998, 0x12801013,
		0x1998, 0x12801014,
		0x1998, 0x12801015,
		0x1998, 0x12801016,
		0x1998, 0x12801017,
		0x1998, 0x12801018,
		0x1998, 0x12801019,
		0x1998, 0x1280101A,
		0x1998, 0x1280101B,
		0x1998, 0x1280101C,
		0x1998, 0x1280101D,
		0x1998, 0x1280101E,
		0x1998, 0x1280101F,
		0x1998, 0x12801020,
		0x1998, 0x12801021,
		0x1998, 0x12801022,
		0x1998, 0x12801023,
		0x1998, 0x1280102C,
		0x1998, 0x1280102D,
		0x1998, 0x1280102E,
		0x1998, 0x1280102F,
		0x1998, 0x12801030,
		0x1998, 0x12801031,
		0x1998, 0x12801032,
		0x1998, 0x12801033,
		0x1998, 0x12801034,
		0x1998, 0x12801035,
		0x1998, 0x12801036,
		0x1998, 0x12801037,
		0x1998, 0x12801038,
		0x1998, 0x12801039,
		0x1998, 0x1280103A,
		0x1998, 0x1280103B,
		0x1998, 0x1280103C,
		0x1998, 0x1280103D,
		0x1998, 0x1280103E,
		0x1998, 0x1280103F,
		0x1998, 0x12801040,
		0x1998, 0x12801041,
		0x1998, 0x12801042,
		0x1998, 0x12801043,
		0x1998, 0x12801044,
		0x1998, 0x12801045,
		0x1998, 0x12801046,
		0x1998, 0x12801047,
		0x1998, 0x12801048,
		0x1998, 0x12801049,
		0x1998, 0x12801100,
		0x1998, 0x12801101,
		0x1998, 0x12801102,
		0x1998, 0x12801103,
		0x1998, 0x12801104,
		0x1998, 0x12801105,
		0x1998, 0x12801106,
		0x1998, 0x12801107,
		0x1998, 0x12801108,
		0x1998, 0x12801109,
		0x1998, 0x1280110A,
		0x1998, 0x1280110B,
		0x1998, 0x1280110C,
		0x1998, 0x1280110D,
		0x1998, 0x1280110E,
		0x1998, 0x1280110F,
		0x1998, 0x12801110,
		0x1998, 0x12801111,
		0x1998, 0x12801112,
		0x1998, 0x12801113,
		0x1998, 0x12801114,
		0x1998, 0x12801115,
		0x1998, 0x12801116,
		0x1998, 0x12801117,
		0x1998, 0x12801118,
		0x1998, 0x12801119,
		0x1998, 0x1280111A,
		0x1998, 0x1280111B,
		0x1998, 0x1280111C,
		0x1998, 0x1280111D,
		0x1998, 0x1280111E,
		0x1998, 0x1280111F,
		0x1998, 0x12801120,
		0x1998, 0x12801121,
		0x1998, 0x12801122,
		0x1998, 0x12801123,
		0x1998, 0x1280112C,
		0x1998, 0x1280112D,
		0x1998, 0x1280112E,
		0x1998, 0x1280112F,
		0x1998, 0x12801130,
		0x1998, 0x12801131,
		0x1998, 0x12801132,
		0x1998, 0x12801133,
		0x1998, 0x12801134,
		0x1998, 0x12801135,
		0x1998, 0x12801136,
		0x1998, 0x12801137,
		0x1998, 0x12801138,
		0x1998, 0x12801139,
		0x1998, 0x1280113A,
		0x1998, 0x1280113B,
		0x1998, 0x1280113C,
		0x1998, 0x1280113D,
		0x1998, 0x1280113E,
		0x1998, 0x1280113F,
		0x1998, 0x12801140,
		0x1998, 0x12801141,
		0x1998, 0x12801142,
		0x1998, 0x12801143,
		0x1998, 0x12801144,
		0x1998, 0x12801145,
		0x1998, 0x12801146,
		0x1998, 0x12801147,
		0x1998, 0x12801148,
		0x1998, 0x12801149,
		0x1998, 0x12801200,
		0x1998, 0x12801201,
		0x1998, 0x12801202,
		0x1998, 0x12801203,
		0x1998, 0x12801204,
		0x1998, 0x12801205,
		0x1998, 0x12801206,
		0x1998, 0x12801207,
		0x1998, 0x12801208,
		0x1998, 0x12801209,
		0x1998, 0x1280120A,
		0x1998, 0x1280120B,
		0x1998, 0x1280120C,
		0x1998, 0x1280120D,
		0x1998, 0x1280120E,
		0x1998, 0x1280120F,
		0x1998, 0x12801210,
		0x1998, 0x12801211,
		0x1998, 0x12801212,
		0x1998, 0x12801213,
		0x1998, 0x12801214,
		0x1998, 0x12801215,
		0x1998, 0x12801216,
		0x1998, 0x12801217,
		0x1998, 0x12801218,
		0x1998, 0x12801219,
		0x1998, 0x1280121A,
		0x1998, 0x1280121B,
		0x1998, 0x1280121C,
		0x1998, 0x1280121D,
		0x1998, 0x1280121E,
		0x1998, 0x1280121F,
		0x1998, 0x12801220,
		0x1998, 0x12801221,
		0x1998, 0x12801222,
		0x1998, 0x12801223,
		0x1998, 0x1280122C,
		0x1998, 0x1280122D,
		0x1998, 0x1280122E,
		0x1998, 0x1280122F,
		0x1998, 0x12801230,
		0x1998, 0x12801231,
		0x1998, 0x12801232,
		0x1998, 0x12801233,
		0x1998, 0x12801234,
		0x1998, 0x12801235,
		0x1998, 0x12801236,
		0x1998, 0x12801237,
		0x1998, 0x12801238,
		0x1998, 0x12801239,
		0x1998, 0x1280123A,
		0x1998, 0x1280123B,
		0x1998, 0x1280123C,
		0x1998, 0x1280123D,
		0x1998, 0x1280123E,
		0x1998, 0x1280123F,
		0x1998, 0x12801240,
		0x1998, 0x12801241,
		0x1998, 0x12801242,
		0x1998, 0x12801243,
		0x1998, 0x12801244,
		0x1998, 0x12801245,
		0x1998, 0x12801246,
		0x1998, 0x12801247,
		0x1998, 0x12801248,
		0x1998, 0x12801249,
		0x1998, 0x12801300,
		0x1998, 0x12801301,
		0x1998, 0x12801302,
		0x1998, 0x12801303,
		0x1998, 0x12801304,
		0x1998, 0x12801305,
		0x1998, 0x12801306,
		0x1998, 0x12801307,
		0x1998, 0x12801308,
		0x1998, 0x12801309,
		0x1998, 0x1280130A,
		0x1998, 0x1280130B,
		0x1998, 0x1280130C,
		0x1998, 0x1280130D,
		0x1998, 0x1280130E,
		0x1998, 0x1280130F,
		0x1998, 0x12801310,
		0x1998, 0x12801311,
		0x1998, 0x12801312,
		0x1998, 0x12801313,
		0x1998, 0x12801314,
		0x1998, 0x12801315,
		0x1998, 0x12801316,
		0x1998, 0x12801317,
		0x1998, 0x12801318,
		0x1998, 0x12801319,
		0x1998, 0x1280131A,
		0x1998, 0x1280131B,
		0x1998, 0x1280131C,
		0x1998, 0x1280131D,
		0x1998, 0x1280131E,
		0x1998, 0x1280131F,
		0x1998, 0x12801320,
		0x1998, 0x12801321,
		0x1998, 0x12801322,
		0x1998, 0x12801323,
		0x1998, 0x1280132C,
		0x1998, 0x1280132D,
		0x1998, 0x1280132E,
		0x1998, 0x1280132F,
		0x1998, 0x12801330,
		0x1998, 0x12801331,
		0x1998, 0x12801332,
		0x1998, 0x12801333,
		0x1998, 0x12801334,
		0x1998, 0x12801335,
		0x1998, 0x12801336,
		0x1998, 0x12801337,
		0x1998, 0x12801338,
		0x1998, 0x12801339,
		0x1998, 0x1280133A,
		0x1998, 0x1280133B,
		0x1998, 0x1280133C,
		0x1998, 0x1280133D,
		0x1998, 0x1280133E,
		0x1998, 0x1280133F,
		0x1998, 0x12801340,
		0x1998, 0x12801341,
		0x1998, 0x12801342,
		0x1998, 0x12801343,
		0x1998, 0x12801344,
		0x1998, 0x12801345,
		0x1998, 0x12801346,
		0x1998, 0x12801347,
		0x1998, 0x12801348,
		0x1998, 0x12801349,
		0x19D4, 0x88888888,
		0x19D8, 0x00000888,
		0xB00, 0xE3100100,
		0xB00, 0xE7100100,
		0xC60, 0x15808002,
		0xC60, 0x01808003,
		0xE60, 0x15808002,
		0xE60, 0x01808003,
		0x1860, 0x15808002,
		0x1860, 0x01808003,
		0x1A60, 0x15808002,
		0x1A60, 0x01808003,
		0xB00, 0xE3100100,
		0xC5C, 0x0D080058,
		0xE5C, 0x0D080058,
		0x185C, 0x0D080058,
		0x1A5C, 0x0D080058,
		0xC5C, 0x0D000058,
		0xE5C, 0x0D000058,
		0x185C, 0x0D000058,
		0x1A5C, 0x0D000058,
		0xC60, 0x05808002,
		0xC60, 0x0E808003,
		0xE60, 0x05808002,
		0xE60, 0x0E808003,
		0x1860, 0x05808002,
		0x1860, 0x0E808003,
		0x1A60, 0x05808002,
		0x1A60, 0x0E808003,
		0xB00, 0xE7100100,
		0xB00, 0xE3100100,
		0xB00, 0xE3100000,
		0x1C38, 0x00000002,
		0xA00, 0x00D047C8,
		0xA04, 0x46FF800C,
		0xA08, 0x8C838300,
		0xA0C, 0x2E7E000F,
		0xA10, 0x9500BB78,
		0xA14, 0x11144028,
		0xA18, 0x00881117,
		0xA1C, 0x89140F00,
		0xA20, 0x1A1B0030,
		0xA24, 0x090E1317,
		0xA28, 0x00000204,
		0xA2C, 0x00900000,
		0xA70, 0x101FFF00,
		0xA74, 0x00000128,
		0xA78, 0x00000900,
		0xA7C, 0x225B0606,
		0xA80, 0x218075B2,
		0xA84, 0x9C1F8C00,
		0x1B04, 0xE24628D2,
		0x1B10, 0x88010D46,
		0x1B14, 0x00000000,
		0x1B18, 0x00292903,
		0x1B00, 0xF8000000,
		0x1B00, 0xF800D000,
		0x1B00, 0xF801F000,
		0x1B1C, 0xA2123DB2,
		0x1B20, 0x07040001,
		0x1B24, 0x07060807,
	0x8000000c,	0x00000000,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B28, 0xC0060324,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0xA0000000,	0x00000000,
		0x1B28, 0xC0060348,
	0xB0000000,	0x00000000,
		0x1B2C, 0x20000003,
		0x1B30, 0x20000000,
		0x1B38, 0x20000000,
		0x1B3C, 0x20000000,
		0x1BD4, 0x00000001,
		0x1B94, 0x80000000,
		0x1B34, 0x00000000,
		0x1B34, 0x00000002,
		0x1B34, 0x00000000,
		0x1B00, 0xF8000002,
		0x1B00, 0xF800D002,
		0x1B00, 0xF801F002,
		0x1B1C, 0xA2123DB2,
		0x1B20, 0x07040001,
		0x1B24, 0x07060807,
	0x8000000c,	0x00000000,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B28, 0xC0060324,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0xA0000000,	0x00000000,
		0x1B28, 0xC0060348,
	0xB0000000,	0x00000000,
		0x1B2C, 0x20000003,
		0x1B30, 0x20000000,
		0x1B38, 0x20000000,
		0x1B3C, 0x20000000,
		0x1BD4, 0x00000001,
		0x1B94, 0x80000000,
		0x1B34, 0x00000000,
		0x1B34, 0x00000002,
		0x1B34, 0x00000000,
		0x1B00, 0xF8000004,
		0x1B00, 0xF800D004,
		0x1B00, 0xF801F004,
		0x1B1C, 0xA2123DB2,
		0x1B20, 0x07040001,
		0x1B24, 0x07060807,
	0x8000000c,	0x00000000,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B28, 0xC0060324,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0xA0000000,	0x00000000,
		0x1B28, 0xC0060348,
	0xB0000000,	0x00000000,
		0x1B2C, 0x20000003,
		0x1B30, 0x20000000,
		0x1B38, 0x20000000,
		0x1B3C, 0x20000000,
		0x1BD4, 0x00000001,
		0x1B94, 0x80000000,
		0x1B34, 0x00000000,
		0x1B34, 0x00000002,
		0x1B34, 0x00000000,
		0x1B00, 0xF8000006,
		0x1B00, 0xF800D006,
		0x1B00, 0xF801F006,
		0x1B1C, 0xA2123DB2,
		0x1B20, 0x07040001,
		0x1B24, 0x07060807,
	0x8000000c,	0x00000000,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B28, 0xC0060324,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x1B28, 0xC0060324,
	0xA0000000,	0x00000000,
		0x1B28, 0xC0060348,
	0xB0000000,	0x00000000,
		0x1B2C, 0x20000003,
		0x1B30, 0x20000000,
		0x1B38, 0x20000000,
		0x1B3C, 0x20000000,
		0x1BD4, 0x00000001,
		0x1B94, 0x80000000,
		0x1B34, 0x00000000,
		0x1B34, 0x00000002,
		0x1B34, 0x00000000,
		0x1B00, 0xF8000000,
		0x1B80, 0x00000007,
		0x1B80, 0x09060005,
		0x1B80, 0x09060007,
		0x1B80, 0x0FFE0015,
		0x1B80, 0x0FFE0017,
		0x1B80, 0x00240025,
		0x1B80, 0x00240027,
		0x1B80, 0x00040035,
		0x1B80, 0x00040037,
		0x1B80, 0x05C00045,
		0x1B80, 0x05C00047,
		0x1B80, 0x00070055,
		0x1B80, 0x00070057,
		0x1B80, 0x64000065,
		0x1B80, 0x64000067,
		0x1B80, 0x00020075,
		0x1B80, 0x00020077,
		0x1B80, 0x00080085,
		0x1B80, 0x00080087,
		0x1B80, 0x80000095,
		0x1B80, 0x80000097,
		0x1B80, 0x090100A5,
		0x1B80, 0x090100A7,
		0x1B80, 0x0F0200B5,
		0x1B80, 0x0F0200B7,
		0x1B80, 0x002400C5,
		0x1B80, 0x002400C7,
		0x1B80, 0x000400D5,
		0x1B80, 0x000400D7,
		0x1B80, 0x05C000E5,
		0x1B80, 0x05C000E7,
		0x1B80, 0x000700F5,
		0x1B80, 0x000700F7,
		0x1B80, 0x64020105,
		0x1B80, 0x64020107,
		0x1B80, 0x00020115,
		0x1B80, 0x00020117,
		0x1B80, 0x00040125,
		0x1B80, 0x00040127,
		0x1B80, 0x4A000135,
		0x1B80, 0x4A000137,
		0x1B80, 0x4B040145,
		0x1B80, 0x4B040147,
		0x1B80, 0x85030155,
		0x1B80, 0x85030157,
		0x1B80, 0x40010165,
		0x1B80, 0x40010167,
		0x1B80, 0xE0290175,
		0x1B80, 0xE0290177,
		0x1B80, 0x00040185,
		0x1B80, 0x00040187,
		0x1B80, 0x4B050195,
		0x1B80, 0x4B050197,
		0x1B80, 0x860301A5,
		0x1B80, 0x860301A7,
		0x1B80, 0x400301B5,
		0x1B80, 0x400301B7,
		0x1B80, 0xE02901C5,
		0x1B80, 0xE02901C7,
		0x1B80, 0x000401D5,
		0x1B80, 0x000401D7,
		0x1B80, 0x4B0601E5,
		0x1B80, 0x4B0601E7,
		0x1B80, 0x870301F5,
		0x1B80, 0x870301F7,
		0x1B80, 0x40050205,
		0x1B80, 0x40050207,
		0x1B80, 0xE0290215,
		0x1B80, 0xE0290217,
		0x1B80, 0x00040225,
		0x1B80, 0x00040227,
		0x1B80, 0x4B070235,
		0x1B80, 0x4B070237,
		0x1B80, 0x88030245,
		0x1B80, 0x88030247,
		0x1B80, 0x40070255,
		0x1B80, 0x40070257,
		0x1B80, 0xE0290265,
		0x1B80, 0xE0290267,
		0x1B80, 0x4B000275,
		0x1B80, 0x4B000277,
		0x1B80, 0x30000285,
		0x1B80, 0x30000287,
		0x1B80, 0xFE100295,
		0x1B80, 0xFE100297,
		0x1B80, 0xFF1002A5,
		0x1B80, 0xFF1002A7,
		0x1B80, 0xE18602B5,
		0x1B80, 0xE18602B7,
		0x1B80, 0xF00A02C5,
		0x1B80, 0xF00A02C7,
		0x1B80, 0xF10A02D5,
		0x1B80, 0xF10A02D7,
		0x1B80, 0xF20A02E5,
		0x1B80, 0xF20A02E7,
		0x1B80, 0xF30802F5,
		0x1B80, 0xF30802F7,
		0x1B80, 0xF4070305,
		0x1B80, 0xF4070307,
		0x1B80, 0xF5060315,
		0x1B80, 0xF5060317,
		0x1B80, 0xF7060325,
		0x1B80, 0xF7060327,
		0x1B80, 0xF8050335,
		0x1B80, 0xF8050337,
		0x1B80, 0xF9040345,
		0x1B80, 0xF9040347,
		0x1B80, 0x00010355,
		0x1B80, 0x00010357,
		0x1B80, 0x303B0365,
		0x1B80, 0x303B0367,
		0x1B80, 0x30500375,
		0x1B80, 0x30500377,
		0x1B80, 0x305C0385,
		0x1B80, 0x305C0387,
		0x1B80, 0x31D50395,
		0x1B80, 0x31D50397,
		0x1B80, 0x31C503A5,
		0x1B80, 0x31C503A7,
		0x1B80, 0x4D0403B5,
		0x1B80, 0x4D0403B7,
		0x1B80, 0x2EF003C5,
		0x1B80, 0x2EF003C7,
		0x1B80, 0x000203D5,
		0x1B80, 0x000203D7,
		0x1B80, 0x208003E5,
		0x1B80, 0x208003E7,
		0x1B80, 0x000003F5,
		0x1B80, 0x000003F7,
		0x1B80, 0x4D000405,
		0x1B80, 0x4D000407,
		0x1B80, 0x55070415,
		0x1B80, 0x55070417,
		0x1B80, 0xE1230425,
		0x1B80, 0xE1230427,
		0x1B80, 0xE1230435,
		0x1B80, 0xE1230437,
		0x1B80, 0x4D040445,
		0x1B80, 0x4D040447,
		0x1B80, 0x20800455,
		0x1B80, 0x20800457,
		0x1B80, 0x84000465,
		0x1B80, 0x84000467,
		0x1B80, 0x4D000475,
		0x1B80, 0x4D000477,
		0x1B80, 0x550F0485,
		0x1B80, 0x550F0487,
		0x1B80, 0xE1230495,
		0x1B80, 0xE1230497,
		0x1B80, 0x4F0204A5,
		0x1B80, 0x4F0204A7,
		0x1B80, 0x4E0004B5,
		0x1B80, 0x4E0004B7,
		0x1B80, 0x530204C5,
		0x1B80, 0x530204C7,
		0x1B80, 0x520104D5,
		0x1B80, 0x520104D7,
		0x1B80, 0xE12704E5,
		0x1B80, 0xE12704E7,
		0x1B80, 0x000104F5,
		0x1B80, 0x000104F7,
		0x1B80, 0x5C720505,
		0x1B80, 0x5C720507,
		0x1B80, 0xE1320515,
		0x1B80, 0xE1320517,
		0x1B80, 0x54E50525,
		0x1B80, 0x54E50527,
		0x1B80, 0x54BF0535,
		0x1B80, 0x54BF0537,
		0x1B80, 0x54C50545,
		0x1B80, 0x54C50547,
		0x1B80, 0x54BE0555,
		0x1B80, 0x54BE0557,
		0x1B80, 0x54DF0565,
		0x1B80, 0x54DF0567,
		0x1B80, 0x0BA60575,
		0x1B80, 0x0BA60577,
		0x1B80, 0xF3130585,
		0x1B80, 0xF3130587,
		0x1B80, 0xF41E0595,
		0x1B80, 0xF41E0597,
		0x1B80, 0xF53C05A5,
		0x1B80, 0xF53C05A7,
		0x1B80, 0x000105B5,
		0x1B80, 0x000105B7,
		0x1B80, 0x620605C5,
		0x1B80, 0x620605C7,
		0x1B80, 0x600605D5,
		0x1B80, 0x600605D7,
		0x1B80, 0xE1A905E5,
		0x1B80, 0xE1A905E7,
		0x1B80, 0x0C0005F5,
		0x1B80, 0x0C0005F7,
		0x1B80, 0x5C720605,
		0x1B80, 0x5C720607,
		0x1B80, 0xE1320615,
		0x1B80, 0xE1320617,
		0x1B80, 0x5CF10625,
		0x1B80, 0x5CF10627,
		0x1B80, 0x0C010635,
		0x1B80, 0x0C010637,
		0x1B80, 0xF2020645,
		0x1B80, 0xF2020647,
		0x1B80, 0x30D60655,
		0x1B80, 0x30D60657,
		0x1B80, 0x0AC60665,
		0x1B80, 0x0AC60667,
		0x1B80, 0xE1B60675,
		0x1B80, 0xE1B60677,
		0x1B80, 0xE1580685,
		0x1B80, 0xE1580687,
		0x1B80, 0x54E50695,
		0x1B80, 0x54E50697,
		0x1B80, 0x000106A5,
		0x1B80, 0x000106A7,
		0x1B80, 0x560106B5,
		0x1B80, 0x560106B7,
		0x1B80, 0x5CE206C5,
		0x1B80, 0x5CE206C7,
		0x1B80, 0x0AE106D5,
		0x1B80, 0x0AE106D7,
		0x1B80, 0x630C06E5,
		0x1B80, 0x630C06E7,
		0x1B80, 0xE13F06F5,
		0x1B80, 0xE13F06F7,
		0x1B80, 0x00270705,
		0x1B80, 0x00270707,
		0x1B80, 0xE16C0715,
		0x1B80, 0xE16C0717,
		0x1B80, 0x00020725,
		0x1B80, 0x00020727,
		0x1B80, 0x002A0735,
		0x1B80, 0x002A0737,
		0x1B80, 0x07140745,
		0x1B80, 0x07140747,
		0x1B80, 0x00020755,
		0x1B80, 0x00020757,
		0x1B80, 0x30C30765,
		0x1B80, 0x30C30767,
		0x1B80, 0x56010775,
		0x1B80, 0x56010777,
		0x1B80, 0x5CE20785,
		0x1B80, 0x5CE20787,
		0x1B80, 0x0AE10795,
		0x1B80, 0x0AE10797,
		0x1B80, 0x631707A5,
		0x1B80, 0x631707A7,
		0x1B80, 0xE13F07B5,
		0x1B80, 0xE13F07B7,
		0x1B80, 0x002507C5,
		0x1B80, 0x002507C7,
		0x1B80, 0xE16C07D5,
		0x1B80, 0xE16C07D7,
		0x1B80, 0x000207E5,
		0x1B80, 0x000207E7,
		0x1B80, 0x630F07F5,
		0x1B80, 0x630F07F7,
		0x1B80, 0xE13F0805,
		0x1B80, 0xE13F0807,
		0x1B80, 0x63070815,
		0x1B80, 0x63070817,
		0x1B80, 0xE13F0825,
		0x1B80, 0xE13F0827,
		0x1B80, 0x07140835,
		0x1B80, 0x07140837,
		0x1B80, 0x56000845,
		0x1B80, 0x56000847,
		0x1B80, 0x5CF20855,
		0x1B80, 0x5CF20857,
		0x1B80, 0x0AF10865,
		0x1B80, 0x0AF10867,
		0x1B80, 0x07140875,
		0x1B80, 0x07140877,
		0x1B80, 0x07140885,
		0x1B80, 0x07140887,
		0x1B80, 0x630F0895,
		0x1B80, 0x630F0897,
		0x1B80, 0xE13F08A5,
		0x1B80, 0xE13F08A7,
		0x1B80, 0x631708B5,
		0x1B80, 0x631708B7,
		0x1B80, 0xE13F08C5,
		0x1B80, 0xE13F08C7,
		0x1B80, 0x002508D5,
		0x1B80, 0x002508D7,
		0x1B80, 0xE16C08E5,
		0x1B80, 0xE16C08E7,
		0x1B80, 0x000208F5,
		0x1B80, 0x000208F7,
		0x1B80, 0x30C30905,
		0x1B80, 0x30C30907,
		0x1B80, 0xE1A90915,
		0x1B80, 0xE1A90917,
		0x1B80, 0x62060925,
		0x1B80, 0x62060927,
		0x1B80, 0x60060935,
		0x1B80, 0x60060937,
		0x1B80, 0xE1160945,
		0x1B80, 0xE1160947,
		0x1B80, 0x54BE0955,
		0x1B80, 0x54BE0957,
		0x1B80, 0x56010965,
		0x1B80, 0x56010967,
		0x1B80, 0x5CE20975,
		0x1B80, 0x5CE20977,
		0x1B80, 0x0AE10985,
		0x1B80, 0x0AE10987,
		0x1B80, 0x633A0995,
		0x1B80, 0x633A0997,
		0x1B80, 0xE13F09A5,
		0x1B80, 0xE13F09A7,
		0x1B80, 0x633709B5,
		0x1B80, 0x633709B7,
		0x1B80, 0xE13F09C5,
		0x1B80, 0xE13F09C7,
		0x1B80, 0x632F09D5,
		0x1B80, 0x632F09D7,
		0x1B80, 0xE13F09E5,
		0x1B80, 0xE13F09E7,
		0x1B80, 0x632709F5,
		0x1B80, 0x632709F7,
		0x1B80, 0xE13F0A05,
		0x1B80, 0xE13F0A07,
		0x1B80, 0x631F0A15,
		0x1B80, 0x631F0A17,
		0x1B80, 0xE13F0A25,
		0x1B80, 0xE13F0A27,
		0x1B80, 0x63170A35,
		0x1B80, 0x63170A37,
		0x1B80, 0xE13F0A45,
		0x1B80, 0xE13F0A47,
		0x1B80, 0x630F0A55,
		0x1B80, 0x630F0A57,
		0x1B80, 0xE13F0A65,
		0x1B80, 0xE13F0A67,
		0x1B80, 0x63070A75,
		0x1B80, 0x63070A77,
		0x1B80, 0xE13F0A85,
		0x1B80, 0xE13F0A87,
		0x1B80, 0xE16C0A95,
		0x1B80, 0xE16C0A97,
		0x1B80, 0x56000AA5,
		0x1B80, 0x56000AA7,
		0x1B80, 0x5CF20AB5,
		0x1B80, 0x5CF20AB7,
		0x1B80, 0x0AF10AC5,
		0x1B80, 0x0AF10AC7,
		0x1B80, 0xF5040AD5,
		0x1B80, 0xF5040AD7,
		0x1B80, 0xE13F0AE5,
		0x1B80, 0xE13F0AE7,
		0x1B80, 0xE16C0AF5,
		0x1B80, 0xE16C0AF7,
		0x1B80, 0x30B30B05,
		0x1B80, 0x30B30B07,
		0x1B80, 0x07140B15,
		0x1B80, 0x07140B17,
		0x1B80, 0x07140B25,
		0x1B80, 0x07140B27,
		0x1B80, 0x630F0B35,
		0x1B80, 0x630F0B37,
		0x1B80, 0xE13F0B45,
		0x1B80, 0xE13F0B47,
		0x1B80, 0x63170B55,
		0x1B80, 0x63170B57,
		0x1B80, 0xE13F0B65,
		0x1B80, 0xE13F0B67,
		0x1B80, 0x631F0B75,
		0x1B80, 0x631F0B77,
		0x1B80, 0xE13F0B85,
		0x1B80, 0xE13F0B87,
		0x1B80, 0x63270B95,
		0x1B80, 0x63270B97,
		0x1B80, 0xE13F0BA5,
		0x1B80, 0xE13F0BA7,
		0x1B80, 0x632F0BB5,
		0x1B80, 0x632F0BB7,
		0x1B80, 0xE13F0BC5,
		0x1B80, 0xE13F0BC7,
		0x1B80, 0x63370BD5,
		0x1B80, 0x63370BD7,
		0x1B80, 0xE13F0BE5,
		0x1B80, 0xE13F0BE7,
		0x1B80, 0x633A0BF5,
		0x1B80, 0x633A0BF7,
		0x1B80, 0xE13F0C05,
		0x1B80, 0xE13F0C07,
		0x1B80, 0xF60B0C15,
		0x1B80, 0xF60B0C17,
		0x1B80, 0xF7170C25,
		0x1B80, 0xF7170C27,
		0x1B80, 0x4D300C35,
		0x1B80, 0x4D300C37,
		0x1B80, 0x57040C45,
		0x1B80, 0x57040C47,
		0x1B80, 0x57000C55,
		0x1B80, 0x57000C57,
		0x1B80, 0x96000C65,
		0x1B80, 0x96000C67,
		0x1B80, 0x57080C75,
		0x1B80, 0x57080C77,
		0x1B80, 0x57000C85,
		0x1B80, 0x57000C87,
		0x1B80, 0x95000C95,
		0x1B80, 0x95000C97,
		0x1B80, 0x4D000CA5,
		0x1B80, 0x4D000CA7,
		0x1B80, 0x6C070CB5,
		0x1B80, 0x6C070CB7,
		0x1B80, 0x00010CC5,
		0x1B80, 0x00010CC7,
		0x1B80, 0x00220CD5,
		0x1B80, 0x00220CD7,
		0x1B80, 0x06140CE5,
		0x1B80, 0x06140CE7,
		0x1B80, 0xE16C0CF5,
		0x1B80, 0xE16C0CF7,
		0x1B80, 0x00020D05,
		0x1B80, 0x00020D07,
		0x1B80, 0x00250D15,
		0x1B80, 0x00250D17,
		0x1B80, 0x06140D25,
		0x1B80, 0x06140D27,
		0x1B80, 0xE16C0D35,
		0x1B80, 0xE16C0D37,
		0x1B80, 0x00020D45,
		0x1B80, 0x00020D47,
		0x1B80, 0x00010D55,
		0x1B80, 0x00010D57,
		0x1B80, 0x00320D65,
		0x1B80, 0x00320D67,
		0x1B80, 0xE16C0D75,
		0x1B80, 0xE16C0D77,
		0x1B80, 0x00020D85,
		0x1B80, 0x00020D87,
		0x1B80, 0xE1860D95,
		0x1B80, 0xE1860D97,
		0x1B80, 0xE1B60DA5,
		0x1B80, 0xE1B60DA7,
		0x1B80, 0x5CD10DB5,
		0x1B80, 0x5CD10DB7,
		0x1B80, 0x673A0DC5,
		0x1B80, 0x673A0DC7,
		0x1B80, 0xE1230DD5,
		0x1B80, 0xE1230DD7,
		0x1B80, 0xF80B0DE5,
		0x1B80, 0xF80B0DE7,
		0x1B80, 0xF9110DF5,
		0x1B80, 0xF9110DF7,
		0x1B80, 0xE1580E05,
		0x1B80, 0xE1580E07,
		0x1B80, 0x67370E15,
		0x1B80, 0x67370E17,
		0x1B80, 0xE1580E25,
		0x1B80, 0xE1580E27,
		0x1B80, 0x672F0E35,
		0x1B80, 0x672F0E37,
		0x1B80, 0xE1580E45,
		0x1B80, 0xE1580E47,
		0x1B80, 0x67270E55,
		0x1B80, 0x67270E57,
		0x1B80, 0xE1580E65,
		0x1B80, 0xE1580E67,
		0x1B80, 0x671F0E75,
		0x1B80, 0x671F0E77,
		0x1B80, 0xE1580E85,
		0x1B80, 0xE1580E87,
		0x1B80, 0x67170E95,
		0x1B80, 0x67170E97,
		0x1B80, 0xE1580EA5,
		0x1B80, 0xE1580EA7,
		0x1B80, 0xF8020EB5,
		0x1B80, 0xF8020EB7,
		0x1B80, 0x30EE0EC5,
		0x1B80, 0x30EE0EC7,
		0x1B80, 0xE0D10ED5,
		0x1B80, 0xE0D10ED7,
		0x1B80, 0x670F0EE5,
		0x1B80, 0x670F0EE7,
		0x1B80, 0xE1580EF5,
		0x1B80, 0xE1580EF7,
		0x1B80, 0x67070F05,
		0x1B80, 0x67070F07,
		0x1B80, 0xE1580F15,
		0x1B80, 0xE1580F17,
		0x1B80, 0xF9020F25,
		0x1B80, 0xF9020F27,
		0x1B80, 0x30F50F35,
		0x1B80, 0x30F50F37,
		0x1B80, 0xE0CD0F45,
		0x1B80, 0xE0CD0F47,
		0x1B80, 0x06140F55,
		0x1B80, 0x06140F57,
		0x1B80, 0xE16C0F65,
		0x1B80, 0xE16C0F67,
		0x1B80, 0x5CF10F75,
		0x1B80, 0x5CF10F77,
		0x1B80, 0xE1580F85,
		0x1B80, 0xE1580F87,
		0x1B80, 0x06140F95,
		0x1B80, 0x06140F97,
		0x1B80, 0xE16C0FA5,
		0x1B80, 0xE16C0FA7,
		0x1B80, 0xF9020FB5,
		0x1B80, 0xF9020FB7,
		0x1B80, 0x30FF0FC5,
		0x1B80, 0x30FF0FC7,
		0x1B80, 0xE0CD0FD5,
		0x1B80, 0xE0CD0FD7,
		0x1B80, 0x31130FE5,
		0x1B80, 0x31130FE7,
		0x1B80, 0x670F0FF5,
		0x1B80, 0x670F0FF7,
		0x1B80, 0xE1581005,
		0x1B80, 0xE1581007,
		0x1B80, 0x67171015,
		0x1B80, 0x67171017,
		0x1B80, 0xE1581025,
		0x1B80, 0xE1581027,
		0x1B80, 0xF8021035,
		0x1B80, 0xF8021037,
		0x1B80, 0x31071045,
		0x1B80, 0x31071047,
		0x1B80, 0xE0D11055,
		0x1B80, 0xE0D11057,
		0x1B80, 0x31131065,
		0x1B80, 0x31131067,
		0x1B80, 0x670F1075,
		0x1B80, 0x670F1077,
		0x1B80, 0xE1581085,
		0x1B80, 0xE1581087,
		0x1B80, 0x671F1095,
		0x1B80, 0x671F1097,
		0x1B80, 0xE15810A5,
		0x1B80, 0xE15810A7,
		0x1B80, 0x672710B5,
		0x1B80, 0x672710B7,
		0x1B80, 0xE15810C5,
		0x1B80, 0xE15810C7,
		0x1B80, 0x672F10D5,
		0x1B80, 0x672F10D7,
		0x1B80, 0xE15810E5,
		0x1B80, 0xE15810E7,
		0x1B80, 0x673710F5,
		0x1B80, 0x673710F7,
		0x1B80, 0xE1581105,
		0x1B80, 0xE1581107,
		0x1B80, 0x673A1115,
		0x1B80, 0x673A1117,
		0x1B80, 0xE1581125,
		0x1B80, 0xE1581127,
		0x1B80, 0x4D101135,
		0x1B80, 0x4D101137,
		0x1B80, 0x30C41145,
		0x1B80, 0x30C41147,
		0x1B80, 0x00011155,
		0x1B80, 0x00011157,
		0x1B80, 0x6F241165,
		0x1B80, 0x6F241167,
		0x1B80, 0x6E401175,
		0x1B80, 0x6E401177,
		0x1B80, 0x6D001185,
		0x1B80, 0x6D001187,
		0x1B80, 0x55031195,
		0x1B80, 0x55031197,
		0x1B80, 0x312311A5,
		0x1B80, 0x312311A7,
		0x1B80, 0x6F1C11B5,
		0x1B80, 0x6F1C11B7,
		0x1B80, 0x6E4011C5,
		0x1B80, 0x6E4011C7,
		0x1B80, 0x550B11D5,
		0x1B80, 0x550B11D7,
		0x1B80, 0x312311E5,
		0x1B80, 0x312311E7,
		0x1B80, 0x061C11F5,
		0x1B80, 0x061C11F7,
		0x1B80, 0x54DE1205,
		0x1B80, 0x54DE1207,
		0x1B80, 0x06DC1215,
		0x1B80, 0x06DC1217,
		0x1B80, 0x55131225,
		0x1B80, 0x55131227,
		0x1B80, 0x74011235,
		0x1B80, 0x74011237,
		0x1B80, 0x74001245,
		0x1B80, 0x74001247,
		0x1B80, 0x8E001255,
		0x1B80, 0x8E001257,
		0x1B80, 0x00011265,
		0x1B80, 0x00011267,
		0x1B80, 0x57021275,
		0x1B80, 0x57021277,
		0x1B80, 0x57001285,
		0x1B80, 0x57001287,
		0x1B80, 0x97001295,
		0x1B80, 0x97001297,
		0x1B80, 0x000112A5,
		0x1B80, 0x000112A7,
		0x1B80, 0x54BF12B5,
		0x1B80, 0x54BF12B7,
		0x1B80, 0x54C112C5,
		0x1B80, 0x54C112C7,
		0x1B80, 0x54A212D5,
		0x1B80, 0x54A212D7,
		0x1B80, 0x54C012E5,
		0x1B80, 0x54C012E7,
		0x1B80, 0x54A112F5,
		0x1B80, 0x54A112F7,
		0x1B80, 0x54DF1305,
		0x1B80, 0x54DF1307,
		0x1B80, 0x00011315,
		0x1B80, 0x00011317,
		0x1B80, 0x55001325,
		0x1B80, 0x55001327,
		0x1B80, 0xE1231335,
		0x1B80, 0xE1231337,
		0x1B80, 0x54811345,
		0x1B80, 0x54811347,
		0x1B80, 0xE1231355,
		0x1B80, 0xE1231357,
		0x1B80, 0x54801365,
		0x1B80, 0x54801367,
		0x1B80, 0x002A1375,
		0x1B80, 0x002A1377,
		0x1B80, 0xE12B1385,
		0x1B80, 0xE12B1387,
		0x1B80, 0xE1231395,
		0x1B80, 0xE1231397,
		0x1B80, 0x548013A5,
		0x1B80, 0x548013A7,
		0x1B80, 0xE17213B5,
		0x1B80, 0xE17213B7,
		0x1B80, 0xBF3013C5,
		0x1B80, 0xBF3013C7,
		0x1B80, 0x000213D5,
		0x1B80, 0x000213D7,
		0x1B80, 0x302813E5,
		0x1B80, 0x302813E7,
		0x1B80, 0x4F7813F5,
		0x1B80, 0x4F7813F7,
		0x1B80, 0x4E001405,
		0x1B80, 0x4E001407,
		0x1B80, 0x53871415,
		0x1B80, 0x53871417,
		0x1B80, 0x52F11425,
		0x1B80, 0x52F11427,
		0x1B80, 0xE1161435,
		0x1B80, 0xE1161437,
		0x1B80, 0xE11B1445,
		0x1B80, 0xE11B1447,
		0x1B80, 0xE11F1455,
		0x1B80, 0xE11F1457,
		0x1B80, 0xE1271465,
		0x1B80, 0xE1271467,
		0x1B80, 0x54811475,
		0x1B80, 0x54811477,
		0x1B80, 0xE1161485,
		0x1B80, 0xE1161487,
		0x1B80, 0xE11B1495,
		0x1B80, 0xE11B1497,
		0x1B80, 0xE11F14A5,
		0x1B80, 0xE11F14A7,
		0x1B80, 0xE12714B5,
		0x1B80, 0xE12714B7,
		0x1B80, 0x548014C5,
		0x1B80, 0x548014C7,
		0x1B80, 0x002A14D5,
		0x1B80, 0x002A14D7,
		0x1B80, 0xE12B14E5,
		0x1B80, 0xE12B14E7,
		0x1B80, 0xE11614F5,
		0x1B80, 0xE11614F7,
		0x1B80, 0xE11B1505,
		0x1B80, 0xE11B1507,
		0x1B80, 0xE11F1515,
		0x1B80, 0xE11F1517,
		0x1B80, 0xE1271525,
		0x1B80, 0xE1271527,
		0x1B80, 0x54801535,
		0x1B80, 0x54801537,
		0x1B80, 0xE1721545,
		0x1B80, 0xE1721547,
		0x1B80, 0xBF171555,
		0x1B80, 0xBF171557,
		0x1B80, 0x00021565,
		0x1B80, 0x00021567,
		0x1B80, 0x30281575,
		0x1B80, 0x30281577,
		0x1B80, 0x06141585,
		0x1B80, 0x06141587,
		0x1B80, 0x73201595,
		0x1B80, 0x73201597,
		0x1B80, 0x720015A5,
		0x1B80, 0x720015A7,
		0x1B80, 0x710015B5,
		0x1B80, 0x710015B7,
		0x1B80, 0x550115C5,
		0x1B80, 0x550115C7,
		0x1B80, 0xE12315D5,
		0x1B80, 0xE12315D7,
		0x1B80, 0xE12715E5,
		0x1B80, 0xE12715E7,
		0x1B80, 0x548115F5,
		0x1B80, 0x548115F7,
		0x1B80, 0xE1231605,
		0x1B80, 0xE1231607,
		0x1B80, 0xE1271615,
		0x1B80, 0xE1271617,
		0x1B80, 0x54801625,
		0x1B80, 0x54801627,
		0x1B80, 0x002A1635,
		0x1B80, 0x002A1637,
		0x1B80, 0xE12B1645,
		0x1B80, 0xE12B1647,
		0x1B80, 0xE1231655,
		0x1B80, 0xE1231657,
		0x1B80, 0xE1271665,
		0x1B80, 0xE1271667,
		0x1B80, 0x54801675,
		0x1B80, 0x54801677,
		0x1B80, 0xE1721685,
		0x1B80, 0xE1721687,
		0x1B80, 0xBF031695,
		0x1B80, 0xBF031697,
		0x1B80, 0x000216A5,
		0x1B80, 0x000216A7,
		0x1B80, 0x302816B5,
		0x1B80, 0x302816B7,
		0x1B80, 0x54BF16C5,
		0x1B80, 0x54BF16C7,
		0x1B80, 0x54C516D5,
		0x1B80, 0x54C516D7,
		0x1B80, 0x050A16E5,
		0x1B80, 0x050A16E7,
		0x1B80, 0x071416F5,
		0x1B80, 0x071416F7,
		0x1B80, 0x54DF1705,
		0x1B80, 0x54DF1707,
		0x1B80, 0x00011715,
		0x1B80, 0x00011717,
		0x1B80, 0x54BF1725,
		0x1B80, 0x54BF1727,
		0x1B80, 0x54C01735,
		0x1B80, 0x54C01737,
		0x1B80, 0x54A31745,
		0x1B80, 0x54A31747,
		0x1B80, 0x54C11755,
		0x1B80, 0x54C11757,
		0x1B80, 0x54A41765,
		0x1B80, 0x54A41767,
		0x1B80, 0x4C831775,
		0x1B80, 0x4C831777,
		0x1B80, 0x4C031785,
		0x1B80, 0x4C031787,
		0x1B80, 0xBF0B1795,
		0x1B80, 0xBF0B1797,
		0x1B80, 0x54C217A5,
		0x1B80, 0x54C217A7,
		0x1B80, 0x54A417B5,
		0x1B80, 0x54A417B7,
		0x1B80, 0x4C8517C5,
		0x1B80, 0x4C8517C7,
		0x1B80, 0x4C0517D5,
		0x1B80, 0x4C0517D7,
		0x1B80, 0xBF0617E5,
		0x1B80, 0xBF0617E7,
		0x1B80, 0x54C117F5,
		0x1B80, 0x54C117F7,
		0x1B80, 0x54A31805,
		0x1B80, 0x54A31807,
		0x1B80, 0x4C861815,
		0x1B80, 0x4C861817,
		0x1B80, 0x4C061825,
		0x1B80, 0x4C061827,
		0x1B80, 0xBF011835,
		0x1B80, 0xBF011837,
		0x1B80, 0x54DF1845,
		0x1B80, 0x54DF1847,
		0x1B80, 0x00011855,
		0x1B80, 0x00011857,
		0x1B80, 0x00071865,
		0x1B80, 0x00071867,
		0x1B80, 0x54011875,
		0x1B80, 0x54011877,
		0x1B80, 0x00041885,
		0x1B80, 0x00041887,
		0x1B80, 0x56001895,
		0x1B80, 0x56001897,
		0x1B80, 0x5CF218A5,
		0x1B80, 0x5CF218A7,
		0x1B80, 0x630718B5,
		0x1B80, 0x630718B7,
		0x1B80, 0x620418C5,
		0x1B80, 0x620418C7,
		0x1B80, 0x610018D5,
		0x1B80, 0x610018D7,
		0x1B80, 0x670718E5,
		0x1B80, 0x670718E7,
		0x1B80, 0x660618F5,
		0x1B80, 0x660618F7,
		0x1B80, 0x6F201905,
		0x1B80, 0x6F201907,
		0x1B80, 0x6E001915,
		0x1B80, 0x6E001917,
		0x1B80, 0x6D001925,
		0x1B80, 0x6D001927,
		0x1B80, 0x6C031935,
		0x1B80, 0x6C031937,
		0x1B80, 0x73201945,
		0x1B80, 0x73201947,
		0x1B80, 0x72001955,
		0x1B80, 0x72001957,
		0x1B80, 0x71001965,
		0x1B80, 0x71001967,
		0x1B80, 0x7B201975,
		0x1B80, 0x7B201977,
		0x1B80, 0x7A001985,
		0x1B80, 0x7A001987,
		0x1B80, 0x79001995,
		0x1B80, 0x79001997,
		0x1B80, 0x7F2019A5,
		0x1B80, 0x7F2019A7,
		0x1B80, 0x7E0019B5,
		0x1B80, 0x7E0019B7,
		0x1B80, 0x7D0019C5,
		0x1B80, 0x7D0019C7,
		0x1B80, 0x090119D5,
		0x1B80, 0x090119D7,
		0x1B80, 0x0AC619E5,
		0x1B80, 0x0AC619E7,
		0x1B80, 0x0BA619F5,
		0x1B80, 0x0BA619F7,
		0x1B80, 0x0C011A05,
		0x1B80, 0x0C011A07,
		0x1B80, 0x0D021A15,
		0x1B80, 0x0D021A17,
		0x1B80, 0x0E041A25,
		0x1B80, 0x0E041A27,
		0x1B80, 0x0FFF1A35,
		0x1B80, 0x0FFF1A37,
		0x1B80, 0x4D041A45,
		0x1B80, 0x4D041A47,
		0x1B80, 0x28F81A55,
		0x1B80, 0x28F81A57,
		0x1B80, 0xE0001A65,
		0x1B80, 0xE0001A67,
		0x1B80, 0x4D001A75,
		0x1B80, 0x4D001A77,
		0x1B80, 0x00011A85,
		0x1B80, 0x00011A87,
		0x1B80, 0x4D041A95,
		0x1B80, 0x4D041A97,
		0x1B80, 0x2EF81AA5,
		0x1B80, 0x2EF81AA7,
		0x1B80, 0x00021AB5,
		0x1B80, 0x00021AB7,
		0x1B80, 0x23031AC5,
		0x1B80, 0x23031AC7,
		0x1B80, 0x00001AD5,
		0x1B80, 0x00001AD7,
		0x1B80, 0x23131AE5,
		0x1B80, 0x23131AE7,
		0x1B80, 0xE77F1AF5,
		0x1B80, 0xE77F1AF7,
		0x1B80, 0x232F1B05,
		0x1B80, 0x232F1B07,
		0x1B80, 0xEFBF1B15,
		0x1B80, 0xEFBF1B17,
		0x1B80, 0x2EF01B25,
		0x1B80, 0x2EF01B27,
		0x1B80, 0x00021B35,
		0x1B80, 0x00021B37,
		0x1B80, 0x4D001B45,
		0x1B80, 0x4D001B47,
		0x1B80, 0x00011B55,
		0x1B80, 0x00011B57,
		0x1B80, 0x4D041B65,
		0x1B80, 0x4D041B67,
		0x1B80, 0x2EF81B75,
		0x1B80, 0x2EF81B77,
		0x1B80, 0x00021B85,
		0x1B80, 0x00021B87,
		0x1B80, 0x23031B95,
		0x1B80, 0x23031B97,
		0x1B80, 0x00001BA5,
		0x1B80, 0x00001BA7,
		0x1B80, 0x23131BB5,
		0x1B80, 0x23131BB7,
		0x1B80, 0xE77F1BC5,
		0x1B80, 0xE77F1BC7,
		0x1B80, 0x232F1BD5,
		0x1B80, 0x232F1BD7,
		0x1B80, 0xE79F1BE5,
		0x1B80, 0xE79F1BE7,
		0x1B80, 0x2EF01BF5,
		0x1B80, 0x2EF01BF7,
		0x1B80, 0x00021C05,
		0x1B80, 0x00021C07,
		0x1B80, 0x28F81C15,
		0x1B80, 0x28F81C17,
		0x1B80, 0x80001C25,
		0x1B80, 0x80001C27,
		0x1B80, 0x4D001C35,
		0x1B80, 0x4D001C37,
		0x1B80, 0x00011C45,
		0x1B80, 0x00011C47,
		0x1B80, 0x00041C55,
		0x1B80, 0x00041C57,
		0x1B80, 0x6BC01C65,
		0x1B80, 0x6BC01C67,
		0x1B80, 0x4D041C75,
		0x1B80, 0x4D041C77,
	0x8000000c,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x68241C85,
		0x1B80, 0x68241C87,
	0x9000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B80, 0x68241C85,
		0x1B80, 0x68241C87,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B80, 0x68241C85,
		0x1B80, 0x68241C87,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B80, 0x68241C85,
		0x1B80, 0x68241C87,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B80, 0x68241C85,
		0x1B80, 0x68241C87,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x68241C85,
		0x1B80, 0x68241C87,
	0xA0000000,	0x00000000,
		0x1B80, 0x68481C85,
		0x1B80, 0x68481C87,
	0xB0000000,	0x00000000,
		0x1B80, 0x66061C95,
		0x1B80, 0x66061C97,
	0x8000000c,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x650C1CA5,
		0x1B80, 0x650C1CA7,
	0x9000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B80, 0x650C1CA5,
		0x1B80, 0x650C1CA7,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B80, 0x650C1CA5,
		0x1B80, 0x650C1CA7,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B80, 0x650C1CA5,
		0x1B80, 0x650C1CA7,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B80, 0x650C1CA5,
		0x1B80, 0x650C1CA7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x650C1CA5,
		0x1B80, 0x650C1CA7,
	0xA0000000,	0x00000000,
		0x1B80, 0x65041CA5,
		0x1B80, 0x65041CA7,
	0xB0000000,	0x00000000,
		0x1B80, 0x64471CB5,
		0x1B80, 0x64471CB7,
		0x1B80, 0x23411CC5,
		0x1B80, 0x23411CC7,
		0x1B80, 0x100E1CD5,
		0x1B80, 0x100E1CD7,
	0x8000000c,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x60101CE5,
		0x1B80, 0x60101CE7,
	0x9000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B80, 0x60101CE5,
		0x1B80, 0x60101CE7,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B80, 0x60101CE5,
		0x1B80, 0x60101CE7,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B80, 0x60101CE5,
		0x1B80, 0x60101CE7,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B80, 0x60101CE5,
		0x1B80, 0x60101CE7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x60101CE5,
		0x1B80, 0x60101CE7,
	0xA0000000,	0x00000000,
		0x1B80, 0x60011CE5,
		0x1B80, 0x60011CE7,
	0xB0000000,	0x00000000,
		0x1B80, 0x23411CF5,
		0x1B80, 0x23411CF7,
	0x8000000c,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x60811D05,
		0x1B80, 0x60811D07,
	0x9000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B80, 0x60811D05,
		0x1B80, 0x60811D07,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B80, 0x60811D05,
		0x1B80, 0x60811D07,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B80, 0x60811D05,
		0x1B80, 0x60811D07,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B80, 0x60811D05,
		0x1B80, 0x60811D07,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x60811D05,
		0x1B80, 0x60811D07,
	0xA0000000,	0x00000000,
		0x1B80, 0x60611D05,
		0x1B80, 0x60611D07,
	0xB0000000,	0x00000000,
		0x1B80, 0x23411D15,
		0x1B80, 0x23411D17,
		0x1B80, 0x70E11D25,
		0x1B80, 0x70E11D27,
		0x1B80, 0x4D001D35,
		0x1B80, 0x4D001D37,
		0x1B80, 0x00011D45,
		0x1B80, 0x00011D47,
		0x1B80, 0x00041D55,
		0x1B80, 0x00041D57,
		0x1B80, 0x6B401D65,
		0x1B80, 0x6B401D67,
		0x1B80, 0x4D041D75,
		0x1B80, 0x4D041D77,
	0x8000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B80, 0x68241D85,
		0x1B80, 0x68241D87,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B80, 0x68241D85,
		0x1B80, 0x68241D87,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B80, 0x68241D85,
		0x1B80, 0x68241D87,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B80, 0x68241D85,
		0x1B80, 0x68241D87,
	0xA0000000,	0x00000000,
		0x1B80, 0x68481D85,
		0x1B80, 0x68481D87,
	0xB0000000,	0x00000000,
		0x1B80, 0x66061D95,
		0x1B80, 0x66061D97,
	0x8000000c,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x65081DA5,
		0x1B80, 0x65081DA7,
	0x9000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B80, 0x65181DA5,
		0x1B80, 0x65181DA7,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B80, 0x65181DA5,
		0x1B80, 0x65181DA7,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B80, 0x65181DA5,
		0x1B80, 0x65181DA7,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B80, 0x65181DA5,
		0x1B80, 0x65181DA7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x65081DA5,
		0x1B80, 0x65081DA7,
	0xA0000000,	0x00000000,
		0x1B80, 0x65081DA5,
		0x1B80, 0x65081DA7,
	0xB0000000,	0x00000000,
	0x8000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B80, 0x64481DB5,
		0x1B80, 0x64481DB7,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B80, 0x64481DB5,
		0x1B80, 0x64481DB7,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B80, 0x64481DB5,
		0x1B80, 0x64481DB7,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B80, 0x64481DB5,
		0x1B80, 0x64481DB7,
	0xA0000000,	0x00000000,
		0x1B80, 0x64471DB5,
		0x1B80, 0x64471DB7,
	0xB0000000,	0x00000000,
		0x1B80, 0x23411DC5,
		0x1B80, 0x23411DC7,
	0x8000000c,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x11E41DD5,
		0x1B80, 0x11E41DD7,
	0x9000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B80, 0x11E81DD5,
		0x1B80, 0x11E81DD7,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B80, 0x11E81DD5,
		0x1B80, 0x11E81DD7,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B80, 0x11E81DD5,
		0x1B80, 0x11E81DD7,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B80, 0x11E81DD5,
		0x1B80, 0x11E81DD7,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x11E41DD5,
		0x1B80, 0x11E41DD7,
	0xA0000000,	0x00000000,
		0x1B80, 0x11E41DD5,
		0x1B80, 0x11E41DD7,
	0xB0000000,	0x00000000,
		0x1B80, 0x60011DE5,
		0x1B80, 0x60011DE7,
		0x1B80, 0x23411DF5,
		0x1B80, 0x23411DF7,
	0x8000000c,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x60E11E05,
		0x1B80, 0x60E11E07,
	0x9000000f,	0x55555555,	0x40000000,	0x00000000,
		0x1B80, 0x61E11E05,
		0x1B80, 0x61E11E07,
	0x9000000f,	0x55ff5555,	0x40000000,	0x00000000,
		0x1B80, 0x61E11E05,
		0x1B80, 0x61E11E07,
	0x9000000f,	0xaaaaaaaa,	0x40000000,	0x00000000,
		0x1B80, 0x61E11E05,
		0x1B80, 0x61E11E07,
	0x9000000f,	0xaa00aaaa,	0x40000000,	0x00550000,
		0x1B80, 0x61E11E05,
		0x1B80, 0x61E11E07,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x1B80, 0x60E11E05,
		0x1B80, 0x60E11E07,
	0xA0000000,	0x00000000,
		0x1B80, 0x60E11E05,
		0x1B80, 0x60E11E07,
	0xB0000000,	0x00000000,
		0x1B80, 0x23411E15,
		0x1B80, 0x23411E17,
		0x1B80, 0x70611E25,
		0x1B80, 0x70611E27,
		0x1B80, 0x4D001E35,
		0x1B80, 0x4D001E37,
		0x1B80, 0x00011E45,
		0x1B80, 0x00011E47,
		0x1B80, 0x00001E55,
		0x1B80, 0x00001E57,
		0x1B80, 0x00001E65,
		0x1B80, 0x00001E67,
		0x1B80, 0x00001E75,
		0x1B80, 0x00001E77,
		0x1B80, 0x00001E85,
		0x1B80, 0x00001E87,
		0x1B80, 0x00001E95,
		0x1B80, 0x00001E97,
		0x1B80, 0x00001EA5,
		0x1B80, 0x00001EA7,
		0x1B80, 0x00001EB5,
		0x1B80, 0x00001EB7,
		0x1B80, 0x00001EC5,
		0x1B80, 0x00001EC7,
		0x1B80, 0x00001ED5,
		0x1B80, 0x00001ED7,
		0x1B80, 0x00001EE5,
		0x1B80, 0x00001EE7,
		0x1B80, 0x00001EF5,
		0x1B80, 0x00001EF7,
		0x1B80, 0x00001F05,
		0x1B80, 0x00001F07,
		0x1B80, 0x00001F15,
		0x1B80, 0x00001F17,
		0x1B80, 0x00001F25,
		0x1B80, 0x00001F27,
		0x1B80, 0x00001F35,
		0x1B80, 0x00001F37,
		0x1B80, 0x00001F45,
		0x1B80, 0x00001F47,
		0x1B80, 0x00001F55,
		0x1B80, 0x00001F57,
		0x1B80, 0x00001F65,
		0x1B80, 0x00001F67,
		0x1B80, 0x00001F75,
		0x1B80, 0x00001F77,
		0x1B80, 0x00001F85,
		0x1B80, 0x00001F87,
		0x1B80, 0x00001F95,
		0x1B80, 0x00001F97,
		0x1B80, 0x00001FA5,
		0x1B80, 0x00001FA7,
		0x1B80, 0x00001FB5,
		0x1B80, 0x00001FB7,
		0x1B80, 0x00001FC5,
		0x1B80, 0x00001FC7,
		0x1B80, 0x00001FD5,
		0x1B80, 0x00001FD7,
		0x1B80, 0x00001FE5,
		0x1B80, 0x00001FE7,
		0x1B80, 0x00001FF5,
		0x1B80, 0x00001FF7,
		0x1B80, 0x00000006,
		0x1B80, 0x00000002,

};

void
ODM_ReadAndConfig_MP_8814A_PHY_REG(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_PHY_REG)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_PHY_REG;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_PHY_REG\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigBB_PHY_8814A(pDM_Odm, v1, bMaskDWord, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_MP_8814A_PHY_REG(void)
{
	   return 98;
}

/******************************************************************************
*                           PHY_REG_MP.TXT
******************************************************************************/

u4Byte Array_MP_8814A_PHY_REG_MP[] = { 
		0x8FC, 0x00000000,
		0x838, 0x86667641,

};

void
ODM_ReadAndConfig_MP_8814A_PHY_REG_MP(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_PHY_REG_MP)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_PHY_REG_MP;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_PHY_REG_MP\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigBB_PHY_8814A(pDM_Odm, v1, bMaskDWord, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_MP_8814A_PHY_REG_MP(void)
{
	   return 98;
}

/******************************************************************************
*                           PHY_REG_PG.TXT
******************************************************************************/

u4Byte Array_MP_8814A_PHY_REG_PG[] = { 
	0, 0, 0, 0x00000c20, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x30323434,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x28303234,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x32323232,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
	0, 0, 2, 0x00000cd8, 0xffffffff, 0x30303030,
	0, 0, 2, 0x00000cdc, 0xffffffff, 0x24262830,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x32322426,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x30323232,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	0, 0, 2, 0x00000ce0, 0xffffffff, 0x30303030,
	0, 0, 2, 0x00000ce4, 0xffffffff, 0x24262830,
	0, 0, 2, 0x00000ce8, 0x0000ffff, 0x20222222,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x30323434,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x28303234,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x32323232,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
	0, 1, 2, 0x00000ed8, 0xffffffff, 0x30303030,
	0, 1, 2, 0x00000edc, 0xffffffff, 0x24262830,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x32322426,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x30323232,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
	0, 1, 2, 0x00000ee0, 0xffffffff, 0x30303030,
	0, 1, 2, 0x00000ee4, 0xffffffff, 0x24262830,
	0, 1, 2, 0x00000ee8, 0x0000ffff, 0x20222222,
	0, 2, 0, 0x00001820, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001824, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001828, 0xffffffff, 0x30323434,
	0, 2, 0, 0x0000182c, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001830, 0xffffffff, 0x28303234,
	0, 2, 1, 0x00001834, 0xffffffff, 0x32323232,
	0, 2, 1, 0x00001838, 0xffffffff, 0x26283032,
	0, 2, 2, 0x000018d8, 0xffffffff, 0x30303030,
	0, 2, 2, 0x000018dc, 0xffffffff, 0x24262830,
	0, 2, 0, 0x0000183c, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001840, 0xffffffff, 0x28303234,
	0, 2, 0, 0x00001844, 0xffffffff, 0x32322426,
	0, 2, 1, 0x00001848, 0xffffffff, 0x30323232,
	0, 2, 1, 0x0000184c, 0xffffffff, 0x22242628,
	0, 2, 2, 0x000018e0, 0xffffffff, 0x30303030,
	0, 2, 2, 0x000018e4, 0xffffffff, 0x24262830,
	0, 2, 2, 0x000018e8, 0x0000ffff, 0x20222222,
	0, 3, 0, 0x00001a20, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a24, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a28, 0xffffffff, 0x30323434,
	0, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a30, 0xffffffff, 0x28303234,
	0, 3, 1, 0x00001a34, 0xffffffff, 0x32323232,
	0, 3, 1, 0x00001a38, 0xffffffff, 0x26283032,
	0, 3, 2, 0x00001ad8, 0xffffffff, 0x30303030,
	0, 3, 2, 0x00001adc, 0xffffffff, 0x24262830,
	0, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a40, 0xffffffff, 0x28303234,
	0, 3, 0, 0x00001a44, 0xffffffff, 0x32322426,
	0, 3, 1, 0x00001a48, 0xffffffff, 0x30323232,
	0, 3, 1, 0x00001a4c, 0xffffffff, 0x22242628,
	0, 3, 2, 0x00001ae0, 0xffffffff, 0x30303030,
	0, 3, 2, 0x00001ae4, 0xffffffff, 0x24262830,
	0, 3, 2, 0x00001ae8, 0x0000ffff, 0x20222222,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x34343434,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x30323434,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x28303234,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x32323232,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
	1, 0, 2, 0x00000cd8, 0xffffffff, 0x30303030,
	1, 0, 2, 0x00000cdc, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x28303234,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x32322426,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x30323232,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	1, 0, 2, 0x00000ce0, 0xffffffff, 0x30303030,
	1, 0, 2, 0x00000ce4, 0xffffffff, 0x24262830,
	1, 0, 2, 0x00000ce8, 0x0000ffff, 0x20222222,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x34343434,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x30323434,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x28303234,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x32323232,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
	1, 1, 2, 0x00000ed8, 0xffffffff, 0x30303030,
	1, 1, 2, 0x00000edc, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x28303234,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x32322426,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x30323232,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
	1, 1, 2, 0x00000ee0, 0xffffffff, 0x30303030,
	1, 1, 2, 0x00000ee4, 0xffffffff, 0x24262830,
	1, 1, 2, 0x00000ee8, 0x0000ffff, 0x20222222,
	1, 2, 0, 0x00001824, 0xffffffff, 0x34343434,
	1, 2, 0, 0x00001828, 0xffffffff, 0x30323434,
	1, 2, 0, 0x0000182c, 0xffffffff, 0x34343434,
	1, 2, 0, 0x00001830, 0xffffffff, 0x28303234,
	1, 2, 1, 0x00001834, 0xffffffff, 0x32323232,
	1, 2, 1, 0x00001838, 0xffffffff, 0x26283032,
	1, 2, 2, 0x000018d8, 0xffffffff, 0x30303030,
	1, 2, 2, 0x000018dc, 0xffffffff, 0x24262830,
	1, 2, 0, 0x0000183c, 0xffffffff, 0x34343434,
	1, 2, 0, 0x00001840, 0xffffffff, 0x28303234,
	1, 2, 0, 0x00001844, 0xffffffff, 0x32322426,
	1, 2, 1, 0x00001848, 0xffffffff, 0x30323232,
	1, 2, 1, 0x0000184c, 0xffffffff, 0x22242628,
	1, 2, 2, 0x000018e0, 0xffffffff, 0x30303030,
	1, 2, 2, 0x000018e4, 0xffffffff, 0x24262830,
	1, 2, 2, 0x000018e8, 0x0000ffff, 0x20222222,
	1, 3, 0, 0x00001a24, 0xffffffff, 0x34343434,
	1, 3, 0, 0x00001a28, 0xffffffff, 0x30323434,
	1, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434,
	1, 3, 0, 0x00001a30, 0xffffffff, 0x28303234,
	1, 3, 1, 0x00001a34, 0xffffffff, 0x32323232,
	1, 3, 1, 0x00001a38, 0xffffffff, 0x26283032,
	1, 3, 2, 0x00001ad8, 0xffffffff, 0x30303030,
	1, 3, 2, 0x00001adc, 0xffffffff, 0x24262830,
	1, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434,
	1, 3, 0, 0x00001a40, 0xffffffff, 0x28303234,
	1, 3, 0, 0x00001a44, 0xffffffff, 0x32322426,
	1, 3, 1, 0x00001a48, 0xffffffff, 0x30323232,
	1, 3, 1, 0x00001a4c, 0xffffffff, 0x22242628,
	1, 3, 2, 0x00001ae0, 0xffffffff, 0x30303030,
	1, 3, 2, 0x00001ae4, 0xffffffff, 0x24262830,
	1, 3, 2, 0x00001ae8, 0x0000ffff, 0x20222222
};

void
ODM_ReadAndConfig_MP_8814A_PHY_REG_PG(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_PHY_REG_PG)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_PHY_REG_PG;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrByRate = ArrayLen/6;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_PHY_REG_PG\n"));

	pDM_Odm->PhyRegPgVersion = 1;
	pDM_Odm->PhyRegPgValueType = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < ArrayLen; i += 6) {
		u4Byte v1 = Array[i];
		u4Byte v2 = Array[i+1];
		u4Byte v3 = Array[i+2];
		u4Byte v4 = Array[i+3];
		u4Byte v5 = Array[i+4];
		u4Byte v6 = Array[i+5];

	    odm_ConfigBB_PHY_REG_PG_8814A(pDM_Odm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)pHalData->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}



/******************************************************************************
*                           PHY_REG_PG_Type0.TXT
******************************************************************************/

u4Byte Array_MP_8814A_PHY_REG_PG_Type0[] = { 
	0, 0, 0, 0x00000c20, 0xffffffff, 0x32323232,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x32323232,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x28303232,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x32323232,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x30303030,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x24262830,
	0, 0, 2, 0x00000cd8, 0xffffffff, 0x28282828,
	0, 0, 2, 0x00000cdc, 0xffffffff, 0x22242628,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x32323232,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x30302224,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x28303030,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x20222426,
	0, 0, 2, 0x00000ce0, 0xffffffff, 0x28282828,
	0, 0, 2, 0x00000ce4, 0xffffffff, 0x22242628,
	0, 0, 2, 0x00000ce8, 0x0000ffff, 0x18202020,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x32323232,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x32323232,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x28303232,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x32323232,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x26283032,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x30303030,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x24262830,
	0, 1, 2, 0x00000ed8, 0xffffffff, 0x28282828,
	0, 1, 2, 0x00000edc, 0xffffffff, 0x22242628,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x32323232,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x30302224,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x28303030,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x20222426,
	0, 1, 2, 0x00000ee0, 0xffffffff, 0x28282828,
	0, 1, 2, 0x00000ee4, 0xffffffff, 0x22242628,
	0, 1, 2, 0x00000ee8, 0x0000ffff, 0x18202020,
	0, 2, 0, 0x00001820, 0xffffffff, 0x32323232,
	0, 2, 0, 0x00001824, 0xffffffff, 0x32323232,
	0, 2, 0, 0x00001828, 0xffffffff, 0x28303232,
	0, 2, 0, 0x0000182c, 0xffffffff, 0x32323232,
	0, 2, 0, 0x00001830, 0xffffffff, 0x26283032,
	0, 2, 1, 0x00001834, 0xffffffff, 0x30303030,
	0, 2, 1, 0x00001838, 0xffffffff, 0x24262830,
	0, 2, 2, 0x000018d8, 0xffffffff, 0x28282828,
	0, 2, 2, 0x000018dc, 0xffffffff, 0x22242628,
	0, 2, 0, 0x0000183c, 0xffffffff, 0x32323232,
	0, 2, 0, 0x00001840, 0xffffffff, 0x26283032,
	0, 2, 0, 0x00001844, 0xffffffff, 0x30302224,
	0, 2, 1, 0x00001848, 0xffffffff, 0x28303030,
	0, 2, 1, 0x0000184c, 0xffffffff, 0x20222426,
	0, 2, 2, 0x000018e0, 0xffffffff, 0x28282828,
	0, 2, 2, 0x000018e4, 0xffffffff, 0x22242628,
	0, 2, 2, 0x000018e8, 0x0000ffff, 0x18202020,
	0, 3, 0, 0x00001a20, 0xffffffff, 0x32323232,
	0, 3, 0, 0x00001a24, 0xffffffff, 0x32323232,
	0, 3, 0, 0x00001a28, 0xffffffff, 0x28303232,
	0, 3, 0, 0x00001a2c, 0xffffffff, 0x32323232,
	0, 3, 0, 0x00001a30, 0xffffffff, 0x26283032,
	0, 3, 1, 0x00001a34, 0xffffffff, 0x30303030,
	0, 3, 1, 0x00001a38, 0xffffffff, 0x24262830,
	0, 3, 2, 0x00001ad8, 0xffffffff, 0x28282828,
	0, 3, 2, 0x00001adc, 0xffffffff, 0x22242628,
	0, 3, 0, 0x00001a3c, 0xffffffff, 0x32323232,
	0, 3, 0, 0x00001a40, 0xffffffff, 0x26283032,
	0, 3, 0, 0x00001a44, 0xffffffff, 0x30302224,
	0, 3, 1, 0x00001a48, 0xffffffff, 0x28303030,
	0, 3, 1, 0x00001a4c, 0xffffffff, 0x20222426,
	0, 3, 2, 0x00001ae0, 0xffffffff, 0x28282828,
	0, 3, 2, 0x00001ae4, 0xffffffff, 0x22242628,
	0, 3, 2, 0x00001ae8, 0x0000ffff, 0x18202020,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x32323232,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x28303232,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x32323232,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x30303030,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x24262830,
	1, 0, 2, 0x00000cd8, 0xffffffff, 0x28282828,
	1, 0, 2, 0x00000cdc, 0xffffffff, 0x22242628,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x32323232,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x30302224,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x28303030,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x20222426,
	1, 0, 2, 0x00000ce0, 0xffffffff, 0x28282828,
	1, 0, 2, 0x00000ce4, 0xffffffff, 0x22242628,
	1, 0, 2, 0x00000ce8, 0x0000ffff, 0x18202020,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x32323232,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x28303232,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x32323232,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x26283032,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x30303030,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x24262830,
	1, 1, 2, 0x00000ed8, 0xffffffff, 0x28282828,
	1, 1, 2, 0x00000edc, 0xffffffff, 0x22242628,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x32323232,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x26283032,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x30302224,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x28303030,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x20222426,
	1, 1, 2, 0x00000ee0, 0xffffffff, 0x28282828,
	1, 1, 2, 0x00000ee4, 0xffffffff, 0x22242628,
	1, 1, 2, 0x00000ee8, 0x0000ffff, 0x18202020,
	1, 2, 0, 0x00001824, 0xffffffff, 0x32323232,
	1, 2, 0, 0x00001828, 0xffffffff, 0x28303232,
	1, 2, 0, 0x0000182c, 0xffffffff, 0x32323232,
	1, 2, 0, 0x00001830, 0xffffffff, 0x26283032,
	1, 2, 1, 0x00001834, 0xffffffff, 0x30303030,
	1, 2, 1, 0x00001838, 0xffffffff, 0x24262830,
	1, 2, 2, 0x000018d8, 0xffffffff, 0x28282828,
	1, 2, 2, 0x000018dc, 0xffffffff, 0x22242628,
	1, 2, 0, 0x0000183c, 0xffffffff, 0x32323232,
	1, 2, 0, 0x00001840, 0xffffffff, 0x26283032,
	1, 2, 0, 0x00001844, 0xffffffff, 0x30302224,
	1, 2, 1, 0x00001848, 0xffffffff, 0x28303030,
	1, 2, 1, 0x0000184c, 0xffffffff, 0x20222426,
	1, 2, 2, 0x000018e0, 0xffffffff, 0x28282828,
	1, 2, 2, 0x000018e4, 0xffffffff, 0x22242628,
	1, 2, 2, 0x000018e8, 0x0000ffff, 0x18202020,
	1, 3, 0, 0x00001a24, 0xffffffff, 0x32323232,
	1, 3, 0, 0x00001a28, 0xffffffff, 0x28303232,
	1, 3, 0, 0x00001a2c, 0xffffffff, 0x32323232,
	1, 3, 0, 0x00001a30, 0xffffffff, 0x26283032,
	1, 3, 1, 0x00001a34, 0xffffffff, 0x30303030,
	1, 3, 1, 0x00001a38, 0xffffffff, 0x24262830,
	1, 3, 2, 0x00001ad8, 0xffffffff, 0x28282828,
	1, 3, 2, 0x00001adc, 0xffffffff, 0x22242628,
	1, 3, 0, 0x00001a3c, 0xffffffff, 0x32323232,
	1, 3, 0, 0x00001a40, 0xffffffff, 0x26283032,
	1, 3, 0, 0x00001a44, 0xffffffff, 0x30302224,
	1, 3, 1, 0x00001a48, 0xffffffff, 0x28303030,
	1, 3, 1, 0x00001a4c, 0xffffffff, 0x20222426,
	1, 3, 2, 0x00001ae0, 0xffffffff, 0x28282828,
	1, 3, 2, 0x00001ae4, 0xffffffff, 0x22242628,
	1, 3, 2, 0x00001ae8, 0x0000ffff, 0x18202020
};

void
ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type0(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_PHY_REG_PG_Type0)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_PHY_REG_PG_Type0;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrByRate = ArrayLen/6;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type0\n"));

	pDM_Odm->PhyRegPgVersion = 1;
	pDM_Odm->PhyRegPgValueType = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < ArrayLen; i += 6) {
		u4Byte v1 = Array[i];
		u4Byte v2 = Array[i+1];
		u4Byte v3 = Array[i+2];
		u4Byte v4 = Array[i+3];
		u4Byte v5 = Array[i+4];
		u4Byte v6 = Array[i+5];

	    odm_ConfigBB_PHY_REG_PG_8814A(pDM_Odm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)pHalData->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}



/******************************************************************************
*                           PHY_REG_PG_Type2.TXT
******************************************************************************/

u4Byte Array_MP_8814A_PHY_REG_PG_Type2[] = { 
	0, 0, 0, 0x00000c20, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x30323434,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x28303234,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x32323232,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
	0, 0, 2, 0x00000cd8, 0xffffffff, 0x30303030,
	0, 0, 2, 0x00000cdc, 0xffffffff, 0x24262830,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x32322426,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x30323232,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	0, 0, 2, 0x00000ce0, 0xffffffff, 0x30303030,
	0, 0, 2, 0x00000ce4, 0xffffffff, 0x24262830,
	0, 0, 2, 0x00000ce8, 0x0000ffff, 0x20222222,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x30323434,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x28303234,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x32323232,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
	0, 1, 2, 0x00000ed8, 0xffffffff, 0x30303030,
	0, 1, 2, 0x00000edc, 0xffffffff, 0x24262830,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x32322426,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x30323232,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
	0, 1, 2, 0x00000ee0, 0xffffffff, 0x30303030,
	0, 1, 2, 0x00000ee4, 0xffffffff, 0x24262830,
	0, 1, 2, 0x00000ee8, 0x0000ffff, 0x20222222,
	0, 2, 0, 0x00001820, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001824, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001828, 0xffffffff, 0x30323434,
	0, 2, 0, 0x0000182c, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001830, 0xffffffff, 0x28303234,
	0, 2, 1, 0x00001834, 0xffffffff, 0x32323232,
	0, 2, 1, 0x00001838, 0xffffffff, 0x26283032,
	0, 2, 2, 0x000018d8, 0xffffffff, 0x30303030,
	0, 2, 2, 0x000018dc, 0xffffffff, 0x24262830,
	0, 2, 0, 0x0000183c, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001840, 0xffffffff, 0x28303234,
	0, 2, 0, 0x00001844, 0xffffffff, 0x32322426,
	0, 2, 1, 0x00001848, 0xffffffff, 0x30323232,
	0, 2, 1, 0x0000184c, 0xffffffff, 0x22242628,
	0, 2, 2, 0x000018e0, 0xffffffff, 0x30303030,
	0, 2, 2, 0x000018e4, 0xffffffff, 0x24262830,
	0, 2, 2, 0x000018e8, 0x0000ffff, 0x20222222,
	0, 3, 0, 0x00001a20, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a24, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a28, 0xffffffff, 0x30323434,
	0, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a30, 0xffffffff, 0x28303234,
	0, 3, 1, 0x00001a34, 0xffffffff, 0x32323232,
	0, 3, 1, 0x00001a38, 0xffffffff, 0x26283032,
	0, 3, 2, 0x00001ad8, 0xffffffff, 0x30303030,
	0, 3, 2, 0x00001adc, 0xffffffff, 0x24262830,
	0, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a40, 0xffffffff, 0x28303234,
	0, 3, 0, 0x00001a44, 0xffffffff, 0x32322426,
	0, 3, 1, 0x00001a48, 0xffffffff, 0x30323232,
	0, 3, 1, 0x00001a4c, 0xffffffff, 0x22242628,
	0, 3, 2, 0x00001ae0, 0xffffffff, 0x30303030,
	0, 3, 2, 0x00001ae4, 0xffffffff, 0x24262830,
	0, 3, 2, 0x00001ae8, 0x0000ffff, 0x20222222,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x34343434,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x30323434,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x28303234,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x32323232,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
	1, 0, 2, 0x00000cd8, 0xffffffff, 0x30303030,
	1, 0, 2, 0x00000cdc, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x28303234,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x32322426,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x30323232,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	1, 0, 2, 0x00000ce0, 0xffffffff, 0x30303030,
	1, 0, 2, 0x00000ce4, 0xffffffff, 0x24262830,
	1, 0, 2, 0x00000ce8, 0x0000ffff, 0x20222222,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x34343434,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x30323434,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x28303234,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x32323232,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
	1, 1, 2, 0x00000ed8, 0xffffffff, 0x30303030,
	1, 1, 2, 0x00000edc, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x28303234,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x32322426,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x30323232,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
	1, 1, 2, 0x00000ee0, 0xffffffff, 0x30303030,
	1, 1, 2, 0x00000ee4, 0xffffffff, 0x24262830,
	1, 1, 2, 0x00000ee8, 0x0000ffff, 0x20222222,
	1, 2, 0, 0x00001824, 0xffffffff, 0x34343434,
	1, 2, 0, 0x00001828, 0xffffffff, 0x30323434,
	1, 2, 0, 0x0000182c, 0xffffffff, 0x34343434,
	1, 2, 0, 0x00001830, 0xffffffff, 0x28303234,
	1, 2, 1, 0x00001834, 0xffffffff, 0x32323232,
	1, 2, 1, 0x00001838, 0xffffffff, 0x26283032,
	1, 2, 2, 0x000018d8, 0xffffffff, 0x30303030,
	1, 2, 2, 0x000018dc, 0xffffffff, 0x24262830,
	1, 2, 0, 0x0000183c, 0xffffffff, 0x34343434,
	1, 2, 0, 0x00001840, 0xffffffff, 0x28303234,
	1, 2, 0, 0x00001844, 0xffffffff, 0x32322426,
	1, 2, 1, 0x00001848, 0xffffffff, 0x30323232,
	1, 2, 1, 0x0000184c, 0xffffffff, 0x22242628,
	1, 2, 2, 0x000018e0, 0xffffffff, 0x30303030,
	1, 2, 2, 0x000018e4, 0xffffffff, 0x24262830,
	1, 2, 2, 0x000018e8, 0x0000ffff, 0x20222222,
	1, 3, 0, 0x00001a24, 0xffffffff, 0x34343434,
	1, 3, 0, 0x00001a28, 0xffffffff, 0x30323434,
	1, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434,
	1, 3, 0, 0x00001a30, 0xffffffff, 0x28303234,
	1, 3, 1, 0x00001a34, 0xffffffff, 0x32323232,
	1, 3, 1, 0x00001a38, 0xffffffff, 0x26283032,
	1, 3, 2, 0x00001ad8, 0xffffffff, 0x30303030,
	1, 3, 2, 0x00001adc, 0xffffffff, 0x24262830,
	1, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434,
	1, 3, 0, 0x00001a40, 0xffffffff, 0x28303234,
	1, 3, 0, 0x00001a44, 0xffffffff, 0x32322426,
	1, 3, 1, 0x00001a48, 0xffffffff, 0x30323232,
	1, 3, 1, 0x00001a4c, 0xffffffff, 0x22242628,
	1, 3, 2, 0x00001ae0, 0xffffffff, 0x30303030,
	1, 3, 2, 0x00001ae4, 0xffffffff, 0x24262830,
	1, 3, 2, 0x00001ae8, 0x0000ffff, 0x20222222
};

void
ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type2(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_PHY_REG_PG_Type2)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_PHY_REG_PG_Type2;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrByRate = ArrayLen/6;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type2\n"));

	pDM_Odm->PhyRegPgVersion = 1;
	pDM_Odm->PhyRegPgValueType = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < ArrayLen; i += 6) {
		u4Byte v1 = Array[i];
		u4Byte v2 = Array[i+1];
		u4Byte v3 = Array[i+2];
		u4Byte v4 = Array[i+3];
		u4Byte v5 = Array[i+4];
		u4Byte v6 = Array[i+5];

	    odm_ConfigBB_PHY_REG_PG_8814A(pDM_Odm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)pHalData->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}



/******************************************************************************
*                           PHY_REG_PG_Type3.TXT
******************************************************************************/

u4Byte Array_MP_8814A_PHY_REG_PG_Type3[] = { 
	0, 0, 0, 0x00000c20, 0xffffffff, 0x48484848,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x42444646,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x46464646,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x42444646,
	0, 0, 2, 0x00000cd8, 0xffffffff, 0x46464646,
	0, 0, 2, 0x00000cdc, 0xffffffff, 0x42444646,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x42444646,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x46463840,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x46464646,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x38404244,
	0, 0, 2, 0x00000ce0, 0xffffffff, 0x46464646,
	0, 0, 2, 0x00000ce4, 0xffffffff, 0x42444646,
	0, 0, 2, 0x00000ce8, 0x0000ffff, 0x38383840,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x48484848,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x46464646,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x44464646,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x46464646,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x42444646,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x46464646,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x42444646,
	0, 1, 2, 0x00000ed8, 0xffffffff, 0x46464646,
	0, 1, 2, 0x00000edc, 0xffffffff, 0x42444646,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x46464646,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x42444646,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x46463840,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x46464646,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x38404244,
	0, 1, 2, 0x00000ee0, 0xffffffff, 0x46464646,
	0, 1, 2, 0x00000ee4, 0xffffffff, 0x42444646,
	0, 1, 2, 0x00000ee8, 0x0000ffff, 0x38383840,
	0, 2, 0, 0x00001820, 0xffffffff, 0x48484848,
	0, 2, 0, 0x00001824, 0xffffffff, 0x46464646,
	0, 2, 0, 0x00001828, 0xffffffff, 0x44464646,
	0, 2, 0, 0x0000182c, 0xffffffff, 0x46464646,
	0, 2, 0, 0x00001830, 0xffffffff, 0x42444646,
	0, 2, 1, 0x00001834, 0xffffffff, 0x46464646,
	0, 2, 1, 0x00001838, 0xffffffff, 0x42444646,
	0, 2, 2, 0x000018d8, 0xffffffff, 0x46464646,
	0, 2, 2, 0x000018dc, 0xffffffff, 0x42444646,
	0, 2, 0, 0x0000183c, 0xffffffff, 0x46464646,
	0, 2, 0, 0x00001840, 0xffffffff, 0x42444646,
	0, 2, 0, 0x00001844, 0xffffffff, 0x46463840,
	0, 2, 1, 0x00001848, 0xffffffff, 0x46464646,
	0, 2, 1, 0x0000184c, 0xffffffff, 0x38404244,
	0, 2, 2, 0x000018e0, 0xffffffff, 0x46464646,
	0, 2, 2, 0x000018e4, 0xffffffff, 0x42444646,
	0, 2, 2, 0x000018e8, 0x0000ffff, 0x38383840,
	0, 3, 0, 0x00001a20, 0xffffffff, 0x48484848,
	0, 3, 0, 0x00001a24, 0xffffffff, 0x46464646,
	0, 3, 0, 0x00001a28, 0xffffffff, 0x44464646,
	0, 3, 0, 0x00001a2c, 0xffffffff, 0x46464646,
	0, 3, 0, 0x00001a30, 0xffffffff, 0x42444646,
	0, 3, 1, 0x00001a34, 0xffffffff, 0x46464646,
	0, 3, 1, 0x00001a38, 0xffffffff, 0x42444646,
	0, 3, 2, 0x00001ad8, 0xffffffff, 0x46464646,
	0, 3, 2, 0x00001adc, 0xffffffff, 0x42444646,
	0, 3, 0, 0x00001a3c, 0xffffffff, 0x46464646,
	0, 3, 0, 0x00001a40, 0xffffffff, 0x42444646,
	0, 3, 0, 0x00001a44, 0xffffffff, 0x46463840,
	0, 3, 1, 0x00001a48, 0xffffffff, 0x46464646,
	0, 3, 1, 0x00001a4c, 0xffffffff, 0x38404244,
	0, 3, 2, 0x00001ae0, 0xffffffff, 0x46464646,
	0, 3, 2, 0x00001ae4, 0xffffffff, 0x42444646,
	0, 3, 2, 0x00001ae8, 0x0000ffff, 0x38383840,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x46464646,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x44464646,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x46464646,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x42444646,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x46464646,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x42444646,
	1, 0, 2, 0x00000cd8, 0xffffffff, 0x46464646,
	1, 0, 2, 0x00000cdc, 0xffffffff, 0x42444646,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x46464646,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x42444646,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x46463840,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x46464646,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x38404244,
	1, 0, 2, 0x00000ce0, 0xffffffff, 0x46464646,
	1, 0, 2, 0x00000ce4, 0xffffffff, 0x42444646,
	1, 0, 2, 0x00000ce8, 0x0000ffff, 0x38383840,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x46464646,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x44464646,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x46464646,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x42444646,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x46464646,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x42444646,
	1, 1, 2, 0x00000ed8, 0xffffffff, 0x46464646,
	1, 1, 2, 0x00000edc, 0xffffffff, 0x42444646,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x46464646,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x42444646,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x46463840,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x46464646,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x38404244,
	1, 1, 2, 0x00000ee0, 0xffffffff, 0x46464646,
	1, 1, 2, 0x00000ee4, 0xffffffff, 0x42444646,
	1, 1, 2, 0x00000ee8, 0x0000ffff, 0x38383840,
	1, 2, 0, 0x00001824, 0xffffffff, 0x46464646,
	1, 2, 0, 0x00001828, 0xffffffff, 0x44464646,
	1, 2, 0, 0x0000182c, 0xffffffff, 0x46464646,
	1, 2, 0, 0x00001830, 0xffffffff, 0x42444646,
	1, 2, 1, 0x00001834, 0xffffffff, 0x46464646,
	1, 2, 1, 0x00001838, 0xffffffff, 0x42444646,
	1, 2, 2, 0x000018d8, 0xffffffff, 0x46464646,
	1, 2, 2, 0x000018dc, 0xffffffff, 0x42444646,
	1, 2, 0, 0x0000183c, 0xffffffff, 0x46464646,
	1, 2, 0, 0x00001840, 0xffffffff, 0x42444646,
	1, 2, 0, 0x00001844, 0xffffffff, 0x46463840,
	1, 2, 1, 0x00001848, 0xffffffff, 0x46464646,
	1, 2, 1, 0x0000184c, 0xffffffff, 0x38404244,
	1, 2, 2, 0x000018e0, 0xffffffff, 0x46464646,
	1, 2, 2, 0x000018e4, 0xffffffff, 0x42444646,
	1, 2, 2, 0x000018e8, 0x0000ffff, 0x38383840,
	1, 3, 0, 0x00001a24, 0xffffffff, 0x46464646,
	1, 3, 0, 0x00001a28, 0xffffffff, 0x44464646,
	1, 3, 0, 0x00001a2c, 0xffffffff, 0x46464646,
	1, 3, 0, 0x00001a30, 0xffffffff, 0x42444646,
	1, 3, 1, 0x00001a34, 0xffffffff, 0x46464646,
	1, 3, 1, 0x00001a38, 0xffffffff, 0x42444646,
	1, 3, 2, 0x00001ad8, 0xffffffff, 0x46464646,
	1, 3, 2, 0x00001adc, 0xffffffff, 0x42444646,
	1, 3, 0, 0x00001a3c, 0xffffffff, 0x46464646,
	1, 3, 0, 0x00001a40, 0xffffffff, 0x42444646,
	1, 3, 0, 0x00001a44, 0xffffffff, 0x46463840,
	1, 3, 1, 0x00001a48, 0xffffffff, 0x46464646,
	1, 3, 1, 0x00001a4c, 0xffffffff, 0x38404244,
	1, 3, 2, 0x00001ae0, 0xffffffff, 0x46464646,
	1, 3, 2, 0x00001ae4, 0xffffffff, 0x42444646,
	1, 3, 2, 0x00001ae8, 0x0000ffff, 0x38383840
};

void
ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type3(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_PHY_REG_PG_Type3)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_PHY_REG_PG_Type3;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrByRate = ArrayLen/6;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type3\n"));

	pDM_Odm->PhyRegPgVersion = 1;
	pDM_Odm->PhyRegPgValueType = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < ArrayLen; i += 6) {
		u4Byte v1 = Array[i];
		u4Byte v2 = Array[i+1];
		u4Byte v3 = Array[i+2];
		u4Byte v4 = Array[i+3];
		u4Byte v5 = Array[i+4];
		u4Byte v6 = Array[i+5];

	    odm_ConfigBB_PHY_REG_PG_8814A(pDM_Odm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)pHalData->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}



/******************************************************************************
*                           PHY_REG_PG_Type4.TXT
******************************************************************************/

u4Byte Array_MP_8814A_PHY_REG_PG_Type4[] = { 
	0, 0, 0, 0x00000c20, 0xffffffff, 0x42424242,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x42424242,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x36384042,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x42424242,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x34363840,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x42424242,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x34363840,
	0, 0, 2, 0x00000cd8, 0xffffffff, 0x42424242,
	0, 0, 2, 0x00000cdc, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x42424242,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x42423032,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x38404242,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x30323436,
	0, 0, 2, 0x00000ce0, 0xffffffff, 0x42424242,
	0, 0, 2, 0x00000ce4, 0xffffffff, 0x34363840,
	0, 0, 2, 0x00000ce8, 0x0000ffff, 0x30303032,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x42424242,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x42424242,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x36384042,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x42424242,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x34363840,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x42424242,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x34363840,
	0, 1, 2, 0x00000ed8, 0xffffffff, 0x42424242,
	0, 1, 2, 0x00000edc, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x42424242,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x42423032,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x38404242,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x30323436,
	0, 1, 2, 0x00000ee0, 0xffffffff, 0x42424242,
	0, 1, 2, 0x00000ee4, 0xffffffff, 0x34363840,
	0, 1, 2, 0x00000ee8, 0x0000ffff, 0x30303032,
	0, 2, 0, 0x00001820, 0xffffffff, 0x42424242,
	0, 2, 0, 0x00001824, 0xffffffff, 0x42424242,
	0, 2, 0, 0x00001828, 0xffffffff, 0x36384042,
	0, 2, 0, 0x0000182c, 0xffffffff, 0x42424242,
	0, 2, 0, 0x00001830, 0xffffffff, 0x34363840,
	0, 2, 1, 0x00001834, 0xffffffff, 0x42424242,
	0, 2, 1, 0x00001838, 0xffffffff, 0x34363840,
	0, 2, 2, 0x000018d8, 0xffffffff, 0x42424242,
	0, 2, 2, 0x000018dc, 0xffffffff, 0x34363840,
	0, 2, 0, 0x0000183c, 0xffffffff, 0x42424242,
	0, 2, 0, 0x00001840, 0xffffffff, 0x34363840,
	0, 2, 0, 0x00001844, 0xffffffff, 0x42423032,
	0, 2, 1, 0x00001848, 0xffffffff, 0x38404242,
	0, 2, 1, 0x0000184c, 0xffffffff, 0x30323436,
	0, 2, 2, 0x000018e0, 0xffffffff, 0x42424242,
	0, 2, 2, 0x000018e4, 0xffffffff, 0x34363840,
	0, 2, 2, 0x000018e8, 0x0000ffff, 0x30303032,
	0, 3, 0, 0x00001a20, 0xffffffff, 0x42424242,
	0, 3, 0, 0x00001a24, 0xffffffff, 0x42424242,
	0, 3, 0, 0x00001a28, 0xffffffff, 0x36384042,
	0, 3, 0, 0x00001a2c, 0xffffffff, 0x42424242,
	0, 3, 0, 0x00001a30, 0xffffffff, 0x34363840,
	0, 3, 1, 0x00001a34, 0xffffffff, 0x42424242,
	0, 3, 1, 0x00001a38, 0xffffffff, 0x34363840,
	0, 3, 2, 0x00001ad8, 0xffffffff, 0x42424242,
	0, 3, 2, 0x00001adc, 0xffffffff, 0x34363840,
	0, 3, 0, 0x00001a3c, 0xffffffff, 0x42424242,
	0, 3, 0, 0x00001a40, 0xffffffff, 0x34363840,
	0, 3, 0, 0x00001a44, 0xffffffff, 0x42423032,
	0, 3, 1, 0x00001a48, 0xffffffff, 0x38404242,
	0, 3, 1, 0x00001a4c, 0xffffffff, 0x30323436,
	0, 3, 2, 0x00001ae0, 0xffffffff, 0x42424242,
	0, 3, 2, 0x00001ae4, 0xffffffff, 0x34363840,
	0, 3, 2, 0x00001ae8, 0x0000ffff, 0x30303032,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x42424242,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x36384042,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x42424242,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x34363840,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x42424242,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x34363840,
	1, 0, 2, 0x00000cd8, 0xffffffff, 0x42424242,
	1, 0, 2, 0x00000cdc, 0xffffffff, 0x34363840,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x42424242,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x34363840,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x42423032,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x38404242,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x30323436,
	1, 0, 2, 0x00000ce0, 0xffffffff, 0x42424242,
	1, 0, 2, 0x00000ce4, 0xffffffff, 0x34363840,
	1, 0, 2, 0x00000ce8, 0x0000ffff, 0x30303032,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x42424242,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x36384042,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x42424242,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x34363840,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x42424242,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x34363840,
	1, 1, 2, 0x00000ed8, 0xffffffff, 0x42424242,
	1, 1, 2, 0x00000edc, 0xffffffff, 0x34363840,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x42424242,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x34363840,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x42423032,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x38404242,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x30323436,
	1, 1, 2, 0x00000ee0, 0xffffffff, 0x42424242,
	1, 1, 2, 0x00000ee4, 0xffffffff, 0x34363840,
	1, 1, 2, 0x00000ee8, 0x0000ffff, 0x30303032,
	1, 2, 0, 0x00001824, 0xffffffff, 0x42424242,
	1, 2, 0, 0x00001828, 0xffffffff, 0x36384042,
	1, 2, 0, 0x0000182c, 0xffffffff, 0x42424242,
	1, 2, 0, 0x00001830, 0xffffffff, 0x34363840,
	1, 2, 1, 0x00001834, 0xffffffff, 0x42424242,
	1, 2, 1, 0x00001838, 0xffffffff, 0x34363840,
	1, 2, 2, 0x000018d8, 0xffffffff, 0x42424242,
	1, 2, 2, 0x000018dc, 0xffffffff, 0x34363840,
	1, 2, 0, 0x0000183c, 0xffffffff, 0x42424242,
	1, 2, 0, 0x00001840, 0xffffffff, 0x34363840,
	1, 2, 0, 0x00001844, 0xffffffff, 0x42423032,
	1, 2, 1, 0x00001848, 0xffffffff, 0x38404242,
	1, 2, 1, 0x0000184c, 0xffffffff, 0x30323436,
	1, 2, 2, 0x000018e0, 0xffffffff, 0x42424242,
	1, 2, 2, 0x000018e4, 0xffffffff, 0x34363840,
	1, 2, 2, 0x000018e8, 0x0000ffff, 0x30303032,
	1, 3, 0, 0x00001a24, 0xffffffff, 0x42424242,
	1, 3, 0, 0x00001a28, 0xffffffff, 0x36384042,
	1, 3, 0, 0x00001a2c, 0xffffffff, 0x42424242,
	1, 3, 0, 0x00001a30, 0xffffffff, 0x34363840,
	1, 3, 1, 0x00001a34, 0xffffffff, 0x42424242,
	1, 3, 1, 0x00001a38, 0xffffffff, 0x34363840,
	1, 3, 2, 0x00001ad8, 0xffffffff, 0x42424242,
	1, 3, 2, 0x00001adc, 0xffffffff, 0x34363840,
	1, 3, 0, 0x00001a3c, 0xffffffff, 0x42424242,
	1, 3, 0, 0x00001a40, 0xffffffff, 0x34363840,
	1, 3, 0, 0x00001a44, 0xffffffff, 0x42423032,
	1, 3, 1, 0x00001a48, 0xffffffff, 0x38404242,
	1, 3, 1, 0x00001a4c, 0xffffffff, 0x30323436,
	1, 3, 2, 0x00001ae0, 0xffffffff, 0x42424242,
	1, 3, 2, 0x00001ae4, 0xffffffff, 0x34363840,
	1, 3, 2, 0x00001ae8, 0x0000ffff, 0x30303032
};

void
ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type4(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_PHY_REG_PG_Type4)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_PHY_REG_PG_Type4;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrByRate = ArrayLen/6;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type4\n"));

	pDM_Odm->PhyRegPgVersion = 1;
	pDM_Odm->PhyRegPgValueType = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < ArrayLen; i += 6) {
		u4Byte v1 = Array[i];
		u4Byte v2 = Array[i+1];
		u4Byte v3 = Array[i+2];
		u4Byte v4 = Array[i+3];
		u4Byte v5 = Array[i+4];
		u4Byte v6 = Array[i+5];

	    odm_ConfigBB_PHY_REG_PG_8814A(pDM_Odm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)pHalData->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}



/******************************************************************************
*                           PHY_REG_PG_Type5.TXT
******************************************************************************/

u4Byte Array_MP_8814A_PHY_REG_PG_Type5[] = { 
	0, 0, 0, 0x00000c20, 0xffffffff, 0x48484848,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x42444646,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x44444444,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x40424444,
	0, 0, 2, 0x00000cd8, 0xffffffff, 0x42424242,
	0, 0, 2, 0x00000cdc, 0xffffffff, 0x38404242,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x42444646,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x44444040,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x44444444,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x38384042,
	0, 0, 2, 0x00000ce0, 0xffffffff, 0x42424242,
	0, 0, 2, 0x00000ce4, 0xffffffff, 0x38404242,
	0, 0, 2, 0x00000ce8, 0x0000ffff, 0x20203636,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x48484848,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x46464646,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x44464646,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x46464646,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x42444646,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x44444444,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x40424444,
	0, 1, 2, 0x00000ed8, 0xffffffff, 0x42424242,
	0, 1, 2, 0x00000edc, 0xffffffff, 0x38404242,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x46464646,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x42444646,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x44444040,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x44444444,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x38384042,
	0, 1, 2, 0x00000ee0, 0xffffffff, 0x42424242,
	0, 1, 2, 0x00000ee4, 0xffffffff, 0x38404242,
	0, 1, 2, 0x00000ee8, 0x0000ffff, 0x20203636,
	0, 2, 0, 0x00001820, 0xffffffff, 0x48484848,
	0, 2, 0, 0x00001824, 0xffffffff, 0x46464646,
	0, 2, 0, 0x00001828, 0xffffffff, 0x44464646,
	0, 2, 0, 0x0000182c, 0xffffffff, 0x46464646,
	0, 2, 0, 0x00001830, 0xffffffff, 0x42444646,
	0, 2, 1, 0x00001834, 0xffffffff, 0x44444444,
	0, 2, 1, 0x00001838, 0xffffffff, 0x40424444,
	0, 2, 2, 0x000018d8, 0xffffffff, 0x42424242,
	0, 2, 2, 0x000018dc, 0xffffffff, 0x38404242,
	0, 2, 0, 0x0000183c, 0xffffffff, 0x46464646,
	0, 2, 0, 0x00001840, 0xffffffff, 0x42444646,
	0, 2, 0, 0x00001844, 0xffffffff, 0x44444040,
	0, 2, 1, 0x00001848, 0xffffffff, 0x44444444,
	0, 2, 1, 0x0000184c, 0xffffffff, 0x38384042,
	0, 2, 2, 0x000018e0, 0xffffffff, 0x42424242,
	0, 2, 2, 0x000018e4, 0xffffffff, 0x38404242,
	0, 2, 2, 0x000018e8, 0x0000ffff, 0x20203636,
	0, 3, 0, 0x00001a20, 0xffffffff, 0x48484848,
	0, 3, 0, 0x00001a24, 0xffffffff, 0x46464646,
	0, 3, 0, 0x00001a28, 0xffffffff, 0x44464646,
	0, 3, 0, 0x00001a2c, 0xffffffff, 0x46464646,
	0, 3, 0, 0x00001a30, 0xffffffff, 0x42444646,
	0, 3, 1, 0x00001a34, 0xffffffff, 0x44444444,
	0, 3, 1, 0x00001a38, 0xffffffff, 0x40424444,
	0, 3, 2, 0x00001ad8, 0xffffffff, 0x42424242,
	0, 3, 2, 0x00001adc, 0xffffffff, 0x38404242,
	0, 3, 0, 0x00001a3c, 0xffffffff, 0x46464646,
	0, 3, 0, 0x00001a40, 0xffffffff, 0x42444646,
	0, 3, 0, 0x00001a44, 0xffffffff, 0x44444040,
	0, 3, 1, 0x00001a48, 0xffffffff, 0x44444444,
	0, 3, 1, 0x00001a4c, 0xffffffff, 0x38384042,
	0, 3, 2, 0x00001ae0, 0xffffffff, 0x42424242,
	0, 3, 2, 0x00001ae4, 0xffffffff, 0x38404242,
	0, 3, 2, 0x00001ae8, 0x0000ffff, 0x20203636,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x46464646,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x44464646,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x46464646,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x42444646,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x44444444,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x40424444,
	1, 0, 2, 0x00000cd8, 0xffffffff, 0x42424242,
	1, 0, 2, 0x00000cdc, 0xffffffff, 0x38404242,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x46464646,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x42444646,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x44443840,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x44444444,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x36384042,
	1, 0, 2, 0x00000ce0, 0xffffffff, 0x42424242,
	1, 0, 2, 0x00000ce4, 0xffffffff, 0x38404242,
	1, 0, 2, 0x00000ce8, 0x0000ffff, 0x20203436,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x46464646,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x44464646,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x46464646,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x42444646,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x44444444,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x40424444,
	1, 1, 2, 0x00000ed8, 0xffffffff, 0x42424242,
	1, 1, 2, 0x00000edc, 0xffffffff, 0x38404242,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x46464646,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x42444646,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x44443840,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x44444444,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x36384042,
	1, 1, 2, 0x00000ee0, 0xffffffff, 0x42424242,
	1, 1, 2, 0x00000ee4, 0xffffffff, 0x38404242,
	1, 1, 2, 0x00000ee8, 0x0000ffff, 0x20203436,
	1, 2, 0, 0x00001824, 0xffffffff, 0x46464646,
	1, 2, 0, 0x00001828, 0xffffffff, 0x44464646,
	1, 2, 0, 0x0000182c, 0xffffffff, 0x46464646,
	1, 2, 0, 0x00001830, 0xffffffff, 0x42444646,
	1, 2, 1, 0x00001834, 0xffffffff, 0x44444444,
	1, 2, 1, 0x00001838, 0xffffffff, 0x40424444,
	1, 2, 2, 0x000018d8, 0xffffffff, 0x42424242,
	1, 2, 2, 0x000018dc, 0xffffffff, 0x38404242,
	1, 2, 0, 0x0000183c, 0xffffffff, 0x46464646,
	1, 2, 0, 0x00001840, 0xffffffff, 0x42444646,
	1, 2, 0, 0x00001844, 0xffffffff, 0x44443840,
	1, 2, 1, 0x00001848, 0xffffffff, 0x44444444,
	1, 2, 1, 0x0000184c, 0xffffffff, 0x36384042,
	1, 2, 2, 0x000018e0, 0xffffffff, 0x42424242,
	1, 2, 2, 0x000018e4, 0xffffffff, 0x38404242,
	1, 2, 2, 0x000018e8, 0x0000ffff, 0x20203436,
	1, 3, 0, 0x00001a24, 0xffffffff, 0x46464646,
	1, 3, 0, 0x00001a28, 0xffffffff, 0x44464646,
	1, 3, 0, 0x00001a2c, 0xffffffff, 0x46464646,
	1, 3, 0, 0x00001a30, 0xffffffff, 0x42444646,
	1, 3, 1, 0x00001a34, 0xffffffff, 0x44444444,
	1, 3, 1, 0x00001a38, 0xffffffff, 0x40424444,
	1, 3, 2, 0x00001ad8, 0xffffffff, 0x42424242,
	1, 3, 2, 0x00001adc, 0xffffffff, 0x38404242,
	1, 3, 0, 0x00001a3c, 0xffffffff, 0x46464646,
	1, 3, 0, 0x00001a40, 0xffffffff, 0x42444646,
	1, 3, 0, 0x00001a44, 0xffffffff, 0x44443840,
	1, 3, 1, 0x00001a48, 0xffffffff, 0x44444444,
	1, 3, 1, 0x00001a4c, 0xffffffff, 0x36384042,
	1, 3, 2, 0x00001ae0, 0xffffffff, 0x42424242,
	1, 3, 2, 0x00001ae4, 0xffffffff, 0x38404242,
	1, 3, 2, 0x00001ae8, 0x0000ffff, 0x20203436
};

void
ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type5(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_PHY_REG_PG_Type5)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_PHY_REG_PG_Type5;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrByRate = ArrayLen/6;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type5\n"));

	pDM_Odm->PhyRegPgVersion = 1;
	pDM_Odm->PhyRegPgValueType = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < ArrayLen; i += 6) {
		u4Byte v1 = Array[i];
		u4Byte v2 = Array[i+1];
		u4Byte v3 = Array[i+2];
		u4Byte v4 = Array[i+3];
		u4Byte v5 = Array[i+4];
		u4Byte v6 = Array[i+5];

	    odm_ConfigBB_PHY_REG_PG_8814A(pDM_Odm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)pHalData->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}



/******************************************************************************
*                           PHY_REG_PG_Type7.TXT
******************************************************************************/

u4Byte Array_MP_8814A_PHY_REG_PG_Type7[] = { 
	0, 0, 0, 0x00000c20, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x30323434,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x28303234,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x34343434,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x28303234,
	0, 0, 2, 0x00000cd8, 0xffffffff, 0x34343434,
	0, 0, 2, 0x00000cdc, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x34342426,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x32343434,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x24262830,
	0, 0, 2, 0x00000ce0, 0xffffffff, 0x34343434,
	0, 0, 2, 0x00000ce4, 0xffffffff, 0x28303234,
	0, 0, 2, 0x00000ce8, 0x0000ffff, 0x24263434,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x30323434,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x28303234,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x34343434,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x28303234,
	0, 1, 2, 0x00000ed8, 0xffffffff, 0x34343434,
	0, 1, 2, 0x00000edc, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x34342426,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x32343434,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x24262830,
	0, 1, 2, 0x00000ee0, 0xffffffff, 0x34343434,
	0, 1, 2, 0x00000ee4, 0xffffffff, 0x28303234,
	0, 1, 2, 0x00000ee8, 0x0000ffff, 0x24263434,
	0, 2, 0, 0x00001820, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001824, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001828, 0xffffffff, 0x30323434,
	0, 2, 0, 0x0000182c, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001830, 0xffffffff, 0x28303234,
	0, 2, 1, 0x00001834, 0xffffffff, 0x34343434,
	0, 2, 1, 0x00001838, 0xffffffff, 0x28303234,
	0, 2, 2, 0x000018d8, 0xffffffff, 0x34343434,
	0, 2, 2, 0x000018dc, 0xffffffff, 0x28303234,
	0, 2, 0, 0x0000183c, 0xffffffff, 0x34343434,
	0, 2, 0, 0x00001840, 0xffffffff, 0x28303234,
	0, 2, 0, 0x00001844, 0xffffffff, 0x34342426,
	0, 2, 1, 0x00001848, 0xffffffff, 0x32343434,
	0, 2, 1, 0x0000184c, 0xffffffff, 0x24262830,
	0, 2, 2, 0x000018e0, 0xffffffff, 0x34343434,
	0, 2, 2, 0x000018e4, 0xffffffff, 0x28303234,
	0, 2, 2, 0x000018e8, 0x0000ffff, 0x24263434,
	0, 3, 0, 0x00001a20, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a24, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a28, 0xffffffff, 0x30323434,
	0, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a30, 0xffffffff, 0x28303234,
	0, 3, 1, 0x00001a34, 0xffffffff, 0x34343434,
	0, 3, 1, 0x00001a38, 0xffffffff, 0x28303234,
	0, 3, 2, 0x00001ad8, 0xffffffff, 0x34343434,
	0, 3, 2, 0x00001adc, 0xffffffff, 0x28303234,
	0, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434,
	0, 3, 0, 0x00001a40, 0xffffffff, 0x28303234,
	0, 3, 0, 0x00001a44, 0xffffffff, 0x34342426,
	0, 3, 1, 0x00001a48, 0xffffffff, 0x32343434,
	0, 3, 1, 0x00001a4c, 0xffffffff, 0x24262830,
	0, 3, 2, 0x00001ae0, 0xffffffff, 0x34343434,
	0, 3, 2, 0x00001ae4, 0xffffffff, 0x28303234,
	0, 3, 2, 0x00001ae8, 0x0000ffff, 0x24263434,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x34343434,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x30323434,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x34343434,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x28303234,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x34343434,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x28303234,
	1, 0, 2, 0x00000cd8, 0xffffffff, 0x34343434,
	1, 0, 2, 0x00000cdc, 0xffffffff, 0x28303234,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x34343434,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x28303234,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x34342426,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x32343434,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x24262830,
	1, 0, 2, 0x00000ce0, 0xffffffff, 0x34343434,
	1, 0, 2, 0x00000ce4, 0xffffffff, 0x28303234,
	1, 0, 2, 0x00000ce8, 0x0000ffff, 0x24263434,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x34343434,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x30323434,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x34343434,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x28303234,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x34343434,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x28303234,
	1, 1, 2, 0x00000ed8, 0xffffffff, 0x34343434,
	1, 1, 2, 0x00000edc, 0xffffffff, 0x28303234,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x34343434,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x28303234,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x34342426,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x32343434,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x24262830,
	1, 1, 2, 0x00000ee0, 0xffffffff, 0x34343434,
	1, 1, 2, 0x00000ee4, 0xffffffff, 0x28303234,
	1, 1, 2, 0x00000ee8, 0x0000ffff, 0x24263434,
	1, 2, 0, 0x00001824, 0xffffffff, 0x34343434,
	1, 2, 0, 0x00001828, 0xffffffff, 0x30323434,
	1, 2, 0, 0x0000182c, 0xffffffff, 0x34343434,
	1, 2, 0, 0x00001830, 0xffffffff, 0x28303234,
	1, 2, 1, 0x00001834, 0xffffffff, 0x34343434,
	1, 2, 1, 0x00001838, 0xffffffff, 0x28303234,
	1, 2, 2, 0x000018d8, 0xffffffff, 0x34343434,
	1, 2, 2, 0x000018dc, 0xffffffff, 0x28303234,
	1, 2, 0, 0x0000183c, 0xffffffff, 0x34343434,
	1, 2, 0, 0x00001840, 0xffffffff, 0x28303234,
	1, 2, 0, 0x00001844, 0xffffffff, 0x34342426,
	1, 2, 1, 0x00001848, 0xffffffff, 0x32343434,
	1, 2, 1, 0x0000184c, 0xffffffff, 0x24262830,
	1, 2, 2, 0x000018e0, 0xffffffff, 0x34343434,
	1, 2, 2, 0x000018e4, 0xffffffff, 0x28303234,
	1, 2, 2, 0x000018e8, 0x0000ffff, 0x24263434,
	1, 3, 0, 0x00001a24, 0xffffffff, 0x34343434,
	1, 3, 0, 0x00001a28, 0xffffffff, 0x30323434,
	1, 3, 0, 0x00001a2c, 0xffffffff, 0x34343434,
	1, 3, 0, 0x00001a30, 0xffffffff, 0x28303234,
	1, 3, 1, 0x00001a34, 0xffffffff, 0x34343434,
	1, 3, 1, 0x00001a38, 0xffffffff, 0x28303234,
	1, 3, 2, 0x00001ad8, 0xffffffff, 0x34343434,
	1, 3, 2, 0x00001adc, 0xffffffff, 0x28303234,
	1, 3, 0, 0x00001a3c, 0xffffffff, 0x34343434,
	1, 3, 0, 0x00001a40, 0xffffffff, 0x28303234,
	1, 3, 0, 0x00001a44, 0xffffffff, 0x34342426,
	1, 3, 1, 0x00001a48, 0xffffffff, 0x32343434,
	1, 3, 1, 0x00001a4c, 0xffffffff, 0x24262830,
	1, 3, 2, 0x00001ae0, 0xffffffff, 0x34343434,
	1, 3, 2, 0x00001ae4, 0xffffffff, 0x28303234,
	1, 3, 2, 0x00001ae8, 0x0000ffff, 0x24263434
};

void
ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type7(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_PHY_REG_PG_Type7)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_PHY_REG_PG_Type7;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrByRate = ArrayLen/6;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_PHY_REG_PG_Type7\n"));

	pDM_Odm->PhyRegPgVersion = 1;
	pDM_Odm->PhyRegPgValueType = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < ArrayLen; i += 6) {
		u4Byte v1 = Array[i];
		u4Byte v2 = Array[i+1];
		u4Byte v3 = Array[i+2];
		u4Byte v4 = Array[i+3];
		u4Byte v5 = Array[i+4];
		u4Byte v6 = Array[i+5];

	    odm_ConfigBB_PHY_REG_PG_8814A(pDM_Odm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)pHalData->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}



#endif /* end of HWIMG_SUPPORT*/

