/*
** Copyright (c) 2010 Silicon Laboratories, Inc.
** 2010-06-21 16:44:49
**
** Si3217x SiVoice API Configuration Tool Version 2.1L
*/


#ifndef SI3217X_CONSTANTS_H
#define SI3217X_CONSTANTS_H

/** Ringing Presets */
#ifdef REALTEK_PATCH_FOR_SILAB
enum {
	RING_20Hz_38VRMS_0VDC_BAL_600ohmCPE,
	RING_20Hz_45VRMS_0VDC_BAL_600ohmCPE,
	RING_20Hz_48VRMS_0VDC_BAL_600ohmCPE,
	RING_25Hz_48VRMS_0VDC_BAL_600ohmCPE,
	RING_17Hz_50VRMS_0VDC_BAL_600ohmCPE,
	RING_20Hz_40VRMS_0VDC_BAL_600ohmCPE
};
#else
enum {
	RING_MAX_VBAT_PROVISIONING,
	RING_F20_45VRMS_0VDC_LPR,
	RING_F20_45VRMS_0VDC_BAL
};
#endif

/** DC_Feed Presets */
enum {
	DCFEED_48V_20MA,
	DCFEED_48V_25MA,
	DCFEED_PSTN_DET_1,
	DCFEED_PSTN_DET_2
};

/** Impedance Presets */
#ifdef REALTEK_PATCH_FOR_SILAB
enum {
	ZSYN_600_0_0,
	ZSYN_900_0_0,
	ZSYN_600_INF_1000,
	ZSYN_200_560_100,
	ZSYN_200_680_100,
	ZSYN_270_750_150,
	ZSYN_220_820_120,
	ZSYN_220_820_115,
	ZSYN_400_700_200,
	ZSYN_200_1000_100,
	ZSYN_150_830_72,
	ZSYN_215_1000_137,
	ZSYN_300_1000_220,
	ZSYN_900_INF_2160,
	ZSYN_250_750_150,
	ZSYN_320_1150_230,
	ZSYN_350_1000_210
};
#else
enum {
	ZSYN_600_0_0_30_0,
	ZSYN_270_750_150_30_0,
	ZSYN_370_620_310_30_0,
	ZSYN_220_820_120_30_0,
	ZSYN_600_0_1000_30_0,
	ZSYN_200_680_100_30_0,
	ZSYN_220_820_115_30_0
};
#endif

/** FSK Presets */
enum {
	DEFAULT_FSK
};

/** Pulse_Metering Presets */
enum {
	DEFAULT_PULSE_METERING
};

/** Tone Presets */
enum {
	TONEGEN_FCC_DIAL,
	TONEGEN_FCC_BUSY,
	TONEGEN_FCC_RINGBACK,
	TONEGEN_FCC_REORDER,
	TONEGEN_FCC_CONGESTION
};

/** PCM Presets */
enum {
	PCM_8ULAW,
	PCM_8ALAW,
	PCM_16LIN,
	PCM_16LIN_WB
};

/** Multiple BOM General Param */
enum {
	GEN_PARAM_FLYBACK,
	GEN_PARAM_BUCK_BOOST
};



#endif

