/*
** Copyright (c) 2012 Silicon Laboratories, Inc.
** 2013-02-05 07:47:17
**
** Si3217x ProSLIC API Configuration Tool Version 3.0.0
*/


#include "proslic.h"
#include "si3217x.h"

Si3217x_General_Cfg Si3217x_General_Configuration  = {
0x73,                       /* DEVICE_KEY */
BO_DCDC_FLYBACK,            /* BOM_OPT */
BO_GDRV_NOT_INSTALLED,      /* GDRV_OPTION */
VDC_7P0_20P0,               /* VDC_RANGE_OPT */
VDAA_ENABLED,               /* DAA_ENABLE */
AUTO_ZCAL_ENABLED,          /* ZCAL_ENABLE */
BO_STD_BOM,                 /* PM_BOM */
1100L,                      /* I_OITHRESH (1100mA) */
900L,                       /* I_OITHRESH_LO (900mA) */
1700L,                      /* I_OITHRESH_HI (1700mA) */
136000L,                    /* V_OVTHRESH (136000mV) */
5000L,                      /* V_UVTHRESH (5000mV) */
1000L,                      /* V_UVHYST (1000mV) */
0x00000000L,                /* DCDC_FSW_VTHLO */
0x00000000L,                /* DCDC_FSW_VHYST */
0x0048D15BL,                /* P_TH_HVIC */
0x07FEB800L,                /* COEF_P_HVIC */
0x00083120L,                /* BAT_HYST */
0x03D70A20L,                /* VBATH_EXPECT (60.00V) */
0x070A3D3AL,                /* VBATR_EXPECT (110.00V) */
0x0FFF0000L,                /* PWRSAVE_TIMER */
0x01999A00L,                /* OFFHOOK_THRESH */
0x00F00000L,                /* VBAT_TRACK_MIN */
0x00F00000L,                /* VBAT_TRACK_MIN_RNG */
0x00200000L,                /* DCDC_FSW_NORM */
0x00200000L,                /* DCDC_FSW_NORM_LO */
0x00200000L,                /* DCDC_FSW_RINGING */
0x00200000L,                /* DCDC_FSW_RINGING_LO */
0x0D980000L,                /* DCDC_DIN_LIM */
0x00C00000L,                /* DCDC_VOUT_LIM */
0x0ADD5500L,                /* DCDC_ANA_SCALE */
0x00800000L,                /* THERM_DBI */
0x00FFFFFFL,                /* VOV_DCDC_SLOPE */
0x00A18937L,                /* VOV_DCDC_OS */
0x00A18937L,                /* VOV_RING_BAT_DCDC */
0x00E49BA5L,                /* VOV_RING_BAT_MAX */
0x01018900L,                /* DCDC_VERR */
0x0080C480L,                /* DCDC_VERR_HYST */
0x00400000L,                /* PD_UVLO */
0x00400000L,                /* PD_OVLO */
0x00200000L,                /* PD_OCLO */
0x00400000L,                /* PD_SWDRV */
0x00000000L,                /* DCDC_UVPOL */
0x00200000L,                /* DCDC_RNGTYPE */
0x00300000L,                /* DCDC_ANA_TOFF */
0x00100000L,                /* DCDC_ANA_TONMIN */
0x00FFC000L,                /* DCDC_ANA_TONMAX */
0x00,                       /* IRQEN1 */
0x00,                       /* IRQEN */
0x03,                       /* IRQEN3 */
0x00,                       /* IRQEN4 */
0x30,                       /* ENHANCE */
0x01,                       /* DAA_CNTL */
0x3F,                       /* AUTO */
};

Si3217x_GPIO_Cfg Si3217x_GPIO_Configuration = {
0x00,     /* GPIO_OE */
0x06,     /* GPIO_ANA */
0x00,     /* GPIO_DIR */
0x00,     /* GPIO_MAN */
0x00,     /* GPIO_POL */
0x00,     /* GPIO_OD */
0x00     /* BATSELMAP */
};
Si3217x_CI_Cfg Si3217x_CI_Presets [] = {
{0}
};
Si3217x_audioGain_Cfg Si3217x_audioGain_Presets [] = {
{0x1377080L,0, 0x0L, 0x0L, 0x0L, 0x0L},
{0x80C3180L,0, 0x0L, 0x0L, 0x0L, 0x0L}
};

#ifdef REALTEK_PATCH_FOR_SILAB

Si3217x_Ring_Cfg Si3217x_Ring_Presets[] ={
{
/*
	Loop = 500 ft @ 0.044 ohms/ft, REN = 5, Rcpe = 600 ohms
	Rprot = 30 ohms, Type = BALANCED, Waveform = SINE
*/ 
0x00050000L,	/* RTPER */
0x07EFE000L,	/* RINGFR (20.000 Hz) */
0x00175338L,	/* RINGAMP (38.000 vrms)  */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00D16348L,	/* IRING_LIM (90.000 mA) */
0x005897D6L,	/* RTACTH (48.924 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00006000L,	/* RTACDB (75.000 ms) */
0x00006000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x04A259CBL,	/* VBATR_EXPECT (72.409 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00051EB8L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x58,			/* RINGCON */
0x00,			/* USERSTAT */
0x02512CE5L,	/* VCM_RING (33.205 v) */
0x02512CE5L,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},  /* 20Hz_38VRMS_0VDC_BAL_600ohmCPE */
{
/*
	Loop = 500 ft @ 0.044 ohms/ft, REN = 5, Rcpe = 600 ohms
	Rprot = 30 ohms, Type = BALANCED, Waveform = SINE
*/ 
0x00050000L,	/* RTPER */
0x07EFE000L,	/* RINGFR (20.000 Hz) */
0x001B9F2EL,	/* RINGAMP (45.000 vrms)  */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00D16348L,	/* IRING_LIM (90.000 mA) */
0x0068E9B4L,	/* RTACTH (57.936 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00006000L,	/* RTACDB (75.000 ms) */
0x00006000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x0558ABFCL,	/* VBATR_EXPECT (83.537 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00051EB8L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x58,			/* RINGCON */
0x00,			/* USERSTAT */
0x02AC55FEL,	/* VCM_RING (38.769 v) */
0x02AC55FEL,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},  /* 20Hz_45VRMS_0VDC_BAL_600ohmCPE */
{
/*
	Loop = 500 ft @ 0.044 ohms/ft, REN = 5, Rcpe = 600 ohms
	Rprot = 30 ohms, Type = BALANCED, Waveform = SINE
*/ 
0x00050000L,	/* RTPER */
0x07EFE000L,	/* RINGFR (20.000 Hz) */
0x001D7698L,	/* RINGAMP (48.000 vrms)  */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00D16348L,	/* IRING_LIM (90.000 mA) */
0x006FE837L,	/* RTACTH (61.799 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00006000L,	/* RTACDB (75.000 ms) */
0x00006000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x05A6CF35L,	/* VBATR_EXPECT (88.306 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00051EB8L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x58,			/* RINGCON */
0x00,			/* USERSTAT */
0x02D3679AL,	/* VCM_RING (41.153 v) */
0x02D3679AL,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},  /* 20Hz_48VRMS_0VDC_BAL_600ohmCPE */
{
/*
	Loop = 500 ft @ 0.044 ohms/ft, REN = 5, Rcpe = 600 ohms
	Rprot = 30 ohms, Type = BALANCED, Waveform = SINE
*/ 
0x00040000L,	/* RTPER */
0x07E6C000L,	/* RINGFR (25.000 Hz) */
0x0024DF0DL,	/* RINGAMP (48.000 vrms)  */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00D16348L,	/* IRING_LIM (90.000 mA) */
0x0059D242L,	/* RTACTH (62.003 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00008000L,	/* RTACDB (75.000 ms) */
0x00008000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x05A75077L,	/* VBATR_EXPECT (88.337 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00066666L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x58,			/* RINGCON */
0x00,			/* USERSTAT */
0x02D3A83BL,	/* VCM_RING (41.169 v) */
0x02D3A83BL,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},  /* 25Hz_48VRMS_0VDC_BAL_600ohmCPE */
{
/*
	Loop = 500 ft @ 0.044 ohms/ft, REN = 5, Rcpe = 600 ohms
	Rprot = 30 ohms, Type = BALANCED, Waveform = SINE
*/ 
0x0005E000L,	/* RTPER */
0x07F46000L,	/* RINGFR (17.000 Hz) */
0x001A110DL,	/* RINGAMP (50.000 vrms)  */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00D16348L,	/* IRING_LIM (90.000 mA) */
0x00887E15L,	/* RTACTH (64.150 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00006000L,	/* RTACDB (75.000 ms) */
0x00006000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x05DA58A6L,	/* VBATR_EXPECT (91.452 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00045A1CL,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x58,			/* RINGCON */
0x00,			/* USERSTAT */
0x02ED2C53L,	/* VCM_RING (42.726 v) */
0x02ED2C53L,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},  /* 17Hz_50VRMS_0VDC_BAL_600ohmCPE */
{
/*
	Loop = 500 ft @ 0.044 ohms/ft, REN = 5, Rcpe = 600 ohms
	Rprot = 30 ohms, Type = BALANCED, Waveform = SINE
*/ 
0x00050000L,	/* RTPER */
0x07EFE000L,	/* RINGFR (20.000 Hz) */
0x00188D7EL,	/* RINGAMP (40.000 vrms)  */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00D16348L,	/* IRING_LIM (90.000 mA) */
0x005D4183L,	/* RTACTH (51.499 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00006000L,	/* RTACDB (75.000 ms) */
0x00006000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x04D67147L,	/* VBATR_EXPECT (75.589 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00051EB8L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x58,			/* RINGCON */
0x00,			/* USERSTAT */
0x026B38A3L,	/* VCM_RING (34.794 v) */
0x026B38A3L,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
}    /* 20Hz_40VRMS_0VDC_BAL_600ohmCPE */
};

#else

Si3217x_Ring_Cfg Si3217x_Ring_Presets[] ={
{
/*
	Loop = 500.0 ft @ 0.044 ohms/ft, REN = 3, Rcpe = 600 ohms
	Rprot = 30 ohms, Type = LPR, Waveform = SINE
*/ 
0x00050000L,	/* RTPER */
0x07EFE000L,	/* RINGFR (20.000 Hz) */
0x0025D5BFL,	/* RINGAMP (64.490 vrms)  */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00D16348L,	/* IRING_LIM (90.000 mA) */
0x00608636L,	/* RTACTH (53.304 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00006000L,	/* RTACDB (75.000 ms) */
0x00006000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x070A0AA8L,	/* VBATR_EXPECT (109.988 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00051EB8L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x01,			/* USERSTAT */
0x03850554L,	/* VCM_RING (51.994 v) */
0x03850554L,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},  /* RING_MAX_VBAT_PROVISIONING */
{
/*
	Loop = 500.0 ft @ 0.044 ohms/ft, REN = 5, Rcpe = 600 ohms
	Rprot = 30 ohms, Type = LPR, Waveform = SINE
*/ 
0x00050000L,	/* RTPER */
0x07EFE000L,	/* RINGFR (20.000 Hz) */
0x001B9F2EL,	/* RINGAMP (45.000 vrms)  */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00D16348L,	/* IRING_LIM (90.000 mA) */
0x0068E9B4L,	/* RTACTH (57.936 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00006000L,	/* RTACDB (75.000 ms) */
0x00006000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x0558ABFCL,	/* VBATR_EXPECT (83.537 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00051EB8L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x01,			/* USERSTAT */
0x02AC55FEL,	/* VCM_RING (38.769 v) */
0x02AC55FEL,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
},  /* RING_F20_45VRMS_0VDC_LPR */
{
/*
	Loop = 500.0 ft @ 0.044 ohms/ft, REN = 5, Rcpe = 600 ohms
	Rprot = 30 ohms, Type = BALANCED, Waveform = SINE
*/ 
0x00050000L,	/* RTPER */
0x07EFE000L,	/* RINGFR (20.000 Hz) */
0x001B9F2EL,	/* RINGAMP (45.000 vrms)  */
0x00000000L,	/* RINGPHAS */
0x00000000L,	/* RINGOF (0.000 vdc) */
0x15E5200EL,	/* SLOPE_RING (100.000 ohms) */
0x00D16348L,	/* IRING_LIM (90.000 mA) */
0x0068E9B4L,	/* RTACTH (57.936 mA) */
0x0FFFFFFFL,	/* RTDCTH (450.000 mA) */
0x00006000L,	/* RTACDB (75.000 ms) */
0x00006000L,	/* RTDCDB (75.000 ms) */
0x00C49BA0L,	/* VOV_RING_BAT (12.000 v) */
0x00000000L,	/* VOV_RING_GND (0.000 v) */
0x0558ABFCL,	/* VBATR_EXPECT (83.537 v) */
0x80,			/* RINGTALO (2.000 s) */
0x3E,			/* RINGTAHI */
0x00,			/* RINGTILO (4.000 s) */
0x7D,			/* RINGTIHI */
0x00000000L,	/* ADAP_RING_MIN_I */
0x00003000L,	/* COUNTER_IRING_VAL */
0x00051EB8L,	/* COUNTER_VTR_VAL */
0x00000000L,	/* CONST_028 */
0x00000000L,	/* CONST_032 */
0x00000000L,	/* CONST_038 */
0x00000000L,	/* CONST_046 */
0x00000000L,	/* RRD_DELAY */
0x00000000L,	/* RRD_DELAY2 */
0x01893740L,	/* DCDC_VREF_MIN_RNG */
0x40,			/* RINGCON */
0x00,			/* USERSTAT */
0x02AC55FEL,	/* VCM_RING (38.769 v) */
0x02AC55FEL,	/* VCM_RING_FIXED */
0x003126E8L,	/* DELTA_VCM */
0x00200000L,	/* DCDC_RNGTYPE */
}    /* RING_F20_45VRMS_0VDC_BAL */
};
#endif

Si3217x_DCfeed_Cfg Si3217x_DCfeed_Presets[] = {
{
0x1C8A024CL,	/* SLOPE_VLIM */
0x1F909679L,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0x1D5B21A9L,	/* SLOPE_DELTA1 */
0x1DD87A3EL,	/* SLOPE_DELTA2 */
0x05A38633L,	/* V_VLIM (48.000 v) */
0x050D2839L,	/* V_RFEED (43.000 v) */
0x03FE7F0FL,	/* V_ILIM  (34.000 v) */
0x00B4F3C3L,	/* CONST_RFEED (15.000 mA) */
0x005D0FA6L,	/* CONST_ILIM (20.000 mA) */
0x002D8D96L,	/* I_VLIM (0.000 mA) */
#ifdef REALTEK_PATCH_FOR_SILAB		//THLin: for 20pps pulse dial det
0x00500000L,	/* LCRONHK (10.000 mA) */
0x00600000L,	/* LCROFFHK (12.000 mA) */
#else
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
#endif
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
},  /* DCFEED_48V_20MA */
{
0x1C8A024CL,	/* SLOPE_VLIM */
0x1EE08C11L,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0x1C940D71L,	/* SLOPE_DELTA1 */
0x1DD87A3EL,	/* SLOPE_DELTA2 */
0x05A38633L,	/* V_VLIM (48.000 v) */
0x050D2839L,	/* V_RFEED (43.000 v) */
0x03FE7F0FL,	/* V_ILIM  (34.000 v) */
0x01241BC9L,	/* CONST_RFEED (15.000 mA) */
0x0074538FL,	/* CONST_ILIM (25.000 mA) */
0x002D8D96L,	/* I_VLIM (0.000 mA) */
#ifdef REALTEK_PATCH_FOR_SILAB		//THLin: for 20pps pulse dial det
0x00500000L,	/* LCRONHK (10.000 mA) */
0x00600000L,	/* LCROFFHK (12.000 mA) */
#else
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
#endif
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
},  /* DCFEED_48V_25MA */
{
0x1E655196L,	/* SLOPE_VLIM */
0x001904EFL,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0x1B4CAD9EL,	/* SLOPE_DELTA1 */
0x1BB0F47CL,	/* SLOPE_DELTA2 */
0x05A38633L,	/* V_VLIM (48.000 v) */
0x043AA4A6L,	/* V_RFEED (36.000 v) */
0x025977EAL,	/* V_ILIM  (20.000 v) */
0x0068B19AL,	/* CONST_RFEED (18.000 mA) */
0x005D0FA6L,	/* CONST_ILIM (20.000 mA) */
0x002D8D96L,	/* I_VLIM (0.000 mA) */
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
},  /* DCFEED_PSTN_DET_1 */
{
0x1A10433FL,	/* SLOPE_VLIM */
0x1C206275L,	/* SLOPE_RFEED */
0x0040A0E0L,	/* SLOPE_ILIM */
0x1C1F426FL,	/* SLOPE_DELTA1 */
0x1EB51625L,	/* SLOPE_DELTA2 */
0x041C91DBL,	/* V_VLIM (35.000 v) */
0x03E06C43L,	/* V_RFEED (33.000 v) */
0x038633E0L,	/* V_ILIM  (30.000 v) */
0x022E5DE5L,	/* CONST_RFEED (10.000 mA) */
0x005D0FA6L,	/* CONST_ILIM (20.000 mA) */
0x0021373DL,	/* I_VLIM (0.000 mA) */
0x005B0AFBL,	/* LCRONHK (10.000 mA) */
0x006D4060L,	/* LCROFFHK (12.000 mA) */
0x00008000L,	/* LCRDBI (5.000 ms) */
0x0048D595L,	/* LONGHITH (8.000 mA) */
0x003FBAE2L,	/* LONGLOTH (7.000 mA) */
0x00008000L,	/* LONGDBI (5.000 ms) */
0x000F0000L,	/* LCRMASK (150.000 ms) */
0x00080000L,	/* LCRMASK_POLREV (80.000 ms) */
0x00140000L,	/* LCRMASK_STATE (200.000 ms) */
0x00140000L,	/* LCRMASK_LINECAP (200.000 ms) */
0x01BA5E35L,	/* VCM_OH (27.000 v) */
0x0051EB85L,	/* VOV_BAT (5.000 v) */
0x00418937L,	/* VOV_GND (4.000 v) */
}    /* DCFEED_PSTN_DET_2 */
};

#ifdef REALTEK_PATCH_FOR_SILAB

Si3217x_Impedance_Cfg Si3217x_Impedance_Presets[] ={
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=600_0_0 rprot=30 rfuse=0 emi_cap=10*/
{
{0x07F46C00L, 0x000E4600L, 0x00008580L, 0x1FFD6100L,    /* TXACEQ */
 0x07EF5000L, 0x0013F580L, 0x1FFDE000L, 0x1FFCB280L},   /* RXACEQ */
{0x0027CB00L, 0x1F8A8880L, 0x02801180L, 0x1F625C80L,    /* ECFIR/ECIIR */
 0x0314FB00L, 0x1E6B8E80L, 0x00C5FF00L, 0x1FC96F00L,
 0x1FFD1200L, 0x00023C00L, 0x0ED29D00L, 0x192A9400L},
{0x00810E00L, 0x1EFEBE80L, 0x00803500L, 0x0FF66D00L,    /* ZSYNTH */
 0x18099080L, 0x59}, 
 0x088E0D80L,   /* TXACGAIN */
 0x01456D80L,   /* RXACGAIN */
 0x07ABE580L, 0x18541B00L, 0x0757CB00L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_600_0_0 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=900_0_0 rprot=30 rfuse=0 emi_cap=10*/
{
{0x06D02180L, 0x00234A00L, 0x1FFE1B80L, 0x1FFFA980L,    /* TXACEQ */
 0x07DD8F80L, 0x002C2B00L, 0x1FF9FE00L, 0x1FFDF780L},   /* RXACEQ */
{0x00117700L, 0x00063380L, 0x02193F80L, 0x0197A500L,    /* ECFIR/ECIIR */
 0x01F8E200L, 0x1FAF6C80L, 0x1FF5B100L, 0x003DE280L,
 0x1FAEB480L, 0x00465880L, 0x00E9E680L, 0x06ECCC00L},
{0x00624000L, 0x1F8FAE80L, 0x000E5100L, 0x0AC84A00L,    /* ZSYNTH */
 0x1D35A180L, 0x2C}, 
 0x08000000L,   /* TXACGAIN */
 0x0106C500L,   /* RXACGAIN */
 0x07B13C80L, 0x184EC400L, 0x07627880L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_900_0_0 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=600_INF_1000 rprot=30 rfuse=0 emi_cap=10*/
{
{0x07F83980L, 0x00056200L, 0x1FFEE880L, 0x1FFB1900L,    /* TXACEQ */
 0x08405000L, 0x001DD200L, 0x0003DB80L, 0x00008700L},   /* RXACEQ */
{0x1FEE8700L, 0x009B2B00L, 0x000C9680L, 0x03700100L,    /* ECFIR/ECIIR */
 0x1F62E400L, 0x01C77400L, 0x1FBBCF80L, 0x0089D500L,
 0x005CFF80L, 0x1FA96E80L, 0x0F679480L, 0x18962A80L},
{0x00657C00L, 0x1F2FA580L, 0x006ADE00L, 0x0FE12100L,    /* ZSYNTH */
 0x181ED080L, 0x57}, 
 0x08618D80L,   /* TXACGAIN */
 0x013E3400L,   /* RXACGAIN */
 0x0717CE80L, 0x18E83200L, 0x062F9C80L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_600_INF_1000 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=200_560_100 rprot=30 rfuse=0 emi_cap=10*/
{
{0x07B53100L, 0x1FCCEE80L, 0x00048B80L, 0x1FFD3A80L,    /* TXACEQ */
 0x09562C80L, 0x1DDD4C80L, 0x00544380L, 0x1FE66D80L},   /* RXACEQ */
{0x000E5780L, 0x00064900L, 0x00D56800L, 0x01BEC580L,    /* ECFIR/ECIIR */
 0x01210680L, 0x00A6B700L, 0x00873A80L, 0x1F7DA700L,
 0x00905900L, 0x1F6A5F00L, 0x02B04D00L, 0x052DD380L},
{0x011EBD00L, 0x1CF39680L, 0x01ED7300L, 0x0A135500L,    /* ZSYNTH */
 0x1DEA4180L, 0x95}, 
 0x08000000L,   /* TXACGAIN */
 0x011FFC00L,   /* RXACGAIN */
 0x07B81580L, 0x1847EB00L, 0x07702B80L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_200_560_100 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=200_680_100 rprot=30 rfuse=0 emi_cap=10*/
{
{0x07365D80L, 0x1FC64180L, 0x00022980L, 0x1FFCE300L,    /* TXACEQ */
 0x09C28580L, 0x1D1FD880L, 0x0071A280L, 0x1FDF7500L},   /* RXACEQ */
{0x1FF15A00L, 0x005C0600L, 0x00828200L, 0x01B11D00L,    /* ECFIR/ECIIR */
 0x027BB800L, 0x1EE9F200L, 0x028BAB80L, 0x1E57BE80L,
 0x01007580L, 0x1EF8B780L, 0x0556EE80L, 0x028DFB80L},
{0x014F2C00L, 0x1C7A1180L, 0x02369A00L, 0x0A138100L,    /* ZSYNTH */
 0x1DEA2280L, 0x8E}, 
 0x08000000L,   /* TXACGAIN */
 0x010C7E80L,   /* RXACGAIN */
 0x07BB2500L, 0x1844DB80L, 0x07764980L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_200_680_100 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=270_750_150 rprot=30 rfuse=0 emi_cap=10*/
{
{0x0715CB80L, 0x1FD56880L, 0x000D4480L, 0x1FFEAE00L,    /* TXACEQ */
 0x0A834F80L, 0x1BA7E500L, 0x0080D300L, 0x1FDC1580L},   /* RXACEQ */
{0x0017A080L, 0x1FDE3600L, 0x0129F900L, 0x01915280L,    /* ECFIR/ECIIR */
 0x01434280L, 0x018E9E00L, 0x1FFE1200L, 0x0085E000L,
 0x001ECE80L, 0x1FDF3C80L, 0x0CC9EA00L, 0x1B2E1180L},
{0x00C66800L, 0x1DD9CB80L, 0x015F8F00L, 0x0CB97F00L,    /* ZSYNTH */
 0x1B44F480L, 0x94}, 
 0x08000000L,   /* TXACGAIN */
 0x0108FB80L,   /* RXACGAIN */
 0x07BB6980L, 0x18449700L, 0x0776D380L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_270_750_150 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=220_820_120 rprot=30 rfuse=0 emi_cap=10*/
{
{0x06E2A580L, 0x1FD1DF80L, 0x00068880L, 0x1FFCE200L,    /* TXACEQ */
 0x0A7AFB00L, 0x1BC11F80L, 0x009C4E80L, 0x1FD60300L},   /* RXACEQ */
{0x002C9880L, 0x1F530400L, 0x02CF4D80L, 0x1E895880L,    /* ECFIR/ECIIR */
 0x055F7200L, 0x1E034600L, 0x023B9080L, 0x1FB01780L,
 0x00339380L, 0x1FC98F80L, 0x0B7EA900L, 0x1C760400L},
{0x022C8200L, 0x1A9F3E80L, 0x03332100L, 0x0A0D4700L,    /* ZSYNTH */
 0x1DEBC480L, 0x8D}, 
 0x08000000L,   /* TXACGAIN */
 0x01013A80L,   /* RXACGAIN */
 0x07BEF980L, 0x18410700L, 0x077DF280L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_220_820_120 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=220_820_115 rprot=30 rfuse=0 emi_cap=10*/
{
{0x06D56400L, 0x1FDF1780L, 0x00095A80L, 0x1FFDA880L,    /* TXACEQ */
 0x0A596300L, 0x1C067880L, 0x0095EF00L, 0x1FD7AF00L},   /* RXACEQ */
{0x00164300L, 0x1FD81880L, 0x0150CC80L, 0x0151BB80L,    /* ECFIR/ECIIR */
 0x01DA1A00L, 0x0142CB80L, 0x0027DE80L, 0x0076A180L,
 0x0012F980L, 0x1FEAE000L, 0x0CC70C80L, 0x1B2DF000L},
{0x00246300L, 0x1E5E0580L, 0x017D2300L, 0x0A138100L,    /* ZSYNTH */
 0x1DEA2280L, 0xA7}, 
 0x08000000L,   /* TXACGAIN */
 0x01009500L,   /* RXACGAIN */
 0x07BBEE80L, 0x18441200L, 0x0777DD80L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_220_820_115 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=400_700_200 rprot=30 rfuse=0 emi_cap=10*/
{
{0x06FC6880L, 0x1FE12200L, 0x00025500L, 0x1FFE7A00L,    /* TXACEQ */
 0x0A23C480L, 0x1C2BF980L, 0x1FF5B780L, 0x1FED5880L},   /* RXACEQ */
{0x00160F00L, 0x1FF2F880L, 0x0134E300L, 0x01D77400L,    /* ECFIR/ECIIR */
 0x01329D00L, 0x01752D00L, 0x000EA100L, 0x00881A00L,
 0x002CE900L, 0x1FD1C400L, 0x0D377680L, 0x1ABB2A00L},
{0x003DBD00L, 0x1F5CDE80L, 0x00655200L, 0x0EB5D300L,    /* ZSYNTH */
 0x19496A80L, 0x71}, 
 0x08000000L,   /* TXACGAIN */
 0x01068B00L,   /* RXACGAIN */
 0x07B8AD80L, 0x18475300L, 0x07715B00L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_400_700_200 */
/* Source: Database file: cwdb.db */
/* Database information: version: 1.0.2 build date: 2011-01-26*/
/* parameters: zref=200_1000_100 rprot=30 rfuse=0 emi_cap=0*/
{
{0x06712B00L, 0x1FBE7C80L, 0x1FFCA500L, 0x1FF9E780L,    /* TXACEQ */
 0x0AB44500L, 0x1B4C2F80L, 0x00B39680L, 0x1FD02680L},   /* RXACEQ */
{0x001D7F00L, 0x1FB2B600L, 0x01DA5B00L, 0x00BCE980L,    /* ECFIR/ECIIR */
 0x0302C780L, 0x00A9F780L, 0x00CA4080L, 0x0067CB80L,
 0x002A8C80L, 0x1FD2B880L, 0x0C9B1F00L, 0x1B5C6500L},
{0x028A8100L, 0x19D87880L, 0x039CA200L, 0x0A133B00L,    /* ZSYNTH */
 0x1DEA3480L, 0x84}, 
 0x08000000L,   /* TXACGAIN */
 0x00EEE880L,   /* RXACGAIN */
 0x07BE2880L, 0x1841D800L, 0x077C5180L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_200_1000_100 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=150_830_72 rprot=30 rfuse=4 emi_cap=10*/
{
{0x06C61F80L, 0x1FEDC200L, 0x000A4C80L, 0x1FFD5980L,    /* TXACEQ */
 0x09746080L, 0x1DA76280L, 0x006BE900L, 0x1FDED780L},   /* RXACEQ */
{0x00078F80L, 0x0013A900L, 0x00E97680L, 0x02038500L,    /* ECFIR/ECIIR */
 0x019FDE80L, 0x01169700L, 0x005BED80L, 0x1FCC5400L,
 0x00699800L, 0x1F91FA80L, 0x023E0000L, 0x059F0380L},
{0x1F502180L, 0x01216300L, 0x1F4CF480L, 0x0EB01C00L,    /* ZSYNTH */
 0x18093280L, 0x9F}, 
 0x08000000L,   /* TXACGAIN */
 0x00FFE280L,   /* RXACGAIN */
 0x07B89400L, 0x18476C80L, 0x07712800L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_150_830_72 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=215_1000_137 rprot=30 rfuse=0 emi_cap=10*/
{
{0x06B8F480L, 0x1FD68A80L, 0x0006F100L, 0x1FFC9E00L,    /* TXACEQ */
 0x0B23A880L, 0x1A3F0A00L, 0x00BF3A80L, 0x1FCDF180L},   /* RXACEQ */
{0x00173680L, 0x1FD13A80L, 0x014F9E80L, 0x01285A00L,    /* ECFIR/ECIIR */
 0x0211A080L, 0x013D4900L, 0x00933D00L, 0x00962100L,
 0x00439100L, 0x1FBA9500L, 0x0D1BBC80L, 0x1AD88700L},
{0x1F257880L, 0x00D78D00L, 0x0002B600L, 0x0D102F00L,    /* ZSYNTH */
 0x1AEEBF80L, 0xBC}, 
 0x08000000L,   /* TXACGAIN */
 0x00FB9C00L,   /* RXACGAIN */
 0x07C0AF80L, 0x183F5100L, 0x07815F00L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_215_1000_137 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=300_1000_220 rprot=30 rfuse=0 emi_cap=10*/
{
{0x074FA800L, 0x1FCA8780L, 0x00047880L, 0x1FFDFE00L,    /* TXACEQ */
 0x0AE6E080L, 0x19FA5A00L, 0x00019980L, 0x1FE4D780L},   /* RXACEQ */
{0x1FDB4F00L, 0x00E48280L, 0x1ECE1400L, 0x04DB4400L,    /* ECFIR/ECIIR */
 0x1DCCF080L, 0x04008700L, 0x1F366C80L, 0x0103ED80L,
 0x00651800L, 0x1F99F080L, 0x0E032980L, 0x19F7F380L},
{0x1FE09F80L, 0x1FEA2580L, 0x00350D00L, 0x0EAC2600L,    /* ZSYNTH */
 0x19531180L, 0xA4}, 
 0x08000000L,   /* TXACGAIN */
 0x01109680L,   /* RXACGAIN */
 0x07BD5B00L, 0x1842A580L, 0x077AB600L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_300_1000_220 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=900_INF_2160 rprot=30 rfuse=0 emi_cap=10*/
{
{0x06CF0B00L, 0x00212200L, 0x1FFBDB00L, 0x1FFDF180L,    /* TXACEQ */
 0x07E5EB80L, 0x002F5B80L, 0x1FFA2F00L, 0x1FFE3A80L},   /* RXACEQ */
{0x001FA000L, 0x1FDA6A80L, 0x02626580L, 0x0172FF80L,    /* ECFIR/ECIIR */
 0x0247E800L, 0x1FC47680L, 0x003D1F00L, 0x004AEA00L,
 0x1FFDEF80L, 0x00478E80L, 0x01D1A600L, 0x060A4280L},
{0x00656400L, 0x1F731280L, 0x00273000L, 0x0C0B2700L,    /* ZSYNTH */
 0x1BEF1B80L, 0x2B}, 
 0x08000000L,   /* TXACGAIN */
 0x0106B880L,   /* RXACGAIN */
 0x078FDD00L, 0x18702380L, 0x071FBA00L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_900_INF_2160 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=270_750_150 rprot=30 rfuse=0 emi_cap=10*/
{
{0x0715CB80L, 0x1FD56880L, 0x000D4480L, 0x1FFEAE00L,    /* TXACEQ */
 0x0A834F80L, 0x1BA7E500L, 0x0080D300L, 0x1FDC1580L},   /* RXACEQ */
{0x0017A080L, 0x1FDE3600L, 0x0129F900L, 0x01915280L,    /* ECFIR/ECIIR */
 0x01434280L, 0x018E9E00L, 0x1FFE1200L, 0x0085E000L,
 0x001ECE80L, 0x1FDF3C80L, 0x0CC9EA00L, 0x1B2E1180L},
{0x00C66800L, 0x1DD9CB80L, 0x015F8F00L, 0x0CB97F00L,    /* ZSYNTH */
 0x1B44F480L, 0x94}, 
 0x08000000L,   /* TXACGAIN */
 0x0108FB80L,   /* RXACGAIN */
 0x07BB6980L, 0x18449700L, 0x0776D380L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_270_750_150 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=320_1050_230 rprot=30 rfuse=4 emi_cap=10*/
{
{0x07AB0D00L, 0x1F951280L, 0x00058C80L, 0x1FFDD380L,    /* TXACEQ */
 0x0AF47880L, 0x19AA7000L, 0x1FFC4B80L, 0x1FE39A80L},   /* RXACEQ */
{0x1FEF6780L, 0x00885D80L, 0x1FD33E80L, 0x0331BF80L,    /* ECFIR/ECIIR */
 0x1FD81180L, 0x025B2D00L, 0x00265980L, 0x00C86180L,
 0x00730100L, 0x1F8E9780L, 0x0DFB3A80L, 0x19F6DF00L},
{0x1FEB0380L, 0x1FCF3B80L, 0x0045A100L, 0x0EAD7600L,    /* ZSYNTH */
 0x19520480L, 0xAB}, 
 0x08000000L,   /* TXACGAIN */
 0x0118AE80L,   /* RXACGAIN */
 0x07BDD100L, 0x18422F80L, 0x077BA200L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* SLIC_IMPEDANCE_320_1050_230 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=350_1000_210 rprot=30 rfuse=0 emi_cap=10*/
{
{0x06F46C80L, 0x1FDBB900L, 0x00031280L, 0x1FFD2C80L,    /* TXACEQ */
 0x0AA3BE80L, 0x1A96E300L, 0x1FD90800L, 0x1FE59F00L},   /* RXACEQ */
{0x0019AA80L, 0x1FD99F80L, 0x015EBF80L, 0x01578100L,    /* ECFIR/ECIIR */
 0x01C7AA00L, 0x01386780L, 0x00908C80L, 0x00AB1180L,
 0x00656D80L, 0x1F9ACD80L, 0x0DD7CA80L, 0x1A1BC180L},
{0x1FFD3180L, 0x1FCAE180L, 0x0037CF00L, 0x0ED0D100L,    /* ZSYNTH */
 0x192E7C80L, 0x87}, 
 0x08000000L,   /* TXACGAIN */
 0x0104BF80L,   /* RXACGAIN */
 0x07BC2380L, 0x1843DD00L, 0x07784700L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 }    /* SLIC_IMPEDANCE_350_1000_210 */
};

#else

Si3217x_Impedance_Cfg Si3217x_Impedance_Presets[] ={
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=600_0_0 rprot=30 rfuse=0 emi_cap=10*/
{
{0x07F46C00L, 0x000E4600L, 0x00008580L, 0x1FFD6100L,    /* TXACEQ */
 0x07EF5000L, 0x0013F580L, 0x1FFDE000L, 0x1FFCB280L},   /* RXACEQ */
{0x0027CB00L, 0x1F8A8880L, 0x02801180L, 0x1F625C80L,    /* ECFIR/ECIIR */
 0x0314FB00L, 0x1E6B8E80L, 0x00C5FF00L, 0x1FC96F00L,
 0x1FFD1200L, 0x00023C00L, 0x0ED29D00L, 0x192A9400L},
{0x00810E00L, 0x1EFEBE80L, 0x00803500L, 0x0FF66D00L,    /* ZSYNTH */
 0x18099080L, 0x59}, 
 0x088E0D80L,   /* TXACGAIN */
 0x01456D80L,   /* RXACGAIN */
 0x07ABE580L, 0x18541B00L, 0x0757CB00L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* ZSYN_600_0_0_30_0 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=270_750_150 rprot=30 rfuse=0 emi_cap=10*/
{
{0x0715CB80L, 0x1FD56880L, 0x000D4480L, 0x1FFEAE00L,    /* TXACEQ */
 0x0A834F80L, 0x1BA7E500L, 0x0080D300L, 0x1FDC1580L},   /* RXACEQ */
{0x0017A080L, 0x1FDE3600L, 0x0129F900L, 0x01915280L,    /* ECFIR/ECIIR */
 0x01434280L, 0x018E9E00L, 0x1FFE1200L, 0x0085E000L,
 0x001ECE80L, 0x1FDF3C80L, 0x0CC9EA00L, 0x1B2E1180L},
{0x00C66800L, 0x1DD9CB80L, 0x015F8F00L, 0x0CB97F00L,    /* ZSYNTH */
 0x1B44F480L, 0x94}, 
 0x08000000L,   /* TXACGAIN */
 0x0108FB80L,   /* RXACGAIN */
 0x07BB6980L, 0x18449700L, 0x0776D380L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* ZSYN_270_750_150_30_0 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=370_620_310 rprot=30 rfuse=0 emi_cap=10*/
{
{0x07E59E80L, 0x1FD33400L, 0x1FFDF800L, 0x1FFD8300L,    /* TXACEQ */
 0x09F38000L, 0x1C1C5A00L, 0x1F94D700L, 0x1FDE5800L},   /* RXACEQ */
{0x00234480L, 0x1F9CDD00L, 0x01F5D580L, 0x1FF39000L,    /* ECFIR/ECIIR */
 0x02C17180L, 0x1FBE2500L, 0x00DFFE80L, 0x00441A80L,
 0x003BF800L, 0x1FC42400L, 0x0D9EB380L, 0x1A514580L},
{0x003ED200L, 0x1F5D6B80L, 0x0063B100L, 0x0F12E200L,    /* ZSYNTH */
 0x18EC9380L, 0x8B}, 
 0x08000000L,   /* TXACGAIN */
 0x0127C700L,   /* RXACGAIN */
 0x07B51200L, 0x184AEE80L, 0x076A2480L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* ZSYN_370_620_310_30_0 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=220_820_120 rprot=30 rfuse=0 emi_cap=10*/
{
{0x06E2A580L, 0x1FD1DF80L, 0x00068880L, 0x1FFCE200L,    /* TXACEQ */
 0x0A7AFB00L, 0x1BC11F80L, 0x009C4E80L, 0x1FD60300L},   /* RXACEQ */
{0x002C9880L, 0x1F530400L, 0x02CF4D80L, 0x1E895880L,    /* ECFIR/ECIIR */
 0x055F7200L, 0x1E034600L, 0x023B9080L, 0x1FB01780L,
 0x00339380L, 0x1FC98F80L, 0x0B7EA900L, 0x1C760400L},
{0x022C8200L, 0x1A9F3E80L, 0x03332100L, 0x0A0D4700L,    /* ZSYNTH */
 0x1DEBC480L, 0x8D}, 
 0x08000000L,   /* TXACGAIN */
 0x01013A80L,   /* RXACGAIN */
 0x07BEF980L, 0x18410700L, 0x077DF280L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* ZSYN_220_820_120_30_0 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=600_0_0 rprot=30 rfuse=0 emi_cap=10*/
{
{0x07F46C00L, 0x000E4600L, 0x00008580L, 0x1FFD6100L,    /* TXACEQ */
 0x07EF5000L, 0x0013F580L, 0x1FFDE000L, 0x1FFCB280L},   /* RXACEQ */
{0x0027CB00L, 0x1F8A8880L, 0x02801180L, 0x1F625C80L,    /* ECFIR/ECIIR */
 0x0314FB00L, 0x1E6B8E80L, 0x00C5FF00L, 0x1FC96F00L,
 0x1FFD1200L, 0x00023C00L, 0x0ED29D00L, 0x192A9400L},
{0x00810E00L, 0x1EFEBE80L, 0x00803500L, 0x0FF66D00L,    /* ZSYNTH */
 0x18099080L, 0x59}, 
 0x088E0D80L,   /* TXACGAIN */
 0x01456D80L,   /* RXACGAIN */
 0x07ABE580L, 0x18541B00L, 0x0757CB00L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* ZSYN_600_0_1000_30_0 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=200_680_100 rprot=30 rfuse=0 emi_cap=10*/
{
{0x07365D80L, 0x1FC64180L, 0x00022980L, 0x1FFCE300L,    /* TXACEQ */
 0x09C28580L, 0x1D1FD880L, 0x0071A280L, 0x1FDF7500L},   /* RXACEQ */
{0x1FF15A00L, 0x005C0600L, 0x00828200L, 0x01B11D00L,    /* ECFIR/ECIIR */
 0x027BB800L, 0x1EE9F200L, 0x028BAB80L, 0x1E57BE80L,
 0x01007580L, 0x1EF8B780L, 0x0556EE80L, 0x028DFB80L},
{0x014F2C00L, 0x1C7A1180L, 0x02369A00L, 0x0A138100L,    /* ZSYNTH */
 0x1DEA2280L, 0x8E}, 
 0x08000000L,   /* TXACGAIN */
 0x010C7E80L,   /* RXACGAIN */
 0x07BB2500L, 0x1844DB80L, 0x07764980L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* ZSYN_200_680_100_30_0 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=220_820_115 rprot=30 rfuse=0 emi_cap=10*/
{
{0x06D56400L, 0x1FDF1780L, 0x00095A80L, 0x1FFDA880L,    /* TXACEQ */
 0x0A596300L, 0x1C067880L, 0x0095EF00L, 0x1FD7AF00L},   /* RXACEQ */
{0x00164300L, 0x1FD81880L, 0x0150CC80L, 0x0151BB80L,    /* ECFIR/ECIIR */
 0x01DA1A00L, 0x0142CB80L, 0x0027DE80L, 0x0076A180L,
 0x0012F980L, 0x1FEAE000L, 0x0CC70C80L, 0x1B2DF000L},
{0x00246300L, 0x1E5E0580L, 0x017D2300L, 0x0A138100L,    /* ZSYNTH */
 0x1DEA2280L, 0xA7}, 
 0x08000000L,   /* TXACGAIN */
 0x01009500L,   /* RXACGAIN */
 0x07BBEE80L, 0x18441200L, 0x0777DD80L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 },  /* ZSYN_220_820_115_30_0 */
/* Source: Database file: cwdb.db */
/* Database information: */
/* parameters: zref=600_0_0 rprot=20 rfuse=0 emi_cap=0*/
{
{0x0817F080L, 0x1FE39600L, 0x0005A280L, 0x1FFC7600L,    /* TXACEQ */
 0x07FA6E80L, 0x1FFD4F80L, 0x1FF80500L, 0x1FFDE780L},   /* RXACEQ */
{0x00538E00L, 0x1F47A800L, 0x02957D00L, 0x00128700L,    /* ECFIR/ECIIR */
 0x0194DD80L, 0x000E7100L, 0x1FC5B180L, 0x00061600L,
 0x0021B480L, 0x1FE88600L, 0x1FCAD600L, 0x1FD00E80L},
{0x006A0F00L, 0x1F499F80L, 0x004C8900L, 0x0A152400L,    /* ZSYNTH */
 0x1DE9B580L, 0x68}, 
 0x08419500L,   /* TXACGAIN */
 0x01365F00L,   /* RXACGAIN */
 0x07BB5700L, 0x1844A980L, 0x0776AE80L,    /* RXACHPF */
#ifdef ENABLE_HIRES_GAIN
 0, 0  /* TXGAIN*10, RXGAIN*10 (hi_res) */
#else
 0, 0  /* TXGAIN, RXGAIN */
#endif
 }    /* WB_ZSYN_600_0_0_20_0 */
};
#endif

Si3217x_FSK_Cfg Si3217x_FSK_Presets[] ={
{
0x02232000L,	 /* FSK01 */
0x077C2000L,	 /* FSK10 */
0x003C0000L,	 /* FSKAMP0 (0.220 vrms )*/
0x00200000L,	 /* FSKAMP1 (0.220 vrms) */
0x06B60000L,	 /* FSKFREQ0 (2200.0 Hz space) */
0x079C0000L,	 /* FSKFREQ1 (1200.0 Hz mark) */
0x00,			 /* FSK8 */
0x00,			 /* FSKDEPTH (1 deep fifo) */
}    /* DEFAULT_FSK */
};

Si3217x_PulseMeter_Cfg Si3217x_PulseMeter_Presets[] ={
{
0x007A2B6AL,  /* PM_AMP_THRESH (1.000) */
0,            /* Freq (12kHz) */ 
0,            /* PM_RAMP (24kHz)*/
0,            /* PM_FORCE (First)*/
0,            /* PWR_SAVE (off)*/
0,            /* PM_AUTO (off)*/
0x07D00000L,  /* PM_active (2000 ms) */
0x07D00000L   /* PM_inactive (2000 ms) */
 }    /* DEFAULT_PULSE_METERING */
};

Si3217x_Tone_Cfg Si3217x_Tone_Presets[] = {
{
	{
	0x07B30000L,	 /* OSC1FREQ (350.000 Hz) */
	0x000C6000L,	 /* OSC1AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC1PHAS (0.000 rad) */
	0x00,			 /* O1TALO (0 ms) */
	0x00,			 /* O1TAHI */
	0x00,			 /* O1TILO (0 ms) */
	0x00			 /* O1TIHI */
	},
	{
	0x07870000L,	 /* OSC2FREQ (440.000 Hz) */
	0x000FA000L,	 /* OSC2AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC2PHAS (0.000 rad) */
	0x00,			 /* O2TALO (0 ms) */
	0x00,			 /* O2TAHI */
	0x00,			 /* O2TILO (0 ms) */
	0x00 			 /* O2TIHI */
	},
	0x66 			 /* OMODE */
},  /* TONEGEN_FCC_DIAL */
{
	{
	0x07700000L,	 /* OSC1FREQ (480.000 Hz) */
	0x00112000L,	 /* OSC1AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC1PHAS (0.000 rad) */
	0xA0,			 /* O1TALO (500 ms) */
	0x0F,			 /* O1TAHI */
	0xA0,			 /* O1TILO (500 ms) */
	0x0F			 /* O1TIHI */
	},
	{
	0x07120000L,	 /* OSC2FREQ (620.000 Hz) */
	0x00164000L,	 /* OSC2AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC2PHAS (0.000 rad) */
	0xA0,			 /* O2TALO (500 ms) */
	0x0F,			 /* O2TAHI */
	0xA0,			 /* O2TILO (500 ms) */
	0x0F 			 /* O2TIHI */
	},
	0x66 			 /* OMODE */
},  /* TONEGEN_FCC_BUSY */
{
	{
	0x07700000L,	 /* OSC1FREQ (480.000 Hz) */
	0x00112000L,	 /* OSC1AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC1PHAS (0.000 rad) */
	0x80,			 /* O1TALO (2000 ms) */
	0x3E,			 /* O1TAHI */
	0x00,			 /* O1TILO (4000 ms) */
	0x7D			 /* O1TIHI */
	},
	{
	0x07870000L,	 /* OSC2FREQ (440.000 Hz) */
	0x000FA000L,	 /* OSC2AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC2PHAS (0.000 rad) */
	0x80,			 /* O2TALO (2000 ms) */
	0x3E,			 /* O2TAHI */
	0x00,			 /* O2TILO (4000 ms) */
	0x7D 			 /* O2TIHI */
	},
	0x66 			 /* OMODE */
},  /* TONEGEN_FCC_RINGBACK */
{
	{
	0x07700000L,	 /* OSC1FREQ (480.000 Hz) */
	0x00112000L,	 /* OSC1AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC1PHAS (0.000 rad) */
	0x60,			 /* O1TALO (300 ms) */
	0x09,			 /* O1TAHI */
	0x60,			 /* O1TILO (300 ms) */
	0x09			 /* O1TIHI */
	},
	{
	0x07120000L,	 /* OSC2FREQ (620.000 Hz) */
	0x00164000L,	 /* OSC2AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC2PHAS (0.000 rad) */
	0x60,			 /* O2TALO (300 ms) */
	0x09,			 /* O2TAHI */
	0x40,			 /* O2TILO (200 ms) */
	0x06 			 /* O2TIHI */
	},
	0x66 			 /* OMODE */
},  /* TONEGEN_FCC_REORDER */
{
	{
	0x07700000L,	 /* OSC1FREQ (480.000 Hz) */
	0x00112000L,	 /* OSC1AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC1PHAS (0.000 rad) */
	0x40,			 /* O1TALO (200 ms) */
	0x06,			 /* O1TAHI */
	0x40,			 /* O1TILO (200 ms) */
	0x06			 /* O1TIHI */
	},
	{
	0x07120000L,	 /* OSC2FREQ (620.000 Hz) */
	0x00164000L,	 /* OSC2AMP (-18.000 dBm) */
	0x00000000L,	 /* OSC2PHAS (0.000 rad) */
	0x40,			 /* O2TALO (200 ms) */
	0x06,			 /* O2TAHI */
	0x40,			 /* O2TILO (200 ms) */
	0x06 			 /* O2TIHI */
	},
	0x66 			 /* OMODE */
}    /* TONEGEN_FCC_CONGESTION */
};

Si3217x_PCM_Cfg Si3217x_PCM_Presets[] ={
#ifdef REALTEK_PATCH_FOR_SILAB
	//narrowband
	{
	0x03, 	 /* PCM_FMT - 16-bit Linear */
	0x00, 	 /* WIDEBAND - DISABLED (3.4kHz BW) */
	0x01, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x00 	 /* A-LAW -  INVERT NONE */
	},  /* PCM_16LIN */
	{
	0x00, 	 /* PCM_FMT - A-Law */
	0x00, 	 /* WIDEBAND - DISABLED (3.4kHz BW) */
	0x01, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x01 	 /* A-LAW -  INVERT NONE */
	},  /* PCM_8ALAW */
	{
	0x01, 	 /* PCM_FMT - u-Law */
	0x00, 	 /* WIDEBAND - DISABLED (3.4kHz BW) */
	0x01, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x00 	 /* A-LAW -  INVERT NONE */
	},  /* PCM_8ULAW */
	//wideband
	{
	0x03, 	 /* PCM_FMT - 16-bit Linear */
	0x01, 	 /* WIDEBAND - ENABLED (7kHz BW) */
	0x01, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x00 	 /* A-LAW -  INVERT NONE */
	},    /* PCM_16LIN_WB */
	{
	0x00, 	 /* PCM_FMT - A-Law */
	0x01, 	 /* WIDEBAND - DISABLED (3.4kHz BW) */
	0x01, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x01 	 /* A-LAW -  INVERT NONE */
	},  /* PCM_8ALAW_WB */
	{
	0x01, 	 /* PCM_FMT - u-Law */
	0x01, 	 /* WIDEBAND - DISABLED (3.4kHz BW) */
	0x01, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x00 	 /* A-LAW -  INVERT NONE */
	},  /* PCM_8ULAW_WB */
#else
	{
	0x01, 	 /* PCM_FMT - u-Law */
	0x00, 	 /* WIDEBAND - DISABLED (3.4kHz BW) */
	0x00, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x00 	 /* A-LAW -  INVERT NONE */
	},  /* PCM_8ULAW */
	{
	0x00, 	 /* PCM_FMT - A-Law */
	0x00, 	 /* WIDEBAND - DISABLED (3.4kHz BW) */
	0x00, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x00 	 /* A-LAW -  INVERT NONE */
	},  /* PCM_8ALAW */
	{
	0x03, 	 /* PCM_FMT - 16-bit Linear */
	0x00, 	 /* WIDEBAND - DISABLED (3.4kHz BW) */
	0x00, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x00 	 /* A-LAW -  INVERT NONE */
	},  /* PCM_16LIN */
	{
	0x03, 	 /* PCM_FMT - 16-bit Linear */
	0x01, 	 /* WIDEBAND - ENABLED (7kHz BW) */
	0x00, 	 /* PCM_TRI - PCLK RISING EDGE */
	0x00, 	 /* TX_EDGE - PCLK RISING EDGE */
	0x00 	 /* A-LAW -  INVERT NONE */
	}    /* PCM_16LIN_WB */
#endif
};

