/*
 * Le890NB_HV.c --
 *
 * This file contains profile data in byte format
 *
 * Project Info --
 *   File:   V:\work\VoIP\branches\VoIP-1.4\VoIP-jungle-2.4.4\rlxlinux-v2.2\linux-2.6.30\rtk_voip\voip_drivers\zarlink\api_lib-2.16.1\profiles\Le890NB_HV.vpw
 *   Type:   VE890 Configuration for 150V Tracking Inverting-Boost Power Supply, Lite Narrowband FXS Coefficients, and 8.192MHz PCLK
 *   Date:   Thursday, January 20, 2011 11:50:34
 *   Device: VE890 Le89336
 *
 *   This file was generated with Profile Wizard Version: P2.0.0
 *
 * Project Comments --
 *  --------------------------------------------
 *  Profile Wizard Coefficient Release 2.7 Notes:
 *  --------------------------------------------
 *  Replaced the FXS AC Coefficients for GR57, China, Finland, and Japan.
 *  
 *  --------------------------------------------
 *  Profile Wizard Coefficient Release 2.6 Notes:
 *  --------------------------------------------
 *  I. General:
 *  1. This release adds support for Mexico, Turkey, Thailand, Malaysia, Indonesia, and Ecuador, bringing
 *  the total number of supported countries to 44.  They are:
 *  Argentina (AR), Austria (AT), Australia (AU), Belgium (BE), Bulgaria (BG), Brazil (BR), Canada (CA), Switzerland (CH),
 *  Chile (CL), China (CN), Czech Republic (CZ), Germany (DE), Denmark (DK), Ecuador (EC), Spain (ES), Finland (FI),
 *  France (FR), UK (GB), Greece (GR), Hong Kong SAR China (HK), Hungary (HU), Indonesia (ID), Ireland (IE), Israel (IL),
 *  India (IN), Iceland (IS), Italy (IT), Japan (JP), S. Korea (KR), Mexico (MX), Malaysia (MY), Netherlands (NL),
 *  Norway (NO), New Zealand (NZ), Poland (PL), Portugal (PT), Russian Federation (RU), Sweden (SE), Singapore (SG),
 *  Thailand (TH), Turkey (TK), Taiwan (TW), USA (US), and South Africa (ZA).
 *  2. This release also corrects some Caller ID implementations and signal levels that were incorrect in release 2.3.
 *  3. The coefficients in this and all releases are provided for use only with the Zarlink VoicePath API. Please refer to the terms 
 *  and conditions for licensing the software regarding terms and conditions of usage.
 *  4. This release is for the VE8911-HV chipset and includes coefficients required for the FXS and FXO operation supported by the chipset.
 *  
 *  II. Device Profile:
 *  1. The default settings for the Device Profile are:
 *         PCLK = 8192 kHz
 *         PCM Transmit Edge = Positive
 *         Transmit Time Slot = 0
 *         Receive Time Slot = 0
 *         Interrupt Mode = Open Drain
 *         Switcher = Inverting-Boost (150V)
 *         Driver Tick Rate = 5 ms
 *         Maximum Events / Tick = 2
 *  2. The settings may be changed by the user as necessary.  Please refer to the VE890 and API documentation for information about
 *  the supported settings.
 *  
 *  II. AC Profiles:
 *  1. FXS Coefficients assume -6dBr RX (Output from chipset) and 0dB TX relative gain levels.
 *  2. FXO Coefficients 0dB RX (Output from chipset) and -6dB TX (which means +6dB gain) relative gain levels.
 *  3. Supported countries not individually listed should use the default 600R coefficients, such as LE890_AC_FXS_RF50_600R_DEF and
 *  AC_FXO_LC_600R_DEF.
 *  4. AC FXS Coefficients assume the use of two 25 ohm series resistors or PTCs.
 *  5. This release includes Normal (or narrowband) coefficients for the FXS port.  Wideband coefficients are available upon request.
 *  6. AC FXO Coefficients assume the use of the LC Filter on VE890 DAA Circuit consisting of CIMM and LIMM as shown
 *  in the datasheet.
 *  7. AC FXO Coefficients include the coefficient sets for the VE890 echo free adaptive balance.
 *  
 *  III. DC Profile:
 *  1. The LE890_DC_FXS_DEF Profile is the default used for all countries.  Additional profiles may be created by the user if necessary.
 *  
 *  IV. Ring Profiles:
 *  1. LE890_RING_25HZ_DEF is the default ringing profile and should be used for all countries which do not have a listed ringing profile.  The default
 *  ringing profile is set for a sine wave ringing with an amplitude of 75 Vrms and a frequency of 25 Hz.
 *  2. All ringing profiles on the list have a 75 Vrms ringing level.  
 *  3. DC biasing is 0 for all the sample ringing profiles.
 *  
 *  V. Tone Profiles:
 *  1. These profiles are available only in the full version of the API.
 *  2. The shown levels assume a 6dB attenuation in the chipset before being outputed to line.
 *  3. Call progress tone levels may be arbitrary as they are not always specified in national standards, or the standards may not be available to Zarlink.
 *  4. ITU-T Recommendation E.180 (03/1998) revised on 02/2003 and ETSI TR 101 041-2 V.1.1.1 (05/1997) were used if national standards were not
 *  available.
 *  5. Recommended ETSI ES 201 970 call progress tones are provided for reference.
 *  6. Modulated tones f1 x f2 are approximated as the sum of f1 + (f1+f2)/2 + (f1-f2)/2.
 *  7. The data in these profiles may be changed by the user as necessary.
 *   8. T_CAS_DEF is not a country-specific tone and is used by several national Caller ID profiles.
 *  
 *  V. Cadence Profiles:
 *  1. These profiles are available only in the full version of the API.
 *  2.  ITU-T Recommendation E.180 (03/1998) revised on 02/2003 and ETSI TR 101 041-2 V.1.1.1 (05/1997) were used if national standards were not
 *  available.
 *  3. Recommended ETSI ES 201 970 call progress cadences are provided for reference.
 *  4. Some countries support multiple call progress tone cadences.  The ones used are believed to be representative and most common.  The user may
 *  wish to edit some of the cadence definitions or add additional cadences.
 *  5. Ringing signal cadences include the alerting signal(s) and necessary delays for Type 1 Caller ID, if it is supported below in the Caller ID Profiles.
 *  
 *  VI. Caller ID Profiles:
 *  1. These profiles are available only in the full version of the API.
 *  2. The option to calculate the checksum in the API is selected for all countries except Japan, which requires that the CRC checksum be calculated by
 *  host application.
 *  
 *  VII. FXO/Dialing Profiles:
 *  1. 44 country-specific profiles are provided.  They take into account such variations in national standards as pulse dialing, DTMF dialing, and line
 *  event detection parameters.
 *  2. They may be edited as necessary to meet regulatory requirements.
 *  3. ETSI 203 021 defaults are also provided for reference.
 *  
 *  ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
 */

#include "Le890NB_HV.h"


/************** Device_Parameters **************/

/* Device Configuration Data */
const VpProfileDataType LE890_DEV_PROFILE_Inverting_Boost_150V[] =
{
  /* Device Profile for VE890 Device Family */
 0x00, 0xFF, 0x00, 0x1A, /* Profile Type and Length */
 0x06, 0x00, /* Version and MPI Command */
 0x08, 0x00, /* PCLK Frequency */
 0x82, 0x00, /* Device Config 1 and MCLK Correction */
 0x40, 0x02, /* Clock Slot and Max Events */
 0x0A, 0x00, /* Device Tickrate */
 0xE4, 0x02, 0x04, 0x0A, /* Inverting Boost (150V) Switching Regulator Parameters */
 0xB3, 0xFF, 0x94, 0x52, 0xFC, 0x52, /* Regulator Timing Parameters */
 0x20, 0x80, 0x3C, 0x52, 0x3C, 0x52  /* FreeRun Timing Parameters */
};

/************** AC_Coefficients **************/

/* AC FXS RF50 600R Normal Coefficients (Default)  */
const VpProfileDataType LE890_AC_FXS_RF50_600R_DEF[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBC, 0x4C, 0x01, 0x49, 0xCA, 0xF1, 0x98, 0xAA, 0x5B, 0xEB,
 0x2C, 0x72, 0xA4, 0x26, 0x24, 0xEB, 0x2D, 0x9A, 0x2B, 0xBA, 0x27, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x2B, 0xA0, 0xD2, 0xA2, 0xAC, 0xCB, 0xE5, 0xA3,
 0x2B, 0xBC, 0xAD, 0x46, 0x88, 0x3C, 0x20, 0x33, 0x4D, 0xAA, 0xB7, 0x45,
 0xE6, 0x24, 0x5F, 0x22, 0x9F, 0x82, 0xAA, 0x71, 0x80, 0xC8, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0xA1, 0xDB, 0x1C, 0xA3, 0xA8, 0xFE, 0x87, 0xAA,
 0xFA, 0x9F, 0xB9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF50 ETSI ES201 970 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_ETSI[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 Telcordia GR-57 900R+2.16uF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_GR57[] =
{
  /* AC Profile */
 0x0E, 0x00, 0x9E, 0x4C, 0x01, 0x49, 0xCA, 0x0E, 0x98, 0x7B, 0xCA, 0x64,
 0x5D, 0x2A, 0xB3, 0xBA, 0xA3, 0xC2, 0x2C, 0x9A, 0x6B, 0xA2, 0x25, 0x2D,
 0x01, 0x8A, 0xC3, 0xC0, 0xBA, 0xC0, 0x73, 0xC4, 0xA2, 0xB6, 0x3A, 0xDD,
 0xB3, 0x97, 0x2A, 0x47, 0x88, 0xA9, 0x70, 0xD2, 0x46, 0xA2, 0x6D, 0x4B,
 0xAD, 0xA2, 0xA4, 0x2A, 0xCD, 0x82, 0x42, 0xA1, 0x80, 0xBF, 0xB0, 0x50,
 0x00, 0x86, 0xBC, 0x52, 0x22, 0x32, 0x1B, 0x22, 0xBA, 0x4A, 0x25, 0x22,
 0x72, 0xA7, 0xA3, 0x70, 0x96, 0x25, 0xC0, 0x00
};

/* AC FXS RF50 Austria 220R+820R//115nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_AT[] =
{
  /* AC Profile */
 0x55, 0x00, 0xC7, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x3C, 0x41, 0xB4,
 0xB2, 0x3B, 0x3B, 0xEA, 0xBA, 0xF4, 0x53, 0x9A, 0x2E, 0xA2, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2A, 0x10, 0x97, 0xB8, 0xDA, 0x33, 0xA3, 0x3E,
 0xBA, 0x8F, 0xAB, 0x8F, 0x88, 0xB3, 0xC0, 0x22, 0xB6, 0xD2, 0x2D, 0xBB,
 0x4E, 0x22, 0x25, 0xC2, 0xAD, 0x82, 0xA8, 0xF1, 0x80, 0xA8, 0xF0, 0x50,
 0x00, 0x86, 0xB4, 0x5B, 0x32, 0x24, 0x1A, 0xA1, 0x2C, 0x2D, 0xB3, 0x6B,
 0x4C, 0xC5, 0xBC, 0x60, 0x96, 0x23, 0xA1, 0x00
};

/* AC FXS RF50 Australia 220R+820R//120nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_AU[] =
{
  /* AC Profile */
 0x55, 0x00, 0xC7, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x3C, 0x41, 0xB4,
 0xB2, 0x3B, 0x3B, 0xEA, 0xBA, 0xF4, 0x53, 0x9A, 0x2E, 0xA2, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2A, 0x10, 0x97, 0xB8, 0xDA, 0x33, 0xA3, 0x3E,
 0xBA, 0x8F, 0xAB, 0x8F, 0x88, 0xB3, 0xC0, 0x22, 0xB6, 0xD2, 0x2D, 0xBB,
 0x4E, 0x22, 0x25, 0xC2, 0xAD, 0x82, 0xA8, 0xF1, 0x80, 0xA8, 0xF0, 0x50,
 0x00, 0x86, 0xB4, 0x5B, 0x32, 0x24, 0x1A, 0xA1, 0x2C, 0x2D, 0xB3, 0x6B,
 0x4C, 0xC5, 0xBC, 0x60, 0x96, 0x23, 0xA1, 0x00
};

/* AC FXS RF50 Belgium 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_BE[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 Bulgaria 220R+820R//115nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_BG[] =
{
  /* AC Profile */
 0x55, 0x00, 0xC7, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x3C, 0x41, 0xB4,
 0xB2, 0x3B, 0x3B, 0xEA, 0xBA, 0xF4, 0x53, 0x9A, 0x2E, 0xA2, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2A, 0x10, 0x97, 0xB8, 0xDA, 0x33, 0xA3, 0x3E,
 0xBA, 0x8F, 0xAB, 0x8F, 0x88, 0xB3, 0xC0, 0x22, 0xB6, 0xD2, 0x2D, 0xBB,
 0x4E, 0x22, 0x25, 0xC2, 0xAD, 0x82, 0xA8, 0xF1, 0x80, 0xA8, 0xF0, 0x50,
 0x00, 0x86, 0xB4, 0x5B, 0x32, 0x24, 0x1A, 0xA1, 0x2C, 0x2D, 0xB3, 0x6B,
 0x4C, 0xC5, 0xBC, 0x60, 0x96, 0x23, 0xA1, 0x00
};

/* AC FXS RF50 Switzerland 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_CH[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 China 200R+680R//100nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_CN[] =
{
  /* AC Profile */
 0xA8, 0x00, 0x4B, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x2A, 0xA1, 0xAB,
 0xB2, 0x3A, 0xBB, 0xEA, 0xBA, 0xAB, 0xD3, 0x9A, 0xCA, 0xC4, 0x97, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0x3A, 0x00, 0xAA, 0xA8, 0xAA, 0xAA, 0xC2, 0xA1,
 0xA2, 0xBA, 0x3A, 0xC4, 0x88, 0xAC, 0x70, 0xD2, 0xB5, 0x24, 0xAC, 0xA3,
 0xAD, 0x9F, 0xA4, 0x3E, 0xAD, 0x82, 0xA3, 0xA1, 0x80, 0xD4, 0xC0, 0x50,
 0x00, 0x86, 0x3D, 0x5A, 0x32, 0xE5, 0x13, 0xA1, 0x22, 0x3A, 0xB4, 0xA3,
 0x62, 0x97, 0xA9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF50 Germany 220R+820R//115nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_DE[] =
{
  /* AC Profile */
 0x55, 0x00, 0xC7, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x3C, 0x41, 0xB4,
 0xB2, 0x3B, 0x3B, 0xEA, 0xBA, 0xF4, 0x53, 0x9A, 0x2E, 0xA2, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2A, 0x10, 0x97, 0xB8, 0xDA, 0x33, 0xA3, 0x3E,
 0xBA, 0x8F, 0xAB, 0x8F, 0x88, 0xB3, 0xC0, 0x22, 0xB6, 0xD2, 0x2D, 0xBB,
 0x4E, 0x22, 0x25, 0xC2, 0xAD, 0x82, 0xA8, 0xF1, 0x80, 0xA8, 0xF0, 0x50,
 0x00, 0x86, 0xB4, 0x5B, 0x32, 0x24, 0x1A, 0xA1, 0x2C, 0x2D, 0xB3, 0x6B,
 0x4C, 0xC5, 0xBC, 0x60, 0x96, 0x23, 0xA1, 0x00
};

/* AC FXS RF50 Denmark 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_DK[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 Spain 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_ES[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 Finland 270R+910R//120nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_FI[] =
{
  /* AC Profile */
 0x1F, 0x00, 0xAA, 0x4C, 0x01, 0x49, 0xCA, 0xEC, 0x98, 0x2B, 0x41, 0x52,
 0x23, 0xAB, 0x6B, 0x22, 0x2B, 0xCA, 0xA3, 0x9A, 0x62, 0xB2, 0x97, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0xBC, 0x00, 0x23, 0x58, 0x2D, 0x3A, 0xB5, 0xA1,
 0x23, 0xEA, 0xAA, 0x24, 0x88, 0xCB, 0x50, 0xA2, 0xAF, 0x3E, 0x2D, 0x22,
 0xDF, 0x3A, 0x25, 0xB3, 0x2E, 0x82, 0x32, 0x22, 0x80, 0x3C, 0xA0, 0x50,
 0x00, 0x86, 0xB4, 0x5A, 0x22, 0x23, 0x1A, 0xC1, 0x23, 0x22, 0x23, 0xBA,
 0x32, 0xC4, 0xB3, 0x50, 0x96, 0x3A, 0x31, 0x00
};

/* AC FXS RF50 France 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_FR[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 UK 370R+620R//310nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_GB[] =
{
  /* AC Profile */
 0x43, 0x00, 0x20, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xA2, 0xB1, 0x3A,
 0x22, 0x72, 0xA4, 0xE3, 0xAB, 0x3A, 0xD5, 0x9A, 0xBA, 0xA3, 0xA5, 0x6E,
 0x01, 0x8A, 0x32, 0xD0, 0x2A, 0x10, 0x33, 0x29, 0xCA, 0x4A, 0x22, 0x25,
 0x2B, 0x2D, 0x4A, 0xA7, 0x88, 0xFA, 0x50, 0xAD, 0x2E, 0x3A, 0x4D, 0xBA,
 0xEE, 0xAA, 0x26, 0xBA, 0xBF, 0x82, 0xC8, 0x71, 0x80, 0x3B, 0xF0, 0x50,
 0x00, 0x86, 0xAD, 0x5C, 0x42, 0x2C, 0x12, 0x22, 0x2B, 0x23, 0x33, 0xAA,
 0x32, 0x34, 0x2B, 0x40, 0x96, 0xA3, 0xA0, 0x00
};

/* AC FXS RF50 Hungary 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_HU[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 Ireland 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_IE[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 Italy 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_IT[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 Japan 600R+1uF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_JP[] =
{
  /* AC Profile */
 0xAD, 0x00, 0x89, 0x4C, 0x01, 0x49, 0xCA, 0x00, 0x98, 0xB2, 0x2A, 0xAA,
 0xA3, 0xA3, 0xB2, 0xAA, 0xA3, 0x22, 0xAC, 0x9A, 0xB3, 0xA2, 0xA3, 0x32,
 0xD0, 0x8A, 0x3A, 0xA0, 0xDA, 0xF0, 0xA3, 0x34, 0x54, 0x2D, 0x24, 0xBA,
 0xA2, 0xB2, 0xD3, 0xDB, 0x88, 0xAA, 0x50, 0xD2, 0x25, 0xA3, 0xDC, 0x22,
 0xBC, 0x35, 0xBF, 0x29, 0xF7, 0x82, 0xB5, 0xA1, 0x80, 0xAC, 0x30, 0x50,
 0x00, 0x86, 0x2C, 0x63, 0xA1, 0x24, 0x12, 0xA2, 0x98, 0x23, 0xA3, 0xDB,
 0x44, 0xD4, 0xAC, 0x40, 0x96, 0xB2, 0xD0, 0x00
};

/* AC FXS RF50 Netherlands 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_NL[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 Norway 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_NO[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 New Zealand 370R+620R//310nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_NZ[] =
{
  /* AC Profile */
 0x43, 0x00, 0x20, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xA2, 0xB1, 0x3A,
 0x22, 0x72, 0xA4, 0xE3, 0xAB, 0x3A, 0xD5, 0x9A, 0xBA, 0xA3, 0xA5, 0x6E,
 0x01, 0x8A, 0x32, 0xD0, 0x2A, 0x10, 0x33, 0x29, 0xCA, 0x4A, 0x22, 0x25,
 0x2B, 0x2D, 0x4A, 0xA7, 0x88, 0xFA, 0x50, 0xAD, 0x2E, 0x3A, 0x4D, 0xBA,
 0xEE, 0xAA, 0x26, 0xBA, 0xBF, 0x82, 0xC8, 0x71, 0x80, 0x3B, 0xF0, 0x50,
 0x00, 0x86, 0xAD, 0x5C, 0x42, 0x2C, 0x12, 0x22, 0x2B, 0x23, 0x33, 0xAA,
 0x32, 0x34, 0x2B, 0x40, 0x96, 0xA3, 0xA0, 0x00
};

/* AC FXS RF50 Portugal 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_PT[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 Sweden 270R+750R//150nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_SE[] =
{
  /* AC Profile */
 0xC0, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0x7B, 0xB1, 0xAC,
 0xE2, 0xAA, 0xAC, 0x22, 0x2B, 0x4A, 0x34, 0x9A, 0xC4, 0xA2, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x20, 0x23, 0xA8, 0xBB, 0xAC, 0x4A, 0xA4,
 0x2C, 0x5D, 0x6A, 0x27, 0x88, 0xAA, 0xE0, 0x2A, 0x8F, 0x22, 0x2D, 0xAA,
 0xAE, 0x23, 0x25, 0x52, 0xAD, 0x82, 0x2A, 0xF1, 0x80, 0xBA, 0xE0, 0x50,
 0x00, 0x86, 0xD3, 0x54, 0x32, 0x97, 0x14, 0xA1, 0xAA, 0x2B, 0xB3, 0xAD,
 0x42, 0x45, 0xB3, 0x60, 0x96, 0xA5, 0xE1, 0x00
};

/* AC FXS RF50 South Africa 220R+820R//115nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXS_RF50_ZA[] =
{
  /* AC Profile */
 0x55, 0x00, 0xC7, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x3C, 0x41, 0xB4,
 0xB2, 0x3B, 0x3B, 0xEA, 0xBA, 0xF4, 0x53, 0x9A, 0x2E, 0xA2, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2A, 0x10, 0x97, 0xB8, 0xDA, 0x33, 0xA3, 0x3E,
 0xBA, 0x8F, 0xAB, 0x8F, 0x88, 0xB3, 0xC0, 0x22, 0xB6, 0xD2, 0x2D, 0xBB,
 0x4E, 0x22, 0x25, 0xC2, 0xAD, 0x82, 0xA8, 0xF1, 0x80, 0xA8, 0xF0, 0x50,
 0x00, 0x86, 0xB4, 0x5B, 0x32, 0x24, 0x1A, 0xA1, 0x2C, 0x2D, 0xB3, 0x6B,
 0x4C, 0xC5, 0xBC, 0x60, 0x96, 0x23, 0xA1, 0x00
};

/* AC FXO LC Filter 600R Normal ABF Coefficients (Default) */
const VpProfileDataType LE890_AC_FXO_LC_600R_DEF[] =
{
  /* AC Profile */
 0xF6, 0x00, 0x42, 0xF2, 0x01, 0x4B, 0xCA, 0xFF, 0x98, 0xAA, 0x42, 0x2E,
 0xAC, 0xA2, 0xAA, 0xC2, 0x2C, 0x42, 0x33, 0x9A, 0xCA, 0x87, 0x01, 0x6E,
 0x01, 0x8A, 0xB3, 0xD0, 0x24, 0x20, 0xAC, 0xA9, 0x32, 0xB3, 0xA2, 0xD5,
 0x23, 0xBC, 0x2B, 0x26, 0x88, 0xA4, 0x10, 0xBC, 0x58, 0x3A, 0xA0, 0xEA,
 0xB9, 0xAC, 0x23, 0xAC, 0x6D, 0x82, 0x24, 0xA0, 0x80, 0x32, 0x20, 0x50,
 0x01, 0x76, 0x20, 0x86, 0xBD, 0xEC, 0xD4, 0x2D, 0x43, 0xC2, 0x3A, 0xDB,
 0x3E, 0x32, 0x6E, 0xA6, 0x87, 0x60, 0x96, 0xBD, 0x01, 0x09, 0x12, 0x86,
 0xC4, 0xD1, 0xB3, 0x2B, 0x42, 0xB2, 0x3A, 0xA7, 0x3B, 0x3A, 0x5B, 0x97,
 0x57, 0x61, 0x96, 0x22, 0xE0, 0x86, 0x34, 0xEB, 0x24, 0x22, 0x4D, 0xC2,
 0x33, 0xA4, 0xBA, 0x29, 0xF4, 0x87, 0xB3, 0x61, 0x96, 0x49, 0xE0, 0x86,
 0x16, 0xD1, 0xB3, 0xD3, 0x42, 0xE2, 0xD2, 0xAB, 0x2A, 0x3A, 0xC1, 0xCE,
 0x30, 0x71, 0x96, 0x13, 0xE0, 0x86, 0x4F, 0xE9, 0xF4, 0x1B, 0x31, 0x42,
 0x3A, 0x94, 0x1A, 0x32, 0xC2, 0xBB, 0x17, 0x61, 0x96, 0x32, 0xE0, 0x86,
 0x12, 0x71, 0xA7, 0x15, 0x33, 0x22, 0x1B, 0x96, 0xB9, 0x23, 0xF2, 0x5A,
 0x51, 0x73, 0x96, 0x1A, 0xE0, 0x86, 0x2D, 0xD4, 0x14, 0x22, 0x44, 0xC2,
 0x1C, 0xB1, 0x2B, 0xC4, 0x5B, 0xAF, 0x36, 0x61, 0x96, 0x07, 0xE0, 0x86,
 0x12, 0xF1, 0x8B, 0x1B, 0x32, 0x42, 0x23, 0xB1, 0xBA, 0x41, 0xC3, 0xAC,
 0x14, 0x61, 0x96, 0x29, 0xE0, 0x86, 0x3C, 0xCC, 0x43, 0x1B, 0x52, 0x42,
 0x4A, 0xC2, 0x2A, 0x2C, 0xAB, 0x3A, 0x3A, 0xB2, 0x96, 0x3A, 0x80, 0x86,
 0x18, 0x51, 0xE4, 0xB3, 0xF1, 0x23, 0x13, 0xC3, 0xAA, 0x3A, 0xBB, 0x3E,
 0x24, 0x61, 0x96, 0x24, 0xE0, 0x00
};

/* AC FXO LC Filter ETSI ES203 021 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_ETSI[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter TBR21 with Current Limit 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_TBR21_CR[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x38, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter Telcordia GR-57 600R Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_GR57[] =
{
  /* AC Profile */
 0xF6, 0x00, 0x42, 0xF2, 0x01, 0x4B, 0xCA, 0xFF, 0x98, 0xAA, 0x42, 0x2E,
 0xAC, 0xA2, 0xAA, 0xC2, 0x2C, 0x42, 0x33, 0x9A, 0xCA, 0x87, 0x01, 0x6E,
 0x01, 0x8A, 0xB3, 0xD0, 0x24, 0x20, 0xAC, 0xA9, 0x32, 0xB3, 0xA2, 0xD5,
 0x23, 0xBC, 0x2B, 0x26, 0x88, 0xA4, 0x10, 0xBC, 0x58, 0x3A, 0xA0, 0xEA,
 0xB9, 0xAC, 0x23, 0xAC, 0x6D, 0x82, 0x24, 0xA0, 0x80, 0x32, 0x20, 0x50,
 0x01, 0x76, 0x20, 0x86, 0xBD, 0xEC, 0xD4, 0x2D, 0x43, 0xC2, 0x3A, 0xDB,
 0x3E, 0x32, 0x6E, 0xA6, 0x87, 0x60, 0x96, 0xBD, 0x01, 0x09, 0x12, 0x86,
 0xC4, 0xD1, 0xB3, 0x2B, 0x42, 0xB2, 0x3A, 0xA7, 0x3B, 0x3A, 0x5B, 0x97,
 0x57, 0x61, 0x96, 0x22, 0xE0, 0x86, 0x34, 0xEB, 0x24, 0x22, 0x4D, 0xC2,
 0x33, 0xA4, 0xBA, 0x29, 0xF4, 0x87, 0xB3, 0x61, 0x96, 0x49, 0xE0, 0x86,
 0x16, 0xD1, 0xB3, 0xD3, 0x42, 0xE2, 0xD2, 0xAB, 0x2A, 0x3A, 0xC1, 0xCE,
 0x30, 0x71, 0x96, 0x13, 0xE0, 0x86, 0x4F, 0xE9, 0xF4, 0x1B, 0x31, 0x42,
 0x3A, 0x94, 0x1A, 0x32, 0xC2, 0xBB, 0x17, 0x61, 0x96, 0x32, 0xE0, 0x86,
 0x12, 0x71, 0xA7, 0x15, 0x33, 0x22, 0x1B, 0x96, 0xB9, 0x23, 0xF2, 0x5A,
 0x51, 0x73, 0x96, 0x1A, 0xE0, 0x86, 0x2D, 0xD4, 0x14, 0x22, 0x44, 0xC2,
 0x1C, 0xB1, 0x2B, 0xC4, 0x5B, 0xAF, 0x36, 0x61, 0x96, 0x07, 0xE0, 0x86,
 0x12, 0xF1, 0x8B, 0x1B, 0x32, 0x42, 0x23, 0xB1, 0xBA, 0x41, 0xC3, 0xAC,
 0x14, 0x61, 0x96, 0x29, 0xE0, 0x86, 0x3C, 0xCC, 0x43, 0x1B, 0x52, 0x42,
 0x4A, 0xC2, 0x2A, 0x2C, 0xAB, 0x3A, 0x3A, 0xB2, 0x96, 0x3A, 0x80, 0x86,
 0x18, 0x51, 0xE4, 0xB3, 0xF1, 0x23, 0x13, 0xC3, 0xAA, 0x3A, 0xBB, 0x3E,
 0x24, 0x61, 0x96, 0x24, 0xE0, 0x00
};

/* AC FXO LC Filter Austria 220R+820R//115nF Normal Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_AT[] =
{
  /* AC Profile */
 0x10, 0x00, 0xB6, 0xF2, 0x01, 0x4B, 0xCA, 0xFD, 0x98, 0xB2, 0x33, 0x2A,
 0x97, 0xAA, 0x2C, 0x5A, 0xAC, 0xAA, 0x34, 0x9A, 0x01, 0x90, 0x08, 0x9F,
 0x01, 0x8A, 0x3B, 0xC0, 0x22, 0x10, 0xDA, 0xA9, 0x2B, 0xA8, 0x32, 0x21,
 0xA2, 0xA9, 0x52, 0xB3, 0x88, 0xE2, 0x50, 0x52, 0x3A, 0x2A, 0x22, 0x22,
 0xA3, 0x32, 0xAB, 0x2D, 0xB4, 0x82, 0xC2, 0x31, 0x80, 0xAA, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0xBA, 0xEC, 0x97, 0x2B, 0x34, 0x27, 0x3A, 0xA2,
 0xAA, 0xAA, 0xB2, 0xAC, 0x36, 0x60, 0x96, 0x2E, 0x01, 0x09, 0x12, 0x86,
 0x23, 0xFA, 0x97, 0xAA, 0x3A, 0x97, 0xAA, 0xAA, 0xAA, 0xF4, 0xBB, 0x2C,
 0x2B, 0x60, 0x96, 0x2E, 0x01, 0x86, 0x3A, 0xDA, 0x5F, 0xAA, 0x33, 0xAE,
 0xC7, 0xAD, 0x4A, 0xFA, 0xAA, 0xCB, 0x42, 0xC0, 0x96, 0xB4, 0x41, 0x86,
 0xBA, 0xDA, 0x3F, 0xAA, 0x3A, 0xAF, 0x98, 0x9A, 0x3A, 0xAA, 0xAA, 0x3B,
 0x2B, 0xB0, 0x96, 0xBC, 0x31, 0x86, 0x97, 0xF2, 0xAD, 0xBA, 0x42, 0xA3,
 0xCB, 0xB3, 0xCA, 0x2C, 0xA3, 0xAA, 0xD2, 0xB0, 0x96, 0x32, 0xA0, 0x86,
 0x3A, 0x6B, 0xA2, 0x2A, 0x02, 0xA4, 0xA3, 0x8A, 0x18, 0x23, 0x8E, 0xB8,
 0xBA, 0x80, 0x96, 0xA2, 0xA0, 0x86, 0xE8, 0xF2, 0x2F, 0x2B, 0x44, 0xA3,
 0xC6, 0xCA, 0x2B, 0x2E, 0xBA, 0x2C, 0x33, 0x70, 0x96, 0x2E, 0x01, 0x86,
 0xF8, 0x72, 0xBE, 0x3C, 0x43, 0xA3, 0x22, 0xC2, 0xAA, 0xA2, 0xB2, 0xAB,
 0xA3, 0x70, 0x96, 0x2E, 0x01, 0x86, 0xCC, 0xE2, 0xBD, 0x3A, 0x43, 0x24,
 0xBB, 0xBA, 0xBA, 0x4B, 0xA2, 0x2B, 0xA6, 0xB0, 0x96, 0x5D, 0x21, 0x86,
 0xBA, 0xEA, 0x87, 0xAB, 0x3C, 0x75, 0x2A, 0xA2, 0xAA, 0x5A, 0xB2, 0xED,
 0x52, 0x60, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXO LC Filter Australia 220R+820R//120nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_AU[] =
{
  /* AC Profile */
 0x10, 0x00, 0xB6, 0xF2, 0x01, 0x4B, 0xCA, 0xFD, 0x98, 0xB2, 0x33, 0x2A,
 0x97, 0xAA, 0x2C, 0x5A, 0xAC, 0xAA, 0x34, 0x9A, 0x01, 0x90, 0x08, 0x9F,
 0x01, 0x8A, 0x3B, 0xC0, 0x22, 0x10, 0xDA, 0xA9, 0x2B, 0xA8, 0x32, 0x21,
 0xA2, 0xA9, 0x52, 0xB3, 0x88, 0xE2, 0x50, 0x52, 0x3A, 0x2A, 0x22, 0x22,
 0xA3, 0x32, 0xAB, 0x2D, 0xB4, 0x82, 0xC2, 0x31, 0x80, 0xAA, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0xBA, 0xEC, 0x97, 0x2B, 0x34, 0x27, 0x3A, 0xA2,
 0xAA, 0xAA, 0xB2, 0xAC, 0x36, 0x60, 0x96, 0x2E, 0x01, 0x09, 0x12, 0x86,
 0x23, 0xFA, 0x97, 0xAA, 0x3A, 0x97, 0xAA, 0xAA, 0xAA, 0xF4, 0xBB, 0x2C,
 0x2B, 0x60, 0x96, 0x2E, 0x01, 0x86, 0x3A, 0xDA, 0x5F, 0xAA, 0x33, 0xAE,
 0xC7, 0xAD, 0x4A, 0xFA, 0xAA, 0xCB, 0x42, 0xC0, 0x96, 0xB4, 0x41, 0x86,
 0xBA, 0xDA, 0x3F, 0xAA, 0x3A, 0xAF, 0x98, 0x9A, 0x3A, 0xAA, 0xAA, 0x3B,
 0x2B, 0xB0, 0x96, 0xBC, 0x31, 0x86, 0x97, 0xF2, 0xAD, 0xBA, 0x42, 0xA3,
 0xCB, 0xB3, 0xCA, 0x2C, 0xA3, 0xAA, 0xD2, 0xB0, 0x96, 0x32, 0xA0, 0x86,
 0x3A, 0x6B, 0xA2, 0x2A, 0x02, 0xA4, 0xA3, 0x8A, 0x18, 0x23, 0x8E, 0xB8,
 0xBA, 0x80, 0x96, 0xA2, 0xA0, 0x86, 0xE8, 0xF2, 0x2F, 0x2B, 0x44, 0xA3,
 0xC6, 0xCA, 0x2B, 0x2E, 0xBA, 0x2C, 0x33, 0x70, 0x96, 0x2E, 0x01, 0x86,
 0xF8, 0x72, 0xBE, 0x3C, 0x43, 0xA3, 0x22, 0xC2, 0xAA, 0xA2, 0xB2, 0xAB,
 0xA3, 0x70, 0x96, 0x2E, 0x01, 0x86, 0xCC, 0xE2, 0xBD, 0x3A, 0x43, 0x24,
 0xBB, 0xBA, 0xBA, 0x4B, 0xA2, 0x2B, 0xA6, 0xB0, 0x96, 0x5D, 0x21, 0x86,
 0xBA, 0xEA, 0x87, 0xAB, 0x3C, 0x75, 0x2A, 0xA2, 0xAA, 0x5A, 0xB2, 0xED,
 0x52, 0x60, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXO LC Filter Belgium 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_BE[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter Bulgaria 220R+820R//115nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_BG[] =
{
  /* AC Profile */
 0x10, 0x00, 0xB6, 0xF2, 0x01, 0x4B, 0xCA, 0xFD, 0x98, 0xB2, 0x33, 0x2A,
 0x97, 0xAA, 0x2C, 0x5A, 0xAC, 0xAA, 0x34, 0x9A, 0x01, 0x90, 0x08, 0x9F,
 0x01, 0x8A, 0x3B, 0xC0, 0x22, 0x10, 0xDA, 0xA9, 0x2B, 0xA8, 0x32, 0x21,
 0xA2, 0xA9, 0x52, 0xB3, 0x88, 0xE2, 0x50, 0x52, 0x3A, 0x2A, 0x22, 0x22,
 0xA3, 0x32, 0xAB, 0x2D, 0xB4, 0x82, 0xC2, 0x31, 0x80, 0xAA, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0xBA, 0xEC, 0x97, 0x2B, 0x34, 0x27, 0x3A, 0xA2,
 0xAA, 0xAA, 0xB2, 0xAC, 0x36, 0x60, 0x96, 0x2E, 0x01, 0x09, 0x12, 0x86,
 0x23, 0xFA, 0x97, 0xAA, 0x3A, 0x97, 0xAA, 0xAA, 0xAA, 0xF4, 0xBB, 0x2C,
 0x2B, 0x60, 0x96, 0x2E, 0x01, 0x86, 0x3A, 0xDA, 0x5F, 0xAA, 0x33, 0xAE,
 0xC7, 0xAD, 0x4A, 0xFA, 0xAA, 0xCB, 0x42, 0xC0, 0x96, 0xB4, 0x41, 0x86,
 0xBA, 0xDA, 0x3F, 0xAA, 0x3A, 0xAF, 0x98, 0x9A, 0x3A, 0xAA, 0xAA, 0x3B,
 0x2B, 0xB0, 0x96, 0xBC, 0x31, 0x86, 0x97, 0xF2, 0xAD, 0xBA, 0x42, 0xA3,
 0xCB, 0xB3, 0xCA, 0x2C, 0xA3, 0xAA, 0xD2, 0xB0, 0x96, 0x32, 0xA0, 0x86,
 0x3A, 0x6B, 0xA2, 0x2A, 0x02, 0xA4, 0xA3, 0x8A, 0x18, 0x23, 0x8E, 0xB8,
 0xBA, 0x80, 0x96, 0xA2, 0xA0, 0x86, 0xE8, 0xF2, 0x2F, 0x2B, 0x44, 0xA3,
 0xC6, 0xCA, 0x2B, 0x2E, 0xBA, 0x2C, 0x33, 0x70, 0x96, 0x2E, 0x01, 0x86,
 0xF8, 0x72, 0xBE, 0x3C, 0x43, 0xA3, 0x22, 0xC2, 0xAA, 0xA2, 0xB2, 0xAB,
 0xA3, 0x70, 0x96, 0x2E, 0x01, 0x86, 0xCC, 0xE2, 0xBD, 0x3A, 0x43, 0x24,
 0xBB, 0xBA, 0xBA, 0x4B, 0xA2, 0x2B, 0xA6, 0xB0, 0x96, 0x5D, 0x21, 0x86,
 0xBA, 0xEA, 0x87, 0xAB, 0x3C, 0x75, 0x2A, 0xA2, 0xAA, 0x5A, 0xB2, 0xED,
 0x52, 0x60, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXO LC Filter Switzerland 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_CH[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter China 200R+680R//100nF Coefficients (Voice Applications) */
const VpProfileDataType LE890_AC_FXO_LC_CN[] =
{
  /* AC Profile */
 0x7C, 0x00, 0xCA, 0xF2, 0x01, 0x4B, 0xCA, 0xFF, 0x98, 0xAD, 0xB3, 0x25,
 0xA7, 0xCA, 0xBC, 0xB2, 0x3D, 0xBA, 0xA4, 0x9A, 0x01, 0x90, 0x08, 0x9F,
 0x01, 0x8A, 0x5B, 0xC0, 0xAB, 0x10, 0x2B, 0x2C, 0xCC, 0xE8, 0xAB, 0xA0,
 0xA4, 0xA9, 0xC2, 0xA3, 0x88, 0x2A, 0x20, 0xB3, 0x39, 0xA3, 0x21, 0x33,
 0xFA, 0xB2, 0x24, 0xC2, 0x97, 0x82, 0x42, 0x31, 0x80, 0x2B, 0x60, 0x50,
 0x01, 0x76, 0x30, 0x86, 0xAB, 0xF2, 0xAD, 0xAA, 0x43, 0xA3, 0x2B, 0xB2,
 0xBA, 0x7A, 0xAA, 0xCB, 0x74, 0xC0, 0x96, 0xD3, 0x41, 0x09, 0x12, 0x86,
 0xA8, 0xF3, 0x3E, 0x9F, 0xB4, 0xA6, 0xE2, 0x6A, 0xAA, 0x63, 0xAB, 0xBA,
 0x23, 0xB0, 0x96, 0xAA, 0x21, 0x86, 0xFB, 0xEB, 0x87, 0x3B, 0x3A, 0xB5,
 0x73, 0xBA, 0xBB, 0x23, 0xD2, 0xB7, 0x2A, 0x50, 0x96, 0x3D, 0x01, 0x86,
 0xBA, 0xEA, 0x87, 0xBA, 0x3A, 0x2F, 0x3A, 0xA2, 0x3B, 0xDB, 0xCB, 0x9F,
 0x22, 0x60, 0x96, 0x1E, 0x01, 0x86, 0xBA, 0xEB, 0x87, 0x3B, 0x34, 0x27,
 0xAA, 0xA4, 0xAA, 0xAA, 0xBA, 0x2D, 0xB3, 0x60, 0x96, 0x2E, 0x01, 0x86,
 0x22, 0xE2, 0xAF, 0xAB, 0x32, 0xAE, 0x97, 0xAA, 0x5A, 0x2A, 0xAC, 0xAB,
 0xC8, 0xF0, 0x96, 0x2E, 0x01, 0x86, 0x2B, 0xD3, 0xAE, 0xAA, 0x3C, 0xCF,
 0xB4, 0xAA, 0x2A, 0x2B, 0xA2, 0x3B, 0x3B, 0xB0, 0x96, 0xAB, 0x41, 0x86,
 0x23, 0xEA, 0x4F, 0xAA, 0x3C, 0x9F, 0xA5, 0xA2, 0x3A, 0xBB, 0xAF, 0x2B,
 0xAC, 0xB0, 0x96, 0x5D, 0x21, 0x86, 0xAB, 0xF2, 0xAD, 0xAA, 0x43, 0xA3,
 0x2B, 0xB2, 0xBA, 0x7A, 0xAA, 0xCB, 0x74, 0xC0, 0x96, 0xD3, 0x41, 0x86,
 0xA8, 0xF2, 0xAD, 0xAC, 0xB9, 0xF7, 0xA8, 0xFB, 0xAA, 0xAD, 0xA2, 0xAA,
 0x52, 0xC0, 0x96, 0xAB, 0xA1, 0x00
};

/* AC FXO LC Filter China 600R Normal ABF Coefficients (Modem Applications) */
const VpProfileDataType LE890_AC_FXO_LC_CN2[] =
{
  /* AC Profile */
 0xF6, 0x00, 0x42, 0xF2, 0x01, 0x4B, 0xCA, 0xFF, 0x98, 0xAA, 0x42, 0x2E,
 0xAC, 0xA2, 0xAA, 0xC2, 0x2C, 0x42, 0x33, 0x9A, 0xCA, 0x87, 0x01, 0x6E,
 0x01, 0x8A, 0xB3, 0xD0, 0x24, 0x20, 0xAC, 0xA9, 0x32, 0xB3, 0xA2, 0xD5,
 0x23, 0xBC, 0x2B, 0x26, 0x88, 0xA4, 0x10, 0xBC, 0x58, 0x3A, 0xA0, 0xEA,
 0xB9, 0xAC, 0x23, 0xAC, 0x6D, 0x82, 0x24, 0xA0, 0x80, 0x32, 0x20, 0x50,
 0x01, 0x76, 0x20, 0x86, 0xBD, 0xEC, 0xD4, 0x2D, 0x43, 0xC2, 0x3A, 0xDB,
 0x3E, 0x32, 0x6E, 0xA6, 0x87, 0x60, 0x96, 0xBD, 0x01, 0x09, 0x12, 0x86,
 0xC4, 0xD1, 0xB3, 0x2B, 0x42, 0xB2, 0x3A, 0xA7, 0x3B, 0x3A, 0x5B, 0x97,
 0x57, 0x61, 0x96, 0x22, 0xE0, 0x86, 0x34, 0xEB, 0x24, 0x22, 0x4D, 0xC2,
 0x33, 0xA4, 0xBA, 0x29, 0xF4, 0x87, 0xB3, 0x61, 0x96, 0x49, 0xE0, 0x86,
 0x16, 0xD1, 0xB3, 0xD3, 0x42, 0xE2, 0xD2, 0xAB, 0x2A, 0x3A, 0xC1, 0xCE,
 0x30, 0x71, 0x96, 0x13, 0xE0, 0x86, 0x4F, 0xE9, 0xF4, 0x1B, 0x31, 0x42,
 0x3A, 0x94, 0x1A, 0x32, 0xC2, 0xBB, 0x17, 0x61, 0x96, 0x32, 0xE0, 0x86,
 0x12, 0x71, 0xA7, 0x15, 0x33, 0x22, 0x1B, 0x96, 0xB9, 0x23, 0xF2, 0x5A,
 0x51, 0x73, 0x96, 0x1A, 0xE0, 0x86, 0x2D, 0xD4, 0x14, 0x22, 0x44, 0xC2,
 0x1C, 0xB1, 0x2B, 0xC4, 0x5B, 0xAF, 0x36, 0x61, 0x96, 0x07, 0xE0, 0x86,
 0x12, 0xF1, 0x8B, 0x1B, 0x32, 0x42, 0x23, 0xB1, 0xBA, 0x41, 0xC3, 0xAC,
 0x14, 0x61, 0x96, 0x29, 0xE0, 0x86, 0x3C, 0xCC, 0x43, 0x1B, 0x52, 0x42,
 0x4A, 0xC2, 0x2A, 0x2C, 0xAB, 0x3A, 0x3A, 0xB2, 0x96, 0x3A, 0x80, 0x86,
 0x18, 0x51, 0xE4, 0xB3, 0xF1, 0x23, 0x13, 0xC3, 0xAA, 0x3A, 0xBB, 0x3E,
 0x24, 0x61, 0x96, 0x24, 0xE0, 0x00
};

/* AC FXO LC Filter Germany 220R+820R//115nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_DE[] =
{
  /* AC Profile */
 0x10, 0x00, 0xB6, 0xF2, 0x01, 0x4B, 0xCA, 0xFD, 0x98, 0xB2, 0x33, 0x2A,
 0x97, 0xAA, 0x2C, 0x5A, 0xAC, 0xAA, 0x34, 0x9A, 0x01, 0x90, 0x08, 0x9F,
 0x01, 0x8A, 0x3B, 0xC0, 0x22, 0x10, 0xDA, 0xA9, 0x2B, 0xA8, 0x32, 0x21,
 0xA2, 0xA9, 0x52, 0xB3, 0x88, 0xE2, 0x50, 0x52, 0x3A, 0x2A, 0x22, 0x22,
 0xA3, 0x32, 0xAB, 0x2D, 0xB4, 0x82, 0xC2, 0x31, 0x80, 0xAA, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0xBA, 0xEC, 0x97, 0x2B, 0x34, 0x27, 0x3A, 0xA2,
 0xAA, 0xAA, 0xB2, 0xAC, 0x36, 0x60, 0x96, 0x2E, 0x01, 0x09, 0x12, 0x86,
 0x23, 0xFA, 0x97, 0xAA, 0x3A, 0x97, 0xAA, 0xAA, 0xAA, 0xF4, 0xBB, 0x2C,
 0x2B, 0x60, 0x96, 0x2E, 0x01, 0x86, 0x3A, 0xDA, 0x5F, 0xAA, 0x33, 0xAE,
 0xC7, 0xAD, 0x4A, 0xFA, 0xAA, 0xCB, 0x42, 0xC0, 0x96, 0xB4, 0x41, 0x86,
 0xBA, 0xDA, 0x3F, 0xAA, 0x3A, 0xAF, 0x98, 0x9A, 0x3A, 0xAA, 0xAA, 0x3B,
 0x2B, 0xB0, 0x96, 0xBC, 0x31, 0x86, 0x97, 0xF2, 0xAD, 0xBA, 0x42, 0xA3,
 0xCB, 0xB3, 0xCA, 0x2C, 0xA3, 0xAA, 0xD2, 0xB0, 0x96, 0x32, 0xA0, 0x86,
 0x3A, 0x6B, 0xA2, 0x2A, 0x02, 0xA4, 0xA3, 0x8A, 0x18, 0x23, 0x8E, 0xB8,
 0xBA, 0x80, 0x96, 0xA2, 0xA0, 0x86, 0xE8, 0xF2, 0x2F, 0x2B, 0x44, 0xA3,
 0xC6, 0xCA, 0x2B, 0x2E, 0xBA, 0x2C, 0x33, 0x70, 0x96, 0x2E, 0x01, 0x86,
 0xF8, 0x72, 0xBE, 0x3C, 0x43, 0xA3, 0x22, 0xC2, 0xAA, 0xA2, 0xB2, 0xAB,
 0xA3, 0x70, 0x96, 0x2E, 0x01, 0x86, 0xCC, 0xE2, 0xBD, 0x3A, 0x43, 0x24,
 0xBB, 0xBA, 0xBA, 0x4B, 0xA2, 0x2B, 0xA6, 0xB0, 0x96, 0x5D, 0x21, 0x86,
 0xBA, 0xEA, 0x87, 0xAB, 0x3C, 0x75, 0x2A, 0xA2, 0xAA, 0x5A, 0xB2, 0xED,
 0x52, 0x60, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXO LC Filter Denmark 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_DK[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter Spain 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_ES[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter Finland 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_FI[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter France 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_FR[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter UK 370R+620R//310nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_GB[] =
{
  /* AC Profile */
 0xE4, 0x00, 0x71, 0xF2, 0x01, 0x4B, 0xCA, 0xFF, 0x98, 0x23, 0xA2, 0xA4,
 0x3E, 0x3C, 0x4B, 0xC2, 0xAB, 0x3C, 0xA3, 0x9A, 0x01, 0x90, 0x08, 0x2E,
 0x01, 0x8A, 0xFA, 0xB0, 0xAA, 0x10, 0x2A, 0xAA, 0x3C, 0xA9, 0xA5, 0x2C,
 0x2C, 0xA3, 0x33, 0xBC, 0x88, 0xAA, 0xB0, 0x2D, 0xB4, 0xCF, 0xAA, 0xB4,
 0x21, 0xAE, 0xB9, 0xB2, 0xC2, 0x82, 0x3B, 0x21, 0x80, 0xAC, 0x20, 0x50,
 0x01, 0x76, 0x34, 0x86, 0xBD, 0xFB, 0x37, 0x3E, 0x62, 0xA6, 0x2A, 0xD2,
 0xAC, 0x5A, 0xC2, 0xAC, 0xBA, 0x60, 0x96, 0x2E, 0x01, 0x09, 0x12, 0x86,
 0xD8, 0x72, 0xAE, 0x23, 0xB3, 0x2C, 0x3A, 0xD2, 0xAA, 0xAA, 0xAB, 0x2B,
 0xAA, 0xB0, 0x96, 0x2B, 0x21, 0x86, 0x2A, 0xEA, 0x97, 0xAA, 0x5C, 0xAC,
 0x22, 0xCA, 0xCC, 0x6A, 0xCB, 0x2D, 0xA2, 0x70, 0x96, 0x2E, 0x01, 0x86,
 0xAA, 0xE7, 0xB7, 0x5A, 0x5C, 0xAB, 0xA3, 0xB2, 0x3C, 0xB2, 0xD4, 0xCD,
 0x2C, 0x60, 0x96, 0x2E, 0x01, 0x86, 0x3A, 0xE2, 0x27, 0x22, 0x5C, 0xAB,
 0x3A, 0xAA, 0xBB, 0x3B, 0xC3, 0x3D, 0x3B, 0x60, 0x96, 0x2E, 0x01, 0x86,
 0xB2, 0xEB, 0xAF, 0x6A, 0x4A, 0xBB, 0xA3, 0xA4, 0xBA, 0xA6, 0xBA, 0x2C,
 0x3C, 0xC0, 0x96, 0x3B, 0x41, 0x86, 0xA2, 0xE2, 0xCF, 0x32, 0x5A, 0xAB,
 0x25, 0xAA, 0xBA, 0xB2, 0xBA, 0xAB, 0x22, 0xC0, 0x96, 0x5D, 0x21, 0x86,
 0xD8, 0x7B, 0x8F, 0xAC, 0x7B, 0xAC, 0x6A, 0xBD, 0x2C, 0xAA, 0xC2, 0x5D,
 0x3B, 0x70, 0x96, 0x2E, 0x01, 0x86, 0xAA, 0xED, 0xAD, 0xB9, 0xFB, 0x3D,
 0xD3, 0xB2, 0xAA, 0x3D, 0xBD, 0x2C, 0xBD, 0xC0, 0x96, 0xAD, 0x21, 0x86,
 0xA8, 0xFA, 0x87, 0x98, 0xA4, 0xCB, 0xB5, 0x5C, 0xAE, 0xA2, 0xC2, 0x3C,
 0x4A, 0x60, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXO LC Filter Hong Kong SAR 600R ABF Coefficients - 4 KHz Return Loss */
const VpProfileDataType LE890_AC_FXO_LC_HK[] =
{
  /* AC Profile */
 0xD0, 0x00, 0x7E, 0xF2, 0x01, 0x4B, 0xCA, 0x05, 0x98, 0xCD, 0x2C, 0x23,
 0xA5, 0x3B, 0xAD, 0x3A, 0xAC, 0xEA, 0x24, 0x9A, 0x01, 0x90, 0x08, 0x2E,
 0x01, 0x8A, 0xB3, 0xD0, 0x56, 0x20, 0xA2, 0xA9, 0x25, 0xA3, 0xAE, 0x35,
 0x22, 0x6C, 0xA7, 0xA5, 0x88, 0xB4, 0x10, 0x42, 0x58, 0xA2, 0xB0, 0xCA,
 0xD9, 0xA2, 0xA2, 0x23, 0xED, 0x82, 0xB3, 0xA0, 0x80, 0x98, 0x10, 0x50,
 0x01, 0x76, 0x20, 0x86, 0x23, 0xFB, 0xC7, 0x24, 0x33, 0x23, 0xB2, 0x72,
 0xAD, 0xB8, 0x7B, 0xA6, 0xBA, 0x60, 0x96, 0xCC, 0x01, 0x09, 0x12, 0x86,
 0xA2, 0x6C, 0x3C, 0x23, 0x36, 0xA8, 0x10, 0x84, 0x08, 0x2D, 0x8C, 0xCA,
 0xBD, 0xF0, 0x96, 0x2E, 0x01, 0x86, 0xAA, 0x22, 0x3D, 0x33, 0x5D, 0xA8,
 0x00, 0x80, 0x08, 0xDB, 0x1D, 0x10, 0x52, 0x30, 0x96, 0x5B, 0x87, 0x86,
 0xB3, 0xCA, 0xA8, 0x20, 0x8B, 0x28, 0xCC, 0xAA, 0x3D, 0xB2, 0x3A, 0xA4,
 0xA3, 0xE0, 0x96, 0xBC, 0x01, 0x86, 0xC4, 0xD1, 0xB3, 0x2B, 0x42, 0xB2,
 0x3A, 0xA7, 0x3B, 0x3A, 0x5B, 0x97, 0x57, 0x61, 0x96, 0x22, 0xE0, 0x86,
 0x34, 0xEB, 0x24, 0x22, 0x4D, 0xC2, 0x33, 0xA4, 0xBA, 0x29, 0xF4, 0x87,
 0xB3, 0x61, 0x96, 0x49, 0xE0, 0x86, 0x16, 0xD1, 0xB3, 0xD3, 0x42, 0xE2,
 0xD2, 0xAB, 0x2A, 0x3A, 0xC1, 0xCE, 0x30, 0x71, 0x96, 0x13, 0xE0, 0x86,
 0x4F, 0xE9, 0xF4, 0x1B, 0x31, 0x42, 0x3A, 0x94, 0x1A, 0x32, 0xC2, 0xBB,
 0x17, 0x61, 0x96, 0x32, 0xE0, 0x86, 0x3C, 0xCC, 0x43, 0x1B, 0x52, 0x42,
 0x4A, 0xC2, 0x2A, 0x2C, 0xAB, 0x3A, 0x3A, 0xB2, 0x96, 0x3A, 0x80, 0x86,
 0x18, 0x51, 0xE4, 0xB3, 0xF1, 0x23, 0x13, 0xC3, 0xAA, 0x3A, 0xBB, 0x3E,
 0x24, 0x61, 0x96, 0x24, 0xE0, 0x00
};

/* AC FXO LC Filter Hungary 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_HU[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter Ireland 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_IE[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter Italy 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_IT[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter Japan 600R Lowest ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_JP[] =
{
  /* AC Profile */
 0xF6, 0x00, 0x42, 0xF2, 0x01, 0x4B, 0xCA, 0xFF, 0x98, 0xAA, 0x42, 0x2E,
 0xAC, 0xA2, 0xAA, 0xC2, 0x2C, 0x42, 0x33, 0x9A, 0xCA, 0x87, 0x01, 0x6E,
 0x01, 0x8A, 0xB3, 0xD0, 0x24, 0x20, 0xAC, 0xA9, 0x32, 0xB3, 0xA2, 0xD5,
 0x23, 0xBC, 0x2B, 0x26, 0x88, 0xA4, 0x10, 0xBC, 0x58, 0x3A, 0xA0, 0xEA,
 0xB9, 0xAC, 0x23, 0xAC, 0x6D, 0x82, 0x24, 0xA0, 0x80, 0x32, 0x20, 0x50,
 0x01, 0x76, 0x60, 0x86, 0xBD, 0xEC, 0xD4, 0x2D, 0x43, 0xC2, 0x3A, 0xDB,
 0x3E, 0x32, 0x6E, 0xA6, 0x87, 0x60, 0x96, 0xBD, 0x01, 0x09, 0x12, 0x86,
 0xC4, 0xD1, 0xB3, 0x2B, 0x42, 0xB2, 0x3A, 0xA7, 0x3B, 0x3A, 0x5B, 0x97,
 0x57, 0x61, 0x96, 0x22, 0xE0, 0x86, 0x34, 0xEB, 0x24, 0x22, 0x4D, 0xC2,
 0x33, 0xA4, 0xBA, 0x29, 0xF4, 0x87, 0xB3, 0x61, 0x96, 0x49, 0xE0, 0x86,
 0x16, 0xD1, 0xB3, 0xD3, 0x42, 0xE2, 0xD2, 0xAB, 0x2A, 0x3A, 0xC1, 0xCE,
 0x30, 0x71, 0x96, 0x13, 0xE0, 0x86, 0x4F, 0xE9, 0xF4, 0x1B, 0x31, 0x42,
 0x3A, 0x94, 0x1A, 0x32, 0xC2, 0xBB, 0x17, 0x61, 0x96, 0x32, 0xE0, 0x86,
 0x12, 0x71, 0xA7, 0x15, 0x33, 0x22, 0x1B, 0x96, 0xB9, 0x23, 0xF2, 0x5A,
 0x51, 0x73, 0x96, 0x1A, 0xE0, 0x86, 0x2D, 0xD4, 0x14, 0x22, 0x44, 0xC2,
 0x1C, 0xB1, 0x2B, 0xC4, 0x5B, 0xAF, 0x36, 0x61, 0x96, 0x07, 0xE0, 0x86,
 0x12, 0xF1, 0x8B, 0x1B, 0x32, 0x42, 0x23, 0xB1, 0xBA, 0x41, 0xC3, 0xAC,
 0x14, 0x61, 0x96, 0x29, 0xE0, 0x86, 0x3C, 0xCC, 0x43, 0x1B, 0x52, 0x42,
 0x4A, 0xC2, 0x2A, 0x2C, 0xAB, 0x3A, 0x3A, 0xB2, 0x96, 0x3A, 0x80, 0x86,
 0x18, 0x51, 0xE4, 0xB3, 0xF1, 0x23, 0x13, 0xC3, 0xAA, 0x3A, 0xBB, 0x3E,
 0x24, 0x61, 0x96, 0x24, 0xE0, 0x00
};

/* AC FXO LC Filter Malaysia 600R Low ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_MY[] =
{
  /* AC Profile */
 0xF6, 0x00, 0x42, 0xF2, 0x01, 0x4B, 0xCA, 0xFF, 0x98, 0xAA, 0x42, 0x2E,
 0xAC, 0xA2, 0xAA, 0xC2, 0x2C, 0x42, 0x33, 0x9A, 0xCA, 0x87, 0x01, 0x6E,
 0x01, 0x8A, 0xB3, 0xD0, 0x24, 0x20, 0xAC, 0xA9, 0x32, 0xB3, 0xA2, 0xD5,
 0x23, 0xBC, 0x2B, 0x26, 0x88, 0xA4, 0x10, 0xBC, 0x58, 0x3A, 0xA0, 0xEA,
 0xB9, 0xAC, 0x23, 0xAC, 0x6D, 0x82, 0x24, 0xA0, 0x80, 0x32, 0x20, 0x50,
 0x01, 0x76, 0x40, 0x86, 0xBD, 0xEC, 0xD4, 0x2D, 0x43, 0xC2, 0x3A, 0xDB,
 0x3E, 0x32, 0x6E, 0xA6, 0x87, 0x60, 0x96, 0xBD, 0x01, 0x09, 0x12, 0x86,
 0xC4, 0xD1, 0xB3, 0x2B, 0x42, 0xB2, 0x3A, 0xA7, 0x3B, 0x3A, 0x5B, 0x97,
 0x57, 0x61, 0x96, 0x22, 0xE0, 0x86, 0x34, 0xEB, 0x24, 0x22, 0x4D, 0xC2,
 0x33, 0xA4, 0xBA, 0x29, 0xF4, 0x87, 0xB3, 0x61, 0x96, 0x49, 0xE0, 0x86,
 0x16, 0xD1, 0xB3, 0xD3, 0x42, 0xE2, 0xD2, 0xAB, 0x2A, 0x3A, 0xC1, 0xCE,
 0x30, 0x71, 0x96, 0x13, 0xE0, 0x86, 0x4F, 0xE9, 0xF4, 0x1B, 0x31, 0x42,
 0x3A, 0x94, 0x1A, 0x32, 0xC2, 0xBB, 0x17, 0x61, 0x96, 0x32, 0xE0, 0x86,
 0x12, 0x71, 0xA7, 0x15, 0x33, 0x22, 0x1B, 0x96, 0xB9, 0x23, 0xF2, 0x5A,
 0x51, 0x73, 0x96, 0x1A, 0xE0, 0x86, 0x2D, 0xD4, 0x14, 0x22, 0x44, 0xC2,
 0x1C, 0xB1, 0x2B, 0xC4, 0x5B, 0xAF, 0x36, 0x61, 0x96, 0x07, 0xE0, 0x86,
 0x12, 0xF1, 0x8B, 0x1B, 0x32, 0x42, 0x23, 0xB1, 0xBA, 0x41, 0xC3, 0xAC,
 0x14, 0x61, 0x96, 0x29, 0xE0, 0x86, 0x3C, 0xCC, 0x43, 0x1B, 0x52, 0x42,
 0x4A, 0xC2, 0x2A, 0x2C, 0xAB, 0x3A, 0x3A, 0xB2, 0x96, 0x3A, 0x80, 0x86,
 0x18, 0x51, 0xE4, 0xB3, 0xF1, 0x23, 0x13, 0xC3, 0xAA, 0x3A, 0xBB, 0x3E,
 0x24, 0x61, 0x96, 0x24, 0xE0, 0x00
};

/* AC FXO LC Filter Netherlands 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_NL[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter Norway 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_NO[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter New Zealand 370R+620R//310nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_NZ[] =
{
  /* AC Profile */
 0xE4, 0x00, 0x71, 0xF2, 0x01, 0x4B, 0xCA, 0xFF, 0x98, 0x23, 0xA2, 0xA4,
 0x3E, 0x3C, 0x4B, 0xC2, 0xAB, 0x3C, 0xA3, 0x9A, 0x01, 0x90, 0x08, 0x2E,
 0x01, 0x8A, 0xFA, 0xB0, 0xAA, 0x10, 0x2A, 0xAA, 0x3C, 0xA9, 0xA5, 0x2C,
 0x2C, 0xA3, 0x33, 0xBC, 0x88, 0xAA, 0xB0, 0x2D, 0xB4, 0xCF, 0xAA, 0xB4,
 0x21, 0xAE, 0xB9, 0xB2, 0xC2, 0x82, 0x3B, 0x21, 0x80, 0xAC, 0x20, 0x50,
 0x01, 0x76, 0x34, 0x86, 0xBD, 0xFB, 0x37, 0x3E, 0x62, 0xA6, 0x2A, 0xD2,
 0xAC, 0x5A, 0xC2, 0xAC, 0xBA, 0x60, 0x96, 0x2E, 0x01, 0x09, 0x12, 0x86,
 0xD8, 0x72, 0xAE, 0x23, 0xB3, 0x2C, 0x3A, 0xD2, 0xAA, 0xAA, 0xAB, 0x2B,
 0xAA, 0xB0, 0x96, 0x2B, 0x21, 0x86, 0x2A, 0xEA, 0x97, 0xAA, 0x5C, 0xAC,
 0x22, 0xCA, 0xCC, 0x6A, 0xCB, 0x2D, 0xA2, 0x70, 0x96, 0x2E, 0x01, 0x86,
 0xAA, 0xE7, 0xB7, 0x5A, 0x5C, 0xAB, 0xA3, 0xB2, 0x3C, 0xB2, 0xD4, 0xCD,
 0x2C, 0x60, 0x96, 0x2E, 0x01, 0x86, 0x3A, 0xE2, 0x27, 0x22, 0x5C, 0xAB,
 0x3A, 0xAA, 0xBB, 0x3B, 0xC3, 0x3D, 0x3B, 0x60, 0x96, 0x2E, 0x01, 0x86,
 0xB2, 0xEB, 0xAF, 0x6A, 0x4A, 0xBB, 0xA3, 0xA4, 0xBA, 0xA6, 0xBA, 0x2C,
 0x3C, 0xC0, 0x96, 0x3B, 0x41, 0x86, 0xA2, 0xE2, 0xCF, 0x32, 0x5A, 0xAB,
 0x25, 0xAA, 0xBA, 0xB2, 0xBA, 0xAB, 0x22, 0xC0, 0x96, 0x5D, 0x21, 0x86,
 0xD8, 0x7B, 0x8F, 0xAC, 0x7B, 0xAC, 0x6A, 0xBD, 0x2C, 0xAA, 0xC2, 0x5D,
 0x3B, 0x70, 0x96, 0x2E, 0x01, 0x86, 0xAA, 0xED, 0xAD, 0xB9, 0xFB, 0x3D,
 0xD3, 0xB2, 0xAA, 0x3D, 0xBD, 0x2C, 0xBD, 0xC0, 0x96, 0xAD, 0x21, 0x86,
 0xA8, 0xFA, 0x87, 0x98, 0xA4, 0xCB, 0xB5, 0x5C, 0xAE, 0xA2, 0xC2, 0x3C,
 0x4A, 0x60, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXO LC Filter Portugal 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_PT[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter Sweden 270R+750R//150nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_SE[] =
{
  /* AC Profile */
 0x3B, 0x00, 0xC2, 0xF2, 0x01, 0x4B, 0xCA, 0x00, 0x98, 0x2B, 0x45, 0x42,
 0xBF, 0xAB, 0x3D, 0x42, 0xAD, 0xBA, 0x25, 0x9A, 0xDC, 0x87, 0x01, 0x9F,
 0x01, 0x8A, 0xF3, 0xD0, 0xA2, 0x10, 0x2C, 0x2A, 0xBB, 0xA8, 0xA9, 0xF1,
 0xBB, 0xBA, 0xCA, 0xA4, 0x88, 0x3B, 0x30, 0x2A, 0xC9, 0xAC, 0x41, 0xBA,
 0x2C, 0xBA, 0xBD, 0x32, 0xC4, 0x82, 0x22, 0x31, 0x80, 0x4C, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0x44, 0xC2, 0xE2, 0xD6, 0xA2, 0x22, 0xB2, 0x5B,
 0x39, 0x3A, 0x1C, 0xBA, 0xAC, 0x50, 0x96, 0x9F, 0x01, 0x09, 0x12, 0x86,
 0xBC, 0xB1, 0xB1, 0x3F, 0x93, 0x12, 0x2B, 0x32, 0xC8, 0x32, 0x14, 0x1A,
 0x3C, 0x53, 0x96, 0x09, 0x60, 0x86, 0x12, 0xB2, 0x31, 0x4A, 0x82, 0x51,
 0x2B, 0x22, 0x28, 0x4C, 0x0B, 0x39, 0x4B, 0x53, 0x96, 0x09, 0x60, 0x86,
 0x43, 0xA1, 0xC0, 0xB2, 0x84, 0x11, 0x1B, 0x1F, 0x08, 0xC1, 0x03, 0xB8,
 0x20, 0x70, 0x96, 0xA9, 0xE0, 0x86, 0x35, 0xB6, 0xB2, 0x22, 0xC3, 0x17,
 0x42, 0xBC, 0x2A, 0x23, 0xA2, 0x0E, 0x23, 0xB4, 0x96, 0x39, 0x80, 0x86,
 0x61, 0xBC, 0x21, 0x5B, 0x83, 0x21, 0x3A, 0x12, 0x28, 0xD7, 0x0B, 0x29,
 0x32, 0x63, 0x96, 0xA9, 0xE0, 0x86, 0xBC, 0xB1, 0xB2, 0xB3, 0xBB, 0x63,
 0x41, 0xD6, 0x1B, 0x42, 0xA1, 0x97, 0x53, 0xBB, 0x96, 0x49, 0x80, 0x86,
 0x35, 0xBC, 0xB2, 0x52, 0xBC, 0x73, 0x2B, 0xC1, 0xBA, 0x3A, 0x94, 0x87,
 0x32, 0xB3, 0x96, 0x39, 0x80, 0x86, 0x18, 0x22, 0xB2, 0x13, 0xB2, 0x43,
 0x53, 0xC1, 0x2B, 0x41, 0xA3, 0xAE, 0x12, 0xBD, 0x96, 0x41, 0xA0, 0x86,
 0xCE, 0xB1, 0xB2, 0x17, 0xB1, 0xB3, 0xC2, 0xD1, 0xBA, 0x41, 0xA1, 0x2D,
 0x61, 0xB2, 0x96, 0xC2, 0xA0, 0x00
};

/* AC FXO LC Filter Taiwan 600R Low ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_TW[] =
{
  /* AC Profile */
 0xF6, 0x00, 0x42, 0xF2, 0x01, 0x4B, 0xCA, 0xFF, 0x98, 0xAA, 0x42, 0x2E,
 0xAC, 0xA2, 0xAA, 0xC2, 0x2C, 0x42, 0x33, 0x9A, 0xCA, 0x87, 0x01, 0x6E,
 0x01, 0x8A, 0xB3, 0xD0, 0x24, 0x20, 0xAC, 0xA9, 0x32, 0xB3, 0xA2, 0xD5,
 0x23, 0xBC, 0x2B, 0x26, 0x88, 0xA4, 0x10, 0xBC, 0x58, 0x3A, 0xA0, 0xEA,
 0xB9, 0xAC, 0x23, 0xAC, 0x6D, 0x82, 0x24, 0xA0, 0x80, 0x32, 0x20, 0x50,
 0x01, 0x76, 0x40, 0x86, 0xBD, 0xEC, 0xD4, 0x2D, 0x43, 0xC2, 0x3A, 0xDB,
 0x3E, 0x32, 0x6E, 0xA6, 0x87, 0x60, 0x96, 0xBD, 0x01, 0x09, 0x12, 0x86,
 0xC4, 0xD1, 0xB3, 0x2B, 0x42, 0xB2, 0x3A, 0xA7, 0x3B, 0x3A, 0x5B, 0x97,
 0x57, 0x61, 0x96, 0x22, 0xE0, 0x86, 0x34, 0xEB, 0x24, 0x22, 0x4D, 0xC2,
 0x33, 0xA4, 0xBA, 0x29, 0xF4, 0x87, 0xB3, 0x61, 0x96, 0x49, 0xE0, 0x86,
 0x16, 0xD1, 0xB3, 0xD3, 0x42, 0xE2, 0xD2, 0xAB, 0x2A, 0x3A, 0xC1, 0xCE,
 0x30, 0x71, 0x96, 0x13, 0xE0, 0x86, 0x4F, 0xE9, 0xF4, 0x1B, 0x31, 0x42,
 0x3A, 0x94, 0x1A, 0x32, 0xC2, 0xBB, 0x17, 0x61, 0x96, 0x32, 0xE0, 0x86,
 0x12, 0x71, 0xA7, 0x15, 0x33, 0x22, 0x1B, 0x96, 0xB9, 0x23, 0xF2, 0x5A,
 0x51, 0x73, 0x96, 0x1A, 0xE0, 0x86, 0x2D, 0xD4, 0x14, 0x22, 0x44, 0xC2,
 0x1C, 0xB1, 0x2B, 0xC4, 0x5B, 0xAF, 0x36, 0x61, 0x96, 0x07, 0xE0, 0x86,
 0x12, 0xF1, 0x8B, 0x1B, 0x32, 0x42, 0x23, 0xB1, 0xBA, 0x41, 0xC3, 0xAC,
 0x14, 0x61, 0x96, 0x29, 0xE0, 0x86, 0x3C, 0xCC, 0x43, 0x1B, 0x52, 0x42,
 0x4A, 0xC2, 0x2A, 0x2C, 0xAB, 0x3A, 0x3A, 0xB2, 0x96, 0x3A, 0x80, 0x86,
 0x18, 0x51, 0xE4, 0xB3, 0xF1, 0x23, 0x13, 0xC3, 0xAA, 0x3A, 0xBB, 0x3E,
 0x24, 0x61, 0x96, 0x24, 0xE0, 0x00
};

/* AC FXO LC Filter South Africa 220R+820R//115nF Normal ABF Coefficients */
const VpProfileDataType LE890_AC_FXO_LC_ZA[] =
{
  /* AC Profile */
 0x10, 0x00, 0xB6, 0xF2, 0x01, 0x4B, 0xCA, 0xFD, 0x98, 0xB2, 0x33, 0x2A,
 0x97, 0xAA, 0x2C, 0x5A, 0xAC, 0xAA, 0x34, 0x9A, 0x01, 0x90, 0x08, 0x9F,
 0x01, 0x8A, 0x3B, 0xC0, 0x22, 0x10, 0xDA, 0xA9, 0x2B, 0xA8, 0x32, 0x21,
 0xA2, 0xA9, 0x52, 0xB3, 0x88, 0xE2, 0x50, 0x52, 0x3A, 0x2A, 0x22, 0x22,
 0xA3, 0x32, 0xAB, 0x2D, 0xB4, 0x82, 0xC2, 0x31, 0x80, 0xAA, 0x50, 0x50,
 0x01, 0x76, 0x30, 0x86, 0xBA, 0xEC, 0x97, 0x2B, 0x34, 0x27, 0x3A, 0xA2,
 0xAA, 0xAA, 0xB2, 0xAC, 0x36, 0x60, 0x96, 0x2E, 0x01, 0x09, 0x12, 0x86,
 0x23, 0xFA, 0x97, 0xAA, 0x3A, 0x97, 0xAA, 0xAA, 0xAA, 0xF4, 0xBB, 0x2C,
 0x2B, 0x60, 0x96, 0x2E, 0x01, 0x86, 0x3A, 0xDA, 0x5F, 0xAA, 0x33, 0xAE,
 0xC7, 0xAD, 0x4A, 0xFA, 0xAA, 0xCB, 0x42, 0xC0, 0x96, 0xB4, 0x41, 0x86,
 0xBA, 0xDA, 0x3F, 0xAA, 0x3A, 0xAF, 0x98, 0x9A, 0x3A, 0xAA, 0xAA, 0x3B,
 0x2B, 0xB0, 0x96, 0xBC, 0x31, 0x86, 0x97, 0xF2, 0xAD, 0xBA, 0x42, 0xA3,
 0xCB, 0xB3, 0xCA, 0x2C, 0xA3, 0xAA, 0xD2, 0xB0, 0x96, 0x32, 0xA0, 0x86,
 0x3A, 0x6B, 0xA2, 0x2A, 0x02, 0xA4, 0xA3, 0x8A, 0x18, 0x23, 0x8E, 0xB8,
 0xBA, 0x80, 0x96, 0xA2, 0xA0, 0x86, 0xE8, 0xF2, 0x2F, 0x2B, 0x44, 0xA3,
 0xC6, 0xCA, 0x2B, 0x2E, 0xBA, 0x2C, 0x33, 0x70, 0x96, 0x2E, 0x01, 0x86,
 0xF8, 0x72, 0xBE, 0x3C, 0x43, 0xA3, 0x22, 0xC2, 0xAA, 0xA2, 0xB2, 0xAB,
 0xA3, 0x70, 0x96, 0x2E, 0x01, 0x86, 0xCC, 0xE2, 0xBD, 0x3A, 0x43, 0x24,
 0xBB, 0xBA, 0xBA, 0x4B, 0xA2, 0x2B, 0xA6, 0xB0, 0x96, 0x5D, 0x21, 0x86,
 0xBA, 0xEA, 0x87, 0xAB, 0x3C, 0x75, 0x2A, 0xA2, 0xAA, 0x5A, 0xB2, 0xED,
 0x52, 0x60, 0x96, 0x2E, 0x01, 0x00
};

/************** DC_Parameters **************/

/* DC FXS Default -- Use for for all countries unless country file exists */
const VpProfileDataType LE890_DC_FXS_DEF[] =
{
 /* DC Profile */
 0x00, 0x01, 0x00, 0x09, 0x02, 0x03, /* Header Information */
 0xC6, 0x13, 0xC7, /* Feed Parameters */
 0x18, 0x84, /* Loop Supervision Parameters */
 0x04, /* Min Floor Voltage 25V */
 0x00  /* Hook Threshold Hysteresis */
};

/************** Ring_Parameters **************/

/* Default Ringing 25 Hz 75 Vrms Tracking - Use for all countries unless country file exists */
const VpProfileDataType LE890_RING_25HZ_DEF[] =
{
  /* Sine, 25 Hz, 1.41 CF, 106.10 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x01, 0x0C, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x44,
 0x57, 0x9D, 0x00, 0x00, 0x00, 0x00,
 0xBE, 0x0F,  /* Ring Trip Threshold (31mA) and Current Limit (80mA)*/
 0x15, /* Max Supply Ringing Voltage 110V */
 0x00  /* Ringing Tracking Mode */
};

/* Austria Ringing 50 Hz 75 Vrms Tracking */
const VpProfileDataType LE890_RING_AT[] =
{
  /* Sine, 50 Hz, 1.41 CF, 106.10 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x01, 0x0C, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x89,
 0x57, 0x9D, 0x00, 0x00, 0x00, 0x00,
 0xBE, 0x0F,  /* Ring Trip Threshold (31mA) and Current Limit (80mA)*/
 0x15, /* Max Supply Ringing Voltage 110V */
 0x00  /* Ringing Tracking Mode */
};

/* Canada Ringing 20 Hz 75 Vrms Tracking */
const VpProfileDataType LE890_RING_CA[] =
{
  /* Sine, 20 Hz, 1.41 CF, 106.10 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x01, 0x0C, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x37,
 0x57, 0x9D, 0x00, 0x00, 0x00, 0x00,
 0xBE, 0x0F,  /* Ring Trip Threshold (31mA) and Current Limit (80mA)*/
 0x15, /* Max Supply Ringing Voltage 110V */
 0x00  /* Ringing Tracking Mode */
};

/* Finland Ringing 50 Hz 75 Vrms Tracking */
const VpProfileDataType LE890_RING_FI[] =
{
  /* Sine, 50 Hz, 1.41 CF, 106.10 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x01, 0x0C, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x89,
 0x57, 0x9D, 0x00, 0x00, 0x00, 0x00,
 0xBE, 0x0F,  /* Ring Trip Threshold (31mA) and Current Limit (80mA)*/
 0x15, /* Max Supply Ringing Voltage 110V */
 0x00  /* Ringing Tracking Mode */
};

/* France Ringing 50 Hz 75 Vrms Tracking */
const VpProfileDataType LE890_RING_FR[] =
{
  /* Sine, 50 Hz, 1.41 CF, 106.10 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x01, 0x0C, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x89,
 0x57, 0x9D, 0x00, 0x00, 0x00, 0x00,
 0xBE, 0x0F,  /* Ring Trip Threshold (31mA) and Current Limit (80mA)*/
 0x15, /* Max Supply Ringing Voltage 110V */
 0x00  /* Ringing Tracking Mode */
};

/* Hong Kong SAR Ringing 20 Hz 75 Vrms Tracking */
const VpProfileDataType LE890_RING_HK[] =
{
  /* Sine, 20 Hz, 1.41 CF, 106.10 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x01, 0x0C, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x37,
 0x57, 0x9D, 0x00, 0x00, 0x00, 0x00,
 0xBE, 0x0F,  /* Ring Trip Threshold (31mA) and Current Limit (80mA)*/
 0x15, /* Max Supply Ringing Voltage 110V */
 0x00  /* Ringing Tracking Mode */
};

/* Japan Ringing 16 Hz 75 Vrms Tracking */
const VpProfileDataType LE890_RING_JP[] =
{
  /* Sine, 16 Hz, 1.41 CF, 106.10 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x01, 0x0C, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x2C,
 0x57, 0x9D, 0x00, 0x00, 0x00, 0x00,
 0xBE, 0x0F,  /* Ring Trip Threshold (31mA) and Current Limit (80mA)*/
 0x15, /* Max Supply Ringing Voltage 110V */
 0x00  /* Ringing Tracking Mode */
};

/* Korea Ringing 20 Hz 75 Vrms Tracking */
const VpProfileDataType LE890_RING_KR[] =
{
  /* Sine, 20 Hz, 1.41 CF, 106.10 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x01, 0x0C, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x37,
 0x57, 0x9D, 0x00, 0x00, 0x00, 0x00,
 0xBE, 0x0F,  /* Ring Trip Threshold (31mA) and Current Limit (80mA)*/
 0x15, /* Max Supply Ringing Voltage 110V */
 0x00  /* Ringing Tracking Mode */
};

/* Singapore Ringing 24 Hz 75 Vrms Tracking */
const VpProfileDataType LE890_RING_SG[] =
{
  /* Sine, 24 Hz, 1.41 CF, 106.10 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x01, 0x0C, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x42,
 0x57, 0x9D, 0x00, 0x00, 0x00, 0x00,
 0xBE, 0x0F,  /* Ring Trip Threshold (31mA) and Current Limit (80mA)*/
 0x15, /* Max Supply Ringing Voltage 110V */
 0x00  /* Ringing Tracking Mode */
};

/* Taiwan Ringing 20 Hz 75 Vrms Tracking */
const VpProfileDataType LE890_RING_TW[] =
{
  /* Sine, 20 Hz, 1.41 CF, 106.10 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x01, 0x0C, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x37,
 0x57, 0x9D, 0x00, 0x00, 0x00, 0x00,
 0xBE, 0x0F,  /* Ring Trip Threshold (31mA) and Current Limit (80mA)*/
 0x15, /* Max Supply Ringing Voltage 110V */
 0x00  /* Ringing Tracking Mode */
};

/* USA Ringing 20 Hz 75 Vrms Tracking */
const VpProfileDataType LE890_RING_US[] =
{
  /* Sine, 20 Hz, 1.41 CF, 106.10 Vpk, 0.00 Bias */
  /* Ringing Profile */
 0x00, 0x04, 0x00, 0x12, 0x01, 0x0C, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x37,
 0x57, 0x9D, 0x00, 0x00, 0x00, 0x00,
 0xBE, 0x0F,  /* Ring Trip Threshold (31mA) and Current Limit (80mA)*/
 0x15, /* Max Supply Ringing Voltage 110V */
 0x00  /* Ringing Tracking Mode */
};

/************** Call_Progress_Tones **************/

/************** Cadence_Definitions **************/

/* Standard Ringing Cadence (2 sec on 4 sec off) */
const VpProfileDataType LE890_RING_CAD_STD[] =
{
  /* Cadence Profile */
 0x00, 0x08, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x07, 0x21, 0x90,
 0x01, 0x05, 0x23, 0x20, 0x40, 0x00
};

/* Short Ringing Cadence (0.5 sec on 0.5 sec off) */
const VpProfileDataType LE890_RING_CAD_SHORT[] =
{
  /* Cadence Profile */
 0x00, 0x08, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x07, 0x20, 0x64,
 0x01, 0x05, 0x20, 0x64, 0x40, 0x00
};

/************** Caller_ID **************/

/************** LE890_FXO_Dialing_Profile **************/

/* Default FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_DEF[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x14, /* Flash Hook Timing (100mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x8F, 0x1B, /* Device Ring Period Max (71mS), Min (13mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x47, /* Ring Period Max (71mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* ETSI ES203 021 FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_ETSI[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x14, /* Flash Hook Timing (100mS) */
 0x0D, 0x07, /* Pulse Break (65mS), Pulse Make (35ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x24, /* Device Ring Period Max (45mS), Min (18mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Argentina FXO/Dialing  */
const VpProfileDataType LE890_FXO_DIALING_AR[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x78, /* Flash Hook Timing (600mS) */
 0x0D, 0x07, /* Pulse Break (65mS), Pulse Make (35ms) */
 0x00, 0x8C, /* Interdigit Min (700mS) */
 0x7E, 0x24, /* Device Ring Period Max (63mS), Min (18mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x3E, /* Ring Period Max (62mS) */
 0x2A, 0x30, 0x21, 0x83  /* DTMF High/Low Freq Level (-6.5dBm0/-8.5dBm0) */
};

/* Austria FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_AT[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Australia FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_AU[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0D, 0x07, /* Pulse Break (65mS), Pulse Make (35ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x86, 0x27, /* Device Ring Period Max (67mS), Min (19mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x42, /* Ring Period Max (66mS) */
 0x1C, 0x32, 0x16, 0x65  /* DTMF High/Low Freq Level (-10.0dBm0/-12.0dBm0) */
};

/* Belgium FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_BE[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x24, /* Device Ring Period Max (45mS), Min (18mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Bulgaria FXO/Dialing  */
const VpProfileDataType LE890_FXO_DIALING_BG[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Brazil FXO/Dialing  */
const VpProfileDataType LE890_FXO_DIALING_BR[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x78, /* Flash Hook Timing (600mS) */
 0x0D, 0x07, /* Pulse Break (65mS), Pulse Make (35ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x76, 0x24, /* Device Ring Period Max (59mS), Min (18mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x3A, /* Ring Period Max (58mS) */
 0x23, 0x7F, 0x1C, 0x32  /* DTMF High/Low Freq Level (-8.0dBm0/-10.0dBm0) */
};

/* Canada FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_CA[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x78, /* Flash Hook Timing (600mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x86, 0x1B, /* Device Ring Period Max (67mS), Min (13mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x42, /* Ring Period Max (66mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Switzerland FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_CH[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Chile FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_CL[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x28, /* Flash Hook Timing (200mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* China FXO/Dialing  */
const VpProfileDataType LE890_FXO_DIALING_CN[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x5A, /* Flash Hook Timing (450mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x86, 0x1C, /* Device Ring Period Max (67mS), Min (14mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x42, /* Ring Period Max (66mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Czech Republic FXO/Dialing  */
const VpProfileDataType LE890_FXO_DIALING_CZ[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Germany FXO/Dialing  */
const VpProfileDataType LE890_FXO_DIALING_DE[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x24, /* Device Ring Period Max (45mS), Min (18mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Denmark FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_DK[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Ecuador FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_EC[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x14, /* Flash Hook Timing (100mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Spain FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_ES[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x14, /* Flash Hook Timing (100mS) */
 0x0D, 0x07, /* Pulse Break (65mS), Pulse Make (35ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x65, 0x41, /* Device Ring Period Max (50mS), Min (32mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x32, /* Ring Period Max (50mS) */
 0x27, 0xD4, 0x1F, 0xA3  /* DTMF High/Low Freq Level (-7.0dBm0/-9.0dBm0) */
};

/* Finland FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_FI[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* France FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_FR[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0D, 0x07, /* Pulse Break (65mS), Pulse Make (35ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x24, /* Device Ring Period Max (45mS), Min (18mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* UK FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_GB[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x0F, /* Flash Hook Timing (75mS) */
 0x0D, 0x06, /* Pulse Break (67mS), Pulse Make (33ms) */
 0x00, 0x78, /* Interdigit Min (600mS) */
 0x76, 0x24, /* Device Ring Period Max (59mS), Min (18mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x3A, /* Ring Period Max (58mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Greece FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_GR[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Hong Kong SAR FXO/Dialing  */
const VpProfileDataType LE890_FXO_DIALING_HK[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x64, /* Flash Hook Timing (500mS) */
 0x0D, 0x07, /* Pulse Break (65mS), Pulse Make (35ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x70, 0x41, /* Device Ring Period Max (56mS), Min (32mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x37, /* Ring Period Max (55mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Hungary FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_HU[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Indonesia FXO/Dialing  */
const VpProfileDataType LE890_FXO_DIALING_ID[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x14, /* Flash Hook Timing (100mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Ireland FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_IE[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x1E, /* Flash Hook Timing (150mS) */
 0x0D, 0x07, /* Pulse Break (65mS), Pulse Make (35ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Israel FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_IL[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x78, /* Flash Hook Timing (600mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x57, 0x23, /* Device Ring Period Max (43mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2B, /* Ring Period Max (43mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* India FXO/Dialing  */
const VpProfileDataType LE890_FXO_DIALING_IN[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x28, /* Flash Hook Timing (200mS) */
 0x0D, 0x06, /* Pulse Break (67mS), Pulse Make (33ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x7E, 0x20, /* Device Ring Period Max (63mS), Min (16mS) */
 0x02, /* Ring Detect Min (38V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x3E, /* Ring Period Max (62mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Iceland FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_IS[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Italy FXO/Dialing  */
const VpProfileDataType LE890_FXO_DIALING_IT[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x10, /* Flash Hook Timing (80mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0x64, /* Interdigit Min (500mS) */
 0x7E, 0x1C, /* Device Ring Period Max (63mS), Min (14mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x3E, /* Ring Period Max (62mS) */
 0x23, 0x7F, 0x1C, 0x32  /* DTMF High/Low Freq Level (-8.0dBm0/-10.0dBm0) */
};

/* Japan FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_JP[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x78, /* Flash Hook Timing (600mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x9A, 0x24, /* Device Ring Period Max (77mS), Min (18mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x4C, /* Ring Period Max (76mS) */
 0x23, 0x7F, 0x1C, 0x32  /* DTMF High/Low Freq Level (-8.0dBm0/-10.0dBm0) */
};

/* S. Korea FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_KR[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x78, /* Flash Hook Timing (600mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x86, 0x1C, /* Device Ring Period Max (67mS), Min (14mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x42, /* Ring Period Max (66mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Mexico FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_MX[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x14, /* Flash Hook Timing (100mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Malaysia FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_MY[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x14, /* Flash Hook Timing (100mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Netherlands FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_NL[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x16, /* Flash Hook Timing (110mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Norway FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_NO[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* New Zealand FXO/Dialing  */
const VpProfileDataType LE890_FXO_DIALING_NZ[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x82, /* Flash Hook Timing (650mS) */
 0x0D, 0x06, /* Pulse Break (67mS), Pulse Make (33ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x86, 0x24, /* Device Ring Period Max (67mS), Min (18mS) */
 0x01, /* Ring Detect Min (27V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x42, /* Ring Period Max (66mS) */
 0x1F, 0xA3, 0x1C, 0x32  /* DTMF High/Low Freq Level (-9.0dBm0/-10.0dBm0) */
};

/* Poland FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_PL[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Portugal FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_PT[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Russia FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_RU[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x28, /* Flash Hook Timing (200mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xB4, /* Interdigit Min (900mS) */
 0x7E, 0x27, /* Device Ring Period Max (63mS), Min (19mS) */
 0x01, /* Ring Detect Min (27V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x3E, /* Ring Period Max (62mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Sweden FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_SE[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Singapore FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_SG[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x78, /* Flash Hook Timing (600mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x65, 0x24, /* Device Ring Period Max (50mS), Min (18mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x32, /* Ring Period Max (50mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Thailand FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_TH[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x14, /* Flash Hook Timing (100mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Turkey FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_TK[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x14, /* Flash Hook Timing (100mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x5B, 0x23, /* Device Ring Period Max (45mS), Min (17mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x2D, /* Ring Period Max (45mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* Taiwan FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_TW[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x64, /* Flash Hook Timing (500mS) */
 0x0D, 0x06, /* Pulse Break (67mS), Pulse Make (33ms) */
 0x00, 0xA0, /* Interdigit Min (800mS) */
 0x76, 0x24, /* Device Ring Period Max (59mS), Min (18mS) */
 0x03, /* Ring Detect Min (49V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x3A, /* Ring Period Max (58mS) */
 0x2A, 0x30, 0x21, 0x83  /* DTMF High/Low Freq Level (-6.5dBm0/-8.5dBm0) */
};

/* USA FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_US[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x78, /* Flash Hook Timing (600mS) */
 0x0C, 0x08, /* Pulse Break (60mS), Pulse Make (40ms) */
 0x00, 0xB4, /* Interdigit Min (900mS) */
 0x8F, 0x1B, /* Device Ring Period Max (71mS), Min (13mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x47, /* Ring Period Max (71mS) */
 0x2C, 0xB0, 0x23, 0x7F  /* DTMF High/Low Freq Level (-6.0dBm0/-8.0dBm0) */
};

/* South Africa FXO/Dialing */
const VpProfileDataType LE890_FXO_DIALING_ZA[] =
{
 /* FXO/Dialing Profile */
 0x00, 0xFE, 0x00, 0x16, 0x01, 0x00, /* Header Information */
 0x00, 0x14, 0x00, 0x14, /* DTMF On (100mS), DTMF Off (100ms) */
 0x00, 0x12, /* Flash Hook Timing (90mS) */
 0x0D, 0x07, /* Pulse Break (65mS), Pulse Make (35ms) */
 0x00, 0x50, /* Interdigit Min (400mS) */
 0x86, 0x27, /* Device Ring Period Max (67mS), Min (19mS) */
 0x04, /* Ring Detect Min (60V) */
 0x00, /* Disconnect Threshold (2.56V) */
 0x02, /* LIU Threshold (20.48V) */
 0x42, /* Ring Period Max (66mS) */
 0x1F, 0xA3, 0x19, 0x21  /* DTMF High/Low Freq Level (-9.0dBm0/-11.0dBm0) */
};

/* end of file Le890NB_HV.c */
