/*
 * Realtek_88601.c --
 *
 * This file contains profile data in byte format
 *
 * Project Info --
 *   File:   C:\Users\Sainz.jeng\Desktop\Realtek_88601.vpw
 *   Type:   Design for ZLR88621L SM2 Line Module Featuring the ZL88601, Lite Coefficients
 *   Date:   Monday, March 17, 2014 22:36:14
 *   Device: ZL880 ZL88601
 *
 *   This file was generated with Profile Wizard Version: P2.5.0
 *
 * Project Comments --
 *  ----------------------------------------------------------------------------------------------------------------------------------
 *  Profile Wizard Coefficient Revision 2.9 Release Notes:
 *  ----------------------------------------------------------------------------------------------------------------------------------
 *  I. General:
 *  1. This is the second release of the ZL88601 worldwide coefficients.
 *  2. This release includes support for the following 44 countries:
 *  Argentina (AR), Austria (AT), Australia (AU), Belgium (BE), Brazil (BR), Bulgaria (BG), Canada (CA), Switzerland (CH),
 *  Chile (CL), China (CN), Czech Republic (CZ), Germany (DE), Denmark (DK), Ecuador (EC), Spain (ES), Finland (FI),
 *  France (FR), UK (GB), Greece (GR), Hong Kong SAR China (HK), Hungary (HU), Indonesia (ID), Ireland (IE), Israel (IL),
 *  India (IN), Iceland (IS), Italy (IT), Japan (JP), S. Korea (KR), Mexico (MX), Malaysia (MY), Netherlands (NL),
 *  Norway (NO), New Zealand (NZ), Poland (PL), Portugal (PT), Russian Federation (RU), Sweden (SE), Singapore (SG),
 *  Thailand (TH), Turkey (TK), Taiwan (TW), USA (US), and South Africa (ZA).
 *  2. The coefficients in this and all releases are provided for use only with the Microsemi VoicePath API-II (VP-API-II). Please refer 
 *  to the terms and conditions for licensing the software regarding terms and conditions of usage. These profiles are provided for 
 *  reference only with no guarantee whatsoever by Microsemi Corporation.
 *  3. This release is for the ZLR88621L SM2 Line Module based on the ZL88601 and for the ZLR88621H Line Module set for a VBATH = -81V.
 *  
 *  II. Device Profile:
 *  1. The default settings for the Device Profile are:
 *         PCLK = 8192 kHz
 *         PCM Transmit Edge = Positive
 *         Transmit Time Slot = 0
 *         Receive Time Slot = 0
 *         Interrupt Mode = Open Drain
 *         Switching Regulator Y Control Mode = Single
 *         Switching Regulator Y Voltage = 27V
 *         Switching Regulator Z Control Mode = Single
 *         Switching Regulator Z Voltage = 81V
 *         IO21 Pin Mode = Digital
 *         IO22 Pin Mode = Analog Voltage Sense
 *      
 *  2. The settings may be changed by the user as necessary.  Please refer to the ZL880 and VP-API-II documentation for information 
 *  about the supported settings.
 *  
 *  II. DC Profiles:
 *  1. The DC_FXS_ZL880_ABS100V_DEF Profile is the default unless a country specific profile is selected. Example DC profile settings are
 *  provided for China, ETSI and the USA.
 *  
 *  III. AC Profiles:
 *  1. FXS Coefficients assume -6dBr RX (Output from chipset) and 0dB TX relative gain levels.
 *  2. Supported countries not individually listed should use the default 600R profile AC_FXS_RF14_600R_DEF.
 *  4. AC FXS Coefficients assume the use of two 7 ohm series resistors or PTCs. Customers using other PTC resistance values (such as 
 *  25ohms or 50 ohms) should not use these AC coefficients and can request alternate ones from Microsemi.
 *  5. This release includes both Narrowband and Wideband coefficients. Note that the ZL880 Series devices support per channel Narrowband or
 *  Wideband audio selection.
 *  
 *  IV. Ring Profiles:
 *  1. RING_ZL880_ABS100V_DEF is the default ringing profile and should be used for all countries which do not have a listed ringing profile.  
 *  The default ringing profile is set for a sine wave ringing with an amplitude of 50Vrms (70.7Vpk)with no DC bias and a frequency of 25 Hz 
 *  generated by fixed (non-tracking) supply.
 *  2. Most ringing profiles on the list are sinusoidal with an amplitude of 50Vrms with no DC bias generated by fixed (non-tracking) supply. 
 *  3. The ringing definitions may be changed based on the requirements of the target market as long as the total amplitude (AC + DC 
 *  components) does not exceed the limits set forth in the ZL88601/602 data sheet.
 *  
 *  V. Tone Profiles:
 *  1. These profiles are available only in the full version of the VP-API-II.
 *  
 *  VI. Cadence Profiles:
 *  1. These profiles are available only in the full version of the VP-API-II.
 *  
 *  VII. Caller ID Profiles:
 *  1. These profiles are available only in the full version of the VP-API-II.
 *  
 *  VIII. Metering Profiles:
 *  1. These profiles are available only in the full version of the VP-API-II.
 *  
 *  (c) Copyright 2012 Microsemi Corporation. All rights reserved.
 *  
 *  -----------------------------------------------------------------------------------------------------------------------------------------------------
 */

#include "Realtek_88601.h"


/************** Device_Parameters **************/

/* Device Configuration Data - ZL88601 100V ABS (-81V/-27V) */
const VpProfileDataType ZLR88621L_ABS81V_DEVICE[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0xFF, 0x00,       /* Device Profile for ZL88601 device */
   0x2C,                   /* Profile length = 44 + 4 = 48 bytes */
   0x05,                   /* Profile format version = 5 */
   0x14,                   /* MPI section length = 20 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0x46, 0x82,             /* PCLK = 2.048 MHz; INTM = Open Drain */
   0x44, 0x06,             /* PCM Clock Slot = 6 TX / 0 RX; XE = Neg. */
   0x5E, 0x14, 0x04,       /* Device Mode Register */
   0xF6, 0x66, 0x00, 0x4C, /* Switching Regulator Timing Params */
         0x30, 0x64, 0x30,
   0xE4, 0x05, 0xA0, 0x00, /* Switching Regulator Params */
   0xE6, 0x00,             /* Switching Regulator Control */
/* Formatted Parameters Section -------------------------------------------- */
   0x20,                   /* IO21 Mode: Digital */
                           /* IO22 Mode: Analog Voltage Sense */
   0x21,                   /* Dial pulse correction: 2 ms */
                           /* Switcher Configuration = ABS (12 V in, 100 V out) */
   0x00, 0xFF,             /* Over-current shutdown count = 255 */
   0x21,                   /* Leading edge blanking window = 81 ns */
                           /* ABS supply config: 1 = Single; 2 = Slave */
   0x45, 0x00, 0x44, 0x30, /* Free-Run Timing Parameters */
         0x64, 0x30,
   0x1B,                   /* Switcher 1 Voltage = 27 V */
   0x51,                   /* Switcher 2 Voltage = 81 V */
   0xFF,
   0x66, 0x00,             /* Low-Power Timing Parameters */
   0x20, 0x6E,             /* Switcher Limit Voltages 32 V, 110 V */
   0x03,                   /* Charge pump enabled */
                           /* Charge Pump Overload Protection: Switcher Cycle Skip */
   0x3C,                   /* Switcher Input 12 V */
   0x00, 0x00              /* VBH Offset 0 V, VBH Overhead 0 V */
};

/************** DC_Parameters **************/

/* DC FXS Defaults - Use for all countries unless country file exists - 23mA Current Feed */
const VpProfileDataType DC_FXS_ZL880_ABS100V_DEF[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x01, 0x00,       /* DC Profile for ZL88601 device */
   0x0B,                   /* Profile length = 11 + 4 = 15 bytes */
   0x02,                   /* Profile format version = 2 */
   0x03,                   /* MPI section length = 3 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC6, 0x91, 0xE5,       /* DC Feed Parameters: ir_overhead = 100 ohm; */
                           /* VOC = 48 V; LI = 50 ohm; ILA = 23 mA */
                           /* Battery Switch Offset Voltage = 4.02 V */
/* Formatted Parameters Section -------------------------------------------- */
   0x1C,                   /* Switch Hook Threshold = 11 mA */
                           /* Ground-Key Threshold = 18 mA */
   0x86,                   /* Switch Hook Debounce = 12 ms */
                           /* Ground-Key Debounce = 16 ms */
   0x58,                   /* Low-Power Switch Hook Hysteresis = 2 V */
                           /* Ground-Key Hysteresis = 6 mA */
                           /* Switch Hook Hysteresis = 2 mA */
   0x80,                   /* Low-Power Switch Hook Threshold = 22 V */
   0x00,                   /* R_OSP = 0 ohms */
   0x07                    /* R_ISP = 7 ohms */
};

/* China DC FXS Parameters - 20mA Current Feed */
const VpProfileDataType DC_FXS_ZL880_ABS100V_CN[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x01, 0x00,       /* DC Profile for ZL88601 device */
   0x0B,                   /* Profile length = 11 + 4 = 15 bytes */
   0x02,                   /* Profile format version = 2 */
   0x03,                   /* MPI section length = 3 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC6, 0x8D, 0xE2,       /* DC Feed Parameters: ir_overhead = 100 ohm; */
                           /* VOC = 45 V; LI = 50 ohm; ILA = 20 mA */
                           /* Battery Switch Offset Voltage = 4.02 V */
/* Formatted Parameters Section -------------------------------------------- */
   0x1A,                   /* Switch Hook Threshold = 9 mA */
                           /* Ground-Key Threshold = 18 mA */
   0x86,                   /* Switch Hook Debounce = 12 ms */
                           /* Ground-Key Debounce = 16 ms */
   0x58,                   /* Low-Power Switch Hook Hysteresis = 2 V */
                           /* Ground-Key Hysteresis = 6 mA */
                           /* Switch Hook Hysteresis = 2 mA */
   0x40,                   /* Low-Power Switch Hook Threshold = 18 V */
   0x00,                   /* R_OSP = 0 ohms */
   0x07                    /* R_ISP = 7 ohms */
};

/* ETSI DC FXS Parameters - 23mA Current Feed */
const VpProfileDataType DC_FXS_ZL880_ABS100V_ETSI[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x01, 0x00,       /* DC Profile for ZL88601 device */
   0x0B,                   /* Profile length = 11 + 4 = 15 bytes */
   0x02,                   /* Profile format version = 2 */
   0x03,                   /* MPI section length = 3 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC6, 0x95, 0xE5,       /* DC Feed Parameters: ir_overhead = 100 ohm; */
                           /* VOC = 51 V; LI = 50 ohm; ILA = 23 mA */
                           /* Battery Switch Offset Voltage = 4.02 V */
/* Formatted Parameters Section -------------------------------------------- */
   0x1A,                   /* Switch Hook Threshold = 9 mA */
                           /* Ground-Key Threshold = 18 mA */
   0x86,                   /* Switch Hook Debounce = 12 ms */
                           /* Ground-Key Debounce = 16 ms */
   0x58,                   /* Low-Power Switch Hook Hysteresis = 2 V */
                           /* Ground-Key Hysteresis = 6 mA */
                           /* Switch Hook Hysteresis = 2 mA */
   0x40,                   /* Low-Power Switch Hook Threshold = 18 V */
   0x00,                   /* R_OSP = 0 ohms */
   0x07                    /* R_ISP = 7 ohms */
};

/* USA DC FXS Parameters - 23mA Current Feed */
const VpProfileDataType DC_FXS_ZL880_ABS100V_US[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x01, 0x00,       /* DC Profile for ZL88601 device */
   0x0B,                   /* Profile length = 11 + 4 = 15 bytes */
   0x02,                   /* Profile format version = 2 */
   0x03,                   /* MPI section length = 3 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC6, 0x91, 0xE5,       /* DC Feed Parameters: ir_overhead = 100 ohm; */
                           /* VOC = 48 V; LI = 50 ohm; ILA = 23 mA */
                           /* Battery Switch Offset Voltage = 4.02 V */
/* Formatted Parameters Section -------------------------------------------- */
   0x1C,                   /* Switch Hook Threshold = 11 mA */
                           /* Ground-Key Threshold = 18 mA */
   0x86,                   /* Switch Hook Debounce = 12 ms */
                           /* Ground-Key Debounce = 16 ms */
   0x58,                   /* Low-Power Switch Hook Hysteresis = 2 V */
                           /* Ground-Key Hysteresis = 6 mA */
                           /* Switch Hook Hysteresis = 2 mA */
   0x80,                   /* Low-Power Switch Hook Threshold = 22 V */
   0x00,                   /* R_OSP = 0 ohms */
   0x07                    /* R_ISP = 7 ohms */
};

/************** AC_Coefficients **************/

/* AC FXS RF14 600R Normal Coefficients (Default)  */
const VpProfileDataType AC_FXS_RF14_600R_DEF[] =
{
  /* AC Profile */
 0xA4, 0x00, 0xF4, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x2A, 0xAA, 0xA6, 0x9F,
 0x01, 0x8A, 0x1D, 0x01, 0xA3, 0xA0, 0x2E, 0xB2, 0xB2, 0xBA, 0xAC, 0xA2,
 0xA6, 0xCB, 0x3B, 0x45, 0x88, 0x2A, 0x20, 0x3C, 0xBC, 0x4E, 0xA6, 0x2B,
 //0xA5, 0x2B, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0xA5, 0x2B, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0x1D, 0x1A, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0xA1, 0xCB, 0x1B, 0xA3, 0xA8, 0xFB, 0x87, 0xAA,
 0xFB, 0x9F, 0xA9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 ETSI ES201 970 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_ETSI[] =
{
  /* AC Profile */
 0xD5, 0x00, 0xEC, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x4A, 0xA1, 0x34,
 0xA2, 0xA2, 0xAC, 0x2C, 0xBB, 0x2B, 0xA4, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2B, 0x20, 0x8F, 0x39, 0x2A, 0xBB, 0xA4, 0x24,
 0xB2, 0xBC, 0x4B, 0x26, 0x88, 0xA3, 0xC0, 0xC2, 0x27, 0xBA, 0x3E, 0xAC,
 0xAF, 0xB4, 0x26, 0x24, 0x3F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5F, 0x32, 0x98, 0x03, 0xA1, 0xAA, 0x23, 0xB3, 0x2C,
 0x4B, 0x55, 0x25, 0x60, 0x96, 0xF2, 0xC1, 0x00
};

/* AC FXS RF14 Telcordia GR-57 900R+2.16uF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_GR57[] =
{
  /* AC Profile */
 0x01, 0x00, 0x90, 0x4C, 0x01, 0x49, 0xCA, 0x0E, 0x98, 0x32, 0x2B, 0x24,
 0x7C, 0x4A, 0x24, 0x55, 0xA3, 0x3A, 0xBC, 0x9A, 0xBA, 0xB3, 0xF4, 0x2D,
 0x01, 0x8A, 0xEB, 0xC0, 0x26, 0x21, 0xB2, 0x35, 0xB3, 0xA6, 0x2A, 0xAD,
 0xD4, 0xA6, 0x52, 0x4F, 0x88, 0xA3, 0xD0, 0x23, 0xAA, 0xAF, 0x62, 0xEA,
 0xBA, 0x2A, 0xB3, 0x4A, 0x3D, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xBD, 0x52, 0xA1, 0x62, 0x1B, 0x22, 0x3A, 0x4B, 0xB5, 0x2A,
 0x65, 0xA7, 0xB6, 0x70, 0x96, 0x23, 0xC0, 0x00
};

/* AC FXS RF14 Austria 220R+820R//115nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_AT[] =
{
  /* AC Profile */
 0x6D, 0x00, 0xA7, 0x4C, 0x01, 0x49, 0xCA, 0xEA, 0x98, 0xFA, 0xE1, 0x23,
 0xA2, 0xEA, 0xCB, 0xB3, 0xAA, 0xA3, 0xB3, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0xB3, 0x20, 0xAB, 0xA8, 0xCC, 0x24, 0x22, 0x97,
 0xAF, 0x8F, 0xD3, 0xBF, 0x88, 0x3B, 0xB0, 0x33, 0x46, 0x2A, 0x2E, 0x33,
 0x4F, 0xAE, 0xA5, 0xB3, 0xBE, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0x22, 0x98, 0x02, 0x42, 0xA2, 0x43, 0xA6, 0xD8,
 0xFA, 0x8F, 0x29, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Australia 220R+820R//120nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_AU[] =
{
  /* AC Profile */
 0xBF, 0x00, 0xAF, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0xBA, 0x41, 0x54,
 0xA2, 0x2A, 0x5B, 0xA4, 0xAA, 0x3A, 0xB3, 0x9A, 0x87, 0xA2, 0x97, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0x23, 0x20, 0x3E, 0xA8, 0x2A, 0x57, 0xCB, 0x34,
 0xBA, 0xAC, 0xBB, 0xA6, 0x88, 0xAA, 0xB0, 0x49, 0xF6, 0x3B, 0x2E, 0x49,
 0xFF, 0xBC, 0xA5, 0x3A, 0xBE, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x34, 0x5C, 0x32, 0x25, 0x1A, 0xA1, 0x3B, 0x23, 0xB3, 0x5B,
 0x4D, 0xB5, 0xDC, 0x60, 0x96, 0x3B, 0xA1, 0x00
};

/* AC FXS RF14 Belgium 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_BE[] =
{
  /* AC Profile */
 0xD5, 0x00, 0xEC, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x4A, 0xA1, 0x34,
 0xA2, 0xA2, 0xAC, 0x2C, 0xBB, 0x2B, 0xA4, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2B, 0x20, 0x8F, 0x39, 0x2A, 0xBB, 0xA4, 0x24,
 0xB2, 0xBC, 0x4B, 0x26, 0x88, 0xA3, 0xC0, 0xC2, 0x27, 0xBA, 0x3E, 0xAC,
 0xAF, 0xB4, 0x26, 0x24, 0x3F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5F, 0x32, 0x98, 0x03, 0xA1, 0xAA, 0x23, 0xB3, 0x2C,
 0x4B, 0x55, 0x25, 0x60, 0x96, 0xF2, 0xC1, 0x00
};

/* AC FXS RF14 Bulgaria 220R+820R//115nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_BG[] =
{
  /* AC Profile */
 0x6D, 0x00, 0xA7, 0x4C, 0x01, 0x49, 0xCA, 0xEA, 0x98, 0xFA, 0xE1, 0x23,
 0xA2, 0xEA, 0xCB, 0xB3, 0xAA, 0xA3, 0xB3, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0xB3, 0x20, 0xAB, 0xA8, 0xCC, 0x24, 0x22, 0x97,
 0xAF, 0x8F, 0xD3, 0xBF, 0x88, 0x3B, 0xB0, 0x33, 0x46, 0x2A, 0x2E, 0x33,
 0x4F, 0xAE, 0xA5, 0xB3, 0xBE, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0x22, 0x98, 0x02, 0x42, 0xA2, 0x43, 0xA6, 0xD8,
 0xFA, 0x8F, 0x29, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Brazil 900R Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_BR[] =
{
  /* AC Profile */
 0xE4, 0x00, 0xF7, 0x4C, 0x01, 0x49, 0xCA, 0x0B, 0x98, 0x34, 0x3B, 0xB2,
 0x2C, 0x9F, 0xA4, 0xD2, 0xA3, 0x22, 0xAC, 0x9A, 0xA4, 0xAA, 0x67, 0x9F,
 0x01, 0x8A, 0xB3, 0xD0, 0xA6, 0x21, 0xAA, 0x34, 0x2B, 0x2F, 0x4A, 0xA6,
 0xAB, 0x2F, 0x4A, 0x37, 0x88, 0x2A, 0xC0, 0x23, 0xAC, 0x2A, 0x26, 0x32,
 0xA5, 0x3C, 0xAD, 0xA4, 0xA7, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xAB, 0x49, 0xF1, 0x2A, 0x0A, 0x43, 0xC9, 0xF3, 0x27, 0xBC,
 0xE2, 0xAF, 0xAD, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Switzerland 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_CH[] =
{
  /* AC Profile */
 0xD5, 0x00, 0xEC, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x4A, 0xA1, 0x34,
 0xA2, 0xA2, 0xAC, 0x2C, 0xBB, 0x2B, 0xA4, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2B, 0x20, 0x8F, 0x39, 0x2A, 0xBB, 0xA4, 0x24,
 0xB2, 0xBC, 0x4B, 0x26, 0x88, 0xA3, 0xC0, 0xC2, 0x27, 0xBA, 0x3E, 0xAC,
 0xAF, 0xB4, 0x26, 0x24, 0x3F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5F, 0x32, 0x98, 0x03, 0xA1, 0xAA, 0x23, 0xB3, 0x2C,
 0x4B, 0x55, 0x25, 0x60, 0x96, 0xF2, 0xC1, 0x00
};

/* AC FXS RF14 China 200R+680R//100nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_CN[] =
{
  /* AC Profile */
 0xB9, 0x00, 0x1F, 0x4C, 0x01, 0x49, 0xCA, 0xE9, 0x98, 0x5C, 0xB1, 0xAA,
 0x23, 0x43, 0xEB, 0x32, 0xAA, 0x23, 0xB3, 0x9A, 0x98, 0x94, 0x97, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x22, 0x30, 0x6A, 0x59, 0x2A, 0xCB, 0xB4, 0xB2,
 0xBF, 0x3B, 0xA3, 0x25, 0x88, 0x43, 0xC0, 0x3A, 0x45, 0x2B, 0xBD, 0x4C,
 0x2E, 0x4C, 0x25, 0x42, 0xAD, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xA4, 0x5A, 0x32, 0xB5, 0x12, 0xA1, 0xA2, 0x3A, 0xA4, 0xB5,
 0x64, 0x97, 0xAA, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Germany 220R+820R//115nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_DE[] =
{
  /* AC Profile */
 0xEB, 0x00, 0xDC, 0x4C, 0x01, 0x49, 0xCA, 0xEA, 0x98, 0xA2, 0xE1, 0x24,
 0xA2, 0x2A, 0xCB, 0xB3, 0xAA, 0xD3, 0xB3, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x24, 0x20, 0x2C, 0xA8, 0xAB, 0x24, 0x22, 0x97,
 0xAF, 0x8F, 0x23, 0xBF, 0x88, 0x3B, 0xB0, 0x33, 0x46, 0x2A, 0x2E, 0x33,
 0x4F, 0xAE, 0xA5, 0xB3, 0xBE, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x53, 0x54, 0x32, 0xC4, 0x1A, 0xA1, 0x2B, 0x2A, 0xA3, 0xAA,
 0x4A, 0xA5, 0xBA, 0x60, 0x96, 0xD2, 0xA1, 0x00
};

/* AC FXS RF14 Denmark 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_DK[] =
{
  /* AC Profile */
 0x7D, 0x00, 0x9A, 0x4C, 0x01, 0x49, 0xCA, 0xE6, 0x98, 0x22, 0xA1, 0x52,
 0xD2, 0xE7, 0x24, 0xF4, 0xCD, 0xAA, 0x97, 0x9A, 0xCA, 0xB3, 0xA5, 0x6E,
 0x01, 0x8A, 0x32, 0xD0, 0xAB, 0x20, 0xAA, 0x49, 0x29, 0x7A, 0x32, 0xD6,
 0xA2, 0xED, 0xC5, 0x97, 0x88, 0xBA, 0xC0, 0x22, 0xA7, 0x2C, 0xFE, 0x42,
 0xDE, 0x22, 0xB6, 0xB3, 0x9F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x23, 0x53, 0x32, 0x2C, 0x1B, 0x22, 0xCA, 0x23, 0x63, 0x2A,
 0x33, 0xD4, 0x2A, 0x40, 0x96, 0xA2, 0xA0, 0x00
};

/* AC FXS RF14 Spain 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_ES[] =
{
  /* AC Profile */
 0xD5, 0x00, 0xEC, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x4A, 0xA1, 0x34,
 0xA2, 0xA2, 0xAC, 0x2C, 0xBB, 0x2B, 0xA4, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2B, 0x20, 0x8F, 0x39, 0x2A, 0xBB, 0xA4, 0x24,
 0xB2, 0xBC, 0x4B, 0x26, 0x88, 0xA3, 0xC0, 0xC2, 0x27, 0xBA, 0x3E, 0xAC,
 0xAF, 0xB4, 0x26, 0x24, 0x3F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5F, 0x32, 0x98, 0x03, 0xA1, 0xAA, 0x23, 0xB3, 0x2C,
 0x4B, 0x55, 0x25, 0x60, 0x96, 0xF2, 0xC1, 0x00
};

/* AC FXS RF14 Finland 270R+910R//120nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_FI[] =
{
  /* AC Profile */
 0xFF, 0x00, 0x8D, 0x4C, 0x01, 0x49, 0xCA, 0xEF, 0x98, 0x2A, 0xB1, 0x23,
 0x33, 0xB2, 0xAB, 0x44, 0xEB, 0xA4, 0x44, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0x24, 0x20, 0x25, 0xB8, 0x2D, 0x42, 0xDB, 0xBA,
 0xE3, 0x43, 0xF2, 0xAC, 0x88, 0xC4, 0xB0, 0xA2, 0xA7, 0x42, 0x3E, 0xA2,
 0x9F, 0x32, 0x26, 0xBE, 0x2F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xA2, 0x5C, 0x22, 0xA2, 0x13, 0xC1, 0xB3, 0x22, 0x23, 0x7A,
 0x3D, 0xB4, 0xD4, 0x50, 0x96, 0x3C, 0x41, 0x00
};

/* AC FXS RF14 France 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_FR[] =
{
  /* AC Profile */
 0xFC, 0x00, 0xA4, 0x4C, 0x01, 0x49, 0xCA, 0xE7, 0x98, 0xBA, 0x31, 0xA5,
 0x62, 0x35, 0xAB, 0xAA, 0xAA, 0xAC, 0xA3, 0x9A, 0xAA, 0xA2, 0xC7, 0x6F,
 0x01, 0x8A, 0x2D, 0x01, 0xBB, 0x10, 0xC2, 0x38, 0x2A, 0xA1, 0xC2, 0xA9,
 0x23, 0xA2, 0x22, 0x2D, 0x88, 0xA3, 0xB0, 0x53, 0x55, 0x4A, 0xAD, 0xB2,
 0xAD, 0x5A, 0x25, 0x72, 0x5E, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x43, 0x22, 0x9F, 0x1A, 0x22, 0x4B, 0x33, 0xD5, 0x2C,
 0x7A, 0x87, 0xA8, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 UK 370R+620R//310nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_GB[] =
{
  /* AC Profile */
 0x24, 0x00, 0x0A, 0x4C, 0x01, 0x49, 0xCA, 0xE6, 0x98, 0x22, 0xA1, 0x52,
 0xD2, 0xE7, 0x24, 0xF4, 0xCD, 0xAA, 0x97, 0x9A, 0x2B, 0xA2, 0x27, 0x6E,
 0x01, 0x8A, 0x32, 0xD0, 0xCB, 0x20, 0xBB, 0x59, 0x5A, 0x4A, 0xAA, 0xB5,
 0x2C, 0x2D, 0x42, 0xC7, 0x88, 0xAA, 0xC0, 0xA3, 0xA7, 0xBA, 0xDE, 0x5C,
 0xCE, 0xAA, 0xA6, 0xA2, 0x9F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x43, 0x5B, 0x32, 0x2C, 0x1D, 0x22, 0xAA, 0x2B, 0x33, 0xBA,
 0x3C, 0x34, 0xBA, 0x40, 0x96, 0xA2, 0xA0, 0x00
};

/* AC FXS RF14 Greece 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_GR[] =
{
  /* AC Profile */
 0x63, 0x00, 0x7D, 0x4C, 0x01, 0x49, 0xCA, 0x03, 0x98, 0x22, 0xA6, 0x2C,
 0x3E, 0x2B, 0x87, 0x44, 0x36, 0x2A, 0x9F, 0x9A, 0x22, 0xBA, 0xA7, 0x9F,
 0x01, 0x8A, 0x7D, 0xD0, 0xAA, 0xA0, 0x22, 0xAA, 0x98, 0xB4, 0x23, 0xBE,
 0xAB, 0xBF, 0xAA, 0x97, 0x88, 0x3C, 0xC0, 0x3A, 0xBD, 0xED, 0x8F, 0xEB,
 0xA6, 0x3A, 0x8F, 0x2B, 0x6F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xD2, 0x52, 0x22, 0xA2, 0x13, 0xA1, 0x97, 0x32, 0x25, 0xCA,
 0x6B, 0x87, 0x2B, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Hungary 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_HU[] =
{
  /* AC Profile */
 0xD5, 0x00, 0xEC, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x4A, 0xA1, 0x34,
 0xA2, 0xA2, 0xAC, 0x2C, 0xBB, 0x2B, 0xA4, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2B, 0x20, 0x8F, 0x39, 0x2A, 0xBB, 0xA4, 0x24,
 0xB2, 0xBC, 0x4B, 0x26, 0x88, 0xA3, 0xC0, 0xC2, 0x27, 0xBA, 0x3E, 0xAC,
 0xAF, 0xB4, 0x26, 0x24, 0x3F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5F, 0x32, 0x98, 0x03, 0xA1, 0xAA, 0x23, 0xB3, 0x2C,
 0x4B, 0x55, 0x25, 0x60, 0x96, 0xF2, 0xC1, 0x00
};

/* AC FXS RF14 Ireland 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_IE[] =
{
  /* AC Profile */
 0xD5, 0x00, 0xEC, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x4A, 0xA1, 0x34,
 0xA2, 0xA2, 0xAC, 0x2C, 0xBB, 0x2B, 0xA4, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2B, 0x20, 0x8F, 0x39, 0x2A, 0xBB, 0xA4, 0x24,
 0xB2, 0xBC, 0x4B, 0x26, 0x88, 0xA3, 0xC0, 0xC2, 0x27, 0xBA, 0x3E, 0xAC,
 0xAF, 0xB4, 0x26, 0x24, 0x3F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5F, 0x32, 0x98, 0x03, 0xA1, 0xAA, 0x23, 0xB3, 0x2C,
 0x4B, 0x55, 0x25, 0x60, 0x96, 0xF2, 0xC1, 0x00
};

/* AC FXS RF14 Israel 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_IL[] =
{
  /* AC Profile */
 0xD5, 0x00, 0xEC, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x4A, 0xA1, 0x34,
 0xA2, 0xA2, 0xAC, 0x2C, 0xBB, 0x2B, 0xA4, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2B, 0x20, 0x8F, 0x39, 0x2A, 0xBB, 0xA4, 0x24,
 0xB2, 0xBC, 0x4B, 0x26, 0x88, 0xA3, 0xC0, 0xC2, 0x27, 0xBA, 0x3E, 0xAC,
 0xAF, 0xB4, 0x26, 0x24, 0x3F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5F, 0x32, 0x98, 0x03, 0xA1, 0xAA, 0x23, 0xB3, 0x2C,
 0x4B, 0x55, 0x25, 0x60, 0x96, 0xF2, 0xC1, 0x00
};

/* AC FXS RF14 Iceland 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_IS[] =
{
  /* AC Profile */
 0xD5, 0x00, 0xEC, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x4A, 0xA1, 0x34,
 0xA2, 0xA2, 0xAC, 0x2C, 0xBB, 0x2B, 0xA4, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2B, 0x20, 0x8F, 0x39, 0x2A, 0xBB, 0xA4, 0x24,
 0xB2, 0xBC, 0x4B, 0x26, 0x88, 0xA3, 0xC0, 0xC2, 0x27, 0xBA, 0x3E, 0xAC,
 0xAF, 0xB4, 0x26, 0x24, 0x3F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5F, 0x32, 0x98, 0x03, 0xA1, 0xAA, 0x23, 0xB3, 0x2C,
 0x4B, 0x55, 0x25, 0x60, 0x96, 0xF2, 0xC1, 0x00
};

/* AC FXS RF14 Italy 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_IT[] =
{
  /* AC Profile */
 0xEE, 0x00, 0xBD, 0x4C, 0x01, 0x49, 0xCA, 0xF3, 0x98, 0x22, 0xD2, 0xBA,
 0x34, 0x22, 0x3C, 0x53, 0xAB, 0xAA, 0xB4, 0x9A, 0x98, 0x1B, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0xBC, 0xD0, 0x2A, 0x2A, 0x3C, 0x4C, 0x4E, 0x23,
 0xD2, 0xBB, 0xDB, 0x55, 0x88, 0xAA, 0xC0, 0x2C, 0xB5, 0x23, 0xAD, 0x4A,
 0x5E, 0xAD, 0xB5, 0x2B, 0x2E, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xA2, 0x52, 0xA1, 0xA3, 0x1A, 0x32, 0xAA, 0x4A, 0xAF, 0x3B,
 0xF4, 0x9F, 0x3A, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Japan 600R+1uF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_JP[] =
{
  /* AC Profile */
 0xDA, 0x00, 0x5B, 0x4C, 0x01, 0x49, 0xCA, 0xF7, 0x98, 0xCA, 0x4D, 0xCD,
 0x2C, 0x45, 0x36, 0x23, 0x44, 0x3A, 0xCC, 0x9A, 0xC2, 0x61, 0xA3, 0xA2,
 0xC0, 0x8A, 0x7B, 0xA0, 0x5A, 0xA0, 0x23, 0xBB, 0x26, 0x23, 0x3A, 0x4B,
 0x5A, 0x24, 0xAA, 0xBD, 0x88, 0xAA, 0x20, 0x4A, 0xCA, 0x34, 0xA1, 0x34,
 0xA9, 0x3B, 0xB2, 0xAA, 0xAB, 0x82, 0x29, 0x71, 0x80, 0x22, 0xF0, 0x50,
 0x00, 0x86, 0xF2, 0x62, 0xA1, 0x36, 0x12, 0xA2, 0x24, 0x4A, 0x34, 0x5F,
 0x4C, 0x64, 0xB3, 0x40, 0x96, 0x2A, 0xC0, 0x00
};

/* AC FXS RF14 Netherlands 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_NL[] =
{
  /* AC Profile */
 0x7D, 0x00, 0x38, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x22, 0xBA, 0xA6, 0x9F,
 0x01, 0x8A, 0x34, 0xD0, 0xCD, 0xA0, 0xAB, 0xD3, 0x22, 0xAB, 0x4A, 0xA3,
 0xA2, 0x2C, 0xAB, 0x45, 0x88, 0x2A, 0x20, 0x6C, 0xBC, 0xCE, 0xA6, 0x2B,
 0xA5, 0xAA, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x62, 0x52, 0x22, 0xCD, 0x12, 0x23, 0x44, 0x7A, 0x87, 0x3B,
 0xFC, 0xBF, 0xBA, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Norway 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_NO[] =
{
  /* AC Profile */
 0x04, 0x00, 0xA8, 0x4C, 0x01, 0x49, 0xCA, 0xE4, 0x98, 0xAA, 0x41, 0x22,
 0xA1, 0xAA, 0x3B, 0x23, 0x2A, 0xD4, 0x23, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0xEA, 0x10, 0x22, 0xB8, 0x22, 0x3B, 0x23, 0xA1,
 0xAA, 0xBA, 0x32, 0xC4, 0x88, 0x25, 0xB0, 0x3B, 0x24, 0x2C, 0x2D, 0xA3,
 0xAC, 0xF4, 0xC4, 0xAB, 0xAD, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xBB, 0x52, 0xE2, 0xBD, 0x1B, 0xA1, 0x3B, 0x2A, 0xA3, 0x3A,
 0x4A, 0x26, 0x29, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 New Zealand 370R+620R//310nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_NZ[] =
{
  /* AC Profile */
 0xFF, 0x00, 0x0D, 0x4C, 0x01, 0x49, 0xCA, 0xFA, 0x98, 0xAB, 0x2A, 0xAB,
 0x22, 0x22, 0xA1, 0xD2, 0xB4, 0x4B, 0xBB, 0x9A, 0x2A, 0xB3, 0x46, 0x1F,
 0x01, 0x8A, 0x1D, 0x01, 0xBA, 0xD0, 0xA3, 0x4B, 0xBC, 0x3A, 0x3A, 0xAC,
 0x2C, 0xB6, 0x2B, 0xAE, 0x88, 0x4C, 0xC0, 0xCB, 0xA3, 0xAA, 0x2B, 0x2A,
 0xA3, 0x3A, 0x2C, 0x98, 0x15, 0x82, 0x29, 0xF1, 0x80, 0xCA, 0xF0, 0x50,
 0x00, 0x86, 0xB2, 0x5C, 0x22, 0x5C, 0x12, 0x42, 0xBA, 0x2B, 0xD3, 0x2A,
 0x36, 0xC4, 0x42, 0x50, 0x96, 0xD2, 0xA0, 0x00
};

/* AC FXS RF14 Portugal 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_PT[] =
{
  /* AC Profile */
 0xD5, 0x00, 0xEC, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x4A, 0xA1, 0x34,
 0xA2, 0xA2, 0xAC, 0x2C, 0xBB, 0x2B, 0xA4, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2B, 0x20, 0x8F, 0x39, 0x2A, 0xBB, 0xA4, 0x24,
 0xB2, 0xBC, 0x4B, 0x26, 0x88, 0xA3, 0xC0, 0xC2, 0x27, 0xBA, 0x3E, 0xAC,
 0xAF, 0xB4, 0x26, 0x24, 0x3F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5F, 0x32, 0x98, 0x03, 0xA1, 0xAA, 0x23, 0xB3, 0x2C,
 0x4B, 0x55, 0x25, 0x60, 0x96, 0xF2, 0xC1, 0x00
};

/* AC FXS RF14 Russia 150R+510R//47nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_RU[] =
{
  /* AC Profile */
 0x00, 0x00, 0x70, 0x4C, 0x01, 0x49, 0xCA, 0xED, 0x98, 0x98, 0x13, 0xB3,
 0xA4, 0xAB, 0xAC, 0xBB, 0xEC, 0x2B, 0x25, 0x9A, 0x3E, 0xAA, 0xA7, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0xA8, 0x70, 0x2C, 0x2A, 0x7A, 0xC3, 0x23, 0x2D,
 0x22, 0xA6, 0xAB, 0x87, 0x88, 0x65, 0x40, 0xBC, 0xB6, 0x22, 0xAD, 0x2A,
 0xAF, 0x22, 0xA5, 0x32, 0xBE, 0x82, 0xF8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xE3, 0x5A, 0x22, 0xAC, 0x14, 0xB2, 0x34, 0x53, 0xAF, 0xDA,
 0xFA, 0x9F, 0xA9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Sweden 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_SE[] =
{
  /* AC Profile */
 0x0E, 0x00, 0x42, 0x4C, 0x01, 0x49, 0xCA, 0xF0, 0x98, 0x24, 0xF1, 0xB4,
 0xA2, 0xAB, 0x4B, 0x4B, 0xAA, 0xA7, 0xC3, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2D, 0x01, 0xB3, 0x20, 0x5B, 0xB8, 0x24, 0xA2, 0x3C, 0xAC,
 0xAA, 0x27, 0x32, 0x9F, 0x88, 0x3A, 0xA0, 0x3A, 0x25, 0x3A, 0xAD, 0x22,
 0xAD, 0xBE, 0x25, 0xA5, 0x2E, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x73, 0x52, 0x22, 0xD2, 0x12, 0xB1, 0x4A, 0x23, 0xC4, 0xC3,
 0x6A, 0x97, 0xA8, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Turkey 270R+750R//150nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_TK[] =
{
  /* AC Profile */
 0xD5, 0x00, 0xEC, 0x4C, 0x01, 0x49, 0xCA, 0xE8, 0x98, 0x4A, 0xA1, 0x34,
 0xA2, 0xA2, 0xAC, 0x2C, 0xBB, 0x2B, 0xA4, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x9C, 0xD0, 0x2B, 0x20, 0x8F, 0x39, 0x2A, 0xBB, 0xA4, 0x24,
 0xB2, 0xBC, 0x4B, 0x26, 0x88, 0xA3, 0xC0, 0xC2, 0x27, 0xBA, 0x3E, 0xAC,
 0xAF, 0xB4, 0x26, 0x24, 0x3F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xC3, 0x5F, 0x32, 0x98, 0x03, 0xA1, 0xAA, 0x23, 0xB3, 0x2C,
 0x4B, 0x55, 0x25, 0x60, 0x96, 0xF2, 0xC1, 0x00
};

/* AC FXS RF14 South Africa 220R+820R//115nF Normal Coefficients */
const VpProfileDataType AC_FXS_RF14_ZA[] =
{
  /* AC Profile */
 0x6D, 0x00, 0xA7, 0x4C, 0x01, 0x49, 0xCA, 0xEA, 0x98, 0xFA, 0xE1, 0x23,
 0xA2, 0xEA, 0xCB, 0xB3, 0xAA, 0xA3, 0xB3, 0x9A, 0x98, 0x92, 0x97, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0xB3, 0x20, 0xAB, 0xA8, 0xCC, 0x24, 0x22, 0x97,
 0xAF, 0x8F, 0xD3, 0xBF, 0x88, 0x3B, 0xB0, 0x33, 0x46, 0x2A, 0x2E, 0x33,
 0x4F, 0xAE, 0xA5, 0xB3, 0xBE, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0x22, 0x98, 0x02, 0x42, 0xA2, 0x43, 0xA6, 0xD8,
 0xFA, 0x8F, 0x29, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 600R Wideband Coefficients (Default)  */
const VpProfileDataType AC_FXS_RF14_WB_600R_DEF[] =
{
  /* AC Profile */
 0xED, 0x00, 0xA9, 0x4C, 0x01, 0x49, 0xCA, 0xFC, 0x98, 0xCC, 0x2A, 0xA2,
 0x3B, 0x98, 0xB3, 0x43, 0xA2, 0x3A, 0xAB, 0x9A, 0x2D, 0xAA, 0xB6, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0xC4, 0xA0, 0x2E, 0x23, 0x3A, 0x2E, 0x9F, 0x87,
 0x4C, 0xCE, 0xB2, 0x27, 0x88, 0x4A, 0x20, 0xBA, 0xAC, 0x22, 0xB5, 0x5A,
 0xB5, 0x3B, 0x4D, 0xA2, 0x27, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xCB, 0x5E, 0x22, 0xBC, 0x12, 0xA3, 0xA9, 0xFA, 0xC6, 0x34,
 0xE2, 0x9F, 0xBA, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 ETSI ES201 970 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_ETSI[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Telcordia GR-57 900R+2.16uF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_GR57[] =
{
  /* AC Profile */
 0x1D, 0x00, 0x10, 0x4C, 0x01, 0x49, 0xCA, 0x0B, 0x98, 0xC2, 0xBB, 0x2A,
 0x2B, 0x2B, 0x8F, 0x6A, 0xB3, 0x2A, 0xA7, 0x9A, 0x7B, 0xA2, 0x36, 0x6E,
 0x01, 0x8A, 0x2D, 0xD0, 0x2C, 0xA0, 0x2B, 0xAA, 0x2C, 0x62, 0x22, 0xAA,
 0xBC, 0xA4, 0x23, 0xAE, 0x88, 0xA2, 0x30, 0xAD, 0xC9, 0x2C, 0x41, 0xB3,
 0xA9, 0xB2, 0x53, 0xAB, 0x3D, 0x82, 0xB8, 0x71, 0x80, 0x7A, 0xF0, 0x50,
 0x00, 0x86, 0x2B, 0x55, 0xB1, 0x3A, 0x0A, 0xA2, 0x98, 0xCA, 0xA4, 0xAA,
 0x5A, 0x87, 0x6A, 0x60, 0x96, 0x1E, 0x01, 0x00
};

/* AC FXS RF14 Austria 220R+820R//115nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_AT[] =
{
  /* AC Profile */
 0x30, 0x00, 0xC0, 0x4C, 0x01, 0x49, 0xCA, 0xDB, 0x98, 0xBA, 0xA1, 0xBA,
 0x22, 0x2A, 0xF4, 0xAA, 0xAB, 0x22, 0x65, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x01, 0x11, 0xA3, 0x10, 0x2B, 0x29, 0x53, 0xB9, 0xBD, 0xB3,
 0x7B, 0xCC, 0xDB, 0xA6, 0x88, 0x2A, 0xB0, 0x2B, 0x9F, 0x2E, 0x3E, 0x22,
 0xBE, 0xC3, 0x26, 0x35, 0x2F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2B, 0x53, 0x52, 0x4B, 0x12, 0x52, 0xDF, 0x32, 0xB4, 0x3A,
 0x5A, 0xA7, 0xB9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Australia 220R+820R//120nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_AU[] =
{
  /* AC Profile */
 0xC2, 0x00, 0x2E, 0x4C, 0x01, 0x49, 0xCA, 0xF0, 0x98, 0xBA, 0xA1, 0xAD,
 0xA3, 0xA2, 0x2C, 0x2D, 0xAB, 0x22, 0xD4, 0x9A, 0xCC, 0xA2, 0x97, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0x7A, 0x10, 0xBA, 0x29, 0x2A, 0x3A, 0xA2, 0x32,
 0xB2, 0xAA, 0xF2, 0xA4, 0x88, 0xBA, 0xA0, 0x5C, 0x3F, 0x2C, 0xCE, 0xAA,
 0x87, 0xC2, 0x66, 0xDB, 0x7E, 0x82, 0xA8, 0x71, 0x80, 0x39, 0x70, 0x50,
 0x00, 0x86, 0xAA, 0x59, 0x81, 0x25, 0x1A, 0xA1, 0xBB, 0x2B, 0xB3, 0x2C,
 0x46, 0xD5, 0xBC, 0x60, 0x96, 0xAA, 0xB1, 0x00
};

/* AC FXS RF14 Belgium 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_BE[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Bulgaria 220R+820R//115nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_BG[] =
{
  /* AC Profile */
 0x30, 0x00, 0xC0, 0x4C, 0x01, 0x49, 0xCA, 0xDB, 0x98, 0xBA, 0xA1, 0xBA,
 0x22, 0x2A, 0xF4, 0xAA, 0xAB, 0x22, 0x65, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x01, 0x11, 0xA3, 0x10, 0x2B, 0x29, 0x53, 0xB9, 0xBD, 0xB3,
 0x7B, 0xCC, 0xDB, 0xA6, 0x88, 0x2A, 0xB0, 0x2B, 0x9F, 0x2E, 0x3E, 0x22,
 0xBE, 0xC3, 0x26, 0x35, 0x2F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2B, 0x53, 0x52, 0x4B, 0x12, 0x52, 0xDF, 0x32, 0xB4, 0x3A,
 0x5A, 0xA7, 0xB9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Brazil 900R Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_BR[] =
{
  /* AC Profile */
 0xF3, 0x00, 0x33, 0x4C, 0x01, 0x49, 0xCA, 0x0B, 0x98, 0xAA, 0xAB, 0xAC,
 0xAA, 0x42, 0xAD, 0xB8, 0xF3, 0x34, 0xA5, 0x9A, 0xAC, 0xAA, 0xC7, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0xAA, 0xA0, 0xCB, 0xDA, 0xAB, 0x22, 0xBC, 0xAA,
 0x3B, 0xA4, 0x42, 0x2F, 0x88, 0xAA, 0x40, 0x4A, 0x4A, 0xB3, 0x22, 0x3D,
 0x2B, 0xB2, 0xAF, 0x4A, 0x37, 0x82, 0xA9, 0xF1, 0x80, 0xB9, 0xF0, 0x50,
 0x00, 0x86, 0x2F, 0x5A, 0xA1, 0x3A, 0x03, 0xA2, 0xA3, 0xCC, 0x25, 0x3A,
 0x54, 0x3E, 0xCB, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Switzerland 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_CH[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 China 200R+680R//100nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_CN[] =
{
  /* AC Profile */
 0xEF, 0x00, 0x46, 0x4C, 0x01, 0x49, 0xCA, 0xDA, 0x98, 0xB3, 0xB1, 0x23,
 0x32, 0x64, 0x97, 0xAA, 0x2B, 0x4A, 0xA4, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xCD, 0x10, 0x2B, 0x29, 0x22, 0x2A, 0xA2, 0x33,
 0x4B, 0x4C, 0xBD, 0xF6, 0x88, 0x2A, 0xC0, 0x52, 0x97, 0xF2, 0x2E, 0xAA,
 0x4E, 0xAC, 0xB5, 0x5B, 0xBE, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x5A, 0xA2, 0xBA, 0x1B, 0x22, 0xCA, 0x24, 0xC3, 0x43,
 0x42, 0xA4, 0x4B, 0x50, 0x96, 0x3C, 0x41, 0x00
};

/* AC FXS RF14 Germany 220R+820R//115nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_DE[] =
{
  /* AC Profile */
 0x27, 0x00, 0xD7, 0x4C, 0x01, 0x49, 0xCA, 0xDB, 0x98, 0xBA, 0xA1, 0xBA,
 0x22, 0x2A, 0xF4, 0xAA, 0xAB, 0x22, 0x65, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xA3, 0x10, 0x2B, 0x29, 0x53, 0xB9, 0xBD, 0xB3,
 0x7B, 0xCC, 0xDB, 0xA6, 0x88, 0x2A, 0xB0, 0x2B, 0x9F, 0x2E, 0x3E, 0x22,
 0xBE, 0xC3, 0x26, 0x35, 0x2F, 0x82, 0xB8, 0x71, 0x80, 0xAB, 0xF0, 0x50,
 0x00, 0x86, 0xCA, 0x5A, 0xA2, 0xBA, 0x1F, 0x22, 0x3B, 0x2A, 0x23, 0x2B,
 0x3A, 0x24, 0x4B, 0x40, 0x96, 0x22, 0x21, 0x00
};

/* AC FXS RF14 Denmark 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_DK[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Spain 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_ES[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Finland 270R+910R//120nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_FI[] =
{
  /* AC Profile */
 0xF1, 0x00, 0xB1, 0x4C, 0x01, 0x49, 0xCA, 0xE5, 0x98, 0x2E, 0x52, 0x2A,
 0xB2, 0xBA, 0xB3, 0xA2, 0xAE, 0x22, 0x37, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x01, 0x11, 0x2B, 0x10, 0xA3, 0xB9, 0xA2, 0xC9, 0xAA, 0xB4,
 0x3A, 0xBC, 0x22, 0x37, 0x88, 0xEC, 0xB0, 0xB3, 0x2E, 0xE2, 0x3F, 0xAA,
 0x8F, 0x25, 0x97, 0xDB, 0xAF, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x7A, 0x5A, 0xB2, 0x3B, 0x12, 0xA1, 0xAC, 0x24, 0xA2, 0x73,
 0x32, 0xB3, 0x22, 0x40, 0x96, 0x24, 0xA0, 0x00
};

/* AC FXS RF14 France 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_FR[] =
{
  /* AC Profile */
 0x98, 0x00, 0x26, 0x4C, 0x01, 0x49, 0xCA, 0xD7, 0x98, 0x4F, 0x22, 0xB5,
 0xB1, 0xC6, 0x23, 0x3A, 0xAB, 0x24, 0xB5, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x01, 0x11, 0x22, 0x10, 0x3A, 0x29, 0x3C, 0x29, 0x32, 0xB3,
 0x4A, 0x2C, 0x2E, 0xB6, 0x88, 0xAC, 0xB0, 0x43, 0x37, 0xAB, 0x3E, 0xB4,
 0x3E, 0x22, 0x37, 0x22, 0xAF, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0xAA, 0x52, 0xE2, 0x2B, 0x12, 0x62, 0x63, 0x3A, 0x24, 0xA2,
 0x5C, 0x36, 0x39, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 UK 370R+620R//310nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_GB[] =
{
  /* AC Profile */
 0xDB, 0x00, 0x85, 0x4C, 0x01, 0x49, 0xCA, 0xE6, 0x98, 0x2B, 0x2A, 0x3B,
 0xD1, 0xB4, 0x22, 0x23, 0x6C, 0xA6, 0x43, 0x9A, 0xBA, 0x23, 0x25, 0x2D,
 0x01, 0x8A, 0x32, 0xC0, 0x2A, 0x10, 0xA5, 0x4A, 0x62, 0xBA, 0xA6, 0xA9,
 0xAA, 0xC3, 0xA2, 0xAB, 0x88, 0x32, 0xC0, 0x3D, 0xB3, 0xA3, 0xBA, 0x53,
 0xC2, 0xAA, 0xAA, 0xC4, 0xA3, 0x82, 0xE8, 0x71, 0x80, 0xAA, 0xF0, 0x50,
 0x00, 0x86, 0x3A, 0x5B, 0xC2, 0xFA, 0x12, 0xB2, 0xE2, 0x33, 0xE3, 0xBA,
 0x33, 0x24, 0xA4, 0x40, 0x96, 0x23, 0xB0, 0x00
};

/* AC FXS RF14 Greece 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_GR[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Hungary 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_HU[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Ireland 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_IE[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Israel 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_IL[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Iceland 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_IS[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Italy 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_IT[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Japan 600R+1uF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_JP[] =
{
  /* AC Profile */
 0x83, 0x00, 0xF8, 0x4C, 0x01, 0x49, 0xCA, 0xFF, 0x98, 0xAB, 0x3A, 0x35,
 0x2C, 0xA2, 0x43, 0xAA, 0x23, 0x26, 0xAB, 0x9A, 0xAA, 0xA2, 0x24, 0x1D,
 0x01, 0x8A, 0xAA, 0xB0, 0xA3, 0xA0, 0x22, 0xA3, 0x2A, 0xCE, 0x2A, 0xBD,
 0x62, 0xA5, 0x54, 0xBE, 0x88, 0x23, 0x30, 0x2E, 0xAC, 0xB2, 0xA6, 0xBA,
 0x26, 0xA2, 0xED, 0x22, 0x27, 0x82, 0xAA, 0x61, 0x80, 0x2A, 0x60, 0x50,
 0x00, 0x86, 0x23, 0x62, 0x22, 0x98, 0x0C, 0x43, 0x2A, 0x44, 0xA4, 0xBD,
 0x62, 0xB5, 0x4F, 0x50, 0x96, 0xBC, 0x01, 0x00
};

/* AC FXS RF14 Netherlands 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_NL[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Norway 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_NO[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 New Zealand 370R+620R//310nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_NZ[] =
{
  /* AC Profile */
 0x11, 0x00, 0xE2, 0x4C, 0x01, 0x49, 0xCA, 0xF2, 0x98, 0x5A, 0x29, 0xCB,
 0xA1, 0xA3, 0xA1, 0xB4, 0x3D, 0x22, 0x24, 0x9A, 0x22, 0xA2, 0xE5, 0x2E,
 0x01, 0x8A, 0x3A, 0xB0, 0xDA, 0x30, 0xBD, 0xAB, 0x42, 0xAF, 0xCA, 0xA9,
 0x32, 0x23, 0xBA, 0xAB, 0x88, 0x2A, 0xB0, 0xAD, 0x42, 0x4C, 0xA9, 0xA6,
 0xA1, 0x2A, 0x2A, 0xA2, 0x43, 0x82, 0x23, 0x71, 0x80, 0x4A, 0x60, 0x50,
 0x00, 0x86, 0xCA, 0x59, 0x81, 0xBA, 0x12, 0xA2, 0x44, 0x3B, 0xA3, 0x23,
 0x4A, 0xC4, 0x3A, 0x40, 0x96, 0x22, 0xB0, 0x00
};

/* AC FXS RF14 Portugal 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_PT[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Russia 150R+510R//47nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_RU[] =
{
  /* AC Profile */
 0x2E, 0x00, 0x60, 0x4C, 0x01, 0x49, 0xCA, 0xE6, 0x98, 0x2D, 0xC2, 0x62,
 0x43, 0xA2, 0xBC, 0x24, 0xEB, 0xBA, 0xB4, 0x9A, 0x24, 0xB5, 0x97, 0x9F,
 0x01, 0x8A, 0x2E, 0x01, 0x2C, 0x30, 0x62, 0x3A, 0x22, 0x2B, 0x3B, 0xA2,
 0xA2, 0xCB, 0x2A, 0xE5, 0x88, 0xDA, 0x40, 0xBA, 0x35, 0x24, 0xDD, 0x4A,
 0xAD, 0xD4, 0xA4, 0xAF, 0xAD, 0x82, 0xA8, 0x71, 0x80, 0xB9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x5A, 0xB2, 0x3B, 0x1A, 0x32, 0x2A, 0x32, 0xA5, 0xA8,
 0x72, 0x9F, 0x29, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/* AC FXS RF14 Sweden 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_SE[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 Turkey 270R+750R//150nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_TK[] =
{
  /* AC Profile */
 0xAA, 0x00, 0x9C, 0x4C, 0x01, 0x49, 0xCA, 0xE0, 0x98, 0xAA, 0xA3, 0x6B,
 0x22, 0x43, 0xA2, 0xAC, 0xBF, 0x22, 0xA6, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xBA, 0x10, 0xA2, 0x3A, 0xBA, 0xE9, 0xAA, 0xB5,
 0x2A, 0xBC, 0xAF, 0x97, 0x88, 0xAB, 0xC0, 0x4A, 0xBE, 0xBA, 0x9F, 0xC3,
 0xAF, 0x3A, 0x3F, 0xCD, 0xA7, 0x82, 0xC8, 0x71, 0x80, 0x69, 0xF0, 0x50,
 0x00, 0x86, 0xBA, 0x52, 0xB2, 0xBA, 0x12, 0x42, 0x4A, 0x2A, 0x33, 0xBA,
 0x33, 0x34, 0x4B, 0x40, 0x96, 0xB2, 0xA0, 0x00
};

/* AC FXS RF14 South Africa 220R+820R//115nF Wideband Coefficients */
const VpProfileDataType AC_FXS_RF14_WB_ZA[] =
{
  /* AC Profile */
 0x27, 0x00, 0xD7, 0x4C, 0x01, 0x49, 0xCA, 0xDB, 0x98, 0xBA, 0xA1, 0xBA,
 0x22, 0x2A, 0xF4, 0xAA, 0xAB, 0x22, 0x65, 0x9A, 0x01, 0x90, 0x01, 0x01,
 0x90, 0x8A, 0x2E, 0x01, 0xA3, 0x10, 0x2B, 0x29, 0x53, 0xB9, 0xBD, 0xB3,
 0x7B, 0xCC, 0xDB, 0xA6, 0x88, 0x2A, 0xB0, 0x2B, 0x9F, 0x2E, 0x3E, 0x22,
 0xBE, 0xC3, 0x26, 0x35, 0x2F, 0x82, 0xB8, 0x71, 0x80, 0xAB, 0xF0, 0x50,
 0x00, 0x86, 0xCA, 0x5A, 0xA2, 0xBA, 0x1F, 0x22, 0x3B, 0x2A, 0x23, 0x2B,
 0x3A, 0x24, 0x4B, 0x40, 0x96, 0x22, 0x21, 0x00
};

/************** Ring_Parameters **************/

/* Default Ringing 25Hz 50Vrms Fixed, AC Trip - Use for all countries unless country profile exists */
const VpProfileDataType RING_ZL880_ABS100V_DEF[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x08, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x44, 0x3A, /* 24.9 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 1; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/* Austria Ringing 50Hz 50Vrms Fixed, AC Trip */
const VpProfileDataType RING_ZL880_ABS100V_AT[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x00, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x89, 0x3A, /* 50.2 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 2; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/* Canada Ringing 20Hz 50Vrms Fixed, AC Trip */
const VpProfileDataType RING_ZL880_ABS100V_CA[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x00, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x37, 0x3A, /* 20.1 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 2; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/* Finland Ringing 50Hz 50Vrms Fixed, AC Trip */
const VpProfileDataType RING_ZL880_ABS100V_FI[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x00, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x89, 0x3A, /* 50.2 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 2; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/* France Ringing 50Hz 50Vrms Fixed, AC Trip */
const VpProfileDataType RING_ZL880_ABS100V_FR[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x00, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x89, 0x3A, /* 50.2 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 2; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/* Hong Kong Ringing 20Hz 50Vrms Fixed, AC Trip */
const VpProfileDataType RING_ZL880_ABS100V_HK[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x00, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x37, 0x3A, /* 20.1 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 2; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/* Japan Ringing 16Hz 50Vrms Fixed, AC Trip */
const VpProfileDataType RING_ZL880_ABS100V_JP[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x08, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x2C, 0x3A, /* 16.1 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 1; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/* Korea Ringing 20Hz 50Vrms Fixed, AC Trip */
const VpProfileDataType RING_ZL880_ABS100V_KR[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x00, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x37, 0x3A, /* 20.1 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 2; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/* Singapore Ringing 24Hz 50Vrms Fixed, AC Trip */
const VpProfileDataType RING_ZL880_ABS100V_SG[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x08, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x42, 0x3A, /* 24.2 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 1; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/* Taiwan Ringing 20Hz 50Vrms Fixed, AC Trip */
const VpProfileDataType RING_ZL880_ABS100V_TW[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x00, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x37, 0x3A, /* 20.1 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 2; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/* USA Ringing 20Hz 50Vrms Fixed, AC Trip */
const VpProfileDataType RING_ZL880_ABS100V_US[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x00, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x37, 0x3A, /* 20.1 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 2; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/************** Call_Progress_Tones **************/

/************** Cadence_Definitions **************/
/* Short Ringing Cadence (2 sec on 4 sec off) */
const VpProfileDataType LE880_RING_CAD_STD[] =
{
  /* Cadence Profile */
 0x00, 0x08, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x07, 0x21, 0x90,
 0x01, 0x05, 0x23, 0x20, 0x40, 0x00
};

/* Short Ringing Cadence (0.5 sec on 0.5 sec off) */
const VpProfileDataType LE880_RING_CAD_SHORT[] =
{
  /* Cadence Profile */
 0x00, 0x08, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x07, 0x20, 0x64,
 0x01, 0x05, 0x20, 0x64, 0x40, 0x00
};

/* Short Ringing Cadence (2 sec on 4 sec off) */
const VpProfileDataType LE886_RING_CAD_STD[] =
{
  /* Cadence Profile */
 0x00, 0x08, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x07, 0x21, 0x90,
 0x01, 0x05, 0x23, 0x20, 0x40, 0x00
};

/* Short Ringing Cadence (0.5 sec on 0.5 sec off) */
const VpProfileDataType LE886_RING_CAD_SHORT[] =
{
  /* Cadence Profile */
 0x00, 0x08, 0x01, 0x0E, 0x00, 0x00, 0x00, 0x0A, 0x01, 0x07, 0x20, 0x64,
 0x01, 0x05, 0x20, 0x64, 0x40, 0x00
};
/************** Caller_ID **************/

/************** Metering_Profile **************/
/* Metering, 12kHz 0.5Vrms */
const VpProfileDataType METER_12KHZ_RF14[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0D, 0x07, 0x00,       /* Metering Profile for Le9662_A device */
   0x08,                   /* Profile length = 8 + 4 = 12 bytes */
   0x00,                   /* Profile format version = 0 */
   0x05,                   /* MPI section length = 5 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xD0, 0x21,             /* MTRF = 12 kHz; MLIM = 511.5/723.4 mV RMS/peak */
         0x2E,             /* SOREV = Smooth; MTRSL = 3.128/4.424 mA RMS/peak */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0x00                    /* Reserved */
};

/* Metering, 16kHz 0.5Vrms */
const VpProfileDataType METER_16KHZ_RF14[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0D, 0x07, 0x00,       /* Metering Profile for Le9662_A device */
   0x08,                   /* Profile length = 8 + 4 = 12 bytes */
   0x00,                   /* Profile format version = 0 */
   0x05,                   /* MPI section length = 5 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xD0, 0x9C,             /* MTRF = 16 kHz; MLIM = 515.2/728.6 mV RMS/peak */
         0x31,             /* SOREV = Smooth; MTRSL = 3.332/4.712 mA RMS/peak */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0x00                    /* Reserved */
};

/* end of file Realtek_88601.c */
