#ifndef __VOIP_MGR_DO_DSP_H__
#define __VOIP_MGR_DO_DSP_H__

#define M_EXTERN_DSP( x )	extern int do_mgr_ ## x ( int cmd, void *user, unsigned int len, unsigned short seq_no );

// DSP - General  
//! @addtogroup VOIP_DSP_GENERAL
//! @ingroup VOIP_CONTROL
M_EXTERN_DSP( VOIP_MGR_ON_HOOK_RE_INIT );
M_EXTERN_DSP( VOIP_MGR_SET_VOICE_GAIN );
M_EXTERN_DSP( VOIP_MGR_ENERGY_DETECT );
M_EXTERN_DSP( VOIP_MGR_GET_VOIP_EVENT );
M_EXTERN_DSP( VOIP_MGR_FLUSH_VOIP_EVENT );
M_EXTERN_DSP( VOIP_MGR_SET_RTP_PT_CHECKER );

// DSP - Codec 
//! @addtogroup VOIP_DSP_CODEC
//! @ingroup VOIP_CONTROL
M_EXTERN_DSP( VOIP_MGR_SETRTPPAYLOADTYPE ); 
M_EXTERN_DSP( VOIP_MGR_DSPCODECSTOP );	
M_EXTERN_DSP( VOIP_MGR_SET_VAD_CNG_THRESHOLD );

// DSP - FAX and Modem  
//! @addtogroup VOIP_DSP_FAXMODEM
//! @ingroup VOIP_CONTROL
M_EXTERN_DSP( VOIP_MGR_FAX_OFFHOOK ); 
M_EXTERN_DSP( VOIP_MGR_FAX_END_DETECT ); 
M_EXTERN_DSP( VOIP_MGR_SET_FAX_MODEM_DET ); 
M_EXTERN_DSP( VOIP_MGR_FAX_DIS_DETECT );
M_EXTERN_DSP( VOIP_MGR_FAX_DIS_TX_DETECT );
M_EXTERN_DSP( VOIP_MGR_FAX_DIS_RX_DETECT );
M_EXTERN_DSP( VOIP_MGR_FAX_DCN_DETECT );
M_EXTERN_DSP( VOIP_MGR_FAX_DCN_TX_DETECT );
M_EXTERN_DSP( VOIP_MGR_FAX_DCN_RX_DETECT );
M_EXTERN_DSP( VOIP_MGR_SET_ANSWERTONE_DET );
M_EXTERN_DSP( VOIP_MGR_SET_FAX_SILENCE_DET );

// DSP - LEC  
//! @addtogroup VOIP_DSP_LEC
//! @ingroup VOIP_CONTROL
M_EXTERN_DSP( VOIP_MGR_SET_ECHO_TAIL_LENGTH ); 
M_EXTERN_DSP( VOIP_MGR_SET_G168_LEC_CFG );
M_EXTERN_DSP( VOIP_MGR_SET_VBD_EC ); 
M_EXTERN_DSP( VOIP_MGR_GET_EC_DEBUG );

// DSP - DTMF  
//! @addtogroup VOIP_DSP_DTMF
//! @ingroup VOIP_CONTROL
M_EXTERN_DSP( VOIP_MGR_DTMF_DET_PARAM );  
M_EXTERN_DSP( VOIP_MGR_DTMF_CFG );  
M_EXTERN_DSP( VOIP_MGR_SET_DTMF_MODE ); 
M_EXTERN_DSP( VOIP_MGR_SEND_RFC2833_PKT_CFG ); 
M_EXTERN_DSP( VOIP_MGR_SEND_RFC2833_BY_AP ); 
M_EXTERN_DSP( VOIP_MGR_PLAY_SIP_INFO ); 
M_EXTERN_DSP( VOIP_MGR_LIMIT_MAX_RFC2833_DTMF_DURATION );
M_EXTERN_DSP( VOIP_MGR_FAX_MODEM_RFC2833_CFG );
M_EXTERN_DSP( VOIP_MGR_RFC2833_PKT_INTERVAL_CFG );
M_EXTERN_DSP( VOIP_MGR_SET_RFC2833_TX_VOLUME );


// DSP - Caller ID  
//! @addtogroup VOIP_DSP_CALLERID
//! @ingroup VOIP_CONTROL
M_EXTERN_DSP( VOIP_MGR_DTMF_CID_GEN_CFG );  
M_EXTERN_DSP( VOIP_MGR_GET_CID_STATE_CFG );  
M_EXTERN_DSP( VOIP_MGR_FSK_CID_GEN_CFG ); 
M_EXTERN_DSP( VOIP_MGR_SET_FSK_VMWI_STATE );  
M_EXTERN_DSP( VOIP_MGR_SET_FSK_AREA ); 
M_EXTERN_DSP( VOIP_MGR_FSK_ALERT_GEN_CFG ); 
M_EXTERN_DSP( VOIP_MGR_SET_CID_DTMF_MODE ); 
M_EXTERN_DSP( VOIP_MGR_SET_CID_DET_MODE );  
M_EXTERN_DSP( VOIP_MGR_GET_FSK_CID_STATE_CFG ); 
M_EXTERN_DSP( VOIP_MGR_SET_CID_FSK_GEN_MODE ); 
M_EXTERN_DSP( VOIP_MGR_FSK_CID_VMWI_GEN_CFG ); 
M_EXTERN_DSP( VOIP_MGR_SET_FSK_CLID_PARA );
M_EXTERN_DSP( VOIP_MGR_GET_FSK_CLID_PARA );
M_EXTERN_DSP( VOIP_MGR_FSK_CID_MDMF_GEN );
M_EXTERN_DSP( VOIP_MGR_STOP_CID );

// DSP - Tone  
//! @addtogroup VOIP_DSP_TONE
//! @ingroup VOIP_CONTROL
M_EXTERN_DSP( VOIP_MGR_SETPLAYTONE ); 
M_EXTERN_DSP( VOIP_MGR_SET_COUNTRY ); 
M_EXTERN_DSP( VOIP_MGR_SET_COUNTRY_IMPEDANCE ); 
M_EXTERN_DSP( VOIP_MGR_SET_COUNTRY_TONE ); 
M_EXTERN_DSP( VOIP_MGR_SET_TONE_OF_CUSTOMIZE );  
M_EXTERN_DSP( VOIP_MGR_SET_CUST_TONE_PARAM );  
M_EXTERN_DSP( VOIP_MGR_USE_CUST_TONE ); 
M_EXTERN_DSP( VOIP_MGR_SET_DIS_TONE_DET ); 
M_EXTERN_DSP( VOIP_MGR_SET_TONE_OF_UPDATE );  
M_EXTERN_DSP( VOIP_MGR_SET_UPDATE_TONE_PARAM );  

// DSP - AGC  
//! @addtogroup VOIP_DSP_AGC
//! @ingroup VOIP_CONTROL
M_EXTERN_DSP( VOIP_MGR_SET_SPK_AGC );  
M_EXTERN_DSP( VOIP_MGR_SET_SPK_AGC_LVL );  
M_EXTERN_DSP( VOIP_MGR_SET_SPK_AGC_GUP );  
M_EXTERN_DSP( VOIP_MGR_SET_SPK_AGC_GDOWN );  
M_EXTERN_DSP( VOIP_MGR_SET_MIC_AGC );  
M_EXTERN_DSP( VOIP_MGR_SET_MIC_AGC_LVL );  
M_EXTERN_DSP( VOIP_MGR_SET_MIC_AGC_GUP ); 
M_EXTERN_DSP( VOIP_MGR_SET_MIC_AGC_GDOWN );  

// DSP - Pluse Dial 
//! @addtogroup VOIP_DSP_PLUSEDIAL
//! @ingroup VOIP_CONTROL
//TH: for pulse dial config
M_EXTERN_DSP( VOIP_MGR_SET_PULSE_DIGIT_DET ); 
M_EXTERN_DSP( VOIP_MGR_SET_DIAL_MODE ); 
M_EXTERN_DSP( VOIP_MGR_GET_DIAL_MODE ); 
M_EXTERN_DSP( VOIP_MGR_PULSE_DIAL_GEN_CFG );  
M_EXTERN_DSP( VOIP_MGR_GEN_PULSE_DIAL ); 

// DSP - IVR  
//! @addtogroup VOIP_DSP_IVR
//! @ingroup VOIP_CONTROL
M_EXTERN_DSP( VOIP_MGR_PLAY_IVR ); 
M_EXTERN_DSP( VOIP_MGR_POLL_IVR );  
M_EXTERN_DSP( VOIP_MGR_STOP_IVR ); 

#undef M_EXTERN_DSP

#endif /* __VOIP_MGR_DO_DSP_H__ */

